
use Test;
use strict;
no warnings;
use Math::Business::SM::Stochastic;
use Math::Business::SMA;

my $number = 30*6;
plan tests => $number;

my $fsto = Math::Business::SM::Stochastic->method_fast(14,3);
my $ssto = Math::Business::SM::Stochastic->method_slow(14,3);
my $sful = Math::Business::SM::Stochastic->method_full(14,3,5);

my $K3  = Math::Business::SMA->new(3);
my $K33 = Math::Business::SMA->new(3);

my $K5  = Math::Business::SMA->new(5);
my $K55 = Math::Business::SMA->new(5);

while(<DATA>) {
    # data ripped from http://stockcharts.com/help/doku.php?id=chart_school:technical_indicators:stochastic_oscillato
    chomp;
    my ($line, $date, $high, $low, $highest, $lowest, $close, $theirK) = split m/,/;

    $fsto->insert( my $i = [$high,$low,$close] );
    $ssto->insert( $i );
    $sful->insert( $i );

    my ($D,$K) = $fsto->query;

    $K3->insert($K) if defined $K;
    my $k3 = $K3->query;

    $K33->insert($k3) if defined $k3;
    my $k33 = $K33->query;

    $K5->insert($K) if defined $K;
    my $k5 = $K5->query;

    $K55->insert($k5) if defined $k5;
    my $k55 = $K55->query;

    if( not defined $K and not $theirK ) {
        ok(1); 
        ok(2);

    } else {
        ok( 1 > abs($K - $theirK) );
        ok( 1 > abs($D - $k3) );
    }

    ($D,$K) = $ssto->query;
    if( not defined $K or not defined $D ) {
        ok(1);
        ok(2);

    } else {
        ok( 1 > abs($K - $k3) );
        ok( 1 > abs($D - $k33) );
    }

    ($D,$K) = $sful->query;
    if( not defined $K or not defined $D ) {
        ok(1);
        ok(2);

    } else {
        ok( 1 > abs($K - $k5) );
        ok( 1 > abs($D - $k55) );
    }
}

__DATA__
1,2010/02/23,127.009,125.3574,,,,
2,2010/02/24,127.6159,126.1633,,,,
3,2010/02/25,126.5911,124.9296,,,,
4,2010/02/26,127.3472,126.0937,,,,
5,2010/03/01,128.173,126.8199,,,,
6,2010/03/02,128.4317,126.4817,,,,
7,2010/03/03,127.3671,126.034,,,,
8,2010/03/04,126.422,124.8301,,,,
9,2010/03/05,126.8995,126.3921,,,,
10,2010/03/08,126.8498,125.7156,,,,
11,2010/03/09,125.646,124.5615,,,,
12,2010/03/10,125.7156,124.5715,,,,
13,2010/03/11,127.1582,125.0689,,,,
14,2010/03/12,127.7154,126.8597,128.4317,124.5615,127.2876,70.4382202470155
15,2010/03/15,127.6855,126.6309,128.4317,124.5615,127.1781,67.6089091003048
16,2010/03/16,128.2228,126.8001,128.4317,124.5615,128.0138,89.2021084181696
17,2010/03/17,128.2725,126.7105,128.4317,124.5615,127.1085,65.8105524262313
18,2010/03/18,128.0934,126.8001,128.4317,124.5615,127.7253,81.7477132964705
19,2010/03/19,128.2725,126.1335,128.4317,124.5615,127.0587,64.5237972197819
20,2010/03/22,127.7353,125.9245,128.2725,124.5615,127.3273,74.5297763406087
21,2010/03/23,128.77,126.9891,128.77,124.5615,128.7103,98.5814423191156
22,2010/03/24,129.2873,127.8148,129.2873,124.5615,127.8745,70.1045325659149
23,2010/03/25,130.0633,128.4715,130.0633,124.5615,128.5809,73.0560907339419
24,2010/03/26,129.1182,128.0641,130.0633,124.5615,128.6008,73.4177905412773
25,2010/03/29,129.2873,127.6059,130.0633,124.5715,127.9342,61.2312902873376
26,2010/03/30,128.4715,127.596,130.0633,125.0689,128.1133,60.9562710235466
27,2010/03/31,128.0934,126.999,130.0633,125.9245,127.596,40.3861022518606
28,2010/04/01,128.6506,126.8995,130.0633,125.9245,127.596,40.3861022518606
29,2010/04/05,129.1381,127.4865,130.0633,125.9245,128.6904,66.8285493379727
30,2010/04/06,128.6406,127.397,130.0633,125.9245,128.2725,56.7314197351892
