package Irssi::Log::Log4perl;
use strict;
use warnings;
use experimental 'signatures';

use Log::Log4perl::Level;

our $global_log_level = $DEBUG;

sub get_logger ($cls, $logger_cls) {
    bless +{ class => $logger_cls } => __PACKAGE__
}

sub is_trace { undef }
sub is_debug ($self) { ($self->{log_level} // $global_log_level) <= $DEBUG }
sub is_info ($self) { ($self->{log_level} // $global_log_level) <= $INFO }
sub is_warn ($self) { ($self->{log_level} // $global_log_level) <= $WARN }
sub is_error ($self) { ($self->{log_level} // $global_log_level) <= $ERROR }
sub is_fatal { 1 }

sub level ($self, $level = undef) {
    if (ref $self) {
	my $old = $self->{log_level};
	$self->{log_level} = $level
	    if defined $level;
	return $old // $global_log_level;
    } else {
	my $old = $global_log_level;
	$global_log_level = $level
	    if defined $level;
	return $global_log_level;
    }
}

sub trace { undef }
sub debug ($self, @message) { return unless $self->is_debug;
			      $self->print('DEBUG', @message); }
sub info ($self, @message) { return unless $self->is_info;
			     $self->print('INFO', @message); }
sub warn ($self, @message) { return unless $self->is_warn;
			     $self->print('WARN', @message); }
sub error ($self, @message) { return unless $self->is_error;
			      $self->print('ERROR', @message); }
sub fatal ($self, @message) { $self->print('FATAL', @message); }
sub log ($self, $level, @message) {
    return unless ($self->{log_level} // $global_log_level) <= $level;
    $self->print($Log::Log4perl::Level::LEVELS{ $level }, @message);
}

sub print ($self, $level, @message) {
    print "[$level] " . ($self->{class} ? "[$self->{class}] " : "")
	. (join "", @message);
}

sub logdie ($self, @message) {
    $self->fatal(@message);
    die;
}

1;

package #
    Log::Log4perl;
use strict;
use warnings;
use base 'Irssi::Log::Log4perl';
BEGIN { $INC{'Log/Log4perl.pm'} = __FILE__; }

sub DUMMY { 1 }

1;
