######################################################################
#
# 5111_jipsj_by_letsj_RT_DBCS.t
#
# Copyright (c) 2018, 2019 INABA Hitoshi <ina@cpan.org> in a CPAN
######################################################################

use strict;
use FindBin;
use lib "$FindBin::Bin/../lib";

BEGIN {
    use vars qw(@test);
    @test = (
        ["\x20\x20",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x21\x21"],
        ["\x21\x21",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\x20\x20"],

        ["\xA1\xA2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x21\x22"],
        ["\x21\x22",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xA2"],

        ["\xA1\xA3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x21\x23"],
        ["\x21\x23",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xA3"],

        ["\xA1\xA4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x21\x24"],
        ["\x21\x24",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xA4"],

        ["\xA1\xA5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x21\x25"],
        ["\x21\x25",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xA5"],

        ["\xA1\xA6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x21\x26"],
        ["\x21\x26",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xA6"],

        ["\xA1\xA7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x21\x27"],
        ["\x21\x27",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xA7"],

        ["\xA1\xA8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x21\x28"],
        ["\x21\x28",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xA8"],

        ["\xA1\xA9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x21\x29"],
        ["\x21\x29",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xA9"],

        ["\xA1\xAA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x21\x2A"],
        ["\x21\x2A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xAA"],

        ["\xA1\xAB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x21\x2B"],
        ["\x21\x2B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xAB"],

        ["\xA1\xAC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x21\x2C"],
        ["\x21\x2C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xAC"],

        ["\xA1\xAD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x21\x2D"],
        ["\x21\x2D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xAD"],

        ["\xA1\xAE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x21\x2E"],
        ["\x21\x2E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xAE"],

        ["\xA1\xAF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x21\x2F"],
        ["\x21\x2F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xAF"],

        ["\xA1\xB0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x21\x30"],
        ["\x21\x30",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xB0"],

        ["\xA1\xB1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x21\x31"],
        ["\x21\x31",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xB1"],

        ["\xA1\xB2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x21\x32"],
        ["\x21\x32",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xB2"],

        ["\xA1\xB3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x21\x33"],
        ["\x21\x33",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xB3"],

        ["\xA1\xB4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x21\x34"],
        ["\x21\x34",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xB4"],

        ["\xA1\xB5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x21\x35"],
        ["\x21\x35",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xB5"],

        ["\xA1\xB6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x21\x36"],
        ["\x21\x36",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xB6"],

        ["\xA1\xB7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x21\x37"],
        ["\x21\x37",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xB7"],

        ["\xA1\xB8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x21\x38"],
        ["\x21\x38",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xB8"],

        ["\xA1\xB9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x21\x39"],
        ["\x21\x39",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xB9"],

        ["\xA1\xBA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x21\x3A"],
        ["\x21\x3A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xBA"],

        ["\xA1\xBB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x21\x3B"],
        ["\x21\x3B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xBB"],

        ["\xA1\xBC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x21\x3C"],
        ["\x21\x3C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xBC"],

        ["\xA1\xBD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x21\x3D"],
        ["\x21\x3D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xBD"],

        ["\xA1\xBE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x21\x3E"],
        ["\x21\x3E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xBE"],

        ["\xA1\xBF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x21\x3F"],
        ["\x21\x3F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xBF"],

        ["\x31\xA1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x21\x40"],
        ["\x21\x40",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\x31\xA1"],

        ["\xA1\xC1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x21\x41"],
        ["\x21\x41",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xC1"],

        ["\x31\xA2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x21\x42"],
        ["\x21\x42",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\x31\xA2"],

        ["\xA1\xC3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x21\x43"],
        ["\x21\x43",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xC3"],

        ["\xA1\xC4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x21\x44"],
        ["\x21\x44",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xC4"],

        ["\xA1\xC5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x21\x45"],
        ["\x21\x45",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xC5"],

        ["\xA1\xC6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x21\x46"],
        ["\x21\x46",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xC6"],

        ["\xA1\xC7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x21\x47"],
        ["\x21\x47",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xC7"],

        ["\xA1\xC8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x21\x48"],
        ["\x21\x48",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xC8"],

        ["\xA1\xC9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x21\x49"],
        ["\x21\x49",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xC9"],

        ["\xA1\xCA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x21\x4A"],
        ["\x21\x4A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xCA"],

        ["\xA1\xCB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x21\x4B"],
        ["\x21\x4B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xCB"],

        ["\xA1\xCC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x21\x4C"],
        ["\x21\x4C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xCC"],

        ["\xA1\xCD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x21\x4D"],
        ["\x21\x4D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xCD"],

        ["\xA1\xCE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x21\x4E"],
        ["\x21\x4E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xCE"],

        ["\xA1\xCF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x21\x4F"],
        ["\x21\x4F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xCF"],

        ["\xA1\xD0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x21\x50"],
        ["\x21\x50",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xD0"],

        ["\xA1\xD1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x21\x51"],
        ["\x21\x51",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xD1"],

        ["\xA1\xD2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x21\x52"],
        ["\x21\x52",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xD2"],

        ["\xA1\xD3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x21\x53"],
        ["\x21\x53",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xD3"],

        ["\xA1\xD4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x21\x54"],
        ["\x21\x54",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xD4"],

        ["\xA1\xD5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x21\x55"],
        ["\x21\x55",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xD5"],

        ["\xA1\xD6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x21\x56"],
        ["\x21\x56",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xD6"],

        ["\xA1\xD7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x21\x57"],
        ["\x21\x57",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xD7"],

        ["\xA1\xD8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x21\x58"],
        ["\x21\x58",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xD8"],

        ["\xA1\xD9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x21\x59"],
        ["\x21\x59",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xD9"],

        ["\xA1\xDA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x21\x5A"],
        ["\x21\x5A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xDA"],

        ["\xA1\xDB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x21\x5B"],
        ["\x21\x5B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xDB"],

        ["\xA1\xDC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x21\x5C"],
        ["\x21\x5C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xDC"],

        ["\x31\xA3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x21\x5D"],
        ["\x21\x5D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\x31\xA3"],

        ["\xA1\xDE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x21\x5E"],
        ["\x21\x5E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xDE"],

        ["\xA1\xDF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x21\x5F"],
        ["\x21\x5F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xDF"],

        ["\xA1\xE0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x21\x60"],
        ["\x21\x60",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xE0"],

        ["\xA1\xE1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x21\x61"],
        ["\x21\x61",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xE1"],

        ["\xA1\xE2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x21\x62"],
        ["\x21\x62",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xE2"],

        ["\xA1\xE3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x21\x63"],
        ["\x21\x63",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xE3"],

        ["\xA1\xE4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x21\x64"],
        ["\x21\x64",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xE4"],

        ["\xA1\xE5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x21\x65"],
        ["\x21\x65",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xE5"],

        ["\xA1\xE6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x21\x66"],
        ["\x21\x66",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xE6"],

        ["\xA1\xE7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x21\x67"],
        ["\x21\x67",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xE7"],

        ["\xA1\xE8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x21\x68"],
        ["\x21\x68",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xE8"],

        ["\xA1\xE9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x21\x69"],
        ["\x21\x69",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xE9"],

        ["\xA1\xEA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x21\x6A"],
        ["\x21\x6A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xEA"],

        ["\xA1\xEB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x21\x6B"],
        ["\x21\x6B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xEB"],

        ["\xA1\xEC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x21\x6C"],
        ["\x21\x6C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xEC"],

        ["\xA1\xED",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x21\x6D"],
        ["\x21\x6D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xED"],

        ["\xA1\xEE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x21\x6E"],
        ["\x21\x6E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xEE"],

        ["\xA1\xEF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x21\x6F"],
        ["\x21\x6F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xEF"],

        ["\xA1\xF0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x21\x70"],
        ["\x21\x70",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xF0"],

        ["\x31\xA4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x21\x71"],
        ["\x21\x71",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\x31\xA4"],

        ["\x31\xA5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x21\x72"],
        ["\x21\x72",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\x31\xA5"],

        ["\xA1\xF3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x21\x73"],
        ["\x21\x73",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xF3"],

        ["\xA1\xF4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x21\x74"],
        ["\x21\x74",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xF4"],

        ["\xA1\xF5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x21\x75"],
        ["\x21\x75",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xF5"],

        ["\xA1\xF6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x21\x76"],
        ["\x21\x76",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xF6"],

        ["\xA1\xF7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x21\x77"],
        ["\x21\x77",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xF7"],

        ["\xA1\xF8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x21\x78"],
        ["\x21\x78",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xF8"],

        ["\xA1\xF9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x21\x79"],
        ["\x21\x79",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xF9"],

        ["\xA1\xFA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x21\x7A"],
        ["\x21\x7A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xFA"],

        ["\xA1\xFB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x21\x7B"],
        ["\x21\x7B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xFB"],

        ["\xA1\xFC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x21\x7C"],
        ["\x21\x7C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xFC"],

        ["\xA1\xFD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x21\x7D"],
        ["\x21\x7D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xFD"],

        ["\xA1\xFE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x21\x7E"],
        ["\x21\x7E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA1\xFE"],

        ["\xA2\xA1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x22\x21"],
        ["\x22\x21",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xA1"],

        ["\xA2\xA2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x22\x22"],
        ["\x22\x22",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xA2"],

        ["\xA2\xA3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x22\x23"],
        ["\x22\x23",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xA3"],

        ["\xA2\xA4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x22\x24"],
        ["\x22\x24",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xA4"],

        ["\xA2\xA5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x22\x25"],
        ["\x22\x25",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xA5"],

        ["\xA2\xA6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x22\x26"],
        ["\x22\x26",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xA6"],

        ["\xA2\xA7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x22\x27"],
        ["\x22\x27",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xA7"],

        ["\xA2\xA8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x22\x28"],
        ["\x22\x28",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xA8"],

        ["\xA2\xA9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x22\x29"],
        ["\x22\x29",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xA9"],

        ["\xA2\xAA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x22\x2A"],
        ["\x22\x2A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAA"],

        ["\xA2\xAB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x22\x2B"],
        ["\x22\x2B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAB"],

        ["\xA2\xAC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x22\x2C"],
        ["\x22\x2C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAC"],

        ["\xA2\xAD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x22\x2D"],
        ["\x22\x2D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAD"],

        ["\xA2\xAE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],
        ["\x22\x2E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],

        ["\xA2\xBA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xD4"],
        ["\xA5\xD4",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xBA"],

        ["\xA2\xBB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xD5"],
        ["\xA5\xD5",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xBB"],

        ["\xA2\xBC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xF4"],
        ["\xA6\xF4",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xBC"],

        ["\xA2\xBD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xF5"],
        ["\xA6\xF5",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xBD"],

        ["\xA2\xBE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xD2"],
        ["\xA5\xD2",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xBE"],

        ["\xA2\xBF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xD3"],
        ["\xA5\xD3",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xBF"],

        ["\xA2\xC0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2D\x7C"],
        ["\x2D\x7C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xC0"],

        ["\xA2\xC1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2D\x7B"],
        ["\x2D\x7B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xC1"],

        ["\xA2\xCA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xD0"],
        ["\xA5\xD0",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xCA"],

        ["\xA2\xCB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xD1"],
        ["\xA5\xD1",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xCB"],

        ["\x31\xA6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x74\x21"],
        ["\x74\x21",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\x31\xA6"],

        ["\xA2\xCD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xF6"],
        ["\xA6\xF6",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xCD"],

        ["\xA2\xCE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xF7"],
        ["\xA6\xF7",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xCE"],

        ["\xA2\xCF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xE7"],
        ["\xA5\xE7",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xCF"],

        ["\xA2\xD0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xE8"],
        ["\xA5\xE8",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xD0"],

        ["\xA2\xDC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2D\x77"],
        ["\x2D\x77",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xDC"],

        ["\xA2\xDD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2D\x76"],
        ["\x2D\x76",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xDD"],

        ["\xA2\xDE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xF8"],
        ["\xA6\xF8",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xDE"],

        ["\xA2\xDF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xCA"],
        ["\xA5\xCA",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xDF"],

        ["\xA2\xE0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xF9"],
        ["\xA6\xF9",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xE0"],

        ["\xA2\xE1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2D\x71"],
        ["\x2D\x71",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xE1"],

        ["\xA2\xE2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2D\x70"],
        ["\x2D\x70",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xE2"],

        ["\xA2\xE3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xE1"],
        ["\xA5\xE1",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xE3"],

        ["\xA2\xE4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xE2"],
        ["\xA5\xE2",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xE4"],

        ["\xA2\xE5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2D\x75"],
        ["\x2D\x75",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xE5"],

        ["\xA2\xE6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xDD"],
        ["\xA5\xDD",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xE6"],

        ["\xA2\xE7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xDC"],
        ["\xA5\xDC",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xE7"],

        ["\xA2\xE8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2D\x7A"],
        ["\x2D\x7A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xE8"],

        ["\xA2\xE9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2D\x72"],
        ["\x2D\x72",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xE9"],

        ["\xA2\xEA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xFA"],
        ["\xA6\xFA",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xEA"],

        ["\xA2\xF2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xDF"],
        ["\xA4\xDF",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xF2"],

        ["\xA2\xF3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xFE"],
        ["\xA4\xFE",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xF3"],

        ["\xA2\xF4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xFB"],
        ["\xA6\xFB",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xF4"],

        ["\xA2\xF5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xFC"],
        ["\xA6\xFC",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xF5"],

        ["\xA2\xF6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xFD"],
        ["\xA6\xFD",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xF6"],

        ["\xA2\xF7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xEE"],
        ["\xA5\xEE",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xF7"],

        ["\xA2\xF8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xEF"],
        ["\xA5\xEF",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xF8"],

        ["\xA2\xF9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xF0"],
        ["\xA5\xF0",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xF9"],

        ["\xA2\xFE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xFE"],
        ["\xA6\xFE",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xFE"],

        ["\xA3\xB0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x23\x30"],
        ["\x23\x30",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xB0"],

        ["\xA3\xB1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x23\x31"],
        ["\x23\x31",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xB1"],

        ["\xA3\xB2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x23\x32"],
        ["\x23\x32",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xB2"],

        ["\xA3\xB3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x23\x33"],
        ["\x23\x33",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xB3"],

        ["\xA3\xB4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x23\x34"],
        ["\x23\x34",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xB4"],

        ["\xA3\xB5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x23\x35"],
        ["\x23\x35",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xB5"],

        ["\xA3\xB6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x23\x36"],
        ["\x23\x36",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xB6"],

        ["\xA3\xB7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x23\x37"],
        ["\x23\x37",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xB7"],

        ["\xA3\xB8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x23\x38"],
        ["\x23\x38",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xB8"],

        ["\xA3\xB9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x23\x39"],
        ["\x23\x39",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xB9"],

        ["\xA3\xC1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x23\x41"],
        ["\x23\x41",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xC1"],

        ["\xA3\xC2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x23\x42"],
        ["\x23\x42",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xC2"],

        ["\xA3\xC3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x23\x43"],
        ["\x23\x43",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xC3"],

        ["\xA3\xC4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x23\x44"],
        ["\x23\x44",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xC4"],

        ["\xA3\xC5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x23\x45"],
        ["\x23\x45",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xC5"],

        ["\xA3\xC6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x23\x46"],
        ["\x23\x46",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xC6"],

        ["\xA3\xC7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x23\x47"],
        ["\x23\x47",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xC7"],

        ["\xA3\xC8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x23\x48"],
        ["\x23\x48",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xC8"],

        ["\xA3\xC9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x23\x49"],
        ["\x23\x49",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xC9"],

        ["\xA3\xCA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x23\x4A"],
        ["\x23\x4A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xCA"],

        ["\xA3\xCB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x23\x4B"],
        ["\x23\x4B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xCB"],

        ["\xA3\xCC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x23\x4C"],
        ["\x23\x4C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xCC"],

        ["\xA3\xCD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x23\x4D"],
        ["\x23\x4D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xCD"],

        ["\xA3\xCE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x23\x4E"],
        ["\x23\x4E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xCE"],

        ["\xA3\xCF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x23\x4F"],
        ["\x23\x4F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xCF"],

        ["\xA3\xD0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x23\x50"],
        ["\x23\x50",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xD0"],

        ["\xA3\xD1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x23\x51"],
        ["\x23\x51",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xD1"],

        ["\xA3\xD2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x23\x52"],
        ["\x23\x52",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xD2"],

        ["\xA3\xD3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x23\x53"],
        ["\x23\x53",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xD3"],

        ["\xA3\xD4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x23\x54"],
        ["\x23\x54",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xD4"],

        ["\xA3\xD5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x23\x55"],
        ["\x23\x55",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xD5"],

        ["\xA3\xD6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x23\x56"],
        ["\x23\x56",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xD6"],

        ["\xA3\xD7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x23\x57"],
        ["\x23\x57",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xD7"],

        ["\xA3\xD8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x23\x58"],
        ["\x23\x58",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xD8"],

        ["\xA3\xD9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x23\x59"],
        ["\x23\x59",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xD9"],

        ["\xA3\xDA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x23\x5A"],
        ["\x23\x5A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xDA"],

        ["\xA3\xE1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x23\x61"],
        ["\x23\x61",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xE1"],

        ["\xA3\xE2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x23\x62"],
        ["\x23\x62",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xE2"],

        ["\xA3\xE3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x23\x63"],
        ["\x23\x63",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xE3"],

        ["\xA3\xE4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x23\x64"],
        ["\x23\x64",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xE4"],

        ["\xA3\xE5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x23\x65"],
        ["\x23\x65",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xE5"],

        ["\xA3\xE6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x23\x66"],
        ["\x23\x66",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xE6"],

        ["\xA3\xE7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x23\x67"],
        ["\x23\x67",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xE7"],

        ["\xA3\xE8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x23\x68"],
        ["\x23\x68",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xE8"],

        ["\xA3\xE9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x23\x69"],
        ["\x23\x69",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xE9"],

        ["\xA3\xEA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x23\x6A"],
        ["\x23\x6A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xEA"],

        ["\xA3\xEB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x23\x6B"],
        ["\x23\x6B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xEB"],

        ["\xA3\xEC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x23\x6C"],
        ["\x23\x6C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xEC"],

        ["\xA3\xED",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x23\x6D"],
        ["\x23\x6D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xED"],

        ["\xA3\xEE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x23\x6E"],
        ["\x23\x6E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xEE"],

        ["\xA3\xEF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x23\x6F"],
        ["\x23\x6F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xEF"],

        ["\xA3\xF0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x23\x70"],
        ["\x23\x70",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xF0"],

        ["\xA3\xF1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x23\x71"],
        ["\x23\x71",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xF1"],

        ["\xA3\xF2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x23\x72"],
        ["\x23\x72",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xF2"],

        ["\xA3\xF3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x23\x73"],
        ["\x23\x73",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xF3"],

        ["\xA3\xF4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x23\x74"],
        ["\x23\x74",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xF4"],

        ["\xA3\xF5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x23\x75"],
        ["\x23\x75",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xF5"],

        ["\xA3\xF6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x23\x76"],
        ["\x23\x76",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xF6"],

        ["\xA3\xF7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x23\x77"],
        ["\x23\x77",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xF7"],

        ["\xA3\xF8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x23\x78"],
        ["\x23\x78",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xF8"],

        ["\xA3\xF9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x23\x79"],
        ["\x23\x79",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xF9"],

        ["\xA3\xFA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x23\x7A"],
        ["\x23\x7A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xFA"],

        ["\xA4\xA1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x24\x21"],
        ["\x24\x21",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xA1"],

        ["\xA4\xA2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x24\x22"],
        ["\x24\x22",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xA2"],

        ["\xA4\xA3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x24\x23"],
        ["\x24\x23",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xA3"],

        ["\xA4\xA4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x24\x24"],
        ["\x24\x24",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xA4"],

        ["\xA4\xA5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x24\x25"],
        ["\x24\x25",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xA5"],

        ["\xA4\xA6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x24\x26"],
        ["\x24\x26",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xA6"],

        ["\xA4\xA7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x24\x27"],
        ["\x24\x27",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xA7"],

        ["\xA4\xA8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x24\x28"],
        ["\x24\x28",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xA8"],

        ["\xA4\xA9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x24\x29"],
        ["\x24\x29",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xA9"],

        ["\xA4\xAA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x24\x2A"],
        ["\x24\x2A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xAA"],

        ["\xA4\xAB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x24\x2B"],
        ["\x24\x2B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xAB"],

        ["\xA4\xAC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x24\x2C"],
        ["\x24\x2C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xAC"],

        ["\xA4\xAD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x24\x2D"],
        ["\x24\x2D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xAD"],

        ["\xA4\xAE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x24\x2E"],
        ["\x24\x2E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xAE"],

        ["\xA4\xAF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x24\x2F"],
        ["\x24\x2F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xAF"],

        ["\xA4\xB0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x24\x30"],
        ["\x24\x30",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xB0"],

        ["\xA4\xB1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x24\x31"],
        ["\x24\x31",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xB1"],

        ["\xA4\xB2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x24\x32"],
        ["\x24\x32",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xB2"],

        ["\xA4\xB3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x24\x33"],
        ["\x24\x33",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xB3"],

        ["\xA4\xB4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x24\x34"],
        ["\x24\x34",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xB4"],

        ["\xA4\xB5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x24\x35"],
        ["\x24\x35",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xB5"],

        ["\xA4\xB6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x24\x36"],
        ["\x24\x36",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xB6"],

        ["\xA4\xB7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x24\x37"],
        ["\x24\x37",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xB7"],

        ["\xA4\xB8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x24\x38"],
        ["\x24\x38",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xB8"],

        ["\xA4\xB9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x24\x39"],
        ["\x24\x39",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xB9"],

        ["\xA4\xBA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x24\x3A"],
        ["\x24\x3A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xBA"],

        ["\xA4\xBB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x24\x3B"],
        ["\x24\x3B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xBB"],

        ["\xA4\xBC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x24\x3C"],
        ["\x24\x3C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xBC"],

        ["\xA4\xBD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x24\x3D"],
        ["\x24\x3D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xBD"],

        ["\xA4\xBE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x24\x3E"],
        ["\x24\x3E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xBE"],

        ["\xA4\xBF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x24\x3F"],
        ["\x24\x3F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xBF"],

        ["\xA4\xC0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x24\x40"],
        ["\x24\x40",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xC0"],

        ["\xA4\xC1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x24\x41"],
        ["\x24\x41",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xC1"],

        ["\xA4\xC2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x24\x42"],
        ["\x24\x42",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xC2"],

        ["\xA4\xC3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x24\x43"],
        ["\x24\x43",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xC3"],

        ["\xA4\xC4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x24\x44"],
        ["\x24\x44",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xC4"],

        ["\xA4\xC5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x24\x45"],
        ["\x24\x45",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xC5"],

        ["\xA4\xC6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x24\x46"],
        ["\x24\x46",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xC6"],

        ["\xA4\xC7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x24\x47"],
        ["\x24\x47",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xC7"],

        ["\xA4\xC8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x24\x48"],
        ["\x24\x48",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xC8"],

        ["\xA4\xC9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x24\x49"],
        ["\x24\x49",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xC9"],

        ["\xA4\xCA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x24\x4A"],
        ["\x24\x4A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xCA"],

        ["\xA4\xCB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x24\x4B"],
        ["\x24\x4B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xCB"],

        ["\xA4\xCC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x24\x4C"],
        ["\x24\x4C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xCC"],

        ["\xA4\xCD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x24\x4D"],
        ["\x24\x4D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xCD"],

        ["\xA4\xCE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x24\x4E"],
        ["\x24\x4E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xCE"],

        ["\xA4\xCF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x24\x4F"],
        ["\x24\x4F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xCF"],

        ["\xA4\xD0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x24\x50"],
        ["\x24\x50",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xD0"],

        ["\xA4\xD1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x24\x51"],
        ["\x24\x51",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xD1"],

        ["\xA4\xD2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x24\x52"],
        ["\x24\x52",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xD2"],

        ["\xA4\xD3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x24\x53"],
        ["\x24\x53",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xD3"],

        ["\xA4\xD4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x24\x54"],
        ["\x24\x54",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xD4"],

        ["\xA4\xD5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x24\x55"],
        ["\x24\x55",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xD5"],

        ["\xA4\xD6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x24\x56"],
        ["\x24\x56",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xD6"],

        ["\xA4\xD7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x24\x57"],
        ["\x24\x57",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xD7"],

        ["\xA4\xD8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x24\x58"],
        ["\x24\x58",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xD8"],

        ["\xA4\xD9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x24\x59"],
        ["\x24\x59",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xD9"],

        ["\xA4\xDA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x24\x5A"],
        ["\x24\x5A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xDA"],

        ["\xA4\xDB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x24\x5B"],
        ["\x24\x5B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xDB"],

        ["\xA4\xDC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x24\x5C"],
        ["\x24\x5C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xDC"],

        ["\xA4\xDD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x24\x5D"],
        ["\x24\x5D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xDD"],

        ["\xA4\xDE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x24\x5E"],
        ["\x24\x5E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xDE"],

        ["\xA4\xDF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x24\x5F"],
        ["\x24\x5F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xDF"],

        ["\xA4\xE0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x24\x60"],
        ["\x24\x60",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xE0"],

        ["\xA4\xE1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x24\x61"],
        ["\x24\x61",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xE1"],

        ["\xA4\xE2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x24\x62"],
        ["\x24\x62",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xE2"],

        ["\xA4\xE3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x24\x63"],
        ["\x24\x63",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xE3"],

        ["\xA4\xE4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x24\x64"],
        ["\x24\x64",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xE4"],

        ["\xA4\xE5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x24\x65"],
        ["\x24\x65",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xE5"],

        ["\xA4\xE6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x24\x66"],
        ["\x24\x66",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xE6"],

        ["\xA4\xE7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x24\x67"],
        ["\x24\x67",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xE7"],

        ["\xA4\xE8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x24\x68"],
        ["\x24\x68",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xE8"],

        ["\xA4\xE9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x24\x69"],
        ["\x24\x69",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xE9"],

        ["\xA4\xEA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x24\x6A"],
        ["\x24\x6A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xEA"],

        ["\xA4\xEB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x24\x6B"],
        ["\x24\x6B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xEB"],

        ["\xA4\xEC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x24\x6C"],
        ["\x24\x6C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xEC"],

        ["\xA4\xED",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x24\x6D"],
        ["\x24\x6D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xED"],

        ["\xA4\xEE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x24\x6E"],
        ["\x24\x6E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xEE"],

        ["\xA4\xEF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x24\x6F"],
        ["\x24\x6F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xEF"],

        ["\xA4\xF0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x24\x70"],
        ["\x24\x70",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xF0"],

        ["\xA4\xF1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x24\x71"],
        ["\x24\x71",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xF1"],

        ["\xA4\xF2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x24\x72"],
        ["\x24\x72",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xF2"],

        ["\xA4\xF3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x24\x73"],
        ["\x24\x73",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA4\xF3"],

        ["\xA5\xA1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x25\x21"],
        ["\x25\x21",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xA1"],

        ["\xA5\xA2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x25\x22"],
        ["\x25\x22",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xA2"],

        ["\xA5\xA3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x25\x23"],
        ["\x25\x23",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xA3"],

        ["\xA5\xA4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x25\x24"],
        ["\x25\x24",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xA4"],

        ["\xA5\xA5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x25\x25"],
        ["\x25\x25",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xA5"],

        ["\xA5\xA6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x25\x26"],
        ["\x25\x26",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xA6"],

        ["\xA5\xA7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x25\x27"],
        ["\x25\x27",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xA7"],

        ["\xA5\xA8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x25\x28"],
        ["\x25\x28",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xA8"],

        ["\xA5\xA9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x25\x29"],
        ["\x25\x29",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xA9"],

        ["\xA5\xAA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x25\x2A"],
        ["\x25\x2A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xAA"],

        ["\xA5\xAB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x25\x2B"],
        ["\x25\x2B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xAB"],

        ["\xA5\xAC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x25\x2C"],
        ["\x25\x2C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xAC"],

        ["\xA5\xAD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x25\x2D"],
        ["\x25\x2D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xAD"],

        ["\xA5\xAE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x25\x2E"],
        ["\x25\x2E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xAE"],

        ["\xA5\xAF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x25\x2F"],
        ["\x25\x2F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xAF"],

        ["\xA5\xB0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x25\x30"],
        ["\x25\x30",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xB0"],

        ["\xA5\xB1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x25\x31"],
        ["\x25\x31",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xB1"],

        ["\xA5\xB2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x25\x32"],
        ["\x25\x32",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xB2"],

        ["\xA5\xB3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x25\x33"],
        ["\x25\x33",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xB3"],

        ["\xA5\xB4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x25\x34"],
        ["\x25\x34",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xB4"],

        ["\xA5\xB5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x25\x35"],
        ["\x25\x35",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xB5"],

        ["\xA5\xB6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x25\x36"],
        ["\x25\x36",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xB6"],

        ["\xA5\xB7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x25\x37"],
        ["\x25\x37",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xB7"],

        ["\xA5\xB8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x25\x38"],
        ["\x25\x38",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xB8"],

        ["\xA5\xB9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x25\x39"],
        ["\x25\x39",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xB9"],

        ["\xA5\xBA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x25\x3A"],
        ["\x25\x3A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xBA"],

        ["\xA5\xBB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x25\x3B"],
        ["\x25\x3B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xBB"],

        ["\xA5\xBC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x25\x3C"],
        ["\x25\x3C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xBC"],

        ["\xA5\xBD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x25\x3D"],
        ["\x25\x3D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xBD"],

        ["\xA5\xBE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x25\x3E"],
        ["\x25\x3E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xBE"],

        ["\xA5\xBF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x25\x3F"],
        ["\x25\x3F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xBF"],

        ["\xA5\xC0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x25\x40"],
        ["\x25\x40",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xC0"],

        ["\xA5\xC1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x25\x41"],
        ["\x25\x41",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xC1"],

        ["\xA5\xC2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x25\x42"],
        ["\x25\x42",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xC2"],

        ["\xA5\xC3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x25\x43"],
        ["\x25\x43",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xC3"],

        ["\xA5\xC4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x25\x44"],
        ["\x25\x44",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xC4"],

        ["\xA5\xC5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x25\x45"],
        ["\x25\x45",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xC5"],

        ["\xA5\xC6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x25\x46"],
        ["\x25\x46",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xC6"],

        ["\xA5\xC7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x25\x47"],
        ["\x25\x47",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xC7"],

        ["\xA5\xC8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x25\x48"],
        ["\x25\x48",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xC8"],

        ["\xA5\xC9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x25\x49"],
        ["\x25\x49",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xC9"],

        ["\xA5\xCA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x25\x4A"],
        ["\x25\x4A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xCA"],

        ["\xA5\xCB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x25\x4B"],
        ["\x25\x4B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xCB"],

        ["\xA5\xCC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x25\x4C"],
        ["\x25\x4C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xCC"],

        ["\xA5\xCD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x25\x4D"],
        ["\x25\x4D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xCD"],

        ["\xA5\xCE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x25\x4E"],
        ["\x25\x4E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xCE"],

        ["\xA5\xCF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x25\x4F"],
        ["\x25\x4F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xCF"],

        ["\xA5\xD0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x25\x50"],
        ["\x25\x50",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xD0"],

        ["\xA5\xD1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x25\x51"],
        ["\x25\x51",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xD1"],

        ["\xA5\xD2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x25\x52"],
        ["\x25\x52",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xD2"],

        ["\xA5\xD3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x25\x53"],
        ["\x25\x53",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xD3"],

        ["\xA5\xD4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x25\x54"],
        ["\x25\x54",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xD4"],

        ["\xA5\xD5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x25\x55"],
        ["\x25\x55",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xD5"],

        ["\xA5\xD6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x25\x56"],
        ["\x25\x56",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xD6"],

        ["\xA5\xD7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x25\x57"],
        ["\x25\x57",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xD7"],

        ["\xA5\xD8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x25\x58"],
        ["\x25\x58",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xD8"],

        ["\xA5\xD9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x25\x59"],
        ["\x25\x59",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xD9"],

        ["\xA5\xDA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x25\x5A"],
        ["\x25\x5A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xDA"],

        ["\xA5\xDB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x25\x5B"],
        ["\x25\x5B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xDB"],

        ["\xA5\xDC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x25\x5C"],
        ["\x25\x5C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xDC"],

        ["\xA5\xDD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x25\x5D"],
        ["\x25\x5D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xDD"],

        ["\xA5\xDE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x25\x5E"],
        ["\x25\x5E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xDE"],

        ["\xA5\xDF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x25\x5F"],
        ["\x25\x5F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xDF"],

        ["\xA5\xE0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x25\x60"],
        ["\x25\x60",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xE0"],

        ["\xA5\xE1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x25\x61"],
        ["\x25\x61",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xE1"],

        ["\xA5\xE2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x25\x62"],
        ["\x25\x62",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xE2"],

        ["\xA5\xE3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x25\x63"],
        ["\x25\x63",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xE3"],

        ["\xA5\xE4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x25\x64"],
        ["\x25\x64",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xE4"],

        ["\xA5\xE5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x25\x65"],
        ["\x25\x65",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xE5"],

        ["\xA5\xE6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x25\x66"],
        ["\x25\x66",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xE6"],

        ["\xA5\xE7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x25\x67"],
        ["\x25\x67",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xE7"],

        ["\xA5\xE8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x25\x68"],
        ["\x25\x68",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xE8"],

        ["\xA5\xE9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x25\x69"],
        ["\x25\x69",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xE9"],

        ["\xA5\xEA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x25\x6A"],
        ["\x25\x6A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xEA"],

        ["\xA5\xEB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x25\x6B"],
        ["\x25\x6B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xEB"],

        ["\xA5\xEC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x25\x6C"],
        ["\x25\x6C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xEC"],

        ["\xA5\xED",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x25\x6D"],
        ["\x25\x6D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xED"],

        ["\xA5\xEE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x25\x6E"],
        ["\x25\x6E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xEE"],

        ["\xA5\xEF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x25\x6F"],
        ["\x25\x6F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xEF"],

        ["\xA5\xF0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x25\x70"],
        ["\x25\x70",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xF0"],

        ["\xA5\xF1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x25\x71"],
        ["\x25\x71",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xF1"],

        ["\xA5\xF2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x25\x72"],
        ["\x25\x72",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xF2"],

        ["\xA5\xF3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x25\x73"],
        ["\x25\x73",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xF3"],

        ["\xA5\xF4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x25\x74"],
        ["\x25\x74",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xF4"],

        ["\xA5\xF5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x25\x75"],
        ["\x25\x75",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xF5"],

        ["\xA5\xF6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x25\x76"],
        ["\x25\x76",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xF6"],

        ["\xA6\xA1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x26\x21"],
        ["\x26\x21",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xA1"],

        ["\xA6\xA2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x26\x22"],
        ["\x26\x22",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xA2"],

        ["\xA6\xA3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x26\x23"],
        ["\x26\x23",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xA3"],

        ["\xA6\xA4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x26\x24"],
        ["\x26\x24",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xA4"],

        ["\xA6\xA5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x26\x25"],
        ["\x26\x25",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xA5"],

        ["\xA6\xA6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x26\x26"],
        ["\x26\x26",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xA6"],

        ["\xA6\xA7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x26\x27"],
        ["\x26\x27",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xA7"],

        ["\xA6\xA8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x26\x28"],
        ["\x26\x28",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xA8"],

        ["\xA6\xA9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x26\x29"],
        ["\x26\x29",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xA9"],

        ["\xA6\xAA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x26\x2A"],
        ["\x26\x2A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xAA"],

        ["\xA6\xAB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x26\x2B"],
        ["\x26\x2B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xAB"],

        ["\xA6\xAC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x26\x2C"],
        ["\x26\x2C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xAC"],

        ["\xA6\xAD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x26\x2D"],
        ["\x26\x2D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xAD"],

        ["\xA6\xAE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x26\x2E"],
        ["\x26\x2E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xAE"],

        ["\xA6\xAF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x26\x2F"],
        ["\x26\x2F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xAF"],

        ["\xA6\xB0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x26\x30"],
        ["\x26\x30",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xB0"],

        ["\xA6\xB1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x26\x31"],
        ["\x26\x31",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xB1"],

        ["\xA6\xB2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x26\x32"],
        ["\x26\x32",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xB2"],

        ["\xA6\xB3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x26\x33"],
        ["\x26\x33",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xB3"],

        ["\xA6\xB4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x26\x34"],
        ["\x26\x34",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xB4"],

        ["\xA6\xB5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x26\x35"],
        ["\x26\x35",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xB5"],

        ["\xA6\xB6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x26\x36"],
        ["\x26\x36",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xB6"],

        ["\xA6\xB7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x26\x37"],
        ["\x26\x37",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xB7"],

        ["\xA6\xB8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x26\x38"],
        ["\x26\x38",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xB8"],

        ["\xA6\xC1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x26\x41"],
        ["\x26\x41",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xC1"],

        ["\xA6\xC2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x26\x42"],
        ["\x26\x42",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xC2"],

        ["\xA6\xC3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x26\x43"],
        ["\x26\x43",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xC3"],

        ["\xA6\xC4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x26\x44"],
        ["\x26\x44",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xC4"],

        ["\xA6\xC5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x26\x45"],
        ["\x26\x45",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xC5"],

        ["\xA6\xC6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x26\x46"],
        ["\x26\x46",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xC6"],

        ["\xA6\xC7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x26\x47"],
        ["\x26\x47",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xC7"],

        ["\xA6\xC8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x26\x48"],
        ["\x26\x48",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xC8"],

        ["\xA6\xC9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x26\x49"],
        ["\x26\x49",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xC9"],

        ["\xA6\xCA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x26\x4A"],
        ["\x26\x4A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xCA"],

        ["\xA6\xCB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x26\x4B"],
        ["\x26\x4B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xCB"],

        ["\xA6\xCC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x26\x4C"],
        ["\x26\x4C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xCC"],

        ["\xA6\xCD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x26\x4D"],
        ["\x26\x4D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xCD"],

        ["\xA6\xCE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x26\x4E"],
        ["\x26\x4E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xCE"],

        ["\xA6\xCF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x26\x4F"],
        ["\x26\x4F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xCF"],

        ["\xA6\xD0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x26\x50"],
        ["\x26\x50",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xD0"],

        ["\xA6\xD1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x26\x51"],
        ["\x26\x51",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xD1"],

        ["\xA6\xD2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x26\x52"],
        ["\x26\x52",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xD2"],

        ["\xA6\xD3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x26\x53"],
        ["\x26\x53",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xD3"],

        ["\xA6\xD4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x26\x54"],
        ["\x26\x54",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xD4"],

        ["\xA6\xD5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x26\x55"],
        ["\x26\x55",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xD5"],

        ["\xA6\xD6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x26\x56"],
        ["\x26\x56",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xD6"],

        ["\xA6\xD7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x26\x57"],
        ["\x26\x57",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xD7"],

        ["\xA6\xD8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x26\x58"],
        ["\x26\x58",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA6\xD8"],

        ["\xA7\xA1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x27\x21"],
        ["\x27\x21",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xA1"],

        ["\xA7\xA2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x27\x22"],
        ["\x27\x22",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xA2"],

        ["\xA7\xA3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x27\x23"],
        ["\x27\x23",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xA3"],

        ["\xA7\xA4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x27\x24"],
        ["\x27\x24",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xA4"],

        ["\xA7\xA5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x27\x25"],
        ["\x27\x25",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xA5"],

        ["\xA7\xA6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x27\x26"],
        ["\x27\x26",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xA6"],

        ["\xA7\xA7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x27\x27"],
        ["\x27\x27",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xA7"],

        ["\xA7\xA8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x27\x28"],
        ["\x27\x28",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xA8"],

        ["\xA7\xA9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x27\x29"],
        ["\x27\x29",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xA9"],

        ["\xA7\xAA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x27\x2A"],
        ["\x27\x2A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xAA"],

        ["\xA7\xAB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x27\x2B"],
        ["\x27\x2B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xAB"],

        ["\xA7\xAC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x27\x2C"],
        ["\x27\x2C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xAC"],

        ["\xA7\xAD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x27\x2D"],
        ["\x27\x2D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xAD"],

        ["\xA7\xAE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x27\x2E"],
        ["\x27\x2E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xAE"],

        ["\xA7\xAF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x27\x2F"],
        ["\x27\x2F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xAF"],

        ["\xA7\xB0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x27\x30"],
        ["\x27\x30",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xB0"],

        ["\xA7\xB1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x27\x31"],
        ["\x27\x31",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xB1"],

        ["\xA7\xB2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x27\x32"],
        ["\x27\x32",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xB2"],

        ["\xA7\xB3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x27\x33"],
        ["\x27\x33",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xB3"],

        ["\xA7\xB4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x27\x34"],
        ["\x27\x34",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xB4"],

        ["\xA7\xB5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x27\x35"],
        ["\x27\x35",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xB5"],

        ["\xA7\xB6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x27\x36"],
        ["\x27\x36",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xB6"],

        ["\xA7\xB7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x27\x37"],
        ["\x27\x37",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xB7"],

        ["\xA7\xB8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x27\x38"],
        ["\x27\x38",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xB8"],

        ["\xA7\xB9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x27\x39"],
        ["\x27\x39",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xB9"],

        ["\xA7\xBA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x27\x3A"],
        ["\x27\x3A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xBA"],

        ["\xA7\xBB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x27\x3B"],
        ["\x27\x3B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xBB"],

        ["\xA7\xBC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x27\x3C"],
        ["\x27\x3C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xBC"],

        ["\xA7\xBD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x27\x3D"],
        ["\x27\x3D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xBD"],

        ["\xA7\xBE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x27\x3E"],
        ["\x27\x3E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xBE"],

        ["\xA7\xBF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x27\x3F"],
        ["\x27\x3F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xBF"],

        ["\xA7\xC0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x27\x40"],
        ["\x27\x40",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xC0"],

        ["\xA7\xC1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x27\x41"],
        ["\x27\x41",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xC1"],

        ["\xA7\xD1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x27\x51"],
        ["\x27\x51",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xD1"],

        ["\xA7\xD2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x27\x52"],
        ["\x27\x52",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xD2"],

        ["\xA7\xD3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x27\x53"],
        ["\x27\x53",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xD3"],

        ["\xA7\xD4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x27\x54"],
        ["\x27\x54",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xD4"],

        ["\xA7\xD5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x27\x55"],
        ["\x27\x55",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xD5"],

        ["\xA7\xD6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x27\x56"],
        ["\x27\x56",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xD6"],

        ["\xA7\xD7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x27\x57"],
        ["\x27\x57",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xD7"],

        ["\xA7\xD8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x27\x58"],
        ["\x27\x58",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xD8"],

        ["\xA7\xD9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x27\x59"],
        ["\x27\x59",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xD9"],

        ["\xA7\xDA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x27\x5A"],
        ["\x27\x5A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xDA"],

        ["\xA7\xDB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x27\x5B"],
        ["\x27\x5B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xDB"],

        ["\xA7\xDC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x27\x5C"],
        ["\x27\x5C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xDC"],

        ["\xA7\xDD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x27\x5D"],
        ["\x27\x5D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xDD"],

        ["\xA7\xDE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x27\x5E"],
        ["\x27\x5E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xDE"],

        ["\xA7\xDF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x27\x5F"],
        ["\x27\x5F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xDF"],

        ["\xA7\xE0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x27\x60"],
        ["\x27\x60",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xE0"],

        ["\xA7\xE1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x27\x61"],
        ["\x27\x61",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xE1"],

        ["\xA7\xE2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x27\x62"],
        ["\x27\x62",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xE2"],

        ["\xA7\xE3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x27\x63"],
        ["\x27\x63",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xE3"],

        ["\xA7\xE4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x27\x64"],
        ["\x27\x64",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xE4"],

        ["\xA7\xE5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x27\x65"],
        ["\x27\x65",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xE5"],

        ["\xA7\xE6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x27\x66"],
        ["\x27\x66",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xE6"],

        ["\xA7\xE7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x27\x67"],
        ["\x27\x67",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xE7"],

        ["\xA7\xE8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x27\x68"],
        ["\x27\x68",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xE8"],

        ["\xA7\xE9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x27\x69"],
        ["\x27\x69",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xE9"],

        ["\xA7\xEA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x27\x6A"],
        ["\x27\x6A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xEA"],

        ["\xA7\xEB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x27\x6B"],
        ["\x27\x6B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xEB"],

        ["\xA7\xEC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x27\x6C"],
        ["\x27\x6C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xEC"],

        ["\xA7\xED",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x27\x6D"],
        ["\x27\x6D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xED"],

        ["\xA7\xEE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x27\x6E"],
        ["\x27\x6E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xEE"],

        ["\xA7\xEF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x27\x6F"],
        ["\x27\x6F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xEF"],

        ["\xA7\xF0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x27\x70"],
        ["\x27\x70",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xF0"],

        ["\xA7\xF1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x27\x71"],
        ["\x27\x71",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA7\xF1"],

        ["\xA8\xA1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2C\x24"],
        ["\x2C\x24",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA8\xA1"],

        ["\xA8\xA2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2C\x26"],
        ["\x2C\x26",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA8\xA2"],

        ["\xA8\xA3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2C\x30"],
        ["\x2C\x30",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA8\xA3"],

        ["\xA8\xA4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2C\x34"],
        ["\x2C\x34",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA8\xA4"],

        ["\xA8\xA5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2C\x3C"],
        ["\x2C\x3C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA8\xA5"],

        ["\xA8\xA6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2C\x38"],
        ["\x2C\x38",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA8\xA6"],

        ["\xA8\xA7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2C\x40"],
        ["\x2C\x40",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA8\xA7"],

        ["\xA8\xA8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2C\x50"],
        ["\x2C\x50",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA8\xA8"],

        ["\xA8\xA9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2C\x48"],
        ["\x2C\x48",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA8\xA9"],

        ["\xA8\xAA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2C\x58"],
        ["\x2C\x58",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA8\xAA"],

        ["\xA8\xAB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2C\x60"],
        ["\x2C\x60",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA8\xAB"],

        ["\xA8\xAC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2C\x25"],
        ["\x2C\x25",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA8\xAC"],

        ["\xA8\xAD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2C\x27"],
        ["\x2C\x27",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA8\xAD"],

        ["\xA8\xAE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2C\x33"],
        ["\x2C\x33",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA8\xAE"],

        ["\xA8\xAF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2C\x37"],
        ["\x2C\x37",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA8\xAF"],

        ["\xA8\xB0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2C\x3F"],
        ["\x2C\x3F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA8\xB0"],

        ["\xA8\xB1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2C\x3B"],
        ["\x2C\x3B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA8\xB1"],

        ["\xA8\xB2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2C\x47"],
        ["\x2C\x47",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA8\xB2"],

        ["\xA8\xB3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2C\x57"],
        ["\x2C\x57",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA8\xB3"],

        ["\xA8\xB4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2C\x4F"],
        ["\x2C\x4F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA8\xB4"],

        ["\xA8\xB5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2C\x5F"],
        ["\x2C\x5F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA8\xB5"],

        ["\xA8\xB6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2C\x6F"],
        ["\x2C\x6F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA8\xB6"],

        ["\xA8\xB7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2C\x44"],
        ["\x2C\x44",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA8\xB7"],

        ["\xA8\xB8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2C\x53"],
        ["\x2C\x53",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA8\xB8"],

        ["\xA8\xB9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2C\x4C"],
        ["\x2C\x4C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA8\xB9"],

        ["\xA8\xBA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2C\x5B"],
        ["\x2C\x5B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA8\xBA"],

        ["\xA8\xBB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2C\x63"],
        ["\x2C\x63",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA8\xBB"],

        ["\xA8\xBC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2C\x41"],
        ["\x2C\x41",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA8\xBC"],

        ["\xA8\xBD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2C\x54"],
        ["\x2C\x54",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA8\xBD"],

        ["\xA8\xBE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2C\x49"],
        ["\x2C\x49",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA8\xBE"],

        ["\xA8\xBF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2C\x5C"],
        ["\x2C\x5C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA8\xBF"],

        ["\xA8\xC0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2C\x66"],
        ["\x2C\x66",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA8\xC0"],

        ["\x31\xA7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2D\x21"],
        ["\x2D\x21",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\x31\xA7"],

        ["\x31\xA8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2D\x22"],
        ["\x2D\x22",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\x31\xA8"],

        ["\x31\xA9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2D\x23"],
        ["\x2D\x23",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\x31\xA9"],

        ["\x31\xAA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2D\x24"],
        ["\x2D\x24",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\x31\xAA"],

        ["\x31\xAB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2D\x25"],
        ["\x2D\x25",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\x31\xAB"],

        ["\x31\xAC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2D\x26"],
        ["\x2D\x26",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\x31\xAC"],

        ["\x31\xAD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2D\x27"],
        ["\x2D\x27",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\x31\xAD"],

        ["\x31\xAE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2D\x28"],
        ["\x2D\x28",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\x31\xAE"],

        ["\x31\xAF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2D\x29"],
        ["\x2D\x29",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\x31\xAF"],

        ["\x31\xB0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2D\x2A"],
        ["\x2D\x2A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\x31\xB0"],

        ["\x31\xB1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2D\x2B"],
        ["\x2D\x2B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\x31\xB1"],

        ["\x31\xB2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2D\x2C"],
        ["\x2D\x2C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\x31\xB2"],

        ["\x31\xB3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2D\x2D"],
        ["\x2D\x2D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\x31\xB3"],

        ["\x31\xB4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2D\x2E"],
        ["\x2D\x2E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\x31\xB4"],

        ["\x31\xB5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2D\x2F"],
        ["\x2D\x2F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\x31\xB5"],

        ["\x31\xB6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2D\x30"],
        ["\x2D\x30",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\x31\xB6"],

        ["\x31\xB7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2D\x31"],
        ["\x2D\x31",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\x31\xB7"],

        ["\x31\xB8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2D\x32"],
        ["\x2D\x32",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\x31\xB8"],

        ["\x31\xB9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2D\x33"],
        ["\x2D\x33",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\x31\xB9"],

        ["\x31\xBA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2D\x34"],
        ["\x2D\x34",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\x31\xBA"],

        ["\x31\xBB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2D\x35"],
        ["\x2D\x35",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\x31\xBB"],

        ["\x31\xBC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2D\x36"],
        ["\x2D\x36",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\x31\xBC"],

        ["\x31\xBD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2D\x37"],
        ["\x2D\x37",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\x31\xBD"],

        ["\x31\xBE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2D\x38"],
        ["\x2D\x38",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\x31\xBE"],

        ["\x31\xBF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2D\x39"],
        ["\x2D\x39",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\x31\xBF"],

        ["\x31\xC0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2D\x3A"],
        ["\x2D\x3A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\x31\xC0"],

        ["\x31\xC1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2D\x3B"],
        ["\x2D\x3B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\x31\xC1"],

        ["\x31\xC2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2D\x3C"],
        ["\x2D\x3C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\x31\xC2"],

        ["\x31\xC3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2D\x3D"],
        ["\x2D\x3D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\x31\xC3"],

        ["\x31\xC4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2D\x3E"],
        ["\x2D\x3E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\x31\xC4"],

        ["\x31\xC5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2D\x40"],
        ["\x2D\x40",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\x31\xC5"],

        ["\x31\xC6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2D\x41"],
        ["\x2D\x41",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\x31\xC6"],

        ["\x31\xC7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2D\x42"],
        ["\x2D\x42",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\x31\xC7"],

        ["\x31\xC8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2D\x43"],
        ["\x2D\x43",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\x31\xC8"],

        ["\x31\xC9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2D\x44"],
        ["\x2D\x44",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\x31\xC9"],

        ["\x31\xCA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2D\x45"],
        ["\x2D\x45",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\x31\xCA"],

        ["\x31\xCB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2D\x46"],
        ["\x2D\x46",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\x31\xCB"],

        ["\x31\xCC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2D\x47"],
        ["\x2D\x47",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\x31\xCC"],

        ["\x31\xCD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2D\x48"],
        ["\x2D\x48",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\x31\xCD"],

        ["\x31\xCE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2D\x49"],
        ["\x2D\x49",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\x31\xCE"],

        ["\x31\xCF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2D\x4A"],
        ["\x2D\x4A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\x31\xCF"],

        ["\x31\xD0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2D\x4B"],
        ["\x2D\x4B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\x31\xD0"],

        ["\x31\xD1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2D\x4C"],
        ["\x2D\x4C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\x31\xD1"],

        ["\x31\xD2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2D\x4D"],
        ["\x2D\x4D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\x31\xD2"],

        ["\x31\xD3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2D\x4E"],
        ["\x2D\x4E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\x31\xD3"],

        ["\x31\xD4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2D\x4F"],
        ["\x2D\x4F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\x31\xD4"],

        ["\x31\xD5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2D\x50"],
        ["\x2D\x50",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\x31\xD5"],

        ["\x31\xD6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2D\x51"],
        ["\x2D\x51",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\x31\xD6"],

        ["\x31\xD7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2D\x52"],
        ["\x2D\x52",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\x31\xD7"],

        ["\x31\xD8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2D\x53"],
        ["\x2D\x53",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\x31\xD8"],

        ["\x31\xD9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2D\x54"],
        ["\x2D\x54",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\x31\xD9"],

        ["\x31\xDA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2D\x55"],
        ["\x2D\x55",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\x31\xDA"],

        ["\x31\xDB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2D\x56"],
        ["\x2D\x56",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\x31\xDB"],

        ["\x31\xDC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2D\x5F"],
        ["\x2D\x5F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\x31\xDC"],

        ["\x31\xDD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2D\x60"],
        ["\x2D\x60",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\x31\xDD"],

        ["\x31\xDE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2D\x61"],
        ["\x2D\x61",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\x31\xDE"],

        ["\xA2\x71",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2D\x62"],
        ["\x2D\x62",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xA2\x71"],

        ["\x31\xDF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2D\x63"],
        ["\x2D\x63",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\x31\xDF"],

        ["\x31\xE0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2D\x64"],
        ["\x2D\x64",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\x31\xE0"],

        ["\x31\xE1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2D\x65"],
        ["\x2D\x65",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\x31\xE1"],

        ["\x31\xE2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2D\x66"],
        ["\x2D\x66",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\x31\xE2"],

        ["\x31\xE3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2D\x67"],
        ["\x2D\x67",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\x31\xE3"],

        ["\x31\xE4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2D\x68"],
        ["\x2D\x68",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\x31\xE4"],

        ["\x31\xE5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2D\x69"],
        ["\x2D\x69",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\x31\xE5"],

        ["\x31\xE6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2D\x6A"],
        ["\x2D\x6A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\x31\xE6"],

        ["\x31\xE7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2D\x6B"],
        ["\x2D\x6B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\x31\xE7"],

        ["\x31\xE8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2D\x6C"],
        ["\x2D\x6C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\x31\xE8"],

        ["\x31\xE9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2D\x6D"],
        ["\x2D\x6D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\x31\xE9"],

        ["\x31\xEA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2D\x6E"],
        ["\x2D\x6E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\x31\xEA"],

        ["\x31\xEB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2D\x6F"],
        ["\x2D\x6F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\x31\xEB"],

        ["\x31\xEC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2D\x73"],
        ["\x2D\x73",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\x31\xEC"],

        ["\x31\xED",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2D\x74"],
        ["\x2D\x74",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\x31\xED"],

        ["\x31\xEE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2D\x78"],
        ["\x2D\x78",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\x31\xEE"],

        ["\x31\xEF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x2D\x79"],
        ["\x2D\x79",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\x31\xEF"],

        ["\xB0\xA1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x30\x21"],
        ["\x30\x21",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xA1"],

        ["\xB0\xA2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x30\x22"],
        ["\x30\x22",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xA2"],

        ["\xB0\xA3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x30\x23"],
        ["\x30\x23",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xA3"],

        ["\xB0\xA4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x30\x24"],
        ["\x30\x24",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xA4"],

        ["\xB0\xA5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x30\x25"],
        ["\x30\x25",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xA5"],

        ["\xB0\xA6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x30\x26"],
        ["\x30\x26",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xA6"],

        ["\xB0\xA7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x30\x27"],
        ["\x30\x27",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xA7"],

        ["\xB0\xA8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x30\x28"],
        ["\x30\x28",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xA8"],

        ["\xB0\xA9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x30\x29"],
        ["\x30\x29",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xA9"],

        ["\xB0\xAA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x30\x2A"],
        ["\x30\x2A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xAA"],

        ["\xB0\xAB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x30\x2B"],
        ["\x30\x2B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xAB"],

        ["\xB0\xAC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x30\x2C"],
        ["\x30\x2C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xAC"],

        ["\xB0\xAD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x30\x2D"],
        ["\x30\x2D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xAD"],

        ["\xB0\xAE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x30\x2E"],
        ["\x30\x2E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xAE"],

        ["\xB0\xAF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x30\x2F"],
        ["\x30\x2F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xAF"],

        ["\xB0\xB0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x30\x30"],
        ["\x30\x30",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xB0"],

        ["\xB0\xB1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x30\x31"],
        ["\x30\x31",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xB1"],

        ["\xB0\xB2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x30\x32"],
        ["\x30\x32",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xB2"],

        ["\xB0\xB3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x4D"],
        ["\x72\x4D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xB3"],

        ["\xB0\xB4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x30\x34"],
        ["\x30\x34",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xB4"],

        ["\xB0\xB5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x30\x35"],
        ["\x30\x35",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xB5"],

        ["\xB0\xB6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x30\x36"],
        ["\x30\x36",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xB6"],

        ["\xB0\xB7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x30\x37"],
        ["\x30\x37",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xB7"],

        ["\xB0\xB8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x30\x38"],
        ["\x30\x38",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xB8"],

        ["\xB0\xB9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x30\x39"],
        ["\x30\x39",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xB9"],

        ["\xB0\xBA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x30\x3A"],
        ["\x30\x3A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xBA"],

        ["\xB0\xBB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x30\x3B"],
        ["\x30\x3B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xBB"],

        ["\xB0\xBC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x30\x3C"],
        ["\x30\x3C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xBC"],

        ["\xB0\xBD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x30\x3D"],
        ["\x30\x3D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xBD"],

        ["\xB0\xBE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x30\x3E"],
        ["\x30\x3E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xBE"],

        ["\xB0\xBF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x30\x3F"],
        ["\x30\x3F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xBF"],

        ["\xB0\xC0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x30\x40"],
        ["\x30\x40",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xC0"],

        ["\xB0\xC1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x30\x41"],
        ["\x30\x41",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xC1"],

        ["\xB0\xC2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x30\x42"],
        ["\x30\x42",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xC2"],

        ["\xB0\xC3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x30\x43"],
        ["\x30\x43",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xC3"],

        ["\xB0\xC4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x30\x44"],
        ["\x30\x44",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xC4"],

        ["\xB0\xC5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x30\x45"],
        ["\x30\x45",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xC5"],

        ["\xB0\xC6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x30\x46"],
        ["\x30\x46",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xC6"],

        ["\xB0\xC7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x30\x47"],
        ["\x30\x47",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xC7"],

        ["\xB0\xC8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x30\x48"],
        ["\x30\x48",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xC8"],

        ["\xB0\xC9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x30\x49"],
        ["\x30\x49",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xC9"],

        ["\xB0\xCA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x30\x4A"],
        ["\x30\x4A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xCA"],

        ["\xB0\xCB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x30\x4B"],
        ["\x30\x4B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xCB"],

        ["\xB0\xCC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x30\x4C"],
        ["\x30\x4C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xCC"],

        ["\xB0\xCD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x30\x4D"],
        ["\x30\x4D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xCD"],

        ["\xB0\xCE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x30\x4E"],
        ["\x30\x4E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xCE"],

        ["\xB0\xCF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x30\x4F"],
        ["\x30\x4F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xCF"],

        ["\xB0\xD0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x30\x50"],
        ["\x30\x50",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xD0"],

        ["\xB0\xD1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x30\x51"],
        ["\x30\x51",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xD1"],

        ["\xB0\xD2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x30\x52"],
        ["\x30\x52",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xD2"],

        ["\xB0\xD3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x30\x53"],
        ["\x30\x53",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xD3"],

        ["\xB0\xD4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x30\x54"],
        ["\x30\x54",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xD4"],

        ["\xB0\xD5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x30\x55"],
        ["\x30\x55",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xD5"],

        ["\xB0\xD6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x30\x56"],
        ["\x30\x56",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xD6"],

        ["\xB0\xD7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x30\x57"],
        ["\x30\x57",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xD7"],

        ["\xB0\xD8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x30\x58"],
        ["\x30\x58",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xD8"],

        ["\xB0\xD9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x30\x59"],
        ["\x30\x59",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xD9"],

        ["\xB0\xDA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x30\x5A"],
        ["\x30\x5A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xDA"],

        ["\xB0\xDB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x30\x5B"],
        ["\x30\x5B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xDB"],

        ["\xB0\xDC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x30\x5C"],
        ["\x30\x5C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xDC"],

        ["\xB0\xDD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x30\x5D"],
        ["\x30\x5D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xDD"],

        ["\xB0\xDE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x30\x5E"],
        ["\x30\x5E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xDE"],

        ["\xB0\xDF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x30\x5F"],
        ["\x30\x5F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xDF"],

        ["\xB0\xE0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x30\x60"],
        ["\x30\x60",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xE0"],

        ["\xB0\xE1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x30\x61"],
        ["\x30\x61",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xE1"],

        ["\xB0\xE2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x30\x62"],
        ["\x30\x62",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xE2"],

        ["\xB0\xE3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x30\x63"],
        ["\x30\x63",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xE3"],

        ["\xB0\xE4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x30\x64"],
        ["\x30\x64",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xE4"],

        ["\xB0\xE5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x30\x65"],
        ["\x30\x65",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xE5"],

        ["\xB0\xE6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x30\x66"],
        ["\x30\x66",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xE6"],

        ["\xB0\xE7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x30\x67"],
        ["\x30\x67",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xE7"],

        ["\xB0\xE8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x30\x68"],
        ["\x30\x68",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xE8"],

        ["\xB0\xE9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x30\x69"],
        ["\x30\x69",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xE9"],

        ["\xB0\xEA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x30\x6A"],
        ["\x30\x6A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xEA"],

        ["\xB0\xEB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x30\x6B"],
        ["\x30\x6B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xEB"],

        ["\xB0\xEC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x30\x6C"],
        ["\x30\x6C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xEC"],

        ["\xB0\xED",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x30\x6D"],
        ["\x30\x6D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xED"],

        ["\xB0\xEE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x30\x6E"],
        ["\x30\x6E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xEE"],

        ["\xB0\xEF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x30\x6F"],
        ["\x30\x6F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xEF"],

        ["\xB0\xF0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x30\x70"],
        ["\x30\x70",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xF0"],

        ["\xB0\xF1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x30\x71"],
        ["\x30\x71",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xF1"],

        ["\xB0\xF2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x30\x72"],
        ["\x30\x72",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xF2"],

        ["\xB0\xF3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x30\x73"],
        ["\x30\x73",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xF3"],

        ["\xB0\xF4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x30\x74"],
        ["\x30\x74",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xF4"],

        ["\xB0\xF5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x30\x75"],
        ["\x30\x75",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xF5"],

        ["\xB0\xF6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x30\x76"],
        ["\x30\x76",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xF6"],

        ["\xB0\xF7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x30\x77"],
        ["\x30\x77",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xF7"],

        ["\xB0\xF8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x30\x78"],
        ["\x30\x78",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xF8"],

        ["\xB0\xF9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x30\x79"],
        ["\x30\x79",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xF9"],

        ["\xB0\xFA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x30\x7A"],
        ["\x30\x7A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xFA"],

        ["\xB0\xFB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x30\x7B"],
        ["\x30\x7B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xFB"],

        ["\xB0\xFC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x30\x7C"],
        ["\x30\x7C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xFC"],

        ["\xB0\xFD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x30\x7D"],
        ["\x30\x7D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xFD"],

        ["\xB0\xFE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x30\x7E"],
        ["\x30\x7E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\xFE"],

        ["\xB1\xA1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x31\x21"],
        ["\x31\x21",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xA1"],

        ["\xB1\xA2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x31\x22"],
        ["\x31\x22",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xA2"],

        ["\xB1\xA3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x31\x23"],
        ["\x31\x23",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xA3"],

        ["\xB1\xA4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x31\x24"],
        ["\x31\x24",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xA4"],

        ["\xB1\xA5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x31\x25"],
        ["\x31\x25",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xA5"],

        ["\xB1\xA6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x31\x26"],
        ["\x31\x26",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xA6"],

        ["\xB1\xA7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x31\x27"],
        ["\x31\x27",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xA7"],

        ["\xB1\xA8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x31\x28"],
        ["\x31\x28",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xA8"],

        ["\xB1\xA9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x31\x29"],
        ["\x31\x29",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xA9"],

        ["\xB1\xAA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x31\x2A"],
        ["\x31\x2A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xAA"],

        ["\xB1\xAB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x31\x2B"],
        ["\x31\x2B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xAB"],

        ["\xB1\xAC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x31\x2C"],
        ["\x31\x2C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xAC"],

        ["\xB1\xAD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x31\x2D"],
        ["\x31\x2D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xAD"],

        ["\xB1\xAE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x31\x2E"],
        ["\x31\x2E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xAE"],

        ["\xB1\xAF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x31\x2F"],
        ["\x31\x2F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xAF"],

        ["\xB1\xB0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x31\x30"],
        ["\x31\x30",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xB0"],

        ["\xB1\xB1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x31\x31"],
        ["\x31\x31",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xB1"],

        ["\xB1\xB2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x31\x32"],
        ["\x31\x32",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xB2"],

        ["\xB1\xB3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x31\x33"],
        ["\x31\x33",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xB3"],

        ["\xB1\xB4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x31\x34"],
        ["\x31\x34",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xB4"],

        ["\xB1\xB5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x31\x35"],
        ["\x31\x35",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xB5"],

        ["\xB1\xB6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x31\x36"],
        ["\x31\x36",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xB6"],

        ["\xB1\xB7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x31\x37"],
        ["\x31\x37",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xB7"],

        ["\xB1\xB8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x31\x38"],
        ["\x31\x38",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xB8"],

        ["\xB1\xB9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x31\x39"],
        ["\x31\x39",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xB9"],

        ["\xB1\xBA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x31\x3A"],
        ["\x31\x3A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xBA"],

        ["\xB1\xBB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x31\x3B"],
        ["\x31\x3B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xBB"],

        ["\xB1\xBC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x31\x3C"],
        ["\x31\x3C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xBC"],

        ["\xB1\xBD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x31\x3D"],
        ["\x31\x3D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xBD"],

        ["\xB1\xBE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x31\x3E"],
        ["\x31\x3E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xBE"],

        ["\xB1\xBF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x31\x3F"],
        ["\x31\x3F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xBF"],

        ["\xB1\xC0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x31\x40"],
        ["\x31\x40",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xC0"],

        ["\xB1\xC1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x31\x41"],
        ["\x31\x41",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xC1"],

        ["\xB1\xC2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x31\x42"],
        ["\x31\x42",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xC2"],

        ["\xB1\xC3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x31\x43"],
        ["\x31\x43",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xC3"],

        ["\xB1\xC4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x31\x44"],
        ["\x31\x44",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xC4"],

        ["\xB1\xC5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x31\x45"],
        ["\x31\x45",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xC5"],

        ["\xB1\xC6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x31\x46"],
        ["\x31\x46",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xC6"],

        ["\xB1\xC7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x31\x47"],
        ["\x31\x47",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xC7"],

        ["\xB1\xC8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x31\x48"],
        ["\x31\x48",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xC8"],

        ["\xB1\xC9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x31\x49"],
        ["\x31\x49",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xC9"],

        ["\xB1\xCA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x31\x4A"],
        ["\x31\x4A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xCA"],

        ["\xB1\xCB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x31\x4B"],
        ["\x31\x4B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xCB"],

        ["\xB1\xCC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x31\x4C"],
        ["\x31\x4C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xCC"],

        ["\xB1\xCD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x31\x4D"],
        ["\x31\x4D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xCD"],

        ["\xB1\xCE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x31\x4E"],
        ["\x31\x4E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xCE"],

        ["\xB1\xCF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x31\x4F"],
        ["\x31\x4F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xCF"],

        ["\xB1\xD0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x31\x50"],
        ["\x31\x50",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xD0"],

        ["\xB1\xD1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x31\x51"],
        ["\x31\x51",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xD1"],

        ["\xB1\xD2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x31\x52"],
        ["\x31\x52",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xD2"],

        ["\xB1\xD3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x31\x53"],
        ["\x31\x53",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xD3"],

        ["\xB1\xD4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x31\x54"],
        ["\x31\x54",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xD4"],

        ["\xB1\xD5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x31\x55"],
        ["\x31\x55",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xD5"],

        ["\xB1\xD6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x31\x56"],
        ["\x31\x56",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xD6"],

        ["\xB1\xD7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x31\x57"],
        ["\x31\x57",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xD7"],

        ["\xB1\xD8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x31\x58"],
        ["\x31\x58",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xD8"],

        ["\xB1\xD9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x31\x59"],
        ["\x31\x59",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xD9"],

        ["\xB1\xDA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x31\x5A"],
        ["\x31\x5A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xDA"],

        ["\xB1\xDB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x31\x5B"],
        ["\x31\x5B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xDB"],

        ["\xB1\xDC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x31\x5C"],
        ["\x31\x5C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xDC"],

        ["\xB1\xDD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x31\x5D"],
        ["\x31\x5D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xDD"],

        ["\xB1\xDE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x31\x5E"],
        ["\x31\x5E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xDE"],

        ["\xB1\xDF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x31\x5F"],
        ["\x31\x5F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xDF"],

        ["\xB1\xE0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x31\x60"],
        ["\x31\x60",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xE0"],

        ["\xB1\xE1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x31\x61"],
        ["\x31\x61",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xE1"],

        ["\xB1\xE2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x31\x62"],
        ["\x31\x62",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xE2"],

        ["\xB1\xE3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x31\x63"],
        ["\x31\x63",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xE3"],

        ["\xB1\xE4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x31\x64"],
        ["\x31\x64",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xE4"],

        ["\xB1\xE5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x31\x65"],
        ["\x31\x65",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xE5"],

        ["\xB1\xE6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x31\x66"],
        ["\x31\x66",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xE6"],

        ["\xB1\xE7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x31\x67"],
        ["\x31\x67",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xE7"],

        ["\xB1\xE8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x31\x68"],
        ["\x31\x68",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xE8"],

        ["\xB1\xE9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x31\x69"],
        ["\x31\x69",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xE9"],

        ["\xB1\xEA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x31\x6A"],
        ["\x31\x6A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xEA"],

        ["\xB1\xEB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x31\x6B"],
        ["\x31\x6B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xEB"],

        ["\xB1\xEC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x31\x6C"],
        ["\x31\x6C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xEC"],

        ["\xB1\xED",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x31\x6D"],
        ["\x31\x6D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xED"],

        ["\xB1\xEE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x31\x6E"],
        ["\x31\x6E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xEE"],

        ["\xB1\xEF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x31\x6F"],
        ["\x31\x6F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xEF"],

        ["\xB1\xF0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x31\x70"],
        ["\x31\x70",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xF0"],

        ["\xB1\xF1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x31\x71"],
        ["\x31\x71",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xF1"],

        ["\xB1\xF2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x31\x72"],
        ["\x31\x72",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xF2"],

        ["\xB1\xF3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x31\x73"],
        ["\x31\x73",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xF3"],

        ["\xB1\xF4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x31\x74"],
        ["\x31\x74",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xF4"],

        ["\xB1\xF5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x31\x75"],
        ["\x31\x75",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xF5"],

        ["\xB1\xF6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x31\x76"],
        ["\x31\x76",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xF6"],

        ["\xB1\xF7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x31\x77"],
        ["\x31\x77",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xF7"],

        ["\xB1\xF8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x31\x78"],
        ["\x31\x78",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xF8"],

        ["\xB1\xF9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x31\x79"],
        ["\x31\x79",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xF9"],

        ["\xB1\xFA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x31\x7A"],
        ["\x31\x7A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xFA"],

        ["\xB1\xFB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x31\x7B"],
        ["\x31\x7B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xFB"],

        ["\xB1\xFC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x31\x7C"],
        ["\x31\x7C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xFC"],

        ["\xB1\xFD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x31\x7D"],
        ["\x31\x7D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xFD"],

        ["\xB1\xFE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x31\x7E"],
        ["\x31\x7E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\xFE"],

        ["\xB2\xA1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x32\x21"],
        ["\x32\x21",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xA1"],

        ["\xB2\xA2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x32\x22"],
        ["\x32\x22",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xA2"],

        ["\xB2\xA3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x32\x23"],
        ["\x32\x23",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xA3"],

        ["\xB2\xA4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x32\x24"],
        ["\x32\x24",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xA4"],

        ["\xB2\xA5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x32\x25"],
        ["\x32\x25",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xA5"],

        ["\xB2\xA6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x32\x26"],
        ["\x32\x26",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xA6"],

        ["\xB2\xA7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x32\x27"],
        ["\x32\x27",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xA7"],

        ["\xB2\xA8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x32\x28"],
        ["\x32\x28",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xA8"],

        ["\xB2\xA9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x74"],
        ["\x72\x74",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xA9"],

        ["\xB2\xAA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x32\x2A"],
        ["\x32\x2A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xAA"],

        ["\xB2\xAB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x32\x2B"],
        ["\x32\x2B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xAB"],

        ["\xB2\xAC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x32\x2C"],
        ["\x32\x2C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xAC"],

        ["\xB2\xAD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x32\x2D"],
        ["\x32\x2D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xAD"],

        ["\xB2\xAE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x32\x2E"],
        ["\x32\x2E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xAE"],

        ["\xB2\xAF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x32\x2F"],
        ["\x32\x2F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xAF"],

        ["\xB2\xB0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x32\x30"],
        ["\x32\x30",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xB0"],

        ["\xB2\xB1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x32\x31"],
        ["\x32\x31",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xB1"],

        ["\xB2\xB2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x32\x32"],
        ["\x32\x32",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xB2"],

        ["\xB2\xB3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x32\x33"],
        ["\x32\x33",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xB3"],

        ["\xB2\xB4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x32\x34"],
        ["\x32\x34",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xB4"],

        ["\xB2\xB5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x32\x35"],
        ["\x32\x35",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xB5"],

        ["\xB2\xB6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x32\x36"],
        ["\x32\x36",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xB6"],

        ["\xB2\xB7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x32\x37"],
        ["\x32\x37",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xB7"],

        ["\xB2\xB8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x32\x38"],
        ["\x32\x38",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xB8"],

        ["\xB2\xB9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x32\x39"],
        ["\x32\x39",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xB9"],

        ["\xB2\xBA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x32\x3A"],
        ["\x32\x3A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xBA"],

        ["\xB2\xBB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x32\x3B"],
        ["\x32\x3B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xBB"],

        ["\xB2\xBC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x32\x3C"],
        ["\x32\x3C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xBC"],

        ["\xB2\xBD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x32\x3D"],
        ["\x32\x3D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xBD"],

        ["\xB2\xBE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x32\x3E"],
        ["\x32\x3E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xBE"],

        ["\xB2\xBF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x32\x3F"],
        ["\x32\x3F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xBF"],

        ["\xB2\xC0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x32\x40"],
        ["\x32\x40",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xC0"],

        ["\xB2\xC1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x32\x41"],
        ["\x32\x41",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xC1"],

        ["\xB2\xC2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x32\x42"],
        ["\x32\x42",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xC2"],

        ["\xB2\xC3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x32\x43"],
        ["\x32\x43",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xC3"],

        ["\xB2\xC4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x32\x44"],
        ["\x32\x44",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xC4"],

        ["\xB2\xC5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x32\x45"],
        ["\x32\x45",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xC5"],

        ["\xB2\xC6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x32\x46"],
        ["\x32\x46",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xC6"],

        ["\xB2\xC7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x32\x47"],
        ["\x32\x47",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xC7"],

        ["\xB2\xC8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x32\x48"],
        ["\x32\x48",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xC8"],

        ["\xB2\xC9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x32\x49"],
        ["\x32\x49",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xC9"],

        ["\xB2\xCA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x32\x4A"],
        ["\x32\x4A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xCA"],

        ["\xB2\xCB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x32\x4B"],
        ["\x32\x4B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xCB"],

        ["\xB2\xCC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x32\x4C"],
        ["\x32\x4C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xCC"],

        ["\xB2\xCD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x32\x4D"],
        ["\x32\x4D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xCD"],

        ["\xB2\xCE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x32\x4E"],
        ["\x32\x4E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xCE"],

        ["\xB2\xCF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x32\x4F"],
        ["\x32\x4F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xCF"],

        ["\xB2\xD0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x32\x50"],
        ["\x32\x50",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xD0"],

        ["\xB2\xD1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x32\x51"],
        ["\x32\x51",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xD1"],

        ["\xB2\xD2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x32\x52"],
        ["\x32\x52",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xD2"],

        ["\xB2\xD3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x32\x53"],
        ["\x32\x53",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xD3"],

        ["\xB2\xD4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x32\x54"],
        ["\x32\x54",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xD4"],

        ["\xB2\xD5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x32\x55"],
        ["\x32\x55",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xD5"],

        ["\xB2\xD6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x32\x56"],
        ["\x32\x56",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xD6"],

        ["\xB2\xD7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x32\x57"],
        ["\x32\x57",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xD7"],

        ["\xB2\xD8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x32\x58"],
        ["\x32\x58",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xD8"],

        ["\xB2\xD9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x32\x59"],
        ["\x32\x59",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xD9"],

        ["\xB2\xDA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x32\x5A"],
        ["\x32\x5A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xDA"],

        ["\xB2\xDB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x32\x5B"],
        ["\x32\x5B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xDB"],

        ["\xB2\xDC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x32\x5C"],
        ["\x32\x5C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xDC"],

        ["\xB2\xDD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x32\x5D"],
        ["\x32\x5D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xDD"],

        ["\xB2\xDE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x32\x5E"],
        ["\x32\x5E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xDE"],

        ["\xB2\xDF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x32\x5F"],
        ["\x32\x5F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xDF"],

        ["\xB2\xE0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x32\x60"],
        ["\x32\x60",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xE0"],

        ["\xB2\xE1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x32\x61"],
        ["\x32\x61",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xE1"],

        ["\xB2\xE2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x32\x62"],
        ["\x32\x62",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xE2"],

        ["\xB2\xE3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x32\x63"],
        ["\x32\x63",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xE3"],

        ["\xB2\xE4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x32\x64"],
        ["\x32\x64",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xE4"],

        ["\xB2\xE5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x32\x65"],
        ["\x32\x65",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xE5"],

        ["\xB2\xE6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x32\x66"],
        ["\x32\x66",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xE6"],

        ["\xB2\xE7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x32\x67"],
        ["\x32\x67",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xE7"],

        ["\xB2\xE8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x32\x68"],
        ["\x32\x68",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xE8"],

        ["\xB2\xE9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x32\x69"],
        ["\x32\x69",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xE9"],

        ["\xB2\xEA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x32\x6A"],
        ["\x32\x6A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xEA"],

        ["\xB2\xEB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x32\x6B"],
        ["\x32\x6B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xEB"],

        ["\xB2\xEC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x32\x6C"],
        ["\x32\x6C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xEC"],

        ["\xB2\xED",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x32\x6D"],
        ["\x32\x6D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xED"],

        ["\xB2\xEE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x32\x6E"],
        ["\x32\x6E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xEE"],

        ["\xB2\xEF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x32\x6F"],
        ["\x32\x6F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xEF"],

        ["\xB2\xF0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x32\x70"],
        ["\x32\x70",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xF0"],

        ["\xB2\xF1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x32\x71"],
        ["\x32\x71",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xF1"],

        ["\xB2\xF2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x32\x72"],
        ["\x32\x72",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xF2"],

        ["\xB2\xF3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x32\x73"],
        ["\x32\x73",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xF3"],

        ["\xB2\xF4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x32\x74"],
        ["\x32\x74",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xF4"],

        ["\xB2\xF5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x32\x75"],
        ["\x32\x75",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xF5"],

        ["\xB2\xF6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x32\x76"],
        ["\x32\x76",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xF6"],

        ["\xB2\xF7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x32\x77"],
        ["\x32\x77",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xF7"],

        ["\xB2\xF8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x32\x78"],
        ["\x32\x78",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xF8"],

        ["\xB2\xF9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x32\x79"],
        ["\x32\x79",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xF9"],

        ["\xB2\xFA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x32\x7A"],
        ["\x32\x7A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xFA"],

        ["\xB2\xFB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x32\x7B"],
        ["\x32\x7B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xFB"],

        ["\xB2\xFC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x32\x7C"],
        ["\x32\x7C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xFC"],

        ["\xB2\xFD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x32\x7D"],
        ["\x32\x7D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xFD"],

        ["\xB2\xFE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x32\x7E"],
        ["\x32\x7E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xFE"],

        ["\xB3\xA1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x33\x21"],
        ["\x33\x21",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xA1"],

        ["\xB3\xA2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x33\x22"],
        ["\x33\x22",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xA2"],

        ["\xB3\xA3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x33\x23"],
        ["\x33\x23",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xA3"],

        ["\xB3\xA4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x33\x24"],
        ["\x33\x24",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xA4"],

        ["\xB3\xA5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x33\x25"],
        ["\x33\x25",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xA5"],

        ["\xB3\xA6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x33\x26"],
        ["\x33\x26",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xA6"],

        ["\xB3\xA7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x33\x27"],
        ["\x33\x27",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xA7"],

        ["\xB3\xA8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x33\x28"],
        ["\x33\x28",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xA8"],

        ["\xB3\xA9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x33\x29"],
        ["\x33\x29",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xA9"],

        ["\xB3\xAA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x33\x2A"],
        ["\x33\x2A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xAA"],

        ["\xB3\xAB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x33\x2B"],
        ["\x33\x2B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xAB"],

        ["\xB3\xAC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x33\x2C"],
        ["\x33\x2C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xAC"],

        ["\xB3\xAD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x33\x2D"],
        ["\x33\x2D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xAD"],

        ["\xB3\xAE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x33\x2E"],
        ["\x33\x2E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xAE"],

        ["\xB3\xAF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x33\x2F"],
        ["\x33\x2F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xAF"],

        ["\xB3\xB0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x33\x30"],
        ["\x33\x30",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xB0"],

        ["\xB3\xB1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x33\x31"],
        ["\x33\x31",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xB1"],

        ["\xB3\xB2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x33\x32"],
        ["\x33\x32",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xB2"],

        ["\xB3\xB3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x33\x33"],
        ["\x33\x33",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xB3"],

        ["\xB3\xB4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x33\x34"],
        ["\x33\x34",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xB4"],

        ["\xB3\xB5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x33\x35"],
        ["\x33\x35",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xB5"],

        ["\xB3\xB6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x33\x36"],
        ["\x33\x36",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xB6"],

        ["\xB3\xB7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x33\x37"],
        ["\x33\x37",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xB7"],

        ["\xB3\xB8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x33\x38"],
        ["\x33\x38",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xB8"],

        ["\xB3\xB9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x33\x39"],
        ["\x33\x39",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xB9"],

        ["\xB3\xBA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x33\x3A"],
        ["\x33\x3A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xBA"],

        ["\xB3\xBB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x33\x3B"],
        ["\x33\x3B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xBB"],

        ["\xB3\xBC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x33\x3C"],
        ["\x33\x3C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xBC"],

        ["\xB3\xBD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x33\x3D"],
        ["\x33\x3D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xBD"],

        ["\xB3\xBE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x33\x3E"],
        ["\x33\x3E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xBE"],

        ["\xB3\xBF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x33\x3F"],
        ["\x33\x3F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xBF"],

        ["\xB3\xC0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x33\x40"],
        ["\x33\x40",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xC0"],

        ["\xB3\xC1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x33\x41"],
        ["\x33\x41",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xC1"],

        ["\xB3\xC2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x5A"],
        ["\x69\x5A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xC2"],

        ["\xB3\xC3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x33\x43"],
        ["\x33\x43",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xC3"],

        ["\xB3\xC4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x33\x44"],
        ["\x33\x44",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xC4"],

        ["\xB3\xC5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x33\x45"],
        ["\x33\x45",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xC5"],

        ["\xB3\xC6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x33\x46"],
        ["\x33\x46",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xC6"],

        ["\xB3\xC7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x33\x47"],
        ["\x33\x47",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xC7"],

        ["\xB3\xC8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x33\x48"],
        ["\x33\x48",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xC8"],

        ["\xB3\xC9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x78"],
        ["\x59\x78",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xC9"],

        ["\xB3\xCA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x33\x4A"],
        ["\x33\x4A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xCA"],

        ["\xB3\xCB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x33\x4B"],
        ["\x33\x4B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xCB"],

        ["\xB3\xCC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x33\x4C"],
        ["\x33\x4C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xCC"],

        ["\xB3\xCD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x33\x4D"],
        ["\x33\x4D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xCD"],

        ["\xB3\xCE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x33\x4E"],
        ["\x33\x4E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xCE"],

        ["\xB3\xCF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x33\x4F"],
        ["\x33\x4F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xCF"],

        ["\xB3\xD0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x33\x50"],
        ["\x33\x50",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xD0"],

        ["\xB3\xD1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x33\x51"],
        ["\x33\x51",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xD1"],

        ["\xB3\xD2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x33\x52"],
        ["\x33\x52",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xD2"],

        ["\xB3\xD3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x33\x53"],
        ["\x33\x53",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xD3"],

        ["\xB3\xD4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x33\x54"],
        ["\x33\x54",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xD4"],

        ["\xB3\xD5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x33\x55"],
        ["\x33\x55",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xD5"],

        ["\xB3\xD6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x33\x56"],
        ["\x33\x56",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xD6"],

        ["\xB3\xD7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x33\x57"],
        ["\x33\x57",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xD7"],

        ["\xB3\xD8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x33\x58"],
        ["\x33\x58",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xD8"],

        ["\xB3\xD9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x33\x59"],
        ["\x33\x59",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xD9"],

        ["\xB3\xDA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x33\x5A"],
        ["\x33\x5A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xDA"],

        ["\xB3\xDB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x33\x5B"],
        ["\x33\x5B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xDB"],

        ["\xB3\xDC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x33\x5C"],
        ["\x33\x5C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xDC"],

        ["\xB3\xDD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x33\x5D"],
        ["\x33\x5D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xDD"],

        ["\xB3\xDE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x33\x5E"],
        ["\x33\x5E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xDE"],

        ["\xB3\xDF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x33\x5F"],
        ["\x33\x5F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xDF"],

        ["\xB3\xE0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x33\x60"],
        ["\x33\x60",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xE0"],

        ["\xB3\xE1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x33\x61"],
        ["\x33\x61",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xE1"],

        ["\xB3\xE2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x33\x62"],
        ["\x33\x62",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xE2"],

        ["\xB3\xE3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x33\x63"],
        ["\x33\x63",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xE3"],

        ["\xB3\xE4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x33\x64"],
        ["\x33\x64",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xE4"],

        ["\xB3\xE5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x33\x65"],
        ["\x33\x65",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xE5"],

        ["\xB3\xE6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x33\x66"],
        ["\x33\x66",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xE6"],

        ["\xB3\xE7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x33\x67"],
        ["\x33\x67",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xE7"],

        ["\xB3\xE8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x33\x68"],
        ["\x33\x68",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xE8"],

        ["\xB3\xE9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x33\x69"],
        ["\x33\x69",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xE9"],

        ["\xB3\xEA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x33\x6A"],
        ["\x33\x6A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xEA"],

        ["\xB3\xEB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x33\x6B"],
        ["\x33\x6B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xEB"],

        ["\xB3\xEC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x33\x6C"],
        ["\x33\x6C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xEC"],

        ["\xB3\xED",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x33\x6D"],
        ["\x33\x6D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xED"],

        ["\xB3\xEE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x33\x6E"],
        ["\x33\x6E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xEE"],

        ["\xB3\xEF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x33\x6F"],
        ["\x33\x6F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xEF"],

        ["\xB3\xF0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x33\x70"],
        ["\x33\x70",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xF0"],

        ["\xB3\xF1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x33\x71"],
        ["\x33\x71",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xF1"],

        ["\xB3\xF2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x33\x72"],
        ["\x33\x72",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xF2"],

        ["\xB3\xF3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x33\x73"],
        ["\x33\x73",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xF3"],

        ["\xB3\xF4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x33\x74"],
        ["\x33\x74",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xF4"],

        ["\xB3\xF5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x33\x75"],
        ["\x33\x75",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xF5"],

        ["\xB3\xF6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x5E"],
        ["\x63\x5E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xF6"],

        ["\xB3\xF7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x33\x77"],
        ["\x33\x77",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xF7"],

        ["\xB3\xF8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x33\x78"],
        ["\x33\x78",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xF8"],

        ["\xB3\xF9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x33\x79"],
        ["\x33\x79",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xF9"],

        ["\xB3\xFA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x33\x7A"],
        ["\x33\x7A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xFA"],

        ["\xB3\xFB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x33\x7B"],
        ["\x33\x7B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xFB"],

        ["\xB3\xFC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x33\x7C"],
        ["\x33\x7C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xFC"],

        ["\xB3\xFD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x33\x7D"],
        ["\x33\x7D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xFD"],

        ["\xB3\xFE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x33\x7E"],
        ["\x33\x7E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xFE"],

        ["\xB4\xA1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x34\x21"],
        ["\x34\x21",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xA1"],

        ["\xB4\xA2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x34\x22"],
        ["\x34\x22",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xA2"],

        ["\xB4\xA3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x34\x23"],
        ["\x34\x23",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xA3"],

        ["\xB4\xA4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x34\x24"],
        ["\x34\x24",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xA4"],

        ["\xB4\xA5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x34\x25"],
        ["\x34\x25",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xA5"],

        ["\xB4\xA6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x34\x26"],
        ["\x34\x26",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xA6"],

        ["\xB4\xA7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x34\x27"],
        ["\x34\x27",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xA7"],

        ["\xB4\xA8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x34\x28"],
        ["\x34\x28",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xA8"],

        ["\xB4\xA9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x34\x29"],
        ["\x34\x29",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xA9"],

        ["\xB4\xAA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x34\x2A"],
        ["\x34\x2A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xAA"],

        ["\xB4\xAB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x34\x2B"],
        ["\x34\x2B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xAB"],

        ["\xB4\xAC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x34\x2C"],
        ["\x34\x2C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xAC"],

        ["\xB4\xAD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x34\x2D"],
        ["\x34\x2D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xAD"],

        ["\xB4\xAE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x34\x2E"],
        ["\x34\x2E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xAE"],

        ["\xB4\xAF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x34\x2F"],
        ["\x34\x2F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xAF"],

        ["\xB4\xB0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x34\x30"],
        ["\x34\x30",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xB0"],

        ["\xB4\xB1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x34\x31"],
        ["\x34\x31",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xB1"],

        ["\xB4\xB2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x34\x32"],
        ["\x34\x32",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xB2"],

        ["\xB4\xB3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x34\x33"],
        ["\x34\x33",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xB3"],

        ["\xB4\xB4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x34\x34"],
        ["\x34\x34",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xB4"],

        ["\xB4\xB5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x34\x35"],
        ["\x34\x35",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xB5"],

        ["\xB4\xB6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x34\x36"],
        ["\x34\x36",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xB6"],

        ["\xB4\xB7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x34\x37"],
        ["\x34\x37",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xB7"],

        ["\xB4\xB8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x34\x38"],
        ["\x34\x38",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xB8"],

        ["\xB4\xB9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x34\x39"],
        ["\x34\x39",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xB9"],

        ["\xB4\xBA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x34\x3A"],
        ["\x34\x3A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xBA"],

        ["\xB4\xBB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x34\x3B"],
        ["\x34\x3B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xBB"],

        ["\xB4\xBC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x34\x3C"],
        ["\x34\x3C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xBC"],

        ["\xB4\xBD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x34\x3D"],
        ["\x34\x3D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xBD"],

        ["\xB4\xBE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x34\x3E"],
        ["\x34\x3E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xBE"],

        ["\xB4\xBF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x34\x3F"],
        ["\x34\x3F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xBF"],

        ["\xB4\xC0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x34\x40"],
        ["\x34\x40",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xC0"],

        ["\xB4\xC1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x34\x41"],
        ["\x34\x41",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xC1"],

        ["\xB4\xC2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x34\x42"],
        ["\x34\x42",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xC2"],

        ["\xB4\xC3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x75"],
        ["\x5E\x75",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xC3"],

        ["\xB4\xC4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x34\x44"],
        ["\x34\x44",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xC4"],

        ["\xB4\xC5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x34\x45"],
        ["\x34\x45",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xC5"],

        ["\xB4\xC6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x34\x46"],
        ["\x34\x46",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xC6"],

        ["\xB4\xC7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x34\x47"],
        ["\x34\x47",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xC7"],

        ["\xB4\xC8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x34\x48"],
        ["\x34\x48",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xC8"],

        ["\xB4\xC9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x34\x49"],
        ["\x34\x49",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xC9"],

        ["\xB4\xCA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x34\x4A"],
        ["\x34\x4A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xCA"],

        ["\xB4\xCB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x34\x4B"],
        ["\x34\x4B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xCB"],

        ["\xB4\xCC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x34\x4C"],
        ["\x34\x4C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xCC"],

        ["\xB4\xCD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x34\x4D"],
        ["\x34\x4D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xCD"],

        ["\xB4\xCE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x34\x4E"],
        ["\x34\x4E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xCE"],

        ["\xB4\xCF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x34\x4F"],
        ["\x34\x4F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xCF"],

        ["\xB4\xD0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x34\x50"],
        ["\x34\x50",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xD0"],

        ["\xB4\xD1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x34\x51"],
        ["\x34\x51",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xD1"],

        ["\xB4\xD2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x5D"],
        ["\x6B\x5D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xD2"],

        ["\xB4\xD3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x34\x53"],
        ["\x34\x53",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xD3"],

        ["\xB4\xD4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x34\x54"],
        ["\x34\x54",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xD4"],

        ["\xB4\xD5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x34\x55"],
        ["\x34\x55",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xD5"],

        ["\xB4\xD6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x34\x56"],
        ["\x34\x56",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xD6"],

        ["\xB4\xD7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x34\x57"],
        ["\x34\x57",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xD7"],

        ["\xB4\xD8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x34\x58"],
        ["\x34\x58",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xD8"],

        ["\xB4\xD9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x34\x59"],
        ["\x34\x59",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xD9"],

        ["\xB4\xDA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x34\x5A"],
        ["\x34\x5A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xDA"],

        ["\xB4\xDB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x34\x5B"],
        ["\x34\x5B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xDB"],

        ["\xB4\xDC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x34\x5C"],
        ["\x34\x5C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xDC"],

        ["\xB4\xDD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x34\x5D"],
        ["\x34\x5D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xDD"],

        ["\xB4\xDE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x34\x5E"],
        ["\x34\x5E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xDE"],

        ["\xB4\xDF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x34\x5F"],
        ["\x34\x5F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xDF"],

        ["\xB4\xE0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x34\x60"],
        ["\x34\x60",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xE0"],

        ["\xB4\xE1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x34\x61"],
        ["\x34\x61",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xE1"],

        ["\xB4\xE2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x34\x62"],
        ["\x34\x62",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xE2"],

        ["\xB4\xE3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x34\x63"],
        ["\x34\x63",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xE3"],

        ["\xB4\xE4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x34\x64"],
        ["\x34\x64",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xE4"],

        ["\xB4\xE5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x34\x65"],
        ["\x34\x65",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xE5"],

        ["\xB4\xE6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x34\x66"],
        ["\x34\x66",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xE6"],

        ["\xB4\xE7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x34\x67"],
        ["\x34\x67",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xE7"],

        ["\xB4\xE8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x34\x68"],
        ["\x34\x68",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xE8"],

        ["\xB4\xE9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x34\x69"],
        ["\x34\x69",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xE9"],

        ["\xB4\xEA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x34\x6A"],
        ["\x34\x6A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xEA"],

        ["\xB4\xEB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x34\x6B"],
        ["\x34\x6B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xEB"],

        ["\xB4\xEC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x34\x6C"],
        ["\x34\x6C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xEC"],

        ["\xB4\xED",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x34\x6D"],
        ["\x34\x6D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xED"],

        ["\xB4\xEE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x34\x6E"],
        ["\x34\x6E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xEE"],

        ["\xB4\xEF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x34\x6F"],
        ["\x34\x6F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xEF"],

        ["\xB4\xF0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x34\x70"],
        ["\x34\x70",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xF0"],

        ["\xB4\xF1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x34\x71"],
        ["\x34\x71",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xF1"],

        ["\xB4\xF2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x34\x72"],
        ["\x34\x72",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xF2"],

        ["\xB4\xF3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x34\x73"],
        ["\x34\x73",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xF3"],

        ["\xB4\xF4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x34\x74"],
        ["\x34\x74",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xF4"],

        ["\xB4\xF5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x34\x75"],
        ["\x34\x75",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xF5"],

        ["\xB4\xF6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x34\x76"],
        ["\x34\x76",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xF6"],

        ["\xB4\xF7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x34\x77"],
        ["\x34\x77",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xF7"],

        ["\xB4\xF8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x34\x78"],
        ["\x34\x78",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xF8"],

        ["\xB4\xF9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x34\x79"],
        ["\x34\x79",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xF9"],

        ["\xB4\xFA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x34\x7A"],
        ["\x34\x7A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xFA"],

        ["\xB4\xFB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x34\x7B"],
        ["\x34\x7B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xFB"],

        ["\xB4\xFC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x34\x7C"],
        ["\x34\x7C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xFC"],

        ["\xB4\xFD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x34\x7D"],
        ["\x34\x7D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xFD"],

        ["\xB4\xFE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x34\x7E"],
        ["\x34\x7E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xFE"],

        ["\xB5\xA1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x35\x21"],
        ["\x35\x21",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xA1"],

        ["\xB5\xA2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x35\x22"],
        ["\x35\x22",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xA2"],

        ["\xB5\xA3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x35\x23"],
        ["\x35\x23",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xA3"],

        ["\xB5\xA4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x35\x24"],
        ["\x35\x24",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xA4"],

        ["\xB5\xA5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x35\x25"],
        ["\x35\x25",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xA5"],

        ["\xB5\xA6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x35\x26"],
        ["\x35\x26",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xA6"],

        ["\xB5\xA7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x35\x27"],
        ["\x35\x27",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xA7"],

        ["\xB5\xA8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x35\x28"],
        ["\x35\x28",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xA8"],

        ["\xB5\xA9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x35\x29"],
        ["\x35\x29",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xA9"],

        ["\xB5\xAA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x35\x2A"],
        ["\x35\x2A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xAA"],

        ["\xB5\xAB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x35\x2B"],
        ["\x35\x2B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xAB"],

        ["\xB5\xAC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x35\x2C"],
        ["\x35\x2C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xAC"],

        ["\xB5\xAD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x35\x2D"],
        ["\x35\x2D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xAD"],

        ["\xB5\xAE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x35\x2E"],
        ["\x35\x2E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xAE"],

        ["\xB5\xAF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x35\x2F"],
        ["\x35\x2F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xAF"],

        ["\xB5\xB0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x35\x30"],
        ["\x35\x30",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xB0"],

        ["\xB5\xB1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x35\x31"],
        ["\x35\x31",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xB1"],

        ["\xB5\xB2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x35\x32"],
        ["\x35\x32",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xB2"],

        ["\xB5\xB3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x35\x33"],
        ["\x35\x33",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xB3"],

        ["\xB5\xB4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x35\x34"],
        ["\x35\x34",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xB4"],

        ["\xB5\xB5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x35\x35"],
        ["\x35\x35",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xB5"],

        ["\xB5\xB6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x35\x36"],
        ["\x35\x36",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xB6"],

        ["\xB5\xB7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x35\x37"],
        ["\x35\x37",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xB7"],

        ["\xB5\xB8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x35\x38"],
        ["\x35\x38",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xB8"],

        ["\xB5\xB9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x35\x39"],
        ["\x35\x39",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xB9"],

        ["\xB5\xBA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x35\x3A"],
        ["\x35\x3A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xBA"],

        ["\xB5\xBB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x35\x3B"],
        ["\x35\x3B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xBB"],

        ["\xB5\xBC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x35\x3C"],
        ["\x35\x3C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xBC"],

        ["\xB5\xBD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x35\x3D"],
        ["\x35\x3D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xBD"],

        ["\xB5\xBE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x35\x3E"],
        ["\x35\x3E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xBE"],

        ["\xB5\xBF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x35\x3F"],
        ["\x35\x3F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xBF"],

        ["\xB5\xC0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x35\x40"],
        ["\x35\x40",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xC0"],

        ["\xB5\xC1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x35\x41"],
        ["\x35\x41",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xC1"],

        ["\xB5\xC2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x35\x42"],
        ["\x35\x42",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xC2"],

        ["\xB5\xC3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x35\x43"],
        ["\x35\x43",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xC3"],

        ["\xB5\xC4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x35\x44"],
        ["\x35\x44",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xC4"],

        ["\xB5\xC5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x35\x45"],
        ["\x35\x45",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xC5"],

        ["\xB5\xC6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x35\x46"],
        ["\x35\x46",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xC6"],

        ["\xB5\xC7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x35\x47"],
        ["\x35\x47",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xC7"],

        ["\xB5\xC8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x35\x48"],
        ["\x35\x48",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xC8"],

        ["\xB5\xC9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x35\x49"],
        ["\x35\x49",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xC9"],

        ["\xB5\xCA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x35\x4A"],
        ["\x35\x4A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xCA"],

        ["\xB5\xCB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x35\x4B"],
        ["\x35\x4B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xCB"],

        ["\xB5\xCC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x35\x4C"],
        ["\x35\x4C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xCC"],

        ["\xB5\xCD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x35\x4D"],
        ["\x35\x4D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xCD"],

        ["\xB5\xCE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x35\x4E"],
        ["\x35\x4E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xCE"],

        ["\xB5\xCF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x35\x4F"],
        ["\x35\x4F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xCF"],

        ["\xB5\xD0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x35\x50"],
        ["\x35\x50",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xD0"],

        ["\xB5\xD1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x35\x51"],
        ["\x35\x51",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xD1"],

        ["\xB5\xD2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x35\x52"],
        ["\x35\x52",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xD2"],

        ["\xB5\xD3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x35\x53"],
        ["\x35\x53",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xD3"],

        ["\xB5\xD4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x35\x54"],
        ["\x35\x54",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xD4"],

        ["\xB5\xD5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x35\x55"],
        ["\x35\x55",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xD5"],

        ["\xB5\xD6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x35\x56"],
        ["\x35\x56",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xD6"],

        ["\xB5\xD7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x35\x57"],
        ["\x35\x57",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xD7"],

        ["\xB5\xD8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x35\x58"],
        ["\x35\x58",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xD8"],

        ["\xB5\xD9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x35\x59"],
        ["\x35\x59",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xD9"],

        ["\xB5\xDA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x35\x5A"],
        ["\x35\x5A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xDA"],

        ["\xB5\xDB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x35\x5B"],
        ["\x35\x5B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xDB"],

        ["\xB5\xDC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x35\x5C"],
        ["\x35\x5C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xDC"],

        ["\xB5\xDD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x35\x5D"],
        ["\x35\x5D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xDD"],

        ["\xB5\xDE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x35\x5E"],
        ["\x35\x5E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xDE"],

        ["\xB5\xDF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x35\x5F"],
        ["\x35\x5F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xDF"],

        ["\xB5\xE0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x35\x60"],
        ["\x35\x60",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xE0"],

        ["\xB5\xE1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x35\x61"],
        ["\x35\x61",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xE1"],

        ["\xB5\xE2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x35\x62"],
        ["\x35\x62",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xE2"],

        ["\xB5\xE3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x35\x63"],
        ["\x35\x63",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xE3"],

        ["\xB5\xE4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x35\x64"],
        ["\x35\x64",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xE4"],

        ["\xB5\xE5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x35\x65"],
        ["\x35\x65",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xE5"],

        ["\xB5\xE6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x35\x66"],
        ["\x35\x66",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xE6"],

        ["\xB5\xE7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x35\x67"],
        ["\x35\x67",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xE7"],

        ["\xB5\xE8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x35\x68"],
        ["\x35\x68",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xE8"],

        ["\xB5\xE9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x35\x69"],
        ["\x35\x69",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xE9"],

        ["\xB5\xEA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x35\x6A"],
        ["\x35\x6A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xEA"],

        ["\xB5\xEB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x35\x6B"],
        ["\x35\x6B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xEB"],

        ["\xB5\xEC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x35\x6C"],
        ["\x35\x6C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xEC"],

        ["\xB5\xED",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x35\x6D"],
        ["\x35\x6D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xED"],

        ["\xB5\xEE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x35\x6E"],
        ["\x35\x6E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xEE"],

        ["\xB5\xEF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x35\x6F"],
        ["\x35\x6F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xEF"],

        ["\xB5\xF0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x35\x70"],
        ["\x35\x70",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xF0"],

        ["\xB5\xF1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x35\x71"],
        ["\x35\x71",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xF1"],

        ["\xB5\xF2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x35\x72"],
        ["\x35\x72",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xF2"],

        ["\xB5\xF3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x35\x73"],
        ["\x35\x73",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xF3"],

        ["\xB5\xF4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x35\x74"],
        ["\x35\x74",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xF4"],

        ["\xB5\xF5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x35\x75"],
        ["\x35\x75",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xF5"],

        ["\xB5\xF6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x35\x76"],
        ["\x35\x76",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xF6"],

        ["\xB5\xF7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x35\x77"],
        ["\x35\x77",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xF7"],

        ["\xB5\xF8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x35\x78"],
        ["\x35\x78",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xF8"],

        ["\xB5\xF9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x35\x79"],
        ["\x35\x79",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xF9"],

        ["\xB5\xFA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x35\x7A"],
        ["\x35\x7A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xFA"],

        ["\xB5\xFB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x35\x7B"],
        ["\x35\x7B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xFB"],

        ["\xB5\xFC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x35\x7C"],
        ["\x35\x7C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xFC"],

        ["\xB5\xFD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x35\x7D"],
        ["\x35\x7D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xFD"],

        ["\xB5\xFE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x35\x7E"],
        ["\x35\x7E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB5\xFE"],

        ["\xB6\xA1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x36\x21"],
        ["\x36\x21",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xA1"],

        ["\xB6\xA2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x36\x22"],
        ["\x36\x22",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xA2"],

        ["\xB6\xA3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x36\x23"],
        ["\x36\x23",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xA3"],

        ["\xB6\xA4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x36\x24"],
        ["\x36\x24",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xA4"],

        ["\xB6\xA5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x36\x25"],
        ["\x36\x25",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xA5"],

        ["\xB6\xA6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x36\x26"],
        ["\x36\x26",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xA6"],

        ["\xB6\xA7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x36\x27"],
        ["\x36\x27",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xA7"],

        ["\xB6\xA8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x36\x28"],
        ["\x36\x28",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xA8"],

        ["\xB6\xA9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x36\x29"],
        ["\x36\x29",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xA9"],

        ["\xB6\xAA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x36\x2A"],
        ["\x36\x2A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xAA"],

        ["\xB6\xAB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x36\x2B"],
        ["\x36\x2B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xAB"],

        ["\xB6\xAC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x36\x2C"],
        ["\x36\x2C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xAC"],

        ["\xB6\xAD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x36\x2D"],
        ["\x36\x2D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xAD"],

        ["\xB6\xAE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x36\x2E"],
        ["\x36\x2E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xAE"],

        ["\xB6\xAF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x36\x2F"],
        ["\x36\x2F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xAF"],

        ["\xB6\xB0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x36\x30"],
        ["\x36\x30",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xB0"],

        ["\xB6\xB1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x36\x31"],
        ["\x36\x31",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xB1"],

        ["\xB6\xB2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x36\x32"],
        ["\x36\x32",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xB2"],

        ["\xB6\xB3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x36\x33"],
        ["\x36\x33",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xB3"],

        ["\xB6\xB4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x36\x34"],
        ["\x36\x34",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xB4"],

        ["\xB6\xB5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x36\x35"],
        ["\x36\x35",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xB5"],

        ["\xB6\xB6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x36\x36"],
        ["\x36\x36",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xB6"],

        ["\xB6\xB7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x36\x37"],
        ["\x36\x37",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xB7"],

        ["\xB6\xB8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x36\x38"],
        ["\x36\x38",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xB8"],

        ["\xB6\xB9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x36\x39"],
        ["\x36\x39",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xB9"],

        ["\xB6\xBA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x36\x3A"],
        ["\x36\x3A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xBA"],

        ["\xB6\xBB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x36\x3B"],
        ["\x36\x3B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xBB"],

        ["\xB6\xBC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x36\x3C"],
        ["\x36\x3C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xBC"],

        ["\xB6\xBD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x36\x3D"],
        ["\x36\x3D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xBD"],

        ["\xB6\xBE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x36\x3E"],
        ["\x36\x3E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xBE"],

        ["\xB6\xBF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x36\x3F"],
        ["\x36\x3F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xBF"],

        ["\xB6\xC0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x36\x40"],
        ["\x36\x40",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xC0"],

        ["\xB6\xC1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x36\x41"],
        ["\x36\x41",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xC1"],

        ["\xB6\xC2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x36\x42"],
        ["\x36\x42",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xC2"],

        ["\xB6\xC3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x36\x43"],
        ["\x36\x43",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xC3"],

        ["\xB6\xC4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x36\x44"],
        ["\x36\x44",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xC4"],

        ["\xB6\xC5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x36\x45"],
        ["\x36\x45",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xC5"],

        ["\xB6\xC6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xDA"],
        ["\xB6\xDA",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xC6"],

        ["\xB6\xC7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x36\x47"],
        ["\x36\x47",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xC7"],

        ["\xB6\xC8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x36\x48"],
        ["\x36\x48",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xC8"],

        ["\xB6\xC9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x36\x49"],
        ["\x36\x49",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xC9"],

        ["\xB6\xCA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x36\x4A"],
        ["\x36\x4A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xCA"],

        ["\xB6\xCB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x36\x4B"],
        ["\x36\x4B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xCB"],

        ["\xB6\xCC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x36\x4C"],
        ["\x36\x4C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xCC"],

        ["\xB6\xCD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x36\x4D"],
        ["\x36\x4D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xCD"],

        ["\xB6\xCE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x36\x4E"],
        ["\x36\x4E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xCE"],

        ["\xB6\xCF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x36\x4F"],
        ["\x36\x4F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xCF"],

        ["\xB6\xD0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x36\x50"],
        ["\x36\x50",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xD0"],

        ["\xB6\xD1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x36\x51"],
        ["\x36\x51",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xD1"],

        ["\xB6\xD2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x36\x52"],
        ["\x36\x52",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xD2"],

        ["\xB6\xD3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x36\x53"],
        ["\x36\x53",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xD3"],

        ["\xB6\xD4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x36\x54"],
        ["\x36\x54",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xD4"],

        ["\xB6\xD5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x36\x55"],
        ["\x36\x55",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xD5"],

        ["\xB6\xD6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x36\x56"],
        ["\x36\x56",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xD6"],

        ["\xB6\xD7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x36\x57"],
        ["\x36\x57",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xD7"],

        ["\xB6\xD8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x36\x58"],
        ["\x36\x58",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xD8"],

        ["\xB6\xD9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x36\x59"],
        ["\x36\x59",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xD9"],

        ["\xB6\xDA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x36\x5A"],
        ["\x36\x5A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xDA"],

        ["\xB6\xDB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x36\x5B"],
        ["\x36\x5B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xDB"],

        ["\xB6\xDC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x36\x5C"],
        ["\x36\x5C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xDC"],

        ["\xB6\xDD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x36\x5D"],
        ["\x36\x5D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xDD"],

        ["\xB6\xDE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x36\x5E"],
        ["\x36\x5E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xDE"],

        ["\xB6\xDF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x36\x5F"],
        ["\x36\x5F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xDF"],

        ["\xB6\xE0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x36\x60"],
        ["\x36\x60",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xE0"],

        ["\xB6\xE1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x36\x61"],
        ["\x36\x61",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xE1"],

        ["\xB6\xE2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x36\x62"],
        ["\x36\x62",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xE2"],

        ["\xB6\xE3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x36\x63"],
        ["\x36\x63",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xE3"],

        ["\xB6\xE4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x36\x64"],
        ["\x36\x64",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xE4"],

        ["\xB6\xE5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x36\x65"],
        ["\x36\x65",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xE5"],

        ["\xB6\xE6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x36\x66"],
        ["\x36\x66",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xE6"],

        ["\xB6\xE7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x36\x67"],
        ["\x36\x67",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xE7"],

        ["\xB6\xE8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x36\x68"],
        ["\x36\x68",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xE8"],

        ["\xB6\xE9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x36\x69"],
        ["\x36\x69",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xE9"],

        ["\xB6\xEA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x36\x6A"],
        ["\x36\x6A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xEA"],

        ["\xB6\xEB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x36\x6B"],
        ["\x36\x6B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xEB"],

        ["\xB6\xEC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x36\x6C"],
        ["\x36\x6C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xEC"],

        ["\xB6\xED",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x36\x6D"],
        ["\x36\x6D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xED"],

        ["\xB6\xEE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x36\x6E"],
        ["\x36\x6E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xEE"],

        ["\xB6\xEF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x36\x6F"],
        ["\x36\x6F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xEF"],

        ["\xB6\xF0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x36\x70"],
        ["\x36\x70",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xF0"],

        ["\xB6\xF1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x36\x71"],
        ["\x36\x71",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xF1"],

        ["\xB6\xF2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x36\x72"],
        ["\x36\x72",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xF2"],

        ["\xB6\xF3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x36\x73"],
        ["\x36\x73",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xF3"],

        ["\xB6\xF4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x36\x74"],
        ["\x36\x74",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xF4"],

        ["\xB6\xF5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x36\x75"],
        ["\x36\x75",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xF5"],

        ["\xB6\xF6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x36\x76"],
        ["\x36\x76",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xF6"],

        ["\xB6\xF7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x36\x77"],
        ["\x36\x77",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xF7"],

        ["\xB6\xF8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x36\x78"],
        ["\x36\x78",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xF8"],

        ["\xB6\xF9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x36\x79"],
        ["\x36\x79",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xF9"],

        ["\xB6\xFA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x36\x7A"],
        ["\x36\x7A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xFA"],

        ["\xB6\xFB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x36\x7B"],
        ["\x36\x7B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xFB"],

        ["\xB6\xFC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x36\x7C"],
        ["\x36\x7C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xFC"],

        ["\xB6\xFD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x36\x7D"],
        ["\x36\x7D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xFD"],

        ["\xB6\xFE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x36\x7E"],
        ["\x36\x7E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xFE"],

        ["\xB7\xA1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x37\x21"],
        ["\x37\x21",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xA1"],

        ["\xB7\xA2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x37\x22"],
        ["\x37\x22",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xA2"],

        ["\xB7\xA3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x37\x23"],
        ["\x37\x23",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xA3"],

        ["\xB7\xA4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x37\x24"],
        ["\x37\x24",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xA4"],

        ["\xB7\xA5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x37\x25"],
        ["\x37\x25",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xA5"],

        ["\xB7\xA6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x37\x26"],
        ["\x37\x26",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xA6"],

        ["\xB7\xA7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x37\x27"],
        ["\x37\x27",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xA7"],

        ["\xB7\xA8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x37\x28"],
        ["\x37\x28",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xA8"],

        ["\xB7\xA9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x37\x29"],
        ["\x37\x29",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xA9"],

        ["\xB7\xAA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x37\x2A"],
        ["\x37\x2A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xAA"],

        ["\xB7\xAB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x37\x2B"],
        ["\x37\x2B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xAB"],

        ["\xB7\xAC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x37\x2C"],
        ["\x37\x2C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xAC"],

        ["\xB7\xAD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x37\x2D"],
        ["\x37\x2D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xAD"],

        ["\xB7\xAE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x37\x2E"],
        ["\x37\x2E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xAE"],

        ["\xB7\xAF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x37\x2F"],
        ["\x37\x2F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xAF"],

        ["\xB7\xB0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x37\x30"],
        ["\x37\x30",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xB0"],

        ["\xB7\xB1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x37\x31"],
        ["\x37\x31",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xB1"],

        ["\xB7\xB2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x37\x32"],
        ["\x37\x32",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xB2"],

        ["\xB7\xB3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x37\x33"],
        ["\x37\x33",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xB3"],

        ["\xB7\xB4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x37\x34"],
        ["\x37\x34",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xB4"],

        ["\xB7\xB5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x37\x35"],
        ["\x37\x35",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xB5"],

        ["\xB7\xB6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x37\x36"],
        ["\x37\x36",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xB6"],

        ["\xB7\xB7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x37\x37"],
        ["\x37\x37",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xB7"],

        ["\xB7\xB8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x37\x38"],
        ["\x37\x38",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xB8"],

        ["\xB7\xB9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x37\x39"],
        ["\x37\x39",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xB9"],

        ["\xB7\xBA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x37\x3A"],
        ["\x37\x3A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xBA"],

        ["\xB7\xBB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x37\x3B"],
        ["\x37\x3B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xBB"],

        ["\xB7\xBC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x37\x3C"],
        ["\x37\x3C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xBC"],

        ["\xB7\xBD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x37\x3D"],
        ["\x37\x3D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xBD"],

        ["\xB7\xBE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x37\x3E"],
        ["\x37\x3E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xBE"],

        ["\xB7\xBF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x37\x3F"],
        ["\x37\x3F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xBF"],

        ["\xB7\xC0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x37\x40"],
        ["\x37\x40",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xC0"],

        ["\xB7\xC1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x37\x41"],
        ["\x37\x41",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xC1"],

        ["\xB7\xC2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x37\x42"],
        ["\x37\x42",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xC2"],

        ["\xB7\xC3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x37\x43"],
        ["\x37\x43",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xC3"],

        ["\xB7\xC4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x37\x44"],
        ["\x37\x44",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xC4"],

        ["\xB7\xC5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x37\x45"],
        ["\x37\x45",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xC5"],

        ["\xB7\xC6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x37\x46"],
        ["\x37\x46",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xC6"],

        ["\xB7\xC7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x37\x47"],
        ["\x37\x47",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xC7"],

        ["\xB7\xC8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x37\x48"],
        ["\x37\x48",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xC8"],

        ["\xB7\xC9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x37\x49"],
        ["\x37\x49",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xC9"],

        ["\xB7\xCA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x37\x4A"],
        ["\x37\x4A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xCA"],

        ["\xB7\xCB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x37\x4B"],
        ["\x37\x4B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xCB"],

        ["\xB7\xCC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x37\x4C"],
        ["\x37\x4C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xCC"],

        ["\xB7\xCD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x37\x4D"],
        ["\x37\x4D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xCD"],

        ["\xB7\xCE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x37\x4E"],
        ["\x37\x4E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xCE"],

        ["\xB7\xCF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x37\x4F"],
        ["\x37\x4F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xCF"],

        ["\xB7\xD0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x37\x50"],
        ["\x37\x50",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xD0"],

        ["\xB7\xD1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x37\x51"],
        ["\x37\x51",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xD1"],

        ["\xB7\xD2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x37\x52"],
        ["\x37\x52",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xD2"],

        ["\xB7\xD3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x37\x53"],
        ["\x37\x53",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xD3"],

        ["\xB7\xD4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x37\x54"],
        ["\x37\x54",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xD4"],

        ["\xB7\xD5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x37\x55"],
        ["\x37\x55",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xD5"],

        ["\xB7\xD6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x37\x56"],
        ["\x37\x56",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xD6"],

        ["\xB7\xD7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x37\x57"],
        ["\x37\x57",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xD7"],

        ["\xB7\xD8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x37\x58"],
        ["\x37\x58",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xD8"],

        ["\xB7\xD9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x37\x59"],
        ["\x37\x59",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xD9"],

        ["\xB7\xDA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x37\x5A"],
        ["\x37\x5A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xDA"],

        ["\xB7\xDB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x74"],
        ["\x70\x74",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xDB"],

        ["\xB7\xDC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x37\x5C"],
        ["\x37\x5C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xDC"],

        ["\xB7\xDD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x37\x5D"],
        ["\x37\x5D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xDD"],

        ["\xB7\xDE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x37\x5E"],
        ["\x37\x5E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xDE"],

        ["\xB7\xDF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x37\x5F"],
        ["\x37\x5F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xDF"],

        ["\xB7\xE0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x37\x60"],
        ["\x37\x60",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xE0"],

        ["\xB7\xE1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x37\x61"],
        ["\x37\x61",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xE1"],

        ["\xB7\xE2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x37\x62"],
        ["\x37\x62",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xE2"],

        ["\xB7\xE3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x37\x63"],
        ["\x37\x63",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xE3"],

        ["\xB7\xE4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x37\x64"],
        ["\x37\x64",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xE4"],

        ["\xB7\xE5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x37\x65"],
        ["\x37\x65",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xE5"],

        ["\xB7\xE6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x37\x66"],
        ["\x37\x66",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xE6"],

        ["\xB7\xE7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x37\x67"],
        ["\x37\x67",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xE7"],

        ["\xB7\xE8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x37\x68"],
        ["\x37\x68",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xE8"],

        ["\xB7\xE9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x37\x69"],
        ["\x37\x69",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xE9"],

        ["\xB7\xEA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x37\x6A"],
        ["\x37\x6A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xEA"],

        ["\xB7\xEB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x37\x6B"],
        ["\x37\x6B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xEB"],

        ["\xB7\xEC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x37\x6C"],
        ["\x37\x6C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xEC"],

        ["\xB7\xED",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x37\x6D"],
        ["\x37\x6D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xED"],

        ["\xB7\xEE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x37\x6E"],
        ["\x37\x6E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xEE"],

        ["\xB7\xEF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x37\x6F"],
        ["\x37\x6F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xEF"],

        ["\xB7\xF0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x37\x70"],
        ["\x37\x70",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xF0"],

        ["\xB7\xF1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x37\x71"],
        ["\x37\x71",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xF1"],

        ["\xB7\xF2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x37\x72"],
        ["\x37\x72",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xF2"],

        ["\xB7\xF3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x37\x73"],
        ["\x37\x73",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xF3"],

        ["\xB7\xF4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x37\x74"],
        ["\x37\x74",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xF4"],

        ["\xB7\xF5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x37\x75"],
        ["\x37\x75",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xF5"],

        ["\xB7\xF6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x37\x76"],
        ["\x37\x76",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xF6"],

        ["\xB7\xF7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x37\x77"],
        ["\x37\x77",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xF7"],

        ["\xB7\xF8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x37\x78"],
        ["\x37\x78",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xF8"],

        ["\xB7\xF9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x37\x79"],
        ["\x37\x79",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xF9"],

        ["\xB7\xFA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x37\x7A"],
        ["\x37\x7A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xFA"],

        ["\xB7\xFB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x37\x7B"],
        ["\x37\x7B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xFB"],

        ["\xB7\xFC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x37\x7C"],
        ["\x37\x7C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xFC"],

        ["\xB7\xFD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x37\x7D"],
        ["\x37\x7D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xFD"],

        ["\xB7\xFE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x37\x7E"],
        ["\x37\x7E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB7\xFE"],

        ["\xB8\xA1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x38\x21"],
        ["\x38\x21",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xA1"],

        ["\xB8\xA2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x38\x22"],
        ["\x38\x22",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xA2"],

        ["\xB8\xA3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x38\x23"],
        ["\x38\x23",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xA3"],

        ["\xB8\xA4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x38\x24"],
        ["\x38\x24",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xA4"],

        ["\xB8\xA5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x38\x25"],
        ["\x38\x25",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xA5"],

        ["\xB8\xA6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x38\x26"],
        ["\x38\x26",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xA6"],

        ["\xB8\xA7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x38\x27"],
        ["\x38\x27",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xA7"],

        ["\xB8\xA8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x38\x28"],
        ["\x38\x28",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xA8"],

        ["\xB8\xA9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x38\x29"],
        ["\x38\x29",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xA9"],

        ["\xB8\xAA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x38\x2A"],
        ["\x38\x2A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xAA"],

        ["\xB8\xAB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x38\x2B"],
        ["\x38\x2B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xAB"],

        ["\xB8\xAC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x38\x2C"],
        ["\x38\x2C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xAC"],

        ["\xB8\xAD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x38\x2D"],
        ["\x38\x2D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xAD"],

        ["\xB8\xAE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x38\x2E"],
        ["\x38\x2E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xAE"],

        ["\xB8\xAF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x38\x2F"],
        ["\x38\x2F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xAF"],

        ["\xB8\xB0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x38\x30"],
        ["\x38\x30",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xB0"],

        ["\xB8\xB1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x38\x31"],
        ["\x38\x31",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xB1"],

        ["\xB8\xB2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x38\x32"],
        ["\x38\x32",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xB2"],

        ["\xB8\xB3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x38\x33"],
        ["\x38\x33",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xB3"],

        ["\xB8\xB4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x38\x34"],
        ["\x38\x34",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xB4"],

        ["\xB8\xB5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x38\x35"],
        ["\x38\x35",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xB5"],

        ["\xB8\xB6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x38\x36"],
        ["\x38\x36",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xB6"],

        ["\xB8\xB7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x38\x37"],
        ["\x38\x37",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xB7"],

        ["\xB8\xB8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x38\x38"],
        ["\x38\x38",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xB8"],

        ["\xB8\xB9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x38\x39"],
        ["\x38\x39",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xB9"],

        ["\xB8\xBA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x38\x3A"],
        ["\x38\x3A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xBA"],

        ["\xB8\xBB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x38\x3B"],
        ["\x38\x3B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xBB"],

        ["\xB8\xBC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x38\x3C"],
        ["\x38\x3C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xBC"],

        ["\xB8\xBD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x38\x3D"],
        ["\x38\x3D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xBD"],

        ["\xB8\xBE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x38\x3E"],
        ["\x38\x3E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xBE"],

        ["\xB8\xBF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x38\x3F"],
        ["\x38\x3F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xBF"],

        ["\xB8\xC0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x38\x40"],
        ["\x38\x40",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xC0"],

        ["\xB8\xC1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x38\x41"],
        ["\x38\x41",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xC1"],

        ["\xB8\xC2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x38\x42"],
        ["\x38\x42",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xC2"],

        ["\xB8\xC3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x38\x43"],
        ["\x38\x43",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xC3"],

        ["\xB8\xC4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x38\x44"],
        ["\x38\x44",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xC4"],

        ["\xB8\xC5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x38\x45"],
        ["\x38\x45",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xC5"],

        ["\xB8\xC6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x38\x46"],
        ["\x38\x46",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xC6"],

        ["\xB8\xC7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x38\x47"],
        ["\x38\x47",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xC7"],

        ["\xB8\xC8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x38\x48"],
        ["\x38\x48",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xC8"],

        ["\xB8\xC9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x38\x49"],
        ["\x38\x49",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xC9"],

        ["\xB8\xCA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x38\x4A"],
        ["\x38\x4A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xCA"],

        ["\xB8\xCB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x38\x4B"],
        ["\x38\x4B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xCB"],

        ["\xB8\xCC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x38\x4C"],
        ["\x38\x4C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xCC"],

        ["\xB8\xCD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x38\x4D"],
        ["\x38\x4D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xCD"],

        ["\xB8\xCE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x38\x4E"],
        ["\x38\x4E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xCE"],

        ["\xB8\xCF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x38\x4F"],
        ["\x38\x4F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xCF"],

        ["\xB8\xD0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x38\x50"],
        ["\x38\x50",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xD0"],

        ["\xB8\xD1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x38\x51"],
        ["\x38\x51",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xD1"],

        ["\xB8\xD2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x38\x52"],
        ["\x38\x52",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xD2"],

        ["\xB8\xD3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x38\x53"],
        ["\x38\x53",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xD3"],

        ["\xB8\xD4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x38\x54"],
        ["\x38\x54",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xD4"],

        ["\xB8\xD5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x38\x55"],
        ["\x38\x55",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xD5"],

        ["\xB8\xD6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x38\x56"],
        ["\x38\x56",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xD6"],

        ["\xB8\xD7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x38\x57"],
        ["\x38\x57",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xD7"],

        ["\xB8\xD8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x38\x58"],
        ["\x38\x58",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xD8"],

        ["\xB8\xD9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x38\x59"],
        ["\x38\x59",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xD9"],

        ["\xB8\xDA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x38\x5A"],
        ["\x38\x5A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xDA"],

        ["\xB8\xDB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x38\x5B"],
        ["\x38\x5B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xDB"],

        ["\xB8\xDC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x38\x5C"],
        ["\x38\x5C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xDC"],

        ["\xB8\xDD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x38\x5D"],
        ["\x38\x5D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xDD"],

        ["\xB8\xDE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x38\x5E"],
        ["\x38\x5E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xDE"],

        ["\xB8\xDF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x38\x5F"],
        ["\x38\x5F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xDF"],

        ["\xB8\xE0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x38\x60"],
        ["\x38\x60",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xE0"],

        ["\xB8\xE1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x38\x61"],
        ["\x38\x61",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xE1"],

        ["\xB8\xE2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x38\x62"],
        ["\x38\x62",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xE2"],

        ["\xB8\xE3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x38\x63"],
        ["\x38\x63",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xE3"],

        ["\xB8\xE4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x38\x64"],
        ["\x38\x64",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xE4"],

        ["\xB8\xE5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x38\x65"],
        ["\x38\x65",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xE5"],

        ["\xB8\xE6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x38\x66"],
        ["\x38\x66",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xE6"],

        ["\xB8\xE7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x38\x67"],
        ["\x38\x67",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xE7"],

        ["\xB8\xE8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x38\x68"],
        ["\x38\x68",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xE8"],

        ["\xB8\xE9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x38\x69"],
        ["\x38\x69",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xE9"],

        ["\xB8\xEA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x38\x6A"],
        ["\x38\x6A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xEA"],

        ["\xB8\xEB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x38\x6B"],
        ["\x38\x6B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xEB"],

        ["\xB8\xEC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x38\x6C"],
        ["\x38\x6C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xEC"],

        ["\xB8\xED",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x38\x6D"],
        ["\x38\x6D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xED"],

        ["\xB8\xEE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x38\x6E"],
        ["\x38\x6E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xEE"],

        ["\xB8\xEF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x38\x6F"],
        ["\x38\x6F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xEF"],

        ["\xB8\xF0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x38\x70"],
        ["\x38\x70",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xF0"],

        ["\xB8\xF1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x38\x71"],
        ["\x38\x71",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xF1"],

        ["\xB8\xF2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x38\x72"],
        ["\x38\x72",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xF2"],

        ["\xB8\xF3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x38\x73"],
        ["\x38\x73",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xF3"],

        ["\xB8\xF4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x38\x74"],
        ["\x38\x74",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xF4"],

        ["\xB8\xF5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x38\x75"],
        ["\x38\x75",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xF5"],

        ["\xB8\xF6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x38\x76"],
        ["\x38\x76",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xF6"],

        ["\xB8\xF7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x38\x77"],
        ["\x38\x77",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xF7"],

        ["\xB8\xF8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x38\x78"],
        ["\x38\x78",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xF8"],

        ["\xB8\xF9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x38\x79"],
        ["\x38\x79",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xF9"],

        ["\xB8\xFA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x38\x7A"],
        ["\x38\x7A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xFA"],

        ["\xB8\xFB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x38\x7B"],
        ["\x38\x7B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xFB"],

        ["\xB8\xFC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x38\x7C"],
        ["\x38\x7C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xFC"],

        ["\xB8\xFD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x38\x7D"],
        ["\x38\x7D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xFD"],

        ["\xB8\xFE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x38\x7E"],
        ["\x38\x7E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB8\xFE"],

        ["\xB9\xA1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x39\x21"],
        ["\x39\x21",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xA1"],

        ["\xB9\xA2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x39\x22"],
        ["\x39\x22",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xA2"],

        ["\xB9\xA3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x39\x23"],
        ["\x39\x23",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xA3"],

        ["\xB9\xA4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x39\x24"],
        ["\x39\x24",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xA4"],

        ["\xB9\xA5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x39\x25"],
        ["\x39\x25",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xA5"],

        ["\xB9\xA6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x39\x26"],
        ["\x39\x26",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xA6"],

        ["\xB9\xA7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x39\x27"],
        ["\x39\x27",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xA7"],

        ["\xB9\xA8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x39\x28"],
        ["\x39\x28",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xA8"],

        ["\xB9\xA9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x39\x29"],
        ["\x39\x29",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xA9"],

        ["\xB9\xAA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x39\x2A"],
        ["\x39\x2A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xAA"],

        ["\xB9\xAB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x39\x2B"],
        ["\x39\x2B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xAB"],

        ["\xB9\xAC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x39\x2C"],
        ["\x39\x2C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xAC"],

        ["\xB9\xAD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x39\x2D"],
        ["\x39\x2D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xAD"],

        ["\xB9\xAE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x39\x2E"],
        ["\x39\x2E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xAE"],

        ["\xB9\xAF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x39\x2F"],
        ["\x39\x2F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xAF"],

        ["\xB9\xB0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x39\x30"],
        ["\x39\x30",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xB0"],

        ["\xB9\xB1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x39\x31"],
        ["\x39\x31",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xB1"],

        ["\xB9\xB2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x39\x32"],
        ["\x39\x32",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xB2"],

        ["\xB9\xB3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x39\x33"],
        ["\x39\x33",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xB3"],

        ["\xB9\xB4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x39\x34"],
        ["\x39\x34",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xB4"],

        ["\xB9\xB5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x39\x35"],
        ["\x39\x35",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xB5"],

        ["\xB9\xB6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x39\x36"],
        ["\x39\x36",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xB6"],

        ["\xB9\xB7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xB6"],
        ["\xBD\xB6",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xB7"],

        ["\xB9\xB8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x39\x38"],
        ["\x39\x38",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xB8"],

        ["\xB9\xB9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x39\x39"],
        ["\x39\x39",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xB9"],

        ["\xB9\xBA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x39\x3A"],
        ["\x39\x3A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xBA"],

        ["\xB9\xBB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x39\x3B"],
        ["\x39\x3B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xBB"],

        ["\xB9\xBC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x39\x3C"],
        ["\x39\x3C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xBC"],

        ["\xB9\xBD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x39\x3D"],
        ["\x39\x3D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xBD"],

        ["\xB9\xBE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x39\x3E"],
        ["\x39\x3E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xBE"],

        ["\xB9\xBF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x39\x3F"],
        ["\x39\x3F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xBF"],

        ["\xB9\xC0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x39\x40"],
        ["\x39\x40",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xC0"],

        ["\xB9\xC1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x39\x41"],
        ["\x39\x41",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xC1"],

        ["\xB9\xC2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x39\x42"],
        ["\x39\x42",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xC2"],

        ["\xB9\xC3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x39\x43"],
        ["\x39\x43",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xC3"],

        ["\xB9\xC4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x39\x44"],
        ["\x39\x44",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xC4"],

        ["\xB9\xC5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x39\x45"],
        ["\x39\x45",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xC5"],

        ["\xB9\xC6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x39\x46"],
        ["\x39\x46",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xC6"],

        ["\xB9\xC7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x39\x47"],
        ["\x39\x47",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xC7"],

        ["\xB9\xC8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x39\x48"],
        ["\x39\x48",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xC8"],

        ["\xB9\xC9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x39\x49"],
        ["\x39\x49",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xC9"],

        ["\xB9\xCA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x39\x4A"],
        ["\x39\x4A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xCA"],

        ["\xB9\xCB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x39\x4B"],
        ["\x39\x4B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xCB"],

        ["\xB9\xCC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x39\x4C"],
        ["\x39\x4C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xCC"],

        ["\xB9\xCD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x39\x4D"],
        ["\x39\x4D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xCD"],

        ["\xB9\xCE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x39\x4E"],
        ["\x39\x4E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xCE"],

        ["\xB9\xCF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x39\x4F"],
        ["\x39\x4F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xCF"],

        ["\xB9\xD0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x39\x50"],
        ["\x39\x50",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xD0"],

        ["\xB9\xD1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x39\x51"],
        ["\x39\x51",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xD1"],

        ["\xB9\xD2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x39\x52"],
        ["\x39\x52",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xD2"],

        ["\xB9\xD3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x39\x53"],
        ["\x39\x53",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xD3"],

        ["\xB9\xD4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x39\x54"],
        ["\x39\x54",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xD4"],

        ["\xB9\xD5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x39\x55"],
        ["\x39\x55",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xD5"],

        ["\xB9\xD6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x39\x56"],
        ["\x39\x56",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xD6"],

        ["\xB9\xD7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x39\x57"],
        ["\x39\x57",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xD7"],

        ["\xB9\xD8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x39\x58"],
        ["\x39\x58",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xD8"],

        ["\xB9\xD9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x39\x59"],
        ["\x39\x59",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xD9"],

        ["\xB9\xDA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x39\x5A"],
        ["\x39\x5A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xDA"],

        ["\xB9\xDB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x39\x5B"],
        ["\x39\x5B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xDB"],

        ["\xB9\xDC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x68"],
        ["\x62\x68",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xDC"],

        ["\xB9\xDD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x39\x5D"],
        ["\x39\x5D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xDD"],

        ["\xB9\xDE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x39\x5E"],
        ["\x39\x5E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xDE"],

        ["\xB9\xDF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x39\x5F"],
        ["\x39\x5F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xDF"],

        ["\xB9\xE0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x39\x60"],
        ["\x39\x60",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xE0"],

        ["\xB9\xE1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x39\x61"],
        ["\x39\x61",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xE1"],

        ["\xB9\xE2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x39\x62"],
        ["\x39\x62",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xE2"],

        ["\xB9\xE3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x39\x63"],
        ["\x39\x63",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xE3"],

        ["\xB9\xE4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x39\x64"],
        ["\x39\x64",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xE4"],

        ["\xB9\xE5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x39\x65"],
        ["\x39\x65",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xE5"],

        ["\xB9\xE6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x39\x66"],
        ["\x39\x66",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xE6"],

        ["\xB9\xE7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x39\x67"],
        ["\x39\x67",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xE7"],

        ["\xB9\xE8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x39\x68"],
        ["\x39\x68",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xE8"],

        ["\xB9\xE9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x39\x69"],
        ["\x39\x69",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xE9"],

        ["\xB9\xEA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x39\x6A"],
        ["\x39\x6A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xEA"],

        ["\xB9\xEB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x39\x6B"],
        ["\x39\x6B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xEB"],

        ["\xB9\xEC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x39\x6C"],
        ["\x39\x6C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xEC"],

        ["\xB9\xED",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xBB"],
        ["\xD6\xBB",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xED"],

        ["\xB9\xEE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x39\x6E"],
        ["\x39\x6E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xEE"],

        ["\xB9\xEF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x39\x6F"],
        ["\x39\x6F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xEF"],

        ["\xB9\xF0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x39\x70"],
        ["\x39\x70",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xF0"],

        ["\xB9\xF1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x39\x71"],
        ["\x39\x71",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xF1"],

        ["\xB9\xF2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x39\x72"],
        ["\x39\x72",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xF2"],

        ["\xB9\xF3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x39\x73"],
        ["\x39\x73",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xF3"],

        ["\xB9\xF4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x39\x74"],
        ["\x39\x74",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xF4"],

        ["\xB9\xF5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x39\x75"],
        ["\x39\x75",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xF5"],

        ["\xB9\xF6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x39\x76"],
        ["\x39\x76",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xF6"],

        ["\xB9\xF7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x39\x77"],
        ["\x39\x77",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xF7"],

        ["\xB9\xF8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x39\x78"],
        ["\x39\x78",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xF8"],

        ["\xB9\xF9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x39\x79"],
        ["\x39\x79",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xF9"],

        ["\xB9\xFA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x39\x7A"],
        ["\x39\x7A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xFA"],

        ["\xB9\xFB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x39\x7B"],
        ["\x39\x7B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xFB"],

        ["\xB9\xFC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x39\x7C"],
        ["\x39\x7C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xFC"],

        ["\xB9\xFD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x39\x7D"],
        ["\x39\x7D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xFD"],

        ["\xB9\xFE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x39\x7E"],
        ["\x39\x7E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB9\xFE"],

        ["\xBA\xA1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3A\x21"],
        ["\x3A\x21",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xA1"],

        ["\xBA\xA2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3A\x22"],
        ["\x3A\x22",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xA2"],

        ["\xBA\xA3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3A\x23"],
        ["\x3A\x23",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xA3"],

        ["\xBA\xA4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3A\x24"],
        ["\x3A\x24",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xA4"],

        ["\xBA\xA5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3A\x25"],
        ["\x3A\x25",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xA5"],

        ["\xBA\xA6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3A\x26"],
        ["\x3A\x26",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xA6"],

        ["\xBA\xA7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3A\x27"],
        ["\x3A\x27",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xA7"],

        ["\xBA\xA8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3A\x28"],
        ["\x3A\x28",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xA8"],

        ["\xBA\xA9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3A\x29"],
        ["\x3A\x29",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xA9"],

        ["\xBA\xAA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3A\x2A"],
        ["\x3A\x2A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xAA"],

        ["\xBA\xAB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3A\x2B"],
        ["\x3A\x2B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xAB"],

        ["\xBA\xAC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3A\x2C"],
        ["\x3A\x2C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xAC"],

        ["\xBA\xAD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3A\x2D"],
        ["\x3A\x2D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xAD"],

        ["\xBA\xAE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3A\x2E"],
        ["\x3A\x2E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xAE"],

        ["\xBA\xAF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3A\x2F"],
        ["\x3A\x2F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xAF"],

        ["\xBA\xB0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3A\x30"],
        ["\x3A\x30",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xB0"],

        ["\xBA\xB1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3A\x31"],
        ["\x3A\x31",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xB1"],

        ["\xBA\xB2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3A\x32"],
        ["\x3A\x32",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xB2"],

        ["\xBA\xB3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3A\x33"],
        ["\x3A\x33",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xB3"],

        ["\xBA\xB4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3A\x34"],
        ["\x3A\x34",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xB4"],

        ["\xBA\xB5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3A\x35"],
        ["\x3A\x35",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xB5"],

        ["\xBA\xB6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3A\x36"],
        ["\x3A\x36",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xB6"],

        ["\xBA\xB7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3A\x37"],
        ["\x3A\x37",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xB7"],

        ["\xBA\xB8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3A\x38"],
        ["\x3A\x38",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xB8"],

        ["\xBA\xB9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3A\x39"],
        ["\x3A\x39",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xB9"],

        ["\xBA\xBA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3A\x3A"],
        ["\x3A\x3A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xBA"],

        ["\xBA\xBB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3A\x3B"],
        ["\x3A\x3B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xBB"],

        ["\xBA\xBC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3A\x3C"],
        ["\x3A\x3C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xBC"],

        ["\xBA\xBD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3A\x3D"],
        ["\x3A\x3D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xBD"],

        ["\xBA\xBE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3A\x3E"],
        ["\x3A\x3E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xBE"],

        ["\xBA\xBF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3A\x3F"],
        ["\x3A\x3F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xBF"],

        ["\xBA\xC0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3A\x40"],
        ["\x3A\x40",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xC0"],

        ["\xBA\xC1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3A\x41"],
        ["\x3A\x41",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xC1"],

        ["\xBA\xC2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3A\x42"],
        ["\x3A\x42",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xC2"],

        ["\xBA\xC3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3A\x43"],
        ["\x3A\x43",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xC3"],

        ["\xBA\xC4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3A\x44"],
        ["\x3A\x44",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xC4"],

        ["\xBA\xC5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3A\x45"],
        ["\x3A\x45",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xC5"],

        ["\xBA\xC6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3A\x46"],
        ["\x3A\x46",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xC6"],

        ["\xBA\xC7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3A\x47"],
        ["\x3A\x47",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xC7"],

        ["\xBA\xC8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3A\x48"],
        ["\x3A\x48",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xC8"],

        ["\xBA\xC9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3A\x49"],
        ["\x3A\x49",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xC9"],

        ["\xBA\xCA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3A\x4A"],
        ["\x3A\x4A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xCA"],

        ["\xBA\xCB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3A\x4B"],
        ["\x3A\x4B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xCB"],

        ["\xBA\xCC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3A\x4C"],
        ["\x3A\x4C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xCC"],

        ["\xBA\xCD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3A\x4D"],
        ["\x3A\x4D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xCD"],

        ["\xBA\xCE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3A\x4E"],
        ["\x3A\x4E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xCE"],

        ["\xBA\xCF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3A\x4F"],
        ["\x3A\x4F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xCF"],

        ["\xBA\xD0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3A\x50"],
        ["\x3A\x50",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xD0"],

        ["\xBA\xD1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3A\x51"],
        ["\x3A\x51",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xD1"],

        ["\xBA\xD2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3A\x52"],
        ["\x3A\x52",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xD2"],

        ["\xBA\xD3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3A\x53"],
        ["\x3A\x53",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xD3"],

        ["\xBA\xD4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3A\x54"],
        ["\x3A\x54",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xD4"],

        ["\xBA\xD5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3A\x55"],
        ["\x3A\x55",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xD5"],

        ["\xBA\xD6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3A\x56"],
        ["\x3A\x56",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xD6"],

        ["\xBA\xD7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3A\x57"],
        ["\x3A\x57",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xD7"],

        ["\xBA\xD8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3A\x58"],
        ["\x3A\x58",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xD8"],

        ["\xBA\xD9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3A\x59"],
        ["\x3A\x59",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xD9"],

        ["\xBA\xDA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3A\x5A"],
        ["\x3A\x5A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xDA"],

        ["\xBA\xDB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3A\x5B"],
        ["\x3A\x5B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xDB"],

        ["\xBA\xDC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3A\x5C"],
        ["\x3A\x5C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xDC"],

        ["\xBA\xDD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3A\x5D"],
        ["\x3A\x5D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xDD"],

        ["\xBA\xDE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3A\x5E"],
        ["\x3A\x5E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xDE"],

        ["\xBA\xDF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3A\x5F"],
        ["\x3A\x5F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xDF"],

        ["\xBA\xE0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3A\x60"],
        ["\x3A\x60",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xE0"],

        ["\xBA\xE1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3A\x61"],
        ["\x3A\x61",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xE1"],

        ["\xBA\xE2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3A\x62"],
        ["\x3A\x62",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xE2"],

        ["\xBA\xE3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3A\x63"],
        ["\x3A\x63",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xE3"],

        ["\xBA\xE4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3A\x64"],
        ["\x3A\x64",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xE4"],

        ["\xBA\xE5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3A\x65"],
        ["\x3A\x65",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xE5"],

        ["\xBA\xE6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3A\x66"],
        ["\x3A\x66",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xE6"],

        ["\xBA\xE7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3A\x67"],
        ["\x3A\x67",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xE7"],

        ["\xBA\xE8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3A\x68"],
        ["\x3A\x68",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xE8"],

        ["\xBA\xE9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3A\x69"],
        ["\x3A\x69",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xE9"],

        ["\xBA\xEA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3A\x6A"],
        ["\x3A\x6A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xEA"],

        ["\xBA\xEB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3A\x6B"],
        ["\x3A\x6B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xEB"],

        ["\xBA\xEC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3A\x6C"],
        ["\x3A\x6C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xEC"],

        ["\xBA\xED",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3A\x6D"],
        ["\x3A\x6D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xED"],

        ["\xBA\xEE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3A\x6E"],
        ["\x3A\x6E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xEE"],

        ["\xBA\xEF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3A\x6F"],
        ["\x3A\x6F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xEF"],

        ["\xBA\xF0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3A\x70"],
        ["\x3A\x70",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xF0"],

        ["\xBA\xF1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3A\x71"],
        ["\x3A\x71",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xF1"],

        ["\xBA\xF2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3A\x72"],
        ["\x3A\x72",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xF2"],

        ["\xBA\xF3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3A\x73"],
        ["\x3A\x73",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xF3"],

        ["\xBA\xF4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3A\x74"],
        ["\x3A\x74",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xF4"],

        ["\xBA\xF5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3A\x75"],
        ["\x3A\x75",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xF5"],

        ["\xBA\xF6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3A\x76"],
        ["\x3A\x76",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xF6"],

        ["\xBA\xF7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3A\x77"],
        ["\x3A\x77",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xF7"],

        ["\xBA\xF8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3A\x78"],
        ["\x3A\x78",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xF8"],

        ["\xBA\xF9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3A\x79"],
        ["\x3A\x79",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xF9"],

        ["\xBA\xFA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3A\x7A"],
        ["\x3A\x7A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xFA"],

        ["\xBA\xFB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3A\x7B"],
        ["\x3A\x7B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xFB"],

        ["\xBA\xFC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3A\x7C"],
        ["\x3A\x7C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xFC"],

        ["\xBA\xFD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3A\x7D"],
        ["\x3A\x7D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xFD"],

        ["\xBA\xFE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3A\x7E"],
        ["\x3A\x7E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xFE"],

        ["\xBB\xA1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3B\x21"],
        ["\x3B\x21",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xA1"],

        ["\xBB\xA2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3B\x22"],
        ["\x3B\x22",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xA2"],

        ["\xBB\xA3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3B\x23"],
        ["\x3B\x23",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xA3"],

        ["\xBB\xA4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3B\x24"],
        ["\x3B\x24",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xA4"],

        ["\xBB\xA5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3B\x25"],
        ["\x3B\x25",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xA5"],

        ["\xBB\xA6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3B\x26"],
        ["\x3B\x26",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xA6"],

        ["\xBB\xA7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3B\x27"],
        ["\x3B\x27",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xA7"],

        ["\xBB\xA8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3B\x28"],
        ["\x3B\x28",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xA8"],

        ["\xBB\xA9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3B\x29"],
        ["\x3B\x29",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xA9"],

        ["\xBB\xAA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3B\x2A"],
        ["\x3B\x2A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xAA"],

        ["\xBB\xAB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3B\x2B"],
        ["\x3B\x2B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xAB"],

        ["\xBB\xAC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3B\x2C"],
        ["\x3B\x2C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xAC"],

        ["\xBB\xAD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3B\x2D"],
        ["\x3B\x2D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xAD"],

        ["\xBB\xAE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3B\x2E"],
        ["\x3B\x2E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xAE"],

        ["\xBB\xAF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3B\x2F"],
        ["\x3B\x2F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xAF"],

        ["\xBB\xB0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3B\x30"],
        ["\x3B\x30",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xB0"],

        ["\xBB\xB1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3B\x31"],
        ["\x3B\x31",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xB1"],

        ["\xBB\xB2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3B\x32"],
        ["\x3B\x32",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xB2"],

        ["\xBB\xB3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3B\x33"],
        ["\x3B\x33",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xB3"],

        ["\xBB\xB4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3B\x34"],
        ["\x3B\x34",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xB4"],

        ["\xBB\xB5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3B\x35"],
        ["\x3B\x35",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xB5"],

        ["\xBB\xB6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3B\x36"],
        ["\x3B\x36",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xB6"],

        ["\xBB\xB7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3B\x37"],
        ["\x3B\x37",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xB7"],

        ["\xBB\xB8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3B\x38"],
        ["\x3B\x38",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xB8"],

        ["\xBB\xB9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3B\x39"],
        ["\x3B\x39",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xB9"],

        ["\xBB\xBA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3B\x3A"],
        ["\x3B\x3A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xBA"],

        ["\xBB\xBB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3B\x3B"],
        ["\x3B\x3B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xBB"],

        ["\xBB\xBC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3B\x3C"],
        ["\x3B\x3C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xBC"],

        ["\xBB\xBD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3B\x3D"],
        ["\x3B\x3D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xBD"],

        ["\xBB\xBE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3B\x3E"],
        ["\x3B\x3E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xBE"],

        ["\xBB\xBF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3B\x3F"],
        ["\x3B\x3F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xBF"],

        ["\xBB\xC0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3B\x40"],
        ["\x3B\x40",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xC0"],

        ["\xBB\xC1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3B\x41"],
        ["\x3B\x41",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xC1"],

        ["\xBB\xC2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3B\x42"],
        ["\x3B\x42",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xC2"],

        ["\xBB\xC3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3B\x43"],
        ["\x3B\x43",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xC3"],

        ["\xBB\xC4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3B\x44"],
        ["\x3B\x44",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xC4"],

        ["\xBB\xC5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3B\x45"],
        ["\x3B\x45",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xC5"],

        ["\xBB\xC6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3B\x46"],
        ["\x3B\x46",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xC6"],

        ["\xBB\xC7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3B\x47"],
        ["\x3B\x47",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xC7"],

        ["\xBB\xC8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3B\x48"],
        ["\x3B\x48",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xC8"],

        ["\xBB\xC9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3B\x49"],
        ["\x3B\x49",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xC9"],

        ["\xBB\xCA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3B\x4A"],
        ["\x3B\x4A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xCA"],

        ["\xBB\xCB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3B\x4B"],
        ["\x3B\x4B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xCB"],

        ["\xBB\xCC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3B\x4C"],
        ["\x3B\x4C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xCC"],

        ["\xBB\xCD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3B\x4D"],
        ["\x3B\x4D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xCD"],

        ["\xBB\xCE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3B\x4E"],
        ["\x3B\x4E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xCE"],

        ["\xBB\xCF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3B\x4F"],
        ["\x3B\x4F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xCF"],

        ["\xBB\xD0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3B\x50"],
        ["\x3B\x50",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xD0"],

        ["\xBB\xD1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3B\x51"],
        ["\x3B\x51",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xD1"],

        ["\xBB\xD2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3B\x52"],
        ["\x3B\x52",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xD2"],

        ["\xBB\xD3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3B\x53"],
        ["\x3B\x53",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xD3"],

        ["\xBB\xD4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3B\x54"],
        ["\x3B\x54",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xD4"],

        ["\xBB\xD5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3B\x55"],
        ["\x3B\x55",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xD5"],

        ["\xBB\xD6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3B\x56"],
        ["\x3B\x56",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xD6"],

        ["\xBB\xD7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3B\x57"],
        ["\x3B\x57",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xD7"],

        ["\xBB\xD8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3B\x58"],
        ["\x3B\x58",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xD8"],

        ["\xBB\xD9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3B\x59"],
        ["\x3B\x59",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xD9"],

        ["\xBB\xDA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3B\x5A"],
        ["\x3B\x5A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xDA"],

        ["\xBB\xDB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3B\x5B"],
        ["\x3B\x5B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xDB"],

        ["\xBB\xDC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3B\x5C"],
        ["\x3B\x5C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xDC"],

        ["\xBB\xDD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3B\x5D"],
        ["\x3B\x5D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xDD"],

        ["\xBB\xDE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3B\x5E"],
        ["\x3B\x5E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xDE"],

        ["\xBB\xDF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3B\x5F"],
        ["\x3B\x5F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xDF"],

        ["\xBB\xE0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3B\x60"],
        ["\x3B\x60",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xE0"],

        ["\xBB\xE1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3B\x61"],
        ["\x3B\x61",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xE1"],

        ["\xBB\xE2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3B\x62"],
        ["\x3B\x62",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xE2"],

        ["\xBB\xE3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3B\x63"],
        ["\x3B\x63",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xE3"],

        ["\xBB\xE4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3B\x64"],
        ["\x3B\x64",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xE4"],

        ["\xBB\xE5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3B\x65"],
        ["\x3B\x65",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xE5"],

        ["\xBB\xE6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3B\x66"],
        ["\x3B\x66",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xE6"],

        ["\xBB\xE7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3B\x67"],
        ["\x3B\x67",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xE7"],

        ["\xBB\xE8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3B\x68"],
        ["\x3B\x68",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xE8"],

        ["\xBB\xE9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3B\x69"],
        ["\x3B\x69",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xE9"],

        ["\xBB\xEA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3B\x6A"],
        ["\x3B\x6A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xEA"],

        ["\xBB\xEB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3B\x6B"],
        ["\x3B\x6B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xEB"],

        ["\xBB\xEC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3B\x6C"],
        ["\x3B\x6C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xEC"],

        ["\xBB\xED",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3B\x6D"],
        ["\x3B\x6D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xED"],

        ["\xBB\xEE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3B\x6E"],
        ["\x3B\x6E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xEE"],

        ["\xBB\xEF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3B\x6F"],
        ["\x3B\x6F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xEF"],

        ["\xBB\xF0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3B\x70"],
        ["\x3B\x70",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xF0"],

        ["\xBB\xF1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3B\x71"],
        ["\x3B\x71",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xF1"],

        ["\xBB\xF2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3B\x72"],
        ["\x3B\x72",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xF2"],

        ["\xBB\xF3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3B\x73"],
        ["\x3B\x73",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xF3"],

        ["\xBB\xF4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3B\x74"],
        ["\x3B\x74",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xF4"],

        ["\xBB\xF5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3B\x75"],
        ["\x3B\x75",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xF5"],

        ["\xBB\xF6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3B\x76"],
        ["\x3B\x76",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xF6"],

        ["\xBB\xF7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3B\x77"],
        ["\x3B\x77",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xF7"],

        ["\xBB\xF8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3B\x78"],
        ["\x3B\x78",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xF8"],

        ["\xBB\xF9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3B\x79"],
        ["\x3B\x79",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xF9"],

        ["\xBB\xFA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3B\x7A"],
        ["\x3B\x7A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xFA"],

        ["\xBB\xFB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3B\x7B"],
        ["\x3B\x7B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xFB"],

        ["\xBB\xFC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3B\x7C"],
        ["\x3B\x7C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xFC"],

        ["\xBB\xFD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3B\x7D"],
        ["\x3B\x7D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xFD"],

        ["\xBB\xFE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3B\x7E"],
        ["\x3B\x7E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBB\xFE"],

        ["\xBC\xA1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3C\x21"],
        ["\x3C\x21",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xA1"],

        ["\xBC\xA2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3C\x22"],
        ["\x3C\x22",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xA2"],

        ["\xBC\xA3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3C\x23"],
        ["\x3C\x23",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xA3"],

        ["\xBC\xA4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3C\x24"],
        ["\x3C\x24",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xA4"],

        ["\xBC\xA5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3C\x25"],
        ["\x3C\x25",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xA5"],

        ["\xBC\xA6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3C\x26"],
        ["\x3C\x26",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xA6"],

        ["\xBC\xA7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3C\x27"],
        ["\x3C\x27",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xA7"],

        ["\xBC\xA8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3C\x28"],
        ["\x3C\x28",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xA8"],

        ["\xBC\xA9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3C\x29"],
        ["\x3C\x29",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xA9"],

        ["\xBC\xAA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3C\x2A"],
        ["\x3C\x2A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xAA"],

        ["\xBC\xAB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3C\x2B"],
        ["\x3C\x2B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xAB"],

        ["\xBC\xAC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3C\x2C"],
        ["\x3C\x2C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xAC"],

        ["\xBC\xAD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3C\x2D"],
        ["\x3C\x2D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xAD"],

        ["\xBC\xAE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3C\x2E"],
        ["\x3C\x2E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xAE"],

        ["\xBC\xAF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3C\x2F"],
        ["\x3C\x2F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xAF"],

        ["\xBC\xB0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3C\x30"],
        ["\x3C\x30",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xB0"],

        ["\xBC\xB1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3C\x31"],
        ["\x3C\x31",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xB1"],

        ["\xBC\xB2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3C\x32"],
        ["\x3C\x32",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xB2"],

        ["\xBC\xB3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3C\x33"],
        ["\x3C\x33",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xB3"],

        ["\xBC\xB4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3C\x34"],
        ["\x3C\x34",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xB4"],

        ["\xBC\xB5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3C\x35"],
        ["\x3C\x35",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xB5"],

        ["\xBC\xB6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3C\x36"],
        ["\x3C\x36",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xB6"],

        ["\xBC\xB7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3C\x37"],
        ["\x3C\x37",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xB7"],

        ["\xBC\xB8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3C\x38"],
        ["\x3C\x38",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xB8"],

        ["\xBC\xB9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3C\x39"],
        ["\x3C\x39",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xB9"],

        ["\xBC\xBA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3C\x3A"],
        ["\x3C\x3A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xBA"],

        ["\xBC\xBB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3C\x3B"],
        ["\x3C\x3B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xBB"],

        ["\xBC\xBC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3C\x3C"],
        ["\x3C\x3C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xBC"],

        ["\xBC\xBD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3C\x3D"],
        ["\x3C\x3D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xBD"],

        ["\xBC\xBE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3C\x3E"],
        ["\x3C\x3E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xBE"],

        ["\xBC\xBF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3C\x3F"],
        ["\x3C\x3F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xBF"],

        ["\xBC\xC0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3C\x40"],
        ["\x3C\x40",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xC0"],

        ["\xBC\xC1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3C\x41"],
        ["\x3C\x41",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xC1"],

        ["\xBC\xC2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3C\x42"],
        ["\x3C\x42",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xC2"],

        ["\xBC\xC3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3C\x43"],
        ["\x3C\x43",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xC3"],

        ["\xBC\xC4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3C\x44"],
        ["\x3C\x44",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xC4"],

        ["\xBC\xC5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3C\x45"],
        ["\x3C\x45",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xC5"],

        ["\xBC\xC6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3C\x46"],
        ["\x3C\x46",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xC6"],

        ["\xBC\xC7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3C\x47"],
        ["\x3C\x47",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xC7"],

        ["\xBC\xC8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3C\x48"],
        ["\x3C\x48",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xC8"],

        ["\xBC\xC9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x22"],
        ["\x69\x22",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xC9"],

        ["\xBC\xCA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3C\x4A"],
        ["\x3C\x4A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xCA"],

        ["\xBC\xCB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3C\x4B"],
        ["\x3C\x4B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xCB"],

        ["\xBC\xCC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3C\x4C"],
        ["\x3C\x4C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xCC"],

        ["\xBC\xCD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3C\x4D"],
        ["\x3C\x4D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xCD"],

        ["\xBC\xCE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3C\x4E"],
        ["\x3C\x4E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xCE"],

        ["\xBC\xCF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3C\x4F"],
        ["\x3C\x4F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xCF"],

        ["\xBC\xD0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3C\x50"],
        ["\x3C\x50",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xD0"],

        ["\xBC\xD1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3C\x51"],
        ["\x3C\x51",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xD1"],

        ["\xBC\xD2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3C\x52"],
        ["\x3C\x52",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xD2"],

        ["\xBC\xD3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3C\x53"],
        ["\x3C\x53",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xD3"],

        ["\xBC\xD4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3C\x54"],
        ["\x3C\x54",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xD4"],

        ["\xBC\xD5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3C\x55"],
        ["\x3C\x55",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xD5"],

        ["\xBC\xD6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3C\x56"],
        ["\x3C\x56",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xD6"],

        ["\xBC\xD7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3C\x57"],
        ["\x3C\x57",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xD7"],

        ["\xBC\xD8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3C\x58"],
        ["\x3C\x58",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xD8"],

        ["\xBC\xD9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3C\x59"],
        ["\x3C\x59",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xD9"],

        ["\xBC\xDA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3C\x5A"],
        ["\x3C\x5A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xDA"],

        ["\xBC\xDB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3C\x5B"],
        ["\x3C\x5B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xDB"],

        ["\xBC\xDC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3C\x5C"],
        ["\x3C\x5C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xDC"],

        ["\xBC\xDD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3C\x5D"],
        ["\x3C\x5D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xDD"],

        ["\xBC\xDE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3C\x5E"],
        ["\x3C\x5E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xDE"],

        ["\xBC\xDF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3C\x5F"],
        ["\x3C\x5F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xDF"],

        ["\xBC\xE0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3C\x60"],
        ["\x3C\x60",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xE0"],

        ["\xBC\xE1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3C\x61"],
        ["\x3C\x61",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xE1"],

        ["\xBC\xE2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3C\x62"],
        ["\x3C\x62",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xE2"],

        ["\xBC\xE3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3C\x63"],
        ["\x3C\x63",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xE3"],

        ["\xBC\xE4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3C\x64"],
        ["\x3C\x64",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xE4"],

        ["\xBC\xE5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3C\x65"],
        ["\x3C\x65",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xE5"],

        ["\xBC\xE6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3C\x66"],
        ["\x3C\x66",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xE6"],

        ["\xBC\xE7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3C\x67"],
        ["\x3C\x67",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xE7"],

        ["\xBC\xE8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3C\x68"],
        ["\x3C\x68",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xE8"],

        ["\xBC\xE9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3C\x69"],
        ["\x3C\x69",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xE9"],

        ["\xBC\xEA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3C\x6A"],
        ["\x3C\x6A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xEA"],

        ["\xBC\xEB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3C\x6B"],
        ["\x3C\x6B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xEB"],

        ["\xBC\xEC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3C\x6C"],
        ["\x3C\x6C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xEC"],

        ["\xBC\xED",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3C\x6D"],
        ["\x3C\x6D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xED"],

        ["\xBC\xEE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3C\x6E"],
        ["\x3C\x6E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xEE"],

        ["\xBC\xEF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3C\x6F"],
        ["\x3C\x6F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xEF"],

        ["\xBC\xF0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3C\x70"],
        ["\x3C\x70",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xF0"],

        ["\xBC\xF1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3C\x71"],
        ["\x3C\x71",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xF1"],

        ["\xBC\xF2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3C\x72"],
        ["\x3C\x72",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xF2"],

        ["\xBC\xF3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3C\x73"],
        ["\x3C\x73",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xF3"],

        ["\xBC\xF4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3C\x74"],
        ["\x3C\x74",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xF4"],

        ["\xBC\xF5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3C\x75"],
        ["\x3C\x75",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xF5"],

        ["\xBC\xF6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3C\x76"],
        ["\x3C\x76",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xF6"],

        ["\xBC\xF7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3C\x77"],
        ["\x3C\x77",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xF7"],

        ["\xBC\xF8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3C\x78"],
        ["\x3C\x78",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xF8"],

        ["\xBC\xF9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3C\x79"],
        ["\x3C\x79",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xF9"],

        ["\xBC\xFA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3C\x7A"],
        ["\x3C\x7A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xFA"],

        ["\xBC\xFB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3C\x7B"],
        ["\x3C\x7B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xFB"],

        ["\xBC\xFC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3C\x7C"],
        ["\x3C\x7C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xFC"],

        ["\xBC\xFD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3C\x7D"],
        ["\x3C\x7D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xFD"],

        ["\xBC\xFE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3C\x7E"],
        ["\x3C\x7E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\xFE"],

        ["\xBD\xA1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3D\x21"],
        ["\x3D\x21",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xA1"],

        ["\xBD\xA2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3D\x22"],
        ["\x3D\x22",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xA2"],

        ["\xBD\xA3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3D\x23"],
        ["\x3D\x23",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xA3"],

        ["\xBD\xA4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3D\x24"],
        ["\x3D\x24",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xA4"],

        ["\xBD\xA5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3D\x25"],
        ["\x3D\x25",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xA5"],

        ["\xBD\xA6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3D\x26"],
        ["\x3D\x26",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xA6"],

        ["\xBD\xA7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3D\x27"],
        ["\x3D\x27",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xA7"],

        ["\xBD\xA8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3D\x28"],
        ["\x3D\x28",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xA8"],

        ["\xBD\xA9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3D\x29"],
        ["\x3D\x29",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xA9"],

        ["\xBD\xAA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3D\x2A"],
        ["\x3D\x2A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xAA"],

        ["\xBD\xAB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3D\x2B"],
        ["\x3D\x2B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xAB"],

        ["\xBD\xAC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3D\x2C"],
        ["\x3D\x2C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xAC"],

        ["\xBD\xAD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3D\x2D"],
        ["\x3D\x2D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xAD"],

        ["\xBD\xAE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3D\x2E"],
        ["\x3D\x2E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xAE"],

        ["\xBD\xAF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3D\x2F"],
        ["\x3D\x2F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xAF"],

        ["\xBD\xB0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3D\x30"],
        ["\x3D\x30",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xB0"],

        ["\xBD\xB1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3D\x31"],
        ["\x3D\x31",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xB1"],

        ["\xBD\xB2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3D\x32"],
        ["\x3D\x32",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xB2"],

        ["\xBD\xB3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3D\x33"],
        ["\x3D\x33",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xB3"],

        ["\xBD\xB4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3D\x34"],
        ["\x3D\x34",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xB4"],

        ["\xBD\xB5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3D\x35"],
        ["\x3D\x35",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xB5"],

        ["\xBD\xB6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3D\x36"],
        ["\x3D\x36",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xB6"],

        ["\xBD\xB7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3D\x37"],
        ["\x3D\x37",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xB7"],

        ["\xBD\xB8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3D\x38"],
        ["\x3D\x38",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xB8"],

        ["\xBD\xB9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3D\x39"],
        ["\x3D\x39",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xB9"],

        ["\xBD\xBA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3D\x3A"],
        ["\x3D\x3A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xBA"],

        ["\xBD\xBB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3D\x3B"],
        ["\x3D\x3B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xBB"],

        ["\xBD\xBC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3D\x3C"],
        ["\x3D\x3C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xBC"],

        ["\xBD\xBD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3D\x3D"],
        ["\x3D\x3D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xBD"],

        ["\xBD\xBE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3D\x3E"],
        ["\x3D\x3E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xBE"],

        ["\xBD\xBF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3D\x3F"],
        ["\x3D\x3F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xBF"],

        ["\xBD\xC0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3D\x40"],
        ["\x3D\x40",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xC0"],

        ["\xBD\xC1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3D\x41"],
        ["\x3D\x41",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xC1"],

        ["\xBD\xC2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3D\x42"],
        ["\x3D\x42",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xC2"],

        ["\xBD\xC3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3D\x43"],
        ["\x3D\x43",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xC3"],

        ["\xBD\xC4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3D\x44"],
        ["\x3D\x44",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xC4"],

        ["\xBD\xC5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3D\x45"],
        ["\x3D\x45",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xC5"],

        ["\xBD\xC6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3D\x46"],
        ["\x3D\x46",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xC6"],

        ["\xBD\xC7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3D\x47"],
        ["\x3D\x47",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xC7"],

        ["\xBD\xC8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3D\x48"],
        ["\x3D\x48",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xC8"],

        ["\xBD\xC9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3D\x49"],
        ["\x3D\x49",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xC9"],

        ["\xBD\xCA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3D\x4A"],
        ["\x3D\x4A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xCA"],

        ["\xBD\xCB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3D\x4B"],
        ["\x3D\x4B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xCB"],

        ["\xBD\xCC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3D\x4C"],
        ["\x3D\x4C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xCC"],

        ["\xBD\xCD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3D\x4D"],
        ["\x3D\x4D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xCD"],

        ["\xBD\xCE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3D\x4E"],
        ["\x3D\x4E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xCE"],

        ["\xBD\xCF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3D\x4F"],
        ["\x3D\x4F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xCF"],

        ["\xBD\xD0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3D\x50"],
        ["\x3D\x50",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xD0"],

        ["\xBD\xD1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3D\x51"],
        ["\x3D\x51",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xD1"],

        ["\xBD\xD2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3D\x52"],
        ["\x3D\x52",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xD2"],

        ["\xBD\xD3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3D\x53"],
        ["\x3D\x53",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xD3"],

        ["\xBD\xD4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3D\x54"],
        ["\x3D\x54",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xD4"],

        ["\xBD\xD5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3D\x55"],
        ["\x3D\x55",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xD5"],

        ["\xBD\xD6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3D\x56"],
        ["\x3D\x56",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xD6"],

        ["\xBD\xD7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3D\x57"],
        ["\x3D\x57",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xD7"],

        ["\xBD\xD8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3D\x58"],
        ["\x3D\x58",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xD8"],

        ["\xBD\xD9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3D\x59"],
        ["\x3D\x59",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xD9"],

        ["\xBD\xDA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3D\x5A"],
        ["\x3D\x5A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xDA"],

        ["\xBD\xDB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3D\x5B"],
        ["\x3D\x5B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xDB"],

        ["\xBD\xDC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3D\x5C"],
        ["\x3D\x5C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xDC"],

        ["\xBD\xDD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3D\x5D"],
        ["\x3D\x5D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xDD"],

        ["\xBD\xDE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3D\x5E"],
        ["\x3D\x5E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xDE"],

        ["\xBD\xDF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3D\x5F"],
        ["\x3D\x5F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xDF"],

        ["\xBD\xE0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3D\x60"],
        ["\x3D\x60",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xE0"],

        ["\xBD\xE1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3D\x61"],
        ["\x3D\x61",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xE1"],

        ["\xBD\xE2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3D\x62"],
        ["\x3D\x62",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xE2"],

        ["\xBD\xE3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3D\x63"],
        ["\x3D\x63",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xE3"],

        ["\xBD\xE4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3D\x64"],
        ["\x3D\x64",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xE4"],

        ["\xBD\xE5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3D\x65"],
        ["\x3D\x65",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xE5"],

        ["\xBD\xE6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3D\x66"],
        ["\x3D\x66",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xE6"],

        ["\xBD\xE7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3D\x67"],
        ["\x3D\x67",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xE7"],

        ["\xBD\xE8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3D\x68"],
        ["\x3D\x68",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xE8"],

        ["\xBD\xE9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3D\x69"],
        ["\x3D\x69",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xE9"],

        ["\xBD\xEA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3D\x6A"],
        ["\x3D\x6A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xEA"],

        ["\xBD\xEB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3D\x6B"],
        ["\x3D\x6B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xEB"],

        ["\xBD\xEC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3D\x6C"],
        ["\x3D\x6C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xEC"],

        ["\xBD\xED",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3D\x6D"],
        ["\x3D\x6D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xED"],

        ["\xBD\xEE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3D\x6E"],
        ["\x3D\x6E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xEE"],

        ["\xBD\xEF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3D\x6F"],
        ["\x3D\x6F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xEF"],

        ["\xBD\xF0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3D\x70"],
        ["\x3D\x70",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xF0"],

        ["\xBD\xF1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3D\x71"],
        ["\x3D\x71",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xF1"],

        ["\xBD\xF2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3D\x72"],
        ["\x3D\x72",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xF2"],

        ["\xBD\xF3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3D\x73"],
        ["\x3D\x73",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xF3"],

        ["\xBD\xF4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3D\x74"],
        ["\x3D\x74",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xF4"],

        ["\xBD\xF5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3D\x75"],
        ["\x3D\x75",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xF5"],

        ["\xBD\xF6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3D\x76"],
        ["\x3D\x76",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xF6"],

        ["\xBD\xF7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3D\x77"],
        ["\x3D\x77",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xF7"],

        ["\xBD\xF8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3D\x78"],
        ["\x3D\x78",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xF8"],

        ["\xBD\xF9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3D\x79"],
        ["\x3D\x79",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xF9"],

        ["\xBD\xFA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3D\x7A"],
        ["\x3D\x7A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xFA"],

        ["\xBD\xFB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3D\x7B"],
        ["\x3D\x7B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xFB"],

        ["\xBD\xFC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3D\x7C"],
        ["\x3D\x7C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xFC"],

        ["\xBD\xFD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3D\x7D"],
        ["\x3D\x7D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xFD"],

        ["\xBD\xFE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3D\x7E"],
        ["\x3D\x7E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xFE"],

        ["\xBE\xA1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3E\x21"],
        ["\x3E\x21",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xA1"],

        ["\xBE\xA2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3E\x22"],
        ["\x3E\x22",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xA2"],

        ["\xBE\xA3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3E\x23"],
        ["\x3E\x23",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xA3"],

        ["\xBE\xA4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3E\x24"],
        ["\x3E\x24",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xA4"],

        ["\xBE\xA5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3E\x25"],
        ["\x3E\x25",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xA5"],

        ["\xBE\xA6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3E\x26"],
        ["\x3E\x26",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xA6"],

        ["\xBE\xA7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3E\x27"],
        ["\x3E\x27",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xA7"],

        ["\xBE\xA8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3E\x28"],
        ["\x3E\x28",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xA8"],

        ["\xBE\xA9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3E\x29"],
        ["\x3E\x29",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xA9"],

        ["\xBE\xAA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3E\x2A"],
        ["\x3E\x2A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xAA"],

        ["\xBE\xAB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3E\x2B"],
        ["\x3E\x2B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xAB"],

        ["\xBE\xAC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3E\x2C"],
        ["\x3E\x2C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xAC"],

        ["\xBE\xAD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3E\x2D"],
        ["\x3E\x2D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xAD"],

        ["\xBE\xAE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3E\x2E"],
        ["\x3E\x2E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xAE"],

        ["\xBE\xAF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3E\x2F"],
        ["\x3E\x2F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xAF"],

        ["\xBE\xB0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3E\x30"],
        ["\x3E\x30",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xB0"],

        ["\xBE\xB1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3E\x31"],
        ["\x3E\x31",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xB1"],

        ["\xBE\xB2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3E\x32"],
        ["\x3E\x32",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xB2"],

        ["\xBE\xB3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3E\x33"],
        ["\x3E\x33",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xB3"],

        ["\xBE\xB4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3E\x34"],
        ["\x3E\x34",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xB4"],

        ["\xBE\xB5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3E\x35"],
        ["\x3E\x35",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xB5"],

        ["\xBE\xB6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3E\x36"],
        ["\x3E\x36",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xB6"],

        ["\xBE\xB7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3E\x37"],
        ["\x3E\x37",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xB7"],

        ["\xBE\xB8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3E\x38"],
        ["\x3E\x38",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xB8"],

        ["\xBE\xB9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3E\x39"],
        ["\x3E\x39",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xB9"],

        ["\xBE\xBA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3E\x3A"],
        ["\x3E\x3A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xBA"],

        ["\xBE\xBB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3E\x3B"],
        ["\x3E\x3B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xBB"],

        ["\xBE\xBC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3E\x3C"],
        ["\x3E\x3C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xBC"],

        ["\xBE\xBD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3E\x3D"],
        ["\x3E\x3D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xBD"],

        ["\xBE\xBE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3E\x3E"],
        ["\x3E\x3E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xBE"],

        ["\xBE\xBF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3E\x3F"],
        ["\x3E\x3F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xBF"],

        ["\xBE\xC0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3E\x40"],
        ["\x3E\x40",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xC0"],

        ["\xBE\xC1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3E\x41"],
        ["\x3E\x41",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xC1"],

        ["\xBE\xC2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3E\x42"],
        ["\x3E\x42",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xC2"],

        ["\xBE\xC3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3E\x43"],
        ["\x3E\x43",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xC3"],

        ["\xBE\xC4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3E\x44"],
        ["\x3E\x44",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xC4"],

        ["\xBE\xC5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3E\x45"],
        ["\x3E\x45",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xC5"],

        ["\xBE\xC6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3E\x46"],
        ["\x3E\x46",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xC6"],

        ["\xBE\xC7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3E\x47"],
        ["\x3E\x47",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xC7"],

        ["\xBE\xC8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3E\x48"],
        ["\x3E\x48",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xC8"],

        ["\xBE\xC9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3E\x49"],
        ["\x3E\x49",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xC9"],

        ["\xBE\xCA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3E\x4A"],
        ["\x3E\x4A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xCA"],

        ["\xBE\xCB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3E\x4B"],
        ["\x3E\x4B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xCB"],

        ["\xBE\xCC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3E\x4C"],
        ["\x3E\x4C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xCC"],

        ["\xBE\xCD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3E\x4D"],
        ["\x3E\x4D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xCD"],

        ["\xBE\xCE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3E\x4E"],
        ["\x3E\x4E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xCE"],

        ["\xBE\xCF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3E\x4F"],
        ["\x3E\x4F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xCF"],

        ["\xBE\xD0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3E\x50"],
        ["\x3E\x50",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xD0"],

        ["\xBE\xD1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3E\x51"],
        ["\x3E\x51",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xD1"],

        ["\xBE\xD2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3E\x52"],
        ["\x3E\x52",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xD2"],

        ["\xBE\xD3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3E\x53"],
        ["\x3E\x53",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xD3"],

        ["\xBE\xD4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3E\x54"],
        ["\x3E\x54",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xD4"],

        ["\xBE\xD5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3E\x55"],
        ["\x3E\x55",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xD5"],

        ["\xBE\xD6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3E\x56"],
        ["\x3E\x56",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xD6"],

        ["\xBE\xD7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3E\x57"],
        ["\x3E\x57",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xD7"],

        ["\xBE\xD8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3E\x58"],
        ["\x3E\x58",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xD8"],

        ["\xBE\xD9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3E\x59"],
        ["\x3E\x59",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xD9"],

        ["\xBE\xDA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3E\x5A"],
        ["\x3E\x5A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xDA"],

        ["\xBE\xDB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3E\x5B"],
        ["\x3E\x5B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xDB"],

        ["\xBE\xDC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3E\x5C"],
        ["\x3E\x5C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xDC"],

        ["\xBE\xDD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3E\x5D"],
        ["\x3E\x5D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xDD"],

        ["\xBE\xDE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3E\x5E"],
        ["\x3E\x5E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xDE"],

        ["\xBE\xDF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3E\x5F"],
        ["\x3E\x5F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xDF"],

        ["\xBE\xE0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3E\x60"],
        ["\x3E\x60",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xE0"],

        ["\xBE\xE1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3E\x61"],
        ["\x3E\x61",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xE1"],

        ["\xBE\xE2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3E\x62"],
        ["\x3E\x62",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xE2"],

        ["\xBE\xE3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3E\x63"],
        ["\x3E\x63",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xE3"],

        ["\xBE\xE4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3E\x64"],
        ["\x3E\x64",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xE4"],

        ["\xBE\xE5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3E\x65"],
        ["\x3E\x65",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xE5"],

        ["\xBE\xE6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3E\x66"],
        ["\x3E\x66",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xE6"],

        ["\xBE\xE7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3E\x67"],
        ["\x3E\x67",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xE7"],

        ["\xBE\xE8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3E\x68"],
        ["\x3E\x68",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xE8"],

        ["\xBE\xE9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3E\x69"],
        ["\x3E\x69",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xE9"],

        ["\xBE\xEA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3E\x6A"],
        ["\x3E\x6A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xEA"],

        ["\xBE\xEB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3E\x6B"],
        ["\x3E\x6B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xEB"],

        ["\xBE\xEC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3E\x6C"],
        ["\x3E\x6C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xEC"],

        ["\xBE\xED",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3E\x6D"],
        ["\x3E\x6D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xED"],

        ["\xBE\xEE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3E\x6E"],
        ["\x3E\x6E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xEE"],

        ["\xBE\xEF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3E\x6F"],
        ["\x3E\x6F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xEF"],

        ["\xBE\xF0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3E\x70"],
        ["\x3E\x70",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xF0"],

        ["\xBE\xF1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3E\x71"],
        ["\x3E\x71",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xF1"],

        ["\xBE\xF2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3E\x72"],
        ["\x3E\x72",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xF2"],

        ["\xBE\xF3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3E\x73"],
        ["\x3E\x73",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xF3"],

        ["\xBE\xF4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3E\x74"],
        ["\x3E\x74",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xF4"],

        ["\xBE\xF5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3E\x75"],
        ["\x3E\x75",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xF5"],

        ["\xBE\xF6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3E\x76"],
        ["\x3E\x76",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xF6"],

        ["\xBE\xF7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3E\x77"],
        ["\x3E\x77",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xF7"],

        ["\xBE\xF8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3E\x78"],
        ["\x3E\x78",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xF8"],

        ["\xBE\xF9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3E\x79"],
        ["\x3E\x79",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xF9"],

        ["\xBE\xFA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3E\x7A"],
        ["\x3E\x7A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xFA"],

        ["\xBE\xFB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3E\x7B"],
        ["\x3E\x7B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xFB"],

        ["\xBE\xFC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3E\x7C"],
        ["\x3E\x7C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xFC"],

        ["\xBE\xFD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3E\x7D"],
        ["\x3E\x7D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xFD"],

        ["\xBE\xFE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3E\x7E"],
        ["\x3E\x7E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBE\xFE"],

        ["\xBF\xA1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3F\x21"],
        ["\x3F\x21",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xA1"],

        ["\xBF\xA2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3F\x22"],
        ["\x3F\x22",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xA2"],

        ["\xBF\xA3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3F\x23"],
        ["\x3F\x23",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xA3"],

        ["\xBF\xA4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3F\x24"],
        ["\x3F\x24",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xA4"],

        ["\xBF\xA5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3F\x25"],
        ["\x3F\x25",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xA5"],

        ["\xBF\xA6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3F\x26"],
        ["\x3F\x26",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xA6"],

        ["\xBF\xA7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3F\x27"],
        ["\x3F\x27",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xA7"],

        ["\xBF\xA8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3F\x28"],
        ["\x3F\x28",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xA8"],

        ["\xBF\xA9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3F\x29"],
        ["\x3F\x29",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xA9"],

        ["\xBF\xAA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3F\x2A"],
        ["\x3F\x2A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xAA"],

        ["\xBF\xAB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3F\x2B"],
        ["\x3F\x2B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xAB"],

        ["\xBF\xAC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3F\x2C"],
        ["\x3F\x2C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xAC"],

        ["\xBF\xAD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3F\x2D"],
        ["\x3F\x2D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xAD"],

        ["\xBF\xAE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3F\x2E"],
        ["\x3F\x2E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xAE"],

        ["\xBF\xAF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3F\x2F"],
        ["\x3F\x2F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xAF"],

        ["\xBF\xB0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3F\x30"],
        ["\x3F\x30",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xB0"],

        ["\xBF\xB1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3F\x31"],
        ["\x3F\x31",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xB1"],

        ["\xBF\xB2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3F\x32"],
        ["\x3F\x32",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xB2"],

        ["\xBF\xB3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3F\x33"],
        ["\x3F\x33",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xB3"],

        ["\xBF\xB4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3F\x34"],
        ["\x3F\x34",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xB4"],

        ["\xBF\xB5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3F\x35"],
        ["\x3F\x35",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xB5"],

        ["\xBF\xB6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3F\x36"],
        ["\x3F\x36",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xB6"],

        ["\xBF\xB7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3F\x37"],
        ["\x3F\x37",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xB7"],

        ["\xBF\xB8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3F\x38"],
        ["\x3F\x38",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xB8"],

        ["\xBF\xB9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3F\x39"],
        ["\x3F\x39",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xB9"],

        ["\xBF\xBA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3F\x3A"],
        ["\x3F\x3A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xBA"],

        ["\xBF\xBB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3F\x3B"],
        ["\x3F\x3B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xBB"],

        ["\xBF\xBC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3F\x3C"],
        ["\x3F\x3C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xBC"],

        ["\xBF\xBD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3F\x3D"],
        ["\x3F\x3D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xBD"],

        ["\xBF\xBE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3F\x3E"],
        ["\x3F\x3E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xBE"],

        ["\xBF\xBF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3F\x3F"],
        ["\x3F\x3F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xBF"],

        ["\xBF\xC0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3F\x40"],
        ["\x3F\x40",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xC0"],

        ["\xBF\xC1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3F\x41"],
        ["\x3F\x41",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xC1"],

        ["\xBF\xC2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3F\x42"],
        ["\x3F\x42",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xC2"],

        ["\xBF\xC3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3F\x43"],
        ["\x3F\x43",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xC3"],

        ["\xBF\xC4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3F\x44"],
        ["\x3F\x44",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xC4"],

        ["\xBF\xC5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3F\x45"],
        ["\x3F\x45",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xC5"],

        ["\xBF\xC6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3F\x46"],
        ["\x3F\x46",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xC6"],

        ["\xBF\xC7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3F\x47"],
        ["\x3F\x47",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xC7"],

        ["\xBF\xC8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3F\x48"],
        ["\x3F\x48",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xC8"],

        ["\xBF\xC9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3F\x49"],
        ["\x3F\x49",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xC9"],

        ["\xBF\xCA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3F\x4A"],
        ["\x3F\x4A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xCA"],

        ["\xBF\xCB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3F\x4B"],
        ["\x3F\x4B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xCB"],

        ["\xBF\xCC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3F\x4C"],
        ["\x3F\x4C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xCC"],

        ["\xBF\xCD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3F\x4D"],
        ["\x3F\x4D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xCD"],

        ["\xBF\xCE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3F\x4E"],
        ["\x3F\x4E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xCE"],

        ["\xBF\xCF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3F\x4F"],
        ["\x3F\x4F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xCF"],

        ["\xBF\xD0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3F\x50"],
        ["\x3F\x50",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xD0"],

        ["\xBF\xD1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3F\x51"],
        ["\x3F\x51",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xD1"],

        ["\xBF\xD2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3F\x52"],
        ["\x3F\x52",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xD2"],

        ["\xBF\xD3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3F\x53"],
        ["\x3F\x53",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xD3"],

        ["\xBF\xD4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3F\x54"],
        ["\x3F\x54",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xD4"],

        ["\xBF\xD5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3F\x55"],
        ["\x3F\x55",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xD5"],

        ["\xBF\xD6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3F\x56"],
        ["\x3F\x56",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xD6"],

        ["\xBF\xD7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3F\x57"],
        ["\x3F\x57",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xD7"],

        ["\xBF\xD8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3F\x58"],
        ["\x3F\x58",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xD8"],

        ["\xBF\xD9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x57"],
        ["\x70\x57",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xD9"],

        ["\xBF\xDA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3F\x5A"],
        ["\x3F\x5A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xDA"],

        ["\xBF\xDB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3F\x5B"],
        ["\x3F\x5B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xDB"],

        ["\xBF\xDC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3F\x5C"],
        ["\x3F\x5C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xDC"],

        ["\xBF\xDD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3F\x5D"],
        ["\x3F\x5D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xDD"],

        ["\xBF\xDE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3F\x5E"],
        ["\x3F\x5E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xDE"],

        ["\xBF\xDF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3F\x5F"],
        ["\x3F\x5F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xDF"],

        ["\xBF\xE0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3F\x60"],
        ["\x3F\x60",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xE0"],

        ["\xBF\xE1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3F\x61"],
        ["\x3F\x61",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xE1"],

        ["\xBF\xE2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3F\x62"],
        ["\x3F\x62",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xE2"],

        ["\xBF\xE3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3F\x63"],
        ["\x3F\x63",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xE3"],

        ["\xBF\xE4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3F\x64"],
        ["\x3F\x64",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xE4"],

        ["\xBF\xE5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3F\x65"],
        ["\x3F\x65",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xE5"],

        ["\xBF\xE6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3F\x66"],
        ["\x3F\x66",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xE6"],

        ["\xBF\xE7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3F\x67"],
        ["\x3F\x67",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xE7"],

        ["\xBF\xE8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3F\x68"],
        ["\x3F\x68",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xE8"],

        ["\xBF\xE9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3F\x69"],
        ["\x3F\x69",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xE9"],

        ["\xBF\xEA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3F\x6A"],
        ["\x3F\x6A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xEA"],

        ["\xBF\xEB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3F\x6B"],
        ["\x3F\x6B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xEB"],

        ["\xBF\xEC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3F\x6C"],
        ["\x3F\x6C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xEC"],

        ["\xBF\xED",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3F\x6D"],
        ["\x3F\x6D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xED"],

        ["\xBF\xEE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3F\x6E"],
        ["\x3F\x6E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xEE"],

        ["\xBF\xEF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3F\x6F"],
        ["\x3F\x6F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xEF"],

        ["\xBF\xF0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3F\x70"],
        ["\x3F\x70",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xF0"],

        ["\xBF\xF1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3F\x71"],
        ["\x3F\x71",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xF1"],

        ["\xBF\xF2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3F\x72"],
        ["\x3F\x72",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xF2"],

        ["\xBF\xF3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3F\x73"],
        ["\x3F\x73",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xF3"],

        ["\xBF\xF4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3F\x74"],
        ["\x3F\x74",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xF4"],

        ["\xBF\xF5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3F\x75"],
        ["\x3F\x75",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xF5"],

        ["\xBF\xF6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3F\x76"],
        ["\x3F\x76",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xF6"],

        ["\xBF\xF7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3F\x77"],
        ["\x3F\x77",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xF7"],

        ["\xBF\xF8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3F\x78"],
        ["\x3F\x78",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xF8"],

        ["\xBF\xF9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3F\x79"],
        ["\x3F\x79",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xF9"],

        ["\xBF\xFA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3F\x7A"],
        ["\x3F\x7A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xFA"],

        ["\xBF\xFB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3F\x7B"],
        ["\x3F\x7B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xFB"],

        ["\xBF\xFC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3F\x7C"],
        ["\x3F\x7C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xFC"],

        ["\xBF\xFD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3F\x7D"],
        ["\x3F\x7D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xFD"],

        ["\xBF\xFE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3F\x7E"],
        ["\x3F\x7E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xFE"],

        ["\xC0\xA1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x40\x21"],
        ["\x40\x21",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xA1"],

        ["\xC0\xA2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x40\x22"],
        ["\x40\x22",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xA2"],

        ["\xC0\xA3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x40\x23"],
        ["\x40\x23",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xA3"],

        ["\xC0\xA4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x40\x24"],
        ["\x40\x24",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xA4"],

        ["\xC0\xA5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x40\x25"],
        ["\x40\x25",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xA5"],

        ["\xC0\xA6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x40\x26"],
        ["\x40\x26",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xA6"],

        ["\xC0\xA7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x40\x27"],
        ["\x40\x27",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xA7"],

        ["\xC0\xA8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x40\x28"],
        ["\x40\x28",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xA8"],

        ["\xC0\xA9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x40\x29"],
        ["\x40\x29",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xA9"],

        ["\xC0\xAA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x40\x2A"],
        ["\x40\x2A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xAA"],

        ["\xC0\xAB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x40\x2B"],
        ["\x40\x2B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xAB"],

        ["\xC0\xAC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x40\x2C"],
        ["\x40\x2C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xAC"],

        ["\xC0\xAD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x40\x2D"],
        ["\x40\x2D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xAD"],

        ["\xC0\xAE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x40\x2E"],
        ["\x40\x2E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xAE"],

        ["\xC0\xAF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x40\x2F"],
        ["\x40\x2F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xAF"],

        ["\xC0\xB0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x40\x30"],
        ["\x40\x30",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xB0"],

        ["\xC0\xB1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x40\x31"],
        ["\x40\x31",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xB1"],

        ["\xC0\xB2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x40\x32"],
        ["\x40\x32",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xB2"],

        ["\xC0\xB3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x40\x33"],
        ["\x40\x33",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xB3"],

        ["\xC0\xB4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x40\x34"],
        ["\x40\x34",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xB4"],

        ["\xC0\xB5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x40\x35"],
        ["\x40\x35",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xB5"],

        ["\xC0\xB6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x40\x36"],
        ["\x40\x36",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xB6"],

        ["\xC0\xB7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x40\x37"],
        ["\x40\x37",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xB7"],

        ["\xC0\xB8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x40\x38"],
        ["\x40\x38",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xB8"],

        ["\xC0\xB9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x40\x39"],
        ["\x40\x39",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xB9"],

        ["\xC0\xBA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x40\x3A"],
        ["\x40\x3A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xBA"],

        ["\xC0\xBB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x40\x3B"],
        ["\x40\x3B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xBB"],

        ["\xC0\xBC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x40\x3C"],
        ["\x40\x3C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xBC"],

        ["\xC0\xBD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x40\x3D"],
        ["\x40\x3D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xBD"],

        ["\xC0\xBE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x40\x3E"],
        ["\x40\x3E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xBE"],

        ["\xC0\xBF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x40\x3F"],
        ["\x40\x3F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xBF"],

        ["\xC0\xC0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x40\x40"],
        ["\x40\x40",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xC0"],

        ["\xC0\xC1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x40\x41"],
        ["\x40\x41",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xC1"],

        ["\xC0\xC2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x40\x42"],
        ["\x40\x42",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xC2"],

        ["\xC0\xC3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x40\x43"],
        ["\x40\x43",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xC3"],

        ["\xC0\xC4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x40\x44"],
        ["\x40\x44",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xC4"],

        ["\xC0\xC5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x40\x45"],
        ["\x40\x45",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xC5"],

        ["\xC0\xC6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x40\x46"],
        ["\x40\x46",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xC6"],

        ["\xC0\xC7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x40\x47"],
        ["\x40\x47",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xC7"],

        ["\xC0\xC8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x40\x48"],
        ["\x40\x48",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xC8"],

        ["\xC0\xC9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x40\x49"],
        ["\x40\x49",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xC9"],

        ["\xC0\xCA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x40\x4A"],
        ["\x40\x4A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xCA"],

        ["\xC0\xCB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x40\x4B"],
        ["\x40\x4B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xCB"],

        ["\xC0\xCC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x40\x4C"],
        ["\x40\x4C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xCC"],

        ["\xC0\xCD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x40\x4D"],
        ["\x40\x4D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xCD"],

        ["\xC0\xCE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x40\x4E"],
        ["\x40\x4E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xCE"],

        ["\xC0\xCF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x40\x4F"],
        ["\x40\x4F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xCF"],

        ["\xC0\xD0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x40\x50"],
        ["\x40\x50",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xD0"],

        ["\xC0\xD1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x40\x51"],
        ["\x40\x51",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xD1"],

        ["\xC0\xD2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x40\x52"],
        ["\x40\x52",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xD2"],

        ["\xC0\xD3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x40\x53"],
        ["\x40\x53",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xD3"],

        ["\xC0\xD4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x40\x54"],
        ["\x40\x54",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xD4"],

        ["\xC0\xD5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x40\x55"],
        ["\x40\x55",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xD5"],

        ["\xC0\xD6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x40\x56"],
        ["\x40\x56",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xD6"],

        ["\xC0\xD7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x40\x57"],
        ["\x40\x57",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xD7"],

        ["\xC0\xD8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x40\x58"],
        ["\x40\x58",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xD8"],

        ["\xC0\xD9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x40\x59"],
        ["\x40\x59",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xD9"],

        ["\xC0\xDA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x40\x5A"],
        ["\x40\x5A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xDA"],

        ["\xC0\xDB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x40\x5B"],
        ["\x40\x5B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xDB"],

        ["\xC0\xDC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x40\x5C"],
        ["\x40\x5C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xDC"],

        ["\xC0\xDD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x40\x5D"],
        ["\x40\x5D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xDD"],

        ["\xC0\xDE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x40\x5E"],
        ["\x40\x5E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xDE"],

        ["\xC0\xDF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x40\x5F"],
        ["\x40\x5F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xDF"],

        ["\xC0\xE0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x40\x60"],
        ["\x40\x60",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xE0"],

        ["\xC0\xE1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x40\x61"],
        ["\x40\x61",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xE1"],

        ["\xC0\xE2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x40\x62"],
        ["\x40\x62",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xE2"],

        ["\xC0\xE3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x40\x63"],
        ["\x40\x63",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xE3"],

        ["\xC0\xE4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x40\x64"],
        ["\x40\x64",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xE4"],

        ["\xC0\xE5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x40\x65"],
        ["\x40\x65",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xE5"],

        ["\xC0\xE6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x40\x66"],
        ["\x40\x66",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xE6"],

        ["\xC0\xE7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x40\x67"],
        ["\x40\x67",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xE7"],

        ["\xC0\xE8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x40\x68"],
        ["\x40\x68",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xE8"],

        ["\xC0\xE9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x40\x69"],
        ["\x40\x69",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xE9"],

        ["\xC0\xEA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x40\x6A"],
        ["\x40\x6A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xEA"],

        ["\xC0\xEB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x40\x6B"],
        ["\x40\x6B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xEB"],

        ["\xC0\xEC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x40\x6C"],
        ["\x40\x6C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xEC"],

        ["\xC0\xED",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x40\x6D"],
        ["\x40\x6D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xED"],

        ["\xC0\xEE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x40\x6E"],
        ["\x40\x6E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xEE"],

        ["\xC0\xEF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x40\x6F"],
        ["\x40\x6F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xEF"],

        ["\xC0\xF0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x40\x70"],
        ["\x40\x70",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xF0"],

        ["\xC0\xF1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x40\x71"],
        ["\x40\x71",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xF1"],

        ["\xC0\xF2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x40\x72"],
        ["\x40\x72",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xF2"],

        ["\xC0\xF3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x40\x73"],
        ["\x40\x73",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xF3"],

        ["\xC0\xF4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x40\x74"],
        ["\x40\x74",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xF4"],

        ["\xC0\xF5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x40\x75"],
        ["\x40\x75",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xF5"],

        ["\xC0\xF6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x40\x76"],
        ["\x40\x76",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xF6"],

        ["\xC0\xF7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x40\x77"],
        ["\x40\x77",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xF7"],

        ["\xC0\xF8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x40\x78"],
        ["\x40\x78",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xF8"],

        ["\xC0\xF9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x40\x79"],
        ["\x40\x79",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xF9"],

        ["\xC0\xFA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x40\x7A"],
        ["\x40\x7A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xFA"],

        ["\xC0\xFB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x40\x7B"],
        ["\x40\x7B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xFB"],

        ["\xC0\xFC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x40\x7C"],
        ["\x40\x7C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xFC"],

        ["\xC0\xFD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x40\x7D"],
        ["\x40\x7D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xFD"],

        ["\xC0\xFE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x40\x7E"],
        ["\x40\x7E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC0\xFE"],

        ["\xC1\xA1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x41\x21"],
        ["\x41\x21",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xA1"],

        ["\xC1\xA2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x41\x22"],
        ["\x41\x22",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xA2"],

        ["\xC1\xA3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x41\x23"],
        ["\x41\x23",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xA3"],

        ["\xC1\xA4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x41\x24"],
        ["\x41\x24",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xA4"],

        ["\xC1\xA5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x41\x25"],
        ["\x41\x25",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xA5"],

        ["\xC1\xA6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x41\x26"],
        ["\x41\x26",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xA6"],

        ["\xC1\xA7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x41\x27"],
        ["\x41\x27",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xA7"],

        ["\xC1\xA8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x4D"],
        ["\x6C\x4D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xA8"],

        ["\xC1\xA9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x41\x29"],
        ["\x41\x29",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xA9"],

        ["\xC1\xAA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x41\x2A"],
        ["\x41\x2A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xAA"],

        ["\xC1\xAB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x41\x2B"],
        ["\x41\x2B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xAB"],

        ["\xC1\xAC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x41\x2C"],
        ["\x41\x2C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xAC"],

        ["\xC1\xAD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x41\x2D"],
        ["\x41\x2D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xAD"],

        ["\xC1\xAE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x41\x2E"],
        ["\x41\x2E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xAE"],

        ["\xC1\xAF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x41\x2F"],
        ["\x41\x2F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xAF"],

        ["\xC1\xB0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x41\x30"],
        ["\x41\x30",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xB0"],

        ["\xC1\xB1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x41\x31"],
        ["\x41\x31",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xB1"],

        ["\xC1\xB2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x41\x32"],
        ["\x41\x32",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xB2"],

        ["\xC1\xB3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x41\x33"],
        ["\x41\x33",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xB3"],

        ["\xC1\xB4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x41\x34"],
        ["\x41\x34",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xB4"],

        ["\xC1\xB5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x41\x35"],
        ["\x41\x35",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xB5"],

        ["\xC1\xB6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x41\x36"],
        ["\x41\x36",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xB6"],

        ["\xC1\xB7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x41\x37"],
        ["\x41\x37",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xB7"],

        ["\xC1\xB8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x41\x38"],
        ["\x41\x38",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xB8"],

        ["\xC1\xB9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x41\x39"],
        ["\x41\x39",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xB9"],

        ["\xC1\xBA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x41\x3A"],
        ["\x41\x3A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xBA"],

        ["\xC1\xBB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x41\x3B"],
        ["\x41\x3B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xBB"],

        ["\xC1\xBC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x41\x3C"],
        ["\x41\x3C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xBC"],

        ["\xC1\xBD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x41\x3D"],
        ["\x41\x3D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xBD"],

        ["\xC1\xBE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x41\x3E"],
        ["\x41\x3E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xBE"],

        ["\xC1\xBF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x41\x3F"],
        ["\x41\x3F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xBF"],

        ["\xC1\xC0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x41\x40"],
        ["\x41\x40",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xC0"],

        ["\xC1\xC1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x41\x41"],
        ["\x41\x41",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xC1"],

        ["\xC1\xC2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x41\x42"],
        ["\x41\x42",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xC2"],

        ["\xC1\xC3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x41\x43"],
        ["\x41\x43",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xC3"],

        ["\xC1\xC4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x41\x44"],
        ["\x41\x44",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xC4"],

        ["\xC1\xC5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x41\x45"],
        ["\x41\x45",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xC5"],

        ["\xC1\xC6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x41\x46"],
        ["\x41\x46",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xC6"],

        ["\xC1\xC7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x41\x47"],
        ["\x41\x47",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xC7"],

        ["\xC1\xC8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x41\x48"],
        ["\x41\x48",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xC8"],

        ["\xC1\xC9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x41\x49"],
        ["\x41\x49",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xC9"],

        ["\xC1\xCA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x41\x4A"],
        ["\x41\x4A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xCA"],

        ["\xC1\xCB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x41\x4B"],
        ["\x41\x4B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xCB"],

        ["\xC1\xCC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x41\x4C"],
        ["\x41\x4C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xCC"],

        ["\xC1\xCD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x41\x4D"],
        ["\x41\x4D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xCD"],

        ["\xC1\xCE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x41\x4E"],
        ["\x41\x4E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xCE"],

        ["\xC1\xCF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x41\x4F"],
        ["\x41\x4F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xCF"],

        ["\xC1\xD0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x41\x50"],
        ["\x41\x50",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xD0"],

        ["\xC1\xD1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x41\x51"],
        ["\x41\x51",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xD1"],

        ["\xC1\xD2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x41\x52"],
        ["\x41\x52",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xD2"],

        ["\xC1\xD3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x41\x53"],
        ["\x41\x53",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xD3"],

        ["\xC1\xD4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x41\x54"],
        ["\x41\x54",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xD4"],

        ["\xC1\xD5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x41\x55"],
        ["\x41\x55",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xD5"],

        ["\xC1\xD6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x41\x56"],
        ["\x41\x56",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xD6"],

        ["\xC1\xD7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x41\x57"],
        ["\x41\x57",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xD7"],

        ["\xC1\xD8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x41\x58"],
        ["\x41\x58",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xD8"],

        ["\xC1\xD9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x41\x59"],
        ["\x41\x59",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xD9"],

        ["\xC1\xDA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x41\x5A"],
        ["\x41\x5A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xDA"],

        ["\xC1\xDB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x41\x5B"],
        ["\x41\x5B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xDB"],

        ["\xC1\xDC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x41\x5C"],
        ["\x41\x5C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xDC"],

        ["\xC1\xDD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x41\x5D"],
        ["\x41\x5D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xDD"],

        ["\xC1\xDE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x41\x5E"],
        ["\x41\x5E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xDE"],

        ["\xC1\xDF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x41\x5F"],
        ["\x41\x5F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xDF"],

        ["\xC1\xE0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x41\x60"],
        ["\x41\x60",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xE0"],

        ["\xC1\xE1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x41\x61"],
        ["\x41\x61",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xE1"],

        ["\xC1\xE2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x41\x62"],
        ["\x41\x62",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xE2"],

        ["\xC1\xE3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x41\x63"],
        ["\x41\x63",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xE3"],

        ["\xC1\xE4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x41\x64"],
        ["\x41\x64",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xE4"],

        ["\xC1\xE5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x41\x65"],
        ["\x41\x65",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xE5"],

        ["\xC1\xE6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x41\x66"],
        ["\x41\x66",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xE6"],

        ["\xC1\xE7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x41\x67"],
        ["\x41\x67",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xE7"],

        ["\xC1\xE8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x41\x68"],
        ["\x41\x68",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xE8"],

        ["\xC1\xE9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x41\x69"],
        ["\x41\x69",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xE9"],

        ["\xC1\xEA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x41\x6A"],
        ["\x41\x6A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xEA"],

        ["\xC1\xEB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x41\x6B"],
        ["\x41\x6B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xEB"],

        ["\xC1\xEC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x41\x6C"],
        ["\x41\x6C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xEC"],

        ["\xC1\xED",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x41\x6D"],
        ["\x41\x6D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xED"],

        ["\xC1\xEE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x41\x6E"],
        ["\x41\x6E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xEE"],

        ["\xC1\xEF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x41\x6F"],
        ["\x41\x6F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xEF"],

        ["\xC1\xF0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x41\x70"],
        ["\x41\x70",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xF0"],

        ["\xC1\xF1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x41\x71"],
        ["\x41\x71",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xF1"],

        ["\xC1\xF2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x41\x72"],
        ["\x41\x72",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xF2"],

        ["\xC1\xF3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x41\x73"],
        ["\x41\x73",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xF3"],

        ["\xC1\xF4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x41\x74"],
        ["\x41\x74",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xF4"],

        ["\xC1\xF5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x41\x75"],
        ["\x41\x75",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xF5"],

        ["\xC1\xF6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x41\x76"],
        ["\x41\x76",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xF6"],

        ["\xC1\xF7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x41\x77"],
        ["\x41\x77",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xF7"],

        ["\xC1\xF8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x41\x78"],
        ["\x41\x78",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xF8"],

        ["\xC1\xF9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x41\x79"],
        ["\x41\x79",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xF9"],

        ["\xC1\xFA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x41\x7A"],
        ["\x41\x7A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xFA"],

        ["\xC1\xFB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x41\x7B"],
        ["\x41\x7B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xFB"],

        ["\xC1\xFC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x41\x7C"],
        ["\x41\x7C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xFC"],

        ["\xC1\xFD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x41\x7D"],
        ["\x41\x7D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xFD"],

        ["\xC1\xFE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x41\x7E"],
        ["\x41\x7E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC1\xFE"],

        ["\xC2\xA1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\x21"],
        ["\x42\x21",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xA1"],

        ["\xC2\xA2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\x22"],
        ["\x42\x22",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xA2"],

        ["\xC2\xA3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\x23"],
        ["\x42\x23",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xA3"],

        ["\xC2\xA4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\x24"],
        ["\x42\x24",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xA4"],

        ["\xC2\xA5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\x25"],
        ["\x42\x25",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xA5"],

        ["\xC2\xA6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\x26"],
        ["\x42\x26",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xA6"],

        ["\xC2\xA7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\x27"],
        ["\x42\x27",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xA7"],

        ["\xC2\xA8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\x28"],
        ["\x42\x28",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xA8"],

        ["\xC2\xA9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\x29"],
        ["\x42\x29",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xA9"],

        ["\xC2\xAA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\x2A"],
        ["\x42\x2A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xAA"],

        ["\xC2\xAB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\x2B"],
        ["\x42\x2B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xAB"],

        ["\xC2\xAC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\x2C"],
        ["\x42\x2C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xAC"],

        ["\xC2\xAD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\x2D"],
        ["\x42\x2D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xAD"],

        ["\xC2\xAE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\x2E"],
        ["\x42\x2E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xAE"],

        ["\xC2\xAF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\x2F"],
        ["\x42\x2F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xAF"],

        ["\xC2\xB0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\x30"],
        ["\x42\x30",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xB0"],

        ["\xC2\xB1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\x31"],
        ["\x42\x31",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xB1"],

        ["\xC2\xB2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\x32"],
        ["\x42\x32",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xB2"],

        ["\xC2\xB3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\x33"],
        ["\x42\x33",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xB3"],

        ["\xC2\xB4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\x34"],
        ["\x42\x34",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xB4"],

        ["\xC2\xB5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\x35"],
        ["\x42\x35",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xB5"],

        ["\xC2\xB6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\x36"],
        ["\x42\x36",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xB6"],

        ["\xC2\xB7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\x37"],
        ["\x42\x37",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xB7"],

        ["\xC2\xB8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\x38"],
        ["\x42\x38",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xB8"],

        ["\xC2\xB9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\x39"],
        ["\x42\x39",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xB9"],

        ["\xC2\xBA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\x3A"],
        ["\x42\x3A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xBA"],

        ["\xC2\xBB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\x3B"],
        ["\x42\x3B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xBB"],

        ["\xC2\xBC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\x3C"],
        ["\x42\x3C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xBC"],

        ["\xC2\xBD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\x3D"],
        ["\x42\x3D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xBD"],

        ["\xC2\xBE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\x3E"],
        ["\x42\x3E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xBE"],

        ["\xC2\xBF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\x3F"],
        ["\x42\x3F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xBF"],

        ["\xC2\xC0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\x40"],
        ["\x42\x40",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xC0"],

        ["\xC2\xC1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\x41"],
        ["\x42\x41",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xC1"],

        ["\xC2\xC2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\x42"],
        ["\x42\x42",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xC2"],

        ["\xC2\xC3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\x43"],
        ["\x42\x43",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xC3"],

        ["\xC2\xC4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\x44"],
        ["\x42\x44",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xC4"],

        ["\xC2\xC5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\x45"],
        ["\x42\x45",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xC5"],

        ["\xC2\xC6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\x46"],
        ["\x42\x46",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xC6"],

        ["\xC2\xC7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\x47"],
        ["\x42\x47",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xC7"],

        ["\xC2\xC8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\x48"],
        ["\x42\x48",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xC8"],

        ["\xC2\xC9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\x49"],
        ["\x42\x49",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xC9"],

        ["\xC2\xCA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\x4A"],
        ["\x42\x4A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xCA"],

        ["\xC2\xCB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\x4B"],
        ["\x42\x4B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xCB"],

        ["\xC2\xCC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\x4C"],
        ["\x42\x4C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xCC"],

        ["\xC2\xCD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\x4D"],
        ["\x42\x4D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xCD"],

        ["\xC2\xCE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\x4E"],
        ["\x42\x4E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xCE"],

        ["\xC2\xCF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\x4F"],
        ["\x42\x4F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xCF"],

        ["\xC2\xD0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\x50"],
        ["\x42\x50",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xD0"],

        ["\xC2\xD1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\x51"],
        ["\x42\x51",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xD1"],

        ["\xC2\xD2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\x52"],
        ["\x42\x52",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xD2"],

        ["\xC2\xD3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\x53"],
        ["\x42\x53",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xD3"],

        ["\xC2\xD4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\x54"],
        ["\x42\x54",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xD4"],

        ["\xC2\xD5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\x55"],
        ["\x42\x55",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xD5"],

        ["\xC2\xD6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\x56"],
        ["\x42\x56",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xD6"],

        ["\xC2\xD7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\x57"],
        ["\x42\x57",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xD7"],

        ["\xC2\xD8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\x58"],
        ["\x42\x58",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xD8"],

        ["\xC2\xD9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\x59"],
        ["\x42\x59",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xD9"],

        ["\xC2\xDA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\x5A"],
        ["\x42\x5A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xDA"],

        ["\xC2\xDB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\x5B"],
        ["\x42\x5B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xDB"],

        ["\xC2\xDC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\x5C"],
        ["\x42\x5C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xDC"],

        ["\xC2\xDD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\x5D"],
        ["\x42\x5D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xDD"],

        ["\xC2\xDE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\x5E"],
        ["\x42\x5E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xDE"],

        ["\xC2\xDF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\x5F"],
        ["\x42\x5F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xDF"],

        ["\xC2\xE0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\x60"],
        ["\x42\x60",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xE0"],

        ["\xC2\xE1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\x61"],
        ["\x42\x61",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xE1"],

        ["\xC2\xE2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\x62"],
        ["\x42\x62",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xE2"],

        ["\xC2\xE3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\x63"],
        ["\x42\x63",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xE3"],

        ["\xC2\xE4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\x64"],
        ["\x42\x64",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xE4"],

        ["\xC2\xE5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\x65"],
        ["\x42\x65",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xE5"],

        ["\xC2\xE6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\x66"],
        ["\x42\x66",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xE6"],

        ["\xC2\xE7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\x67"],
        ["\x42\x67",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xE7"],

        ["\xC2\xE8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\x68"],
        ["\x42\x68",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xE8"],

        ["\xC2\xE9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\x69"],
        ["\x42\x69",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xE9"],

        ["\xC2\xEA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\x6A"],
        ["\x42\x6A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xEA"],

        ["\xC2\xEB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\x6B"],
        ["\x42\x6B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xEB"],

        ["\xC2\xEC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\x6C"],
        ["\x42\x6C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xEC"],

        ["\xC2\xED",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\x6D"],
        ["\x42\x6D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xED"],

        ["\xC2\xEE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\x6E"],
        ["\x42\x6E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xEE"],

        ["\xC2\xEF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\x6F"],
        ["\x42\x6F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xEF"],

        ["\xC2\xF0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\x70"],
        ["\x42\x70",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xF0"],

        ["\xC2\xF1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\x71"],
        ["\x42\x71",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xF1"],

        ["\xC2\xF2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\x72"],
        ["\x42\x72",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xF2"],

        ["\xC2\xF3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\x73"],
        ["\x42\x73",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xF3"],

        ["\xC2\xF4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\x74"],
        ["\x42\x74",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xF4"],

        ["\xC2\xF5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\x75"],
        ["\x42\x75",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xF5"],

        ["\xC2\xF6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\x76"],
        ["\x42\x76",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xF6"],

        ["\xC2\xF7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\x77"],
        ["\x42\x77",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xF7"],

        ["\xC2\xF8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\x78"],
        ["\x42\x78",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xF8"],

        ["\xC2\xF9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\x79"],
        ["\x42\x79",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xF9"],

        ["\xC2\xFA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\x7A"],
        ["\x42\x7A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xFA"],

        ["\xC2\xFB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\x7B"],
        ["\x42\x7B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xFB"],

        ["\xC2\xFC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\x7C"],
        ["\x42\x7C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xFC"],

        ["\xC2\xFD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\x7D"],
        ["\x42\x7D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xFD"],

        ["\xC2\xFE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x42\x7E"],
        ["\x42\x7E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xFE"],

        ["\xC3\xA1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x43\x21"],
        ["\x43\x21",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xA1"],

        ["\xC3\xA2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x43\x22"],
        ["\x43\x22",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xA2"],

        ["\xC3\xA3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x43\x23"],
        ["\x43\x23",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xA3"],

        ["\xC3\xA4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x43\x24"],
        ["\x43\x24",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xA4"],

        ["\xC3\xA5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x43\x25"],
        ["\x43\x25",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xA5"],

        ["\xC3\xA6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x43\x26"],
        ["\x43\x26",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xA6"],

        ["\xC3\xA7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x43\x27"],
        ["\x43\x27",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xA7"],

        ["\xC3\xA8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x43\x28"],
        ["\x43\x28",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xA8"],

        ["\xC3\xA9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x43\x29"],
        ["\x43\x29",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xA9"],

        ["\xC3\xAA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x43\x2A"],
        ["\x43\x2A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xAA"],

        ["\xC3\xAB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x43\x2B"],
        ["\x43\x2B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xAB"],

        ["\xC3\xAC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x43\x2C"],
        ["\x43\x2C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xAC"],

        ["\xC3\xAD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x43\x2D"],
        ["\x43\x2D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xAD"],

        ["\xC3\xAE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x43\x2E"],
        ["\x43\x2E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xAE"],

        ["\xC3\xAF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x43\x2F"],
        ["\x43\x2F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xAF"],

        ["\xC3\xB0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x43\x30"],
        ["\x43\x30",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xB0"],

        ["\xC3\xB1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x43\x31"],
        ["\x43\x31",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xB1"],

        ["\xC3\xB2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x43\x32"],
        ["\x43\x32",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xB2"],

        ["\xC3\xB3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x43\x33"],
        ["\x43\x33",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xB3"],

        ["\xC3\xB4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x43\x34"],
        ["\x43\x34",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xB4"],

        ["\xC3\xB5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x43\x35"],
        ["\x43\x35",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xB5"],

        ["\xC3\xB6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x43\x36"],
        ["\x43\x36",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xB6"],

        ["\xC3\xB7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x43\x37"],
        ["\x43\x37",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xB7"],

        ["\xC3\xB8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x43\x38"],
        ["\x43\x38",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xB8"],

        ["\xC3\xB9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x43\x39"],
        ["\x43\x39",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xB9"],

        ["\xC3\xBA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x43\x3A"],
        ["\x43\x3A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xBA"],

        ["\xC3\xBB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x43\x3B"],
        ["\x43\x3B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xBB"],

        ["\xC3\xBC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x43\x3C"],
        ["\x43\x3C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xBC"],

        ["\xC3\xBD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x43\x3D"],
        ["\x43\x3D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xBD"],

        ["\xC3\xBE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x43\x3E"],
        ["\x43\x3E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xBE"],

        ["\xC3\xBF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x43\x3F"],
        ["\x43\x3F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xBF"],

        ["\xC3\xC0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x43\x40"],
        ["\x43\x40",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xC0"],

        ["\xC3\xC1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x43\x41"],
        ["\x43\x41",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xC1"],

        ["\xC3\xC2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x43\x42"],
        ["\x43\x42",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xC2"],

        ["\xC3\xC3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x43\x43"],
        ["\x43\x43",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xC3"],

        ["\xC3\xC4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x43\x44"],
        ["\x43\x44",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xC4"],

        ["\xC3\xC5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x43\x45"],
        ["\x43\x45",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xC5"],

        ["\xC3\xC6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x43\x46"],
        ["\x43\x46",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xC6"],

        ["\xC3\xC7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x43\x47"],
        ["\x43\x47",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xC7"],

        ["\xC3\xC8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x43\x48"],
        ["\x43\x48",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xC8"],

        ["\xC3\xC9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x43\x49"],
        ["\x43\x49",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xC9"],

        ["\xC3\xCA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x43\x4A"],
        ["\x43\x4A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xCA"],

        ["\xC3\xCB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x43\x4B"],
        ["\x43\x4B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xCB"],

        ["\xC3\xCC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x43\x4C"],
        ["\x43\x4C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xCC"],

        ["\xC3\xCD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x43\x4D"],
        ["\x43\x4D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xCD"],

        ["\xC3\xCE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x43\x4E"],
        ["\x43\x4E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xCE"],

        ["\xC3\xCF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x43\x4F"],
        ["\x43\x4F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xCF"],

        ["\xC3\xD0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x43\x50"],
        ["\x43\x50",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xD0"],

        ["\xC3\xD1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x43\x51"],
        ["\x43\x51",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xD1"],

        ["\xC3\xD2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x43\x52"],
        ["\x43\x52",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xD2"],

        ["\xC3\xD3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x43\x53"],
        ["\x43\x53",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xD3"],

        ["\xC3\xD4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x43\x54"],
        ["\x43\x54",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xD4"],

        ["\xC3\xD5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x43\x55"],
        ["\x43\x55",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xD5"],

        ["\xC3\xD6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x43\x56"],
        ["\x43\x56",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xD6"],

        ["\xC3\xD7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x43\x57"],
        ["\x43\x57",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xD7"],

        ["\xC3\xD8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x43\x58"],
        ["\x43\x58",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xD8"],

        ["\xC3\xD9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x43\x59"],
        ["\x43\x59",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xD9"],

        ["\xC3\xDA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x43\x5A"],
        ["\x43\x5A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xDA"],

        ["\xC3\xDB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x43\x5B"],
        ["\x43\x5B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xDB"],

        ["\xC3\xDC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x43\x5C"],
        ["\x43\x5C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xDC"],

        ["\xC3\xDD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x43\x5D"],
        ["\x43\x5D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xDD"],

        ["\xC3\xDE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x43\x5E"],
        ["\x43\x5E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xDE"],

        ["\xC3\xDF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x43\x5F"],
        ["\x43\x5F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xDF"],

        ["\xC3\xE0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x43\x60"],
        ["\x43\x60",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xE0"],

        ["\xC3\xE1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x43\x61"],
        ["\x43\x61",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xE1"],

        ["\xC3\xE2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x43\x62"],
        ["\x43\x62",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xE2"],

        ["\xC3\xE3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x43\x63"],
        ["\x43\x63",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xE3"],

        ["\xC3\xE4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x43\x64"],
        ["\x43\x64",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xE4"],

        ["\xC3\xE5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x43\x65"],
        ["\x43\x65",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xE5"],

        ["\xC3\xE6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x43\x66"],
        ["\x43\x66",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xE6"],

        ["\xC3\xE7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x43\x67"],
        ["\x43\x67",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xE7"],

        ["\xC3\xE8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x43\x68"],
        ["\x43\x68",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xE8"],

        ["\xC3\xE9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x43\x69"],
        ["\x43\x69",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xE9"],

        ["\xC3\xEA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x43\x6A"],
        ["\x43\x6A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xEA"],

        ["\xC3\xEB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x43\x6B"],
        ["\x43\x6B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xEB"],

        ["\xC3\xEC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x43\x6C"],
        ["\x43\x6C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xEC"],

        ["\xC3\xED",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x43\x6D"],
        ["\x43\x6D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xED"],

        ["\xC3\xEE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x43\x6E"],
        ["\x43\x6E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xEE"],

        ["\xC3\xEF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x43\x6F"],
        ["\x43\x6F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xEF"],

        ["\xC3\xF0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x43\x70"],
        ["\x43\x70",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xF0"],

        ["\xC3\xF1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x43\x71"],
        ["\x43\x71",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xF1"],

        ["\xC3\xF2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x43\x72"],
        ["\x43\x72",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xF2"],

        ["\xC3\xF3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x43\x73"],
        ["\x43\x73",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xF3"],

        ["\xC3\xF4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x43\x74"],
        ["\x43\x74",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xF4"],

        ["\xC3\xF5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x43\x75"],
        ["\x43\x75",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xF5"],

        ["\xC3\xF6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x43\x76"],
        ["\x43\x76",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xF6"],

        ["\xC3\xF7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x43\x77"],
        ["\x43\x77",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xF7"],

        ["\xC3\xF8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x43\x78"],
        ["\x43\x78",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xF8"],

        ["\xC3\xF9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x43\x79"],
        ["\x43\x79",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xF9"],

        ["\xC3\xFA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x43\x7A"],
        ["\x43\x7A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xFA"],

        ["\xC3\xFB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x43\x7B"],
        ["\x43\x7B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xFB"],

        ["\xC3\xFC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x43\x7C"],
        ["\x43\x7C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xFC"],

        ["\xC3\xFD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x43\x7D"],
        ["\x43\x7D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xFD"],

        ["\xC3\xFE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x43\x7E"],
        ["\x43\x7E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xFE"],

        ["\xC4\xA1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x44\x21"],
        ["\x44\x21",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xA1"],

        ["\xC4\xA2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x44\x22"],
        ["\x44\x22",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xA2"],

        ["\xC4\xA3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x44\x23"],
        ["\x44\x23",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xA3"],

        ["\xC4\xA4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x44\x24"],
        ["\x44\x24",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xA4"],

        ["\xC4\xA5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x44\x25"],
        ["\x44\x25",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xA5"],

        ["\xC4\xA6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x44\x26"],
        ["\x44\x26",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xA6"],

        ["\xC4\xA7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x44\x27"],
        ["\x44\x27",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xA7"],

        ["\xC4\xA8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x44\x28"],
        ["\x44\x28",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xA8"],

        ["\xC4\xA9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x44\x29"],
        ["\x44\x29",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xA9"],

        ["\xC4\xAA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x44\x2A"],
        ["\x44\x2A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xAA"],

        ["\xC4\xAB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x44\x2B"],
        ["\x44\x2B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xAB"],

        ["\xC4\xAC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x44\x2C"],
        ["\x44\x2C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xAC"],

        ["\xC4\xAD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x44\x2D"],
        ["\x44\x2D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xAD"],

        ["\xC4\xAE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x44\x2E"],
        ["\x44\x2E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xAE"],

        ["\xC4\xAF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x44\x2F"],
        ["\x44\x2F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xAF"],

        ["\xC4\xB0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x44\x30"],
        ["\x44\x30",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xB0"],

        ["\xC4\xB1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x44\x31"],
        ["\x44\x31",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xB1"],

        ["\xC4\xB2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x44\x32"],
        ["\x44\x32",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xB2"],

        ["\xC4\xB3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x44\x33"],
        ["\x44\x33",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xB3"],

        ["\xC4\xB4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x44\x34"],
        ["\x44\x34",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xB4"],

        ["\xC4\xB5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x44\x35"],
        ["\x44\x35",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xB5"],

        ["\xC4\xB6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x44\x36"],
        ["\x44\x36",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xB6"],

        ["\xC4\xB7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x44\x37"],
        ["\x44\x37",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xB7"],

        ["\xC4\xB8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x44\x38"],
        ["\x44\x38",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xB8"],

        ["\xC4\xB9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x44\x39"],
        ["\x44\x39",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xB9"],

        ["\xC4\xBA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x44\x3A"],
        ["\x44\x3A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xBA"],

        ["\xC4\xBB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x44\x3B"],
        ["\x44\x3B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xBB"],

        ["\xC4\xBC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x44\x3C"],
        ["\x44\x3C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xBC"],

        ["\xC4\xBD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x44\x3D"],
        ["\x44\x3D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xBD"],

        ["\xC4\xBE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x44\x3E"],
        ["\x44\x3E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xBE"],

        ["\xC4\xBF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x44\x3F"],
        ["\x44\x3F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xBF"],

        ["\xC4\xC0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x44\x40"],
        ["\x44\x40",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xC0"],

        ["\xC4\xC1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x44\x41"],
        ["\x44\x41",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xC1"],

        ["\xC4\xC2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x44\x42"],
        ["\x44\x42",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xC2"],

        ["\xC4\xC3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x44\x43"],
        ["\x44\x43",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xC3"],

        ["\xC4\xC4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x44\x44"],
        ["\x44\x44",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xC4"],

        ["\xC4\xC5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x44\x45"],
        ["\x44\x45",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xC5"],

        ["\xC4\xC6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x44\x46"],
        ["\x44\x46",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xC6"],

        ["\xC4\xC7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x44\x47"],
        ["\x44\x47",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xC7"],

        ["\xC4\xC8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x44\x48"],
        ["\x44\x48",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xC8"],

        ["\xC4\xC9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x44\x49"],
        ["\x44\x49",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xC9"],

        ["\xC4\xCA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x44\x4A"],
        ["\x44\x4A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xCA"],

        ["\xC4\xCB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x44\x4B"],
        ["\x44\x4B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xCB"],

        ["\xC4\xCC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x44\x4C"],
        ["\x44\x4C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xCC"],

        ["\xC4\xCD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\xB6\xF5"],
        ["\xB6\xF5",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xCD"],

        ["\xC4\xCE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x44\x4E"],
        ["\x44\x4E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xCE"],

        ["\xC4\xCF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x44\x4F"],
        ["\x44\x4F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xCF"],

        ["\xC4\xD0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x44\x50"],
        ["\x44\x50",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xD0"],

        ["\xC4\xD1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x44\x51"],
        ["\x44\x51",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xD1"],

        ["\xC4\xD2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x44\x52"],
        ["\x44\x52",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xD2"],

        ["\xC4\xD3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x44\x53"],
        ["\x44\x53",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xD3"],

        ["\xC4\xD4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x44\x54"],
        ["\x44\x54",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xD4"],

        ["\xC4\xD5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x44\x55"],
        ["\x44\x55",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xD5"],

        ["\xC4\xD6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x44\x56"],
        ["\x44\x56",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xD6"],

        ["\xC4\xD7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x44\x57"],
        ["\x44\x57",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xD7"],

        ["\xC4\xD8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x44\x58"],
        ["\x44\x58",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xD8"],

        ["\xC4\xD9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x44\x59"],
        ["\x44\x59",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xD9"],

        ["\xC4\xDA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x44\x5A"],
        ["\x44\x5A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xDA"],

        ["\xC4\xDB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x54\x64"],
        ["\x54\x64",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xDB"],

        ["\xC4\xDC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x44\x5C"],
        ["\x44\x5C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xDC"],

        ["\xC4\xDD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x44\x5D"],
        ["\x44\x5D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xDD"],

        ["\xC4\xDE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x44\x5E"],
        ["\x44\x5E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xDE"],

        ["\xC4\xDF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x44\x5F"],
        ["\x44\x5F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xDF"],

        ["\xC4\xE0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x44\x60"],
        ["\x44\x60",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xE0"],

        ["\xC4\xE1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x44\x61"],
        ["\x44\x61",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xE1"],

        ["\xC4\xE2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x44\x62"],
        ["\x44\x62",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xE2"],

        ["\xC4\xE3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x44\x63"],
        ["\x44\x63",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xE3"],

        ["\xC4\xE4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x44\x64"],
        ["\x44\x64",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xE4"],

        ["\xC4\xE5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x44\x65"],
        ["\x44\x65",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xE5"],

        ["\xC4\xE6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x44\x66"],
        ["\x44\x66",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xE6"],

        ["\xC4\xE7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x44\x67"],
        ["\x44\x67",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xE7"],

        ["\xC4\xE8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x44\x68"],
        ["\x44\x68",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xE8"],

        ["\xC4\xE9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x44\x69"],
        ["\x44\x69",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xE9"],

        ["\xC4\xEA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x44\x6A"],
        ["\x44\x6A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xEA"],

        ["\xC4\xEB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x44\x6B"],
        ["\x44\x6B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xEB"],

        ["\xC4\xEC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x44\x6C"],
        ["\x44\x6C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xEC"],

        ["\xC4\xED",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x44\x6D"],
        ["\x44\x6D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xED"],

        ["\xC4\xEE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x44\x6E"],
        ["\x44\x6E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xEE"],

        ["\xC4\xEF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x44\x6F"],
        ["\x44\x6F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xEF"],

        ["\xC4\xF0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x44\x70"],
        ["\x44\x70",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xF0"],

        ["\xC4\xF1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x44\x71"],
        ["\x44\x71",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xF1"],

        ["\xC4\xF2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x44\x72"],
        ["\x44\x72",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xF2"],

        ["\xC4\xF3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x44\x73"],
        ["\x44\x73",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xF3"],

        ["\xC4\xF4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x44\x74"],
        ["\x44\x74",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xF4"],

        ["\xC4\xF5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x44\x75"],
        ["\x44\x75",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xF5"],

        ["\xC4\xF6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x44\x76"],
        ["\x44\x76",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xF6"],

        ["\xC4\xF7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x44\x77"],
        ["\x44\x77",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xF7"],

        ["\xC4\xF8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x44\x78"],
        ["\x44\x78",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xF8"],

        ["\xC4\xF9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x44\x79"],
        ["\x44\x79",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xF9"],

        ["\xC4\xFA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x44\x7A"],
        ["\x44\x7A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xFA"],

        ["\xC4\xFB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x44\x7B"],
        ["\x44\x7B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xFB"],

        ["\xC4\xFC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x44\x7C"],
        ["\x44\x7C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xFC"],

        ["\xC4\xFD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x44\x7D"],
        ["\x44\x7D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xFD"],

        ["\xC4\xFE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x44\x7E"],
        ["\x44\x7E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xFE"],

        ["\xC5\xA1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\x21"],
        ["\x45\x21",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xA1"],

        ["\xC5\xA2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\x22"],
        ["\x45\x22",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xA2"],

        ["\xC5\xA3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\x23"],
        ["\x45\x23",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xA3"],

        ["\xC5\xA4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\x24"],
        ["\x45\x24",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xA4"],

        ["\xC5\xA5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\x25"],
        ["\x45\x25",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xA5"],

        ["\xC5\xA6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\x26"],
        ["\x45\x26",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xA6"],

        ["\xC5\xA7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\x27"],
        ["\x45\x27",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xA7"],

        ["\xC5\xA8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\x28"],
        ["\x45\x28",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xA8"],

        ["\xC5\xA9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\x29"],
        ["\x45\x29",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xA9"],

        ["\xC5\xAA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\x2A"],
        ["\x45\x2A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xAA"],

        ["\xC5\xAB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\x2B"],
        ["\x45\x2B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xAB"],

        ["\xC5\xAC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\x2C"],
        ["\x45\x2C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xAC"],

        ["\xC5\xAD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\x2D"],
        ["\x45\x2D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xAD"],

        ["\xC5\xAE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\x2E"],
        ["\x45\x2E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xAE"],

        ["\xC5\xAF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\x2F"],
        ["\x45\x2F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xAF"],

        ["\xC5\xB0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\x30"],
        ["\x45\x30",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xB0"],

        ["\xC5\xB1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\x31"],
        ["\x45\x31",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xB1"],

        ["\xC5\xB2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\x32"],
        ["\x45\x32",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xB2"],

        ["\xC5\xB3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\x33"],
        ["\x45\x33",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xB3"],

        ["\xC5\xB4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\x34"],
        ["\x45\x34",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xB4"],

        ["\xC5\xB5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\x35"],
        ["\x45\x35",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xB5"],

        ["\xC5\xB6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xE6"],
        ["\xD6\xE6",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xB6"],

        ["\xC5\xB7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\x37"],
        ["\x45\x37",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xB7"],

        ["\xC5\xB8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\x38"],
        ["\x45\x38",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xB8"],

        ["\xC5\xB9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\x39"],
        ["\x45\x39",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xB9"],

        ["\xC5\xBA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\x3A"],
        ["\x45\x3A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xBA"],

        ["\xC5\xBB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\x3B"],
        ["\x45\x3B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xBB"],

        ["\xC5\xBC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\x3C"],
        ["\x45\x3C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xBC"],

        ["\xC5\xBD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\x3D"],
        ["\x45\x3D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xBD"],

        ["\xC5\xBE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\x3E"],
        ["\x45\x3E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xBE"],

        ["\xC5\xBF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xA3"],
        ["\xD4\xA3",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xBF"],

        ["\xC5\xC0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\x40"],
        ["\x45\x40",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xC0"],

        ["\xC5\xC1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\x41"],
        ["\x45\x41",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xC1"],

        ["\xC5\xC2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\x42"],
        ["\x45\x42",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xC2"],

        ["\xC5\xC3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\x43"],
        ["\x45\x43",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xC3"],

        ["\xC5\xC4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\x44"],
        ["\x45\x44",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xC4"],

        ["\xC5\xC5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\x45"],
        ["\x45\x45",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xC5"],

        ["\xC5\xC6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\x46"],
        ["\x45\x46",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xC6"],

        ["\xC5\xC7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\x47"],
        ["\x45\x47",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xC7"],

        ["\xC5\xC8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\x48"],
        ["\x45\x48",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xC8"],

        ["\xC5\xC9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\x49"],
        ["\x45\x49",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xC9"],

        ["\xC5\xCA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\x4A"],
        ["\x45\x4A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xCA"],

        ["\xC5\xCB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\x4B"],
        ["\x45\x4B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xCB"],

        ["\xC5\xCC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\x4C"],
        ["\x45\x4C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xCC"],

        ["\xC5\xCD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\x4D"],
        ["\x45\x4D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xCD"],

        ["\xC5\xCE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\x4E"],
        ["\x45\x4E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xCE"],

        ["\xC5\xCF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\x4F"],
        ["\x45\x4F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xCF"],

        ["\xC5\xD0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\x50"],
        ["\x45\x50",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xD0"],

        ["\xC5\xD1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\x51"],
        ["\x45\x51",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xD1"],

        ["\xC5\xD2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\x52"],
        ["\x45\x52",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xD2"],

        ["\xC5\xD3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\x53"],
        ["\x45\x53",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xD3"],

        ["\xC5\xD4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\x54"],
        ["\x45\x54",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xD4"],

        ["\xC5\xD5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\x55"],
        ["\x45\x55",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xD5"],

        ["\xC5\xD6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\x56"],
        ["\x45\x56",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xD6"],

        ["\xC5\xD7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x6A"],
        ["\x62\x6A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xD7"],

        ["\xC5\xD8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\x58"],
        ["\x45\x58",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xD8"],

        ["\xC5\xD9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\x59"],
        ["\x45\x59",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xD9"],

        ["\xC5\xDA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\x5A"],
        ["\x45\x5A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xDA"],

        ["\xC5\xDB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\x5B"],
        ["\x45\x5B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xDB"],

        ["\xC5\xDC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\x5C"],
        ["\x45\x5C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xDC"],

        ["\xC5\xDD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\x5D"],
        ["\x45\x5D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xDD"],

        ["\xC5\xDE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\x5E"],
        ["\x45\x5E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xDE"],

        ["\xC5\xDF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\x5F"],
        ["\x45\x5F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xDF"],

        ["\xC5\xE0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\x60"],
        ["\x45\x60",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xE0"],

        ["\xC5\xE1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\x61"],
        ["\x45\x61",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xE1"],

        ["\xC5\xE2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\x62"],
        ["\x45\x62",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xE2"],

        ["\xC5\xE3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\x63"],
        ["\x45\x63",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xE3"],

        ["\xC5\xE4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\x64"],
        ["\x45\x64",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xE4"],

        ["\xC5\xE5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\x65"],
        ["\x45\x65",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xE5"],

        ["\xC5\xE6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\x66"],
        ["\x45\x66",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xE6"],

        ["\xC5\xE7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\x67"],
        ["\x45\x67",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xE7"],

        ["\xC5\xE8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\x68"],
        ["\x45\x68",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xE8"],

        ["\xC5\xE9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\x69"],
        ["\x45\x69",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xE9"],

        ["\xC5\xEA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\x6A"],
        ["\x45\x6A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xEA"],

        ["\xC5\xEB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\x6B"],
        ["\x45\x6B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xEB"],

        ["\xC5\xEC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\x6C"],
        ["\x45\x6C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xEC"],

        ["\xC5\xED",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\x6D"],
        ["\x45\x6D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xED"],

        ["\xC5\xEE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x6D"],
        ["\x5B\x6D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xEE"],

        ["\xC5\xEF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\x6F"],
        ["\x45\x6F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xEF"],

        ["\xC5\xF0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\x70"],
        ["\x45\x70",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xF0"],

        ["\xC5\xF1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\x71"],
        ["\x45\x71",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xF1"],

        ["\xC5\xF2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\x72"],
        ["\x45\x72",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xF2"],

        ["\xC5\xF3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x39"],
        ["\x5E\x39",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xF3"],

        ["\xC5\xF4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\x74"],
        ["\x45\x74",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xF4"],

        ["\xC5\xF5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\x75"],
        ["\x45\x75",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xF5"],

        ["\xC5\xF6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\x76"],
        ["\x45\x76",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xF6"],

        ["\xC5\xF7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\x77"],
        ["\x45\x77",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xF7"],

        ["\xC5\xF8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\x78"],
        ["\x45\x78",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xF8"],

        ["\xC5\xF9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\x79"],
        ["\x45\x79",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xF9"],

        ["\xC5\xFA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\x7A"],
        ["\x45\x7A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xFA"],

        ["\xC5\xFB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\x7B"],
        ["\x45\x7B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xFB"],

        ["\xC5\xFC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\x7C"],
        ["\x45\x7C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xFC"],

        ["\xC5\xFD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\x7D"],
        ["\x45\x7D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xFD"],

        ["\xC5\xFE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\x7E"],
        ["\x45\x7E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC5\xFE"],

        ["\xC6\xA1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\x21"],
        ["\x46\x21",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xA1"],

        ["\xC6\xA2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\x22"],
        ["\x46\x22",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xA2"],

        ["\xC6\xA3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\x23"],
        ["\x46\x23",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xA3"],

        ["\xC6\xA4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\x24"],
        ["\x46\x24",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xA4"],

        ["\xC6\xA5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\x25"],
        ["\x46\x25",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xA5"],

        ["\xC6\xA6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\x26"],
        ["\x46\x26",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xA6"],

        ["\xC6\xA7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\x27"],
        ["\x46\x27",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xA7"],

        ["\xC6\xA8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\x28"],
        ["\x46\x28",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xA8"],

        ["\xC6\xA9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\x29"],
        ["\x46\x29",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xA9"],

        ["\xC6\xAA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\x2A"],
        ["\x46\x2A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xAA"],

        ["\xC6\xAB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\x2B"],
        ["\x46\x2B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xAB"],

        ["\xC6\xAC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\x2C"],
        ["\x46\x2C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xAC"],

        ["\xC6\xAD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\x2D"],
        ["\x46\x2D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xAD"],

        ["\xC6\xAE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\x2E"],
        ["\x46\x2E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xAE"],

        ["\xC6\xAF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\x2F"],
        ["\x46\x2F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xAF"],

        ["\xC6\xB0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\x30"],
        ["\x46\x30",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xB0"],

        ["\xC6\xB1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\x31"],
        ["\x46\x31",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xB1"],

        ["\xC6\xB2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\x32"],
        ["\x46\x32",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xB2"],

        ["\xC6\xB3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\x33"],
        ["\x46\x33",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xB3"],

        ["\xC6\xB4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\x34"],
        ["\x46\x34",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xB4"],

        ["\xC6\xB5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\x35"],
        ["\x46\x35",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xB5"],

        ["\xC6\xB6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\x36"],
        ["\x46\x36",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xB6"],

        ["\xC6\xB7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\x37"],
        ["\x46\x37",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xB7"],

        ["\xC6\xB8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\x38"],
        ["\x46\x38",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xB8"],

        ["\xC6\xB9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\x39"],
        ["\x46\x39",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xB9"],

        ["\xC6\xBA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\x3A"],
        ["\x46\x3A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xBA"],

        ["\xC6\xBB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\x3B"],
        ["\x46\x3B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xBB"],

        ["\xC6\xBC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\x3C"],
        ["\x46\x3C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xBC"],

        ["\xC6\xBD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\x3D"],
        ["\x46\x3D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xBD"],

        ["\xC6\xBE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\x3E"],
        ["\x46\x3E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xBE"],

        ["\xC6\xBF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\x3F"],
        ["\x46\x3F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xBF"],

        ["\xC6\xC0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\x40"],
        ["\x46\x40",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xC0"],

        ["\xC6\xC1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\x41"],
        ["\x46\x41",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xC1"],

        ["\xC6\xC2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\x42"],
        ["\x46\x42",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xC2"],

        ["\xC6\xC3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\x43"],
        ["\x46\x43",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xC3"],

        ["\xC6\xC4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\x44"],
        ["\x46\x44",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xC4"],

        ["\xC6\xC5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\x45"],
        ["\x46\x45",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xC5"],

        ["\xC6\xC6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\x46"],
        ["\x46\x46",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xC6"],

        ["\xC6\xC7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\x47"],
        ["\x46\x47",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xC7"],

        ["\xC6\xC8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\x48"],
        ["\x46\x48",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xC8"],

        ["\xC6\xC9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\x49"],
        ["\x46\x49",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xC9"],

        ["\xC6\xCA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\x4A"],
        ["\x46\x4A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xCA"],

        ["\xC6\xCB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\x4B"],
        ["\x46\x4B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xCB"],

        ["\xC6\xCC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\x4C"],
        ["\x46\x4C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xCC"],

        ["\xC6\xCD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\x4D"],
        ["\x46\x4D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xCD"],

        ["\xC6\xCE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\x4E"],
        ["\x46\x4E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xCE"],

        ["\xC6\xCF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\x4F"],
        ["\x46\x4F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xCF"],

        ["\xC6\xD0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\x50"],
        ["\x46\x50",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xD0"],

        ["\xC6\xD1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\x51"],
        ["\x46\x51",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xD1"],

        ["\xC6\xD2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\x52"],
        ["\x46\x52",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xD2"],

        ["\xC6\xD3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\x53"],
        ["\x46\x53",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xD3"],

        ["\xC6\xD4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\x54"],
        ["\x46\x54",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xD4"],

        ["\xC6\xD5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\x55"],
        ["\x46\x55",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xD5"],

        ["\xC6\xD6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\x56"],
        ["\x46\x56",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xD6"],

        ["\xC6\xD7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\x57"],
        ["\x46\x57",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xD7"],

        ["\xC6\xD8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\x58"],
        ["\x46\x58",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xD8"],

        ["\xC6\xD9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\x59"],
        ["\x46\x59",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xD9"],

        ["\xC6\xDA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\x5A"],
        ["\x46\x5A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xDA"],

        ["\xC6\xDB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\x5B"],
        ["\x46\x5B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xDB"],

        ["\xC6\xDC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\x5C"],
        ["\x46\x5C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xDC"],

        ["\xC6\xDD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\x5D"],
        ["\x46\x5D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xDD"],

        ["\xC6\xDE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\x5E"],
        ["\x46\x5E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xDE"],

        ["\xC6\xDF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\x5F"],
        ["\x46\x5F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xDF"],

        ["\xC6\xE0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\x60"],
        ["\x46\x60",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xE0"],

        ["\xC6\xE1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\x61"],
        ["\x46\x61",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xE1"],

        ["\xC6\xE2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\x62"],
        ["\x46\x62",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xE2"],

        ["\xC6\xE3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\x63"],
        ["\x46\x63",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xE3"],

        ["\xC6\xE4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\x64"],
        ["\x46\x64",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xE4"],

        ["\xC6\xE5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\x65"],
        ["\x46\x65",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xE5"],

        ["\xC6\xE6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\x66"],
        ["\x46\x66",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xE6"],

        ["\xC6\xE7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\x67"],
        ["\x46\x67",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xE7"],

        ["\xC6\xE8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\x68"],
        ["\x46\x68",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xE8"],

        ["\xC6\xE9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\x69"],
        ["\x46\x69",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xE9"],

        ["\xC6\xEA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\x6A"],
        ["\x46\x6A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xEA"],

        ["\xC6\xEB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\x6B"],
        ["\x46\x6B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xEB"],

        ["\xC6\xEC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\x6C"],
        ["\x46\x6C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xEC"],

        ["\xC6\xED",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\x6D"],
        ["\x46\x6D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xED"],

        ["\xC6\xEE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\x6E"],
        ["\x46\x6E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xEE"],

        ["\xC6\xEF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\x6F"],
        ["\x46\x6F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xEF"],

        ["\xC6\xF0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\x70"],
        ["\x46\x70",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xF0"],

        ["\xC6\xF1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\x71"],
        ["\x46\x71",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xF1"],

        ["\xC6\xF2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\x72"],
        ["\x46\x72",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xF2"],

        ["\xC6\xF3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\x73"],
        ["\x46\x73",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xF3"],

        ["\xC6\xF4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\x74"],
        ["\x46\x74",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xF4"],

        ["\xC6\xF5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\x75"],
        ["\x46\x75",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xF5"],

        ["\xC6\xF6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x6E"],
        ["\x6D\x6E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xF6"],

        ["\xC6\xF7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\x77"],
        ["\x46\x77",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xF7"],

        ["\xC6\xF8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\x78"],
        ["\x46\x78",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xF8"],

        ["\xC6\xF9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\x79"],
        ["\x46\x79",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xF9"],

        ["\xC6\xFA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\x7A"],
        ["\x46\x7A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xFA"],

        ["\xC6\xFB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\x7B"],
        ["\x46\x7B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xFB"],

        ["\xC6\xFC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\x7C"],
        ["\x46\x7C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xFC"],

        ["\xC6\xFD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\x7D"],
        ["\x46\x7D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xFD"],

        ["\xC6\xFE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\x7E"],
        ["\x46\x7E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC6\xFE"],

        ["\xC7\xA1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x47\x21"],
        ["\x47\x21",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xA1"],

        ["\xC7\xA2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x47\x22"],
        ["\x47\x22",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xA2"],

        ["\xC7\xA3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x47\x23"],
        ["\x47\x23",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xA3"],

        ["\xC7\xA4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x47\x24"],
        ["\x47\x24",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xA4"],

        ["\xC7\xA5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x47\x25"],
        ["\x47\x25",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xA5"],

        ["\xC7\xA6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x47\x26"],
        ["\x47\x26",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xA6"],

        ["\xC7\xA7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x47\x27"],
        ["\x47\x27",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xA7"],

        ["\xC7\xA8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x47\x28"],
        ["\x47\x28",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xA8"],

        ["\xC7\xA9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x47\x29"],
        ["\x47\x29",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xA9"],

        ["\xC7\xAA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x47\x2A"],
        ["\x47\x2A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xAA"],

        ["\xC7\xAB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x47\x2B"],
        ["\x47\x2B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xAB"],

        ["\xC7\xAC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x47\x2C"],
        ["\x47\x2C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xAC"],

        ["\xC7\xAD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x47\x2D"],
        ["\x47\x2D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xAD"],

        ["\xC7\xAE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x47\x2E"],
        ["\x47\x2E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xAE"],

        ["\xC7\xAF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x47\x2F"],
        ["\x47\x2F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xAF"],

        ["\xC7\xB0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x47\x30"],
        ["\x47\x30",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xB0"],

        ["\xC7\xB1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x47\x31"],
        ["\x47\x31",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xB1"],

        ["\xC7\xB2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x47\x32"],
        ["\x47\x32",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xB2"],

        ["\xC7\xB3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x47\x33"],
        ["\x47\x33",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xB3"],

        ["\xC7\xB4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x47\x34"],
        ["\x47\x34",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xB4"],

        ["\xC7\xB5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x47\x35"],
        ["\x47\x35",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xB5"],

        ["\xC7\xB6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x47\x36"],
        ["\x47\x36",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xB6"],

        ["\xC7\xB7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x47\x37"],
        ["\x47\x37",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xB7"],

        ["\xC7\xB8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x47\x38"],
        ["\x47\x38",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xB8"],

        ["\xC7\xB9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x47\x39"],
        ["\x47\x39",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xB9"],

        ["\xC7\xBA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x47\x3A"],
        ["\x47\x3A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xBA"],

        ["\xC7\xBB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x47\x3B"],
        ["\x47\x3B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xBB"],

        ["\xC7\xBC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x47\x3C"],
        ["\x47\x3C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xBC"],

        ["\xC7\xBD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x47\x3D"],
        ["\x47\x3D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xBD"],

        ["\xC7\xBE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x47\x3E"],
        ["\x47\x3E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xBE"],

        ["\xC7\xBF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x47\x3F"],
        ["\x47\x3F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xBF"],

        ["\xC7\xC0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x47\x40"],
        ["\x47\x40",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xC0"],

        ["\xC7\xC1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x47\x41"],
        ["\x47\x41",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xC1"],

        ["\xC7\xC2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x47\x42"],
        ["\x47\x42",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xC2"],

        ["\xC7\xC3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x47\x43"],
        ["\x47\x43",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xC3"],

        ["\xC7\xC4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x47\x44"],
        ["\x47\x44",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xC4"],

        ["\xC7\xC5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x47\x45"],
        ["\x47\x45",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xC5"],

        ["\xC7\xC6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x47\x46"],
        ["\x47\x46",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xC6"],

        ["\xC7\xC7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x47\x47"],
        ["\x47\x47",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xC7"],

        ["\xC7\xC8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x47\x48"],
        ["\x47\x48",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xC8"],

        ["\xC7\xC9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x47\x49"],
        ["\x47\x49",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xC9"],

        ["\xC7\xCA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x47\x4A"],
        ["\x47\x4A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xCA"],

        ["\xC7\xCB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x47\x4B"],
        ["\x47\x4B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xCB"],

        ["\xC7\xCC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x47\x4C"],
        ["\x47\x4C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xCC"],

        ["\xC7\xCD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x47\x4D"],
        ["\x47\x4D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xCD"],

        ["\xC7\xCE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x47\x4E"],
        ["\x47\x4E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xCE"],

        ["\xC7\xCF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x47\x4F"],
        ["\x47\x4F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xCF"],

        ["\xC7\xD0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x47\x50"],
        ["\x47\x50",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xD0"],

        ["\xC7\xD1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x47\x51"],
        ["\x47\x51",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xD1"],

        ["\xC7\xD2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x47\x52"],
        ["\x47\x52",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xD2"],

        ["\xC7\xD3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x47\x53"],
        ["\x47\x53",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xD3"],

        ["\xC7\xD4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x47\x54"],
        ["\x47\x54",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xD4"],

        ["\xC7\xD5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x47\x55"],
        ["\x47\x55",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xD5"],

        ["\xC7\xD6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x47\x56"],
        ["\x47\x56",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xD6"],

        ["\xC7\xD7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x47\x57"],
        ["\x47\x57",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xD7"],

        ["\xC7\xD8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x47\x58"],
        ["\x47\x58",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xD8"],

        ["\xC7\xD9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x47\x59"],
        ["\x47\x59",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xD9"],

        ["\xC7\xDA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x47\x5A"],
        ["\x47\x5A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xDA"],

        ["\xC7\xDB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x47\x5B"],
        ["\x47\x5B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xDB"],

        ["\xC7\xDC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x47\x5C"],
        ["\x47\x5C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xDC"],

        ["\xC7\xDD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x47\x5D"],
        ["\x47\x5D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xDD"],

        ["\xC7\xDE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x47\x5E"],
        ["\x47\x5E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xDE"],

        ["\xC7\xDF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x47\x5F"],
        ["\x47\x5F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xDF"],

        ["\xC7\xE0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x47\x60"],
        ["\x47\x60",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xE0"],

        ["\xC7\xE1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x47\x61"],
        ["\x47\x61",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xE1"],

        ["\xC7\xE2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x47\x62"],
        ["\x47\x62",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xE2"],

        ["\xC7\xE3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x47\x63"],
        ["\x47\x63",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xE3"],

        ["\xC7\xE4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x47\x64"],
        ["\x47\x64",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xE4"],

        ["\xC7\xE5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x47\x65"],
        ["\x47\x65",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xE5"],

        ["\xC7\xE6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x47\x66"],
        ["\x47\x66",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xE6"],

        ["\xC7\xE7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x47\x67"],
        ["\x47\x67",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xE7"],

        ["\xC7\xE8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6A\x24"],
        ["\x6A\x24",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xE8"],

        ["\xC7\xE9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x47\x69"],
        ["\x47\x69",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xE9"],

        ["\xC7\xEA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x47\x6A"],
        ["\x47\x6A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xEA"],

        ["\xC7\xEB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x47\x6B"],
        ["\x47\x6B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xEB"],

        ["\xC7\xEC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x47\x6C"],
        ["\x47\x6C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xEC"],

        ["\xC7\xED",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x47\x6D"],
        ["\x47\x6D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xED"],

        ["\xC7\xEE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x47\x6E"],
        ["\x47\x6E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xEE"],

        ["\xC7\xEF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x47\x6F"],
        ["\x47\x6F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xEF"],

        ["\xC7\xF0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x47\x70"],
        ["\x47\x70",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xF0"],

        ["\xC7\xF1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x47\x71"],
        ["\x47\x71",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xF1"],

        ["\xC7\xF2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x47\x72"],
        ["\x47\x72",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xF2"],

        ["\xC7\xF3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x47\x73"],
        ["\x47\x73",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xF3"],

        ["\xC7\xF4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x47\x74"],
        ["\x47\x74",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xF4"],

        ["\xC7\xF5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x47\x75"],
        ["\x47\x75",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xF5"],

        ["\xC7\xF6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x47\x76"],
        ["\x47\x76",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xF6"],

        ["\xC7\xF7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x47\x77"],
        ["\x47\x77",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xF7"],

        ["\xC7\xF8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x47\x78"],
        ["\x47\x78",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xF8"],

        ["\xC7\xF9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x47\x79"],
        ["\x47\x79",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xF9"],

        ["\xC7\xFA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x47\x7A"],
        ["\x47\x7A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xFA"],

        ["\xC7\xFB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x47\x7B"],
        ["\x47\x7B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xFB"],

        ["\xC7\xFC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x47\x7C"],
        ["\x47\x7C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xFC"],

        ["\xC7\xFD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x47\x7D"],
        ["\x47\x7D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xFD"],

        ["\xC7\xFE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x47\x7E"],
        ["\x47\x7E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC7\xFE"],

        ["\xC8\xA1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x48\x21"],
        ["\x48\x21",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xA1"],

        ["\xC8\xA2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x48\x22"],
        ["\x48\x22",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xA2"],

        ["\xC8\xA3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x48\x23"],
        ["\x48\x23",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xA3"],

        ["\xC8\xA4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x48\x24"],
        ["\x48\x24",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xA4"],

        ["\xC8\xA5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x48\x25"],
        ["\x48\x25",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xA5"],

        ["\xC8\xA6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x48\x26"],
        ["\x48\x26",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xA6"],

        ["\xC8\xA7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x48\x27"],
        ["\x48\x27",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xA7"],

        ["\xC8\xA8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x48\x28"],
        ["\x48\x28",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xA8"],

        ["\xC8\xA9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x48\x29"],
        ["\x48\x29",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xA9"],

        ["\xC8\xAA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x48\x2A"],
        ["\x48\x2A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xAA"],

        ["\xC8\xAB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x48\x2B"],
        ["\x48\x2B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xAB"],

        ["\xC8\xAC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x48\x2C"],
        ["\x48\x2C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xAC"],

        ["\xC8\xAD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x48\x2D"],
        ["\x48\x2D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xAD"],

        ["\xC8\xAE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x48\x2E"],
        ["\x48\x2E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xAE"],

        ["\xC8\xAF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x48\x2F"],
        ["\x48\x2F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xAF"],

        ["\xC8\xB0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x48\x30"],
        ["\x48\x30",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xB0"],

        ["\xC8\xB1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x48\x31"],
        ["\x48\x31",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xB1"],

        ["\xC8\xB2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x48\x32"],
        ["\x48\x32",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xB2"],

        ["\xC8\xB3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x48\x33"],
        ["\x48\x33",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xB3"],

        ["\xC8\xB4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x48\x34"],
        ["\x48\x34",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xB4"],

        ["\xC8\xB5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x48\x35"],
        ["\x48\x35",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xB5"],

        ["\xC8\xB6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x48\x36"],
        ["\x48\x36",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xB6"],

        ["\xC8\xB7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x48\x37"],
        ["\x48\x37",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xB7"],

        ["\xC8\xB8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x48\x38"],
        ["\x48\x38",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xB8"],

        ["\xC8\xB9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x48\x39"],
        ["\x48\x39",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xB9"],

        ["\xC8\xBA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x48\x3A"],
        ["\x48\x3A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xBA"],

        ["\xC8\xBB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x48\x3B"],
        ["\x48\x3B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xBB"],

        ["\xC8\xBC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x48\x3C"],
        ["\x48\x3C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xBC"],

        ["\xC8\xBD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x48\x3D"],
        ["\x48\x3D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xBD"],

        ["\xC8\xBE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x48\x3E"],
        ["\x48\x3E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xBE"],

        ["\xC8\xBF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x48\x3F"],
        ["\x48\x3F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xBF"],

        ["\xC8\xC0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x48\x40"],
        ["\x48\x40",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xC0"],

        ["\xC8\xC1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x48\x41"],
        ["\x48\x41",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xC1"],

        ["\xC8\xC2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x48\x42"],
        ["\x48\x42",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xC2"],

        ["\xC8\xC3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x48\x43"],
        ["\x48\x43",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xC3"],

        ["\xC8\xC4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x48\x44"],
        ["\x48\x44",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xC4"],

        ["\xC8\xC5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x48\x45"],
        ["\x48\x45",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xC5"],

        ["\xC8\xC6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x48\x46"],
        ["\x48\x46",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xC6"],

        ["\xC8\xC7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x48\x47"],
        ["\x48\x47",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xC7"],

        ["\xC8\xC8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x48\x48"],
        ["\x48\x48",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xC8"],

        ["\xC8\xC9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x48\x49"],
        ["\x48\x49",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xC9"],

        ["\xC8\xCA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x48\x4A"],
        ["\x48\x4A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xCA"],

        ["\xC8\xCB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x48\x4B"],
        ["\x48\x4B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xCB"],

        ["\xC8\xCC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x48\x4C"],
        ["\x48\x4C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xCC"],

        ["\xC8\xCD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x48\x4D"],
        ["\x48\x4D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xCD"],

        ["\xC8\xCE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x48\x4E"],
        ["\x48\x4E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xCE"],

        ["\xC8\xCF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x48\x4F"],
        ["\x48\x4F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xCF"],

        ["\xC8\xD0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x48\x50"],
        ["\x48\x50",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xD0"],

        ["\xC8\xD1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x48\x51"],
        ["\x48\x51",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xD1"],

        ["\xC8\xD2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x48\x52"],
        ["\x48\x52",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xD2"],

        ["\xC8\xD3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x48\x53"],
        ["\x48\x53",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xD3"],

        ["\xC8\xD4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x48\x54"],
        ["\x48\x54",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xD4"],

        ["\xC8\xD5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x48\x55"],
        ["\x48\x55",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xD5"],

        ["\xC8\xD6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x48\x56"],
        ["\x48\x56",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xD6"],

        ["\xC8\xD7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x48\x57"],
        ["\x48\x57",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xD7"],

        ["\xC8\xD8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x48\x58"],
        ["\x48\x58",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xD8"],

        ["\xC8\xD9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x48\x59"],
        ["\x48\x59",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xD9"],

        ["\xC8\xDA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x48\x5A"],
        ["\x48\x5A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xDA"],

        ["\xC8\xDB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x48\x5B"],
        ["\x48\x5B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xDB"],

        ["\xC8\xDC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x48\x5C"],
        ["\x48\x5C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xDC"],

        ["\xC8\xDD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x48\x5D"],
        ["\x48\x5D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xDD"],

        ["\xC8\xDE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x48\x5E"],
        ["\x48\x5E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xDE"],

        ["\xC8\xDF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x48\x5F"],
        ["\x48\x5F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xDF"],

        ["\xC8\xE0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x48\x60"],
        ["\x48\x60",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xE0"],

        ["\xC8\xE1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x48\x61"],
        ["\x48\x61",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xE1"],

        ["\xC8\xE2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x48\x62"],
        ["\x48\x62",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xE2"],

        ["\xC8\xE3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x48\x63"],
        ["\x48\x63",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xE3"],

        ["\xC8\xE4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x48\x64"],
        ["\x48\x64",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xE4"],

        ["\xC8\xE5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x48\x65"],
        ["\x48\x65",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xE5"],

        ["\xC8\xE6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x48\x66"],
        ["\x48\x66",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xE6"],

        ["\xC8\xE7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x48\x67"],
        ["\x48\x67",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xE7"],

        ["\xC8\xE8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x48\x68"],
        ["\x48\x68",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xE8"],

        ["\xC8\xE9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x48\x69"],
        ["\x48\x69",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xE9"],

        ["\xC8\xEA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x48\x6A"],
        ["\x48\x6A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xEA"],

        ["\xC8\xEB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x48\x6B"],
        ["\x48\x6B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xEB"],

        ["\xC8\xEC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x48\x6C"],
        ["\x48\x6C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xEC"],

        ["\xC8\xED",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x48\x6D"],
        ["\x48\x6D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xED"],

        ["\xC8\xEE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x48\x6E"],
        ["\x48\x6E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xEE"],

        ["\xC8\xEF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x48\x6F"],
        ["\x48\x6F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xEF"],

        ["\xC8\xF0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x48\x70"],
        ["\x48\x70",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xF0"],

        ["\xC8\xF1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x48\x71"],
        ["\x48\x71",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xF1"],

        ["\xC8\xF2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x48\x72"],
        ["\x48\x72",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xF2"],

        ["\xC8\xF3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x48\x73"],
        ["\x48\x73",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xF3"],

        ["\xC8\xF4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x48\x74"],
        ["\x48\x74",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xF4"],

        ["\xC8\xF5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x48\x75"],
        ["\x48\x75",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xF5"],

        ["\xC8\xF6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x48\x76"],
        ["\x48\x76",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xF6"],

        ["\xC8\xF7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x48\x77"],
        ["\x48\x77",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xF7"],

        ["\xC8\xF8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x48\x78"],
        ["\x48\x78",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xF8"],

        ["\xC8\xF9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x48\x79"],
        ["\x48\x79",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xF9"],

        ["\xC8\xFA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x48\x7A"],
        ["\x48\x7A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xFA"],

        ["\xC8\xFB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x48\x7B"],
        ["\x48\x7B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xFB"],

        ["\xC8\xFC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x48\x7C"],
        ["\x48\x7C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xFC"],

        ["\xC8\xFD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x48\x7D"],
        ["\x48\x7D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xFD"],

        ["\xC8\xFE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x48\x7E"],
        ["\x48\x7E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC8\xFE"],

        ["\xC9\xA1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x49\x21"],
        ["\x49\x21",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xA1"],

        ["\xC9\xA2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x49\x22"],
        ["\x49\x22",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xA2"],

        ["\xC9\xA3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x49\x23"],
        ["\x49\x23",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xA3"],

        ["\xC9\xA4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x49\x24"],
        ["\x49\x24",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xA4"],

        ["\xC9\xA5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x49\x25"],
        ["\x49\x25",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xA5"],

        ["\xC9\xA6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x49\x26"],
        ["\x49\x26",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xA6"],

        ["\xC9\xA7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x49\x27"],
        ["\x49\x27",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xA7"],

        ["\xC9\xA8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x49\x28"],
        ["\x49\x28",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xA8"],

        ["\xC9\xA9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x49\x29"],
        ["\x49\x29",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xA9"],

        ["\xC9\xAA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x49\x2A"],
        ["\x49\x2A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xAA"],

        ["\xC9\xAB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x49\x2B"],
        ["\x49\x2B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xAB"],

        ["\xC9\xAC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x49\x2C"],
        ["\x49\x2C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xAC"],

        ["\xC9\xAD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x49\x2D"],
        ["\x49\x2D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xAD"],

        ["\xC9\xAE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x49\x2E"],
        ["\x49\x2E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xAE"],

        ["\xC9\xAF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x49\x2F"],
        ["\x49\x2F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xAF"],

        ["\xC9\xB0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x58"],
        ["\x5B\x58",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xB0"],

        ["\xC9\xB1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x49\x31"],
        ["\x49\x31",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xB1"],

        ["\xC9\xB2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x49\x32"],
        ["\x49\x32",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xB2"],

        ["\xC9\xB3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x49\x33"],
        ["\x49\x33",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xB3"],

        ["\xC9\xB4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x49\x34"],
        ["\x49\x34",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xB4"],

        ["\xC9\xB5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x49\x35"],
        ["\x49\x35",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xB5"],

        ["\xC9\xB6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x49\x36"],
        ["\x49\x36",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xB6"],

        ["\xC9\xB7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x49\x37"],
        ["\x49\x37",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xB7"],

        ["\xC9\xB8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x49\x38"],
        ["\x49\x38",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xB8"],

        ["\xC9\xB9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x49\x39"],
        ["\x49\x39",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xB9"],

        ["\xC9\xBA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x49\x3A"],
        ["\x49\x3A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xBA"],

        ["\xC9\xBB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x49\x3B"],
        ["\x49\x3B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xBB"],

        ["\xC9\xBC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x49\x3C"],
        ["\x49\x3C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xBC"],

        ["\xC9\xBD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x49\x3D"],
        ["\x49\x3D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xBD"],

        ["\xC9\xBE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x49\x3E"],
        ["\x49\x3E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xBE"],

        ["\xC9\xBF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x49\x3F"],
        ["\x49\x3F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xBF"],

        ["\xC9\xC0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x49\x40"],
        ["\x49\x40",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xC0"],

        ["\xC9\xC1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x49\x41"],
        ["\x49\x41",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xC1"],

        ["\xC9\xC2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x49\x42"],
        ["\x49\x42",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xC2"],

        ["\xC9\xC3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x49\x43"],
        ["\x49\x43",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xC3"],

        ["\xC9\xC4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x49\x44"],
        ["\x49\x44",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xC4"],

        ["\xC9\xC5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x49\x45"],
        ["\x49\x45",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xC5"],

        ["\xC9\xC6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x49\x46"],
        ["\x49\x46",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xC6"],

        ["\xC9\xC7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x49\x47"],
        ["\x49\x47",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xC7"],

        ["\xC9\xC8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x49\x48"],
        ["\x49\x48",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xC8"],

        ["\xC9\xC9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x49\x49"],
        ["\x49\x49",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xC9"],

        ["\xC9\xCA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x49\x4A"],
        ["\x49\x4A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xCA"],

        ["\xC9\xCB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x49\x4B"],
        ["\x49\x4B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xCB"],

        ["\xC9\xCC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x49\x4C"],
        ["\x49\x4C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xCC"],

        ["\xC9\xCD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x49\x4D"],
        ["\x49\x4D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xCD"],

        ["\xC9\xCE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x49\x4E"],
        ["\x49\x4E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xCE"],

        ["\xC9\xCF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x49\x4F"],
        ["\x49\x4F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xCF"],

        ["\xC9\xD0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x49\x50"],
        ["\x49\x50",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xD0"],

        ["\xC9\xD1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x49\x51"],
        ["\x49\x51",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xD1"],

        ["\xC9\xD2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x49\x52"],
        ["\x49\x52",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xD2"],

        ["\xC9\xD3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x49\x53"],
        ["\x49\x53",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xD3"],

        ["\xC9\xD4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x49\x54"],
        ["\x49\x54",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xD4"],

        ["\xC9\xD5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x49\x55"],
        ["\x49\x55",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xD5"],

        ["\xC9\xD6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x49\x56"],
        ["\x49\x56",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xD6"],

        ["\xC9\xD7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x49\x57"],
        ["\x49\x57",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xD7"],

        ["\xC9\xD8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x49\x58"],
        ["\x49\x58",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xD8"],

        ["\xC9\xD9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x49\x59"],
        ["\x49\x59",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xD9"],

        ["\xC9\xDA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x49\x5A"],
        ["\x49\x5A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xDA"],

        ["\xC9\xDB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x49\x5B"],
        ["\x49\x5B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xDB"],

        ["\xC9\xDC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x49\x5C"],
        ["\x49\x5C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xDC"],

        ["\xC9\xDD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x49\x5D"],
        ["\x49\x5D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xDD"],

        ["\xC9\xDE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x49\x5E"],
        ["\x49\x5E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xDE"],

        ["\xC9\xDF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x49\x5F"],
        ["\x49\x5F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xDF"],

        ["\xC9\xE0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x49\x60"],
        ["\x49\x60",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xE0"],

        ["\xC9\xE1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x49\x61"],
        ["\x49\x61",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xE1"],

        ["\xC9\xE2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x49\x62"],
        ["\x49\x62",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xE2"],

        ["\xC9\xE3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x49\x63"],
        ["\x49\x63",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xE3"],

        ["\xC9\xE4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x49\x64"],
        ["\x49\x64",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xE4"],

        ["\xC9\xE5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x49\x65"],
        ["\x49\x65",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xE5"],

        ["\xC9\xE6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x49\x66"],
        ["\x49\x66",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xE6"],

        ["\xC9\xE7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x49\x67"],
        ["\x49\x67",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xE7"],

        ["\xC9\xE8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x49\x68"],
        ["\x49\x68",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xE8"],

        ["\xC9\xE9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x49\x69"],
        ["\x49\x69",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xE9"],

        ["\xC9\xEA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x49\x6A"],
        ["\x49\x6A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xEA"],

        ["\xC9\xEB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x49\x6B"],
        ["\x49\x6B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xEB"],

        ["\xC9\xEC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x49\x6C"],
        ["\x49\x6C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xEC"],

        ["\xC9\xED",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x49\x6D"],
        ["\x49\x6D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xED"],

        ["\xC9\xEE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x49\x6E"],
        ["\x49\x6E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xEE"],

        ["\xC9\xEF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x49\x6F"],
        ["\x49\x6F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xEF"],

        ["\xC9\xF0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x49\x70"],
        ["\x49\x70",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xF0"],

        ["\xC9\xF1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x49\x71"],
        ["\x49\x71",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xF1"],

        ["\xC9\xF2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x49\x72"],
        ["\x49\x72",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xF2"],

        ["\xC9\xF3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x49\x73"],
        ["\x49\x73",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xF3"],

        ["\xC9\xF4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x49\x74"],
        ["\x49\x74",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xF4"],

        ["\xC9\xF5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x49\x75"],
        ["\x49\x75",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xF5"],

        ["\xC9\xF6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x49\x76"],
        ["\x49\x76",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xF6"],

        ["\xC9\xF7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x49\x77"],
        ["\x49\x77",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xF7"],

        ["\xC9\xF8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x49\x78"],
        ["\x49\x78",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xF8"],

        ["\xC9\xF9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x49\x79"],
        ["\x49\x79",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xF9"],

        ["\xC9\xFA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x49\x7A"],
        ["\x49\x7A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xFA"],

        ["\xC9\xFB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x49\x7B"],
        ["\x49\x7B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xFB"],

        ["\xC9\xFC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x49\x7C"],
        ["\x49\x7C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xFC"],

        ["\xC9\xFD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x49\x7D"],
        ["\x49\x7D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xFD"],

        ["\xC9\xFE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x49\x7E"],
        ["\x49\x7E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xFE"],

        ["\xCA\xA1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x21"],
        ["\x4A\x21",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xA1"],

        ["\xCA\xA2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x22"],
        ["\x4A\x22",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xA2"],

        ["\xCA\xA3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x23"],
        ["\x4A\x23",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xA3"],

        ["\xCA\xA4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x24"],
        ["\x4A\x24",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xA4"],

        ["\xCA\xA5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x25"],
        ["\x4A\x25",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xA5"],

        ["\xCA\xA6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x26"],
        ["\x4A\x26",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xA6"],

        ["\xCA\xA7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x27"],
        ["\x4A\x27",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xA7"],

        ["\xCA\xA8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x28"],
        ["\x4A\x28",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xA8"],

        ["\xCA\xA9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x29"],
        ["\x4A\x29",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xA9"],

        ["\xCA\xAA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x2A"],
        ["\x4A\x2A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xAA"],

        ["\xCA\xAB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x2B"],
        ["\x4A\x2B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xAB"],

        ["\xCA\xAC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x2C"],
        ["\x4A\x2C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xAC"],

        ["\xCA\xAD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x2D"],
        ["\x4A\x2D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xAD"],

        ["\xCA\xAE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x2E"],
        ["\x4A\x2E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xAE"],

        ["\xCA\xAF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x2F"],
        ["\x4A\x2F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xAF"],

        ["\xCA\xB0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x30"],
        ["\x4A\x30",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xB0"],

        ["\xCA\xB1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x31"],
        ["\x4A\x31",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xB1"],

        ["\xCA\xB2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x32"],
        ["\x4A\x32",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xB2"],

        ["\xCA\xB3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x33"],
        ["\x4A\x33",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xB3"],

        ["\xCA\xB4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x34"],
        ["\x4A\x34",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xB4"],

        ["\xCA\xB5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x35"],
        ["\x4A\x35",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xB5"],

        ["\xCA\xB6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x36"],
        ["\x4A\x36",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xB6"],

        ["\xCA\xB7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x37"],
        ["\x4A\x37",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xB7"],

        ["\xCA\xB8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x38"],
        ["\x4A\x38",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xB8"],

        ["\xCA\xB9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x39"],
        ["\x4A\x39",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xB9"],

        ["\xCA\xBA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x3A"],
        ["\x4A\x3A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xBA"],

        ["\xCA\xBB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x3B"],
        ["\x4A\x3B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xBB"],

        ["\xCA\xBC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x3C"],
        ["\x4A\x3C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xBC"],

        ["\xCA\xBD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x3D"],
        ["\x4A\x3D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xBD"],

        ["\xCA\xBE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x3E"],
        ["\x4A\x3E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xBE"],

        ["\xCA\xBF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x3F"],
        ["\x4A\x3F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xBF"],

        ["\xCA\xC0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x40"],
        ["\x4A\x40",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xC0"],

        ["\xCA\xC1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x41"],
        ["\x4A\x41",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xC1"],

        ["\xCA\xC2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x42"],
        ["\x4A\x42",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xC2"],

        ["\xCA\xC3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x43"],
        ["\x4A\x43",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xC3"],

        ["\xCA\xC4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x44"],
        ["\x4A\x44",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xC4"],

        ["\xCA\xC5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x45"],
        ["\x4A\x45",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xC5"],

        ["\xCA\xC6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x46"],
        ["\x4A\x46",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xC6"],

        ["\xCA\xC7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x47"],
        ["\x4A\x47",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xC7"],

        ["\xCA\xC8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x48"],
        ["\x4A\x48",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xC8"],

        ["\xCA\xC9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x49"],
        ["\x4A\x49",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xC9"],

        ["\xCA\xCA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x4A"],
        ["\x4A\x4A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xCA"],

        ["\xCA\xCB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x4B"],
        ["\x4A\x4B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xCB"],

        ["\xCA\xCC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x4C"],
        ["\x4A\x4C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xCC"],

        ["\xCA\xCD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x4D"],
        ["\x4A\x4D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xCD"],

        ["\xCA\xCE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x4E"],
        ["\x4A\x4E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xCE"],

        ["\xCA\xCF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x4F"],
        ["\x4A\x4F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xCF"],

        ["\xCA\xD0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x50"],
        ["\x4A\x50",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xD0"],

        ["\xCA\xD1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x51"],
        ["\x4A\x51",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xD1"],

        ["\xCA\xD2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x52"],
        ["\x4A\x52",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xD2"],

        ["\xCA\xD3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x53"],
        ["\x4A\x53",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xD3"],

        ["\xCA\xD4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x54"],
        ["\x4A\x54",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xD4"],

        ["\xCA\xD5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x55"],
        ["\x4A\x55",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xD5"],

        ["\xCA\xD6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x56"],
        ["\x4A\x56",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xD6"],

        ["\xCA\xD7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x57"],
        ["\x4A\x57",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xD7"],

        ["\xCA\xD8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x58"],
        ["\x4A\x58",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xD8"],

        ["\xCA\xD9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x59"],
        ["\x4A\x59",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xD9"],

        ["\xCA\xDA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x5A"],
        ["\x4A\x5A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xDA"],

        ["\xCA\xDB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x5B"],
        ["\x4A\x5B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xDB"],

        ["\xCA\xDC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x5C"],
        ["\x4A\x5C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xDC"],

        ["\xCA\xDD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x5D"],
        ["\x4A\x5D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xDD"],

        ["\xCA\xDE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x5E"],
        ["\x4A\x5E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xDE"],

        ["\xCA\xDF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x5F"],
        ["\x4A\x5F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xDF"],

        ["\xCA\xE0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x60"],
        ["\x4A\x60",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xE0"],

        ["\xCA\xE1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x61"],
        ["\x4A\x61",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xE1"],

        ["\xCA\xE2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x62"],
        ["\x4A\x62",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xE2"],

        ["\xCA\xE3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x63"],
        ["\x4A\x63",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xE3"],

        ["\xCA\xE4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x64"],
        ["\x4A\x64",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xE4"],

        ["\xCA\xE5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x65"],
        ["\x4A\x65",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xE5"],

        ["\xCA\xE6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x66"],
        ["\x4A\x66",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xE6"],

        ["\xCA\xE7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x67"],
        ["\x4A\x67",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xE7"],

        ["\xCA\xE8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x68"],
        ["\x4A\x68",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xE8"],

        ["\xCA\xE9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x69"],
        ["\x4A\x69",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xE9"],

        ["\xCA\xEA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x6A"],
        ["\x4A\x6A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xEA"],

        ["\xCA\xEB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x6B"],
        ["\x4A\x6B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xEB"],

        ["\xCA\xEC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x6C"],
        ["\x4A\x6C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xEC"],

        ["\xCA\xED",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x6D"],
        ["\x4A\x6D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xED"],

        ["\xCA\xEE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x6E"],
        ["\x4A\x6E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xEE"],

        ["\xCA\xEF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x6F"],
        ["\x4A\x6F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xEF"],

        ["\xCA\xF0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x70"],
        ["\x4A\x70",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xF0"],

        ["\xCA\xF1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x71"],
        ["\x4A\x71",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xF1"],

        ["\xCA\xF2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x72"],
        ["\x4A\x72",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xF2"],

        ["\xCA\xF3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x73"],
        ["\x4A\x73",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xF3"],

        ["\xCA\xF4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x74"],
        ["\x4A\x74",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xF4"],

        ["\xCA\xF5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x75"],
        ["\x4A\x75",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xF5"],

        ["\xCA\xF6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x76"],
        ["\x4A\x76",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xF6"],

        ["\xCA\xF7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x77"],
        ["\x4A\x77",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xF7"],

        ["\xCA\xF8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x78"],
        ["\x4A\x78",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xF8"],

        ["\xCA\xF9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x79"],
        ["\x4A\x79",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xF9"],

        ["\xCA\xFA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x7A"],
        ["\x4A\x7A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xFA"],

        ["\xCA\xFB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x7B"],
        ["\x4A\x7B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xFB"],

        ["\xCA\xFC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x7C"],
        ["\x4A\x7C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xFC"],

        ["\xCA\xFD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x7D"],
        ["\x4A\x7D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xFD"],

        ["\xCA\xFE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4A\x7E"],
        ["\x4A\x7E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCA\xFE"],

        ["\xCB\xA1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4B\x21"],
        ["\x4B\x21",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xA1"],

        ["\xCB\xA2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4B\x22"],
        ["\x4B\x22",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xA2"],

        ["\xCB\xA3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4B\x23"],
        ["\x4B\x23",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xA3"],

        ["\xCB\xA4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4B\x24"],
        ["\x4B\x24",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xA4"],

        ["\xCB\xA5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4B\x25"],
        ["\x4B\x25",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xA5"],

        ["\xCB\xA6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4B\x26"],
        ["\x4B\x26",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xA6"],

        ["\xCB\xA7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4B\x27"],
        ["\x4B\x27",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xA7"],

        ["\xCB\xA8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4B\x28"],
        ["\x4B\x28",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xA8"],

        ["\xCB\xA9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4B\x29"],
        ["\x4B\x29",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xA9"],

        ["\xCB\xAA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4B\x2A"],
        ["\x4B\x2A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xAA"],

        ["\xCB\xAB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4B\x2B"],
        ["\x4B\x2B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xAB"],

        ["\xCB\xAC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4B\x2C"],
        ["\x4B\x2C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xAC"],

        ["\xCB\xAD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4B\x2D"],
        ["\x4B\x2D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xAD"],

        ["\xCB\xAE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4B\x2E"],
        ["\x4B\x2E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xAE"],

        ["\xCB\xAF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4B\x2F"],
        ["\x4B\x2F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xAF"],

        ["\xCB\xB0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4B\x30"],
        ["\x4B\x30",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xB0"],

        ["\xCB\xB1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4B\x31"],
        ["\x4B\x31",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xB1"],

        ["\xCB\xB2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4B\x32"],
        ["\x4B\x32",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xB2"],

        ["\xCB\xB3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4B\x33"],
        ["\x4B\x33",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xB3"],

        ["\xCB\xB4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4B\x34"],
        ["\x4B\x34",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xB4"],

        ["\xCB\xB5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4B\x35"],
        ["\x4B\x35",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xB5"],

        ["\xCB\xB6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4B\x36"],
        ["\x4B\x36",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xB6"],

        ["\xCB\xB7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4B\x37"],
        ["\x4B\x37",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xB7"],

        ["\xCB\xB8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4B\x38"],
        ["\x4B\x38",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xB8"],

        ["\xCB\xB9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4B\x39"],
        ["\x4B\x39",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xB9"],

        ["\xCB\xBA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4B\x3A"],
        ["\x4B\x3A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xBA"],

        ["\xCB\xBB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4B\x3B"],
        ["\x4B\x3B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xBB"],

        ["\xCB\xBC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4B\x3C"],
        ["\x4B\x3C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xBC"],

        ["\xCB\xBD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4B\x3D"],
        ["\x4B\x3D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xBD"],

        ["\xCB\xBE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4B\x3E"],
        ["\x4B\x3E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xBE"],

        ["\xCB\xBF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4B\x3F"],
        ["\x4B\x3F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xBF"],

        ["\xCB\xC0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4B\x40"],
        ["\x4B\x40",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xC0"],

        ["\xCB\xC1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4B\x41"],
        ["\x4B\x41",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xC1"],

        ["\xCB\xC2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4B\x42"],
        ["\x4B\x42",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xC2"],

        ["\xCB\xC3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4B\x43"],
        ["\x4B\x43",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xC3"],

        ["\xCB\xC4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4B\x44"],
        ["\x4B\x44",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xC4"],

        ["\xCB\xC5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4B\x45"],
        ["\x4B\x45",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xC5"],

        ["\xCB\xC6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4B\x46"],
        ["\x4B\x46",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xC6"],

        ["\xCB\xC7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4B\x47"],
        ["\x4B\x47",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xC7"],

        ["\xCB\xC8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4B\x48"],
        ["\x4B\x48",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xC8"],

        ["\xCB\xC9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4B\x49"],
        ["\x4B\x49",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xC9"],

        ["\xCB\xCA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4B\x4A"],
        ["\x4B\x4A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xCA"],

        ["\xCB\xCB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4B\x4B"],
        ["\x4B\x4B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xCB"],

        ["\xCB\xCC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4B\x4C"],
        ["\x4B\x4C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xCC"],

        ["\xCB\xCD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4B\x4D"],
        ["\x4B\x4D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xCD"],

        ["\xCB\xCE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4B\x4E"],
        ["\x4B\x4E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xCE"],

        ["\xCB\xCF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4B\x4F"],
        ["\x4B\x4F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xCF"],

        ["\xCB\xD0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4B\x50"],
        ["\x4B\x50",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xD0"],

        ["\xCB\xD1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4B\x51"],
        ["\x4B\x51",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xD1"],

        ["\xCB\xD2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4B\x52"],
        ["\x4B\x52",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xD2"],

        ["\xCB\xD3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4B\x53"],
        ["\x4B\x53",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xD3"],

        ["\xCB\xD4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4B\x54"],
        ["\x4B\x54",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xD4"],

        ["\xCB\xD5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4B\x55"],
        ["\x4B\x55",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xD5"],

        ["\xCB\xD6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4B\x56"],
        ["\x4B\x56",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xD6"],

        ["\xCB\xD7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4B\x57"],
        ["\x4B\x57",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xD7"],

        ["\xCB\xD8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4B\x58"],
        ["\x4B\x58",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xD8"],

        ["\xCB\xD9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4B\x59"],
        ["\x4B\x59",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xD9"],

        ["\xCB\xDA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4B\x5A"],
        ["\x4B\x5A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xDA"],

        ["\xCB\xDB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4B\x5B"],
        ["\x4B\x5B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xDB"],

        ["\xCB\xDC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4B\x5C"],
        ["\x4B\x5C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xDC"],

        ["\xCB\xDD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4B\x5D"],
        ["\x4B\x5D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xDD"],

        ["\xCB\xDE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4B\x5E"],
        ["\x4B\x5E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xDE"],

        ["\xCB\xDF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4B\x5F"],
        ["\x4B\x5F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xDF"],

        ["\xCB\xE0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4B\x60"],
        ["\x4B\x60",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xE0"],

        ["\xCB\xE1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4B\x61"],
        ["\x4B\x61",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xE1"],

        ["\xCB\xE2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4B\x62"],
        ["\x4B\x62",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xE2"],

        ["\xCB\xE3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4B\x63"],
        ["\x4B\x63",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xE3"],

        ["\xCB\xE4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4B\x64"],
        ["\x4B\x64",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xE4"],

        ["\xCB\xE5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4B\x65"],
        ["\x4B\x65",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xE5"],

        ["\xCB\xE6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4B\x66"],
        ["\x4B\x66",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xE6"],

        ["\xCB\xE7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4B\x67"],
        ["\x4B\x67",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xE7"],

        ["\xCB\xE8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4B\x68"],
        ["\x4B\x68",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xE8"],

        ["\xCB\xE9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4B\x69"],
        ["\x4B\x69",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xE9"],

        ["\xCB\xEA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xCE"],
        ["\xBF\xCE",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xEA"],

        ["\xCB\xEB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4B\x6B"],
        ["\x4B\x6B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xEB"],

        ["\xCB\xEC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4B\x6C"],
        ["\x4B\x6C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xEC"],

        ["\xCB\xED",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4B\x6D"],
        ["\x4B\x6D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xED"],

        ["\xCB\xEE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4B\x6E"],
        ["\x4B\x6E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xEE"],

        ["\xCB\xEF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4B\x6F"],
        ["\x4B\x6F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xEF"],

        ["\xCB\xF0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4B\x70"],
        ["\x4B\x70",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xF0"],

        ["\xCB\xF1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4B\x71"],
        ["\x4B\x71",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xF1"],

        ["\xCB\xF2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4B\x72"],
        ["\x4B\x72",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xF2"],

        ["\xCB\xF3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4B\x73"],
        ["\x4B\x73",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xF3"],

        ["\xCB\xF4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4B\x74"],
        ["\x4B\x74",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xF4"],

        ["\xCB\xF5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4B\x75"],
        ["\x4B\x75",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xF5"],

        ["\xCB\xF6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4B\x76"],
        ["\x4B\x76",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xF6"],

        ["\xCB\xF7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4B\x77"],
        ["\x4B\x77",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xF7"],

        ["\xCB\xF8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4B\x78"],
        ["\x4B\x78",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xF8"],

        ["\xCB\xF9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x56"],
        ["\x50\x56",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xF9"],

        ["\xCB\xFA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4B\x7A"],
        ["\x4B\x7A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xFA"],

        ["\xCB\xFB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4B\x7B"],
        ["\x4B\x7B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xFB"],

        ["\xCB\xFC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4B\x7C"],
        ["\x4B\x7C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xFC"],

        ["\xCB\xFD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4B\x7D"],
        ["\x4B\x7D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xFD"],

        ["\xCB\xFE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4B\x7E"],
        ["\x4B\x7E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCB\xFE"],

        ["\xCC\xA1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x21"],
        ["\x4C\x21",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xA1"],

        ["\xCC\xA2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x22"],
        ["\x4C\x22",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xA2"],

        ["\xCC\xA3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x23"],
        ["\x4C\x23",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xA3"],

        ["\xCC\xA4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x24"],
        ["\x4C\x24",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xA4"],

        ["\xCC\xA5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x25"],
        ["\x4C\x25",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xA5"],

        ["\xCC\xA6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x26"],
        ["\x4C\x26",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xA6"],

        ["\xCC\xA7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x27"],
        ["\x4C\x27",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xA7"],

        ["\xCC\xA8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x28"],
        ["\x4C\x28",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xA8"],

        ["\xCC\xA9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x29"],
        ["\x4C\x29",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xA9"],

        ["\xCC\xAA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x2A"],
        ["\x4C\x2A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xAA"],

        ["\xCC\xAB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x2B"],
        ["\x4C\x2B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xAB"],

        ["\xCC\xAC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x2C"],
        ["\x4C\x2C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xAC"],

        ["\xCC\xAD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x2D"],
        ["\x4C\x2D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xAD"],

        ["\xCC\xAE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x2E"],
        ["\x4C\x2E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xAE"],

        ["\xCC\xAF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x2F"],
        ["\x4C\x2F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xAF"],

        ["\xCC\xB0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x30"],
        ["\x4C\x30",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xB0"],

        ["\xCC\xB1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x31"],
        ["\x4C\x31",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xB1"],

        ["\xCC\xB2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x32"],
        ["\x4C\x32",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xB2"],

        ["\xCC\xB3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x33"],
        ["\x4C\x33",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xB3"],

        ["\xCC\xB4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x34"],
        ["\x4C\x34",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xB4"],

        ["\xCC\xB5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x35"],
        ["\x4C\x35",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xB5"],

        ["\xCC\xB6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x36"],
        ["\x4C\x36",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xB6"],

        ["\xCC\xB7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x37"],
        ["\x4C\x37",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xB7"],

        ["\xCC\xB8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x38"],
        ["\x4C\x38",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xB8"],

        ["\xCC\xB9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x39"],
        ["\x4C\x39",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xB9"],

        ["\xCC\xBA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x3A"],
        ["\x4C\x3A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xBA"],

        ["\xCC\xBB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x3B"],
        ["\x4C\x3B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xBB"],

        ["\xCC\xBC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x3C"],
        ["\x4C\x3C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xBC"],

        ["\xCC\xBD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x3D"],
        ["\x4C\x3D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xBD"],

        ["\xCC\xBE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x3E"],
        ["\x4C\x3E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xBE"],

        ["\xCC\xBF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x3F"],
        ["\x4C\x3F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xBF"],

        ["\xCC\xC0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x40"],
        ["\x4C\x40",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xC0"],

        ["\xCC\xC1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x41"],
        ["\x4C\x41",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xC1"],

        ["\xCC\xC2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x42"],
        ["\x4C\x42",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xC2"],

        ["\xCC\xC3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x43"],
        ["\x4C\x43",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xC3"],

        ["\xCC\xC4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x44"],
        ["\x4C\x44",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xC4"],

        ["\xCC\xC5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x45"],
        ["\x4C\x45",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xC5"],

        ["\xCC\xC6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x46"],
        ["\x4C\x46",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xC6"],

        ["\xCC\xC7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x47"],
        ["\x4C\x47",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xC7"],

        ["\xCC\xC8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x48"],
        ["\x4C\x48",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xC8"],

        ["\xCC\xC9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x49"],
        ["\x4C\x49",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xC9"],

        ["\xCC\xCA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x4A"],
        ["\x4C\x4A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xCA"],

        ["\xCC\xCB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x4B"],
        ["\x4C\x4B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xCB"],

        ["\xCC\xCC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x4C"],
        ["\x4C\x4C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xCC"],

        ["\xCC\xCD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x4D"],
        ["\x4C\x4D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xCD"],

        ["\xCC\xCE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x4E"],
        ["\x4C\x4E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xCE"],

        ["\xCC\xCF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x4F"],
        ["\x4C\x4F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xCF"],

        ["\xCC\xD0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x50"],
        ["\x4C\x50",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xD0"],

        ["\xCC\xD1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x51"],
        ["\x4C\x51",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xD1"],

        ["\xCC\xD2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x52"],
        ["\x4C\x52",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xD2"],

        ["\xCC\xD3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x53"],
        ["\x4C\x53",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xD3"],

        ["\xCC\xD4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x54"],
        ["\x4C\x54",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xD4"],

        ["\xCC\xD5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x55"],
        ["\x4C\x55",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xD5"],

        ["\xCC\xD6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x56"],
        ["\x4C\x56",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xD6"],

        ["\xCC\xD7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x57"],
        ["\x4C\x57",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xD7"],

        ["\xCC\xD8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x58"],
        ["\x4C\x58",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xD8"],

        ["\xCC\xD9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x59"],
        ["\x4C\x59",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xD9"],

        ["\xCC\xDA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x5A"],
        ["\x4C\x5A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xDA"],

        ["\xCC\xDB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x5B"],
        ["\x4C\x5B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xDB"],

        ["\xCC\xDC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x5C"],
        ["\x4C\x5C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xDC"],

        ["\xCC\xDD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x5D"],
        ["\x4C\x5D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xDD"],

        ["\xCC\xDE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x5E"],
        ["\x4C\x5E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xDE"],

        ["\xCC\xDF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x5F"],
        ["\x4C\x5F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xDF"],

        ["\xCC\xE0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x60"],
        ["\x4C\x60",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xE0"],

        ["\xCC\xE1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x61"],
        ["\x4C\x61",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xE1"],

        ["\xCC\xE2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x62"],
        ["\x4C\x62",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xE2"],

        ["\xCC\xE3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x63"],
        ["\x4C\x63",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xE3"],

        ["\xCC\xE4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x64"],
        ["\x4C\x64",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xE4"],

        ["\xCC\xE5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x65"],
        ["\x4C\x65",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xE5"],

        ["\xCC\xE6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x66"],
        ["\x4C\x66",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xE6"],

        ["\xCC\xE7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x67"],
        ["\x4C\x67",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xE7"],

        ["\xCC\xE8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x68"],
        ["\x4C\x68",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xE8"],

        ["\xCC\xE9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x69"],
        ["\x4C\x69",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xE9"],

        ["\xCC\xEA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x6A"],
        ["\x4C\x6A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xEA"],

        ["\xCC\xEB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x6B"],
        ["\x4C\x6B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xEB"],

        ["\xCC\xEC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x6C"],
        ["\x4C\x6C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xEC"],

        ["\xCC\xED",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x6D"],
        ["\x4C\x6D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xED"],

        ["\xCC\xEE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x6E"],
        ["\x4C\x6E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xEE"],

        ["\xCC\xEF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x6F"],
        ["\x4C\x6F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xEF"],

        ["\xCC\xF0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x70"],
        ["\x4C\x70",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xF0"],

        ["\xCC\xF1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x71"],
        ["\x4C\x71",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xF1"],

        ["\xCC\xF2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x72"],
        ["\x4C\x72",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xF2"],

        ["\xCC\xF3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x73"],
        ["\x4C\x73",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xF3"],

        ["\xCC\xF4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x74"],
        ["\x4C\x74",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xF4"],

        ["\xCC\xF5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x75"],
        ["\x4C\x75",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xF5"],

        ["\xCC\xF6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x76"],
        ["\x4C\x76",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xF6"],

        ["\xCC\xF7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x77"],
        ["\x4C\x77",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xF7"],

        ["\xCC\xF8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x78"],
        ["\x4C\x78",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xF8"],

        ["\xCC\xF9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x2E"],
        ["\x69\x2E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xF9"],

        ["\xCC\xFA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x7A"],
        ["\x4C\x7A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xFA"],

        ["\xCC\xFB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x7B"],
        ["\x4C\x7B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xFB"],

        ["\xCC\xFC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x7C"],
        ["\x4C\x7C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xFC"],

        ["\xCC\xFD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x7D"],
        ["\x4C\x7D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xFD"],

        ["\xCC\xFE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x7E"],
        ["\x4C\x7E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xFE"],

        ["\xCD\xA1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4D\x21"],
        ["\x4D\x21",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xA1"],

        ["\xCD\xA2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4D\x22"],
        ["\x4D\x22",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xA2"],

        ["\xCD\xA3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4D\x23"],
        ["\x4D\x23",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xA3"],

        ["\xCD\xA4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4D\x24"],
        ["\x4D\x24",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xA4"],

        ["\xCD\xA5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4D\x25"],
        ["\x4D\x25",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xA5"],

        ["\xCD\xA6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4D\x26"],
        ["\x4D\x26",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xA6"],

        ["\xCD\xA7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4D\x27"],
        ["\x4D\x27",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xA7"],

        ["\xCD\xA8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4D\x28"],
        ["\x4D\x28",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xA8"],

        ["\xCD\xA9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4D\x29"],
        ["\x4D\x29",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xA9"],

        ["\xCD\xAA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4D\x2A"],
        ["\x4D\x2A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xAA"],

        ["\xCD\xAB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4D\x2B"],
        ["\x4D\x2B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xAB"],

        ["\xCD\xAC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4D\x2C"],
        ["\x4D\x2C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xAC"],

        ["\xCD\xAD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4D\x2D"],
        ["\x4D\x2D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xAD"],

        ["\xCD\xAE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4D\x2E"],
        ["\x4D\x2E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xAE"],

        ["\xCD\xAF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4D\x2F"],
        ["\x4D\x2F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xAF"],

        ["\xCD\xB0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4D\x30"],
        ["\x4D\x30",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xB0"],

        ["\xCD\xB1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4D\x31"],
        ["\x4D\x31",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xB1"],

        ["\xCD\xB2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4D\x32"],
        ["\x4D\x32",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xB2"],

        ["\xCD\xB3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4D\x33"],
        ["\x4D\x33",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xB3"],

        ["\xCD\xB4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4D\x34"],
        ["\x4D\x34",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xB4"],

        ["\xCD\xB5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4D\x35"],
        ["\x4D\x35",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xB5"],

        ["\xCD\xB6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4D\x36"],
        ["\x4D\x36",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xB6"],

        ["\xCD\xB7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4D\x37"],
        ["\x4D\x37",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xB7"],

        ["\xCD\xB8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4D\x38"],
        ["\x4D\x38",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xB8"],

        ["\xCD\xB9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4D\x39"],
        ["\x4D\x39",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xB9"],

        ["\xCD\xBA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4D\x3A"],
        ["\x4D\x3A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xBA"],

        ["\xCD\xBB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4D\x3B"],
        ["\x4D\x3B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xBB"],

        ["\xCD\xBC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4D\x3C"],
        ["\x4D\x3C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xBC"],

        ["\xCD\xBD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4D\x3D"],
        ["\x4D\x3D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xBD"],

        ["\xCD\xBE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4D\x3E"],
        ["\x4D\x3E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xBE"],

        ["\xCD\xBF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4D\x3F"],
        ["\x4D\x3F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xBF"],

        ["\xCD\xC0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4D\x40"],
        ["\x4D\x40",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xC0"],

        ["\xCD\xC1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4D\x41"],
        ["\x4D\x41",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xC1"],

        ["\xCD\xC2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4D\x42"],
        ["\x4D\x42",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xC2"],

        ["\xCD\xC3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4D\x43"],
        ["\x4D\x43",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xC3"],

        ["\xCD\xC4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4D\x44"],
        ["\x4D\x44",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xC4"],

        ["\xCD\xC5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4D\x45"],
        ["\x4D\x45",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xC5"],

        ["\xCD\xC6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4D\x46"],
        ["\x4D\x46",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xC6"],

        ["\xCD\xC7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4D\x47"],
        ["\x4D\x47",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xC7"],

        ["\xCD\xC8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4D\x48"],
        ["\x4D\x48",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xC8"],

        ["\xCD\xC9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4D\x49"],
        ["\x4D\x49",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xC9"],

        ["\xCD\xCA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4D\x4A"],
        ["\x4D\x4A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xCA"],

        ["\xCD\xCB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4D\x4B"],
        ["\x4D\x4B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xCB"],

        ["\xCD\xCC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4D\x4C"],
        ["\x4D\x4C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xCC"],

        ["\xCD\xCD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4D\x4D"],
        ["\x4D\x4D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xCD"],

        ["\xCD\xCE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4D\x4E"],
        ["\x4D\x4E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xCE"],

        ["\xCD\xCF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4D\x4F"],
        ["\x4D\x4F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xCF"],

        ["\xCD\xD0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4D\x50"],
        ["\x4D\x50",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xD0"],

        ["\xCD\xD1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4D\x51"],
        ["\x4D\x51",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xD1"],

        ["\xCD\xD2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4D\x52"],
        ["\x4D\x52",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xD2"],

        ["\xCD\xD3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4D\x53"],
        ["\x4D\x53",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xD3"],

        ["\xCD\xD4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4D\x54"],
        ["\x4D\x54",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xD4"],

        ["\xCD\xD5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4D\x55"],
        ["\x4D\x55",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xD5"],

        ["\xCD\xD6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4D\x56"],
        ["\x4D\x56",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xD6"],

        ["\xCD\xD7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4D\x57"],
        ["\x4D\x57",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xD7"],

        ["\xCD\xD8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4D\x58"],
        ["\x4D\x58",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xD8"],

        ["\xCD\xD9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4D\x59"],
        ["\x4D\x59",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xD9"],

        ["\xCD\xDA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xC4"],
        ["\xD0\xC4",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xDA"],

        ["\xCD\xDB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4D\x5B"],
        ["\x4D\x5B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xDB"],

        ["\xCD\xDC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4D\x5C"],
        ["\x4D\x5C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xDC"],

        ["\xCD\xDD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4D\x5D"],
        ["\x4D\x5D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xDD"],

        ["\xCD\xDE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4D\x5E"],
        ["\x4D\x5E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xDE"],

        ["\xCD\xDF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4D\x5F"],
        ["\x4D\x5F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xDF"],

        ["\xCD\xE0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4D\x60"],
        ["\x4D\x60",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xE0"],

        ["\xCD\xE1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4D\x61"],
        ["\x4D\x61",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xE1"],

        ["\xCD\xE2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4D\x62"],
        ["\x4D\x62",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xE2"],

        ["\xCD\xE3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4D\x63"],
        ["\x4D\x63",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xE3"],

        ["\xCD\xE4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4D\x64"],
        ["\x4D\x64",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xE4"],

        ["\xCD\xE5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4D\x65"],
        ["\x4D\x65",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xE5"],

        ["\xCD\xE6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4D\x66"],
        ["\x4D\x66",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xE6"],

        ["\xCD\xE7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4D\x67"],
        ["\x4D\x67",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xE7"],

        ["\xCD\xE8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4D\x68"],
        ["\x4D\x68",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xE8"],

        ["\xCD\xE9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4D\x69"],
        ["\x4D\x69",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xE9"],

        ["\xCD\xEA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4D\x6A"],
        ["\x4D\x6A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xEA"],

        ["\xCD\xEB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4D\x6B"],
        ["\x4D\x6B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xEB"],

        ["\xCD\xEC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4D\x6C"],
        ["\x4D\x6C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xEC"],

        ["\xCD\xED",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4D\x6D"],
        ["\x4D\x6D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xED"],

        ["\xCD\xEE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4D\x6E"],
        ["\x4D\x6E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xEE"],

        ["\xCD\xEF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4D\x6F"],
        ["\x4D\x6F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xEF"],

        ["\xCD\xF0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4D\x70"],
        ["\x4D\x70",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xF0"],

        ["\xCD\xF1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4D\x71"],
        ["\x4D\x71",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xF1"],

        ["\xCD\xF2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4D\x72"],
        ["\x4D\x72",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xF2"],

        ["\xCD\xF3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4D\x73"],
        ["\x4D\x73",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xF3"],

        ["\xCD\xF4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4D\x74"],
        ["\x4D\x74",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xF4"],

        ["\xCD\xF5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4D\x75"],
        ["\x4D\x75",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xF5"],

        ["\xCD\xF6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4D\x76"],
        ["\x4D\x76",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xF6"],

        ["\xCD\xF7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4D\x77"],
        ["\x4D\x77",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xF7"],

        ["\xCD\xF8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4D\x78"],
        ["\x4D\x78",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xF8"],

        ["\xCD\xF9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4D\x79"],
        ["\x4D\x79",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xF9"],

        ["\xCD\xFA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4D\x7A"],
        ["\x4D\x7A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xFA"],

        ["\xCD\xFB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4D\x7B"],
        ["\x4D\x7B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xFB"],

        ["\xCD\xFC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4D\x7C"],
        ["\x4D\x7C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xFC"],

        ["\xCD\xFD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4D\x7D"],
        ["\x4D\x7D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xFD"],

        ["\xCD\xFE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4D\x7E"],
        ["\x4D\x7E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCD\xFE"],

        ["\xCE\xA1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4E\x21"],
        ["\x4E\x21",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xA1"],

        ["\xCE\xA2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4E\x22"],
        ["\x4E\x22",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xA2"],

        ["\xCE\xA3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4E\x23"],
        ["\x4E\x23",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xA3"],

        ["\xCE\xA4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4E\x24"],
        ["\x4E\x24",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xA4"],

        ["\xCE\xA5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4E\x25"],
        ["\x4E\x25",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xA5"],

        ["\xCE\xA6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4E\x26"],
        ["\x4E\x26",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xA6"],

        ["\xCE\xA7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4E\x27"],
        ["\x4E\x27",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xA7"],

        ["\xCE\xA8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4E\x28"],
        ["\x4E\x28",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xA8"],

        ["\xCE\xA9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4E\x29"],
        ["\x4E\x29",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xA9"],

        ["\xCE\xAA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4E\x2A"],
        ["\x4E\x2A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xAA"],

        ["\xCE\xAB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4E\x2B"],
        ["\x4E\x2B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xAB"],

        ["\xCE\xAC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4E\x2C"],
        ["\x4E\x2C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xAC"],

        ["\xCE\xAD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4E\x2D"],
        ["\x4E\x2D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xAD"],

        ["\xCE\xAE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4E\x2E"],
        ["\x4E\x2E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xAE"],

        ["\xCE\xAF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4E\x2F"],
        ["\x4E\x2F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xAF"],

        ["\xCE\xB0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4E\x30"],
        ["\x4E\x30",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xB0"],

        ["\xCE\xB1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4E\x31"],
        ["\x4E\x31",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xB1"],

        ["\xCE\xB2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4E\x32"],
        ["\x4E\x32",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xB2"],

        ["\xCE\xB3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4E\x33"],
        ["\x4E\x33",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xB3"],

        ["\xCE\xB4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4E\x34"],
        ["\x4E\x34",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xB4"],

        ["\xCE\xB5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4E\x35"],
        ["\x4E\x35",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xB5"],

        ["\xCE\xB6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4E\x36"],
        ["\x4E\x36",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xB6"],

        ["\xCE\xB7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4E\x37"],
        ["\x4E\x37",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xB7"],

        ["\xCE\xB8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4E\x38"],
        ["\x4E\x38",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xB8"],

        ["\xCE\xB9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4E\x39"],
        ["\x4E\x39",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xB9"],

        ["\xCE\xBA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4E\x3A"],
        ["\x4E\x3A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xBA"],

        ["\xCE\xBB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4E\x3B"],
        ["\x4E\x3B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xBB"],

        ["\xCE\xBC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4E\x3C"],
        ["\x4E\x3C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xBC"],

        ["\xCE\xBD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4E\x3D"],
        ["\x4E\x3D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xBD"],

        ["\xCE\xBE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4E\x3E"],
        ["\x4E\x3E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xBE"],

        ["\xCE\xBF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4E\x3F"],
        ["\x4E\x3F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xBF"],

        ["\xCE\xC0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4E\x40"],
        ["\x4E\x40",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xC0"],

        ["\xCE\xC1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4E\x41"],
        ["\x4E\x41",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xC1"],

        ["\xCE\xC2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4E\x42"],
        ["\x4E\x42",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xC2"],

        ["\xCE\xC3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4E\x43"],
        ["\x4E\x43",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xC3"],

        ["\xCE\xC4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4E\x44"],
        ["\x4E\x44",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xC4"],

        ["\xCE\xC5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4E\x45"],
        ["\x4E\x45",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xC5"],

        ["\xCE\xC6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4E\x46"],
        ["\x4E\x46",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xC6"],

        ["\xCE\xC7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4E\x47"],
        ["\x4E\x47",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xC7"],

        ["\xCE\xC8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4E\x48"],
        ["\x4E\x48",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xC8"],

        ["\xCE\xC9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4E\x49"],
        ["\x4E\x49",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xC9"],

        ["\xCE\xCA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4E\x4A"],
        ["\x4E\x4A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xCA"],

        ["\xCE\xCB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4E\x4B"],
        ["\x4E\x4B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xCB"],

        ["\xCE\xCC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4E\x4C"],
        ["\x4E\x4C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xCC"],

        ["\xCE\xCD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4E\x4D"],
        ["\x4E\x4D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xCD"],

        ["\xCE\xCE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4E\x4E"],
        ["\x4E\x4E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xCE"],

        ["\xCE\xCF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4E\x4F"],
        ["\x4E\x4F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xCF"],

        ["\xCE\xD0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4E\x50"],
        ["\x4E\x50",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xD0"],

        ["\xCE\xD1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4E\x51"],
        ["\x4E\x51",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xD1"],

        ["\xCE\xD2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4E\x52"],
        ["\x4E\x52",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xD2"],

        ["\xCE\xD3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4E\x53"],
        ["\x4E\x53",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xD3"],

        ["\xCE\xD4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4E\x54"],
        ["\x4E\x54",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xD4"],

        ["\xCE\xD5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4E\x55"],
        ["\x4E\x55",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xD5"],

        ["\xCE\xD6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4E\x56"],
        ["\x4E\x56",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xD6"],

        ["\xCE\xD7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4E\x57"],
        ["\x4E\x57",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xD7"],

        ["\xCE\xD8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4E\x58"],
        ["\x4E\x58",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xD8"],

        ["\xCE\xD9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4E\x59"],
        ["\x4E\x59",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xD9"],

        ["\xCE\xDA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4E\x5A"],
        ["\x4E\x5A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xDA"],

        ["\xCE\xDB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4E\x5B"],
        ["\x4E\x5B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xDB"],

        ["\xCE\xDC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4E\x5C"],
        ["\x4E\x5C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xDC"],

        ["\xCE\xDD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4E\x5D"],
        ["\x4E\x5D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xDD"],

        ["\xCE\xDE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4E\x5E"],
        ["\x4E\x5E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xDE"],

        ["\xCE\xDF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4E\x5F"],
        ["\x4E\x5F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xDF"],

        ["\xCE\xE0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4E\x60"],
        ["\x4E\x60",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xE0"],

        ["\xCE\xE1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4E\x61"],
        ["\x4E\x61",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xE1"],

        ["\xCE\xE2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4E\x62"],
        ["\x4E\x62",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xE2"],

        ["\xCE\xE3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4E\x63"],
        ["\x4E\x63",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xE3"],

        ["\xCE\xE4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4E\x64"],
        ["\x4E\x64",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xE4"],

        ["\xCE\xE5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4E\x65"],
        ["\x4E\x65",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xE5"],

        ["\xCE\xE6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4E\x66"],
        ["\x4E\x66",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xE6"],

        ["\xCE\xE7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4E\x67"],
        ["\x4E\x67",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xE7"],

        ["\xCE\xE8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4E\x68"],
        ["\x4E\x68",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xE8"],

        ["\xCE\xE9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4E\x69"],
        ["\x4E\x69",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xE9"],

        ["\xCE\xEA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4E\x6A"],
        ["\x4E\x6A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xEA"],

        ["\xCE\xEB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4E\x6B"],
        ["\x4E\x6B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xEB"],

        ["\xCE\xEC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4E\x6C"],
        ["\x4E\x6C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xEC"],

        ["\xCE\xED",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4E\x6D"],
        ["\x4E\x6D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xED"],

        ["\xCE\xEE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4E\x6E"],
        ["\x4E\x6E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xEE"],

        ["\xCE\xEF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4E\x6F"],
        ["\x4E\x6F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xEF"],

        ["\xCE\xF0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4E\x70"],
        ["\x4E\x70",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xF0"],

        ["\xCE\xF1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4E\x71"],
        ["\x4E\x71",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xF1"],

        ["\xCE\xF2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4E\x72"],
        ["\x4E\x72",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xF2"],

        ["\xCE\xF3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4E\x73"],
        ["\x4E\x73",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xF3"],

        ["\xCE\xF4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4E\x74"],
        ["\x4E\x74",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xF4"],

        ["\xCE\xF5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4E\x75"],
        ["\x4E\x75",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xF5"],

        ["\xCE\xF6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4E\x76"],
        ["\x4E\x76",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xF6"],

        ["\xCE\xF7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4E\x77"],
        ["\x4E\x77",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xF7"],

        ["\xCE\xF8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4E\x78"],
        ["\x4E\x78",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xF8"],

        ["\xCE\xF9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4E\x79"],
        ["\x4E\x79",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xF9"],

        ["\xCE\xFA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4E\x7A"],
        ["\x4E\x7A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xFA"],

        ["\xCE\xFB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4E\x7B"],
        ["\x4E\x7B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xFB"],

        ["\xCE\xFC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4E\x7C"],
        ["\x4E\x7C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xFC"],

        ["\xCE\xFD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4E\x7D"],
        ["\x4E\x7D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xFD"],

        ["\xCE\xFE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4E\x7E"],
        ["\x4E\x7E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xFE"],

        ["\xCF\xA1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\x21"],
        ["\x4F\x21",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xA1"],

        ["\xCF\xA2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\x22"],
        ["\x4F\x22",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xA2"],

        ["\xCF\xA3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\x23"],
        ["\x4F\x23",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xA3"],

        ["\xCF\xA4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\x24"],
        ["\x4F\x24",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xA4"],

        ["\xCF\xA5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\x25"],
        ["\x4F\x25",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xA5"],

        ["\xCF\xA6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\x26"],
        ["\x4F\x26",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xA6"],

        ["\xCF\xA7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\x27"],
        ["\x4F\x27",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xA7"],

        ["\xCF\xA8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\x28"],
        ["\x4F\x28",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xA8"],

        ["\xCF\xA9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\x29"],
        ["\x4F\x29",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xA9"],

        ["\xCF\xAA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\x2A"],
        ["\x4F\x2A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xAA"],

        ["\xCF\xAB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\x2B"],
        ["\x4F\x2B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xAB"],

        ["\xCF\xAC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\x2C"],
        ["\x4F\x2C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xAC"],

        ["\xCF\xAD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\x2D"],
        ["\x4F\x2D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xAD"],

        ["\xCF\xAE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\x2E"],
        ["\x4F\x2E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xAE"],

        ["\xCF\xAF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\x2F"],
        ["\x4F\x2F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xAF"],

        ["\xCF\xB0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\x30"],
        ["\x4F\x30",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xB0"],

        ["\xCF\xB1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\x31"],
        ["\x4F\x31",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xB1"],

        ["\xCF\xB2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\x32"],
        ["\x4F\x32",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xB2"],

        ["\xCF\xB3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\x33"],
        ["\x4F\x33",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xB3"],

        ["\xCF\xB4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\x34"],
        ["\x4F\x34",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xB4"],

        ["\xCF\xB5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\x35"],
        ["\x4F\x35",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xB5"],

        ["\xCF\xB6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x46"],
        ["\x64\x46",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xB6"],

        ["\xCF\xB7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\x37"],
        ["\x4F\x37",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xB7"],

        ["\xCF\xB8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\x38"],
        ["\x4F\x38",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xB8"],

        ["\xCF\xB9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\x39"],
        ["\x4F\x39",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xB9"],

        ["\xCF\xBA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\x3A"],
        ["\x4F\x3A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xBA"],

        ["\xCF\xBB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\x3B"],
        ["\x4F\x3B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xBB"],

        ["\xCF\xBC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\x3C"],
        ["\x4F\x3C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xBC"],

        ["\xCF\xBD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\x3D"],
        ["\x4F\x3D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xBD"],

        ["\xCF\xBE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\x3E"],
        ["\x4F\x3E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xBE"],

        ["\xCF\xBF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\x3F"],
        ["\x4F\x3F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xBF"],

        ["\xCF\xC0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\x40"],
        ["\x4F\x40",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xC0"],

        ["\xCF\xC1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\x41"],
        ["\x4F\x41",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xC1"],

        ["\xCF\xC2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\x42"],
        ["\x4F\x42",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xC2"],

        ["\xCF\xC3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\x43"],
        ["\x4F\x43",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xC3"],

        ["\xCF\xC4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\x44"],
        ["\x4F\x44",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xC4"],

        ["\xCF\xC5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\x45"],
        ["\x4F\x45",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xC5"],

        ["\xCF\xC6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\x46"],
        ["\x4F\x46",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xC6"],

        ["\xCF\xC7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\x47"],
        ["\x4F\x47",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xC7"],

        ["\xCF\xC8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\x48"],
        ["\x4F\x48",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xC8"],

        ["\xCF\xC9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\x49"],
        ["\x4F\x49",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xC9"],

        ["\xCF\xCA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\x4A"],
        ["\x4F\x4A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xCA"],

        ["\xCF\xCB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\x4B"],
        ["\x4F\x4B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xCB"],

        ["\xCF\xCC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\x4C"],
        ["\x4F\x4C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xCC"],

        ["\xCF\xCD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\x4D"],
        ["\x4F\x4D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xCD"],

        ["\xCF\xCE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\x4E"],
        ["\x4F\x4E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xCE"],

        ["\xCF\xCF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\x4F"],
        ["\x4F\x4F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xCF"],

        ["\xCF\xD0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\x50"],
        ["\x4F\x50",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xD0"],

        ["\xCF\xD1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\x51"],
        ["\x4F\x51",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xD1"],

        ["\xCF\xD2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\x52"],
        ["\x4F\x52",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xD2"],

        ["\xCF\xD3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\x53"],
        ["\x4F\x53",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xCF\xD3"],

        ["\xD0\xA1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x21"],
        ["\x50\x21",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xA1"],

        ["\xD0\xA2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x22"],
        ["\x50\x22",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xA2"],

        ["\xD0\xA3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x23"],
        ["\x50\x23",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xA3"],

        ["\xD0\xA4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x24"],
        ["\x50\x24",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xA4"],

        ["\xD0\xA5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x25"],
        ["\x50\x25",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xA5"],

        ["\xD0\xA6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x26"],
        ["\x50\x26",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xA6"],

        ["\xD0\xA7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x27"],
        ["\x50\x27",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xA7"],

        ["\xD0\xA8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x28"],
        ["\x50\x28",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xA8"],

        ["\xD0\xA9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x29"],
        ["\x50\x29",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xA9"],

        ["\xD0\xAA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x2A"],
        ["\x50\x2A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xAA"],

        ["\xD0\xAB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x2B"],
        ["\x50\x2B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xAB"],

        ["\xD0\xAC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x2C"],
        ["\x50\x2C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xAC"],

        ["\xD0\xAD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x2D"],
        ["\x50\x2D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xAD"],

        ["\xD0\xAE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x2E"],
        ["\x50\x2E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xAE"],

        ["\xD0\xAF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x2F"],
        ["\x50\x2F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xAF"],

        ["\xD0\xB0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x30"],
        ["\x50\x30",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xB0"],

        ["\xD0\xB1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x31"],
        ["\x50\x31",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xB1"],

        ["\xD0\xB2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x32"],
        ["\x50\x32",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xB2"],

        ["\xD0\xB3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x33"],
        ["\x50\x33",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xB3"],

        ["\xD0\xB4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x34"],
        ["\x50\x34",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xB4"],

        ["\xD0\xB5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x35"],
        ["\x50\x35",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xB5"],

        ["\xD0\xB6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x36"],
        ["\x50\x36",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xB6"],

        ["\xD0\xB7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x37"],
        ["\x50\x37",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xB7"],

        ["\xD0\xB8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x38"],
        ["\x50\x38",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xB8"],

        ["\xD0\xB9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x39"],
        ["\x50\x39",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xB9"],

        ["\xD0\xBA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x3A"],
        ["\x50\x3A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xBA"],

        ["\xD0\xBB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x3B"],
        ["\x50\x3B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xBB"],

        ["\xD0\xBC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x3C"],
        ["\x50\x3C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xBC"],

        ["\xD0\xBD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x3D"],
        ["\x50\x3D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xBD"],

        ["\xD0\xBE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x3E"],
        ["\x50\x3E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xBE"],

        ["\xD0\xBF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x3F"],
        ["\x50\x3F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xBF"],

        ["\xD0\xC0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x40"],
        ["\x50\x40",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xC0"],

        ["\xD0\xC1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x41"],
        ["\x50\x41",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xC1"],

        ["\xD0\xC2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x42"],
        ["\x50\x42",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xC2"],

        ["\xD0\xC3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x43"],
        ["\x50\x43",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xC3"],

        ["\xD0\xC4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x44"],
        ["\x50\x44",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xC4"],

        ["\xD0\xC5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x45"],
        ["\x50\x45",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xC5"],

        ["\xD0\xC6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x46"],
        ["\x50\x46",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xC6"],

        ["\xD0\xC7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x47"],
        ["\x50\x47",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xC7"],

        ["\xD0\xC8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x48"],
        ["\x50\x48",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xC8"],

        ["\xD0\xC9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x49"],
        ["\x50\x49",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xC9"],

        ["\xD0\xCA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x4A"],
        ["\x50\x4A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xCA"],

        ["\xD0\xCB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x4B"],
        ["\x50\x4B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xCB"],

        ["\xD0\xCC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x4C"],
        ["\x50\x4C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xCC"],

        ["\xD0\xCD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x4D"],
        ["\x50\x4D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xCD"],

        ["\xD0\xCE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x4E"],
        ["\x50\x4E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xCE"],

        ["\xD0\xCF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x4F"],
        ["\x50\x4F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xCF"],

        ["\xD0\xD0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x50"],
        ["\x50\x50",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xD0"],

        ["\xD0\xD1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x51"],
        ["\x50\x51",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xD1"],

        ["\xD0\xD2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x52"],
        ["\x50\x52",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xD2"],

        ["\xD0\xD3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x53"],
        ["\x50\x53",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xD3"],

        ["\xD0\xD4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x54"],
        ["\x50\x54",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xD4"],

        ["\xD0\xD5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x55"],
        ["\x50\x55",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xD5"],

        ["\xD0\xD6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4B\x79"],
        ["\x4B\x79",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xD6"],

        ["\xD0\xD7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x57"],
        ["\x50\x57",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xD7"],

        ["\xD0\xD8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x58"],
        ["\x50\x58",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xD8"],

        ["\xD0\xD9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x59"],
        ["\x50\x59",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xD9"],

        ["\xD0\xDA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x5A"],
        ["\x50\x5A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xDA"],

        ["\xD0\xDB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x5B"],
        ["\x50\x5B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xDB"],

        ["\xD0\xDC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x5C"],
        ["\x50\x5C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xDC"],

        ["\xD0\xDD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x5D"],
        ["\x50\x5D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xDD"],

        ["\xD0\xDE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x5E"],
        ["\x50\x5E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xDE"],

        ["\xD0\xDF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x5F"],
        ["\x50\x5F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xDF"],

        ["\xD0\xE0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x60"],
        ["\x50\x60",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xE0"],

        ["\xD0\xE1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x61"],
        ["\x50\x61",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xE1"],

        ["\xD0\xE2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x62"],
        ["\x50\x62",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xE2"],

        ["\xD0\xE3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x63"],
        ["\x50\x63",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xE3"],

        ["\xD0\xE4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x64"],
        ["\x50\x64",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xE4"],

        ["\xD0\xE5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x65"],
        ["\x50\x65",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xE5"],

        ["\xD0\xE6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x66"],
        ["\x50\x66",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xE6"],

        ["\xD0\xE7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x67"],
        ["\x50\x67",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xE7"],

        ["\xD0\xE8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x68"],
        ["\x50\x68",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xE8"],

        ["\xD0\xE9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x69"],
        ["\x50\x69",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xE9"],

        ["\xD0\xEA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x6A"],
        ["\x50\x6A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xEA"],

        ["\xD0\xEB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x6B"],
        ["\x50\x6B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xEB"],

        ["\xD0\xEC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x6C"],
        ["\x50\x6C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xEC"],

        ["\xD0\xED",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x6D"],
        ["\x50\x6D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xED"],

        ["\xD0\xEE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x6E"],
        ["\x50\x6E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xEE"],

        ["\xD0\xEF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x6F"],
        ["\x50\x6F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xEF"],

        ["\xD0\xF0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x70"],
        ["\x50\x70",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xF0"],

        ["\xD0\xF1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x71"],
        ["\x50\x71",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xF1"],

        ["\xD0\xF2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x72"],
        ["\x50\x72",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xF2"],

        ["\xD0\xF3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x73"],
        ["\x50\x73",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xF3"],

        ["\xD0\xF4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x74"],
        ["\x50\x74",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xF4"],

        ["\xD0\xF5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x75"],
        ["\x50\x75",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xF5"],

        ["\xD0\xF6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x76"],
        ["\x50\x76",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xF6"],

        ["\xD0\xF7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x77"],
        ["\x50\x77",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xF7"],

        ["\xD0\xF8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x78"],
        ["\x50\x78",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xF8"],

        ["\xD0\xF9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x79"],
        ["\x50\x79",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xF9"],

        ["\xD0\xFA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x7A"],
        ["\x50\x7A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xFA"],

        ["\xD0\xFB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x7B"],
        ["\x50\x7B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xFB"],

        ["\xD0\xFC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x7C"],
        ["\x50\x7C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xFC"],

        ["\xD0\xFD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x7D"],
        ["\x50\x7D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xFD"],

        ["\xD0\xFE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x50\x7E"],
        ["\x50\x7E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD0\xFE"],

        ["\xD1\xA1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\x21"],
        ["\x51\x21",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xA1"],

        ["\xD1\xA2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\x22"],
        ["\x51\x22",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xA2"],

        ["\xD1\xA3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\x23"],
        ["\x51\x23",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xA3"],

        ["\xD1\xA4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\x24"],
        ["\x51\x24",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xA4"],

        ["\xD1\xA5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\x25"],
        ["\x51\x25",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xA5"],

        ["\xD1\xA6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\x26"],
        ["\x51\x26",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xA6"],

        ["\xD1\xA7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\x27"],
        ["\x51\x27",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xA7"],

        ["\xD1\xA8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\x28"],
        ["\x51\x28",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xA8"],

        ["\xD1\xA9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\x29"],
        ["\x51\x29",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xA9"],

        ["\xD1\xAA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\x2A"],
        ["\x51\x2A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xAA"],

        ["\xD1\xAB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\x2B"],
        ["\x51\x2B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xAB"],

        ["\xD1\xAC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\x2C"],
        ["\x51\x2C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xAC"],

        ["\xD1\xAD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\x2D"],
        ["\x51\x2D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xAD"],

        ["\xD1\xAE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\x2E"],
        ["\x51\x2E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xAE"],

        ["\xD1\xAF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\x2F"],
        ["\x51\x2F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xAF"],

        ["\xD1\xB0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\x30"],
        ["\x51\x30",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xB0"],

        ["\xD1\xB1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\x31"],
        ["\x51\x31",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xB1"],

        ["\xD1\xB2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\x32"],
        ["\x51\x32",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xB2"],

        ["\xD1\xB3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\x33"],
        ["\x51\x33",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xB3"],

        ["\xD1\xB4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\x34"],
        ["\x51\x34",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xB4"],

        ["\xD1\xB5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\x35"],
        ["\x51\x35",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xB5"],

        ["\xD1\xB6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\x36"],
        ["\x51\x36",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xB6"],

        ["\xD1\xB7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\x37"],
        ["\x51\x37",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xB7"],

        ["\xD1\xB8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\x38"],
        ["\x51\x38",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xB8"],

        ["\xD1\xB9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\x39"],
        ["\x51\x39",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xB9"],

        ["\xD1\xBA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\x3A"],
        ["\x51\x3A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xBA"],

        ["\xD1\xBB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\x3B"],
        ["\x51\x3B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xBB"],

        ["\xD1\xBC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\x3C"],
        ["\x51\x3C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xBC"],

        ["\xD1\xBD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\x3D"],
        ["\x51\x3D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xBD"],

        ["\xD1\xBE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\x3E"],
        ["\x51\x3E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xBE"],

        ["\xD1\xBF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\x3F"],
        ["\x51\x3F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xBF"],

        ["\xD1\xC0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\x40"],
        ["\x51\x40",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xC0"],

        ["\xD1\xC1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\x41"],
        ["\x51\x41",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xC1"],

        ["\xD1\xC2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\x42"],
        ["\x51\x42",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xC2"],

        ["\xD1\xC3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\x43"],
        ["\x51\x43",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xC3"],

        ["\xD1\xC4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\x44"],
        ["\x51\x44",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xC4"],

        ["\xD1\xC5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\x45"],
        ["\x51\x45",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xC5"],

        ["\xD1\xC6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\x46"],
        ["\x51\x46",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xC6"],

        ["\xD1\xC7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\x47"],
        ["\x51\x47",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xC7"],

        ["\xD1\xC8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\x48"],
        ["\x51\x48",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xC8"],

        ["\xD1\xC9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\x49"],
        ["\x51\x49",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xC9"],

        ["\xD1\xCA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\x4A"],
        ["\x51\x4A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xCA"],

        ["\xD1\xCB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\x4B"],
        ["\x51\x4B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xCB"],

        ["\xD1\xCC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\x4C"],
        ["\x51\x4C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xCC"],

        ["\xD1\xCD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\x4D"],
        ["\x51\x4D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xCD"],

        ["\xD1\xCE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\x4E"],
        ["\x51\x4E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xCE"],

        ["\xD1\xCF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\x4F"],
        ["\x51\x4F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xCF"],

        ["\xD1\xD0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\x50"],
        ["\x51\x50",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xD0"],

        ["\xD1\xD1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\x51"],
        ["\x51\x51",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xD1"],

        ["\xD1\xD2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\x52"],
        ["\x51\x52",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xD2"],

        ["\xD1\xD3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\x53"],
        ["\x51\x53",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xD3"],

        ["\xD1\xD4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\x54"],
        ["\x51\x54",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xD4"],

        ["\xD1\xD5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\x55"],
        ["\x51\x55",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xD5"],

        ["\xD1\xD6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\x56"],
        ["\x51\x56",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xD6"],

        ["\xD1\xD7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\x57"],
        ["\x51\x57",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xD7"],

        ["\xD1\xD8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\x58"],
        ["\x51\x58",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xD8"],

        ["\xD1\xD9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\x59"],
        ["\x51\x59",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xD9"],

        ["\xD1\xDA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\x5A"],
        ["\x51\x5A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xDA"],

        ["\xD1\xDB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\x5B"],
        ["\x51\x5B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xDB"],

        ["\xD1\xDC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\x5C"],
        ["\x51\x5C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xDC"],

        ["\xD1\xDD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\x5D"],
        ["\x51\x5D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xDD"],

        ["\xD1\xDE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\x5E"],
        ["\x51\x5E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xDE"],

        ["\xD1\xDF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\x5F"],
        ["\x51\x5F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xDF"],

        ["\xD1\xE0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\x60"],
        ["\x51\x60",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xE0"],

        ["\xD1\xE1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\x61"],
        ["\x51\x61",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xE1"],

        ["\xD1\xE2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\x62"],
        ["\x51\x62",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xE2"],

        ["\xD1\xE3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\x63"],
        ["\x51\x63",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xE3"],

        ["\xD1\xE4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\x64"],
        ["\x51\x64",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xE4"],

        ["\xD1\xE5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\x65"],
        ["\x51\x65",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xE5"],

        ["\xD1\xE6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\x66"],
        ["\x51\x66",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xE6"],

        ["\xD1\xE7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\x67"],
        ["\x51\x67",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xE7"],

        ["\xD1\xE8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\x68"],
        ["\x51\x68",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xE8"],

        ["\xD1\xE9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\x69"],
        ["\x51\x69",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xE9"],

        ["\xD1\xEA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\x6A"],
        ["\x51\x6A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xEA"],

        ["\xD1\xEB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\x6B"],
        ["\x51\x6B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xEB"],

        ["\xD1\xEC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\x6C"],
        ["\x51\x6C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xEC"],

        ["\xD1\xED",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\x6D"],
        ["\x51\x6D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xED"],

        ["\xD1\xEE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\x6E"],
        ["\x51\x6E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xEE"],

        ["\xD1\xEF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\x6F"],
        ["\x51\x6F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xEF"],

        ["\xD1\xF0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\x70"],
        ["\x51\x70",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xF0"],

        ["\xD1\xF1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\x71"],
        ["\x51\x71",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xF1"],

        ["\xD1\xF2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\x72"],
        ["\x51\x72",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xF2"],

        ["\xD1\xF3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\x73"],
        ["\x51\x73",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xF3"],

        ["\xD1\xF4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\x74"],
        ["\x51\x74",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xF4"],

        ["\xD1\xF5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\x75"],
        ["\x51\x75",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xF5"],

        ["\xD1\xF6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\x76"],
        ["\x51\x76",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xF6"],

        ["\xD1\xF7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\x77"],
        ["\x51\x77",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xF7"],

        ["\xD1\xF8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\x78"],
        ["\x51\x78",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xF8"],

        ["\xD1\xF9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\x79"],
        ["\x51\x79",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xF9"],

        ["\xD1\xFA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\x7A"],
        ["\x51\x7A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xFA"],

        ["\xD1\xFB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\x7B"],
        ["\x51\x7B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xFB"],

        ["\xD1\xFC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\x7C"],
        ["\x51\x7C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xFC"],

        ["\xD1\xFD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\x7D"],
        ["\x51\x7D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xFD"],

        ["\xD1\xFE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x51\x7E"],
        ["\x51\x7E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xFE"],

        ["\xD2\xA1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x52\x21"],
        ["\x52\x21",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xA1"],

        ["\xD2\xA2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x52\x22"],
        ["\x52\x22",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xA2"],

        ["\xD2\xA3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x52\x23"],
        ["\x52\x23",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xA3"],

        ["\xD2\xA4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x52\x24"],
        ["\x52\x24",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xA4"],

        ["\xD2\xA5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x52\x25"],
        ["\x52\x25",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xA5"],

        ["\xD2\xA6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x52\x26"],
        ["\x52\x26",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xA6"],

        ["\xD2\xA7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x52\x27"],
        ["\x52\x27",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xA7"],

        ["\xD2\xA8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x52\x28"],
        ["\x52\x28",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xA8"],

        ["\xD2\xA9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x52\x29"],
        ["\x52\x29",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xA9"],

        ["\xD2\xAA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x52\x2A"],
        ["\x52\x2A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xAA"],

        ["\xD2\xAB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x52\x2B"],
        ["\x52\x2B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xAB"],

        ["\xD2\xAC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x52\x2C"],
        ["\x52\x2C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xAC"],

        ["\xD2\xAD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x52\x2D"],
        ["\x52\x2D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xAD"],

        ["\xD2\xAE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x52\x2E"],
        ["\x52\x2E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xAE"],

        ["\xD2\xAF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x52\x2F"],
        ["\x52\x2F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xAF"],

        ["\xD2\xB0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x52\x30"],
        ["\x52\x30",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xB0"],

        ["\xD2\xB1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x52\x31"],
        ["\x52\x31",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xB1"],

        ["\xD2\xB2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x52\x32"],
        ["\x52\x32",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xB2"],

        ["\xD2\xB3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x52\x33"],
        ["\x52\x33",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xB3"],

        ["\xD2\xB4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x52\x34"],
        ["\x52\x34",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xB4"],

        ["\xD2\xB5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x52\x35"],
        ["\x52\x35",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xB5"],

        ["\xD2\xB6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x52\x36"],
        ["\x52\x36",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xB6"],

        ["\xD2\xB7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x52\x37"],
        ["\x52\x37",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xB7"],

        ["\xD2\xB8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x52\x38"],
        ["\x52\x38",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xB8"],

        ["\xD2\xB9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x52\x39"],
        ["\x52\x39",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xB9"],

        ["\xD2\xBA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x52\x3A"],
        ["\x52\x3A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xBA"],

        ["\xD2\xBB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x52\x3B"],
        ["\x52\x3B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xBB"],

        ["\xD2\xBC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x52\x3C"],
        ["\x52\x3C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xBC"],

        ["\xD2\xBD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x52\x3D"],
        ["\x52\x3D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xBD"],

        ["\xD2\xBE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x52\x3E"],
        ["\x52\x3E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xBE"],

        ["\xD2\xBF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x52\x3F"],
        ["\x52\x3F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xBF"],

        ["\xD2\xC0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x52\x40"],
        ["\x52\x40",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xC0"],

        ["\xD2\xC1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x52\x41"],
        ["\x52\x41",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xC1"],

        ["\xD2\xC2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x52\x42"],
        ["\x52\x42",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xC2"],

        ["\xD2\xC3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x52\x43"],
        ["\x52\x43",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xC3"],

        ["\xD2\xC4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x52\x44"],
        ["\x52\x44",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xC4"],

        ["\xD2\xC5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x52\x45"],
        ["\x52\x45",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xC5"],

        ["\xD2\xC6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x52\x46"],
        ["\x52\x46",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xC6"],

        ["\xD2\xC7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x52\x47"],
        ["\x52\x47",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xC7"],

        ["\xD2\xC8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x52\x48"],
        ["\x52\x48",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xC8"],

        ["\xD2\xC9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x52\x49"],
        ["\x52\x49",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xC9"],

        ["\xD2\xCA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x52\x4A"],
        ["\x52\x4A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xCA"],

        ["\xD2\xCB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x52\x4B"],
        ["\x52\x4B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xCB"],

        ["\xD2\xCC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x52\x4C"],
        ["\x52\x4C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xCC"],

        ["\xD2\xCD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x52\x4D"],
        ["\x52\x4D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xCD"],

        ["\xD2\xCE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x52\x4E"],
        ["\x52\x4E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xCE"],

        ["\xD2\xCF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x52\x4F"],
        ["\x52\x4F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xCF"],

        ["\xD2\xD0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x52\x50"],
        ["\x52\x50",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xD0"],

        ["\xD2\xD1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x52\x51"],
        ["\x52\x51",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xD1"],

        ["\xD2\xD2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x52\x52"],
        ["\x52\x52",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xD2"],

        ["\xD2\xD3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x52\x53"],
        ["\x52\x53",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xD3"],

        ["\xD2\xD4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x52\x54"],
        ["\x52\x54",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xD4"],

        ["\xD2\xD5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x52\x55"],
        ["\x52\x55",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xD5"],

        ["\xD2\xD6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x52\x56"],
        ["\x52\x56",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xD6"],

        ["\xD2\xD7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x52\x57"],
        ["\x52\x57",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xD7"],

        ["\xD2\xD8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x52\x58"],
        ["\x52\x58",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xD8"],

        ["\xD2\xD9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x52\x59"],
        ["\x52\x59",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xD9"],

        ["\xD2\xDA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x52\x5A"],
        ["\x52\x5A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xDA"],

        ["\xD2\xDB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x52\x5B"],
        ["\x52\x5B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xDB"],

        ["\xD2\xDC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x52\x5C"],
        ["\x52\x5C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xDC"],

        ["\xD2\xDD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x52\x5D"],
        ["\x52\x5D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xDD"],

        ["\xD2\xDE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x52\x5E"],
        ["\x52\x5E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xDE"],

        ["\xD2\xDF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x52\x5F"],
        ["\x52\x5F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xDF"],

        ["\xD2\xE0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x52\x60"],
        ["\x52\x60",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xE0"],

        ["\xD2\xE1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x52\x61"],
        ["\x52\x61",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xE1"],

        ["\xD2\xE2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x52\x62"],
        ["\x52\x62",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xE2"],

        ["\xD2\xE3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x52\x63"],
        ["\x52\x63",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xE3"],

        ["\xD2\xE4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x52\x64"],
        ["\x52\x64",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xE4"],

        ["\xD2\xE5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x52\x65"],
        ["\x52\x65",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xE5"],

        ["\xD2\xE6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x52\x66"],
        ["\x52\x66",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xE6"],

        ["\xD2\xE7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x52\x67"],
        ["\x52\x67",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xE7"],

        ["\xD2\xE8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x52\x68"],
        ["\x52\x68",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xE8"],

        ["\xD2\xE9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x52\x69"],
        ["\x52\x69",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xE9"],

        ["\xD2\xEA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x52\x6A"],
        ["\x52\x6A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xEA"],

        ["\xD2\xEB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x52\x6B"],
        ["\x52\x6B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xEB"],

        ["\xD2\xEC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x52\x6C"],
        ["\x52\x6C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xEC"],

        ["\xD2\xED",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x52\x6D"],
        ["\x52\x6D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xED"],

        ["\xD2\xEE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x52\x6E"],
        ["\x52\x6E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xEE"],

        ["\xD2\xEF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x52\x6F"],
        ["\x52\x6F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xEF"],

        ["\xD2\xF0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x52\x70"],
        ["\x52\x70",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xF0"],

        ["\xD2\xF1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x52\x71"],
        ["\x52\x71",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xF1"],

        ["\xD2\xF2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x52\x72"],
        ["\x52\x72",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xF2"],

        ["\xD2\xF3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x52\x73"],
        ["\x52\x73",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xF3"],

        ["\xD2\xF4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x52\x74"],
        ["\x52\x74",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xF4"],

        ["\xD2\xF5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x52\x75"],
        ["\x52\x75",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xF5"],

        ["\xD2\xF6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x52\x76"],
        ["\x52\x76",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xF6"],

        ["\xD2\xF7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x52\x77"],
        ["\x52\x77",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xF7"],

        ["\xD2\xF8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x52\x78"],
        ["\x52\x78",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xF8"],

        ["\xD2\xF9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x52\x79"],
        ["\x52\x79",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xF9"],

        ["\xD2\xFA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x52\x7A"],
        ["\x52\x7A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xFA"],

        ["\xD2\xFB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x52\x7B"],
        ["\x52\x7B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xFB"],

        ["\xD2\xFC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x52\x7C"],
        ["\x52\x7C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xFC"],

        ["\xD2\xFD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x52\x7D"],
        ["\x52\x7D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xFD"],

        ["\xD2\xFE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x52\x7E"],
        ["\x52\x7E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xFE"],

        ["\xD3\xA1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x53\x21"],
        ["\x53\x21",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xA1"],

        ["\xD3\xA2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x53\x22"],
        ["\x53\x22",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xA2"],

        ["\xD3\xA3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x53\x23"],
        ["\x53\x23",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xA3"],

        ["\xD3\xA4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x53\x24"],
        ["\x53\x24",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xA4"],

        ["\xD3\xA5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x53\x25"],
        ["\x53\x25",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xA5"],

        ["\xD3\xA6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x53\x26"],
        ["\x53\x26",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xA6"],

        ["\xD3\xA7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x53\x27"],
        ["\x53\x27",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xA7"],

        ["\xD3\xA8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x53\x28"],
        ["\x53\x28",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xA8"],

        ["\xD3\xA9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x53\x29"],
        ["\x53\x29",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xA9"],

        ["\xD3\xAA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x53\x2A"],
        ["\x53\x2A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xAA"],

        ["\xD3\xAB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x53\x2B"],
        ["\x53\x2B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xAB"],

        ["\xD3\xAC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x53\x2C"],
        ["\x53\x2C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xAC"],

        ["\xD3\xAD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x53\x2D"],
        ["\x53\x2D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xAD"],

        ["\xD3\xAE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x53\x2E"],
        ["\x53\x2E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xAE"],

        ["\xD3\xAF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x53\x2F"],
        ["\x53\x2F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xAF"],

        ["\xD3\xB0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x53\x30"],
        ["\x53\x30",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xB0"],

        ["\xD3\xB1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x53\x31"],
        ["\x53\x31",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xB1"],

        ["\xD3\xB2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x53\x32"],
        ["\x53\x32",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xB2"],

        ["\xD3\xB3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x53\x33"],
        ["\x53\x33",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xB3"],

        ["\xD3\xB4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x53\x34"],
        ["\x53\x34",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xB4"],

        ["\xD3\xB5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x53\x35"],
        ["\x53\x35",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xB5"],

        ["\xD3\xB6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x53\x36"],
        ["\x53\x36",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xB6"],

        ["\xD3\xB7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x53\x37"],
        ["\x53\x37",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xB7"],

        ["\xD3\xB8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x53\x38"],
        ["\x53\x38",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xB8"],

        ["\xD3\xB9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x53\x39"],
        ["\x53\x39",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xB9"],

        ["\xD3\xBA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x53\x3A"],
        ["\x53\x3A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xBA"],

        ["\xD3\xBB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x53\x3B"],
        ["\x53\x3B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xBB"],

        ["\xD3\xBC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x53\x3C"],
        ["\x53\x3C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xBC"],

        ["\xD3\xBD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x53\x3D"],
        ["\x53\x3D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xBD"],

        ["\xD3\xBE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x53\x3E"],
        ["\x53\x3E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xBE"],

        ["\xD3\xBF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x53\x3F"],
        ["\x53\x3F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xBF"],

        ["\xD3\xC0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x53\x40"],
        ["\x53\x40",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xC0"],

        ["\xD3\xC1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x53\x41"],
        ["\x53\x41",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xC1"],

        ["\xD3\xC2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x53\x42"],
        ["\x53\x42",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xC2"],

        ["\xD3\xC3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x53\x43"],
        ["\x53\x43",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xC3"],

        ["\xD3\xC4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x53\x44"],
        ["\x53\x44",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xC4"],

        ["\xD3\xC5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x53\x45"],
        ["\x53\x45",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xC5"],

        ["\xD3\xC6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x53\x46"],
        ["\x53\x46",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xC6"],

        ["\xD3\xC7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x53\x47"],
        ["\x53\x47",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xC7"],

        ["\xD3\xC8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x53\x48"],
        ["\x53\x48",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xC8"],

        ["\xD3\xC9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x53\x49"],
        ["\x53\x49",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xC9"],

        ["\xD3\xCA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x53\x4A"],
        ["\x53\x4A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xCA"],

        ["\xD3\xCB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x53\x4B"],
        ["\x53\x4B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xCB"],

        ["\xD3\xCC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x53\x4C"],
        ["\x53\x4C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xCC"],

        ["\xD3\xCD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x53\x4D"],
        ["\x53\x4D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xCD"],

        ["\xD3\xCE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x53\x4E"],
        ["\x53\x4E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xCE"],

        ["\xD3\xCF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x53\x4F"],
        ["\x53\x4F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xCF"],

        ["\xD3\xD0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x53\x50"],
        ["\x53\x50",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xD0"],

        ["\xD3\xD1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x53\x51"],
        ["\x53\x51",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xD1"],

        ["\xD3\xD2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x53\x52"],
        ["\x53\x52",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xD2"],

        ["\xD3\xD3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x53\x53"],
        ["\x53\x53",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xD3"],

        ["\xD3\xD4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x53\x54"],
        ["\x53\x54",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xD4"],

        ["\xD3\xD5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x53\x55"],
        ["\x53\x55",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xD5"],

        ["\xD3\xD6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x53\x56"],
        ["\x53\x56",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xD6"],

        ["\xD3\xD7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x53\x57"],
        ["\x53\x57",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xD7"],

        ["\xD3\xD8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x53\x58"],
        ["\x53\x58",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xD8"],

        ["\xD3\xD9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x53\x59"],
        ["\x53\x59",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xD9"],

        ["\xD3\xDA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x53\x5A"],
        ["\x53\x5A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xDA"],

        ["\xD3\xDB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x53\x5B"],
        ["\x53\x5B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xDB"],

        ["\xD3\xDC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x53\x5C"],
        ["\x53\x5C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xDC"],

        ["\xD3\xDD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x53\x5D"],
        ["\x53\x5D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xDD"],

        ["\xD3\xDE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x53\x5E"],
        ["\x53\x5E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xDE"],

        ["\xD3\xDF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x53\x5F"],
        ["\x53\x5F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xDF"],

        ["\xD3\xE0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x53\x60"],
        ["\x53\x60",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xE0"],

        ["\xD3\xE1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x53\x61"],
        ["\x53\x61",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xE1"],

        ["\xD3\xE2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x53\x62"],
        ["\x53\x62",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xE2"],

        ["\xD3\xE3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x53\x63"],
        ["\x53\x63",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xE3"],

        ["\xD3\xE4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x53\x64"],
        ["\x53\x64",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xE4"],

        ["\xD3\xE5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x53\x65"],
        ["\x53\x65",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xE5"],

        ["\xD3\xE6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x53\x66"],
        ["\x53\x66",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xE6"],

        ["\xD3\xE7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x53\x67"],
        ["\x53\x67",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xE7"],

        ["\xD3\xE8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x53\x68"],
        ["\x53\x68",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xE8"],

        ["\xD3\xE9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x53\x69"],
        ["\x53\x69",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xE9"],

        ["\xD3\xEA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x53\x6A"],
        ["\x53\x6A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xEA"],

        ["\xD3\xEB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x53\x6B"],
        ["\x53\x6B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xEB"],

        ["\xD3\xEC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x53\x6C"],
        ["\x53\x6C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xEC"],

        ["\xD3\xED",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x53\x6D"],
        ["\x53\x6D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xED"],

        ["\xD3\xEE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x53\x6E"],
        ["\x53\x6E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xEE"],

        ["\xD3\xEF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x53\x6F"],
        ["\x53\x6F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xEF"],

        ["\xD3\xF0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x53\x70"],
        ["\x53\x70",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xF0"],

        ["\xD3\xF1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x53\x71"],
        ["\x53\x71",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xF1"],

        ["\xD3\xF2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x53\x72"],
        ["\x53\x72",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xF2"],

        ["\xD3\xF3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x53\x73"],
        ["\x53\x73",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xF3"],

        ["\xD3\xF4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x53\x74"],
        ["\x53\x74",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xF4"],

        ["\xD3\xF5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x53\x75"],
        ["\x53\x75",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xF5"],

        ["\xD3\xF6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x53\x76"],
        ["\x53\x76",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xF6"],

        ["\xD3\xF7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x53\x77"],
        ["\x53\x77",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xF7"],

        ["\xD3\xF8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x53\x78"],
        ["\x53\x78",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xF8"],

        ["\xD3\xF9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x53\x79"],
        ["\x53\x79",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xF9"],

        ["\xD3\xFA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x53\x7A"],
        ["\x53\x7A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xFA"],

        ["\xD3\xFB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x53\x7B"],
        ["\x53\x7B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xFB"],

        ["\xD3\xFC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x53\x7C"],
        ["\x53\x7C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xFC"],

        ["\xD3\xFD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x53\x7D"],
        ["\x53\x7D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xFD"],

        ["\xD3\xFE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x53\x7E"],
        ["\x53\x7E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD3\xFE"],

        ["\xD4\xA1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x54\x21"],
        ["\x54\x21",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xA1"],

        ["\xD4\xA2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x54\x22"],
        ["\x54\x22",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xA2"],

        ["\xD4\xA3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x54\x23"],
        ["\x54\x23",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xA3"],

        ["\xD4\xA4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x54\x24"],
        ["\x54\x24",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xA4"],

        ["\xD4\xA5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x54\x25"],
        ["\x54\x25",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xA5"],

        ["\xD4\xA6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x54\x26"],
        ["\x54\x26",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xA6"],

        ["\xD4\xA7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x54\x27"],
        ["\x54\x27",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xA7"],

        ["\xD4\xA8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x54\x28"],
        ["\x54\x28",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xA8"],

        ["\xD4\xA9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x54\x29"],
        ["\x54\x29",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xA9"],

        ["\xD4\xAA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x54\x2A"],
        ["\x54\x2A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xAA"],

        ["\xD4\xAB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x54\x2B"],
        ["\x54\x2B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xAB"],

        ["\xD4\xAC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x54\x2C"],
        ["\x54\x2C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xAC"],

        ["\xD4\xAD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x54\x2D"],
        ["\x54\x2D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xAD"],

        ["\xD4\xAE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x54\x2E"],
        ["\x54\x2E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xAE"],

        ["\xD4\xAF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x54\x2F"],
        ["\x54\x2F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xAF"],

        ["\xD4\xB0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x54\x30"],
        ["\x54\x30",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xB0"],

        ["\xD4\xB1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x54\x31"],
        ["\x54\x31",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xB1"],

        ["\xD4\xB2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x54\x32"],
        ["\x54\x32",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xB2"],

        ["\xD4\xB3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x54\x33"],
        ["\x54\x33",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xB3"],

        ["\xD4\xB4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x54\x34"],
        ["\x54\x34",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xB4"],

        ["\xD4\xB5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x54\x35"],
        ["\x54\x35",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xB5"],

        ["\xD4\xB6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x54\x36"],
        ["\x54\x36",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xB6"],

        ["\xD4\xB7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x54\x37"],
        ["\x54\x37",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xB7"],

        ["\xD4\xB8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x54\x38"],
        ["\x54\x38",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xB8"],

        ["\xD4\xB9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x54\x39"],
        ["\x54\x39",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xB9"],

        ["\xD4\xBA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x54\x3A"],
        ["\x54\x3A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xBA"],

        ["\xD4\xBB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x54\x3B"],
        ["\x54\x3B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xBB"],

        ["\xD4\xBC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x54\x3C"],
        ["\x54\x3C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xBC"],

        ["\xD4\xBD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x54\x3D"],
        ["\x54\x3D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xBD"],

        ["\xD4\xBE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x54\x3E"],
        ["\x54\x3E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xBE"],

        ["\xD4\xBF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x54\x3F"],
        ["\x54\x3F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xBF"],

        ["\xD4\xC0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x54\x40"],
        ["\x54\x40",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xC0"],

        ["\xD4\xC1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x54\x41"],
        ["\x54\x41",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xC1"],

        ["\xD4\xC2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x54\x42"],
        ["\x54\x42",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xC2"],

        ["\xD4\xC3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x54\x43"],
        ["\x54\x43",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xC3"],

        ["\xD4\xC4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x54\x44"],
        ["\x54\x44",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xC4"],

        ["\xD4\xC5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x54\x45"],
        ["\x54\x45",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xC5"],

        ["\xD4\xC6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x54\x46"],
        ["\x54\x46",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xC6"],

        ["\xD4\xC7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x54\x47"],
        ["\x54\x47",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xC7"],

        ["\xD4\xC8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x54\x48"],
        ["\x54\x48",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xC8"],

        ["\xD4\xC9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x54\x49"],
        ["\x54\x49",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xC9"],

        ["\xD4\xCA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x54\x4A"],
        ["\x54\x4A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xCA"],

        ["\xD4\xCB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x54\x4B"],
        ["\x54\x4B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xCB"],

        ["\xD4\xCC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x54\x4C"],
        ["\x54\x4C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xCC"],

        ["\xD4\xCD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x54\x4D"],
        ["\x54\x4D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xCD"],

        ["\xD4\xCE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x54\x4E"],
        ["\x54\x4E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xCE"],

        ["\xD4\xCF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x54\x4F"],
        ["\x54\x4F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xCF"],

        ["\xD4\xD0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x54\x50"],
        ["\x54\x50",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xD0"],

        ["\xD4\xD1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x54\x51"],
        ["\x54\x51",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xD1"],

        ["\xD4\xD2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x54\x52"],
        ["\x54\x52",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xD2"],

        ["\xD4\xD3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x54\x53"],
        ["\x54\x53",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xD3"],

        ["\xD4\xD4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x54\x54"],
        ["\x54\x54",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xD4"],

        ["\xD4\xD5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x54\x55"],
        ["\x54\x55",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xD5"],

        ["\xD4\xD6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x54\x56"],
        ["\x54\x56",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xD6"],

        ["\xD4\xD7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x54\x57"],
        ["\x54\x57",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xD7"],

        ["\xD4\xD8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x54\x58"],
        ["\x54\x58",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xD8"],

        ["\xD4\xD9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x54\x59"],
        ["\x54\x59",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xD9"],

        ["\xD4\xDA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x54\x5A"],
        ["\x54\x5A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xDA"],

        ["\xD4\xDB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x54\x5B"],
        ["\x54\x5B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xDB"],

        ["\xD4\xDC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x54\x5C"],
        ["\x54\x5C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xDC"],

        ["\xD4\xDD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x54\x5D"],
        ["\x54\x5D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xDD"],

        ["\xD4\xDE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x54\x5E"],
        ["\x54\x5E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xDE"],

        ["\xD4\xDF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x54\x5F"],
        ["\x54\x5F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xDF"],

        ["\xD4\xE0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x54\x60"],
        ["\x54\x60",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xE0"],

        ["\xD4\xE1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x54\x61"],
        ["\x54\x61",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xE1"],

        ["\xD4\xE2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x54\x62"],
        ["\x54\x62",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xE2"],

        ["\xD4\xE3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x54\x63"],
        ["\x54\x63",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xE3"],

        ["\xD4\xE4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x44\x5B"],
        ["\x44\x5B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xE4"],

        ["\xD4\xE5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x54\x65"],
        ["\x54\x65",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xE5"],

        ["\xD4\xE6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x54\x66"],
        ["\x54\x66",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xE6"],

        ["\xD4\xE7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x54\x67"],
        ["\x54\x67",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xE7"],

        ["\xD4\xE8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x54\x68"],
        ["\x54\x68",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xE8"],

        ["\xD4\xE9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x54\x69"],
        ["\x54\x69",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xE9"],

        ["\xD4\xEA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x54\x6A"],
        ["\x54\x6A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xEA"],

        ["\xD4\xEB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x54\x6B"],
        ["\x54\x6B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xEB"],

        ["\xD4\xEC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x54\x6C"],
        ["\x54\x6C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xEC"],

        ["\xD4\xED",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x54\x6D"],
        ["\x54\x6D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xED"],

        ["\xD4\xEE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x54\x6E"],
        ["\x54\x6E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xEE"],

        ["\xD4\xEF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x54\x6F"],
        ["\x54\x6F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xEF"],

        ["\xD4\xF0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x54\x70"],
        ["\x54\x70",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xF0"],

        ["\xD4\xF1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x54\x71"],
        ["\x54\x71",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xF1"],

        ["\xD4\xF2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x54\x72"],
        ["\x54\x72",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xF2"],

        ["\xD4\xF3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x54\x73"],
        ["\x54\x73",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xF3"],

        ["\xD4\xF4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x54\x74"],
        ["\x54\x74",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xF4"],

        ["\xD4\xF5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x54\x75"],
        ["\x54\x75",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xF5"],

        ["\xD4\xF6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x54\x76"],
        ["\x54\x76",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xF6"],

        ["\xD4\xF7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x54\x77"],
        ["\x54\x77",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xF7"],

        ["\xD4\xF8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x54\x78"],
        ["\x54\x78",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xF8"],

        ["\xD4\xF9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x54\x79"],
        ["\x54\x79",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xF9"],

        ["\xD4\xFA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x54\x7A"],
        ["\x54\x7A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xFA"],

        ["\xD4\xFB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x54\x7B"],
        ["\x54\x7B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xFB"],

        ["\xD4\xFC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x54\x7C"],
        ["\x54\x7C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xFC"],

        ["\xD4\xFD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x54\x7D"],
        ["\x54\x7D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xFD"],

        ["\xD4\xFE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x54\x7E"],
        ["\x54\x7E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\xFE"],

        ["\xD5\xA1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x55\x21"],
        ["\x55\x21",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xA1"],

        ["\xD5\xA2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x55\x22"],
        ["\x55\x22",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xA2"],

        ["\xD5\xA3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x55\x23"],
        ["\x55\x23",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xA3"],

        ["\xD5\xA4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x55\x24"],
        ["\x55\x24",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xA4"],

        ["\xD5\xA5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x55\x25"],
        ["\x55\x25",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xA5"],

        ["\xD5\xA6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x55\x26"],
        ["\x55\x26",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xA6"],

        ["\xD5\xA7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x55\x27"],
        ["\x55\x27",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xA7"],

        ["\xD5\xA8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x55\x28"],
        ["\x55\x28",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xA8"],

        ["\xD5\xA9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x55\x29"],
        ["\x55\x29",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xA9"],

        ["\xD5\xAA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x55\x2A"],
        ["\x55\x2A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xAA"],

        ["\xD5\xAB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x55\x2B"],
        ["\x55\x2B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xAB"],

        ["\xD5\xAC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x55\x2C"],
        ["\x55\x2C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xAC"],

        ["\xD5\xAD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x55\x2D"],
        ["\x55\x2D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xAD"],

        ["\xD5\xAE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x55\x2E"],
        ["\x55\x2E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xAE"],

        ["\xD5\xAF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x55\x2F"],
        ["\x55\x2F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xAF"],

        ["\xD5\xB0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x55\x30"],
        ["\x55\x30",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xB0"],

        ["\xD5\xB1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x55\x31"],
        ["\x55\x31",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xB1"],

        ["\xD5\xB2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x55\x32"],
        ["\x55\x32",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xB2"],

        ["\xD5\xB3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x55\x33"],
        ["\x55\x33",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xB3"],

        ["\xD5\xB4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x55\x34"],
        ["\x55\x34",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xB4"],

        ["\xD5\xB5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x55\x35"],
        ["\x55\x35",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xB5"],

        ["\xD5\xB6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x55\x36"],
        ["\x55\x36",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xB6"],

        ["\xD5\xB7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x55\x37"],
        ["\x55\x37",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xB7"],

        ["\xD5\xB8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x55\x38"],
        ["\x55\x38",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xB8"],

        ["\xD5\xB9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x55\x39"],
        ["\x55\x39",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xB9"],

        ["\xD5\xBA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x55\x3A"],
        ["\x55\x3A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xBA"],

        ["\xD5\xBB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x55\x3B"],
        ["\x55\x3B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xBB"],

        ["\xD5\xBC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x55\x3C"],
        ["\x55\x3C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xBC"],

        ["\xD5\xBD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x55\x3D"],
        ["\x55\x3D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xBD"],

        ["\xD5\xBE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x55\x3E"],
        ["\x55\x3E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xBE"],

        ["\xD5\xBF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x55\x3F"],
        ["\x55\x3F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xBF"],

        ["\xD5\xC0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x55\x40"],
        ["\x55\x40",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xC0"],

        ["\xD5\xC1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x55\x41"],
        ["\x55\x41",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xC1"],

        ["\xD5\xC2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x55\x42"],
        ["\x55\x42",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xC2"],

        ["\xD5\xC3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x55\x43"],
        ["\x55\x43",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xC3"],

        ["\xD5\xC4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x55\x44"],
        ["\x55\x44",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xC4"],

        ["\xD5\xC5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x55\x45"],
        ["\x55\x45",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xC5"],

        ["\xD5\xC6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x55\x46"],
        ["\x55\x46",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xC6"],

        ["\xD5\xC7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x55\x47"],
        ["\x55\x47",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xC7"],

        ["\xD5\xC8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x55\x48"],
        ["\x55\x48",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xC8"],

        ["\xD5\xC9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x55\x49"],
        ["\x55\x49",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xC9"],

        ["\xD5\xCA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x55\x4A"],
        ["\x55\x4A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xCA"],

        ["\xD5\xCB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x55\x4B"],
        ["\x55\x4B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xCB"],

        ["\xD5\xCC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x55\x4C"],
        ["\x55\x4C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xCC"],

        ["\xD5\xCD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x55\x4D"],
        ["\x55\x4D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xCD"],

        ["\xD5\xCE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x55\x4E"],
        ["\x55\x4E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xCE"],

        ["\xD5\xCF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x55\x4F"],
        ["\x55\x4F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xCF"],

        ["\xD5\xD0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x55\x50"],
        ["\x55\x50",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xD0"],

        ["\xD5\xD1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x55\x51"],
        ["\x55\x51",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xD1"],

        ["\xD5\xD2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x55\x52"],
        ["\x55\x52",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xD2"],

        ["\xD5\xD3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x55\x53"],
        ["\x55\x53",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xD3"],

        ["\xD5\xD4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x55\x54"],
        ["\x55\x54",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xD4"],

        ["\xD5\xD5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x55\x55"],
        ["\x55\x55",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xD5"],

        ["\xD5\xD6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x55\x56"],
        ["\x55\x56",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xD6"],

        ["\xD5\xD7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x55\x57"],
        ["\x55\x57",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xD7"],

        ["\xD5\xD8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x55\x58"],
        ["\x55\x58",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xD8"],

        ["\xD5\xD9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x55\x59"],
        ["\x55\x59",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xD9"],

        ["\xD5\xDA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x55\x5A"],
        ["\x55\x5A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xDA"],

        ["\xD5\xDB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x55\x5B"],
        ["\x55\x5B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xDB"],

        ["\xD5\xDC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x55\x5C"],
        ["\x55\x5C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xDC"],

        ["\xD5\xDD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x55\x5D"],
        ["\x55\x5D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xDD"],

        ["\xD5\xDE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x55\x5E"],
        ["\x55\x5E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xDE"],

        ["\xD5\xDF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x55\x5F"],
        ["\x55\x5F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xDF"],

        ["\xD5\xE0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x55\x60"],
        ["\x55\x60",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xE0"],

        ["\xD5\xE1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x55\x61"],
        ["\x55\x61",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xE1"],

        ["\xD5\xE2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x55\x62"],
        ["\x55\x62",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xE2"],

        ["\xD5\xE3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x55\x63"],
        ["\x55\x63",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xE3"],

        ["\xD5\xE4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x55\x64"],
        ["\x55\x64",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xE4"],

        ["\xD5\xE5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x55\x65"],
        ["\x55\x65",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xE5"],

        ["\xD5\xE6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x55\x66"],
        ["\x55\x66",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xE6"],

        ["\xD5\xE7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x55\x67"],
        ["\x55\x67",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xE7"],

        ["\xD5\xE8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x55\x68"],
        ["\x55\x68",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xE8"],

        ["\xD5\xE9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x55\x69"],
        ["\x55\x69",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xE9"],

        ["\xD5\xEA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x55\x6A"],
        ["\x55\x6A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xEA"],

        ["\xD5\xEB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x55\x6B"],
        ["\x55\x6B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xEB"],

        ["\xD5\xEC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x55\x6C"],
        ["\x55\x6C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xEC"],

        ["\xD5\xED",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x55\x6D"],
        ["\x55\x6D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xED"],

        ["\xD5\xEE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x55\x6E"],
        ["\x55\x6E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xEE"],

        ["\xD5\xEF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x55\x6F"],
        ["\x55\x6F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xEF"],

        ["\xD5\xF0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x55\x70"],
        ["\x55\x70",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xF0"],

        ["\xD5\xF1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x55\x71"],
        ["\x55\x71",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xF1"],

        ["\xD5\xF2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x55\x72"],
        ["\x55\x72",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xF2"],

        ["\xD5\xF3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x55\x73"],
        ["\x55\x73",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xF3"],

        ["\xD5\xF4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x55\x74"],
        ["\x55\x74",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xF4"],

        ["\xD5\xF5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x55\x75"],
        ["\x55\x75",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xF5"],

        ["\xD5\xF6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x55\x76"],
        ["\x55\x76",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xF6"],

        ["\xD5\xF7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x55\x77"],
        ["\x55\x77",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xF7"],

        ["\xD5\xF8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x55\x78"],
        ["\x55\x78",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xF8"],

        ["\xD5\xF9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x55\x79"],
        ["\x55\x79",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xF9"],

        ["\xD5\xFA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x55\x7A"],
        ["\x55\x7A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xFA"],

        ["\xD5\xFB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x55\x7B"],
        ["\x55\x7B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xFB"],

        ["\xD5\xFC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x55\x7C"],
        ["\x55\x7C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xFC"],

        ["\xD5\xFD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x55\x7D"],
        ["\x55\x7D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xFD"],

        ["\xD5\xFE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x55\x7E"],
        ["\x55\x7E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD5\xFE"],

        ["\xD6\xA1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x56\x21"],
        ["\x56\x21",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xA1"],

        ["\xD6\xA2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x56\x22"],
        ["\x56\x22",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xA2"],

        ["\xD6\xA3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x56\x23"],
        ["\x56\x23",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xA3"],

        ["\xD6\xA4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x56\x24"],
        ["\x56\x24",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xA4"],

        ["\xD6\xA5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x56\x25"],
        ["\x56\x25",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xA5"],

        ["\xD6\xA6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x56\x26"],
        ["\x56\x26",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xA6"],

        ["\xD6\xA7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x56\x27"],
        ["\x56\x27",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xA7"],

        ["\xD6\xA8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x56\x28"],
        ["\x56\x28",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xA8"],

        ["\xD6\xA9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x56\x29"],
        ["\x56\x29",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xA9"],

        ["\xD6\xAA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x56\x2A"],
        ["\x56\x2A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xAA"],

        ["\xD6\xAB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x56\x2B"],
        ["\x56\x2B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xAB"],

        ["\xD6\xAC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x56\x2C"],
        ["\x56\x2C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xAC"],

        ["\xD6\xAD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x56\x2D"],
        ["\x56\x2D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xAD"],

        ["\xD6\xAE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x56\x2E"],
        ["\x56\x2E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xAE"],

        ["\xD6\xAF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x56\x2F"],
        ["\x56\x2F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xAF"],

        ["\xD6\xB0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x56\x30"],
        ["\x56\x30",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xB0"],

        ["\xD6\xB1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x56\x31"],
        ["\x56\x31",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xB1"],

        ["\xD6\xB2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x56\x32"],
        ["\x56\x32",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xB2"],

        ["\xD6\xB3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x56\x33"],
        ["\x56\x33",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xB3"],

        ["\xD6\xB4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x56\x34"],
        ["\x56\x34",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xB4"],

        ["\xD6\xB5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x56\x35"],
        ["\x56\x35",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xB5"],

        ["\xD6\xB6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x56\x36"],
        ["\x56\x36",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xB6"],

        ["\xD6\xB7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x56\x37"],
        ["\x56\x37",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xB7"],

        ["\xD6\xB8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x56\x38"],
        ["\x56\x38",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xB8"],

        ["\xD6\xB9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x56\x39"],
        ["\x56\x39",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xB9"],

        ["\xD6\xBA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x56\x3A"],
        ["\x56\x3A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xBA"],

        ["\xD6\xBB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x56\x3B"],
        ["\x56\x3B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xBB"],

        ["\xD6\xBC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x56\x3C"],
        ["\x56\x3C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xBC"],

        ["\xD6\xBD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x56\x3D"],
        ["\x56\x3D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xBD"],

        ["\xD6\xBE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x56\x3E"],
        ["\x56\x3E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xBE"],

        ["\xD6\xBF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x56\x3F"],
        ["\x56\x3F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xBF"],

        ["\xD6\xC0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x56\x40"],
        ["\x56\x40",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xC0"],

        ["\xD6\xC1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x56\x41"],
        ["\x56\x41",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xC1"],

        ["\xD6\xC2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x56\x42"],
        ["\x56\x42",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xC2"],

        ["\xD6\xC3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x56\x43"],
        ["\x56\x43",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xC3"],

        ["\xD6\xC4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x56\x44"],
        ["\x56\x44",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xC4"],

        ["\xD6\xC5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x56\x45"],
        ["\x56\x45",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xC5"],

        ["\xD6\xC6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x56\x46"],
        ["\x56\x46",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xC6"],

        ["\xD6\xC7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x56\x47"],
        ["\x56\x47",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xC7"],

        ["\xD6\xC8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x56\x48"],
        ["\x56\x48",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xC8"],

        ["\xD6\xC9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x56\x49"],
        ["\x56\x49",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xC9"],

        ["\xD6\xCA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x56\x4A"],
        ["\x56\x4A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xCA"],

        ["\xD6\xCB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x56\x4B"],
        ["\x56\x4B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xCB"],

        ["\xD6\xCC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x56\x4C"],
        ["\x56\x4C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xCC"],

        ["\xD6\xCD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x56\x4D"],
        ["\x56\x4D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xCD"],

        ["\xD6\xCE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x56\x4E"],
        ["\x56\x4E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xCE"],

        ["\xD6\xCF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x56\x4F"],
        ["\x56\x4F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xCF"],

        ["\xD6\xD0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x56\x50"],
        ["\x56\x50",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xD0"],

        ["\xD6\xD1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x56\x51"],
        ["\x56\x51",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xD1"],

        ["\xD6\xD2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x56\x52"],
        ["\x56\x52",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xD2"],

        ["\xD6\xD3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x56\x53"],
        ["\x56\x53",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xD3"],

        ["\xD6\xD4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x56\x54"],
        ["\x56\x54",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xD4"],

        ["\xD6\xD5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x56\x55"],
        ["\x56\x55",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xD5"],

        ["\xD6\xD6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x56\x56"],
        ["\x56\x56",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xD6"],

        ["\xD6\xD7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x56\x57"],
        ["\x56\x57",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xD7"],

        ["\xD6\xD8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x56\x58"],
        ["\x56\x58",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xD8"],

        ["\xD6\xD9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x56\x59"],
        ["\x56\x59",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xD9"],

        ["\xD6\xDA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x56\x5A"],
        ["\x56\x5A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xDA"],

        ["\xD6\xDB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x56\x5B"],
        ["\x56\x5B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xDB"],

        ["\xD6\xDC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x56\x5C"],
        ["\x56\x5C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xDC"],

        ["\xD6\xDD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x56\x5D"],
        ["\x56\x5D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xDD"],

        ["\xD6\xDE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x56\x5E"],
        ["\x56\x5E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xDE"],

        ["\xD6\xDF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x56\x5F"],
        ["\x56\x5F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xDF"],

        ["\xD6\xE0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x56\x60"],
        ["\x56\x60",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xE0"],

        ["\xD6\xE1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x56\x61"],
        ["\x56\x61",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xE1"],

        ["\xD6\xE2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x56\x62"],
        ["\x56\x62",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xE2"],

        ["\xD6\xE3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x56\x63"],
        ["\x56\x63",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xE3"],

        ["\xD6\xE4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x56\x64"],
        ["\x56\x64",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xE4"],

        ["\xD6\xE5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x56\x65"],
        ["\x56\x65",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xE5"],

        ["\xD6\xE6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x56\x66"],
        ["\x56\x66",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xE6"],

        ["\xD6\xE7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x56\x67"],
        ["\x56\x67",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xE7"],

        ["\xD6\xE8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x56\x68"],
        ["\x56\x68",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xE8"],

        ["\xD6\xE9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x56\x69"],
        ["\x56\x69",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xE9"],

        ["\xD6\xEA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x56\x6A"],
        ["\x56\x6A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xEA"],

        ["\xD6\xEB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x56\x6B"],
        ["\x56\x6B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xEB"],

        ["\xD6\xEC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x56\x6C"],
        ["\x56\x6C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xEC"],

        ["\xD6\xED",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x56\x6D"],
        ["\x56\x6D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xED"],

        ["\xD6\xEE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x56\x6E"],
        ["\x56\x6E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xEE"],

        ["\xD6\xEF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x56\x6F"],
        ["\x56\x6F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xEF"],

        ["\xD6\xF0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x56\x70"],
        ["\x56\x70",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xF0"],

        ["\xD6\xF1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x56\x71"],
        ["\x56\x71",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xF1"],

        ["\xD6\xF2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x56\x72"],
        ["\x56\x72",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xF2"],

        ["\xD6\xF3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x56\x73"],
        ["\x56\x73",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xF3"],

        ["\xD6\xF4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x56\x74"],
        ["\x56\x74",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xF4"],

        ["\xD6\xF5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x56\x75"],
        ["\x56\x75",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xF5"],

        ["\xD6\xF6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x56\x76"],
        ["\x56\x76",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xF6"],

        ["\xD6\xF7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x56\x77"],
        ["\x56\x77",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xF7"],

        ["\xD6\xF8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x56\x78"],
        ["\x56\x78",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xF8"],

        ["\xD6\xF9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x56\x79"],
        ["\x56\x79",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xF9"],

        ["\xD6\xFA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x56\x7A"],
        ["\x56\x7A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xFA"],

        ["\xD6\xFB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x56\x7B"],
        ["\x56\x7B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xFB"],

        ["\xD6\xFC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x56\x7C"],
        ["\x56\x7C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xFC"],

        ["\xD6\xFD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x56\x7D"],
        ["\x56\x7D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xFD"],

        ["\xD6\xFE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x56\x7E"],
        ["\x56\x7E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD6\xFE"],

        ["\xD7\xA1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x21"],
        ["\x57\x21",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xA1"],

        ["\xD7\xA2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x22"],
        ["\x57\x22",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xA2"],

        ["\xD7\xA3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x23"],
        ["\x57\x23",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xA3"],

        ["\xD7\xA4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x24"],
        ["\x57\x24",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xA4"],

        ["\xD7\xA5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x25"],
        ["\x57\x25",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xA5"],

        ["\xD7\xA6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x26"],
        ["\x57\x26",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xA6"],

        ["\xD7\xA7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x27"],
        ["\x57\x27",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xA7"],

        ["\xD7\xA8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x28"],
        ["\x57\x28",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xA8"],

        ["\xD7\xA9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x29"],
        ["\x57\x29",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xA9"],

        ["\xD7\xAA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x2A"],
        ["\x57\x2A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xAA"],

        ["\xD7\xAB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x2B"],
        ["\x57\x2B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xAB"],

        ["\xD7\xAC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x2C"],
        ["\x57\x2C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xAC"],

        ["\xD7\xAD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x2D"],
        ["\x57\x2D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xAD"],

        ["\xD7\xAE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x2E"],
        ["\x57\x2E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xAE"],

        ["\xD7\xAF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x2F"],
        ["\x57\x2F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xAF"],

        ["\xD7\xB0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x30"],
        ["\x57\x30",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xB0"],

        ["\xD7\xB1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x31"],
        ["\x57\x31",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xB1"],

        ["\xD7\xB2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x32"],
        ["\x57\x32",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xB2"],

        ["\xD7\xB3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x33"],
        ["\x57\x33",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xB3"],

        ["\xD7\xB4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x34"],
        ["\x57\x34",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xB4"],

        ["\xD7\xB5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x35"],
        ["\x57\x35",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xB5"],

        ["\xD7\xB6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x36"],
        ["\x57\x36",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xB6"],

        ["\xD7\xB7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x37"],
        ["\x57\x37",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xB7"],

        ["\xD7\xB8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x38"],
        ["\x57\x38",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xB8"],

        ["\xD7\xB9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x39"],
        ["\x57\x39",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xB9"],

        ["\xD7\xBA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x3A"],
        ["\x57\x3A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xBA"],

        ["\xD7\xBC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x3C"],
        ["\x57\x3C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xBC"],

        ["\xD7\xBD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x3D"],
        ["\x57\x3D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xBD"],

        ["\xD7\xBE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x3E"],
        ["\x57\x3E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xBE"],

        ["\xD7\xBF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x3F"],
        ["\x57\x3F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xBF"],

        ["\xD7\xC0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x40"],
        ["\x57\x40",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xC0"],

        ["\xD7\xC1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x41"],
        ["\x57\x41",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xC1"],

        ["\xD7\xC2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x42"],
        ["\x57\x42",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xC2"],

        ["\xD7\xC3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x43"],
        ["\x57\x43",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xC3"],

        ["\xD7\xC4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x44"],
        ["\x57\x44",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xC4"],

        ["\xD7\xC5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x45"],
        ["\x57\x45",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xC5"],

        ["\xD7\xC6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x46"],
        ["\x57\x46",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xC6"],

        ["\xD7\xC7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x47"],
        ["\x57\x47",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xC7"],

        ["\xD7\xC8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x48"],
        ["\x57\x48",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xC8"],

        ["\xD7\xC9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x49"],
        ["\x57\x49",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xC9"],

        ["\xD7\xCA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x4A"],
        ["\x57\x4A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xCA"],

        ["\xD7\xCB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x4B"],
        ["\x57\x4B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xCB"],

        ["\xD7\xCC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x4C"],
        ["\x57\x4C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xCC"],

        ["\xD7\xCD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x4D"],
        ["\x57\x4D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xCD"],

        ["\xD7\xCE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x4E"],
        ["\x57\x4E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xCE"],

        ["\xD7\xCF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x4F"],
        ["\x57\x4F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xCF"],

        ["\xD7\xD0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x50"],
        ["\x57\x50",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xD0"],

        ["\xD7\xD1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x51"],
        ["\x57\x51",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xD1"],

        ["\xD7\xD2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x52"],
        ["\x57\x52",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xD2"],

        ["\xD7\xD3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x53"],
        ["\x57\x53",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xD3"],

        ["\xD7\xD4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x54"],
        ["\x57\x54",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xD4"],

        ["\xD7\xD5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x55"],
        ["\x57\x55",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xD5"],

        ["\xD7\xD6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x56"],
        ["\x57\x56",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xD6"],

        ["\xD7\xD7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x57"],
        ["\x57\x57",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xD7"],

        ["\xD7\xD8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x58"],
        ["\x57\x58",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xD8"],

        ["\xD7\xD9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x59"],
        ["\x57\x59",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xD9"],

        ["\xD7\xDA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x5A"],
        ["\x57\x5A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xDA"],

        ["\xD7\xDB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x5B"],
        ["\x57\x5B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xDB"],

        ["\xD7\xDC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x5C"],
        ["\x57\x5C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xDC"],

        ["\xD7\xDD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x5D"],
        ["\x57\x5D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xDD"],

        ["\xD7\xDE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x5E"],
        ["\x57\x5E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xDE"],

        ["\xD7\xDF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x5F"],
        ["\x57\x5F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xDF"],

        ["\xD7\xE0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x60"],
        ["\x57\x60",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xE0"],

        ["\xD7\xE1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x61"],
        ["\x57\x61",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xE1"],

        ["\xD7\xE2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x62"],
        ["\x57\x62",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xE2"],

        ["\xD7\xE3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x63"],
        ["\x57\x63",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xE3"],

        ["\xD7\xE4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x64"],
        ["\x57\x64",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xE4"],

        ["\xD7\xE5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x65"],
        ["\x57\x65",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xE5"],

        ["\xD7\xE6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x66"],
        ["\x57\x66",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xE6"],

        ["\xD7\xE7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x67"],
        ["\x57\x67",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xE7"],

        ["\xD7\xE8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x68"],
        ["\x57\x68",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xE8"],

        ["\xD7\xE9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x69"],
        ["\x57\x69",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xE9"],

        ["\xD7\xEA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x6A"],
        ["\x57\x6A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xEA"],

        ["\xD7\xEB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x6B"],
        ["\x57\x6B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xEB"],

        ["\xD7\xEC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x6C"],
        ["\x57\x6C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xEC"],

        ["\xD7\xED",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x6D"],
        ["\x57\x6D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xED"],

        ["\xD7\xEE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x6E"],
        ["\x57\x6E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xEE"],

        ["\xD7\xEF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x6F"],
        ["\x57\x6F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xEF"],

        ["\xD7\xF0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x70"],
        ["\x57\x70",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xF0"],

        ["\xD7\xF1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x71"],
        ["\x57\x71",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xF1"],

        ["\xD7\xF2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x72"],
        ["\x57\x72",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xF2"],

        ["\xD7\xF3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x73"],
        ["\x57\x73",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xF3"],

        ["\xD7\xF4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x74"],
        ["\x57\x74",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xF4"],

        ["\xD7\xF5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x75"],
        ["\x57\x75",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xF5"],

        ["\xD7\xF6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x76"],
        ["\x57\x76",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xF6"],

        ["\xD7\xF7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x77"],
        ["\x57\x77",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xF7"],

        ["\xD7\xF8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x78"],
        ["\x57\x78",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xF8"],

        ["\xD7\xF9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x79"],
        ["\x57\x79",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xF9"],

        ["\xD7\xFA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x7A"],
        ["\x57\x7A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xFA"],

        ["\xD7\xFB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x7B"],
        ["\x57\x7B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xFB"],

        ["\xD7\xFC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x7C"],
        ["\x57\x7C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xFC"],

        ["\xD7\xFD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x7D"],
        ["\x57\x7D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xFD"],

        ["\xD7\xFE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x57\x7E"],
        ["\x57\x7E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD7\xFE"],

        ["\xD8\xA1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x58\x21"],
        ["\x58\x21",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xA1"],

        ["\xD8\xA2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x58\x22"],
        ["\x58\x22",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xA2"],

        ["\xD8\xA3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x58\x23"],
        ["\x58\x23",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xA3"],

        ["\xD8\xA4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x58\x24"],
        ["\x58\x24",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xA4"],

        ["\xD8\xA5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x58\x25"],
        ["\x58\x25",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xA5"],

        ["\xD8\xA6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x58\x26"],
        ["\x58\x26",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xA6"],

        ["\xD8\xA7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x58\x27"],
        ["\x58\x27",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xA7"],

        ["\xD8\xA8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x58\x28"],
        ["\x58\x28",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xA8"],

        ["\xD8\xA9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x58\x29"],
        ["\x58\x29",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xA9"],

        ["\xD8\xAA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x58\x2A"],
        ["\x58\x2A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xAA"],

        ["\xD8\xAB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x58\x2B"],
        ["\x58\x2B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xAB"],

        ["\xD8\xAC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x58\x2C"],
        ["\x58\x2C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xAC"],

        ["\xD8\xAD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x58\x2D"],
        ["\x58\x2D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xAD"],

        ["\xD8\xAE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x58\x2E"],
        ["\x58\x2E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xAE"],

        ["\xD8\xAF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x58\x2F"],
        ["\x58\x2F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xAF"],

        ["\xD8\xB0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x58\x30"],
        ["\x58\x30",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xB0"],

        ["\xD8\xB1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x58\x31"],
        ["\x58\x31",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xB1"],

        ["\xD8\xB2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x58\x32"],
        ["\x58\x32",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xB2"],

        ["\xD8\xB3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x58\x33"],
        ["\x58\x33",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xB3"],

        ["\xD8\xB4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x58\x34"],
        ["\x58\x34",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xB4"],

        ["\xD8\xB5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x58\x35"],
        ["\x58\x35",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xB5"],

        ["\xD8\xB6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x58\x36"],
        ["\x58\x36",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xB6"],

        ["\xD8\xB7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x58\x37"],
        ["\x58\x37",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xB7"],

        ["\xD8\xB8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x58\x38"],
        ["\x58\x38",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xB8"],

        ["\xD8\xB9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x58\x39"],
        ["\x58\x39",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xB9"],

        ["\xD8\xBA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x58\x3A"],
        ["\x58\x3A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xBA"],

        ["\xD8\xBB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x58\x3B"],
        ["\x58\x3B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xBB"],

        ["\xD8\xBC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x58\x3C"],
        ["\x58\x3C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xBC"],

        ["\xD8\xBD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x58\x3D"],
        ["\x58\x3D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xBD"],

        ["\xD8\xBE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x58\x3E"],
        ["\x58\x3E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xBE"],

        ["\xD8\xBF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x58\x3F"],
        ["\x58\x3F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xBF"],

        ["\xD8\xC0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x58\x40"],
        ["\x58\x40",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xC0"],

        ["\xD8\xC1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x58\x41"],
        ["\x58\x41",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xC1"],

        ["\xD8\xC2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x58\x42"],
        ["\x58\x42",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xC2"],

        ["\xD8\xC3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x58\x43"],
        ["\x58\x43",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xC3"],

        ["\xD8\xC4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x58\x44"],
        ["\x58\x44",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xC4"],

        ["\xD8\xC5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x58\x45"],
        ["\x58\x45",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xC5"],

        ["\xD8\xC6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x58\x46"],
        ["\x58\x46",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xC6"],

        ["\xD8\xC7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x58\x47"],
        ["\x58\x47",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xC7"],

        ["\xD8\xC8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x58\x48"],
        ["\x58\x48",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xC8"],

        ["\xD8\xC9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x58\x49"],
        ["\x58\x49",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xC9"],

        ["\xD8\xCA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x58\x4A"],
        ["\x58\x4A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xCA"],

        ["\xD8\xCB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x58\x4B"],
        ["\x58\x4B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xCB"],

        ["\xD8\xCC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x58\x4C"],
        ["\x58\x4C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xCC"],

        ["\xD8\xCD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x58\x4D"],
        ["\x58\x4D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xCD"],

        ["\xD8\xCE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x58\x4E"],
        ["\x58\x4E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xCE"],

        ["\xD8\xCF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x58\x4F"],
        ["\x58\x4F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xCF"],

        ["\xD8\xD0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x58\x50"],
        ["\x58\x50",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xD0"],

        ["\xD8\xD1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x58\x51"],
        ["\x58\x51",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xD1"],

        ["\xD8\xD2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x58\x52"],
        ["\x58\x52",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xD2"],

        ["\xD8\xD3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x58\x53"],
        ["\x58\x53",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xD3"],

        ["\xD8\xD4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x58\x54"],
        ["\x58\x54",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xD4"],

        ["\xD8\xD5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x58\x55"],
        ["\x58\x55",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xD5"],

        ["\xD8\xD6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x58\x56"],
        ["\x58\x56",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xD6"],

        ["\xD8\xD7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x58\x57"],
        ["\x58\x57",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xD7"],

        ["\xD8\xD8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x58\x58"],
        ["\x58\x58",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xD8"],

        ["\xD8\xD9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x58\x59"],
        ["\x58\x59",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xD9"],

        ["\xD8\xDA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x58\x5A"],
        ["\x58\x5A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xDA"],

        ["\xD8\xDB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x58\x5B"],
        ["\x58\x5B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xDB"],

        ["\xD8\xDC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x58\x5C"],
        ["\x58\x5C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xDC"],

        ["\xD8\xDD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x58\x5D"],
        ["\x58\x5D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xDD"],

        ["\xD8\xDE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x58\x5E"],
        ["\x58\x5E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xDE"],

        ["\xD8\xDF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x58\x5F"],
        ["\x58\x5F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xDF"],

        ["\xD8\xE0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x58\x60"],
        ["\x58\x60",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xE0"],

        ["\xD8\xE1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x58\x61"],
        ["\x58\x61",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xE1"],

        ["\xD8\xE2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x58\x62"],
        ["\x58\x62",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xE2"],

        ["\xD8\xE3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x58\x63"],
        ["\x58\x63",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xE3"],

        ["\xD8\xE4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x58\x64"],
        ["\x58\x64",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xE4"],

        ["\xD8\xE5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x58\x65"],
        ["\x58\x65",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xE5"],

        ["\xD8\xE6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x58\x66"],
        ["\x58\x66",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xE6"],

        ["\xD8\xE7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x58\x67"],
        ["\x58\x67",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xE7"],

        ["\xD8\xE8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x58\x68"],
        ["\x58\x68",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xE8"],

        ["\xD8\xE9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x58\x69"],
        ["\x58\x69",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xE9"],

        ["\xD8\xEA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x58\x6A"],
        ["\x58\x6A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xEA"],

        ["\xD8\xEB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x58\x6B"],
        ["\x58\x6B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xEB"],

        ["\xD8\xEC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x58\x6C"],
        ["\x58\x6C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xEC"],

        ["\xD8\xED",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x58\x6D"],
        ["\x58\x6D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xED"],

        ["\xD8\xEE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x58\x6E"],
        ["\x58\x6E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xEE"],

        ["\xD8\xEF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x58\x6F"],
        ["\x58\x6F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xEF"],

        ["\xD8\xF0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x58\x70"],
        ["\x58\x70",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xF0"],

        ["\xD8\xF1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x58\x71"],
        ["\x58\x71",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xF1"],

        ["\xD8\xF2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x58\x72"],
        ["\x58\x72",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xF2"],

        ["\xD8\xF3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x58\x73"],
        ["\x58\x73",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xF3"],

        ["\xD8\xF4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x58\x74"],
        ["\x58\x74",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xF4"],

        ["\xD8\xF5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x58\x75"],
        ["\x58\x75",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xF5"],

        ["\xD8\xF6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x58\x76"],
        ["\x58\x76",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xF6"],

        ["\xD8\xF7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x58\x77"],
        ["\x58\x77",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xF7"],

        ["\xD8\xF8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x58\x78"],
        ["\x58\x78",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xF8"],

        ["\xD8\xF9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x58\x79"],
        ["\x58\x79",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xF9"],

        ["\xD8\xFA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x58\x7A"],
        ["\x58\x7A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xFA"],

        ["\xD8\xFB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x58\x7B"],
        ["\x58\x7B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xFB"],

        ["\xD8\xFC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x58\x7C"],
        ["\x58\x7C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xFC"],

        ["\xD8\xFD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x58\x7D"],
        ["\x58\x7D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xFD"],

        ["\xD8\xFE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x58\x7E"],
        ["\x58\x7E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD8\xFE"],

        ["\xD9\xA1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x21"],
        ["\x59\x21",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xA1"],

        ["\xD9\xA2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x22"],
        ["\x59\x22",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xA2"],

        ["\xD9\xA3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x23"],
        ["\x59\x23",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xA3"],

        ["\xD9\xA4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x24"],
        ["\x59\x24",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xA4"],

        ["\xD9\xA5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x25"],
        ["\x59\x25",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xA5"],

        ["\xD9\xA6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x26"],
        ["\x59\x26",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xA6"],

        ["\xD9\xA7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x27"],
        ["\x59\x27",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xA7"],

        ["\xD9\xA8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x28"],
        ["\x59\x28",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xA8"],

        ["\xD9\xA9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x29"],
        ["\x59\x29",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xA9"],

        ["\xD9\xAA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x2A"],
        ["\x59\x2A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xAA"],

        ["\xD9\xAB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x2B"],
        ["\x59\x2B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xAB"],

        ["\xD9\xAC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x2C"],
        ["\x59\x2C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xAC"],

        ["\xD9\xAD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x2D"],
        ["\x59\x2D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xAD"],

        ["\xD9\xAE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x2E"],
        ["\x59\x2E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xAE"],

        ["\xD9\xAF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x2F"],
        ["\x59\x2F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xAF"],

        ["\xD9\xB0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x30"],
        ["\x59\x30",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xB0"],

        ["\xD9\xB1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x31"],
        ["\x59\x31",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xB1"],

        ["\xD9\xB2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x32"],
        ["\x59\x32",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xB2"],

        ["\xD9\xB3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x33"],
        ["\x59\x33",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xB3"],

        ["\xD9\xB4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x34"],
        ["\x59\x34",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xB4"],

        ["\xD9\xB5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x35"],
        ["\x59\x35",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xB5"],

        ["\xD9\xB6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x36"],
        ["\x59\x36",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xB6"],

        ["\xD9\xB7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x37"],
        ["\x59\x37",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xB7"],

        ["\xD9\xB8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x38"],
        ["\x59\x38",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xB8"],

        ["\xD9\xB9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x39"],
        ["\x59\x39",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xB9"],

        ["\xD9\xBA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x3A"],
        ["\x59\x3A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xBA"],

        ["\xD9\xBB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x3B"],
        ["\x59\x3B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xBB"],

        ["\xD9\xBC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x3C"],
        ["\x59\x3C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xBC"],

        ["\xD9\xBD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x3D"],
        ["\x59\x3D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xBD"],

        ["\xD9\xBE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x3E"],
        ["\x59\x3E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xBE"],

        ["\xD9\xBF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x3F"],
        ["\x59\x3F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xBF"],

        ["\xD9\xC0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x40"],
        ["\x59\x40",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xC0"],

        ["\xD9\xC1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x41"],
        ["\x59\x41",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xC1"],

        ["\xD9\xC2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x42"],
        ["\x59\x42",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xC2"],

        ["\xD9\xC3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x43"],
        ["\x59\x43",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xC3"],

        ["\xD9\xC4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x44"],
        ["\x59\x44",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xC4"],

        ["\xD9\xC5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x45"],
        ["\x59\x45",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xC5"],

        ["\xD9\xC6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x46"],
        ["\x59\x46",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xC6"],

        ["\xD9\xC7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x47"],
        ["\x59\x47",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xC7"],

        ["\xD9\xC8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x48"],
        ["\x59\x48",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xC8"],

        ["\xD9\xC9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x49"],
        ["\x59\x49",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xC9"],

        ["\xD9\xCA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x4A"],
        ["\x59\x4A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xCA"],

        ["\xD9\xCB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x4B"],
        ["\x59\x4B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xCB"],

        ["\xD9\xCC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x4C"],
        ["\x59\x4C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xCC"],

        ["\xD9\xCD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x4D"],
        ["\x59\x4D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xCD"],

        ["\xD9\xCE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x4E"],
        ["\x59\x4E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xCE"],

        ["\xD9\xCF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x4F"],
        ["\x59\x4F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xCF"],

        ["\xD9\xD0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x50"],
        ["\x59\x50",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xD0"],

        ["\xD9\xD1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x51"],
        ["\x59\x51",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xD1"],

        ["\xD9\xD2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x52"],
        ["\x59\x52",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xD2"],

        ["\xD9\xD3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x53"],
        ["\x59\x53",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xD3"],

        ["\xD9\xD4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x54"],
        ["\x59\x54",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xD4"],

        ["\xD9\xD5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x55"],
        ["\x59\x55",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xD5"],

        ["\xD9\xD6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x56"],
        ["\x59\x56",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xD6"],

        ["\xD9\xD7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x57"],
        ["\x59\x57",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xD7"],

        ["\xD9\xD8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x58"],
        ["\x59\x58",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xD8"],

        ["\xD9\xD9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x59"],
        ["\x59\x59",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xD9"],

        ["\xD9\xDA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x5A"],
        ["\x59\x5A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xDA"],

        ["\xD9\xDB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x5B"],
        ["\x59\x5B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xDB"],

        ["\xD9\xDC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x5C"],
        ["\x59\x5C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xDC"],

        ["\xD9\xDD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x5D"],
        ["\x59\x5D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xDD"],

        ["\xD9\xDE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x5E"],
        ["\x59\x5E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xDE"],

        ["\xD9\xDF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x5F"],
        ["\x59\x5F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xDF"],

        ["\xD9\xE0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x60"],
        ["\x59\x60",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xE0"],

        ["\xD9\xE1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x61"],
        ["\x59\x61",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xE1"],

        ["\xD9\xE2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x62"],
        ["\x59\x62",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xE2"],

        ["\xD9\xE3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x63"],
        ["\x59\x63",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xE3"],

        ["\xD9\xE4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x64"],
        ["\x59\x64",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xE4"],

        ["\xD9\xE5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x65"],
        ["\x59\x65",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xE5"],

        ["\xD9\xE6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x66"],
        ["\x59\x66",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xE6"],

        ["\xD9\xE7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x67"],
        ["\x59\x67",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xE7"],

        ["\xD9\xE8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x68"],
        ["\x59\x68",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xE8"],

        ["\xD9\xE9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x69"],
        ["\x59\x69",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xE9"],

        ["\xD9\xEA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x6A"],
        ["\x59\x6A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xEA"],

        ["\xD9\xEB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x6B"],
        ["\x59\x6B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xEB"],

        ["\xD9\xEC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x6C"],
        ["\x59\x6C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xEC"],

        ["\xD9\xED",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x6D"],
        ["\x59\x6D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xED"],

        ["\xD9\xEE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x6E"],
        ["\x59\x6E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xEE"],

        ["\xD9\xEF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x6F"],
        ["\x59\x6F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xEF"],

        ["\xD9\xF0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x70"],
        ["\x59\x70",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xF0"],

        ["\xD9\xF1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x71"],
        ["\x59\x71",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xF1"],

        ["\xD9\xF2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x72"],
        ["\x59\x72",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xF2"],

        ["\xD9\xF3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x73"],
        ["\x59\x73",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xF3"],

        ["\xD9\xF4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x74"],
        ["\x59\x74",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xF4"],

        ["\xD9\xF5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x75"],
        ["\x59\x75",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xF5"],

        ["\xD9\xF6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x76"],
        ["\x59\x76",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xF6"],

        ["\xD9\xF7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x77"],
        ["\x59\x77",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xF7"],

        ["\xD9\xF8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x33\x49"],
        ["\x33\x49",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xF8"],

        ["\xD9\xF9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x79"],
        ["\x59\x79",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xF9"],

        ["\xD9\xFA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x7A"],
        ["\x59\x7A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xFA"],

        ["\xD9\xFB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x7B"],
        ["\x59\x7B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xFB"],

        ["\xD9\xFC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x7C"],
        ["\x59\x7C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xFC"],

        ["\xD9\xFD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x7D"],
        ["\x59\x7D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xFD"],

        ["\xD9\xFE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x59\x7E"],
        ["\x59\x7E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\xFE"],

        ["\xDA\xA1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x21"],
        ["\x5A\x21",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xA1"],

        ["\xDA\xA2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x22"],
        ["\x5A\x22",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xA2"],

        ["\xDA\xA3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x23"],
        ["\x5A\x23",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xA3"],

        ["\xDA\xA4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x24"],
        ["\x5A\x24",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xA4"],

        ["\xDA\xA5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x25"],
        ["\x5A\x25",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xA5"],

        ["\xDA\xA6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x26"],
        ["\x5A\x26",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xA6"],

        ["\xDA\xA7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x27"],
        ["\x5A\x27",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xA7"],

        ["\xDA\xA8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x28"],
        ["\x5A\x28",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xA8"],

        ["\xDA\xA9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x29"],
        ["\x5A\x29",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xA9"],

        ["\xDA\xAA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x2A"],
        ["\x5A\x2A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xAA"],

        ["\xDA\xAB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x2B"],
        ["\x5A\x2B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xAB"],

        ["\xDA\xAC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x2C"],
        ["\x5A\x2C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xAC"],

        ["\xDA\xAD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x2D"],
        ["\x5A\x2D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xAD"],

        ["\xDA\xAE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x2E"],
        ["\x5A\x2E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xAE"],

        ["\xDA\xAF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x2F"],
        ["\x5A\x2F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xAF"],

        ["\xDA\xB0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x30"],
        ["\x5A\x30",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xB0"],

        ["\xDA\xB1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x31"],
        ["\x5A\x31",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xB1"],

        ["\xDA\xB2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x32"],
        ["\x5A\x32",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xB2"],

        ["\xDA\xB3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x33"],
        ["\x5A\x33",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xB3"],

        ["\xDA\xB4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x34"],
        ["\x5A\x34",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xB4"],

        ["\xDA\xB5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x35"],
        ["\x5A\x35",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xB5"],

        ["\xDA\xB6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x36"],
        ["\x5A\x36",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xB6"],

        ["\xDA\xB7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x37"],
        ["\x5A\x37",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xB7"],

        ["\xDA\xB8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x38"],
        ["\x5A\x38",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xB8"],

        ["\xDA\xB9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x39"],
        ["\x5A\x39",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xB9"],

        ["\xDA\xBA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x3A"],
        ["\x5A\x3A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xBA"],

        ["\xDA\xBB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x3B"],
        ["\x5A\x3B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xBB"],

        ["\xDA\xBC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x3C"],
        ["\x5A\x3C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xBC"],

        ["\xDA\xBD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x3D"],
        ["\x5A\x3D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xBD"],

        ["\xDA\xBE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x3E"],
        ["\x5A\x3E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xBE"],

        ["\xDA\xBF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x3F"],
        ["\x5A\x3F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xBF"],

        ["\xDA\xC0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x40"],
        ["\x5A\x40",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xC0"],

        ["\xDA\xC1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x41"],
        ["\x5A\x41",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xC1"],

        ["\xDA\xC2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x42"],
        ["\x5A\x42",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xC2"],

        ["\xDA\xC3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x43"],
        ["\x5A\x43",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xC3"],

        ["\xDA\xC4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x44"],
        ["\x5A\x44",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xC4"],

        ["\xDA\xC5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x45"],
        ["\x5A\x45",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xC5"],

        ["\xDA\xC6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x46"],
        ["\x5A\x46",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xC6"],

        ["\xDA\xC7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x47"],
        ["\x5A\x47",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xC7"],

        ["\xDA\xC8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x48"],
        ["\x5A\x48",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xC8"],

        ["\xDA\xC9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x49"],
        ["\x5A\x49",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xC9"],

        ["\xDA\xCA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x4A"],
        ["\x5A\x4A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xCA"],

        ["\xDA\xCB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x4B"],
        ["\x5A\x4B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xCB"],

        ["\xDA\xCC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x4C"],
        ["\x5A\x4C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xCC"],

        ["\xDA\xCD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x4D"],
        ["\x5A\x4D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xCD"],

        ["\xDA\xCE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x4E"],
        ["\x5A\x4E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xCE"],

        ["\xDA\xCF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x4F"],
        ["\x5A\x4F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xCF"],

        ["\xDA\xD0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x50"],
        ["\x5A\x50",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xD0"],

        ["\xDA\xD1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x51"],
        ["\x5A\x51",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xD1"],

        ["\xDA\xD2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x52"],
        ["\x5A\x52",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xD2"],

        ["\xDA\xD3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x53"],
        ["\x5A\x53",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xD3"],

        ["\xDA\xD4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x54"],
        ["\x5A\x54",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xD4"],

        ["\xDA\xD5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x55"],
        ["\x5A\x55",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xD5"],

        ["\xDA\xD6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x56"],
        ["\x5A\x56",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xD6"],

        ["\xDA\xD7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x57"],
        ["\x5A\x57",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xD7"],

        ["\xDA\xD8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x58"],
        ["\x5A\x58",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xD8"],

        ["\xDA\xD9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x59"],
        ["\x5A\x59",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xD9"],

        ["\xDA\xDA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x5A"],
        ["\x5A\x5A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xDA"],

        ["\xDA\xDB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x5B"],
        ["\x5A\x5B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xDB"],

        ["\xDA\xDC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x5C"],
        ["\x5A\x5C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xDC"],

        ["\xDA\xDD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x5D"],
        ["\x5A\x5D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xDD"],

        ["\xDA\xDE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x5E"],
        ["\x5A\x5E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xDE"],

        ["\xDA\xDF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x5F"],
        ["\x5A\x5F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xDF"],

        ["\xDA\xE0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x60"],
        ["\x5A\x60",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xE0"],

        ["\xDA\xE1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x61"],
        ["\x5A\x61",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xE1"],

        ["\xDA\xE2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x62"],
        ["\x5A\x62",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xE2"],

        ["\xDA\xE3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x63"],
        ["\x5A\x63",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xE3"],

        ["\xDA\xE4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x64"],
        ["\x5A\x64",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xE4"],

        ["\xDA\xE5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x65"],
        ["\x5A\x65",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xE5"],

        ["\xDA\xE6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x66"],
        ["\x5A\x66",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xE6"],

        ["\xDA\xE7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x67"],
        ["\x5A\x67",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xE7"],

        ["\xDA\xE8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x68"],
        ["\x5A\x68",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xE8"],

        ["\xDA\xE9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x69"],
        ["\x5A\x69",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xE9"],

        ["\xDA\xEA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x6A"],
        ["\x5A\x6A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xEA"],

        ["\xDA\xEB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x6B"],
        ["\x5A\x6B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xEB"],

        ["\xDA\xEC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x6C"],
        ["\x5A\x6C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xEC"],

        ["\xDA\xED",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x6D"],
        ["\x5A\x6D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xED"],

        ["\xDA\xEE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x6E"],
        ["\x5A\x6E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xEE"],

        ["\xDA\xEF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x6F"],
        ["\x5A\x6F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xEF"],

        ["\xDA\xF0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x70"],
        ["\x5A\x70",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xF0"],

        ["\xDA\xF1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x71"],
        ["\x5A\x71",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xF1"],

        ["\xDA\xF2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x72"],
        ["\x5A\x72",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xF2"],

        ["\xDA\xF3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x73"],
        ["\x5A\x73",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xF3"],

        ["\xDA\xF4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x74"],
        ["\x5A\x74",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xF4"],

        ["\xDA\xF5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x75"],
        ["\x5A\x75",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xF5"],

        ["\xDA\xF6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x76"],
        ["\x5A\x76",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xF6"],

        ["\xDA\xF7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x77"],
        ["\x5A\x77",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xF7"],

        ["\xDA\xF8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x78"],
        ["\x5A\x78",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xF8"],

        ["\xDA\xF9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x79"],
        ["\x5A\x79",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xF9"],

        ["\xDA\xFA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x7A"],
        ["\x5A\x7A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xFA"],

        ["\xDA\xFB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x7B"],
        ["\x5A\x7B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xFB"],

        ["\xDA\xFC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x7C"],
        ["\x5A\x7C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xFC"],

        ["\xDA\xFD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x7D"],
        ["\x5A\x7D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xFD"],

        ["\xDA\xFE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5A\x7E"],
        ["\x5A\x7E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDA\xFE"],

        ["\xDB\xA1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x21"],
        ["\x5B\x21",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xA1"],

        ["\xDB\xA2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x22"],
        ["\x5B\x22",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xA2"],

        ["\xDB\xA3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x23"],
        ["\x5B\x23",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xA3"],

        ["\xDB\xA4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x24"],
        ["\x5B\x24",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xA4"],

        ["\xDB\xA5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x25"],
        ["\x5B\x25",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xA5"],

        ["\xDB\xA6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x26"],
        ["\x5B\x26",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xA6"],

        ["\xDB\xA7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x27"],
        ["\x5B\x27",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xA7"],

        ["\xDB\xA8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x28"],
        ["\x5B\x28",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xA8"],

        ["\xDB\xA9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x29"],
        ["\x5B\x29",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xA9"],

        ["\xDB\xAA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x2A"],
        ["\x5B\x2A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xAA"],

        ["\xDB\xAB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x2B"],
        ["\x5B\x2B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xAB"],

        ["\xDB\xAC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x2C"],
        ["\x5B\x2C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xAC"],

        ["\xDB\xAD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x2D"],
        ["\x5B\x2D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xAD"],

        ["\xDB\xAE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x2E"],
        ["\x5B\x2E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xAE"],

        ["\xDB\xAF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x2F"],
        ["\x5B\x2F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xAF"],

        ["\xDB\xB0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x30"],
        ["\x5B\x30",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xB0"],

        ["\xDB\xB1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x31"],
        ["\x5B\x31",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xB1"],

        ["\xDB\xB2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x32"],
        ["\x5B\x32",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xB2"],

        ["\xDB\xB3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x33"],
        ["\x5B\x33",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xB3"],

        ["\xDB\xB4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x34"],
        ["\x5B\x34",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xB4"],

        ["\xDB\xB5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x35"],
        ["\x5B\x35",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xB5"],

        ["\xDB\xB6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x36"],
        ["\x5B\x36",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xB6"],

        ["\xDB\xB7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x37"],
        ["\x5B\x37",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xB7"],

        ["\xDB\xB8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x38"],
        ["\x5B\x38",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xB8"],

        ["\xDB\xB9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x39"],
        ["\x5B\x39",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xB9"],

        ["\xDB\xBA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x3A"],
        ["\x5B\x3A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xBA"],

        ["\xDB\xBB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x3B"],
        ["\x5B\x3B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xBB"],

        ["\xDB\xBC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x3C"],
        ["\x5B\x3C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xBC"],

        ["\xDB\xBD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x3D"],
        ["\x5B\x3D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xBD"],

        ["\xDB\xBE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x3E"],
        ["\x5B\x3E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xBE"],

        ["\xDB\xBF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x3F"],
        ["\x5B\x3F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xBF"],

        ["\xDB\xC0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x40"],
        ["\x5B\x40",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xC0"],

        ["\xDB\xC1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x41"],
        ["\x5B\x41",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xC1"],

        ["\xDB\xC2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x42"],
        ["\x5B\x42",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xC2"],

        ["\xDB\xC3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x43"],
        ["\x5B\x43",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xC3"],

        ["\xDB\xC4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x44"],
        ["\x5B\x44",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xC4"],

        ["\xDB\xC5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x45"],
        ["\x5B\x45",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xC5"],

        ["\xDB\xC6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x46"],
        ["\x5B\x46",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xC6"],

        ["\xDB\xC7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x47"],
        ["\x5B\x47",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xC7"],

        ["\xDB\xC8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x48"],
        ["\x5B\x48",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xC8"],

        ["\xDB\xC9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x49"],
        ["\x5B\x49",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xC9"],

        ["\xDB\xCA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x4A"],
        ["\x5B\x4A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xCA"],

        ["\xDB\xCB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x4B"],
        ["\x5B\x4B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xCB"],

        ["\xDB\xCC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x4C"],
        ["\x5B\x4C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xCC"],

        ["\xDB\xCD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x4D"],
        ["\x5B\x4D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xCD"],

        ["\xDB\xCE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x4E"],
        ["\x5B\x4E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xCE"],

        ["\xDB\xCF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x4F"],
        ["\x5B\x4F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xCF"],

        ["\xDB\xD0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x50"],
        ["\x5B\x50",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xD0"],

        ["\xDB\xD1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x51"],
        ["\x5B\x51",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xD1"],

        ["\xDB\xD2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x52"],
        ["\x5B\x52",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xD2"],

        ["\xDB\xD3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x53"],
        ["\x5B\x53",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xD3"],

        ["\xDB\xD4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x54"],
        ["\x5B\x54",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xD4"],

        ["\xDB\xD5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x55"],
        ["\x5B\x55",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xD5"],

        ["\xDB\xD6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x56"],
        ["\x5B\x56",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xD6"],

        ["\xDB\xD7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x57"],
        ["\x5B\x57",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xD7"],

        ["\xDB\xD8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x49\x30"],
        ["\x49\x30",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xD8"],

        ["\xDB\xD9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x59"],
        ["\x5B\x59",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xD9"],

        ["\xDB\xDA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x5A"],
        ["\x5B\x5A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xDA"],

        ["\xDB\xDB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x5B"],
        ["\x5B\x5B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xDB"],

        ["\xDB\xDC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x5C"],
        ["\x5B\x5C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xDC"],

        ["\xDB\xDD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x5D"],
        ["\x5B\x5D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xDD"],

        ["\xDB\xDE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x5E"],
        ["\x5B\x5E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xDE"],

        ["\xDB\xDF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x5F"],
        ["\x5B\x5F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xDF"],

        ["\xDB\xE0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x60"],
        ["\x5B\x60",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xE0"],

        ["\xDB\xE1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x61"],
        ["\x5B\x61",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xE1"],

        ["\xDB\xE2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x62"],
        ["\x5B\x62",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xE2"],

        ["\xDB\xE3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x63"],
        ["\x5B\x63",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xE3"],

        ["\xDB\xE4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x64"],
        ["\x5B\x64",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xE4"],

        ["\xDB\xE5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x65"],
        ["\x5B\x65",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xE5"],

        ["\xDB\xE6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x66"],
        ["\x5B\x66",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xE6"],

        ["\xDB\xE7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x67"],
        ["\x5B\x67",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xE7"],

        ["\xDB\xE8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x68"],
        ["\x5B\x68",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xE8"],

        ["\xDB\xE9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x69"],
        ["\x5B\x69",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xE9"],

        ["\xDB\xEA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x6A"],
        ["\x5B\x6A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xEA"],

        ["\xDB\xEB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x6B"],
        ["\x5B\x6B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xEB"],

        ["\xDB\xEC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x6C"],
        ["\x5B\x6C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xEC"],

        ["\xDB\xED",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\x6E"],
        ["\x45\x6E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xED"],

        ["\xDB\xEE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x6E"],
        ["\x5B\x6E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xEE"],

        ["\xDB\xEF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x6F"],
        ["\x5B\x6F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xEF"],

        ["\xDB\xF0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x70"],
        ["\x5B\x70",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xF0"],

        ["\xDB\xF1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x71"],
        ["\x5B\x71",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xF1"],

        ["\xDB\xF2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x72"],
        ["\x5B\x72",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xF2"],

        ["\xDB\xF3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x73"],
        ["\x5B\x73",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xF3"],

        ["\xDB\xF4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x74"],
        ["\x5B\x74",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xF4"],

        ["\xDB\xF5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x75"],
        ["\x5B\x75",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xF5"],

        ["\xDB\xF6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x76"],
        ["\x5B\x76",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xF6"],

        ["\xDB\xF7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x77"],
        ["\x5B\x77",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xF7"],

        ["\xDB\xF8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x78"],
        ["\x5B\x78",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xF8"],

        ["\xDB\xF9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x79"],
        ["\x5B\x79",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xF9"],

        ["\xDB\xFA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x7A"],
        ["\x5B\x7A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xFA"],

        ["\xDB\xFB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x7B"],
        ["\x5B\x7B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xFB"],

        ["\xDB\xFC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x7C"],
        ["\x5B\x7C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xFC"],

        ["\xDB\xFD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x7D"],
        ["\x5B\x7D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xFD"],

        ["\xDB\xFE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5B\x7E"],
        ["\x5B\x7E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDB\xFE"],

        ["\xDC\xA1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5C\x21"],
        ["\x5C\x21",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xA1"],

        ["\xDC\xA2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5C\x22"],
        ["\x5C\x22",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xA2"],

        ["\xDC\xA3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5C\x23"],
        ["\x5C\x23",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xA3"],

        ["\xDC\xA4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5C\x24"],
        ["\x5C\x24",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xA4"],

        ["\xDC\xA5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5C\x25"],
        ["\x5C\x25",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xA5"],

        ["\xDC\xA6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5C\x26"],
        ["\x5C\x26",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xA6"],

        ["\xDC\xA7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5C\x27"],
        ["\x5C\x27",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xA7"],

        ["\xDC\xA8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5C\x28"],
        ["\x5C\x28",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xA8"],

        ["\xDC\xA9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5C\x29"],
        ["\x5C\x29",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xA9"],

        ["\xDC\xAA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5C\x2A"],
        ["\x5C\x2A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xAA"],

        ["\xDC\xAB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5C\x2B"],
        ["\x5C\x2B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xAB"],

        ["\xDC\xAC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5C\x2C"],
        ["\x5C\x2C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xAC"],

        ["\xDC\xAD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5C\x2D"],
        ["\x5C\x2D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xAD"],

        ["\xDC\xAE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5C\x2E"],
        ["\x5C\x2E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xAE"],

        ["\xDC\xAF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5C\x2F"],
        ["\x5C\x2F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xAF"],

        ["\xDC\xB0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5C\x30"],
        ["\x5C\x30",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xB0"],

        ["\xDC\xB1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5C\x31"],
        ["\x5C\x31",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xB1"],

        ["\xDC\xB2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5C\x32"],
        ["\x5C\x32",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xB2"],

        ["\xDC\xB3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5C\x33"],
        ["\x5C\x33",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xB3"],

        ["\xDC\xB4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5C\x34"],
        ["\x5C\x34",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xB4"],

        ["\xDC\xB5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5C\x35"],
        ["\x5C\x35",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xB5"],

        ["\xDC\xB6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5C\x36"],
        ["\x5C\x36",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xB6"],

        ["\xDC\xB7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5C\x37"],
        ["\x5C\x37",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xB7"],

        ["\xDC\xB8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5C\x38"],
        ["\x5C\x38",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xB8"],

        ["\xDC\xB9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5C\x39"],
        ["\x5C\x39",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xB9"],

        ["\xDC\xBA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5C\x3A"],
        ["\x5C\x3A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xBA"],

        ["\xDC\xBB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5C\x3B"],
        ["\x5C\x3B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xBB"],

        ["\xDC\xBC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5C\x3C"],
        ["\x5C\x3C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xBC"],

        ["\xDC\xBD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5C\x3D"],
        ["\x5C\x3D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xBD"],

        ["\xDC\xBE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5C\x3E"],
        ["\x5C\x3E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xBE"],

        ["\xDC\xBF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5C\x3F"],
        ["\x5C\x3F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xBF"],

        ["\xDC\xC0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5C\x40"],
        ["\x5C\x40",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xC0"],

        ["\xDC\xC1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5C\x41"],
        ["\x5C\x41",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xC1"],

        ["\xDC\xC2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5C\x42"],
        ["\x5C\x42",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xC2"],

        ["\xDC\xC3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5C\x43"],
        ["\x5C\x43",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xC3"],

        ["\xDC\xC4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5C\x44"],
        ["\x5C\x44",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xC4"],

        ["\xDC\xC5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5C\x45"],
        ["\x5C\x45",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xC5"],

        ["\xDC\xC6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5C\x46"],
        ["\x5C\x46",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xC6"],

        ["\xDC\xC7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5C\x47"],
        ["\x5C\x47",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xC7"],

        ["\xDC\xC8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5C\x48"],
        ["\x5C\x48",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xC8"],

        ["\xDC\xC9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5C\x49"],
        ["\x5C\x49",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xC9"],

        ["\xDC\xCA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5C\x4A"],
        ["\x5C\x4A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xCA"],

        ["\xDC\xCB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5C\x4B"],
        ["\x5C\x4B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xCB"],

        ["\xDC\xCC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5C\x4C"],
        ["\x5C\x4C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xCC"],

        ["\xDC\xCD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5C\x4D"],
        ["\x5C\x4D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xCD"],

        ["\xDC\xCE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5C\x4E"],
        ["\x5C\x4E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xCE"],

        ["\xDC\xCF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5C\x4F"],
        ["\x5C\x4F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xCF"],

        ["\xDC\xD0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5C\x50"],
        ["\x5C\x50",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xD0"],

        ["\xDC\xD1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5C\x51"],
        ["\x5C\x51",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xD1"],

        ["\xDC\xD2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5C\x52"],
        ["\x5C\x52",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xD2"],

        ["\xDC\xD3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5C\x53"],
        ["\x5C\x53",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xD3"],

        ["\xDC\xD4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5C\x54"],
        ["\x5C\x54",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xD4"],

        ["\xDC\xD5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5C\x55"],
        ["\x5C\x55",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xD5"],

        ["\xDC\xD6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5C\x56"],
        ["\x5C\x56",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xD6"],

        ["\xDC\xD7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5C\x57"],
        ["\x5C\x57",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xD7"],

        ["\xDC\xD8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5C\x58"],
        ["\x5C\x58",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xD8"],

        ["\xDC\xD9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5C\x59"],
        ["\x5C\x59",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xD9"],

        ["\xDC\xDA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5C\x5A"],
        ["\x5C\x5A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xDA"],

        ["\xDC\xDB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5C\x5B"],
        ["\x5C\x5B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xDB"],

        ["\xDC\xDC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5C\x5C"],
        ["\x5C\x5C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xDC"],

        ["\xDC\xDD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5C\x5D"],
        ["\x5C\x5D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xDD"],

        ["\xDC\xDE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5C\x5E"],
        ["\x5C\x5E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xDE"],

        ["\xDC\xDF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5C\x5F"],
        ["\x5C\x5F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xDF"],

        ["\xDC\xE0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5C\x60"],
        ["\x5C\x60",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xE0"],

        ["\xDC\xE1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5C\x61"],
        ["\x5C\x61",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xE1"],

        ["\xDC\xE2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5C\x62"],
        ["\x5C\x62",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xE2"],

        ["\xDC\xE3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5C\x63"],
        ["\x5C\x63",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xE3"],

        ["\xDC\xE4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5C\x64"],
        ["\x5C\x64",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xE4"],

        ["\xDC\xE5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5C\x65"],
        ["\x5C\x65",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xE5"],

        ["\xDC\xE6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5C\x66"],
        ["\x5C\x66",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xE6"],

        ["\xDC\xE7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5C\x67"],
        ["\x5C\x67",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xE7"],

        ["\xDC\xE8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5C\x68"],
        ["\x5C\x68",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xE8"],

        ["\xDC\xE9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5C\x69"],
        ["\x5C\x69",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xE9"],

        ["\xDC\xEA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5C\x6A"],
        ["\x5C\x6A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xEA"],

        ["\xDC\xEB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5C\x6B"],
        ["\x5C\x6B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xEB"],

        ["\xDC\xEC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5C\x6C"],
        ["\x5C\x6C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xEC"],

        ["\xDC\xED",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5C\x6D"],
        ["\x5C\x6D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xED"],

        ["\xDC\xEE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5C\x6E"],
        ["\x5C\x6E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xEE"],

        ["\xDC\xEF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5C\x6F"],
        ["\x5C\x6F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xEF"],

        ["\xDC\xF0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5C\x70"],
        ["\x5C\x70",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xF0"],

        ["\xDC\xF1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5C\x71"],
        ["\x5C\x71",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xF1"],

        ["\xDC\xF2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5C\x72"],
        ["\x5C\x72",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xF2"],

        ["\xDC\xF3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5C\x73"],
        ["\x5C\x73",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xF3"],

        ["\xDC\xF4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5C\x74"],
        ["\x5C\x74",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xF4"],

        ["\xDC\xF5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5C\x75"],
        ["\x5C\x75",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xF5"],

        ["\xDC\xF6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5C\x76"],
        ["\x5C\x76",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xF6"],

        ["\xDC\xF7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5C\x77"],
        ["\x5C\x77",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xF7"],

        ["\xDC\xF8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5C\x78"],
        ["\x5C\x78",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xF8"],

        ["\xDC\xF9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5C\x79"],
        ["\x5C\x79",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xF9"],

        ["\xDC\xFA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5C\x7A"],
        ["\x5C\x7A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xFA"],

        ["\xDC\xFB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5C\x7B"],
        ["\x5C\x7B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xFB"],

        ["\xDC\xFC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5C\x7C"],
        ["\x5C\x7C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xFC"],

        ["\xDC\xFD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5C\x7D"],
        ["\x5C\x7D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xFD"],

        ["\xDC\xFE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5C\x7E"],
        ["\x5C\x7E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\xFE"],

        ["\xDD\xA1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5D\x21"],
        ["\x5D\x21",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xA1"],

        ["\xDD\xA2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5D\x22"],
        ["\x5D\x22",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xA2"],

        ["\xDD\xA3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5D\x23"],
        ["\x5D\x23",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xA3"],

        ["\xDD\xA4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5D\x24"],
        ["\x5D\x24",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xA4"],

        ["\xDD\xA5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5D\x25"],
        ["\x5D\x25",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xA5"],

        ["\xDD\xA6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5D\x26"],
        ["\x5D\x26",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xA6"],

        ["\xDD\xA7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5D\x27"],
        ["\x5D\x27",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xA7"],

        ["\xDD\xA8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5D\x28"],
        ["\x5D\x28",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xA8"],

        ["\xDD\xA9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5D\x29"],
        ["\x5D\x29",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xA9"],

        ["\xDD\xAA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5D\x2A"],
        ["\x5D\x2A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xAA"],

        ["\xDD\xAB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5D\x2B"],
        ["\x5D\x2B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xAB"],

        ["\xDD\xAC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5D\x2C"],
        ["\x5D\x2C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xAC"],

        ["\xDD\xAD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5D\x2D"],
        ["\x5D\x2D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xAD"],

        ["\xDD\xAE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5D\x2E"],
        ["\x5D\x2E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xAE"],

        ["\xDD\xAF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5D\x2F"],
        ["\x5D\x2F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xAF"],

        ["\xDD\xB0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5D\x30"],
        ["\x5D\x30",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xB0"],

        ["\xDD\xB1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5D\x31"],
        ["\x5D\x31",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xB1"],

        ["\xDD\xB2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5D\x32"],
        ["\x5D\x32",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xB2"],

        ["\xDD\xB3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5D\x33"],
        ["\x5D\x33",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xB3"],

        ["\xDD\xB4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5D\x34"],
        ["\x5D\x34",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xB4"],

        ["\xDD\xB5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5D\x35"],
        ["\x5D\x35",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xB5"],

        ["\xDD\xB6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5D\x36"],
        ["\x5D\x36",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xB6"],

        ["\xDD\xB7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5D\x37"],
        ["\x5D\x37",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xB7"],

        ["\xDD\xB8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5D\x38"],
        ["\x5D\x38",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xB8"],

        ["\xDD\xB9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5D\x39"],
        ["\x5D\x39",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xB9"],

        ["\xDD\xBA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5D\x3A"],
        ["\x5D\x3A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xBA"],

        ["\xDD\xBB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5D\x3B"],
        ["\x5D\x3B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xBB"],

        ["\xDD\xBC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5D\x3C"],
        ["\x5D\x3C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xBC"],

        ["\xDD\xBD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5D\x3D"],
        ["\x5D\x3D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xBD"],

        ["\xDD\xBE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5D\x3E"],
        ["\x5D\x3E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xBE"],

        ["\xDD\xBF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5D\x3F"],
        ["\x5D\x3F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xBF"],

        ["\xDD\xC0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5D\x40"],
        ["\x5D\x40",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xC0"],

        ["\xDD\xC1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5D\x41"],
        ["\x5D\x41",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xC1"],

        ["\xDD\xC2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5D\x42"],
        ["\x5D\x42",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xC2"],

        ["\xDD\xC3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5D\x43"],
        ["\x5D\x43",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xC3"],

        ["\xDD\xC4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5D\x44"],
        ["\x5D\x44",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xC4"],

        ["\xDD\xC5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5D\x45"],
        ["\x5D\x45",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xC5"],

        ["\xDD\xC6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5D\x46"],
        ["\x5D\x46",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xC6"],

        ["\xDD\xC7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5D\x47"],
        ["\x5D\x47",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xC7"],

        ["\xDD\xC8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5D\x48"],
        ["\x5D\x48",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xC8"],

        ["\xDD\xC9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5D\x49"],
        ["\x5D\x49",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xC9"],

        ["\xDD\xCA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5D\x4A"],
        ["\x5D\x4A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xCA"],

        ["\xDD\xCB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5D\x4B"],
        ["\x5D\x4B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xCB"],

        ["\xDD\xCC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5D\x4C"],
        ["\x5D\x4C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xCC"],

        ["\xDD\xCD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5D\x4D"],
        ["\x5D\x4D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xCD"],

        ["\xDD\xCE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5D\x4E"],
        ["\x5D\x4E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xCE"],

        ["\xDD\xCF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5D\x4F"],
        ["\x5D\x4F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xCF"],

        ["\xDD\xD0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5D\x50"],
        ["\x5D\x50",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xD0"],

        ["\xDD\xD1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5D\x51"],
        ["\x5D\x51",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xD1"],

        ["\xDD\xD2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5D\x52"],
        ["\x5D\x52",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xD2"],

        ["\xDD\xD3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5D\x53"],
        ["\x5D\x53",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xD3"],

        ["\xDD\xD4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5D\x54"],
        ["\x5D\x54",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xD4"],

        ["\xDD\xD5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5D\x55"],
        ["\x5D\x55",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xD5"],

        ["\xDD\xD6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5D\x56"],
        ["\x5D\x56",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xD6"],

        ["\xDD\xD7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5D\x57"],
        ["\x5D\x57",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xD7"],

        ["\xDD\xD8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5D\x58"],
        ["\x5D\x58",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xD8"],

        ["\xDD\xD9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5D\x59"],
        ["\x5D\x59",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xD9"],

        ["\xDD\xDA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5D\x5A"],
        ["\x5D\x5A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xDA"],

        ["\xDD\xDB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5D\x5B"],
        ["\x5D\x5B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xDB"],

        ["\xDD\xDC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5D\x5C"],
        ["\x5D\x5C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xDC"],

        ["\xDD\xDD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5D\x5D"],
        ["\x5D\x5D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xDD"],

        ["\xDD\xDE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5D\x5E"],
        ["\x5D\x5E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xDE"],

        ["\xDD\xDF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5D\x5F"],
        ["\x5D\x5F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xDF"],

        ["\xDD\xE0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5D\x60"],
        ["\x5D\x60",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xE0"],

        ["\xDD\xE1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5D\x61"],
        ["\x5D\x61",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xE1"],

        ["\xDD\xE2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5D\x62"],
        ["\x5D\x62",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xE2"],

        ["\xDD\xE3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5D\x63"],
        ["\x5D\x63",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xE3"],

        ["\xDD\xE4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5D\x64"],
        ["\x5D\x64",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xE4"],

        ["\xDD\xE5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5D\x65"],
        ["\x5D\x65",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xE5"],

        ["\xDD\xE6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5D\x66"],
        ["\x5D\x66",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xE6"],

        ["\xDD\xE7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5D\x67"],
        ["\x5D\x67",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xE7"],

        ["\xDD\xE8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5D\x68"],
        ["\x5D\x68",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xE8"],

        ["\xDD\xE9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5D\x69"],
        ["\x5D\x69",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xE9"],

        ["\xDD\xEA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5D\x6A"],
        ["\x5D\x6A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xEA"],

        ["\xDD\xEB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5D\x6B"],
        ["\x5D\x6B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xEB"],

        ["\xDD\xEC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5D\x6C"],
        ["\x5D\x6C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xEC"],

        ["\xDD\xED",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5D\x6D"],
        ["\x5D\x6D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xED"],

        ["\xDD\xEE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5D\x6E"],
        ["\x5D\x6E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xEE"],

        ["\xDD\xEF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5D\x6F"],
        ["\x5D\x6F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xEF"],

        ["\xDD\xF0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5D\x70"],
        ["\x5D\x70",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xF0"],

        ["\xDD\xF1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5D\x71"],
        ["\x5D\x71",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xF1"],

        ["\xDD\xF2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5D\x72"],
        ["\x5D\x72",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xF2"],

        ["\xDD\xF3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5D\x73"],
        ["\x5D\x73",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xF3"],

        ["\xDD\xF4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5D\x74"],
        ["\x5D\x74",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xF4"],

        ["\xDD\xF5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5D\x75"],
        ["\x5D\x75",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xF5"],

        ["\xDD\xF6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5D\x76"],
        ["\x5D\x76",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xF6"],

        ["\xDD\xF7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5D\x77"],
        ["\x5D\x77",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xF7"],

        ["\xDD\xF8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5D\x78"],
        ["\x5D\x78",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xF8"],

        ["\xDD\xF9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5D\x79"],
        ["\x5D\x79",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xF9"],

        ["\xDD\xFA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5D\x7A"],
        ["\x5D\x7A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xFA"],

        ["\xDD\xFB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5D\x7B"],
        ["\x5D\x7B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xFB"],

        ["\xDD\xFC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5D\x7C"],
        ["\x5D\x7C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xFC"],

        ["\xDD\xFD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5D\x7D"],
        ["\x5D\x7D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xFD"],

        ["\xDD\xFE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5D\x7E"],
        ["\x5D\x7E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDD\xFE"],

        ["\xDE\xA1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x21"],
        ["\x5E\x21",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xA1"],

        ["\xDE\xA2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x22"],
        ["\x5E\x22",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xA2"],

        ["\xDE\xA3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x23"],
        ["\x5E\x23",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xA3"],

        ["\xDE\xA4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x24"],
        ["\x5E\x24",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xA4"],

        ["\xDE\xA5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x25"],
        ["\x5E\x25",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xA5"],

        ["\xDE\xA6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x26"],
        ["\x5E\x26",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xA6"],

        ["\xDE\xA7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x27"],
        ["\x5E\x27",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xA7"],

        ["\xDE\xA8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x28"],
        ["\x5E\x28",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xA8"],

        ["\xDE\xA9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x29"],
        ["\x5E\x29",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xA9"],

        ["\xDE\xAA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x2A"],
        ["\x5E\x2A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xAA"],

        ["\xDE\xAB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x2B"],
        ["\x5E\x2B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xAB"],

        ["\xDE\xAC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x2C"],
        ["\x5E\x2C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xAC"],

        ["\xDE\xAD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x2D"],
        ["\x5E\x2D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xAD"],

        ["\xDE\xAE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x2E"],
        ["\x5E\x2E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xAE"],

        ["\xDE\xAF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x2F"],
        ["\x5E\x2F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xAF"],

        ["\xDE\xB0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x30"],
        ["\x5E\x30",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xB0"],

        ["\xDE\xB1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x31"],
        ["\x5E\x31",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xB1"],

        ["\xDE\xB2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x32"],
        ["\x5E\x32",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xB2"],

        ["\xDE\xB3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x33"],
        ["\x5E\x33",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xB3"],

        ["\xDE\xB4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x34"],
        ["\x5E\x34",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xB4"],

        ["\xDE\xB5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x35"],
        ["\x5E\x35",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xB5"],

        ["\xDE\xB6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x36"],
        ["\x5E\x36",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xB6"],

        ["\xDE\xB7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x37"],
        ["\x5E\x37",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xB7"],

        ["\xDE\xB8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x38"],
        ["\x5E\x38",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xB8"],

        ["\xDE\xB9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\x73"],
        ["\x45\x73",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xB9"],

        ["\xDE\xBA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x3A"],
        ["\x5E\x3A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xBA"],

        ["\xDE\xBB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x3B"],
        ["\x5E\x3B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xBB"],

        ["\xDE\xBC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x3C"],
        ["\x5E\x3C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xBC"],

        ["\xDE\xBD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x3D"],
        ["\x5E\x3D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xBD"],

        ["\xDE\xBE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x3E"],
        ["\x5E\x3E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xBE"],

        ["\xDE\xBF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x3F"],
        ["\x5E\x3F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xBF"],

        ["\xDE\xC0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x40"],
        ["\x5E\x40",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xC0"],

        ["\xDE\xC1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x41"],
        ["\x5E\x41",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xC1"],

        ["\xDE\xC2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x42"],
        ["\x5E\x42",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xC2"],

        ["\xDE\xC3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x43"],
        ["\x5E\x43",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xC3"],

        ["\xDE\xC4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x44"],
        ["\x5E\x44",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xC4"],

        ["\xDE\xC5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x45"],
        ["\x5E\x45",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xC5"],

        ["\xDE\xC6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x46"],
        ["\x5E\x46",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xC6"],

        ["\xDE\xC7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x47"],
        ["\x5E\x47",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xC7"],

        ["\xDE\xC8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x48"],
        ["\x5E\x48",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xC8"],

        ["\xDE\xC9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x49"],
        ["\x5E\x49",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xC9"],

        ["\xDE\xCA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x4A"],
        ["\x5E\x4A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xCA"],

        ["\xDE\xCB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x4B"],
        ["\x5E\x4B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xCB"],

        ["\xDE\xCC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x4C"],
        ["\x5E\x4C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xCC"],

        ["\xDE\xCD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x4D"],
        ["\x5E\x4D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xCD"],

        ["\xDE\xCE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x4E"],
        ["\x5E\x4E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xCE"],

        ["\xDE\xCF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x4F"],
        ["\x5E\x4F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xCF"],

        ["\xDE\xD0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x50"],
        ["\x5E\x50",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xD0"],

        ["\xDE\xD1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x51"],
        ["\x5E\x51",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xD1"],

        ["\xDE\xD2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x52"],
        ["\x5E\x52",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xD2"],

        ["\xDE\xD3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x53"],
        ["\x5E\x53",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xD3"],

        ["\xDE\xD4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x54"],
        ["\x5E\x54",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xD4"],

        ["\xDE\xD5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x55"],
        ["\x5E\x55",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xD5"],

        ["\xDE\xD6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x56"],
        ["\x5E\x56",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xD6"],

        ["\xDE\xD7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x57"],
        ["\x5E\x57",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xD7"],

        ["\xDE\xD8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x58"],
        ["\x5E\x58",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xD8"],

        ["\xDE\xD9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x59"],
        ["\x5E\x59",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xD9"],

        ["\xDE\xDA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x5A"],
        ["\x5E\x5A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xDA"],

        ["\xDE\xDB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x5B"],
        ["\x5E\x5B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xDB"],

        ["\xDE\xDC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x5C"],
        ["\x5E\x5C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xDC"],

        ["\xDE\xDD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x5D"],
        ["\x5E\x5D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xDD"],

        ["\xDE\xDE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x5E"],
        ["\x5E\x5E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xDE"],

        ["\xDE\xDF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x5F"],
        ["\x5E\x5F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xDF"],

        ["\xDE\xE0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x60"],
        ["\x5E\x60",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xE0"],

        ["\xDE\xE1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x61"],
        ["\x5E\x61",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xE1"],

        ["\xDE\xE2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x62"],
        ["\x5E\x62",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xE2"],

        ["\xDE\xE3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x63"],
        ["\x5E\x63",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xE3"],

        ["\xDE\xE4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x64"],
        ["\x5E\x64",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xE4"],

        ["\xDE\xE5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x65"],
        ["\x5E\x65",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xE5"],

        ["\xDE\xE6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x66"],
        ["\x5E\x66",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xE6"],

        ["\xDE\xE7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x67"],
        ["\x5E\x67",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xE7"],

        ["\xDE\xE8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x68"],
        ["\x5E\x68",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xE8"],

        ["\xDE\xE9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x69"],
        ["\x5E\x69",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xE9"],

        ["\xDE\xEA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x6A"],
        ["\x5E\x6A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xEA"],

        ["\xDE\xEB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x6B"],
        ["\x5E\x6B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xEB"],

        ["\xDE\xEC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x6C"],
        ["\x5E\x6C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xEC"],

        ["\xDE\xED",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x6D"],
        ["\x5E\x6D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xED"],

        ["\xDE\xEE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x6E"],
        ["\x5E\x6E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xEE"],

        ["\xDE\xEF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x6F"],
        ["\x5E\x6F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xEF"],

        ["\xDE\xF0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x70"],
        ["\x5E\x70",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xF0"],

        ["\xDE\xF1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x71"],
        ["\x5E\x71",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xF1"],

        ["\xDE\xF2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x72"],
        ["\x5E\x72",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xF2"],

        ["\xDE\xF3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x73"],
        ["\x5E\x73",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xF3"],

        ["\xDE\xF4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x74"],
        ["\x5E\x74",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xF4"],

        ["\xDE\xF5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x34\x43"],
        ["\x34\x43",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xF5"],

        ["\xDE\xF6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x76"],
        ["\x5E\x76",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xF6"],

        ["\xDE\xF7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x77"],
        ["\x5E\x77",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xF7"],

        ["\xDE\xF8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x78"],
        ["\x5E\x78",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xF8"],

        ["\xDE\xF9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x79"],
        ["\x5E\x79",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xF9"],

        ["\xDE\xFA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x7A"],
        ["\x5E\x7A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xFA"],

        ["\xDE\xFB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x7B"],
        ["\x5E\x7B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xFB"],

        ["\xDE\xFC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x7C"],
        ["\x5E\x7C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xFC"],

        ["\xDE\xFD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x7D"],
        ["\x5E\x7D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xFD"],

        ["\xDE\xFE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5E\x7E"],
        ["\x5E\x7E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDE\xFE"],

        ["\xDF\xA1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x21"],
        ["\x5F\x21",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xA1"],

        ["\xDF\xA2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x22"],
        ["\x5F\x22",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xA2"],

        ["\xDF\xA3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x23"],
        ["\x5F\x23",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xA3"],

        ["\xDF\xA4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x24"],
        ["\x5F\x24",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xA4"],

        ["\xDF\xA5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x25"],
        ["\x5F\x25",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xA5"],

        ["\xDF\xA6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x26"],
        ["\x5F\x26",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xA6"],

        ["\xDF\xA7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x27"],
        ["\x5F\x27",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xA7"],

        ["\xDF\xA8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x28"],
        ["\x5F\x28",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xA8"],

        ["\xDF\xA9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x29"],
        ["\x5F\x29",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xA9"],

        ["\xDF\xAA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x2A"],
        ["\x5F\x2A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xAA"],

        ["\xDF\xAB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x2B"],
        ["\x5F\x2B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xAB"],

        ["\xDF\xAC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x2C"],
        ["\x5F\x2C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xAC"],

        ["\xDF\xAD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x2D"],
        ["\x5F\x2D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xAD"],

        ["\xDF\xAE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x2E"],
        ["\x5F\x2E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xAE"],

        ["\xDF\xAF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x2F"],
        ["\x5F\x2F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xAF"],

        ["\xDF\xB0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x30"],
        ["\x5F\x30",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xB0"],

        ["\xDF\xB1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x31"],
        ["\x5F\x31",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xB1"],

        ["\xDF\xB2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x32"],
        ["\x5F\x32",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xB2"],

        ["\xDF\xB3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x33"],
        ["\x5F\x33",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xB3"],

        ["\xDF\xB4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x34"],
        ["\x5F\x34",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xB4"],

        ["\xDF\xB5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x35"],
        ["\x5F\x35",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xB5"],

        ["\xDF\xB6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x36"],
        ["\x5F\x36",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xB6"],

        ["\xDF\xB7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x37"],
        ["\x5F\x37",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xB7"],

        ["\xDF\xB8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x38"],
        ["\x5F\x38",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xB8"],

        ["\xDF\xB9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x39"],
        ["\x5F\x39",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xB9"],

        ["\xDF\xBA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x3A"],
        ["\x5F\x3A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xBA"],

        ["\xDF\xBB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x3B"],
        ["\x5F\x3B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xBB"],

        ["\xDF\xBC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x3C"],
        ["\x5F\x3C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xBC"],

        ["\xDF\xBD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x3D"],
        ["\x5F\x3D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xBD"],

        ["\xDF\xBE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x3E"],
        ["\x5F\x3E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xBE"],

        ["\xDF\xBF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x3F"],
        ["\x5F\x3F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xBF"],

        ["\xDF\xC0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x40"],
        ["\x5F\x40",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xC0"],

        ["\xDF\xC1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x41"],
        ["\x5F\x41",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xC1"],

        ["\xDF\xC2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x42"],
        ["\x5F\x42",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xC2"],

        ["\xDF\xC3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x43"],
        ["\x5F\x43",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xC3"],

        ["\xDF\xC4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x44"],
        ["\x5F\x44",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xC4"],

        ["\xDF\xC5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x45"],
        ["\x5F\x45",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xC5"],

        ["\xDF\xC6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x46"],
        ["\x5F\x46",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xC6"],

        ["\xDF\xC7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x47"],
        ["\x5F\x47",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xC7"],

        ["\xDF\xC8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x48"],
        ["\x5F\x48",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xC8"],

        ["\xDF\xC9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x49"],
        ["\x5F\x49",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xC9"],

        ["\xDF\xCA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x4A"],
        ["\x5F\x4A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xCA"],

        ["\xDF\xCB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x4B"],
        ["\x5F\x4B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xCB"],

        ["\xDF\xCC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x4C"],
        ["\x5F\x4C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xCC"],

        ["\xDF\xCD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x4D"],
        ["\x5F\x4D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xCD"],

        ["\xDF\xCE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x4E"],
        ["\x5F\x4E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xCE"],

        ["\xDF\xCF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x4F"],
        ["\x5F\x4F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xCF"],

        ["\xDF\xD0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x50"],
        ["\x5F\x50",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xD0"],

        ["\xDF\xD1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x51"],
        ["\x5F\x51",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xD1"],

        ["\xDF\xD2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x52"],
        ["\x5F\x52",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xD2"],

        ["\xDF\xD3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x53"],
        ["\x5F\x53",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xD3"],

        ["\xDF\xD4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x54"],
        ["\x5F\x54",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xD4"],

        ["\xDF\xD5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x55"],
        ["\x5F\x55",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xD5"],

        ["\xDF\xD6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x56"],
        ["\x5F\x56",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xD6"],

        ["\xDF\xD7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x57"],
        ["\x5F\x57",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xD7"],

        ["\xDF\xD8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x58"],
        ["\x5F\x58",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xD8"],

        ["\xDF\xD9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x59"],
        ["\x5F\x59",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xD9"],

        ["\xDF\xDA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x5A"],
        ["\x5F\x5A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xDA"],

        ["\xDF\xDB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x5B"],
        ["\x5F\x5B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xDB"],

        ["\xDF\xDC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x5C"],
        ["\x5F\x5C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xDC"],

        ["\xDF\xDD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x5D"],
        ["\x5F\x5D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xDD"],

        ["\xDF\xDE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x5E"],
        ["\x5F\x5E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xDE"],

        ["\xDF\xDF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x5F"],
        ["\x5F\x5F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xDF"],

        ["\xDF\xE0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x60"],
        ["\x5F\x60",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xE0"],

        ["\xDF\xE1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x61"],
        ["\x5F\x61",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xE1"],

        ["\xDF\xE2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x62"],
        ["\x5F\x62",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xE2"],

        ["\xDF\xE3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x63"],
        ["\x5F\x63",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xE3"],

        ["\xDF\xE4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x64"],
        ["\x5F\x64",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xE4"],

        ["\xDF\xE5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x65"],
        ["\x5F\x65",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xE5"],

        ["\xDF\xE6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x66"],
        ["\x5F\x66",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xE6"],

        ["\xDF\xE7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x67"],
        ["\x5F\x67",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xE7"],

        ["\xDF\xE8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x68"],
        ["\x5F\x68",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xE8"],

        ["\xDF\xE9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x69"],
        ["\x5F\x69",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xE9"],

        ["\xDF\xEA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x6A"],
        ["\x5F\x6A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xEA"],

        ["\xDF\xEB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x6B"],
        ["\x5F\x6B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xEB"],

        ["\xDF\xEC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x6C"],
        ["\x5F\x6C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xEC"],

        ["\xDF\xED",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x6D"],
        ["\x5F\x6D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xED"],

        ["\xDF\xEE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x6E"],
        ["\x5F\x6E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xEE"],

        ["\xDF\xEF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x6F"],
        ["\x5F\x6F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xEF"],

        ["\xDF\xF0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x70"],
        ["\x5F\x70",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xF0"],

        ["\xDF\xF1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x71"],
        ["\x5F\x71",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xF1"],

        ["\xDF\xF2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x72"],
        ["\x5F\x72",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xF2"],

        ["\xDF\xF3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x73"],
        ["\x5F\x73",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xF3"],

        ["\xDF\xF4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x74"],
        ["\x5F\x74",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xF4"],

        ["\xDF\xF5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x75"],
        ["\x5F\x75",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xF5"],

        ["\xDF\xF6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x76"],
        ["\x5F\x76",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xF6"],

        ["\xDF\xF7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x77"],
        ["\x5F\x77",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xF7"],

        ["\xDF\xF8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x78"],
        ["\x5F\x78",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xF8"],

        ["\xDF\xF9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x79"],
        ["\x5F\x79",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xF9"],

        ["\xDF\xFA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x7A"],
        ["\x5F\x7A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xFA"],

        ["\xDF\xFB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x7B"],
        ["\x5F\x7B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xFB"],

        ["\xDF\xFC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x7C"],
        ["\x5F\x7C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xFC"],

        ["\xDF\xFD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x7D"],
        ["\x5F\x7D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xFD"],

        ["\xDF\xFE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x5F\x7E"],
        ["\x5F\x7E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDF\xFE"],

        ["\xE0\xA1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x21"],
        ["\x60\x21",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xA1"],

        ["\xE0\xA2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x22"],
        ["\x60\x22",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xA2"],

        ["\xE0\xA3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x23"],
        ["\x60\x23",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xA3"],

        ["\xE0\xA4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x24"],
        ["\x60\x24",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xA4"],

        ["\xE0\xA5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x25"],
        ["\x60\x25",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xA5"],

        ["\xE0\xA6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x26"],
        ["\x60\x26",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xA6"],

        ["\xE0\xA7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x27"],
        ["\x60\x27",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xA7"],

        ["\xE0\xA8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x28"],
        ["\x60\x28",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xA8"],

        ["\xE0\xA9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x29"],
        ["\x60\x29",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xA9"],

        ["\xE0\xAA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x2A"],
        ["\x60\x2A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xAA"],

        ["\xE0\xAB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x2B"],
        ["\x60\x2B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xAB"],

        ["\xE0\xAC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x2C"],
        ["\x60\x2C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xAC"],

        ["\xE0\xAD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x2D"],
        ["\x60\x2D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xAD"],

        ["\xE0\xAE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x2E"],
        ["\x60\x2E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xAE"],

        ["\xE0\xAF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x2F"],
        ["\x60\x2F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xAF"],

        ["\xE0\xB0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x30"],
        ["\x60\x30",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xB0"],

        ["\xE0\xB1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x31"],
        ["\x60\x31",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xB1"],

        ["\xE0\xB2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x32"],
        ["\x60\x32",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xB2"],

        ["\xE0\xB3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x33"],
        ["\x60\x33",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xB3"],

        ["\xE0\xB4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x34"],
        ["\x60\x34",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xB4"],

        ["\xE0\xB5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x35"],
        ["\x60\x35",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xB5"],

        ["\xE0\xB6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x36"],
        ["\x60\x36",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xB6"],

        ["\xE0\xB7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x37"],
        ["\x60\x37",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xB7"],

        ["\xE0\xB8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x38"],
        ["\x60\x38",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xB8"],

        ["\xE0\xB9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x39"],
        ["\x60\x39",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xB9"],

        ["\xE0\xBA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x3A"],
        ["\x60\x3A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xBA"],

        ["\xE0\xBB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x3B"],
        ["\x60\x3B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xBB"],

        ["\xE0\xBC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x3C"],
        ["\x60\x3C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xBC"],

        ["\xE0\xBD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x3D"],
        ["\x60\x3D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xBD"],

        ["\xE0\xBE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x3E"],
        ["\x60\x3E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xBE"],

        ["\xE0\xBF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x3F"],
        ["\x60\x3F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xBF"],

        ["\xE0\xC0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x40"],
        ["\x60\x40",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xC0"],

        ["\xE0\xC1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x41"],
        ["\x60\x41",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xC1"],

        ["\xE0\xC2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x42"],
        ["\x60\x42",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xC2"],

        ["\xE0\xC3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x43"],
        ["\x60\x43",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xC3"],

        ["\xE0\xC4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x44"],
        ["\x60\x44",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xC4"],

        ["\xE0\xC5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x45"],
        ["\x60\x45",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xC5"],

        ["\xE0\xC6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x46"],
        ["\x60\x46",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xC6"],

        ["\xE0\xC7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x47"],
        ["\x60\x47",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xC7"],

        ["\xE0\xC8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x48"],
        ["\x60\x48",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xC8"],

        ["\xE0\xC9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x49"],
        ["\x60\x49",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xC9"],

        ["\xE0\xCA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x4A"],
        ["\x60\x4A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xCA"],

        ["\xE0\xCB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x4B"],
        ["\x60\x4B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xCB"],

        ["\xE0\xCC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x4C"],
        ["\x60\x4C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xCC"],

        ["\xE0\xCD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x4D"],
        ["\x60\x4D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xCD"],

        ["\xE0\xCE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x4E"],
        ["\x60\x4E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xCE"],

        ["\xE0\xCF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x4F"],
        ["\x60\x4F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xCF"],

        ["\xE0\xD0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x50"],
        ["\x60\x50",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xD0"],

        ["\xE0\xD1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x51"],
        ["\x60\x51",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xD1"],

        ["\xE0\xD2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x52"],
        ["\x60\x52",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xD2"],

        ["\xE0\xD3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x53"],
        ["\x60\x53",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xD3"],

        ["\xE0\xD4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x54"],
        ["\x60\x54",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xD4"],

        ["\xE0\xD5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x55"],
        ["\x60\x55",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xD5"],

        ["\xE0\xD6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x56"],
        ["\x60\x56",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xD6"],

        ["\xE0\xD7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x57"],
        ["\x60\x57",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xD7"],

        ["\xE0\xD8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x58"],
        ["\x60\x58",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xD8"],

        ["\xE0\xD9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x59"],
        ["\x60\x59",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xD9"],

        ["\xE0\xDA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x5A"],
        ["\x60\x5A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xDA"],

        ["\xE0\xDB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x5B"],
        ["\x60\x5B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xDB"],

        ["\xE0\xDC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x5C"],
        ["\x60\x5C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xDC"],

        ["\xE0\xDD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x5D"],
        ["\x60\x5D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xDD"],

        ["\xE0\xDE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x5E"],
        ["\x60\x5E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xDE"],

        ["\xE0\xDF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x5F"],
        ["\x60\x5F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xDF"],

        ["\xE0\xE0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x60"],
        ["\x60\x60",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xE0"],

        ["\xE0\xE1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x61"],
        ["\x60\x61",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xE1"],

        ["\xE0\xE2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x62"],
        ["\x60\x62",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xE2"],

        ["\xE0\xE3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x63"],
        ["\x60\x63",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xE3"],

        ["\xE0\xE4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x64"],
        ["\x60\x64",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xE4"],

        ["\xE0\xE5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x65"],
        ["\x60\x65",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xE5"],

        ["\xE0\xE6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x66"],
        ["\x60\x66",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xE6"],

        ["\xE0\xE7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x67"],
        ["\x60\x67",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xE7"],

        ["\xE0\xE8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x68"],
        ["\x60\x68",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xE8"],

        ["\xE0\xE9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x69"],
        ["\x60\x69",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xE9"],

        ["\xE0\xEA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x6A"],
        ["\x60\x6A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xEA"],

        ["\xE0\xEB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x6B"],
        ["\x60\x6B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xEB"],

        ["\xE0\xEC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x6C"],
        ["\x60\x6C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xEC"],

        ["\xE0\xED",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x6D"],
        ["\x60\x6D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xED"],

        ["\xE0\xEE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x6E"],
        ["\x60\x6E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xEE"],

        ["\xE0\xEF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x6F"],
        ["\x60\x6F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xEF"],

        ["\xE0\xF0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x70"],
        ["\x60\x70",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xF0"],

        ["\xE0\xF1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x71"],
        ["\x60\x71",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xF1"],

        ["\xE0\xF2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x72"],
        ["\x60\x72",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xF2"],

        ["\xE0\xF3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x73"],
        ["\x60\x73",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xF3"],

        ["\xE0\xF4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x74"],
        ["\x60\x74",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xF4"],

        ["\xE0\xF5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x75"],
        ["\x60\x75",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xF5"],

        ["\xE0\xF6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\xC4\xE8"],
        ["\xC4\xE8",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xF6"],

        ["\xE0\xF7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x77"],
        ["\x60\x77",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xF7"],

        ["\xE0\xF8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x78"],
        ["\x60\x78",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xF8"],

        ["\xE0\xF9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x79"],
        ["\x60\x79",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xF9"],

        ["\xE0\xFA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x7A"],
        ["\x60\x7A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xFA"],

        ["\xE0\xFB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x7B"],
        ["\x60\x7B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xFB"],

        ["\xE0\xFC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x7C"],
        ["\x60\x7C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xFC"],

        ["\xE0\xFD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x7D"],
        ["\x60\x7D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xFD"],

        ["\xE0\xFE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x7E"],
        ["\x60\x7E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xFE"],

        ["\xE1\xA1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x61\x21"],
        ["\x61\x21",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xA1"],

        ["\xE1\xA2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x61\x22"],
        ["\x61\x22",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xA2"],

        ["\xE1\xA3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x61\x23"],
        ["\x61\x23",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xA3"],

        ["\xE1\xA4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x61\x24"],
        ["\x61\x24",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xA4"],

        ["\xE1\xA5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x61\x25"],
        ["\x61\x25",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xA5"],

        ["\xE1\xA6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x61\x26"],
        ["\x61\x26",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xA6"],

        ["\xE1\xA7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x61\x27"],
        ["\x61\x27",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xA7"],

        ["\xE1\xA8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x61\x28"],
        ["\x61\x28",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xA8"],

        ["\xE1\xA9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x61\x29"],
        ["\x61\x29",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xA9"],

        ["\xE1\xAA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x61\x2A"],
        ["\x61\x2A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xAA"],

        ["\xE1\xAB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x61\x2B"],
        ["\x61\x2B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xAB"],

        ["\xE1\xAC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x61\x2C"],
        ["\x61\x2C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xAC"],

        ["\xE1\xAD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x61\x2D"],
        ["\x61\x2D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xAD"],

        ["\xE1\xAE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x61\x2E"],
        ["\x61\x2E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xAE"],

        ["\xE1\xAF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x61\x2F"],
        ["\x61\x2F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xAF"],

        ["\xE1\xB0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x61\x30"],
        ["\x61\x30",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xB0"],

        ["\xE1\xB1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x61\x31"],
        ["\x61\x31",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xB1"],

        ["\xE1\xB2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x61\x32"],
        ["\x61\x32",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xB2"],

        ["\xE1\xB3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x61\x33"],
        ["\x61\x33",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xB3"],

        ["\xE1\xB4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x61\x34"],
        ["\x61\x34",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xB4"],

        ["\xE1\xB5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x61\x35"],
        ["\x61\x35",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xB5"],

        ["\xE1\xB6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x61\x36"],
        ["\x61\x36",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xB6"],

        ["\xE1\xB7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x61\x37"],
        ["\x61\x37",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xB7"],

        ["\xE1\xB8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x61\x38"],
        ["\x61\x38",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xB8"],

        ["\xE1\xB9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x61\x39"],
        ["\x61\x39",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xB9"],

        ["\xE1\xBA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x61\x3A"],
        ["\x61\x3A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xBA"],

        ["\xE1\xBB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x61\x3B"],
        ["\x61\x3B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xBB"],

        ["\xE1\xBC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x61\x3C"],
        ["\x61\x3C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xBC"],

        ["\xE1\xBD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x61\x3D"],
        ["\x61\x3D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xBD"],

        ["\xE1\xBE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x61\x3E"],
        ["\x61\x3E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xBE"],

        ["\xE1\xBF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x61\x3F"],
        ["\x61\x3F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xBF"],

        ["\xE1\xC0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x61\x40"],
        ["\x61\x40",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xC0"],

        ["\xE1\xC1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x61\x41"],
        ["\x61\x41",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xC1"],

        ["\xE1\xC2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x61\x42"],
        ["\x61\x42",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xC2"],

        ["\xE1\xC3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x61\x43"],
        ["\x61\x43",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xC3"],

        ["\xE1\xC4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x61\x44"],
        ["\x61\x44",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xC4"],

        ["\xE1\xC5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x61\x45"],
        ["\x61\x45",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xC5"],

        ["\xE1\xC6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x61\x46"],
        ["\x61\x46",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xC6"],

        ["\xE1\xC7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x61\x47"],
        ["\x61\x47",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xC7"],

        ["\xE1\xC8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x61\x48"],
        ["\x61\x48",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xC8"],

        ["\xE1\xC9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x61\x49"],
        ["\x61\x49",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xC9"],

        ["\xE1\xCA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x61\x4A"],
        ["\x61\x4A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xCA"],

        ["\xE1\xCB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x61\x4B"],
        ["\x61\x4B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xCB"],

        ["\xE1\xCC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x61\x4C"],
        ["\x61\x4C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xCC"],

        ["\xE1\xCD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x61\x4D"],
        ["\x61\x4D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xCD"],

        ["\xE1\xCE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x61\x4E"],
        ["\x61\x4E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xCE"],

        ["\xE1\xCF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x61\x4F"],
        ["\x61\x4F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xCF"],

        ["\xE1\xD0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x61\x50"],
        ["\x61\x50",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xD0"],

        ["\xE1\xD1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x61\x51"],
        ["\x61\x51",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xD1"],

        ["\xE1\xD2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x61\x52"],
        ["\x61\x52",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xD2"],

        ["\xE1\xD3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x61\x53"],
        ["\x61\x53",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xD3"],

        ["\xE1\xD4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x61\x54"],
        ["\x61\x54",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xD4"],

        ["\xE1\xD5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x61\x55"],
        ["\x61\x55",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xD5"],

        ["\xE1\xD6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x61\x56"],
        ["\x61\x56",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xD6"],

        ["\xE1\xD7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x61\x57"],
        ["\x61\x57",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xD7"],

        ["\xE1\xD8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x61\x58"],
        ["\x61\x58",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xD8"],

        ["\xE1\xD9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x61\x59"],
        ["\x61\x59",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xD9"],

        ["\xE1\xDA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x61\x5A"],
        ["\x61\x5A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xDA"],

        ["\xE1\xDB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x61\x5B"],
        ["\x61\x5B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xDB"],

        ["\xE1\xDC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x61\x5C"],
        ["\x61\x5C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xDC"],

        ["\xE1\xDD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x61\x5D"],
        ["\x61\x5D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xDD"],

        ["\xE1\xDE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x61\x5E"],
        ["\x61\x5E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xDE"],

        ["\xE1\xDF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x61\x5F"],
        ["\x61\x5F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xDF"],

        ["\xE1\xE0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x61\x60"],
        ["\x61\x60",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xE0"],

        ["\xE1\xE1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x61\x61"],
        ["\x61\x61",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xE1"],

        ["\xE1\xE2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x61\x62"],
        ["\x61\x62",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xE2"],

        ["\xE1\xE3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x61\x63"],
        ["\x61\x63",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xE3"],

        ["\xE1\xE4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x61\x64"],
        ["\x61\x64",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xE4"],

        ["\xE1\xE5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x61\x65"],
        ["\x61\x65",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xE5"],

        ["\xE1\xE6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x61\x66"],
        ["\x61\x66",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xE6"],

        ["\xE1\xE7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x61\x67"],
        ["\x61\x67",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xE7"],

        ["\xE1\xE8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x61\x68"],
        ["\x61\x68",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xE8"],

        ["\xE1\xE9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x61\x69"],
        ["\x61\x69",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xE9"],

        ["\xE1\xEA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x61\x6A"],
        ["\x61\x6A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xEA"],

        ["\xE1\xEB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x61\x6B"],
        ["\x61\x6B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xEB"],

        ["\xE1\xEC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x61\x6C"],
        ["\x61\x6C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xEC"],

        ["\xE1\xED",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x61\x6D"],
        ["\x61\x6D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xED"],

        ["\xE1\xEE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x61\x6E"],
        ["\x61\x6E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xEE"],

        ["\xE1\xEF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x61\x6F"],
        ["\x61\x6F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xEF"],

        ["\xE1\xF0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x61\x70"],
        ["\x61\x70",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xF0"],

        ["\xE1\xF1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x61\x71"],
        ["\x61\x71",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xF1"],

        ["\xE1\xF2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x61\x72"],
        ["\x61\x72",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xF2"],

        ["\xE1\xF3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x61\x73"],
        ["\x61\x73",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xF3"],

        ["\xE1\xF4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x61\x74"],
        ["\x61\x74",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xF4"],

        ["\xE1\xF5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x61\x75"],
        ["\x61\x75",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xF5"],

        ["\xE1\xF6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x61\x76"],
        ["\x61\x76",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xF6"],

        ["\xE1\xF7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x61\x77"],
        ["\x61\x77",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xF7"],

        ["\xE1\xF8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x61\x78"],
        ["\x61\x78",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xF8"],

        ["\xE1\xF9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x61\x79"],
        ["\x61\x79",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xF9"],

        ["\xE1\xFA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x61\x7A"],
        ["\x61\x7A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xFA"],

        ["\xE1\xFB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x61\x7B"],
        ["\x61\x7B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xFB"],

        ["\xE1\xFC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x61\x7C"],
        ["\x61\x7C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xFC"],

        ["\xE1\xFD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x61\x7D"],
        ["\x61\x7D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xFD"],

        ["\xE1\xFE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x61\x7E"],
        ["\x61\x7E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xFE"],

        ["\xE2\xA1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x21"],
        ["\x62\x21",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xA1"],

        ["\xE2\xA2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x22"],
        ["\x62\x22",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xA2"],

        ["\xE2\xA3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x23"],
        ["\x62\x23",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xA3"],

        ["\xE2\xA4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x24"],
        ["\x62\x24",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xA4"],

        ["\xE2\xA5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x25"],
        ["\x62\x25",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xA5"],

        ["\xE2\xA6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x26"],
        ["\x62\x26",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xA6"],

        ["\xE2\xA7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x27"],
        ["\x62\x27",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xA7"],

        ["\xE2\xA8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x28"],
        ["\x62\x28",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xA8"],

        ["\xE2\xA9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x29"],
        ["\x62\x29",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xA9"],

        ["\xE2\xAA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x2A"],
        ["\x62\x2A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xAA"],

        ["\xE2\xAB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x2B"],
        ["\x62\x2B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xAB"],

        ["\xE2\xAC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x2C"],
        ["\x62\x2C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xAC"],

        ["\xE2\xAD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x2D"],
        ["\x62\x2D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xAD"],

        ["\xE2\xAE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x2E"],
        ["\x62\x2E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xAE"],

        ["\xE2\xAF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x2F"],
        ["\x62\x2F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xAF"],

        ["\xE2\xB0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x30"],
        ["\x62\x30",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xB0"],

        ["\xE2\xB1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x31"],
        ["\x62\x31",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xB1"],

        ["\xE2\xB2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x32"],
        ["\x62\x32",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xB2"],

        ["\xE2\xB3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x33"],
        ["\x62\x33",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xB3"],

        ["\xE2\xB4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x34"],
        ["\x62\x34",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xB4"],

        ["\xE2\xB5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x35"],
        ["\x62\x35",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xB5"],

        ["\xE2\xB6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x36"],
        ["\x62\x36",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xB6"],

        ["\xE2\xB7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x37"],
        ["\x62\x37",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xB7"],

        ["\xE2\xB8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x38"],
        ["\x62\x38",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xB8"],

        ["\xE2\xB9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x39"],
        ["\x62\x39",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xB9"],

        ["\xE2\xBA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x3A"],
        ["\x62\x3A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xBA"],

        ["\xE2\xBB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x3B"],
        ["\x62\x3B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xBB"],

        ["\xE2\xBC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x3C"],
        ["\x62\x3C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xBC"],

        ["\xE2\xBD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x3D"],
        ["\x62\x3D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xBD"],

        ["\xE2\xBE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x3E"],
        ["\x62\x3E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xBE"],

        ["\xE2\xBF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x3F"],
        ["\x62\x3F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xBF"],

        ["\xE2\xC0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x40"],
        ["\x62\x40",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xC0"],

        ["\xE2\xC1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x41"],
        ["\x62\x41",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xC1"],

        ["\xE2\xC2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x42"],
        ["\x62\x42",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xC2"],

        ["\xE2\xC3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x43"],
        ["\x62\x43",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xC3"],

        ["\xE2\xC4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x44"],
        ["\x62\x44",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xC4"],

        ["\xE2\xC5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x45"],
        ["\x62\x45",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xC5"],

        ["\xE2\xC6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x46"],
        ["\x62\x46",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xC6"],

        ["\xE2\xC7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x47"],
        ["\x62\x47",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xC7"],

        ["\xE2\xC8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x48"],
        ["\x62\x48",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xC8"],

        ["\xE2\xC9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x49"],
        ["\x62\x49",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xC9"],

        ["\xE2\xCA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x4A"],
        ["\x62\x4A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xCA"],

        ["\xE2\xCB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x4B"],
        ["\x62\x4B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xCB"],

        ["\xE2\xCC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x4C"],
        ["\x62\x4C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xCC"],

        ["\xE2\xCD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x4D"],
        ["\x62\x4D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xCD"],

        ["\xE2\xCE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x4E"],
        ["\x62\x4E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xCE"],

        ["\xE2\xCF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x4F"],
        ["\x62\x4F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xCF"],

        ["\xE2\xD0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x50"],
        ["\x62\x50",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xD0"],

        ["\xE2\xD1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x51"],
        ["\x62\x51",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xD1"],

        ["\xE2\xD2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x52"],
        ["\x62\x52",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xD2"],

        ["\xE2\xD3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x53"],
        ["\x62\x53",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xD3"],

        ["\xE2\xD4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x54"],
        ["\x62\x54",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xD4"],

        ["\xE2\xD5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x55"],
        ["\x62\x55",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xD5"],

        ["\xE2\xD6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x56"],
        ["\x62\x56",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xD6"],

        ["\xE2\xD7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x57"],
        ["\x62\x57",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xD7"],

        ["\xE2\xD8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x58"],
        ["\x62\x58",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xD8"],

        ["\xE2\xD9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x59"],
        ["\x62\x59",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xD9"],

        ["\xE2\xDA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x5A"],
        ["\x62\x5A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xDA"],

        ["\xE2\xDB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x5B"],
        ["\x62\x5B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xDB"],

        ["\xE2\xDC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x5C"],
        ["\x62\x5C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xDC"],

        ["\xE2\xDD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x5D"],
        ["\x62\x5D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xDD"],

        ["\xE2\xDE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x5E"],
        ["\x62\x5E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xDE"],

        ["\xE2\xDF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x5F"],
        ["\x62\x5F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xDF"],

        ["\xE2\xE0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x60"],
        ["\x62\x60",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xE0"],

        ["\xE2\xE1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x61"],
        ["\x62\x61",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xE1"],

        ["\xE2\xE2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x62"],
        ["\x62\x62",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xE2"],

        ["\xE2\xE3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x63"],
        ["\x62\x63",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xE3"],

        ["\xE2\xE4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x64"],
        ["\x62\x64",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xE4"],

        ["\xE2\xE5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x65"],
        ["\x62\x65",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xE5"],

        ["\xE2\xE6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x66"],
        ["\x62\x66",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xE6"],

        ["\xE2\xE7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x67"],
        ["\x62\x67",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xE7"],

        ["\xE2\xE8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x39\x5C"],
        ["\x39\x5C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xE8"],

        ["\xE2\xE9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x69"],
        ["\x62\x69",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xE9"],

        ["\xE2\xEA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x45\x57"],
        ["\x45\x57",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xEA"],

        ["\xE2\xEB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x6B"],
        ["\x62\x6B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xEB"],

        ["\xE2\xEC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x6C"],
        ["\x62\x6C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xEC"],

        ["\xE2\xED",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x6D"],
        ["\x62\x6D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xED"],

        ["\xE2\xEE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x6E"],
        ["\x62\x6E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xEE"],

        ["\xE2\xEF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x6F"],
        ["\x62\x6F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xEF"],

        ["\xE2\xF0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x70"],
        ["\x62\x70",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xF0"],

        ["\xE2\xF1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x71"],
        ["\x62\x71",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xF1"],

        ["\xE2\xF2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x72"],
        ["\x62\x72",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xF2"],

        ["\xE2\xF3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x73"],
        ["\x62\x73",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xF3"],

        ["\xE2\xF4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x74"],
        ["\x62\x74",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xF4"],

        ["\xE2\xF5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x75"],
        ["\x62\x75",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xF5"],

        ["\xE2\xF6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x76"],
        ["\x62\x76",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xF6"],

        ["\xE2\xF7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x77"],
        ["\x62\x77",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xF7"],

        ["\xE2\xF8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x78"],
        ["\x62\x78",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xF8"],

        ["\xE2\xF9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x79"],
        ["\x62\x79",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xF9"],

        ["\xE2\xFA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x7A"],
        ["\x62\x7A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xFA"],

        ["\xE2\xFB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x7B"],
        ["\x62\x7B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xFB"],

        ["\xE2\xFC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x7C"],
        ["\x62\x7C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xFC"],

        ["\xE2\xFD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x7D"],
        ["\x62\x7D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xFD"],

        ["\xE2\xFE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x62\x7E"],
        ["\x62\x7E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xFE"],

        ["\xE3\xA1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x21"],
        ["\x63\x21",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xA1"],

        ["\xE3\xA2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x22"],
        ["\x63\x22",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xA2"],

        ["\xE3\xA3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x23"],
        ["\x63\x23",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xA3"],

        ["\xE3\xA4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x24"],
        ["\x63\x24",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xA4"],

        ["\xE3\xA5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x25"],
        ["\x63\x25",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xA5"],

        ["\xE3\xA6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x26"],
        ["\x63\x26",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xA6"],

        ["\xE3\xA7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x27"],
        ["\x63\x27",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xA7"],

        ["\xE3\xA8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x28"],
        ["\x63\x28",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xA8"],

        ["\xE3\xA9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x29"],
        ["\x63\x29",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xA9"],

        ["\xE3\xAA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x2A"],
        ["\x63\x2A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xAA"],

        ["\xE3\xAB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x2B"],
        ["\x63\x2B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xAB"],

        ["\xE3\xAC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x2C"],
        ["\x63\x2C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xAC"],

        ["\xE3\xAD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x2D"],
        ["\x63\x2D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xAD"],

        ["\xE3\xAE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x2E"],
        ["\x63\x2E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xAE"],

        ["\xE3\xAF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x2F"],
        ["\x63\x2F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xAF"],

        ["\xE3\xB0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x30"],
        ["\x63\x30",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xB0"],

        ["\xE3\xB1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x31"],
        ["\x63\x31",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xB1"],

        ["\xE3\xB2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x32"],
        ["\x63\x32",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xB2"],

        ["\xE3\xB3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x33"],
        ["\x63\x33",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xB3"],

        ["\xE3\xB4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x34"],
        ["\x63\x34",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xB4"],

        ["\xE3\xB5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x35"],
        ["\x63\x35",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xB5"],

        ["\xE3\xB6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x36"],
        ["\x63\x36",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xB6"],

        ["\xE3\xB7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x37"],
        ["\x63\x37",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xB7"],

        ["\xE3\xB8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x38"],
        ["\x63\x38",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xB8"],

        ["\xE3\xB9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x39"],
        ["\x63\x39",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xB9"],

        ["\xE3\xBA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x3A"],
        ["\x63\x3A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xBA"],

        ["\xE3\xBB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x3B"],
        ["\x63\x3B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xBB"],

        ["\xE3\xBC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x3C"],
        ["\x63\x3C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xBC"],

        ["\xE3\xBD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x3D"],
        ["\x63\x3D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xBD"],

        ["\xE3\xBE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x3E"],
        ["\x63\x3E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xBE"],

        ["\xE3\xBF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x3F"],
        ["\x63\x3F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xBF"],

        ["\xE3\xC0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x40"],
        ["\x63\x40",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xC0"],

        ["\xE3\xC1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x41"],
        ["\x63\x41",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xC1"],

        ["\xE3\xC2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x42"],
        ["\x63\x42",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xC2"],

        ["\xE3\xC3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x43"],
        ["\x63\x43",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xC3"],

        ["\xE3\xC4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x44"],
        ["\x63\x44",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xC4"],

        ["\xE3\xC5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x45"],
        ["\x63\x45",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xC5"],

        ["\xE3\xC6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x46"],
        ["\x63\x46",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xC6"],

        ["\xE3\xC7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x47"],
        ["\x63\x47",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xC7"],

        ["\xE3\xC8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x48"],
        ["\x63\x48",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xC8"],

        ["\xE3\xC9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x49"],
        ["\x63\x49",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xC9"],

        ["\xE3\xCA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x4A"],
        ["\x63\x4A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xCA"],

        ["\xE3\xCB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x4B"],
        ["\x63\x4B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xCB"],

        ["\xE3\xCC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x4C"],
        ["\x63\x4C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xCC"],

        ["\xE3\xCD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x4D"],
        ["\x63\x4D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xCD"],

        ["\xE3\xCE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x4E"],
        ["\x63\x4E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xCE"],

        ["\xE3\xCF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x4F"],
        ["\x63\x4F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xCF"],

        ["\xE3\xD0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x50"],
        ["\x63\x50",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xD0"],

        ["\xE3\xD1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x51"],
        ["\x63\x51",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xD1"],

        ["\xE3\xD2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x52"],
        ["\x63\x52",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xD2"],

        ["\xE3\xD3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x53"],
        ["\x63\x53",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xD3"],

        ["\xE3\xD4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x54"],
        ["\x63\x54",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xD4"],

        ["\xE3\xD5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x55"],
        ["\x63\x55",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xD5"],

        ["\xE3\xD6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x56"],
        ["\x63\x56",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xD6"],

        ["\xE3\xD7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x57"],
        ["\x63\x57",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xD7"],

        ["\xE3\xD8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x58"],
        ["\x63\x58",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xD8"],

        ["\xE3\xD9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x59"],
        ["\x63\x59",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xD9"],

        ["\xE3\xDA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x5A"],
        ["\x63\x5A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xDA"],

        ["\xE3\xDB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x5B"],
        ["\x63\x5B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xDB"],

        ["\xE3\xDC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x5C"],
        ["\x63\x5C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xDC"],

        ["\xE3\xDD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x5D"],
        ["\x63\x5D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xDD"],

        ["\xE3\xDE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x33\x76"],
        ["\x33\x76",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xDE"],

        ["\xE3\xDF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x5F"],
        ["\x63\x5F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xDF"],

        ["\xE3\xE0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x60"],
        ["\x63\x60",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xE0"],

        ["\xE3\xE1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x61"],
        ["\x63\x61",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xE1"],

        ["\xE3\xE2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x62"],
        ["\x63\x62",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xE2"],

        ["\xE3\xE3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x63"],
        ["\x63\x63",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xE3"],

        ["\xE3\xE4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x64"],
        ["\x63\x64",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xE4"],

        ["\xE3\xE5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x65"],
        ["\x63\x65",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xE5"],

        ["\xE3\xE6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x66"],
        ["\x63\x66",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xE6"],

        ["\xE3\xE7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x67"],
        ["\x63\x67",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xE7"],

        ["\xE3\xE8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x68"],
        ["\x63\x68",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xE8"],

        ["\xE3\xE9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x69"],
        ["\x63\x69",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xE9"],

        ["\xE3\xEA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x6A"],
        ["\x63\x6A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xEA"],

        ["\xE3\xEB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x6B"],
        ["\x63\x6B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xEB"],

        ["\xE3\xEC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x6C"],
        ["\x63\x6C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xEC"],

        ["\xE3\xED",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x6D"],
        ["\x63\x6D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xED"],

        ["\xE3\xEE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x6E"],
        ["\x63\x6E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xEE"],

        ["\xE3\xEF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x6F"],
        ["\x63\x6F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xEF"],

        ["\xE3\xF0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x70"],
        ["\x63\x70",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xF0"],

        ["\xE3\xF1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x71"],
        ["\x63\x71",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xF1"],

        ["\xE3\xF2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x72"],
        ["\x63\x72",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xF2"],

        ["\xE3\xF3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x73"],
        ["\x63\x73",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xF3"],

        ["\xE3\xF4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x74"],
        ["\x63\x74",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xF4"],

        ["\xE3\xF5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x75"],
        ["\x63\x75",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xF5"],

        ["\xE3\xF6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x76"],
        ["\x63\x76",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xF6"],

        ["\xE3\xF7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x77"],
        ["\x63\x77",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xF7"],

        ["\xE3\xF8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x78"],
        ["\x63\x78",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xF8"],

        ["\xE3\xF9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x79"],
        ["\x63\x79",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xF9"],

        ["\xE3\xFA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x7A"],
        ["\x63\x7A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xFA"],

        ["\xE3\xFB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x7B"],
        ["\x63\x7B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xFB"],

        ["\xE3\xFC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x7C"],
        ["\x63\x7C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xFC"],

        ["\xE3\xFD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x7D"],
        ["\x63\x7D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xFD"],

        ["\xE3\xFE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x63\x7E"],
        ["\x63\x7E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xFE"],

        ["\xE4\xA1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x21"],
        ["\x64\x21",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xA1"],

        ["\xE4\xA2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x22"],
        ["\x64\x22",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xA2"],

        ["\xE4\xA3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x23"],
        ["\x64\x23",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xA3"],

        ["\xE4\xA4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x24"],
        ["\x64\x24",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xA4"],

        ["\xE4\xA5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x25"],
        ["\x64\x25",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xA5"],

        ["\xE4\xA6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x26"],
        ["\x64\x26",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xA6"],

        ["\xE4\xA7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x27"],
        ["\x64\x27",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xA7"],

        ["\xE4\xA8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x28"],
        ["\x64\x28",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xA8"],

        ["\xE4\xA9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x29"],
        ["\x64\x29",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xA9"],

        ["\xE4\xAA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x2A"],
        ["\x64\x2A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xAA"],

        ["\xE4\xAB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x2B"],
        ["\x64\x2B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xAB"],

        ["\xE4\xAC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x2C"],
        ["\x64\x2C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xAC"],

        ["\xE4\xAD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x2D"],
        ["\x64\x2D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xAD"],

        ["\xE4\xAE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x2E"],
        ["\x64\x2E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xAE"],

        ["\xE4\xAF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x2F"],
        ["\x64\x2F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xAF"],

        ["\xE4\xB0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x30"],
        ["\x64\x30",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xB0"],

        ["\xE4\xB1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x31"],
        ["\x64\x31",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xB1"],

        ["\xE4\xB2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x32"],
        ["\x64\x32",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xB2"],

        ["\xE4\xB3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x33"],
        ["\x64\x33",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xB3"],

        ["\xE4\xB4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x34"],
        ["\x64\x34",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xB4"],

        ["\xE4\xB5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x35"],
        ["\x64\x35",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xB5"],

        ["\xE4\xB6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x36"],
        ["\x64\x36",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xB6"],

        ["\xE4\xB7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x37"],
        ["\x64\x37",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xB7"],

        ["\xE4\xB8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x38"],
        ["\x64\x38",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8"],

        ["\xE4\xB9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x39"],
        ["\x64\x39",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9"],

        ["\xE4\xBA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x3A"],
        ["\x64\x3A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA"],

        ["\xE4\xBB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x3B"],
        ["\x64\x3B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB"],

        ["\xE4\xBC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x3C"],
        ["\x64\x3C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC"],

        ["\xE4\xBD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x3D"],
        ["\x64\x3D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD"],

        ["\xE4\xBE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x3E"],
        ["\x64\x3E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE"],

        ["\xE4\xBF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x3F"],
        ["\x64\x3F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF"],

        ["\xE4\xC0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x40"],
        ["\x64\x40",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xC0"],

        ["\xE4\xC1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x41"],
        ["\x64\x41",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xC1"],

        ["\xE4\xC2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x42"],
        ["\x64\x42",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xC2"],

        ["\xE4\xC3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x43"],
        ["\x64\x43",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xC3"],

        ["\xE4\xC4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x44"],
        ["\x64\x44",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xC4"],

        ["\xE4\xC5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x45"],
        ["\x64\x45",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xC5"],

        ["\xE4\xC6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4F\x36"],
        ["\x4F\x36",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xC6"],

        ["\xE4\xC7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x47"],
        ["\x64\x47",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xC7"],

        ["\xE4\xC8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x48"],
        ["\x64\x48",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xC8"],

        ["\xE4\xC9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x49"],
        ["\x64\x49",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xC9"],

        ["\xE4\xCA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x4A"],
        ["\x64\x4A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xCA"],

        ["\xE4\xCB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x4B"],
        ["\x64\x4B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xCB"],

        ["\xE4\xCC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x4C"],
        ["\x64\x4C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xCC"],

        ["\xE4\xCD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x4D"],
        ["\x64\x4D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xCD"],

        ["\xE4\xCE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x4E"],
        ["\x64\x4E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xCE"],

        ["\xE4\xCF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x4F"],
        ["\x64\x4F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xCF"],

        ["\xE4\xD0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x50"],
        ["\x64\x50",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xD0"],

        ["\xE4\xD1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x51"],
        ["\x64\x51",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xD1"],

        ["\xE4\xD2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x52"],
        ["\x64\x52",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xD2"],

        ["\xE4\xD3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x53"],
        ["\x64\x53",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xD3"],

        ["\xE4\xD4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x54"],
        ["\x64\x54",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xD4"],

        ["\xE4\xD5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x55"],
        ["\x64\x55",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xD5"],

        ["\xE4\xD6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x56"],
        ["\x64\x56",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xD6"],

        ["\xE4\xD7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x57"],
        ["\x64\x57",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xD7"],

        ["\xE4\xD8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x58"],
        ["\x64\x58",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xD8"],

        ["\xE4\xD9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x59"],
        ["\x64\x59",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xD9"],

        ["\xE4\xDA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x5A"],
        ["\x64\x5A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xDA"],

        ["\xE4\xDB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x5B"],
        ["\x64\x5B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xDB"],

        ["\xE4\xDC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x5C"],
        ["\x64\x5C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xDC"],

        ["\xE4\xDD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x5D"],
        ["\x64\x5D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xDD"],

        ["\xE4\xDE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x5E"],
        ["\x64\x5E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xDE"],

        ["\xE4\xDF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x5F"],
        ["\x64\x5F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xDF"],

        ["\xE4\xE0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x60"],
        ["\x64\x60",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xE0"],

        ["\xE4\xE1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x61"],
        ["\x64\x61",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xE1"],

        ["\xE4\xE2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x62"],
        ["\x64\x62",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xE2"],

        ["\xE4\xE3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x63"],
        ["\x64\x63",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xE3"],

        ["\xE4\xE4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x64"],
        ["\x64\x64",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xE4"],

        ["\xE4\xE5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x65"],
        ["\x64\x65",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xE5"],

        ["\xE4\xE6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x66"],
        ["\x64\x66",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xE6"],

        ["\xE4\xE7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x67"],
        ["\x64\x67",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xE7"],

        ["\xE4\xE8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x68"],
        ["\x64\x68",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xE8"],

        ["\xE4\xE9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x69"],
        ["\x64\x69",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xE9"],

        ["\xE4\xEA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x6A"],
        ["\x64\x6A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xEA"],

        ["\xE4\xEB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x6B"],
        ["\x64\x6B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xEB"],

        ["\xE4\xEC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x6C"],
        ["\x64\x6C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xEC"],

        ["\xE4\xED",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x6D"],
        ["\x64\x6D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xED"],

        ["\xE4\xEE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x6E"],
        ["\x64\x6E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xEE"],

        ["\xE4\xEF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x6F"],
        ["\x64\x6F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xEF"],

        ["\xE4\xF0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x70"],
        ["\x64\x70",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xF0"],

        ["\xE4\xF1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x71"],
        ["\x64\x71",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xF1"],

        ["\xE4\xF2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x72"],
        ["\x64\x72",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xF2"],

        ["\xE4\xF3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x73"],
        ["\x64\x73",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xF3"],

        ["\xE4\xF4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x74"],
        ["\x64\x74",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xF4"],

        ["\xE4\xF5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x75"],
        ["\x64\x75",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xF5"],

        ["\xE4\xF6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x76"],
        ["\x64\x76",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xF6"],

        ["\xE4\xF7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x77"],
        ["\x64\x77",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xF7"],

        ["\xE4\xF8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x78"],
        ["\x64\x78",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xF8"],

        ["\xE4\xF9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x79"],
        ["\x64\x79",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xF9"],

        ["\xE4\xFA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x7A"],
        ["\x64\x7A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xFA"],

        ["\xE4\xFB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x7B"],
        ["\x64\x7B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xFB"],

        ["\xE4\xFC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x7C"],
        ["\x64\x7C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xFC"],

        ["\xE4\xFD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x7D"],
        ["\x64\x7D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xFD"],

        ["\xE4\xFE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x64\x7E"],
        ["\x64\x7E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xFE"],

        ["\xE5\xA1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x21"],
        ["\x65\x21",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1"],

        ["\xE5\xA2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x22"],
        ["\x65\x22",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2"],

        ["\xE5\xA3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x23"],
        ["\x65\x23",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3"],

        ["\xE5\xA4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x24"],
        ["\x65\x24",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4"],

        ["\xE5\xA5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x25"],
        ["\x65\x25",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5"],

        ["\xE5\xA6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x26"],
        ["\x65\x26",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6"],

        ["\xE5\xA7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x27"],
        ["\x65\x27",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7"],

        ["\xE5\xA8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x28"],
        ["\x65\x28",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8"],

        ["\xE5\xA9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x29"],
        ["\x65\x29",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9"],

        ["\xE5\xAA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x2A"],
        ["\x65\x2A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xAA"],

        ["\xE5\xAB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x2B"],
        ["\x65\x2B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB"],

        ["\xE5\xAC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x2C"],
        ["\x65\x2C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC"],

        ["\xE5\xAD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x2D"],
        ["\x65\x2D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD"],

        ["\xE5\xAE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x2E"],
        ["\x65\x2E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE"],

        ["\xE5\xAF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x2F"],
        ["\x65\x2F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF"],

        ["\xE5\xB0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x30"],
        ["\x65\x30",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0"],

        ["\xE5\xB1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x31"],
        ["\x65\x31",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1"],

        ["\xE5\xB2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x32"],
        ["\x65\x32",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2"],

        ["\xE5\xB3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x33"],
        ["\x65\x33",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3"],

        ["\xE5\xB4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x34"],
        ["\x65\x34",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4"],

        ["\xE5\xB5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x35"],
        ["\x65\x35",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5"],

        ["\xE5\xB6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x36"],
        ["\x65\x36",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6"],

        ["\xE5\xB7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x37"],
        ["\x65\x37",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7"],

        ["\xE5\xB8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x38"],
        ["\x65\x38",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8"],

        ["\xE5\xB9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x39"],
        ["\x65\x39",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9"],

        ["\xE5\xBA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x3A"],
        ["\x65\x3A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA"],

        ["\xE5\xBB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x3B"],
        ["\x65\x3B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB"],

        ["\xE5\xBC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x3C"],
        ["\x65\x3C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC"],

        ["\xE5\xBD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x3D"],
        ["\x65\x3D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD"],

        ["\xE5\xBE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x3E"],
        ["\x65\x3E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE"],

        ["\xE5\xBF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x3F"],
        ["\x65\x3F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF"],

        ["\xE5\xC0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x40"],
        ["\x65\x40",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xC0"],

        ["\xE5\xC1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x41"],
        ["\x65\x41",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xC1"],

        ["\xE5\xC2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x42"],
        ["\x65\x42",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xC2"],

        ["\xE5\xC3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x43"],
        ["\x65\x43",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xC3"],

        ["\xE5\xC4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x44"],
        ["\x65\x44",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xC4"],

        ["\xE5\xC5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x45"],
        ["\x65\x45",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xC5"],

        ["\xE5\xC6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x46"],
        ["\x65\x46",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xC6"],

        ["\xE5\xC7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x47"],
        ["\x65\x47",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xC7"],

        ["\xE5\xC8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x48"],
        ["\x65\x48",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xC8"],

        ["\xE5\xC9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x49"],
        ["\x65\x49",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xC9"],

        ["\xE5\xCA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x4A"],
        ["\x65\x4A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xCA"],

        ["\xE5\xCB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x4B"],
        ["\x65\x4B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xCB"],

        ["\xE5\xCC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x4C"],
        ["\x65\x4C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xCC"],

        ["\xE5\xCD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x4D"],
        ["\x65\x4D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xCD"],

        ["\xE5\xCE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x4E"],
        ["\x65\x4E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xCE"],

        ["\xE5\xCF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x4F"],
        ["\x65\x4F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xCF"],

        ["\xE5\xD0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x50"],
        ["\x65\x50",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xD0"],

        ["\xE5\xD1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x51"],
        ["\x65\x51",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xD1"],

        ["\xE5\xD2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x52"],
        ["\x65\x52",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xD2"],

        ["\xE5\xD3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x53"],
        ["\x65\x53",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xD3"],

        ["\xE5\xD4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x54"],
        ["\x65\x54",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xD4"],

        ["\xE5\xD5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x55"],
        ["\x65\x55",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xD5"],

        ["\xE5\xD6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x56"],
        ["\x65\x56",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xD6"],

        ["\xE5\xD7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x57"],
        ["\x65\x57",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xD7"],

        ["\xE5\xD8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x58"],
        ["\x65\x58",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xD8"],

        ["\xE5\xD9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x59"],
        ["\x65\x59",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xD9"],

        ["\xE5\xDA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x5A"],
        ["\x65\x5A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xDA"],

        ["\xE5\xDB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x5B"],
        ["\x65\x5B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xDB"],

        ["\xE5\xDC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x5C"],
        ["\x65\x5C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xDC"],

        ["\xE5\xDD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x5D"],
        ["\x65\x5D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xDD"],

        ["\xE5\xDE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x5E"],
        ["\x65\x5E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xDE"],

        ["\xE5\xDF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x5F"],
        ["\x65\x5F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xDF"],

        ["\xE5\xE0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x60"],
        ["\x65\x60",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xE0"],

        ["\xE5\xE1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x61"],
        ["\x65\x61",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xE1"],

        ["\xE5\xE2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x62"],
        ["\x65\x62",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xE2"],

        ["\xE5\xE3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x63"],
        ["\x65\x63",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xE3"],

        ["\xE5\xE4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x64"],
        ["\x65\x64",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xE4"],

        ["\xE5\xE5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x65"],
        ["\x65\x65",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xE5"],

        ["\xE5\xE6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x66"],
        ["\x65\x66",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xE6"],

        ["\xE5\xE7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x67"],
        ["\x65\x67",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xE7"],

        ["\xE5\xE8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x68"],
        ["\x65\x68",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xE8"],

        ["\xE5\xE9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x69"],
        ["\x65\x69",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xE9"],

        ["\xE5\xEA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x6A"],
        ["\x65\x6A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xEA"],

        ["\xE5\xEB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x6B"],
        ["\x65\x6B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xEB"],

        ["\xE5\xEC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x6C"],
        ["\x65\x6C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xEC"],

        ["\xE5\xED",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x6D"],
        ["\x65\x6D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xED"],

        ["\xE5\xEE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x6E"],
        ["\x65\x6E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xEE"],

        ["\xE5\xEF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x6F"],
        ["\x65\x6F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xEF"],

        ["\xE5\xF0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x70"],
        ["\x65\x70",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xF0"],

        ["\xE5\xF1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x71"],
        ["\x65\x71",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xF1"],

        ["\xE5\xF2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x72"],
        ["\x65\x72",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xF2"],

        ["\xE5\xF3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x73"],
        ["\x65\x73",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xF3"],

        ["\xE5\xF4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x74"],
        ["\x65\x74",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xF4"],

        ["\xE5\xF5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x75"],
        ["\x65\x75",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xF5"],

        ["\xE5\xF6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x76"],
        ["\x65\x76",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xF6"],

        ["\xE5\xF7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x77"],
        ["\x65\x77",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xF7"],

        ["\xE5\xF8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x78"],
        ["\x65\x78",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xF8"],

        ["\xE5\xF9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x79"],
        ["\x65\x79",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xF9"],

        ["\xE5\xFA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x7A"],
        ["\x65\x7A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xFA"],

        ["\xE5\xFB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x7B"],
        ["\x65\x7B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xFB"],

        ["\xE5\xFC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x7C"],
        ["\x65\x7C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xFC"],

        ["\xE5\xFD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x7D"],
        ["\x65\x7D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xFD"],

        ["\xE5\xFE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x65\x7E"],
        ["\x65\x7E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xFE"],

        ["\xE6\xA1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x21"],
        ["\x66\x21",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1"],

        ["\xE6\xA2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x22"],
        ["\x66\x22",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2"],

        ["\xE6\xA3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x23"],
        ["\x66\x23",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3"],

        ["\xE6\xA4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x24"],
        ["\x66\x24",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4"],

        ["\xE6\xA5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x25"],
        ["\x66\x25",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5"],

        ["\xE6\xA6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x26"],
        ["\x66\x26",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6"],

        ["\xE6\xA7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x27"],
        ["\x66\x27",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7"],

        ["\xE6\xA8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x28"],
        ["\x66\x28",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8"],

        ["\xE6\xA9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x29"],
        ["\x66\x29",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9"],

        ["\xE6\xAA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x2A"],
        ["\x66\x2A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA"],

        ["\xE6\xAB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x2B"],
        ["\x66\x2B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB"],

        ["\xE6\xAC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x2C"],
        ["\x66\x2C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC"],

        ["\xE6\xAD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x2D"],
        ["\x66\x2D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD"],

        ["\xE6\xAE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x2E"],
        ["\x66\x2E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE"],

        ["\xE6\xAF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x2F"],
        ["\x66\x2F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF"],

        ["\xE6\xB0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x30"],
        ["\x66\x30",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0"],

        ["\xE6\xB1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x31"],
        ["\x66\x31",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1"],

        ["\xE6\xB2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x32"],
        ["\x66\x32",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2"],

        ["\xE6\xB3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x33"],
        ["\x66\x33",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3"],

        ["\xE6\xB4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x34"],
        ["\x66\x34",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4"],

        ["\xE6\xB5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x35"],
        ["\x66\x35",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5"],

        ["\xE6\xB6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x36"],
        ["\x66\x36",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6"],

        ["\xE6\xB7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x37"],
        ["\x66\x37",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7"],

        ["\xE6\xB8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x38"],
        ["\x66\x38",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8"],

        ["\xE6\xB9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x39"],
        ["\x66\x39",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9"],

        ["\xE6\xBA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x3A"],
        ["\x66\x3A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA"],

        ["\xE6\xBB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x3B"],
        ["\x66\x3B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB"],

        ["\xE6\xBC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x3C"],
        ["\x66\x3C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC"],

        ["\xE6\xBD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x3D"],
        ["\x66\x3D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD"],

        ["\xE6\xBE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x3E"],
        ["\x66\x3E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE"],

        ["\xE6\xBF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x3F"],
        ["\x66\x3F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF"],

        ["\xE6\xC0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x40"],
        ["\x66\x40",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xC0"],

        ["\xE6\xC1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x41"],
        ["\x66\x41",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xC1"],

        ["\xE6\xC2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x42"],
        ["\x66\x42",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xC2"],

        ["\xE6\xC3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x43"],
        ["\x66\x43",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xC3"],

        ["\xE6\xC4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x44"],
        ["\x66\x44",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xC4"],

        ["\xE6\xC5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x45"],
        ["\x66\x45",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xC5"],

        ["\xE6\xC6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x46"],
        ["\x66\x46",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xC6"],

        ["\xE6\xC7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x47"],
        ["\x66\x47",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xC7"],

        ["\xE6\xC8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x48"],
        ["\x66\x48",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xC8"],

        ["\xE6\xC9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x49"],
        ["\x66\x49",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xC9"],

        ["\xE6\xCA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x4A"],
        ["\x66\x4A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xCA"],

        ["\xE6\xCB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x4B"],
        ["\x66\x4B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xCB"],

        ["\xE6\xCC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x4C"],
        ["\x66\x4C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xCC"],

        ["\xE6\xCD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x4D"],
        ["\x66\x4D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xCD"],

        ["\xE6\xCE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x4E"],
        ["\x66\x4E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xCE"],

        ["\xE6\xCF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x4F"],
        ["\x66\x4F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xCF"],

        ["\xE6\xD0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x50"],
        ["\x66\x50",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xD0"],

        ["\xE6\xD1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x51"],
        ["\x66\x51",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xD1"],

        ["\xE6\xD2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x52"],
        ["\x66\x52",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xD2"],

        ["\xE6\xD3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x53"],
        ["\x66\x53",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xD3"],

        ["\xE6\xD4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x54"],
        ["\x66\x54",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xD4"],

        ["\xE6\xD5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x55"],
        ["\x66\x55",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xD5"],

        ["\xE6\xD6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x56"],
        ["\x66\x56",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xD6"],

        ["\xE6\xD7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x57"],
        ["\x66\x57",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xD7"],

        ["\xE6\xD8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x58"],
        ["\x66\x58",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xD8"],

        ["\xE6\xD9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x59"],
        ["\x66\x59",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xD9"],

        ["\xE6\xDA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x5A"],
        ["\x66\x5A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xDA"],

        ["\xE6\xDB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x5B"],
        ["\x66\x5B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xDB"],

        ["\xE6\xDC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x5C"],
        ["\x66\x5C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xDC"],

        ["\xE6\xDD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x5D"],
        ["\x66\x5D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xDD"],

        ["\xE6\xDE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x5E"],
        ["\x66\x5E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xDE"],

        ["\xE6\xDF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x5F"],
        ["\x66\x5F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xDF"],

        ["\xE6\xE0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x60"],
        ["\x66\x60",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xE0"],

        ["\xE6\xE1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x61"],
        ["\x66\x61",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xE1"],

        ["\xE6\xE2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x62"],
        ["\x66\x62",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xE2"],

        ["\xE6\xE3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x63"],
        ["\x66\x63",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xE3"],

        ["\xE6\xE4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x64"],
        ["\x66\x64",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xE4"],

        ["\xE6\xE5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x65"],
        ["\x66\x65",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xE5"],

        ["\xE6\xE6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x66"],
        ["\x66\x66",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xE6"],

        ["\xE6\xE7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x67"],
        ["\x66\x67",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xE7"],

        ["\xE6\xE8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x68"],
        ["\x66\x68",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xE8"],

        ["\xE6\xE9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x69"],
        ["\x66\x69",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xE9"],

        ["\xE6\xEA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x6A"],
        ["\x66\x6A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xEA"],

        ["\xE6\xEB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x6B"],
        ["\x66\x6B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xEB"],

        ["\xE6\xEC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x6C"],
        ["\x66\x6C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xEC"],

        ["\xE6\xED",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x6D"],
        ["\x66\x6D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xED"],

        ["\xE6\xEE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x6E"],
        ["\x66\x6E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xEE"],

        ["\xE6\xEF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x6F"],
        ["\x66\x6F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xEF"],

        ["\xE6\xF0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x70"],
        ["\x66\x70",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xF0"],

        ["\xE6\xF1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x71"],
        ["\x66\x71",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xF1"],

        ["\xE6\xF2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x72"],
        ["\x66\x72",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xF2"],

        ["\xE6\xF3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x73"],
        ["\x66\x73",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xF3"],

        ["\xE6\xF4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x74"],
        ["\x66\x74",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xF4"],

        ["\xE6\xF5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x75"],
        ["\x66\x75",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xF5"],

        ["\xE6\xF6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x76"],
        ["\x66\x76",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xF6"],

        ["\xE6\xF7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x77"],
        ["\x66\x77",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xF7"],

        ["\xE6\xF8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x78"],
        ["\x66\x78",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xF8"],

        ["\xE6\xF9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x79"],
        ["\x66\x79",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xF9"],

        ["\xE6\xFA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x7A"],
        ["\x66\x7A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xFA"],

        ["\xE6\xFB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x7B"],
        ["\x66\x7B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xFB"],

        ["\xE6\xFC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x7C"],
        ["\x66\x7C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xFC"],

        ["\xE6\xFD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x7D"],
        ["\x66\x7D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xFD"],

        ["\xE6\xFE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x66\x7E"],
        ["\x66\x7E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xFE"],

        ["\xE7\xA1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x21"],
        ["\x67\x21",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1"],

        ["\xE7\xA2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x22"],
        ["\x67\x22",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2"],

        ["\xE7\xA3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x23"],
        ["\x67\x23",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3"],

        ["\xE7\xA4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x24"],
        ["\x67\x24",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4"],

        ["\xE7\xA5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x25"],
        ["\x67\x25",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5"],

        ["\xE7\xA6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x26"],
        ["\x67\x26",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6"],

        ["\xE7\xA7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x27"],
        ["\x67\x27",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7"],

        ["\xE7\xA8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x28"],
        ["\x67\x28",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8"],

        ["\xE7\xA9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x29"],
        ["\x67\x29",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9"],

        ["\xE7\xAA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x2A"],
        ["\x67\x2A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA"],

        ["\xE7\xAB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x2B"],
        ["\x67\x2B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB"],

        ["\xE7\xAC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x2C"],
        ["\x67\x2C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC"],

        ["\xE7\xAD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x2D"],
        ["\x67\x2D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD"],

        ["\xE7\xAE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x2E"],
        ["\x67\x2E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE"],

        ["\xE7\xAF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x2F"],
        ["\x67\x2F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF"],

        ["\xE7\xB0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x30"],
        ["\x67\x30",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0"],

        ["\xE7\xB1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x31"],
        ["\x67\x31",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1"],

        ["\xE7\xB2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x32"],
        ["\x67\x32",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2"],

        ["\xE7\xB3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x33"],
        ["\x67\x33",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3"],

        ["\xE7\xB4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x34"],
        ["\x67\x34",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4"],

        ["\xE7\xB5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x35"],
        ["\x67\x35",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5"],

        ["\xE7\xB6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x36"],
        ["\x67\x36",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6"],

        ["\xE7\xB7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x37"],
        ["\x67\x37",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7"],

        ["\xE7\xB8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x38"],
        ["\x67\x38",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8"],

        ["\xE7\xB9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x39"],
        ["\x67\x39",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9"],

        ["\xE7\xBA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x3A"],
        ["\x67\x3A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA"],

        ["\xE7\xBB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x3B"],
        ["\x67\x3B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xBB"],

        ["\xE7\xBC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x3C"],
        ["\x67\x3C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xBC"],

        ["\xE7\xBD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x3D"],
        ["\x67\x3D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD"],

        ["\xE7\xBE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x3E"],
        ["\x67\x3E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE"],

        ["\xE7\xBF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x3F"],
        ["\x67\x3F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF"],

        ["\xE7\xC0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x40"],
        ["\x67\x40",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xC0"],

        ["\xE7\xC1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x41"],
        ["\x67\x41",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xC1"],

        ["\xE7\xC2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x42"],
        ["\x67\x42",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xC2"],

        ["\xE7\xC3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x43"],
        ["\x67\x43",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xC3"],

        ["\xE7\xC4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x44"],
        ["\x67\x44",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xC4"],

        ["\xE7\xC5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x45"],
        ["\x67\x45",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xC5"],

        ["\xE7\xC6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x46"],
        ["\x67\x46",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xC6"],

        ["\xE7\xC7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x47"],
        ["\x67\x47",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xC7"],

        ["\xE7\xC8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x48"],
        ["\x67\x48",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xC8"],

        ["\xE7\xC9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x49"],
        ["\x67\x49",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xC9"],

        ["\xE7\xCA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x4A"],
        ["\x67\x4A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xCA"],

        ["\xE7\xCB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x4B"],
        ["\x67\x4B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xCB"],

        ["\xE7\xCC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x4C"],
        ["\x67\x4C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xCC"],

        ["\xE7\xCD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x4D"],
        ["\x67\x4D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xCD"],

        ["\xE7\xCE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x4E"],
        ["\x67\x4E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xCE"],

        ["\xE7\xCF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x4F"],
        ["\x67\x4F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xCF"],

        ["\xE7\xD0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x50"],
        ["\x67\x50",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xD0"],

        ["\xE7\xD1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x51"],
        ["\x67\x51",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xD1"],

        ["\xE7\xD2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x52"],
        ["\x67\x52",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xD2"],

        ["\xE7\xD3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x53"],
        ["\x67\x53",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xD3"],

        ["\xE7\xD4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x54"],
        ["\x67\x54",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xD4"],

        ["\xE7\xD5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x55"],
        ["\x67\x55",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xD5"],

        ["\xE7\xD6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x56"],
        ["\x67\x56",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xD6"],

        ["\xE7\xD7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x57"],
        ["\x67\x57",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xD7"],

        ["\xE7\xD8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x58"],
        ["\x67\x58",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xD8"],

        ["\xE7\xD9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x59"],
        ["\x67\x59",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xD9"],

        ["\xE7\xDA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x5A"],
        ["\x67\x5A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xDA"],

        ["\xE7\xDB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x5B"],
        ["\x67\x5B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xDB"],

        ["\xE7\xDC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x5C"],
        ["\x67\x5C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xDC"],

        ["\xE7\xDD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x5D"],
        ["\x67\x5D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xDD"],

        ["\xE7\xDE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x5E"],
        ["\x67\x5E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xDE"],

        ["\xE7\xDF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x5F"],
        ["\x67\x5F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xDF"],

        ["\xE7\xE0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x60"],
        ["\x67\x60",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xE0"],

        ["\xE7\xE1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x61"],
        ["\x67\x61",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xE1"],

        ["\xE7\xE2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x62"],
        ["\x67\x62",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xE2"],

        ["\xE7\xE3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x63"],
        ["\x67\x63",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xE3"],

        ["\xE7\xE4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x64"],
        ["\x67\x64",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xE4"],

        ["\xE7\xE5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x65"],
        ["\x67\x65",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xE5"],

        ["\xE7\xE6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x66"],
        ["\x67\x66",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xE6"],

        ["\xE7\xE7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x67"],
        ["\x67\x67",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xE7"],

        ["\xE7\xE8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x68"],
        ["\x67\x68",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xE8"],

        ["\xE7\xE9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x69"],
        ["\x67\x69",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xE9"],

        ["\xE7\xEA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x6A"],
        ["\x67\x6A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xEA"],

        ["\xE7\xEB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x6B"],
        ["\x67\x6B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xEB"],

        ["\xE7\xEC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x6C"],
        ["\x67\x6C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xEC"],

        ["\xE7\xED",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x6D"],
        ["\x67\x6D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xED"],

        ["\xE7\xEE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x6E"],
        ["\x67\x6E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xEE"],

        ["\xE7\xEF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x6F"],
        ["\x67\x6F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xEF"],

        ["\xE7\xF0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x70"],
        ["\x67\x70",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xF0"],

        ["\xE7\xF1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x71"],
        ["\x67\x71",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xF1"],

        ["\xE7\xF2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x72"],
        ["\x67\x72",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xF2"],

        ["\xE7\xF3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x73"],
        ["\x67\x73",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xF3"],

        ["\xE7\xF4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x74"],
        ["\x67\x74",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xF4"],

        ["\xE7\xF5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x75"],
        ["\x67\x75",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xF5"],

        ["\xE7\xF6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x76"],
        ["\x67\x76",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xF6"],

        ["\xE7\xF7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x77"],
        ["\x67\x77",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xF7"],

        ["\xE7\xF8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x78"],
        ["\x67\x78",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xF8"],

        ["\xE7\xF9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x79"],
        ["\x67\x79",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xF9"],

        ["\xE7\xFA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x7A"],
        ["\x67\x7A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xFA"],

        ["\xE7\xFB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x7B"],
        ["\x67\x7B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xFB"],

        ["\xE7\xFC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x7C"],
        ["\x67\x7C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xFC"],

        ["\xE7\xFD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x7D"],
        ["\x67\x7D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xFD"],

        ["\xE7\xFE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x67\x7E"],
        ["\x67\x7E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xFE"],

        ["\xE8\xA1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x21"],
        ["\x68\x21",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1"],

        ["\xE8\xA2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x22"],
        ["\x68\x22",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2"],

        ["\xE8\xA3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x23"],
        ["\x68\x23",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3"],

        ["\xE8\xA4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x24"],
        ["\x68\x24",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4"],

        ["\xE8\xA5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x25"],
        ["\x68\x25",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5"],

        ["\xE8\xA6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x26"],
        ["\x68\x26",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6"],

        ["\xE8\xA7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x27"],
        ["\x68\x27",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7"],

        ["\xE8\xA8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x28"],
        ["\x68\x28",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8"],

        ["\xE8\xA9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x29"],
        ["\x68\x29",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9"],

        ["\xE8\xAA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x2A"],
        ["\x68\x2A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA"],

        ["\xE8\xAB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x2B"],
        ["\x68\x2B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB"],

        ["\xE8\xAC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x2C"],
        ["\x68\x2C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC"],

        ["\xE8\xAD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x2D"],
        ["\x68\x2D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD"],

        ["\xE8\xAE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x2E"],
        ["\x68\x2E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE"],

        ["\xE8\xAF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x2F"],
        ["\x68\x2F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xAF"],

        ["\xE8\xB0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x30"],
        ["\x68\x30",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xB0"],

        ["\xE8\xB1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x31"],
        ["\x68\x31",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1"],

        ["\xE8\xB2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x32"],
        ["\x68\x32",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2"],

        ["\xE8\xB3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x33"],
        ["\x68\x33",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3"],

        ["\xE8\xB4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x34"],
        ["\x68\x34",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4"],

        ["\xE8\xB5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x35"],
        ["\x68\x35",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xB5"],

        ["\xE8\xB6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x36"],
        ["\x68\x36",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xB6"],

        ["\xE8\xB7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x37"],
        ["\x68\x37",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7"],

        ["\xE8\xB8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x38"],
        ["\x68\x38",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8"],

        ["\xE8\xB9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x39"],
        ["\x68\x39",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9"],

        ["\xE8\xBA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x3A"],
        ["\x68\x3A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA"],

        ["\xE8\xBB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x3B"],
        ["\x68\x3B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB"],

        ["\xE8\xBC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x3C"],
        ["\x68\x3C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC"],

        ["\xE8\xBD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x3D"],
        ["\x68\x3D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD"],

        ["\xE8\xBE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x3E"],
        ["\x68\x3E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE"],

        ["\xE8\xBF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x3F"],
        ["\x68\x3F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF"],

        ["\xE8\xC0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x40"],
        ["\x68\x40",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xC0"],

        ["\xE8\xC1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x41"],
        ["\x68\x41",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xC1"],

        ["\xE8\xC2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x42"],
        ["\x68\x42",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xC2"],

        ["\xE8\xC3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x43"],
        ["\x68\x43",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xC3"],

        ["\xE8\xC4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x44"],
        ["\x68\x44",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xC4"],

        ["\xE8\xC5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x45"],
        ["\x68\x45",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xC5"],

        ["\xE8\xC6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x46"],
        ["\x68\x46",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xC6"],

        ["\xE8\xC7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x47"],
        ["\x68\x47",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xC7"],

        ["\xE8\xC8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x48"],
        ["\x68\x48",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xC8"],

        ["\xE8\xC9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x49"],
        ["\x68\x49",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xC9"],

        ["\xE8\xCA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x4A"],
        ["\x68\x4A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xCA"],

        ["\xE8\xCB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x4B"],
        ["\x68\x4B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xCB"],

        ["\xE8\xCC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x4C"],
        ["\x68\x4C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xCC"],

        ["\xE8\xCD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x4D"],
        ["\x68\x4D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xCD"],

        ["\xE8\xCE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x4E"],
        ["\x68\x4E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xCE"],

        ["\xE8\xCF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x4F"],
        ["\x68\x4F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xCF"],

        ["\xE8\xD0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x50"],
        ["\x68\x50",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xD0"],

        ["\xE8\xD1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x51"],
        ["\x68\x51",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xD1"],

        ["\xE8\xD2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x52"],
        ["\x68\x52",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xD2"],

        ["\xE8\xD3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x53"],
        ["\x68\x53",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xD3"],

        ["\xE8\xD4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x54"],
        ["\x68\x54",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xD4"],

        ["\xE8\xD5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x55"],
        ["\x68\x55",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xD5"],

        ["\xE8\xD6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x56"],
        ["\x68\x56",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xD6"],

        ["\xE8\xD7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x57"],
        ["\x68\x57",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xD7"],

        ["\xE8\xD8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x58"],
        ["\x68\x58",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xD8"],

        ["\xE8\xD9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x59"],
        ["\x68\x59",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xD9"],

        ["\xE8\xDA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x5A"],
        ["\x68\x5A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xDA"],

        ["\xE8\xDB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x5B"],
        ["\x68\x5B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xDB"],

        ["\xE8\xDC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x5C"],
        ["\x68\x5C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xDC"],

        ["\xE8\xDD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x5D"],
        ["\x68\x5D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xDD"],

        ["\xE8\xDE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x5E"],
        ["\x68\x5E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xDE"],

        ["\xE8\xDF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x5F"],
        ["\x68\x5F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xDF"],

        ["\xE8\xE0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x60"],
        ["\x68\x60",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xE0"],

        ["\xE8\xE1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x61"],
        ["\x68\x61",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xE1"],

        ["\xE8\xE2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x62"],
        ["\x68\x62",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xE2"],

        ["\xE8\xE3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x63"],
        ["\x68\x63",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xE3"],

        ["\xE8\xE4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x64"],
        ["\x68\x64",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xE4"],

        ["\xE8\xE5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x65"],
        ["\x68\x65",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xE5"],

        ["\xE8\xE6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x66"],
        ["\x68\x66",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xE6"],

        ["\xE8\xE7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x67"],
        ["\x68\x67",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xE7"],

        ["\xE8\xE8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x68"],
        ["\x68\x68",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xE8"],

        ["\xE8\xE9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x69"],
        ["\x68\x69",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xE9"],

        ["\xE8\xEA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x6A"],
        ["\x68\x6A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xEA"],

        ["\xE8\xEB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x6B"],
        ["\x68\x6B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xEB"],

        ["\xE8\xEC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x6C"],
        ["\x68\x6C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xEC"],

        ["\xE8\xED",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x6D"],
        ["\x68\x6D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xED"],

        ["\xE8\xEE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x6E"],
        ["\x68\x6E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xEE"],

        ["\xE8\xEF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x6F"],
        ["\x68\x6F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xEF"],

        ["\xE8\xF0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x70"],
        ["\x68\x70",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xF0"],

        ["\xE8\xF1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x71"],
        ["\x68\x71",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xF1"],

        ["\xE8\xF2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x72"],
        ["\x68\x72",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xF2"],

        ["\xE8\xF3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x73"],
        ["\x68\x73",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xF3"],

        ["\xE8\xF4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x74"],
        ["\x68\x74",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xF4"],

        ["\xE8\xF5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x75"],
        ["\x68\x75",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xF5"],

        ["\xE8\xF6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x76"],
        ["\x68\x76",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xF6"],

        ["\xE8\xF7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x77"],
        ["\x68\x77",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xF7"],

        ["\xE8\xF8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x78"],
        ["\x68\x78",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xF8"],

        ["\xE8\xF9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x79"],
        ["\x68\x79",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xF9"],

        ["\xE8\xFA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x7A"],
        ["\x68\x7A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xFA"],

        ["\xE8\xFB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x7B"],
        ["\x68\x7B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xFB"],

        ["\xE8\xFC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x7C"],
        ["\x68\x7C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xFC"],

        ["\xE8\xFD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x7D"],
        ["\x68\x7D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xFD"],

        ["\xE8\xFE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x68\x7E"],
        ["\x68\x7E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xFE"],

        ["\xE9\xA1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x21"],
        ["\x69\x21",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1"],

        ["\xE9\xA2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3C\x49"],
        ["\x3C\x49",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xA2"],

        ["\xE9\xA3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x23"],
        ["\x69\x23",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3"],

        ["\xE9\xA4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x24"],
        ["\x69\x24",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4"],

        ["\xE9\xA5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x25"],
        ["\x69\x25",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xA5"],

        ["\xE9\xA6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x26"],
        ["\x69\x26",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xA6"],

        ["\xE9\xA7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x27"],
        ["\x69\x27",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7"],

        ["\xE9\xA8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x28"],
        ["\x69\x28",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8"],

        ["\xE9\xA9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x29"],
        ["\x69\x29",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9"],

        ["\xE9\xAA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x2A"],
        ["\x69\x2A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xAA"],

        ["\xE9\xAB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x2B"],
        ["\x69\x2B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB"],

        ["\xE9\xAC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x2C"],
        ["\x69\x2C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC"],

        ["\xE9\xAD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x2D"],
        ["\x69\x2D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD"],

        ["\xE9\xAE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4C\x79"],
        ["\x4C\x79",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE"],

        ["\xE9\xAF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x2F"],
        ["\x69\x2F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF"],

        ["\xE9\xB0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x30"],
        ["\x69\x30",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0"],

        ["\xE9\xB1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x31"],
        ["\x69\x31",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1"],

        ["\xE9\xB2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x32"],
        ["\x69\x32",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xB2"],

        ["\xE9\xB3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x33"],
        ["\x69\x33",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xB3"],

        ["\xE9\xB4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x34"],
        ["\x69\x34",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4"],

        ["\xE9\xB5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x35"],
        ["\x69\x35",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5"],

        ["\xE9\xB6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x36"],
        ["\x69\x36",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6"],

        ["\xE9\xB7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x37"],
        ["\x69\x37",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7"],

        ["\xE9\xB8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x38"],
        ["\x69\x38",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xB8"],

        ["\xE9\xB9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x39"],
        ["\x69\x39",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xB9"],

        ["\xE9\xBA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x3A"],
        ["\x69\x3A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA"],

        ["\xE9\xBB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x3B"],
        ["\x69\x3B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB"],

        ["\xE9\xBC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x3C"],
        ["\x69\x3C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xBC"],

        ["\xE9\xBD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x3D"],
        ["\x69\x3D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD"],

        ["\xE9\xBE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x3E"],
        ["\x69\x3E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xBE"],

        ["\xE9\xBF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x3F"],
        ["\x69\x3F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xBF"],

        ["\xE9\xC0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x40"],
        ["\x69\x40",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xC0"],

        ["\xE9\xC1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x41"],
        ["\x69\x41",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xC1"],

        ["\xE9\xC2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x42"],
        ["\x69\x42",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xC2"],

        ["\xE9\xC3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x43"],
        ["\x69\x43",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xC3"],

        ["\xE9\xC4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x44"],
        ["\x69\x44",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xC4"],

        ["\xE9\xC5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x45"],
        ["\x69\x45",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xC5"],

        ["\xE9\xC6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x46"],
        ["\x69\x46",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xC6"],

        ["\xE9\xC7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x47"],
        ["\x69\x47",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xC7"],

        ["\xE9\xC8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x48"],
        ["\x69\x48",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xC8"],

        ["\xE9\xC9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x49"],
        ["\x69\x49",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xC9"],

        ["\xE9\xCA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x4A"],
        ["\x69\x4A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xCA"],

        ["\xE9\xCB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x4B"],
        ["\x69\x4B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xCB"],

        ["\xE9\xCC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x4C"],
        ["\x69\x4C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xCC"],

        ["\xE9\xCD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x4D"],
        ["\x69\x4D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xCD"],

        ["\xE9\xCE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x4E"],
        ["\x69\x4E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xCE"],

        ["\xE9\xCF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x4F"],
        ["\x69\x4F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xCF"],

        ["\xE9\xD0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x50"],
        ["\x69\x50",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xD0"],

        ["\xE9\xD1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x51"],
        ["\x69\x51",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xD1"],

        ["\xE9\xD2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x52"],
        ["\x69\x52",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xD2"],

        ["\xE9\xD3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x53"],
        ["\x69\x53",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xD3"],

        ["\xE9\xD4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x54"],
        ["\x69\x54",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xD4"],

        ["\xE9\xD5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x55"],
        ["\x69\x55",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xD5"],

        ["\xE9\xD6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x56"],
        ["\x69\x56",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xD6"],

        ["\xE9\xD7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x57"],
        ["\x69\x57",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xD7"],

        ["\xE9\xD8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x58"],
        ["\x69\x58",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xD8"],

        ["\xE9\xD9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x59"],
        ["\x69\x59",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xD9"],

        ["\xE9\xDA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x33\x42"],
        ["\x33\x42",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xDA"],

        ["\xE9\xDB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x5B"],
        ["\x69\x5B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xDB"],

        ["\xE9\xDC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x5C"],
        ["\x69\x5C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xDC"],

        ["\xE9\xDD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x5D"],
        ["\x69\x5D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xDD"],

        ["\xE9\xDE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x5E"],
        ["\x69\x5E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xDE"],

        ["\xE9\xDF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x5F"],
        ["\x69\x5F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xDF"],

        ["\xE9\xE0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x60"],
        ["\x69\x60",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xE0"],

        ["\xE9\xE1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x61"],
        ["\x69\x61",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xE1"],

        ["\xE9\xE2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x62"],
        ["\x69\x62",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xE2"],

        ["\xE9\xE3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x63"],
        ["\x69\x63",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xE3"],

        ["\xE9\xE4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x64"],
        ["\x69\x64",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xE4"],

        ["\xE9\xE5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x65"],
        ["\x69\x65",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xE5"],

        ["\xE9\xE6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x66"],
        ["\x69\x66",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xE6"],

        ["\xE9\xE7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x67"],
        ["\x69\x67",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xE7"],

        ["\xE9\xE8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x68"],
        ["\x69\x68",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xE8"],

        ["\xE9\xE9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x69"],
        ["\x69\x69",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xE9"],

        ["\xE9\xEA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x6A"],
        ["\x69\x6A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xEA"],

        ["\xE9\xEB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x6B"],
        ["\x69\x6B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xEB"],

        ["\xE9\xEC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x6C"],
        ["\x69\x6C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xEC"],

        ["\xE9\xED",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x6D"],
        ["\x69\x6D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xED"],

        ["\xE9\xEE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x6E"],
        ["\x69\x6E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xEE"],

        ["\xE9\xEF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x6F"],
        ["\x69\x6F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xEF"],

        ["\xE9\xF0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x70"],
        ["\x69\x70",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xF0"],

        ["\xE9\xF1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x71"],
        ["\x69\x71",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xF1"],

        ["\xE9\xF2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x72"],
        ["\x69\x72",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xF2"],

        ["\xE9\xF3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x73"],
        ["\x69\x73",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xF3"],

        ["\xE9\xF4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x74"],
        ["\x69\x74",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xF4"],

        ["\xE9\xF5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x75"],
        ["\x69\x75",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xF5"],

        ["\xE9\xF6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x76"],
        ["\x69\x76",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xF6"],

        ["\xE9\xF7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x77"],
        ["\x69\x77",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xF7"],

        ["\xE9\xF8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x78"],
        ["\x69\x78",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xF8"],

        ["\xE9\xF9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x79"],
        ["\x69\x79",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xF9"],

        ["\xE9\xFA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x7A"],
        ["\x69\x7A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xFA"],

        ["\xE9\xFB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x7B"],
        ["\x69\x7B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xFB"],

        ["\xE9\xFC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x7C"],
        ["\x69\x7C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xFC"],

        ["\xE9\xFD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x7D"],
        ["\x69\x7D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xFD"],

        ["\xE9\xFE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x69\x7E"],
        ["\x69\x7E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xFE"],

        ["\xEA\xA1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6A\x21"],
        ["\x6A\x21",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xA1"],

        ["\xEA\xA2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6A\x22"],
        ["\x6A\x22",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xA2"],

        ["\xEA\xA3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6A\x23"],
        ["\x6A\x23",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xA3"],

        ["\xEA\xA4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x47\x68"],
        ["\x47\x68",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xA4"],

        ["\xEA\xA5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6A\x25"],
        ["\x6A\x25",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xA5"],

        ["\xEA\xA6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6A\x26"],
        ["\x6A\x26",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xA6"],

        ["\xEA\xA7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6A\x27"],
        ["\x6A\x27",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xA7"],

        ["\xEA\xA8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6A\x28"],
        ["\x6A\x28",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xA8"],

        ["\xEA\xA9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6A\x29"],
        ["\x6A\x29",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xA9"],

        ["\xEA\xAA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6A\x2A"],
        ["\x6A\x2A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xAA"],

        ["\xEA\xAB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6A\x2B"],
        ["\x6A\x2B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xAB"],

        ["\xEA\xAC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6A\x2C"],
        ["\x6A\x2C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xAC"],

        ["\xEA\xAD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6A\x2D"],
        ["\x6A\x2D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xAD"],

        ["\xEA\xAE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6A\x2E"],
        ["\x6A\x2E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xAE"],

        ["\xEA\xAF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6A\x2F"],
        ["\x6A\x2F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xAF"],

        ["\xEA\xB0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6A\x30"],
        ["\x6A\x30",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xB0"],

        ["\xEA\xB1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6A\x31"],
        ["\x6A\x31",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xB1"],

        ["\xEA\xB2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6A\x32"],
        ["\x6A\x32",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xB2"],

        ["\xEA\xB3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6A\x33"],
        ["\x6A\x33",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xB3"],

        ["\xEA\xB4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6A\x34"],
        ["\x6A\x34",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xB4"],

        ["\xEA\xB5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6A\x35"],
        ["\x6A\x35",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xB5"],

        ["\xEA\xB6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6A\x36"],
        ["\x6A\x36",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xB6"],

        ["\xEA\xB7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6A\x37"],
        ["\x6A\x37",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xB7"],

        ["\xEA\xB8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6A\x38"],
        ["\x6A\x38",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xB8"],

        ["\xEA\xB9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6A\x39"],
        ["\x6A\x39",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xB9"],

        ["\xEA\xBA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6A\x3A"],
        ["\x6A\x3A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xBA"],

        ["\xEA\xBB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6A\x3B"],
        ["\x6A\x3B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xBB"],

        ["\xEA\xBC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6A\x3C"],
        ["\x6A\x3C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xBC"],

        ["\xEA\xBD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6A\x3D"],
        ["\x6A\x3D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xBD"],

        ["\xEA\xBE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6A\x3E"],
        ["\x6A\x3E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xBE"],

        ["\xEA\xBF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6A\x3F"],
        ["\x6A\x3F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xBF"],

        ["\xEA\xC0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6A\x40"],
        ["\x6A\x40",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xC0"],

        ["\xEA\xC1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6A\x41"],
        ["\x6A\x41",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xC1"],

        ["\xEA\xC2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6A\x42"],
        ["\x6A\x42",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xC2"],

        ["\xEA\xC3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6A\x43"],
        ["\x6A\x43",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xC3"],

        ["\xEA\xC4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6A\x44"],
        ["\x6A\x44",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xC4"],

        ["\xEA\xC5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6A\x45"],
        ["\x6A\x45",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xC5"],

        ["\xEA\xC6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6A\x46"],
        ["\x6A\x46",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xC6"],

        ["\xEA\xC7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6A\x47"],
        ["\x6A\x47",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xC7"],

        ["\xEA\xC8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6A\x48"],
        ["\x6A\x48",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xC8"],

        ["\xEA\xC9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6A\x49"],
        ["\x6A\x49",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xC9"],

        ["\xEA\xCA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6A\x4A"],
        ["\x6A\x4A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xCA"],

        ["\xEA\xCB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6A\x4B"],
        ["\x6A\x4B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xCB"],

        ["\xEA\xCC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6A\x4C"],
        ["\x6A\x4C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xCC"],

        ["\xEA\xCD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6A\x4D"],
        ["\x6A\x4D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xCD"],

        ["\xEA\xCE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6A\x4E"],
        ["\x6A\x4E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xCE"],

        ["\xEA\xCF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6A\x4F"],
        ["\x6A\x4F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xCF"],

        ["\xEA\xD0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6A\x50"],
        ["\x6A\x50",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xD0"],

        ["\xEA\xD1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6A\x51"],
        ["\x6A\x51",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xD1"],

        ["\xEA\xD2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6A\x52"],
        ["\x6A\x52",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xD2"],

        ["\xEA\xD3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6A\x53"],
        ["\x6A\x53",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xD3"],

        ["\xEA\xD4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6A\x54"],
        ["\x6A\x54",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xD4"],

        ["\xEA\xD5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6A\x55"],
        ["\x6A\x55",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xD5"],

        ["\xEA\xD6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6A\x56"],
        ["\x6A\x56",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xD6"],

        ["\xEA\xD7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6A\x57"],
        ["\x6A\x57",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xD7"],

        ["\xEA\xD8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6A\x58"],
        ["\x6A\x58",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xD8"],

        ["\xEA\xD9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6A\x59"],
        ["\x6A\x59",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xD9"],

        ["\xEA\xDA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6A\x5A"],
        ["\x6A\x5A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xDA"],

        ["\xEA\xDB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6A\x5B"],
        ["\x6A\x5B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xDB"],

        ["\xEA\xDC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6A\x5C"],
        ["\x6A\x5C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xDC"],

        ["\xEA\xDD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6A\x5D"],
        ["\x6A\x5D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xDD"],

        ["\xEA\xDE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6A\x5E"],
        ["\x6A\x5E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xDE"],

        ["\xEA\xDF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6A\x5F"],
        ["\x6A\x5F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xDF"],

        ["\xEA\xE0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6A\x60"],
        ["\x6A\x60",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xE0"],

        ["\xEA\xE1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6A\x61"],
        ["\x6A\x61",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xE1"],

        ["\xEA\xE2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6A\x62"],
        ["\x6A\x62",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xE2"],

        ["\xEA\xE3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6A\x63"],
        ["\x6A\x63",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xE3"],

        ["\xEA\xE4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6A\x64"],
        ["\x6A\x64",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xE4"],

        ["\xEA\xE5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6A\x65"],
        ["\x6A\x65",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xE5"],

        ["\xEA\xE6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6A\x66"],
        ["\x6A\x66",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xE6"],

        ["\xEA\xE7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6A\x67"],
        ["\x6A\x67",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xE7"],

        ["\xEA\xE8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6A\x68"],
        ["\x6A\x68",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xE8"],

        ["\xEA\xE9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6A\x69"],
        ["\x6A\x69",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xE9"],

        ["\xEA\xEA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6A\x6A"],
        ["\x6A\x6A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xEA"],

        ["\xEA\xEB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6A\x6B"],
        ["\x6A\x6B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xEB"],

        ["\xEA\xEC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6A\x6C"],
        ["\x6A\x6C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xEC"],

        ["\xEA\xED",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6A\x6D"],
        ["\x6A\x6D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xED"],

        ["\xEA\xEE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6A\x6E"],
        ["\x6A\x6E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xEE"],

        ["\xEA\xEF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6A\x6F"],
        ["\x6A\x6F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xEF"],

        ["\xEA\xF0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6A\x70"],
        ["\x6A\x70",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xF0"],

        ["\xEA\xF1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6A\x71"],
        ["\x6A\x71",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xF1"],

        ["\xEA\xF2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6A\x72"],
        ["\x6A\x72",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xF2"],

        ["\xEA\xF3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6A\x73"],
        ["\x6A\x73",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xF3"],

        ["\xEA\xF4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6A\x74"],
        ["\x6A\x74",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xF4"],

        ["\xEA\xF5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6A\x75"],
        ["\x6A\x75",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xF5"],

        ["\xEA\xF6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6A\x76"],
        ["\x6A\x76",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xF6"],

        ["\xEA\xF7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6A\x77"],
        ["\x6A\x77",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xF7"],

        ["\xEA\xF8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6A\x78"],
        ["\x6A\x78",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xF8"],

        ["\xEA\xF9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6A\x79"],
        ["\x6A\x79",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xF9"],

        ["\xEA\xFA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6A\x7A"],
        ["\x6A\x7A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xFA"],

        ["\xEA\xFB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6A\x7B"],
        ["\x6A\x7B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xFB"],

        ["\xEA\xFC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6A\x7C"],
        ["\x6A\x7C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xFC"],

        ["\xEA\xFD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6A\x7D"],
        ["\x6A\x7D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xFD"],

        ["\xEA\xFE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6A\x7E"],
        ["\x6A\x7E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\xFE"],

        ["\xEB\xA1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x21"],
        ["\x6B\x21",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xA1"],

        ["\xEB\xA2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x22"],
        ["\x6B\x22",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xA2"],

        ["\xEB\xA3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x23"],
        ["\x6B\x23",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xA3"],

        ["\xEB\xA4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x24"],
        ["\x6B\x24",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xA4"],

        ["\xEB\xA5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x25"],
        ["\x6B\x25",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xA5"],

        ["\xEB\xA6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x26"],
        ["\x6B\x26",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xA6"],

        ["\xEB\xA7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x27"],
        ["\x6B\x27",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xA7"],

        ["\xEB\xA8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x28"],
        ["\x6B\x28",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xA8"],

        ["\xEB\xA9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x29"],
        ["\x6B\x29",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xA9"],

        ["\xEB\xAA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x2A"],
        ["\x6B\x2A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xAA"],

        ["\xEB\xAB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x2B"],
        ["\x6B\x2B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xAB"],

        ["\xEB\xAC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x2C"],
        ["\x6B\x2C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xAC"],

        ["\xEB\xAD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x2D"],
        ["\x6B\x2D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xAD"],

        ["\xEB\xAE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x2E"],
        ["\x6B\x2E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xAE"],

        ["\xEB\xAF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x2F"],
        ["\x6B\x2F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xAF"],

        ["\xEB\xB0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x30"],
        ["\x6B\x30",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xB0"],

        ["\xEB\xB1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x31"],
        ["\x6B\x31",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xB1"],

        ["\xEB\xB2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x32"],
        ["\x6B\x32",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xB2"],

        ["\xEB\xB3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x33"],
        ["\x6B\x33",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xB3"],

        ["\xEB\xB4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x34"],
        ["\x6B\x34",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xB4"],

        ["\xEB\xB5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x35"],
        ["\x6B\x35",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xB5"],

        ["\xEB\xB6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x36"],
        ["\x6B\x36",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xB6"],

        ["\xEB\xB7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x37"],
        ["\x6B\x37",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xB7"],

        ["\xEB\xB8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x38"],
        ["\x6B\x38",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xB8"],

        ["\xEB\xB9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x39"],
        ["\x6B\x39",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xB9"],

        ["\xEB\xBA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x3A"],
        ["\x6B\x3A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xBA"],

        ["\xEB\xBB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x3B"],
        ["\x6B\x3B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xBB"],

        ["\xEB\xBC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x3C"],
        ["\x6B\x3C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xBC"],

        ["\xEB\xBD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x3D"],
        ["\x6B\x3D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xBD"],

        ["\xEB\xBE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x3E"],
        ["\x6B\x3E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xBE"],

        ["\xEB\xBF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x3F"],
        ["\x6B\x3F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xBF"],

        ["\xEB\xC0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x40"],
        ["\x6B\x40",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xC0"],

        ["\xEB\xC1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x41"],
        ["\x6B\x41",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xC1"],

        ["\xEB\xC2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x42"],
        ["\x6B\x42",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xC2"],

        ["\xEB\xC3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x43"],
        ["\x6B\x43",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xC3"],

        ["\xEB\xC4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x44"],
        ["\x6B\x44",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xC4"],

        ["\xEB\xC5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x45"],
        ["\x6B\x45",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xC5"],

        ["\xEB\xC6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x46"],
        ["\x6B\x46",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xC6"],

        ["\xEB\xC7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x47"],
        ["\x6B\x47",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xC7"],

        ["\xEB\xC8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x48"],
        ["\x6B\x48",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xC8"],

        ["\xEB\xC9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x49"],
        ["\x6B\x49",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xC9"],

        ["\xEB\xCA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x4A"],
        ["\x6B\x4A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xCA"],

        ["\xEB\xCB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x4B"],
        ["\x6B\x4B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xCB"],

        ["\xEB\xCC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x4C"],
        ["\x6B\x4C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xCC"],

        ["\xEB\xCD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x4D"],
        ["\x6B\x4D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xCD"],

        ["\xEB\xCE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x4E"],
        ["\x6B\x4E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xCE"],

        ["\xEB\xCF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x4F"],
        ["\x6B\x4F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xCF"],

        ["\xEB\xD0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x50"],
        ["\x6B\x50",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xD0"],

        ["\xEB\xD1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x51"],
        ["\x6B\x51",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xD1"],

        ["\xEB\xD2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x52"],
        ["\x6B\x52",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xD2"],

        ["\xEB\xD3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x53"],
        ["\x6B\x53",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xD3"],

        ["\xEB\xD4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x54"],
        ["\x6B\x54",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xD4"],

        ["\xEB\xD5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x55"],
        ["\x6B\x55",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xD5"],

        ["\xEB\xD6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x56"],
        ["\x6B\x56",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xD6"],

        ["\xEB\xD7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x57"],
        ["\x6B\x57",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xD7"],

        ["\xEB\xD8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x58"],
        ["\x6B\x58",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xD8"],

        ["\xEB\xD9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x59"],
        ["\x6B\x59",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xD9"],

        ["\xEB\xDA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x5A"],
        ["\x6B\x5A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xDA"],

        ["\xEB\xDB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x5B"],
        ["\x6B\x5B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xDB"],

        ["\xEB\xDC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x5C"],
        ["\x6B\x5C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xDC"],

        ["\xEB\xDD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x34\x52"],
        ["\x34\x52",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xDD"],

        ["\xEB\xDE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x5E"],
        ["\x6B\x5E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xDE"],

        ["\xEB\xDF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x5F"],
        ["\x6B\x5F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xDF"],

        ["\xEB\xE0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x60"],
        ["\x6B\x60",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xE0"],

        ["\xEB\xE1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x61"],
        ["\x6B\x61",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xE1"],

        ["\xEB\xE2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x62"],
        ["\x6B\x62",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xE2"],

        ["\xEB\xE3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x63"],
        ["\x6B\x63",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xE3"],

        ["\xEB\xE4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x64"],
        ["\x6B\x64",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xE4"],

        ["\xEB\xE5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x65"],
        ["\x6B\x65",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xE5"],

        ["\xEB\xE6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x66"],
        ["\x6B\x66",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xE6"],

        ["\xEB\xE7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x67"],
        ["\x6B\x67",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xE7"],

        ["\xEB\xE8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x68"],
        ["\x6B\x68",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xE8"],

        ["\xEB\xE9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x69"],
        ["\x6B\x69",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xE9"],

        ["\xEB\xEA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x6A"],
        ["\x6B\x6A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xEA"],

        ["\xEB\xEB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x6B"],
        ["\x6B\x6B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xEB"],

        ["\xEB\xEC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x6C"],
        ["\x6B\x6C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xEC"],

        ["\xEB\xED",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x6D"],
        ["\x6B\x6D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xED"],

        ["\xEB\xEE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x6E"],
        ["\x6B\x6E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xEE"],

        ["\xEB\xEF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x6F"],
        ["\x6B\x6F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xEF"],

        ["\xEB\xF0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x70"],
        ["\x6B\x70",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xF0"],

        ["\xEB\xF1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x71"],
        ["\x6B\x71",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xF1"],

        ["\xEB\xF2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x72"],
        ["\x6B\x72",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xF2"],

        ["\xEB\xF3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x73"],
        ["\x6B\x73",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xF3"],

        ["\xEB\xF4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x74"],
        ["\x6B\x74",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xF4"],

        ["\xEB\xF5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x75"],
        ["\x6B\x75",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xF5"],

        ["\xEB\xF6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x76"],
        ["\x6B\x76",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xF6"],

        ["\xEB\xF7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x77"],
        ["\x6B\x77",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xF7"],

        ["\xEB\xF8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x78"],
        ["\x6B\x78",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xF8"],

        ["\xEB\xF9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x79"],
        ["\x6B\x79",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xF9"],

        ["\xEB\xFA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x7A"],
        ["\x6B\x7A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xFA"],

        ["\xEB\xFB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x7B"],
        ["\x6B\x7B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xFB"],

        ["\xEB\xFC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x7C"],
        ["\x6B\x7C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xFC"],

        ["\xEB\xFD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x7D"],
        ["\x6B\x7D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xFD"],

        ["\xEB\xFE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6B\x7E"],
        ["\x6B\x7E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEB\xFE"],

        ["\xEC\xA1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x21"],
        ["\x6C\x21",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xA1"],

        ["\xEC\xA2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x22"],
        ["\x6C\x22",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xA2"],

        ["\xEC\xA3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x23"],
        ["\x6C\x23",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xA3"],

        ["\xEC\xA4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x24"],
        ["\x6C\x24",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xA4"],

        ["\xEC\xA5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x25"],
        ["\x6C\x25",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xA5"],

        ["\xEC\xA6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x26"],
        ["\x6C\x26",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xA6"],

        ["\xEC\xA7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x27"],
        ["\x6C\x27",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xA7"],

        ["\xEC\xA8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x28"],
        ["\x6C\x28",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xA8"],

        ["\xEC\xA9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x29"],
        ["\x6C\x29",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xA9"],

        ["\xEC\xAA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x2A"],
        ["\x6C\x2A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xAA"],

        ["\xEC\xAB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x2B"],
        ["\x6C\x2B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xAB"],

        ["\xEC\xAC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x2C"],
        ["\x6C\x2C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xAC"],

        ["\xEC\xAD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x2D"],
        ["\x6C\x2D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xAD"],

        ["\xEC\xAE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x2E"],
        ["\x6C\x2E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xAE"],

        ["\xEC\xAF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x2F"],
        ["\x6C\x2F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xAF"],

        ["\xEC\xB0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x30"],
        ["\x6C\x30",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xB0"],

        ["\xEC\xB1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x31"],
        ["\x6C\x31",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xB1"],

        ["\xEC\xB2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x32"],
        ["\x6C\x32",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xB2"],

        ["\xEC\xB3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x33"],
        ["\x6C\x33",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xB3"],

        ["\xEC\xB4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x34"],
        ["\x6C\x34",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xB4"],

        ["\xEC\xB5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x35"],
        ["\x6C\x35",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xB5"],

        ["\xEC\xB6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x36"],
        ["\x6C\x36",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xB6"],

        ["\xEC\xB7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x37"],
        ["\x6C\x37",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xB7"],

        ["\xEC\xB8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x38"],
        ["\x6C\x38",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xB8"],

        ["\xEC\xB9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x39"],
        ["\x6C\x39",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xB9"],

        ["\xEC\xBA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x3A"],
        ["\x6C\x3A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xBA"],

        ["\xEC\xBB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x3B"],
        ["\x6C\x3B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xBB"],

        ["\xEC\xBC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x3C"],
        ["\x6C\x3C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xBC"],

        ["\xEC\xBD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x3D"],
        ["\x6C\x3D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xBD"],

        ["\xEC\xBE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x3E"],
        ["\x6C\x3E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xBE"],

        ["\xEC\xBF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x3F"],
        ["\x6C\x3F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xBF"],

        ["\xEC\xC0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x40"],
        ["\x6C\x40",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xC0"],

        ["\xEC\xC1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x41"],
        ["\x6C\x41",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xC1"],

        ["\xEC\xC2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x42"],
        ["\x6C\x42",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xC2"],

        ["\xEC\xC3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x43"],
        ["\x6C\x43",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xC3"],

        ["\xEC\xC4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x44"],
        ["\x6C\x44",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xC4"],

        ["\xEC\xC5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x45"],
        ["\x6C\x45",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xC5"],

        ["\xEC\xC6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x46"],
        ["\x6C\x46",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xC6"],

        ["\xEC\xC7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x47"],
        ["\x6C\x47",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xC7"],

        ["\xEC\xC8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x48"],
        ["\x6C\x48",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xC8"],

        ["\xEC\xC9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x49"],
        ["\x6C\x49",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xC9"],

        ["\xEC\xCA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x4A"],
        ["\x6C\x4A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xCA"],

        ["\xEC\xCB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x4B"],
        ["\x6C\x4B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xCB"],

        ["\xEC\xCC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x4C"],
        ["\x6C\x4C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xCC"],

        ["\xEC\xCD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x41\x28"],
        ["\x41\x28",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xCD"],

        ["\xEC\xCE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x4E"],
        ["\x6C\x4E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xCE"],

        ["\xEC\xCF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x4F"],
        ["\x6C\x4F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xCF"],

        ["\xEC\xD0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x50"],
        ["\x6C\x50",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xD0"],

        ["\xEC\xD1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x51"],
        ["\x6C\x51",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xD1"],

        ["\xEC\xD2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x52"],
        ["\x6C\x52",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xD2"],

        ["\xEC\xD3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x53"],
        ["\x6C\x53",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xD3"],

        ["\xEC\xD4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x54"],
        ["\x6C\x54",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xD4"],

        ["\xEC\xD5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x55"],
        ["\x6C\x55",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xD5"],

        ["\xEC\xD6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x56"],
        ["\x6C\x56",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xD6"],

        ["\xEC\xD7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x57"],
        ["\x6C\x57",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xD7"],

        ["\xEC\xD8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x58"],
        ["\x6C\x58",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xD8"],

        ["\xEC\xD9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x59"],
        ["\x6C\x59",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xD9"],

        ["\xEC\xDA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x5A"],
        ["\x6C\x5A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xDA"],

        ["\xEC\xDB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x5B"],
        ["\x6C\x5B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xDB"],

        ["\xEC\xDC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x5C"],
        ["\x6C\x5C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xDC"],

        ["\xEC\xDD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x5D"],
        ["\x6C\x5D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xDD"],

        ["\xEC\xDE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x5E"],
        ["\x6C\x5E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xDE"],

        ["\xEC\xDF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x5F"],
        ["\x6C\x5F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xDF"],

        ["\xEC\xE0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x60"],
        ["\x6C\x60",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xE0"],

        ["\xEC\xE1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x61"],
        ["\x6C\x61",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xE1"],

        ["\xEC\xE2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x62"],
        ["\x6C\x62",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xE2"],

        ["\xEC\xE3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x63"],
        ["\x6C\x63",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xE3"],

        ["\xEC\xE4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x64"],
        ["\x6C\x64",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xE4"],

        ["\xEC\xE5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x65"],
        ["\x6C\x65",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xE5"],

        ["\xEC\xE6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x66"],
        ["\x6C\x66",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xE6"],

        ["\xEC\xE7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x67"],
        ["\x6C\x67",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xE7"],

        ["\xEC\xE8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x68"],
        ["\x6C\x68",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xE8"],

        ["\xEC\xE9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x69"],
        ["\x6C\x69",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xE9"],

        ["\xEC\xEA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x6A"],
        ["\x6C\x6A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xEA"],

        ["\xEC\xEB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x6B"],
        ["\x6C\x6B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xEB"],

        ["\xEC\xEC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x6C"],
        ["\x6C\x6C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xEC"],

        ["\xEC\xED",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x6D"],
        ["\x6C\x6D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xED"],

        ["\xEC\xEE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x6E"],
        ["\x6C\x6E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xEE"],

        ["\xEC\xEF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x6F"],
        ["\x6C\x6F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xEF"],

        ["\xEC\xF0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x70"],
        ["\x6C\x70",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xF0"],

        ["\xEC\xF1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x71"],
        ["\x6C\x71",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xF1"],

        ["\xEC\xF2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x72"],
        ["\x6C\x72",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xF2"],

        ["\xEC\xF3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x73"],
        ["\x6C\x73",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xF3"],

        ["\xEC\xF4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x74"],
        ["\x6C\x74",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xF4"],

        ["\xEC\xF5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x75"],
        ["\x6C\x75",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xF5"],

        ["\xEC\xF6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x76"],
        ["\x6C\x76",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xF6"],

        ["\xEC\xF7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x77"],
        ["\x6C\x77",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xF7"],

        ["\xEC\xF8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x78"],
        ["\x6C\x78",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xF8"],

        ["\xEC\xF9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x79"],
        ["\x6C\x79",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xF9"],

        ["\xEC\xFA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x7A"],
        ["\x6C\x7A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xFA"],

        ["\xEC\xFB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x7B"],
        ["\x6C\x7B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xFB"],

        ["\xEC\xFC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x7C"],
        ["\x6C\x7C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xFC"],

        ["\xEC\xFD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x7D"],
        ["\x6C\x7D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xFD"],

        ["\xEC\xFE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6C\x7E"],
        ["\x6C\x7E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEC\xFE"],

        ["\xED\xA1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x21"],
        ["\x6D\x21",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xA1"],

        ["\xED\xA2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x22"],
        ["\x6D\x22",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xA2"],

        ["\xED\xA3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x23"],
        ["\x6D\x23",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xA3"],

        ["\xED\xA4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x24"],
        ["\x6D\x24",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xA4"],

        ["\xED\xA5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x25"],
        ["\x6D\x25",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xA5"],

        ["\xED\xA6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x26"],
        ["\x6D\x26",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xA6"],

        ["\xED\xA7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x27"],
        ["\x6D\x27",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xA7"],

        ["\xED\xA8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x28"],
        ["\x6D\x28",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xA8"],

        ["\xED\xA9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x29"],
        ["\x6D\x29",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xA9"],

        ["\xED\xAA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x2A"],
        ["\x6D\x2A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xAA"],

        ["\xED\xAB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x2B"],
        ["\x6D\x2B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xAB"],

        ["\xED\xAC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x2C"],
        ["\x6D\x2C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xAC"],

        ["\xED\xAD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x2D"],
        ["\x6D\x2D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xAD"],

        ["\xED\xAE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x2E"],
        ["\x6D\x2E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xAE"],

        ["\xED\xAF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x2F"],
        ["\x6D\x2F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xAF"],

        ["\xED\xB0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x30"],
        ["\x6D\x30",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xB0"],

        ["\xED\xB1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x31"],
        ["\x6D\x31",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xB1"],

        ["\xED\xB2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x32"],
        ["\x6D\x32",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xB2"],

        ["\xED\xB3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x33"],
        ["\x6D\x33",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xB3"],

        ["\xED\xB4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x34"],
        ["\x6D\x34",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xB4"],

        ["\xED\xB5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x35"],
        ["\x6D\x35",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xB5"],

        ["\xED\xB6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x36"],
        ["\x6D\x36",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xB6"],

        ["\xED\xB7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x37"],
        ["\x6D\x37",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xB7"],

        ["\xED\xB8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x38"],
        ["\x6D\x38",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xB8"],

        ["\xED\xB9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x39"],
        ["\x6D\x39",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xB9"],

        ["\xED\xBA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x3A"],
        ["\x6D\x3A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xBA"],

        ["\xED\xBB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x3B"],
        ["\x6D\x3B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xBB"],

        ["\xED\xBC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x3C"],
        ["\x6D\x3C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xBC"],

        ["\xED\xBD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x3D"],
        ["\x6D\x3D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xBD"],

        ["\xED\xBE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x3E"],
        ["\x6D\x3E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xBE"],

        ["\xED\xBF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x3F"],
        ["\x6D\x3F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xBF"],

        ["\xED\xC0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x40"],
        ["\x6D\x40",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xC0"],

        ["\xED\xC1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x41"],
        ["\x6D\x41",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xC1"],

        ["\xED\xC2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x42"],
        ["\x6D\x42",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xC2"],

        ["\xED\xC3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x43"],
        ["\x6D\x43",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xC3"],

        ["\xED\xC4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x44"],
        ["\x6D\x44",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xC4"],

        ["\xED\xC5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x45"],
        ["\x6D\x45",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xC5"],

        ["\xED\xC6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x46"],
        ["\x6D\x46",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xC6"],

        ["\xED\xC7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x47"],
        ["\x6D\x47",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xC7"],

        ["\xED\xC8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x48"],
        ["\x6D\x48",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xC8"],

        ["\xED\xC9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x49"],
        ["\x6D\x49",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xC9"],

        ["\xED\xCA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x4A"],
        ["\x6D\x4A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xCA"],

        ["\xED\xCB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x4B"],
        ["\x6D\x4B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xCB"],

        ["\xED\xCC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x4C"],
        ["\x6D\x4C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xCC"],

        ["\xED\xCD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x4D"],
        ["\x6D\x4D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xCD"],

        ["\xED\xCE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x4E"],
        ["\x6D\x4E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xCE"],

        ["\xED\xCF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x4F"],
        ["\x6D\x4F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xCF"],

        ["\xED\xD0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x50"],
        ["\x6D\x50",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xD0"],

        ["\xED\xD1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x51"],
        ["\x6D\x51",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xD1"],

        ["\xED\xD2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x52"],
        ["\x6D\x52",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xD2"],

        ["\xED\xD3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x53"],
        ["\x6D\x53",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xD3"],

        ["\xED\xD4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x54"],
        ["\x6D\x54",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xD4"],

        ["\xED\xD5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x55"],
        ["\x6D\x55",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xD5"],

        ["\xED\xD6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x56"],
        ["\x6D\x56",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xD6"],

        ["\xED\xD7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x57"],
        ["\x6D\x57",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xD7"],

        ["\xED\xD8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x58"],
        ["\x6D\x58",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xD8"],

        ["\xED\xD9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x59"],
        ["\x6D\x59",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xD9"],

        ["\xED\xDA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x5A"],
        ["\x6D\x5A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xDA"],

        ["\xED\xDB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x5B"],
        ["\x6D\x5B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xDB"],

        ["\xED\xDC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x5C"],
        ["\x6D\x5C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xDC"],

        ["\xED\xDD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x5D"],
        ["\x6D\x5D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xDD"],

        ["\xED\xDE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x5E"],
        ["\x6D\x5E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xDE"],

        ["\xED\xDF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x5F"],
        ["\x6D\x5F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xDF"],

        ["\xED\xE0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x60"],
        ["\x6D\x60",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xE0"],

        ["\xED\xE1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x61"],
        ["\x6D\x61",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xE1"],

        ["\xED\xE2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x62"],
        ["\x6D\x62",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xE2"],

        ["\xED\xE3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x63"],
        ["\x6D\x63",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xE3"],

        ["\xED\xE4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x64"],
        ["\x6D\x64",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xE4"],

        ["\xED\xE5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x65"],
        ["\x6D\x65",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xE5"],

        ["\xED\xE6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x66"],
        ["\x6D\x66",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xE6"],

        ["\xED\xE7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x67"],
        ["\x6D\x67",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xE7"],

        ["\xED\xE8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x68"],
        ["\x6D\x68",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xE8"],

        ["\xED\xE9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x69"],
        ["\x6D\x69",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xE9"],

        ["\xED\xEA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x6A"],
        ["\x6D\x6A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xEA"],

        ["\xED\xEB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x6B"],
        ["\x6D\x6B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xEB"],

        ["\xED\xEC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x6C"],
        ["\x6D\x6C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xEC"],

        ["\xED\xED",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x6D"],
        ["\x6D\x6D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xED"],

        ["\xED\xEE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x46\x76"],
        ["\x46\x76",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xEE"],

        ["\xED\xEF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x6F"],
        ["\x6D\x6F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xEF"],

        ["\xED\xF0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x70"],
        ["\x6D\x70",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xF0"],

        ["\xED\xF1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x71"],
        ["\x6D\x71",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xF1"],

        ["\xED\xF2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x72"],
        ["\x6D\x72",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xF2"],

        ["\xED\xF3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x73"],
        ["\x6D\x73",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xF3"],

        ["\xED\xF4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x74"],
        ["\x6D\x74",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xF4"],

        ["\xED\xF5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x75"],
        ["\x6D\x75",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xF5"],

        ["\xED\xF6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x76"],
        ["\x6D\x76",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xF6"],

        ["\xED\xF7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x77"],
        ["\x6D\x77",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xF7"],

        ["\xED\xF8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x78"],
        ["\x6D\x78",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xF8"],

        ["\xED\xF9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x79"],
        ["\x6D\x79",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xF9"],

        ["\xED\xFA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x7A"],
        ["\x6D\x7A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xFA"],

        ["\xED\xFB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x7B"],
        ["\x6D\x7B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xFB"],

        ["\xED\xFC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x7C"],
        ["\x6D\x7C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xFC"],

        ["\xED\xFD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x7D"],
        ["\x6D\x7D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xFD"],

        ["\xED\xFE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6D\x7E"],
        ["\x6D\x7E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xED\xFE"],

        ["\xEE\xA1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x21"],
        ["\x6E\x21",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xA1"],

        ["\xEE\xA2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x22"],
        ["\x6E\x22",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xA2"],

        ["\xEE\xA3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x23"],
        ["\x6E\x23",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xA3"],

        ["\xEE\xA4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x24"],
        ["\x6E\x24",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xA4"],

        ["\xEE\xA5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x25"],
        ["\x6E\x25",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xA5"],

        ["\xEE\xA6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x26"],
        ["\x6E\x26",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xA6"],

        ["\xEE\xA7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x27"],
        ["\x6E\x27",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xA7"],

        ["\xEE\xA8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x28"],
        ["\x6E\x28",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xA8"],

        ["\xEE\xA9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x29"],
        ["\x6E\x29",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xA9"],

        ["\xEE\xAA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x2A"],
        ["\x6E\x2A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xAA"],

        ["\xEE\xAB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x2B"],
        ["\x6E\x2B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xAB"],

        ["\xEE\xAC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x2C"],
        ["\x6E\x2C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xAC"],

        ["\xEE\xAD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x2D"],
        ["\x6E\x2D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xAD"],

        ["\xEE\xAE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x2E"],
        ["\x6E\x2E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xAE"],

        ["\xEE\xAF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x2F"],
        ["\x6E\x2F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xAF"],

        ["\xEE\xB0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x30"],
        ["\x6E\x30",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xB0"],

        ["\xEE\xB1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x31"],
        ["\x6E\x31",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xB1"],

        ["\xEE\xB2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x32"],
        ["\x6E\x32",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xB2"],

        ["\xEE\xB3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x33"],
        ["\x6E\x33",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xB3"],

        ["\xEE\xB4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x34"],
        ["\x6E\x34",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xB4"],

        ["\xEE\xB5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x35"],
        ["\x6E\x35",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xB5"],

        ["\xEE\xB6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x36"],
        ["\x6E\x36",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xB6"],

        ["\xEE\xB7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x37"],
        ["\x6E\x37",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xB7"],

        ["\xEE\xB8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x38"],
        ["\x6E\x38",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xB8"],

        ["\xEE\xB9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x39"],
        ["\x6E\x39",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xB9"],

        ["\xEE\xBA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x3A"],
        ["\x6E\x3A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xBA"],

        ["\xEE\xBB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x3B"],
        ["\x6E\x3B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xBB"],

        ["\xEE\xBC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x3C"],
        ["\x6E\x3C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xBC"],

        ["\xEE\xBD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x3D"],
        ["\x6E\x3D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xBD"],

        ["\xEE\xBE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x3E"],
        ["\x6E\x3E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xBE"],

        ["\xEE\xBF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x3F"],
        ["\x6E\x3F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xBF"],

        ["\xEE\xC0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x40"],
        ["\x6E\x40",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xC0"],

        ["\xEE\xC1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x41"],
        ["\x6E\x41",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xC1"],

        ["\xEE\xC2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x42"],
        ["\x6E\x42",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xC2"],

        ["\xEE\xC3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x43"],
        ["\x6E\x43",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xC3"],

        ["\xEE\xC4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x44"],
        ["\x6E\x44",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xC4"],

        ["\xEE\xC5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x45"],
        ["\x6E\x45",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xC5"],

        ["\xEE\xC6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x46"],
        ["\x6E\x46",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xC6"],

        ["\xEE\xC7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x47"],
        ["\x6E\x47",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xC7"],

        ["\xEE\xC8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x48"],
        ["\x6E\x48",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xC8"],

        ["\xEE\xC9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x49"],
        ["\x6E\x49",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xC9"],

        ["\xEE\xCA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x4A"],
        ["\x6E\x4A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xCA"],

        ["\xEE\xCB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x4B"],
        ["\x6E\x4B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xCB"],

        ["\xEE\xCC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x4C"],
        ["\x6E\x4C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xCC"],

        ["\xEE\xCD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x4D"],
        ["\x6E\x4D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xCD"],

        ["\xEE\xCE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x4E"],
        ["\x6E\x4E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xCE"],

        ["\xEE\xCF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x4F"],
        ["\x6E\x4F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xCF"],

        ["\xEE\xD0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x50"],
        ["\x6E\x50",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xD0"],

        ["\xEE\xD1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x51"],
        ["\x6E\x51",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xD1"],

        ["\xEE\xD2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x52"],
        ["\x6E\x52",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xD2"],

        ["\xEE\xD3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x53"],
        ["\x6E\x53",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xD3"],

        ["\xEE\xD4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x54"],
        ["\x6E\x54",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xD4"],

        ["\xEE\xD5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x55"],
        ["\x6E\x55",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xD5"],

        ["\xEE\xD6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x56"],
        ["\x6E\x56",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xD6"],

        ["\xEE\xD7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x57"],
        ["\x6E\x57",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xD7"],

        ["\xEE\xD8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x58"],
        ["\x6E\x58",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xD8"],

        ["\xEE\xD9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x59"],
        ["\x6E\x59",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xD9"],

        ["\xEE\xDA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x5A"],
        ["\x6E\x5A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xDA"],

        ["\xEE\xDB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x5B"],
        ["\x6E\x5B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xDB"],

        ["\xEE\xDC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x5C"],
        ["\x6E\x5C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xDC"],

        ["\xEE\xDD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x5D"],
        ["\x6E\x5D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xDD"],

        ["\xEE\xDE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x5E"],
        ["\x6E\x5E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xDE"],

        ["\xEE\xDF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x5F"],
        ["\x6E\x5F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xDF"],

        ["\xEE\xE0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x60"],
        ["\x6E\x60",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xE0"],

        ["\xEE\xE1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x61"],
        ["\x6E\x61",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xE1"],

        ["\xEE\xE2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x62"],
        ["\x6E\x62",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xE2"],

        ["\xEE\xE3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x63"],
        ["\x6E\x63",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xE3"],

        ["\xEE\xE4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x64"],
        ["\x6E\x64",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xE4"],

        ["\xEE\xE5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x65"],
        ["\x6E\x65",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xE5"],

        ["\xEE\xE6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x66"],
        ["\x6E\x66",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xE6"],

        ["\xEE\xE7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x67"],
        ["\x6E\x67",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xE7"],

        ["\xEE\xE8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x68"],
        ["\x6E\x68",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xE8"],

        ["\xEE\xE9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x69"],
        ["\x6E\x69",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xE9"],

        ["\xEE\xEA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x6A"],
        ["\x6E\x6A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xEA"],

        ["\xEE\xEB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x6B"],
        ["\x6E\x6B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xEB"],

        ["\xEE\xEC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x6C"],
        ["\x6E\x6C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xEC"],

        ["\xEE\xED",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x6D"],
        ["\x6E\x6D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xED"],

        ["\xEE\xEE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x6E"],
        ["\x6E\x6E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xEE"],

        ["\xEE\xEF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x6F"],
        ["\x6E\x6F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xEF"],

        ["\xEE\xF0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x70"],
        ["\x6E\x70",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xF0"],

        ["\xEE\xF1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x71"],
        ["\x6E\x71",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xF1"],

        ["\xEE\xF2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x72"],
        ["\x6E\x72",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xF2"],

        ["\xEE\xF3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x73"],
        ["\x6E\x73",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xF3"],

        ["\xEE\xF4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x74"],
        ["\x6E\x74",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xF4"],

        ["\xEE\xF5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x75"],
        ["\x6E\x75",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xF5"],

        ["\xEE\xF6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x76"],
        ["\x6E\x76",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xF6"],

        ["\xEE\xF7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x77"],
        ["\x6E\x77",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xF7"],

        ["\xEE\xF8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x78"],
        ["\x6E\x78",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xF8"],

        ["\xEE\xF9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x79"],
        ["\x6E\x79",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xF9"],

        ["\xEE\xFA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x7A"],
        ["\x6E\x7A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xFA"],

        ["\xEE\xFB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x7B"],
        ["\x6E\x7B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xFB"],

        ["\xEE\xFC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x7C"],
        ["\x6E\x7C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xFC"],

        ["\xEE\xFD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x7D"],
        ["\x6E\x7D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xFD"],

        ["\xEE\xFE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6E\x7E"],
        ["\x6E\x7E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEE\xFE"],

        ["\xEF\xA1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x21"],
        ["\x6F\x21",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xA1"],

        ["\xEF\xA2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x22"],
        ["\x6F\x22",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xA2"],

        ["\xEF\xA3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x23"],
        ["\x6F\x23",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xA3"],

        ["\xEF\xA4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x24"],
        ["\x6F\x24",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xA4"],

        ["\xEF\xA5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x25"],
        ["\x6F\x25",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xA5"],

        ["\xEF\xA6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x26"],
        ["\x6F\x26",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xA6"],

        ["\xEF\xA7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x27"],
        ["\x6F\x27",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xA7"],

        ["\xEF\xA8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x28"],
        ["\x6F\x28",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8"],

        ["\xEF\xA9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x29"],
        ["\x6F\x29",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9"],

        ["\xEF\xAA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x2A"],
        ["\x6F\x2A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xAA"],

        ["\xEF\xAB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x2B"],
        ["\x6F\x2B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xAB"],

        ["\xEF\xAC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x2C"],
        ["\x6F\x2C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xAC"],

        ["\xEF\xAD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x2D"],
        ["\x6F\x2D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xAD"],

        ["\xEF\xAE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x2E"],
        ["\x6F\x2E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xAE"],

        ["\xEF\xAF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x2F"],
        ["\x6F\x2F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xAF"],

        ["\xEF\xB0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x30"],
        ["\x6F\x30",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xB0"],

        ["\xEF\xB1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x31"],
        ["\x6F\x31",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xB1"],

        ["\xEF\xB2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x32"],
        ["\x6F\x32",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xB2"],

        ["\xEF\xB3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x33"],
        ["\x6F\x33",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xB3"],

        ["\xEF\xB4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x34"],
        ["\x6F\x34",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xB4"],

        ["\xEF\xB5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x35"],
        ["\x6F\x35",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xB5"],

        ["\xEF\xB6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x36"],
        ["\x6F\x36",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xB6"],

        ["\xEF\xB7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x37"],
        ["\x6F\x37",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xB7"],

        ["\xEF\xB8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x38"],
        ["\x6F\x38",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xB8"],

        ["\xEF\xB9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x39"],
        ["\x6F\x39",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xB9"],

        ["\xEF\xBA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x3A"],
        ["\x6F\x3A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xBA"],

        ["\xEF\xBB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x3B"],
        ["\x6F\x3B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xBB"],

        ["\xEF\xBC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x3C"],
        ["\x6F\x3C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC"],

        ["\xEF\xBD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x3D"],
        ["\x6F\x3D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD"],

        ["\xEF\xBE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x3E"],
        ["\x6F\x3E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xBE"],

        ["\xEF\xBF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x3F"],
        ["\x6F\x3F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xBF"],

        ["\xEF\xC0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x40"],
        ["\x6F\x40",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xC0"],

        ["\xEF\xC1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x41"],
        ["\x6F\x41",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xC1"],

        ["\xEF\xC2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x42"],
        ["\x6F\x42",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xC2"],

        ["\xEF\xC3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x43"],
        ["\x6F\x43",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xC3"],

        ["\xEF\xC4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x44"],
        ["\x6F\x44",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xC4"],

        ["\xEF\xC5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x45"],
        ["\x6F\x45",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xC5"],

        ["\xEF\xC6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x46"],
        ["\x6F\x46",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xC6"],

        ["\xEF\xC7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x47"],
        ["\x6F\x47",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xC7"],

        ["\xEF\xC8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x48"],
        ["\x6F\x48",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xC8"],

        ["\xEF\xC9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x49"],
        ["\x6F\x49",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xC9"],

        ["\xEF\xCA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x4A"],
        ["\x6F\x4A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xCA"],

        ["\xEF\xCB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x4B"],
        ["\x6F\x4B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xCB"],

        ["\xEF\xCC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x4C"],
        ["\x6F\x4C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xCC"],

        ["\xEF\xCD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x4D"],
        ["\x6F\x4D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xCD"],

        ["\xEF\xCE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x4E"],
        ["\x6F\x4E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xCE"],

        ["\xEF\xCF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x4F"],
        ["\x6F\x4F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xCF"],

        ["\xEF\xD0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x50"],
        ["\x6F\x50",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xD0"],

        ["\xEF\xD1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x51"],
        ["\x6F\x51",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xD1"],

        ["\xEF\xD2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x52"],
        ["\x6F\x52",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xD2"],

        ["\xEF\xD3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x53"],
        ["\x6F\x53",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xD3"],

        ["\xEF\xD4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x54"],
        ["\x6F\x54",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xD4"],

        ["\xEF\xD5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x55"],
        ["\x6F\x55",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xD5"],

        ["\xEF\xD6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x56"],
        ["\x6F\x56",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xD6"],

        ["\xEF\xD7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x57"],
        ["\x6F\x57",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xD7"],

        ["\xEF\xD8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x58"],
        ["\x6F\x58",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xD8"],

        ["\xEF\xD9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x59"],
        ["\x6F\x59",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xD9"],

        ["\xEF\xDA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x5A"],
        ["\x6F\x5A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xDA"],

        ["\xEF\xDB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x5B"],
        ["\x6F\x5B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xDB"],

        ["\xEF\xDC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x5C"],
        ["\x6F\x5C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xDC"],

        ["\xEF\xDD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x5D"],
        ["\x6F\x5D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xDD"],

        ["\xEF\xDE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x5E"],
        ["\x6F\x5E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xDE"],

        ["\xEF\xDF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x5F"],
        ["\x6F\x5F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xDF"],

        ["\xEF\xE0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x60"],
        ["\x6F\x60",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xE0"],

        ["\xEF\xE1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x61"],
        ["\x6F\x61",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xE1"],

        ["\xEF\xE2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x62"],
        ["\x6F\x62",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xE2"],

        ["\xEF\xE3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x63"],
        ["\x6F\x63",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xE3"],

        ["\xEF\xE4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x64"],
        ["\x6F\x64",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xE4"],

        ["\xEF\xE5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x65"],
        ["\x6F\x65",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xE5"],

        ["\xEF\xE6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x66"],
        ["\x6F\x66",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xE6"],

        ["\xEF\xE7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x67"],
        ["\x6F\x67",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xE7"],

        ["\xEF\xE8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x68"],
        ["\x6F\x68",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xE8"],

        ["\xEF\xE9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x69"],
        ["\x6F\x69",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xE9"],

        ["\xEF\xEA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x6A"],
        ["\x6F\x6A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xEA"],

        ["\xEF\xEB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x6B"],
        ["\x6F\x6B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xEB"],

        ["\xEF\xEC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x6C"],
        ["\x6F\x6C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xEC"],

        ["\xEF\xED",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x6D"],
        ["\x6F\x6D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xED"],

        ["\xEF\xEE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x6E"],
        ["\x6F\x6E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xEE"],

        ["\xEF\xEF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x6F"],
        ["\x6F\x6F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xEF"],

        ["\xEF\xF0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x70"],
        ["\x6F\x70",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xF0"],

        ["\xEF\xF1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x71"],
        ["\x6F\x71",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xF1"],

        ["\xEF\xF2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x72"],
        ["\x6F\x72",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xF2"],

        ["\xEF\xF3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x73"],
        ["\x6F\x73",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xF3"],

        ["\xEF\xF4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x74"],
        ["\x6F\x74",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xF4"],

        ["\xEF\xF5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x75"],
        ["\x6F\x75",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xF5"],

        ["\xEF\xF6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x76"],
        ["\x6F\x76",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xF6"],

        ["\xEF\xF7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x77"],
        ["\x6F\x77",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xF7"],

        ["\xEF\xF8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x78"],
        ["\x6F\x78",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xF8"],

        ["\xEF\xF9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x79"],
        ["\x6F\x79",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xF9"],

        ["\xEF\xFA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x7A"],
        ["\x6F\x7A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xFA"],

        ["\xEF\xFB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x7B"],
        ["\x6F\x7B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xFB"],

        ["\xEF\xFC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x7C"],
        ["\x6F\x7C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xFC"],

        ["\xEF\xFD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x7D"],
        ["\x6F\x7D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xFD"],

        ["\xEF\xFE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x6F\x7E"],
        ["\x6F\x7E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEF\xFE"],

        ["\xF0\xA1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x21"],
        ["\x70\x21",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xA1"],

        ["\xF0\xA2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x22"],
        ["\x70\x22",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xA2"],

        ["\xF0\xA3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x23"],
        ["\x70\x23",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xA3"],

        ["\xF0\xA4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x24"],
        ["\x70\x24",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xA4"],

        ["\xF0\xA5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x25"],
        ["\x70\x25",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xA5"],

        ["\xF0\xA6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x26"],
        ["\x70\x26",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xA6"],

        ["\xF0\xA7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x27"],
        ["\x70\x27",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xA7"],

        ["\xF0\xA8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x28"],
        ["\x70\x28",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xA8"],

        ["\xF0\xA9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x29"],
        ["\x70\x29",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xA9"],

        ["\xF0\xAA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x2A"],
        ["\x70\x2A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xAA"],

        ["\xF0\xAB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x2B"],
        ["\x70\x2B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xAB"],

        ["\xF0\xAC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x2C"],
        ["\x70\x2C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xAC"],

        ["\xF0\xAD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x2D"],
        ["\x70\x2D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xAD"],

        ["\xF0\xAE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x2E"],
        ["\x70\x2E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xAE"],

        ["\xF0\xAF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x2F"],
        ["\x70\x2F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xAF"],

        ["\xF0\xB0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x30"],
        ["\x70\x30",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xB0"],

        ["\xF0\xB1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x31"],
        ["\x70\x31",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xB1"],

        ["\xF0\xB2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x32"],
        ["\x70\x32",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xB2"],

        ["\xF0\xB3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x33"],
        ["\x70\x33",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xB3"],

        ["\xF0\xB4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x34"],
        ["\x70\x34",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xB4"],

        ["\xF0\xB5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x35"],
        ["\x70\x35",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xB5"],

        ["\xF0\xB6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x36"],
        ["\x70\x36",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xB6"],

        ["\xF0\xB7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x37"],
        ["\x70\x37",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xB7"],

        ["\xF0\xB8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x38"],
        ["\x70\x38",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xB8"],

        ["\xF0\xB9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x39"],
        ["\x70\x39",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xB9"],

        ["\xF0\xBA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x3A"],
        ["\x70\x3A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xBA"],

        ["\xF0\xBB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x3B"],
        ["\x70\x3B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xBB"],

        ["\xF0\xBC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x3C"],
        ["\x70\x3C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xBC"],

        ["\xF0\xBD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x3D"],
        ["\x70\x3D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xBD"],

        ["\xF0\xBE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x3E"],
        ["\x70\x3E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xBE"],

        ["\xF0\xBF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x3F"],
        ["\x70\x3F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xBF"],

        ["\xF0\xC0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x40"],
        ["\x70\x40",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xC0"],

        ["\xF0\xC1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x41"],
        ["\x70\x41",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xC1"],

        ["\xF0\xC2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x42"],
        ["\x70\x42",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xC2"],

        ["\xF0\xC3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x43"],
        ["\x70\x43",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xC3"],

        ["\xF0\xC4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x44"],
        ["\x70\x44",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xC4"],

        ["\xF0\xC5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x45"],
        ["\x70\x45",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xC5"],

        ["\xF0\xC6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x46"],
        ["\x70\x46",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xC6"],

        ["\xF0\xC7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x47"],
        ["\x70\x47",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xC7"],

        ["\xF0\xC8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x48"],
        ["\x70\x48",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xC8"],

        ["\xF0\xC9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x49"],
        ["\x70\x49",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xC9"],

        ["\xF0\xCA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x4A"],
        ["\x70\x4A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xCA"],

        ["\xF0\xCB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x4B"],
        ["\x70\x4B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xCB"],

        ["\xF0\xCC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x4C"],
        ["\x70\x4C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xCC"],

        ["\xF0\xCD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x4D"],
        ["\x70\x4D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xCD"],

        ["\xF0\xCE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x4E"],
        ["\x70\x4E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xCE"],

        ["\xF0\xCF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x4F"],
        ["\x70\x4F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xCF"],

        ["\xF0\xD0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x50"],
        ["\x70\x50",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xD0"],

        ["\xF0\xD1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x51"],
        ["\x70\x51",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xD1"],

        ["\xF0\xD2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x52"],
        ["\x70\x52",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xD2"],

        ["\xF0\xD3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x53"],
        ["\x70\x53",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xD3"],

        ["\xF0\xD4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x54"],
        ["\x70\x54",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xD4"],

        ["\xF0\xD5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x55"],
        ["\x70\x55",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xD5"],

        ["\xF0\xD6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x56"],
        ["\x70\x56",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xD6"],

        ["\xF0\xD7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x3F\x59"],
        ["\x3F\x59",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xD7"],

        ["\xF0\xD8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x58"],
        ["\x70\x58",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xD8"],

        ["\xF0\xD9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x59"],
        ["\x70\x59",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xD9"],

        ["\xF0\xDA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x5A"],
        ["\x70\x5A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xDA"],

        ["\xF0\xDB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x5B"],
        ["\x70\x5B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xDB"],

        ["\xF0\xDC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x5C"],
        ["\x70\x5C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xDC"],

        ["\xF0\xDD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x5D"],
        ["\x70\x5D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xDD"],

        ["\xF0\xDE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x5E"],
        ["\x70\x5E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xDE"],

        ["\xF0\xDF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x5F"],
        ["\x70\x5F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xDF"],

        ["\xF0\xE0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x60"],
        ["\x70\x60",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xE0"],

        ["\xF0\xE1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x61"],
        ["\x70\x61",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xE1"],

        ["\xF0\xE2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x62"],
        ["\x70\x62",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xE2"],

        ["\xF0\xE3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x63"],
        ["\x70\x63",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xE3"],

        ["\xF0\xE4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x64"],
        ["\x70\x64",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xE4"],

        ["\xF0\xE5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x65"],
        ["\x70\x65",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xE5"],

        ["\xF0\xE6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x66"],
        ["\x70\x66",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xE6"],

        ["\xF0\xE7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x67"],
        ["\x70\x67",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xE7"],

        ["\xF0\xE8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x68"],
        ["\x70\x68",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xE8"],

        ["\xF0\xE9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x69"],
        ["\x70\x69",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xE9"],

        ["\xF0\xEA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x6A"],
        ["\x70\x6A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xEA"],

        ["\xF0\xEB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x6B"],
        ["\x70\x6B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xEB"],

        ["\xF0\xEC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x6C"],
        ["\x70\x6C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xEC"],

        ["\xF0\xED",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x6D"],
        ["\x70\x6D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xED"],

        ["\xF0\xEE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x6E"],
        ["\x70\x6E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xEE"],

        ["\xF0\xEF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x6F"],
        ["\x70\x6F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xEF"],

        ["\xF0\xF0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x70"],
        ["\x70\x70",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xF0"],

        ["\xF0\xF1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x71"],
        ["\x70\x71",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xF1"],

        ["\xF0\xF2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x72"],
        ["\x70\x72",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xF2"],

        ["\xF0\xF3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x73"],
        ["\x70\x73",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xF3"],

        ["\xF0\xF4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x37\x5B"],
        ["\x37\x5B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xF4"],

        ["\xF0\xF5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x75"],
        ["\x70\x75",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xF5"],

        ["\xF0\xF6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x76"],
        ["\x70\x76",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xF6"],

        ["\xF0\xF7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x77"],
        ["\x70\x77",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xF7"],

        ["\xF0\xF8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x78"],
        ["\x70\x78",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xF8"],

        ["\xF0\xF9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x79"],
        ["\x70\x79",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xF9"],

        ["\xF0\xFA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x7A"],
        ["\x70\x7A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xFA"],

        ["\xF0\xFB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x7B"],
        ["\x70\x7B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xFB"],

        ["\xF0\xFC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x7C"],
        ["\x70\x7C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xFC"],

        ["\xF0\xFD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x7D"],
        ["\x70\x7D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xFD"],

        ["\xF0\xFE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x70\x7E"],
        ["\x70\x7E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF0\xFE"],

        ["\xF1\xA1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x21"],
        ["\x71\x21",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xA1"],

        ["\xF1\xA2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x22"],
        ["\x71\x22",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xA2"],

        ["\xF1\xA3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x23"],
        ["\x71\x23",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xA3"],

        ["\xF1\xA4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x24"],
        ["\x71\x24",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xA4"],

        ["\xF1\xA5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x25"],
        ["\x71\x25",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xA5"],

        ["\xF1\xA6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x26"],
        ["\x71\x26",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xA6"],

        ["\xF1\xA7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x27"],
        ["\x71\x27",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xA7"],

        ["\xF1\xA8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x28"],
        ["\x71\x28",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xA8"],

        ["\xF1\xA9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x29"],
        ["\x71\x29",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xA9"],

        ["\xF1\xAA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x2A"],
        ["\x71\x2A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xAA"],

        ["\xF1\xAB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x2B"],
        ["\x71\x2B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xAB"],

        ["\xF1\xAC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x2C"],
        ["\x71\x2C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xAC"],

        ["\xF1\xAD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x2D"],
        ["\x71\x2D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xAD"],

        ["\xF1\xAE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x2E"],
        ["\x71\x2E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xAE"],

        ["\xF1\xAF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x2F"],
        ["\x71\x2F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xAF"],

        ["\xF1\xB0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x30"],
        ["\x71\x30",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xB0"],

        ["\xF1\xB1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x31"],
        ["\x71\x31",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xB1"],

        ["\xF1\xB2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x32"],
        ["\x71\x32",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xB2"],

        ["\xF1\xB3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x33"],
        ["\x71\x33",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xB3"],

        ["\xF1\xB4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x34"],
        ["\x71\x34",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xB4"],

        ["\xF1\xB5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x35"],
        ["\x71\x35",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xB5"],

        ["\xF1\xB6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x36"],
        ["\x71\x36",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xB6"],

        ["\xF1\xB7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x37"],
        ["\x71\x37",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xB7"],

        ["\xF1\xB8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x38"],
        ["\x71\x38",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xB8"],

        ["\xF1\xB9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x39"],
        ["\x71\x39",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xB9"],

        ["\xF1\xBA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x3A"],
        ["\x71\x3A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xBA"],

        ["\xF1\xBB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x3B"],
        ["\x71\x3B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xBB"],

        ["\xF1\xBC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x3C"],
        ["\x71\x3C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xBC"],

        ["\xF1\xBD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x3D"],
        ["\x71\x3D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xBD"],

        ["\xF1\xBE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x3E"],
        ["\x71\x3E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xBE"],

        ["\xF1\xBF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x3F"],
        ["\x71\x3F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xBF"],

        ["\xF1\xC0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x40"],
        ["\x71\x40",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xC0"],

        ["\xF1\xC1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x41"],
        ["\x71\x41",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xC1"],

        ["\xF1\xC2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x42"],
        ["\x71\x42",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xC2"],

        ["\xF1\xC3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x43"],
        ["\x71\x43",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xC3"],

        ["\xF1\xC4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x44"],
        ["\x71\x44",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xC4"],

        ["\xF1\xC5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x45"],
        ["\x71\x45",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xC5"],

        ["\xF1\xC6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x46"],
        ["\x71\x46",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xC6"],

        ["\xF1\xC7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x47"],
        ["\x71\x47",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xC7"],

        ["\xF1\xC8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x48"],
        ["\x71\x48",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xC8"],

        ["\xF1\xC9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x49"],
        ["\x71\x49",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xC9"],

        ["\xF1\xCA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x4A"],
        ["\x71\x4A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xCA"],

        ["\xF1\xCB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x4B"],
        ["\x71\x4B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xCB"],

        ["\xF1\xCC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x4C"],
        ["\x71\x4C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xCC"],

        ["\xF1\xCD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x4D"],
        ["\x71\x4D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xCD"],

        ["\xF1\xCE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x4E"],
        ["\x71\x4E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xCE"],

        ["\xF1\xCF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x4F"],
        ["\x71\x4F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xCF"],

        ["\xF1\xD0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x50"],
        ["\x71\x50",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xD0"],

        ["\xF1\xD1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x51"],
        ["\x71\x51",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xD1"],

        ["\xF1\xD2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x52"],
        ["\x71\x52",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xD2"],

        ["\xF1\xD3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x53"],
        ["\x71\x53",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xD3"],

        ["\xF1\xD4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x54"],
        ["\x71\x54",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xD4"],

        ["\xF1\xD5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x55"],
        ["\x71\x55",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xD5"],

        ["\xF1\xD6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x56"],
        ["\x71\x56",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xD6"],

        ["\xF1\xD7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x57"],
        ["\x71\x57",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xD7"],

        ["\xF1\xD8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x58"],
        ["\x71\x58",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xD8"],

        ["\xF1\xD9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x59"],
        ["\x71\x59",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xD9"],

        ["\xF1\xDA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x5A"],
        ["\x71\x5A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xDA"],

        ["\xF1\xDB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x5B"],
        ["\x71\x5B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xDB"],

        ["\xF1\xDC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x5C"],
        ["\x71\x5C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xDC"],

        ["\xF1\xDD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x5D"],
        ["\x71\x5D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xDD"],

        ["\xF1\xDE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x5E"],
        ["\x71\x5E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xDE"],

        ["\xF1\xDF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x5F"],
        ["\x71\x5F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xDF"],

        ["\xF1\xE0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x60"],
        ["\x71\x60",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xE0"],

        ["\xF1\xE1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x61"],
        ["\x71\x61",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xE1"],

        ["\xF1\xE2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x62"],
        ["\x71\x62",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xE2"],

        ["\xF1\xE3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x63"],
        ["\x71\x63",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xE3"],

        ["\xF1\xE4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x64"],
        ["\x71\x64",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xE4"],

        ["\xF1\xE5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x65"],
        ["\x71\x65",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xE5"],

        ["\xF1\xE6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x66"],
        ["\x71\x66",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xE6"],

        ["\xF1\xE7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x67"],
        ["\x71\x67",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xE7"],

        ["\xF1\xE8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x68"],
        ["\x71\x68",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xE8"],

        ["\xF1\xE9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x69"],
        ["\x71\x69",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xE9"],

        ["\xF1\xEA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x6A"],
        ["\x71\x6A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xEA"],

        ["\xF1\xEB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x6B"],
        ["\x71\x6B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xEB"],

        ["\xF1\xEC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x6C"],
        ["\x71\x6C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xEC"],

        ["\xF1\xED",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x6D"],
        ["\x71\x6D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xED"],

        ["\xF1\xEE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x6E"],
        ["\x71\x6E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xEE"],

        ["\xF1\xEF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x6F"],
        ["\x71\x6F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xEF"],

        ["\xF1\xF0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x70"],
        ["\x71\x70",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xF0"],

        ["\xF1\xF1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x71"],
        ["\x71\x71",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xF1"],

        ["\xF1\xF2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x72"],
        ["\x71\x72",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xF2"],

        ["\xF1\xF3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x73"],
        ["\x71\x73",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xF3"],

        ["\xF1\xF4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x74"],
        ["\x71\x74",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xF4"],

        ["\xF1\xF5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x75"],
        ["\x71\x75",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xF5"],

        ["\xF1\xF6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x76"],
        ["\x71\x76",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xF6"],

        ["\xF1\xF7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x77"],
        ["\x71\x77",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xF7"],

        ["\xF1\xF8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x78"],
        ["\x71\x78",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xF8"],

        ["\xF1\xF9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x79"],
        ["\x71\x79",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xF9"],

        ["\xF1\xFA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x7A"],
        ["\x71\x7A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xFA"],

        ["\xF1\xFB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x7B"],
        ["\x71\x7B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xFB"],

        ["\xF1\xFC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x7C"],
        ["\x71\x7C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xFC"],

        ["\xF1\xFD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x7D"],
        ["\x71\x7D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xFD"],

        ["\xF1\xFE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x71\x7E"],
        ["\x71\x7E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF1\xFE"],

        ["\xF2\xA1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x21"],
        ["\x72\x21",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xA1"],

        ["\xF2\xA2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x22"],
        ["\x72\x22",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xA2"],

        ["\xF2\xA3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x23"],
        ["\x72\x23",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xA3"],

        ["\xF2\xA4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x24"],
        ["\x72\x24",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xA4"],

        ["\xF2\xA5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x25"],
        ["\x72\x25",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xA5"],

        ["\xF2\xA6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x26"],
        ["\x72\x26",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xA6"],

        ["\xF2\xA7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x27"],
        ["\x72\x27",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xA7"],

        ["\xF2\xA8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x28"],
        ["\x72\x28",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xA8"],

        ["\xF2\xA9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x29"],
        ["\x72\x29",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xA9"],

        ["\xF2\xAA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x2A"],
        ["\x72\x2A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xAA"],

        ["\xF2\xAB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x2B"],
        ["\x72\x2B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xAB"],

        ["\xF2\xAC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x2C"],
        ["\x72\x2C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xAC"],

        ["\xF2\xAD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x2D"],
        ["\x72\x2D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xAD"],

        ["\xF2\xAE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x2E"],
        ["\x72\x2E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xAE"],

        ["\xF2\xAF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x2F"],
        ["\x72\x2F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xAF"],

        ["\xF2\xB0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x30"],
        ["\x72\x30",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xB0"],

        ["\xF2\xB1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x31"],
        ["\x72\x31",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xB1"],

        ["\xF2\xB2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x32"],
        ["\x72\x32",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xB2"],

        ["\xF2\xB3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x33"],
        ["\x72\x33",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xB3"],

        ["\xF2\xB4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x34"],
        ["\x72\x34",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xB4"],

        ["\xF2\xB5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x35"],
        ["\x72\x35",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xB5"],

        ["\xF2\xB6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x36"],
        ["\x72\x36",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xB6"],

        ["\xF2\xB7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x37"],
        ["\x72\x37",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xB7"],

        ["\xF2\xB8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x38"],
        ["\x72\x38",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xB8"],

        ["\xF2\xB9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x39"],
        ["\x72\x39",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xB9"],

        ["\xF2\xBA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x3A"],
        ["\x72\x3A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xBA"],

        ["\xF2\xBB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x3B"],
        ["\x72\x3B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xBB"],

        ["\xF2\xBC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x3C"],
        ["\x72\x3C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xBC"],

        ["\xF2\xBD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x3D"],
        ["\x72\x3D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xBD"],

        ["\xF2\xBE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x3E"],
        ["\x72\x3E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xBE"],

        ["\xF2\xBF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x3F"],
        ["\x72\x3F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xBF"],

        ["\xF2\xC0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x40"],
        ["\x72\x40",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xC0"],

        ["\xF2\xC1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x41"],
        ["\x72\x41",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xC1"],

        ["\xF2\xC2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x42"],
        ["\x72\x42",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xC2"],

        ["\xF2\xC3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x43"],
        ["\x72\x43",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xC3"],

        ["\xF2\xC4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x44"],
        ["\x72\x44",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xC4"],

        ["\xF2\xC5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x45"],
        ["\x72\x45",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xC5"],

        ["\xF2\xC6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x46"],
        ["\x72\x46",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xC6"],

        ["\xF2\xC7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x47"],
        ["\x72\x47",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xC7"],

        ["\xF2\xC8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x48"],
        ["\x72\x48",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xC8"],

        ["\xF2\xC9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x49"],
        ["\x72\x49",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xC9"],

        ["\xF2\xCA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x4A"],
        ["\x72\x4A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xCA"],

        ["\xF2\xCB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x4B"],
        ["\x72\x4B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xCB"],

        ["\xF2\xCC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x4C"],
        ["\x72\x4C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xCC"],

        ["\xF2\xCD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x30\x33"],
        ["\x30\x33",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xCD"],

        ["\xF2\xCE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x4E"],
        ["\x72\x4E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xCE"],

        ["\xF2\xCF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x4F"],
        ["\x72\x4F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xCF"],

        ["\xF2\xD0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x50"],
        ["\x72\x50",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xD0"],

        ["\xF2\xD1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x51"],
        ["\x72\x51",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xD1"],

        ["\xF2\xD2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x52"],
        ["\x72\x52",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xD2"],

        ["\xF2\xD3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x53"],
        ["\x72\x53",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xD3"],

        ["\xF2\xD4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x54"],
        ["\x72\x54",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xD4"],

        ["\xF2\xD5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x55"],
        ["\x72\x55",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xD5"],

        ["\xF2\xD6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x56"],
        ["\x72\x56",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xD6"],

        ["\xF2\xD7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x57"],
        ["\x72\x57",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xD7"],

        ["\xF2\xD8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x58"],
        ["\x72\x58",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xD8"],

        ["\xF2\xD9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x59"],
        ["\x72\x59",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xD9"],

        ["\xF2\xDA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x5A"],
        ["\x72\x5A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xDA"],

        ["\xF2\xDB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x5B"],
        ["\x72\x5B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xDB"],

        ["\xF2\xDC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x5C"],
        ["\x72\x5C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xDC"],

        ["\xF2\xDD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x5D"],
        ["\x72\x5D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xDD"],

        ["\xF2\xDE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x5E"],
        ["\x72\x5E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xDE"],

        ["\xF2\xDF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x5F"],
        ["\x72\x5F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xDF"],

        ["\xF2\xE0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x60"],
        ["\x72\x60",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xE0"],

        ["\xF2\xE1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x61"],
        ["\x72\x61",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xE1"],

        ["\xF2\xE2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x62"],
        ["\x72\x62",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xE2"],

        ["\xF2\xE3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x63"],
        ["\x72\x63",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xE3"],

        ["\xF2\xE4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x64"],
        ["\x72\x64",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xE4"],

        ["\xF2\xE5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x65"],
        ["\x72\x65",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xE5"],

        ["\xF2\xE6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x66"],
        ["\x72\x66",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xE6"],

        ["\xF2\xE7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x67"],
        ["\x72\x67",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xE7"],

        ["\xF2\xE8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x68"],
        ["\x72\x68",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xE8"],

        ["\xF2\xE9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x69"],
        ["\x72\x69",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xE9"],

        ["\xF2\xEA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x6A"],
        ["\x72\x6A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xEA"],

        ["\xF2\xEB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x6B"],
        ["\x72\x6B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xEB"],

        ["\xF2\xEC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x6C"],
        ["\x72\x6C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xEC"],

        ["\xF2\xED",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x6D"],
        ["\x72\x6D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xED"],

        ["\xF2\xEE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x6E"],
        ["\x72\x6E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xEE"],

        ["\xF2\xEF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x6F"],
        ["\x72\x6F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xEF"],

        ["\xF2\xF0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x70"],
        ["\x72\x70",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xF0"],

        ["\xF2\xF1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x71"],
        ["\x72\x71",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xF1"],

        ["\xF2\xF2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x72"],
        ["\x72\x72",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xF2"],

        ["\xF2\xF3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x73"],
        ["\x72\x73",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xF3"],

        ["\xF2\xF4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x32\x29"],
        ["\x32\x29",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xF4"],

        ["\xF2\xF5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x75"],
        ["\x72\x75",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xF5"],

        ["\xF2\xF6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x76"],
        ["\x72\x76",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xF6"],

        ["\xF2\xF7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x77"],
        ["\x72\x77",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xF7"],

        ["\xF2\xF8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x78"],
        ["\x72\x78",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xF8"],

        ["\xF2\xF9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x79"],
        ["\x72\x79",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xF9"],

        ["\xF2\xFA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x7A"],
        ["\x72\x7A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xFA"],

        ["\xF2\xFB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x7B"],
        ["\x72\x7B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xFB"],

        ["\xF2\xFC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x7C"],
        ["\x72\x7C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xFC"],

        ["\xF2\xFD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x7D"],
        ["\x72\x7D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xFD"],

        ["\xF2\xFE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x72\x7E"],
        ["\x72\x7E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF2\xFE"],

        ["\xF3\xA1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x21"],
        ["\x73\x21",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xA1"],

        ["\xF3\xA2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x22"],
        ["\x73\x22",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xA2"],

        ["\xF3\xA3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x23"],
        ["\x73\x23",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xA3"],

        ["\xF3\xA4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x24"],
        ["\x73\x24",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xA4"],

        ["\xF3\xA5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x25"],
        ["\x73\x25",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xA5"],

        ["\xF3\xA6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x26"],
        ["\x73\x26",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xA6"],

        ["\xF3\xA7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x27"],
        ["\x73\x27",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xA7"],

        ["\xF3\xA8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x28"],
        ["\x73\x28",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xA8"],

        ["\xF3\xA9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x29"],
        ["\x73\x29",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xA9"],

        ["\xF3\xAA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x2A"],
        ["\x73\x2A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xAA"],

        ["\xF3\xAB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x2B"],
        ["\x73\x2B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xAB"],

        ["\xF3\xAC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x2C"],
        ["\x73\x2C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xAC"],

        ["\xF3\xAD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x2D"],
        ["\x73\x2D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xAD"],

        ["\xF3\xAE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x2E"],
        ["\x73\x2E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xAE"],

        ["\xF3\xAF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x2F"],
        ["\x73\x2F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xAF"],

        ["\xF3\xB0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x30"],
        ["\x73\x30",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0"],

        ["\xF3\xB1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x31"],
        ["\x73\x31",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1"],

        ["\xF3\xB2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x32"],
        ["\x73\x32",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2"],

        ["\xF3\xB3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x33"],
        ["\x73\x33",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3"],

        ["\xF3\xB4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x34"],
        ["\x73\x34",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4"],

        ["\xF3\xB5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x35"],
        ["\x73\x35",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5"],

        ["\xF3\xB6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x36"],
        ["\x73\x36",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB6"],

        ["\xF3\xB7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x37"],
        ["\x73\x37",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB7"],

        ["\xF3\xB8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x38"],
        ["\x73\x38",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB8"],

        ["\xF3\xB9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x39"],
        ["\x73\x39",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB9"],

        ["\xF3\xBA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x3A"],
        ["\x73\x3A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xBA"],

        ["\xF3\xBB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x3B"],
        ["\x73\x3B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xBB"],

        ["\xF3\xBC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x3C"],
        ["\x73\x3C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xBC"],

        ["\xF3\xBD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x3D"],
        ["\x73\x3D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xBD"],

        ["\xF3\xBE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x3E"],
        ["\x73\x3E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xBE"],

        ["\xF3\xBF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x3F"],
        ["\x73\x3F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xBF"],

        ["\xF3\xC0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x40"],
        ["\x73\x40",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xC0"],

        ["\xF3\xC1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x41"],
        ["\x73\x41",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xC1"],

        ["\xF3\xC2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x42"],
        ["\x73\x42",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xC2"],

        ["\xF3\xC3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x43"],
        ["\x73\x43",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xC3"],

        ["\xF3\xC4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x44"],
        ["\x73\x44",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xC4"],

        ["\xF3\xC5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x45"],
        ["\x73\x45",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xC5"],

        ["\xF3\xC6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x46"],
        ["\x73\x46",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xC6"],

        ["\xF3\xC7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x47"],
        ["\x73\x47",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xC7"],

        ["\xF3\xC8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x48"],
        ["\x73\x48",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xC8"],

        ["\xF3\xC9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x49"],
        ["\x73\x49",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xC9"],

        ["\xF3\xCA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x4A"],
        ["\x73\x4A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xCA"],

        ["\xF3\xCB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x4B"],
        ["\x73\x4B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xCB"],

        ["\xF3\xCC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x4C"],
        ["\x73\x4C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xCC"],

        ["\xF3\xCD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x4D"],
        ["\x73\x4D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xCD"],

        ["\xF3\xCE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x4E"],
        ["\x73\x4E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xCE"],

        ["\xF3\xCF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x4F"],
        ["\x73\x4F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xCF"],

        ["\xF3\xD0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x50"],
        ["\x73\x50",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xD0"],

        ["\xF3\xD1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x51"],
        ["\x73\x51",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xD1"],

        ["\xF3\xD2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x52"],
        ["\x73\x52",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xD2"],

        ["\xF3\xD3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x53"],
        ["\x73\x53",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xD3"],

        ["\xF3\xD4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x54"],
        ["\x73\x54",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xD4"],

        ["\xF3\xD5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x55"],
        ["\x73\x55",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xD5"],

        ["\xF3\xD6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x56"],
        ["\x73\x56",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xD6"],

        ["\xF3\xD7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x57"],
        ["\x73\x57",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xD7"],

        ["\xF3\xD8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x58"],
        ["\x73\x58",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xD8"],

        ["\xF3\xD9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x59"],
        ["\x73\x59",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xD9"],

        ["\xF3\xDA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x5A"],
        ["\x73\x5A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xDA"],

        ["\xF3\xDB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x5B"],
        ["\x73\x5B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xDB"],

        ["\xF3\xDC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x5C"],
        ["\x73\x5C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xDC"],

        ["\xF3\xDD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x5D"],
        ["\x73\x5D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xDD"],

        ["\xF3\xDE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x5E"],
        ["\x73\x5E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xDE"],

        ["\xF3\xDF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x5F"],
        ["\x73\x5F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xDF"],

        ["\xF3\xE0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x60"],
        ["\x73\x60",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xE0"],

        ["\xF3\xE1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x61"],
        ["\x73\x61",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xE1"],

        ["\xF3\xE2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x62"],
        ["\x73\x62",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xE2"],

        ["\xF3\xE3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x63"],
        ["\x73\x63",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xE3"],

        ["\xF3\xE4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x64"],
        ["\x73\x64",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xE4"],

        ["\xF3\xE5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x65"],
        ["\x73\x65",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xE5"],

        ["\xF3\xE6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x66"],
        ["\x73\x66",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xE6"],

        ["\xF3\xE7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x67"],
        ["\x73\x67",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xE7"],

        ["\xF3\xE8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x68"],
        ["\x73\x68",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xE8"],

        ["\xF3\xE9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x69"],
        ["\x73\x69",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xE9"],

        ["\xF3\xEA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x6A"],
        ["\x73\x6A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xEA"],

        ["\xF3\xEB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x6B"],
        ["\x73\x6B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xEB"],

        ["\xF3\xEC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x6C"],
        ["\x73\x6C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xEC"],

        ["\xF3\xED",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x6D"],
        ["\x73\x6D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xED"],

        ["\xF3\xEE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x6E"],
        ["\x73\x6E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xEE"],

        ["\xF3\xEF",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x6F"],
        ["\x73\x6F",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xEF"],

        ["\xF3\xF0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x70"],
        ["\x73\x70",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xF0"],

        ["\xF3\xF1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x71"],
        ["\x73\x71",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xF1"],

        ["\xF3\xF2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x72"],
        ["\x73\x72",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xF2"],

        ["\xF3\xF3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x73"],
        ["\x73\x73",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xF3"],

        ["\xF3\xF4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x74"],
        ["\x73\x74",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xF4"],

        ["\xF3\xF5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x75"],
        ["\x73\x75",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xF5"],

        ["\xF3\xF6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x76"],
        ["\x73\x76",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xF6"],

        ["\xF3\xF7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x77"],
        ["\x73\x77",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xF7"],

        ["\xF3\xF8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x78"],
        ["\x73\x78",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xF8"],

        ["\xF3\xF9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x79"],
        ["\x73\x79",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xF9"],

        ["\xF3\xFA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x7A"],
        ["\x73\x7A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xFA"],

        ["\xF3\xFB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x7B"],
        ["\x73\x7B",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xFB"],

        ["\xF3\xFC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x7C"],
        ["\x73\x7C",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xFC"],

        ["\xF3\xFD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x7D"],
        ["\x73\x7D",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xFD"],

        ["\xF3\xFE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x73\x7E"],
        ["\x73\x7E",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xFE"],

        ["\xF4\xA1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x36\x46"],
        ["\x36\x46",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF4\xA1"],

        ["\xF4\xA2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4B\x6A"],
        ["\x4B\x6A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF4\xA2"],

        ["\xF4\xA3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x4D\x5A"],
        ["\x4D\x5A",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF4\xA3"],

        ["\xF4\xA4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\x60\x76"],
        ["\x60\x76",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF4\xA4"],

        ["\xF4\xA5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\xB4\xA8"],
        ["\xB4\xA8",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF4\xA5"],

        ["\xF4\xA6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\xC3\xBA"],
        ["\xC3\xBA",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF4\xA6"],

        ["\x31\xF0",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xBD"],
        ["\xA2\xBD",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\x31\xF0"],

        ["\x31\xF1",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xBE"],
        ["\xA2\xBE",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\x31\xF1"],

        ["\x31\xF2",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xBF"],
        ["\xA2\xBF",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\x31\xF2"],

        ["\x31\xF3",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xC0"],
        ["\xA2\xC0",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\x31\xF3"],

        ["\x31\xF4",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xC1"],
        ["\xA2\xC1",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\x31\xF4"],

        ["\x31\xF5",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xC2"],
        ["\xA2\xC2",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\x31\xF5"],

        ["\x31\xF6",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xC3"],
        ["\xA2\xC3",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\x31\xF6"],

        ["\x31\xF7",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xC4"],
        ["\xA2\xC4",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\x31\xF7"],

        ["\x31\xF8",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xC5"],
        ["\xA2\xC5",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\x31\xF8"],

        ["\x31\xF9",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\xA2\xC6"],
        ["\xA2\xC6",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\x31\xF9"],

        ["\x31\xFA",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\xA5\xFB"],
        ["\xA5\xFB",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\x31\xFA"],

        ["\x31\xFB",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xF9"],
        ["\xA3\xF9",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\x31\xFB"],

        ["\x31\xFC",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\xA3\xFA"],
        ["\xA3\xFA",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\x31\xFC"],

        ["\xD4\x63",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\xC9\xD8"],
        ["\xC9\xD8",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD4\x63"],

        ["\xDC\x5F",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\xCE\xA9"],
        ["\xCE\xA9",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xDC\x5F"],

        ["\xE4\x69",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xB9"],
        ["\xD2\xB9",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x69"],

        ["\xE3\x78",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\xD1\xED"],
        ["\xD1\xED",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x78"],

        ["\xD9\x21",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\xCC\xCA"],
        ["\xCC\xCA",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xD9\x21"],

        ["\xB1\x3B",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xF6"],
        ["\xB2\xF6",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\x3B"],

        ["\x31\xFD",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\xC2\xFE"],
        ["\xC2\xFE",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\x31\xFD"],

        ["\xC2\x2D",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xBF"],
        ["\xBD\xBF",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\x2D"],

        ["\xC3\x7C",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\xBF\xB7"],
        ["\xBF\xB7",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC3\x7C"],

        ["\xE4\x50",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\xD2\xB6"],
        ["\xD2\xB6",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x50"],

        ["\xC2\x3F",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\xBD\xD5"],
        ["\xBD\xD5",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xC2\x3F"],

        ["\xBC\x74",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xC7"],
        ["\xBA\xC7",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xBC\x74"],

        ["\xB0\x29",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xAB"],
        ["\xB2\xAB",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\x29"],

        ["\xB0\x48",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xC2"],
        ["\xB2\xC2",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\x48"],

        ["\x31\xFE",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xD3"],
        ["\xB2\xD3",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\x31\xFE"],

        ["\xB0\x52",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xCD"],
        ["\xB2\xCD",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\x52"],

        ["\xB0\x54",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xCE"],
        ["\xB2\xCE",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\x54"],

        ["\xB0\x63",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xDB"],
        ["\xB2\xDB",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\x63"],

        ["\xB0\x6E",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xD6"],
        ["\xB2\xD6",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB0\x6E"],

        ["\xB1\x27",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xEA"],
        ["\xB2\xEA",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\x27"],

        ["\xB1\x23",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xE7"],
        ["\xB2\xE7",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\x23"],

        ["\xB1\x2C",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\xBA\xDA"],
        ["\xBA\xDA",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\x2C"],

        ["\xB1\x29",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xE1"],
        ["\xB2\xE1",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\x29"],

        ["\xB1\x3E",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\xB2\xF5"],
        ["\xB2\xF5",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\x3E"],

        ["\xB1\x5F",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xB2"],
        ["\xB3\xB2",'letsj','jipsj',{'INPUT_LAYOUT'=>'D'},"\xB1\x5F"],

        ["\xB1\x58",'jipsj','letsj',{'INPUT_LAYOUT'=>'D'},"\xB3\xA1"],
        ["