#!/usr/bin/perl

# mt-aws-glacier - Amazon Glacier sync client
# Copyright (C) 2012-2013  Victor Efimov
# http://mt-aws.com (also http://vs-dev.com) vs@vs-dev.com
# License: GPLv3
#
# This file is part of "mt-aws-glacier"
#
#    mt-aws-glacier is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    mt-aws-glacier is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.


use strict;
use warnings;
use Test::Simple tests => 1065;
use FindBin;
use lib "$FindBin::RealBin/../", "$FindBin::RealBin/../../lib";
use App::MtAws::TreeHash;

local $SIG{__WARN__} = sub {die "Termination after a warning: $_[0]"};

# Those are random pre-calculated tables, not a special test tables
# so this way I only do regression a testings
my $randomstring = 'TDvjTNoOZdYLHGJgmowQQPIANymiZabVUgL4toMOXtAxTVdAb3fHc7djq3CWvg47qp9e706QoGMA2PlhUyHkln9mw2G9Y1QynMS5zejFweL4Ll72P5eHSHXmzSBGZ4Xa';

#my $chunksize = 1048576;
#my $chunksize = 200;

my $check = {
	200 => {
		'TDvjTNoOZdYLHGJgmowQQPIANymiZabVUgL4toMOXtAxTVdAb3fHc7djq3CWvg47qp9e706QoGMA2PlhUyHkln9mw2G9Y1QynMS5zejFweL4Ll72P5eHSHXmzSBGZ4Xa' =>
		{
197 => '8df4bd49b43151c67ffa840eab9ef3b41d2ab6b9b1ff1c814efc06ebfa2bf3d8',
198 => '2c86c2274abfc6ad860a0a01f80a1b3e99783b822872af84289d3f67349a5e9f',
199 => 'f2c98aa633a8fb3a1374957c5b8ea79f8c065202956445dd71c4c4200a4226f8',
200 => '7795414407259db4a9c2c440538ad9bdb34988e89fbc8c61f73702f6c8a87894',
201 => '22b93237207859002de9cbe1244a8d78a10dc41b1ed30795d35aa5d02b54bba0',
202 => 'f3b1eaa1a7fbc7ab884d2694f91330e5be88bd5d127bc2774e5a6dba56dbef99',
203 => '89d0013ae7d167e608b9edb68428f4cb75f7167795b064f591b90f62bd3304a8',
397 => '74da15ae2017c90f90d851698b45250b1d5841e98545447b1c77a6f4c6176198',
398 => '72688a4c7ad23f01a08fded961b10423ef665b0ceab6a9866a766b53f2d4d358',
399 => '1b6b74b3dd32886ef0b2f52ee684e574652d0755ccecfa00b9bf8bd67422d64f',
400 => 'f41eb8760a58073ee6ca52f6eac803db496934ae09ff8d9882ab69c9378508c2',
401 => 'ea5caed8285098f72dc3205c7f87372c43e94f42c3e62f6f4449567bb933a5f7',
402 => '7564ee61fa8ac978e3d72a32e5b5eaefbc2221b77ca3a3d7cbb2f9732aad828b',
403 => 'f70e6a94e658ce4e71f5ed27bb8155e9ec953acae16c3faa6219ada733e7215e',
597 => '5f0eabbee0c8d502a9f67f489c6bfc7545cf7722d551f12a4dfb1bbdbfe8b309',
598 => 'd7a3eea0ee6f28ea9abc0d2607b669e7a3db38becb37de4a9ba5611d4efb667c',
599 => 'c477aececf1a04b16b99635c78602ebca896441cbc0ae9c2da104a0800d9a49b',
600 => '987eadfe3aed389cbf649ac84e7740685908dd9ce8110e4b9665cf8905e0aa6d',
601 => '7ae2057ee95867205b8c1c7c25c5cb4990c964fcac8ec9c4d29783d3af4e9712',
602 => '43c192a32cdbd6b598f846fd54125c29b715008571c200f1e5a7db5f082cda12',
603 => '1ddbefd79fa9d78830bb2ea445cb2c77fe8efe56c4be55cdf86600138fc88e91',
797 => '555a0943173e43dc37b63a1f6453115cc52d06ac6bf4288ffbfea90742f5dbac',
798 => '63b072610d9ff4e24a804c95912136ba5e04985ba9062b30681e7dd70b8e5dd8',
799 => '5b8a57b10b8c70ab00af318cf75f2186417944864124ba8e2117df7be5602f91',
800 => '810e4045c8c92a87c7072a677003c41866665fb31797ca23b8e1563e76ab5e06',
801 => '3156a54b831bcac452f650a40836b68c16b698c8216446a8fbdcc498b021c2a1',
802 => 'bd9277c8d84550ecf835b8ce5faa910f49e269c06cbf030669c1da2bf1ae7d80',
803 => 'e8b3cc1386307fc826cf55d7c48b559bb9b568f3876f843628881a14374f62f2',
997 => 'ec4d8e85cd26332f9a93a4ede73bb0b4b17dadb983baea968f7ee0c5b46d9bf2',
998 => '9b34b7b44f0c748982ecc5ee3d99e3763e3c68cff7ae246a542422badb942f0c',
999 => 'df66ea25a70300d9a6c7299402b1c4c412cd088c7a6128db92fe58525ad7427d',
1000 => 'de19616e2fa06806bc28af712a3649dd9279e36b55aa737fde855475e0de9064',
1001 => '5cb94fa36f29a2575adc4cc7ee3f264531ecf4dbc5980a18edc687e2a72f4514',
1002 => 'b46c72f464f9ed576dd726bcbdd370095c7d3c9705083cc1b4778755caa8fd43',
1003 => '75f9859fbf36769506bf575a0f15c5a79322fed69729c91a9cb633b0a66d8e5a',
1197 => '581cd076dfb2be452f78094d9cc3c1106578bf2f92c135f935a0eae5ef4ca41c',
1198 => '2b1b6d1c4d63c3b4f8b3e7927310729286b24df58e651151a1d1a5f8d9cd04b7',
1199 => '7d20bff6970954708c86a076d0900ee15d1d557a58adf633c010a612dcc33dc7',
1200 => '67585675f7f89ccffef75726fa5c82e2e1d38135bea1daec776b63bc6b7a141f',
1201 => '39e0e60f308c0cfbce9ac821f576d194498774193379a5cfbe4fe5b96d30c7d2',
1202 => 'beb06349a3ebc2ba0d258dcb5bc69bed8228c206fd2f8dea9da9001a786f8533',
1203 => '4e9a6f07399fde248625028ed22c99e23c815840fa1e3e35d47bc6159675db75',
1397 => '3c5e4b6b12db9b5a968eb1c61a64e4e17ab5d57893f6c2bbc863fe9902c27960',
1398 => 'b9af896019891b7a4b7ef8ffe09e43b13cd3d0061977f50d78d1733f84ba4035',
1399 => '6e98972776e6d73f369a9f3dcf291e5f00475fd314bd7716053ec78ad2d359ec',
1400 => '095c549ab9820d9274cc19a4de02b84f429dc40277370d2322b49e1df02b5c22',
1401 => 'b52b57e5ad6f26569573799ddb7d947ba7989f9176708247e9a8dcc6f0538c6f',
1402 => 'afaf5cedd3c2f62c515b934f0e3d3b79d4042b23af1ee55bf43cdd9c5c420514',
1403 => 'e558f20315de9c2cf18a3cea5a7a103683b35686b1258592e321cf509e1ae7ab',
1597 => '3fb46d9025c0f1ead671a861bd379c7eac8413da3c6de417a9f1fe5a1fefbff5',
1598 => 'a1b8534253818d310b68d67e9463b996e874852db12b3005ecaa6cfdc9046927',
1599 => '04a74217f46e6866a1aac384f955ee12853efdb41c7c0c29c5853350ca1e4320',
1600 => '4e327a4c4c83d2434ac4e07031ce2517172fdf32fa79216762a7739f76026dec',
1601 => 'b9b17014b3dac5353c6fec21553af50e9c5ab80138a29eb0719098fa98a153dc',
1602 => '3d5d6ae53c70607d8dc8ec5e5f943350e8597d69ccba1ff63364733f546cfcef',
1603 => '93fecabe17156dba2e171431a9c0de0e5cff9de90ef69ec45695ea1b8ed26c64',
1797 => 'd8767ae1505726367f8a5faa75a78c849c057e5e2ca7e0c8354eaf4e0f8db7f7',
1798 => '06d00c5ff132049a724ed0327aba3778afc83c12d4d42270ded318a73b86f9cf',
1799 => 'eb173240064e7b8e375efce4f503848baa310fd3452cf66768ba49998c722852',
1800 => '0d61aa0bdc3283fc89d77b18ffc909c014d2add3fc67bdafe12ef1947be5aec3',
1801 => '77ccb2e57d56e76b39d59ad5799aa0a7d311c46fb3691772b2fd011bff5f5871',
1802 => 'a4b461674f529d9c1c548030b07d964f0c448f33e33996a284f09acd84f23d71',
1803 => 'f80e80f02b7f6f80127f7a0342d6d593efb147588e5962314b6e87a559275883',
1997 => '8faf3594dc34a13048804acb2a75158d209f630e285fcc0f1c7842bb4a744525',
1998 => '2506bceda7a3ed9eac719f07d701bc2b0191301e837f1b00a64a3066093e4d75',
1999 => 'fb9b1c3a66a48cb417523c4699b81064e9344b8cd2c49a80ee697bb3983ab16d',
2000 => '4300c46812e8777ba0015ffb330b64bbb77fa8988f6928d1ba80c20d1f75a636',
2001 => 'd8f8117d7a0292a4ac1fd4df44f6faf5ec7c5fc3b79f90b8445f227613e31e8f',
2002 => 'f3fe5196eed75079dfce34cbe5a615ab5c55a2d2c31d671955848b971208f12a',
2003 => '243d077c73ab751673882bf13303e7e09e36578a3f1655860bc886aba9f532a1',
2197 => '04ab5ebbec9dc382aecf1ab076e865773a5fc8a6dd0ee461e827f84b7efb52ea',
2198 => 'c8d57265febaf9b5119a65a5ceffd7c4c304d96a665e2ddf9a6f4d80e24f67d2',
2199 => 'e199624198a4d95ca890779831e070244d8efc180cea16fc92c3631bb83e1a81',
2200 => 'f9691c9ecdef9b7f7415f9353dcb7fb27a0a7bcffc460962cc5f01929424b649',
2201 => 'ab161bdc4d69b2c15c0c6d3891791da298f8dedf3c831cb7f7f93ef5755a6a28',
2202 => 'e5d2a5116b4651abc1761b785c24d2b929320bf1d8fa0ccb7e6a822130f264ad',
2203 => '8a649f82c3bb7bf81b030cd2b960eb2f14693d931475a7f8b25fbd6d593d4d25',
2397 => 'd5e9969283130135b46ec9251a6c286028dc31b19bbd85fb137cffc0c95bd909',
2398 => '4853d629a52dc8331df98ce187dd5119f06854769cac4e8f319c8034d9962b6a',
2399 => 'd8d64173960f5fdacb7a140502eea8317bcae3314ccecf913cafbc6e8425a4ef',
2400 => '4ae05bc74a8ff142d5096961d70353df2296d2898d77fcb499499b9c1f9973cb',
2401 => 'ad78b09bd2f663f97764bc3f252a0e261a28b7e2af25c4e7e247c80eb0f62c51',
2402 => '18a8b6a173abaf92fd74ded060a60333c0929e051723910202bb0d0b833fc025',
2403 => '11ba4e42d31d520b196732008a27ebcda3f80ae00f2ad8df407e36153cc72307',
2597 => '3f09d017e7d25ad33f596c1e64f6fe5da21f846374ae011faacf94bbf44dab59',
2598 => '149d66fd073ccdf6558c96a58eb9e9ed7d25bacc0d9d5cf38792a85576c5c74a',
2599 => 'ac4cb6fb830c7649f0df3eeb48334aed0f034b46d9e9b73c04ec9f1ac140c2f5',
2600 => '88482a2553e6c07dcacfcf42d6b0c5fe6c566c2e414a70c705cb90dd47497c65',
2601 => 'dcefaeae57109e4444334a9c6c4cd3f9c0c24ab11ae2e6508a80d23a6fa2a711',
2602 => '4cf917882f8d9c44db7415cd51e043a1723499549e623e1ecdc1b32a9a631223',
2603 => '0eeae3e65711bdbab7a621d5efc147f155faabee95e777cd8dd91eb2c1c0aa35',
2797 => '624d856053339be1c189bcc4569e28ddd2320353ed742e80933daf0279d67eef',
2798 => '829693a9f3c28476e904acb9740f7ff9d282480ca039f812d8dc8cb1b409d170',
2799 => '177e773fccc43db905310b4f9a62f82f8b72ebdfac1b7a9fce39ceaf3ad4a732',
2800 => '5d30fc3607654fbfa46766b3709173dc71b57cf2c7e8a676d4c3fec4550e7a24',
2801 => '593988a1590402b3a9b49a64728fbc6ea0c9fa7dfe952cadb78ed0c67d1cae44',
2802 => 'dca7bce81f0d25ab77fa6ea64a34babd27378991f7ddf1c1aed28d36614e932d',
2803 => '5ed4ad83166957cf4e825d18ebd0b4879c83948ff24ded471e8bf8fd7c36c7c6',
2997 => '657b339d7603f3c4bbd41d5c9a932acd211214c3954888180591a35003a7d85f',
2998 => '62f07816843057897063bc420bd8e779dc33cf2a91d19e89a836adc9bbd1367c',
2999 => '10e44b2f63bb8883ee0618facd63e25efe238dfe5fca60ba63cc1d42f260e57e',
3000 => 'e9f1245ab8562e9b614a61f2936901b40b26c81c2e96628da7975149e88d377b',
3001 => 'c1c82e5902293193338c391382797e1ad662a6024fa5bb4644aae97112a53240',
3002 => '254b6c39dd343f9f826fce34db2dff2dd1c1e1ceddbd002ba2496c798466bce4',
3003 => '7fe01177005b74ddc274722226e38e1bf5175f3702d165994ba3b3a789fe4658',
3197 => 'cc51451f1dfc0e4df971baa6e2629171444e844c7192274de3724ba38f75fb90',
3198 => '1ddb6bcda585b9c9cbafdeb9ce9e8cb3a3ce8356c0f2f5c634aba839ec4c9b9a',
3199 => 'ec7dd2aceba7e024d747752c5503e6cc91bc19f895edb02d553ec2a885ff026b',
3200 => 'f22e3050f4eeef4290caaa118684ba9ba44f01aa5dd0fb98247dc1ab96725188',
3201 => 'ed8559d9ff42f6b97e9f0641e346c1e9378956cfd172fea82b15ff650c969c98',
3202 => '0bcf1f6b92b86701ef1ca7f1d067a6527cf1f91427d357f9060c9f5b064e8b7f',
3203 => '1042c79951a3dd7f38c33d639dfacff0142597750bb500c4ec35620032d0445f',
3397 => 'a480dd041afd3615793fe67d34e4fc7ca34fe74e2d62dce15f0a463dcddfaa8b',
3398 => '0e5d1a7c18277e729412b79e840f8f4aea5870202775c388ba99c4ea5130c93a',
3399 => '38a8eedb8de4e4e4ef723a9235de455459ac41f225d395048c95c84c5510cec0',
3400 => 'b4a72d7865a44213ea3986c7050574861fc5923f484d36c0d0976fd19f15c5a4',
3401 => '4f4643c0db4d86e1f71c35455f17b0dca0949780ac4a3cb53b7019f1b0b9a474',
3402 => '18080f640d085adf89badb4a99b5c662b27d8433e571e356be4cbc096343876c',
3403 => '876c3072e80bd4984224762237c0d53cc7e888244b2eb31a207285f814125ec6',
3597 => 'e58454f85152edd7c732a382686db2235a24c827b18e61c27a0fc58023a5d948',
3598 => 'c1728ea2e441a2aa1efe1aa8c14e98f081830924aa75c5f219d09842004941a8',
3599 => '84fe77522ad451e5b74072dcd7adaa6de89fa4e2b3ef4b32def26a33c3d2f34b',
3600 => 'e52cba460fe6ef39d9d8dd062b695f7ecd680f0191ba95a085467754b54f72df',
3601 => 'cb096895ae535a121e3cc06d3004603dea5df5b8dd11693ad114469667540ce0',
3602 => '087bffbf27472134c732ed20b119467fb66bfea773145d1f5dfd2922bfb08052',
3603 => 'eacbf02eff7a0b19077db5e4355e1a3195912f404e121e98cd7de6b0d3416fce',
3797 => 'f7153a3c9f0eb16a6b3c9686a419a2ecc53274f6521f9859c4f604022899ae13',
3798 => '687dfe53261200ac7f1a1d3a7dec43f216c8a5f498fd3e14b76ec439ae836876',
3799 => '6a5fb86c0e9b35a71ae918d22a704bd3b47aa6874cc3d196eb6fe7a96d434d98',
3800 => 'd2344b6cf23c4573deec6e68e9dd08d11aaa2f6a63c9d94bfe62636f04df858a',
3801 => '68f247e2136b2ed8a6aa1499267faad8eb750ab4c071f11b93448e0903d468e7',
3802 => '3d15265c8ce15e71b795563c23e7ab4b52ef8fb908b8074a87c411ad42f2ac2f',
3803 => 'f6963d716ba90217c0d75541e4a80a3d55d3261e82137341d5b6e0a24ee519d8',
3997 => 'ef4c047f01caf25b42515a743be41c3281e8fe146feb2d7d94db9c054f55583a',
3998 => 'e367187f72f7371e90c2eb0119829ab43feac209003696a088091d1d5cc0e5ea',
3999 => 'f8e3781db1cd0711cfdf1ccb365f986342ad44e2c112c3d842b63c962d5d661f',
4000 => '96c0a862f1db0ba771b4dd87955aee731c6cfeee70a115f424a2725a17826fb5',
4001 => 'b18d0d075a276831e1166a3b87cd15e576c3ab6183036fa9d085d2a77df64468',
4002 => '9c6906bfe0b23d890d6a41779bd62db6939572bd3b3004503f29eece0221030a',
4003 => '5881ad70090129f049a53a0b1aa5cd8132d440f0281a1ab8bcb171d9c9365d2c',
4197 => '464e47f8663007a69fa3321108fa89f70ff83f904cb5c6ca3d11bf2148f096db',
4198 => '8d15393c1a641ad1cab3855ed8c67e2c8d6b2bf83bf091f84a9ff770d3223281',
4199 => '8d2f2fd547f4bda004db04df1f8115351ff33241553bb11f68a71ecdce9bf926',
4200 => '6dff3b962746794b84b94cc5bdd2f577add79c5362eff19f21b90a2f81d79226',
4201 => 'aaabde3e8b13460cb2593b867cfc88d6bbc5ffe41e942c126a18dc52e1c84514',
4202 => 'ea0d2f314b423b289eec1efb5f92d6862d5d31c08e2e888a897931bff1ed66de',
4203 => '9fa363ce23de286e9f2b1e47421a8c70d3a27904f75ac20da7bc9a1c5590e0e4',
4397 => '49d2dff47772b65690c75552fd8d98746ba27d8c2c1e88e6cb06050ff9563d86',
4398 => '81d18a721853871ffbc438ad5610c9c5ceee595f3c3eb8ad67afb51116e3d54a',
4399 => 'd2d2c6640d67131d01e397b5b7729c932eb1d5534e9b45dd7ad6bcdc3427c9b3',
4400 => 'a14433f2191ac12ab52897ca3ee3a2a65c2599a46a1175ec510a0ca4e6412c09',
4401 => 'a4b8fcc06dffa061f8d55b9e4a8a42b30ca2d3a2d1c24ed4f1008bbc272a3588',
4402 => 'd1d1a2a6159a89163d22ea02608aec2680761e7a19b500e5a1889637bda0207f',
4403 => 'd88e94b335391b6580024dc6b817125755553f4d21717298c92d1e0becf4478e',
4597 => 'c0c1e1ed58938debfe69ecaefc8a0e9530f1a954901ce97d0f23fc8dea61035a',
4598 => 'd2d7b494329b7a81f743fc5ece7dc31a33f5ecf9dfc954c78c952dd815aac858',
4599 => '9d6af2f3560629ffd926c055d6addd8ce966e635d5ae702d6853506a26091801',
4600 => '2bfce615133389a728ce34ff80c69e662bbf8464995529ea847cbd02af186692',
4601 => '4f084623ee5204e56d0809daa486de92863554cf7d1089c65573bf4c469aee58',
4602 => '3151d3d8333d0dee1575c34ec8cd7e4f7743f335b1937ff0ce16d5daa0597bfe',
4603 => '7ba42415c4c050488f96275acd78d93d64e9a83bff694507d9440eb3b22b7b94',
4797 => '12d0f5241139640d83de13daa31e41fc5ef55cde05fd0db0c266a3e1ebc3e6e1',
4798 => '212192a08b9c74c94ea112d72a862989ffbee2800d295e0b1350b5a8e29b092d',
4799 => 'af6d8a26812fcadff344766ae8cf3e5d3aa52263bddc3a79163eeae323f037cb',
4800 => 'c143be114b891e50cf65b63843275e8c1896279f317ec7a1b7af15561aa70554',
4801 => 'a45290a7090e5114aeb9d0b04c271bffd238f634508b1c9ddf7a27d00dc97c63',
4802 => '61c5862b70cff2ebb9bc43f13a6e9c589b2c3abaa8bb0c680f6d963c801eeeca',
4803 => 'f9e0f9052734033e2d4bbb67b37f8d8676ad048c10d3d8a617910018c8d15045',
4997 => 'cc8398a92f787c223d5b5097882ba813d8228c271e411f9802b5c8f2fe7e84c2',
4998 => 'c89331cd2edd3a8c1dfae5645a68860c59a515353725df3b90785780f65abeaf',
4999 => 'cd24edb1758741145371c14c35d71de9d5ee721b85d0f45d3d969707bad8bcf5',
5000 => 'c8c3e2fdee3e47e3ccd25f7839374263add86d36f2ee9422542256166079fffa',
5001 => 'd68c9ca98b0b521845b837c30e387a3f19d88f2599a41f6b24ea2944b1a7bbc3',
5002 => 'b2bbcd3d68edf832d2e640046883d081140916fb99e9b6e619f88ee23a1ead9c',
5003 => '961315de9ae21ec032d2a5cd13922462eceac17e44f968af32cfc4b84d5ca972',
5197 => '5645271ecdc0a9bb8583b6c950fdaeddbe1a03c4a6a808beb65ab5218f3996e0',
5198 => 'af861c02791322b63ef70f495a392c807c11efc79e4cdb3354e1233a03483943',
5199 => 'd0c7b368412f9b4e42a60c22de8154944d7d1691598ba9c81c79e53e8e860726',
5200 => '47752700cb6e4b44e139de2ad77ab7dfe0294d19b3320eab37831fc1a3651316',
5201 => 'dafbae3fdb392535ad14d89de00cca3535eeeb5689c4b7538ffa4618e70a10b3',
5202 => 'f63bd8aff16e25618dc554bd5e5bb2135a85bd964b32a8c091bbca0bfcbeba46',
5203 => '537e6a9c0817263d89427016c2174054cb0fcd4be3f7628848e7f5a2782d90eb',
5397 => '8aa54c15767cd635f2d26cddcc61423b5466895c2d4cb8dfad131f64069d376c',
5398 => 'aa5d6300016bd1cf0356dc78130ced590c287f6940da5a1edd027bbf545b738a',
5399 => '029af432c30a5e3517b855df81467ecfd2b656e721f8aaf7f58f45d4ddab58ca',
5400 => '87ec1a0242bd9a9426bc5f9a3e75cc22985e8e9fef61bdbde1351d225091a663',
5401 => 'b3c62f5bec0edfe1e59c5457e29a7e3aadab2101e65c8d184680d6db377a2628',
5402 => '9780d6b23b96c81e488f839993b093d614a0b600bc3b122436ba7de1c553a836',
5403 => '9f61e650f2141dc073826bd07cb85a430f30612d76d7481b82598b75679a1ce4',
5597 => '27adbb14e6c3e13471ff9f8840f27b4450f00b88e1785d43cdad54c6c5bd6213',
5598 => '5b3efd8d811939fca3e6d3c0fcbaca6edb4374c25824737c70babaeb0b9cd1b2',
5599 => '26c66c28562d61ec2839d8f53de6a98061737df2f846372d736ea81af457a022',
5600 => 'df2348aa88a9e779c3d83d91e273352125f5d323a1295f9191451df386c9229d',
5601 => 'b0c12d57c3aa438a0f0f361f839b468aa47df199b3c69185994458357da1a8af',
5602 => '72bc24da77e643a68797098ca66860437884caf2c2ced8582cb7ae12e2673aa4',
5603 => '0222df4e5c78fb1f0c3b85cf0fbfa7bb46b9770618b16c872944f9c70f01bbc7',
5797 => 'ce84e2ec0eb0c1e082cbf790ba7cd9ec3aa7cbcca2b87bc9d9acf8eb5202e572',
5798 => 'cbe72517caf03b315b581910e42f602c04abf17697c95f4c2b6ded203f48974e',
5799 => '9a2513fdb09f1b08786d29f6e03743da29fc6e3b5626c5ea28fb82327de2d3ae',
5800 => 'af7af68024d9a577af72ebdd3c1e4efaf1e6bc89a4224bb847321e7e79916322',
5801 => 'f3be87cb76f4f9d074380c177fe0c69929e2cfa91ad7dc04c947f07c1189ce76',
5802 => '3fdb925410956a1de4c7a64492c8225687e845a374714370803393aaa838d1fa',
5803 => '8807f7c690bad4906d479ed182b998d2e5a368fbe7e76de68c0c0d3a6a86d44c',
5997 => 'db72d23058e9d18bb95de75893b4934a010abc54925c361f58f4e2bb0ad375db',
5998 => '0a3e7724e2f8d98801268f6a94bc8c0ab749fd177e3a81628fbcd782957426cd',
5999 => 'cab36e482f18260b343fa347f88f88b98fef9ba0f85737f65ac1eb879c8ac616',
6000 => '083cee952180130190a8b7ee0ff3121db5f43c1f7d636d207fd2086012f35995',
6001 => '53588f8661a87df8bbeec8ce2a51b8470ca2e5da22a4e83b5aafe509f5008d9b',
6002 => '101e6a89f26a407cdfbbeaea2098490851e506ab3d96d63d5dd9494ffd00b264',
6003 => 'f77ed94277a283fb8996d2f37a4293d1dcce642984a0901c81f58b565d738e03',
6197 => '3f4a67f770f81b491a4cf091b51fbbf2610fc60787585b6778aa687ad7bd30b4',
6198 => '24299383e50d2a4a629851a16e2c0fe40568f2a59763aea71a50eed062a4379f',
6199 => '4b6708dc82924d051643c5ddf3f94a727d776f6113bc712527652efdf82bf501',
6200 => '49ebd26c70db2d5fc4dd48b4ed7f0ec2ce6f7481fed353e36a71837f798e12fb',
6201 => 'e4cb2c5e5d955078c544508c42e9d9cf8c91ea71342cf56130317ed128fc222f',
6202 => '593428efdd19206e475bfb5f2b43d9e3a3bc57b74117c5be105bbc88954295c9',
6203 => '8973c1401e80e36f1fdd590dd83499f8fb9ceba938cae11e058d0e737a3a8968',
	}
	},
	1048576 => {
		'TDvjTNoOZdYLHGJgmowQQPIANymiZabVUgL4toMOXtAxTVdAb3fHc7djq3CWvg47qp9e706QoGMA2PlhUyHkln9mw2G9Y1QynMS5zejFweL4Ll72P5eHSHXmzSBGZ4Xa' => {
1 => 'e632b7095b0bf32c260fa4c539e9fd7b852d0de454e9be26f24d0d6f91d069d3',
2 => 'b6a51c2aa0fba8cf9928d7a2382bc4d76a8e9053939962467695c7db183c592b',
3 => 'ed7e4853e7b5cb135218467b1a4410bd01c8fa3e632cbb92e806cdef5237b0e6',
4 => '77ca901378d1769b7a2f9999874f0cfbdc1f63e056ed64e6edaf45fb2cd278cd',
5 => '6296826f333685eed90b76edb44f0e585d14dcebbdcf5a0a2f3ccdea5e8da5ae',

1048573 => '42ce39ee2632722c3acad6dfd2a11dddac30adefdfeb13232b8ceaa10b62be3c',
1048574 => '2970b04ecf247b14d66a1e1d4ac7b54260a15e1b32bae845cc1d26371293b898',
1048575 => '1b4571c7df12150afa939c0a590785773e80b7bd207b7dd19b7fd3c2256b46bc',
1048576 => '1af41c69e98cc8dbb1fe9d3302bc35a062cbbf99f733c8cbe8586d1b6327b69d',
1048577 => '78d6c5ae312da5fdee8380c5bae35fde09e31a9987d7831854b7a7524ba6dc59',
1048578 => '1086d7a79033a7b611b6cdf3d4df182c08e68ebe299262cf48ead9c887c2b7f3',
1048579 => 'b6d74d27de9dd83b815c0c23907e32c5816e91b8d5df17101876f1ac646b4b6f',
2097149 => 'e9736c704f7cdb85fe1d1bb38183d77bdfffc896130f92e13f77fac8a4693090',
2097150 => '7706649cfdf6d6c92c3da32941e3a64e32e8a90c2d28308f1bc62deda4cb07a9',
2097151 => '6d700b3e5bbda257aeba9ad4ada6fa3111201d0d088695ee8695133b066d542f',
2097152 => '351132ca830667e2226a12adf29f02164f68267432a4792ed15792665c8fc5a6',
2097153 => '463fa8c133a4625f0b09d7af525f5b6255133f7dff4de4cb9090e5a6be92efd1',
2097154 => 'd8597003582777d2ac1f208051d89336a034dd1f0016bd12e67c3a5479428ae5',
2097155 => 'bf306127e4ab60d17cc8054d5ce485d1d5462a895c56872a52d6adc6fcd646e1',
3145725 => '2669af532ab035bae5b0e03c9f77b3f8cf10b0dd8f532d6d573e5b900ea9ff25',
3145726 => 'f680e9aba4c82f6c114bca0cca8438c3a546a3e47a9c37c108381691ee465f6b',
3145727 => '6a11594cae24cc053c41b42c4a528df1444aba67e03d42aca84b8f73cf1042cf',
3145728 => '4bba1bc0cc2fb572814ddaa23f73a54a55e88a26e1fee5f87e4a2aa37e258f3b',
3145729 => '621ea99da4194ffc0f71640f88d44845bb4eefc31bbf1e48798cdb39964df9c0',
3145730 => '5aabfbc8a4a48feb381229114d244579e6a0d733891052de088113f17a9a7cdd',
3145731 => '5e0bb260df2ec07e2aeeef62e864495f71d20de93f67a3c4c979bca2cf3cf2f4',
4194301 => '7a38e1388f4de1ea0e688facbc5838c973b0bb669f2afe1aa2206814731981e4',
4194302 => '377287534b7da474ae1ca2ab8e50192e1f99e7eac1a4364e3a28bf40c04f38b5',
4194303 => 'e44681db35cf8f3cfb0600827a60b83e761ccda47122154467eb5bc68f7c574d',
4194304 => '7e60736b0250ff9b004948cf4bf5fe720ab5e90a0b160fe0dfd0d76bda1fcf7a',
4194305 => '8e0f5c4c69efdc1d9401fb426416f8d950fdcb70d12c3642a4cd751164199bd1',
4194306 => 'e52aadf1426f9ceb6270794128e646cf70ec414d58a048452eabb8ad8cd304a2',
4194307 => 'e0b87273579b7b1bab569cd9c766965969d7bac0eb1585f312f3002744b87e87',
5242877 => 'e48ad886e3479e3cd2841f05ba8f0cf73d6f11af8f10ad31cddbd8b3c853f01c',
5242878 => '4ef132cfb878fed38013e76ad2b505ca27aaf41a48f1e0ba8cffe443daf92334',
5242879 => '9629ebea3ff0f05e47b14f8a987b5ba3bbceb3551cf438ea0d0facff289d571e',
5242880 => 'cf9481b7c7391c197f3fc1d6c1cc2cc07185a92520148b3b7a8271e0df4b5e69',
5242881 => '43af9dec5f1ca88f99e2c8f7c2ada6d03db6139cdab392d978ee116255741916',
5242882 => '6b0fc053746ed07f5a700257982827ee0ad3b90f38d3e7694242eac5d704ccae',
5242883 => '343c5c835bddfaa05d4bfa1e5cfe7e562fad80574e2ed2f736c3628b21639608',
6291453 => '3714a58780cb9e0a94196efd7b9fe7b26d1ba967e15062fb10e6e76e6d6b8ccc',
6291454 => '303e9782e909e501408faea643f3d5a21e679f446675bc506dd18745b2411282',
6291455 => '533d27f05433dcd6f17102ff0632c19ced6d9f2e349c1a064d5cc38bd96ebadf',
6291456 => 'a0d8738f7ad816f949f8c01b9d035c38877aca22246f87673ad57368f7d27748',
6291457 => '443da99034eadcb5984136ba8dbd276bb80889346ee9dc8684bde8d486e2bfde',
6291458 => '52c052ae85bd08f1a98beeed27d1e2c7bf55d694b33d8455cd8e410704d8d22e',
6291459 => '14c9dfdb5fb5a54a0471d758e6f2bfb0b0e986bd6617ee2163dadf704118d48c',
7340029 => '88585e43a98c76e5cfeffd0be97ed96512d422f2093d93020045a7761063cce3',
7340030 => '1ac26be1fee8ce0e19c0c0e092e5b113f34c773d0d8b16aeb77017dc76f7230a',
7340031 => '81ba01a62947ed89df779244a66c58120cca8566504823f5f358f8b344bb9385',
7340032 => '5e8cc28c7015f6b8a95d3db79917574b7fcc6fd5b7ca87b41ed4005f402e0c89',
7340033 => 'fb3b47e2d84262304442b46b4124f3f2bc61602c7f481cb5c75fe8ea5f590eff',
7340034 => 'b8bb1b0217c49ac0381c35d9f8a393147c774db733e697640304650984208fef',
7340035 => '1e3f275da95706c1b02329ab04855444cfdc7280f166089adc6d70c550555c65',
8388605 => '523097256a4bb057c538a56bff18aa11001a1e485a1ebfc73f21b99c2df83e7a',
8388606 => '55557ded65326b92ea0b3f246a3787b49e6df2b97b38e6ac925fc2daf8baf41f',
8388607 => '585124e8e75b3de88c51490e1c1bb7291a0a3dd108616a2bd753f2d8be23e9e1',
8388608 => 'c7cefac7374c3905716be15d1aef23ad9495b7fac4b36c2c67a4ae0d11c61159',
8388609 => 'f681f297dca3839e4894a3b3bb39bd5fc9999f83b2b4639aa7b4a7a661b5db5e',
8388610 => '85ce1a528e7837cdfd9b895d7503c48f663ac1259df490954a6f6ebc15ddffe6',
8388611 => 'eaa292e63eb4752fcf0e53be51eb901106ff65b1fe675cfcb2975fc0a1678f23',
9437181 => 'acef20de499e179194f147044edb6fef76d6f04fe16df2c8f7d3a6d64a919fb1',
9437182 => '4c6e80c2f179bdafcc3f3aa387c142c39a09dc2feb900d9a0361d9fea6ebf85d',
9437183 => 'a2c8aea898beefc97a5fc11b08691c97c84bcb9d914f98da525f9fea5b16270a',
9437184 => 'e16b6b41f9adf7c9fe5900d65e9a68394355d1f7b97a8777d0b45d69654776db',
9437185 => 'efff316b12b14b749b627f7476d478066134308d2466463567f4d8d0a67616f6',
9437186 => '990991b3215297e092cafb2eb60fbe352112bad4df96a6c30e7809a8dd8ceccb',
9437187 => 'cbc197fcd8ff1ef32051d16d6dd4c72e020880742c081651dc887952db4cd9f5',
10485757 => '18b2177189dbffaf81f934c1bc30fdc0bdf630da91aa6b176e30dec15eaa7125',
10485758 => 'ae4805d700002bf69d002577d2605c25a460d728e332fc9f3be9e1de352f3245',
10485759 => '2ecbdd7cb9cd6d26fa06e9d37f9f005746c74157ebc9eed90ed28e7611ab6056',
10485760 => 'bf06e6aa48a47f9973ea24fbdfefaff614952ed45b15aeeccfe29b729a83116b',
10485761 => 'e5afc77d81e9ad35ae49a96b12a4beb0ac45362d8942572fa8bfab2928bc2cfb',
10485762 => '80baa54f6621cbb7c8e56e577b5aeab47b6b64c7e31391e1ef36bf094ba97300',
10485763 => 'b828be8cdc159db227330fa0088ac3cdb9ea8e9e0088d961d5e84f07b8549219',
11534333 => '6d8bd8d36d979babcfde55b0f990888ed43d5407931b5db8cade5409e698fa59',
11534334 => 'e1e8876eefc94393c210068a9ce90fcc3fef4483c671c2d8347216c8419673e3',
11534335 => '4dd3d7c4a9ac689e2ddb3227a6a880b5e98a835343afbd38afff85ac599b62bc',
11534336 => '3b614b23a4322c125eedcf1d552ff48932825a827c96bf4bb6b726038e8105b9',
11534337 => '29e39b1ecc5bc008d2f4298abbf3d77cc652fe8f4c73495f7b65ce66171cc461',
11534338 => '50b29223d7075c6a385f4a6b7ab42b6818585e35d3bcf7d02a28fcb391658ee7',
11534339 => '932372d0ebdeeaade51190bc3a67633a5dfc34b2266139523e26dd41671b2e86',
12582909 => '0fa602801efc88cd729f192ab7968140287f3b64ed2bab05c99f86b64a5da659',
12582910 => '556bec52032ed5d860a7d7c1c95e50fb15f5f818e8583ac4109555121ea44cdb',
12582911 => '963466ef69e5f6b31268d583016fb11649145cc1e83a85c01c839f5fe3ba4a90',
12582912 => '23d6622324f74eac2d370860d3a996ae37400d65351216c84aa228c2d8203afa',
12582913 => '84dbaeaa4ad7fa993fe6b6ea195a920e34fdb0f1a844748ecf0488b74460779f',
12582914 => '78d8c46488bd1841724478b03f11af15b3c8b3c30f4bf4449a685e7cabfddd83',
12582915 => '455207a7554c5a1ee0424b342402859722e1480b1ebe233003aaa46ec0d69001',
13631485 => 'fdd5935ea10ab0ee641d384a260d04532751c735a5fa1edd9b82df28b13f734a',
13631486 => 'd078807ff5fdbda76c0fb3ee1aaec191bd97bc7b3526b200bedcdac1d68d5f1a',
13631487 => 'dc092eba291d84d7a8a2dedc79c09243274c9c87c6c1d9776d5785cda95fb845',
13631488 => 'a823aa50f504032dd79a5b64b78cc1aa89021eb13ef37dbefb49a94ca60283d4',
13631489 => 'ef5e59fa3a6c1f1ceded5ce4427d5a9d33fff8c4728505dc9e12d848fe0e4e5b',
13631490 => 'd86789d628fdec284356e4600d0f7030ec7ece12ae31bea46e0b31d7b64635a5',
13631491 => '906a4dd7eb3d026180c3a0ae716c4a382c2bca28719d2555e129e09790b54e6c',
14680061 => '473815b35e63a84df44a4895da0bf07ddcb5335e80bda1287db9cfb87503e1e5',
14680062 => 'd19f0ca48983c179357b500731b9383a92e44995128f725c7911a7a2e2ede691',
14680063 => 'cfe1fc46394b951d57a8aebc8642f51f582395ab39cd74a74aa9d852b9fcbbac',
14680064 => '014376a3ce5b21362540385cc08b5021773fcaf287386c6494368884978a15f1',
14680065 => '661587c006bb020995fff67aca5ebabf8fa3dd89937b832bc967c9b773fd9805',
14680066 => '4af96b4c6f3903989f4902fb7a66a97e6a47d879fa9b5713d7f28d6bcadf123a',
14680067 => '9f6144531788457940d91af47f6b61242c9e6d0369635640bb2908eee185d9d3',
15728637 => '75bba0c737eced396bab2150afb86983c5f3c9e70012e86678cecaa6d38bf7da',
15728638 => 'aeb8bd66201078676dda804dbf55c2b4ced53a4361966bf418bde6ee76711261',
15728639 => 'e734d2d7e75f34c058af3a20ab31557cb44b3a6932c9bb1e0f78a285c29fdae8',
15728640 => '91892db7cc3d41b3c82019778f21788df7a4be38a4af8973ecd54d8251c2092d',
15728641 => '98fde9ab7a6c7fd0bc68d99c7e7a30ee937b5beb84ca16bfedac71a805a1cb4f',
15728642 => '90f08c767eee06efdd1959953d47cf25c4d8806de1ce22fdf1294527b9e151c1',
15728643 => '95a353e4a50aae3c5bddb15a39a226e639eaf380933ef119b8d9d2cdba4c41fe',
16777213 => '0734b6f45e0b0adbd8083a88c555b856457f11b265a5e45fc0f02244d2115897',
16777214 => '43d8513e45f69e45a95a91ded26cf4745b0fd7231b869cc17875b986345f03e6',
16777215 => 'd1a9bbf07e3c9d563d2b786f56415351e2b7199bb1b6e4a436df392837fbc59a',
16777216 => '5e1fcd33cdaa0635d30b62f380a6857d32b999cbb4250706f0df20c5a2bcb037',
16777217 => 'c0190998eb02db84a9d772a644b8d60c572092fd548a1ab716a61a65d9f57cbd',
16777218 => 'e9a3431d518f382b78892ea40657049ffea24f7b71f3826cd012386982c67cf1',
16777219 => 'd63f0cf828e44059b17c3316e3cfb20a295fd5a47c85cce3a7b92f3411f29954',
17825789 => 'fd81aa423300c13eb7a3e3dc5560e5f19c926554ec604f94a5000cad3b718811',
17825790 => '8189fce53dc1cd7628282ea4e869357cacde040b872c1d228d60e0be1b7986b3',
17825791 => '2c843ba8eee54a67ab0b9f27eaf34360772c8361a4ebf6dc1799a15254b90d39',
17825792 => '4f53d1a319f50bd7169745c5425536cecb5b225fa20ba9384ea76c6a1ba8b450',
17825793 => '349fb3f77e406834f5054b340b87c05b5b0bb4d23bf54fb5f6fcd22ba112cd77',
17825794 => 'dbb5004702dc23b805fa84ca50974ad651a39b9fece7b19ec36b1e3cf7b05a15',
17825795 => '70f058fdf6c7a26df41b84f9754a9a166f04268489e2c5925c1b1436c92946ea',
18874365 => 'b7a1826a96bb477c7aa971dcf3843df520a900439c3d7e9272feafe4b5149936',
18874366 => '2cc1dc27d18027b3e6d23999c0127cb6e90ac2212ef5d67f4fa9e93b63370a5f',
18874367 => '0866089c7ee07f9cacc0f2f6752309a13e050050b67e1c8a3b57c488cc8e71c5',
18874368 => '14be74f3cf5adcd23ca213f4a80ba31429ab652f9aacd05a7a951f4aa0b0dd42',
18874369 => 'c2eed4289e560886c9f4607ced364697c9af6be283a1f15b198ccfbad97495da',
18874370 => '946e4f3ed0cad33383f52eca545ca2ad1a5aaaf9e2c4f994817c2fbe83664506',
18874371 => 'fb7fc717655d7904a60c078d3adb38a12b06d8c58474c561ee8c5ccf503590d4',
19922941 => 'c0d2a68acc31a4641cb30cf60c69c5f1c815e4ede4c7a62ece37700fcd754913',
19922942 => '18c7998060145cbad0e3ee85562e52ea91ec2945dbb5e6d4e98e51238d6844e4',
19922943 => '61416fdd4a012fcc0c3412c7315069caf29367411855fba9858bc39b2ca149b8',
19922944 => 'e23fc232177e71e918e87f4f88a352df217eed4a2c8ee1f685d0478e3723a445',
19922945 => '9152a862333ebf9b03c95361ad0b58eeac8c52e757f573e3831ccff065166bcf',
19922946 => '0889048cd42c2d4da4e18b475f7cec843c3a648cc6a82a4a811f59f5544750e9',
19922947 => 'a4f8485b49c927c5f57ef3d545b7c60728acf7b37d2844f8751e473db89ba4c4',
20971517 => '5bde91ededb23de29fbdc0bbef3594668ea8d122f8785da273eaadfb7887d274',
20971518 => 'bab65aab362ee3240019a179c877d4bb21039dfb8ef7cd89bc6f258243bfa6cb',
20971519 => '4122594f551e1c6d1c4ad8f41b6a8d27049602024ff550678e8934ac9497328e',
20971520 => '7b4ce024ad40d62d21ec77af46b16061852ad1b4091183f3f772994694586c4b',
20971521 => '6a0f2cb3ef6e5d3c21c2858fcbf97edecd19e4846cfbbd2c8e68aa42e41d37cb',
20971522 => '6bd14905761743f72790c0f99337dd74df1418e5c8decc2ea55bed9b581e5c66',
20971523 => '28b74bb42470d742ef288bfc6415c8072517d163e1eb44c41aa65631a4d53571',
22020093 => 'c8c5f8809e5c55de6d2e90e80432392e92b0ea9bbad6af1d792b631554f4bde8',
22020094 => 'e69e63a85b6d38537badc560bb0739eb7fe461a03e042f14c271de07f7032e26',
22020095 => '1dc192a58ac56fb8f2f2249feaa2189758b1c1b9064224f2da0031a332149c10',
22020096 => '22b496d32ecaf845bd23619b935b718ae7853042dac64cc50bf7b14c7a1dffd2',
22020097 => '5f3a2b8be70e4de3cbb68434d8e584de0471d3e26ffc287f3e16b600d914d829',
22020098 => '5ebf4c302034fa876f9a47084b6a3636726c184834442a7a5785d68252bca704',
22020099 => '842f3006a7be3af9c20f49a176d0dfbf6a023e1d144ef1584f84d1715ee4233a',
23068669 => '8c3ef8943ea57f180c1c2004350569187594866042f3cd916eef22566708102e',
23068670 => 'c00bc0599dd6865fd90b29f03bda92e78bc28a31a4ed02382967345bc0aa8005',
23068671 => 'a5bb92142f4fd48d9abf63d5366a2402b8fc0d3f40714ffd920f65f273dc848f',
23068672 => 'b0f9decd9eb24f350d7ef49bca2ab50ea6b84eba560b3cb129e765968f87ac00',
23068673 => 'c8c6dbdde4b20288287a9e3ec951b73c966023e8ccc54515c1afcee5ea04335a',
23068674 => '41c079b06997e79141942491663dc6b83e44c5cc32ee877e25a41753517ee92c',
23068675 => '792bbc516f7448608da98af11d7a549398c088406087f68a64f144a8c1efa682',
24117245 => 'b95a197d4d788479825fc55f35a5613d40f4447c5cc5a3680bc940cade876c3e',
24117246 => 'edae7aef51295f41e3d6e9014a5ecd536f9a5f1f3d1c057a1149f5443f49c299',
24117247 => '2319d46ecb934253511650ee6e17d4d437799e85f87e0d7ceb5acc9a9e5b9ddf',
24117248 => '2ea14761debea1f2cb3d34e25fa9beae3c4d0d9c902f931a1cc0958343124450',
24117249 => '616d53eea67431bde581e085b11b8fbd394cd7b82c7467676bd7b2814d5c4bee',
24117250 => '88b510b4cb4cf806bd66458ac14f6850588955eaee2bfa8f46c5a784ecab693c',
24117251 => 'b600cc1a6edb66d5a268c0e99e428e198324bc83a5fbd6c757aab9b266557cb3',
25165821 => '97ff659d8f7fe278c7e6c0c12d36082a84ceedff43dfbe2a18094064ecd49cd2',
25165822 => '77fc3efc5d69f3874375f9d297c824b23510d5fb407f06e51ad230f77872fef6',
25165823 => '86778551f7f219325afcf20e568d7f305be08584bb68cf68ee8b556e0caf4b87',
25165824 => '57113c20beb68687613d20d2af05eb916978f585b536b92f895f67076bbc5a9d',
25165825 => '7958d827240d8ac4eebce066d89c6e37a7bae11e9cdb24fdf3a399754508dd88',
25165826 => 'ad8875ac4c4a54f971ffb49401186b8d00603ce0e4f8ff9d3afc94eb9dba3b69',
25165827 => '1f3ae5e0f7ecd3d72239db5041198f50aa2d045f051e90296f47da2e1562a289',
26214397 => '3485ec60e10f82b9f1032b036106d60e8fb7a6bc29790abf0bb626e07885e2ae',
26214398 => '73033890e2fff9367a0698c0923c9909f0324e8f4769783abe7053067f8dc56d',
26214399 => '9767e65535db42f948be9f5e7bd91516dcd85c97d562de2d63b5284ee583019e',
26214400 => '33e3c5742db75c1ec8cfbc43b8c9616002524ad323454e69de9a48413cac1600',
26214401 => '7b0aeea967dd471258fc3b38127567226edc770b790bdbb87800d5080820ca6c',
26214402 => '91e13f6e2eaef4f58d9b4bfdecbc92df9c260097542bfbec7cd5c58f241bef4e',
26214403 => 'df144ef77195788a9ab4f657d352499fc875c4b9b9f99c5bbec0bf6a81c25efd',
27262973 => '9dcfbd1295abf78903bb8a6cba73615ad884a277904684a05e6d0e6c4749f529',
27262974 => '6c65adee7914328e957cab6e6583fd9568e5a37c732e95ad4a99d4c928991dac',
27262975 => 'cb169a67054740016a698fec05c36f2022ade2f03492eaebe3d1accac603da2d',
27262976 => '7a81eb70bbb3e048019e55d01bde15e24b90b920ac806a3f033be71d01b4f012',
27262977 => 'f084ceeb627fdf8199e0a89f033cdeeb15f7a79143946891495419d4c384e502',
27262978 => '4d44ad62bd033c34a87208313d67e4f4f2a85ff85b977d910a6458e98cd2e02e',
27262979 => '125f14e69dabfc0c929db511da0cf60ce0719bde7c5c59e3acef51df71d3acdf',
28311549 => '20c0fac028a6a5784d8b524fc217608c5f553189a57b5d2e3183f00bc236a836',
28311550 => 'fa2fbf483372a330f79a6907b8d31d67e0942bb63a378d31d022d32d25950adf',
28311551 => 'fcc5dbcdd56afa81ee563fd8b1f1a0ba669b704c23e0b1ff2f900e84721d1934',
28311552 => 'd6b139b01a1b062032499af596602476089ced25b58be72ba722cbcd3c15b9e2',
28311553 => '1945ab35c4d1a16de395de3669d8db5a7232e3fa8e4685274d632857b07eaa37',
28311554 => '5d863d1433049687fd588a1f755959ce30ed3cf817b9b034aca6774d4695a3bf',
28311555 => '12de150d5321fd51b6363d04b36e49d992c82d4726ffa77ff07841a03a1530e8',
29360125 => '6891573c15a4de182c8e8a66a632e5908392ea80a4c3192d44838d73b67b547b',
29360126 => 'e71eccccbea9e1bbdfbcfd6b97252442cbea3dab8dc49ce9e82474a1e52a1252',
29360127 => '8ed666fb2b40877c14c6cb9508de8ad1acd978c3ee24d98d4f3a006e002a9b7a',
29360128 => 'f3dd1a912582cfc21faa45075f17400860b754e6274cf9802e989d074a188484',
29360129 => 'c4176b52fa465398a810097d55932e32d9ef72f79a53b1b7bbda0cdf30ad3361',
29360130 => '7b6ab5364d121a4d52c8124e6fa46ad9a492f5748e530570fb5ad49877ec7990',
29360131 => 'e3b4605c3f2b9e81adfeead96770f1f539d12281d2705d95a700de38d930babb',
30408701 => '5abea2f78de79df030347c19e8bbf3297918da88166ff7b2a193866c7a74f6d6',
30408702 => '01806b23cfc07341f6e30ad18af1c40fde1be9a4dc950b2651d37714ee4ad7b3',
30408703 => '3d6559236c048f1729bf0237990b8210adb5e11752a895bd2e220d8e446914ed',
30408704 => '6ed89a58e7e341795f2fb85b6b9bd4a92121845a1adb27f941621070eb63160d',
30408705 => '1d51a3858906d64b6a29a965d41502404f19d4e7dbb25cecd6096e1a6adb37ea',
30408706 => 'be7450a5594a0679f4a766972d6f5e1df09052693f8bb30a2d9d170dcca10aa2',
30408707 => '6cb9f5e45d453cf8a6c93ca26cac5ac4b537e8c33b4683b5f90ff595607bb8a6',
31457277 => '674515a0850b560e7117f17e8924ba7eb3b65c7442269400ca2517a42d7c35a7',
31457278 => 'f71908411972d90545d887a201301290a04bafbab67173b15856f798ebe34eae',
31457279 => 'bf0d30d7a40fc5b4f23595c529d65ef7fcb83928ae2a94853925712ad0b9b799',
31457280 => '04d431e889dba3b36177ac00925ae93baefb745503c1041e2e6b39eda6152492',
31457281 => 'b6211348982a0f0a02bd292f3f72d27610f68df7aaa7e23ad53be6aca4065fea',
31457282 => '442ee9ec8fdb0cfa36e5ce94e157b23a9b4c87cc1338918cada3232cb170ad5b',
31457283 => 'edec0dbe337efb2c15aa6482935a85e60a4ff6ac38a98e53f5a0a38d3d776790',
32505853 => 'b1248401ff32782e9aea1aa88ede7577c7f07bbb03b65cb785b8cf61a6615838',
32505854 => 'af06218b750c2a495a0e3a9cc523a2eb744f33df8062994b5e9f968dad9cc4dd',
32505855 => 'd4143aa48e0c3e0b0117379add01c34976c3087f4f8c528f116ab6d405eab65d',
32505856 => '26ecf47ea021036258cad5bc2997073996cf20daddba13170ae28daf09350d9d',
32505857 => '2d548018dc16c40f9ad3edcf08dd8657a4ea7eea8c12201114a6f6ddd762afcc',
32505858 => '58b851ef5f150934b04fd941eb7aab57e768e6bef1cbcd6616ef3fdd36f81369',
32505859 => 'c844f2f081a2b808b3bd80e02e17500277e04ec15c79a33c3857f2710c45593a',
	}
	}
};

sub get_pseudo_random_array
{
	my ($size) = @_;
	ok($size >= length($randomstring));
	my $n = int($size /length($randomstring)  );
	my $s = $randomstring x $n;
	my $missedchars = $size - length($s);
	if ($missedchars) {
		$s .= substr($randomstring, 0, $missedchars);
	}
	ok($size == length($s));
	return \$s;
}

for my $chunksize (qw/200/) {
for my $i (1..31) {
	for my $j (qw/-3 -2 -1 0 1 2 3/) {
		my $size = $i*$chunksize+$j;
		my $dataref = get_pseudo_random_array($size);
		my $th = App::MtAws::TreeHash->new(unit => $chunksize);
		$th->eat_data($dataref);
		$th->calc_tree();
		my $hash = $th->get_final_hash();
		ok( $hash eq $check->{$chunksize}->{$randomstring}->{$size} );
	}
}
}

for my $chunksize (qw/200/) {
	for my $i ((1..33),  qw/255 256 257 4095 4096 4097/) {
		for my $j (qw/-1 0 1/) {
			my $size = $i*$chunksize+$j;
			my $dataref = get_pseudo_random_array($size);
			
			my $th = App::MtAws::TreeHash->new(unit => $chunksize);
			$th->eat_data($dataref);
			$th->calc_tree();
			my $hash = $th->get_final_hash();

			my $threc = App::MtAws::TreeHash->new(unit => $chunksize);
			$threc->eat_data($dataref);
			$threc->calc_tree_recursive();
			my $hashrec = $th->get_final_hash();

			ok( $hash eq $hashrec, "comparing test recursive and normal" );
		}
	}
}

# check lso how it works for non-ref
for my $chunksize (qw/200/) {
for my $i (qw/1 2 29/) {
	for my $j (qw/-1 0 1/) {
		my $size = $i*$chunksize+$j;
		my $dataref = get_pseudo_random_array($size);
		my $data = $$dataref;
		my $th = App::MtAws::TreeHash->new(unit => $chunksize);
		$th->eat_data($data);
		$th->calc_tree();
		my $hash = $th->get_final_hash();
		ok( $hash eq $check->{$chunksize}->{$randomstring}->{$size} );
	}
}
}


# Chunk 1048576 is the only correct chunk for amazon
for my $chunksize (qw/1048576/) {
for my $i (1..4) {
	for my $j (qw/-1 0 1/) {
		my $size = $i*$chunksize+$j;
		my $dataref = get_pseudo_random_array($size);
		my $th = $chunksize == 1048576 ? App::MtAws::TreeHash->new() : App::MtAws::TreeHash->new(unit => $chunksize);
		$th->eat_data($dataref);
		$th->calc_tree();
		my $hash = $th->get_final_hash();
#		print "$size => '$hash',\n";
		ok( $hash eq $check->{$chunksize}->{$randomstring}->{$size} );
	}
}
}


1;
