package Daje::Workflow::Activities::Tools::Generate::SQL;
use Mojo::Base 'Daje::Workflow::Activities::Tools::Generate::Base', -base, -signatures;
use v5.42;

# NAME
# ====
#
# Daje::Workflow::Activities::Tools::Generate::SQL - Generate SQL
# migration files for Mojo::Pg
#
# SYNOPSIS
# ========
#
#     use Daje::Workflow::Activities::Tools::Generate::SQL
#
# DESCRIPTION
# ===========
#
# Daje::Workflow::Activities::Tools::Generate::SQL is a module that generates SQL
#
# LICENSE
# =======
#
# Copyright (C) janeskil1525.
#
# This library is free software; you can redistribute it and/or modify
# it under the same terms as Perl itself.
#
# AUTHOR
# ======
#
# janeskil1525 E<lt>janeskil1525@gmail.comE<gt>
#

use Mojo::Util qw { camelize };
use Data::Dumper;
use Daje::Document::Builder;


sub generate_sql($self) {
    my @data;
     $self->model->insert_history(
         "Generate SQL",
         "Daje::Workflow::Activity::Tools::Generate::SQL::generate_sql",
         1
     );

    try {
        my $tools_projects_pkey = $self->context->{context}->{payload}->{tools_projects_fkey};
        if ($self->load_generate_data($tools_projects_pkey)) {
            my $documents = $self->build_documents($tools_projects_pkey);
            my $length = scalar @{$documents};
            for (my $i = 0; $i < $length; $i++) {
                my $data->{data} = @{$documents}[$i]->{document};
                my $filename = $self->get_parameter('Sql', 'Output file name', $tools_projects_pkey);
                $data->{file} = $self->get_parameter('Sql', 'Output Path', $tools_projects_pkey) . '/' . $filename;
                $data->{path} = 1;
                push(@data, $data);
            }
            $self->context->{context}->{payload}->{sql} = \@data;
        }
    } catch ($e) {
        say $e
        $self->error->add_error($e);
    };
}

sub build_documents ($self, $tools_projects_pkey) {
    my $source = $self->get_parameter('Sql', 'Template Source', $tools_projects_pkey);

    my $builder = Daje::Document::Builder->new(
        source        => $source,
        data_sections => 'sql',
        data          => $self->versions(),
        error         => $self->error()
    );

    my $data = $self->versions();

    $builder->process();

    return $builder->output();
}



1;
#################### pod generated by Pod::Autopod - keep this line to make pod updates possible ####################

=head1 NAME


Daje::Workflow::Activities::Tools::Generate::SQL - Generate SQL
migration files for Mojo::Pg



=head1 SYNOPSIS


    use Daje::Workflow::Activities::Tools::Generate::SQL



=head1 DESCRIPTION


Daje::Workflow::Activities::Tools::Generate::SQL is a module that generates SQL



=head1 REQUIRES

L<Daje::Document::Builder> 

L<Data::Dumper> 

L<v5.42> 

L<Mojo::Base> 


=head1 METHODS

=head2 build_documents

 build_documents();

=head2 generate_sql($self)

 generate_sql($self)();


=head1 AUTHOR


janeskil1525 E<lt>janeskil1525@gmail.comE<gt>



=head1 LICENSE


Copyright (C) janeskil1525.

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.



=cut

