/* src/bazaar.p/bz-repository.c
 *
 * Copyright 2026 AUTOGEN
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#include "src/bazaar.p/bz-repository.h"



struct _BzRepository
{
  GObject parent_instance;

  gboolean is_user;
  char *title;
  char *url;
  char *name;
};

G_DEFINE_FINAL_TYPE (BzRepository, bz_repository, G_TYPE_OBJECT);

enum
{
  PROP_0,

  PROP_IS_USER,
  PROP_TITLE,
  PROP_URL,
  PROP_NAME,

  LAST_PROP
};
static GParamSpec *props[LAST_PROP] = { 0 };

static void
bz_repository_dispose (GObject *object)
{
  BzRepository *self = BZ_REPOSITORY (object);

  g_clear_pointer (&self->title, g_free);
  g_clear_pointer (&self->url, g_free);
  g_clear_pointer (&self->name, g_free);

  G_OBJECT_CLASS (bz_repository_parent_class)->dispose (object);
}

static void
bz_repository_get_property (GObject    *object,
                       guint       prop_id,
                       GValue     *value,
                       GParamSpec *pspec)
{
  BzRepository *self = BZ_REPOSITORY (object);

  switch (prop_id)
    {
    case PROP_IS_USER:
      g_value_set_boolean (value, bz_repository_get_is_user (self));
      break;
    case PROP_TITLE:
      g_value_set_string (value, bz_repository_get_title (self));
      break;
    case PROP_URL:
      g_value_set_string (value, bz_repository_get_url (self));
      break;
    case PROP_NAME:
      g_value_set_string (value, bz_repository_get_name (self));
      break;
    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
    }
}

static void
bz_repository_set_property (GObject      *object,
                       guint         prop_id,
                       const GValue *value,
                       GParamSpec   *pspec)
{
  BzRepository *self = BZ_REPOSITORY (object);

  switch (prop_id)
    {
    case PROP_IS_USER:
      bz_repository_set_is_user (self, g_value_get_boolean (value));
      break;
    case PROP_TITLE:
      bz_repository_set_title (self, g_value_get_string (value));
      break;
    case PROP_URL:
      bz_repository_set_url (self, g_value_get_string (value));
      break;
    case PROP_NAME:
      bz_repository_set_name (self, g_value_get_string (value));
      break;
    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
    }
}

static void
bz_repository_class_init (BzRepositoryClass *klass)
{
  GObjectClass *object_class = G_OBJECT_CLASS (klass);



  object_class->set_property = bz_repository_set_property;
  object_class->get_property = bz_repository_get_property;
  object_class->dispose      = bz_repository_dispose;

  props[PROP_IS_USER] =
      g_param_spec_boolean (
          "is-user",
          NULL, NULL, FALSE,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_TITLE] =
      g_param_spec_string (
          "title",
          NULL, NULL, NULL,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_URL] =
      g_param_spec_string (
          "url",
          NULL, NULL, NULL,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_NAME] =
      g_param_spec_string (
          "name",
          NULL, NULL, NULL,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  g_object_class_install_properties (object_class, LAST_PROP, props);
}

static void
bz_repository_init (BzRepository *self)
{
}

BzRepository *
bz_repository_new (void){
  return g_object_new (BZ_TYPE_REPOSITORY, NULL);
}

gboolean
bz_repository_get_is_user (BzRepository *self){
  g_return_val_if_fail (BZ_IS_REPOSITORY (self), FALSE);
  return self->is_user;
}

const char *
bz_repository_get_title (BzRepository *self){
  g_return_val_if_fail (BZ_IS_REPOSITORY (self), NULL);
  return self->title;
}

const char *
bz_repository_get_url (BzRepository *self){
  g_return_val_if_fail (BZ_IS_REPOSITORY (self), NULL);
  return self->url;
}

const char *
bz_repository_get_name (BzRepository *self){
  g_return_val_if_fail (BZ_IS_REPOSITORY (self), NULL);
  return self->name;
}

void
bz_repository_set_is_user (BzRepository *self,
    gboolean is_user){
  g_return_if_fail (BZ_IS_REPOSITORY (self));

  if (!!is_user == !!self->is_user)
    return;

  self->is_user = is_user;

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_IS_USER]);
}

void
bz_repository_set_title (BzRepository *self,
    const char *title){
  g_return_if_fail (BZ_IS_REPOSITORY (self));

  if (title == self->title || (title != NULL && self->title != NULL && g_strcmp0(title, self->title) == 0))
    return;

  g_clear_pointer (&self->title, g_free);
  if (title != NULL)
    self->title = g_strdup (title);

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_TITLE]);
}

void
bz_repository_set_url (BzRepository *self,
    const char *url){
  g_return_if_fail (BZ_IS_REPOSITORY (self));

  if (url == self->url || (url != NULL && self->url != NULL && g_strcmp0(url, self->url) == 0))
    return;

  g_clear_pointer (&self->url, g_free);
  if (url != NULL)
    self->url = g_strdup (url);

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_URL]);
}

void
bz_repository_set_name (BzRepository *self,
    const char *name){
  g_return_if_fail (BZ_IS_REPOSITORY (self));

  if (name == self->name || (name != NULL && self->name != NULL && g_strcmp0(name, self->name) == 0))
    return;

  g_clear_pointer (&self->name, g_free);
  if (name != NULL)
    self->name = g_strdup (name);

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_NAME]);
}

/* End of src/bazaar.p/bz-repository.c */
