/* SPDX-License-Identifier: (LGPL-2.1 OR BSD-2-Clause) */

/* THIS FILE IS AUTOGENERATED BY BPFTOOL! */
#ifndef __GETHOSTLATENCY_BPF_SKEL_H__
#define __GETHOSTLATENCY_BPF_SKEL_H__

#include <errno.h>
#include <stdlib.h>
#include <bpf/libbpf.h>

struct gethostlatency_bpf {
	struct bpf_object_skeleton *skeleton;
	struct bpf_object *obj;
	struct {
		struct bpf_map *starts;
		struct bpf_map *events;
		struct bpf_map *rodata;
	} maps;
	struct {
		struct bpf_program *handle_entry;
		struct bpf_program *handle_return;
	} progs;
	struct {
		struct bpf_link *handle_entry;
		struct bpf_link *handle_return;
	} links;
	struct gethostlatency_bpf__rodata {
		pid_t target_pid;
	} *rodata;

#ifdef __cplusplus
	static inline struct gethostlatency_bpf *open(const struct bpf_object_open_opts *opts = nullptr);
	static inline struct gethostlatency_bpf *open_and_load();
	static inline int load(struct gethostlatency_bpf *skel);
	static inline int attach(struct gethostlatency_bpf *skel);
	static inline void detach(struct gethostlatency_bpf *skel);
	static inline void destroy(struct gethostlatency_bpf *skel);
	static inline const void *elf_bytes(size_t *sz);
#endif /* __cplusplus */
};

static void
gethostlatency_bpf__destroy(struct gethostlatency_bpf *obj)
{
	if (!obj)
		return;
	if (obj->skeleton)
		bpf_object__destroy_skeleton(obj->skeleton);
	free(obj);
}

static inline int
gethostlatency_bpf__create_skeleton(struct gethostlatency_bpf *obj);

static inline struct gethostlatency_bpf *
gethostlatency_bpf__open_opts(const struct bpf_object_open_opts *opts)
{
	struct gethostlatency_bpf *obj;
	int err;

	obj = (struct gethostlatency_bpf *)calloc(1, sizeof(*obj));
	if (!obj) {
		errno = ENOMEM;
		return NULL;
	}

	err = gethostlatency_bpf__create_skeleton(obj);
	if (err)
		goto err_out;

	err = bpf_object__open_skeleton(obj->skeleton, opts);
	if (err)
		goto err_out;

	return obj;
err_out:
	gethostlatency_bpf__destroy(obj);
	errno = -err;
	return NULL;
}

static inline struct gethostlatency_bpf *
gethostlatency_bpf__open(void)
{
	return gethostlatency_bpf__open_opts(NULL);
}

static inline int
gethostlatency_bpf__load(struct gethostlatency_bpf *obj)
{
	return bpf_object__load_skeleton(obj->skeleton);
}

static inline struct gethostlatency_bpf *
gethostlatency_bpf__open_and_load(void)
{
	struct gethostlatency_bpf *obj;
	int err;

	obj = gethostlatency_bpf__open();
	if (!obj)
		return NULL;
	err = gethostlatency_bpf__load(obj);
	if (err) {
		gethostlatency_bpf__destroy(obj);
		errno = -err;
		return NULL;
	}
	return obj;
}

static inline int
gethostlatency_bpf__attach(struct gethostlatency_bpf *obj)
{
	return bpf_object__attach_skeleton(obj->skeleton);
}

static inline void
gethostlatency_bpf__detach(struct gethostlatency_bpf *obj)
{
	bpf_object__detach_skeleton(obj->skeleton);
}

static inline const void *gethostlatency_bpf__elf_bytes(size_t *sz);

static inline int
gethostlatency_bpf__create_skeleton(struct gethostlatency_bpf *obj)
{
	struct bpf_object_skeleton *s;
	int err;

	s = (struct bpf_object_skeleton *)calloc(1, sizeof(*s));
	if (!s)	{
		err = -ENOMEM;
		goto err;
	}

	s->sz = sizeof(*s);
	s->name = "gethostlatency_bpf";
	s->obj = &obj->obj;

	/* maps */
	s->map_cnt = 3;
	s->map_skel_sz = sizeof(*s->maps);
	s->maps = (struct bpf_map_skeleton *)calloc(s->map_cnt, s->map_skel_sz);
	if (!s->maps) {
		err = -ENOMEM;
		goto err;
	}

	s->maps[0].name = "starts";
	s->maps[0].map = &obj->maps.starts;

	s->maps[1].name = "events";
	s->maps[1].map = &obj->maps.events;

	s->maps[2].name = "gethostl.rodata";
	s->maps[2].map = &obj->maps.rodata;
	s->maps[2].mmaped = (void **)&obj->rodata;

	/* programs */
	s->prog_cnt = 2;
	s->prog_skel_sz = sizeof(*s->progs);
	s->progs = (struct bpf_prog_skeleton *)calloc(s->prog_cnt, s->prog_skel_sz);
	if (!s->progs) {
		err = -ENOMEM;
		goto err;
	}

	s->progs[0].name = "handle_entry";
	s->progs[0].prog = &obj->progs.handle_entry;
	s->progs[0].link = &obj->links.handle_entry;

	s->progs[1].name = "handle_return";
	s->progs[1].prog = &obj->progs.handle_return;
	s->progs[1].link = &obj->links.handle_return;

	s->data = (void *)gethostlatency_bpf__elf_bytes(&s->data_sz);

	obj->skeleton = s;
	return 0;
err:
	bpf_object__destroy_skeleton(s);
	return err;
}

static inline const void *gethostlatency_bpf__elf_bytes(size_t *sz)
{
	*sz = 6264;
	return (const void *)"\
\x7f\x45\x4c\x46\x02\x01\x01\0\0\0\0\0\0\0\0\0\x01\0\xf7\0\x01\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\x78\x14\0\0\0\0\0\0\0\0\0\0\x40\0\0\0\0\0\x40\0\x10\0\
\x01\0\xbf\x16\0\0\0\0\0\0\x79\x61\x70\0\0\0\0\0\x15\x01\x2c\0\0\0\0\0\x85\0\0\
\0\x0e\0\0\0\xbf\x07\0\0\0\0\0\0\x63\x7a\xfc\xff\0\0\0\0\xb7\x01\0\0\0\0\0\0\
\x7b\x1a\xf0\xff\0\0\0\0\x7b\x1a\xe8\xff\0\0\0\0\x7b\x1a\xe0\xff\0\0\0\0\x7b\
\x1a\xd8\xff\0\0\0\0\x7b\x1a\xd0\xff\0\0\0\0\x7b\x1a\xc8\xff\0\0\0\0\x7b\x1a\
\xc0\xff\0\0\0\0\x7b\x1a\xb8\xff\0\0\0\0\x7b\x1a\xb0\xff\0\0\0\0\x7b\x1a\xa8\
\xff\0\0\0\0\x7b\x1a\xa0\xff\0\0\0\0\x7b\x1a\x98\xff\0\0\0\0\x7b\x1a\x90\xff\0\
\0\0\0\x77\x07\0\0\x20\0\0\0\x18\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x61\x12\0\0\0\
\0\0\0\x16\x02\x02\0\0\0\0\0\x61\x11\0\0\0\0\0\0\x5e\x71\x14\0\0\0\0\0\x85\0\0\
\0\x05\0\0\0\x63\x7a\x90\xff\0\0\0\0\x7b\x0a\x88\xff\0\0\0\0\xbf\xa1\0\0\0\0\0\
\0\x07\x01\0\0\x94\xff\xff\xff\xb4\x02\0\0\x10\0\0\0\x85\0\0\0\x10\0\0\0\x79\
\x63\x70\0\0\0\0\0\xbf\xa1\0\0\0\0\0\0\x07\x01\0\0\xa4\xff\xff\xff\xb4\x02\0\0\
\x50\0\0\0\x85\0\0\0\x70\0\0\0\xbf\xa2\0\0\0\0\0\0\x07\x02\0\0\xfc\xff\xff\xff\
\xbf\xa3\0\0\0\0\0\0\x07\x03\0\0\x88\xff\xff\xff\x18\x01\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\xb7\x04\0\0\0\0\0\0\x85\0\0\0\x02\0\0\0\xb4\0\0\0\0\0\0\0\x95\0\0\0\0\0\
\0\0\xbf\x16\0\0\0\0\0\0\x85\0\0\0\x0e\0\0\0\x63\x0a\xfc\xff\0\0\0\0\xbf\xa2\0\
\0\0\0\0\0\x07\x02\0\0\xfc\xff\xff\xff\x18\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x85\
\0\0\0\x01\0\0\0\xbf\x07\0\0\0\0\0\0\x15\x07\x11\0\0\0\0\0\x85\0\0\0\x05\0\0\0\
\x79\x71\0\0\0\0\0\0\x1f\x10\0\0\0\0\0\0\x7b\x07\0\0\0\0\0\0\xbf\x61\0\0\0\0\0\
\0\x18\x02\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x18\x03\0\0\xff\xff\xff\xff\0\0\0\0\0\0\
\0\0\xbf\x74\0\0\0\0\0\0\xb7\x05\0\0\x70\0\0\0\x85\0\0\0\x19\0\0\0\xbf\xa2\0\0\
\0\0\0\0\x07\x02\0\0\xfc\xff\xff\xff\x18\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x85\0\
\0\0\x03\0\0\0\xb4\0\0\0\0\0\0\0\x95\0\0\0\0\0\0\0\0\0\0\0\x47\x50\x4c\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x9f\xeb\x01\0\x18\0\0\0\0\0\0\0\x4c\x05\0\0\x4c\
\x05\0\0\x24\x05\0\0\0\0\0\0\0\0\0\x02\x03\0\0\0\x01\0\0\0\0\0\0\x01\x04\0\0\0\
\x20\0\0\x01\0\0\0\0\0\0\0\x03\0\0\0\0\x02\0\0\0\x04\0\0\0\x01\0\0\0\x05\0\0\0\
\0\0\0\x01\x04\0\0\0\x20\0\0\0\0\0\0\0\0\0\0\x02\x06\0\0\0\0\0\0\0\0\0\0\x03\0\
\0\0\0\x02\0\0\0\x04\0\0\0\0\x28\0\0\0\0\0\0\0\0\0\x02\x08\0\0\0\x19\0\0\0\0\0\
\0\x08\x09\0\0\0\x1f\0\0\0\0\0\0\x01\x04\0\0\0\x20\0\0\0\0\0\0\0\0\0\0\x02\x0b\
\0\0\0\x2c\0\0\0\x04\0\0\x04\x70\0\0\0\x32\0\0\0\x0c\0\0\0\0\0\0\0\x37\0\0\0\
\x08\0\0\0\x40\0\0\0\x3b\0\0\0\x0f\0\0\0\x60\0\0\0\x40\0\0\0\x10\0\0\0\xe0\0\0\
\0\x45\0\0\0\0\0\0\x08\x0d\0\0\0\x4b\0\0\0\0\0\0\x01\x08\0\0\0\x40\0\0\0\x5e\0\
\0\0\0\0\0\x01\x01\0\0\0\x08\0\0\x01\0\0\0\0\0\0\0\x03\0\0\0\0\x0e\0\0\0\x04\0\
\0\0\x10\0\0\0\0\0\0\0\0\0\0\x03\0\0\0\0\x0e\0\0\0\x04\0\0\0\x50\0\0\0\0\0\0\0\
\x04\0\0\x04\x20\0\0\0\x63\0\0\0\x01\0\0\0\0\0\0\0\x68\0\0\0\x05\0\0\0\x40\0\0\
\0\x74\0\0\0\x07\0\0\0\x80\0\0\0\x78\0\0\0\x0a\0\0\0\xc0\0\0\0\x7e\0\0\0\0\0\0\
\x0e\x11\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\x02\x14\0\0\0\0\0\0\0\0\0\0\x03\0\0\0\0\
\x02\0\0\0\x04\0\0\0\x04\0\0\0\0\0\0\0\x03\0\0\x04\x18\0\0\0\x63\0\0\0\x13\0\0\
\0\0\0\0\0\x85\0\0\0\x13\0\0\0\x40\0\0\0\x8e\0\0\0\x13\0\0\0\x80\0\0\0\x99\0\0\
\0\0\0\0\x0e\x15\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\x02\x18\0\0\0\xa0\0\0\0\x15\0\0\
\x04\xa8\0\0\0\xa8\0\0\0\x19\0\0\0\0\0\0\0\xac\0\0\0\x19\0\0\0\x40\0\0\0\xb0\0\
\0\0\x19\0\0\0\x80\0\0\0\xb4\0\0\0\x19\0\0\0\xc0\0\0\0\xb8\0\0\0\x19\0\0\0\0\
\x01\0\0\xbb\0\0\0\x19\0\0\0\x40\x01\0\0\xbe\0\0\0\x19\0\0\0\x80\x01\0\0\xc2\0\
\0\0\x19\0\0\0\xc0\x01\0\0\xc6\0\0\0\x19\0\0\0\0\x02\0\0\xc9\0\0\0\x19\0\0\0\
\x40\x02\0\0\xcc\0\0\0\x19\0\0\0\x80\x02\0\0\xcf\0\0\0\x19\0\0\0\xc0\x02\0\0\
\xd2\0\0\0\x19\0\0\0\0\x03\0\0\xd5\0\0\0\x19\0\0\0\x40\x03\0\0\xd8\0\0\0\x19\0\
\0\0\x80\x03\0\0\xdb\0\0\0\x19\0\0\0\xc0\x03\0\0\xe3\0\0\0\x19\0\0\0\0\x04\0\0\
\0\0\0\0\x1a\0\0\0\x40\x04\0\0\xe6\0\0\0\x19\0\0\0\x80\x04\0\0\xec\0\0\0\x19\0\
\0\0\xc0\x04\0\0\0\0\0\0\x20\0\0\0\0\x05\0\0\xef\0\0\0\0\0\0\x01\x08\0\0\0\x40\
\0\0\0\0\0\0\0\x03\0\0\x05\x08\0\0\0\xfd\0\0\0\x1b\0\0\0\0\0\0\0\0\x01\0\0\x1e\
\0\0\0\0\0\0\0\x04\x01\0\0\x1f\0\0\0\0\0\0\0\x0c\x01\0\0\0\0\0\x08\x1c\0\0\0\
\x10\x01\0\0\0\0\0\x08\x1d\0\0\0\x16\x01\0\0\0\0\0\x01\x02\0\0\0\x10\0\0\0\x25\
\x01\0\0\0\0\0\x08\x0c\0\0\0\x04\x01\0\0\x03\0\0\x84\x08\0\0\0\xfd\0\0\0\x1e\0\
\0\0\0\0\0\x10\x29\x01\0\0\x1e\0\0\0\x10\0\0\x02\x2c\x01\0\0\x1e\0\0\0\x12\0\0\
\x01\0\0\0\0\x03\0\0\x05\x08\0\0\0\x30\x01\0\0\x1b\0\0\0\0\0\0\0\x33\x01\0\0\
\x1e\0\0\0\0\0\0\0\x37\x01\0\0\x21\0\0\0\0\0\0\0\x37\x01\0\0\x0a\0\0\x84\x08\0\
\0\0\x30\x01\0\0\x1e\0\0\0\0\0\0\x10\x3f\x01\0\0\x1e\0\0\0\x10\0\0\x01\x43\x01\
\0\0\x1e\0\0\0\x11\0\0\x01\x4b\x01\0\0\x1e\0\0\0\x12\0\0\x01\x4f\x01\0\0\x1e\0\
\0\0\x20\0\0\x08\x63\0\0\0\x1e\0\0\0\x30\0\0\x04\x56\x01\0\0\x1e\0\0\0\x38\0\0\
\x01\x5e\x01\0\0\x1e\0\0\0\x39\0\0\x01\x61\x01\0\0\x1e\0\0\0\x3a\0\0\x01\x68\
\x01\0\0\x1e\0\0\0\x3c\0\0\x04\0\0\0\0\x01\0\0\x0d\x02\0\0\0\x70\x01\0\0\x17\0\
\0\0\x74\x01\0\0\x01\0\0\x0c\x22\0\0\0\0\0\0\0\x01\0\0\x0d\x02\0\0\0\x70\x01\0\
\0\x17\0\0\0\x97\x03\0\0\x01\0\0\x0c\x24\0\0\0\0\0\0\0\0\0\0\x0a\x27\0\0\0\0\0\
\0\0\0\0\0\x09\x28\0\0\0\xe6\x04\0\0\0\0\0\x08\x29\0\0\0\xec\x04\0\0\0\0\0\x08\
\x02\0\0\0\xfb\x04\0\0\0\0\0\x0e\x26\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\x03\0\0\0\0\
\x0e\0\0\0\x04\0\0\0\x04\0\0\0\x06\x05\0\0\0\0\0\x0e\x2b\0\0\0\x01\0\0\0\x0e\
\x05\0\0\x02\0\0\x0f\0\0\0\0\x12\0\0\0\0\0\0\0\x20\0\0\0\x16\0\0\0\0\0\0\0\x18\
\0\0\0\x14\x05\0\0\x01\0\0\x0f\0\0\0\0\x2a\0\0\0\0\0\0\0\x04\0\0\0\x1c\x05\0\0\
\x01\0\0\x0f\0\0\0\0\x2c\0\0\0\0\0\0\0\x04\0\0\0\0\x69\x6e\x74\0\x5f\x5f\x41\
\x52\x52\x41\x59\x5f\x53\x49\x5a\x45\x5f\x54\x59\x50\x45\x5f\x5f\0\x5f\x5f\x75\
\x33\x32\0\x75\x6e\x73\x69\x67\x6e\x65\x64\x20\x69\x6e\x74\0\x65\x76\x65\x6e\
\x74\0\x74\x69\x6d\x65\0\x70\x69\x64\0\x63\x6f\x6d\x6d\0\x68\x6f\x73\x74\0\x5f\
\x5f\x75\x36\x34\0\x75\x6e\x73\x69\x67\x6e\x65\x64\x20\x6c\x6f\x6e\x67\x20\x6c\
\x6f\x6e\x67\0\x63\x68\x61\x72\0\x74\x79\x70\x65\0\x6d\x61\x78\x5f\x65\x6e\x74\
\x72\x69\x65\x73\0\x6b\x65\x79\0\x76\x61\x6c\x75\x65\0\x73\x74\x61\x72\x74\x73\
\0\x6b\x65\x79\x5f\x73\x69\x7a\x65\0\x76\x61\x6c\x75\x65\x5f\x73\x69\x7a\x65\0\
\x65\x76\x65\x6e\x74\x73\0\x70\x74\x5f\x72\x65\x67\x73\0\x72\x31\x35\0\x72\x31\
\x34\0\x72\x31\x33\0\x72\x31\x32\0\x62\x70\0\x62\x78\0\x72\x31\x31\0\x72\x31\
\x30\0\x72\x39\0\x72\x38\0\x61\x78\0\x63\x78\0\x64\x78\0\x73\x69\0\x64\x69\0\
\x6f\x72\x69\x67\x5f\x61\x78\0\x69\x70\0\x66\x6c\x61\x67\x73\0\x73\x70\0\x75\
\x6e\x73\x69\x67\x6e\x65\x64\x20\x6c\x6f\x6e\x67\0\x63\x73\0\x63\x73\x78\0\x66\
\x72\x65\x64\x5f\x63\x73\0\x75\x31\x36\0\x5f\x5f\x75\x31\x36\0\x75\x6e\x73\x69\
\x67\x6e\x65\x64\x20\x73\x68\x6f\x72\x74\0\x75\x36\x34\0\x73\x6c\0\x77\x66\x65\
\0\x73\x73\0\x73\x73\x78\0\x66\x72\x65\x64\x5f\x73\x73\0\x73\x74\x69\0\x73\x77\
\x65\x76\x65\x6e\x74\0\x6e\x6d\x69\0\x76\x65\x63\x74\x6f\x72\0\x65\x6e\x63\x6c\
\x61\x76\x65\0\x6c\x6d\0\x6e\x65\x73\x74\x65\x64\0\x69\x6e\x73\x6e\x6c\x65\x6e\
\0\x63\x74\x78\0\x68\x61\x6e\x64\x6c\x65\x5f\x65\x6e\x74\x72\x79\0\x75\x70\x72\
\x6f\x62\x65\0\x2f\x62\x75\x69\x6c\x64\x2f\x62\x63\x63\x2f\x73\x72\x63\x2f\x62\
\x63\x63\x2f\x6c\x69\x62\x62\x70\x66\x2d\x74\x6f\x6f\x6c\x73\x2f\x67\x65\x74\
\x68\x6f\x73\x74\x6c\x61\x74\x65\x6e\x63\x79\x2e\x62\x70\x66\x2e\x63\0\x69\x6e\
\x74\x20\x42\x50\x46\x5f\x55\x50\x52\x4f\x42\x45\x28\x68\x61\x6e\x64\x6c\x65\
\x5f\x65\x6e\x74\x72\x79\x29\0\x30\x3a\x31\x34\0\x09\x69\x66\x20\x28\x21\x50\
\x54\x5f\x52\x45\x47\x53\x5f\x50\x41\x52\x4d\x31\x28\x63\x74\x78\x29\x29\0\x09\
\x5f\x5f\x75\x36\x34\x20\x70\x69\x64\x5f\x74\x67\x69\x64\x20\x3d\x20\x62\x70\
\x66\x5f\x67\x65\x74\x5f\x63\x75\x72\x72\x65\x6e\x74\x5f\x70\x69\x64\x5f\x74\
\x67\x69\x64\x28\x29\x3b\0\x09\x5f\x5f\x75\x33\x32\x20\x74\x69\x64\x20\x3d\x20\
\x28\x5f\x5f\x75\x33\x32\x29\x70\x69\x64\x5f\x74\x67\x69\x64\x3b\0\x09\x73\x74\
\x72\x75\x63\x74\x20\x65\x76\x65\x6e\x74\x20\x65\x76\x65\x6e\x74\x20\x3d\x20\
\x7b\x7d\x3b\0\x09\x5f\x5f\x75\x33\x32\x20\x70\x69\x64\x20\x3d\x20\x70\x69\x64\
\x5f\x74\x67\x69\x64\x20\x3e\x3e\x20\x33\x32\x3b\0\x09\x69\x66\x20\x28\x74\x61\
\x72\x67\x65\x74\x5f\x70\x69\x64\x20\x26\x26\x20\x74\x61\x72\x67\x65\x74\x5f\
\x70\x69\x64\x20\x21\x3d\x20\x70\x69\x64\x29\0\x09\x65\x76\x65\x6e\x74\x2e\x74\
\x69\x6d\x65\x20\x3d\x20\x62\x70\x66\x5f\x6b\x74\x69\x6d\x65\x5f\x67\x65\x74\
\x5f\x6e\x73\x28\x29\x3b\0\x09\x65\x76\x65\x6e\x74\x2e\x70\x69\x64\x20\x3d\x20\
\x70\x69\x64\x3b\0\x09\x62\x70\x66\x5f\x67\x65\x74\x5f\x63\x75\x72\x72\x65\x6e\
\x74\x5f\x63\x6f\x6d\x6d\x28\x26\x65\x76\x65\x6e\x74\x2e\x63\x6f\x6d\x6d\x2c\
\x20\x73\x69\x7a\x65\x6f\x66\x28\x65\x76\x65\x6e\x74\x2e\x63\x6f\x6d\x6d\x29\
\x29\x3b\0\x09\x62\x70\x66\x5f\x70\x72\x6f\x62\x65\x5f\x72\x65\x61\x64\x5f\x75\
\x73\x65\x72\x28\x26\x65\x76\x65\x6e\x74\x2e\x68\x6f\x73\x74\x2c\x20\x73\x69\
\x7a\x65\x6f\x66\x28\x65\x76\x65\x6e\x74\x2e\x68\x6f\x73\x74\x29\x2c\x20\x28\
\x76\x6f\x69\x64\x20\x2a\x29\x50\x54\x5f\x52\x45\x47\x53\x5f\x50\x41\x52\x4d\
\x31\x28\x63\x74\x78\x29\x29\x3b\0\x09\x62\x70\x66\x5f\x6d\x61\x70\x5f\x75\x70\
\x64\x61\x74\x65\x5f\x65\x6c\x65\x6d\x28\x26\x73\x74\x61\x72\x74\x73\x2c\x20\
\x26\x74\x69\x64\x2c\x20\x26\x65\x76\x65\x6e\x74\x2c\x20\x42\x50\x46\x5f\x41\
\x4e\x59\x29\x3b\0\x68\x61\x6e\x64\x6c\x65\x5f\x72\x65\x74\x75\x72\x6e\0\x75\
\x72\x65\x74\x70\x72\x6f\x62\x65\0\x69\x6e\x74\x20\x42\x50\x46\x5f\x55\x52\x45\
\x54\x50\x52\x4f\x42\x45\x28\x68\x61\x6e\x64\x6c\x65\x5f\x72\x65\x74\x75\x72\
\x6e\x29\0\x09\x5f\x5f\x75\x33\x32\x20\x74\x69\x64\x20\x3d\x20\x28\x5f\x5f\x75\
\x33\x32\x29\x62\x70\x66\x5f\x67\x65\x74\x5f\x63\x75\x72\x72\x65\x6e\x74\x5f\
\x70\x69\x64\x5f\x74\x67\x69\x64\x28\x29\x3b\0\x09\x65\x76\x65\x6e\x74\x70\x20\
\x3d\x20\x62\x70\x66\x5f\x6d\x61\x70\x5f\x6c\x6f\x6f\x6b\x75\x70\x5f\x65\x6c\
\x65\x6d\x28\x26\x73\x74\x61\x72\x74\x73\x2c\x20\x26\x74\x69\x64\x29\x3b\0\x09\
\x69\x66\x20\x28\x21\x65\x76\x65\x6e\x74\x70\x29\0\x09\x65\x76\x65\x6e\x74\x70\
\x2d\x3e\x74\x69\x6d\x65\x20\x3d\x20\x62\x70\x66\x5f\x6b\x74\x69\x6d\x65\x5f\
\x67\x65\x74\x5f\x6e\x73\x28\x29\x20\x2d\x20\x65\x76\x65\x6e\x74\x70\x2d\x3e\
\x74\x69\x6d\x65\x3b\0\x09\x62\x70\x66\x5f\x70\x65\x72\x66\x5f\x65\x76\x65\x6e\
\x74\x5f\x6f\x75\x74\x70\x75\x74\x28\x63\x74\x78\x2c\x20\x26\x65\x76\x65\x6e\
\x74\x73\x2c\x20\x42\x50\x46\x5f\x46\x5f\x43\x55\x52\x52\x45\x4e\x54\x5f\x43\
\x50\x55\x2c\x20\x65\x76\x65\x6e\x74\x70\x2c\x20\x73\x69\x7a\x65\x6f\x66\x28\
\x2a\x65\x76\x65\x6e\x74\x70\x29\x29\x3b\0\x09\x62\x70\x66\x5f\x6d\x61\x70\x5f\
\x64\x65\x6c\x65\x74\x65\x5f\x65\x6c\x65\x6d\x28\x26\x73\x74\x61\x72\x74\x73\
\x2c\x20\x26\x74\x69\x64\x29\x3b\0\x70\x69\x64\x5f\x74\0\x5f\x5f\x6b\x65\x72\
\x6e\x65\x6c\x5f\x70\x69\x64\x5f\x74\0\x74\x61\x72\x67\x65\x74\x5f\x70\x69\x64\
\0\x4c\x49\x43\x45\x4e\x53\x45\0\x2e\x6d\x61\x70\x73\0\x2e\x72\x6f\x64\x61\x74\
\x61\0\x6c\x69\x63\x65\x6e\x73\x65\0\x9f\xeb\x01\0\x20\0\0\0\0\0\0\0\x24\0\0\0\
\x24\0\0\0\x24\x02\0\0\x48\x02\0\0\x2c\0\0\0\x08\0\0\0\x81\x01\0\0\x01\0\0\0\0\
\0\0\0\x23\0\0\0\xa5\x03\0\0\x01\0\0\0\0\0\0\0\x25\0\0\0\x10\0\0\0\x81\x01\0\0\
\x15\0\0\0\0\0\0\0\x88\x01\0\0\xbd\x01\0\0\0\0\x01\0\x08\0\0\0\x88\x01\0\0\xdf\
\x01\0\0\x07\x70\0\0\x10\0\0\0\x88\x01\0\0\xdf\x01\0\0\x06\x70\0\0\x18\0\0\0\
\x88\x01\0\0\xf9\x01\0\0\x13\x7c\0\0\x28\0\0\0\x88\x01\0\0\x27\x02\0\0\x08\x84\
\0\0\x38\0\0\0\x88\x01\0\0\x45\x02\0\0\x0f\x88\0\0\xa0\0\0\0\x88\x01\0\0\x5f\
\x02\0\0\x17\x80\0\0\xa8\0\0\0\x88\x01\0\0\x7c\x02\0\0\x06\x90\0\0\xc0\0\0\0\
\x88\x01\0\0\x7c\x02\0\0\x11\x90\0\0\xc8\0\0\0\x88\x01\0\0\x7c\x02\0\0\x14\x90\
\0\0\xd0\0\0\0\x88\x01\0\0\x7c\x02\0\0\x11\x90\0\0\xd8\0\0\0\x88\x01\0\0\xa2\
\x02\0\0\x0f\x9c\0\0\xe0\0\0\0\x88\x01\0\0\xc4\x02\0\0\x0c\xa0\0\0\xe8\0\0\0\
\x88\x01\0\0\xa2\x02\0\0\x0d\x9c\0\0\xf0\0\0\0\x88\x01\0\0\xd6\x02\0\0\x1e\xa4\
\0\0\0\x01\0\0\x88\x01\0\0\xd6\x02\0\0\x02\xa4\0\0\x10\x01\0\0\x88\x01\0\0\x0e\
\x03\0\0\x3f\xa8\0\0\x18\x01\0\0\x88\x01\0\0\x0e\x03\0\0\x1d\xa8\0\0\x28\x01\0\
\0\x88\x01\0\0\x0e\x03\0\0\x02\xa8\0\0\x58\x01\0\0\x88\x01\0\0\x61\x03\0\0\x02\
\xac\0\0\x78\x01\0\0\x88\x01\0\0\xbd\x01\0\0\x05\0\x01\0\xa5\x03\0\0\x0c\0\0\0\
\0\0\0\0\x88\x01\0\0\xaf\x03\0\0\0\x18\x01\0\x08\0\0\0\x88\x01\0\0\xd0\x03\0\0\
\x15\xc4\0\0\x10\0\0\0\x88\x01\0\0\xd0\x03\0\0\x08\xc4\0\0\x28\0\0\0\x88\x01\0\
\0\0\x04\0\0\x0b\xd0\0\0\x48\0\0\0\x88\x01\0\0\x2e\x04\0\0\x06\xd4\0\0\x50\0\0\
\0\x88\x01\0\0\x3c\x04\0\0\x11\xe4\0\0\x58\0\0\0\x88\x01\0\0\x3c\x04\0\0\x2e\
\xe4\0\0\x60\0\0\0\x88\x01\0\0\x3c\x04\0\0\x24\xe4\0\0\x68\0\0\0\x88\x01\0\0\
\x3c\x04\0\0\x0f\xe4\0\0\x70\0\0\0\x88\x01\0\0\x6f\x04\0\0\x02\xe8\0\0\xc0\0\0\
\0\x88\x01\0\0\xc1\x04\0\0\x02\xec\0\0\xd8\0\0\0\x88\x01\0\0\xaf\x03\0\0\x05\
\x18\x01\0\x10\0\0\0\x81\x01\0\0\x02\0\0\0\x08\0\0\0\x18\0\0\0\xda\x01\0\0\0\0\
\0\0\x10\x01\0\0\x18\0\0\0\xda\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x03\0\x03\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\x03\0\x05\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x01\0\0\0\x12\0\x03\0\0\0\0\
\0\0\0\0\0\x88\x01\0\0\0\0\0\0\x72\0\0\0\x11\0\x07\0\0\0\0\0\0\0\0\0\x04\0\0\0\
\0\0\0\0\x21\0\0\0\x11\0\x09\0\0\0\0\0\0\0\0\0\x20\0\0\0\0\0\0\0\x35\0\0\0\x12\
\0\x05\0\0\0\0\0\0\0\0\0\xe8\0\0\0\0\0\0\0\x28\0\0\0\x11\0\x09\0\x20\0\0\0\0\0\
\0\0\x18\0\0\0\0\0\0\0\x9e\0\0\0\x11\0\x08\0\0\0\0\0\0\0\0\0\x04\0\0\0\0\0\0\0\
\xa8\0\0\0\0\0\0\0\x01\0\0\0\x04\0\0\0\x58\x01\0\0\0\0\0\0\x01\0\0\0\x05\0\0\0\
\x28\0\0\0\0\0\0\0\x01\0\0\0\x05\0\0\0\x78\0\0\0\0\0\0\0\x01\0\0\0\x07\0\0\0\
\xc0\0\0\0\0\0\0\0\x01\0\0\0\x05\0\0\0\x20\x05\0\0\0\0\0\0\x04\0\0\0\x05\0\0\0\
\x2c\x05\0\0\0\0\0\0\x04\0\0\0\x07\0\0\0\x44\x05\0\0\0\0\0\0\x03\0\0\0\x04\0\0\
\0\x5c\x05\0\0\0\0\0\0\x04\0\0\0\x08\0\0\0\x2c\0\0\0\0\0\0\0\x04\0\0\0\x01\0\0\
\0\x3c\0\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x50\0\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\
\x60\0\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x70\0\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\
\x80\0\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x90\0\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\
\xa0\0\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\xb0\0\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\
\xc0\0\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\xd0\0\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\
\xe0\0\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\xf0\0\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\0\
\x01\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x10\x01\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\
\x20\x01\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x30\x01\0\0\0\0\0\0\x04\0\0\0\x01\0\0\
\0\x40\x01\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x50\x01\0\0\0\0\0\0\x04\0\0\0\x01\0\
\0\0\x60\x01\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x70\x01\0\0\0\0\0\0\x04\0\0\0\x01\
\0\0\0\x80\x01\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x90\x01\0\0\0\0\0\0\x04\0\0\0\
\x01\0\0\0\xa8\x01\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\xb8\x01\0\0\0\0\0\0\x04\0\0\
\0\x02\0\0\0\xc8\x01\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\xd8\x01\0\0\0\0\0\0\x04\0\
\0\0\x02\0\0\0\xe8\x01\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\xf8\x01\0\0\0\0\0\0\x04\
\0\0\0\x02\0\0\0\x08\x02\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x18\x02\0\0\0\0\0\0\
\x04\0\0\0\x02\0\0\0\x28\x02\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x38\x02\0\0\0\0\0\
\0\x04\0\0\0\x02\0\0\0\x48\x02\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x58\x02\0\0\0\0\
\0\0\x04\0\0\0\x02\0\0\0\x74\x02\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x84\x02\0\0\0\
\0\0\0\x04\0\0\0\x01\0\0\0\x0d\x10\x0e\x12\x0f\x11\0\x68\x61\x6e\x64\x6c\x65\
\x5f\x65\x6e\x74\x72\x79\0\x2e\x74\x65\x78\x74\0\x2e\x72\x65\x6c\x2e\x42\x54\
\x46\x2e\x65\x78\x74\0\x73\x74\x61\x72\x74\x73\0\x65\x76\x65\x6e\x74\x73\0\x2e\
\x6d\x61\x70\x73\0\x68\x61\x6e\x64\x6c\x65\x5f\x72\x65\x74\x75\x72\x6e\0\x2e\
\x6c\x6c\x76\x6d\x5f\x61\x64\x64\x72\x73\x69\x67\0\x6c\x69\x63\x65\x6e\x73\x65\
\0\x2e\x72\x65\x6c\x75\x70\x72\x6f\x62\x65\0\x2e\x72\x65\x6c\x75\x72\x65\x74\
\x70\x72\x6f\x62\x65\0\x74\x61\x72\x67\x65\x74\x5f\x70\x69\x64\0\x2e\x73\x74\
\x72\x74\x61\x62\0\x2e\x73\x79\x6d\x74\x61\x62\0\x2e\x72\x6f\x64\x61\x74\x61\0\
\x2e\x72\x65\x6c\x2e\x42\x54\x46\0\x4c\x49\x43\x45\x4e\x53\x45\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x7d\0\0\0\x03\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\xce\x13\0\0\0\0\0\0\xa6\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x01\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x0e\0\0\0\x01\0\0\0\x06\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\x40\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x04\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\x5d\0\0\0\x01\0\0\0\x06\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x40\0\0\0\0\0\
\0\0\x88\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x08\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x59\
\0\0\0\x09\0\0\0\x40\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xe8\x10\0\0\0\0\0\0\x20\0\0\
\0\0\0\0\0\x0f\0\0\0\x03\0\0\0\x08\0\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\x68\0\0\0\
\x01\0\0\0\x06\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xc8\x01\0\0\0\0\0\0\xe8\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\x08\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x64\0\0\0\x09\0\0\0\x40\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x08\x11\0\0\0\0\0\0\x30\0\0\0\0\0\0\0\x0f\0\0\0\
\x05\0\0\0\x08\0\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\x8d\0\0\0\x01\0\0\0\x02\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\xb0\x02\0\0\0\0\0\0\x04\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\x04\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x51\0\0\0\x01\0\0\0\x03\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\xb4\x02\0\0\0\0\0\0\x04\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x01\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\x2f\0\0\0\x01\0\0\0\x03\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xb8\
\x02\0\0\0\0\0\0\x38\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x08\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\x99\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xf0\x02\0\0\0\0\0\0\
\x88\x0a\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x04\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x95\0\0\
\0\x09\0\0\0\x40\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x38\x11\0\0\0\0\0\0\x40\0\0\0\0\
\0\0\0\x0f\0\0\0\x0a\0\0\0\x08\0\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\x18\0\0\0\x01\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x78\x0d\0\0\0\0\0\0\x94\x02\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\x04\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x14\0\0\0\x09\0\0\0\x40\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\x78\x11\0\0\0\0\0\0\x50\x02\0\0\0\0\0\0\x0f\0\0\0\x0c\
\0\0\0\x08\0\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\x43\0\0\0\x03\x4c\xff\x6f\0\0\0\x80\
\0\0\0\0\0\0\0\0\0\0\0\0\xc8\x13\0\0\0\0\0\0\x06\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x85\0\0\0\x02\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\x10\x10\0\0\0\0\0\0\xd8\0\0\0\0\0\0\0\x01\0\0\0\x03\0\0\0\x08\0\0\0\0\
\0\0\0\x18\0\0\0\0\0\0\0";
}

#ifdef __cplusplus
struct gethostlatency_bpf *gethostlatency_bpf::open(const struct bpf_object_open_opts *opts) { return gethostlatency_bpf__open_opts(opts); }
struct gethostlatency_bpf *gethostlatency_bpf::open_and_load() { return gethostlatency_bpf__open_and_load(); }
int gethostlatency_bpf::load(struct gethostlatency_bpf *skel) { return gethostlatency_bpf__load(skel); }
int gethostlatency_bpf::attach(struct gethostlatency_bpf *skel) { return gethostlatency_bpf__attach(skel); }
void gethostlatency_bpf::detach(struct gethostlatency_bpf *skel) { gethostlatency_bpf__detach(skel); }
void gethostlatency_bpf::destroy(struct gethostlatency_bpf *skel) { gethostlatency_bpf__destroy(skel); }
const void *gethostlatency_bpf::elf_bytes(size_t *sz) { return gethostlatency_bpf__elf_bytes(sz); }
#endif /* __cplusplus */

__attribute__((unused)) static void
gethostlatency_bpf__assert(struct gethostlatency_bpf *s __attribute__((unused)))
{
#ifdef __cplusplus
#define _Static_assert static_assert
#endif
	_Static_assert(sizeof(s->rodata->target_pid) == 4, "unexpected size of 'target_pid'");
#ifdef __cplusplus
#undef _Static_assert
#endif
}

#endif /* __GETHOSTLATENCY_BPF_SKEL_H__ */
