/* SPDX-FileCopyrightText: 2018 Blender Authors
 *
 * SPDX-License-Identifier: GPL-2.0-or-later */

/**
 * Generated by 'tools/utils/blender_theme_as_c.py'
 *
 * Do not hand edit this file!
 */

#include "DNA_userdef_types.h"

#include "BLO_userdef_default.h"

/* clang-format off */

/* NOTE: this is endianness-sensitive. */
#define RGBA(c) {((c) >> 24) & 0xff, ((c) >> 16) & 0xff, ((c) >> 8) & 0xff, (c) & 0xff}
#define RGB(c)  {((c) >> 16) & 0xff, ((c) >> 8) & 0xff, (c) & 0xff}

const bTheme U_theme_default = {
  .name = "Default",
  .tui = {
    .wcol_regular = {
      .outline = RGBA(0x3d3d3dff),
      .outline_sel = RGBA(0x3d3d3dff),
      .inner = RGBA(0x545454ff),
      .inner_sel = RGBA(0x4772b3ff),
      .item = RGBA(0x1d1d1d80),
      .text = RGBA(0xe6e6e6ff),
      .text_sel = RGBA(0xffffffff),
      .roundness = 0.2f,
    },
    .wcol_tool = {
      .outline = RGBA(0x3d3d3dff),
      .outline_sel = RGBA(0x3d3d3dff),
      .inner = RGBA(0x545454ff),
      .inner_sel = RGBA(0x4772b3ff),
      .item = RGBA(0xffffffff),
      .text = RGBA(0xe6e6e6ff),
      .text_sel = RGBA(0xffffffff),
      .roundness = 0.2f,
    },
    .wcol_toolbar_item = {
      .outline = RGBA(0x3d3d3dff),
      .outline_sel = RGBA(0x3d3d3dff),
      .inner = RGBA(0x282828ff),
      .inner_sel = RGBA(0x4772b3ff),
      .item = RGBA(0xffffffb3),
      .text = RGBA(0xe6e6e6ff),
      .text_sel = RGBA(0xffffffff),
      .roundness = 0.2f,
    },
    .wcol_text = {
      .outline = RGBA(0x3d3d3dff),
      .outline_sel = RGBA(0x3d3d3dff),
      .inner = RGBA(0x1d1d1dff),
      .inner_sel = RGBA(0x181818ff),
      .item = RGBA(0xffffff33),
      .text = RGBA(0xe6e6e6ff),
      .text_sel = RGBA(0xffffffff),
      .roundness = 0.2f,
    },
    .wcol_radio = {
      .outline = RGBA(0x3d3d3dff),
      .outline_sel = RGBA(0x3d3d3dff),
      .inner = RGBA(0x545454ff),
      .inner_sel = RGBA(0x4772b3ff),
      .item = RGBA(0x252525ff),
      .text = RGBA(0xe6e6e6ff),
      .text_sel = RGBA(0xffffffff),
      .roundness = 0.2f,
    },
    .wcol_option = {
      .outline = RGBA(0x3d3d3dff),
      .outline_sel = RGBA(0x3d3d3dff),
      .inner = RGBA(0x545454ff),
      .inner_sel = RGBA(0x4772b3ff),
      .item = RGBA(0xffffffff),
      .text = RGBA(0xe6e6e6ff),
      .text_sel = RGBA(0xffffffff),
      .roundness = 0.2f,
    },
    .wcol_toggle = {
      .outline = RGBA(0x3d3d3dff),
      .outline_sel = RGBA(0x3d3d3dff),
      .inner = RGBA(0x545454ff),
      .inner_sel = RGBA(0x4772b3ff),
      .item = RGBA(0x252525ff),
      .text = RGBA(0xe6e6e6ff),
      .text_sel = RGBA(0xffffffff),
      .roundness = 0.2f,
    },
    .wcol_num = {
      .outline = RGBA(0x3d3d3dff),
      .outline_sel = RGBA(0x3d3d3dff),
      .inner = RGBA(0x545454ff),
      .inner_sel = RGBA(0x222222ff),
      .item = RGBA(0x4772b3ff),
      .text = RGBA(0xe6e6e6ff),
      .text_sel = RGBA(0xffffffff),
      .roundness = 0.2f,
    },
    .wcol_numslider = {
      .outline = RGBA(0x3d3d3dff),
      .outline_sel = RGBA(0x3d3d3dff),
      .inner = RGBA(0x545454ff),
      .inner_sel = RGBA(0x222222ff),
      .item = RGBA(0x4772b3ff),
      .text = RGBA(0xe6e6e6ff),
      .text_sel = RGBA(0xffffffff),
      .roundness = 0.2f,
    },
    .wcol_tab = {
      .outline = RGBA(0x1d1d1dff),
      .outline_sel = RGBA(0x1d1d1dff),
      .inner = RGBA(0x1d1d1dff),
      .inner_sel = RGBA(0x303030ff),
      .item = RGBA(0x1d1d1dff),
      .text = RGBA(0x989898ff),
      .text_sel = RGBA(0xffffffff),
      .roundness = 0.2f,
    },
    .wcol_curve = {
      .outline = RGBA(0x727272ff),
      .outline_sel = RGBA(0x9a9a9aff),
      .inner = RGBA(0x545454ff),
      .inner_sel = RGBA(0x000000ff),
      .item = RGBA(0x00000059),
      .text = RGBA(0x08080800),
      .text_sel = RGBA(0xc9c9c900),
      .roundness = 0.2f,
    },
    .wcol_menu = {
      .outline = RGBA(0x3d3d3dff),
      .outline_sel = RGBA(0x3d3d3dff),
      .inner = RGBA(0x282828ff),
      .inner_sel = RGBA(0x4772b3b3),
      .item = RGBA(0xd9d9d9ff),
      .text = RGBA(0xe6e6e6ff),
      .text_sel = RGBA(0xffffffff),
      .roundness = 0.2f,
    },
    .wcol_pulldown = {
      .outline = RGBA(0x3d3d3d00),
      .outline_sel = RGBA(0x3d3d3d00),
      .inner = RGBA(0x22222200),
      .inner_sel = RGBA(0xffffff1a),
      .item = RGBA(0xffffff8f),
      .text = RGBA(0xd9d9d9ff),
      .text_sel = RGBA(0xffffffff),
      .roundness = 0.2f,
    },
    .wcol_menu_back = {
      .outline = RGBA(0x242424ff),
      .outline_sel = RGBA(0x242424ff),
      .inner = RGBA(0x181818ff),
      .inner_sel = RGBA(0x4772b3ff),
      .item = RGBA(0xd9d9d9ff),
      .text = RGBA(0x999999ff),
      .text_sel = RGBA(0xffffffff),
      .roundness = 0.2f,
    },
    .wcol_menu_item = {
      .outline = RGBA(0x3d3d3d00),
      .outline_sel = RGBA(0x3d3d3d00),
      .inner = RGBA(0x18181800),
      .inner_sel = RGBA(0x4772b3ff),
      .item = RGBA(0xffffff8f),
      .text = RGBA(0xddddddff),
      .text_sel = RGBA(0xffffffff),
      .roundness = 0.2f,
    },
    .wcol_tooltip = {
      .outline = RGBA(0x242424ff),
      .outline_sel = RGBA(0x242424ff),
      .inner = RGBA(0x1d1d1dff),
      .inner_sel = RGBA(0x4772b3ff),
      .item = RGBA(0xd9d9d9ff),
      .text = RGBA(0xd9d9d9ff),
      .text_sel = RGBA(0xffffffff),
      .roundness = 0.2f,
    },
    .wcol_box = {
      .outline = RGBA(0x3d3d3dff),
      .outline_sel = RGBA(0x3d3d3dff),
      .inner = RGBA(0x1d1d1d80),
      .inner_sel = RGBA(0x545454ff),
      .item = RGBA(0x191919ff),
      .text = RGBA(0xe6e6e6ff),
      .text_sel = RGBA(0xffffffff),
      .roundness = 0.2f,
    },
    .wcol_scroll = {
      .outline = RGBA(0x3d3d3dff),
      .outline_sel = RGBA(0x3d3d3dff),
      .inner = RGBA(0x22222200),
      .inner_sel = RGBA(0xffffffff),
      .item = RGBA(0x545454ff),
      .text = RGBA(0xe6e6e6ff),
      .text_sel = RGBA(0xffffffff),
      .roundness = 0.5f,
    },
    .wcol_progress = {
      .outline = RGBA(0x3d3d3dff),
      .outline_sel = RGBA(0x3d3d3dff),
      .inner = RGBA(0x222222ff),
      .inner_sel = RGBA(0x4772b3ff),
      .item = RGBA(0x4772b3ff),
      .text = RGBA(0xe6e6e6ff),
      .text_sel = RGBA(0xffffffff),
      .roundness = 0.2f,
    },
    .wcol_list_item = {
      .outline = RGBA(0x2d2d2d00),
      .outline_sel = RGBA(0x2d2d2dff),
      .inner = RGBA(0xffffff00),
      .inner_sel = RGBA(0x4772b3ff),
      .item = RGBA(0xffffff33),
      .text = RGBA(0xccccccff),
      .text_sel = RGBA(0xffffffff),
      .roundness = 0.2f,
    },
    .wcol_pie_menu = {
      .outline = RGBA(0x242424ff),
      .outline_sel = RGBA(0x242424ff),
      .inner = RGBA(0x181818ff),
      .inner_sel = RGBA(0x4772b3ff),
      .item = RGBA(0x545454ff),
      .text = RGBA(0xd9d9d9ff),
      .text_sel = RGBA(0xffffffff),
      .roundness = 0.2f,
    },
    .wcol_state = {
      .error = RGBA(0x771111ff),
      .warning = RGBA(0xac8737ff),
      .info = RGBA(0x28487dff),
      .success = RGBA(0x188625ff),
      .inner_anim = RGBA(0x53992eff),
      .inner_anim_sel = RGBA(0x38a600ff),
      .inner_key = RGBA(0xb3ae36ff),
      .inner_key_sel = RGBA(0xb29700ff),
      .inner_driven = RGBA(0x9000ccff),
      .inner_driven_sel = RGBA(0x9900e6ff),
      .inner_overridden = RGBA(0x00c3c300),
      .inner_overridden_sel = RGBA(0x118f8f00),
      .inner_changed = RGBA(0xcc7529ff),
      .inner_changed_sel = RGBA(0xd26400ff),
      .blend = 0.5f,
    },
    .widget_emboss = RGBA(0x00000026),
    .menu_shadow_fac = 0.2f,
    .menu_shadow_width = 6,
    .editor_border = RGBA(0x161616ff),
    .editor_outline = RGBA(0xffffff15),
    .editor_outline_active = RGBA(0xffffff2a),
    .transparent_checker_primary = RGBA(0x333333ff),
    .transparent_checker_secondary = RGBA(0x262626ff),
    .transparent_checker_size = 8,
    .icon_alpha = 1.0f,
    .icon_saturation = 0.5f,
    .widget_text_cursor = RGBA(0x71a8ffff),
    .xaxis = RGBA(0xff3352ff),
    .yaxis = RGBA(0x8bdc00ff),
    .zaxis = RGBA(0x2890ffff),
    .waxis = RGBA(0xedba18ff),
    .gizmo_hi = RGBA(0xffffffff),
    .gizmo_primary = RGBA(0xf5f14dff),
    .gizmo_secondary = RGBA(0x63ffffff),
    .gizmo_view_align = RGBA(0xffffffff),
    .gizmo_a = RGBA(0x4da84dff),
    .gizmo_b = RGBA(0xa33535ff),
    .icon_scene = RGBA(0xccccccff),
    .icon_collection = RGBA(0xffffffff),
    .icon_object = RGBA(0xe19658ff),
    .icon_object_data = RGBA(0x00d4a3ff),
    .icon_modifier = RGBA(0x74a2ffff),
    .icon_shading = RGBA(0xcc6670ff),
    .icon_folder = RGBA(0xccad63ff),
    .icon_autokey = RGBA(0xab3c48ff),
    .panel_roundness = 0.4f,
    .panel_header = RGBA(0x3d3d3dff),
    .panel_back = RGBA(0x3d3d3dff),
    .panel_sub_back = RGBA(0x0000001f),
    .panel_outline = RGBA(0xffffff11),
    .panel_title = RGBA(0xe6e6e6ff),
    .panel_text = RGBA(0xe6e6e6ff),
    .panel_active = RGBA(0x4772b3ff),
  },
  .regions = {
    .asset_shelf = {
      .back = RGBA(0x303030e6),
      .header_back = RGBA(0x1d1d1dff),
    },
    .channels = {
      .back = RGBA(0x1d1d1dff),
      .text = RGBA(0xb8b8b8ff),
      .text_selected = RGBA(0xffaf23ff),
    },
    .scrubbing = {
      .back = RGBA(0x1d1d1dff),
      .text = RGBA(0x808080ff),
      .time_marker = RGBA(0xffffff80),
      .time_marker_selected = RGBA(0xffffffff),
    },
    .sidebars = {
      .back = RGBA(0x30303000),
      .tab_back = RGBA(0x18181800),
    },
  },
  .common = {
    .anim = {
      .playhead = RGBA(0x4772b3ff),
      .preview_range = RGBA(0xa14d0066),
      .channels = RGBA(0x194e8080),
      .channels_sub = RGBA(0x0f2c4d80),
      .channel_group = RGBA(0x1a332d37),
      .channel_group_active = RGBA(0x216d5b67),
      .channel = RGBA(0x12121299),
      .channel_selected = RGBA(0x60c04044),
      .keyframe = RGBA(0xbfbfbfff),
      .keyframe_extreme = RGBA(0xe8b3ccff),
      .keyframe_breakdown = RGBA(0xb3dbe8ff),
      .keyframe_jitter = RGBA(0x94e575ff),
      .keyframe_moving_hold = RGBA(0x808080ff),
      .keyframe_generated = RGBA(0x585858ff),
      .keyframe_selected = RGBA(0xffbe33ff),
      .keyframe_extreme_selected = RGBA(0xf28080ff),
      .keyframe_breakdown_selected = RGBA(0x54bfedff),
      .keyframe_jitter_selected = RGBA(0x61c042ff),
      .keyframe_moving_hold_selected = RGBA(0xffaf23ff),
      .keyframe_generated_selected = RGBA(0xa28962ff),
      .long_key = RGBA(0xffffff1f),
      .long_key_selected = RGBA(0xff8c0099),
      .scene_strip_range = RGBA(0x00000080),
    },
    .curves = {
      .handle_free = RGBA(0x745900ff),
      .handle_auto = RGBA(0x740d00ff),
      .handle_vect = RGBA(0x232374ff),
      .handle_align = RGBA(0x157000ff),
      .handle_auto_clamped = RGBA(0x803060ff),
      .handle_sel_free = RGBA(0xffc300ff),
      .handle_sel_auto = RGBA(0xff1900ff),
      .handle_sel_vect = RGBA(0x4444ffff),
      .handle_sel_align = RGBA(0x72ff57ff),
      .handle_sel_auto_clamped = RGBA(0xf090a0ff),
      .handle_vertex = RGBA(0x000000ff),
      .handle_vertex_select = RGBA(0xff8500ff),
      .handle_vertex_size = 5,
    },
  },
  .space_properties = {
    .back = RGBA(0x30303000),
    .title = RGBA(0xe6e6e6ff),
    .text = RGBA(0xe6e6e6ff),
    .text_hi = RGBA(0xffffffff),
    .header = RGBA(0x303030b3),
    .header_text = RGBA(0xeeeeeeff),
    .header_text_hi = RGBA(0xffffffff),
    .vertex_size = 3,
    .outline_width = 1,
    .facedot_size = 4,
    .match = RGBA(0x4772b3ff),
  },
  .space_view3d = {
    .back = RGBA(0x3d3d3dff),
    .back_grad = RGBA(0x30303000),
    .title = RGBA(0xeeeeeeff),
    .text = RGBA(0xe6e6e6ff),
    .text_hi = RGBA(0xffffffff),
    .header = RGBA(0x303030b3),
    .header_text = RGBA(0xeeeeeeff),
    .header_text_hi = RGBA(0xffffffff),
    .grid = RGBA(0x54545480),
    .wire = RGBA(0x000000ff),
    .wire_edit = RGBA(0x000000ff),
    .select = RGBA(0xed5700ff),
    .lamp = RGBA(0x00000050),
    .speaker = RGBA(0x000000ff),
    .empty = RGBA(0x000000ff),
    .camera = RGBA(0x000000ff),
    .active = RGBA(0xffa028ff),
    .transform = RGBA(0xffffffff),
    .vertex = RGBA(0x000000ff),
    .vertex_select = RGBA(0xff7a00ff),
    .edge = RGBA(0x000000ff),
    .edge_select = RGBA(0xff9900ff),
    .edge_mode_select = RGBA(0xffd800ff),
    .face = RGBA(0xffffff02),
    .face_select = RGBA(0xffa30033),
    .face_mode_select = RGBA(0xffb70033),
    .face_retopology = RGBA(0x50c8ff0f),
    .face_back = RGBA(0xff0000b3),
    .face_front = RGBA(0x0000ff00),
    .extra_edge_len = RGBA(0x150806ff),
    .extra_edge_angle = RGBA(0x4d4d00ff),
    .extra_face_angle = RGBA(0x0000ccff),
    .extra_face_area = RGBA(0x004d00ff),
    .normal = RGBA(0x22ddddff),
    .vertex_normal = RGBA(0x2361ddff),
    .loop_normal = RGBA(0xdd23ddff),
    .bone_solid = RGBA(0xb2b2b2ff),
    .bone_pose = RGBA(0x50c8ff50),
    .bone_pose_active = RGBA(0x8cffff50),
    .bone_locked_weight = RGBA(0xff000080),
    .before_current_frame = RGBA(0xf22e23ff),
    .after_current_frame = RGBA(0x78f244ff),
    .time_gp_keyframe = RGBA(0x7a9b14ff),
    .bevel = RGBA(0x00a5ffff),
    .seam = RGBA(0xdb2512ff),
    .sharp = RGBA(0x00ffffff),
    .crease = RGBA(0xcc0099ff),
    .freestyle = RGBA(0x7fff7f4d),
    .nurb_uline = RGBA(0x909000ff),
    .nurb_vline = RGBA(0x803060ff),
    .nurb_sel_uline = RGBA(0xf0ff40ff),
    .nurb_sel_vline = RGBA(0xf090a0ff),
    .vertex_size = 3,
    .edge_width = 1,
    .outline_width = 1,
    .obcenter_dia = 6,
    .facedot_size = 3,
    .editmesh_active = RGBA(0xffffff33),
    .clipping_border_3d = RGBA(0x3f3f3fff),
    .bundle_solid = RGBA(0xc8c8c8ff),
    .camera_path = RGBA(0x000000ff),
    .gp_vertex_size = 3,
    .gp_vertex = RGBA(0x000000ff),
    .gp_vertex_select = RGBA(0xff8500ff),
    .skin_root = RGBA(0xb44d4dff),
  },
  .space_file = {
    .back = RGBA(0x28282800),
    .title = RGBA(0xffffffff),
    .text = RGBA(0xe6e6e6ff),
    .text_hi = RGBA(0xffffffff),
    .header = RGBA(0x303030b3),
    .header_text = RGBA(0xeeeeeeff),
    .header_text_hi = RGBA(0xffffffff),
    .hilite = RGBA(0x4772b3ff),
    .vertex_size = 3,
    .outline_width = 1,
    .facedot_size = 4,
    .row_alternate = RGBA(0xffffff04),
  },
  .space_graph = {
    .back = RGBA(0x30303000),
    .title = RGBA(0xffffffff),
    .text = RGBA(0xa6a6a6ff),
    .text_hi = RGBA(0xffffffff),
    .header = RGBA(0x303030b3),
    .header_text = RGBA(0xeeeeeeff),
    .header_text_hi = RGBA(0xffffffff),
    .shade1 = RGBA(0x96969600),
    .grid = RGBA(0x1a1a1aff),
    .vertex = RGBA(0x000000ff),
    .vertex_select = RGBA(0xff8500ff),
    .vertex_active = RGBA(0xffffffff),
    .vertex_size = 6,
    .outline_width = 1,
    .facedot_size = 4,
  },
  .space_info = {
    .back = RGBA(0x1d1d1d00),
    .title = RGBA(0xffffffff),
    .text = RGBA(0xc3c3c3ff),
    .text_hi = RGBA(0xffffffff),
    .header = RGBA(0x303030b3),
    .header_text = RGBA(0xeeeeeeff),
    .header_text_hi = RGBA(0xffffffff),
    .vertex_size = 3,
    .outline_width = 1,
    .facedot_size = 4,
    .info_selected = RGBA(0x3b5689ff),
    .info_selected_text = RGBA(0xffffffff),
    .info_error_text = RGBA(0xffffffff),
    .info_warning_text = RGBA(0xffffffff),
    .info_info_text = RGBA(0xffffffff),
    .info_debug = RGBA(0x6b3293ff),
    .info_debug_text = RGBA(0xffffffff),
    .info_property = RGBA(0x236666ff),
    .info_property_text = RGBA(0xffffffff),
    .info_operator = RGBA(0x235266ff),
    .info_operator_text = RGBA(0xffffffff),
  },
  .space_action = {
    .back = RGBA(0x30303000),
    .title = RGBA(0xeeeeeeff),
    .text = RGBA(0xa6a6a6ff),
    .text_hi = RGBA(0xffffffff),
    .header = RGBA(0x303030b3),
    .header_text = RGBA(0xeeeeeeff),
    .header_text_hi = RGBA(0xffffffff),
    .shade1 = RGBA(0xc0c0c000),
    .grid = RGBA(0x161616ff),
    .ds_ipoline = RGBA(0x94e575cc),
    .keyborder = RGBA(0x000000ff),
    .keyborder_select = RGBA(0x000000ff),
    .vertex_size = 3,
    .outline_width = 1,
    .facedot_size = 4,
    .simulated_frames = RGBA(0x721e65ff),
    .keyframe_scale_fac = 1.0f,
    .anim_active = RGBA(0x4d272766),
  },
  .space_nla = {
    .back = RGBA(0x30303000),
    .title = RGBA(0xffffffff),
    .text = RGBA(0xa6a6a6ff),
    .text_hi = RGBA(0xffffffff),
    .header = RGBA(0x303030b3),
    .header_text = RGBA(0xeeeeeeff),
    .header_text_hi = RGBA(0xffffffff),
    .shade1 = RGBA(0x96969600),
    .grid = RGBA(0x2a2a2aff),
    .strip = RGBA(0x0d0d0d80),
    .strip_select = RGBA(0xff8c00ff),
    .keyborder = RGBA(0x000000ff),
    .keyborder_select = RGBA(0x000000ff),
    .vertex_size = 3,
    .outline_width = 1,
    .facedot_size = 4,
    .anim_active = RGBA(0x99541366),
    .anim_non_active = RGBA(0x4d3b174d),
    .nla_tweaking = RGBA(0x4df31a4d),
    .nla_tweakdupli = RGBA(0xd90000ff),
    .nla_transition = RGBA(0x1c2630ff),
    .nla_transition_sel = RGBA(0x2e75dbff),
    .nla_meta = RGBA(0x332642ff),
    .nla_meta_sel = RGBA(0x692196ff),
    .nla_sound = RGBA(0x2b3d3dff),
    .nla_sound_sel = RGBA(0x1f7a7aff),
  },
  .space_sequencer = {
    .back = RGBA(0x18181800),
    .title = RGBA(0xeeeeeeff),
    .text = RGBA(0xa6a6a6ff),
    .text_hi = RGBA(0xffffffff),
    .header = RGBA(0x303030b3),
    .header_text = RGBA(0xeeeeeeff),
    .header_text_hi = RGBA(0xffffffff),
    .shade1 = RGBA(0xa0a0a000),
    .grid = RGBA(0x303030ff),
    .vertex_select = RGBA(0xff8500ff),
    .bone_pose = RGBA(0x50c8ff50),
    .before_current_frame = RGBA(0xf22e23ff),
    .after_current_frame = RGBA(0x78f244ff),
    .keyborder = RGBA(0x000000ff),
    .keyborder_select = RGBA(0x000000ff),
    .vertex_size = 3,
    .outline_width = 1,
    .facedot_size = 4,
    .movie = RGBA(0x6282a3ff),
    .movieclip = RGBA(0x8f6e56ff),
    .mask = RGBA(0x8f5656ff),
    .image = RGBA(0x8c548cff),
    .scene = RGBA(0x999999ff),
    .audio = RGBA(0x568f6dff),
    .effect = RGBA(0x7b5f80ff),
    .transition = RGBA(0x867accff),
    .meta = RGBA(0x7b995cff),
    .text_strip = RGBA(0x9f926fff),
    .color_strip = RGBA(0x99995cff),
    .active_strip = RGBA(0xffffffff),
    .selected_strip = RGBA(0xff8f0dff),
    .text_strip_cursor = RGBA(0x71a8ffff),
    .selected_text = RGBA(0xffffff4d),
    .gp_vertex_size = 3,
    .gp_vertex_select = RGBA(0xff8500ff),
    .row_alternate = RGBA(0xffffff05),
    .metadatatext = RGBA(0xffffffff),
  },
  .space_image = {
    .back = RGBA(0x30303000),
    .title = RGBA(0xeeeeeeff),
    .text = RGBA(0xe6e6e6ff),
    .text_hi = RGBA(0xffffffff),
    .header = RGBA(0x303030b3),
    .header_text = RGBA(0xeeeeeeff),
    .header_text_hi = RGBA(0xffffffff),
    .grid = RGBA(0x303030ff),
    .wire_edit = RGBA(0xc0c0c0ff),
    .vertex_select = RGBA(0xff8500ff),
    .edge_select = RGBA(0xff8500ff),
    .face = RGBA(0xffffff0a),
    .face_select = RGBA(0xff85003c),
    .vertex_size = 3,
    .edge_width = 1,
    .outline_width = 1,
    .facedot_size = 3,
    .editmesh_active = RGBA(0xffffff40),
    .gp_vertex_size = 3,
    .gp_vertex_select = RGBA(0xff8500ff),
    .preview_back = RGBA(0x727272ff),
    .preview_stitch_face = RGBA(0x7f7f0033),
    .preview_stitch_edge = RGBA(0xff00ff33),
    .preview_stitch_vert = RGBA(0x0000ff33),
    .preview_stitch_stitchable = RGBA(0x00ff00ff),
    .preview_stitch_unstitchable = RGBA(0xff0000ff),
    .preview_stitch_active = RGBA(0xe1d2c323),
    .uv_shadow = RGBA(0x707070ff),
    .metadatatext = RGBA(0xffffffff),
  },
  .space_text = {
    .back = RGBA(0x23232300),
    .title = RGBA(0xeeeeeeff),
    .text = RGBA(0xe6e6e6ff),
    .text_hi = RGBA(0xffffffff),
    .header = RGBA(0x303030b3),
    .header_text = RGBA(0xeeeeeeff),
    .header_text_hi = RGBA(0xffffffff),
    .shade2 = RGBA(0x4d4d4de6),
    .hilite = RGBA(0x71a8ffff),
    .grid = RGBA(0x1d1d1dff),
    .vertex_size = 3,
    .outline_width = 1,
    .facedot_size = 4,
    .syntaxl = RGBA(0xe6d573ff),
    .syntaxs = RGBA(0xff734dff),
    .syntaxb = RGBA(0xe62e67ff),
    .syntaxn = RGBA(0x48d9e6ff),
    .syntaxv = RGBA(0x689d06ff),
    .syntaxc = RGBA(0x939393ff),
    .syntaxd = RGBA(0x9c73e6ff),
    .syntaxr = RGBA(0xc4753bff),
    .line_numbers = RGBA(0x777777ff),
  },
  .space_outliner = {
    .back = RGBA(0x28282800),
    .title = RGBA(0xffffffff),
    .text = RGBA(0xc3c3c3ff),
    .text_hi = RGBA(0xffffffff),
    .header = RGBA(0x282828b3),
    .header_text = RGBA(0xeeeeeeff),
    .header_text_hi = RGBA(0xffffffff),
    .active = RGBA(0x334d80ff),
    .vertex_size = 3,
    .outline_width = 1,
    .facedot_size = 4,
    .match = RGBA(0x337f334c),
    .selected_highlight = RGBA(0x1d314dff),
    .selected_object = RGBA(0xe96a00ff),
    .active_object = RGBA(0xffaf29ff),
    .edited_object = RGBA(0x00806266),
    .row_alternate = RGBA(0xffffff04),
  },
  .space_node = {
    .back = RGBA(0x1a1a1a00),
    .title = RGBA(0xeeeeeeff),
    .text = RGBA(0xe6e6e6ff),
    .text_hi = RGBA(0xffffffff),
    .header = RGBA(0x1a1a1ab3),
    .header_text = RGBA(0xeeeeeeff),
    .header_text_hi = RGBA(0xffffffff),
    .shade2 = RGBA(0x7f7f7f64),
    .grid = RGBA(0x30303000),
    .wire = RGBA(0x1a1a1aff),
    .select = RGBA(0xed5700ff),
    .active = RGBA(0xffffffff),
    .edge_select = RGBA(0xffffffb3),
    .console_output = RGBA(0x1d1d1dff),
    .vertex_size = 3,
    .outline_width = 1,
    .facedot_size = 4,
    .noodle_curving = 4,
    .grid_levels = 3,
    .dash_alpha = 0.5f,
    .syntaxl = RGBA(0x303030ff),
    .syntaxs = RGBA(0x5a3838ff),
    .syntaxb = RGBA(0x6e6e23ff),
    .syntaxn = RGBA(0x82354cff),
    .syntaxv = RGBA(0x246283ff),
    .syntaxc = RGBA(0x374725ff),
    .syntaxd = RGBA(0x3e5a5bff),
    .syntaxr = RGBA(0x8d8d8dff),
    .node_outline = RGBA(0xffffff26),
    .nodeclass_output = RGBA(0x3e232aff),
    .nodeclass_filter = RGBA(0x412b51ff),
    .nodeclass_vector = RGBA(0x3c3c83ff),
    .nodeclass_texture = RGBA(0x79461dff),
    .nodeclass_shader = RGBA(0x2b652bff),
    .nodeclass_script = RGBA(0x203c3cff),
    .nodeclass_geometry = RGBA(0x1d725eff),
    .nodeclass_attribute = RGBA(0x1d2546ff),
    .node_zone_simulation = RGBA(0x66416233),
    .node_zone_repeat = RGBA(0x76512f33),
    .node_zone_foreach_geometry_element = RGBA(0x33527f33),
    .node_zone_closure = RGBA(0x7d7d3a33),
    .movie = RGBA(0x0f0f0fcc),
    .gp_vertex_size = 3,
    .gp_vertex = RGBA(0x97979700),
    .gp_vertex_select = RGBA(0xff8500ff),
  },
  .space_preferences = {
    .back = RGBA(0x30303000),
    .title = RGBA(0xeeeeeeff),
    .text = RGBA(0xe6e6e6ff),
    .text_hi = RGBA(0xffffffff),
    .header = RGBA(0x303030b3),
    .header_text = RGBA(0xeeeeeeff),
    .header_text_hi = RGBA(0xffffffff),
    .vertex_size = 3,
    .outline_width = 1,
    .facedot_size = 4,
  },
  .space_console = {
    .back = RGBA(0x1d1d1d00),
    .title = RGBA(0xeeeeeeff),
    .text = RGBA(0xe6e6e6ff),
    .text_hi = RGBA(0xffffffff),
    .header = RGBA(0x303030b3),
    .header_text = RGBA(0xeeeeeeff),
    .header_text_hi = RGBA(0xffffffff),
    .console_output = RGBA(0x71a8ffff),
    .console_input = RGBA(0xf2f2f2ff),
    .console_info = RGBA(0x95d600ff),
    .console_error = RGBA(0xff4d84ff),
    .console_cursor = RGBA(0x71a8ffff),
    .console_select = RGBA(0xffffff30),
    .vertex_size = 3,
    .outline_width = 1,
    .facedot_size = 4,
  },
  .space_clip = {
    .back = RGBA(0x30303000),
    .title = RGBA(0xeeeeeeff),
    .text = RGBA(0xa6a6a6ff),
    .text_hi = RGBA(0xffffffff),
    .header = RGBA(0x303030b3),
    .header_text = RGBA(0xeeeeeeff),
    .header_text_hi = RGBA(0xffffffff),
    .grid = RGBA(0x181818ff),
    .vertex_size = 3,
    .outline_width = 1,
    .facedot_size = 4,
    .marker = RGBA(0x808000ff),
    .act_marker = RGBA(0xffffffff),
    .sel_marker = RGBA(0xffff00ff),
    .dis_marker = RGBA(0x7f0000ff),
    .lock_marker = RGBA(0x7f7f7fff),
    .path_before = RGBA(0xff0000ff),
    .path_after = RGBA(0x0000ffff),
    .path_keyframe_before = RGBA(0xffc4c4ff),
    .path_keyframe_after = RGBA(0xc4c4ffff),
    .gp_vertex_size = 1,
    .metadatatext = RGBA(0xffffffff),
  },
  .space_topbar = {
    .back = RGBA(0x18181800),
    .title = RGBA(0xffffffff),
    .text = RGBA(0xe6e6e6ff),
    .text_hi = RGBA(0xffffffff),
    .header = RGBA(0x181818b3),
    .header_text = RGBA(0xeeeeeeff),
    .header_text_hi = RGBA(0xffffffff),
    .vertex_size = 3,
    .outline_width = 1,
    .facedot_size = 4,
    .gp_vertex_size = 3,
  },
  .space_statusbar = {
    .back = RGBA(0x30303000),
    .title = RGBA(0xffffffff),
    .text = RGBA(0x838383ff),
    .text_hi = RGBA(0xffffffff),
    .header = RGBA(0x181818b3),
    .header_text = RGBA(0x888888ff),
    .header_text_hi = RGBA(0xffffffff),
    .vertex_size = 3,
    .outline_width = 1,
    .facedot_size = 4,
    .gp_vertex_size = 3,
  },
  .space_spreadsheet = {
    .back = RGBA(0x28282800),
    .title = RGBA(0xffffffff),
    .text = RGBA(0xc3c3c3ff),
    .text_hi = RGBA(0xffffffff),
    .header = RGBA(0x303030b3),
    .header_text = RGBA(0xeeeeeeff),
    .header_text_hi = RGBA(0xffffffff),
    .hilite = RGBA(0x80808080),
    .active = RGBA(0x3b5689ff),
    .vertex_size = 3,
    .outline_width = 1,
    .facedot_size = 4,
    .match = RGBA(0x337f334c),
    .selected_highlight = RGBA(0x223a5bff),
    .selected_object = RGBA(0xe96a00ff),
    .active_object = RGBA(0xffaf29ff),
    .edited_object = RGBA(0x00806266),
    .row_alternate = RGBA(0xffffff04),
  },
  .tarm = {
    {
      .solid = RGBA(0x9a0000ff),
      .select = RGBA(0xbd1111ff),
      .active = RGBA(0xf70a0aff),
    },
    {
      .solid = RGBA(0xf74018ff),
      .select = RGBA(0xf66913ff),
      .active = RGBA(0xfa9900ff),
    },
    {
      .solid = RGBA(0x1e9109ff),
      .select = RGBA(0x59b70bff),
      .active = RGBA(0x83ef1dff),
    },
    {
      .solid = RGBA(0x0a3694ff),
      .select = RGBA(0x3667dfff),
      .active = RGBA(0x5ec1efff),
    },
    {
      .solid = RGBA(0xa9294eff),
      .select = RGBA(0xc1416aff),
      .active = RGBA(0xf05d91ff),
    },
    {
      .solid = RGBA(0x430c78ff),
      .select = RGBA(0x543aa3ff),
      .active = RGBA(0x8764d5ff),
    },
    {
      .solid = RGBA(0x24785aff),
      .select = RGBA(0x3c9579ff),
      .active = RGBA(0x6fb6abff),
    },
    {
      .solid = RGBA(0x4b707cff),
      .select = RGBA(0x6a8691ff),
      .active = RGBA(0x9bc2cdff),
    },
    {
      .solid = RGBA(0xf4c90cff),
      .select = RGBA(0xeec236ff),
      .active = RGBA(0xf3ff00ff),
    },
    {
      .solid = RGBA(0x1e2024ff),
      .select = RGBA(0x484c56ff),
      .active = RGBA(0xffffffff),
    },
    {
      .solid = RGBA(0x6f2f6aff),
      .select = RGBA(0x9845beff),
      .active = RGBA(0xd330d6ff),
    },
    {
      .solid = RGBA(0x6c8e22ff),
      .select = RGBA(0x7fb022ff),
      .active = RGBA(0xbbef5bff),
    },
    {
      .solid = RGBA(0x8d8d8dff),
      .select = RGBA(0xb0b0b0ff),
      .active = RGBA(0xdededeff),
    },
    {
      .solid = RGBA(0x834326ff),
      .select = RGBA(0x8b5811ff),
      .active = RGBA(0xbd6a11ff),
    },
    {
      .solid = RGBA(0x08310eff),
      .select = RGBA(0x1c430bff),
      .active = RGBA(0x34622bff),
    },
    {
      .solid = RGBA(0x000000ff),
      .select = RGBA(0x000000ff),
      .active = RGBA(0x000000ff),
    },
    {
      .solid = RGBA(0x000000ff),
      .select = RGBA(0x000000ff),
      .active = RGBA(0x000000ff),
    },
    {
      .solid = RGBA(0x000000ff),
      .select = RGBA(0x000000ff),
      .active = RGBA(0x000000ff),
    },
    {
      .solid = RGBA(0x000000ff),
      .select = RGBA(0x000000ff),
      .active = RGBA(0x000000ff),
    },
    {
      .solid = RGBA(0x000000ff),
      .select = RGBA(0x000000ff),
      .active = RGBA(0x000000ff),
    },
  },
  .collection_color = {
    {
      .color = RGBA(0xe2605bff),
    },
    {
      .color = RGBA(0xf1a355ff),
    },
    {
      .color = RGBA(0xf1dc55ff),
    },
    {
      .color = RGBA(0x7bcc7bff),
    },
    {
      .color = RGBA(0x5db6eaff),
    },
    {
      .color = RGBA(0x8d59daff),
    },
    {
      .color = RGBA(0xc673b8ff),
    },
    {
      .color = RGBA(0x7a5441ff),
    },
  },
  .strip_color = {
    {
      .color = RGBA(0xcc5a52ff),
    },
    {
      .color = RGBA(0xcc8a48ff),
    },
    {
      .color = RGBA(0xb3a33fff),
    },
    {
      .color = RGBA(0x5c995cff),
    },
    {
      .color = RGBA(0x519fccff),
    },
    {
      .color = RGBA(0x8d59daff),
    },
    {
      .color = RGBA(0xc673b8ff),
    },
    {
      .color = RGBA(0x996952ff),
    },
    {
      .color = RGBA(0x808080ff),
    },
  },
};

/* clang-format on */
