use llvm_sys::target::*;
use llvm_sys::ir_reader::*;
use llvm_sys::error::*;
use llvm_sys::bit_writer::*;
use llvm_sys::bit_reader::*;
use llvm_sys::error_handling::*;
use llvm_sys::orc2::ee::*;
use llvm_sys::debuginfo::*;
use llvm_sys::core::*;
use llvm_sys::lto::*;
use llvm_sys::orc2::lljit::*;
use llvm_sys::linker::*;
use llvm_sys::disassembler::*;
use llvm_sys::*;
use llvm_sys::execution_engine::*;
use llvm_sys::orc2::*;
use llvm_sys::blake3::*;
use llvm_sys::support::*;
use llvm_sys::comdat::*;
use llvm_sys::transforms::pass_builder::*;
use llvm_sys::analysis::*;
use llvm_sys::prelude::*;
use llvm_sys::object::*;
use llvm_sys::remarks::*;
use llvm_sys::target_machine::*;
#[no_mangle]
pub extern "C" fn LLVMBuildAdd(
    arg1: LLVMBuilderRef,
    LHS: LLVMValueRef,
    RHS: LLVMValueRef,
    Name: *const ::libc::c_char,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMBuilderRef,
                    LLVMValueRef,
                    LLVMValueRef,
                    *const ::libc::c_char,
                ) -> LLVMValueRef,
            >(stringify!(LLVMBuildAdd).as_bytes())
    }
        .expect(stringify!(LLVMBuildAdd));
    entry(arg1, LHS, RHS, Name)
}
#[no_mangle]
pub extern "C" fn LLVMIsADbgInfoIntrinsic(Val: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMIsADbgInfoIntrinsic).as_bytes())
    }
        .expect(stringify!(LLVMIsADbgInfoIntrinsic));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn LLVMX86AMXTypeInContext(C: LLVMContextRef) -> LLVMTypeRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMContextRef) -> LLVMTypeRef,
            >(stringify!(LLVMX86AMXTypeInContext).as_bytes())
    }
        .expect(stringify!(LLVMX86AMXTypeInContext));
    entry(C)
}
#[no_mangle]
pub extern "C" fn LLVMGetBlockAddressFunction(BlockAddr: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMGetBlockAddressFunction).as_bytes())
    }
        .expect(stringify!(LLVMGetBlockAddressFunction));
    entry(BlockAddr)
}
#[no_mangle]
pub extern "C" fn LLVMSetSubprogram(Func: LLVMValueRef, SP: LLVMMetadataRef) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, LLVMMetadataRef),
            >(stringify!(LLVMSetSubprogram).as_bytes())
    }
        .expect(stringify!(LLVMSetSubprogram));
    entry(Func, SP)
}
#[no_mangle]
pub extern "C" fn LLVMBuildICmp(
    arg1: LLVMBuilderRef,
    Op: LLVMIntPredicate,
    LHS: LLVMValueRef,
    RHS: LLVMValueRef,
    Name: *const ::libc::c_char,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMBuilderRef,
                    LLVMIntPredicate,
                    LLVMValueRef,
                    LLVMValueRef,
                    *const ::libc::c_char,
                ) -> LLVMValueRef,
            >(stringify!(LLVMBuildICmp).as_bytes())
    }
        .expect(stringify!(LLVMBuildICmp));
    entry(arg1, Op, LHS, RHS, Name)
}
#[no_mangle]
pub extern "C" fn LLVMConstStruct(
    ConstantVals: *mut LLVMValueRef,
    Count: ::libc::c_uint,
    Packed: LLVMBool,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    *mut LLVMValueRef,
                    ::libc::c_uint,
                    LLVMBool,
                ) -> LLVMValueRef,
            >(stringify!(LLVMConstStruct).as_bytes())
    }
        .expect(stringify!(LLVMConstStruct));
    entry(ConstantVals, Count, Packed)
}
#[no_mangle]
pub extern "C" fn LLVMGetConstOpcode(ConstantVal: LLVMValueRef) -> LLVMOpcode {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMOpcode,
            >(stringify!(LLVMGetConstOpcode).as_bytes())
    }
        .expect(stringify!(LLVMGetConstOpcode));
    entry(ConstantVal)
}
#[no_mangle]
pub extern "C" fn lto_module_get_symbol_attribute(
    _mod: lto_module_t,
    index: ::libc::c_uint,
) -> lto_symbol_attributes {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(lto_module_t, ::libc::c_uint) -> lto_symbol_attributes,
            >(stringify!(lto_module_get_symbol_attribute).as_bytes())
    }
        .expect(stringify!(lto_module_get_symbol_attribute));
    entry(_mod, index)
}
#[no_mangle]
pub extern "C" fn LLVMInitializeLoongArchTargetMC() {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(),
            >(stringify!(LLVMInitializeLoongArchTargetMC).as_bytes())
    }
        .expect(stringify!(LLVMInitializeLoongArchTargetMC));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMGetInlineAsmCanUnwind(InlineAsmVal: LLVMValueRef) -> LLVMBool {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMBool,
            >(stringify!(LLVMGetInlineAsmCanUnwind).as_bytes())
    }
        .expect(stringify!(LLVMGetInlineAsmCanUnwind));
    entry(InlineAsmVal)
}
#[no_mangle]
pub extern "C" fn LLVMGetFirstBasicBlock(Fn: LLVMValueRef) -> LLVMBasicBlockRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMBasicBlockRef,
            >(stringify!(LLVMGetFirstBasicBlock).as_bytes())
    }
        .expect(stringify!(LLVMGetFirstBasicBlock));
    entry(Fn)
}
#[no_mangle]
pub extern "C" fn LLVMIntrinsicGetType(
    Ctx: LLVMContextRef,
    ID: ::libc::c_uint,
    ParamTypes: *mut LLVMTypeRef,
    ParamCount: ::libc::size_t,
) -> LLVMTypeRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMContextRef,
                    ::libc::c_uint,
                    *mut LLVMTypeRef,
                    ::libc::size_t,
                ) -> LLVMTypeRef,
            >(stringify!(LLVMIntrinsicGetType).as_bytes())
    }
        .expect(stringify!(LLVMIntrinsicGetType));
    entry(Ctx, ID, ParamTypes, ParamCount)
}
#[no_mangle]
pub extern "C" fn LLVMConstStringInContext2(
    C: LLVMContextRef,
    Str: *const ::libc::c_char,
    Length: usize,
    DontNullTerminate: LLVMBool,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMContextRef,
                    *const ::libc::c_char,
                    usize,
                    LLVMBool,
                ) -> LLVMValueRef,
            >(stringify!(LLVMConstStringInContext2).as_bytes())
    }
        .expect(stringify!(LLVMConstStringInContext2));
    entry(C, Str, Length, DontNullTerminate)
}
#[no_mangle]
pub extern "C" fn LLVMDbgRecordGetDebugLoc(Rec: LLVMDbgRecordRef) -> LLVMMetadataRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMDbgRecordRef) -> LLVMMetadataRef,
            >(stringify!(LLVMDbgRecordGetDebugLoc).as_bytes())
    }
        .expect(stringify!(LLVMDbgRecordGetDebugLoc));
    entry(Rec)
}
#[no_mangle]
pub extern "C" fn LLVMIsAICmpInst(Val: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMIsAICmpInst).as_bytes())
    }
        .expect(stringify!(LLVMIsAICmpInst));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn LLVMSetOrdering(
    MemoryAccessInst: LLVMValueRef,
    Ordering: LLVMAtomicOrdering,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, LLVMAtomicOrdering),
            >(stringify!(LLVMSetOrdering).as_bytes())
    }
        .expect(stringify!(LLVMSetOrdering));
    entry(MemoryAccessInst, Ordering)
}
#[no_mangle]
pub extern "C" fn thinlto_codegen_dispose(cg: thinlto_code_gen_t) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(thinlto_code_gen_t),
            >(stringify!(thinlto_codegen_dispose).as_bytes())
    }
        .expect(stringify!(thinlto_codegen_dispose));
    entry(cg)
}
#[no_mangle]
pub extern "C" fn LLVMInitializeMipsAsmParser() {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<extern "C" fn()>(stringify!(LLVMInitializeMipsAsmParser).as_bytes())
    }
        .expect(stringify!(LLVMInitializeMipsAsmParser));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMInitializeLoongArchDisassembler() {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(),
            >(stringify!(LLVMInitializeLoongArchDisassembler).as_bytes())
    }
        .expect(stringify!(LLVMInitializeLoongArchDisassembler));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMGetSectionContainsSymbol(
    SI: LLVMSectionIteratorRef,
    Sym: LLVMSymbolIteratorRef,
) -> LLVMBool {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMSectionIteratorRef, LLVMSymbolIteratorRef) -> LLVMBool,
            >(stringify!(LLVMGetSectionContainsSymbol).as_bytes())
    }
        .expect(stringify!(LLVMGetSectionContainsSymbol));
    entry(SI, Sym)
}
#[no_mangle]
pub extern "C" fn LLVMPassBuilderOptionsSetLoopVectorization(
    Options: LLVMPassBuilderOptionsRef,
    LoopVectorization: LLVMBool,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMPassBuilderOptionsRef, LLVMBool),
            >(stringify!(LLVMPassBuilderOptionsSetLoopVectorization).as_bytes())
    }
        .expect(stringify!(LLVMPassBuilderOptionsSetLoopVectorization));
    entry(Options, LoopVectorization)
}
#[no_mangle]
pub extern "C" fn LLVMSetExact(DivOrShrInst: LLVMValueRef, IsExact: LLVMBool) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, LLVMBool),
            >(stringify!(LLVMSetExact).as_bytes())
    }
        .expect(stringify!(LLVMSetExact));
    entry(DivOrShrInst, IsExact)
}
#[no_mangle]
pub extern "C" fn LLVMGetEnumAttributeValue(A: LLVMAttributeRef) -> u64 {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMAttributeRef) -> u64,
            >(stringify!(LLVMGetEnumAttributeValue).as_bytes())
    }
        .expect(stringify!(LLVMGetEnumAttributeValue));
    entry(A)
}
#[no_mangle]
pub extern "C" fn LLVMBuildTrunc(
    arg1: LLVMBuilderRef,
    Val: LLVMValueRef,
    DestTy: LLVMTypeRef,
    Name: *const ::libc::c_char,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMBuilderRef,
                    LLVMValueRef,
                    LLVMTypeRef,
                    *const ::libc::c_char,
                ) -> LLVMValueRef,
            >(stringify!(LLVMBuildTrunc).as_bytes())
    }
        .expect(stringify!(LLVMBuildTrunc));
    entry(arg1, Val, DestTy, Name)
}
#[no_mangle]
pub extern "C" fn LLVMDIBuilderCreateNameSpace(
    Builder: LLVMDIBuilderRef,
    ParentScope: LLVMMetadataRef,
    Name: *const ::libc::c_char,
    NameLen: ::libc::size_t,
    ExportSymbols: LLVMBool,
) -> LLVMMetadataRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMDIBuilderRef,
                    LLVMMetadataRef,
                    *const ::libc::c_char,
                    ::libc::size_t,
                    LLVMBool,
                ) -> LLVMMetadataRef,
            >(stringify!(LLVMDIBuilderCreateNameSpace).as_bytes())
    }
        .expect(stringify!(LLVMDIBuilderCreateNameSpace));
    entry(Builder, ParentScope, Name, NameLen, ExportSymbols)
}
#[no_mangle]
pub extern "C" fn LLVMIsAIntToPtrInst(Val: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMIsAIntToPtrInst).as_bytes())
    }
        .expect(stringify!(LLVMIsAIntToPtrInst));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn LLVMDIBuilderCreateVectorType(
    Builder: LLVMDIBuilderRef,
    Size: u64,
    AlignInBits: u32,
    Ty: LLVMMetadataRef,
    Subscripts: *mut LLVMMetadataRef,
    NumSubscripts: ::libc::c_uint,
) -> LLVMMetadataRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMDIBuilderRef,
                    u64,
                    u32,
                    LLVMMetadataRef,
                    *mut LLVMMetadataRef,
                    ::libc::c_uint,
                ) -> LLVMMetadataRef,
            >(stringify!(LLVMDIBuilderCreateVectorType).as_bytes())
    }
        .expect(stringify!(LLVMDIBuilderCreateVectorType));
    entry(Builder, Size, AlignInBits, Ty, Subscripts, NumSubscripts)
}
#[no_mangle]
pub extern "C" fn LLVMReplaceAllUsesWith(OldVal: LLVMValueRef, NewVal: LLVMValueRef) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, LLVMValueRef),
            >(stringify!(LLVMReplaceAllUsesWith).as_bytes())
    }
        .expect(stringify!(LLVMReplaceAllUsesWith));
    entry(OldVal, NewVal)
}
#[no_mangle]
pub extern "C" fn LLVMCreatePassManager() -> LLVMPassManagerRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn() -> LLVMPassManagerRef,
            >(stringify!(LLVMCreatePassManager).as_bytes())
    }
        .expect(stringify!(LLVMCreatePassManager));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMGetClause(
    LandingPad: LLVMValueRef,
    Idx: ::libc::c_uint,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, ::libc::c_uint) -> LLVMValueRef,
            >(stringify!(LLVMGetClause).as_bytes())
    }
        .expect(stringify!(LLVMGetClause));
    entry(LandingPad, Idx)
}
#[no_mangle]
pub extern "C" fn LLVMDIBuilderCreateConstantValueExpression(
    Builder: LLVMDIBuilderRef,
    Value: u64,
) -> LLVMMetadataRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMDIBuilderRef, u64) -> LLVMMetadataRef,
            >(stringify!(LLVMDIBuilderCreateConstantValueExpression).as_bytes())
    }
        .expect(stringify!(LLVMDIBuilderCreateConstantValueExpression));
    entry(Builder, Value)
}
#[no_mangle]
pub extern "C" fn LLVMIsTailCall(CallInst: LLVMValueRef) -> LLVMBool {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMBool,
            >(stringify!(LLVMIsTailCall).as_bytes())
    }
        .expect(stringify!(LLVMIsTailCall));
    entry(CallInst)
}
#[no_mangle]
pub extern "C" fn LLVMGetFirstDbgRecord(Inst: LLVMValueRef) -> LLVMDbgRecordRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMDbgRecordRef,
            >(stringify!(LLVMGetFirstDbgRecord).as_bytes())
    }
        .expect(stringify!(LLVMGetFirstDbgRecord));
    entry(Inst)
}
#[no_mangle]
pub extern "C" fn LLVMGlobalAddDebugInfo(Global: LLVMValueRef, GVE: LLVMMetadataRef) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, LLVMMetadataRef),
            >(stringify!(LLVMGlobalAddDebugInfo).as_bytes())
    }
        .expect(stringify!(LLVMGlobalAddDebugInfo));
    entry(Global, GVE)
}
#[no_mangle]
pub extern "C" fn LLVMTargetMachineEmitToMemoryBuffer(
    T: LLVMTargetMachineRef,
    M: LLVMModuleRef,
    codegen: LLVMCodeGenFileType,
    ErrorMessage: *mut *mut ::libc::c_char,
    OutMemBuf: *mut LLVMMemoryBufferRef,
) -> LLVMBool {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMTargetMachineRef,
                    LLVMModuleRef,
                    LLVMCodeGenFileType,
                    *mut *mut ::libc::c_char,
                    *mut LLVMMemoryBufferRef,
                ) -> LLVMBool,
            >(stringify!(LLVMTargetMachineEmitToMemoryBuffer).as_bytes())
    }
        .expect(stringify!(LLVMTargetMachineEmitToMemoryBuffer));
    entry(T, M, codegen, ErrorMessage, OutMemBuf)
}
#[no_mangle]
pub extern "C" fn LLVMGetDLLStorageClass(Global: LLVMValueRef) -> LLVMDLLStorageClass {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMDLLStorageClass,
            >(stringify!(LLVMGetDLLStorageClass).as_bytes())
    }
        .expect(stringify!(LLVMGetDLLStorageClass));
    entry(Global)
}
#[no_mangle]
pub extern "C" fn LLVMIsAConstantTokenNone(Val: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMIsAConstantTokenNone).as_bytes())
    }
        .expect(stringify!(LLVMIsAConstantTokenNone));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn LLVMTargetHasJIT(T: LLVMTargetRef) -> LLVMBool {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMTargetRef) -> LLVMBool,
            >(stringify!(LLVMTargetHasJIT).as_bytes())
    }
        .expect(stringify!(LLVMTargetHasJIT));
    entry(T)
}
#[no_mangle]
pub extern "C" fn LLVMAddCallSiteAttribute(
    C: LLVMValueRef,
    Idx: LLVMAttributeIndex,
    A: LLVMAttributeRef,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, LLVMAttributeIndex, LLVMAttributeRef),
            >(stringify!(LLVMAddCallSiteAttribute).as_bytes())
    }
        .expect(stringify!(LLVMAddCallSiteAttribute));
    entry(C, Idx, A)
}
#[no_mangle]
pub extern "C" fn LLVMGetNamedGlobal(
    M: LLVMModuleRef,
    Name: *const ::libc::c_char,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMModuleRef, *const ::libc::c_char) -> LLVMValueRef,
            >(stringify!(LLVMGetNamedGlobal).as_bytes())
    }
        .expect(stringify!(LLVMGetNamedGlobal));
    entry(M, Name)
}
#[no_mangle]
pub extern "C" fn LLVMInitializeSystemZAsmPrinter() {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(),
            >(stringify!(LLVMInitializeSystemZAsmPrinter).as_bytes())
    }
        .expect(stringify!(LLVMInitializeSystemZAsmPrinter));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMDIFileGetFilename(
    File: LLVMMetadataRef,
    Len: *mut ::libc::c_uint,
) -> *const ::libc::c_char {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMMetadataRef,
                    *mut ::libc::c_uint,
                ) -> *const ::libc::c_char,
            >(stringify!(LLVMDIFileGetFilename).as_bytes())
    }
        .expect(stringify!(LLVMDIFileGetFilename));
    entry(File, Len)
}
#[no_mangle]
pub extern "C" fn LLVMScalableVectorType(
    ElementType: LLVMTypeRef,
    ElementCount: ::libc::c_uint,
) -> LLVMTypeRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMTypeRef, ::libc::c_uint) -> LLVMTypeRef,
            >(stringify!(LLVMScalableVectorType).as_bytes())
    }
        .expect(stringify!(LLVMScalableVectorType));
    entry(ElementType, ElementCount)
}
#[no_mangle]
pub extern "C" fn LLVMGetCallBrDefaultDest(CallBr: LLVMValueRef) -> LLVMBasicBlockRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMBasicBlockRef,
            >(stringify!(LLVMGetCallBrDefaultDest).as_bytes())
    }
        .expect(stringify!(LLVMGetCallBrDefaultDest));
    entry(CallBr)
}
#[no_mangle]
pub extern "C" fn LLVMGetElementType(Ty: LLVMTypeRef) -> LLVMTypeRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMTypeRef) -> LLVMTypeRef,
            >(stringify!(LLVMGetElementType).as_bytes())
    }
        .expect(stringify!(LLVMGetElementType));
    entry(Ty)
}
#[no_mangle]
pub extern "C" fn LLVMOrcDisposeSymbols(Symbols: *mut LLVMOrcSymbolStringPoolEntryRef) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(*mut LLVMOrcSymbolStringPoolEntryRef),
            >(stringify!(LLVMOrcDisposeSymbols).as_bytes())
    }
        .expect(stringify!(LLVMOrcDisposeSymbols));
    entry(Symbols)
}
#[no_mangle]
pub extern "C" fn lto_module_is_object_file_in_memory_for_target(
    mem: *const ::libc::c_void,
    length: ::libc::size_t,
    target_triple_prefix: *const ::libc::c_char,
) -> lto_bool_t {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    *const ::libc::c_void,
                    ::libc::size_t,
                    *const ::libc::c_char,
                ) -> lto_bool_t,
            >(stringify!(lto_module_is_object_file_in_memory_for_target).as_bytes())
    }
        .expect(stringify!(lto_module_is_object_file_in_memory_for_target));
    entry(mem, length, target_triple_prefix)
}
#[no_mangle]
pub extern "C" fn thinlto_module_get_object_file(
    cg: thinlto_code_gen_t,
    index: ::libc::c_uint,
) -> *const ::libc::c_char {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    thinlto_code_gen_t,
                    ::libc::c_uint,
                ) -> *const ::libc::c_char,
            >(stringify!(thinlto_module_get_object_file).as_bytes())
    }
        .expect(stringify!(thinlto_module_get_object_file));
    entry(cg, index)
}
#[no_mangle]
pub extern "C" fn LLVMFinalizeFunctionPassManager(FPM: LLVMPassManagerRef) -> LLVMBool {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMPassManagerRef) -> LLVMBool,
            >(stringify!(LLVMFinalizeFunctionPassManager).as_bytes())
    }
        .expect(stringify!(LLVMFinalizeFunctionPassManager));
    entry(FPM)
}
#[no_mangle]
pub extern "C" fn LLVMVoidTypeInContext(C: LLVMContextRef) -> LLVMTypeRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMContextRef) -> LLVMTypeRef,
            >(stringify!(LLVMVoidTypeInContext).as_bytes())
    }
        .expect(stringify!(LLVMVoidTypeInContext));
    entry(C)
}
#[no_mangle]
pub extern "C" fn LLVMViewFunctionCFGOnly(Fn: LLVMValueRef) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef),
            >(stringify!(LLVMViewFunctionCFGOnly).as_bytes())
    }
        .expect(stringify!(LLVMViewFunctionCFGOnly));
    entry(Fn)
}
#[no_mangle]
pub extern "C" fn LLVMInitializeMSP430Target() {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<extern "C" fn()>(stringify!(LLVMInitializeMSP430Target).as_bytes())
    }
        .expect(stringify!(LLVMInitializeMSP430Target));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMGetRawDataValues(
    c: LLVMValueRef,
    SizeInBytes: usize,
) -> *const ::libc::c_char {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, usize) -> *const ::libc::c_char,
            >(stringify!(LLVMGetRawDataValues).as_bytes())
    }
        .expect(stringify!(LLVMGetRawDataValues));
    entry(c, SizeInBytes)
}
#[no_mangle]
pub extern "C" fn LLVMBuildNUWMul(
    arg1: LLVMBuilderRef,
    LHS: LLVMValueRef,
    RHS: LLVMValueRef,
    Name: *const ::libc::c_char,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMBuilderRef,
                    LLVMValueRef,
                    LLVMValueRef,
                    *const ::libc::c_char,
                ) -> LLVMValueRef,
            >(stringify!(LLVMBuildNUWMul).as_bytes())
    }
        .expect(stringify!(LLVMBuildNUWMul));
    entry(arg1, LHS, RHS, Name)
}
#[no_mangle]
pub extern "C" fn LLVMRemarkParserGetErrorMessage(
    Parser: LLVMRemarkParserRef,
) -> *const ::libc::c_char {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMRemarkParserRef) -> *const ::libc::c_char,
            >(stringify!(LLVMRemarkParserGetErrorMessage).as_bytes())
    }
        .expect(stringify!(LLVMRemarkParserGetErrorMessage));
    entry(Parser)
}
#[no_mangle]
pub extern "C" fn LLVMInitializeMCJITCompilerOptions(
    Options: *mut LLVMMCJITCompilerOptions,
    SizeOfOptions: ::libc::size_t,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(*mut LLVMMCJITCompilerOptions, ::libc::size_t),
            >(stringify!(LLVMInitializeMCJITCompilerOptions).as_bytes())
    }
        .expect(stringify!(LLVMInitializeMCJITCompilerOptions));
    entry(Options, SizeOfOptions)
}
#[no_mangle]
pub extern "C" fn LLVMIsADbgLabelInst(Val: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMIsADbgLabelInst).as_bytes())
    }
        .expect(stringify!(LLVMIsADbgLabelInst));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn thinlto_debug_options(
    options: *const *const ::libc::c_char,
    number: ::libc::c_int,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(*const *const ::libc::c_char, ::libc::c_int),
            >(stringify!(thinlto_debug_options).as_bytes())
    }
        .expect(stringify!(thinlto_debug_options));
    entry(options, number)
}
#[no_mangle]
pub extern "C" fn LLVMGetCurrentDebugLocation2(
    Builder: LLVMBuilderRef,
) -> LLVMMetadataRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMBuilderRef) -> LLVMMetadataRef,
            >(stringify!(LLVMGetCurrentDebugLocation2).as_bytes())
    }
        .expect(stringify!(LLVMGetCurrentDebugLocation2));
    entry(Builder)
}
#[no_mangle]
pub extern "C" fn LLVMPassBuilderOptionsSetSLPVectorization(
    Options: LLVMPassBuilderOptionsRef,
    SLPVectorization: LLVMBool,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMPassBuilderOptionsRef, LLVMBool),
            >(stringify!(LLVMPassBuilderOptionsSetSLPVectorization).as_bytes())
    }
        .expect(stringify!(LLVMPassBuilderOptionsSetSLPVectorization));
    entry(Options, SLPVectorization)
}
#[no_mangle]
pub extern "C" fn LLVMInitializeAArch64Target() {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<extern "C" fn()>(stringify!(LLVMInitializeAArch64Target).as_bytes())
    }
        .expect(stringify!(LLVMInitializeAArch64Target));
    entry()
}
#[no_mangle]
pub extern "C" fn thinlto_codegen_add_module(
    cg: thinlto_code_gen_t,
    identifier: *const ::libc::c_char,
    data: *const ::libc::c_char,
    length: ::libc::c_int,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    thinlto_code_gen_t,
                    *const ::libc::c_char,
                    *const ::libc::c_char,
                    ::libc::c_int,
                ),
            >(stringify!(thinlto_codegen_add_module).as_bytes())
    }
        .expect(stringify!(thinlto_codegen_add_module));
    entry(cg, identifier, data, length)
}
#[no_mangle]
pub extern "C" fn LLVMSetSourceFileName(
    M: LLVMModuleRef,
    Name: *const ::libc::c_char,
    Len: ::libc::size_t,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMModuleRef, *const ::libc::c_char, ::libc::size_t),
            >(stringify!(LLVMSetSourceFileName).as_bytes())
    }
        .expect(stringify!(LLVMSetSourceFileName));
    entry(M, Name, Len)
}
#[no_mangle]
pub extern "C" fn thinlto_codegen_set_final_cache_size_relative_to_available_space(
    cg: thinlto_code_gen_t,
    percentage: ::libc::c_uint,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(thinlto_code_gen_t, ::libc::c_uint),
            >(
                stringify!(
                    thinlto_codegen_set_final_cache_size_relative_to_available_space
                )
                    .as_bytes(),
            )
    }
        .expect(
            stringify!(thinlto_codegen_set_final_cache_size_relative_to_available_space),
        );
    entry(cg, percentage)
}
#[no_mangle]
pub extern "C" fn LLVMInt128Type() -> LLVMTypeRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<extern "C" fn() -> LLVMTypeRef>(stringify!(LLVMInt128Type).as_bytes())
    }
        .expect(stringify!(LLVMInt128Type));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMOrcMaterializationResponsibilityFailMaterialization(
    MR: LLVMOrcMaterializationResponsibilityRef,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMOrcMaterializationResponsibilityRef),
            >(
                stringify!(LLVMOrcMaterializationResponsibilityFailMaterialization)
                    .as_bytes(),
            )
    }
        .expect(stringify!(LLVMOrcMaterializationResponsibilityFailMaterialization));
    entry(MR)
}
#[no_mangle]
pub extern "C" fn LLVMDisposeMemoryBuffer(MemBuf: LLVMMemoryBufferRef) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMMemoryBufferRef),
            >(stringify!(LLVMDisposeMemoryBuffer).as_bytes())
    }
        .expect(stringify!(LLVMDisposeMemoryBuffer));
    entry(MemBuf)
}
#[no_mangle]
pub extern "C" fn LLVMGetNextDbgRecord(DbgRecord: LLVMDbgRecordRef) -> LLVMDbgRecordRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMDbgRecordRef) -> LLVMDbgRecordRef,
            >(stringify!(LLVMGetNextDbgRecord).as_bytes())
    }
        .expect(stringify!(LLVMGetNextDbgRecord));
    entry(DbgRecord)
}
#[no_mangle]
pub extern "C" fn LLVMGetAsString(
    C: LLVMValueRef,
    Length: *mut ::libc::size_t,
) -> *const ::libc::c_char {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, *mut ::libc::size_t) -> *const ::libc::c_char,
            >(stringify!(LLVMGetAsString).as_bytes())
    }
        .expect(stringify!(LLVMGetAsString));
    entry(C, Length)
}
#[no_mangle]
pub extern "C" fn LLVMParseCommandLineOptions(
    argc: ::libc::c_int,
    argv: *const *const ::libc::c_char,
    Overview: *const ::libc::c_char,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    ::libc::c_int,
                    *const *const ::libc::c_char,
                    *const ::libc::c_char,
                ),
            >(stringify!(LLVMParseCommandLineOptions).as_bytes())
    }
        .expect(stringify!(LLVMParseCommandLineOptions));
    entry(argc, argv, Overview)
}
#[no_mangle]
pub extern "C" fn LLVMStartMultithreaded() -> LLVMBool {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn() -> LLVMBool,
            >(stringify!(LLVMStartMultithreaded).as_bytes())
    }
        .expect(stringify!(LLVMStartMultithreaded));
    entry()
}
#[no_mangle]
pub extern "C" fn lto_codegen_set_assembler_path(
    cg: lto_code_gen_t,
    path: *const ::libc::c_char,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(lto_code_gen_t, *const ::libc::c_char),
            >(stringify!(lto_codegen_set_assembler_path).as_bytes())
    }
        .expect(stringify!(lto_codegen_set_assembler_path));
    entry(cg, path)
}
#[no_mangle]
pub extern "C" fn lto_initialize_disassembler() {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<extern "C" fn()>(stringify!(lto_initialize_disassembler).as_bytes())
    }
        .expect(stringify!(lto_initialize_disassembler));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMGetRelocationOffset(RI: LLVMRelocationIteratorRef) -> u64 {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMRelocationIteratorRef) -> u64,
            >(stringify!(LLVMGetRelocationOffset).as_bytes())
    }
        .expect(stringify!(LLVMGetRelocationOffset));
    entry(RI)
}
#[no_mangle]
pub extern "C" fn LLVMRemoveEnumAttributeAtIndex(
    F: LLVMValueRef,
    Idx: LLVMAttributeIndex,
    KindID: ::libc::c_uint,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, LLVMAttributeIndex, ::libc::c_uint),
            >(stringify!(LLVMRemoveEnumAttributeAtIndex).as_bytes())
    }
        .expect(stringify!(LLVMRemoveEnumAttributeAtIndex));
    entry(F, Idx, KindID)
}
#[no_mangle]
pub extern "C" fn LLVMGetMDString(
    V: LLVMValueRef,
    Len: *mut ::libc::c_uint,
) -> *const ::libc::c_char {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, *mut ::libc::c_uint) -> *const ::libc::c_char,
            >(stringify!(LLVMGetMDString).as_bytes())
    }
        .expect(stringify!(LLVMGetMDString));
    entry(V, Len)
}
#[no_mangle]
pub extern "C" fn LLVMIsAVAArgInst(Val: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMIsAVAArgInst).as_bytes())
    }
        .expect(stringify!(LLVMIsAVAArgInst));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn LLVMTemporaryMDNode(
    Ctx: LLVMContextRef,
    Data: *mut LLVMMetadataRef,
    NumElements: ::libc::size_t,
) -> LLVMMetadataRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMContextRef,
                    *mut LLVMMetadataRef,
                    ::libc::size_t,
                ) -> LLVMMetadataRef,
            >(stringify!(LLVMTemporaryMDNode).as_bytes())
    }
        .expect(stringify!(LLVMTemporaryMDNode));
    entry(Ctx, Data, NumElements)
}
#[no_mangle]
pub extern "C" fn LLVMParseIRInContext(
    ContextRef: LLVMContextRef,
    MemBuf: LLVMMemoryBufferRef,
    OutM: *mut LLVMModuleRef,
    OutMessage: *mut *mut ::libc::c_char,
) -> LLVMBool {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMContextRef,
                    LLVMMemoryBufferRef,
                    *mut LLVMModuleRef,
                    *mut *mut ::libc::c_char,
                ) -> LLVMBool,
            >(stringify!(LLVMParseIRInContext).as_bytes())
    }
        .expect(stringify!(LLVMParseIRInContext));
    entry(ContextRef, MemBuf, OutM, OutMessage)
}
#[no_mangle]
pub extern "C" fn LLVMIsAIntrinsicInst(Val: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMIsAIntrinsicInst).as_bytes())
    }
        .expect(stringify!(LLVMIsAIntrinsicInst));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn LLVMBuildMul(
    arg1: LLVMBuilderRef,
    LHS: LLVMValueRef,
    RHS: LLVMValueRef,
    Name: *const ::libc::c_char,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMBuilderRef,
                    LLVMValueRef,
                    LLVMValueRef,
                    *const ::libc::c_char,
                ) -> LLVMValueRef,
            >(stringify!(LLVMBuildMul).as_bytes())
    }
        .expect(stringify!(LLVMBuildMul));
    entry(arg1, LHS, RHS, Name)
}
#[no_mangle]
pub extern "C" fn thinlto_codegen_set_cache_size_megabytes(
    cg: thinlto_code_gen_t,
    max_size_megabytes: ::libc::c_uint,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(thinlto_code_gen_t, ::libc::c_uint),
            >(stringify!(thinlto_codegen_set_cache_size_megabytes).as_bytes())
    }
        .expect(stringify!(thinlto_codegen_set_cache_size_megabytes));
    entry(cg, max_size_megabytes)
}
#[no_mangle]
pub extern "C" fn LLVMObjectFileCopySectionIterator(
    BR: LLVMBinaryRef,
) -> LLVMSectionIteratorRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMBinaryRef) -> LLVMSectionIteratorRef,
            >(stringify!(LLVMObjectFileCopySectionIterator).as_bytes())
    }
        .expect(stringify!(LLVMObjectFileCopySectionIterator));
    entry(BR)
}
#[no_mangle]
pub extern "C" fn LLVMInitializeLoongArchAsmParser() {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(),
            >(stringify!(LLVMInitializeLoongArchAsmParser).as_bytes())
    }
        .expect(stringify!(LLVMInitializeLoongArchAsmParser));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMInitializeRISCVDisassembler() {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(),
            >(stringify!(LLVMInitializeRISCVDisassembler).as_bytes())
    }
        .expect(stringify!(LLVMInitializeRISCVDisassembler));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMGetInlineAsmFunctionType(
    InlineAsmVal: LLVMValueRef,
) -> LLVMTypeRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMTypeRef,
            >(stringify!(LLVMGetInlineAsmFunctionType).as_bytes())
    }
        .expect(stringify!(LLVMGetInlineAsmFunctionType));
    entry(InlineAsmVal)
}
#[no_mangle]
pub extern "C" fn LLVMConstNSWAdd(
    LHSConstant: LLVMValueRef,
    RHSConstant: LLVMValueRef,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMConstNSWAdd).as_bytes())
    }
        .expect(stringify!(LLVMConstNSWAdd));
    entry(LHSConstant, RHSConstant)
}
#[no_mangle]
pub extern "C" fn LLVMGetTailCallKind(CallInst: LLVMValueRef) -> LLVMTailCallKind {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMTailCallKind,
            >(stringify!(LLVMGetTailCallKind).as_bytes())
    }
        .expect(stringify!(LLVMGetTailCallKind));
    entry(CallInst)
}
#[no_mangle]
pub extern "C" fn LLVMGlobalClearMetadata(Global: LLVMValueRef) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef),
            >(stringify!(LLVMGlobalClearMetadata).as_bytes())
    }
        .expect(stringify!(LLVMGlobalClearMetadata));
    entry(Global)
}
#[no_mangle]
pub extern "C" fn LLVMConstArray(
    ElementTy: LLVMTypeRef,
    ConstantVals: *mut LLVMValueRef,
    Length: ::libc::c_uint,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMTypeRef,
                    *mut LLVMValueRef,
                    ::libc::c_uint,
                ) -> LLVMValueRef,
            >(stringify!(LLVMConstArray).as_bytes())
    }
        .expect(stringify!(LLVMConstArray));
    entry(ElementTy, ConstantVals, Length)
}
#[no_mangle]
pub extern "C" fn LLVMGetFCmpPredicate(Inst: LLVMValueRef) -> LLVMRealPredicate {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMRealPredicate,
            >(stringify!(LLVMGetFCmpPredicate).as_bytes())
    }
        .expect(stringify!(LLVMGetFCmpPredicate));
    entry(Inst)
}
#[no_mangle]
pub extern "C" fn LLVMDIBuilderCreateArtificialType(
    Builder: LLVMDIBuilderRef,
    Type: LLVMMetadataRef,
) -> LLVMMetadataRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMDIBuilderRef, LLVMMetadataRef) -> LLVMMetadataRef,
            >(stringify!(LLVMDIBuilderCreateArtificialType).as_bytes())
    }
        .expect(stringify!(LLVMDIBuilderCreateArtificialType));
    entry(Builder, Type)
}
#[no_mangle]
pub extern "C" fn LLVMInt16TypeInContext(C: LLVMContextRef) -> LLVMTypeRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMContextRef) -> LLVMTypeRef,
            >(stringify!(LLVMInt16TypeInContext).as_bytes())
    }
        .expect(stringify!(LLVMInt16TypeInContext));
    entry(C)
}
#[no_mangle]
pub extern "C" fn LLVMSetThreadLocal(GlobalVar: LLVMValueRef, IsThreadLocal: LLVMBool) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, LLVMBool),
            >(stringify!(LLVMSetThreadLocal).as_bytes())
    }
        .expect(stringify!(LLVMSetThreadLocal));
    entry(GlobalVar, IsThreadLocal)
}
#[no_mangle]
pub extern "C" fn LLVMDIBuilderFinalize(Builder: LLVMDIBuilderRef) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMDIBuilderRef),
            >(stringify!(LLVMDIBuilderFinalize).as_bytes())
    }
        .expect(stringify!(LLVMDIBuilderFinalize));
    entry(Builder)
}
#[no_mangle]
pub extern "C" fn LLVMSetAtomicSyncScopeID(
    AtomicInst: LLVMValueRef,
    SSID: ::libc::c_uint,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, ::libc::c_uint),
            >(stringify!(LLVMSetAtomicSyncScopeID).as_bytes())
    }
        .expect(stringify!(LLVMSetAtomicSyncScopeID));
    entry(AtomicInst, SSID)
}
#[no_mangle]
pub extern "C" fn LLVMConstString(
    Str: *const ::libc::c_char,
    Length: ::libc::c_uint,
    DontNullTerminate: LLVMBool,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    *const ::libc::c_char,
                    ::libc::c_uint,
                    LLVMBool,
                ) -> LLVMValueRef,
            >(stringify!(LLVMConstString).as_bytes())
    }
        .expect(stringify!(LLVMConstString));
    entry(Str, Length, DontNullTerminate)
}
#[no_mangle]
pub extern "C" fn LLVMCountStructElementTypes(StructTy: LLVMTypeRef) -> ::libc::c_uint {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMTypeRef) -> ::libc::c_uint,
            >(stringify!(LLVMCountStructElementTypes).as_bytes())
    }
        .expect(stringify!(LLVMCountStructElementTypes));
    entry(StructTy)
}
#[no_mangle]
pub extern "C" fn LLVMCantFail(Error: LLVMErrorRef) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<extern "C" fn(LLVMErrorRef)>(stringify!(LLVMCantFail).as_bytes())
    }
        .expect(stringify!(LLVMCantFail));
    entry(Error)
}
#[no_mangle]
pub extern "C" fn LLVMConstNUWNeg(ConstantVal: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMConstNUWNeg).as_bytes())
    }
        .expect(stringify!(LLVMConstNUWNeg));
    entry(ConstantVal)
}
#[no_mangle]
pub extern "C" fn LLVMDisposeMCJITMemoryManager(MM: LLVMMCJITMemoryManagerRef) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMMCJITMemoryManagerRef),
            >(stringify!(LLVMDisposeMCJITMemoryManager).as_bytes())
    }
        .expect(stringify!(LLVMDisposeMCJITMemoryManager));
    entry(MM)
}
#[no_mangle]
pub extern "C" fn LLVMBuildNUWSub(
    arg1: LLVMBuilderRef,
    LHS: LLVMValueRef,
    RHS: LLVMValueRef,
    Name: *const ::libc::c_char,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMBuilderRef,
                    LLVMValueRef,
                    LLVMValueRef,
                    *const ::libc::c_char,
                ) -> LLVMValueRef,
            >(stringify!(LLVMBuildNUWSub).as_bytes())
    }
        .expect(stringify!(LLVMBuildNUWSub));
    entry(arg1, LHS, RHS, Name)
}
#[no_mangle]
pub extern "C" fn LLVMGetSubtypes(Tp: LLVMTypeRef, Arr: *mut LLVMTypeRef) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMTypeRef, *mut LLVMTypeRef),
            >(stringify!(LLVMGetSubtypes).as_bytes())
    }
        .expect(stringify!(LLVMGetSubtypes));
    entry(Tp, Arr)
}
#[no_mangle]
pub extern "C" fn LLVMBuildOr(
    arg1: LLVMBuilderRef,
    LHS: LLVMValueRef,
    RHS: LLVMValueRef,
    Name: *const ::libc::c_char,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMBuilderRef,
                    LLVMValueRef,
                    LLVMValueRef,
                    *const ::libc::c_char,
                ) -> LLVMValueRef,
            >(stringify!(LLVMBuildOr).as_bytes())
    }
        .expect(stringify!(LLVMBuildOr));
    entry(arg1, LHS, RHS, Name)
}
#[no_mangle]
pub extern "C" fn LLVMCreateBasicBlockInContext(
    C: LLVMContextRef,
    Name: *const ::libc::c_char,
) -> LLVMBasicBlockRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMContextRef, *const ::libc::c_char) -> LLVMBasicBlockRef,
            >(stringify!(LLVMCreateBasicBlockInContext).as_bytes())
    }
        .expect(stringify!(LLVMCreateBasicBlockInContext));
    entry(C, Name)
}
#[no_mangle]
pub extern "C" fn LLVMBuildFPExt(
    arg1: LLVMBuilderRef,
    Val: LLVMValueRef,
    DestTy: LLVMTypeRef,
    Name: *const ::libc::c_char,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMBuilderRef,
                    LLVMValueRef,
                    LLVMTypeRef,
                    *const ::libc::c_char,
                ) -> LLVMValueRef,
            >(stringify!(LLVMBuildFPExt).as_bytes())
    }
        .expect(stringify!(LLVMBuildFPExt));
    entry(arg1, Val, DestTy, Name)
}
#[no_mangle]
pub extern "C" fn LLVMOrcDisposeCSymbolFlagsMap(Pairs: LLVMOrcCSymbolFlagsMapPairs) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMOrcCSymbolFlagsMapPairs),
            >(stringify!(LLVMOrcDisposeCSymbolFlagsMap).as_bytes())
    }
        .expect(stringify!(LLVMOrcDisposeCSymbolFlagsMap));
    entry(Pairs)
}
#[no_mangle]
pub extern "C" fn LLVMOrcIRTransformLayerEmit(
    IRTransformLayer: LLVMOrcIRTransformLayerRef,
    MR: LLVMOrcMaterializationResponsibilityRef,
    TSM: LLVMOrcThreadSafeModuleRef,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMOrcIRTransformLayerRef,
                    LLVMOrcMaterializationResponsibilityRef,
                    LLVMOrcThreadSafeModuleRef,
                ),
            >(stringify!(LLVMOrcIRTransformLayerEmit).as_bytes())
    }
        .expect(stringify!(LLVMOrcIRTransformLayerEmit));
    entry(IRTransformLayer, MR, TSM)
}
#[no_mangle]
pub extern "C" fn LLVMEraseGlobalIFunc(IFunc: LLVMValueRef) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef),
            >(stringify!(LLVMEraseGlobalIFunc).as_bytes())
    }
        .expect(stringify!(LLVMEraseGlobalIFunc));
    entry(IFunc)
}
#[no_mangle]
pub extern "C" fn LLVMCreateStringError(ErrMst: *const ::libc::c_char) -> LLVMErrorRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(*const ::libc::c_char) -> LLVMErrorRef,
            >(stringify!(LLVMCreateStringError).as_bytes())
    }
        .expect(stringify!(LLVMCreateStringError));
    entry(ErrMst)
}
#[no_mangle]
pub extern "C" fn LLVMInitializeNVPTXTargetMC() {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<extern "C" fn()>(stringify!(LLVMInitializeNVPTXTargetMC).as_bytes())
    }
        .expect(stringify!(LLVMInitializeNVPTXTargetMC));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMPreferredAlignmentOfGlobal(
    TD: LLVMTargetDataRef,
    GlobalVar: LLVMValueRef,
) -> ::libc::c_uint {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMTargetDataRef, LLVMValueRef) -> ::libc::c_uint,
            >(stringify!(LLVMPreferredAlignmentOfGlobal).as_bytes())
    }
        .expect(stringify!(LLVMPreferredAlignmentOfGlobal));
    entry(TD, GlobalVar)
}
#[no_mangle]
pub extern "C" fn LLVMRemoveStringAttributeAtIndex(
    F: LLVMValueRef,
    Idx: LLVMAttributeIndex,
    K: *const ::libc::c_char,
    KLen: ::libc::c_uint,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMValueRef,
                    LLVMAttributeIndex,
                    *const ::libc::c_char,
                    ::libc::c_uint,
                ),
            >(stringify!(LLVMRemoveStringAttributeAtIndex).as_bytes())
    }
        .expect(stringify!(LLVMRemoveStringAttributeAtIndex));
    entry(F, Idx, K, KLen)
}
#[no_mangle]
pub extern "C" fn LLVMGetNumOperands(Val: LLVMValueRef) -> ::libc::c_int {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> ::libc::c_int,
            >(stringify!(LLVMGetNumOperands).as_bytes())
    }
        .expect(stringify!(LLVMGetNumOperands));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn LLVMInitializeMSP430TargetMC() {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<extern "C" fn()>(stringify!(LLVMInitializeMSP430TargetMC).as_bytes())
    }
        .expect(stringify!(LLVMInitializeMSP430TargetMC));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMInitializeARMTargetMC() {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<extern "C" fn()>(stringify!(LLVMInitializeARMTargetMC).as_bytes())
    }
        .expect(stringify!(LLVMInitializeARMTargetMC));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMCreateBinary(
    MemBuf: LLVMMemoryBufferRef,
    Context: LLVMContextRef,
    ErrorMessage: *mut *mut ::libc::c_char,
) -> LLVMBinaryRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMMemoryBufferRef,
                    LLVMContextRef,
                    *mut *mut ::libc::c_char,
                ) -> LLVMBinaryRef,
            >(stringify!(LLVMCreateBinary).as_bytes())
    }
        .expect(stringify!(LLVMCreateBinary));
    entry(MemBuf, Context, ErrorMessage)
}
#[no_mangle]
pub extern "C" fn LLVMClearInsertionPosition(Builder: LLVMBuilderRef) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMBuilderRef),
            >(stringify!(LLVMClearInsertionPosition).as_bytes())
    }
        .expect(stringify!(LLVMClearInsertionPosition));
    entry(Builder)
}
#[no_mangle]
pub extern "C" fn LLVMIsAInlineAsm(Val: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMIsAInlineAsm).as_bytes())
    }
        .expect(stringify!(LLVMIsAInlineAsm));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn LLVMBuildFenceSyncScope(
    B: LLVMBuilderRef,
    ordering: LLVMAtomicOrdering,
    SSID: ::libc::c_uint,
    Name: *const ::libc::c_char,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMBuilderRef,
                    LLVMAtomicOrdering,
                    ::libc::c_uint,
                    *const ::libc::c_char,
                ) -> LLVMValueRef,
            >(stringify!(LLVMBuildFenceSyncScope).as_bytes())
    }
        .expect(stringify!(LLVMBuildFenceSyncScope));
    entry(B, ordering, SSID, Name)
}
#[no_mangle]
pub extern "C" fn LLVMIsACallBrInst(Val: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMIsACallBrInst).as_bytes())
    }
        .expect(stringify!(LLVMIsACallBrInst));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn LLVMIsASwitchInst(Val: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMIsASwitchInst).as_bytes())
    }
        .expect(stringify!(LLVMIsASwitchInst));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn LLVMIsASelectInst(Val: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMIsASelectInst).as_bytes())
    }
        .expect(stringify!(LLVMIsASelectInst));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn LLVMIsAtomic(Inst: LLVMValueRef) -> LLVMBool {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMBool,
            >(stringify!(LLVMIsAtomic).as_bytes())
    }
        .expect(stringify!(LLVMIsAtomic));
    entry(Inst)
}
#[no_mangle]
pub extern "C" fn LLVMCreateGenericValueOfFloat(
    Ty: LLVMTypeRef,
    N: ::libc::c_double,
) -> LLVMGenericValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMTypeRef, ::libc::c_double) -> LLVMGenericValueRef,
            >(stringify!(LLVMCreateGenericValueOfFloat).as_bytes())
    }
        .expect(stringify!(LLVMCreateGenericValueOfFloat));
    entry(Ty, N)
}
#[no_mangle]
pub extern "C" fn LLVMGetTargetMachineCPU(
    T: LLVMTargetMachineRef,
) -> *mut ::libc::c_char {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMTargetMachineRef) -> *mut ::libc::c_char,
            >(stringify!(LLVMGetTargetMachineCPU).as_bytes())
    }
        .expect(stringify!(LLVMGetTargetMachineCPU));
    entry(T)
}
#[no_mangle]
pub extern "C" fn LLVMDisposeMessage(Message: *mut ::libc::c_char) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(*mut ::libc::c_char),
            >(stringify!(LLVMDisposeMessage).as_bytes())
    }
        .expect(stringify!(LLVMDisposeMessage));
    entry(Message)
}
#[no_mangle]
pub extern "C" fn LLVMCountParams(Fn: LLVMValueRef) -> ::libc::c_uint {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> ::libc::c_uint,
            >(stringify!(LLVMCountParams).as_bytes())
    }
        .expect(stringify!(LLVMCountParams));
    entry(Fn)
}
#[no_mangle]
pub extern "C" fn LLVMConstPointerNull(Ty: LLVMTypeRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMTypeRef) -> LLVMValueRef,
            >(stringify!(LLVMConstPointerNull).as_bytes())
    }
        .expect(stringify!(LLVMConstPointerNull));
    entry(Ty)
}
#[no_mangle]
pub extern "C" fn LLVMCreateMemoryBufferWithSTDIN(
    OutMemBuf: *mut LLVMMemoryBufferRef,
    OutMessage: *mut *mut ::libc::c_char,
) -> LLVMBool {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    *mut LLVMMemoryBufferRef,
                    *mut *mut ::libc::c_char,
                ) -> LLVMBool,
            >(stringify!(LLVMCreateMemoryBufferWithSTDIN).as_bytes())
    }
        .expect(stringify!(LLVMCreateMemoryBufferWithSTDIN));
    entry(OutMemBuf, OutMessage)
}
#[no_mangle]
pub extern "C" fn LLVMCreateSimpleMCJITMemoryManager(
    Opaque: *mut ::libc::c_void,
    AllocateCodeSection: LLVMMemoryManagerAllocateCodeSectionCallback,
    AllocateDataSection: LLVMMemoryManagerAllocateDataSectionCallback,
    FinalizeMemory: LLVMMemoryManagerFinalizeMemoryCallback,
    Destroy: LLVMMemoryManagerDestroyCallback,
) -> LLVMMCJITMemoryManagerRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    *mut ::libc::c_void,
                    LLVMMemoryManagerAllocateCodeSectionCallback,
                    LLVMMemoryManagerAllocateDataSectionCallback,
                    LLVMMemoryManagerFinalizeMemoryCallback,
                    LLVMMemoryManagerDestroyCallback,
                ) -> LLVMMCJITMemoryManagerRef,
            >(stringify!(LLVMCreateSimpleMCJITMemoryManager).as_bytes())
    }
        .expect(stringify!(LLVMCreateSimpleMCJITMemoryManager));
    entry(Opaque, AllocateCodeSection, AllocateDataSection, FinalizeMemory, Destroy)
}
#[no_mangle]
pub extern "C" fn LLVMDIVariableGetScope(Var: LLVMMetadataRef) -> LLVMMetadataRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMMetadataRef) -> LLVMMetadataRef,
            >(stringify!(LLVMDIVariableGetScope).as_bytes())
    }
        .expect(stringify!(LLVMDIVariableGetScope));
    entry(Var)
}
#[no_mangle]
pub extern "C" fn lto_module_has_ctor_dtor(mod_: lto_module_t) -> lto_bool_t {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(lto_module_t) -> lto_bool_t,
            >(stringify!(lto_module_has_ctor_dtor).as_bytes())
    }
        .expect(stringify!(lto_module_has_ctor_dtor));
    entry(mod_)
}
#[no_mangle]
pub extern "C" fn LLVMInitializeXCoreTargetMC() {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<extern "C" fn()>(stringify!(LLVMInitializeXCoreTargetMC).as_bytes())
    }
        .expect(stringify!(LLVMInitializeXCoreTargetMC));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMInstructionGetAllMetadataOtherThanDebugLoc(
    Instr: LLVMValueRef,
    NumEntries: *mut ::libc::size_t,
) -> *mut LLVMValueMetadataEntry {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMValueRef,
                    *mut ::libc::size_t,
                ) -> *mut LLVMValueMetadataEntry,
            >(stringify!(LLVMInstructionGetAllMetadataOtherThanDebugLoc).as_bytes())
    }
        .expect(stringify!(LLVMInstructionGetAllMetadataOtherThanDebugLoc));
    entry(Instr, NumEntries)
}
#[no_mangle]
pub extern "C" fn llvm_blake3_hasher_init(hasher: *mut llvm_blake3_hasher) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(*mut llvm_blake3_hasher),
            >(stringify!(llvm_blake3_hasher_init).as_bytes())
    }
        .expect(stringify!(llvm_blake3_hasher_init));
    entry(hasher)
}
#[no_mangle]
pub extern "C" fn LLVMInt16Type() -> LLVMTypeRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<extern "C" fn() -> LLVMTypeRef>(stringify!(LLVMInt16Type).as_bytes())
    }
        .expect(stringify!(LLVMInt16Type));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMGetUser(U: LLVMUseRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMUseRef) -> LLVMValueRef,
            >(stringify!(LLVMGetUser).as_bytes())
    }
        .expect(stringify!(LLVMGetUser));
    entry(U)
}
#[no_mangle]
pub extern "C" fn LLVMCanValueUseFastMathFlags(Inst: LLVMValueRef) -> LLVMBool {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMBool,
            >(stringify!(LLVMCanValueUseFastMathFlags).as_bytes())
    }
        .expect(stringify!(LLVMCanValueUseFastMathFlags));
    entry(Inst)
}
#[no_mangle]
pub extern "C" fn LLVMGetSourceFileName(
    M: LLVMModuleRef,
    Len: *mut ::libc::size_t,
) -> *const ::libc::c_char {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMModuleRef,
                    *mut ::libc::size_t,
                ) -> *const ::libc::c_char,
            >(stringify!(LLVMGetSourceFileName).as_bytes())
    }
        .expect(stringify!(LLVMGetSourceFileName));
    entry(M, Len)
}
#[no_mangle]
pub extern "C" fn LLVMBuildResume(B: LLVMBuilderRef, Exn: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMBuilderRef, LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMBuildResume).as_bytes())
    }
        .expect(stringify!(LLVMBuildResume));
    entry(B, Exn)
}
#[no_mangle]
pub extern "C" fn LLVMBuildBitCast(
    arg1: LLVMBuilderRef,
    Val: LLVMValueRef,
    DestTy: LLVMTypeRef,
    Name: *const ::libc::c_char,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMBuilderRef,
                    LLVMValueRef,
                    LLVMTypeRef,
                    *const ::libc::c_char,
                ) -> LLVMValueRef,
            >(stringify!(LLVMBuildBitCast).as_bytes())
    }
        .expect(stringify!(LLVMBuildBitCast));
    entry(arg1, Val, DestTy, Name)
}
#[no_mangle]
pub extern "C" fn LLVMGetLastGlobal(M: LLVMModuleRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMModuleRef) -> LLVMValueRef,
            >(stringify!(LLVMGetLastGlobal).as_bytes())
    }
        .expect(stringify!(LLVMGetLastGlobal));
    entry(M)
}
#[no_mangle]
pub extern "C" fn LLVMMetadataReplaceAllUsesWith(
    TempTargetMetadata: LLVMMetadataRef,
    Replacement: LLVMMetadataRef,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMMetadataRef, LLVMMetadataRef),
            >(stringify!(LLVMMetadataReplaceAllUsesWith).as_bytes())
    }
        .expect(stringify!(LLVMMetadataReplaceAllUsesWith));
    entry(TempTargetMetadata, Replacement)
}
#[no_mangle]
pub extern "C" fn LLVMConstRealOfStringAndSize(
    RealTy: LLVMTypeRef,
    Text: *const ::libc::c_char,
    SLen: ::libc::c_uint,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMTypeRef,
                    *const ::libc::c_char,
                    ::libc::c_uint,
                ) -> LLVMValueRef,
            >(stringify!(LLVMConstRealOfStringAndSize).as_bytes())
    }
        .expect(stringify!(LLVMConstRealOfStringAndSize));
    entry(RealTy, Text, SLen)
}
#[no_mangle]
pub extern "C" fn LLVMSetGlobalIFuncResolver(
    IFunc: LLVMValueRef,
    Resolver: LLVMValueRef,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, LLVMValueRef),
            >(stringify!(LLVMSetGlobalIFuncResolver).as_bytes())
    }
        .expect(stringify!(LLVMSetGlobalIFuncResolver));
    entry(IFunc, Resolver)
}
#[no_mangle]
pub extern "C" fn LLVMAddModule(EE: LLVMExecutionEngineRef, M: LLVMModuleRef) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMExecutionEngineRef, LLVMModuleRef),
            >(stringify!(LLVMAddModule).as_bytes())
    }
        .expect(stringify!(LLVMAddModule));
    entry(EE, M)
}
#[no_mangle]
pub extern "C" fn LLVMDoubleTypeInContext(C: LLVMContextRef) -> LLVMTypeRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMContextRef) -> LLVMTypeRef,
            >(stringify!(LLVMDoubleTypeInContext).as_bytes())
    }
        .expect(stringify!(LLVMDoubleTypeInContext));
    entry(C)
}
#[no_mangle]
pub extern "C" fn LLVMIsACleanupPadInst(Val: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMIsACleanupPadInst).as_bytes())
    }
        .expect(stringify!(LLVMIsACleanupPadInst));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn LLVMOrcCreateDynamicLibrarySearchGeneratorForPath(
    Result: *mut LLVMOrcDefinitionGeneratorRef,
    FileName: *const ::libc::c_char,
    GlobalPrefix: ::libc::c_char,
    Filter: LLVMOrcSymbolPredicate,
    FilterCtx: *mut ::libc::c_void,
) -> LLVMErrorRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    *mut LLVMOrcDefinitionGeneratorRef,
                    *const ::libc::c_char,
                    ::libc::c_char,
                    LLVMOrcSymbolPredicate,
                    *mut ::libc::c_void,
                ) -> LLVMErrorRef,
            >(stringify!(LLVMOrcCreateDynamicLibrarySearchGeneratorForPath).as_bytes())
    }
        .expect(stringify!(LLVMOrcCreateDynamicLibrarySearchGeneratorForPath));
    entry(Result, FileName, GlobalPrefix, Filter, FilterCtx)
}
#[no_mangle]
pub extern "C" fn LLVMBuildExactUDiv(
    arg1: LLVMBuilderRef,
    LHS: LLVMValueRef,
    RHS: LLVMValueRef,
    Name: *const ::libc::c_char,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMBuilderRef,
                    LLVMValueRef,
                    LLVMValueRef,
                    *const ::libc::c_char,
                ) -> LLVMValueRef,
            >(stringify!(LLVMBuildExactUDiv).as_bytes())
    }
        .expect(stringify!(LLVMBuildExactUDiv));
    entry(arg1, LHS, RHS, Name)
}
#[no_mangle]
pub extern "C" fn LLVMGetLastFunction(M: LLVMModuleRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMModuleRef) -> LLVMValueRef,
            >(stringify!(LLVMGetLastFunction).as_bytes())
    }
        .expect(stringify!(LLVMGetLastFunction));
    entry(M)
}
#[no_mangle]
pub extern "C" fn LLVMGetPointerToGlobal(
    EE: LLVMExecutionEngineRef,
    Global: LLVMValueRef,
) -> *mut ::libc::c_void {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMExecutionEngineRef,
                    LLVMValueRef,
                ) -> *mut ::libc::c_void,
            >(stringify!(LLVMGetPointerToGlobal).as_bytes())
    }
        .expect(stringify!(LLVMGetPointerToGlobal));
    entry(EE, Global)
}
#[no_mangle]
pub extern "C" fn LLVMTargetMachineOptionsSetCodeModel(
    Options: LLVMTargetMachineOptionsRef,
    CodeModel: LLVMCodeModel,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMTargetMachineOptionsRef, LLVMCodeModel),
            >(stringify!(LLVMTargetMachineOptionsSetCodeModel).as_bytes())
    }
        .expect(stringify!(LLVMTargetMachineOptionsSetCodeModel));
    entry(Options, CodeModel)
}
#[no_mangle]
pub extern "C" fn LLVMInitializeSparcTargetMC() {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<extern "C" fn()>(stringify!(LLVMInitializeSparcTargetMC).as_bytes())
    }
        .expect(stringify!(LLVMInitializeSparcTargetMC));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMDIBuilderCreateGlobalVariableExpression(
    Builder: LLVMDIBuilderRef,
    Scope: LLVMMetadataRef,
    Name: *const ::libc::c_char,
    NameLen: ::libc::size_t,
    Linkage: *const ::libc::c_char,
    LinkLen: ::libc::size_t,
    File: LLVMMetadataRef,
    LineNo: ::libc::c_uint,
    Ty: LLVMMetadataRef,
    LocalToUnit: LLVMBool,
    Expr: LLVMMetadataRef,
    Decl: LLVMMetadataRef,
    AlignInBits: u32,
) -> LLVMMetadataRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMDIBuilderRef,
                    LLVMMetadataRef,
                    *const ::libc::c_char,
                    ::libc::size_t,
                    *const ::libc::c_char,
                    ::libc::size_t,
                    LLVMMetadataRef,
                    ::libc::c_uint,
                    LLVMMetadataRef,
                    LLVMBool,
                    LLVMMetadataRef,
                    LLVMMetadataRef,
                    u32,
                ) -> LLVMMetadataRef,
            >(stringify!(LLVMDIBuilderCreateGlobalVariableExpression).as_bytes())
    }
        .expect(stringify!(LLVMDIBuilderCreateGlobalVariableExpression));
    entry(
        Builder,
        Scope,
        Name,
        NameLen,
        Linkage,
        LinkLen,
        File,
        LineNo,
        Ty,
        LocalToUnit,
        Expr,
        Decl,
        AlignInBits,
    )
}
#[no_mangle]
pub extern "C" fn LLVMInitializeX86AsmPrinter() {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<extern "C" fn()>(stringify!(LLVMInitializeX86AsmPrinter).as_bytes())
    }
        .expect(stringify!(LLVMInitializeX86AsmPrinter));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMDIBuilderCreateBasicType(
    Builder: LLVMDIBuilderRef,
    Name: *const ::libc::c_char,
    NameLen: ::libc::size_t,
    SizeInBits: u64,
    Encoding: LLVMDWARFTypeEncoding,
    Flags: LLVMDIFlags,
) -> LLVMMetadataRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMDIBuilderRef,
                    *const ::libc::c_char,
                    ::libc::size_t,
                    u64,
                    LLVMDWARFTypeEncoding,
                    LLVMDIFlags,
                ) -> LLVMMetadataRef,
            >(stringify!(LLVMDIBuilderCreateBasicType).as_bytes())
    }
        .expect(stringify!(LLVMDIBuilderCreateBasicType));
    entry(Builder, Name, NameLen, SizeInBits, Encoding, Flags)
}
#[no_mangle]
pub extern "C" fn LLVMBuildLandingPad(
    B: LLVMBuilderRef,
    Ty: LLVMTypeRef,
    PersFn: LLVMValueRef,
    NumClauses: ::libc::c_uint,
    Name: *const ::libc::c_char,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMBuilderRef,
                    LLVMTypeRef,
                    LLVMValueRef,
                    ::libc::c_uint,
                    *const ::libc::c_char,
                ) -> LLVMValueRef,
            >(stringify!(LLVMBuildLandingPad).as_bytes())
    }
        .expect(stringify!(LLVMBuildLandingPad));
    entry(B, Ty, PersFn, NumClauses, Name)
}
#[no_mangle]
pub extern "C" fn LLVMOrcLookupStateContinueLookup(
    S: LLVMOrcLookupStateRef,
    Error: LLVMErrorRef,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMOrcLookupStateRef, LLVMErrorRef),
            >(stringify!(LLVMOrcLookupStateContinueLookup).as_bytes())
    }
        .expect(stringify!(LLVMOrcLookupStateContinueLookup));
    entry(S, Error)
}
#[no_mangle]
pub extern "C" fn LLVMGetHostCPUFeatures() -> *mut ::libc::c_char {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn() -> *mut ::libc::c_char,
            >(stringify!(LLVMGetHostCPUFeatures).as_bytes())
    }
        .expect(stringify!(LLVMGetHostCPUFeatures));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMSetDisasmOptions(
    DC: LLVMDisasmContextRef,
    Options: u64,
) -> ::libc::c_int {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMDisasmContextRef, u64) -> ::libc::c_int,
            >(stringify!(LLVMSetDisasmOptions).as_bytes())
    }
        .expect(stringify!(LLVMSetDisasmOptions));
    entry(DC, Options)
}
#[no_mangle]
pub extern "C" fn LLVMOrcResourceTrackerTransferTo(
    SrcRT: LLVMOrcResourceTrackerRef,
    DstRT: LLVMOrcResourceTrackerRef,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMOrcResourceTrackerRef, LLVMOrcResourceTrackerRef),
            >(stringify!(LLVMOrcResourceTrackerTransferTo).as_bytes())
    }
        .expect(stringify!(LLVMOrcResourceTrackerTransferTo));
    entry(SrcRT, DstRT)
}
#[no_mangle]
pub extern "C" fn LLVMSizeOf(Ty: LLVMTypeRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMTypeRef) -> LLVMValueRef,
            >(stringify!(LLVMSizeOf).as_bytes())
    }
        .expect(stringify!(LLVMSizeOf));
    entry(Ty)
}
#[no_mangle]
pub extern "C" fn LLVMOrcJITTargetMachineBuilderCreateFromTargetMachine(
    TM: LLVMTargetMachineRef,
) -> LLVMOrcJITTargetMachineBuilderRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMTargetMachineRef) -> LLVMOrcJITTargetMachineBuilderRef,
            >(
                stringify!(LLVMOrcJITTargetMachineBuilderCreateFromTargetMachine)
                    .as_bytes(),
            )
    }
        .expect(stringify!(LLVMOrcJITTargetMachineBuilderCreateFromTargetMachine));
    entry(TM)
}
#[no_mangle]
pub extern "C" fn LLVMIsGlobalConstant(GlobalVar: LLVMValueRef) -> LLVMBool {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMBool,
            >(stringify!(LLVMIsGlobalConstant).as_bytes())
    }
        .expect(stringify!(LLVMIsGlobalConstant));
    entry(GlobalVar)
}
#[no_mangle]
pub extern "C" fn LLVMDIBuilderGetOrCreateSubrange(
    Builder: LLVMDIBuilderRef,
    LowerBound: i64,
    Count: i64,
) -> LLVMMetadataRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMDIBuilderRef, i64, i64) -> LLVMMetadataRef,
            >(stringify!(LLVMDIBuilderGetOrCreateSubrange).as_bytes())
    }
        .expect(stringify!(LLVMDIBuilderGetOrCreateSubrange));
    entry(Builder, LowerBound, Count)
}
#[no_mangle]
pub extern "C" fn LLVMCreateTargetMachineWithOptions(
    T: LLVMTargetRef,
    Triple: *const ::libc::c_char,
    Options: LLVMTargetMachineOptionsRef,
) -> LLVMTargetMachineRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMTargetRef,
                    *const ::libc::c_char,
                    LLVMTargetMachineOptionsRef,
                ) -> LLVMTargetMachineRef,
            >(stringify!(LLVMCreateTargetMachineWithOptions).as_bytes())
    }
        .expect(stringify!(LLVMCreateTargetMachineWithOptions));
    entry(T, Triple, Options)
}
#[no_mangle]
pub extern "C" fn LLVMRunStaticDestructors(EE: LLVMExecutionEngineRef) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMExecutionEngineRef),
            >(stringify!(LLVMRunStaticDestructors).as_bytes())
    }
        .expect(stringify!(LLVMRunStaticDestructors));
    entry(EE)
}
#[no_mangle]
pub extern "C" fn LLVMConstBitCast(
    ConstantVal: LLVMValueRef,
    ToType: LLVMTypeRef,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, LLVMTypeRef) -> LLVMValueRef,
            >(stringify!(LLVMConstBitCast).as_bytes())
    }
        .expect(stringify!(LLVMConstBitCast));
    entry(ConstantVal, ToType)
}
#[no_mangle]
pub extern "C" fn LLVMGetLastParam(Fn: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMGetLastParam).as_bytes())
    }
        .expect(stringify!(LLVMGetLastParam));
    entry(Fn)
}
#[no_mangle]
pub extern "C" fn LLVMMDNodeInContext2(
    C: LLVMContextRef,
    MDs: *mut LLVMMetadataRef,
    Count: ::libc::size_t,
) -> LLVMMetadataRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMContextRef,
                    *mut LLVMMetadataRef,
                    ::libc::size_t,
                ) -> LLVMMetadataRef,
            >(stringify!(LLVMMDNodeInContext2).as_bytes())
    }
        .expect(stringify!(LLVMMDNodeInContext2));
    entry(C, MDs, Count)
}
#[no_mangle]
pub extern "C" fn LLVMFP128Type() -> LLVMTypeRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<extern "C" fn() -> LLVMTypeRef>(stringify!(LLVMFP128Type).as_bytes())
    }
        .expect(stringify!(LLVMFP128Type));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMSetPrefixData(Fn: LLVMValueRef, prefixData: LLVMValueRef) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, LLVMValueRef),
            >(stringify!(LLVMSetPrefixData).as_bytes())
    }
        .expect(stringify!(LLVMSetPrefixData));
    entry(Fn, prefixData)
}
#[no_mangle]
pub extern "C" fn LLVMSetAtomicSingleThread(
    AtomicInst: LLVMValueRef,
    SingleThread: LLVMBool,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, LLVMBool),
            >(stringify!(LLVMSetAtomicSingleThread).as_bytes())
    }
        .expect(stringify!(LLVMSetAtomicSingleThread));
    entry(AtomicInst, SingleThread)
}
#[no_mangle]
pub extern "C" fn LLVMGetFirstFunction(M: LLVMModuleRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMModuleRef) -> LLVMValueRef,
            >(stringify!(LLVMGetFirstFunction).as_bytes())
    }
        .expect(stringify!(LLVMGetFirstFunction));
    entry(M)
}
#[no_mangle]
pub extern "C" fn LLVMGetCalledFunctionType(C: LLVMValueRef) -> LLVMTypeRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMTypeRef,
            >(stringify!(LLVMGetCalledFunctionType).as_bytes())
    }
        .expect(stringify!(LLVMGetCalledFunctionType));
    entry(C)
}
#[no_mangle]
pub extern "C" fn LLVMBuildAggregateRet(
    arg1: LLVMBuilderRef,
    RetVals: *mut LLVMValueRef,
    N: ::libc::c_uint,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMBuilderRef,
                    *mut LLVMValueRef,
                    ::libc::c_uint,
                ) -> LLVMValueRef,
            >(stringify!(LLVMBuildAggregateRet).as_bytes())
    }
        .expect(stringify!(LLVMBuildAggregateRet));
    entry(arg1, RetVals, N)
}
#[no_mangle]
pub extern "C" fn LLVMGetThreadLocalMode(
    GlobalVar: LLVMValueRef,
) -> LLVMThreadLocalMode {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMThreadLocalMode,
            >(stringify!(LLVMGetThreadLocalMode).as_bytes())
    }
        .expect(stringify!(LLVMGetThreadLocalMode));
    entry(GlobalVar)
}
#[no_mangle]
pub extern "C" fn LLVMX86FP80TypeInContext(C: LLVMContextRef) -> LLVMTypeRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMContextRef) -> LLVMTypeRef,
            >(stringify!(LLVMX86FP80TypeInContext).as_bytes())
    }
        .expect(stringify!(LLVMX86FP80TypeInContext));
    entry(C)
}
#[no_mangle]
pub extern "C" fn lto_get_error_message() -> *const ::libc::c_char {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn() -> *const ::libc::c_char,
            >(stringify!(lto_get_error_message).as_bytes())
    }
        .expect(stringify!(lto_get_error_message));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMBuildShuffleVector(
    arg1: LLVMBuilderRef,
    V1: LLVMValueRef,
    V2: LLVMValueRef,
    Mask: LLVMValueRef,
    Name: *const ::libc::c_char,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMBuilderRef,
                    LLVMValueRef,
                    LLVMValueRef,
                    LLVMValueRef,
                    *const ::libc::c_char,
                ) -> LLVMValueRef,
            >(stringify!(LLVMBuildShuffleVector).as_bytes())
    }
        .expect(stringify!(LLVMBuildShuffleVector));
    entry(arg1, V1, V2, Mask, Name)
}
#[no_mangle]
pub extern "C" fn LLVMInitializeSparcAsmParser() {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<extern "C" fn()>(stringify!(LLVMInitializeSparcAsmParser).as_bytes())
    }
        .expect(stringify!(LLVMInitializeSparcAsmParser));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMGetPreviousInstruction(Inst: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMGetPreviousInstruction).as_bytes())
    }
        .expect(stringify!(LLVMGetPreviousInstruction));
    entry(Inst)
}
#[no_mangle]
pub extern "C" fn lto_module_get_num_asm_undef_symbols(
    mod_: lto_module_t,
) -> ::libc::c_uint {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(lto_module_t) -> ::libc::c_uint,
            >(stringify!(lto_module_get_num_asm_undef_symbols).as_bytes())
    }
        .expect(stringify!(lto_module_get_num_asm_undef_symbols));
    entry(mod_)
}
#[no_mangle]
pub extern "C" fn LLVMInitializeX86Target() {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<extern "C" fn()>(stringify!(LLVMInitializeX86Target).as_bytes())
    }
        .expect(stringify!(LLVMInitializeX86Target));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMMDStringInContext(
    C: LLVMContextRef,
    Str: *const ::libc::c_char,
    SLen: ::libc::c_uint,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMContextRef,
                    *const ::libc::c_char,
                    ::libc::c_uint,
                ) -> LLVMValueRef,
            >(stringify!(LLVMMDStringInContext).as_bytes())
    }
        .expect(stringify!(LLVMMDStringInContext));
    entry(C, Str, SLen)
}
#[no_mangle]
pub extern "C" fn LLVMSetMetadata(
    Val: LLVMValueRef,
    KindID: ::libc::c_uint,
    Node: LLVMValueRef,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, ::libc::c_uint, LLVMValueRef),
            >(stringify!(LLVMSetMetadata).as_bytes())
    }
        .expect(stringify!(LLVMSetMetadata));
    entry(Val, KindID, Node)
}
#[no_mangle]
pub extern "C" fn LLVMIsAConstantPtrAuth(Val: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMIsAConstantPtrAuth).as_bytes())
    }
        .expect(stringify!(LLVMIsAConstantPtrAuth));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn LLVMDebugMetadataVersion() -> ::libc::c_uint {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn() -> ::libc::c_uint,
            >(stringify!(LLVMDebugMetadataVersion).as_bytes())
    }
        .expect(stringify!(LLVMDebugMetadataVersion));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMInitializeMipsTarget() {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<extern "C" fn()>(stringify!(LLVMInitializeMipsTarget).as_bytes())
    }
        .expect(stringify!(LLVMInitializeMipsTarget));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMConstRealOfString(
    RealTy: LLVMTypeRef,
    Text: *const ::libc::c_char,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMTypeRef, *const ::libc::c_char) -> LLVMValueRef,
            >(stringify!(LLVMConstRealOfString).as_bytes())
    }
        .expect(stringify!(LLVMConstRealOfString));
    entry(RealTy, Text)
}
#[no_mangle]
pub extern "C" fn LLVMCreateConstantRangeAttribute(
    C: LLVMContextRef,
    KindID: ::libc::c_uint,
    NumBits: ::libc::c_uint,
    LowerWords: *const u64,
    UpperWords: *const u64,
) -> LLVMAttributeRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMContextRef,
                    ::libc::c_uint,
                    ::libc::c_uint,
                    *const u64,
                    *const u64,
                ) -> LLVMAttributeRef,
            >(stringify!(LLVMCreateConstantRangeAttribute).as_bytes())
    }
        .expect(stringify!(LLVMCreateConstantRangeAttribute));
    entry(C, KindID, NumBits, LowerWords, UpperWords)
}
#[no_mangle]
pub extern "C" fn LLVMSetExternallyInitialized(
    GlobalVar: LLVMValueRef,
    IsExtInit: LLVMBool,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, LLVMBool),
            >(stringify!(LLVMSetExternallyInitialized).as_bytes())
    }
        .expect(stringify!(LLVMSetExternallyInitialized));
    entry(GlobalVar, IsExtInit)
}
#[no_mangle]
pub extern "C" fn LLVMFreeMachineCodeForFunction(
    EE: LLVMExecutionEngineRef,
    F: LLVMValueRef,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMExecutionEngineRef, LLVMValueRef),
            >(stringify!(LLVMFreeMachineCodeForFunction).as_bytes())
    }
        .expect(stringify!(LLVMFreeMachineCodeForFunction));
    entry(EE, F)
}
#[no_mangle]
pub extern "C" fn lto_module_is_object_file_for_target(
    path: *const ::libc::c_char,
    target_triple_prefix: *const ::libc::c_char,
) -> lto_bool_t {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(*const ::libc::c_char, *const ::libc::c_char) -> lto_bool_t,
            >(stringify!(lto_module_is_object_file_for_target).as_bytes())
    }
        .expect(stringify!(lto_module_is_object_file_for_target));
    entry(path, target_triple_prefix)
}
#[no_mangle]
pub extern "C" fn LLVMDIBuilderCreateImportedDeclaration(
    Builder: LLVMDIBuilderRef,
    Scope: LLVMMetadataRef,
    Decl: LLVMMetadataRef,
    File: LLVMMetadataRef,
    Line: ::libc::c_uint,
    Name: *const ::libc::c_char,
    NameLen: ::libc::size_t,
    Elements: *mut LLVMMetadataRef,
    NumElements: ::libc::c_uint,
) -> LLVMMetadataRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMDIBuilderRef,
                    LLVMMetadataRef,
                    LLVMMetadataRef,
                    LLVMMetadataRef,
                    ::libc::c_uint,
                    *const ::libc::c_char,
                    ::libc::size_t,
                    *mut LLVMMetadataRef,
                    ::libc::c_uint,
                ) -> LLVMMetadataRef,
            >(stringify!(LLVMDIBuilderCreateImportedDeclaration).as_bytes())
    }
        .expect(stringify!(LLVMDIBuilderCreateImportedDeclaration));
    entry(Builder, Scope, Decl, File, Line, Name, NameLen, Elements, NumElements)
}
#[no_mangle]
pub extern "C" fn LLVMDisasmInstruction(
    DC: LLVMDisasmContextRef,
    Bytes: *mut u8,
    BytesSize: u64,
    PC: u64,
    OutString: *mut ::libc::c_char,
    OutStringSize: ::libc::size_t,
) -> ::libc::size_t {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMDisasmContextRef,
                    *mut u8,
                    u64,
                    u64,
                    *mut ::libc::c_char,
                    ::libc::size_t,
                ) -> ::libc::size_t,
            >(stringify!(LLVMDisasmInstruction).as_bytes())
    }
        .expect(stringify!(LLVMDisasmInstruction));
    entry(DC, Bytes, BytesSize, PC, OutString, OutStringSize)
}
#[no_mangle]
pub extern "C" fn LLVMConstShuffleVector(
    VectorAConstant: LLVMValueRef,
    VectorBConstant: LLVMValueRef,
    MaskConstant: LLVMValueRef,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, LLVMValueRef, LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMConstShuffleVector).as_bytes())
    }
        .expect(stringify!(LLVMConstShuffleVector));
    entry(VectorAConstant, VectorBConstant, MaskConstant)
}
#[no_mangle]
pub extern "C" fn lto_module_is_object_file_in_memory(
    mem: *const ::libc::c_void,
    length: ::libc::size_t,
) -> lto_bool_t {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(*const ::libc::c_void, ::libc::size_t) -> lto_bool_t,
            >(stringify!(lto_module_is_object_file_in_memory).as_bytes())
    }
        .expect(stringify!(lto_module_is_object_file_in_memory));
    entry(mem, length)
}
#[no_mangle]
pub extern "C" fn lto_module_set_target_triple(
    _mod: lto_module_t,
    triple: *const ::libc::c_char,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(lto_module_t, *const ::libc::c_char),
            >(stringify!(lto_module_set_target_triple).as_bytes())
    }
        .expect(stringify!(lto_module_set_target_triple));
    entry(_mod, triple)
}
#[no_mangle]
pub extern "C" fn LLVMGetComdatSelectionKind(
    C: LLVMComdatRef,
) -> LLVMComdatSelectionKind {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMComdatRef) -> LLVMComdatSelectionKind,
            >(stringify!(LLVMGetComdatSelectionKind).as_bytes())
    }
        .expect(stringify!(LLVMGetComdatSelectionKind));
    entry(C)
}
#[no_mangle]
pub extern "C" fn thinlto_codegen_add_cross_referenced_symbol(
    cg: thinlto_code_gen_t,
    name: *const ::libc::c_char,
    length: ::libc::c_int,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(thinlto_code_gen_t, *const ::libc::c_char, ::libc::c_int),
            >(stringify!(thinlto_codegen_add_cross_referenced_symbol).as_bytes())
    }
        .expect(stringify!(thinlto_codegen_add_cross_referenced_symbol));
    entry(cg, name, length)
}
#[no_mangle]
pub extern "C" fn LLVMInt1Type() -> LLVMTypeRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<extern "C" fn() -> LLVMTypeRef>(stringify!(LLVMInt1Type).as_bytes())
    }
        .expect(stringify!(LLVMInt1Type));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMConstIntOfStringAndSize(
    IntTy: LLVMTypeRef,
    Text: *const ::libc::c_char,
    SLen: ::libc::c_uint,
    Radix: u8,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMTypeRef,
                    *const ::libc::c_char,
                    ::libc::c_uint,
                    u8,
                ) -> LLVMValueRef,
            >(stringify!(LLVMConstIntOfStringAndSize).as_bytes())
    }
        .expect(stringify!(LLVMConstIntOfStringAndSize));
    entry(IntTy, Text, SLen, Radix)
}
#[no_mangle]
pub extern "C" fn LLVMTargetMachineOptionsSetCodeGenOptLevel(
    Options: LLVMTargetMachineOptionsRef,
    Level: LLVMCodeGenOptLevel,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMTargetMachineOptionsRef, LLVMCodeGenOptLevel),
            >(stringify!(LLVMTargetMachineOptionsSetCodeGenOptLevel).as_bytes())
    }
        .expect(stringify!(LLVMTargetMachineOptionsSetCodeGenOptLevel));
    entry(Options, Level)
}
#[no_mangle]
pub extern "C" fn LLVMVectorType(
    ElementType: LLVMTypeRef,
    ElementCount: ::libc::c_uint,
) -> LLVMTypeRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMTypeRef, ::libc::c_uint) -> LLVMTypeRef,
            >(stringify!(LLVMVectorType).as_bytes())
    }
        .expect(stringify!(LLVMVectorType));
    entry(ElementType, ElementCount)
}
#[no_mangle]
pub extern "C" fn LLVMInt8Type() -> LLVMTypeRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<extern "C" fn() -> LLVMTypeRef>(stringify!(LLVMInt8Type).as_bytes())
    }
        .expect(stringify!(LLVMInt8Type));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMOrcLLJITLookup(
    J: LLVMOrcLLJITRef,
    Result: *mut LLVMOrcExecutorAddress,
    Name: *const ::libc::c_char,
) -> LLVMErrorRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMOrcLLJITRef,
                    *mut LLVMOrcExecutorAddress,
                    *const ::libc::c_char,
                ) -> LLVMErrorRef,
            >(stringify!(LLVMOrcLLJITLookup).as_bytes())
    }
        .expect(stringify!(LLVMOrcLLJITLookup));
    entry(J, Result, Name)
}
#[no_mangle]
pub extern "C" fn LLVMGetCmpXchgFailureOrdering(
    CmpXchgInst: LLVMValueRef,
) -> LLVMAtomicOrdering {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMAtomicOrdering,
            >(stringify!(LLVMGetCmpXchgFailureOrdering).as_bytes())
    }
        .expect(stringify!(LLVMGetCmpXchgFailureOrdering));
    entry(CmpXchgInst)
}
#[no_mangle]
pub extern "C" fn LLVMInitializePowerPCTarget() {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<extern "C" fn()>(stringify!(LLVMInitializePowerPCTarget).as_bytes())
    }
        .expect(stringify!(LLVMInitializePowerPCTarget));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMInitializeLanaiTargetInfo() {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<extern "C" fn()>(stringify!(LLVMInitializeLanaiTargetInfo).as_bytes())
    }
        .expect(stringify!(LLVMInitializeLanaiTargetInfo));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMInitializeAArch64TargetInfo() {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(),
            >(stringify!(LLVMInitializeAArch64TargetInfo).as_bytes())
    }
        .expect(stringify!(LLVMInitializeAArch64TargetInfo));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMMDString(
    Str: *const ::libc::c_char,
    SLen: ::libc::c_uint,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(*const ::libc::c_char, ::libc::c_uint) -> LLVMValueRef,
            >(stringify!(LLVMMDString).as_bytes())
    }
        .expect(stringify!(LLVMMDString));
    entry(Str, SLen)
}
#[no_mangle]
pub extern "C" fn LLVMGetUndef(Ty: LLVMTypeRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMTypeRef) -> LLVMValueRef,
            >(stringify!(LLVMGetUndef).as_bytes())
    }
        .expect(stringify!(LLVMGetUndef));
    entry(Ty)
}
#[no_mangle]
pub extern "C" fn LLVMGetTargetName(T: LLVMTargetRef) -> *const ::libc::c_char {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMTargetRef) -> *const ::libc::c_char,
            >(stringify!(LLVMGetTargetName).as_bytes())
    }
        .expect(stringify!(LLVMGetTargetName));
    entry(T)
}
#[no_mangle]
pub extern "C" fn LLVMInitializeAMDGPUAsmParser() {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<extern "C" fn()>(stringify!(LLVMInitializeAMDGPUAsmParser).as_bytes())
    }
        .expect(stringify!(LLVMInitializeAMDGPUAsmParser));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMCreateBuilderInContext(C: LLVMContextRef) -> LLVMBuilderRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMContextRef) -> LLVMBuilderRef,
            >(stringify!(LLVMCreateBuilderInContext).as_bytes())
    }
        .expect(stringify!(LLVMCreateBuilderInContext));
    entry(C)
}
#[no_mangle]
pub extern "C" fn LLVMBuildFreeze(
    arg1: LLVMBuilderRef,
    Val: LLVMValueRef,
    Name: *const ::libc::c_char,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMBuilderRef,
                    LLVMValueRef,
                    *const ::libc::c_char,
                ) -> LLVMValueRef,
            >(stringify!(LLVMBuildFreeze).as_bytes())
    }
        .expect(stringify!(LLVMBuildFreeze));
    entry(arg1, Val, Name)
}
#[no_mangle]
pub extern "C" fn LLVMDIBuilderCreateModule(
    Builder: LLVMDIBuilderRef,
    ParentScope: LLVMMetadataRef,
    Name: *const ::libc::c_char,
    NameLen: ::libc::size_t,
    ConfigMacros: *const ::libc::c_char,
    ConfigMacrosLen: ::libc::size_t,
    IncludePath: *const ::libc::c_char,
    IncludePathLen: ::libc::size_t,
    APINotesFile: *const ::libc::c_char,
    APINotesFileLen: ::libc::size_t,
) -> LLVMMetadataRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMDIBuilderRef,
                    LLVMMetadataRef,
                    *const ::libc::c_char,
                    ::libc::size_t,
                    *const ::libc::c_char,
                    ::libc::size_t,
                    *const ::libc::c_char,
                    ::libc::size_t,
                    *const ::libc::c_char,
                    ::libc::size_t,
                ) -> LLVMMetadataRef,
            >(stringify!(LLVMDIBuilderCreateModule).as_bytes())
    }
        .expect(stringify!(LLVMDIBuilderCreateModule));
    entry(
        Builder,
        ParentScope,
        Name,
        NameLen,
        ConfigMacros,
        ConfigMacrosLen,
        IncludePath,
        IncludePathLen,
        APINotesFile,
        APINotesFileLen,
    )
}
#[no_mangle]
pub extern "C" fn LLVMInitializeXCoreTargetInfo() {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<extern "C" fn()>(stringify!(LLVMInitializeXCoreTargetInfo).as_bytes())
    }
        .expect(stringify!(LLVMInitializeXCoreTargetInfo));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMInitializeMipsTargetInfo() {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<extern "C" fn()>(stringify!(LLVMInitializeMipsTargetInfo).as_bytes())
    }
        .expect(stringify!(LLVMInitializeMipsTargetInfo));
    entry()
}
#[no_mangle]
pub extern "C" fn llvm_blake3_hasher_reset(hasher: *mut llvm_blake3_hasher) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(*mut llvm_blake3_hasher),
            >(stringify!(llvm_blake3_hasher_reset).as_bytes())
    }
        .expect(stringify!(llvm_blake3_hasher_reset));
    entry(hasher)
}
#[no_mangle]
pub extern "C" fn LLVMGetVersion(
    Major: *mut ::libc::c_uint,
    Minor: *mut ::libc::c_uint,
    Patch: *mut ::libc::c_uint,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    *mut ::libc::c_uint,
                    *mut ::libc::c_uint,
                    *mut ::libc::c_uint,
                ),
            >(stringify!(LLVMGetVersion).as_bytes())
    }
        .expect(stringify!(LLVMGetVersion));
    entry(Major, Minor, Patch)
}
#[no_mangle]
pub extern "C" fn LLVMInitializeSparcTargetInfo() {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<extern "C" fn()>(stringify!(LLVMInitializeSparcTargetInfo).as_bytes())
    }
        .expect(stringify!(LLVMInitializeSparcTargetInfo));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMOrcDisposeJITTargetMachineBuilder(
    JTMB: LLVMOrcJITTargetMachineBuilderRef,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMOrcJITTargetMachineBuilderRef),
            >(stringify!(LLVMOrcDisposeJITTargetMachineBuilder).as_bytes())
    }
        .expect(stringify!(LLVMOrcDisposeJITTargetMachineBuilder));
    entry(JTMB)
}
#[no_mangle]
pub extern "C" fn LLVMWriteBitcodeToFileHandle(
    M: LLVMModuleRef,
    Handle: ::libc::c_int,
) -> ::libc::c_int {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMModuleRef, ::libc::c_int) -> ::libc::c_int,
            >(stringify!(LLVMWriteBitcodeToFileHandle).as_bytes())
    }
        .expect(stringify!(LLVMWriteBitcodeToFileHandle));
    entry(M, Handle)
}
#[no_mangle]
pub extern "C" fn LLVMDIBuilderCreateObjCIVar(
    Builder: LLVMDIBuilderRef,
    Name: *const ::libc::c_char,
    NameLen: ::libc::size_t,
    File: LLVMMetadataRef,
    LineNo: ::libc::c_uint,
    SizeInBits: u64,
    AlignInBits: u32,
    OffsetInBits: u64,
    Flags: LLVMDIFlags,
    Ty: LLVMMetadataRef,
    PropertyNode: LLVMMetadataRef,
) -> LLVMMetadataRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMDIBuilderRef,
                    *const ::libc::c_char,
                    ::libc::size_t,
                    LLVMMetadataRef,
                    ::libc::c_uint,
                    u64,
                    u32,
                    u64,
                    LLVMDIFlags,
                    LLVMMetadataRef,
                    LLVMMetadataRef,
                ) -> LLVMMetadataRef,
            >(stringify!(LLVMDIBuilderCreateObjCIVar).as_bytes())
    }
        .expect(stringify!(LLVMDIBuilderCreateObjCIVar));
    entry(
        Builder,
        Name,
        NameLen,
        File,
        LineNo,
        SizeInBits,
        AlignInBits,
        OffsetInBits,
        Flags,
        Ty,
        PropertyNode,
    )
}
#[no_mangle]
pub extern "C" fn LLVMAddClause(LandingPad: LLVMValueRef, ClauseVal: LLVMValueRef) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, LLVMValueRef),
            >(stringify!(LLVMAddClause).as_bytes())
    }
        .expect(stringify!(LLVMAddClause));
    entry(LandingPad, ClauseVal)
}
#[no_mangle]
pub extern "C" fn LLVMDumpModule(M: LLVMModuleRef) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<extern "C" fn(LLVMModuleRef)>(stringify!(LLVMDumpModule).as_bytes())
    }
        .expect(stringify!(LLVMDumpModule));
    entry(M)
}
#[no_mangle]
pub extern "C" fn LLVMConstantPtrAuth(
    Ptr: LLVMValueRef,
    Key: LLVMValueRef,
    Disc: LLVMValueRef,
    AddrDisc: LLVMValueRef,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMValueRef,
                    LLVMValueRef,
                    LLVMValueRef,
                    LLVMValueRef,
                ) -> LLVMValueRef,
            >(stringify!(LLVMConstantPtrAuth).as_bytes())
    }
        .expect(stringify!(LLVMConstantPtrAuth));
    entry(Ptr, Key, Disc, AddrDisc)
}
#[no_mangle]
pub extern "C" fn LLVMGetOperandBundleAtIndex(
    C: LLVMValueRef,
    Index: ::libc::c_uint,
) -> LLVMOperandBundleRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, ::libc::c_uint) -> LLVMOperandBundleRef,
            >(stringify!(LLVMGetOperandBundleAtIndex).as_bytes())
    }
        .expect(stringify!(LLVMGetOperandBundleAtIndex));
    entry(C, Index)
}
#[no_mangle]
pub extern "C" fn LLVMSetGC(Fn: LLVMValueRef, Name: *const ::libc::c_char) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, *const ::libc::c_char),
            >(stringify!(LLVMSetGC).as_bytes())
    }
        .expect(stringify!(LLVMSetGC));
    entry(Fn, Name)
}
#[no_mangle]
pub extern "C" fn LLVMConstRealGetDouble(
    ConstantVal: LLVMValueRef,
    losesInfo: *mut LLVMBool,
) -> ::libc::c_double {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, *mut LLVMBool) -> ::libc::c_double,
            >(stringify!(LLVMConstRealGetDouble).as_bytes())
    }
        .expect(stringify!(LLVMConstRealGetDouble));
    entry(ConstantVal, losesInfo)
}
#[no_mangle]
pub extern "C" fn LLVMIsACallInst(Val: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMIsACallInst).as_bytes())
    }
        .expect(stringify!(LLVMIsACallInst));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn LLVMAppendExistingBasicBlock(Fn: LLVMValueRef, BB: LLVMBasicBlockRef) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, LLVMBasicBlockRef),
            >(stringify!(LLVMAppendExistingBasicBlock).as_bytes())
    }
        .expect(stringify!(LLVMAppendExistingBasicBlock));
    entry(Fn, BB)
}
#[no_mangle]
pub extern "C" fn LLVMSetTargetMachineGlobalISelAbort(
    T: LLVMTargetMachineRef,
    Mode: LLVMGlobalISelAbortMode,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMTargetMachineRef, LLVMGlobalISelAbortMode),
            >(stringify!(LLVMSetTargetMachineGlobalISelAbort).as_bytes())
    }
        .expect(stringify!(LLVMSetTargetMachineGlobalISelAbort));
    entry(T, Mode)
}
#[no_mangle]
pub extern "C" fn LLVMHasPersonalityFn(Fn: LLVMValueRef) -> LLVMBool {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMBool,
            >(stringify!(LLVMHasPersonalityFn).as_bytes())
    }
        .expect(stringify!(LLVMHasPersonalityFn));
    entry(Fn)
}
#[no_mangle]
pub extern "C" fn LLVMOrcDisposeLLJIT(J: LLVMOrcLLJITRef) -> LLVMErrorRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMOrcLLJITRef) -> LLVMErrorRef,
            >(stringify!(LLVMOrcDisposeLLJIT).as_bytes())
    }
        .expect(stringify!(LLVMOrcDisposeLLJIT));
    entry(J)
}
#[no_mangle]
pub extern "C" fn LLVMIsExternallyInitialized(GlobalVar: LLVMValueRef) -> LLVMBool {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMBool,
            >(stringify!(LLVMIsExternallyInitialized).as_bytes())
    }
        .expect(stringify!(LLVMIsExternallyInitialized));
    entry(GlobalVar)
}
#[no_mangle]
pub extern "C" fn LLVMInt1TypeInContext(C: LLVMContextRef) -> LLVMTypeRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMContextRef) -> LLVMTypeRef,
            >(stringify!(LLVMInt1TypeInContext).as_bytes())
    }
        .expect(stringify!(LLVMInt1TypeInContext));
    entry(C)
}
#[no_mangle]
pub extern "C" fn LLVMPassBuilderOptionsSetLoopUnrolling(
    Options: LLVMPassBuilderOptionsRef,
    LoopUnrolling: LLVMBool,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMPassBuilderOptionsRef, LLVMBool),
            >(stringify!(LLVMPassBuilderOptionsSetLoopUnrolling).as_bytes())
    }
        .expect(stringify!(LLVMPassBuilderOptionsSetLoopUnrolling));
    entry(Options, LoopUnrolling)
}
#[no_mangle]
pub extern "C" fn LLVMSetInitializer(
    GlobalVar: LLVMValueRef,
    ConstantVal: LLVMValueRef,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, LLVMValueRef),
            >(stringify!(LLVMSetInitializer).as_bytes())
    }
        .expect(stringify!(LLVMSetInitializer));
    entry(GlobalVar, ConstantVal)
}
#[no_mangle]
pub extern "C" fn LLVMIsConstantString(c: LLVMValueRef) -> LLVMBool {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMBool,
            >(stringify!(LLVMIsConstantString).as_bytes())
    }
        .expect(stringify!(LLVMIsConstantString));
    entry(c)
}
#[no_mangle]
pub extern "C" fn LLVMConstInsertElement(
    VectorConstant: LLVMValueRef,
    ElementValueConstant: LLVMValueRef,
    IndexConstant: LLVMValueRef,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, LLVMValueRef, LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMConstInsertElement).as_bytes())
    }
        .expect(stringify!(LLVMConstInsertElement));
    entry(VectorConstant, ElementValueConstant, IndexConstant)
}
#[no_mangle]
pub extern "C" fn LLVMOrcObjectLayerEmit(
    ObjLayer: LLVMOrcObjectLayerRef,
    R: LLVMOrcMaterializationResponsibilityRef,
    ObjBuffer: LLVMMemoryBufferRef,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMOrcObjectLayerRef,
                    LLVMOrcMaterializationResponsibilityRef,
                    LLVMMemoryBufferRef,
                ),
            >(stringify!(LLVMOrcObjectLayerEmit).as_bytes())
    }
        .expect(stringify!(LLVMOrcObjectLayerEmit));
    entry(ObjLayer, R, ObjBuffer)
}
#[no_mangle]
pub extern "C" fn LLVMGetMDKindIDInContext(
    C: LLVMContextRef,
    Name: *const ::libc::c_char,
    SLen: ::libc::c_uint,
) -> ::libc::c_uint {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMContextRef,
                    *const ::libc::c_char,
                    ::libc::c_uint,
                ) -> ::libc::c_uint,
            >(stringify!(LLVMGetMDKindIDInContext).as_bytes())
    }
        .expect(stringify!(LLVMGetMDKindIDInContext));
    entry(C, Name, SLen)
}
#[no_mangle]
pub extern "C" fn LLVMConstNamedStruct(
    StructTy: LLVMTypeRef,
    ConstantVals: *mut LLVMValueRef,
    Count: ::libc::c_uint,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMTypeRef,
                    *mut LLVMValueRef,
                    ::libc::c_uint,
                ) -> LLVMValueRef,
            >(stringify!(LLVMConstNamedStruct).as_bytes())
    }
        .expect(stringify!(LLVMConstNamedStruct));
    entry(StructTy, ConstantVals, Count)
}
#[no_mangle]
pub extern "C" fn thinlto_codegen_set_cache_size_files(
    cg: thinlto_code_gen_t,
    max_size_files: ::libc::c_uint,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(thinlto_code_gen_t, ::libc::c_uint),
            >(stringify!(thinlto_codegen_set_cache_size_files).as_bytes())
    }
        .expect(stringify!(thinlto_codegen_set_cache_size_files));
    entry(cg, max_size_files)
}
#[no_mangle]
pub extern "C" fn LLVMBuildAddrSpaceCast(
    arg1: LLVMBuilderRef,
    Val: LLVMValueRef,
    DestTy: LLVMTypeRef,
    Name: *const ::libc::c_char,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMBuilderRef,
                    LLVMValueRef,
                    LLVMTypeRef,
                    *const ::libc::c_char,
                ) -> LLVMValueRef,
            >(stringify!(LLVMBuildAddrSpaceCast).as_bytes())
    }
        .expect(stringify!(LLVMBuildAddrSpaceCast));
    entry(arg1, Val, DestTy, Name)
}
#[no_mangle]
pub extern "C" fn LLVMGetTargetExtTypeNumTypeParams(
    TargetExtTy: LLVMTypeRef,
) -> ::libc::c_uint {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMTypeRef) -> ::libc::c_uint,
            >(stringify!(LLVMGetTargetExtTypeNumTypeParams).as_bytes())
    }
        .expect(stringify!(LLVMGetTargetExtTypeNumTypeParams));
    entry(TargetExtTy)
}
#[no_mangle]
pub extern "C" fn LLVMTargetExtTypeInContext(
    C: LLVMContextRef,
    Name: *const ::libc::c_char,
    TypeParams: *mut LLVMTypeRef,
    TypeParamCount: ::libc::c_uint,
    IntParams: *mut ::libc::c_uint,
    IntParamCount: ::libc::c_uint,
) -> LLVMTypeRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMContextRef,
                    *const ::libc::c_char,
                    *mut LLVMTypeRef,
                    ::libc::c_uint,
                    *mut ::libc::c_uint,
                    ::libc::c_uint,
                ) -> LLVMTypeRef,
            >(stringify!(LLVMTargetExtTypeInContext).as_bytes())
    }
        .expect(stringify!(LLVMTargetExtTypeInContext));
    entry(C, Name, TypeParams, TypeParamCount, IntParams, IntParamCount)
}
#[no_mangle]
pub extern "C" fn LLVMSetUnnamedAddress(
    Global: LLVMValueRef,
    UnnamedAddr: LLVMUnnamedAddr,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, LLVMUnnamedAddr),
            >(stringify!(LLVMSetUnnamedAddress).as_bytes())
    }
        .expect(stringify!(LLVMSetUnnamedAddress));
    entry(Global, UnnamedAddr)
}
#[no_mangle]
pub extern "C" fn LLVMBuildCall2(
    arg1: LLVMBuilderRef,
    arg2: LLVMTypeRef,
    Fn: LLVMValueRef,
    Args: *mut LLVMValueRef,
    NumArgs: ::libc::c_uint,
    Name: *const ::libc::c_char,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMBuilderRef,
                    LLVMTypeRef,
                    LLVMValueRef,
                    *mut LLVMValueRef,
                    ::libc::c_uint,
                    *const ::libc::c_char,
                ) -> LLVMValueRef,
            >(stringify!(LLVMBuildCall2).as_bytes())
    }
        .expect(stringify!(LLVMBuildCall2));
    entry(arg1, arg2, Fn, Args, NumArgs, Name)
}
#[no_mangle]
pub extern "C" fn thinlto_codegen_set_cache_dir(
    cg: thinlto_code_gen_t,
    cache_dir: *const ::libc::c_char,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(thinlto_code_gen_t, *const ::libc::c_char),
            >(stringify!(thinlto_codegen_set_cache_dir).as_bytes())
    }
        .expect(stringify!(thinlto_codegen_set_cache_dir));
    entry(cg, cache_dir)
}
#[no_mangle]
pub extern "C" fn LLVMGetTargetFromTriple(
    Triple: *const ::libc::c_char,
    T: *mut LLVMTargetRef,
    ErrorMessage: *mut *mut ::libc::c_char,
) -> LLVMBool {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    *const ::libc::c_char,
                    *mut LLVMTargetRef,
                    *mut *mut ::libc::c_char,
                ) -> LLVMBool,
            >(stringify!(LLVMGetTargetFromTriple).as_bytes())
    }
        .expect(stringify!(LLVMGetTargetFromTriple));
    entry(Triple, T, ErrorMessage)
}
#[no_mangle]
pub extern "C" fn LLVMDILocationGetScope(Location: LLVMMetadataRef) -> LLVMMetadataRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMMetadataRef) -> LLVMMetadataRef,
            >(stringify!(LLVMDILocationGetScope).as_bytes())
    }
        .expect(stringify!(LLVMDILocationGetScope));
    entry(Location)
}
#[no_mangle]
pub extern "C" fn LLVMDIScopeGetFile(Scope: LLVMMetadataRef) -> LLVMMetadataRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMMetadataRef) -> LLVMMetadataRef,
            >(stringify!(LLVMDIScopeGetFile).as_bytes())
    }
        .expect(stringify!(LLVMDIScopeGetFile));
    entry(Scope)
}
#[no_mangle]
pub extern "C" fn LLVMValueIsBasicBlock(Val: LLVMValueRef) -> LLVMBool {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMBool,
            >(stringify!(LLVMValueIsBasicBlock).as_bytes())
    }
        .expect(stringify!(LLVMValueIsBasicBlock));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn LLVMParseBitcodeInContext(
    ContextRef: LLVMContextRef,
    MemBuf: LLVMMemoryBufferRef,
    OutModule: *mut LLVMModuleRef,
    OutMessage: *mut *mut ::libc::c_char,
) -> LLVMBool {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMContextRef,
                    LLVMMemoryBufferRef,
                    *mut LLVMModuleRef,
                    *mut *mut ::libc::c_char,
                ) -> LLVMBool,
            >(stringify!(LLVMParseBitcodeInContext).as_bytes())
    }
        .expect(stringify!(LLVMParseBitcodeInContext));
    entry(ContextRef, MemBuf, OutModule, OutMessage)
}
#[no_mangle]
pub extern "C" fn LLVMGetLastInstruction(BB: LLVMBasicBlockRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMBasicBlockRef) -> LLVMValueRef,
            >(stringify!(LLVMGetLastInstruction).as_bytes())
    }
        .expect(stringify!(LLVMGetLastInstruction));
    entry(BB)
}
#[no_mangle]
pub extern "C" fn LLVMIsAConstantExpr(Val: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMIsAConstantExpr).as_bytes())
    }
        .expect(stringify!(LLVMIsAConstantExpr));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn LLVMDILocationGetLine(Location: LLVMMetadataRef) -> ::libc::c_uint {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMMetadataRef) -> ::libc::c_uint,
            >(stringify!(LLVMDILocationGetLine).as_bytes())
    }
        .expect(stringify!(LLVMDILocationGetLine));
    entry(Location)
}
#[no_mangle]
pub extern "C" fn LLVMGenericValueToInt(
    GenVal: LLVMGenericValueRef,
    IsSigned: LLVMBool,
) -> ::libc::c_ulonglong {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMGenericValueRef, LLVMBool) -> ::libc::c_ulonglong,
            >(stringify!(LLVMGenericValueToInt).as_bytes())
    }
        .expect(stringify!(LLVMGenericValueToInt));
    entry(GenVal, IsSigned)
}
#[no_mangle]
pub extern "C" fn LLVMIsAValueAsMetadata(Val: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMIsAValueAsMetadata).as_bytes())
    }
        .expect(stringify!(LLVMIsAValueAsMetadata));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn LLVMGetDiagInfoDescription(
    DI: LLVMDiagnosticInfoRef,
) -> *mut ::libc::c_char {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMDiagnosticInfoRef) -> *mut ::libc::c_char,
            >(stringify!(LLVMGetDiagInfoDescription).as_bytes())
    }
        .expect(stringify!(LLVMGetDiagInfoDescription));
    entry(DI)
}
#[no_mangle]
pub extern "C" fn LLVMHalfType() -> LLVMTypeRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<extern "C" fn() -> LLVMTypeRef>(stringify!(LLVMHalfType).as_bytes())
    }
        .expect(stringify!(LLVMHalfType));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMGetSwitchDefaultDest(
    SwitchInstr: LLVMValueRef,
) -> LLVMBasicBlockRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMBasicBlockRef,
            >(stringify!(LLVMGetSwitchDefaultDest).as_bytes())
    }
        .expect(stringify!(LLVMGetSwitchDefaultDest));
    entry(SwitchInstr)
}
#[no_mangle]
pub extern "C" fn LLVMInt64Type() -> LLVMTypeRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<extern "C" fn() -> LLVMTypeRef>(stringify!(LLVMInt64Type).as_bytes())
    }
        .expect(stringify!(LLVMInt64Type));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMDIBuilderCreateFunction(
    Builder: LLVMDIBuilderRef,
    Scope: LLVMMetadataRef,
    Name: *const ::libc::c_char,
    NameLen: ::libc::size_t,
    LinkageName: *const ::libc::c_char,
    LinkageNameLen: ::libc::size_t,
    File: LLVMMetadataRef,
    LineNo: ::libc::c_uint,
    Ty: LLVMMetadataRef,
    IsLocalToUnit: LLVMBool,
    IsDefinition: LLVMBool,
    ScopeLine: ::libc::c_uint,
    Flags: LLVMDIFlags,
    IsOptimized: LLVMBool,
) -> LLVMMetadataRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMDIBuilderRef,
                    LLVMMetadataRef,
                    *const ::libc::c_char,
                    ::libc::size_t,
                    *const ::libc::c_char,
                    ::libc::size_t,
                    LLVMMetadataRef,
                    ::libc::c_uint,
                    LLVMMetadataRef,
                    LLVMBool,
                    LLVMBool,
                    ::libc::c_uint,
                    LLVMDIFlags,
                    LLVMBool,
                ) -> LLVMMetadataRef,
            >(stringify!(LLVMDIBuilderCreateFunction).as_bytes())
    }
        .expect(stringify!(LLVMDIBuilderCreateFunction));
    entry(
        Builder,
        Scope,
        Name,
        NameLen,
        LinkageName,
        LinkageNameLen,
        File,
        LineNo,
        Ty,
        IsLocalToUnit,
        IsDefinition,
        ScopeLine,
        Flags,
        IsOptimized,
    )
}
#[no_mangle]
pub extern "C" fn LLVMCreateGenericValueOfPointer(
    P: *mut ::libc::c_void,
) -> LLVMGenericValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(*mut ::libc::c_void) -> LLVMGenericValueRef,
            >(stringify!(LLVMCreateGenericValueOfPointer).as_bytes())
    }
        .expect(stringify!(LLVMCreateGenericValueOfPointer));
    entry(P)
}
#[no_mangle]
pub extern "C" fn LLVMRemarkEntryGetNextArg(
    It: LLVMRemarkArgRef,
    Remark: LLVMRemarkEntryRef,
) -> LLVMRemarkArgRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMRemarkArgRef, LLVMRemarkEntryRef) -> LLVMRemarkArgRef,
            >(stringify!(LLVMRemarkEntryGetNextArg).as_bytes())
    }
        .expect(stringify!(LLVMRemarkEntryGetNextArg));
    entry(It, Remark)
}
#[no_mangle]
pub extern "C" fn LLVMOffsetOfElement(
    TD: LLVMTargetDataRef,
    StructTy: LLVMTypeRef,
    Element: ::libc::c_uint,
) -> ::libc::c_ulonglong {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMTargetDataRef,
                    LLVMTypeRef,
                    ::libc::c_uint,
                ) -> ::libc::c_ulonglong,
            >(stringify!(LLVMOffsetOfElement).as_bytes())
    }
        .expect(stringify!(LLVMOffsetOfElement));
    entry(TD, StructTy, Element)
}
#[no_mangle]
pub extern "C" fn LLVMGetModuleIdentifier(
    M: LLVMModuleRef,
    Len: *mut ::libc::size_t,
) -> *const ::libc::c_char {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMModuleRef,
                    *mut ::libc::size_t,
                ) -> *const ::libc::c_char,
            >(stringify!(LLVMGetModuleIdentifier).as_bytes())
    }
        .expect(stringify!(LLVMGetModuleIdentifier));
    entry(M, Len)
}
#[no_mangle]
pub extern "C" fn LLVMGetInlineAsmConstraintString(
    InlineAsmVal: LLVMValueRef,
    Len: *mut ::libc::size_t,
) -> *const ::libc::c_char {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, *mut ::libc::size_t) -> *const ::libc::c_char,
            >(stringify!(LLVMGetInlineAsmConstraintString).as_bytes())
    }
        .expect(stringify!(LLVMGetInlineAsmConstraintString));
    entry(InlineAsmVal, Len)
}
#[no_mangle]
pub extern "C" fn LLVMGetAttributeCountAtIndex(
    F: LLVMValueRef,
    Idx: LLVMAttributeIndex,
) -> ::libc::c_uint {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, LLVMAttributeIndex) -> ::libc::c_uint,
            >(stringify!(LLVMGetAttributeCountAtIndex).as_bytes())
    }
        .expect(stringify!(LLVMGetAttributeCountAtIndex));
    entry(F, Idx)
}
#[no_mangle]
pub extern "C" fn LLVMDIFileGetDirectory(
    File: LLVMMetadataRef,
    Len: *mut ::libc::c_uint,
) -> *const ::libc::c_char {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMMetadataRef,
                    *mut ::libc::c_uint,
                ) -> *const ::libc::c_char,
            >(stringify!(LLVMDIFileGetDirectory).as_bytes())
    }
        .expect(stringify!(LLVMDIFileGetDirectory));
    entry(File, Len)
}
#[no_mangle]
pub extern "C" fn LLVMGetParam(Fn: LLVMValueRef, Index: ::libc::c_uint) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, ::libc::c_uint) -> LLVMValueRef,
            >(stringify!(LLVMGetParam).as_bytes())
    }
        .expect(stringify!(LLVMGetParam));
    entry(Fn, Index)
}
#[no_mangle]
pub extern "C" fn LLVMBuildMemSet(
    B: LLVMBuilderRef,
    Ptr: LLVMValueRef,
    Val: LLVMValueRef,
    Len: LLVMValueRef,
    Align: ::libc::c_uint,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMBuilderRef,
                    LLVMValueRef,
                    LLVMValueRef,
                    LLVMValueRef,
                    ::libc::c_uint,
                ) -> LLVMValueRef,
            >(stringify!(LLVMBuildMemSet).as_bytes())
    }
        .expect(stringify!(LLVMBuildMemSet));
    entry(B, Ptr, Val, Len, Align)
}
#[no_mangle]
pub extern "C" fn LLVMGetConstantPtrAuthAddrDiscriminator(
    PtrAuth: LLVMValueRef,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMGetConstantPtrAuthAddrDiscriminator).as_bytes())
    }
        .expect(stringify!(LLVMGetConstantPtrAuthAddrDiscriminator));
    entry(PtrAuth)
}
#[no_mangle]
pub extern "C" fn LLVMIsAFPToUIInst(Val: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMIsAFPToUIInst).as_bytes())
    }
        .expect(stringify!(LLVMIsAFPToUIInst));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn LLVMBuildZExt(
    arg1: LLVMBuilderRef,
    Val: LLVMValueRef,
    DestTy: LLVMTypeRef,
    Name: *const ::libc::c_char,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMBuilderRef,
                    LLVMValueRef,
                    LLVMTypeRef,
                    *const ::libc::c_char,
                ) -> LLVMValueRef,
            >(stringify!(LLVMBuildZExt).as_bytes())
    }
        .expect(stringify!(LLVMBuildZExt));
    entry(arg1, Val, DestTy, Name)
}
#[no_mangle]
pub extern "C" fn LLVMCreateEnumAttribute(
    C: LLVMContextRef,
    KindID: ::libc::c_uint,
    Val: u64,
) -> LLVMAttributeRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMContextRef, ::libc::c_uint, u64) -> LLVMAttributeRef,
            >(stringify!(LLVMCreateEnumAttribute).as_bytes())
    }
        .expect(stringify!(LLVMCreateEnumAttribute));
    entry(C, KindID, Val)
}
#[no_mangle]
pub extern "C" fn LLVMDIBuilderCreateImportedModuleFromModule(
    Builder: LLVMDIBuilderRef,
    Scope: LLVMMetadataRef,
    M: LLVMMetadataRef,
    File: LLVMMetadataRef,
    Line: ::libc::c_uint,
    Elements: *mut LLVMMetadataRef,
    NumElements: ::libc::c_uint,
) -> LLVMMetadataRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMDIBuilderRef,
                    LLVMMetadataRef,
                    LLVMMetadataRef,
                    LLVMMetadataRef,
                    ::libc::c_uint,
                    *mut LLVMMetadataRef,
                    ::libc::c_uint,
                ) -> LLVMMetadataRef,
            >(stringify!(LLVMDIBuilderCreateImportedModuleFromModule).as_bytes())
    }
        .expect(stringify!(LLVMDIBuilderCreateImportedModuleFromModule));
    entry(Builder, Scope, M, File, Line, Elements, NumElements)
}
#[no_mangle]
pub extern "C" fn LLVMGetDataLayout(M: LLVMModuleRef) -> *const ::libc::c_char {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMModuleRef) -> *const ::libc::c_char,
            >(stringify!(LLVMGetDataLayout).as_bytes())
    }
        .expect(stringify!(LLVMGetDataLayout));
    entry(M)
}
#[no_mangle]
pub extern "C" fn LLVMDIBuilderInsertDbgValueRecordBefore(
    Builder: LLVMDIBuilderRef,
    Val: LLVMValueRef,
    VarInfo: LLVMMetadataRef,
    Expr: LLVMMetadataRef,
    DebugLoc: LLVMMetadataRef,
    Instr: LLVMValueRef,
) -> LLVMDbgRecordRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMDIBuilderRef,
                    LLVMValueRef,
                    LLVMMetadataRef,
                    LLVMMetadataRef,
                    LLVMMetadataRef,
                    LLVMValueRef,
                ) -> LLVMDbgRecordRef,
            >(stringify!(LLVMDIBuilderInsertDbgValueRecordBefore).as_bytes())
    }
        .expect(stringify!(LLVMDIBuilderInsertDbgValueRecordBefore));
    entry(Builder, Val, VarInfo, Expr, DebugLoc, Instr)
}
#[no_mangle]
pub extern "C" fn LLVMGetInlineAsmAsmString(
    InlineAsmVal: LLVMValueRef,
    Len: *mut ::libc::size_t,
) -> *const ::libc::c_char {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, *mut ::libc::size_t) -> *const ::libc::c_char,
            >(stringify!(LLVMGetInlineAsmAsmString).as_bytes())
    }
        .expect(stringify!(LLVMGetInlineAsmAsmString));
    entry(InlineAsmVal, Len)
}
#[no_mangle]
pub extern "C" fn LLVMDIFileGetSource(
    File: LLVMMetadataRef,
    Len: *mut ::libc::c_uint,
) -> *const ::libc::c_char {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMMetadataRef,
                    *mut ::libc::c_uint,
                ) -> *const ::libc::c_char,
            >(stringify!(LLVMDIFileGetSource).as_bytes())
    }
        .expect(stringify!(LLVMDIFileGetSource));
    entry(File, Len)
}
#[no_mangle]
pub extern "C" fn LLVMGetLinkage(Global: LLVMValueRef) -> LLVMLinkage {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMLinkage,
            >(stringify!(LLVMGetLinkage).as_bytes())
    }
        .expect(stringify!(LLVMGetLinkage));
    entry(Global)
}
#[no_mangle]
pub extern "C" fn LLVMMoveToContainingSection(
    Sect: LLVMSectionIteratorRef,
    Sym: LLVMSymbolIteratorRef,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMSectionIteratorRef, LLVMSymbolIteratorRef),
            >(stringify!(LLVMMoveToContainingSection).as_bytes())
    }
        .expect(stringify!(LLVMMoveToContainingSection));
    entry(Sect, Sym)
}
#[no_mangle]
pub extern "C" fn LLVMOrcLazyReexports(
    LCTM: LLVMOrcLazyCallThroughManagerRef,
    ISM: LLVMOrcIndirectStubsManagerRef,
    SourceRef: LLVMOrcJITDylibRef,
    CallableAliases: LLVMOrcCSymbolAliasMapPairs,
    NumPairs: ::libc::size_t,
) -> LLVMOrcMaterializationUnitRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMOrcLazyCallThroughManagerRef,
                    LLVMOrcIndirectStubsManagerRef,
                    LLVMOrcJITDylibRef,
                    LLVMOrcCSymbolAliasMapPairs,
                    ::libc::size_t,
                ) -> LLVMOrcMaterializationUnitRef,
            >(stringify!(LLVMOrcLazyReexports).as_bytes())
    }
        .expect(stringify!(LLVMOrcLazyReexports));
    entry(LCTM, ISM, SourceRef, CallableAliases, NumPairs)
}
#[no_mangle]
pub extern "C" fn LLVMOrcMaterializationResponsibilityGetRequestedSymbols(
    MR: LLVMOrcMaterializationResponsibilityRef,
    NumSymbols: *mut ::libc::size_t,
) -> *mut LLVMOrcSymbolStringPoolEntryRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMOrcMaterializationResponsibilityRef,
                    *mut ::libc::size_t,
                ) -> *mut LLVMOrcSymbolStringPoolEntryRef,
            >(
                stringify!(LLVMOrcMaterializationResponsibilityGetRequestedSymbols)
                    .as_bytes(),
            )
    }
        .expect(stringify!(LLVMOrcMaterializationResponsibilityGetRequestedSymbols));
    entry(MR, NumSymbols)
}
#[no_mangle]
pub extern "C" fn LLVMOrcMaterializationResponsibilityNotifyResolved(
    MR: LLVMOrcMaterializationResponsibilityRef,
    Symbols: LLVMOrcCSymbolMapPairs,
    NumPairs: ::libc::size_t,
) -> LLVMErrorRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMOrcMaterializationResponsibilityRef,
                    LLVMOrcCSymbolMapPairs,
                    ::libc::size_t,
                ) -> LLVMErrorRef,
            >(stringify!(LLVMOrcMaterializationResponsibilityNotifyResolved).as_bytes())
    }
        .expect(stringify!(LLVMOrcMaterializationResponsibilityNotifyResolved));
    entry(MR, Symbols, NumPairs)
}
#[no_mangle]
pub extern "C" fn LLVMAddNamedMetadataOperand(
    M: LLVMModuleRef,
    name: *const ::libc::c_char,
    Val: LLVMValueRef,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMModuleRef, *const ::libc::c_char, LLVMValueRef),
            >(stringify!(LLVMAddNamedMetadataOperand).as_bytes())
    }
        .expect(stringify!(LLVMAddNamedMetadataOperand));
    entry(M, name, Val)
}
#[no_mangle]
pub extern "C" fn LLVMAddAlias2(
    M: LLVMModuleRef,
    ValueTy: LLVMTypeRef,
    AddrSpace: ::libc::c_uint,
    Aliasee: LLVMValueRef,
    Name: *const ::libc::c_char,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMModuleRef,
                    LLVMTypeRef,
                    ::libc::c_uint,
                    LLVMValueRef,
                    *const ::libc::c_char,
                ) -> LLVMValueRef,
            >(stringify!(LLVMAddAlias2).as_bytes())
    }
        .expect(stringify!(LLVMAddAlias2));
    entry(M, ValueTy, AddrSpace, Aliasee, Name)
}
#[no_mangle]
pub extern "C" fn LLVMGetNumClauses(LandingPad: LLVMValueRef) -> ::libc::c_uint {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> ::libc::c_uint,
            >(stringify!(LLVMGetNumClauses).as_bytes())
    }
        .expect(stringify!(LLVMGetNumClauses));
    entry(LandingPad)
}
#[no_mangle]
pub extern "C" fn LLVMBuildNeg(
    arg1: LLVMBuilderRef,
    V: LLVMValueRef,
    Name: *const ::libc::c_char,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMBuilderRef,
                    LLVMValueRef,
                    *const ::libc::c_char,
                ) -> LLVMValueRef,
            >(stringify!(LLVMBuildNeg).as_bytes())
    }
        .expect(stringify!(LLVMBuildNeg));
    entry(arg1, V, Name)
}
#[no_mangle]
pub extern "C" fn LLVMOrcMaterializationResponsibilityReplace(
    MR: LLVMOrcMaterializationResponsibilityRef,
    MU: LLVMOrcMaterializationUnitRef,
) -> LLVMErrorRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMOrcMaterializationResponsibilityRef,
                    LLVMOrcMaterializationUnitRef,
                ) -> LLVMErrorRef,
            >(stringify!(LLVMOrcMaterializationResponsibilityReplace).as_bytes())
    }
        .expect(stringify!(LLVMOrcMaterializationResponsibilityReplace));
    entry(MR, MU)
}
#[no_mangle]
pub extern "C" fn LLVMInitializeMipsDisassembler() {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(),
            >(stringify!(LLVMInitializeMipsDisassembler).as_bytes())
    }
        .expect(stringify!(LLVMInitializeMipsDisassembler));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMInitializeLanaiTarget() {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<extern "C" fn()>(stringify!(LLVMInitializeLanaiTarget).as_bytes())
    }
        .expect(stringify!(LLVMInitializeLanaiTarget));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMIsPoison(Val: LLVMValueRef) -> LLVMBool {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMBool,
            >(stringify!(LLVMIsPoison).as_bytes())
    }
        .expect(stringify!(LLVMIsPoison));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn LLVMGetArrayLength2(ArrayTy: LLVMTypeRef) -> u64 {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMTypeRef) -> u64,
            >(stringify!(LLVMGetArrayLength2).as_bytes())
    }
        .expect(stringify!(LLVMGetArrayLength2));
    entry(ArrayTy)
}
#[no_mangle]
pub extern "C" fn LLVMGetLastNamedMetadata(M: LLVMModuleRef) -> LLVMNamedMDNodeRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMModuleRef) -> LLVMNamedMDNodeRef,
            >(stringify!(LLVMGetLastNamedMetadata).as_bytes())
    }
        .expect(stringify!(LLVMGetLastNamedMetadata));
    entry(M)
}
#[no_mangle]
pub extern "C" fn LLVMDIBuilderCreateObjectPointerType(
    Builder: LLVMDIBuilderRef,
    Type: LLVMMetadataRef,
    Implicit: LLVMBool,
) -> LLVMMetadataRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMDIBuilderRef,
                    LLVMMetadataRef,
                    LLVMBool,
                ) -> LLVMMetadataRef,
            >(stringify!(LLVMDIBuilderCreateObjectPointerType).as_bytes())
    }
        .expect(stringify!(LLVMDIBuilderCreateObjectPointerType));
    entry(Builder, Type, Implicit)
}
#[no_mangle]
pub extern "C" fn LLVMAddTargetLibraryInfo(
    TLI: LLVMTargetLibraryInfoRef,
    PM: LLVMPassManagerRef,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMTargetLibraryInfoRef, LLVMPassManagerRef),
            >(stringify!(LLVMAddTargetLibraryInfo).as_bytes())
    }
        .expect(stringify!(LLVMAddTargetLibraryInfo));
    entry(TLI, PM)
}
#[no_mangle]
pub extern "C" fn LLVMCallFrameAlignmentOfType(
    TD: LLVMTargetDataRef,
    Ty: LLVMTypeRef,
) -> ::libc::c_uint {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMTargetDataRef, LLVMTypeRef) -> ::libc::c_uint,
            >(stringify!(LLVMCallFrameAlignmentOfType).as_bytes())
    }
        .expect(stringify!(LLVMCallFrameAlignmentOfType));
    entry(TD, Ty)
}
#[no_mangle]
pub extern "C" fn LLVMSetNormalDest(InvokeInst: LLVMValueRef, B: LLVMBasicBlockRef) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, LLVMBasicBlockRef),
            >(stringify!(LLVMSetNormalDest).as_bytes())
    }
        .expect(stringify!(LLVMSetNormalDest));
    entry(InvokeInst, B)
}
#[no_mangle]
pub extern "C" fn LLVMGetMDNodeNumOperands(V: LLVMValueRef) -> ::libc::c_uint {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> ::libc::c_uint,
            >(stringify!(LLVMGetMDNodeNumOperands).as_bytes())
    }
        .expect(stringify!(LLVMGetMDNodeNumOperands));
    entry(V)
}
#[no_mangle]
pub extern "C" fn LLVMParseBitcodeInContext2(
    ContextRef: LLVMContextRef,
    MemBuf: LLVMMemoryBufferRef,
    OutModule: *mut LLVMModuleRef,
) -> LLVMBool {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMContextRef,
                    LLVMMemoryBufferRef,
                    *mut LLVMModuleRef,
                ) -> LLVMBool,
            >(stringify!(LLVMParseBitcodeInContext2).as_bytes())
    }
        .expect(stringify!(LLVMParseBitcodeInContext2));
    entry(ContextRef, MemBuf, OutModule)
}
#[no_mangle]
pub extern "C" fn LLVMIsAAtomicRMWInst(Val: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMIsAAtomicRMWInst).as_bytes())
    }
        .expect(stringify!(LLVMIsAAtomicRMWInst));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn LLVMGetTypeContext(Ty: LLVMTypeRef) -> LLVMContextRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMTypeRef) -> LLVMContextRef,
            >(stringify!(LLVMGetTypeContext).as_bytes())
    }
        .expect(stringify!(LLVMGetTypeContext));
    entry(Ty)
}
#[no_mangle]
pub extern "C" fn LLVMGetMaskValue(
    ShuffleVectorInst: LLVMValueRef,
    Elt: ::libc::c_uint,
) -> ::libc::c_int {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, ::libc::c_uint) -> ::libc::c_int,
            >(stringify!(LLVMGetMaskValue).as_bytes())
    }
        .expect(stringify!(LLVMGetMaskValue));
    entry(ShuffleVectorInst, Elt)
}
#[no_mangle]
pub extern "C" fn LLVMGlobalEraseMetadata(Global: LLVMValueRef, Kind: ::libc::c_uint) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, ::libc::c_uint),
            >(stringify!(LLVMGlobalEraseMetadata).as_bytes())
    }
        .expect(stringify!(LLVMGlobalEraseMetadata));
    entry(Global, Kind)
}
#[no_mangle]
pub extern "C" fn LLVMDIBuilderCreateCompileUnit(
    Builder: LLVMDIBuilderRef,
    Lang: LLVMDWARFSourceLanguage,
    FileRef: LLVMMetadataRef,
    Producer: *const ::libc::c_char,
    ProducerLen: ::libc::size_t,
    isOptimized: LLVMBool,
    Flags: *const ::libc::c_char,
    FlagsLen: ::libc::size_t,
    RuntimeVer: ::libc::c_uint,
    SplitName: *const ::libc::c_char,
    SplitNameLen: ::libc::size_t,
    Kind: LLVMDWARFEmissionKind,
    DWOId: ::libc::c_uint,
    SplitDebugInlining: LLVMBool,
    DebugInfoForProfiling: LLVMBool,
    SysRoot: *const ::libc::c_char,
    SysRootLen: ::libc::size_t,
    SDK: *const ::libc::c_char,
    SDKLen: ::libc::size_t,
) -> LLVMMetadataRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMDIBuilderRef,
                    LLVMDWARFSourceLanguage,
                    LLVMMetadataRef,
                    *const ::libc::c_char,
                    ::libc::size_t,
                    LLVMBool,
                    *const ::libc::c_char,
                    ::libc::size_t,
                    ::libc::c_uint,
                    *const ::libc::c_char,
                    ::libc::size_t,
                    LLVMDWARFEmissionKind,
                    ::libc::c_uint,
                    LLVMBool,
                    LLVMBool,
                    *const ::libc::c_char,
                    ::libc::size_t,
                    *const ::libc::c_char,
                    ::libc::size_t,
                ) -> LLVMMetadataRef,
            >(stringify!(LLVMDIBuilderCreateCompileUnit).as_bytes())
    }
        .expect(stringify!(LLVMDIBuilderCreateCompileUnit));
    entry(
        Builder,
        Lang,
        FileRef,
        Producer,
        ProducerLen,
        isOptimized,
        Flags,
        FlagsLen,
        RuntimeVer,
        SplitName,
        SplitNameLen,
        Kind,
        DWOId,
        SplitDebugInlining,
        DebugInfoForProfiling,
        SysRoot,
        SysRootLen,
        SDK,
        SDKLen,
    )
}
#[no_mangle]
pub extern "C" fn LLVMPassBuilderOptionsSetLoopInterleaving(
    Options: LLVMPassBuilderOptionsRef,
    LoopInterleaving: LLVMBool,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMPassBuilderOptionsRef, LLVMBool),
            >(stringify!(LLVMPassBuilderOptionsSetLoopInterleaving).as_bytes())
    }
        .expect(stringify!(LLVMPassBuilderOptionsSetLoopInterleaving));
    entry(Options, LoopInterleaving)
}
#[no_mangle]
pub extern "C" fn LLVMPassBuilderOptionsSetForgetAllSCEVInLoopUnroll(
    Options: LLVMPassBuilderOptionsRef,
    ForgetAllSCEVInLoopUnroll: LLVMBool,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMPassBuilderOptionsRef, LLVMBool),
            >(stringify!(LLVMPassBuilderOptionsSetForgetAllSCEVInLoopUnroll).as_bytes())
    }
        .expect(stringify!(LLVMPassBuilderOptionsSetForgetAllSCEVInLoopUnroll));
    entry(Options, ForgetAllSCEVInLoopUnroll)
}
#[no_mangle]
pub extern "C" fn LLVMTargetMachineOptionsSetABI(
    Options: LLVMTargetMachineOptionsRef,
    ABI: *const ::libc::c_char,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMTargetMachineOptionsRef, *const ::libc::c_char),
            >(stringify!(LLVMTargetMachineOptionsSetABI).as_bytes())
    }
        .expect(stringify!(LLVMTargetMachineOptionsSetABI));
    entry(Options, ABI)
}
#[no_mangle]
pub extern "C" fn lto_module_create(path: *const ::libc::c_char) -> lto_module_t {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(*const ::libc::c_char) -> lto_module_t,
            >(stringify!(lto_module_create).as_bytes())
    }
        .expect(stringify!(lto_module_create));
    entry(path)
}
#[no_mangle]
pub extern "C" fn LLVMGetNormalDest(InvokeInst: LLVMValueRef) -> LLVMBasicBlockRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMBasicBlockRef,
            >(stringify!(LLVMGetNormalDest).as_bytes())
    }
        .expect(stringify!(LLVMGetNormalDest));
    entry(InvokeInst)
}
#[no_mangle]
pub extern "C" fn LLVMGetAggregateElement(
    C: LLVMValueRef,
    idx: ::libc::c_uint,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, ::libc::c_uint) -> LLVMValueRef,
            >(stringify!(LLVMGetAggregateElement).as_bytes())
    }
        .expect(stringify!(LLVMGetAggregateElement));
    entry(C, idx)
}
#[no_mangle]
pub extern "C" fn LLVMRemoveCallSiteStringAttribute(
    C: LLVMValueRef,
    Idx: LLVMAttributeIndex,
    K: *const ::libc::c_char,
    KLen: ::libc::c_uint,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMValueRef,
                    LLVMAttributeIndex,
                    *const ::libc::c_char,
                    ::libc::c_uint,
                ),
            >(stringify!(LLVMRemoveCallSiteStringAttribute).as_bytes())
    }
        .expect(stringify!(LLVMRemoveCallSiteStringAttribute));
    entry(C, Idx, K, KLen)
}
#[no_mangle]
pub extern "C" fn LLVMFP128TypeInContext(C: LLVMContextRef) -> LLVMTypeRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMContextRef) -> LLVMTypeRef,
            >(stringify!(LLVMFP128TypeInContext).as_bytes())
    }
        .expect(stringify!(LLVMFP128TypeInContext));
    entry(C)
}
#[no_mangle]
pub extern "C" fn LLVMGetPrologueData(Fn: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMGetPrologueData).as_bytes())
    }
        .expect(stringify!(LLVMGetPrologueData));
    entry(Fn)
}
#[no_mangle]
pub extern "C" fn LLVMBuildCleanupPad(
    B: LLVMBuilderRef,
    ParentPad: LLVMValueRef,
    Args: *mut LLVMValueRef,
    NumArgs: ::libc::c_uint,
    Name: *const ::libc::c_char,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMBuilderRef,
                    LLVMValueRef,
                    *mut LLVMValueRef,
                    ::libc::c_uint,
                    *const ::libc::c_char,
                ) -> LLVMValueRef,
            >(stringify!(LLVMBuildCleanupPad).as_bytes())
    }
        .expect(stringify!(LLVMBuildCleanupPad));
    entry(B, ParentPad, Args, NumArgs, Name)
}
#[no_mangle]
pub extern "C" fn LLVMIsASIToFPInst(Val: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMIsASIToFPInst).as_bytes())
    }
        .expect(stringify!(LLVMIsASIToFPInst));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn LLVMBuildExtractElement(
    arg1: LLVMBuilderRef,
    VecVal: LLVMValueRef,
    Index: LLVMValueRef,
    Name: *const ::libc::c_char,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMBuilderRef,
                    LLVMValueRef,
                    LLVMValueRef,
                    *const ::libc::c_char,
                ) -> LLVMValueRef,
            >(stringify!(LLVMBuildExtractElement).as_bytes())
    }
        .expect(stringify!(LLVMBuildExtractElement));
    entry(arg1, VecVal, Index, Name)
}
#[no_mangle]
pub extern "C" fn LLVMDisposeTemporaryMDNode(TempNode: LLVMMetadataRef) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMMetadataRef),
            >(stringify!(LLVMDisposeTemporaryMDNode).as_bytes())
    }
        .expect(stringify!(LLVMDisposeTemporaryMDNode));
    entry(TempNode)
}
#[no_mangle]
pub extern "C" fn LLVMCreateMCJITCompilerForModule(
    OutJIT: *mut LLVMExecutionEngineRef,
    M: LLVMModuleRef,
    Options: *mut LLVMMCJITCompilerOptions,
    SizeOfOptions: ::libc::size_t,
    OutError: *mut *mut ::libc::c_char,
) -> LLVMBool {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    *mut LLVMExecutionEngineRef,
                    LLVMModuleRef,
                    *mut LLVMMCJITCompilerOptions,
                    ::libc::size_t,
                    *mut *mut ::libc::c_char,
                ) -> LLVMBool,
            >(stringify!(LLVMCreateMCJITCompilerForModule).as_bytes())
    }
        .expect(stringify!(LLVMCreateMCJITCompilerForModule));
    entry(OutJIT, M, Options, SizeOfOptions, OutError)
}
#[no_mangle]
pub extern "C" fn LLVMIsAUnaryOperator(Val: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMIsAUnaryOperator).as_bytes())
    }
        .expect(stringify!(LLVMIsAUnaryOperator));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn LLVMOrcMaterializationResponsibilityGetExecutionSession(
    MR: LLVMOrcMaterializationResponsibilityRef,
) -> LLVMOrcExecutionSessionRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMOrcMaterializationResponsibilityRef,
                ) -> LLVMOrcExecutionSessionRef,
            >(
                stringify!(LLVMOrcMaterializationResponsibilityGetExecutionSession)
                    .as_bytes(),
            )
    }
        .expect(stringify!(LLVMOrcMaterializationResponsibilityGetExecutionSession));
    entry(MR)
}
#[no_mangle]
pub extern "C" fn LLVMInstallFatalErrorHandler(Handler: LLVMFatalErrorHandler) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMFatalErrorHandler),
            >(stringify!(LLVMInstallFatalErrorHandler).as_bytes())
    }
        .expect(stringify!(LLVMInstallFatalErrorHandler));
    entry(Handler)
}
#[no_mangle]
pub extern "C" fn LLVMBuildInsertValue(
    arg1: LLVMBuilderRef,
    AggVal: LLVMValueRef,
    EltVal: LLVMValueRef,
    Index: ::libc::c_uint,
    Name: *const ::libc::c_char,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMBuilderRef,
                    LLVMValueRef,
                    LLVMValueRef,
                    ::libc::c_uint,
                    *const ::libc::c_char,
                ) -> LLVMValueRef,
            >(stringify!(LLVMBuildInsertValue).as_bytes())
    }
        .expect(stringify!(LLVMBuildInsertValue));
    entry(arg1, AggVal, EltVal, Index, Name)
}
#[no_mangle]
pub extern "C" fn LLVMSetTarget(M: LLVMModuleRef, Triple: *const ::libc::c_char) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMModuleRef, *const ::libc::c_char),
            >(stringify!(LLVMSetTarget).as_bytes())
    }
        .expect(stringify!(LLVMSetTarget));
    entry(M, Triple)
}
#[no_mangle]
pub extern "C" fn LLVMGetInstructionParent(Inst: LLVMValueRef) -> LLVMBasicBlockRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMBasicBlockRef,
            >(stringify!(LLVMGetInstructionParent).as_bytes())
    }
        .expect(stringify!(LLVMGetInstructionParent));
    entry(Inst)
}
#[no_mangle]
pub extern "C" fn LLVMConstInlineAsm(
    Ty: LLVMTypeRef,
    AsmString: *const ::libc::c_char,
    Constraints: *const ::libc::c_char,
    HasSideEffects: LLVMBool,
    IsAlignStack: LLVMBool,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMTypeRef,
                    *const ::libc::c_char,
                    *const ::libc::c_char,
                    LLVMBool,
                    LLVMBool,
                ) -> LLVMValueRef,
            >(stringify!(LLVMConstInlineAsm).as_bytes())
    }
        .expect(stringify!(LLVMConstInlineAsm));
    entry(Ty, AsmString, Constraints, HasSideEffects, IsAlignStack)
}
#[no_mangle]
pub extern "C" fn LLVMIsAInstruction(Val: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMIsAInstruction).as_bytes())
    }
        .expect(stringify!(LLVMIsAInstruction));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn LLVMOrcSymbolStringPoolClearDeadEntries(
    SSP: LLVMOrcSymbolStringPoolRef,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMOrcSymbolStringPoolRef),
            >(stringify!(LLVMOrcSymbolStringPoolClearDeadEntries).as_bytes())
    }
        .expect(stringify!(LLVMOrcSymbolStringPoolClearDeadEntries));
    entry(SSP)
}
#[no_mangle]
pub extern "C" fn LLVMInitializePowerPCTargetInfo() {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(),
            >(stringify!(LLVMInitializePowerPCTargetInfo).as_bytes())
    }
        .expect(stringify!(LLVMInitializePowerPCTargetInfo));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMOrcDumpObjects_CallOperator(
    DumpObjects: LLVMOrcDumpObjectsRef,
    ObjBuffer: *mut LLVMMemoryBufferRef,
) -> LLVMErrorRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMOrcDumpObjectsRef,
                    *mut LLVMMemoryBufferRef,
                ) -> LLVMErrorRef,
            >(stringify!(LLVMOrcDumpObjects_CallOperator).as_bytes())
    }
        .expect(stringify!(LLVMOrcDumpObjects_CallOperator));
    entry(DumpObjects, ObjBuffer)
}
#[no_mangle]
pub extern "C" fn LLVMIsAInvokeInst(Val: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMIsAInvokeInst).as_bytes())
    }
        .expect(stringify!(LLVMIsAInvokeInst));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn LLVMIntrinsicCopyOverloadedName(
    ID: ::libc::c_uint,
    ParamTypes: *mut LLVMTypeRef,
    ParamCount: ::libc::size_t,
    NameLength: *mut ::libc::size_t,
) -> *const ::libc::c_char {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    ::libc::c_uint,
                    *mut LLVMTypeRef,
                    ::libc::size_t,
                    *mut ::libc::size_t,
                ) -> *const ::libc::c_char,
            >(stringify!(LLVMIntrinsicCopyOverloadedName).as_bytes())
    }
        .expect(stringify!(LLVMIntrinsicCopyOverloadedName));
    entry(ID, ParamTypes, ParamCount, NameLength)
}
#[no_mangle]
pub extern "C" fn LLVMConstSub(
    LHSConstant: LLVMValueRef,
    RHSConstant: LLVMValueRef,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMConstSub).as_bytes())
    }
        .expect(stringify!(LLVMConstSub));
    entry(LHSConstant, RHSConstant)
}
#[no_mangle]
pub extern "C" fn LLVMDisposeModule(M: LLVMModuleRef) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMModuleRef),
            >(stringify!(LLVMDisposeModule).as_bytes())
    }
        .expect(stringify!(LLVMDisposeModule));
    entry(M)
}
#[no_mangle]
pub extern "C" fn LLVMGetCallSiteAttributeCount(
    C: LLVMValueRef,
    Idx: LLVMAttributeIndex,
) -> ::libc::c_uint {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, LLVMAttributeIndex) -> ::libc::c_uint,
            >(stringify!(LLVMGetCallSiteAttributeCount).as_bytes())
    }
        .expect(stringify!(LLVMGetCallSiteAttributeCount));
    entry(C, Idx)
}
#[no_mangle]
pub extern "C" fn LLVMBuildAShr(
    arg1: LLVMBuilderRef,
    LHS: LLVMValueRef,
    RHS: LLVMValueRef,
    Name: *const ::libc::c_char,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMBuilderRef,
                    LLVMValueRef,
                    LLVMValueRef,
                    *const ::libc::c_char,
                ) -> LLVMValueRef,
            >(stringify!(LLVMBuildAShr).as_bytes())
    }
        .expect(stringify!(LLVMBuildAShr));
    entry(arg1, LHS, RHS, Name)
}
#[no_mangle]
pub extern "C" fn LLVMIsAConstantArray(Val: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMIsAConstantArray).as_bytes())
    }
        .expect(stringify!(LLVMIsAConstantArray));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn LLVMBuildSwitch(
    arg1: LLVMBuilderRef,
    V: LLVMValueRef,
    Else: LLVMBasicBlockRef,
    NumCases: ::libc::c_uint,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMBuilderRef,
                    LLVMValueRef,
                    LLVMBasicBlockRef,
                    ::libc::c_uint,
                ) -> LLVMValueRef,
            >(stringify!(LLVMBuildSwitch).as_bytes())
    }
        .expect(stringify!(LLVMBuildSwitch));
    entry(arg1, V, Else, NumCases)
}
#[no_mangle]
pub extern "C" fn LLVMCreatePassBuilderOptions() -> LLVMPassBuilderOptionsRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn() -> LLVMPassBuilderOptionsRef,
            >(stringify!(LLVMCreatePassBuilderOptions).as_bytes())
    }
        .expect(stringify!(LLVMCreatePassBuilderOptions));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMConstIntGetZExtValue(
    ConstantVal: LLVMValueRef,
) -> ::libc::c_ulonglong {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> ::libc::c_ulonglong,
            >(stringify!(LLVMConstIntGetZExtValue).as_bytes())
    }
        .expect(stringify!(LLVMConstIntGetZExtValue));
    entry(ConstantVal)
}
#[no_mangle]
pub extern "C" fn lto_module_create_from_fd(
    fd: ::libc::c_int,
    path: *const ::libc::c_char,
    file_size: ::libc::size_t,
) -> lto_module_t {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    ::libc::c_int,
                    *const ::libc::c_char,
                    ::libc::size_t,
                ) -> lto_module_t,
            >(stringify!(lto_module_create_from_fd).as_bytes())
    }
        .expect(stringify!(lto_module_create_from_fd));
    entry(fd, path, file_size)
}
#[no_mangle]
pub extern "C" fn LLVMIsABasicBlock(Val: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMIsABasicBlock).as_bytes())
    }
        .expect(stringify!(LLVMIsABasicBlock));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn LLVMRunStaticConstructors(EE: LLVMExecutionEngineRef) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMExecutionEngineRef),
            >(stringify!(LLVMRunStaticConstructors).as_bytes())
    }
        .expect(stringify!(LLVMRunStaticConstructors));
    entry(EE)
}
#[no_mangle]
pub extern "C" fn LLVMOrcDisposeDumpObjects(DumpObjects: LLVMOrcDumpObjectsRef) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMOrcDumpObjectsRef),
            >(stringify!(LLVMOrcDisposeDumpObjects).as_bytes())
    }
        .expect(stringify!(LLVMOrcDisposeDumpObjects));
    entry(DumpObjects)
}
#[no_mangle]
pub extern "C" fn LLVMConstStructInContext(
    C: LLVMContextRef,
    ConstantVals: *mut LLVMValueRef,
    Count: ::libc::c_uint,
    Packed: LLVMBool,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMContextRef,
                    *mut LLVMValueRef,
                    ::libc::c_uint,
                    LLVMBool,
                ) -> LLVMValueRef,
            >(stringify!(LLVMConstStructInContext).as_bytes())
    }
        .expect(stringify!(LLVMConstStructInContext));
    entry(C, ConstantVals, Count, Packed)
}
#[no_mangle]
pub extern "C" fn LLVMSearchForAddressOfSymbol(
    symbolName: *const ::libc::c_char,
) -> *mut ::libc::c_void {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(*const ::libc::c_char) -> *mut ::libc::c_void,
            >(stringify!(LLVMSearchForAddressOfSymbol).as_bytes())
    }
        .expect(stringify!(LLVMSearchForAddressOfSymbol));
    entry(symbolName)
}
#[no_mangle]
pub extern "C" fn LLVMCreateMemoryBufferWithContentsOfFile(
    Path: *const ::libc::c_char,
    OutMemBuf: *mut LLVMMemoryBufferRef,
    OutMessage: *mut *mut ::libc::c_char,
) -> LLVMBool {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    *const ::libc::c_char,
                    *mut LLVMMemoryBufferRef,
                    *mut *mut ::libc::c_char,
                ) -> LLVMBool,
            >(stringify!(LLVMCreateMemoryBufferWithContentsOfFile).as_bytes())
    }
        .expect(stringify!(LLVMCreateMemoryBufferWithContentsOfFile));
    entry(Path, OutMemBuf, OutMessage)
}
#[no_mangle]
pub extern "C" fn LLVMOrcLLJITAddLLVMIRModule(
    J: LLVMOrcLLJITRef,
    JD: LLVMOrcJITDylibRef,
    TSM: LLVMOrcThreadSafeModuleRef,
) -> LLVMErrorRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMOrcLLJITRef,
                    LLVMOrcJITDylibRef,
                    LLVMOrcThreadSafeModuleRef,
                ) -> LLVMErrorRef,
            >(stringify!(LLVMOrcLLJITAddLLVMIRModule).as_bytes())
    }
        .expect(stringify!(LLVMOrcLLJITAddLLVMIRModule));
    entry(J, JD, TSM)
}
#[no_mangle]
pub extern "C" fn LLVMBuildGlobalStringPtr(
    B: LLVMBuilderRef,
    Str: *const ::libc::c_char,
    Name: *const ::libc::c_char,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMBuilderRef,
                    *const ::libc::c_char,
                    *const ::libc::c_char,
                ) -> LLVMValueRef,
            >(stringify!(LLVMBuildGlobalStringPtr).as_bytes())
    }
        .expect(stringify!(LLVMBuildGlobalStringPtr));
    entry(B, Str, Name)
}
#[no_mangle]
pub extern "C" fn LLVMDIBuilderFinalizeSubprogram(
    Builder: LLVMDIBuilderRef,
    Subprogram: LLVMMetadataRef,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMDIBuilderRef, LLVMMetadataRef),
            >(stringify!(LLVMDIBuilderFinalizeSubprogram).as_bytes())
    }
        .expect(stringify!(LLVMDIBuilderFinalizeSubprogram));
    entry(Builder, Subprogram)
}
#[no_mangle]
pub extern "C" fn LLVMDisposeExecutionEngine(EE: LLVMExecutionEngineRef) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMExecutionEngineRef),
            >(stringify!(LLVMDisposeExecutionEngine).as_bytes())
    }
        .expect(stringify!(LLVMDisposeExecutionEngine));
    entry(EE)
}
#[no_mangle]
pub extern "C" fn LLVMBuildIntToPtr(
    arg1: LLVMBuilderRef,
    Val: LLVMValueRef,
    DestTy: LLVMTypeRef,
    Name: *const ::libc::c_char,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMBuilderRef,
                    LLVMValueRef,
                    LLVMTypeRef,
                    *const ::libc::c_char,
                ) -> LLVMValueRef,
            >(stringify!(LLVMBuildIntToPtr).as_bytes())
    }
        .expect(stringify!(LLVMBuildIntToPtr));
    entry(arg1, Val, DestTy, Name)
}
#[no_mangle]
pub extern "C" fn lto_module_dispose(_mod: lto_module_t) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(lto_module_t),
            >(stringify!(lto_module_dispose).as_bytes())
    }
        .expect(stringify!(lto_module_dispose));
    entry(_mod)
}
#[no_mangle]
pub extern "C" fn LLVMInitializeBPFTargetMC() {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<extern "C" fn()>(stringify!(LLVMInitializeBPFTargetMC).as_bytes())
    }
        .expect(stringify!(LLVMInitializeBPFTargetMC));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMInitializeWebAssemblyAsmPrinter() {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(),
            >(stringify!(LLVMInitializeWebAssemblyAsmPrinter).as_bytes())
    }
        .expect(stringify!(LLVMInitializeWebAssemblyAsmPrinter));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMIsAFPToSIInst(Val: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMIsAFPToSIInst).as_bytes())
    }
        .expect(stringify!(LLVMIsAFPToSIInst));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn LLVMGetNextTarget(T: LLVMTargetRef) -> LLVMTargetRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMTargetRef) -> LLVMTargetRef,
            >(stringify!(LLVMGetNextTarget).as_bytes())
    }
        .expect(stringify!(LLVMGetNextTarget));
    entry(T)
}
#[no_mangle]
pub extern "C" fn LLVMPassBuilderOptionsSetLicmMssaNoAccForPromotionCap(
    Options: LLVMPassBuilderOptionsRef,
    LicmMssaNoAccForPromotionCap: ::libc::c_uint,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMPassBuilderOptionsRef, ::libc::c_uint),
            >(
                stringify!(LLVMPassBuilderOptionsSetLicmMssaNoAccForPromotionCap)
                    .as_bytes(),
            )
    }
        .expect(stringify!(LLVMPassBuilderOptionsSetLicmMssaNoAccForPromotionCap));
    entry(Options, LicmMssaNoAccForPromotionCap)
}
#[no_mangle]
pub extern "C" fn thinlto_codegen_set_cache_size_bytes(
    cg: thinlto_code_gen_t,
    max_size_bytes: ::libc::c_uint,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(thinlto_code_gen_t, ::libc::c_uint),
            >(stringify!(thinlto_codegen_set_cache_size_bytes).as_bytes())
    }
        .expect(stringify!(thinlto_codegen_set_cache_size_bytes));
    entry(cg, max_size_bytes)
}
#[no_mangle]
pub extern "C" fn LLVMIsAInsertValueInst(Val: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMIsAInsertValueInst).as_bytes())
    }
        .expect(stringify!(LLVMIsAInsertValueInst));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn lto_module_create_in_codegen_context(
    mem: *const ::libc::c_void,
    length: ::libc::size_t,
    path: *const ::libc::c_char,
    cg: lto_code_gen_t,
) -> lto_module_t {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    *const ::libc::c_void,
                    ::libc::size_t,
                    *const ::libc::c_char,
                    lto_code_gen_t,
                ) -> lto_module_t,
            >(stringify!(lto_module_create_in_codegen_context).as_bytes())
    }
        .expect(stringify!(lto_module_create_in_codegen_context));
    entry(mem, length, path, cg)
}
#[no_mangle]
pub extern "C" fn LLVMGetErrorMessage(Error: LLVMErrorRef) -> *mut ::libc::c_char {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMErrorRef) -> *mut ::libc::c_char,
            >(stringify!(LLVMGetErrorMessage).as_bytes())
    }
        .expect(stringify!(LLVMGetErrorMessage));
    entry(Error)
}
#[no_mangle]
pub extern "C" fn LLVMSetInstrParamAlignment(
    Instr: LLVMValueRef,
    Idx: LLVMAttributeIndex,
    Align: ::libc::c_uint,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, LLVMAttributeIndex, ::libc::c_uint),
            >(stringify!(LLVMSetInstrParamAlignment).as_bytes())
    }
        .expect(stringify!(LLVMSetInstrParamAlignment));
    entry(Instr, Idx, Align)
}
#[no_mangle]
pub extern "C" fn LLVMDisposeModuleFlagsMetadata(Entries: *mut LLVMModuleFlagEntry) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(*mut LLVMModuleFlagEntry),
            >(stringify!(LLVMDisposeModuleFlagsMetadata).as_bytes())
    }
        .expect(stringify!(LLVMDisposeModuleFlagsMetadata));
    entry(Entries)
}
#[no_mangle]
pub extern "C" fn LLVMGetRelocationTypeName(
    RI: LLVMRelocationIteratorRef,
) -> *const ::libc::c_char {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMRelocationIteratorRef) -> *const ::libc::c_char,
            >(stringify!(LLVMGetRelocationTypeName).as_bytes())
    }
        .expect(stringify!(LLVMGetRelocationTypeName));
    entry(RI)
}
#[no_mangle]
pub extern "C" fn LLVMDbgVariableRecordGetVariable(
    Rec: LLVMDbgRecordRef,
) -> LLVMMetadataRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMDbgRecordRef) -> LLVMMetadataRef,
            >(stringify!(LLVMDbgVariableRecordGetVariable).as_bytes())
    }
        .expect(stringify!(LLVMDbgVariableRecordGetVariable));
    entry(Rec)
}
#[no_mangle]
pub extern "C" fn LLVMGetSymbols(
    ObjectFile: LLVMObjectFileRef,
) -> LLVMSymbolIteratorRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMObjectFileRef) -> LLVMSymbolIteratorRef,
            >(stringify!(LLVMGetSymbols).as_bytes())
    }
        .expect(stringify!(LLVMGetSymbols));
    entry(ObjectFile)
}
#[no_mangle]
pub extern "C" fn LLVMInitializeSparcTarget() {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<extern "C" fn()>(stringify!(LLVMInitializeSparcTarget).as_bytes())
    }
        .expect(stringify!(LLVMInitializeSparcTarget));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMIsABinaryOperator(Val: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMIsABinaryOperator).as_bytes())
    }
        .expect(stringify!(LLVMIsABinaryOperator));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn LLVMFloatType() -> LLVMTypeRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<extern "C" fn() -> LLVMTypeRef>(stringify!(LLVMFloatType).as_bytes())
    }
        .expect(stringify!(LLVMFloatType));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMBuildPtrToInt(
    arg1: LLVMBuilderRef,
    Val: LLVMValueRef,
    DestTy: LLVMTypeRef,
    Name: *const ::libc::c_char,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMBuilderRef,
                    LLVMValueRef,
                    LLVMTypeRef,
                    *const ::libc::c_char,
                ) -> LLVMValueRef,
            >(stringify!(LLVMBuildPtrToInt).as_bytes())
    }
        .expect(stringify!(LLVMBuildPtrToInt));
    entry(arg1, Val, DestTy, Name)
}
#[no_mangle]
pub extern "C" fn LLVMStopMultithreaded() {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<extern "C" fn()>(stringify!(LLVMStopMultithreaded).as_bytes())
    }
        .expect(stringify!(LLVMStopMultithreaded));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMOrcCreateCustomCAPIDefinitionGenerator(
    F: LLVMOrcCAPIDefinitionGeneratorTryToGenerateFunction,
    Ctx: *mut ::libc::c_void,
    Dispose: LLVMOrcDisposeCAPIDefinitionGeneratorFunction,
) -> LLVMOrcDefinitionGeneratorRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMOrcCAPIDefinitionGeneratorTryToGenerateFunction,
                    *mut ::libc::c_void,
                    LLVMOrcDisposeCAPIDefinitionGeneratorFunction,
                ) -> LLVMOrcDefinitionGeneratorRef,
            >(stringify!(LLVMOrcCreateCustomCAPIDefinitionGenerator).as_bytes())
    }
        .expect(stringify!(LLVMOrcCreateCustomCAPIDefinitionGenerator));
    entry(F, Ctx, Dispose)
}
#[no_mangle]
pub extern "C" fn LLVMOrcCreateLocalLazyCallThroughManager(
    TargetTriple: *const ::libc::c_char,
    ES: LLVMOrcExecutionSessionRef,
    ErrorHandlerAddr: LLVMOrcJITTargetAddress,
    LCTM: *mut LLVMOrcLazyCallThroughManagerRef,
) -> LLVMErrorRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    *const ::libc::c_char,
                    LLVMOrcExecutionSessionRef,
                    LLVMOrcJITTargetAddress,
                    *mut LLVMOrcLazyCallThroughManagerRef,
                ) -> LLVMErrorRef,
            >(stringify!(LLVMOrcCreateLocalLazyCallThroughManager).as_bytes())
    }
        .expect(stringify!(LLVMOrcCreateLocalLazyCallThroughManager));
    entry(TargetTriple, ES, ErrorHandlerAddr, LCTM)
}
#[no_mangle]
pub extern "C" fn LLVMX86FP80Type() -> LLVMTypeRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn() -> LLVMTypeRef,
            >(stringify!(LLVMX86FP80Type).as_bytes())
    }
        .expect(stringify!(LLVMX86FP80Type));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMGetTargetExtTypeNumIntParams(
    TargetExtTy: LLVMTypeRef,
) -> ::libc::c_uint {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMTypeRef) -> ::libc::c_uint,
            >(stringify!(LLVMGetTargetExtTypeNumIntParams).as_bytes())
    }
        .expect(stringify!(LLVMGetTargetExtTypeNumIntParams));
    entry(TargetExtTy)
}
#[no_mangle]
pub extern "C" fn LLVMConstAllOnes(Ty: LLVMTypeRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMTypeRef) -> LLVMValueRef,
            >(stringify!(LLVMConstAllOnes).as_bytes())
    }
        .expect(stringify!(LLVMConstAllOnes));
    entry(Ty)
}
#[no_mangle]
pub extern "C" fn LLVMDIBuilderCreateExpression(
    Builder: LLVMDIBuilderRef,
    Addr: *mut u64,
    Length: ::libc::size_t,
) -> LLVMMetadataRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMDIBuilderRef,
                    *mut u64,
                    ::libc::size_t,
                ) -> LLVMMetadataRef,
            >(stringify!(LLVMDIBuilderCreateExpression).as_bytes())
    }
        .expect(stringify!(LLVMDIBuilderCreateExpression));
    entry(Builder, Addr, Length)
}
#[no_mangle]
pub extern "C" fn thinlto_codegen_set_codegen_only(
    cg: thinlto_code_gen_t,
    codegen_only: lto_bool_t,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(thinlto_code_gen_t, lto_bool_t),
            >(stringify!(thinlto_codegen_set_codegen_only).as_bytes())
    }
        .expect(stringify!(thinlto_codegen_set_codegen_only));
    entry(cg, codegen_only)
}
#[no_mangle]
pub extern "C" fn LLVMGetNamedGlobalWithLength(
    M: LLVMModuleRef,
    Name: *const ::libc::c_char,
    Length: ::libc::size_t,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMModuleRef,
                    *const ::libc::c_char,
                    ::libc::size_t,
                ) -> LLVMValueRef,
            >(stringify!(LLVMGetNamedGlobalWithLength).as_bytes())
    }
        .expect(stringify!(LLVMGetNamedGlobalWithLength));
    entry(M, Name, Length)
}
#[no_mangle]
pub extern "C" fn llvm_blake3_version() -> *const ::libc::c_char {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn() -> *const ::libc::c_char,
            >(stringify!(llvm_blake3_version).as_bytes())
    }
        .expect(stringify!(llvm_blake3_version));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMGetUnnamedAddress(Global: LLVMValueRef) -> LLVMUnnamedAddr {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMUnnamedAddr,
            >(stringify!(LLVMGetUnnamedAddress).as_bytes())
    }
        .expect(stringify!(LLVMGetUnnamedAddress));
    entry(Global)
}
#[no_mangle]
pub extern "C" fn LLVMGetFunctionAddress(
    EE: LLVMExecutionEngineRef,
    Name: *const ::libc::c_char,
) -> u64 {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMExecutionEngineRef, *const ::libc::c_char) -> u64,
            >(stringify!(LLVMGetFunctionAddress).as_bytes())
    }
        .expect(stringify!(LLVMGetFunctionAddress));
    entry(EE, Name)
}
#[no_mangle]
pub extern "C" fn LLVMGetEnumAttributeKind(A: LLVMAttributeRef) -> ::libc::c_uint {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMAttributeRef) -> ::libc::c_uint,
            >(stringify!(LLVMGetEnumAttributeKind).as_bytes())
    }
        .expect(stringify!(LLVMGetEnumAttributeKind));
    entry(A)
}
#[no_mangle]
pub extern "C" fn LLVMGetOrInsertFunction(
    M: LLVMModuleRef,
    Name: *const ::libc::c_char,
    NameLen: ::libc::size_t,
    FunctionTy: LLVMTypeRef,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMModuleRef,
                    *const ::libc::c_char,
                    ::libc::size_t,
                    LLVMTypeRef,
                ) -> LLVMValueRef,
            >(stringify!(LLVMGetOrInsertFunction).as_bytes())
    }
        .expect(stringify!(LLVMGetOrInsertFunction));
    entry(M, Name, NameLen, FunctionTy)
}
#[no_mangle]
pub extern "C" fn LLVMInitializeHexagonTargetInfo() {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(),
            >(stringify!(LLVMInitializeHexagonTargetInfo).as_bytes())
    }
        .expect(stringify!(LLVMInitializeHexagonTargetInfo));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMGetPoison(Ty: LLVMTypeRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMTypeRef) -> LLVMValueRef,
            >(stringify!(LLVMGetPoison).as_bytes())
    }
        .expect(stringify!(LLVMGetPoison));
    entry(Ty)
}
#[no_mangle]
pub extern "C" fn LVMDbgVariableRecordGetExpression(
    Rec: LLVMDbgRecordRef,
) -> LLVMMetadataRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMDbgRecordRef) -> LLVMMetadataRef,
            >(stringify!(LVMDbgVariableRecordGetExpression).as_bytes())
    }
        .expect(stringify!(LVMDbgVariableRecordGetExpression));
    entry(Rec)
}
#[no_mangle]
pub extern "C" fn LLVMConstArray2(
    ElementTy: LLVMTypeRef,
    ConstantVals: *mut LLVMValueRef,
    Length: u64,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMTypeRef, *mut LLVMValueRef, u64) -> LLVMValueRef,
            >(stringify!(LLVMConstArray2).as_bytes())
    }
        .expect(stringify!(LLVMConstArray2));
    entry(ElementTy, ConstantVals, Length)
}
#[no_mangle]
pub extern "C" fn LLVMSetModuleInlineAsm2(
    M: LLVMModuleRef,
    Asm: *const ::libc::c_char,
    Len: ::libc::size_t,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMModuleRef, *const ::libc::c_char, ::libc::size_t),
            >(stringify!(LLVMSetModuleInlineAsm2).as_bytes())
    }
        .expect(stringify!(LLVMSetModuleInlineAsm2));
    entry(M, Asm, Len)
}
#[no_mangle]
pub extern "C" fn LLVMIsAAtomicCmpXchgInst(Val: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMIsAAtomicCmpXchgInst).as_bytes())
    }
        .expect(stringify!(LLVMIsAAtomicCmpXchgInst));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn lto_input_get_dependent_library(
    input: lto_input_t,
    index: ::libc::size_t,
    size: *mut ::libc::size_t,
) -> *const ::libc::c_char {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    lto_input_t,
                    ::libc::size_t,
                    *mut ::libc::size_t,
                ) -> *const ::libc::c_char,
            >(stringify!(lto_input_get_dependent_library).as_bytes())
    }
        .expect(stringify!(lto_input_get_dependent_library));
    entry(input, index, size)
}
#[no_mangle]
pub extern "C" fn LLVMDeleteFunction(Fn: LLVMValueRef) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef),
            >(stringify!(LLVMDeleteFunction).as_bytes())
    }
        .expect(stringify!(LLVMDeleteFunction));
    entry(Fn)
}
#[no_mangle]
pub extern "C" fn LLVMBuildCleanupRet(
    B: LLVMBuilderRef,
    CatchPad: LLVMValueRef,
    BB: LLVMBasicBlockRef,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMBuilderRef,
                    LLVMValueRef,
                    LLVMBasicBlockRef,
                ) -> LLVMValueRef,
            >(stringify!(LLVMBuildCleanupRet).as_bytes())
    }
        .expect(stringify!(LLVMBuildCleanupRet));
    entry(B, CatchPad, BB)
}
#[no_mangle]
pub extern "C" fn LLVMGetNUW(ArithInst: LLVMValueRef) -> LLVMBool {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMBool,
            >(stringify!(LLVMGetNUW).as_bytes())
    }
        .expect(stringify!(LLVMGetNUW));
    entry(ArithInst)
}
#[no_mangle]
pub extern "C" fn LLVMInitializePowerPCDisassembler() {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(),
            >(stringify!(LLVMInitializePowerPCDisassembler).as_bytes())
    }
        .expect(stringify!(LLVMInitializePowerPCDisassembler));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMContextSetDiagnosticHandler(
    C: LLVMContextRef,
    Handler: LLVMDiagnosticHandler,
    DiagnosticContext: *mut ::libc::c_void,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMContextRef, LLVMDiagnosticHandler, *mut ::libc::c_void),
            >(stringify!(LLVMContextSetDiagnosticHandler).as_bytes())
    }
        .expect(stringify!(LLVMContextSetDiagnosticHandler));
    entry(C, Handler, DiagnosticContext)
}
#[no_mangle]
pub extern "C" fn LLVMOrcCreateCustomMaterializationUnit(
    Name: *const ::libc::c_char,
    Ctx: *mut ::libc::c_void,
    Syms: LLVMOrcCSymbolFlagsMapPairs,
    NumSyms: ::libc::size_t,
    InitSym: LLVMOrcSymbolStringPoolEntryRef,
    Materialize: LLVMOrcMaterializationUnitMaterializeFunction,
    Discard: LLVMOrcMaterializationUnitDiscardFunction,
    Destroy: LLVMOrcMaterializationUnitDestroyFunction,
) -> LLVMOrcMaterializationUnitRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    *const ::libc::c_char,
                    *mut ::libc::c_void,
                    LLVMOrcCSymbolFlagsMapPairs,
                    ::libc::size_t,
                    LLVMOrcSymbolStringPoolEntryRef,
                    LLVMOrcMaterializationUnitMaterializeFunction,
                    LLVMOrcMaterializationUnitDiscardFunction,
                    LLVMOrcMaterializationUnitDestroyFunction,
                ) -> LLVMOrcMaterializationUnitRef,
            >(stringify!(LLVMOrcCreateCustomMaterializationUnit).as_bytes())
    }
        .expect(stringify!(LLVMOrcCreateCustomMaterializationUnit));
    entry(Name, Ctx, Syms, NumSyms, InitSym, Materialize, Discard, Destroy)
}
#[no_mangle]
pub extern "C" fn LLVMGetInlineAsm(
    Ty: LLVMTypeRef,
    AsmString: *const ::libc::c_char,
    AsmStringSize: ::libc::size_t,
    Constraints: *const ::libc::c_char,
    ConstraintsSize: ::libc::size_t,
    HasSideEffects: LLVMBool,
    IsAlignStack: LLVMBool,
    Dialect: LLVMInlineAsmDialect,
    CanThrow: LLVMBool,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMTypeRef,
                    *const ::libc::c_char,
                    ::libc::size_t,
                    *const ::libc::c_char,
                    ::libc::size_t,
                    LLVMBool,
                    LLVMBool,
                    LLVMInlineAsmDialect,
                    LLVMBool,
                ) -> LLVMValueRef,
            >(stringify!(LLVMGetInlineAsm).as_bytes())
    }
        .expect(stringify!(LLVMGetInlineAsm));
    entry(
        Ty,
        AsmString,
        AsmStringSize,
        Constraints,
        ConstraintsSize,
        HasSideEffects,
        IsAlignStack,
        Dialect,
        CanThrow,
    )
}
#[no_mangle]
pub extern "C" fn LLVMSetNSW(ArithInst: LLVMValueRef, HasNSW: LLVMBool) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, LLVMBool),
            >(stringify!(LLVMSetNSW).as_bytes())
    }
        .expect(stringify!(LLVMSetNSW));
    entry(ArithInst, HasNSW)
}
#[no_mangle]
pub extern "C" fn llvm_blake3_hasher_update(
    hasher: *mut llvm_blake3_hasher,
    input: *const ::libc::c_void,
    input_len: usize,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(*mut llvm_blake3_hasher, *const ::libc::c_void, usize),
            >(stringify!(llvm_blake3_hasher_update).as_bytes())
    }
        .expect(stringify!(llvm_blake3_hasher_update));
    entry(hasher, input, input_len)
}
#[no_mangle]
pub extern "C" fn LLVMOrcDisposeMaterializationResponsibility(
    MR: LLVMOrcMaterializationResponsibilityRef,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMOrcMaterializationResponsibilityRef),
            >(stringify!(LLVMOrcDisposeMaterializationResponsibility).as_bytes())
    }
        .expect(stringify!(LLVMOrcDisposeMaterializationResponsibility));
    entry(MR)
}
#[no_mangle]
pub extern "C" fn LLVMDisposeSectionIterator(SI: LLVMSectionIteratorRef) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMSectionIteratorRef),
            >(stringify!(LLVMDisposeSectionIterator).as_bytes())
    }
        .expect(stringify!(LLVMDisposeSectionIterator));
    entry(SI)
}
#[no_mangle]
pub extern "C" fn LLVMGetInstructionOpcode(Inst: LLVMValueRef) -> LLVMOpcode {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMOpcode,
            >(stringify!(LLVMGetInstructionOpcode).as_bytes())
    }
        .expect(stringify!(LLVMGetInstructionOpcode));
    entry(Inst)
}
#[no_mangle]
pub extern "C" fn LLVMBuildPointerCast(
    arg1: LLVMBuilderRef,
    Val: LLVMValueRef,
    DestTy: LLVMTypeRef,
    Name: *const ::libc::c_char,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMBuilderRef,
                    LLVMValueRef,
                    LLVMTypeRef,
                    *const ::libc::c_char,
                ) -> LLVMValueRef,
            >(stringify!(LLVMBuildPointerCast).as_bytes())
    }
        .expect(stringify!(LLVMBuildPointerCast));
    entry(arg1, Val, DestTy, Name)
}
#[no_mangle]
pub extern "C" fn LLVMConstReal(
    RealTy: LLVMTypeRef,
    N: ::libc::c_double,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMTypeRef, ::libc::c_double) -> LLVMValueRef,
            >(stringify!(LLVMConstReal).as_bytes())
    }
        .expect(stringify!(LLVMConstReal));
    entry(RealTy, N)
}
#[no_mangle]
pub extern "C" fn LLVMSetPrologueData(Fn: LLVMValueRef, prologueData: LLVMValueRef) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, LLVMValueRef),
            >(stringify!(LLVMSetPrologueData).as_bytes())
    }
        .expect(stringify!(LLVMSetPrologueData));
    entry(Fn, prologueData)
}
#[no_mangle]
pub extern "C" fn LLVMDbgRecordGetKind(Rec: LLVMDbgRecordRef) -> LLVMDbgRecordKind {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMDbgRecordRef) -> LLVMDbgRecordKind,
            >(stringify!(LLVMDbgRecordGetKind).as_bytes())
    }
        .expect(stringify!(LLVMDbgRecordGetKind));
    entry(Rec)
}
#[no_mangle]
pub extern "C" fn LLVMDisposeErrorMessage(ErrMsg: *mut ::libc::c_char) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(*mut ::libc::c_char),
            >(stringify!(LLVMDisposeErrorMessage).as_bytes())
    }
        .expect(stringify!(LLVMDisposeErrorMessage));
    entry(ErrMsg)
}
#[no_mangle]
pub extern "C" fn LLVMBuildSelect(
    arg1: LLVMBuilderRef,
    If: LLVMValueRef,
    Then: LLVMValueRef,
    Else: LLVMValueRef,
    Name: *const ::libc::c_char,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMBuilderRef,
                    LLVMValueRef,
                    LLVMValueRef,
                    LLVMValueRef,
                    *const ::libc::c_char,
                ) -> LLVMValueRef,
            >(stringify!(LLVMBuildSelect).as_bytes())
    }
        .expect(stringify!(LLVMBuildSelect));
    entry(arg1, If, Then, Else, Name)
}
#[no_mangle]
pub extern "C" fn LLVMInitializeSystemZDisassembler() {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(),
            >(stringify!(LLVMInitializeSystemZDisassembler).as_bytes())
    }
        .expect(stringify!(LLVMInitializeSystemZDisassembler));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMCreateMemoryBufferWithMemoryRange(
    InputData: *const ::libc::c_char,
    InputDataLength: ::libc::size_t,
    BufferName: *const ::libc::c_char,
    RequiresNullTerminator: LLVMBool,
) -> LLVMMemoryBufferRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    *const ::libc::c_char,
                    ::libc::size_t,
                    *const ::libc::c_char,
                    LLVMBool,
                ) -> LLVMMemoryBufferRef,
            >(stringify!(LLVMCreateMemoryBufferWithMemoryRange).as_bytes())
    }
        .expect(stringify!(LLVMCreateMemoryBufferWithMemoryRange));
    entry(InputData, InputDataLength, BufferName, RequiresNullTerminator)
}
#[no_mangle]
pub extern "C" fn LLVMCreateBuilder() -> LLVMBuilderRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn() -> LLVMBuilderRef,
            >(stringify!(LLVMCreateBuilder).as_bytes())
    }
        .expect(stringify!(LLVMCreateBuilder));
    entry()
}
#[no_mangle]
pub extern "C" fn lto_api_version() -> ::libc::c_uint {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn() -> ::libc::c_uint,
            >(stringify!(lto_api_version).as_bytes())
    }
        .expect(stringify!(lto_api_version));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMIsAConstantStruct(Val: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMIsAConstantStruct).as_bytes())
    }
        .expect(stringify!(LLVMIsAConstantStruct));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn lto_codegen_debug_options(
    cg: lto_code_gen_t,
    arg1: *const ::libc::c_char,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(lto_code_gen_t, *const ::libc::c_char),
            >(stringify!(lto_codegen_debug_options).as_bytes())
    }
        .expect(stringify!(lto_codegen_debug_options));
    entry(cg, arg1)
}
#[no_mangle]
pub extern "C" fn LLVMInitializeWebAssemblyTargetInfo() {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(),
            >(stringify!(LLVMInitializeWebAssemblyTargetInfo).as_bytes())
    }
        .expect(stringify!(LLVMInitializeWebAssemblyTargetInfo));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMConstXor(
    LHSConstant: LLVMValueRef,
    RHSConstant: LLVMValueRef,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMConstXor).as_bytes())
    }
        .expect(stringify!(LLVMConstXor));
    entry(LHSConstant, RHSConstant)
}
#[no_mangle]
pub extern "C" fn LLVMInstructionGetDebugLoc(Inst: LLVMValueRef) -> LLVMMetadataRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMMetadataRef,
            >(stringify!(LLVMInstructionGetDebugLoc).as_bytes())
    }
        .expect(stringify!(LLVMInstructionGetDebugLoc));
    entry(Inst)
}
#[no_mangle]
pub extern "C" fn LLVMSetComdat(V: LLVMValueRef, C: LLVMComdatRef) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, LLVMComdatRef),
            >(stringify!(LLVMSetComdat).as_bytes())
    }
        .expect(stringify!(LLVMSetComdat));
    entry(V, C)
}
#[no_mangle]
pub extern "C" fn LLVMGetTargetExtTypeTypeParam(
    TargetExtTy: LLVMTypeRef,
    Idx: ::libc::c_uint,
) -> LLVMTypeRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMTypeRef, ::libc::c_uint) -> LLVMTypeRef,
            >(stringify!(LLVMGetTargetExtTypeTypeParam).as_bytes())
    }
        .expect(stringify!(LLVMGetTargetExtTypeTypeParam));
    entry(TargetExtTy, Idx)
}
#[no_mangle]
pub extern "C" fn LLVMIsTypeAttribute(A: LLVMAttributeRef) -> LLVMBool {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMAttributeRef) -> LLVMBool,
            >(stringify!(LLVMIsTypeAttribute).as_bytes())
    }
        .expect(stringify!(LLVMIsTypeAttribute));
    entry(A)
}
#[no_mangle]
pub extern "C" fn LLVMCopyModuleFlagsMetadata(
    M: LLVMModuleRef,
    Len: *mut ::libc::size_t,
) -> *mut LLVMModuleFlagEntry {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMModuleRef,
                    *mut ::libc::size_t,
                ) -> *mut LLVMModuleFlagEntry,
            >(stringify!(LLVMCopyModuleFlagsMetadata).as_bytes())
    }
        .expect(stringify!(LLVMCopyModuleFlagsMetadata));
    entry(M, Len)
}
#[no_mangle]
pub extern "C" fn LLVMGetCallSiteEnumAttribute(
    C: LLVMValueRef,
    Idx: LLVMAttributeIndex,
    KindID: ::libc::c_uint,
) -> LLVMAttributeRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMValueRef,
                    LLVMAttributeIndex,
                    ::libc::c_uint,
                ) -> LLVMAttributeRef,
            >(stringify!(LLVMGetCallSiteEnumAttribute).as_bytes())
    }
        .expect(stringify!(LLVMGetCallSiteEnumAttribute));
    entry(C, Idx, KindID)
}
#[no_mangle]
pub extern "C" fn LLVMBuildInvoke2(
    arg1: LLVMBuilderRef,
    Ty: LLVMTypeRef,
    Fn: LLVMValueRef,
    Args: *mut LLVMValueRef,
    NumArgs: ::libc::c_uint,
    Then: LLVMBasicBlockRef,
    Catch: LLVMBasicBlockRef,
    Name: *const ::libc::c_char,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMBuilderRef,
                    LLVMTypeRef,
                    LLVMValueRef,
                    *mut LLVMValueRef,
                    ::libc::c_uint,
                    LLVMBasicBlockRef,
                    LLVMBasicBlockRef,
                    *const ::libc::c_char,
                ) -> LLVMValueRef,
            >(stringify!(LLVMBuildInvoke2).as_bytes())
    }
        .expect(stringify!(LLVMBuildInvoke2));
    entry(arg1, Ty, Fn, Args, NumArgs, Then, Catch, Name)
}
#[no_mangle]
pub extern "C" fn LLVMGetSuccessor(
    Term: LLVMValueRef,
    i: ::libc::c_uint,
) -> LLVMBasicBlockRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, ::libc::c_uint) -> LLVMBasicBlockRef,
            >(stringify!(LLVMGetSuccessor).as_bytes())
    }
        .expect(stringify!(LLVMGetSuccessor));
    entry(Term, i)
}
#[no_mangle]
pub extern "C" fn LLVMBlockAddress(
    F: LLVMValueRef,
    BB: LLVMBasicBlockRef,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, LLVMBasicBlockRef) -> LLVMValueRef,
            >(stringify!(LLVMBlockAddress).as_bytes())
    }
        .expect(stringify!(LLVMBlockAddress));
    entry(F, BB)
}
#[no_mangle]
pub extern "C" fn LLVMBuildSExtOrBitCast(
    arg1: LLVMBuilderRef,
    Val: LLVMValueRef,
    DestTy: LLVMTypeRef,
    Name: *const ::libc::c_char,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMBuilderRef,
                    LLVMValueRef,
                    LLVMTypeRef,
                    *const ::libc::c_char,
                ) -> LLVMValueRef,
            >(stringify!(LLVMBuildSExtOrBitCast).as_bytes())
    }
        .expect(stringify!(LLVMBuildSExtOrBitCast));
    entry(arg1, Val, DestTy, Name)
}
#[no_mangle]
pub extern "C" fn LLVMMoveToNextSection(SI: LLVMSectionIteratorRef) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMSectionIteratorRef),
            >(stringify!(LLVMMoveToNextSection).as_bytes())
    }
        .expect(stringify!(LLVMMoveToNextSection));
    entry(SI)
}
#[no_mangle]
pub extern "C" fn LLVMDIBuilderInsertDbgValueRecordAtEnd(
    Builder: LLVMDIBuilderRef,
    Val: LLVMValueRef,
    VarInfo: LLVMMetadataRef,
    Expr: LLVMMetadataRef,
    DebugLoc: LLVMMetadataRef,
    Block: LLVMBasicBlockRef,
) -> LLVMDbgRecordRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMDIBuilderRef,
                    LLVMValueRef,
                    LLVMMetadataRef,
                    LLVMMetadataRef,
                    LLVMMetadataRef,
                    LLVMBasicBlockRef,
                ) -> LLVMDbgRecordRef,
            >(stringify!(LLVMDIBuilderInsertDbgValueRecordAtEnd).as_bytes())
    }
        .expect(stringify!(LLVMDIBuilderInsertDbgValueRecordAtEnd));
    entry(Builder, Val, VarInfo, Expr, DebugLoc, Block)
}
#[no_mangle]
pub extern "C" fn LLVMBuildGlobalString(
    B: LLVMBuilderRef,
    Str: *const ::libc::c_char,
    Name: *const ::libc::c_char,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMBuilderRef,
                    *const ::libc::c_char,
                    *const ::libc::c_char,
                ) -> LLVMValueRef,
            >(stringify!(LLVMBuildGlobalString).as_bytes())
    }
        .expect(stringify!(LLVMBuildGlobalString));
    entry(B, Str, Name)
}
#[no_mangle]
pub extern "C" fn LLVMStructType(
    ElementTypes: *mut LLVMTypeRef,
    ElementCount: ::libc::c_uint,
    Packed: LLVMBool,
) -> LLVMTypeRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(*mut LLVMTypeRef, ::libc::c_uint, LLVMBool) -> LLVMTypeRef,
            >(stringify!(LLVMStructType).as_bytes())
    }
        .expect(stringify!(LLVMStructType));
    entry(ElementTypes, ElementCount, Packed)
}
#[no_mangle]
pub extern "C" fn LLVMLabelType() -> LLVMTypeRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<extern "C" fn() -> LLVMTypeRef>(stringify!(LLVMLabelType).as_bytes())
    }
        .expect(stringify!(LLVMLabelType));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMConstNSWNeg(ConstantVal: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMConstNSWNeg).as_bytes())
    }
        .expect(stringify!(LLVMConstNSWNeg));
    entry(ConstantVal)
}
#[no_mangle]
pub extern "C" fn LLVMDIBuilderCreateImportedModuleFromAlias(
    Builder: LLVMDIBuilderRef,
    Scope: LLVMMetadataRef,
    ImportedEntity: LLVMMetadataRef,
    File: LLVMMetadataRef,
    Line: ::libc::c_uint,
    Elements: *mut LLVMMetadataRef,
    NumElements: ::libc::c_uint,
) -> LLVMMetadataRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMDIBuilderRef,
                    LLVMMetadataRef,
                    LLVMMetadataRef,
                    LLVMMetadataRef,
                    ::libc::c_uint,
                    *mut LLVMMetadataRef,
                    ::libc::c_uint,
                ) -> LLVMMetadataRef,
            >(stringify!(LLVMDIBuilderCreateImportedModuleFromAlias).as_bytes())
    }
        .expect(stringify!(LLVMDIBuilderCreateImportedModuleFromAlias));
    entry(Builder, Scope, ImportedEntity, File, Line, Elements, NumElements)
}
#[no_mangle]
pub extern "C" fn LLVMCreateFunctionPassManager(
    MP: LLVMModuleProviderRef,
) -> LLVMPassManagerRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMModuleProviderRef) -> LLVMPassManagerRef,
            >(stringify!(LLVMCreateFunctionPassManager).as_bytes())
    }
        .expect(stringify!(LLVMCreateFunctionPassManager));
    entry(MP)
}
#[no_mangle]
pub extern "C" fn LLVMDIVariableGetLine(Var: LLVMMetadataRef) -> ::libc::c_uint {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMMetadataRef) -> ::libc::c_uint,
            >(stringify!(LLVMDIVariableGetLine).as_bytes())
    }
        .expect(stringify!(LLVMDIVariableGetLine));
    entry(Var)
}
#[no_mangle]
pub extern "C" fn LLVMAddGlobalMapping(
    EE: LLVMExecutionEngineRef,
    Global: LLVMValueRef,
    Addr: *mut ::libc::c_void,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMExecutionEngineRef, LLVMValueRef, *mut ::libc::c_void),
            >(stringify!(LLVMAddGlobalMapping).as_bytes())
    }
        .expect(stringify!(LLVMAddGlobalMapping));
    entry(EE, Global, Addr)
}
#[no_mangle]
pub extern "C" fn LLVMInitializeHexagonDisassembler() {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(),
            >(stringify!(LLVMInitializeHexagonDisassembler).as_bytes())
    }
        .expect(stringify!(LLVMInitializeHexagonDisassembler));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMResetFatalErrorHandler() {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<extern "C" fn()>(stringify!(LLVMResetFatalErrorHandler).as_bytes())
    }
        .expect(stringify!(LLVMResetFatalErrorHandler));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMLabelTypeInContext(C: LLVMContextRef) -> LLVMTypeRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMContextRef) -> LLVMTypeRef,
            >(stringify!(LLVMLabelTypeInContext).as_bytes())
    }
        .expect(stringify!(LLVMLabelTypeInContext));
    entry(C)
}
#[no_mangle]
pub extern "C" fn LLVMIsACatchReturnInst(Val: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMIsACatchReturnInst).as_bytes())
    }
        .expect(stringify!(LLVMIsACatchReturnInst));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn LLVMGetBufferSize(MemBuf: LLVMMemoryBufferRef) -> ::libc::size_t {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMMemoryBufferRef) -> ::libc::size_t,
            >(stringify!(LLVMGetBufferSize).as_bytes())
    }
        .expect(stringify!(LLVMGetBufferSize));
    entry(MemBuf)
}
#[no_mangle]
pub extern "C" fn lto_module_get_linkeropts(
    _mod: lto_module_t,
) -> *const ::libc::c_char {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(lto_module_t) -> *const ::libc::c_char,
            >(stringify!(lto_module_get_linkeropts).as_bytes())
    }
        .expect(stringify!(lto_module_get_linkeropts));
    entry(_mod)
}
#[no_mangle]
pub extern "C" fn LLVMOrcLLJITGetObjTransformLayer(
    J: LLVMOrcLLJITRef,
) -> LLVMOrcObjectTransformLayerRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMOrcLLJITRef) -> LLVMOrcObjectTransformLayerRef,
            >(stringify!(LLVMOrcLLJITGetObjTransformLayer).as_bytes())
    }
        .expect(stringify!(LLVMOrcLLJITGetObjTransformLayer));
    entry(J)
}
#[no_mangle]
pub extern "C" fn LLVMIsACastInst(Val: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMIsACastInst).as_bytes())
    }
        .expect(stringify!(LLVMIsACastInst));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn LLVMInitializeHexagonAsmPrinter() {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(),
            >(stringify!(LLVMInitializeHexagonAsmPrinter).as_bytes())
    }
        .expect(stringify!(LLVMInitializeHexagonAsmPrinter));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMGetPointerAddressSpace(PointerTy: LLVMTypeRef) -> ::libc::c_uint {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMTypeRef) -> ::libc::c_uint,
            >(stringify!(LLVMGetPointerAddressSpace).as_bytes())
    }
        .expect(stringify!(LLVMGetPointerAddressSpace));
    entry(PointerTy)
}
#[no_mangle]
pub extern "C" fn lto_module_get_target_triple(
    _mod: lto_module_t,
) -> *const ::libc::c_char {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(lto_module_t) -> *const ::libc::c_char,
            >(stringify!(lto_module_get_target_triple).as_bytes())
    }
        .expect(stringify!(lto_module_get_target_triple));
    entry(_mod)
}
#[no_mangle]
pub extern "C" fn LLVMPPCFP128TypeInContext(C: LLVMContextRef) -> LLVMTypeRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMContextRef) -> LLVMTypeRef,
            >(stringify!(LLVMPPCFP128TypeInContext).as_bytes())
    }
        .expect(stringify!(LLVMPPCFP128TypeInContext));
    entry(C)
}
#[no_mangle]
pub extern "C" fn LLVMInsertBasicBlock(
    InsertBeforeBB: LLVMBasicBlockRef,
    Name: *const ::libc::c_char,
) -> LLVMBasicBlockRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMBasicBlockRef,
                    *const ::libc::c_char,
                ) -> LLVMBasicBlockRef,
            >(stringify!(LLVMInsertBasicBlock).as_bytes())
    }
        .expect(stringify!(LLVMInsertBasicBlock));
    entry(InsertBeforeBB, Name)
}
#[no_mangle]
pub extern "C" fn LLVMGetIndices(Inst: LLVMValueRef) -> *const ::libc::c_uint {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> *const ::libc::c_uint,
            >(stringify!(LLVMGetIndices).as_bytes())
    }
        .expect(stringify!(LLVMGetIndices));
    entry(Inst)
}
#[no_mangle]
pub extern "C" fn LLVMGetRelocationValueString(
    RI: LLVMRelocationIteratorRef,
) -> *const ::libc::c_char {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMRelocationIteratorRef) -> *const ::libc::c_char,
            >(stringify!(LLVMGetRelocationValueString).as_bytes())
    }
        .expect(stringify!(LLVMGetRelocationValueString));
    entry(RI)
}
#[no_mangle]
pub extern "C" fn LLVMInitializeNVPTXTarget() {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<extern "C" fn()>(stringify!(LLVMInitializeNVPTXTarget).as_bytes())
    }
        .expect(stringify!(LLVMInitializeNVPTXTarget));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMInitializeARMAsmParser() {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<extern "C" fn()>(stringify!(LLVMInitializeARMAsmParser).as_bytes())
    }
        .expect(stringify!(LLVMInitializeARMAsmParser));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMAliasSetAliasee(Alias: LLVMValueRef, Aliasee: LLVMValueRef) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, LLVMValueRef),
            >(stringify!(LLVMAliasSetAliasee).as_bytes())
    }
        .expect(stringify!(LLVMAliasSetAliasee));
    entry(Alias, Aliasee)
}
#[no_mangle]
pub extern "C" fn LLVMStructCreateNamed(
    C: LLVMContextRef,
    Name: *const ::libc::c_char,
) -> LLVMTypeRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMContextRef, *const ::libc::c_char) -> LLVMTypeRef,
            >(stringify!(LLVMStructCreateNamed).as_bytes())
    }
        .expect(stringify!(LLVMStructCreateNamed));
    entry(C, Name)
}
#[no_mangle]
pub extern "C" fn LLVMGEPSetNoWrapFlags(
    GEP: LLVMValueRef,
    NoWrapFlags: LLVMGEPNoWrapFlags,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, LLVMGEPNoWrapFlags),
            >(stringify!(LLVMGEPSetNoWrapFlags).as_bytes())
    }
        .expect(stringify!(LLVMGEPSetNoWrapFlags));
    entry(GEP, NoWrapFlags)
}
#[no_mangle]
pub extern "C" fn LLVMGetComdat(V: LLVMValueRef) -> LLVMComdatRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMComdatRef,
            >(stringify!(LLVMGetComdat).as_bytes())
    }
        .expect(stringify!(LLVMGetComdat));
    entry(V)
}
#[no_mangle]
pub extern "C" fn LLVMBuildFree(
    arg1: LLVMBuilderRef,
    PointerVal: LLVMValueRef,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMBuilderRef, LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMBuildFree).as_bytes())
    }
        .expect(stringify!(LLVMBuildFree));
    entry(arg1, PointerVal)
}
#[no_mangle]
pub extern "C" fn LLVMGetTypeKind(Ty: LLVMTypeRef) -> LLVMTypeKind {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMTypeRef) -> LLVMTypeKind,
            >(stringify!(LLVMGetTypeKind).as_bytes())
    }
        .expect(stringify!(LLVMGetTypeKind));
    entry(Ty)
}
#[no_mangle]
pub extern "C" fn LLVMDIBuilderCreateUnionType(
    Builder: LLVMDIBuilderRef,
    Scope: LLVMMetadataRef,
    Name: *const ::libc::c_char,
    NameLen: ::libc::size_t,
    File: LLVMMetadataRef,
    LineNumber: ::libc::c_uint,
    SizeInBits: u64,
    AlignInBits: u32,
    Flags: LLVMDIFlags,
    Elements: *mut LLVMMetadataRef,
    NumElements: ::libc::c_uint,
    RunTimeLang: ::libc::c_uint,
    UniqueId: *const ::libc::c_char,
    UniqueIdLen: ::libc::size_t,
) -> LLVMMetadataRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMDIBuilderRef,
                    LLVMMetadataRef,
                    *const ::libc::c_char,
                    ::libc::size_t,
                    LLVMMetadataRef,
                    ::libc::c_uint,
                    u64,
                    u32,
                    LLVMDIFlags,
                    *mut LLVMMetadataRef,
                    ::libc::c_uint,
                    ::libc::c_uint,
                    *const ::libc::c_char,
                    ::libc::size_t,
                ) -> LLVMMetadataRef,
            >(stringify!(LLVMDIBuilderCreateUnionType).as_bytes())
    }
        .expect(stringify!(LLVMDIBuilderCreateUnionType));
    entry(
        Builder,
        Scope,
        Name,
        NameLen,
        File,
        LineNumber,
        SizeInBits,
        AlignInBits,
        Flags,
        Elements,
        NumElements,
        RunTimeLang,
        UniqueId,
        UniqueIdLen,
    )
}
#[no_mangle]
pub extern "C" fn thinlto_codegen_process(cg: thinlto_code_gen_t) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(thinlto_code_gen_t),
            >(stringify!(thinlto_codegen_process).as_bytes())
    }
        .expect(stringify!(thinlto_codegen_process));
    entry(cg)
}
#[no_mangle]
pub extern "C" fn LLVMAddIncoming(
    PhiNode: LLVMValueRef,
    IncomingValues: *mut LLVMValueRef,
    IncomingBlocks: *mut LLVMBasicBlockRef,
    Count: ::libc::c_uint,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMValueRef,
                    *mut LLVMValueRef,
                    *mut LLVMBasicBlockRef,
                    ::libc::c_uint,
                ),
            >(stringify!(LLVMAddIncoming).as_bytes())
    }
        .expect(stringify!(LLVMAddIncoming));
    entry(PhiNode, IncomingValues, IncomingBlocks, Count)
}
#[no_mangle]
pub extern "C" fn LLVMGetBasicBlockTerminator(BB: LLVMBasicBlockRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMBasicBlockRef) -> LLVMValueRef,
            >(stringify!(LLVMGetBasicBlockTerminator).as_bytes())
    }
        .expect(stringify!(LLVMGetBasicBlockTerminator));
    entry(BB)
}
#[no_mangle]
pub extern "C" fn LLVMInitializeLoongArchTargetInfo() {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(),
            >(stringify!(LLVMInitializeLoongArchTargetInfo).as_bytes())
    }
        .expect(stringify!(LLVMInitializeLoongArchTargetInfo));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMSetLinkage(Global: LLVMValueRef, Linkage: LLVMLinkage) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, LLVMLinkage),
            >(stringify!(LLVMSetLinkage).as_bytes())
    }
        .expect(stringify!(LLVMSetLinkage));
    entry(Global, Linkage)
}
#[no_mangle]
pub extern "C" fn LLVMDIBuilderCreatePointerType(
    Builder: LLVMDIBuilderRef,
    PointeeTy: LLVMMetadataRef,
    SizeInBits: u64,
    AlignInBits: u32,
    AddressSpace: ::libc::c_uint,
    Name: *const ::libc::c_char,
    NameLen: ::libc::size_t,
) -> LLVMMetadataRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMDIBuilderRef,
                    LLVMMetadataRef,
                    u64,
                    u32,
                    ::libc::c_uint,
                    *const ::libc::c_char,
                    ::libc::size_t,
                ) -> LLVMMetadataRef,
            >(stringify!(LLVMDIBuilderCreatePointerType).as_bytes())
    }
        .expect(stringify!(LLVMDIBuilderCreatePointerType));
    entry(Builder, PointeeTy, SizeInBits, AlignInBits, AddressSpace, Name, NameLen)
}
#[no_mangle]
pub extern "C" fn LLVMDIBuilderCreateParameterVariable(
    Builder: LLVMDIBuilderRef,
    Scope: LLVMMetadataRef,
    Name: *const ::libc::c_char,
    NameLen: ::libc::size_t,
    ArgNo: ::libc::c_uint,
    File: LLVMMetadataRef,
    LineNo: ::libc::c_uint,
    Ty: LLVMMetadataRef,
    AlwaysPreserve: LLVMBool,
    Flags: LLVMDIFlags,
) -> LLVMMetadataRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMDIBuilderRef,
                    LLVMMetadataRef,
                    *const ::libc::c_char,
                    ::libc::size_t,
                    ::libc::c_uint,
                    LLVMMetadataRef,
                    ::libc::c_uint,
                    LLVMMetadataRef,
                    LLVMBool,
                    LLVMDIFlags,
                ) -> LLVMMetadataRef,
            >(stringify!(LLVMDIBuilderCreateParameterVariable).as_bytes())
    }
        .expect(stringify!(LLVMDIBuilderCreateParameterVariable));
    entry(Builder, Scope, Name, NameLen, ArgNo, File, LineNo, Ty, AlwaysPreserve, Flags)
}
#[no_mangle]
pub extern "C" fn LLVMConstIntOfString(
    IntTy: LLVMTypeRef,
    Text: *const ::libc::c_char,
    Radix: u8,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMTypeRef, *const ::libc::c_char, u8) -> LLVMValueRef,
            >(stringify!(LLVMConstIntOfString).as_bytes())
    }
        .expect(stringify!(LLVMConstIntOfString));
    entry(IntTy, Text, Radix)
}
#[no_mangle]
pub extern "C" fn LLVMGetSubprogram(Func: LLVMValueRef) -> LLVMMetadataRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMMetadataRef,
            >(stringify!(LLVMGetSubprogram).as_bytes())
    }
        .expect(stringify!(LLVMGetSubprogram));
    entry(Func)
}
#[no_mangle]
pub extern "C" fn LLVMDisposeBuilder(Builder: LLVMBuilderRef) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMBuilderRef),
            >(stringify!(LLVMDisposeBuilder).as_bytes())
    }
        .expect(stringify!(LLVMDisposeBuilder));
    entry(Builder)
}
#[no_mangle]
pub extern "C" fn LLVMGetOrInsertNamedMetadata(
    M: LLVMModuleRef,
    Name: *const ::libc::c_char,
    NameLen: ::libc::size_t,
) -> LLVMNamedMDNodeRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMModuleRef,
                    *const ::libc::c_char,
                    ::libc::size_t,
                ) -> LLVMNamedMDNodeRef,
            >(stringify!(LLVMGetOrInsertNamedMetadata).as_bytes())
    }
        .expect(stringify!(LLVMGetOrInsertNamedMetadata));
    entry(M, Name, NameLen)
}
#[no_mangle]
pub extern "C" fn LLVMPassBuilderOptionsSetInlinerThreshold(
    Options: LLVMPassBuilderOptionsRef,
    Threshold: ::libc::c_int,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMPassBuilderOptionsRef, ::libc::c_int),
            >(stringify!(LLVMPassBuilderOptionsSetInlinerThreshold).as_bytes())
    }
        .expect(stringify!(LLVMPassBuilderOptionsSetInlinerThreshold));
    entry(Options, Threshold)
}
#[no_mangle]
pub extern "C" fn LLVMGetPreviousBasicBlock(BB: LLVMBasicBlockRef) -> LLVMBasicBlockRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMBasicBlockRef) -> LLVMBasicBlockRef,
            >(stringify!(LLVMGetPreviousBasicBlock).as_bytes())
    }
        .expect(stringify!(LLVMGetPreviousBasicBlock));
    entry(BB)
}
#[no_mangle]
pub extern "C" fn LLVMInitializeLanaiAsmParser() {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<extern "C" fn()>(stringify!(LLVMInitializeLanaiAsmParser).as_bytes())
    }
        .expect(stringify!(LLVMInitializeLanaiAsmParser));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMIsAGlobalAlias(Val: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMIsAGlobalAlias).as_bytes())
    }
        .expect(stringify!(LLVMIsAGlobalAlias));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn LLVMGetNamedFunctionWithLength(
    M: LLVMModuleRef,
    Name: *const ::libc::c_char,
    Length: ::libc::size_t,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMModuleRef,
                    *const ::libc::c_char,
                    ::libc::size_t,
                ) -> LLVMValueRef,
            >(stringify!(LLVMGetNamedFunctionWithLength).as_bytes())
    }
        .expect(stringify!(LLVMGetNamedFunctionWithLength));
    entry(M, Name, Length)
}
#[no_mangle]
pub extern "C" fn LLVMBuilderGetDefaultFPMathTag(
    Builder: LLVMBuilderRef,
) -> LLVMMetadataRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMBuilderRef) -> LLVMMetadataRef,
            >(stringify!(LLVMBuilderGetDefaultFPMathTag).as_bytes())
    }
        .expect(stringify!(LLVMBuilderGetDefaultFPMathTag));
    entry(Builder)
}
#[no_mangle]
pub extern "C" fn LLVMDisposeObjectFile(ObjectFile: LLVMObjectFileRef) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMObjectFileRef),
            >(stringify!(LLVMDisposeObjectFile).as_bytes())
    }
        .expect(stringify!(LLVMDisposeObjectFile));
    entry(ObjectFile)
}
#[no_mangle]
pub extern "C" fn LLVMInitializeAMDGPUTarget() {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<extern "C" fn()>(stringify!(LLVMInitializeAMDGPUTarget).as_bytes())
    }
        .expect(stringify!(LLVMInitializeAMDGPUTarget));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMRemarkEntryGetRemarkName(
    Remark: LLVMRemarkEntryRef,
) -> LLVMRemarkStringRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMRemarkEntryRef) -> LLVMRemarkStringRef,
            >(stringify!(LLVMRemarkEntryGetRemarkName).as_bytes())
    }
        .expect(stringify!(LLVMRemarkEntryGetRemarkName));
    entry(Remark)
}
#[no_mangle]
pub extern "C" fn LLVMConstStringInContext(
    C: LLVMContextRef,
    Str: *const ::libc::c_char,
    Length: ::libc::c_uint,
    DontNullTerminate: LLVMBool,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMContextRef,
                    *const ::libc::c_char,
                    ::libc::c_uint,
                    LLVMBool,
                ) -> LLVMValueRef,
            >(stringify!(LLVMConstStringInContext).as_bytes())
    }
        .expect(stringify!(LLVMConstStringInContext));
    entry(C, Str, Length, DontNullTerminate)
}
#[no_mangle]
pub extern "C" fn LLVMIntPtrTypeForAS(
    TD: LLVMTargetDataRef,
    AS: ::libc::c_uint,
) -> LLVMTypeRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMTargetDataRef, ::libc::c_uint) -> LLVMTypeRef,
            >(stringify!(LLVMIntPtrTypeForAS).as_bytes())
    }
        .expect(stringify!(LLVMIntPtrTypeForAS));
    entry(TD, AS)
}
#[no_mangle]
pub extern "C" fn LLVMGetIntrinsicDeclaration(
    Mod: LLVMModuleRef,
    ID: ::libc::c_uint,
    ParamTypes: *mut LLVMTypeRef,
    ParamCount: ::libc::size_t,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMModuleRef,
                    ::libc::c_uint,
                    *mut LLVMTypeRef,
                    ::libc::size_t,
                ) -> LLVMValueRef,
            >(stringify!(LLVMGetIntrinsicDeclaration).as_bytes())
    }
        .expect(stringify!(LLVMGetIntrinsicDeclaration));
    entry(Mod, ID, ParamTypes, ParamCount)
}
#[no_mangle]
pub extern "C" fn LLVMGetIntTypeWidth(IntegerTy: LLVMTypeRef) -> ::libc::c_uint {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMTypeRef) -> ::libc::c_uint,
            >(stringify!(LLVMGetIntTypeWidth).as_bytes())
    }
        .expect(stringify!(LLVMGetIntTypeWidth));
    entry(IntegerTy)
}
#[no_mangle]
pub extern "C" fn LLVMGetSection(Global: LLVMValueRef) -> *const ::libc::c_char {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> *const ::libc::c_char,
            >(stringify!(LLVMGetSection).as_bytes())
    }
        .expect(stringify!(LLVMGetSection));
    entry(Global)
}
#[no_mangle]
pub extern "C" fn LLVMInstructionEraseFromParent(Inst: LLVMValueRef) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef),
            >(stringify!(LLVMInstructionEraseFromParent).as_bytes())
    }
        .expect(stringify!(LLVMInstructionEraseFromParent));
    entry(Inst)
}
#[no_mangle]
pub extern "C" fn LLVMGetBitcodeModuleInContext2(
    ContextRef: LLVMContextRef,
    MemBuf: LLVMMemoryBufferRef,
    OutM: *mut LLVMModuleRef,
) -> LLVMBool {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMContextRef,
                    LLVMMemoryBufferRef,
                    *mut LLVMModuleRef,
                ) -> LLVMBool,
            >(stringify!(LLVMGetBitcodeModuleInContext2).as_bytes())
    }
        .expect(stringify!(LLVMGetBitcodeModuleInContext2));
    entry(ContextRef, MemBuf, OutM)
}
#[no_mangle]
pub extern "C" fn LLVMBuildSub(
    arg1: LLVMBuilderRef,
    LHS: LLVMValueRef,
    RHS: LLVMValueRef,
    Name: *const ::libc::c_char,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMBuilderRef,
                    LLVMValueRef,
                    LLVMValueRef,
                    *const ::libc::c_char,
                ) -> LLVMValueRef,
            >(stringify!(LLVMBuildSub).as_bytes())
    }
        .expect(stringify!(LLVMBuildSub));
    entry(arg1, LHS, RHS, Name)
}
#[no_mangle]
pub extern "C" fn LLVMIsAZExtInst(Val: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMIsAZExtInst).as_bytes())
    }
        .expect(stringify!(LLVMIsAZExtInst));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn lto_module_get_macho_cputype(
    _mod: lto_module_t,
    out_cputype: *mut ::libc::c_uint,
    out_cpusubtype: *mut ::libc::c_uint,
) -> lto_bool_t {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    lto_module_t,
                    *mut ::libc::c_uint,
                    *mut ::libc::c_uint,
                ) -> lto_bool_t,
            >(stringify!(lto_module_get_macho_cputype).as_bytes())
    }
        .expect(stringify!(lto_module_get_macho_cputype));
    entry(_mod, out_cputype, out_cpusubtype)
}
#[no_mangle]
pub extern "C" fn LLVMGetTargetExtTypeName(
    TargetExtTy: LLVMTypeRef,
) -> *const ::libc::c_char {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMTypeRef) -> *const ::libc::c_char,
            >(stringify!(LLVMGetTargetExtTypeName).as_bytes())
    }
        .expect(stringify!(LLVMGetTargetExtTypeName));
    entry(TargetExtTy)
}
#[no_mangle]
pub extern "C" fn lto_module_create_in_local_context(
    mem: *const ::libc::c_void,
    length: ::libc::size_t,
    path: *const ::libc::c_char,
) -> lto_module_t {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    *const ::libc::c_void,
                    ::libc::size_t,
                    *const ::libc::c_char,
                ) -> lto_module_t,
            >(stringify!(lto_module_create_in_local_context).as_bytes())
    }
        .expect(stringify!(lto_module_create_in_local_context));
    entry(mem, length, path)
}
#[no_mangle]
pub extern "C" fn LLVMIsAConstantDataSequential(Val: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMIsAConstantDataSequential).as_bytes())
    }
        .expect(stringify!(LLVMIsAConstantDataSequential));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn lto_codegen_compile(
    cg: lto_code_gen_t,
    length: *mut ::libc::size_t,
) -> *const ::libc::c_void {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    lto_code_gen_t,
                    *mut ::libc::size_t,
                ) -> *const ::libc::c_void,
            >(stringify!(lto_codegen_compile).as_bytes())
    }
        .expect(stringify!(lto_codegen_compile));
    entry(cg, length)
}
#[no_mangle]
pub extern "C" fn LLVMGetWeak(CmpXchgInst: LLVMValueRef) -> LLVMBool {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMBool,
            >(stringify!(LLVMGetWeak).as_bytes())
    }
        .expect(stringify!(LLVMGetWeak));
    entry(CmpXchgInst)
}
#[no_mangle]
pub extern "C" fn LLVMHalfTypeInContext(C: LLVMContextRef) -> LLVMTypeRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMContextRef) -> LLVMTypeRef,
            >(stringify!(LLVMHalfTypeInContext).as_bytes())
    }
        .expect(stringify!(LLVMHalfTypeInContext));
    entry(C)
}
#[no_mangle]
pub extern "C" fn LLVMIsABranchInst(Val: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMIsABranchInst).as_bytes())
    }
        .expect(stringify!(LLVMIsABranchInst));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn LLVMDITypeGetSizeInBits(DType: LLVMMetadataRef) -> u64 {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMMetadataRef) -> u64,
            >(stringify!(LLVMDITypeGetSizeInBits).as_bytes())
    }
        .expect(stringify!(LLVMDITypeGetSizeInBits));
    entry(DType)
}
#[no_mangle]
pub extern "C" fn LLVMGenericValueToFloat(
    TyRef: LLVMTypeRef,
    GenVal: LLVMGenericValueRef,
) -> ::libc::c_double {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMTypeRef, LLVMGenericValueRef) -> ::libc::c_double,
            >(stringify!(LLVMGenericValueToFloat).as_bytes())
    }
        .expect(stringify!(LLVMGenericValueToFloat));
    entry(TyRef, GenVal)
}
#[no_mangle]
pub extern "C" fn lto_codegen_optimize(cg: lto_code_gen_t) -> lto_bool_t {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(lto_code_gen_t) -> lto_bool_t,
            >(stringify!(lto_codegen_optimize).as_bytes())
    }
        .expect(stringify!(lto_codegen_optimize));
    entry(cg)
}
#[no_mangle]
pub extern "C" fn LLVMSetModuleIdentifier(
    M: LLVMModuleRef,
    Ident: *const ::libc::c_char,
    Len: ::libc::size_t,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMModuleRef, *const ::libc::c_char, ::libc::size_t),
            >(stringify!(LLVMSetModuleIdentifier).as_bytes())
    }
        .expect(stringify!(LLVMSetModuleIdentifier));
    entry(M, Ident, Len)
}
#[no_mangle]
pub extern "C" fn LLVMIsAUIToFPInst(Val: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMIsAUIToFPInst).as_bytes())
    }
        .expect(stringify!(LLVMIsAUIToFPInst));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn LLVMGetCastOpcode(
    arg1: LLVMValueRef,
    SrcIsSigned: LLVMBool,
    DestTy: LLVMTypeRef,
    DestIsSigned: LLVMBool,
) -> LLVMOpcode {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMValueRef,
                    LLVMBool,
                    LLVMTypeRef,
                    LLVMBool,
                ) -> LLVMOpcode,
            >(stringify!(LLVMGetCastOpcode).as_bytes())
    }
        .expect(stringify!(LLVMGetCastOpcode));
    entry(arg1, SrcIsSigned, DestTy, DestIsSigned)
}
#[no_mangle]
pub extern "C" fn LLVMGetElementAsConstant(
    C: LLVMValueRef,
    idx: ::libc::c_uint,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, ::libc::c_uint) -> LLVMValueRef,
            >(stringify!(LLVMGetElementAsConstant).as_bytes())
    }
        .expect(stringify!(LLVMGetElementAsConstant));
    entry(C, idx)
}
#[no_mangle]
pub extern "C" fn LLVMDITypeGetName(
    DType: LLVMMetadataRef,
    Length: *mut ::libc::size_t,
) -> *const ::libc::c_char {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMMetadataRef,
                    *mut ::libc::size_t,
                ) -> *const ::libc::c_char,
            >(stringify!(LLVMDITypeGetName).as_bytes())
    }
        .expect(stringify!(LLVMDITypeGetName));
    entry(DType, Length)
}
#[no_mangle]
pub extern "C" fn LLVMBuildSDiv(
    arg1: LLVMBuilderRef,
    LHS: LLVMValueRef,
    RHS: LLVMValueRef,
    Name: *const ::libc::c_char,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMBuilderRef,
                    LLVMValueRef,
                    LLVMValueRef,
                    *const ::libc::c_char,
                ) -> LLVMValueRef,
            >(stringify!(LLVMBuildSDiv).as_bytes())
    }
        .expect(stringify!(LLVMBuildSDiv));
    entry(arg1, LHS, RHS, Name)
}
#[no_mangle]
pub extern "C" fn lto_codegen_create() -> lto_code_gen_t {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn() -> lto_code_gen_t,
            >(stringify!(lto_codegen_create).as_bytes())
    }
        .expect(stringify!(lto_codegen_create));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMDIBuilderCreateTypedef(
    Builder: LLVMDIBuilderRef,
    Type: LLVMMetadataRef,
    Name: *const ::libc::c_char,
    NameLen: ::libc::size_t,
    File: LLVMMetadataRef,
    LineNo: ::libc::c_uint,
    Scope: LLVMMetadataRef,
    AlignInBits: u32,
) -> LLVMMetadataRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMDIBuilderRef,
                    LLVMMetadataRef,
                    *const ::libc::c_char,
                    ::libc::size_t,
                    LLVMMetadataRef,
                    ::libc::c_uint,
                    LLVMMetadataRef,
                    u32,
                ) -> LLVMMetadataRef,
            >(stringify!(LLVMDIBuilderCreateTypedef).as_bytes())
    }
        .expect(stringify!(LLVMDIBuilderCreateTypedef));
    entry(Builder, Type, Name, NameLen, File, LineNo, Scope, AlignInBits)
}
#[no_mangle]
pub extern "C" fn thinlto_module_get_object(
    cg: thinlto_code_gen_t,
    index: ::libc::c_uint,
) -> LTOObjectBuffer {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(thinlto_code_gen_t, ::libc::c_uint) -> LTOObjectBuffer,
            >(stringify!(thinlto_module_get_object).as_bytes())
    }
        .expect(stringify!(thinlto_module_get_object));
    entry(cg, index)
}
#[no_mangle]
pub extern "C" fn thinlto_codegen_set_cache_pruning_interval(
    cg: thinlto_code_gen_t,
    interval: ::libc::c_int,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(thinlto_code_gen_t, ::libc::c_int),
            >(stringify!(thinlto_codegen_set_cache_pruning_interval).as_bytes())
    }
        .expect(stringify!(thinlto_codegen_set_cache_pruning_interval));
    entry(cg, interval)
}
#[no_mangle]
pub extern "C" fn lto_codegen_debug_options_array(
    cg: lto_code_gen_t,
    arg2: *const *const ::libc::c_char,
    number: ::libc::c_int,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    lto_code_gen_t,
                    *const *const ::libc::c_char,
                    ::libc::c_int,
                ),
            >(stringify!(lto_codegen_debug_options_array).as_bytes())
    }
        .expect(stringify!(lto_codegen_debug_options_array));
    entry(cg, arg2, number)
}
#[no_mangle]
pub extern "C" fn LLVMInitializeXCoreDisassembler() {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(),
            >(stringify!(LLVMInitializeXCoreDisassembler).as_bytes())
    }
        .expect(stringify!(LLVMInitializeXCoreDisassembler));
    entry()
}
#[no_mangle]
pub extern "C" fn llvm_blake3_hasher_finalize(
    hasher: *mut llvm_blake3_hasher,
    out: *mut u8,
    out_len: usize,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(*mut llvm_blake3_hasher, *mut u8, usize),
            >(stringify!(llvm_blake3_hasher_finalize).as_bytes())
    }
        .expect(stringify!(llvm_blake3_hasher_finalize));
    entry(hasher, out, out_len)
}
#[no_mangle]
pub extern "C" fn LLVMGetLastBasicBlock(Fn: LLVMValueRef) -> LLVMBasicBlockRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMBasicBlockRef,
            >(stringify!(LLVMGetLastBasicBlock).as_bytes())
    }
        .expect(stringify!(LLVMGetLastBasicBlock));
    entry(Fn)
}
#[no_mangle]
pub extern "C" fn LLVMSetWeak(CmpXchgInst: LLVMValueRef, IsWeak: LLVMBool) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, LLVMBool),
            >(stringify!(LLVMSetWeak).as_bytes())
    }
        .expect(stringify!(LLVMSetWeak));
    entry(CmpXchgInst, IsWeak)
}
#[no_mangle]
pub extern "C" fn LLVMGetSwitchCaseValue(
    SwitchInstr: LLVMValueRef,
    i: ::libc::c_uint,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, ::libc::c_uint) -> LLVMValueRef,
            >(stringify!(LLVMGetSwitchCaseValue).as_bytes())
    }
        .expect(stringify!(LLVMGetSwitchCaseValue));
    entry(SwitchInstr, i)
}
#[no_mangle]
pub extern "C" fn LLVMIsAInsertElementInst(Val: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMIsAInsertElementInst).as_bytes())
    }
        .expect(stringify!(LLVMIsAInsertElementInst));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn LLVMDisposeTargetMachine(T: LLVMTargetMachineRef) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMTargetMachineRef),
            >(stringify!(LLVMDisposeTargetMachine).as_bytes())
    }
        .expect(stringify!(LLVMDisposeTargetMachine));
    entry(T)
}
#[no_mangle]
pub extern "C" fn LLVMInitializeBPFTargetInfo() {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<extern "C" fn()>(stringify!(LLVMInitializeBPFTargetInfo).as_bytes())
    }
        .expect(stringify!(LLVMInitializeBPFTargetInfo));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMDITypeGetFlags(DType: LLVMMetadataRef) -> LLVMDIFlags {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMMetadataRef) -> LLVMDIFlags,
            >(stringify!(LLVMDITypeGetFlags).as_bytes())
    }
        .expect(stringify!(LLVMDITypeGetFlags));
    entry(DType)
}
#[no_mangle]
pub extern "C" fn LLVMGetEnumAttributeKindForName(
    Name: *const ::libc::c_char,
    SLen: ::libc::size_t,
) -> ::libc::c_uint {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(*const ::libc::c_char, ::libc::size_t) -> ::libc::c_uint,
            >(stringify!(LLVMGetEnumAttributeKindForName).as_bytes())
    }
        .expect(stringify!(LLVMGetEnumAttributeKindForName));
    entry(Name, SLen)
}
#[no_mangle]
pub extern "C" fn LLVMOrcLLJITAddObjectFileWithRT(
    J: LLVMOrcLLJITRef,
    RT: LLVMOrcResourceTrackerRef,
    ObjBuffer: LLVMMemoryBufferRef,
) -> LLVMErrorRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMOrcLLJITRef,
                    LLVMOrcResourceTrackerRef,
                    LLVMMemoryBufferRef,
                ) -> LLVMErrorRef,
            >(stringify!(LLVMOrcLLJITAddObjectFileWithRT).as_bytes())
    }
        .expect(stringify!(LLVMOrcLLJITAddObjectFileWithRT));
    entry(J, RT, ObjBuffer)
}
#[no_mangle]
pub extern "C" fn LLVMInitializeRISCVTargetInfo() {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<extern "C" fn()>(stringify!(LLVMInitializeRISCVTargetInfo).as_bytes())
    }
        .expect(stringify!(LLVMInitializeRISCVTargetInfo));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMDIBuilderCreateForwardDecl(
    Builder: LLVMDIBuilderRef,
    Tag: ::libc::c_uint,
    Name: *const ::libc::c_char,
    NameLen: ::libc::size_t,
    Scope: LLVMMetadataRef,
    File: LLVMMetadataRef,
    Line: ::libc::c_uint,
    RuntimeLang: ::libc::c_uint,
    SizeInBits: u64,
    AlignInBits: u32,
    UniqueIdentifier: *const ::libc::c_char,
    UniqueIdentifierLen: ::libc::size_t,
) -> LLVMMetadataRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMDIBuilderRef,
                    ::libc::c_uint,
                    *const ::libc::c_char,
                    ::libc::size_t,
                    LLVMMetadataRef,
                    LLVMMetadataRef,
                    ::libc::c_uint,
                    ::libc::c_uint,
                    u64,
                    u32,
                    *const ::libc::c_char,
                    ::libc::size_t,
                ) -> LLVMMetadataRef,
            >(stringify!(LLVMDIBuilderCreateForwardDecl).as_bytes())
    }
        .expect(stringify!(LLVMDIBuilderCreateForwardDecl));
    entry(
        Builder,
        Tag,
        Name,
        NameLen,
        Scope,
        File,
        Line,
        RuntimeLang,
        SizeInBits,
        AlignInBits,
        UniqueIdentifier,
        UniqueIdentifierLen,
    )
}
#[no_mangle]
pub extern "C" fn LLVMGetPersonalityFn(Fn: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMGetPersonalityFn).as_bytes())
    }
        .expect(stringify!(LLVMGetPersonalityFn));
    entry(Fn)
}
#[no_mangle]
pub extern "C" fn LLVMBuildCast(
    B: LLVMBuilderRef,
    Op: LLVMOpcode,
    Val: LLVMValueRef,
    DestTy: LLVMTypeRef,
    Name: *const ::libc::c_char,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMBuilderRef,
                    LLVMOpcode,
                    LLVMValueRef,
                    LLVMTypeRef,
                    *const ::libc::c_char,
                ) -> LLVMValueRef,
            >(stringify!(LLVMBuildCast).as_bytes())
    }
        .expect(stringify!(LLVMBuildCast));
    entry(B, Op, Val, DestTy, Name)
}
#[no_mangle]
pub extern "C" fn LLVMGetNumHandlers(CatchSwitch: LLVMValueRef) -> ::libc::c_uint {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> ::libc::c_uint,
            >(stringify!(LLVMGetNumHandlers).as_bytes())
    }
        .expect(stringify!(LLVMGetNumHandlers));
    entry(CatchSwitch)
}
#[no_mangle]
pub extern "C" fn LLVMIsConstant(Val: LLVMValueRef) -> LLVMBool {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMBool,
            >(stringify!(LLVMIsConstant).as_bytes())
    }
        .expect(stringify!(LLVMIsConstant));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn LLVMBuildCallWithOperandBundles(
    arg1: LLVMBuilderRef,
    arg2: LLVMTypeRef,
    Fn: LLVMValueRef,
    Args: *mut LLVMValueRef,
    NumArgs: ::libc::c_uint,
    Bundles: *mut LLVMOperandBundleRef,
    NumBundles: ::libc::c_uint,
    Name: *const ::libc::c_char,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMBuilderRef,
                    LLVMTypeRef,
                    LLVMValueRef,
                    *mut LLVMValueRef,
                    ::libc::c_uint,
                    *mut LLVMOperandBundleRef,
                    ::libc::c_uint,
                    *const ::libc::c_char,
                ) -> LLVMValueRef,
            >(stringify!(LLVMBuildCallWithOperandBundles).as_bytes())
    }
        .expect(stringify!(LLVMBuildCallWithOperandBundles));
    entry(arg1, arg2, Fn, Args, NumArgs, Bundles, NumBundles, Name)
}
#[no_mangle]
pub extern "C" fn LLVMDisposeOperandBundle(Bundle: LLVMOperandBundleRef) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMOperandBundleRef),
            >(stringify!(LLVMDisposeOperandBundle).as_bytes())
    }
        .expect(stringify!(LLVMDisposeOperandBundle));
    entry(Bundle)
}
#[no_mangle]
pub extern "C" fn LLVMDIBuilderCreateEnumeratorOfArbitraryPrecision(
    Builder: LLVMDIBuilderRef,
    Name: *const ::libc::c_char,
    NameLen: ::libc::size_t,
    SizeInBits: u64,
    Words: *const u64,
    IsUnsigned: LLVMBool,
) -> LLVMMetadataRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMDIBuilderRef,
                    *const ::libc::c_char,
                    ::libc::size_t,
                    u64,
                    *const u64,
                    LLVMBool,
                ) -> LLVMMetadataRef,
            >(stringify!(LLVMDIBuilderCreateEnumeratorOfArbitraryPrecision).as_bytes())
    }
        .expect(stringify!(LLVMDIBuilderCreateEnumeratorOfArbitraryPrecision));
    entry(Builder, Name, NameLen, SizeInBits, Words, IsUnsigned)
}
#[no_mangle]
pub extern "C" fn LLVMGetFirstTarget() -> LLVMTargetRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn() -> LLVMTargetRef,
            >(stringify!(LLVMGetFirstTarget).as_bytes())
    }
        .expect(stringify!(LLVMGetFirstTarget));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMOrcCreateRTDyldObjectLinkingLayerWithMCJITMemoryManagerLikeCallbacks(
    ES: LLVMOrcExecutionSessionRef,
    CreateContext: LLVMMemoryManagerCreateContextCallback,
    NotifyTerminating: LLVMMemoryManagerNotifyTerminatingCallback,
    AllocateCodeSection: LLVMMemoryManagerAllocateCodeSectionCallback,
    AllocateDataSection: LLVMMemoryManagerAllocateDataSectionCallback,
    FinalizeMemory: LLVMMemoryManagerFinalizeMemoryCallback,
    Destroy: LLVMMemoryManagerDestroyCallback,
) -> LLVMOrcObjectLayerRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMOrcExecutionSessionRef,
                    LLVMMemoryManagerCreateContextCallback,
                    LLVMMemoryManagerNotifyTerminatingCallback,
                    LLVMMemoryManagerAllocateCodeSectionCallback,
                    LLVMMemoryManagerAllocateDataSectionCallback,
                    LLVMMemoryManagerFinalizeMemoryCallback,
                    LLVMMemoryManagerDestroyCallback,
                ) -> LLVMOrcObjectLayerRef,
            >(
                stringify!(
                    LLVMOrcCreateRTDyldObjectLinkingLayerWithMCJITMemoryManagerLikeCallbacks
                )
                    .as_bytes(),
            )
    }
        .expect(
            stringify!(
                LLVMOrcCreateRTDyldObjectLinkingLayerWithMCJITMemoryManagerLikeCallbacks
            ),
        );
    entry(
        ES,
        CreateContext,
        NotifyTerminating,
        AllocateCodeSection,
        AllocateDataSection,
        FinalizeMemory,
        Destroy,
    )
}
#[no_mangle]
pub extern "C" fn LLVMDIBuilderCreateBitFieldMemberType(
    Builder: LLVMDIBuilderRef,
    Scope: LLVMMetadataRef,
    Name: *const ::libc::c_char,
    NameLen: ::libc::size_t,
    File: LLVMMetadataRef,
    LineNumber: ::libc::c_uint,
    SizeInBits: u64,
    OffsetInBits: u64,
    StorageOffsetInBits: u64,
    Flags: LLVMDIFlags,
    Type: LLVMMetadataRef,
) -> LLVMMetadataRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMDIBuilderRef,
                    LLVMMetadataRef,
                    *const ::libc::c_char,
                    ::libc::size_t,
                    LLVMMetadataRef,
                    ::libc::c_uint,
                    u64,
                    u64,
                    u64,
                    LLVMDIFlags,
                    LLVMMetadataRef,
                ) -> LLVMMetadataRef,
            >(stringify!(LLVMDIBuilderCreateBitFieldMemberType).as_bytes())
    }
        .expect(stringify!(LLVMDIBuilderCreateBitFieldMemberType));
    entry(
        Builder,
        Scope,
        Name,
        NameLen,
        File,
        LineNumber,
        SizeInBits,
        OffsetInBits,
        StorageOffsetInBits,
        Flags,
        Type,
    )
}
#[no_mangle]
pub extern "C" fn LLVMPassBuilderOptionsSetLicmMssaOptCap(
    Options: LLVMPassBuilderOptionsRef,
    LicmMssaOptCap: ::libc::c_uint,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMPassBuilderOptionsRef, ::libc::c_uint),
            >(stringify!(LLVMPassBuilderOptionsSetLicmMssaOptCap).as_bytes())
    }
        .expect(stringify!(LLVMPassBuilderOptionsSetLicmMssaOptCap));
    entry(Options, LicmMssaOptCap)
}
#[no_mangle]
pub extern "C" fn LLVMBuildFence(
    B: LLVMBuilderRef,
    ordering: LLVMAtomicOrdering,
    singleThread: LLVMBool,
    Name: *const ::libc::c_char,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMBuilderRef,
                    LLVMAtomicOrdering,
                    LLVMBool,
                    *const ::libc::c_char,
                ) -> LLVMValueRef,
            >(stringify!(LLVMBuildFence).as_bytes())
    }
        .expect(stringify!(LLVMBuildFence));
    entry(B, ordering, singleThread, Name)
}
#[no_mangle]
pub extern "C" fn LLVMSetNUW(ArithInst: LLVMValueRef, HasNUW: LLVMBool) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, LLVMBool),
            >(stringify!(LLVMSetNUW).as_bytes())
    }
        .expect(stringify!(LLVMSetNUW));
    entry(ArithInst, HasNUW)
}
#[no_mangle]
pub extern "C" fn LLVMOrcDisposeThreadSafeContext(TSCtx: LLVMOrcThreadSafeContextRef) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMOrcThreadSafeContextRef),
            >(stringify!(LLVMOrcDisposeThreadSafeContext).as_bytes())
    }
        .expect(stringify!(LLVMOrcDisposeThreadSafeContext));
    entry(TSCtx)
}
#[no_mangle]
pub extern "C" fn LLVMConstGEP2(
    Ty: LLVMTypeRef,
    ConstantVal: LLVMValueRef,
    ConstantIndices: *mut LLVMValueRef,
    NumIndices: ::libc::c_uint,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMTypeRef,
                    LLVMValueRef,
                    *mut LLVMValueRef,
                    ::libc::c_uint,
                ) -> LLVMValueRef,
            >(stringify!(LLVMConstGEP2).as_bytes())
    }
        .expect(stringify!(LLVMConstGEP2));
    entry(Ty, ConstantVal, ConstantIndices, NumIndices)
}
#[no_mangle]
pub extern "C" fn LLVMOrcLLJITGetGlobalPrefix(J: LLVMOrcLLJITRef) -> ::libc::c_char {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMOrcLLJITRef) -> ::libc::c_char,
            >(stringify!(LLVMOrcLLJITGetGlobalPrefix).as_bytes())
    }
        .expect(stringify!(LLVMOrcLLJITGetGlobalPrefix));
    entry(J)
}
#[no_mangle]
pub extern "C" fn LLVMOrcSymbolStringPoolEntryStr(
    S: LLVMOrcSymbolStringPoolEntryRef,
) -> *const ::libc::c_char {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMOrcSymbolStringPoolEntryRef) -> *const ::libc::c_char,
            >(stringify!(LLVMOrcSymbolStringPoolEntryStr).as_bytes())
    }
        .expect(stringify!(LLVMOrcSymbolStringPoolEntryStr));
    entry(S)
}
#[no_mangle]
pub extern "C" fn LLVMDisposeValueMetadataEntries(Entries: *mut LLVMValueMetadataEntry) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(*mut LLVMValueMetadataEntry),
            >(stringify!(LLVMDisposeValueMetadataEntries).as_bytes())
    }
        .expect(stringify!(LLVMDisposeValueMetadataEntries));
    entry(Entries)
}
#[no_mangle]
pub extern "C" fn LLVMDIBuilderCreateEnumerator(
    Builder: LLVMDIBuilderRef,
    Name: *const ::libc::c_char,
    NameLen: ::libc::size_t,
    Value: i64,
    IsUnsigned: LLVMBool,
) -> LLVMMetadataRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMDIBuilderRef,
                    *const ::libc::c_char,
                    ::libc::size_t,
                    i64,
                    LLVMBool,
                ) -> LLVMMetadataRef,
            >(stringify!(LLVMDIBuilderCreateEnumerator).as_bytes())
    }
        .expect(stringify!(LLVMDIBuilderCreateEnumerator));
    entry(Builder, Name, NameLen, Value, IsUnsigned)
}
#[no_mangle]
pub extern "C" fn lto_runtime_lib_symbols_list(
    size: *mut usize,
) -> *const *const ::libc::c_char {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(*mut usize) -> *const *const ::libc::c_char,
            >(stringify!(lto_runtime_lib_symbols_list).as_bytes())
    }
        .expect(stringify!(lto_runtime_lib_symbols_list));
    entry(size)
}
#[no_mangle]
pub extern "C" fn LLVMGetFastMathFlags(FPMathInst: LLVMValueRef) -> LLVMFastMathFlags {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMFastMathFlags,
            >(stringify!(LLVMGetFastMathFlags).as_bytes())
    }
        .expect(stringify!(LLVMGetFastMathFlags));
    entry(FPMathInst)
}
#[no_mangle]
pub extern "C" fn LLVMBuildIntCast2(
    arg1: LLVMBuilderRef,
    Val: LLVMValueRef,
    DestTy: LLVMTypeRef,
    IsSigned: LLVMBool,
    Name: *const ::libc::c_char,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMBuilderRef,
                    LLVMValueRef,
                    LLVMTypeRef,
                    LLVMBool,
                    *const ::libc::c_char,
                ) -> LLVMValueRef,
            >(stringify!(LLVMBuildIntCast2).as_bytes())
    }
        .expect(stringify!(LLVMBuildIntCast2));
    entry(arg1, Val, DestTy, IsSigned, Name)
}
#[no_mangle]
pub extern "C" fn LLVMSizeOfTypeInBits(
    TD: LLVMTargetDataRef,
    Ty: LLVMTypeRef,
) -> ::libc::c_ulonglong {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMTargetDataRef, LLVMTypeRef) -> ::libc::c_ulonglong,
            >(stringify!(LLVMSizeOfTypeInBits).as_bytes())
    }
        .expect(stringify!(LLVMSizeOfTypeInBits));
    entry(TD, Ty)
}
#[no_mangle]
pub extern "C" fn LLVMValueAsBasicBlock(Val: LLVMValueRef) -> LLVMBasicBlockRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMBasicBlockRef,
            >(stringify!(LLVMValueAsBasicBlock).as_bytes())
    }
        .expect(stringify!(LLVMValueAsBasicBlock));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn LLVMBuildMemMove(
    B: LLVMBuilderRef,
    Dst: LLVMValueRef,
    DstAlign: ::libc::c_uint,
    Src: LLVMValueRef,
    SrcAlign: ::libc::c_uint,
    Size: LLVMValueRef,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMBuilderRef,
                    LLVMValueRef,
                    ::libc::c_uint,
                    LLVMValueRef,
                    ::libc::c_uint,
                    LLVMValueRef,
                ) -> LLVMValueRef,
            >(stringify!(LLVMBuildMemMove).as_bytes())
    }
        .expect(stringify!(LLVMBuildMemMove));
    entry(B, Dst, DstAlign, Src, SrcAlign, Size)
}
#[no_mangle]
pub extern "C" fn LLVMDIBuilderCreateFileWithChecksum(
    Builder: LLVMDIBuilderRef,
    Filename: *const ::libc::c_char,
    FilenameLen: ::libc::size_t,
    Directory: *const ::libc::c_char,
    DirectoryLen: ::libc::size_t,
    ChecksumKind: LLVMChecksumKind,
    Checksum: *const ::libc::c_char,
    ChecksumLen: ::libc::size_t,
    Source: *const ::libc::c_char,
    SourceLen: ::libc::size_t,
) -> LLVMMetadataRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMDIBuilderRef,
                    *const ::libc::c_char,
                    ::libc::size_t,
                    *const ::libc::c_char,
                    ::libc::size_t,
                    LLVMChecksumKind,
                    *const ::libc::c_char,
                    ::libc::size_t,
                    *const ::libc::c_char,
                    ::libc::size_t,
                ) -> LLVMMetadataRef,
            >(stringify!(LLVMDIBuilderCreateFileWithChecksum).as_bytes())
    }
        .expect(stringify!(LLVMDIBuilderCreateFileWithChecksum));
    entry(
        Builder,
        Filename,
        FilenameLen,
        Directory,
        DirectoryLen,
        ChecksumKind,
        Checksum,
        ChecksumLen,
        Source,
        SourceLen,
    )
}
#[no_mangle]
pub extern "C" fn LLVMSetIsInBounds(GEP: LLVMValueRef, InBounds: LLVMBool) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, LLVMBool),
            >(stringify!(LLVMSetIsInBounds).as_bytes())
    }
        .expect(stringify!(LLVMSetIsInBounds));
    entry(GEP, InBounds)
}
#[no_mangle]
pub extern "C" fn LLVMOrcCreateStaticLibrarySearchGeneratorForPath(
    Result: *mut LLVMOrcDefinitionGeneratorRef,
    ObjLayer: LLVMOrcObjectLayerRef,
    FileName: *const ::libc::c_char,
    TargetTriple: *const ::libc::c_char,
) -> LLVMErrorRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    *mut LLVMOrcDefinitionGeneratorRef,
                    LLVMOrcObjectLayerRef,
                    *const ::libc::c_char,
                    *const ::libc::c_char,
                ) -> LLVMErrorRef,
            >(stringify!(LLVMOrcCreateStaticLibrarySearchGeneratorForPath).as_bytes())
    }
        .expect(stringify!(LLVMOrcCreateStaticLibrarySearchGeneratorForPath));
    entry(Result, ObjLayer, FileName, TargetTriple)
}
#[no_mangle]
pub extern "C" fn LLVMIsConditional(Branch: LLVMValueRef) -> LLVMBool {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMBool,
            >(stringify!(LLVMIsConditional).as_bytes())
    }
        .expect(stringify!(LLVMIsConditional));
    entry(Branch)
}
#[no_mangle]
pub extern "C" fn LLVMGetMetadata(
    Val: LLVMValueRef,
    KindID: ::libc::c_uint,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, ::libc::c_uint) -> LLVMValueRef,
            >(stringify!(LLVMGetMetadata).as_bytes())
    }
        .expect(stringify!(LLVMGetMetadata));
    entry(Val, KindID)
}
#[no_mangle]
pub extern "C" fn LLVMInitializeXCoreAsmPrinter() {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<extern "C" fn()>(stringify!(LLVMInitializeXCoreAsmPrinter).as_bytes())
    }
        .expect(stringify!(LLVMInitializeXCoreAsmPrinter));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMGetParamTypes(FunctionTy: LLVMTypeRef, Dest: *mut LLVMTypeRef) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMTypeRef, *mut LLVMTypeRef),
            >(stringify!(LLVMGetParamTypes).as_bytes())
    }
        .expect(stringify!(LLVMGetParamTypes));
    entry(FunctionTy, Dest)
}
#[no_mangle]
pub extern "C" fn LLVMDIBuilderCreateLabel(
    Builder: LLVMDIBuilderRef,
    Context: LLVMMetadataRef,
    Name: *const ::libc::c_char,
    NameLen: ::libc::size_t,
    File: LLVMMetadataRef,
    LineNo: ::libc::size_t,
    AlwaysPreserve: LLVMBool,
) -> LLVMMetadataRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMDIBuilderRef,
                    LLVMMetadataRef,
                    *const ::libc::c_char,
                    ::libc::size_t,
                    LLVMMetadataRef,
                    ::libc::size_t,
                    LLVMBool,
                ) -> LLVMMetadataRef,
            >(stringify!(LLVMDIBuilderCreateLabel).as_bytes())
    }
        .expect(stringify!(LLVMDIBuilderCreateLabel));
    entry(Builder, Context, Name, NameLen, File, LineNo, AlwaysPreserve)
}
#[no_mangle]
pub extern "C" fn LLVMObjectFileIsSectionIteratorAtEnd(
    BR: LLVMBinaryRef,
    SI: LLVMSectionIteratorRef,
) -> LLVMBool {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMBinaryRef, LLVMSectionIteratorRef) -> LLVMBool,
            >(stringify!(LLVMObjectFileIsSectionIteratorAtEnd).as_bytes())
    }
        .expect(stringify!(LLVMObjectFileIsSectionIteratorAtEnd));
    entry(BR, SI)
}
#[no_mangle]
pub extern "C" fn LLVMIntPtrTypeInContext(
    C: LLVMContextRef,
    TD: LLVMTargetDataRef,
) -> LLVMTypeRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMContextRef, LLVMTargetDataRef) -> LLVMTypeRef,
            >(stringify!(LLVMIntPtrTypeInContext).as_bytes())
    }
        .expect(stringify!(LLVMIntPtrTypeInContext));
    entry(C, TD)
}
#[no_mangle]
pub extern "C" fn LLVMPassBuilderOptionsSetVerifyEach(
    Options: LLVMPassBuilderOptionsRef,
    VerifyEach: LLVMBool,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMPassBuilderOptionsRef, LLVMBool),
            >(stringify!(LLVMPassBuilderOptionsSetVerifyEach).as_bytes())
    }
        .expect(stringify!(LLVMPassBuilderOptionsSetVerifyEach));
    entry(Options, VerifyEach)
}
#[no_mangle]
pub extern "C" fn LLVMDeleteBasicBlock(BB: LLVMBasicBlockRef) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMBasicBlockRef),
            >(stringify!(LLVMDeleteBasicBlock).as_bytes())
    }
        .expect(stringify!(LLVMDeleteBasicBlock));
    entry(BB)
}
#[no_mangle]
pub extern "C" fn LLVMIsAFuncletPadInst(Val: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMIsAFuncletPadInst).as_bytes())
    }
        .expect(stringify!(LLVMIsAFuncletPadInst));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn LLVMAddHandler(CatchSwitch: LLVMValueRef, Dest: LLVMBasicBlockRef) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, LLVMBasicBlockRef),
            >(stringify!(LLVMAddHandler).as_bytes())
    }
        .expect(stringify!(LLVMAddHandler));
    entry(CatchSwitch, Dest)
}
#[no_mangle]
pub extern "C" fn LLVMAddTargetDependentFunctionAttr(
    Fn: LLVMValueRef,
    A: *const ::libc::c_char,
    V: *const ::libc::c_char,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, *const ::libc::c_char, *const ::libc::c_char),
            >(stringify!(LLVMAddTargetDependentFunctionAttr).as_bytes())
    }
        .expect(stringify!(LLVMAddTargetDependentFunctionAttr));
    entry(Fn, A, V)
}
#[no_mangle]
pub extern "C" fn thinlto_codegen_set_cpu(
    cg: thinlto_code_gen_t,
    cpu: *const ::libc::c_char,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(thinlto_code_gen_t, *const ::libc::c_char),
            >(stringify!(thinlto_codegen_set_cpu).as_bytes())
    }
        .expect(stringify!(thinlto_codegen_set_cpu));
    entry(cg, cpu)
}
#[no_mangle]
pub extern "C" fn LLVMModuleFlagEntriesGetMetadata(
    Entries: *mut LLVMModuleFlagEntry,
    Index: ::libc::c_uint,
) -> LLVMMetadataRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    *mut LLVMModuleFlagEntry,
                    ::libc::c_uint,
                ) -> LLVMMetadataRef,
            >(stringify!(LLVMModuleFlagEntriesGetMetadata).as_bytes())
    }
        .expect(stringify!(LLVMModuleFlagEntriesGetMetadata));
    entry(Entries, Index)
}
#[no_mangle]
pub extern "C" fn lto_module_create_from_memory_with_path(
    mem: *const ::libc::c_void,
    length: ::libc::size_t,
    path: *const ::libc::c_char,
) -> lto_module_t {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    *const ::libc::c_void,
                    ::libc::size_t,
                    *const ::libc::c_char,
                ) -> lto_module_t,
            >(stringify!(lto_module_create_from_memory_with_path).as_bytes())
    }
        .expect(stringify!(lto_module_create_from_memory_with_path));
    entry(mem, length, path)
}
#[no_mangle]
pub extern "C" fn LLVMIntType(NumBits: ::libc::c_uint) -> LLVMTypeRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(::libc::c_uint) -> LLVMTypeRef,
            >(stringify!(LLVMIntType).as_bytes())
    }
        .expect(stringify!(LLVMIntType));
    entry(NumBits)
}
#[no_mangle]
pub extern "C" fn LLVMInitializeAMDGPUTargetMC() {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<extern "C" fn()>(stringify!(LLVMInitializeAMDGPUTargetMC).as_bytes())
    }
        .expect(stringify!(LLVMInitializeAMDGPUTargetMC));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMIsDeclaration(Global: LLVMValueRef) -> LLVMBool {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMBool,
            >(stringify!(LLVMIsDeclaration).as_bytes())
    }
        .expect(stringify!(LLVMIsDeclaration));
    entry(Global)
}
#[no_mangle]
pub extern "C" fn LLVMCreateTargetMachine(
    T: LLVMTargetRef,
    Triple: *const ::libc::c_char,
    CPU: *const ::libc::c_char,
    Features: *const ::libc::c_char,
    Level: LLVMCodeGenOptLevel,
    Reloc: LLVMRelocMode,
    CodeModel: LLVMCodeModel,
) -> LLVMTargetMachineRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMTargetRef,
                    *const ::libc::c_char,
                    *const ::libc::c_char,
                    *const ::libc::c_char,
                    LLVMCodeGenOptLevel,
                    LLVMRelocMode,
                    LLVMCodeModel,
                ) -> LLVMTargetMachineRef,
            >(stringify!(LLVMCreateTargetMachine).as_bytes())
    }
        .expect(stringify!(LLVMCreateTargetMachine));
    entry(T, Triple, CPU, Features, Level, Reloc, CodeModel)
}
#[no_mangle]
pub extern "C" fn LLVMGetConstantPtrAuthDiscriminator(
    PtrAuth: LLVMValueRef,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMGetConstantPtrAuthDiscriminator).as_bytes())
    }
        .expect(stringify!(LLVMGetConstantPtrAuthDiscriminator));
    entry(PtrAuth)
}
#[no_mangle]
pub extern "C" fn LLVMOrcJITTargetMachineBuilderDetectHost(
    Result: *mut LLVMOrcJITTargetMachineBuilderRef,
) -> LLVMErrorRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(*mut LLVMOrcJITTargetMachineBuilderRef) -> LLVMErrorRef,
            >(stringify!(LLVMOrcJITTargetMachineBuilderDetectHost).as_bytes())
    }
        .expect(stringify!(LLVMOrcJITTargetMachineBuilderDetectHost));
    entry(Result)
}
#[no_mangle]
pub extern "C" fn LLVMPositionBuilderBefore(
    Builder: LLVMBuilderRef,
    Instr: LLVMValueRef,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMBuilderRef, LLVMValueRef),
            >(stringify!(LLVMPositionBuilderBefore).as_bytes())
    }
        .expect(stringify!(LLVMPositionBuilderBefore));
    entry(Builder, Instr)
}
#[no_mangle]
pub extern "C" fn LLVMBuildFCmp(
    arg1: LLVMBuilderRef,
    Op: LLVMRealPredicate,
    LHS: LLVMValueRef,
    RHS: LLVMValueRef,
    Name: *const ::libc::c_char,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMBuilderRef,
                    LLVMRealPredicate,
                    LLVMValueRef,
                    LLVMValueRef,
                    *const ::libc::c_char,
                ) -> LLVMValueRef,
            >(stringify!(LLVMBuildFCmp).as_bytes())
    }
        .expect(stringify!(LLVMBuildFCmp));
    entry(arg1, Op, LHS, RHS, Name)
}
#[no_mangle]
pub extern "C" fn LLVMDIBuilderCreateEnumerationType(
    Builder: LLVMDIBuilderRef,
    Scope: LLVMMetadataRef,
    Name: *const ::libc::c_char,
    NameLen: ::libc::size_t,
    File: LLVMMetadataRef,
    LineNumber: ::libc::c_uint,
    SizeInBits: u64,
    AlignInBits: u32,
    Elements: *mut LLVMMetadataRef,
    NumElements: ::libc::c_uint,
    ClassTy: LLVMMetadataRef,
) -> LLVMMetadataRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMDIBuilderRef,
                    LLVMMetadataRef,
                    *const ::libc::c_char,
                    ::libc::size_t,
                    LLVMMetadataRef,
                    ::libc::c_uint,
                    u64,
                    u32,
                    *mut LLVMMetadataRef,
                    ::libc::c_uint,
                    LLVMMetadataRef,
                ) -> LLVMMetadataRef,
            >(stringify!(LLVMDIBuilderCreateEnumerationType).as_bytes())
    }
        .expect(stringify!(LLVMDIBuilderCreateEnumerationType));
    entry(
        Builder,
        Scope,
        Name,
        NameLen,
        File,
        LineNumber,
        SizeInBits,
        AlignInBits,
        Elements,
        NumElements,
        ClassTy,
    )
}
#[no_mangle]
pub extern "C" fn LLVMRunPasses(
    M: LLVMModuleRef,
    Passes: *const ::libc::c_char,
    TM: LLVMTargetMachineRef,
    Options: LLVMPassBuilderOptionsRef,
) -> LLVMErrorRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMModuleRef,
                    *const ::libc::c_char,
                    LLVMTargetMachineRef,
                    LLVMPassBuilderOptionsRef,
                ) -> LLVMErrorRef,
            >(stringify!(LLVMRunPasses).as_bytes())
    }
        .expect(stringify!(LLVMRunPasses));
    entry(M, Passes, TM, Options)
}
#[no_mangle]
pub extern "C" fn LLVMCreateDisasm(
    TripleName: *const ::libc::c_char,
    DisInfo: *mut ::libc::c_void,
    TagType: ::libc::c_int,
    GetOpInfo: LLVMOpInfoCallback,
    SymbolLookUp: LLVMSymbolLookupCallback,
) -> LLVMDisasmContextRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    *const ::libc::c_char,
                    *mut ::libc::c_void,
                    ::libc::c_int,
                    LLVMOpInfoCallback,
                    LLVMSymbolLookupCallback,
                ) -> LLVMDisasmContextRef,
            >(stringify!(LLVMCreateDisasm).as_bytes())
    }
        .expect(stringify!(LLVMCreateDisasm));
    entry(TripleName, DisInfo, TagType, GetOpInfo, SymbolLookUp)
}
#[no_mangle]
pub extern "C" fn LLVMBuildAtomicCmpXchg(
    B: LLVMBuilderRef,
    Ptr: LLVMValueRef,
    Cmp: LLVMValueRef,
    New: LLVMValueRef,
    SuccessOrdering: LLVMAtomicOrdering,
    FailureOrdering: LLVMAtomicOrdering,
    SingleThread: LLVMBool,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMBuilderRef,
                    LLVMValueRef,
                    LLVMValueRef,
                    LLVMValueRef,
                    LLVMAtomicOrdering,
                    LLVMAtomicOrdering,
                    LLVMBool,
                ) -> LLVMValueRef,
            >(stringify!(LLVMBuildAtomicCmpXchg).as_bytes())
    }
        .expect(stringify!(LLVMBuildAtomicCmpXchg));
    entry(B, Ptr, Cmp, New, SuccessOrdering, FailureOrdering, SingleThread)
}
#[no_mangle]
pub extern "C" fn LLVMIsPackedStruct(StructTy: LLVMTypeRef) -> LLVMBool {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMTypeRef) -> LLVMBool,
            >(stringify!(LLVMIsPackedStruct).as_bytes())
    }
        .expect(stringify!(LLVMIsPackedStruct));
    entry(StructTy)
}
#[no_mangle]
pub extern "C" fn LLVMIsAFunction(Val: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMIsAFunction).as_bytes())
    }
        .expect(stringify!(LLVMIsAFunction));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn LLVMBuildAtomicCmpXchgSyncScope(
    B: LLVMBuilderRef,
    Ptr: LLVMValueRef,
    Cmp: LLVMValueRef,
    New: LLVMValueRef,
    SuccessOrdering: LLVMAtomicOrdering,
    FailureOrdering: LLVMAtomicOrdering,
    SSID: ::libc::c_uint,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMBuilderRef,
                    LLVMValueRef,
                    LLVMValueRef,
                    LLVMValueRef,
                    LLVMAtomicOrdering,
                    LLVMAtomicOrdering,
                    ::libc::c_uint,
                ) -> LLVMValueRef,
            >(stringify!(LLVMBuildAtomicCmpXchgSyncScope).as_bytes())
    }
        .expect(stringify!(LLVMBuildAtomicCmpXchgSyncScope));
    entry(B, Ptr, Cmp, New, SuccessOrdering, FailureOrdering, SSID)
}
#[no_mangle]
pub extern "C" fn LLVMDITypeGetLine(DType: LLVMMetadataRef) -> ::libc::c_uint {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMMetadataRef) -> ::libc::c_uint,
            >(stringify!(LLVMDITypeGetLine).as_bytes())
    }
        .expect(stringify!(LLVMDITypeGetLine));
    entry(DType)
}
#[no_mangle]
pub extern "C" fn LLVMGetStringAttributeAtIndex(
    F: LLVMValueRef,
    Idx: LLVMAttributeIndex,
    K: *const ::libc::c_char,
    KLen: ::libc::c_uint,
) -> LLVMAttributeRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMValueRef,
                    LLVMAttributeIndex,
                    *const ::libc::c_char,
                    ::libc::c_uint,
                ) -> LLVMAttributeRef,
            >(stringify!(LLVMGetStringAttributeAtIndex).as_bytes())
    }
        .expect(stringify!(LLVMGetStringAttributeAtIndex));
    entry(F, Idx, K, KLen)
}
#[no_mangle]
pub extern "C" fn LLVMLinkModules2(Dest: LLVMModuleRef, Src: LLVMModuleRef) -> LLVMBool {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMModuleRef, LLVMModuleRef) -> LLVMBool,
            >(stringify!(LLVMLinkModules2).as_bytes())
    }
        .expect(stringify!(LLVMLinkModules2));
    entry(Dest, Src)
}
#[no_mangle]
pub extern "C" fn LLVMRunPassesOnFunction(
    F: LLVMValueRef,
    Passes: *const ::libc::c_char,
    TM: LLVMTargetMachineRef,
    Options: LLVMPassBuilderOptionsRef,
) -> LLVMErrorRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMValueRef,
                    *const ::libc::c_char,
                    LLVMTargetMachineRef,
                    LLVMPassBuilderOptionsRef,
                ) -> LLVMErrorRef,
            >(stringify!(LLVMRunPassesOnFunction).as_bytes())
    }
        .expect(stringify!(LLVMRunPassesOnFunction));
    entry(F, Passes, TM, Options)
}
#[no_mangle]
pub extern "C" fn LLVMDIBuilderCreateTempGlobalVariableFwdDecl(
    Builder: LLVMDIBuilderRef,
    Scope: LLVMMetadataRef,
    Name: *const ::libc::c_char,
    NameLen: ::libc::size_t,
    Linkage: *const ::libc::c_char,
    LnkLen: ::libc::size_t,
    File: LLVMMetadataRef,
    LineNo: ::libc::c_uint,
    Ty: LLVMMetadataRef,
    LocalToUnit: LLVMBool,
    Decl: LLVMMetadataRef,
    AlignInBits: u32,
) -> LLVMMetadataRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMDIBuilderRef,
                    LLVMMetadataRef,
                    *const ::libc::c_char,
                    ::libc::size_t,
                    *const ::libc::c_char,
                    ::libc::size_t,
                    LLVMMetadataRef,
                    ::libc::c_uint,
                    LLVMMetadataRef,
                    LLVMBool,
                    LLVMMetadataRef,
                    u32,
                ) -> LLVMMetadataRef,
            >(stringify!(LLVMDIBuilderCreateTempGlobalVariableFwdDecl).as_bytes())
    }
        .expect(stringify!(LLVMDIBuilderCreateTempGlobalVariableFwdDecl));
    entry(
        Builder,
        Scope,
        Name,
        NameLen,
        Linkage,
        LnkLen,
        File,
        LineNo,
        Ty,
        LocalToUnit,
        Decl,
        AlignInBits,
    )
}
#[no_mangle]
pub extern "C" fn lto_input_get_num_dependent_libraries(
    input: lto_input_t,
) -> ::libc::c_uint {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(lto_input_t) -> ::libc::c_uint,
            >(stringify!(lto_input_get_num_dependent_libraries).as_bytes())
    }
        .expect(stringify!(lto_input_get_num_dependent_libraries));
    entry(input)
}
#[no_mangle]
pub extern "C" fn LLVMMoveToNextSymbol(SI: LLVMSymbolIteratorRef) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMSymbolIteratorRef),
            >(stringify!(LLVMMoveToNextSymbol).as_bytes())
    }
        .expect(stringify!(LLVMMoveToNextSymbol));
    entry(SI)
}
#[no_mangle]
pub extern "C" fn LLVMStructSetBody(
    StructTy: LLVMTypeRef,
    ElementTypes: *mut LLVMTypeRef,
    ElementCount: ::libc::c_uint,
    Packed: LLVMBool,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMTypeRef, *mut LLVMTypeRef, ::libc::c_uint, LLVMBool),
            >(stringify!(LLVMStructSetBody).as_bytes())
    }
        .expect(stringify!(LLVMStructSetBody));
    entry(StructTy, ElementTypes, ElementCount, Packed)
}
#[no_mangle]
pub extern "C" fn LLVMRemarkEntryGetDebugLoc(
    Remark: LLVMRemarkEntryRef,
) -> LLVMRemarkDebugLocRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMRemarkEntryRef) -> LLVMRemarkDebugLocRef,
            >(stringify!(LLVMRemarkEntryGetDebugLoc).as_bytes())
    }
        .expect(stringify!(LLVMRemarkEntryGetDebugLoc));
    entry(Remark)
}
#[no_mangle]
pub extern "C" fn LLVMGetModuleInlineAsm(
    M: LLVMModuleRef,
    Len: *mut ::libc::size_t,
) -> *const ::libc::c_char {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMModuleRef,
                    *mut ::libc::size_t,
                ) -> *const ::libc::c_char,
            >(stringify!(LLVMGetModuleInlineAsm).as_bytes())
    }
        .expect(stringify!(LLVMGetModuleInlineAsm));
    entry(M, Len)
}
#[no_mangle]
pub extern "C" fn LLVMIsSymbolIteratorAtEnd(
    ObjectFile: LLVMObjectFileRef,
    SI: LLVMSymbolIteratorRef,
) -> LLVMBool {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMObjectFileRef, LLVMSymbolIteratorRef) -> LLVMBool,
            >(stringify!(LLVMIsSymbolIteratorAtEnd).as_bytes())
    }
        .expect(stringify!(LLVMIsSymbolIteratorAtEnd));
    entry(ObjectFile, SI)
}
#[no_mangle]
pub extern "C" fn LLVMOrcExecutionSessionIntern(
    ES: LLVMOrcExecutionSessionRef,
    Name: *const ::libc::c_char,
) -> LLVMOrcSymbolStringPoolEntryRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMOrcExecutionSessionRef,
                    *const ::libc::c_char,
                ) -> LLVMOrcSymbolStringPoolEntryRef,
            >(stringify!(LLVMOrcExecutionSessionIntern).as_bytes())
    }
        .expect(stringify!(LLVMOrcExecutionSessionIntern));
    entry(ES, Name)
}
#[no_mangle]
pub extern "C" fn LLVMSetParentCatchSwitch(
    CatchPad: LLVMValueRef,
    CatchSwitch: LLVMValueRef,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, LLVMValueRef),
            >(stringify!(LLVMSetParentCatchSwitch).as_bytes())
    }
        .expect(stringify!(LLVMSetParentCatchSwitch));
    entry(CatchPad, CatchSwitch)
}
#[no_mangle]
pub extern "C" fn LLVMPassBuilderOptionsSetCallGraphProfile(
    Options: LLVMPassBuilderOptionsRef,
    CallGraphProfile: LLVMBool,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMPassBuilderOptionsRef, LLVMBool),
            >(stringify!(LLVMPassBuilderOptionsSetCallGraphProfile).as_bytes())
    }
        .expect(stringify!(LLVMPassBuilderOptionsSetCallGraphProfile));
    entry(Options, CallGraphProfile)
}
#[no_mangle]
pub extern "C" fn LLVMLoadLibraryPermanently(
    Filename: *const ::libc::c_char,
) -> LLVMBool {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(*const ::libc::c_char) -> LLVMBool,
            >(stringify!(LLVMLoadLibraryPermanently).as_bytes())
    }
        .expect(stringify!(LLVMLoadLibraryPermanently));
    entry(Filename)
}
#[no_mangle]
pub extern "C" fn LLVMDbgVariableRecordGetValue(
    Rec: LLVMDbgRecordRef,
    OpIdx: ::libc::c_uint,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMDbgRecordRef, ::libc::c_uint) -> LLVMValueRef,
            >(stringify!(LLVMDbgVariableRecordGetValue).as_bytes())
    }
        .expect(stringify!(LLVMDbgVariableRecordGetValue));
    entry(Rec, OpIdx)
}
#[no_mangle]
pub extern "C" fn LLVMDIBuilderCreateAutoVariable(
    Builder: LLVMDIBuilderRef,
    Scope: LLVMMetadataRef,
    Name: *const ::libc::c_char,
    NameLen: ::libc::size_t,
    File: LLVMMetadataRef,
    LineNo: ::libc::c_uint,
    Ty: LLVMMetadataRef,
    AlwaysPreserve: LLVMBool,
    Flags: LLVMDIFlags,
    AlignInBits: u32,
) -> LLVMMetadataRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMDIBuilderRef,
                    LLVMMetadataRef,
                    *const ::libc::c_char,
                    ::libc::size_t,
                    LLVMMetadataRef,
                    ::libc::c_uint,
                    LLVMMetadataRef,
                    LLVMBool,
                    LLVMDIFlags,
                    u32,
                ) -> LLVMMetadataRef,
            >(stringify!(LLVMDIBuilderCreateAutoVariable).as_bytes())
    }
        .expect(stringify!(LLVMDIBuilderCreateAutoVariable));
    entry(
        Builder,
        Scope,
        Name,
        NameLen,
        File,
        LineNo,
        Ty,
        AlwaysPreserve,
        Flags,
        AlignInBits,
    )
}
#[no_mangle]
pub extern "C" fn LLVMGlobalSetMetadata(
    Global: LLVMValueRef,
    Kind: ::libc::c_uint,
    MD: LLVMMetadataRef,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, ::libc::c_uint, LLVMMetadataRef),
            >(stringify!(LLVMGlobalSetMetadata).as_bytes())
    }
        .expect(stringify!(LLVMGlobalSetMetadata));
    entry(Global, Kind, MD)
}
#[no_mangle]
pub extern "C" fn LLVMSetAtomicRMWBinOp(
    AtomicRMWInst: LLVMValueRef,
    BinOp: LLVMAtomicRMWBinOp,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, LLVMAtomicRMWBinOp),
            >(stringify!(LLVMSetAtomicRMWBinOp).as_bytes())
    }
        .expect(stringify!(LLVMSetAtomicRMWBinOp));
    entry(AtomicRMWInst, BinOp)
}
#[no_mangle]
pub extern "C" fn LLVMDIBuilderCreateFile(
    Builder: LLVMDIBuilderRef,
    Filename: *const ::libc::c_char,
    FilenameLen: ::libc::size_t,
    Directory: *const ::libc::c_char,
    DirectoryLen: ::libc::size_t,
) -> LLVMMetadataRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMDIBuilderRef,
                    *const ::libc::c_char,
                    ::libc::size_t,
                    *const ::libc::c_char,
                    ::libc::size_t,
                ) -> LLVMMetadataRef,
            >(stringify!(LLVMDIBuilderCreateFile).as_bytes())
    }
        .expect(stringify!(LLVMDIBuilderCreateFile));
    entry(Builder, Filename, FilenameLen, Directory, DirectoryLen)
}
#[no_mangle]
pub extern "C" fn LLVMCountBasicBlocks(Fn: LLVMValueRef) -> ::libc::c_uint {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> ::libc::c_uint,
            >(stringify!(LLVMCountBasicBlocks).as_bytes())
    }
        .expect(stringify!(LLVMCountBasicBlocks));
    entry(Fn)
}
#[no_mangle]
pub extern "C" fn LLVMIsALandingPadInst(Val: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMIsALandingPadInst).as_bytes())
    }
        .expect(stringify!(LLVMIsALandingPadInst));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn LLVMCreateDIBuilderDisallowUnresolved(
    M: LLVMModuleRef,
) -> LLVMDIBuilderRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMModuleRef) -> LLVMDIBuilderRef,
            >(stringify!(LLVMCreateDIBuilderDisallowUnresolved).as_bytes())
    }
        .expect(stringify!(LLVMCreateDIBuilderDisallowUnresolved));
    entry(M)
}
#[no_mangle]
pub extern "C" fn LLVMInitializeARMDisassembler() {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<extern "C" fn()>(stringify!(LLVMInitializeARMDisassembler).as_bytes())
    }
        .expect(stringify!(LLVMInitializeARMDisassembler));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMGetTargetDescription(T: LLVMTargetRef) -> *const ::libc::c_char {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMTargetRef) -> *const ::libc::c_char,
            >(stringify!(LLVMGetTargetDescription).as_bytes())
    }
        .expect(stringify!(LLVMGetTargetDescription));
    entry(T)
}
#[no_mangle]
pub extern "C" fn LLVMAddAttributeAtIndex(
    F: LLVMValueRef,
    Idx: LLVMAttributeIndex,
    A: LLVMAttributeRef,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, LLVMAttributeIndex, LLVMAttributeRef),
            >(stringify!(LLVMAddAttributeAtIndex).as_bytes())
    }
        .expect(stringify!(LLVMAddAttributeAtIndex));
    entry(F, Idx, A)
}
#[no_mangle]
pub extern "C" fn LLVMConstNull(Ty: LLVMTypeRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMTypeRef) -> LLVMValueRef,
            >(stringify!(LLVMConstNull).as_bytes())
    }
        .expect(stringify!(LLVMConstNull));
    entry(Ty)
}
#[no_mangle]
pub extern "C" fn LLVMEnablePrettyStackTrace() {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<extern "C" fn()>(stringify!(LLVMEnablePrettyStackTrace).as_bytes())
    }
        .expect(stringify!(LLVMEnablePrettyStackTrace));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMOrcJITDylibCreateResourceTracker(
    JD: LLVMOrcJITDylibRef,
) -> LLVMOrcResourceTrackerRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMOrcJITDylibRef) -> LLVMOrcResourceTrackerRef,
            >(stringify!(LLVMOrcJITDylibCreateResourceTracker).as_bytes())
    }
        .expect(stringify!(LLVMOrcJITDylibCreateResourceTracker));
    entry(JD)
}
#[no_mangle]
pub extern "C" fn LLVMPrintModuleToString(M: LLVMModuleRef) -> *mut ::libc::c_char {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMModuleRef) -> *mut ::libc::c_char,
            >(stringify!(LLVMPrintModuleToString).as_bytes())
    }
        .expect(stringify!(LLVMPrintModuleToString));
    entry(M)
}
#[no_mangle]
pub extern "C" fn thinlto_create_codegen() -> thinlto_code_gen_t {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn() -> thinlto_code_gen_t,
            >(stringify!(thinlto_create_codegen).as_bytes())
    }
        .expect(stringify!(thinlto_create_codegen));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMOrcObjectLayerAddObjectFileWithRT(
    ObjLayer: LLVMOrcObjectLayerRef,
    RT: LLVMOrcResourceTrackerRef,
    ObjBuffer: LLVMMemoryBufferRef,
) -> LLVMErrorRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMOrcObjectLayerRef,
                    LLVMOrcResourceTrackerRef,
                    LLVMMemoryBufferRef,
                ) -> LLVMErrorRef,
            >(stringify!(LLVMOrcObjectLayerAddObjectFileWithRT).as_bytes())
    }
        .expect(stringify!(LLVMOrcObjectLayerAddObjectFileWithRT));
    entry(ObjLayer, RT, ObjBuffer)
}
#[no_mangle]
pub extern "C" fn LLVMGetNamedMetadataNumOperands(
    M: LLVMModuleRef,
    name: *const ::libc::c_char,
) -> ::libc::c_uint {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMModuleRef, *const ::libc::c_char) -> ::libc::c_uint,
            >(stringify!(LLVMGetNamedMetadataNumOperands).as_bytes())
    }
        .expect(stringify!(LLVMGetNamedMetadataNumOperands));
    entry(M, name)
}
#[no_mangle]
pub extern "C" fn LLVMBuildZExtOrBitCast(
    arg1: LLVMBuilderRef,
    Val: LLVMValueRef,
    DestTy: LLVMTypeRef,
    Name: *const ::libc::c_char,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMBuilderRef,
                    LLVMValueRef,
                    LLVMTypeRef,
                    *const ::libc::c_char,
                ) -> LLVMValueRef,
            >(stringify!(LLVMBuildZExtOrBitCast).as_bytes())
    }
        .expect(stringify!(LLVMBuildZExtOrBitCast));
    entry(arg1, Val, DestTy, Name)
}
#[no_mangle]
pub extern "C" fn lto_set_debug_options(
    options: *mut *const ::libc::c_char,
    number: ::libc::c_int,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(*mut *const ::libc::c_char, ::libc::c_int),
            >(stringify!(lto_set_debug_options).as_bytes())
    }
        .expect(stringify!(lto_set_debug_options));
    entry(options, number)
}
#[no_mangle]
pub extern "C" fn LLVMGetOperandBundleTag(
    Bundle: LLVMOperandBundleRef,
    Len: *mut ::libc::size_t,
) -> *const ::libc::c_char {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMOperandBundleRef,
                    *mut ::libc::size_t,
                ) -> *const ::libc::c_char,
            >(stringify!(LLVMGetOperandBundleTag).as_bytes())
    }
        .expect(stringify!(LLVMGetOperandBundleTag));
    entry(Bundle, Len)
}
#[no_mangle]
pub extern "C" fn LLVMGetPreviousGlobalIFunc(IFunc: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMGetPreviousGlobalIFunc).as_bytes())
    }
        .expect(stringify!(LLVMGetPreviousGlobalIFunc));
    entry(IFunc)
}
#[no_mangle]
pub extern "C" fn LLVMDIBuilderInsertDeclareRecordBefore(
    Builder: LLVMDIBuilderRef,
    Storage: LLVMValueRef,
    VarInfo: LLVMMetadataRef,
    Expr: LLVMMetadataRef,
    DebugLoc: LLVMMetadataRef,
    Instr: LLVMValueRef,
) -> LLVMDbgRecordRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMDIBuilderRef,
                    LLVMValueRef,
                    LLVMMetadataRef,
                    LLVMMetadataRef,
                    LLVMMetadataRef,
                    LLVMValueRef,
                ) -> LLVMDbgRecordRef,
            >(stringify!(LLVMDIBuilderInsertDeclareRecordBefore).as_bytes())
    }
        .expect(stringify!(LLVMDIBuilderInsertDeclareRecordBefore));
    entry(Builder, Storage, VarInfo, Expr, DebugLoc, Instr)
}
#[no_mangle]
pub extern "C" fn LLVMIsAMDString(Val: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMIsAMDString).as_bytes())
    }
        .expect(stringify!(LLVMIsAMDString));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn LLVMGetNextUse(U: LLVMUseRef) -> LLVMUseRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMUseRef) -> LLVMUseRef,
            >(stringify!(LLVMGetNextUse).as_bytes())
    }
        .expect(stringify!(LLVMGetNextUse));
    entry(U)
}
#[no_mangle]
pub extern "C" fn LLVMGetOperand(
    Val: LLVMValueRef,
    Index: ::libc::c_uint,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, ::libc::c_uint) -> LLVMValueRef,
            >(stringify!(LLVMGetOperand).as_bytes())
    }
        .expect(stringify!(LLVMGetOperand));
    entry(Val, Index)
}
#[no_mangle]
pub extern "C" fn LLVMIntrinsicCopyOverloadedName2(
    Mod: LLVMModuleRef,
    ID: ::libc::c_uint,
    ParamTypes: *mut LLVMTypeRef,
    ParamCount: ::libc::size_t,
    NameLength: *mut ::libc::size_t,
) -> *mut ::libc::c_char {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMModuleRef,
                    ::libc::c_uint,
                    *mut LLVMTypeRef,
                    ::libc::size_t,
                    *mut ::libc::size_t,
                ) -> *mut ::libc::c_char,
            >(stringify!(LLVMIntrinsicCopyOverloadedName2).as_bytes())
    }
        .expect(stringify!(LLVMIntrinsicCopyOverloadedName2));
    entry(Mod, ID, ParamTypes, ParamCount, NameLength)
}
#[no_mangle]
pub extern "C" fn LLVMDIBuilderCreateLexicalBlockFile(
    Builder: LLVMDIBuilderRef,
    Scope: LLVMMetadataRef,
    File: LLVMMetadataRef,
    Discriminator: ::libc::c_uint,
) -> LLVMMetadataRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMDIBuilderRef,
                    LLVMMetadataRef,
                    LLVMMetadataRef,
                    ::libc::c_uint,
                ) -> LLVMMetadataRef,
            >(stringify!(LLVMDIBuilderCreateLexicalBlockFile).as_bytes())
    }
        .expect(stringify!(LLVMDIBuilderCreateLexicalBlockFile));
    entry(Builder, Scope, File, Discriminator)
}
#[no_mangle]
pub extern "C" fn LLVMDIBuilderCreateUnspecifiedType(
    Builder: LLVMDIBuilderRef,
    Name: *const ::libc::c_char,
    NameLen: ::libc::size_t,
) -> LLVMMetadataRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMDIBuilderRef,
                    *const ::libc::c_char,
                    ::libc::size_t,
                ) -> LLVMMetadataRef,
            >(stringify!(LLVMDIBuilderCreateUnspecifiedType).as_bytes())
    }
        .expect(stringify!(LLVMDIBuilderCreateUnspecifiedType));
    entry(Builder, Name, NameLen)
}
#[no_mangle]
pub extern "C" fn LLVMOrcLLJITGetIRTransformLayer(
    J: LLVMOrcLLJITRef,
) -> LLVMOrcIRTransformLayerRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMOrcLLJITRef) -> LLVMOrcIRTransformLayerRef,
            >(stringify!(LLVMOrcLLJITGetIRTransformLayer).as_bytes())
    }
        .expect(stringify!(LLVMOrcLLJITGetIRTransformLayer));
    entry(J)
}
#[no_mangle]
pub extern "C" fn LLVMGetPreviousDbgRecord(
    DbgRecord: LLVMDbgRecordRef,
) -> LLVMDbgRecordRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMDbgRecordRef) -> LLVMDbgRecordRef,
            >(stringify!(LLVMGetPreviousDbgRecord).as_bytes())
    }
        .expect(stringify!(LLVMGetPreviousDbgRecord));
    entry(DbgRecord)
}
#[no_mangle]
pub extern "C" fn LLVMAddGlobalIFunc(
    M: LLVMModuleRef,
    Name: *const ::libc::c_char,
    NameLen: ::libc::size_t,
    Ty: LLVMTypeRef,
    AddrSpace: ::libc::c_uint,
    Resolver: LLVMValueRef,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMModuleRef,
                    *const ::libc::c_char,
                    ::libc::size_t,
                    LLVMTypeRef,
                    ::libc::c_uint,
                    LLVMValueRef,
                ) -> LLVMValueRef,
            >(stringify!(LLVMAddGlobalIFunc).as_bytes())
    }
        .expect(stringify!(LLVMAddGlobalIFunc));
    entry(M, Name, NameLen, Ty, AddrSpace, Resolver)
}
#[no_mangle]
pub extern "C" fn LLVMIsAPHINode(Val: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMIsAPHINode).as_bytes())
    }
        .expect(stringify!(LLVMIsAPHINode));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn LLVMPassBuilderOptionsSetMergeFunctions(
    Options: LLVMPassBuilderOptionsRef,
    MergeFunctions: LLVMBool,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMPassBuilderOptionsRef, LLVMBool),
            >(stringify!(LLVMPassBuilderOptionsSetMergeFunctions).as_bytes())
    }
        .expect(stringify!(LLVMPassBuilderOptionsSetMergeFunctions));
    entry(Options, MergeFunctions)
}
#[no_mangle]
pub extern "C" fn LLVMVoidType() -> LLVMTypeRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<extern "C" fn() -> LLVMTypeRef>(stringify!(LLVMVoidType).as_bytes())
    }
        .expect(stringify!(LLVMVoidType));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMConstIntToPtr(
    ConstantVal: LLVMValueRef,
    ToType: LLVMTypeRef,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, LLVMTypeRef) -> LLVMValueRef,
            >(stringify!(LLVMConstIntToPtr).as_bytes())
    }
        .expect(stringify!(LLVMConstIntToPtr));
    entry(ConstantVal, ToType)
}
#[no_mangle]
pub extern "C" fn LLVMGetBitcodeModule(
    MemBuf: LLVMMemoryBufferRef,
    OutM: *mut LLVMModuleRef,
    OutMessage: *mut *mut ::libc::c_char,
) -> LLVMBool {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMMemoryBufferRef,
                    *mut LLVMModuleRef,
                    *mut *mut ::libc::c_char,
                ) -> LLVMBool,
            >(stringify!(LLVMGetBitcodeModule).as_bytes())
    }
        .expect(stringify!(LLVMGetBitcodeModule));
    entry(MemBuf, OutM, OutMessage)
}
#[no_mangle]
pub extern "C" fn LLVMInitializeWebAssemblyAsmParser() {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(),
            >(stringify!(LLVMInitializeWebAssemblyAsmParser).as_bytes())
    }
        .expect(stringify!(LLVMInitializeWebAssemblyAsmParser));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMSetCondition(Branch: LLVMValueRef, Cond: LLVMValueRef) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, LLVMValueRef),
            >(stringify!(LLVMSetCondition).as_bytes())
    }
        .expect(stringify!(LLVMSetCondition));
    entry(Branch, Cond)
}
#[no_mangle]
pub extern "C" fn LLVMOrcThreadSafeContextGetContext(
    TSCtx: LLVMOrcThreadSafeContextRef,
) -> LLVMContextRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMOrcThreadSafeContextRef) -> LLVMContextRef,
            >(stringify!(LLVMOrcThreadSafeContextGetContext).as_bytes())
    }
        .expect(stringify!(LLVMOrcThreadSafeContextGetContext));
    entry(TSCtx)
}
#[no_mangle]
pub extern "C" fn LLVMGetModuleFlag(
    M: LLVMModuleRef,
    Key: *const ::libc::c_char,
    KeyLen: ::libc::size_t,
) -> LLVMMetadataRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMModuleRef,
                    *const ::libc::c_char,
                    ::libc::size_t,
                ) -> LLVMMetadataRef,
            >(stringify!(LLVMGetModuleFlag).as_bytes())
    }
        .expect(stringify!(LLVMGetModuleFlag));
    entry(M, Key, KeyLen)
}
#[no_mangle]
pub extern "C" fn LLVMGetDebugLocColumn(Val: LLVMValueRef) -> ::libc::c_uint {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> ::libc::c_uint,
            >(stringify!(LLVMGetDebugLocColumn).as_bytes())
    }
        .expect(stringify!(LLVMGetDebugLocColumn));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn LLVMShutdown() {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<extern "C" fn()>(stringify!(LLVMShutdown).as_bytes())
    }
        .expect(stringify!(LLVMShutdown));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMGetFirstParam(Fn: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMGetFirstParam).as_bytes())
    }
        .expect(stringify!(LLVMGetFirstParam));
    entry(Fn)
}
#[no_mangle]
pub extern "C" fn LLVMBuildCatchPad(
    B: LLVMBuilderRef,
    ParentPad: LLVMValueRef,
    Args: *mut LLVMValueRef,
    NumArgs: ::libc::c_uint,
    Name: *const ::libc::c_char,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMBuilderRef,
                    LLVMValueRef,
                    *mut LLVMValueRef,
                    ::libc::c_uint,
                    *const ::libc::c_char,
                ) -> LLVMValueRef,
            >(stringify!(LLVMBuildCatchPad).as_bytes())
    }
        .expect(stringify!(LLVMBuildCatchPad));
    entry(B, ParentPad, Args, NumArgs, Name)
}
#[no_mangle]
pub extern "C" fn LLVMStructGetTypeAtIndex(
    StructTy: LLVMTypeRef,
    i: ::libc::c_uint,
) -> LLVMTypeRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMTypeRef, ::libc::c_uint) -> LLVMTypeRef,
            >(stringify!(LLVMStructGetTypeAtIndex).as_bytes())
    }
        .expect(stringify!(LLVMStructGetTypeAtIndex));
    entry(StructTy, i)
}
#[no_mangle]
pub extern "C" fn LLVMOrcDisposeLLJITBuilder(Builder: LLVMOrcLLJITBuilderRef) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMOrcLLJITBuilderRef),
            >(stringify!(LLVMOrcDisposeLLJITBuilder).as_bytes())
    }
        .expect(stringify!(LLVMOrcDisposeLLJITBuilder));
    entry(Builder)
}
#[no_mangle]
pub extern "C" fn LLVMBuildFPToSI(
    arg1: LLVMBuilderRef,
    Val: LLVMValueRef,
    DestTy: LLVMTypeRef,
    Name: *const ::libc::c_char,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMBuilderRef,
                    LLVMValueRef,
                    LLVMTypeRef,
                    *const ::libc::c_char,
                ) -> LLVMValueRef,
            >(stringify!(LLVMBuildFPToSI).as_bytes())
    }
        .expect(stringify!(LLVMBuildFPToSI));
    entry(arg1, Val, DestTy, Name)
}
#[no_mangle]
pub extern "C" fn LLVMConstNUWMul(
    LHSConstant: LLVMValueRef,
    RHSConstant: LLVMValueRef,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMConstNUWMul).as_bytes())
    }
        .expect(stringify!(LLVMConstNUWMul));
    entry(LHSConstant, RHSConstant)
}
#[no_mangle]
pub extern "C" fn LLVMPositionBuilderBeforeDbgRecords(
    Builder: LLVMBuilderRef,
    Block: LLVMBasicBlockRef,
    Inst: LLVMValueRef,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMBuilderRef, LLVMBasicBlockRef, LLVMValueRef),
            >(stringify!(LLVMPositionBuilderBeforeDbgRecords).as_bytes())
    }
        .expect(stringify!(LLVMPositionBuilderBeforeDbgRecords));
    entry(Builder, Block, Inst)
}
#[no_mangle]
pub extern "C" fn LLVMTokenTypeInContext(C: LLVMContextRef) -> LLVMTypeRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMContextRef) -> LLVMTypeRef,
            >(stringify!(LLVMTokenTypeInContext).as_bytes())
    }
        .expect(stringify!(LLVMTokenTypeInContext));
    entry(C)
}
#[no_mangle]
pub extern "C" fn LLVMOrcResourceTrackerRemove(
    RT: LLVMOrcResourceTrackerRef,
) -> LLVMErrorRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMOrcResourceTrackerRef) -> LLVMErrorRef,
            >(stringify!(LLVMOrcResourceTrackerRemove).as_bytes())
    }
        .expect(stringify!(LLVMOrcResourceTrackerRemove));
    entry(RT)
}
#[no_mangle]
pub extern "C" fn LLVMIsACmpInst(Val: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMIsACmpInst).as_bytes())
    }
        .expect(stringify!(LLVMIsACmpInst));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn LLVMBuildSIToFP(
    arg1: LLVMBuilderRef,
    Val: LLVMValueRef,
    DestTy: LLVMTypeRef,
    Name: *const ::libc::c_char,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMBuilderRef,
                    LLVMValueRef,
                    LLVMTypeRef,
                    *const ::libc::c_char,
                ) -> LLVMValueRef,
            >(stringify!(LLVMBuildSIToFP).as_bytes())
    }
        .expect(stringify!(LLVMBuildSIToFP));
    entry(arg1, Val, DestTy, Name)
}
#[no_mangle]
pub extern "C" fn LLVMSetThreadLocalMode(
    GlobalVar: LLVMValueRef,
    Mode: LLVMThreadLocalMode,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, LLVMThreadLocalMode),
            >(stringify!(LLVMSetThreadLocalMode).as_bytes())
    }
        .expect(stringify!(LLVMSetThreadLocalMode));
    entry(GlobalVar, Mode)
}
#[no_mangle]
pub extern "C" fn LLVMCreateIntelJITEventListener() -> LLVMJITEventListenerRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn() -> LLVMJITEventListenerRef,
            >(stringify!(LLVMCreateIntelJITEventListener).as_bytes())
    }
        .expect(stringify!(LLVMCreateIntelJITEventListener));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMDIBuilderCreateSubrangeType(
    Builder: LLVMDIBuilderRef,
    Scope: LLVMMetadataRef,
    Name: *const ::libc::c_char,
    NameLen: ::libc::size_t,
    LineNo: ::libc::c_uint,
    File: LLVMMetadataRef,
    SizeInBits: u64,
    AlignInBits: u32,
    Flags: LLVMDIFlags,
    BaseTy: LLVMMetadataRef,
    LowerBound: LLVMMetadataRef,
    UpperBound: LLVMMetadataRef,
    Stride: LLVMMetadataRef,
    Bias: LLVMMetadataRef,
) -> LLVMMetadataRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMDIBuilderRef,
                    LLVMMetadataRef,
                    *const ::libc::c_char,
                    ::libc::size_t,
                    ::libc::c_uint,
                    LLVMMetadataRef,
                    u64,
                    u32,
                    LLVMDIFlags,
                    LLVMMetadataRef,
                    LLVMMetadataRef,
                    LLVMMetadataRef,
                    LLVMMetadataRef,
                    LLVMMetadataRef,
                ) -> LLVMMetadataRef,
            >(stringify!(LLVMDIBuilderCreateSubrangeType).as_bytes())
    }
        .expect(stringify!(LLVMDIBuilderCreateSubrangeType));
    entry(
        Builder,
        Scope,
        Name,
        NameLen,
        LineNo,
        File,
        SizeInBits,
        AlignInBits,
        Flags,
        BaseTy,
        LowerBound,
        UpperBound,
        Stride,
        Bias,
    )
}
#[no_mangle]
pub extern "C" fn LLVMInitializeMipsTargetMC() {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<extern "C" fn()>(stringify!(LLVMInitializeMipsTargetMC).as_bytes())
    }
        .expect(stringify!(LLVMInitializeMipsTargetMC));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMStoreSizeOfType(
    TD: LLVMTargetDataRef,
    Ty: LLVMTypeRef,
) -> ::libc::c_ulonglong {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMTargetDataRef, LLVMTypeRef) -> ::libc::c_ulonglong,
            >(stringify!(LLVMStoreSizeOfType).as_bytes())
    }
        .expect(stringify!(LLVMStoreSizeOfType));
    entry(TD, Ty)
}
#[no_mangle]
pub extern "C" fn LLVMGetCallSiteAttributes(
    C: LLVMValueRef,
    Idx: LLVMAttributeIndex,
    Attrs: *mut LLVMAttributeRef,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, LLVMAttributeIndex, *mut LLVMAttributeRef),
            >(stringify!(LLVMGetCallSiteAttributes).as_bytes())
    }
        .expect(stringify!(LLVMGetCallSiteAttributes));
    entry(C, Idx, Attrs)
}
#[no_mangle]
pub extern "C" fn LLVMInitializeLoongArchAsmPrinter() {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(),
            >(stringify!(LLVMInitializeLoongArchAsmPrinter).as_bytes())
    }
        .expect(stringify!(LLVMInitializeLoongArchAsmPrinter));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMGetTypeByName2(
    C: LLVMContextRef,
    Name: *const ::libc::c_char,
) -> LLVMTypeRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMContextRef, *const ::libc::c_char) -> LLVMTypeRef,
            >(stringify!(LLVMGetTypeByName2).as_bytes())
    }
        .expect(stringify!(LLVMGetTypeByName2));
    entry(C, Name)
}
#[no_mangle]
pub extern "C" fn LLVMGetLastGlobalIFunc(M: LLVMModuleRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMModuleRef) -> LLVMValueRef,
            >(stringify!(LLVMGetLastGlobalIFunc).as_bytes())
    }
        .expect(stringify!(LLVMGetLastGlobalIFunc));
    entry(M)
}
#[no_mangle]
pub extern "C" fn LLVMInitializeXCoreTarget() {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<extern "C" fn()>(stringify!(LLVMInitializeXCoreTarget).as_bytes())
    }
        .expect(stringify!(LLVMInitializeXCoreTarget));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMCountParamTypes(FunctionTy: LLVMTypeRef) -> ::libc::c_uint {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMTypeRef) -> ::libc::c_uint,
            >(stringify!(LLVMCountParamTypes).as_bytes())
    }
        .expect(stringify!(LLVMCountParamTypes));
    entry(FunctionTy)
}
#[no_mangle]
pub extern "C" fn LLVMIsAExtractValueInst(Val: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMIsAExtractValueInst).as_bytes())
    }
        .expect(stringify!(LLVMIsAExtractValueInst));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn LLVMInitializeBPFDisassembler() {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<extern "C" fn()>(stringify!(LLVMInitializeBPFDisassembler).as_bytes())
    }
        .expect(stringify!(LLVMInitializeBPFDisassembler));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMMoveBasicBlockBefore(
    BB: LLVMBasicBlockRef,
    MovePos: LLVMBasicBlockRef,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMBasicBlockRef, LLVMBasicBlockRef),
            >(stringify!(LLVMMoveBasicBlockBefore).as_bytes())
    }
        .expect(stringify!(LLVMMoveBasicBlockBefore));
    entry(BB, MovePos)
}
#[no_mangle]
pub extern "C" fn LLVMInitializeAMDGPUAsmPrinter() {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(),
            >(stringify!(LLVMInitializeAMDGPUAsmPrinter).as_bytes())
    }
        .expect(stringify!(LLVMInitializeAMDGPUAsmPrinter));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMIsAMemSetInst(Val: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMIsAMemSetInst).as_bytes())
    }
        .expect(stringify!(LLVMIsAMemSetInst));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn LLVMIsAFCmpInst(Val: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMIsAFCmpInst).as_bytes())
    }
        .expect(stringify!(LLVMIsAFCmpInst));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn LLVMFloatTypeInContext(C: LLVMContextRef) -> LLVMTypeRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMContextRef) -> LLVMTypeRef,
            >(stringify!(LLVMFloatTypeInContext).as_bytes())
    }
        .expect(stringify!(LLVMFloatTypeInContext));
    entry(C)
}
#[no_mangle]
pub extern "C" fn LLVMIsNull(Val: LLVMValueRef) -> LLVMBool {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMBool,
            >(stringify!(LLVMIsNull).as_bytes())
    }
        .expect(stringify!(LLVMIsNull));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn LLVMValueAsMetadata(Val: LLVMValueRef) -> LLVMMetadataRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMMetadataRef,
            >(stringify!(LLVMValueAsMetadata).as_bytes())
    }
        .expect(stringify!(LLVMValueAsMetadata));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn LLVMIsMultithreaded() -> LLVMBool {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn() -> LLVMBool,
            >(stringify!(LLVMIsMultithreaded).as_bytes())
    }
        .expect(stringify!(LLVMIsMultithreaded));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMGetExecutionEngineTargetMachine(
    EE: LLVMExecutionEngineRef,
) -> LLVMTargetMachineRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMExecutionEngineRef) -> LLVMTargetMachineRef,
            >(stringify!(LLVMGetExecutionEngineTargetMachine).as_bytes())
    }
        .expect(stringify!(LLVMGetExecutionEngineTargetMachine));
    entry(EE)
}
#[no_mangle]
pub extern "C" fn LLVMOrcReleaseSymbolStringPoolEntry(
    S: LLVMOrcSymbolStringPoolEntryRef,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMOrcSymbolStringPoolEntryRef),
            >(stringify!(LLVMOrcReleaseSymbolStringPoolEntry).as_bytes())
    }
        .expect(stringify!(LLVMOrcReleaseSymbolStringPoolEntry));
    entry(S)
}
#[no_mangle]
pub extern "C" fn LLVMBinaryCopyMemoryBuffer(BR: LLVMBinaryRef) -> LLVMMemoryBufferRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMBinaryRef) -> LLVMMemoryBufferRef,
            >(stringify!(LLVMBinaryCopyMemoryBuffer).as_bytes())
    }
        .expect(stringify!(LLVMBinaryCopyMemoryBuffer));
    entry(BR)
}
#[no_mangle]
pub extern "C" fn LLVMHasPrologueData(Fn: LLVMValueRef) -> LLVMBool {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMBool,
            >(stringify!(LLVMHasPrologueData).as_bytes())
    }
        .expect(stringify!(LLVMHasPrologueData));
    entry(Fn)
}
#[no_mangle]
pub extern "C" fn LLVMWriteBitcodeToMemoryBuffer(
    M: LLVMModuleRef,
) -> LLVMMemoryBufferRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMModuleRef) -> LLVMMemoryBufferRef,
            >(stringify!(LLVMWriteBitcodeToMemoryBuffer).as_bytes())
    }
        .expect(stringify!(LLVMWriteBitcodeToMemoryBuffer));
    entry(M)
}
#[no_mangle]
pub extern "C" fn LLVMGetReturnType(FunctionTy: LLVMTypeRef) -> LLVMTypeRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMTypeRef) -> LLVMTypeRef,
            >(stringify!(LLVMGetReturnType).as_bytes())
    }
        .expect(stringify!(LLVMGetReturnType));
    entry(FunctionTy)
}
#[no_mangle]
pub extern "C" fn thinlto_codegen_set_pic_model(
    cg: thinlto_code_gen_t,
    model: lto_codegen_model,
) -> lto_bool_t {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(thinlto_code_gen_t, lto_codegen_model) -> lto_bool_t,
            >(stringify!(thinlto_codegen_set_pic_model).as_bytes())
    }
        .expect(stringify!(thinlto_codegen_set_pic_model));
    entry(cg, model)
}
#[no_mangle]
pub extern "C" fn LLVMDIBuilderCreateArrayType(
    Builder: LLVMDIBuilderRef,
    Size: u64,
    AlignInBits: u32,
    Ty: LLVMMetadataRef,
    Subscripts: *mut LLVMMetadataRef,
    NumSubscripts: ::libc::c_uint,
) -> LLVMMetadataRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMDIBuilderRef,
                    u64,
                    u32,
                    LLVMMetadataRef,
                    *mut LLVMMetadataRef,
                    ::libc::c_uint,
                ) -> LLVMMetadataRef,
            >(stringify!(LLVMDIBuilderCreateArrayType).as_bytes())
    }
        .expect(stringify!(LLVMDIBuilderCreateArrayType));
    entry(Builder, Size, AlignInBits, Ty, Subscripts, NumSubscripts)
}
#[no_mangle]
pub extern "C" fn lto_codegen_set_cpu(cg: lto_code_gen_t, cpu: *const ::libc::c_char) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(lto_code_gen_t, *const ::libc::c_char),
            >(stringify!(lto_codegen_set_cpu).as_bytes())
    }
        .expect(stringify!(lto_codegen_set_cpu));
    entry(cg, cpu)
}
#[no_mangle]
pub extern "C" fn LLVMInitializeBPFAsmParser() {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<extern "C" fn()>(stringify!(LLVMInitializeBPFAsmParser).as_bytes())
    }
        .expect(stringify!(LLVMInitializeBPFAsmParser));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMOrcCreateLLJIT(
    Result: *mut LLVMOrcLLJITRef,
    Builder: LLVMOrcLLJITBuilderRef,
) -> LLVMErrorRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    *mut LLVMOrcLLJITRef,
                    LLVMOrcLLJITBuilderRef,
                ) -> LLVMErrorRef,
            >(stringify!(LLVMOrcCreateLLJIT).as_bytes())
    }
        .expect(stringify!(LLVMOrcCreateLLJIT));
    entry(Result, Builder)
}
#[no_mangle]
pub extern "C" fn LLVMGetDebugLocDirectory(
    Val: LLVMValueRef,
    Length: *mut ::libc::c_uint,
) -> *const ::libc::c_char {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, *mut ::libc::c_uint) -> *const ::libc::c_char,
            >(stringify!(LLVMGetDebugLocDirectory).as_bytes())
    }
        .expect(stringify!(LLVMGetDebugLocDirectory));
    entry(Val, Length)
}
#[no_mangle]
pub extern "C" fn LLVMCreateTargetData(
    StringRep: *const ::libc::c_char,
) -> LLVMTargetDataRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(*const ::libc::c_char) -> LLVMTargetDataRef,
            >(stringify!(LLVMCreateTargetData).as_bytes())
    }
        .expect(stringify!(LLVMCreateTargetData));
    entry(StringRep)
}
#[no_mangle]
pub extern "C" fn LLVMContextDispose(C: LLVMContextRef) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMContextRef),
            >(stringify!(LLVMContextDispose).as_bytes())
    }
        .expect(stringify!(LLVMContextDispose));
    entry(C)
}
#[no_mangle]
pub extern "C" fn LLVMIsADbgVariableIntrinsic(Val: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMIsADbgVariableIntrinsic).as_bytes())
    }
        .expect(stringify!(LLVMIsADbgVariableIntrinsic));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn LLVMInitializeMSP430AsmPrinter() {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(),
            >(stringify!(LLVMInitializeMSP430AsmPrinter).as_bytes())
    }
        .expect(stringify!(LLVMInitializeMSP430AsmPrinter));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMIsNewDbgInfoFormat(M: LLVMModuleRef) -> LLVMBool {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMModuleRef) -> LLVMBool,
            >(stringify!(LLVMIsNewDbgInfoFormat).as_bytes())
    }
        .expect(stringify!(LLVMIsNewDbgInfoFormat));
    entry(M)
}
#[no_mangle]
pub extern "C" fn LLVMSetModuleInlineAsm(M: LLVMModuleRef, Asm: *const ::libc::c_char) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMModuleRef, *const ::libc::c_char),
            >(stringify!(LLVMSetModuleInlineAsm).as_bytes())
    }
        .expect(stringify!(LLVMSetModuleInlineAsm));
    entry(M, Asm)
}
#[no_mangle]
pub extern "C" fn LLVMLookupIntrinsicID(
    Name: *const ::libc::c_char,
    NameLen: ::libc::size_t,
) -> ::libc::c_uint {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(*const ::libc::c_char, ::libc::size_t) -> ::libc::c_uint,
            >(stringify!(LLVMLookupIntrinsicID).as_bytes())
    }
        .expect(stringify!(LLVMLookupIntrinsicID));
    entry(Name, NameLen)
}
#[no_mangle]
pub extern "C" fn LLVMGetEnumAttributeAtIndex(
    F: LLVMValueRef,
    Idx: LLVMAttributeIndex,
    KindID: ::libc::c_uint,
) -> LLVMAttributeRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMValueRef,
                    LLVMAttributeIndex,
                    ::libc::c_uint,
                ) -> LLVMAttributeRef,
            >(stringify!(LLVMGetEnumAttributeAtIndex).as_bytes())
    }
        .expect(stringify!(LLVMGetEnumAttributeAtIndex));
    entry(F, Idx, KindID)
}
#[no_mangle]
pub extern "C" fn LLVMOrcMaterializationResponsibilityNotifyEmitted(
    MR: LLVMOrcMaterializationResponsibilityRef,
    SymbolDepGroups: *mut LLVMOrcCSymbolDependenceGroup,
    NumSymbolDepGroups: usize,
) -> LLVMErrorRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMOrcMaterializationResponsibilityRef,
                    *mut LLVMOrcCSymbolDependenceGroup,
                    usize,
                ) -> LLVMErrorRef,
            >(stringify!(LLVMOrcMaterializationResponsibilityNotifyEmitted).as_bytes())
    }
        .expect(stringify!(LLVMOrcMaterializationResponsibilityNotifyEmitted));
    entry(MR, SymbolDepGroups, NumSymbolDepGroups)
}
#[no_mangle]
pub extern "C" fn LLVMAlignOf(Ty: LLVMTypeRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMTypeRef) -> LLVMValueRef,
            >(stringify!(LLVMAlignOf).as_bytes())
    }
        .expect(stringify!(LLVMAlignOf));
    entry(Ty)
}
#[no_mangle]
pub extern "C" fn LLVMMDNode(
    Vals: *mut LLVMValueRef,
    Count: ::libc::c_uint,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(*mut LLVMValueRef, ::libc::c_uint) -> LLVMValueRef,
            >(stringify!(LLVMMDNode).as_bytes())
    }
        .expect(stringify!(LLVMMDNode));
    entry(Vals, Count)
}
#[no_mangle]
pub extern "C" fn llvm_blake3_hasher_init_keyed(
    hasher: *mut llvm_blake3_hasher,
    key: *const u8,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(*mut llvm_blake3_hasher, *const u8),
            >(stringify!(llvm_blake3_hasher_init_keyed).as_bytes())
    }
        .expect(stringify!(llvm_blake3_hasher_init_keyed));
    entry(hasher, key)
}
#[no_mangle]
pub extern "C" fn LLVMGetTarget(M: LLVMModuleRef) -> *const ::libc::c_char {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMModuleRef) -> *const ::libc::c_char,
            >(stringify!(LLVMGetTarget).as_bytes())
    }
        .expect(stringify!(LLVMGetTarget));
    entry(M)
}
#[no_mangle]
pub extern "C" fn LLVMIsAShuffleVectorInst(Val: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMIsAShuffleVectorInst).as_bytes())
    }
        .expect(stringify!(LLVMIsAShuffleVectorInst));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn LLVMGetDINodeTag(MD: LLVMMetadataRef) -> u16 {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMMetadataRef) -> u16,
            >(stringify!(LLVMGetDINodeTag).as_bytes())
    }
        .expect(stringify!(LLVMGetDINodeTag));
    entry(MD)
}
#[no_mangle]
pub extern "C" fn LLVMGetSymbolAddress(SI: LLVMSymbolIteratorRef) -> u64 {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMSymbolIteratorRef) -> u64,
            >(stringify!(LLVMGetSymbolAddress).as_bytes())
    }
        .expect(stringify!(LLVMGetSymbolAddress));
    entry(SI)
}
#[no_mangle]
pub extern "C" fn LLVMAddSymbol(
    symbolName: *const ::libc::c_char,
    symbolValue: *mut ::libc::c_void,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(*const ::libc::c_char, *mut ::libc::c_void),
            >(stringify!(LLVMAddSymbol).as_bytes())
    }
        .expect(stringify!(LLVMAddSymbol));
    entry(symbolName, symbolValue)
}
#[no_mangle]
pub extern "C" fn LLVMArrayType(
    ElementType: LLVMTypeRef,
    ElementCount: ::libc::c_uint,
) -> LLVMTypeRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMTypeRef, ::libc::c_uint) -> LLVMTypeRef,
            >(stringify!(LLVMArrayType).as_bytes())
    }
        .expect(stringify!(LLVMArrayType));
    entry(ElementType, ElementCount)
}
#[no_mangle]
pub extern "C" fn LLVMIsInBounds(GEP: LLVMValueRef) -> LLVMBool {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMBool,
            >(stringify!(LLVMIsInBounds).as_bytes())
    }
        .expect(stringify!(LLVMIsInBounds));
    entry(GEP)
}
#[no_mangle]
pub extern "C" fn LLVMGetCurrentDebugLocation(Builder: LLVMBuilderRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMBuilderRef) -> LLVMValueRef,
            >(stringify!(LLVMGetCurrentDebugLocation).as_bytes())
    }
        .expect(stringify!(LLVMGetCurrentDebugLocation));
    entry(Builder)
}
#[no_mangle]
pub extern "C" fn LLVMGetParentCatchSwitch(CatchPad: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMGetParentCatchSwitch).as_bytes())
    }
        .expect(stringify!(LLVMGetParentCatchSwitch));
    entry(CatchPad)
}
#[no_mangle]
pub extern "C" fn LLVMGetModuleDataLayout(M: LLVMModuleRef) -> LLVMTargetDataRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMModuleRef) -> LLVMTargetDataRef,
            >(stringify!(LLVMGetModuleDataLayout).as_bytes())
    }
        .expect(stringify!(LLVMGetModuleDataLayout));
    entry(M)
}
#[no_mangle]
pub extern "C" fn LLVMInsertIntoBuilderWithName(
    Builder: LLVMBuilderRef,
    Instr: LLVMValueRef,
    Name: *const ::libc::c_char,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMBuilderRef, LLVMValueRef, *const ::libc::c_char),
            >(stringify!(LLVMInsertIntoBuilderWithName).as_bytes())
    }
        .expect(stringify!(LLVMInsertIntoBuilderWithName));
    entry(Builder, Instr, Name)
}
#[no_mangle]
pub extern "C" fn LLVMSetCurrentDebugLocation(Builder: LLVMBuilderRef, L: LLVMValueRef) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMBuilderRef, LLVMValueRef),
            >(stringify!(LLVMSetCurrentDebugLocation).as_bytes())
    }
        .expect(stringify!(LLVMSetCurrentDebugLocation));
    entry(Builder, L)
}
#[no_mangle]
pub extern "C" fn LLVMStripModuleDebugInfo(Module: LLVMModuleRef) -> LLVMBool {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMModuleRef) -> LLVMBool,
            >(stringify!(LLVMStripModuleDebugInfo).as_bytes())
    }
        .expect(stringify!(LLVMStripModuleDebugInfo));
    entry(Module)
}
#[no_mangle]
pub extern "C" fn LLVMBuildPhi(
    arg1: LLVMBuilderRef,
    Ty: LLVMTypeRef,
    Name: *const ::libc::c_char,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMBuilderRef,
                    LLVMTypeRef,
                    *const ::libc::c_char,
                ) -> LLVMValueRef,
            >(stringify!(LLVMBuildPhi).as_bytes())
    }
        .expect(stringify!(LLVMBuildPhi));
    entry(arg1, Ty, Name)
}
#[no_mangle]
pub extern "C" fn LLVMContextGetDiagnosticContext(
    C: LLVMContextRef,
) -> *mut ::libc::c_void {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMContextRef) -> *mut ::libc::c_void,
            >(stringify!(LLVMContextGetDiagnosticContext).as_bytes())
    }
        .expect(stringify!(LLVMContextGetDiagnosticContext));
    entry(C)
}
#[no_mangle]
pub extern "C" fn LLVMBuildCondBr(
    arg1: LLVMBuilderRef,
    If: LLVMValueRef,
    Then: LLVMBasicBlockRef,
    Else: LLVMBasicBlockRef,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMBuilderRef,
                    LLVMValueRef,
                    LLVMBasicBlockRef,
                    LLVMBasicBlockRef,
                ) -> LLVMValueRef,
            >(stringify!(LLVMBuildCondBr).as_bytes())
    }
        .expect(stringify!(LLVMBuildCondBr));
    entry(arg1, If, Then, Else)
}
#[no_mangle]
pub extern "C" fn LLVMIsABlockAddress(Val: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMIsABlockAddress).as_bytes())
    }
        .expect(stringify!(LLVMIsABlockAddress));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn LLVMSetParamAlignment(Arg: LLVMValueRef, Align: ::libc::c_uint) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, ::libc::c_uint),
            >(stringify!(LLVMSetParamAlignment).as_bytes())
    }
        .expect(stringify!(LLVMSetParamAlignment));
    entry(Arg, Align)
}
#[no_mangle]
pub extern "C" fn LLVMInitializeX86Disassembler() {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<extern "C" fn()>(stringify!(LLVMInitializeX86Disassembler).as_bytes())
    }
        .expect(stringify!(LLVMInitializeX86Disassembler));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMAddGlobalInAddressSpace(
    M: LLVMModuleRef,
    Ty: LLVMTypeRef,
    Name: *const ::libc::c_char,
    AddressSpace: ::libc::c_uint,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMModuleRef,
                    LLVMTypeRef,
                    *const ::libc::c_char,
                    ::libc::c_uint,
                ) -> LLVMValueRef,
            >(stringify!(LLVMAddGlobalInAddressSpace).as_bytes())
    }
        .expect(stringify!(LLVMAddGlobalInAddressSpace));
    entry(M, Ty, Name, AddressSpace)
}
#[no_mangle]
pub extern "C" fn LLVMDIBuilderCreateSetType(
    Builder: LLVMDIBuilderRef,
    Scope: LLVMMetadataRef,
    Name: *const ::libc::c_char,
    NameLen: ::libc::size_t,
    File: LLVMMetadataRef,
    LineNumber: ::libc::c_uint,
    SizeInBits: u64,
    AlignInBits: u32,
    BaseTy: LLVMMetadataRef,
) -> LLVMMetadataRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMDIBuilderRef,
                    LLVMMetadataRef,
                    *const ::libc::c_char,
                    ::libc::size_t,
                    LLVMMetadataRef,
                    ::libc::c_uint,
                    u64,
                    u32,
                    LLVMMetadataRef,
                ) -> LLVMMetadataRef,
            >(stringify!(LLVMDIBuilderCreateSetType).as_bytes())
    }
        .expect(stringify!(LLVMDIBuilderCreateSetType));
    entry(
        Builder,
        Scope,
        Name,
        NameLen,
        File,
        LineNumber,
        SizeInBits,
        AlignInBits,
        BaseTy,
    )
}
#[no_mangle]
pub extern "C" fn LLVMContextSetYieldCallback(
    C: LLVMContextRef,
    Callback: LLVMYieldCallback,
    OpaqueHandle: *mut ::libc::c_void,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMContextRef, LLVMYieldCallback, *mut ::libc::c_void),
            >(stringify!(LLVMContextSetYieldCallback).as_bytes())
    }
        .expect(stringify!(LLVMContextSetYieldCallback));
    entry(C, Callback, OpaqueHandle)
}
#[no_mangle]
pub extern "C" fn LLVMGetInlineAsmDialect(
    InlineAsmVal: LLVMValueRef,
) -> LLVMInlineAsmDialect {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMInlineAsmDialect,
            >(stringify!(LLVMGetInlineAsmDialect).as_bytes())
    }
        .expect(stringify!(LLVMGetInlineAsmDialect));
    entry(InlineAsmVal)
}
#[no_mangle]
pub extern "C" fn LLVMGetNamedMetadataOperands(
    M: LLVMModuleRef,
    name: *const ::libc::c_char,
    Dest: *mut LLVMValueRef,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMModuleRef, *const ::libc::c_char, *mut LLVMValueRef),
            >(stringify!(LLVMGetNamedMetadataOperands).as_bytes())
    }
        .expect(stringify!(LLVMGetNamedMetadataOperands));
    entry(M, name, Dest)
}
#[no_mangle]
pub extern "C" fn LLVMGetNSW(ArithInst: LLVMValueRef) -> LLVMBool {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMBool,
            >(stringify!(LLVMGetNSW).as_bytes())
    }
        .expect(stringify!(LLVMGetNSW));
    entry(ArithInst)
}
#[no_mangle]
pub extern "C" fn LLVMSetComdatSelectionKind(
    C: LLVMComdatRef,
    Kind: LLVMComdatSelectionKind,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMComdatRef, LLVMComdatSelectionKind),
            >(stringify!(LLVMSetComdatSelectionKind).as_bytes())
    }
        .expect(stringify!(LLVMSetComdatSelectionKind));
    entry(C, Kind)
}
#[no_mangle]
pub extern "C" fn LLVMReplaceArrays(
    Builder: LLVMDIBuilderRef,
    T: *mut LLVMMetadataRef,
    Elements: *mut LLVMMetadataRef,
    NumElements: ::libc::c_uint,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMDIBuilderRef,
                    *mut LLVMMetadataRef,
                    *mut LLVMMetadataRef,
                    ::libc::c_uint,
                ),
            >(stringify!(LLVMReplaceArrays).as_bytes())
    }
        .expect(stringify!(LLVMReplaceArrays));
    entry(Builder, T, Elements, NumElements)
}
#[no_mangle]
pub extern "C" fn LLVMObjectFileCopySymbolIterator(
    BR: LLVMBinaryRef,
) -> LLVMSymbolIteratorRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMBinaryRef) -> LLVMSymbolIteratorRef,
            >(stringify!(LLVMObjectFileCopySymbolIterator).as_bytes())
    }
        .expect(stringify!(LLVMObjectFileCopySymbolIterator));
    entry(BR)
}
#[no_mangle]
pub extern "C" fn LLVMGetSymbolName(SI: LLVMSymbolIteratorRef) -> *const ::libc::c_char {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMSymbolIteratorRef) -> *const ::libc::c_char,
            >(stringify!(LLVMGetSymbolName).as_bytes())
    }
        .expect(stringify!(LLVMGetSymbolName));
    entry(SI)
}
#[no_mangle]
pub extern "C" fn LLVMIntrinsicGetName(
    ID: ::libc::c_uint,
    NameLength: *mut ::libc::size_t,
) -> *const ::libc::c_char {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    ::libc::c_uint,
                    *mut ::libc::size_t,
                ) -> *const ::libc::c_char,
            >(stringify!(LLVMIntrinsicGetName).as_bytes())
    }
        .expect(stringify!(LLVMIntrinsicGetName));
    entry(ID, NameLength)
}
#[no_mangle]
pub extern "C" fn LLVMWriteBitcodeToFD(
    M: LLVMModuleRef,
    FD: ::libc::c_int,
    ShouldClose: ::libc::c_int,
    Unbuffered: ::libc::c_int,
) -> ::libc::c_int {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMModuleRef,
                    ::libc::c_int,
                    ::libc::c_int,
                    ::libc::c_int,
                ) -> ::libc::c_int,
            >(stringify!(LLVMWriteBitcodeToFD).as_bytes())
    }
        .expect(stringify!(LLVMWriteBitcodeToFD));
    entry(M, FD, ShouldClose, Unbuffered)
}
#[no_mangle]
pub extern "C" fn LLVMGetDebugLocLine(Val: LLVMValueRef) -> ::libc::c_uint {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> ::libc::c_uint,
            >(stringify!(LLVMGetDebugLocLine).as_bytes())
    }
        .expect(stringify!(LLVMGetDebugLocLine));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn LLVMGetSectionContents(
    SI: LLVMSectionIteratorRef,
) -> *const ::libc::c_char {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMSectionIteratorRef) -> *const ::libc::c_char,
            >(stringify!(LLVMGetSectionContents).as_bytes())
    }
        .expect(stringify!(LLVMGetSectionContents));
    entry(SI)
}
#[no_mangle]
pub extern "C" fn LLVMMoveToNextRelocation(RI: LLVMRelocationIteratorRef) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMRelocationIteratorRef),
            >(stringify!(LLVMMoveToNextRelocation).as_bytes())
    }
        .expect(stringify!(LLVMMoveToNextRelocation));
    entry(RI)
}
#[no_mangle]
pub extern "C" fn LLVMOrcCreateDynamicLibrarySearchGeneratorForProcess(
    Result: *mut LLVMOrcDefinitionGeneratorRef,
    GlobalPrefix: ::libc::c_char,
    Filter: LLVMOrcSymbolPredicate,
    FilterCtx: *mut ::libc::c_void,
) -> LLVMErrorRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    *mut LLVMOrcDefinitionGeneratorRef,
                    ::libc::c_char,
                    LLVMOrcSymbolPredicate,
                    *mut ::libc::c_void,
                ) -> LLVMErrorRef,
            >(
                stringify!(LLVMOrcCreateDynamicLibrarySearchGeneratorForProcess)
                    .as_bytes(),
            )
    }
        .expect(stringify!(LLVMOrcCreateDynamicLibrarySearchGeneratorForProcess));
    entry(Result, GlobalPrefix, Filter, FilterCtx)
}
#[no_mangle]
pub extern "C" fn lto_codegen_create_in_local_context() -> lto_code_gen_t {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn() -> lto_code_gen_t,
            >(stringify!(lto_codegen_create_in_local_context).as_bytes())
    }
        .expect(stringify!(lto_codegen_create_in_local_context));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMGetGlobalParent(Global: LLVMValueRef) -> LLVMModuleRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMModuleRef,
            >(stringify!(LLVMGetGlobalParent).as_bytes())
    }
        .expect(stringify!(LLVMGetGlobalParent));
    entry(Global)
}
#[no_mangle]
pub extern "C" fn LLVMDIBuilderCreateReplaceableCompositeType(
    Builder: LLVMDIBuilderRef,
    Tag: ::libc::c_uint,
    Name: *const ::libc::c_char,
    NameLen: ::libc::size_t,
    Scope: LLVMMetadataRef,
    File: LLVMMetadataRef,
    Line: ::libc::c_uint,
    RuntimeLang: ::libc::c_uint,
    SizeInBits: u64,
    AlignInBits: u32,
    Flags: LLVMDIFlags,
    UniqueIdentifier: *const ::libc::c_char,
    UniqueIdentifierLen: ::libc::size_t,
) -> LLVMMetadataRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMDIBuilderRef,
                    ::libc::c_uint,
                    *const ::libc::c_char,
                    ::libc::size_t,
                    LLVMMetadataRef,
                    LLVMMetadataRef,
                    ::libc::c_uint,
                    ::libc::c_uint,
                    u64,
                    u32,
                    LLVMDIFlags,
                    *const ::libc::c_char,
                    ::libc::size_t,
                ) -> LLVMMetadataRef,
            >(stringify!(LLVMDIBuilderCreateReplaceableCompositeType).as_bytes())
    }
        .expect(stringify!(LLVMDIBuilderCreateReplaceableCompositeType));
    entry(
        Builder,
        Tag,
        Name,
        NameLen,
        Scope,
        File,
        Line,
        RuntimeLang,
        SizeInBits,
        AlignInBits,
        Flags,
        UniqueIdentifier,
        UniqueIdentifierLen,
    )
}
#[no_mangle]
pub extern "C" fn LLVMInitializeNVPTXAsmPrinter() {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<extern "C" fn()>(stringify!(LLVMInitializeNVPTXAsmPrinter).as_bytes())
    }
        .expect(stringify!(LLVMInitializeNVPTXAsmPrinter));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMInitializeLanaiDisassembler() {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(),
            >(stringify!(LLVMInitializeLanaiDisassembler).as_bytes())
    }
        .expect(stringify!(LLVMInitializeLanaiDisassembler));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMDisposeTargetMachineOptions(Options: LLVMTargetMachineOptionsRef) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMTargetMachineOptionsRef),
            >(stringify!(LLVMDisposeTargetMachineOptions).as_bytes())
    }
        .expect(stringify!(LLVMDisposeTargetMachineOptions));
    entry(Options)
}
#[no_mangle]
pub extern "C" fn LLVMGetDefaultTargetTriple() -> *mut ::libc::c_char {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn() -> *mut ::libc::c_char,
            >(stringify!(LLVMGetDefaultTargetTriple).as_bytes())
    }
        .expect(stringify!(LLVMGetDefaultTargetTriple));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMSetUnwindDest(InvokeInst: LLVMValueRef, B: LLVMBasicBlockRef) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, LLVMBasicBlockRef),
            >(stringify!(LLVMSetUnwindDest).as_bytes())
    }
        .expect(stringify!(LLVMSetUnwindDest));
    entry(InvokeInst, B)
}
#[no_mangle]
pub extern "C" fn LLVMBuildArrayAlloca(
    arg1: LLVMBuilderRef,
    Ty: LLVMTypeRef,
    Val: LLVMValueRef,
    Name: *const ::libc::c_char,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMBuilderRef,
                    LLVMTypeRef,
                    LLVMValueRef,
                    *const ::libc::c_char,
                ) -> LLVMValueRef,
            >(stringify!(LLVMBuildArrayAlloca).as_bytes())
    }
        .expect(stringify!(LLVMBuildArrayAlloca));
    entry(arg1, Ty, Val, Name)
}
#[no_mangle]
pub extern "C" fn LLVMMetadataTypeInContext(C: LLVMContextRef) -> LLVMTypeRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMContextRef) -> LLVMTypeRef,
            >(stringify!(LLVMMetadataTypeInContext).as_bytes())
    }
        .expect(stringify!(LLVMMetadataTypeInContext));
    entry(C)
}
#[no_mangle]
pub extern "C" fn LLVMCreatePerfJITEventListener() -> LLVMJITEventListenerRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn() -> LLVMJITEventListenerRef,
            >(stringify!(LLVMCreatePerfJITEventListener).as_bytes())
    }
        .expect(stringify!(LLVMCreatePerfJITEventListener));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMIntPtrTypeForASInContext(
    C: LLVMContextRef,
    TD: LLVMTargetDataRef,
    AS: ::libc::c_uint,
) -> LLVMTypeRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMContextRef,
                    LLVMTargetDataRef,
                    ::libc::c_uint,
                ) -> LLVMTypeRef,
            >(stringify!(LLVMIntPtrTypeForASInContext).as_bytes())
    }
        .expect(stringify!(LLVMIntPtrTypeForASInContext));
    entry(C, TD, AS)
}
#[no_mangle]
pub extern "C" fn LLVMIsAExtractElementInst(Val: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMIsAExtractElementInst).as_bytes())
    }
        .expect(stringify!(LLVMIsAExtractElementInst));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn LLVMGetNamedGlobalAlias(
    M: LLVMModuleRef,
    Name: *const ::libc::c_char,
    NameLen: ::libc::size_t,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMModuleRef,
                    *const ::libc::c_char,
                    ::libc::size_t,
                ) -> LLVMValueRef,
            >(stringify!(LLVMGetNamedGlobalAlias).as_bytes())
    }
        .expect(stringify!(LLVMGetNamedGlobalAlias));
    entry(M, Name, NameLen)
}
#[no_mangle]
pub extern "C" fn lto_module_is_object_file(path: *const ::libc::c_char) -> lto_bool_t {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(*const ::libc::c_char) -> lto_bool_t,
            >(stringify!(lto_module_is_object_file).as_bytes())
    }
        .expect(stringify!(lto_module_is_object_file));
    entry(path)
}
#[no_mangle]
pub extern "C" fn LLVMInitializeSparcAsmPrinter() {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<extern "C" fn()>(stringify!(LLVMInitializeSparcAsmPrinter).as_bytes())
    }
        .expect(stringify!(LLVMInitializeSparcAsmPrinter));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMInitializeRISCVAsmParser() {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<extern "C" fn()>(stringify!(LLVMInitializeRISCVAsmParser).as_bytes())
    }
        .expect(stringify!(LLVMInitializeRISCVAsmParser));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMGetVectorSize(VectorTy: LLVMTypeRef) -> ::libc::c_uint {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMTypeRef) -> ::libc::c_uint,
            >(stringify!(LLVMGetVectorSize).as_bytes())
    }
        .expect(stringify!(LLVMGetVectorSize));
    entry(VectorTy)
}
#[no_mangle]
pub extern "C" fn LLVMIsAConstantAggregateZero(Val: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMIsAConstantAggregateZero).as_bytes())
    }
        .expect(stringify!(LLVMIsAConstantAggregateZero));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn LLVMInsertIntoBuilder(Builder: LLVMBuilderRef, Instr: LLVMValueRef) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMBuilderRef, LLVMValueRef),
            >(stringify!(LLVMInsertIntoBuilder).as_bytes())
    }
        .expect(stringify!(LLVMInsertIntoBuilder));
    entry(Builder, Instr)
}
#[no_mangle]
pub extern "C" fn LLVMInitializeARMTarget() {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<extern "C" fn()>(stringify!(LLVMInitializeARMTarget).as_bytes())
    }
        .expect(stringify!(LLVMInitializeARMTarget));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMDILocationGetInlinedAt(
    Location: LLVMMetadataRef,
) -> LLVMMetadataRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMMetadataRef) -> LLVMMetadataRef,
            >(stringify!(LLVMDILocationGetInlinedAt).as_bytes())
    }
        .expect(stringify!(LLVMDILocationGetInlinedAt));
    entry(Location)
}
#[no_mangle]
pub extern "C" fn LLVMAddGlobal(
    M: LLVMModuleRef,
    Ty: LLVMTypeRef,
    Name: *const ::libc::c_char,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMModuleRef,
                    LLVMTypeRef,
                    *const ::libc::c_char,
                ) -> LLVMValueRef,
            >(stringify!(LLVMAddGlobal).as_bytes())
    }
        .expect(stringify!(LLVMAddGlobal));
    entry(M, Ty, Name)
}
#[no_mangle]
pub extern "C" fn LLVMOrcCreateRTDyldObjectLinkingLayerWithSectionMemoryManager(
    ES: LLVMOrcExecutionSessionRef,
) -> LLVMOrcObjectLayerRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMOrcExecutionSessionRef) -> LLVMOrcObjectLayerRef,
            >(
                stringify!(LLVMOrcCreateRTDyldObjectLinkingLayerWithSectionMemoryManager)
                    .as_bytes(),
            )
    }
        .expect(
            stringify!(LLVMOrcCreateRTDyldObjectLinkingLayerWithSectionMemoryManager),
        );
    entry(ES)
}
#[no_mangle]
pub extern "C" fn LLVMGetNextInstruction(Inst: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMGetNextInstruction).as_bytes())
    }
        .expect(stringify!(LLVMGetNextInstruction));
    entry(Inst)
}
#[no_mangle]
pub extern "C" fn LLVMConsumeError(Error: LLVMErrorRef) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<extern "C" fn(LLVMErrorRef)>(stringify!(LLVMConsumeError).as_bytes())
    }
        .expect(stringify!(LLVMConsumeError));
    entry(Error)
}
#[no_mangle]
pub extern "C" fn LLVMSetTargetMachineMachineOutliner(
    T: LLVMTargetMachineRef,
    Enable: LLVMBool,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMTargetMachineRef, LLVMBool),
            >(stringify!(LLVMSetTargetMachineMachineOutliner).as_bytes())
    }
        .expect(stringify!(LLVMSetTargetMachineMachineOutliner));
    entry(T, Enable)
}
#[no_mangle]
pub extern "C" fn LLVMDumpType(Val: LLVMTypeRef) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<extern "C" fn(LLVMTypeRef)>(stringify!(LLVMDumpType).as_bytes())
    }
        .expect(stringify!(LLVMDumpType));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn LLVMGetCmpXchgSuccessOrdering(
    CmpXchgInst: LLVMValueRef,
) -> LLVMAtomicOrdering {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMAtomicOrdering,
            >(stringify!(LLVMGetCmpXchgSuccessOrdering).as_bytes())
    }
        .expect(stringify!(LLVMGetCmpXchgSuccessOrdering));
    entry(CmpXchgInst)
}
#[no_mangle]
pub extern "C" fn LLVMGetFirstGlobal(M: LLVMModuleRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMModuleRef) -> LLVMValueRef,
            >(stringify!(LLVMGetFirstGlobal).as_bytes())
    }
        .expect(stringify!(LLVMGetFirstGlobal));
    entry(M)
}
#[no_mangle]
pub extern "C" fn LLVMGetFunctionCallConv(Fn: LLVMValueRef) -> ::libc::c_uint {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> ::libc::c_uint,
            >(stringify!(LLVMGetFunctionCallConv).as_bytes())
    }
        .expect(stringify!(LLVMGetFunctionCallConv));
    entry(Fn)
}
#[no_mangle]
pub extern "C" fn LLVMIsAAllocaInst(Val: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMIsAAllocaInst).as_bytes())
    }
        .expect(stringify!(LLVMIsAAllocaInst));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn LLVMConstNSWSub(
    LHSConstant: LLVMValueRef,
    RHSConstant: LLVMValueRef,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMConstNSWSub).as_bytes())
    }
        .expect(stringify!(LLVMConstNSWSub));
    entry(LHSConstant, RHSConstant)
}
#[no_mangle]
pub extern "C" fn LLVMOrcDisposeThreadSafeModule(TSM: LLVMOrcThreadSafeModuleRef) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMOrcThreadSafeModuleRef),
            >(stringify!(LLVMOrcDisposeThreadSafeModule).as_bytes())
    }
        .expect(stringify!(LLVMOrcDisposeThreadSafeModule));
    entry(TSM)
}
#[no_mangle]
pub extern "C" fn LLVMInt8TypeInContext(C: LLVMContextRef) -> LLVMTypeRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMContextRef) -> LLVMTypeRef,
            >(stringify!(LLVMInt8TypeInContext).as_bytes())
    }
        .expect(stringify!(LLVMInt8TypeInContext));
    entry(C)
}
#[no_mangle]
pub extern "C" fn LLVMCopyStringRepOfTargetData(
    TD: LLVMTargetDataRef,
) -> *mut ::libc::c_char {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMTargetDataRef) -> *mut ::libc::c_char,
            >(stringify!(LLVMCopyStringRepOfTargetData).as_bytes())
    }
        .expect(stringify!(LLVMCopyStringRepOfTargetData));
    entry(TD)
}
#[no_mangle]
pub extern "C" fn LLVMIsAArgument(Val: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMIsAArgument).as_bytes())
    }
        .expect(stringify!(LLVMIsAArgument));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn LLVMGetSectionSize(SI: LLVMSectionIteratorRef) -> u64 {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMSectionIteratorRef) -> u64,
            >(stringify!(LLVMGetSectionSize).as_bytes())
    }
        .expect(stringify!(LLVMGetSectionSize));
    entry(SI)
}
#[no_mangle]
pub extern "C" fn LLVMIsADbgDeclareInst(Val: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMIsADbgDeclareInst).as_bytes())
    }
        .expect(stringify!(LLVMIsADbgDeclareInst));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn LLVMRunPassManager(
    PM: LLVMPassManagerRef,
    M: LLVMModuleRef,
) -> LLVMBool {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMPassManagerRef, LLVMModuleRef) -> LLVMBool,
            >(stringify!(LLVMRunPassManager).as_bytes())
    }
        .expect(stringify!(LLVMRunPassManager));
    entry(PM, M)
}
#[no_mangle]
pub extern "C" fn LLVMBuildIntCast(
    arg1: LLVMBuilderRef,
    Val: LLVMValueRef,
    DestTy: LLVMTypeRef,
    Name: *const ::libc::c_char,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMBuilderRef,
                    LLVMValueRef,
                    LLVMTypeRef,
                    *const ::libc::c_char,
                ) -> LLVMValueRef,
            >(stringify!(LLVMBuildIntCast).as_bytes())
    }
        .expect(stringify!(LLVMBuildIntCast));
    entry(arg1, Val, DestTy, Name)
}
#[no_mangle]
pub extern "C" fn LLVMRemarkArgGetDebugLoc(
    Arg: LLVMRemarkArgRef,
) -> LLVMRemarkDebugLocRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMRemarkArgRef) -> LLVMRemarkDebugLocRef,
            >(stringify!(LLVMRemarkArgGetDebugLoc).as_bytes())
    }
        .expect(stringify!(LLVMRemarkArgGetDebugLoc));
    entry(Arg)
}
#[no_mangle]
pub extern "C" fn LLVMConstTruncOrBitCast(
    ConstantVal: LLVMValueRef,
    ToType: LLVMTypeRef,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, LLVMTypeRef) -> LLVMValueRef,
            >(stringify!(LLVMConstTruncOrBitCast).as_bytes())
    }
        .expect(stringify!(LLVMConstTruncOrBitCast));
    entry(ConstantVal, ToType)
}
#[no_mangle]
pub extern "C" fn LLVMCreateMessage(
    Message: *const ::libc::c_char,
) -> *mut ::libc::c_char {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(*const ::libc::c_char) -> *mut ::libc::c_char,
            >(stringify!(LLVMCreateMessage).as_bytes())
    }
        .expect(stringify!(LLVMCreateMessage));
    entry(Message)
}
#[no_mangle]
pub extern "C" fn LLVMAddModuleFlag(
    M: LLVMModuleRef,
    Behavior: LLVMModuleFlagBehavior,
    Key: *const ::libc::c_char,
    KeyLen: ::libc::size_t,
    Val: LLVMMetadataRef,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMModuleRef,
                    LLVMModuleFlagBehavior,
                    *const ::libc::c_char,
                    ::libc::size_t,
                    LLVMMetadataRef,
                ),
            >(stringify!(LLVMAddModuleFlag).as_bytes())
    }
        .expect(stringify!(LLVMAddModuleFlag));
    entry(M, Behavior, Key, KeyLen, Val)
}
#[no_mangle]
pub extern "C" fn LLVMGetIntrinsicID(Fn: LLVMValueRef) -> ::libc::c_uint {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> ::libc::c_uint,
            >(stringify!(LLVMGetIntrinsicID).as_bytes())
    }
        .expect(stringify!(LLVMGetIntrinsicID));
    entry(Fn)
}
#[no_mangle]
pub extern "C" fn LLVMIsASExtInst(Val: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMIsASExtInst).as_bytes())
    }
        .expect(stringify!(LLVMIsASExtInst));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn LLVMGetBufferStart(
    MemBuf: LLVMMemoryBufferRef,
) -> *const ::libc::c_char {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMMemoryBufferRef) -> *const ::libc::c_char,
            >(stringify!(LLVMGetBufferStart).as_bytes())
    }
        .expect(stringify!(LLVMGetBufferStart));
    entry(MemBuf)
}
#[no_mangle]
pub extern "C" fn LLVMBuildAnd(
    arg1: LLVMBuilderRef,
    LHS: LLVMValueRef,
    RHS: LLVMValueRef,
    Name: *const ::libc::c_char,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMBuilderRef,
                    LLVMValueRef,
                    LLVMValueRef,
                    *const ::libc::c_char,
                ) -> LLVMValueRef,
            >(stringify!(LLVMBuildAnd).as_bytes())
    }
        .expect(stringify!(LLVMBuildAnd));
    entry(arg1, LHS, RHS, Name)
}
#[no_mangle]
pub extern "C" fn LLVMCreateDisasmCPU(
    Triple: *const ::libc::c_char,
    CPU: *const ::libc::c_char,
    DisInfo: *mut ::libc::c_void,
    TagType: ::libc::c_int,
    GetOpInfo: LLVMOpInfoCallback,
    SymbolLookUp: LLVMSymbolLookupCallback,
) -> LLVMDisasmContextRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    *const ::libc::c_char,
                    *const ::libc::c_char,
                    *mut ::libc::c_void,
                    ::libc::c_int,
                    LLVMOpInfoCallback,
                    LLVMSymbolLookupCallback,
                ) -> LLVMDisasmContextRef,
            >(stringify!(LLVMCreateDisasmCPU).as_bytes())
    }
        .expect(stringify!(LLVMCreateDisasmCPU));
    entry(Triple, CPU, DisInfo, TagType, GetOpInfo, SymbolLookUp)
}
#[no_mangle]
pub extern "C" fn LLVMCreateInterpreterForModule(
    OutInterp: *mut LLVMExecutionEngineRef,
    M: LLVMModuleRef,
    OutError: *mut *mut ::libc::c_char,
) -> LLVMBool {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    *mut LLVMExecutionEngineRef,
                    LLVMModuleRef,
                    *mut *mut ::libc::c_char,
                ) -> LLVMBool,
            >(stringify!(LLVMCreateInterpreterForModule).as_bytes())
    }
        .expect(stringify!(LLVMCreateInterpreterForModule));
    entry(OutInterp, M, OutError)
}
#[no_mangle]
pub extern "C" fn LLVMRemarkEntryDispose(Remark: LLVMRemarkEntryRef) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMRemarkEntryRef),
            >(stringify!(LLVMRemarkEntryDispose).as_bytes())
    }
        .expect(stringify!(LLVMRemarkEntryDispose));
    entry(Remark)
}
#[no_mangle]
pub extern "C" fn LLVMInitializeHexagonTargetMC() {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<extern "C" fn()>(stringify!(LLVMInitializeHexagonTargetMC).as_bytes())
    }
        .expect(stringify!(LLVMInitializeHexagonTargetMC));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMOrcLLJITBuilderSetObjectLinkingLayerCreator(
    Builder: LLVMOrcLLJITBuilderRef,
    F: LLVMOrcLLJITBuilderObjectLinkingLayerCreatorFunction,
    Ctx: *mut ::libc::c_void,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMOrcLLJITBuilderRef,
                    LLVMOrcLLJITBuilderObjectLinkingLayerCreatorFunction,
                    *mut ::libc::c_void,
                ),
            >(stringify!(LLVMOrcLLJITBuilderSetObjectLinkingLayerCreator).as_bytes())
    }
        .expect(stringify!(LLVMOrcLLJITBuilderSetObjectLinkingLayerCreator));
    entry(Builder, F, Ctx)
}
#[no_mangle]
pub extern "C" fn LLVMGetValueName2(
    Val: LLVMValueRef,
    Length: *mut ::libc::size_t,
) -> *const ::libc::c_char {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, *mut ::libc::size_t) -> *const ::libc::c_char,
            >(stringify!(LLVMGetValueName2).as_bytes())
    }
        .expect(stringify!(LLVMGetValueName2));
    entry(Val, Length)
}
#[no_mangle]
pub extern "C" fn LLVMGetNextParam(Arg: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMGetNextParam).as_bytes())
    }
        .expect(stringify!(LLVMGetNextParam));
    entry(Arg)
}
#[no_mangle]
pub extern "C" fn LLVMDIBuilderCreateQualifiedType(
    Builder: LLVMDIBuilderRef,
    Tag: ::libc::c_uint,
    Type: LLVMMetadataRef,
) -> LLVMMetadataRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMDIBuilderRef,
                    ::libc::c_uint,
                    LLVMMetadataRef,
                ) -> LLVMMetadataRef,
            >(stringify!(LLVMDIBuilderCreateQualifiedType).as_bytes())
    }
        .expect(stringify!(LLVMDIBuilderCreateQualifiedType));
    entry(Builder, Tag, Type)
}
#[no_mangle]
pub extern "C" fn LLVMIsAtomicSingleThread(AtomicInst: LLVMValueRef) -> LLVMBool {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMBool,
            >(stringify!(LLVMIsAtomicSingleThread).as_bytes())
    }
        .expect(stringify!(LLVMIsAtomicSingleThread));
    entry(AtomicInst)
}
#[no_mangle]
pub extern "C" fn LLVMGetBasicBlocks(
    Fn: LLVMValueRef,
    BasicBlocks: *mut LLVMBasicBlockRef,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, *mut LLVMBasicBlockRef),
            >(stringify!(LLVMGetBasicBlocks).as_bytes())
    }
        .expect(stringify!(LLVMGetBasicBlocks));
    entry(Fn, BasicBlocks)
}
#[no_mangle]
pub extern "C" fn LLVMIsATruncInst(Val: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMIsATruncInst).as_bytes())
    }
        .expect(stringify!(LLVMIsATruncInst));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn LLVMBuildGEP2(
    B: LLVMBuilderRef,
    Ty: LLVMTypeRef,
    Pointer: LLVMValueRef,
    Indices: *mut LLVMValueRef,
    NumIndices: ::libc::c_uint,
    Name: *const ::libc::c_char,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMBuilderRef,
                    LLVMTypeRef,
                    LLVMValueRef,
                    *mut LLVMValueRef,
                    ::libc::c_uint,
                    *const ::libc::c_char,
                ) -> LLVMValueRef,
            >(stringify!(LLVMBuildGEP2).as_bytes())
    }
        .expect(stringify!(LLVMBuildGEP2));
    entry(B, Ty, Pointer, Indices, NumIndices, Name)
}
#[no_mangle]
pub extern "C" fn LLVMContextSetDiscardValueNames(C: LLVMContextRef, Discard: LLVMBool) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMContextRef, LLVMBool),
            >(stringify!(LLVMContextSetDiscardValueNames).as_bytes())
    }
        .expect(stringify!(LLVMContextSetDiscardValueNames));
    entry(C, Discard)
}
#[no_mangle]
pub extern "C" fn LLVMIsAConstant(Val: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMIsAConstant).as_bytes())
    }
        .expect(stringify!(LLVMIsAConstant));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn LLVMIsCleanup(LandingPad: LLVMValueRef) -> LLVMBool {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMBool,
            >(stringify!(LLVMIsCleanup).as_bytes())
    }
        .expect(stringify!(LLVMIsCleanup));
    entry(LandingPad)
}
#[no_mangle]
pub extern "C" fn LLVMBuildAlloca(
    arg1: LLVMBuilderRef,
    Ty: LLVMTypeRef,
    Name: *const ::libc::c_char,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMBuilderRef,
                    LLVMTypeRef,
                    *const ::libc::c_char,
                ) -> LLVMValueRef,
            >(stringify!(LLVMBuildAlloca).as_bytes())
    }
        .expect(stringify!(LLVMBuildAlloca));
    entry(arg1, Ty, Name)
}
#[no_mangle]
pub extern "C" fn LLVMIsALoadInst(Val: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMIsALoadInst).as_bytes())
    }
        .expect(stringify!(LLVMIsALoadInst));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn thinlto_codegen_disable_codegen(
    cg: thinlto_code_gen_t,
    disable: lto_bool_t,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(thinlto_code_gen_t, lto_bool_t),
            >(stringify!(thinlto_codegen_disable_codegen).as_bytes())
    }
        .expect(stringify!(thinlto_codegen_disable_codegen));
    entry(cg, disable)
}
#[no_mangle]
pub extern "C" fn LLVMRemarkVersion() -> u32 {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<extern "C" fn() -> u32>(stringify!(LLVMRemarkVersion).as_bytes())
    }
        .expect(stringify!(LLVMRemarkVersion));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMIsAStoreInst(Val: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMIsAStoreInst).as_bytes())
    }
        .expect(stringify!(LLVMIsAStoreInst));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn LLVMDisposeModuleProvider(M: LLVMModuleProviderRef) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMModuleProviderRef),
            >(stringify!(LLVMDisposeModuleProvider).as_bytes())
    }
        .expect(stringify!(LLVMDisposeModuleProvider));
    entry(M)
}
#[no_mangle]
pub extern "C" fn LLVMGetOrInsertComdat(
    M: LLVMModuleRef,
    Name: *const ::libc::c_char,
) -> LLVMComdatRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMModuleRef, *const ::libc::c_char) -> LLVMComdatRef,
            >(stringify!(LLVMGetOrInsertComdat).as_bytes())
    }
        .expect(stringify!(LLVMGetOrInsertComdat));
    entry(M, Name)
}
#[no_mangle]
pub extern "C" fn LLVMLinkInInterpreter() {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<extern "C" fn()>(stringify!(LLVMLinkInInterpreter).as_bytes())
    }
        .expect(stringify!(LLVMLinkInInterpreter));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMValueMetadataEntriesGetMetadata(
    Entries: *mut LLVMValueMetadataEntry,
    Index: ::libc::c_uint,
) -> LLVMMetadataRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    *mut LLVMValueMetadataEntry,
                    ::libc::c_uint,
                ) -> LLVMMetadataRef,
            >(stringify!(LLVMValueMetadataEntriesGetMetadata).as_bytes())
    }
        .expect(stringify!(LLVMValueMetadataEntriesGetMetadata));
    entry(Entries, Index)
}
#[no_mangle]
pub extern "C" fn LLVMGetUnwindDest(InvokeInst: LLVMValueRef) -> LLVMBasicBlockRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMBasicBlockRef,
            >(stringify!(LLVMGetUnwindDest).as_bytes())
    }
        .expect(stringify!(LLVMGetUnwindDest));
    entry(InvokeInst)
}
#[no_mangle]
pub extern "C" fn LLVMGetNamedMetadataName(
    NamedMD: LLVMNamedMDNodeRef,
    NameLen: *mut ::libc::size_t,
) -> *const ::libc::c_char {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMNamedMDNodeRef,
                    *mut ::libc::size_t,
                ) -> *const ::libc::c_char,
            >(stringify!(LLVMGetNamedMetadataName).as_bytes())
    }
        .expect(stringify!(LLVMGetNamedMetadataName));
    entry(NamedMD, NameLen)
}
#[no_mangle]
pub extern "C" fn LLVMBuildFDiv(
    arg1: LLVMBuilderRef,
    LHS: LLVMValueRef,
    RHS: LLVMValueRef,
    Name: *const ::libc::c_char,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMBuilderRef,
                    LLVMValueRef,
                    LLVMValueRef,
                    *const ::libc::c_char,
                ) -> LLVMValueRef,
            >(stringify!(LLVMBuildFDiv).as_bytes())
    }
        .expect(stringify!(LLVMBuildFDiv));
    entry(arg1, LHS, RHS, Name)
}
#[no_mangle]
pub extern "C" fn LLVMSetVolatile(MemoryAccessInst: LLVMValueRef, IsVolatile: LLVMBool) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, LLVMBool),
            >(stringify!(LLVMSetVolatile).as_bytes())
    }
        .expect(stringify!(LLVMSetVolatile));
    entry(MemoryAccessInst, IsVolatile)
}
#[no_mangle]
pub extern "C" fn LLVMRemarkDebugLocGetSourceColumn(DL: LLVMRemarkDebugLocRef) -> u32 {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMRemarkDebugLocRef) -> u32,
            >(stringify!(LLVMRemarkDebugLocGetSourceColumn).as_bytes())
    }
        .expect(stringify!(LLVMRemarkDebugLocGetSourceColumn));
    entry(DL)
}
#[no_mangle]
pub extern "C" fn LLVMOrcLLJITEnableDebugSupport(J: LLVMOrcLLJITRef) -> LLVMErrorRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMOrcLLJITRef) -> LLVMErrorRef,
            >(stringify!(LLVMOrcLLJITEnableDebugSupport).as_bytes())
    }
        .expect(stringify!(LLVMOrcLLJITEnableDebugSupport));
    entry(J)
}
#[no_mangle]
pub extern "C" fn LLVMOrcMaterializationResponsibilityGetSymbols(
    MR: LLVMOrcMaterializationResponsibilityRef,
    NumPairs: *mut ::libc::size_t,
) -> LLVMOrcCSymbolFlagsMapPairs {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMOrcMaterializationResponsibilityRef,
                    *mut ::libc::size_t,
                ) -> LLVMOrcCSymbolFlagsMapPairs,
            >(stringify!(LLVMOrcMaterializationResponsibilityGetSymbols).as_bytes())
    }
        .expect(stringify!(LLVMOrcMaterializationResponsibilityGetSymbols));
    entry(MR, NumPairs)
}
#[no_mangle]
pub extern "C" fn LLVMInitializeSystemZTargetMC() {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<extern "C" fn()>(stringify!(LLVMInitializeSystemZTargetMC).as_bytes())
    }
        .expect(stringify!(LLVMInitializeSystemZTargetMC));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMBuildInvokeWithOperandBundles(
    arg1: LLVMBuilderRef,
    Ty: LLVMTypeRef,
    Fn: LLVMValueRef,
    Args: *mut LLVMValueRef,
    NumArgs: ::libc::c_uint,
    Then: LLVMBasicBlockRef,
    Catch: LLVMBasicBlockRef,
    Bundles: *mut LLVMOperandBundleRef,
    NumBundles: ::libc::c_uint,
    Name: *const ::libc::c_char,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMBuilderRef,
                    LLVMTypeRef,
                    LLVMValueRef,
                    *mut LLVMValueRef,
                    ::libc::c_uint,
                    LLVMBasicBlockRef,
                    LLVMBasicBlockRef,
                    *mut LLVMOperandBundleRef,
                    ::libc::c_uint,
                    *const ::libc::c_char,
                ) -> LLVMValueRef,
            >(stringify!(LLVMBuildInvokeWithOperandBundles).as_bytes())
    }
        .expect(stringify!(LLVMBuildInvokeWithOperandBundles));
    entry(arg1, Ty, Fn, Args, NumArgs, Then, Catch, Bundles, NumBundles, Name)
}
#[no_mangle]
pub extern "C" fn LLVMIsStringAttribute(A: LLVMAttributeRef) -> LLVMBool {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMAttributeRef) -> LLVMBool,
            >(stringify!(LLVMIsStringAttribute).as_bytes())
    }
        .expect(stringify!(LLVMIsStringAttribute));
    entry(A)
}
#[no_mangle]
pub extern "C" fn LLVMPointerTypeInContext(
    C: LLVMContextRef,
    AddressSpace: ::libc::c_uint,
) -> LLVMTypeRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMContextRef, ::libc::c_uint) -> LLVMTypeRef,
            >(stringify!(LLVMPointerTypeInContext).as_bytes())
    }
        .expect(stringify!(LLVMPointerTypeInContext));
    entry(C, AddressSpace)
}
#[no_mangle]
pub extern "C" fn LLVMIsAMDNode(Val: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMIsAMDNode).as_bytes())
    }
        .expect(stringify!(LLVMIsAMDNode));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn LLVMOrcCreateDumpObjects(
    DumpDir: *const ::libc::c_char,
    IdentifierOverride: *const ::libc::c_char,
) -> LLVMOrcDumpObjectsRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    *const ::libc::c_char,
                    *const ::libc::c_char,
                ) -> LLVMOrcDumpObjectsRef,
            >(stringify!(LLVMOrcCreateDumpObjects).as_bytes())
    }
        .expect(stringify!(LLVMOrcCreateDumpObjects));
    entry(DumpDir, IdentifierOverride)
}
#[no_mangle]
pub extern "C" fn LLVMRemoveCallSiteEnumAttribute(
    C: LLVMValueRef,
    Idx: LLVMAttributeIndex,
    KindID: ::libc::c_uint,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, LLVMAttributeIndex, ::libc::c_uint),
            >(stringify!(LLVMRemoveCallSiteEnumAttribute).as_bytes())
    }
        .expect(stringify!(LLVMRemoveCallSiteEnumAttribute));
    entry(C, Idx, KindID)
}
#[no_mangle]
pub extern "C" fn LLVMDIBuilderCreateDebugLocation(
    Ctx: LLVMContextRef,
    Line: ::libc::c_uint,
    Column: ::libc::c_uint,
    Scope: LLVMMetadataRef,
    InlinedAt: LLVMMetadataRef,
) -> LLVMMetadataRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMContextRef,
                    ::libc::c_uint,
                    ::libc::c_uint,
                    LLVMMetadataRef,
                    LLVMMetadataRef,
                ) -> LLVMMetadataRef,
            >(stringify!(LLVMDIBuilderCreateDebugLocation).as_bytes())
    }
        .expect(stringify!(LLVMDIBuilderCreateDebugLocation));
    entry(Ctx, Line, Column, Scope, InlinedAt)
}
#[no_mangle]
pub extern "C" fn LLVMOrcMaterializationResponsibilityGetTargetDylib(
    MR: LLVMOrcMaterializationResponsibilityRef,
) -> LLVMOrcJITDylibRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMOrcMaterializationResponsibilityRef,
                ) -> LLVMOrcJITDylibRef,
            >(stringify!(LLVMOrcMaterializationResponsibilityGetTargetDylib).as_bytes())
    }
        .expect(stringify!(LLVMOrcMaterializationResponsibilityGetTargetDylib));
    entry(MR)
}
#[no_mangle]
pub extern "C" fn LLVMGetSections(
    ObjectFile: LLVMObjectFileRef,
) -> LLVMSectionIteratorRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMObjectFileRef) -> LLVMSectionIteratorRef,
            >(stringify!(LLVMGetSections).as_bytes())
    }
        .expect(stringify!(LLVMGetSections));
    entry(ObjectFile)
}
#[no_mangle]
pub extern "C" fn LLVMOrcJITTargetMachineBuilderSetTargetTriple(
    JTMB: LLVMOrcJITTargetMachineBuilderRef,
    TargetTriple: *const ::libc::c_char,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMOrcJITTargetMachineBuilderRef, *const ::libc::c_char),
            >(stringify!(LLVMOrcJITTargetMachineBuilderSetTargetTriple).as_bytes())
    }
        .expect(stringify!(LLVMOrcJITTargetMachineBuilderSetTargetTriple));
    entry(JTMB, TargetTriple)
}
#[no_mangle]
pub extern "C" fn LLVMRemarkParserGetNext(
    Parser: LLVMRemarkParserRef,
) -> LLVMRemarkEntryRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMRemarkParserRef) -> LLVMRemarkEntryRef,
            >(stringify!(LLVMRemarkParserGetNext).as_bytes())
    }
        .expect(stringify!(LLVMRemarkParserGetNext));
    entry(Parser)
}
#[no_mangle]
pub extern "C" fn LLVMSetArgOperand(
    Funclet: LLVMValueRef,
    i: ::libc::c_uint,
    value: LLVMValueRef,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, ::libc::c_uint, LLVMValueRef),
            >(stringify!(LLVMSetArgOperand).as_bytes())
    }
        .expect(stringify!(LLVMSetArgOperand));
    entry(Funclet, i, value)
}
#[no_mangle]
pub extern "C" fn LLVMInitializeX86TargetMC() {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<extern "C" fn()>(stringify!(LLVMInitializeX86TargetMC).as_bytes())
    }
        .expect(stringify!(LLVMInitializeX86TargetMC));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMOrcMaterializationResponsibilityDelegate(
    MR: LLVMOrcMaterializationResponsibilityRef,
    Symbols: *mut LLVMOrcSymbolStringPoolEntryRef,
    NumSymbols: ::libc::size_t,
    Result: *mut LLVMOrcMaterializationResponsibilityRef,
) -> LLVMErrorRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMOrcMaterializationResponsibilityRef,
                    *mut LLVMOrcSymbolStringPoolEntryRef,
                    ::libc::size_t,
                    *mut LLVMOrcMaterializationResponsibilityRef,
                ) -> LLVMErrorRef,
            >(stringify!(LLVMOrcMaterializationResponsibilityDelegate).as_bytes())
    }
        .expect(stringify!(LLVMOrcMaterializationResponsibilityDelegate));
    entry(MR, Symbols, NumSymbols, Result)
}
#[no_mangle]
pub extern "C" fn lto_codegen_write_merged_modules(
    cg: lto_code_gen_t,
    path: *const ::libc::c_char,
) -> lto_bool_t {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(lto_code_gen_t, *const ::libc::c_char) -> lto_bool_t,
            >(stringify!(lto_codegen_write_merged_modules).as_bytes())
    }
        .expect(stringify!(lto_codegen_write_merged_modules));
    entry(cg, path)
}
#[no_mangle]
pub extern "C" fn LLVMGetPreviousFunction(Fn: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMGetPreviousFunction).as_bytes())
    }
        .expect(stringify!(LLVMGetPreviousFunction));
    entry(Fn)
}
#[no_mangle]
pub extern "C" fn LLVMOrcCreateRTDyldObjectLinkingLayerWithSectionMemoryManagerReserveAlloc(
    ES: LLVMOrcExecutionSessionRef,
    ReserveAlloc: LLVMBool,
) -> LLVMOrcObjectLayerRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMOrcExecutionSessionRef,
                    LLVMBool,
                ) -> LLVMOrcObjectLayerRef,
            >(
                stringify!(
                    LLVMOrcCreateRTDyldObjectLinkingLayerWithSectionMemoryManagerReserveAlloc
                )
                    .as_bytes(),
            )
    }
        .expect(
            stringify!(
                LLVMOrcCreateRTDyldObjectLinkingLayerWithSectionMemoryManagerReserveAlloc
            ),
        );
    entry(ES, ReserveAlloc)
}
#[no_mangle]
pub extern "C" fn LLVMIsAFenceInst(Val: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMIsAFenceInst).as_bytes())
    }
        .expect(stringify!(LLVMIsAFenceInst));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn LLVMGetTargetFromName(Name: *const ::libc::c_char) -> LLVMTargetRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(*const ::libc::c_char) -> LLVMTargetRef,
            >(stringify!(LLVMGetTargetFromName).as_bytes())
    }
        .expect(stringify!(LLVMGetTargetFromName));
    entry(Name)
}
#[no_mangle]
pub extern "C" fn LLVMGenericValueToPointer(
    GenVal: LLVMGenericValueRef,
) -> *mut ::libc::c_void {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMGenericValueRef) -> *mut ::libc::c_void,
            >(stringify!(LLVMGenericValueToPointer).as_bytes())
    }
        .expect(stringify!(LLVMGenericValueToPointer));
    entry(GenVal)
}
#[no_mangle]
pub extern "C" fn LLVMRemoveBasicBlockFromParent(BB: LLVMBasicBlockRef) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMBasicBlockRef),
            >(stringify!(LLVMRemoveBasicBlockFromParent).as_bytes())
    }
        .expect(stringify!(LLVMRemoveBasicBlockFromParent));
    entry(BB)
}
#[no_mangle]
pub extern "C" fn LLVMGetNextGlobal(GlobalVar: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMGetNextGlobal).as_bytes())
    }
        .expect(stringify!(LLVMGetNextGlobal));
    entry(GlobalVar)
}
#[no_mangle]
pub extern "C" fn LLVMGetArrayLength(ArrayTy: LLVMTypeRef) -> ::libc::c_uint {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMTypeRef) -> ::libc::c_uint,
            >(stringify!(LLVMGetArrayLength).as_bytes())
    }
        .expect(stringify!(LLVMGetArrayLength));
    entry(ArrayTy)
}
#[no_mangle]
pub extern "C" fn LLVMGetOrdering(MemoryAccessInst: LLVMValueRef) -> LLVMAtomicOrdering {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMAtomicOrdering,
            >(stringify!(LLVMGetOrdering).as_bytes())
    }
        .expect(stringify!(LLVMGetOrdering));
    entry(MemoryAccessInst)
}
#[no_mangle]
pub extern "C" fn LLVMGetStringAttributeKind(
    A: LLVMAttributeRef,
    Length: *mut ::libc::c_uint,
) -> *const ::libc::c_char {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMAttributeRef,
                    *mut ::libc::c_uint,
                ) -> *const ::libc::c_char,
            >(stringify!(LLVMGetStringAttributeKind).as_bytes())
    }
        .expect(stringify!(LLVMGetStringAttributeKind));
    entry(A, Length)
}
#[no_mangle]
pub extern "C" fn LLVMObjectFileIsSymbolIteratorAtEnd(
    BR: LLVMBinaryRef,
    SI: LLVMSymbolIteratorRef,
) -> LLVMBool {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMBinaryRef, LLVMSymbolIteratorRef) -> LLVMBool,
            >(stringify!(LLVMObjectFileIsSymbolIteratorAtEnd).as_bytes())
    }
        .expect(stringify!(LLVMObjectFileIsSymbolIteratorAtEnd));
    entry(BR, SI)
}
#[no_mangle]
pub extern "C" fn LLVMModuleFlagEntriesGetKey(
    Entries: *mut LLVMModuleFlagEntry,
    Index: ::libc::c_uint,
    Len: *mut ::libc::size_t,
) -> *const ::libc::c_char {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    *mut LLVMModuleFlagEntry,
                    ::libc::c_uint,
                    *mut ::libc::size_t,
                ) -> *const ::libc::c_char,
            >(stringify!(LLVMModuleFlagEntriesGetKey).as_bytes())
    }
        .expect(stringify!(LLVMModuleFlagEntriesGetKey));
    entry(Entries, Index, Len)
}
#[no_mangle]
pub extern "C" fn LLVMGetAllocatedType(Alloca: LLVMValueRef) -> LLVMTypeRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMTypeRef,
            >(stringify!(LLVMGetAllocatedType).as_bytes())
    }
        .expect(stringify!(LLVMGetAllocatedType));
    entry(Alloca)
}
#[no_mangle]
pub extern "C" fn LLVMIsAPtrToIntInst(Val: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMIsAPtrToIntInst).as_bytes())
    }
        .expect(stringify!(LLVMIsAPtrToIntInst));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn LLVMConstInBoundsGEP2(
    Ty: LLVMTypeRef,
    ConstantVal: LLVMValueRef,
    ConstantIndices: *mut LLVMValueRef,
    NumIndices: ::libc::c_uint,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMTypeRef,
                    LLVMValueRef,
                    *mut LLVMValueRef,
                    ::libc::c_uint,
                ) -> LLVMValueRef,
            >(stringify!(LLVMConstInBoundsGEP2).as_bytes())
    }
        .expect(stringify!(LLVMConstInBoundsGEP2));
    entry(Ty, ConstantVal, ConstantIndices, NumIndices)
}
#[no_mangle]
pub extern "C" fn LLVMGetNumIndices(Inst: LLVMValueRef) -> ::libc::c_uint {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> ::libc::c_uint,
            >(stringify!(LLVMGetNumIndices).as_bytes())
    }
        .expect(stringify!(LLVMGetNumIndices));
    entry(Inst)
}
#[no_mangle]
pub extern "C" fn LLVMGetIsDisjoint(Inst: LLVMValueRef) -> LLVMBool {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMBool,
            >(stringify!(LLVMGetIsDisjoint).as_bytes())
    }
        .expect(stringify!(LLVMGetIsDisjoint));
    entry(Inst)
}
#[no_mangle]
pub extern "C" fn lto_codegen_add_module(
    cg: lto_code_gen_t,
    _mod: lto_module_t,
) -> lto_bool_t {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(lto_code_gen_t, lto_module_t) -> lto_bool_t,
            >(stringify!(lto_codegen_add_module).as_bytes())
    }
        .expect(stringify!(lto_codegen_add_module));
    entry(cg, _mod)
}
#[no_mangle]
pub extern "C" fn LLVMInitializeLoongArchTarget() {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<extern "C" fn()>(stringify!(LLVMInitializeLoongArchTarget).as_bytes())
    }
        .expect(stringify!(LLVMInitializeLoongArchTarget));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMConstIntOfArbitraryPrecision(
    IntTy: LLVMTypeRef,
    NumWords: ::libc::c_uint,
    Words: *const u64,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMTypeRef, ::libc::c_uint, *const u64) -> LLVMValueRef,
            >(stringify!(LLVMConstIntOfArbitraryPrecision).as_bytes())
    }
        .expect(stringify!(LLVMConstIntOfArbitraryPrecision));
    entry(IntTy, NumWords, Words)
}
#[no_mangle]
pub extern "C" fn LLVMGlobalAddMetadata(
    Global: LLVMValueRef,
    Kind: ::libc::c_uint,
    MD: LLVMMetadataRef,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, ::libc::c_uint, LLVMMetadataRef),
            >(stringify!(LLVMGlobalAddMetadata).as_bytes())
    }
        .expect(stringify!(LLVMGlobalAddMetadata));
    entry(Global, Kind, MD)
}
#[no_mangle]
pub extern "C" fn LLVMGetSectionName(
    SI: LLVMSectionIteratorRef,
) -> *const ::libc::c_char {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMSectionIteratorRef) -> *const ::libc::c_char,
            >(stringify!(LLVMGetSectionName).as_bytes())
    }
        .expect(stringify!(LLVMGetSectionName));
    entry(SI)
}
#[no_mangle]
pub extern "C" fn LLVMConstAdd(
    LHSConstant: LLVMValueRef,
    RHSConstant: LLVMValueRef,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMConstAdd).as_bytes())
    }
        .expect(stringify!(LLVMConstAdd));
    entry(LHSConstant, RHSConstant)
}
#[no_mangle]
pub extern "C" fn LLVMDisposeSymbolIterator(SI: LLVMSymbolIteratorRef) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMSymbolIteratorRef),
            >(stringify!(LLVMDisposeSymbolIterator).as_bytes())
    }
        .expect(stringify!(LLVMDisposeSymbolIterator));
    entry(SI)
}
#[no_mangle]
pub extern "C" fn LLVMInitializeAArch64Disassembler() {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(),
            >(stringify!(LLVMInitializeAArch64Disassembler).as_bytes())
    }
        .expect(stringify!(LLVMInitializeAArch64Disassembler));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMBuildLShr(
    arg1: LLVMBuilderRef,
    LHS: LLVMValueRef,
    RHS: LLVMValueRef,
    Name: *const ::libc::c_char,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMBuilderRef,
                    LLVMValueRef,
                    LLVMValueRef,
                    *const ::libc::c_char,
                ) -> LLVMValueRef,
            >(stringify!(LLVMBuildLShr).as_bytes())
    }
        .expect(stringify!(LLVMBuildLShr));
    entry(arg1, LHS, RHS, Name)
}
#[no_mangle]
pub extern "C" fn LLVMCreateOProfileJITEventListener() -> LLVMJITEventListenerRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn() -> LLVMJITEventListenerRef,
            >(stringify!(LLVMCreateOProfileJITEventListener).as_bytes())
    }
        .expect(stringify!(LLVMCreateOProfileJITEventListener));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMOrcCreateNewThreadSafeContext() -> LLVMOrcThreadSafeContextRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn() -> LLVMOrcThreadSafeContextRef,
            >(stringify!(LLVMOrcCreateNewThreadSafeContext).as_bytes())
    }
        .expect(stringify!(LLVMOrcCreateNewThreadSafeContext));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMBuildArrayMalloc(
    arg1: LLVMBuilderRef,
    Ty: LLVMTypeRef,
    Val: LLVMValueRef,
    Name: *const ::libc::c_char,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMBuilderRef,
                    LLVMTypeRef,
                    LLVMValueRef,
                    *const ::libc::c_char,
                ) -> LLVMValueRef,
            >(stringify!(LLVMBuildArrayMalloc).as_bytes())
    }
        .expect(stringify!(LLVMBuildArrayMalloc));
    entry(arg1, Ty, Val, Name)
}
#[no_mangle]
pub extern "C" fn LLVMBuildCatchSwitch(
    B: LLVMBuilderRef,
    ParentPad: LLVMValueRef,
    UnwindBB: LLVMBasicBlockRef,
    NumHandler: ::libc::c_uint,
    Name: *const ::libc::c_char,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMBuilderRef,
                    LLVMValueRef,
                    LLVMBasicBlockRef,
                    ::libc::c_uint,
                    *const ::libc::c_char,
                ) -> LLVMValueRef,
            >(stringify!(LLVMBuildCatchSwitch).as_bytes())
    }
        .expect(stringify!(LLVMBuildCatchSwitch));
    entry(B, ParentPad, UnwindBB, NumHandler, Name)
}
#[no_mangle]
pub extern "C" fn LLVMSetGlobalConstant(GlobalVar: LLVMValueRef, IsConstant: LLVMBool) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, LLVMBool),
            >(stringify!(LLVMSetGlobalConstant).as_bytes())
    }
        .expect(stringify!(LLVMSetGlobalConstant));
    entry(GlobalVar, IsConstant)
}
#[no_mangle]
pub extern "C" fn LLVMRemarkParserCreateBitstream(
    Buf: *const ::libc::c_void,
    Size: u64,
) -> LLVMRemarkParserRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(*const ::libc::c_void, u64) -> LLVMRemarkParserRef,
            >(stringify!(LLVMRemarkParserCreateBitstream).as_bytes())
    }
        .expect(stringify!(LLVMRemarkParserCreateBitstream));
    entry(Buf, Size)
}
#[no_mangle]
pub extern "C" fn LLVMIsAPoisonValue(Val: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMIsAPoisonValue).as_bytes())
    }
        .expect(stringify!(LLVMIsAPoisonValue));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn LLVMGlobalCopyAllMetadata(
    Value: LLVMValueRef,
    NumEntries: *mut ::libc::size_t,
) -> *mut LLVMValueMetadataEntry {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMValueRef,
                    *mut ::libc::size_t,
                ) -> *mut LLVMValueMetadataEntry,
            >(stringify!(LLVMGlobalCopyAllMetadata).as_bytes())
    }
        .expect(stringify!(LLVMGlobalCopyAllMetadata));
    entry(Value, NumEntries)
}
#[no_mangle]
pub extern "C" fn LLVMValueMetadataEntriesGetKind(
    Entries: *mut LLVMValueMetadataEntry,
    Index: ::libc::c_uint,
) -> ::libc::c_uint {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    *mut LLVMValueMetadataEntry,
                    ::libc::c_uint,
                ) -> ::libc::c_uint,
            >(stringify!(LLVMValueMetadataEntriesGetKind).as_bytes())
    }
        .expect(stringify!(LLVMValueMetadataEntriesGetKind));
    entry(Entries, Index)
}
#[no_mangle]
pub extern "C" fn LLVMInsertExistingBasicBlockAfterInsertBlock(
    Builder: LLVMBuilderRef,
    BB: LLVMBasicBlockRef,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMBuilderRef, LLVMBasicBlockRef),
            >(stringify!(LLVMInsertExistingBasicBlockAfterInsertBlock).as_bytes())
    }
        .expect(stringify!(LLVMInsertExistingBasicBlockAfterInsertBlock));
    entry(Builder, BB)
}
#[no_mangle]
pub extern "C" fn LLVMFindFunction(
    EE: LLVMExecutionEngineRef,
    Name: *const ::libc::c_char,
    OutFn: *mut LLVMValueRef,
) -> LLVMBool {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMExecutionEngineRef,
                    *const ::libc::c_char,
                    *mut LLVMValueRef,
                ) -> LLVMBool,
            >(stringify!(LLVMFindFunction).as_bytes())
    }
        .expect(stringify!(LLVMFindFunction));
    entry(EE, Name, OutFn)
}
#[no_mangle]
pub extern "C" fn lto_module_get_symbol_name(
    _mod: lto_module_t,
    index: ::libc::c_uint,
) -> *const ::libc::c_char {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(lto_module_t, ::libc::c_uint) -> *const ::libc::c_char,
            >(stringify!(lto_module_get_symbol_name).as_bytes())
    }
        .expect(stringify!(lto_module_get_symbol_name));
    entry(_mod, index)
}
#[no_mangle]
pub extern "C" fn LLVMBuildNSWNeg(
    B: LLVMBuilderRef,
    V: LLVMValueRef,
    Name: *const ::libc::c_char,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMBuilderRef,
                    LLVMValueRef,
                    *const ::libc::c_char,
                ) -> LLVMValueRef,
            >(stringify!(LLVMBuildNSWNeg).as_bytes())
    }
        .expect(stringify!(LLVMBuildNSWNeg));
    entry(B, V, Name)
}
#[no_mangle]
pub extern "C" fn lto_codegen_set_module(cg: lto_code_gen_t, _mod: lto_module_t) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(lto_code_gen_t, lto_module_t),
            >(stringify!(lto_codegen_set_module).as_bytes())
    }
        .expect(stringify!(lto_codegen_set_module));
    entry(cg, _mod)
}
#[no_mangle]
pub extern "C" fn LLVMOrcJITTargetMachineBuilderGetTargetTriple(
    JTMB: LLVMOrcJITTargetMachineBuilderRef,
) -> *mut ::libc::c_char {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMOrcJITTargetMachineBuilderRef) -> *mut ::libc::c_char,
            >(stringify!(LLVMOrcJITTargetMachineBuilderGetTargetTriple).as_bytes())
    }
        .expect(stringify!(LLVMOrcJITTargetMachineBuilderGetTargetTriple));
    entry(JTMB)
}
#[no_mangle]
pub extern "C" fn LLVMInitializeWebAssemblyDisassembler() {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(),
            >(stringify!(LLVMInitializeWebAssemblyDisassembler).as_bytes())
    }
        .expect(stringify!(LLVMInitializeWebAssemblyDisassembler));
    entry()
}
#[no_mangle]
pub extern "C" fn thinlto_codegen_set_cache_entry_expiration(
    cg: thinlto_code_gen_t,
    expiration: ::libc::c_uint,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(thinlto_code_gen_t, ::libc::c_uint),
            >(stringify!(thinlto_codegen_set_cache_entry_expiration).as_bytes())
    }
        .expect(stringify!(thinlto_codegen_set_cache_entry_expiration));
    entry(cg, expiration)
}
#[no_mangle]
pub extern "C" fn LLVMMetadataAsValue(
    C: LLVMContextRef,
    MD: LLVMMetadataRef,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMContextRef, LLVMMetadataRef) -> LLVMValueRef,
            >(stringify!(LLVMMetadataAsValue).as_bytes())
    }
        .expect(stringify!(LLVMMetadataAsValue));
    entry(C, MD)
}
#[no_mangle]
pub extern "C" fn LLVMDIGlobalVariableExpressionGetExpression(
    GVE: LLVMMetadataRef,
) -> LLVMMetadataRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMMetadataRef) -> LLVMMetadataRef,
            >(stringify!(LLVMDIGlobalVariableExpressionGetExpression).as_bytes())
    }
        .expect(stringify!(LLVMDIGlobalVariableExpressionGetExpression));
    entry(GVE)
}
#[no_mangle]
pub extern "C" fn LLVMOrcExecutionSessionSetErrorReporter(
    ES: LLVMOrcExecutionSessionRef,
    ReportError: LLVMOrcErrorReporterFunction,
    Ctx: *mut ::libc::c_void,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMOrcExecutionSessionRef,
                    LLVMOrcErrorReporterFunction,
                    *mut ::libc::c_void,
                ),
            >(stringify!(LLVMOrcExecutionSessionSetErrorReporter).as_bytes())
    }
        .expect(stringify!(LLVMOrcExecutionSessionSetErrorReporter));
    entry(ES, ReportError, Ctx)
}
#[no_mangle]
pub extern "C" fn LLVMGetCallSiteStringAttribute(
    C: LLVMValueRef,
    Idx: LLVMAttributeIndex,
    K: *const ::libc::c_char,
    KLen: ::libc::c_uint,
) -> LLVMAttributeRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMValueRef,
                    LLVMAttributeIndex,
                    *const ::libc::c_char,
                    ::libc::c_uint,
                ) -> LLVMAttributeRef,
            >(stringify!(LLVMGetCallSiteStringAttribute).as_bytes())
    }
        .expect(stringify!(LLVMGetCallSiteStringAttribute));
    entry(C, Idx, K, KLen)
}
#[no_mangle]
pub extern "C" fn LLVMCreateOperandBundle(
    Tag: *const ::libc::c_char,
    TagLen: ::libc::size_t,
    Args: *mut LLVMValueRef,
    NumArgs: ::libc::c_uint,
) -> LLVMOperandBundleRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    *const ::libc::c_char,
                    ::libc::size_t,
                    *mut LLVMValueRef,
                    ::libc::c_uint,
                ) -> LLVMOperandBundleRef,
            >(stringify!(LLVMCreateOperandBundle).as_bytes())
    }
        .expect(stringify!(LLVMCreateOperandBundle));
    entry(Tag, TagLen, Args, NumArgs)
}
#[no_mangle]
pub extern "C" fn LLVMIsSectionIteratorAtEnd(
    ObjectFile: LLVMObjectFileRef,
    SI: LLVMSectionIteratorRef,
) -> LLVMBool {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMObjectFileRef, LLVMSectionIteratorRef) -> LLVMBool,
            >(stringify!(LLVMIsSectionIteratorAtEnd).as_bytes())
    }
        .expect(stringify!(LLVMIsSectionIteratorAtEnd));
    entry(ObjectFile, SI)
}
#[no_mangle]
pub extern "C" fn LLVMRemarkEntryGetPassName(
    Remark: LLVMRemarkEntryRef,
) -> LLVMRemarkStringRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMRemarkEntryRef) -> LLVMRemarkStringRef,
            >(stringify!(LLVMRemarkEntryGetPassName).as_bytes())
    }
        .expect(stringify!(LLVMRemarkEntryGetPassName));
    entry(Remark)
}
#[no_mangle]
pub extern "C" fn LLVMPassBuilderOptionsSetDebugLogging(
    Options: LLVMPassBuilderOptionsRef,
    DebugLogging: LLVMBool,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMPassBuilderOptionsRef, LLVMBool),
            >(stringify!(LLVMPassBuilderOptionsSetDebugLogging).as_bytes())
    }
        .expect(stringify!(LLVMPassBuilderOptionsSetDebugLogging));
    entry(Options, DebugLogging)
}
#[no_mangle]
pub extern "C" fn LLVMSetTargetMachineGlobalISel(
    T: LLVMTargetMachineRef,
    Enable: LLVMBool,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMTargetMachineRef, LLVMBool),
            >(stringify!(LLVMSetTargetMachineGlobalISel).as_bytes())
    }
        .expect(stringify!(LLVMSetTargetMachineGlobalISel));
    entry(T, Enable)
}
#[no_mangle]
pub extern "C" fn LLVMGetInitializer(GlobalVar: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMGetInitializer).as_bytes())
    }
        .expect(stringify!(LLVMGetInitializer));
    entry(GlobalVar)
}
#[no_mangle]
pub extern "C" fn LLVMOrcLLJITGetMainJITDylib(J: LLVMOrcLLJITRef) -> LLVMOrcJITDylibRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMOrcLLJITRef) -> LLVMOrcJITDylibRef,
            >(stringify!(LLVMOrcLLJITGetMainJITDylib).as_bytes())
    }
        .expect(stringify!(LLVMOrcLLJITGetMainJITDylib));
    entry(J)
}
#[no_mangle]
pub extern "C" fn LLVMContextCreate() -> LLVMContextRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn() -> LLVMContextRef,
            >(stringify!(LLVMContextCreate).as_bytes())
    }
        .expect(stringify!(LLVMContextCreate));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMBFloatTypeInContext(C: LLVMContextRef) -> LLVMTypeRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMContextRef) -> LLVMTypeRef,
            >(stringify!(LLVMBFloatTypeInContext).as_bytes())
    }
        .expect(stringify!(LLVMBFloatTypeInContext));
    entry(C)
}
#[no_mangle]
pub extern "C" fn LLVMRemoveModule(
    EE: LLVMExecutionEngineRef,
    M: LLVMModuleRef,
    OutMod: *mut LLVMModuleRef,
    OutError: *mut *mut ::libc::c_char,
) -> LLVMBool {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMExecutionEngineRef,
                    LLVMModuleRef,
                    *mut LLVMModuleRef,
                    *mut *mut ::libc::c_char,
                ) -> LLVMBool,
            >(stringify!(LLVMRemoveModule).as_bytes())
    }
        .expect(stringify!(LLVMRemoveModule));
    entry(EE, M, OutMod, OutError)
}
#[no_mangle]
pub extern "C" fn LLVMInstructionClone(Inst: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMInstructionClone).as_bytes())
    }
        .expect(stringify!(LLVMInstructionClone));
    entry(Inst)
}
#[no_mangle]
pub extern "C" fn LLVMGetPreviousNamedMetadata(
    NamedMDNode: LLVMNamedMDNodeRef,
) -> LLVMNamedMDNodeRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMNamedMDNodeRef) -> LLVMNamedMDNodeRef,
            >(stringify!(LLVMGetPreviousNamedMetadata).as_bytes())
    }
        .expect(stringify!(LLVMGetPreviousNamedMetadata));
    entry(NamedMDNode)
}
#[no_mangle]
pub extern "C" fn LLVMCreateTargetMachineOptions() -> LLVMTargetMachineOptionsRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn() -> LLVMTargetMachineOptionsRef,
            >(stringify!(LLVMCreateTargetMachineOptions).as_bytes())
    }
        .expect(stringify!(LLVMCreateTargetMachineOptions));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMInitializeNVPTXTargetInfo() {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<extern "C" fn()>(stringify!(LLVMInitializeNVPTXTargetInfo).as_bytes())
    }
        .expect(stringify!(LLVMInitializeNVPTXTargetInfo));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMAppendModuleInlineAsm(
    M: LLVMModuleRef,
    Asm: *const ::libc::c_char,
    Len: ::libc::size_t,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMModuleRef, *const ::libc::c_char, ::libc::size_t),
            >(stringify!(LLVMAppendModuleInlineAsm).as_bytes())
    }
        .expect(stringify!(LLVMAppendModuleInlineAsm));
    entry(M, Asm, Len)
}
#[no_mangle]
pub extern "C" fn LLVMSetValueName2(
    Val: LLVMValueRef,
    Name: *const ::libc::c_char,
    NameLen: ::libc::size_t,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, *const ::libc::c_char, ::libc::size_t),
            >(stringify!(LLVMSetValueName2).as_bytes())
    }
        .expect(stringify!(LLVMSetValueName2));
    entry(Val, Name, NameLen)
}
#[no_mangle]
pub extern "C" fn thinlto_module_get_num_objects(
    cg: thinlto_code_gen_t,
) -> ::libc::c_int {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(thinlto_code_gen_t) -> ::libc::c_int,
            >(stringify!(thinlto_module_get_num_objects).as_bytes())
    }
        .expect(stringify!(thinlto_module_get_num_objects));
    entry(cg)
}
#[no_mangle]
pub extern "C" fn LLVMBuildBr(
    arg1: LLVMBuilderRef,
    Dest: LLVMBasicBlockRef,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMBuilderRef, LLVMBasicBlockRef) -> LLVMValueRef,
            >(stringify!(LLVMBuildBr).as_bytes())
    }
        .expect(stringify!(LLVMBuildBr));
    entry(arg1, Dest)
}
#[no_mangle]
pub extern "C" fn LLVMAddMetadataToInst(Builder: LLVMBuilderRef, Inst: LLVMValueRef) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMBuilderRef, LLVMValueRef),
            >(stringify!(LLVMAddMetadataToInst).as_bytes())
    }
        .expect(stringify!(LLVMAddMetadataToInst));
    entry(Builder, Inst)
}
#[no_mangle]
pub extern "C" fn LLVMExecutionEngineGetErrMsg(
    EE: LLVMExecutionEngineRef,
    OutError: *mut *mut ::libc::c_char,
) -> LLVMBool {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMExecutionEngineRef,
                    *mut *mut ::libc::c_char,
                ) -> LLVMBool,
            >(stringify!(LLVMExecutionEngineGetErrMsg).as_bytes())
    }
        .expect(stringify!(LLVMExecutionEngineGetErrMsg));
    entry(EE, OutError)
}
#[no_mangle]
pub extern "C" fn LLVMOrcThreadSafeModuleWithModuleDo(
    TSM: LLVMOrcThreadSafeModuleRef,
    F: LLVMOrcGenericIRModuleOperationFunction,
    Ctx: *mut ::libc::c_void,
) -> LLVMErrorRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMOrcThreadSafeModuleRef,
                    LLVMOrcGenericIRModuleOperationFunction,
                    *mut ::libc::c_void,
                ) -> LLVMErrorRef,
            >(stringify!(LLVMOrcThreadSafeModuleWithModuleDo).as_bytes())
    }
        .expect(stringify!(LLVMOrcThreadSafeModuleWithModuleDo));
    entry(TSM, F, Ctx)
}
#[no_mangle]
pub extern "C" fn LLVMIsAGlobalValue(Val: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMIsAGlobalValue).as_bytes())
    }
        .expect(stringify!(LLVMIsAGlobalValue));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn LLVMGetCondition(Branch: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMGetCondition).as_bytes())
    }
        .expect(stringify!(LLVMGetCondition));
    entry(Branch)
}
#[no_mangle]
pub extern "C" fn LLVMIsAGlobalObject(Val: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMIsAGlobalObject).as_bytes())
    }
        .expect(stringify!(LLVMIsAGlobalObject));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn LLVMIsAMemMoveInst(Val: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMIsAMemMoveInst).as_bytes())
    }
        .expect(stringify!(LLVMIsAMemMoveInst));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn LLVMOrcLLJITAddLLVMIRModuleWithRT(
    J: LLVMOrcLLJITRef,
    JD: LLVMOrcResourceTrackerRef,
    TSM: LLVMOrcThreadSafeModuleRef,
) -> LLVMErrorRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMOrcLLJITRef,
                    LLVMOrcResourceTrackerRef,
                    LLVMOrcThreadSafeModuleRef,
                ) -> LLVMErrorRef,
            >(stringify!(LLVMOrcLLJITAddLLVMIRModuleWithRT).as_bytes())
    }
        .expect(stringify!(LLVMOrcLLJITAddLLVMIRModuleWithRT));
    entry(J, JD, TSM)
}
#[no_mangle]
pub extern "C" fn LLVMGetUsedValue(U: LLVMUseRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMUseRef) -> LLVMValueRef,
            >(stringify!(LLVMGetUsedValue).as_bytes())
    }
        .expect(stringify!(LLVMGetUsedValue));
    entry(U)
}
#[no_mangle]
pub extern "C" fn LLVMOrcReleaseResourceTracker(RT: LLVMOrcResourceTrackerRef) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMOrcResourceTrackerRef),
            >(stringify!(LLVMOrcReleaseResourceTracker).as_bytes())
    }
        .expect(stringify!(LLVMOrcReleaseResourceTracker));
    entry(RT)
}
#[no_mangle]
pub extern "C" fn LLVMRemarkParserHasError(Parser: LLVMRemarkParserRef) -> LLVMBool {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMRemarkParserRef) -> LLVMBool,
            >(stringify!(LLVMRemarkParserHasError).as_bytes())
    }
        .expect(stringify!(LLVMRemarkParserHasError));
    entry(Parser)
}
#[no_mangle]
pub extern "C" fn LLVMGetHandlers(
    CatchSwitch: LLVMValueRef,
    Handlers: *mut LLVMBasicBlockRef,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, *mut LLVMBasicBlockRef),
            >(stringify!(LLVMGetHandlers).as_bytes())
    }
        .expect(stringify!(LLVMGetHandlers));
    entry(CatchSwitch, Handlers)
}
#[no_mangle]
pub extern "C" fn LLVMGetGlobalContext() -> LLVMContextRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn() -> LLVMContextRef,
            >(stringify!(LLVMGetGlobalContext).as_bytes())
    }
        .expect(stringify!(LLVMGetGlobalContext));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMBuilderSetDefaultFPMathTag(
    Builder: LLVMBuilderRef,
    FPMathTag: LLVMMetadataRef,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMBuilderRef, LLVMMetadataRef),
            >(stringify!(LLVMBuilderSetDefaultFPMathTag).as_bytes())
    }
        .expect(stringify!(LLVMBuilderSetDefaultFPMathTag));
    entry(Builder, FPMathTag)
}
#[no_mangle]
pub extern "C" fn LLVMDITypeGetAlignInBits(DType: LLVMMetadataRef) -> u32 {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMMetadataRef) -> u32,
            >(stringify!(LLVMDITypeGetAlignInBits).as_bytes())
    }
        .expect(stringify!(LLVMDITypeGetAlignInBits));
    entry(DType)
}
#[no_mangle]
pub extern "C" fn LLVMGetValueContext(Val: LLVMValueRef) -> LLVMContextRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMContextRef,
            >(stringify!(LLVMGetValueContext).as_bytes())
    }
        .expect(stringify!(LLVMGetValueContext));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn LLVMBFloatType() -> LLVMTypeRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<extern "C" fn() -> LLVMTypeRef>(stringify!(LLVMBFloatType).as_bytes())
    }
        .expect(stringify!(LLVMBFloatType));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMInsertBasicBlockInContext(
    C: LLVMContextRef,
    BB: LLVMBasicBlockRef,
    Name: *const ::libc::c_char,
) -> LLVMBasicBlockRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMContextRef,
                    LLVMBasicBlockRef,
                    *const ::libc::c_char,
                ) -> LLVMBasicBlockRef,
            >(stringify!(LLVMInsertBasicBlockInContext).as_bytes())
    }
        .expect(stringify!(LLVMInsertBasicBlockInContext));
    entry(C, BB, Name)
}
#[no_mangle]
pub extern "C" fn LLVMGEPGetNoWrapFlags(GEP: LLVMValueRef) -> LLVMGEPNoWrapFlags {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMGEPNoWrapFlags,
            >(stringify!(LLVMGEPGetNoWrapFlags).as_bytes())
    }
        .expect(stringify!(LLVMGEPGetNoWrapFlags));
    entry(GEP)
}
#[no_mangle]
pub extern "C" fn LLVMGetLastEnumAttributeKind() -> ::libc::c_uint {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn() -> ::libc::c_uint,
            >(stringify!(LLVMGetLastEnumAttributeKind).as_bytes())
    }
        .expect(stringify!(LLVMGetLastEnumAttributeKind));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMRunFunctionAsMain(
    EE: LLVMExecutionEngineRef,
    F: LLVMValueRef,
    ArgC: ::libc::c_uint,
    ArgV: *const *const ::libc::c_char,
    EnvP: *const *const ::libc::c_char,
) -> ::libc::c_int {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMExecutionEngineRef,
                    LLVMValueRef,
                    ::libc::c_uint,
                    *const *const ::libc::c_char,
                    *const *const ::libc::c_char,
                ) -> ::libc::c_int,
            >(stringify!(LLVMRunFunctionAsMain).as_bytes())
    }
        .expect(stringify!(LLVMRunFunctionAsMain));
    entry(EE, F, ArgC, ArgV, EnvP)
}
#[no_mangle]
pub extern "C" fn LLVMInitializeWebAssemblyTargetMC() {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(),
            >(stringify!(LLVMInitializeWebAssemblyTargetMC).as_bytes())
    }
        .expect(stringify!(LLVMInitializeWebAssemblyTargetMC));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMAliasGetAliasee(Alias: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMAliasGetAliasee).as_bytes())
    }
        .expect(stringify!(LLVMAliasGetAliasee));
    entry(Alias)
}
#[no_mangle]
pub extern "C" fn lto_module_create_from_fd_at_offset(
    fd: ::libc::c_int,
    path: *const ::libc::c_char,
    file_size: ::libc::size_t,
    map_size: ::libc::size_t,
    offset: ::libc::off_t,
) -> lto_module_t {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    ::libc::c_int,
                    *const ::libc::c_char,
                    ::libc::size_t,
                    ::libc::size_t,
                    ::libc::off_t,
                ) -> lto_module_t,
            >(stringify!(lto_module_create_from_fd_at_offset).as_bytes())
    }
        .expect(stringify!(lto_module_create_from_fd_at_offset));
    entry(fd, path, file_size, map_size, offset)
}
#[no_mangle]
pub extern "C" fn LLVMOrcObjectTransformLayerSetTransform(
    ObjTransformLayer: LLVMOrcObjectTransformLayerRef,
    TransformFunction: LLVMOrcObjectTransformLayerTransformFunction,
    Ctx: *mut ::libc::c_void,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMOrcObjectTransformLayerRef,
                    LLVMOrcObjectTransformLayerTransformFunction,
                    *mut ::libc::c_void,
                ),
            >(stringify!(LLVMOrcObjectTransformLayerSetTransform).as_bytes())
    }
        .expect(stringify!(LLVMOrcObjectTransformLayerSetTransform));
    entry(ObjTransformLayer, TransformFunction, Ctx)
}
#[no_mangle]
pub extern "C" fn LLVMGetNumSuccessors(Term: LLVMValueRef) -> ::libc::c_uint {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> ::libc::c_uint,
            >(stringify!(LLVMGetNumSuccessors).as_bytes())
    }
        .expect(stringify!(LLVMGetNumSuccessors));
    entry(Term)
}
#[no_mangle]
pub extern "C" fn LLVMInt32Type() -> LLVMTypeRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<extern "C" fn() -> LLVMTypeRef>(stringify!(LLVMInt32Type).as_bytes())
    }
        .expect(stringify!(LLVMInt32Type));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMIsAConstantDataArray(Val: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMIsAConstantDataArray).as_bytes())
    }
        .expect(stringify!(LLVMIsAConstantDataArray));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn LLVMGetTargetExtTypeIntParam(
    TargetExtTy: LLVMTypeRef,
    Idx: ::libc::c_uint,
) -> ::libc::c_uint {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMTypeRef, ::libc::c_uint) -> ::libc::c_uint,
            >(stringify!(LLVMGetTargetExtTypeIntParam).as_bytes())
    }
        .expect(stringify!(LLVMGetTargetExtTypeIntParam));
    entry(TargetExtTy, Idx)
}
#[no_mangle]
pub extern "C" fn LLVMIsAUndefValue(Val: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMIsAUndefValue).as_bytes())
    }
        .expect(stringify!(LLVMIsAUndefValue));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn LLVMPointerSizeForAS(
    TD: LLVMTargetDataRef,
    AS: ::libc::c_uint,
) -> ::libc::c_uint {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMTargetDataRef, ::libc::c_uint) -> ::libc::c_uint,
            >(stringify!(LLVMPointerSizeForAS).as_bytes())
    }
        .expect(stringify!(LLVMPointerSizeForAS));
    entry(TD, AS)
}
#[no_mangle]
pub extern "C" fn LLVMStructTypeInContext(
    C: LLVMContextRef,
    ElementTypes: *mut LLVMTypeRef,
    ElementCount: ::libc::c_uint,
    Packed: LLVMBool,
) -> LLVMTypeRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMContextRef,
                    *mut LLVMTypeRef,
                    ::libc::c_uint,
                    LLVMBool,
                ) -> LLVMTypeRef,
            >(stringify!(LLVMStructTypeInContext).as_bytes())
    }
        .expect(stringify!(LLVMStructTypeInContext));
    entry(C, ElementTypes, ElementCount, Packed)
}
#[no_mangle]
pub extern "C" fn LLVMReplaceMDNodeOperandWith(
    V: LLVMValueRef,
    Index: ::libc::c_uint,
    Replacement: LLVMMetadataRef,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, ::libc::c_uint, LLVMMetadataRef),
            >(stringify!(LLVMReplaceMDNodeOperandWith).as_bytes())
    }
        .expect(stringify!(LLVMReplaceMDNodeOperandWith));
    entry(V, Index, Replacement)
}
#[no_mangle]
pub extern "C" fn lto_codegen_compile_to_file(
    cg: lto_code_gen_t,
    name: *mut *const ::libc::c_char,
) -> lto_bool_t {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(lto_code_gen_t, *mut *const ::libc::c_char) -> lto_bool_t,
            >(stringify!(lto_codegen_compile_to_file).as_bytes())
    }
        .expect(stringify!(lto_codegen_compile_to_file));
    entry(cg, name)
}
#[no_mangle]
pub extern "C" fn LLVMGetAtomicRMWBinOp(
    AtomicRMWInst: LLVMValueRef,
) -> LLVMAtomicRMWBinOp {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMAtomicRMWBinOp,
            >(stringify!(LLVMGetAtomicRMWBinOp).as_bytes())
    }
        .expect(stringify!(LLVMGetAtomicRMWBinOp));
    entry(AtomicRMWInst)
}
#[no_mangle]
pub extern "C" fn LLVMPreferredAlignmentOfType(
    TD: LLVMTargetDataRef,
    Ty: LLVMTypeRef,
) -> ::libc::c_uint {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMTargetDataRef, LLVMTypeRef) -> ::libc::c_uint,
            >(stringify!(LLVMPreferredAlignmentOfType).as_bytes())
    }
        .expect(stringify!(LLVMPreferredAlignmentOfType));
    entry(TD, Ty)
}
#[no_mangle]
pub extern "C" fn LLVMBuildRet(arg1: LLVMBuilderRef, V: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMBuilderRef, LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMBuildRet).as_bytes())
    }
        .expect(stringify!(LLVMBuildRet));
    entry(arg1, V)
}
#[no_mangle]
pub extern "C" fn LLVMByteOrder(TD: LLVMTargetDataRef) -> LLVMByteOrdering {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMTargetDataRef) -> LLVMByteOrdering,
            >(stringify!(LLVMByteOrder).as_bytes())
    }
        .expect(stringify!(LLVMByteOrder));
    entry(TD)
}
#[no_mangle]
pub extern "C" fn LLVMSetPersonalityFn(Fn: LLVMValueRef, PersonalityFn: LLVMValueRef) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, LLVMValueRef),
            >(stringify!(LLVMSetPersonalityFn).as_bytes())
    }
        .expect(stringify!(LLVMSetPersonalityFn));
    entry(Fn, PersonalityFn)
}
#[no_mangle]
pub extern "C" fn LLVMIsAIndirectBrInst(Val: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMIsAIndirectBrInst).as_bytes())
    }
        .expect(stringify!(LLVMIsAIndirectBrInst));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn LLVMBuildShl(
    arg1: LLVMBuilderRef,
    LHS: LLVMValueRef,
    RHS: LLVMValueRef,
    Name: *const ::libc::c_char,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMBuilderRef,
                    LLVMValueRef,
                    LLVMValueRef,
                    *const ::libc::c_char,
                ) -> LLVMValueRef,
            >(stringify!(LLVMBuildShl).as_bytes())
    }
        .expect(stringify!(LLVMBuildShl));
    entry(arg1, LHS, RHS, Name)
}
#[no_mangle]
pub extern "C" fn LLVMGetModuleContext(M: LLVMModuleRef) -> LLVMContextRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMModuleRef) -> LLVMContextRef,
            >(stringify!(LLVMGetModuleContext).as_bytes())
    }
        .expect(stringify!(LLVMGetModuleContext));
    entry(M)
}
#[no_mangle]
pub extern "C" fn LLVMBuildMemCpy(
    B: LLVMBuilderRef,
    Dst: LLVMValueRef,
    DstAlign: ::libc::c_uint,
    Src: LLVMValueRef,
    SrcAlign: ::libc::c_uint,
    Size: LLVMValueRef,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMBuilderRef,
                    LLVMValueRef,
                    ::libc::c_uint,
                    LLVMValueRef,
                    ::libc::c_uint,
                    LLVMValueRef,
                ) -> LLVMValueRef,
            >(stringify!(LLVMBuildMemCpy).as_bytes())
    }
        .expect(stringify!(LLVMBuildMemCpy));
    entry(B, Dst, DstAlign, Src, SrcAlign, Size)
}
#[no_mangle]
pub extern "C" fn LLVMRemarkEntryGetFirstArg(
    Remark: LLVMRemarkEntryRef,
) -> LLVMRemarkArgRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMRemarkEntryRef) -> LLVMRemarkArgRef,
            >(stringify!(LLVMRemarkEntryGetFirstArg).as_bytes())
    }
        .expect(stringify!(LLVMRemarkEntryGetFirstArg));
    entry(Remark)
}
#[no_mangle]
pub extern "C" fn LLVMRemarkEntryGetHotness(Remark: LLVMRemarkEntryRef) -> u64 {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMRemarkEntryRef) -> u64,
            >(stringify!(LLVMRemarkEntryGetHotness).as_bytes())
    }
        .expect(stringify!(LLVMRemarkEntryGetHotness));
    entry(Remark)
}
#[no_mangle]
pub extern "C" fn LLVMConstMul(
    LHSConstant: LLVMValueRef,
    RHSConstant: LLVMValueRef,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMConstMul).as_bytes())
    }
        .expect(stringify!(LLVMConstMul));
    entry(LHSConstant, RHSConstant)
}
#[no_mangle]
pub extern "C" fn LLVMBuildIndirectBr(
    B: LLVMBuilderRef,
    Addr: LLVMValueRef,
    NumDests: ::libc::c_uint,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMBuilderRef,
                    LLVMValueRef,
                    ::libc::c_uint,
                ) -> LLVMValueRef,
            >(stringify!(LLVMBuildIndirectBr).as_bytes())
    }
        .expect(stringify!(LLVMBuildIndirectBr));
    entry(B, Addr, NumDests)
}
#[no_mangle]
pub extern "C" fn LLVMGetNamedFunction(
    M: LLVMModuleRef,
    Name: *const ::libc::c_char,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMModuleRef, *const ::libc::c_char) -> LLVMValueRef,
            >(stringify!(LLVMGetNamedFunction).as_bytes())
    }
        .expect(stringify!(LLVMGetNamedFunction));
    entry(M, Name)
}
#[no_mangle]
pub extern "C" fn LLVMTargetHasAsmBackend(T: LLVMTargetRef) -> LLVMBool {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMTargetRef) -> LLVMBool,
            >(stringify!(LLVMTargetHasAsmBackend).as_bytes())
    }
        .expect(stringify!(LLVMTargetHasAsmBackend));
    entry(T)
}
#[no_mangle]
pub extern "C" fn lto_codegen_dispose(arg1: lto_code_gen_t) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(lto_code_gen_t),
            >(stringify!(lto_codegen_dispose).as_bytes())
    }
        .expect(stringify!(lto_codegen_dispose));
    entry(arg1)
}
#[no_mangle]
pub extern "C" fn LLVMGetSectionAddress(SI: LLVMSectionIteratorRef) -> u64 {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMSectionIteratorRef) -> u64,
            >(stringify!(LLVMGetSectionAddress).as_bytes())
    }
        .expect(stringify!(LLVMGetSectionAddress));
    entry(SI)
}
#[no_mangle]
pub extern "C" fn LLVMDIBuilderGetOrCreateTypeArray(
    Builder: LLVMDIBuilderRef,
    Data: *mut LLVMMetadataRef,
    NumElements: ::libc::size_t,
) -> LLVMMetadataRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMDIBuilderRef,
                    *mut LLVMMetadataRef,
                    ::libc::size_t,
                ) -> LLVMMetadataRef,
            >(stringify!(LLVMDIBuilderGetOrCreateTypeArray).as_bytes())
    }
        .expect(stringify!(LLVMDIBuilderGetOrCreateTypeArray));
    entry(Builder, Data, NumElements)
}
#[no_mangle]
pub extern "C" fn LLVMCreateFunctionPassManagerForModule(
    M: LLVMModuleRef,
) -> LLVMPassManagerRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMModuleRef) -> LLVMPassManagerRef,
            >(stringify!(LLVMCreateFunctionPassManagerForModule).as_bytes())
    }
        .expect(stringify!(LLVMCreateFunctionPassManagerForModule));
    entry(M)
}
#[no_mangle]
pub extern "C" fn LLVMPrintDbgRecordToString(
    Record: LLVMDbgRecordRef,
) -> *mut ::libc::c_char {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMDbgRecordRef) -> *mut ::libc::c_char,
            >(stringify!(LLVMPrintDbgRecordToString).as_bytes())
    }
        .expect(stringify!(LLVMPrintDbgRecordToString));
    entry(Record)
}
#[no_mangle]
pub extern "C" fn LLVMTypeIsSized(Ty: LLVMTypeRef) -> LLVMBool {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMTypeRef) -> LLVMBool,
            >(stringify!(LLVMTypeIsSized).as_bytes())
    }
        .expect(stringify!(LLVMTypeIsSized));
    entry(Ty)
}
#[no_mangle]
pub extern "C" fn LLVMBuildNUWAdd(
    arg1: LLVMBuilderRef,
    LHS: LLVMValueRef,
    RHS: LLVMValueRef,
    Name: *const ::libc::c_char,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMBuilderRef,
                    LLVMValueRef,
                    LLVMValueRef,
                    *const ::libc::c_char,
                ) -> LLVMValueRef,
            >(stringify!(LLVMBuildNUWAdd).as_bytes())
    }
        .expect(stringify!(LLVMBuildNUWAdd));
    entry(arg1, LHS, RHS, Name)
}
#[no_mangle]
pub extern "C" fn LLVMBuildVAArg(
    arg1: LLVMBuilderRef,
    List: LLVMValueRef,
    Ty: LLVMTypeRef,
    Name: *const ::libc::c_char,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMBuilderRef,
                    LLVMValueRef,
                    LLVMTypeRef,
                    *const ::libc::c_char,
                ) -> LLVMValueRef,
            >(stringify!(LLVMBuildVAArg).as_bytes())
    }
        .expect(stringify!(LLVMBuildVAArg));
    entry(arg1, List, Ty, Name)
}
#[no_mangle]
pub extern "C" fn thinlto_codegen_add_must_preserve_symbol(
    cg: thinlto_code_gen_t,
    name: *const ::libc::c_char,
    length: ::libc::c_int,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(thinlto_code_gen_t, *const ::libc::c_char, ::libc::c_int),
            >(stringify!(thinlto_codegen_add_must_preserve_symbol).as_bytes())
    }
        .expect(stringify!(thinlto_codegen_add_must_preserve_symbol));
    entry(cg, name, length)
}
#[no_mangle]
pub extern "C" fn LLVMRemarkStringGetLen(String: LLVMRemarkStringRef) -> u32 {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMRemarkStringRef) -> u32,
            >(stringify!(LLVMRemarkStringGetLen).as_bytes())
    }
        .expect(stringify!(LLVMRemarkStringGetLen));
    entry(String)
}
#[no_mangle]
pub extern "C" fn LLVMCloneModule(M: LLVMModuleRef) -> LLVMModuleRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMModuleRef) -> LLVMModuleRef,
            >(stringify!(LLVMCloneModule).as_bytes())
    }
        .expect(stringify!(LLVMCloneModule));
    entry(M)
}
#[no_mangle]
pub extern "C" fn LLVMIsAResumeInst(Val: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMIsAResumeInst).as_bytes())
    }
        .expect(stringify!(LLVMIsAResumeInst));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn LLVMConstPointerCast(
    ConstantVal: LLVMValueRef,
    ToType: LLVMTypeRef,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, LLVMTypeRef) -> LLVMValueRef,
            >(stringify!(LLVMConstPointerCast).as_bytes())
    }
        .expect(stringify!(LLVMConstPointerCast));
    entry(ConstantVal, ToType)
}
#[no_mangle]
pub extern "C" fn LLVMBuildSRem(
    arg1: LLVMBuilderRef,
    LHS: LLVMValueRef,
    RHS: LLVMValueRef,
    Name: *const ::libc::c_char,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMBuilderRef,
                    LLVMValueRef,
                    LLVMValueRef,
                    *const ::libc::c_char,
                ) -> LLVMValueRef,
            >(stringify!(LLVMBuildSRem).as_bytes())
    }
        .expect(stringify!(LLVMBuildSRem));
    entry(arg1, LHS, RHS, Name)
}
#[no_mangle]
pub extern "C" fn LLVMSetIsNewDbgInfoFormat(M: LLVMModuleRef, UseNewFormat: LLVMBool) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMModuleRef, LLVMBool),
            >(stringify!(LLVMSetIsNewDbgInfoFormat).as_bytes())
    }
        .expect(stringify!(LLVMSetIsNewDbgInfoFormat));
    entry(M, UseNewFormat)
}
#[no_mangle]
pub extern "C" fn LLVMVerifyModule(
    M: LLVMModuleRef,
    Action: LLVMVerifierFailureAction,
    OutMessage: *mut *mut ::libc::c_char,
) -> LLVMBool {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMModuleRef,
                    LLVMVerifierFailureAction,
                    *mut *mut ::libc::c_char,
                ) -> LLVMBool,
            >(stringify!(LLVMVerifyModule).as_bytes())
    }
        .expect(stringify!(LLVMVerifyModule));
    entry(M, Action, OutMessage)
}
#[no_mangle]
pub extern "C" fn LLVMPrintModuleToFile(
    M: LLVMModuleRef,
    Filename: *const ::libc::c_char,
    ErrorMessage: *mut *mut ::libc::c_char,
) -> LLVMBool {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMModuleRef,
                    *const ::libc::c_char,
                    *mut *mut ::libc::c_char,
                ) -> LLVMBool,
            >(stringify!(LLVMPrintModuleToFile).as_bytes())
    }
        .expect(stringify!(LLVMPrintModuleToFile));
    entry(M, Filename, ErrorMessage)
}
#[no_mangle]
pub extern "C" fn LLVMGetCallBrIndirectDest(
    CallBr: LLVMValueRef,
    Idx: ::libc::c_uint,
) -> LLVMBasicBlockRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, ::libc::c_uint) -> LLVMBasicBlockRef,
            >(stringify!(LLVMGetCallBrIndirectDest).as_bytes())
    }
        .expect(stringify!(LLVMGetCallBrIndirectDest));
    entry(CallBr, Idx)
}
#[no_mangle]
pub extern "C" fn LLVMPointerSize(TD: LLVMTargetDataRef) -> ::libc::c_uint {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMTargetDataRef) -> ::libc::c_uint,
            >(stringify!(LLVMPointerSize).as_bytes())
    }
        .expect(stringify!(LLVMPointerSize));
    entry(TD)
}
#[no_mangle]
pub extern "C" fn LLVMIsRelocationIteratorAtEnd(
    Section: LLVMSectionIteratorRef,
    RI: LLVMRelocationIteratorRef,
) -> LLVMBool {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMSectionIteratorRef,
                    LLVMRelocationIteratorRef,
                ) -> LLVMBool,
            >(stringify!(LLVMIsRelocationIteratorAtEnd).as_bytes())
    }
        .expect(stringify!(LLVMIsRelocationIteratorAtEnd));
    entry(Section, RI)
}
#[no_mangle]
pub extern "C" fn LLVMAppendBasicBlock(
    Fn: LLVMValueRef,
    Name: *const ::libc::c_char,
) -> LLVMBasicBlockRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, *const ::libc::c_char) -> LLVMBasicBlockRef,
            >(stringify!(LLVMAppendBasicBlock).as_bytes())
    }
        .expect(stringify!(LLVMAppendBasicBlock));
    entry(Fn, Name)
}
#[no_mangle]
pub extern "C" fn LLVMContextGetDiagnosticHandler(
    C: LLVMContextRef,
) -> LLVMDiagnosticHandler {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMContextRef) -> LLVMDiagnosticHandler,
            >(stringify!(LLVMContextGetDiagnosticHandler).as_bytes())
    }
        .expect(stringify!(LLVMContextGetDiagnosticHandler));
    entry(C)
}
#[no_mangle]
pub extern "C" fn LLVMDisposeGenericValue(GenVal: LLVMGenericValueRef) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMGenericValueRef),
            >(stringify!(LLVMDisposeGenericValue).as_bytes())
    }
        .expect(stringify!(LLVMDisposeGenericValue));
    entry(GenVal)
}
#[no_mangle]
pub extern "C" fn LLVMGenericValueIntWidth(
    GenValRef: LLVMGenericValueRef,
) -> ::libc::c_uint {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMGenericValueRef) -> ::libc::c_uint,
            >(stringify!(LLVMGenericValueIntWidth).as_bytes())
    }
        .expect(stringify!(LLVMGenericValueIntWidth));
    entry(GenValRef)
}
#[no_mangle]
pub extern "C" fn LLVMIntTypeInContext(
    C: LLVMContextRef,
    NumBits: ::libc::c_uint,
) -> LLVMTypeRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMContextRef, ::libc::c_uint) -> LLVMTypeRef,
            >(stringify!(LLVMIntTypeInContext).as_bytes())
    }
        .expect(stringify!(LLVMIntTypeInContext));
    entry(C, NumBits)
}
#[no_mangle]
pub extern "C" fn LLVMGetLastGlobalAlias(M: LLVMModuleRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMModuleRef) -> LLVMValueRef,
            >(stringify!(LLVMGetLastGlobalAlias).as_bytes())
    }
        .expect(stringify!(LLVMGetLastGlobalAlias));
    entry(M)
}
#[no_mangle]
pub extern "C" fn LLVMConstIntGetSExtValue(
    ConstantVal: LLVMValueRef,
) -> ::libc::c_longlong {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> ::libc::c_longlong,
            >(stringify!(LLVMConstIntGetSExtValue).as_bytes())
    }
        .expect(stringify!(LLVMConstIntGetSExtValue));
    entry(ConstantVal)
}
#[no_mangle]
pub extern "C" fn LLVMConstGEPWithNoWrapFlags(
    Ty: LLVMTypeRef,
    ConstantVal: LLVMValueRef,
    ConstantIndices: *mut LLVMValueRef,
    NumIndices: ::libc::c_uint,
    NoWrapFlags: LLVMGEPNoWrapFlags,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMTypeRef,
                    LLVMValueRef,
                    *mut LLVMValueRef,
                    ::libc::c_uint,
                    LLVMGEPNoWrapFlags,
                ) -> LLVMValueRef,
            >(stringify!(LLVMConstGEPWithNoWrapFlags).as_bytes())
    }
        .expect(stringify!(LLVMConstGEPWithNoWrapFlags));
    entry(Ty, ConstantVal, ConstantIndices, NumIndices, NoWrapFlags)
}
#[no_mangle]
pub extern "C" fn LLVMGetBuilderContext(Builder: LLVMBuilderRef) -> LLVMContextRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMBuilderRef) -> LLVMContextRef,
            >(stringify!(LLVMGetBuilderContext).as_bytes())
    }
        .expect(stringify!(LLVMGetBuilderContext));
    entry(Builder)
}
#[no_mangle]
pub extern "C" fn LLVMSetCleanup(LandingPad: LLVMValueRef, Val: LLVMBool) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, LLVMBool),
            >(stringify!(LLVMSetCleanup).as_bytes())
    }
        .expect(stringify!(LLVMSetCleanup));
    entry(LandingPad, Val)
}
#[no_mangle]
pub extern "C" fn LLVMSetTailCall(CallInst: LLVMValueRef, IsTailCall: LLVMBool) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, LLVMBool),
            >(stringify!(LLVMSetTailCall).as_bytes())
    }
        .expect(stringify!(LLVMSetTailCall));
    entry(CallInst, IsTailCall)
}
#[no_mangle]
pub extern "C" fn LLVMConstNUWSub(
    LHSConstant: LLVMValueRef,
    RHSConstant: LLVMValueRef,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMConstNUWSub).as_bytes())
    }
        .expect(stringify!(LLVMConstNUWSub));
    entry(LHSConstant, RHSConstant)
}
#[no_mangle]
pub extern "C" fn llvm_blake3_hasher_init_derive_key(
    hasher: *mut llvm_blake3_hasher,
    context: *const ::libc::c_char,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(*mut llvm_blake3_hasher, *const ::libc::c_char),
            >(stringify!(llvm_blake3_hasher_init_derive_key).as_bytes())
    }
        .expect(stringify!(llvm_blake3_hasher_init_derive_key));
    entry(hasher, context)
}
#[no_mangle]
pub extern "C" fn LLVMContextShouldDiscardValueNames(C: LLVMContextRef) -> LLVMBool {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMContextRef) -> LLVMBool,
            >(stringify!(LLVMContextShouldDiscardValueNames).as_bytes())
    }
        .expect(stringify!(LLVMContextShouldDiscardValueNames));
    entry(C)
}
#[no_mangle]
pub extern "C" fn LLVMGetFirstInstruction(BB: LLVMBasicBlockRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMBasicBlockRef) -> LLVMValueRef,
            >(stringify!(LLVMGetFirstInstruction).as_bytes())
    }
        .expect(stringify!(LLVMGetFirstInstruction));
    entry(BB)
}
#[no_mangle]
pub extern "C" fn LLVMGetCalledValue(Instr: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMGetCalledValue).as_bytes())
    }
        .expect(stringify!(LLVMGetCalledValue));
    entry(Instr)
}
#[no_mangle]
pub extern "C" fn LLVMGetStructElementTypes(
    StructTy: LLVMTypeRef,
    Dest: *mut LLVMTypeRef,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMTypeRef, *mut LLVMTypeRef),
            >(stringify!(LLVMGetStructElementTypes).as_bytes())
    }
        .expect(stringify!(LLVMGetStructElementTypes));
    entry(StructTy, Dest)
}
#[no_mangle]
pub extern "C" fn LLVMIsAConstantPointerNull(Val: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMIsAConstantPointerNull).as_bytes())
    }
        .expect(stringify!(LLVMIsAConstantPointerNull));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn LLVMSetFastMathFlags(
    FPMathInst: LLVMValueRef,
    FMF: LLVMFastMathFlags,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, LLVMFastMathFlags),
            >(stringify!(LLVMSetFastMathFlags).as_bytes())
    }
        .expect(stringify!(LLVMSetFastMathFlags));
    entry(FPMathInst, FMF)
}
#[no_mangle]
pub extern "C" fn LLVMSetIsDisjoint(Inst: LLVMValueRef, IsDisjoint: LLVMBool) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, LLVMBool),
            >(stringify!(LLVMSetIsDisjoint).as_bytes())
    }
        .expect(stringify!(LLVMSetIsDisjoint));
    entry(Inst, IsDisjoint)
}
#[no_mangle]
pub extern "C" fn LLVMOrcLLJITMangleAndIntern(
    J: LLVMOrcLLJITRef,
    UnmangledName: *const ::libc::c_char,
) -> LLVMOrcSymbolStringPoolEntryRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMOrcLLJITRef,
                    *const ::libc::c_char,
                ) -> LLVMOrcSymbolStringPoolEntryRef,
            >(stringify!(LLVMOrcLLJITMangleAndIntern).as_bytes())
    }
        .expect(stringify!(LLVMOrcLLJITMangleAndIntern));
    entry(J, UnmangledName)
}
#[no_mangle]
pub extern "C" fn LLVMModuleCreateWithNameInContext(
    ModuleID: *const ::libc::c_char,
    C: LLVMContextRef,
) -> LLVMModuleRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(*const ::libc::c_char, LLVMContextRef) -> LLVMModuleRef,
            >(stringify!(LLVMModuleCreateWithNameInContext).as_bytes())
    }
        .expect(stringify!(LLVMModuleCreateWithNameInContext));
    entry(ModuleID, C)
}
#[no_mangle]
pub extern "C" fn LLVMBuildInBoundsGEP2(
    B: LLVMBuilderRef,
    Ty: LLVMTypeRef,
    Pointer: LLVMValueRef,
    Indices: *mut LLVMValueRef,
    NumIndices: ::libc::c_uint,
    Name: *const ::libc::c_char,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMBuilderRef,
                    LLVMTypeRef,
                    LLVMValueRef,
                    *mut LLVMValueRef,
                    ::libc::c_uint,
                    *const ::libc::c_char,
                ) -> LLVMValueRef,
            >(stringify!(LLVMBuildInBoundsGEP2).as_bytes())
    }
        .expect(stringify!(LLVMBuildInBoundsGEP2));
    entry(B, Ty, Pointer, Indices, NumIndices, Name)
}
#[no_mangle]
pub extern "C" fn LLVMRunFunctionPassManager(
    FPM: LLVMPassManagerRef,
    F: LLVMValueRef,
) -> LLVMBool {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMPassManagerRef, LLVMValueRef) -> LLVMBool,
            >(stringify!(LLVMRunFunctionPassManager).as_bytes())
    }
        .expect(stringify!(LLVMRunFunctionPassManager));
    entry(FPM, F)
}
#[no_mangle]
pub extern "C" fn LLVMGetParams(Fn: LLVMValueRef, Params: *mut LLVMValueRef) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, *mut LLVMValueRef),
            >(stringify!(LLVMGetParams).as_bytes())
    }
        .expect(stringify!(LLVMGetParams));
    entry(Fn, Params)
}
#[no_mangle]
pub extern "C" fn LLVMOrcLLJITBuilderSetJITTargetMachineBuilder(
    Builder: LLVMOrcLLJITBuilderRef,
    JTMB: LLVMOrcJITTargetMachineBuilderRef,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMOrcLLJITBuilderRef, LLVMOrcJITTargetMachineBuilderRef),
            >(stringify!(LLVMOrcLLJITBuilderSetJITTargetMachineBuilder).as_bytes())
    }
        .expect(stringify!(LLVMOrcLLJITBuilderSetJITTargetMachineBuilder));
    entry(Builder, JTMB)
}
#[no_mangle]
pub extern "C" fn LLVMIsAFreezeInst(Val: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMIsAFreezeInst).as_bytes())
    }
        .expect(stringify!(LLVMIsAFreezeInst));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn LLVMConstVector(
    ScalarConstantVals: *mut LLVMValueRef,
    Size: ::libc::c_uint,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(*mut LLVMValueRef, ::libc::c_uint) -> LLVMValueRef,
            >(stringify!(LLVMConstVector).as_bytes())
    }
        .expect(stringify!(LLVMConstVector));
    entry(ScalarConstantVals, Size)
}
#[no_mangle]
pub extern "C" fn thinlto_set_generated_objects_dir(
    cg: thinlto_code_gen_t,
    save_temps_dir: *const ::libc::c_char,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(thinlto_code_gen_t, *const ::libc::c_char),
            >(stringify!(thinlto_set_generated_objects_dir).as_bytes())
    }
        .expect(stringify!(thinlto_set_generated_objects_dir));
    entry(cg, save_temps_dir)
}
#[no_mangle]
pub extern "C" fn LLVMOrcExecutionSessionCreateBareJITDylib(
    ES: LLVMOrcExecutionSessionRef,
    Name: *const ::libc::c_char,
) -> LLVMOrcJITDylibRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMOrcExecutionSessionRef,
                    *const ::libc::c_char,
                ) -> LLVMOrcJITDylibRef,
            >(stringify!(LLVMOrcExecutionSessionCreateBareJITDylib).as_bytes())
    }
        .expect(stringify!(LLVMOrcExecutionSessionCreateBareJITDylib));
    entry(ES, Name)
}
#[no_mangle]
pub extern "C" fn LLVMPrintValueToString(Val: LLVMValueRef) -> *mut ::libc::c_char {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> *mut ::libc::c_char,
            >(stringify!(LLVMPrintValueToString).as_bytes())
    }
        .expect(stringify!(LLVMPrintValueToString));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn LLVMGetGEPSourceElementType(GEP: LLVMValueRef) -> LLVMTypeRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMTypeRef,
            >(stringify!(LLVMGetGEPSourceElementType).as_bytes())
    }
        .expect(stringify!(LLVMGetGEPSourceElementType));
    entry(GEP)
}
#[no_mangle]
pub extern "C" fn LLVMGetAttributesAtIndex(
    F: LLVMValueRef,
    Idx: LLVMAttributeIndex,
    Attrs: *mut LLVMAttributeRef,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, LLVMAttributeIndex, *mut LLVMAttributeRef),
            >(stringify!(LLVMGetAttributesAtIndex).as_bytes())
    }
        .expect(stringify!(LLVMGetAttributesAtIndex));
    entry(F, Idx, Attrs)
}
#[no_mangle]
pub extern "C" fn LLVMOrcJITDylibGetDefaultResourceTracker(
    JD: LLVMOrcJITDylibRef,
) -> LLVMOrcResourceTrackerRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMOrcJITDylibRef) -> LLVMOrcResourceTrackerRef,
            >(stringify!(LLVMOrcJITDylibGetDefaultResourceTracker).as_bytes())
    }
        .expect(stringify!(LLVMOrcJITDylibGetDefaultResourceTracker));
    entry(JD)
}
#[no_mangle]
pub extern "C" fn LLVMInstructionSetDebugLoc(Inst: LLVMValueRef, Loc: LLVMMetadataRef) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, LLVMMetadataRef),
            >(stringify!(LLVMInstructionSetDebugLoc).as_bytes())
    }
        .expect(stringify!(LLVMInstructionSetDebugLoc));
    entry(Inst, Loc)
}
#[no_mangle]
pub extern "C" fn LLVMOrcCreateObjectLinkingLayerWithInProcessMemoryManager(
    Result: *mut LLVMOrcObjectLayerRef,
    ES: LLVMOrcExecutionSessionRef,
) -> LLVMErrorRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    *mut LLVMOrcObjectLayerRef,
                    LLVMOrcExecutionSessionRef,
                ) -> LLVMErrorRef,
            >(
                stringify!(LLVMOrcCreateObjectLinkingLayerWithInProcessMemoryManager)
                    .as_bytes(),
            )
    }
        .expect(stringify!(LLVMOrcCreateObjectLinkingLayerWithInProcessMemoryManager));
    entry(Result, ES)
}
#[no_mangle]
pub extern "C" fn LLVMIsACleanupReturnInst(Val: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMIsACleanupReturnInst).as_bytes())
    }
        .expect(stringify!(LLVMIsACleanupReturnInst));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn LLVMOrcExecutionSessionCreateJITDylib(
    ES: LLVMOrcExecutionSessionRef,
    Result_: *mut LLVMOrcJITDylibRef,
    Name: *const ::libc::c_char,
) -> LLVMErrorRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMOrcExecutionSessionRef,
                    *mut LLVMOrcJITDylibRef,
                    *const ::libc::c_char,
                ) -> LLVMErrorRef,
            >(stringify!(LLVMOrcExecutionSessionCreateJITDylib).as_bytes())
    }
        .expect(stringify!(LLVMOrcExecutionSessionCreateJITDylib));
    entry(ES, Result_, Name)
}
#[no_mangle]
pub extern "C" fn LLVMOrcDisposeMaterializationUnit(MU: LLVMOrcMaterializationUnitRef) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMOrcMaterializationUnitRef),
            >(stringify!(LLVMOrcDisposeMaterializationUnit).as_bytes())
    }
        .expect(stringify!(LLVMOrcDisposeMaterializationUnit));
    entry(MU)
}
#[no_mangle]
pub extern "C" fn LLVMOrcIRTransformLayerSetTransform(
    IRTransformLayer: LLVMOrcIRTransformLayerRef,
    TransformFunction: LLVMOrcIRTransformLayerTransformFunction,
    Ctx: *mut ::libc::c_void,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMOrcIRTransformLayerRef,
                    LLVMOrcIRTransformLayerTransformFunction,
                    *mut ::libc::c_void,
                ),
            >(stringify!(LLVMOrcIRTransformLayerSetTransform).as_bytes())
    }
        .expect(stringify!(LLVMOrcIRTransformLayerSetTransform));
    entry(IRTransformLayer, TransformFunction, Ctx)
}
#[no_mangle]
pub extern "C" fn LLVMRemarkEntryGetType(Remark: LLVMRemarkEntryRef) -> LLVMRemarkType {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMRemarkEntryRef) -> LLVMRemarkType,
            >(stringify!(LLVMRemarkEntryGetType).as_bytes())
    }
        .expect(stringify!(LLVMRemarkEntryGetType));
    entry(Remark)
}
#[no_mangle]
pub extern "C" fn LLVMRemarkEntryGetFunctionName(
    Remark: LLVMRemarkEntryRef,
) -> LLVMRemarkStringRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMRemarkEntryRef) -> LLVMRemarkStringRef,
            >(stringify!(LLVMRemarkEntryGetFunctionName).as_bytes())
    }
        .expect(stringify!(LLVMRemarkEntryGetFunctionName));
    entry(Remark)
}
#[no_mangle]
pub extern "C" fn lto_module_is_thinlto(module: lto_module_t) -> lto_bool_t {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(lto_module_t) -> lto_bool_t,
            >(stringify!(lto_module_is_thinlto).as_bytes())
    }
        .expect(stringify!(lto_module_is_thinlto));
    entry(module)
}
#[no_mangle]
pub extern "C" fn LLVMSetVisibility(Global: LLVMValueRef, Viz: LLVMVisibility) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, LLVMVisibility),
            >(stringify!(LLVMSetVisibility).as_bytes())
    }
        .expect(stringify!(LLVMSetVisibility));
    entry(Global, Viz)
}
#[no_mangle]
pub extern "C" fn LLVMDIBuilderGetOrCreateArray(
    Builder: LLVMDIBuilderRef,
    Data: *mut LLVMMetadataRef,
    NumElements: ::libc::size_t,
) -> LLVMMetadataRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMDIBuilderRef,
                    *mut LLVMMetadataRef,
                    ::libc::size_t,
                ) -> LLVMMetadataRef,
            >(stringify!(LLVMDIBuilderGetOrCreateArray).as_bytes())
    }
        .expect(stringify!(LLVMDIBuilderGetOrCreateArray));
    entry(Builder, Data, NumElements)
}
#[no_mangle]
pub extern "C" fn LLVMGetVisibility(Global: LLVMValueRef) -> LLVMVisibility {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMVisibility,
            >(stringify!(LLVMGetVisibility).as_bytes())
    }
        .expect(stringify!(LLVMGetVisibility));
    entry(Global)
}
#[no_mangle]
pub extern "C" fn LLVMRemarkDebugLocGetSourceFilePath(
    DL: LLVMRemarkDebugLocRef,
) -> LLVMRemarkStringRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMRemarkDebugLocRef) -> LLVMRemarkStringRef,
            >(stringify!(LLVMRemarkDebugLocGetSourceFilePath).as_bytes())
    }
        .expect(stringify!(LLVMRemarkDebugLocGetSourceFilePath));
    entry(DL)
}
#[no_mangle]
pub extern "C" fn LLVMDIBuilderCreateSubroutineType(
    Builder: LLVMDIBuilderRef,
    File: LLVMMetadataRef,
    ParameterTypes: *mut LLVMMetadataRef,
    NumParameterTypes: ::libc::c_uint,
    Flags: LLVMDIFlags,
) -> LLVMMetadataRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMDIBuilderRef,
                    LLVMMetadataRef,
                    *mut LLVMMetadataRef,
                    ::libc::c_uint,
                    LLVMDIFlags,
                ) -> LLVMMetadataRef,
            >(stringify!(LLVMDIBuilderCreateSubroutineType).as_bytes())
    }
        .expect(stringify!(LLVMDIBuilderCreateSubroutineType));
    entry(Builder, File, ParameterTypes, NumParameterTypes, Flags)
}
#[no_mangle]
pub extern "C" fn LLVMGetSyncScopeID(
    C: LLVMContextRef,
    Name: *const ::libc::c_char,
    SLen: ::libc::size_t,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMContextRef, *const ::libc::c_char, ::libc::size_t),
            >(stringify!(LLVMGetSyncScopeID).as_bytes())
    }
        .expect(stringify!(LLVMGetSyncScopeID));
    entry(C, Name, SLen)
}
#[no_mangle]
pub extern "C" fn LLVMInitializeSystemZTargetInfo() {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(),
            >(stringify!(LLVMInitializeSystemZTargetInfo).as_bytes())
    }
        .expect(stringify!(LLVMInitializeSystemZTargetInfo));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMIsOpaqueStruct(StructTy: LLVMTypeRef) -> LLVMBool {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMTypeRef) -> LLVMBool,
            >(stringify!(LLVMIsOpaqueStruct).as_bytes())
    }
        .expect(stringify!(LLVMIsOpaqueStruct));
    entry(StructTy)
}
#[no_mangle]
pub extern "C" fn LLVMOrcLLJITGetExecutionSession(
    J: LLVMOrcLLJITRef,
) -> LLVMOrcExecutionSessionRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMOrcLLJITRef) -> LLVMOrcExecutionSessionRef,
            >(stringify!(LLVMOrcLLJITGetExecutionSession).as_bytes())
    }
        .expect(stringify!(LLVMOrcLLJITGetExecutionSession));
    entry(J)
}
#[no_mangle]
pub extern "C" fn LLVMGetMDKindID(
    Name: *const ::libc::c_char,
    SLen: ::libc::c_uint,
) -> ::libc::c_uint {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(*const ::libc::c_char, ::libc::c_uint) -> ::libc::c_uint,
            >(stringify!(LLVMGetMDKindID).as_bytes())
    }
        .expect(stringify!(LLVMGetMDKindID));
    entry(Name, SLen)
}
#[no_mangle]
pub extern "C" fn LLVMGetFirstGlobalAlias(M: LLVMModuleRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMModuleRef) -> LLVMValueRef,
            >(stringify!(LLVMGetFirstGlobalAlias).as_bytes())
    }
        .expect(stringify!(LLVMGetFirstGlobalAlias));
    entry(M)
}
#[no_mangle]
pub extern "C" fn LLVMInitializeRISCVAsmPrinter() {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<extern "C" fn()>(stringify!(LLVMInitializeRISCVAsmPrinter).as_bytes())
    }
        .expect(stringify!(LLVMInitializeRISCVAsmPrinter));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMLinkInMCJIT() {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<extern "C" fn()>(stringify!(LLVMLinkInMCJIT).as_bytes())
    }
        .expect(stringify!(LLVMLinkInMCJIT));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMConstDataArray(
    ElementTy: LLVMTypeRef,
    Data: *const ::libc::c_char,
    SizeInBytes: usize,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMTypeRef, *const ::libc::c_char, usize) -> LLVMValueRef,
            >(stringify!(LLVMConstDataArray).as_bytes())
    }
        .expect(stringify!(LLVMConstDataArray));
    entry(ElementTy, Data, SizeInBytes)
}
#[no_mangle]
pub extern "C" fn LLVMIsAConstantDataVector(Val: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMIsAConstantDataVector).as_bytes())
    }
        .expect(stringify!(LLVMIsAConstantDataVector));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn LLVMDisposeRelocationIterator(RI: LLVMRelocationIteratorRef) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMRelocationIteratorRef),
            >(stringify!(LLVMDisposeRelocationIterator).as_bytes())
    }
        .expect(stringify!(LLVMDisposeRelocationIterator));
    entry(RI)
}
#[no_mangle]
pub extern "C" fn LLVMOrcObjectLayerAddObjectFile(
    ObjLayer: LLVMOrcObjectLayerRef,
    JD: LLVMOrcJITDylibRef,
    ObjBuffer: LLVMMemoryBufferRef,
) -> LLVMErrorRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMOrcObjectLayerRef,
                    LLVMOrcJITDylibRef,
                    LLVMMemoryBufferRef,
                ) -> LLVMErrorRef,
            >(stringify!(LLVMOrcObjectLayerAddObjectFile).as_bytes())
    }
        .expect(stringify!(LLVMOrcObjectLayerAddObjectFile));
    entry(ObjLayer, JD, ObjBuffer)
}
#[no_mangle]
pub extern "C" fn LLVMIsAGlobalIFunc(Val: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMIsAGlobalIFunc).as_bytes())
    }
        .expect(stringify!(LLVMIsAGlobalIFunc));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn LLVMInt32TypeInContext(C: LLVMContextRef) -> LLVMTypeRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMContextRef) -> LLVMTypeRef,
            >(stringify!(LLVMInt32TypeInContext).as_bytes())
    }
        .expect(stringify!(LLVMInt32TypeInContext));
    entry(C)
}
#[no_mangle]
pub extern "C" fn LLVMABIAlignmentOfType(
    TD: LLVMTargetDataRef,
    Ty: LLVMTypeRef,
) -> ::libc::c_uint {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMTargetDataRef, LLVMTypeRef) -> ::libc::c_uint,
            >(stringify!(LLVMABIAlignmentOfType).as_bytes())
    }
        .expect(stringify!(LLVMABIAlignmentOfType));
    entry(TD, Ty)
}
#[no_mangle]
pub extern "C" fn LLVMTypeOf(Val: LLVMValueRef) -> LLVMTypeRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMTypeRef,
            >(stringify!(LLVMTypeOf).as_bytes())
    }
        .expect(stringify!(LLVMTypeOf));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn LLVMGetConstantPtrAuthPointer(PtrAuth: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMGetConstantPtrAuthPointer).as_bytes())
    }
        .expect(stringify!(LLVMGetConstantPtrAuthPointer));
    entry(PtrAuth)
}
#[no_mangle]
pub extern "C" fn LLVMGetGlobalValueAddress(
    EE: LLVMExecutionEngineRef,
    Name: *const ::libc::c_char,
) -> u64 {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMExecutionEngineRef, *const ::libc::c_char) -> u64,
            >(stringify!(LLVMGetGlobalValueAddress).as_bytes())
    }
        .expect(stringify!(LLVMGetGlobalValueAddress));
    entry(EE, Name)
}
#[no_mangle]
pub extern "C" fn LLVMConstNSWMul(
    LHSConstant: LLVMValueRef,
    RHSConstant: LLVMValueRef,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMConstNSWMul).as_bytes())
    }
        .expect(stringify!(LLVMConstNSWMul));
    entry(LHSConstant, RHSConstant)
}
#[no_mangle]
pub extern "C" fn LLVMPrintTypeToString(Val: LLVMTypeRef) -> *mut ::libc::c_char {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMTypeRef) -> *mut ::libc::c_char,
            >(stringify!(LLVMPrintTypeToString).as_bytes())
    }
        .expect(stringify!(LLVMPrintTypeToString));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn llvm_blake3_hasher_finalize_seek(
    hasher: *mut llvm_blake3_hasher,
    seek: u64,
    out: *mut u8,
    out_len: usize,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(*mut llvm_blake3_hasher, u64, *mut u8, usize),
            >(stringify!(llvm_blake3_hasher_finalize_seek).as_bytes())
    }
        .expect(stringify!(llvm_blake3_hasher_finalize_seek));
    entry(hasher, seek, out, out_len)
}
#[no_mangle]
pub extern "C" fn LLVMBuildFPTrunc(
    arg1: LLVMBuilderRef,
    Val: LLVMValueRef,
    DestTy: LLVMTypeRef,
    Name: *const ::libc::c_char,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMBuilderRef,
                    LLVMValueRef,
                    LLVMTypeRef,
                    *const ::libc::c_char,
                ) -> LLVMValueRef,
            >(stringify!(LLVMBuildFPTrunc).as_bytes())
    }
        .expect(stringify!(LLVMBuildFPTrunc));
    entry(arg1, Val, DestTy, Name)
}
#[no_mangle]
pub extern "C" fn LLVMInitializeLanaiAsmPrinter() {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<extern "C" fn()>(stringify!(LLVMInitializeLanaiAsmPrinter).as_bytes())
    }
        .expect(stringify!(LLVMInitializeLanaiAsmPrinter));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMMachOUniversalBinaryCopyObjectForArch(
    BR: LLVMBinaryRef,
    Arch: *const ::libc::c_char,
    ArchLen: ::libc::size_t,
    ErrorMessage: *mut *mut ::libc::c_char,
) -> LLVMBinaryRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMBinaryRef,
                    *const ::libc::c_char,
                    ::libc::size_t,
                    *mut *mut ::libc::c_char,
                ) -> LLVMBinaryRef,
            >(stringify!(LLVMMachOUniversalBinaryCopyObjectForArch).as_bytes())
    }
        .expect(stringify!(LLVMMachOUniversalBinaryCopyObjectForArch));
    entry(BR, Arch, ArchLen, ErrorMessage)
}
#[no_mangle]
pub extern "C" fn LLVMAddAnalysisPasses(
    T: LLVMTargetMachineRef,
    PM: LLVMPassManagerRef,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMTargetMachineRef, LLVMPassManagerRef),
            >(stringify!(LLVMAddAnalysisPasses).as_bytes())
    }
        .expect(stringify!(LLVMAddAnalysisPasses));
    entry(T, PM)
}
#[no_mangle]
pub extern "C" fn LLVMOrcJITDylibDefine(
    JD: LLVMOrcJITDylibRef,
    MU: LLVMOrcMaterializationUnitRef,
) -> LLVMErrorRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMOrcJITDylibRef,
                    LLVMOrcMaterializationUnitRef,
                ) -> LLVMErrorRef,
            >(stringify!(LLVMOrcJITDylibDefine).as_bytes())
    }
        .expect(stringify!(LLVMOrcJITDylibDefine));
    entry(JD, MU)
}
#[no_mangle]
pub extern "C" fn LLVMDisasmDispose(DC: LLVMDisasmContextRef) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMDisasmContextRef),
            >(stringify!(LLVMDisasmDispose).as_bytes())
    }
        .expect(stringify!(LLVMDisasmDispose));
    entry(DC)
}
#[no_mangle]
pub extern "C" fn LLVMSetFunctionCallConv(Fn: LLVMValueRef, CC: ::libc::c_uint) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, ::libc::c_uint),
            >(stringify!(LLVMSetFunctionCallConv).as_bytes())
    }
        .expect(stringify!(LLVMSetFunctionCallConv));
    entry(Fn, CC)
}
#[no_mangle]
pub extern "C" fn LLVMGetIncomingValue(
    PhiNode: LLVMValueRef,
    Index: ::libc::c_uint,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, ::libc::c_uint) -> LLVMValueRef,
            >(stringify!(LLVMGetIncomingValue).as_bytes())
    }
        .expect(stringify!(LLVMGetIncomingValue));
    entry(PhiNode, Index)
}
#[no_mangle]
pub extern "C" fn LLVMParseBitcode2(
    MemBuf: LLVMMemoryBufferRef,
    OutModule: *mut LLVMModuleRef,
) -> LLVMBool {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMMemoryBufferRef, *mut LLVMModuleRef) -> LLVMBool,
            >(stringify!(LLVMParseBitcode2).as_bytes())
    }
        .expect(stringify!(LLVMParseBitcode2));
    entry(MemBuf, OutModule)
}
#[no_mangle]
pub extern "C" fn LLVMIsAGlobalVariable(Val: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMIsAGlobalVariable).as_bytes())
    }
        .expect(stringify!(LLVMIsAGlobalVariable));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn LLVMViewFunctionCFG(Fn: LLVMValueRef) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef),
            >(stringify!(LLVMViewFunctionCFG).as_bytes())
    }
        .expect(stringify!(LLVMViewFunctionCFG));
    entry(Fn)
}
#[no_mangle]
pub extern "C" fn LLVMGetNextGlobalIFunc(IFunc: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMGetNextGlobalIFunc).as_bytes())
    }
        .expect(stringify!(LLVMGetNextGlobalIFunc));
    entry(IFunc)
}
#[no_mangle]
pub extern "C" fn LLVMCountIncoming(PhiNode: LLVMValueRef) -> ::libc::c_uint {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> ::libc::c_uint,
            >(stringify!(LLVMCountIncoming).as_bytes())
    }
        .expect(stringify!(LLVMCountIncoming));
    entry(PhiNode)
}
#[no_mangle]
pub extern "C" fn LLVMGetOperandUse(
    Val: LLVMValueRef,
    Index: ::libc::c_uint,
) -> LLVMUseRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, ::libc::c_uint) -> LLVMUseRef,
            >(stringify!(LLVMGetOperandUse).as_bytes())
    }
        .expect(stringify!(LLVMGetOperandUse));
    entry(Val, Index)
}
#[no_mangle]
pub extern "C" fn LLVMIsLiteralStruct(StructTy: LLVMTypeRef) -> LLVMBool {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMTypeRef) -> LLVMBool,
            >(stringify!(LLVMIsLiteralStruct).as_bytes())
    }
        .expect(stringify!(LLVMIsLiteralStruct));
    entry(StructTy)
}
#[no_mangle]
pub extern "C" fn LLVMGetNumArgOperands(Instr: LLVMValueRef) -> ::libc::c_uint {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> ::libc::c_uint,
            >(stringify!(LLVMGetNumArgOperands).as_bytes())
    }
        .expect(stringify!(LLVMGetNumArgOperands));
    entry(Instr)
}
#[no_mangle]
pub extern "C" fn LLVMGetAlignment(V: LLVMValueRef) -> ::libc::c_uint {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> ::libc::c_uint,
            >(stringify!(LLVMGetAlignment).as_bytes())
    }
        .expect(stringify!(LLVMGetAlignment));
    entry(V)
}
#[no_mangle]
pub extern "C" fn LLVMCreateJITCompilerForModule(
    OutJIT: *mut LLVMExecutionEngineRef,
    M: LLVMModuleRef,
    OptLevel: ::libc::c_uint,
    OutError: *mut *mut ::libc::c_char,
) -> LLVMBool {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    *mut LLVMExecutionEngineRef,
                    LLVMModuleRef,
                    ::libc::c_uint,
                    *mut *mut ::libc::c_char,
                ) -> LLVMBool,
            >(stringify!(LLVMCreateJITCompilerForModule).as_bytes())
    }
        .expect(stringify!(LLVMCreateJITCompilerForModule));
    entry(OutJIT, M, OptLevel, OutError)
}
#[no_mangle]
pub extern "C" fn LLVMOrcJITDylibClear(JD: LLVMOrcJITDylibRef) -> LLVMErrorRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMOrcJITDylibRef) -> LLVMErrorRef,
            >(stringify!(LLVMOrcJITDylibClear).as_bytes())
    }
        .expect(stringify!(LLVMOrcJITDylibClear));
    entry(JD)
}
#[no_mangle]
pub extern "C" fn LLVMBuildBinOp(
    B: LLVMBuilderRef,
    Op: LLVMOpcode,
    LHS: LLVMValueRef,
    RHS: LLVMValueRef,
    Name: *const ::libc::c_char,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMBuilderRef,
                    LLVMOpcode,
                    LLVMValueRef,
                    LLVMValueRef,
                    *const ::libc::c_char,
                ) -> LLVMValueRef,
            >(stringify!(LLVMBuildBinOp).as_bytes())
    }
        .expect(stringify!(LLVMBuildBinOp));
    entry(B, Op, LHS, RHS, Name)
}
#[no_mangle]
pub extern "C" fn LLVMIsACatchPadInst(Val: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMIsACatchPadInst).as_bytes())
    }
        .expect(stringify!(LLVMIsACatchPadInst));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn thinlto_module_get_num_object_files(
    cg: thinlto_code_gen_t,
) -> ::libc::c_uint {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(thinlto_code_gen_t) -> ::libc::c_uint,
            >(stringify!(thinlto_module_get_num_object_files).as_bytes())
    }
        .expect(stringify!(thinlto_module_get_num_object_files));
    entry(cg)
}
#[no_mangle]
pub extern "C" fn LLVMPositionBuilderAtEnd(
    Builder: LLVMBuilderRef,
    Block: LLVMBasicBlockRef,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMBuilderRef, LLVMBasicBlockRef),
            >(stringify!(LLVMPositionBuilderAtEnd).as_bytes())
    }
        .expect(stringify!(LLVMPositionBuilderAtEnd));
    entry(Builder, Block)
}
#[no_mangle]
pub extern "C" fn LLVMCreateTypeAttribute(
    C: LLVMContextRef,
    KindID: ::libc::c_uint,
    type_ref: LLVMTypeRef,
) -> LLVMAttributeRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMContextRef,
                    ::libc::c_uint,
                    LLVMTypeRef,
                ) -> LLVMAttributeRef,
            >(stringify!(LLVMCreateTypeAttribute).as_bytes())
    }
        .expect(stringify!(LLVMCreateTypeAttribute));
    entry(C, KindID, type_ref)
}
#[no_mangle]
pub extern "C" fn LLVMSetDLLStorageClass(
    Global: LLVMValueRef,
    Class: LLVMDLLStorageClass,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, LLVMDLLStorageClass),
            >(stringify!(LLVMSetDLLStorageClass).as_bytes())
    }
        .expect(stringify!(LLVMSetDLLStorageClass));
    entry(Global, Class)
}
#[no_mangle]
pub extern "C" fn LLVMDIBuilderInsertLabelBefore(
    Builder: LLVMDIBuilderRef,
    LabelInfo: LLVMMetadataRef,
    Location: LLVMMetadataRef,
    InsertBefore: LLVMValueRef,
) -> LLVMDbgRecordRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMDIBuilderRef,
                    LLVMMetadataRef,
                    LLVMMetadataRef,
                    LLVMValueRef,
                ) -> LLVMDbgRecordRef,
            >(stringify!(LLVMDIBuilderInsertLabelBefore).as_bytes())
    }
        .expect(stringify!(LLVMDIBuilderInsertLabelBefore));
    entry(Builder, LabelInfo, Location, InsertBefore)
}
#[no_mangle]
pub extern "C" fn LLVMOrcDisposeLazyCallThroughManager(
    LCTM: LLVMOrcLazyCallThroughManagerRef,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMOrcLazyCallThroughManagerRef),
            >(stringify!(LLVMOrcDisposeLazyCallThroughManager).as_bytes())
    }
        .expect(stringify!(LLVMOrcDisposeLazyCallThroughManager));
    entry(LCTM)
}
#[no_mangle]
pub extern "C" fn LLVMDisposeTargetData(TD: LLVMTargetDataRef) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMTargetDataRef),
            >(stringify!(LLVMDisposeTargetData).as_bytes())
    }
        .expect(stringify!(LLVMDisposeTargetData));
    entry(TD)
}
#[no_mangle]
pub extern "C" fn LLVMOrcCreateLocalIndirectStubsManager(
    TargetTriple: *const ::libc::c_char,
) -> LLVMOrcIndirectStubsManagerRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(*const ::libc::c_char) -> LLVMOrcIndirectStubsManagerRef,
            >(stringify!(LLVMOrcCreateLocalIndirectStubsManager).as_bytes())
    }
        .expect(stringify!(LLVMOrcCreateLocalIndirectStubsManager));
    entry(TargetTriple)
}
#[no_mangle]
pub extern "C" fn LLVMABISizeOfType(
    TD: LLVMTargetDataRef,
    Ty: LLVMTypeRef,
) -> ::libc::c_ulonglong {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMTargetDataRef, LLVMTypeRef) -> ::libc::c_ulonglong,
            >(stringify!(LLVMABISizeOfType).as_bytes())
    }
        .expect(stringify!(LLVMABISizeOfType));
    entry(TD, Ty)
}
#[no_mangle]
pub extern "C" fn LLVMNormalizeTargetTriple(
    triple: *const ::libc::c_char,
) -> *mut ::libc::c_char {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(*const ::libc::c_char) -> *mut ::libc::c_char,
            >(stringify!(LLVMNormalizeTargetTriple).as_bytes())
    }
        .expect(stringify!(LLVMNormalizeTargetTriple));
    entry(triple)
}
#[no_mangle]
pub extern "C" fn LLVMGetPreviousParam(Arg: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMGetPreviousParam).as_bytes())
    }
        .expect(stringify!(LLVMGetPreviousParam));
    entry(Arg)
}
#[no_mangle]
pub extern "C" fn LLVMRunFunction(
    EE: LLVMExecutionEngineRef,
    F: LLVMValueRef,
    NumArgs: ::libc::c_uint,
    Args: *mut LLVMGenericValueRef,
) -> LLVMGenericValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMExecutionEngineRef,
                    LLVMValueRef,
                    ::libc::c_uint,
                    *mut LLVMGenericValueRef,
                ) -> LLVMGenericValueRef,
            >(stringify!(LLVMRunFunction).as_bytes())
    }
        .expect(stringify!(LLVMRunFunction));
    entry(EE, F, NumArgs, Args)
}
#[no_mangle]
pub extern "C" fn LLVMBuildInsertElement(
    arg1: LLVMBuilderRef,
    VecVal: LLVMValueRef,
    EltVal: LLVMValueRef,
    Index: LLVMValueRef,
    Name: *const ::libc::c_char,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMBuilderRef,
                    LLVMValueRef,
                    LLVMValueRef,
                    LLVMValueRef,
                    *const ::libc::c_char,
                ) -> LLVMValueRef,
            >(stringify!(LLVMBuildInsertElement).as_bytes())
    }
        .expect(stringify!(LLVMBuildInsertElement));
    entry(arg1, VecVal, EltVal, Index, Name)
}
#[no_mangle]
pub extern "C" fn LLVMVerifyFunction(
    Fn: LLVMValueRef,
    Action: LLVMVerifierFailureAction,
) -> LLVMBool {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, LLVMVerifierFailureAction) -> LLVMBool,
            >(stringify!(LLVMVerifyFunction).as_bytes())
    }
        .expect(stringify!(LLVMVerifyFunction));
    entry(Fn, Action)
}
#[no_mangle]
pub extern "C" fn LLVMOrcJITDylibAddGenerator(
    JD: LLVMOrcJITDylibRef,
    DG: LLVMOrcDefinitionGeneratorRef,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMOrcJITDylibRef, LLVMOrcDefinitionGeneratorRef),
            >(stringify!(LLVMOrcJITDylibAddGenerator).as_bytes())
    }
        .expect(stringify!(LLVMOrcJITDylibAddGenerator));
    entry(JD, DG)
}
#[no_mangle]
pub extern "C" fn LLVMTargetMachineOptionsSetCPU(
    Options: LLVMTargetMachineOptionsRef,
    CPU: *const ::libc::c_char,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMTargetMachineOptionsRef, *const ::libc::c_char),
            >(stringify!(LLVMTargetMachineOptionsSetCPU).as_bytes())
    }
        .expect(stringify!(LLVMTargetMachineOptionsSetCPU));
    entry(Options, CPU)
}
#[no_mangle]
pub extern "C" fn LLVMConstTrunc(
    ConstantVal: LLVMValueRef,
    ToType: LLVMTypeRef,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, LLVMTypeRef) -> LLVMValueRef,
            >(stringify!(LLVMConstTrunc).as_bytes())
    }
        .expect(stringify!(LLVMConstTrunc));
    entry(ConstantVal, ToType)
}
#[no_mangle]
pub extern "C" fn LLVMPointerType(
    ElementType: LLVMTypeRef,
    AddressSpace: ::libc::c_uint,
) -> LLVMTypeRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMTypeRef, ::libc::c_uint) -> LLVMTypeRef,
            >(stringify!(LLVMPointerType).as_bytes())
    }
        .expect(stringify!(LLVMPointerType));
    entry(ElementType, AddressSpace)
}
#[no_mangle]
pub extern "C" fn LLVMGetFirstUse(Val: LLVMValueRef) -> LLVMUseRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMUseRef,
            >(stringify!(LLVMGetFirstUse).as_bytes())
    }
        .expect(stringify!(LLVMGetFirstUse));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn LLVMDIBuilderCreateClassType(
    Builder: LLVMDIBuilderRef,
    Scope: LLVMMetadataRef,
    Name: *const ::libc::c_char,
    NameLen: ::libc::size_t,
    File: LLVMMetadataRef,
    LineNumber: ::libc::c_uint,
    SizeInBits: u64,
    AlignInBits: u32,
    OffsetInBits: u64,
    Flags: LLVMDIFlags,
    DerivedFrom: LLVMMetadataRef,
    Elements: *mut LLVMMetadataRef,
    NumElements: ::libc::c_uint,
    VTableHolder: LLVMMetadataRef,
    TemplateParamsNode: LLVMMetadataRef,
    UniqueIdentifier: *const ::libc::c_char,
    UniqueIdentifierLen: ::libc::size_t,
) -> LLVMMetadataRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMDIBuilderRef,
                    LLVMMetadataRef,
                    *const ::libc::c_char,
                    ::libc::size_t,
                    LLVMMetadataRef,
                    ::libc::c_uint,
                    u64,
                    u32,
                    u64,
                    LLVMDIFlags,
                    LLVMMetadataRef,
                    *mut LLVMMetadataRef,
                    ::libc::c_uint,
                    LLVMMetadataRef,
                    LLVMMetadataRef,
                    *const ::libc::c_char,
                    ::libc::size_t,
                ) -> LLVMMetadataRef,
            >(stringify!(LLVMDIBuilderCreateClassType).as_bytes())
    }
        .expect(stringify!(LLVMDIBuilderCreateClassType));
    entry(
        Builder,
        Scope,
        Name,
        NameLen,
        File,
        LineNumber,
        SizeInBits,
        AlignInBits,
        OffsetInBits,
        Flags,
        DerivedFrom,
        Elements,
        NumElements,
        VTableHolder,
        TemplateParamsNode,
        UniqueIdentifier,
        UniqueIdentifierLen,
    )
}
#[no_mangle]
pub extern "C" fn LLVMBuildFSub(
    arg1: LLVMBuilderRef,
    LHS: LLVMValueRef,
    RHS: LLVMValueRef,
    Name: *const ::libc::c_char,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMBuilderRef,
                    LLVMValueRef,
                    LLVMValueRef,
                    *const ::libc::c_char,
                ) -> LLVMValueRef,
            >(stringify!(LLVMBuildFSub).as_bytes())
    }
        .expect(stringify!(LLVMBuildFSub));
    entry(arg1, LHS, RHS, Name)
}
#[no_mangle]
pub extern "C" fn LLVMIsAUnaryInstruction(Val: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMIsAUnaryInstruction).as_bytes())
    }
        .expect(stringify!(LLVMIsAUnaryInstruction));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn LLVMDIBuilderCreateReferenceType(
    Builder: LLVMDIBuilderRef,
    Tag: ::libc::c_uint,
    Type: LLVMMetadataRef,
) -> LLVMMetadataRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMDIBuilderRef,
                    ::libc::c_uint,
                    LLVMMetadataRef,
                ) -> LLVMMetadataRef,
            >(stringify!(LLVMDIBuilderCreateReferenceType).as_bytes())
    }
        .expect(stringify!(LLVMDIBuilderCreateReferenceType));
    entry(Builder, Tag, Type)
}
#[no_mangle]
pub extern "C" fn lto_module_get_asm_undef_symbol_name(
    mod_: lto_module_t,
    index: ::libc::c_uint,
) -> *const ::libc::c_char {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(lto_module_t, ::libc::c_uint) -> *const ::libc::c_char,
            >(stringify!(lto_module_get_asm_undef_symbol_name).as_bytes())
    }
        .expect(stringify!(lto_module_get_asm_undef_symbol_name));
    entry(mod_, index)
}
#[no_mangle]
pub extern "C" fn LLVMOrcExecutionSessionGetJITDylibByName(
    ES: LLVMOrcExecutionSessionRef,
    Name: *const ::libc::c_char,
) -> LLVMOrcJITDylibRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMOrcExecutionSessionRef,
                    *const ::libc::c_char,
                ) -> LLVMOrcJITDylibRef,
            >(stringify!(LLVMOrcExecutionSessionGetJITDylibByName).as_bytes())
    }
        .expect(stringify!(LLVMOrcExecutionSessionGetJITDylibByName));
    entry(ES, Name)
}
#[no_mangle]
pub extern "C" fn LLVMGetExecutionEngineTargetData(
    EE: LLVMExecutionEngineRef,
) -> LLVMTargetDataRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMExecutionEngineRef) -> LLVMTargetDataRef,
            >(stringify!(LLVMGetExecutionEngineTargetData).as_bytes())
    }
        .expect(stringify!(LLVMGetExecutionEngineTargetData));
    entry(EE)
}
#[no_mangle]
pub extern "C" fn LLVMRemarkArgGetKey(Arg: LLVMRemarkArgRef) -> LLVMRemarkStringRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMRemarkArgRef) -> LLVMRemarkStringRef,
            >(stringify!(LLVMRemarkArgGetKey).as_bytes())
    }
        .expect(stringify!(LLVMRemarkArgGetKey));
    entry(Arg)
}
#[no_mangle]
pub extern "C" fn LLVMAppendBasicBlockInContext(
    C: LLVMContextRef,
    Fn: LLVMValueRef,
    Name: *const ::libc::c_char,
) -> LLVMBasicBlockRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMContextRef,
                    LLVMValueRef,
                    *const ::libc::c_char,
                ) -> LLVMBasicBlockRef,
            >(stringify!(LLVMAppendBasicBlockInContext).as_bytes())
    }
        .expect(stringify!(LLVMAppendBasicBlockInContext));
    entry(C, Fn, Name)
}
#[no_mangle]
pub extern "C" fn LLVMInitializeAArch64AsmParser() {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(),
            >(stringify!(LLVMInitializeAArch64AsmParser).as_bytes())
    }
        .expect(stringify!(LLVMInitializeAArch64AsmParser));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMTargetMachineOptionsSetRelocMode(
    Options: LLVMTargetMachineOptionsRef,
    Reloc: LLVMRelocMode,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMTargetMachineOptionsRef, LLVMRelocMode),
            >(stringify!(LLVMTargetMachineOptionsSetRelocMode).as_bytes())
    }
        .expect(stringify!(LLVMTargetMachineOptionsSetRelocMode));
    entry(Options, Reloc)
}
#[no_mangle]
pub extern "C" fn LLVMGetNextGlobalAlias(GA: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMGetNextGlobalAlias).as_bytes())
    }
        .expect(stringify!(LLVMGetNextGlobalAlias));
    entry(GA)
}
#[no_mangle]
pub extern "C" fn LLVMGlobalGetValueType(Global: LLVMValueRef) -> LLVMTypeRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMTypeRef,
            >(stringify!(LLVMGlobalGetValueType).as_bytes())
    }
        .expect(stringify!(LLVMGlobalGetValueType));
    entry(Global)
}
#[no_mangle]
pub extern "C" fn LLVMRecompileAndRelinkFunction(
    EE: LLVMExecutionEngineRef,
    Fn: LLVMValueRef,
) -> *mut ::libc::c_void {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMExecutionEngineRef,
                    LLVMValueRef,
                ) -> *mut ::libc::c_void,
            >(stringify!(LLVMRecompileAndRelinkFunction).as_bytes())
    }
        .expect(stringify!(LLVMRecompileAndRelinkFunction));
    entry(EE, Fn)
}
#[no_mangle]
pub extern "C" fn lto_codegen_set_diagnostic_handler(
    arg1: lto_code_gen_t,
    arg2: lto_diagnostic_handler_t,
    arg3: *mut ::libc::c_void,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    lto_code_gen_t,
                    lto_diagnostic_handler_t,
                    *mut ::libc::c_void,
                ),
            >(stringify!(lto_codegen_set_diagnostic_handler).as_bytes())
    }
        .expect(stringify!(lto_codegen_set_diagnostic_handler));
    entry(arg1, arg2, arg3)
}
#[no_mangle]
pub extern "C" fn LLVMOrcLLJITGetDataLayoutStr(
    J: LLVMOrcLLJITRef,
) -> *const ::libc::c_char {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMOrcLLJITRef) -> *const ::libc::c_char,
            >(stringify!(LLVMOrcLLJITGetDataLayoutStr).as_bytes())
    }
        .expect(stringify!(LLVMOrcLLJITGetDataLayoutStr));
    entry(J)
}
#[no_mangle]
pub extern "C" fn LLVMOrcAbsoluteSymbols(
    Syms: LLVMOrcCSymbolMapPairs,
    NumPairs: usize,
) -> LLVMOrcMaterializationUnitRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMOrcCSymbolMapPairs,
                    usize,
                ) -> LLVMOrcMaterializationUnitRef,
            >(stringify!(LLVMOrcAbsoluteSymbols).as_bytes())
    }
        .expect(stringify!(LLVMOrcAbsoluteSymbols));
    entry(Syms, NumPairs)
}
#[no_mangle]
pub extern "C" fn LLVMGetLastDbgRecord(Inst: LLVMValueRef) -> LLVMDbgRecordRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMDbgRecordRef,
            >(stringify!(LLVMGetLastDbgRecord).as_bytes())
    }
        .expect(stringify!(LLVMGetLastDbgRecord));
    entry(Inst)
}
#[no_mangle]
pub extern "C" fn LLVMDIVariableGetFile(Var: LLVMMetadataRef) -> LLVMMetadataRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMMetadataRef) -> LLVMMetadataRef,
            >(stringify!(LLVMDIVariableGetFile).as_bytes())
    }
        .expect(stringify!(LLVMDIVariableGetFile));
    entry(Var)
}
#[no_mangle]
pub extern "C" fn LLVMArrayType2(
    ElementType: LLVMTypeRef,
    ElementCount: u64,
) -> LLVMTypeRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMTypeRef, u64) -> LLVMTypeRef,
            >(stringify!(LLVMArrayType2).as_bytes())
    }
        .expect(stringify!(LLVMArrayType2));
    entry(ElementType, ElementCount)
}
#[no_mangle]
pub extern "C" fn LLVMRemarkParserDispose(Parser: LLVMRemarkParserRef) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMRemarkParserRef),
            >(stringify!(LLVMRemarkParserDispose).as_bytes())
    }
        .expect(stringify!(LLVMRemarkParserDispose));
    entry(Parser)
}
#[no_mangle]
pub extern "C" fn LLVMInitializeAMDGPUTargetInfo() {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(),
            >(stringify!(LLVMInitializeAMDGPUTargetInfo).as_bytes())
    }
        .expect(stringify!(LLVMInitializeAMDGPUTargetInfo));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMGetTargetMachineFeatureString(
    T: LLVMTargetMachineRef,
) -> *mut ::libc::c_char {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMTargetMachineRef) -> *mut ::libc::c_char,
            >(stringify!(LLVMGetTargetMachineFeatureString).as_bytes())
    }
        .expect(stringify!(LLVMGetTargetMachineFeatureString));
    entry(T)
}
#[no_mangle]
pub extern "C" fn lto_input_dispose(input: lto_input_t) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<extern "C" fn(lto_input_t)>(stringify!(lto_input_dispose).as_bytes())
    }
        .expect(stringify!(lto_input_dispose));
    entry(input)
}
#[no_mangle]
pub extern "C" fn LLVMInitializePowerPCTargetMC() {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<extern "C" fn()>(stringify!(LLVMInitializePowerPCTargetMC).as_bytes())
    }
        .expect(stringify!(LLVMInitializePowerPCTargetMC));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMDisposeDIBuilder(Builder: LLVMDIBuilderRef) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMDIBuilderRef),
            >(stringify!(LLVMDisposeDIBuilder).as_bytes())
    }
        .expect(stringify!(LLVMDisposeDIBuilder));
    entry(Builder)
}
#[no_mangle]
pub extern "C" fn LLVMPPCFP128Type() -> LLVMTypeRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn() -> LLVMTypeRef,
            >(stringify!(LLVMPPCFP128Type).as_bytes())
    }
        .expect(stringify!(LLVMPPCFP128Type));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMDIBuilderInsertLabelAtEnd(
    Builder: LLVMDIBuilderRef,
    LabelInfo: LLVMMetadataRef,
    Location: LLVMMetadataRef,
    InsertAtEnd: LLVMBasicBlockRef,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMDIBuilderRef,
                    LLVMMetadataRef,
                    LLVMMetadataRef,
                    LLVMBasicBlockRef,
                ),
            >(stringify!(LLVMDIBuilderInsertLabelAtEnd).as_bytes())
    }
        .expect(stringify!(LLVMDIBuilderInsertLabelAtEnd));
    entry(Builder, LabelInfo, Location, InsertAtEnd)
}
#[no_mangle]
pub extern "C" fn LLVMGetHostCPUName() -> *mut ::libc::c_char {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn() -> *mut ::libc::c_char,
            >(stringify!(LLVMGetHostCPUName).as_bytes())
    }
        .expect(stringify!(LLVMGetHostCPUName));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMPointerTypeIsOpaque(Ty: LLVMTypeRef) -> LLVMBool {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMTypeRef) -> LLVMBool,
            >(stringify!(LLVMPointerTypeIsOpaque).as_bytes())
    }
        .expect(stringify!(LLVMPointerTypeIsOpaque));
    entry(Ty)
}
#[no_mangle]
pub extern "C" fn LLVMGetValueName(Val: LLVMValueRef) -> *const ::libc::c_char {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> *const ::libc::c_char,
            >(stringify!(LLVMGetValueName).as_bytes())
    }
        .expect(stringify!(LLVMGetValueName));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn LLVMGetNamedMetadata(
    M: LLVMModuleRef,
    Name: *const ::libc::c_char,
    NameLen: ::libc::size_t,
) -> LLVMNamedMDNodeRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMModuleRef,
                    *const ::libc::c_char,
                    ::libc::size_t,
                ) -> LLVMNamedMDNodeRef,
            >(stringify!(LLVMGetNamedMetadata).as_bytes())
    }
        .expect(stringify!(LLVMGetNamedMetadata));
    entry(M, Name, NameLen)
}
#[no_mangle]
pub extern "C" fn LLVMBuildFMul(
    arg1: LLVMBuilderRef,
    LHS: LLVMValueRef,
    RHS: LLVMValueRef,
    Name: *const ::libc::c_char,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMBuilderRef,
                    LLVMValueRef,
                    LLVMValueRef,
                    *const ::libc::c_char,
                ) -> LLVMValueRef,
            >(stringify!(LLVMBuildFMul).as_bytes())
    }
        .expect(stringify!(LLVMBuildFMul));
    entry(arg1, LHS, RHS, Name)
}
#[no_mangle]
pub extern "C" fn lto_module_create_from_memory(
    mem: *const ::libc::c_void,
    length: ::libc::size_t,
) -> lto_module_t {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(*const ::libc::c_void, ::libc::size_t) -> lto_module_t,
            >(stringify!(lto_module_create_from_memory).as_bytes())
    }
        .expect(stringify!(lto_module_create_from_memory));
    entry(mem, length)
}
#[no_mangle]
pub extern "C" fn LLVMIsFunctionVarArg(FunctionTy: LLVMTypeRef) -> LLVMBool {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMTypeRef) -> LLVMBool,
            >(stringify!(LLVMIsFunctionVarArg).as_bytes())
    }
        .expect(stringify!(LLVMIsFunctionVarArg));
    entry(FunctionTy)
}
#[no_mangle]
pub extern "C" fn LLVMGetInlineAsmHasSideEffects(
    InlineAsmVal: LLVMValueRef,
) -> LLVMBool {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMBool,
            >(stringify!(LLVMGetInlineAsmHasSideEffects).as_bytes())
    }
        .expect(stringify!(LLVMGetInlineAsmHasSideEffects));
    entry(InlineAsmVal)
}
#[no_mangle]
pub extern "C" fn LLVMGetBasicBlockParent(BB: LLVMBasicBlockRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMBasicBlockRef) -> LLVMValueRef,
            >(stringify!(LLVMGetBasicBlockParent).as_bytes())
    }
        .expect(stringify!(LLVMGetBasicBlockParent));
    entry(BB)
}
#[no_mangle]
pub extern "C" fn LLVMBuildNSWSub(
    arg1: LLVMBuilderRef,
    LHS: LLVMValueRef,
    RHS: LLVMValueRef,
    Name: *const ::libc::c_char,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMBuilderRef,
                    LLVMValueRef,
                    LLVMValueRef,
                    *const ::libc::c_char,
                ) -> LLVMValueRef,
            >(stringify!(LLVMBuildNSWSub).as_bytes())
    }
        .expect(stringify!(LLVMBuildNSWSub));
    entry(arg1, LHS, RHS, Name)
}
#[no_mangle]
pub extern "C" fn LLVMBuildNSWMul(
    arg1: LLVMBuilderRef,
    LHS: LLVMValueRef,
    RHS: LLVMValueRef,
    Name: *const ::libc::c_char,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMBuilderRef,
                    LLVMValueRef,
                    LLVMValueRef,
                    *const ::libc::c_char,
                ) -> LLVMValueRef,
            >(stringify!(LLVMBuildNSWMul).as_bytes())
    }
        .expect(stringify!(LLVMBuildNSWMul));
    entry(arg1, LHS, RHS, Name)
}
#[no_mangle]
pub extern "C" fn LLVMDIBuilderCreateStructType(
    Builder: LLVMDIBuilderRef,
    Scope: LLVMMetadataRef,
    Name: *const ::libc::c_char,
    NameLen: ::libc::size_t,
    File: LLVMMetadataRef,
    LineNumber: ::libc::c_uint,
    SizeInBits: u64,
    AlignInBits: u32,
    Flags: LLVMDIFlags,
    DerivedFrom: LLVMMetadataRef,
    Elements: *mut LLVMMetadataRef,
    NumElements: ::libc::c_uint,
    RunTimeLang: ::libc::c_uint,
    VTableHolder: LLVMMetadataRef,
    UniqueId: *const ::libc::c_char,
    UniqueIdLen: ::libc::size_t,
) -> LLVMMetadataRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMDIBuilderRef,
                    LLVMMetadataRef,
                    *const ::libc::c_char,
                    ::libc::size_t,
                    LLVMMetadataRef,
                    ::libc::c_uint,
                    u64,
                    u32,
                    LLVMDIFlags,
                    LLVMMetadataRef,
                    *mut LLVMMetadataRef,
                    ::libc::c_uint,
                    ::libc::c_uint,
                    LLVMMetadataRef,
                    *const ::libc::c_char,
                    ::libc::size_t,
                ) -> LLVMMetadataRef,
            >(stringify!(LLVMDIBuilderCreateStructType).as_bytes())
    }
        .expect(stringify!(LLVMDIBuilderCreateStructType));
    entry(
        Builder,
        Scope,
        Name,
        NameLen,
        File,
        LineNumber,
        SizeInBits,
        AlignInBits,
        Flags,
        DerivedFrom,
        Elements,
        NumElements,
        RunTimeLang,
        VTableHolder,
        UniqueId,
        UniqueIdLen,
    )
}
#[no_mangle]
pub extern "C" fn LLVMIsAAddrSpaceCastInst(Val: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMIsAAddrSpaceCastInst).as_bytes())
    }
        .expect(stringify!(LLVMIsAAddrSpaceCastInst));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn LLVMSetTailCallKind(CallInst: LLVMValueRef, kind: LLVMTailCallKind) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, LLVMTailCallKind),
            >(stringify!(LLVMSetTailCallKind).as_bytes())
    }
        .expect(stringify!(LLVMSetTailCallKind));
    entry(CallInst, kind)
}
#[no_mangle]
pub extern "C" fn LLVMIntrinsicIsOverloaded(ID: ::libc::c_uint) -> LLVMBool {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(::libc::c_uint) -> LLVMBool,
            >(stringify!(LLVMIntrinsicIsOverloaded).as_bytes())
    }
        .expect(stringify!(LLVMIntrinsicIsOverloaded));
    entry(ID)
}
#[no_mangle]
pub extern "C" fn LLVMIsAUser(Val: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMIsAUser).as_bytes())
    }
        .expect(stringify!(LLVMIsAUser));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn LLVMCreateModuleProviderForExistingModule(
    M: LLVMModuleRef,
) -> LLVMModuleProviderRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMModuleRef) -> LLVMModuleProviderRef,
            >(stringify!(LLVMCreateModuleProviderForExistingModule).as_bytes())
    }
        .expect(stringify!(LLVMCreateModuleProviderForExistingModule));
    entry(M)
}
#[no_mangle]
pub extern "C" fn LLVMGetUndefMaskElem() -> ::libc::c_int {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn() -> ::libc::c_int,
            >(stringify!(LLVMGetUndefMaskElem).as_bytes())
    }
        .expect(stringify!(LLVMGetUndefMaskElem));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMDisposeBinary(BR: LLVMBinaryRef) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMBinaryRef),
            >(stringify!(LLVMDisposeBinary).as_bytes())
    }
        .expect(stringify!(LLVMDisposeBinary));
    entry(BR)
}
#[no_mangle]
pub extern "C" fn LLVMConstNeg(ConstantVal: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMConstNeg).as_bytes())
    }
        .expect(stringify!(LLVMConstNeg));
    entry(ConstantVal)
}
#[no_mangle]
pub extern "C" fn LLVMBinaryGetType(BR: LLVMBinaryRef) -> LLVMBinaryType {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMBinaryRef) -> LLVMBinaryType,
            >(stringify!(LLVMBinaryGetType).as_bytes())
    }
        .expect(stringify!(LLVMBinaryGetType));
    entry(BR)
}
#[no_mangle]
pub extern "C" fn LLVMConstPtrToInt(
    ConstantVal: LLVMValueRef,
    ToType: LLVMTypeRef,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, LLVMTypeRef) -> LLVMValueRef,
            >(stringify!(LLVMConstPtrToInt).as_bytes())
    }
        .expect(stringify!(LLVMConstPtrToInt));
    entry(ConstantVal, ToType)
}
#[no_mangle]
pub extern "C" fn LLVMGetOperandBundleArgAtIndex(
    Bundle: LLVMOperandBundleRef,
    Index: ::libc::c_uint,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMOperandBundleRef, ::libc::c_uint) -> LLVMValueRef,
            >(stringify!(LLVMGetOperandBundleArgAtIndex).as_bytes())
    }
        .expect(stringify!(LLVMGetOperandBundleArgAtIndex));
    entry(Bundle, Index)
}
#[no_mangle]
pub extern "C" fn LLVMGetNextFunction(Fn: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMGetNextFunction).as_bytes())
    }
        .expect(stringify!(LLVMGetNextFunction));
    entry(Fn)
}
#[no_mangle]
pub extern "C" fn LLVMBuildTruncOrBitCast(
    arg1: LLVMBuilderRef,
    Val: LLVMValueRef,
    DestTy: LLVMTypeRef,
    Name: *const ::libc::c_char,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMBuilderRef,
                    LLVMValueRef,
                    LLVMTypeRef,
                    *const ::libc::c_char,
                ) -> LLVMValueRef,
            >(stringify!(LLVMBuildTruncOrBitCast).as_bytes())
    }
        .expect(stringify!(LLVMBuildTruncOrBitCast));
    entry(arg1, Val, DestTy, Name)
}
#[no_mangle]
pub extern "C" fn LLVMOrcLLJITGetTripleString(
    J: LLVMOrcLLJITRef,
) -> *const ::libc::c_char {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMOrcLLJITRef) -> *const ::libc::c_char,
            >(stringify!(LLVMOrcLLJITGetTripleString).as_bytes())
    }
        .expect(stringify!(LLVMOrcLLJITGetTripleString));
    entry(J)
}
#[no_mangle]
pub extern "C" fn LLVMDoubleType() -> LLVMTypeRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<extern "C" fn() -> LLVMTypeRef>(stringify!(LLVMDoubleType).as_bytes())
    }
        .expect(stringify!(LLVMDoubleType));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMMDNodeInContext(
    C: LLVMContextRef,
    Vals: *mut LLVMValueRef,
    Count: ::libc::c_uint,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMContextRef,
                    *mut LLVMValueRef,
                    ::libc::c_uint,
                ) -> LLVMValueRef,
            >(stringify!(LLVMMDNodeInContext).as_bytes())
    }
        .expect(stringify!(LLVMMDNodeInContext));
    entry(C, Vals, Count)
}
#[no_mangle]
pub extern "C" fn LLVMSetSection(Global: LLVMValueRef, Section: *const ::libc::c_char) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, *const ::libc::c_char),
            >(stringify!(LLVMSetSection).as_bytes())
    }
        .expect(stringify!(LLVMSetSection));
    entry(Global, Section)
}
#[no_mangle]
pub extern "C" fn LLVMRemoveGlobalIFunc(IFunc: LLVMValueRef) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef),
            >(stringify!(LLVMRemoveGlobalIFunc).as_bytes())
    }
        .expect(stringify!(LLVMRemoveGlobalIFunc));
    entry(IFunc)
}
#[no_mangle]
pub extern "C" fn LLVMGetTypeByName(
    M: LLVMModuleRef,
    Name: *const ::libc::c_char,
) -> LLVMTypeRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMModuleRef, *const ::libc::c_char) -> LLVMTypeRef,
            >(stringify!(LLVMGetTypeByName).as_bytes())
    }
        .expect(stringify!(LLVMGetTypeByName));
    entry(M, Name)
}
#[no_mangle]
pub extern "C" fn LLVMGetICmpPredicate(Inst: LLVMValueRef) -> LLVMIntPredicate {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMIntPredicate,
            >(stringify!(LLVMGetICmpPredicate).as_bytes())
    }
        .expect(stringify!(LLVMGetICmpPredicate));
    entry(Inst)
}
#[no_mangle]
pub extern "C" fn LLVMCreateDisasmCPUFeatures(
    Triple: *const ::libc::c_char,
    CPU: *const ::libc::c_char,
    Features: *const ::libc::c_char,
    DisInfo: *mut ::libc::c_void,
    TagType: ::libc::c_int,
    GetOpInfo: LLVMOpInfoCallback,
    SymbolLookUp: LLVMSymbolLookupCallback,
) -> LLVMDisasmContextRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    *const ::libc::c_char,
                    *const ::libc::c_char,
                    *const ::libc::c_char,
                    *mut ::libc::c_void,
                    ::libc::c_int,
                    LLVMOpInfoCallback,
                    LLVMSymbolLookupCallback,
                ) -> LLVMDisasmContextRef,
            >(stringify!(LLVMCreateDisasmCPUFeatures).as_bytes())
    }
        .expect(stringify!(LLVMCreateDisasmCPUFeatures));
    entry(Triple, CPU, Features, DisInfo, TagType, GetOpInfo, SymbolLookUp)
}
#[no_mangle]
pub extern "C" fn lto_module_has_objc_category(
    mem: *const ::libc::c_void,
    length: ::libc::size_t,
) -> lto_bool_t {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(*const ::libc::c_void, ::libc::size_t) -> lto_bool_t,
            >(stringify!(lto_module_has_objc_category).as_bytes())
    }
        .expect(stringify!(lto_module_has_objc_category));
    entry(mem, length)
}
#[no_mangle]
pub extern "C" fn LLVMParseBitcode(
    MemBuf: LLVMMemoryBufferRef,
    OutModule: *mut LLVMModuleRef,
    OutMessage: *mut *mut ::libc::c_char,
) -> LLVMBool {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMMemoryBufferRef,
                    *mut LLVMModuleRef,
                    *mut *mut ::libc::c_char,
                ) -> LLVMBool,
            >(stringify!(LLVMParseBitcode).as_bytes())
    }
        .expect(stringify!(LLVMParseBitcode));
    entry(MemBuf, OutModule, OutMessage)
}
#[no_mangle]
pub extern "C" fn LLVMBuildNot(
    arg1: LLVMBuilderRef,
    V: LLVMValueRef,
    Name: *const ::libc::c_char,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMBuilderRef,
                    LLVMValueRef,
                    *const ::libc::c_char,
                ) -> LLVMValueRef,
            >(stringify!(LLVMBuildNot).as_bytes())
    }
        .expect(stringify!(LLVMBuildNot));
    entry(arg1, V, Name)
}
#[no_mangle]
pub extern "C" fn lto_codegen_add_must_preserve_symbol(
    cg: lto_code_gen_t,
    symbol: *const ::libc::c_char,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(lto_code_gen_t, *const ::libc::c_char),
            >(stringify!(lto_codegen_add_must_preserve_symbol).as_bytes())
    }
        .expect(stringify!(lto_codegen_add_must_preserve_symbol));
    entry(cg, symbol)
}
#[no_mangle]
pub extern "C" fn LLVMGetRelocationSymbol(
    RI: LLVMRelocationIteratorRef,
) -> LLVMSymbolIteratorRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMRelocationIteratorRef) -> LLVMSymbolIteratorRef,
            >(stringify!(LLVMGetRelocationSymbol).as_bytes())
    }
        .expect(stringify!(LLVMGetRelocationSymbol));
    entry(RI)
}
#[no_mangle]
pub extern "C" fn LLVMInitializeMipsAsmPrinter() {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<extern "C" fn()>(stringify!(LLVMInitializeMipsAsmPrinter).as_bytes())
    }
        .expect(stringify!(LLVMInitializeMipsAsmPrinter));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMRemarkEntryGetNumArgs(Remark: LLVMRemarkEntryRef) -> u32 {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMRemarkEntryRef) -> u32,
            >(stringify!(LLVMRemarkEntryGetNumArgs).as_bytes())
    }
        .expect(stringify!(LLVMRemarkEntryGetNumArgs));
    entry(Remark)
}
#[no_mangle]
pub extern "C" fn LLVMInitializeLanaiTargetMC() {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<extern "C" fn()>(stringify!(LLVMInitializeLanaiTargetMC).as_bytes())
    }
        .expect(stringify!(LLVMInitializeLanaiTargetMC));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMInitializeX86AsmParser() {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<extern "C" fn()>(stringify!(LLVMInitializeX86AsmParser).as_bytes())
    }
        .expect(stringify!(LLVMInitializeX86AsmParser));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMIntPtrType(TD: LLVMTargetDataRef) -> LLVMTypeRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMTargetDataRef) -> LLVMTypeRef,
            >(stringify!(LLVMIntPtrType).as_bytes())
    }
        .expect(stringify!(LLVMIntPtrType));
    entry(TD)
}
#[no_mangle]
pub extern "C" fn LLVMTargetHasTargetMachine(T: LLVMTargetRef) -> LLVMBool {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMTargetRef) -> LLVMBool,
            >(stringify!(LLVMTargetHasTargetMachine).as_bytes())
    }
        .expect(stringify!(LLVMTargetHasTargetMachine));
    entry(T)
}
#[no_mangle]
pub extern "C" fn LLVMGetGC(Fn: LLVMValueRef) -> *const ::libc::c_char {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> *const ::libc::c_char,
            >(stringify!(LLVMGetGC).as_bytes())
    }
        .expect(stringify!(LLVMGetGC));
    entry(Fn)
}
#[no_mangle]
pub extern "C" fn LLVMOrcRTDyldObjectLinkingLayerRegisterJITEventListener(
    RTDyldObjLinkingLayer: LLVMOrcObjectLayerRef,
    Listener: LLVMJITEventListenerRef,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMOrcObjectLayerRef, LLVMJITEventListenerRef),
            >(
                stringify!(LLVMOrcRTDyldObjectLinkingLayerRegisterJITEventListener)
                    .as_bytes(),
            )
    }
        .expect(stringify!(LLVMOrcRTDyldObjectLinkingLayerRegisterJITEventListener));
    entry(RTDyldObjLinkingLayer, Listener)
}
#[no_mangle]
pub extern "C" fn LLVMGetBitcodeModule2(
    MemBuf: LLVMMemoryBufferRef,
    OutM: *mut LLVMModuleRef,
) -> LLVMBool {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMMemoryBufferRef, *mut LLVMModuleRef) -> LLVMBool,
            >(stringify!(LLVMGetBitcodeModule2).as_bytes())
    }
        .expect(stringify!(LLVMGetBitcodeModule2));
    entry(MemBuf, OutM)
}
#[no_mangle]
pub extern "C" fn LLVMIsABitCastInst(Val: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMIsABitCastInst).as_bytes())
    }
        .expect(stringify!(LLVMIsABitCastInst));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn LLVMConstInt(
    IntTy: LLVMTypeRef,
    N: ::libc::c_ulonglong,
    SignExtend: LLVMBool,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMTypeRef, ::libc::c_ulonglong, LLVMBool) -> LLVMValueRef,
            >(stringify!(LLVMConstInt).as_bytes())
    }
        .expect(stringify!(LLVMConstInt));
    entry(IntTy, N, SignExtend)
}
#[no_mangle]
pub extern "C" fn LLVMAddFunction(
    M: LLVMModuleRef,
    Name: *const ::libc::c_char,
    FunctionTy: LLVMTypeRef,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMModuleRef,
                    *const ::libc::c_char,
                    LLVMTypeRef,
                ) -> LLVMValueRef,
            >(stringify!(LLVMAddFunction).as_bytes())
    }
        .expect(stringify!(LLVMAddFunction));
    entry(M, Name, FunctionTy)
}
#[no_mangle]
pub extern "C" fn LLVMConstNot(ConstantVal: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMConstNot).as_bytes())
    }
        .expect(stringify!(LLVMConstNot));
    entry(ConstantVal)
}
#[no_mangle]
pub extern "C" fn LLVMOrcDisposeIndirectStubsManager(
    ISM: LLVMOrcIndirectStubsManagerRef,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMOrcIndirectStubsManagerRef),
            >(stringify!(LLVMOrcDisposeIndirectStubsManager).as_bytes())
    }
        .expect(stringify!(LLVMOrcDisposeIndirectStubsManager));
    entry(ISM)
}
#[no_mangle]
pub extern "C" fn LLVMCreateObjectFile(
    MemBuf: LLVMMemoryBufferRef,
) -> LLVMObjectFileRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMMemoryBufferRef) -> LLVMObjectFileRef,
            >(stringify!(LLVMCreateObjectFile).as_bytes())
    }
        .expect(stringify!(LLVMCreateObjectFile));
    entry(MemBuf)
}
#[no_mangle]
pub extern "C" fn LLVMSetTargetMachineAsmVerbosity(
    T: LLVMTargetMachineRef,
    VerboseAsm: LLVMBool,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMTargetMachineRef, LLVMBool),
            >(stringify!(LLVMSetTargetMachineAsmVerbosity).as_bytes())
    }
        .expect(stringify!(LLVMSetTargetMachineAsmVerbosity));
    entry(T, VerboseAsm)
}
#[no_mangle]
pub extern "C" fn LLVMInitializeMSP430TargetInfo() {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(),
            >(stringify!(LLVMInitializeMSP430TargetInfo).as_bytes())
    }
        .expect(stringify!(LLVMInitializeMSP430TargetInfo));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMIsAReturnInst(Val: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMIsAReturnInst).as_bytes())
    }
        .expect(stringify!(LLVMIsAReturnInst));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn LLVMPositionBuilderBeforeInstrAndDbgRecords(
    Builder: LLVMBuilderRef,
    Instr: LLVMValueRef,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMBuilderRef, LLVMValueRef),
            >(stringify!(LLVMPositionBuilderBeforeInstrAndDbgRecords).as_bytes())
    }
        .expect(stringify!(LLVMPositionBuilderBeforeInstrAndDbgRecords));
    entry(Builder, Instr)
}
#[no_mangle]
pub extern "C" fn LLVMInitializeRISCVTargetMC() {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<extern "C" fn()>(stringify!(LLVMInitializeRISCVTargetMC).as_bytes())
    }
        .expect(stringify!(LLVMInitializeRISCVTargetMC));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMDeleteGlobal(GlobalVar: LLVMValueRef) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<extern "C" fn(LLVMValueRef)>(stringify!(LLVMDeleteGlobal).as_bytes())
    }
        .expect(stringify!(LLVMDeleteGlobal));
    entry(GlobalVar)
}
#[no_mangle]
pub extern "C" fn LLVMTargetMachineEmitToFile(
    T: LLVMTargetMachineRef,
    M: LLVMModuleRef,
    Filename: *const ::libc::c_char,
    codegen: LLVMCodeGenFileType,
    ErrorMessage: *mut *mut ::libc::c_char,
) -> LLVMBool {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMTargetMachineRef,
                    LLVMModuleRef,
                    *const ::libc::c_char,
                    LLVMCodeGenFileType,
                    *mut *mut ::libc::c_char,
                ) -> LLVMBool,
            >(stringify!(LLVMTargetMachineEmitToFile).as_bytes())
    }
        .expect(stringify!(LLVMTargetMachineEmitToFile));
    entry(T, M, Filename, codegen, ErrorMessage)
}
#[no_mangle]
pub extern "C" fn LLVMOrcCreateLLJITBuilder() -> LLVMOrcLLJITBuilderRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn() -> LLVMOrcLLJITBuilderRef,
            >(stringify!(LLVMOrcCreateLLJITBuilder).as_bytes())
    }
        .expect(stringify!(LLVMOrcCreateLLJITBuilder));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMModuleCreateWithName(
    ModuleID: *const ::libc::c_char,
) -> LLVMModuleRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(*const ::libc::c_char) -> LLVMModuleRef,
            >(stringify!(LLVMModuleCreateWithName).as_bytes())
    }
        .expect(stringify!(LLVMModuleCreateWithName));
    entry(ModuleID)
}
#[no_mangle]
pub extern "C" fn LLVMIsAConstantFP(Val: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMIsAConstantFP).as_bytes())
    }
        .expect(stringify!(LLVMIsAConstantFP));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn LLVMGetValueKind(Val: LLVMValueRef) -> LLVMValueKind {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueKind,
            >(stringify!(LLVMGetValueKind).as_bytes())
    }
        .expect(stringify!(LLVMGetValueKind));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn LLVMDIBuilderCreateTempMacroFile(
    Builder: LLVMDIBuilderRef,
    ParentMacroFile: LLVMMetadataRef,
    Line: ::libc::c_uint,
    File: LLVMMetadataRef,
) -> LLVMMetadataRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMDIBuilderRef,
                    LLVMMetadataRef,
                    ::libc::c_uint,
                    LLVMMetadataRef,
                ) -> LLVMMetadataRef,
            >(stringify!(LLVMDIBuilderCreateTempMacroFile).as_bytes())
    }
        .expect(stringify!(LLVMDIBuilderCreateTempMacroFile));
    entry(Builder, ParentMacroFile, Line, File)
}
#[no_mangle]
pub extern "C" fn LLVMGetInlineAsmNeedsAlignedStack(
    InlineAsmVal: LLVMValueRef,
) -> LLVMBool {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMBool,
            >(stringify!(LLVMGetInlineAsmNeedsAlignedStack).as_bytes())
    }
        .expect(stringify!(LLVMGetInlineAsmNeedsAlignedStack));
    entry(InlineAsmVal)
}
#[no_mangle]
pub extern "C" fn LLVMGetNamedGlobalIFunc(
    M: LLVMModuleRef,
    Name: *const ::libc::c_char,
    NameLen: ::libc::size_t,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMModuleRef,
                    *const ::libc::c_char,
                    ::libc::size_t,
                ) -> LLVMValueRef,
            >(stringify!(LLVMGetNamedGlobalIFunc).as_bytes())
    }
        .expect(stringify!(LLVMGetNamedGlobalIFunc));
    entry(M, Name, NameLen)
}
#[no_mangle]
pub extern "C" fn LLVMBuildFRem(
    arg1: LLVMBuilderRef,
    LHS: LLVMValueRef,
    RHS: LLVMValueRef,
    Name: *const ::libc::c_char,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMBuilderRef,
                    LLVMValueRef,
                    LLVMValueRef,
                    *const ::libc::c_char,
                ) -> LLVMValueRef,
            >(stringify!(LLVMBuildFRem).as_bytes())
    }
        .expect(stringify!(LLVMBuildFRem));
    entry(arg1, LHS, RHS, Name)
}
#[no_mangle]
pub extern "C" fn lto_input_create(
    buffer: *const ::libc::c_void,
    buffer_size: ::libc::size_t,
    path: *const ::libc::c_char,
) -> lto_input_t {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    *const ::libc::c_void,
                    ::libc::size_t,
                    *const ::libc::c_char,
                ) -> lto_input_t,
            >(stringify!(lto_input_create).as_bytes())
    }
        .expect(stringify!(lto_input_create));
    entry(buffer, buffer_size, path)
}
#[no_mangle]
pub extern "C" fn LLVMGetPrefixData(Fn: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMGetPrefixData).as_bytes())
    }
        .expect(stringify!(LLVMGetPrefixData));
    entry(Fn)
}
#[no_mangle]
pub extern "C" fn LLVMGetTargetMachineTriple(
    T: LLVMTargetMachineRef,
) -> *mut ::libc::c_char {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMTargetMachineRef) -> *mut ::libc::c_char,
            >(stringify!(LLVMGetTargetMachineTriple).as_bytes())
    }
        .expect(stringify!(LLVMGetTargetMachineTriple));
    entry(T)
}
#[no_mangle]
pub extern "C" fn LLVMGetNumOperandBundles(C: LLVMValueRef) -> ::libc::c_uint {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> ::libc::c_uint,
            >(stringify!(LLVMGetNumOperandBundles).as_bytes())
    }
        .expect(stringify!(LLVMGetNumOperandBundles));
    entry(C)
}
#[no_mangle]
pub extern "C" fn LLVMGetGlobalIFuncResolver(IFunc: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMGetGlobalIFuncResolver).as_bytes())
    }
        .expect(stringify!(LLVMGetGlobalIFuncResolver));
    entry(IFunc)
}
#[no_mangle]
pub extern "C" fn LLVMGetBasicBlockName(BB: LLVMBasicBlockRef) -> *const ::libc::c_char {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMBasicBlockRef) -> *const ::libc::c_char,
            >(stringify!(LLVMGetBasicBlockName).as_bytes())
    }
        .expect(stringify!(LLVMGetBasicBlockName));
    entry(BB)
}
#[no_mangle]
pub extern "C" fn LLVMIsAFPTruncInst(Val: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMIsAFPTruncInst).as_bytes())
    }
        .expect(stringify!(LLVMIsAFPTruncInst));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn LLVMDIBuilderCreateDynamicArrayType(
    Builder: LLVMDIBuilderRef,
    Scope: LLVMMetadataRef,
    Name: *const ::libc::c_char,
    NameLen: ::libc::size_t,
    LineNo: ::libc::c_uint,
    File: LLVMMetadataRef,
    Size: u64,
    AlignInBits: u32,
    Ty: LLVMMetadataRef,
    Subscripts: LLVMMetadataRef,
    NumSubscripts: ::libc::c_uint,
    DataLocation: LLVMMetadataRef,
    Associated: LLVMMetadataRef,
    Allocated: LLVMMetadataRef,
    Rank: LLVMMetadataRef,
    BitStride: LLVMMetadataRef,
) -> LLVMMetadataRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMDIBuilderRef,
                    LLVMMetadataRef,
                    *const ::libc::c_char,
                    ::libc::size_t,
                    ::libc::c_uint,
                    LLVMMetadataRef,
                    u64,
                    u32,
                    LLVMMetadataRef,
                    LLVMMetadataRef,
                    ::libc::c_uint,
                    LLVMMetadataRef,
                    LLVMMetadataRef,
                    LLVMMetadataRef,
                    LLVMMetadataRef,
                    LLVMMetadataRef,
                ) -> LLVMMetadataRef,
            >(stringify!(LLVMDIBuilderCreateDynamicArrayType).as_bytes())
    }
        .expect(stringify!(LLVMDIBuilderCreateDynamicArrayType));
    entry(
        Builder,
        Scope,
        Name,
        NameLen,
        LineNo,
        File,
        Size,
        AlignInBits,
        Ty,
        Subscripts,
        NumSubscripts,
        DataLocation,
        Associated,
        Allocated,
        Rank,
        BitStride,
    )
}
#[no_mangle]
pub extern "C" fn LLVMGetEntryBasicBlock(Fn: LLVMValueRef) -> LLVMBasicBlockRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMBasicBlockRef,
            >(stringify!(LLVMGetEntryBasicBlock).as_bytes())
    }
        .expect(stringify!(LLVMGetEntryBasicBlock));
    entry(Fn)
}
#[no_mangle]
pub extern "C" fn LLVMSetDataLayout(
    M: LLVMModuleRef,
    DataLayoutStr: *const ::libc::c_char,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMModuleRef, *const ::libc::c_char),
            >(stringify!(LLVMSetDataLayout).as_bytes())
    }
        .expect(stringify!(LLVMSetDataLayout));
    entry(M, DataLayoutStr)
}
#[no_mangle]
pub extern "C" fn LLVMParseIRInContext2(
    ContextRef: LLVMContextRef,
    MemBuf: LLVMMemoryBufferRef,
    OutM: *mut LLVMModuleRef,
    OutMessage: *mut *mut ::libc::c_char,
) -> LLVMBool {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMContextRef,
                    LLVMMemoryBufferRef,
                    *mut LLVMModuleRef,
                    *mut *mut ::libc::c_char,
                ) -> LLVMBool,
            >(stringify!(LLVMParseIRInContext2).as_bytes())
    }
        .expect(stringify!(LLVMParseIRInContext2));
    entry(ContextRef, MemBuf, OutM, OutMessage)
}
#[no_mangle]
pub extern "C" fn LLVMInitializeSystemZTarget() {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<extern "C" fn()>(stringify!(LLVMInitializeSystemZTarget).as_bytes())
    }
        .expect(stringify!(LLVMInitializeSystemZTarget));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMSetAlignment(V: LLVMValueRef, Bytes: ::libc::c_uint) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, ::libc::c_uint),
            >(stringify!(LLVMSetAlignment).as_bytes())
    }
        .expect(stringify!(LLVMSetAlignment));
    entry(V, Bytes)
}
#[no_mangle]
pub extern "C" fn LLVMOrcRetainSymbolStringPoolEntry(
    S: LLVMOrcSymbolStringPoolEntryRef,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMOrcSymbolStringPoolEntryRef),
            >(stringify!(LLVMOrcRetainSymbolStringPoolEntry).as_bytes())
    }
        .expect(stringify!(LLVMOrcRetainSymbolStringPoolEntry));
    entry(S)
}
#[no_mangle]
pub extern "C" fn lto_get_version() -> *const ::libc::c_char {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn() -> *const ::libc::c_char,
            >(stringify!(lto_get_version).as_bytes())
    }
        .expect(stringify!(lto_get_version));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMBuildAtomicRMWSyncScope(
    B: LLVMBuilderRef,
    op: LLVMAtomicRMWBinOp,
    PTR: LLVMValueRef,
    Val: LLVMValueRef,
    ordering: LLVMAtomicOrdering,
    SSID: ::libc::c_uint,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMBuilderRef,
                    LLVMAtomicRMWBinOp,
                    LLVMValueRef,
                    LLVMValueRef,
                    LLVMAtomicOrdering,
                    ::libc::c_uint,
                ) -> LLVMValueRef,
            >(stringify!(LLVMBuildAtomicRMWSyncScope).as_bytes())
    }
        .expect(stringify!(LLVMBuildAtomicRMWSyncScope));
    entry(B, op, PTR, Val, ordering, SSID)
}
#[no_mangle]
pub extern "C" fn LLVMDIGlobalVariableExpressionGetVariable(
    GVE: LLVMMetadataRef,
) -> LLVMMetadataRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMMetadataRef) -> LLVMMetadataRef,
            >(stringify!(LLVMDIGlobalVariableExpressionGetVariable).as_bytes())
    }
        .expect(stringify!(LLVMDIGlobalVariableExpressionGetVariable));
    entry(GVE)
}
#[no_mangle]
pub extern "C" fn LLVMIsAConstantInt(Val: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMIsAConstantInt).as_bytes())
    }
        .expect(stringify!(LLVMIsAConstantInt));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn LLVMOrcExecutionSessionGetSymbolStringPool(
    ES: LLVMOrcExecutionSessionRef,
) -> LLVMOrcSymbolStringPoolRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMOrcExecutionSessionRef) -> LLVMOrcSymbolStringPoolRef,
            >(stringify!(LLVMOrcExecutionSessionGetSymbolStringPool).as_bytes())
    }
        .expect(stringify!(LLVMOrcExecutionSessionGetSymbolStringPool));
    entry(ES)
}
#[no_mangle]
pub extern "C" fn LLVMCreateDIBuilder(M: LLVMModuleRef) -> LLVMDIBuilderRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMModuleRef) -> LLVMDIBuilderRef,
            >(stringify!(LLVMCreateDIBuilder).as_bytes())
    }
        .expect(stringify!(LLVMCreateDIBuilder));
    entry(M)
}
#[no_mangle]
pub extern "C" fn LLVMGetNextBasicBlock(BB: LLVMBasicBlockRef) -> LLVMBasicBlockRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMBasicBlockRef) -> LLVMBasicBlockRef,
            >(stringify!(LLVMGetNextBasicBlock).as_bytes())
    }
        .expect(stringify!(LLVMGetNextBasicBlock));
    entry(BB)
}
#[no_mangle]
pub extern "C" fn LLVMBuildGEPWithNoWrapFlags(
    B: LLVMBuilderRef,
    Ty: LLVMTypeRef,
    Pointer: LLVMValueRef,
    Indices: *mut LLVMValueRef,
    NumIndices: ::libc::c_uint,
    Name: *const ::libc::c_char,
    NoWrapFlags: LLVMGEPNoWrapFlags,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMBuilderRef,
                    LLVMTypeRef,
                    LLVMValueRef,
                    *mut LLVMValueRef,
                    ::libc::c_uint,
                    *const ::libc::c_char,
                    LLVMGEPNoWrapFlags,
                ) -> LLVMValueRef,
            >(stringify!(LLVMBuildGEPWithNoWrapFlags).as_bytes())
    }
        .expect(stringify!(LLVMBuildGEPWithNoWrapFlags));
    entry(B, Ty, Pointer, Indices, NumIndices, Name, NoWrapFlags)
}
#[no_mangle]
pub extern "C" fn LLVMElementAtOffset(
    TD: LLVMTargetDataRef,
    StructTy: LLVMTypeRef,
    Offset: ::libc::c_ulonglong,
) -> ::libc::c_uint {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMTargetDataRef,
                    LLVMTypeRef,
                    ::libc::c_ulonglong,
                ) -> ::libc::c_uint,
            >(stringify!(LLVMElementAtOffset).as_bytes())
    }
        .expect(stringify!(LLVMElementAtOffset));
    entry(TD, StructTy, Offset)
}
#[no_mangle]
pub extern "C" fn LLVMInitializeX86TargetInfo() {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<extern "C" fn()>(stringify!(LLVMInitializeX86TargetInfo).as_bytes())
    }
        .expect(stringify!(LLVMInitializeX86TargetInfo));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMGetSymbolSize(SI: LLVMSymbolIteratorRef) -> u64 {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMSymbolIteratorRef) -> u64,
            >(stringify!(LLVMGetSymbolSize).as_bytes())
    }
        .expect(stringify!(LLVMGetSymbolSize));
    entry(SI)
}
#[no_mangle]
pub extern "C" fn LLVMGetNumOperandBundleArgs(
    Bundle: LLVMOperandBundleRef,
) -> ::libc::c_uint {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMOperandBundleRef) -> ::libc::c_uint,
            >(stringify!(LLVMGetNumOperandBundleArgs).as_bytes())
    }
        .expect(stringify!(LLVMGetNumOperandBundleArgs));
    entry(Bundle)
}
#[no_mangle]
pub extern "C" fn LLVMDILocationGetColumn(Location: LLVMMetadataRef) -> ::libc::c_uint {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMMetadataRef) -> ::libc::c_uint,
            >(stringify!(LLVMDILocationGetColumn).as_bytes())
    }
        .expect(stringify!(LLVMDILocationGetColumn));
    entry(Location)
}
#[no_mangle]
pub extern "C" fn LLVMConstNUWAdd(
    LHSConstant: LLVMValueRef,
    RHSConstant: LLVMValueRef,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMConstNUWAdd).as_bytes())
    }
        .expect(stringify!(LLVMConstNUWAdd));
    entry(LHSConstant, RHSConstant)
}
#[no_mangle]
pub extern "C" fn LLVMIsAConstantVector(Val: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMIsAConstantVector).as_bytes())
    }
        .expect(stringify!(LLVMIsAConstantVector));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn LLVMBuildURem(
    arg1: LLVMBuilderRef,
    LHS: LLVMValueRef,
    RHS: LLVMValueRef,
    Name: *const ::libc::c_char,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMBuilderRef,
                    LLVMValueRef,
                    LLVMValueRef,
                    *const ::libc::c_char,
                ) -> LLVMValueRef,
            >(stringify!(LLVMBuildURem).as_bytes())
    }
        .expect(stringify!(LLVMBuildURem));
    entry(arg1, LHS, RHS, Name)
}
#[no_mangle]
pub extern "C" fn LLVMDIBuilderCreateImportedModuleFromNamespace(
    Builder: LLVMDIBuilderRef,
    Scope: LLVMMetadataRef,
    NS: LLVMMetadataRef,
    File: LLVMMetadataRef,
    Line: ::libc::c_uint,
) -> LLVMMetadataRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMDIBuilderRef,
                    LLVMMetadataRef,
                    LLVMMetadataRef,
                    LLVMMetadataRef,
                    ::libc::c_uint,
                ) -> LLVMMetadataRef,
            >(stringify!(LLVMDIBuilderCreateImportedModuleFromNamespace).as_bytes())
    }
        .expect(stringify!(LLVMDIBuilderCreateImportedModuleFromNamespace));
    entry(Builder, Scope, NS, File, Line)
}
#[no_mangle]
pub extern "C" fn LLVMGetFirstGlobalIFunc(M: LLVMModuleRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMModuleRef) -> LLVMValueRef,
            >(stringify!(LLVMGetFirstGlobalIFunc).as_bytes())
    }
        .expect(stringify!(LLVMGetFirstGlobalIFunc));
    entry(M)
}
#[no_mangle]
pub extern "C" fn LLVMDIBuilderCreateStaticMemberType(
    Builder: LLVMDIBuilderRef,
    Scope: LLVMMetadataRef,
    Name: *const ::libc::c_char,
    NameLen: ::libc::size_t,
    File: LLVMMetadataRef,
    LineNumber: ::libc::c_uint,
    Type: LLVMMetadataRef,
    Flags: LLVMDIFlags,
    ConstantVal: LLVMValueRef,
    AlignInBits: u32,
) -> LLVMMetadataRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMDIBuilderRef,
                    LLVMMetadataRef,
                    *const ::libc::c_char,
                    ::libc::size_t,
                    LLVMMetadataRef,
                    ::libc::c_uint,
                    LLVMMetadataRef,
                    LLVMDIFlags,
                    LLVMValueRef,
                    u32,
                ) -> LLVMMetadataRef,
            >(stringify!(LLVMDIBuilderCreateStaticMemberType).as_bytes())
    }
        .expect(stringify!(LLVMDIBuilderCreateStaticMemberType));
    entry(
        Builder,
        Scope,
        Name,
        NameLen,
        File,
        LineNumber,
        Type,
        Flags,
        ConstantVal,
        AlignInBits,
    )
}
#[no_mangle]
pub extern "C" fn LLVMIsUndef(Val: LLVMValueRef) -> LLVMBool {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMBool,
            >(stringify!(LLVMIsUndef).as_bytes())
    }
        .expect(stringify!(LLVMIsUndef));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn LLVMHasMetadata(Val: LLVMValueRef) -> ::libc::c_int {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> ::libc::c_int,
            >(stringify!(LLVMHasMetadata).as_bytes())
    }
        .expect(stringify!(LLVMHasMetadata));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn LLVMInitializeBPFAsmPrinter() {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<extern "C" fn()>(stringify!(LLVMInitializeBPFAsmPrinter).as_bytes())
    }
        .expect(stringify!(LLVMInitializeBPFAsmPrinter));
    entry()
}
#[no_mangle]
pub extern "C" fn llvm_blake3_hasher_init_derive_key_raw(
    hasher: *mut llvm_blake3_hasher,
    context: *const ::libc::c_char,
    context_len: usize,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(*mut llvm_blake3_hasher, *const ::libc::c_char, usize),
            >(stringify!(llvm_blake3_hasher_init_derive_key_raw).as_bytes())
    }
        .expect(stringify!(llvm_blake3_hasher_init_derive_key_raw));
    entry(hasher, context, context_len)
}
#[no_mangle]
pub extern "C" fn LLVMGetBitcodeModuleInContext(
    ContextRef: LLVMContextRef,
    MemBuf: LLVMMemoryBufferRef,
    OutM: *mut LLVMModuleRef,
    OutMessage: *mut *mut ::libc::c_char,
) -> LLVMBool {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMContextRef,
                    LLVMMemoryBufferRef,
                    *mut LLVMModuleRef,
                    *mut *mut ::libc::c_char,
                ) -> LLVMBool,
            >(stringify!(LLVMGetBitcodeModuleInContext).as_bytes())
    }
        .expect(stringify!(LLVMGetBitcodeModuleInContext));
    entry(ContextRef, MemBuf, OutM, OutMessage)
}
#[no_mangle]
pub extern "C" fn LLVMSetModuleDataLayout(M: LLVMModuleRef, R: LLVMTargetDataRef) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMModuleRef, LLVMTargetDataRef),
            >(stringify!(LLVMSetModuleDataLayout).as_bytes())
    }
        .expect(stringify!(LLVMSetModuleDataLayout));
    entry(M, R)
}
#[no_mangle]
pub extern "C" fn LLVMGetNNeg(NonNegInst: LLVMValueRef) -> LLVMBool {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMBool,
            >(stringify!(LLVMGetNNeg).as_bytes())
    }
        .expect(stringify!(LLVMGetNNeg));
    entry(NonNegInst)
}
#[no_mangle]
pub extern "C" fn LLVMTargetMachineOptionsSetFeatures(
    Options: LLVMTargetMachineOptionsRef,
    Features: *const ::libc::c_char,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMTargetMachineOptionsRef, *const ::libc::c_char),
            >(stringify!(LLVMTargetMachineOptionsSetFeatures).as_bytes())
    }
        .expect(stringify!(LLVMTargetMachineOptionsSetFeatures));
    entry(Options, Features)
}
#[no_mangle]
pub extern "C" fn LLVMGetRelocations(
    Section: LLVMSectionIteratorRef,
) -> LLVMRelocationIteratorRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMSectionIteratorRef) -> LLVMRelocationIteratorRef,
            >(stringify!(LLVMGetRelocations).as_bytes())
    }
        .expect(stringify!(LLVMGetRelocations));
    entry(Section)
}
#[no_mangle]
pub extern "C" fn LLVMSetCmpXchgFailureOrdering(
    CmpXchgInst: LLVMValueRef,
    Ordering: LLVMAtomicOrdering,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, LLVMAtomicOrdering),
            >(stringify!(LLVMSetCmpXchgFailureOrdering).as_bytes())
    }
        .expect(stringify!(LLVMSetCmpXchgFailureOrdering));
    entry(CmpXchgInst, Ordering)
}
#[no_mangle]
pub extern "C" fn LLVMIsThreadLocal(GlobalVar: LLVMValueRef) -> LLVMBool {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMBool,
            >(stringify!(LLVMIsThreadLocal).as_bytes())
    }
        .expect(stringify!(LLVMIsThreadLocal));
    entry(GlobalVar)
}
#[no_mangle]
pub extern "C" fn LLVMRemarkParserCreateYAML(
    Buf: *const ::libc::c_void,
    Size: u64,
) -> LLVMRemarkParserRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(*const ::libc::c_void, u64) -> LLVMRemarkParserRef,
            >(stringify!(LLVMRemarkParserCreateYAML).as_bytes())
    }
        .expect(stringify!(LLVMRemarkParserCreateYAML));
    entry(Buf, Size)
}
#[no_mangle]
pub extern "C" fn LLVMGetInsertBlock(Builder: LLVMBuilderRef) -> LLVMBasicBlockRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMBuilderRef) -> LLVMBasicBlockRef,
            >(stringify!(LLVMGetInsertBlock).as_bytes())
    }
        .expect(stringify!(LLVMGetInsertBlock));
    entry(Builder)
}
#[no_mangle]
pub extern "C" fn LLVMDIBuilderCreateInheritance(
    Builder: LLVMDIBuilderRef,
    Ty: LLVMMetadataRef,
    BaseTy: LLVMMetadataRef,
    BaseOffset: u64,
    VBPtrOffset: u32,
    Flags: LLVMDIFlags,
) -> LLVMMetadataRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMDIBuilderRef,
                    LLVMMetadataRef,
                    LLVMMetadataRef,
                    u64,
                    u32,
                    LLVMDIFlags,
                ) -> LLVMMetadataRef,
            >(stringify!(LLVMDIBuilderCreateInheritance).as_bytes())
    }
        .expect(stringify!(LLVMDIBuilderCreateInheritance));
    entry(Builder, Ty, BaseTy, BaseOffset, VBPtrOffset, Flags)
}
#[no_mangle]
pub extern "C" fn lto_codegen_set_pic_model(
    cg: lto_code_gen_t,
    arg1: lto_codegen_model,
) -> lto_bool_t {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(lto_code_gen_t, lto_codegen_model) -> lto_bool_t,
            >(stringify!(lto_codegen_set_pic_model).as_bytes())
    }
        .expect(stringify!(lto_codegen_set_pic_model));
    entry(cg, arg1)
}
#[no_mangle]
pub extern "C" fn LLVMBuildStore(
    arg1: LLVMBuilderRef,
    Val: LLVMValueRef,
    Ptr: LLVMValueRef,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMBuilderRef, LLVMValueRef, LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMBuildStore).as_bytes())
    }
        .expect(stringify!(LLVMBuildStore));
    entry(arg1, Val, Ptr)
}
#[no_mangle]
pub extern "C" fn LLVMInitializeAArch64TargetMC() {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<extern "C" fn()>(stringify!(LLVMInitializeAArch64TargetMC).as_bytes())
    }
        .expect(stringify!(LLVMInitializeAArch64TargetMC));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMBuildStructGEP2(
    B: LLVMBuilderRef,
    Ty: LLVMTypeRef,
    Pointer: LLVMValueRef,
    Idx: ::libc::c_uint,
    Name: *const ::libc::c_char,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMBuilderRef,
                    LLVMTypeRef,
                    LLVMValueRef,
                    ::libc::c_uint,
                    *const ::libc::c_char,
                ) -> LLVMValueRef,
            >(stringify!(LLVMBuildStructGEP2).as_bytes())
    }
        .expect(stringify!(LLVMBuildStructGEP2));
    entry(B, Ty, Pointer, Idx, Name)
}
#[no_mangle]
pub extern "C" fn LLVMGetNextNamedMetadata(
    NamedMDNode: LLVMNamedMDNodeRef,
) -> LLVMNamedMDNodeRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMNamedMDNodeRef) -> LLVMNamedMDNodeRef,
            >(stringify!(LLVMGetNextNamedMetadata).as_bytes())
    }
        .expect(stringify!(LLVMGetNextNamedMetadata));
    entry(NamedMDNode)
}
#[no_mangle]
pub extern "C" fn LLVMOrcMaterializationResponsibilityDefineMaterializing(
    MR: LLVMOrcMaterializationResponsibilityRef,
    Pairs: LLVMOrcCSymbolFlagsMapPairs,
    NumPairs: ::libc::size_t,
) -> LLVMErrorRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMOrcMaterializationResponsibilityRef,
                    LLVMOrcCSymbolFlagsMapPairs,
                    ::libc::size_t,
                ) -> LLVMErrorRef,
            >(
                stringify!(LLVMOrcMaterializationResponsibilityDefineMaterializing)
                    .as_bytes(),
            )
    }
        .expect(stringify!(LLVMOrcMaterializationResponsibilityDefineMaterializing));
    entry(MR, Pairs, NumPairs)
}
#[no_mangle]
pub extern "C" fn LLVMGetBlockAddressBasicBlock(
    BlockAddr: LLVMValueRef,
) -> LLVMBasicBlockRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMBasicBlockRef,
            >(stringify!(LLVMGetBlockAddressBasicBlock).as_bytes())
    }
        .expect(stringify!(LLVMGetBlockAddressBasicBlock));
    entry(BlockAddr)
}
#[no_mangle]
pub extern "C" fn LLVMBuildPtrDiff2(
    arg1: LLVMBuilderRef,
    ElemTy: LLVMTypeRef,
    LHS: LLVMValueRef,
    RHS: LLVMValueRef,
    Name: *const ::libc::c_char,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMBuilderRef,
                    LLVMTypeRef,
                    LLVMValueRef,
                    LLVMValueRef,
                    *const ::libc::c_char,
                ) -> LLVMValueRef,
            >(stringify!(LLVMBuildPtrDiff2).as_bytes())
    }
        .expect(stringify!(LLVMBuildPtrDiff2));
    entry(arg1, ElemTy, LHS, RHS, Name)
}
#[no_mangle]
pub extern "C" fn LLVMBuildUnreachable(B: LLVMBuilderRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMBuilderRef) -> LLVMValueRef,
            >(stringify!(LLVMBuildUnreachable).as_bytes())
    }
        .expect(stringify!(LLVMBuildUnreachable));
    entry(B)
}
#[no_mangle]
pub extern "C" fn LLVMInstructionRemoveFromParent(Inst: LLVMValueRef) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef),
            >(stringify!(LLVMInstructionRemoveFromParent).as_bytes())
    }
        .expect(stringify!(LLVMInstructionRemoveFromParent));
    entry(Inst)
}
#[no_mangle]
pub extern "C" fn LLVMBuildExtractValue(
    arg1: LLVMBuilderRef,
    AggVal: LLVMValueRef,
    Index: ::libc::c_uint,
    Name: *const ::libc::c_char,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMBuilderRef,
                    LLVMValueRef,
                    ::libc::c_uint,
                    *const ::libc::c_char,
                ) -> LLVMValueRef,
            >(stringify!(LLVMBuildExtractValue).as_bytes())
    }
        .expect(stringify!(LLVMBuildExtractValue));
    entry(arg1, AggVal, Index, Name)
}
#[no_mangle]
pub extern "C" fn LLVMDumpValue(Val: LLVMValueRef) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<extern "C" fn(LLVMValueRef)>(stringify!(LLVMDumpValue).as_bytes())
    }
        .expect(stringify!(LLVMDumpValue));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn LLVMDeleteInstruction(Inst: LLVMValueRef) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef),
            >(stringify!(LLVMDeleteInstruction).as_bytes())
    }
        .expect(stringify!(LLVMDeleteInstruction));
    entry(Inst)
}
#[no_mangle]
pub extern "C" fn LLVMBuildAtomicRMW(
    B: LLVMBuilderRef,
    op: LLVMAtomicRMWBinOp,
    PTR: LLVMValueRef,
    Val: LLVMValueRef,
    ordering: LLVMAtomicOrdering,
    singleThread: LLVMBool,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMBuilderRef,
                    LLVMAtomicRMWBinOp,
                    LLVMValueRef,
                    LLVMValueRef,
                    LLVMAtomicOrdering,
                    LLVMBool,
                ) -> LLVMValueRef,
            >(stringify!(LLVMBuildAtomicRMW).as_bytes())
    }
        .expect(stringify!(LLVMBuildAtomicRMW));
    entry(B, op, PTR, Val, ordering, singleThread)
}
#[no_mangle]
pub extern "C" fn LLVMDIBuilderInsertDeclareRecordAtEnd(
    Builder: LLVMDIBuilderRef,
    Storage: LLVMValueRef,
    VarInfo: LLVMMetadataRef,
    Expr: LLVMMetadataRef,
    DebugLoc: LLVMMetadataRef,
    Block: LLVMBasicBlockRef,
) -> LLVMDbgRecordRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMDIBuilderRef,
                    LLVMValueRef,
                    LLVMMetadataRef,
                    LLVMMetadataRef,
                    LLVMMetadataRef,
                    LLVMBasicBlockRef,
                ) -> LLVMDbgRecordRef,
            >(stringify!(LLVMDIBuilderInsertDeclareRecordAtEnd).as_bytes())
    }
        .expect(stringify!(LLVMDIBuilderInsertDeclareRecordAtEnd));
    entry(Builder, Storage, VarInfo, Expr, DebugLoc, Block)
}
#[no_mangle]
pub extern "C" fn LLVMGetStringErrorTypeId() -> LLVMErrorTypeId {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn() -> LLVMErrorTypeId,
            >(stringify!(LLVMGetStringErrorTypeId).as_bytes())
    }
        .expect(stringify!(LLVMGetStringErrorTypeId));
    entry()
}
#[no_mangle]
pub extern "C" fn lto_codegen_set_debug_model(
    cg: lto_code_gen_t,
    arg1: lto_debug_model,
) -> lto_bool_t {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(lto_code_gen_t, lto_debug_model) -> lto_bool_t,
            >(stringify!(lto_codegen_set_debug_model).as_bytes())
    }
        .expect(stringify!(lto_codegen_set_debug_model));
    entry(cg, arg1)
}
#[no_mangle]
pub extern "C" fn LLVMGetParamParent(Inst: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMGetParamParent).as_bytes())
    }
        .expect(stringify!(LLVMGetParamParent));
    entry(Inst)
}
#[no_mangle]
pub extern "C" fn LLVMIsACatchSwitchInst(Val: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMIsACatchSwitchInst).as_bytes())
    }
        .expect(stringify!(LLVMIsACatchSwitchInst));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn LLVMSetUnnamedAddr(Global: LLVMValueRef, HasUnnamedAddr: LLVMBool) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, LLVMBool),
            >(stringify!(LLVMSetUnnamedAddr).as_bytes())
    }
        .expect(stringify!(LLVMSetUnnamedAddr));
    entry(Global, HasUnnamedAddr)
}
#[no_mangle]
pub extern "C" fn LLVMGetPreviousGlobalAlias(GA: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMGetPreviousGlobalAlias).as_bytes())
    }
        .expect(stringify!(LLVMGetPreviousGlobalAlias));
    entry(GA)
}
#[no_mangle]
pub extern "C" fn LLVMCreateStringAttribute(
    C: LLVMContextRef,
    K: *const ::libc::c_char,
    KLength: ::libc::c_uint,
    V: *const ::libc::c_char,
    VLength: ::libc::c_uint,
) -> LLVMAttributeRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMContextRef,
                    *const ::libc::c_char,
                    ::libc::c_uint,
                    *const ::libc::c_char,
                    ::libc::c_uint,
                ) -> LLVMAttributeRef,
            >(stringify!(LLVMCreateStringAttribute).as_bytes())
    }
        .expect(stringify!(LLVMCreateStringAttribute));
    entry(C, K, KLength, V, VLength)
}
#[no_mangle]
pub extern "C" fn LLVMWriteBitcodeToFile(
    M: LLVMModuleRef,
    Path: *const ::libc::c_char,
) -> ::libc::c_int {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMModuleRef, *const ::libc::c_char) -> ::libc::c_int,
            >(stringify!(LLVMWriteBitcodeToFile).as_bytes())
    }
        .expect(stringify!(LLVMWriteBitcodeToFile));
    entry(M, Path)
}
#[no_mangle]
pub extern "C" fn LLVMMDStringInContext2(
    C: LLVMContextRef,
    Str: *const ::libc::c_char,
    SLen: ::libc::size_t,
) -> LLVMMetadataRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMContextRef,
                    *const ::libc::c_char,
                    ::libc::size_t,
                ) -> LLVMMetadataRef,
            >(stringify!(LLVMMDStringInContext2).as_bytes())
    }
        .expect(stringify!(LLVMMDStringInContext2));
    entry(C, Str, SLen)
}
#[no_mangle]
pub extern "C" fn LLVMFunctionType(
    ReturnType: LLVMTypeRef,
    ParamTypes: *mut LLVMTypeRef,
    ParamCount: ::libc::c_uint,
    IsVarArg: LLVMBool,
) -> LLVMTypeRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMTypeRef,
                    *mut LLVMTypeRef,
                    ::libc::c_uint,
                    LLVMBool,
                ) -> LLVMTypeRef,
            >(stringify!(LLVMFunctionType).as_bytes())
    }
        .expect(stringify!(LLVMFunctionType));
    entry(ReturnType, ParamTypes, ParamCount, IsVarArg)
}
#[no_mangle]
pub extern "C" fn LLVMIsAGetElementPtrInst(Val: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMIsAGetElementPtrInst).as_bytes())
    }
        .expect(stringify!(LLVMIsAGetElementPtrInst));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn LLVMIsAUnreachableInst(Val: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMIsAUnreachableInst).as_bytes())
    }
        .expect(stringify!(LLVMIsAUnreachableInst));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn LLVMSetInstDebugLocation(Builder: LLVMBuilderRef, Inst: LLVMValueRef) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMBuilderRef, LLVMValueRef),
            >(stringify!(LLVMSetInstDebugLocation).as_bytes())
    }
        .expect(stringify!(LLVMSetInstDebugLocation));
    entry(Builder, Inst)
}
#[no_mangle]
pub extern "C" fn LLVMGetExact(DivOrShrInst: LLVMValueRef) -> LLVMBool {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMBool,
            >(stringify!(LLVMGetExact).as_bytes())
    }
        .expect(stringify!(LLVMGetExact));
    entry(DivOrShrInst)
}
#[no_mangle]
pub extern "C" fn LLVMBuildCallBr(
    B: LLVMBuilderRef,
    Ty: LLVMTypeRef,
    Fn: LLVMValueRef,
    DefaultDest: LLVMBasicBlockRef,
    IndirectDests: *mut LLVMBasicBlockRef,
    NumIndirectDests: ::libc::c_uint,
    Args: *mut LLVMValueRef,
    NumArgs: ::libc::c_uint,
    Bundles: *mut LLVMOperandBundleRef,
    NumBundles: ::libc::c_uint,
    Name: *const ::libc::c_char,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMBuilderRef,
                    LLVMTypeRef,
                    LLVMValueRef,
                    LLVMBasicBlockRef,
                    *mut LLVMBasicBlockRef,
                    ::libc::c_uint,
                    *mut LLVMValueRef,
                    ::libc::c_uint,
                    *mut LLVMOperandBundleRef,
                    ::libc::c_uint,
                    *const ::libc::c_char,
                ) -> LLVMValueRef,
            >(stringify!(LLVMBuildCallBr).as_bytes())
    }
        .expect(stringify!(LLVMBuildCallBr));
    entry(
        B,
        Ty,
        Fn,
        DefaultDest,
        IndirectDests,
        NumIndirectDests,
        Args,
        NumArgs,
        Bundles,
        NumBundles,
        Name,
    )
}
#[no_mangle]
pub extern "C" fn lto_codegen_compile_optimized(
    cg: lto_code_gen_t,
    length: *mut ::libc::size_t,
) -> *mut ::libc::c_void {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(lto_code_gen_t, *mut ::libc::size_t) -> *mut ::libc::c_void,
            >(stringify!(lto_codegen_compile_optimized).as_bytes())
    }
        .expect(stringify!(lto_codegen_compile_optimized));
    entry(cg, length)
}
#[no_mangle]
pub extern "C" fn lto_codegen_set_should_internalize(
    cg: lto_code_gen_t,
    ShouldInternalize: lto_bool_t,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(lto_code_gen_t, lto_bool_t),
            >(stringify!(lto_codegen_set_should_internalize).as_bytes())
    }
        .expect(stringify!(lto_codegen_set_should_internalize));
    entry(cg, ShouldInternalize)
}
#[no_mangle]
pub extern "C" fn LLVMOrcDisposeObjectLayer(ObjLayer: LLVMOrcObjectLayerRef) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMOrcObjectLayerRef),
            >(stringify!(LLVMOrcDisposeObjectLayer).as_bytes())
    }
        .expect(stringify!(LLVMOrcDisposeObjectLayer));
    entry(ObjLayer)
}
#[no_mangle]
pub extern "C" fn LLVMInitializeWebAssemblyTarget() {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(),
            >(stringify!(LLVMInitializeWebAssemblyTarget).as_bytes())
    }
        .expect(stringify!(LLVMInitializeWebAssemblyTarget));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMBuildRetVoid(arg1: LLVMBuilderRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMBuilderRef) -> LLVMValueRef,
            >(stringify!(LLVMBuildRetVoid).as_bytes())
    }
        .expect(stringify!(LLVMBuildRetVoid));
    entry(arg1)
}
#[no_mangle]
pub extern "C" fn LLVMSetCurrentDebugLocation2(
    Builder: LLVMBuilderRef,
    Loc: LLVMMetadataRef,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMBuilderRef, LLVMMetadataRef),
            >(stringify!(LLVMSetCurrentDebugLocation2).as_bytes())
    }
        .expect(stringify!(LLVMSetCurrentDebugLocation2));
    entry(Builder, Loc)
}
#[no_mangle]
pub extern "C" fn LLVMBuildFNeg(
    arg1: LLVMBuilderRef,
    V: LLVMValueRef,
    Name: *const ::libc::c_char,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMBuilderRef,
                    LLVMValueRef,
                    *const ::libc::c_char,
                ) -> LLVMValueRef,
            >(stringify!(LLVMBuildFNeg).as_bytes())
    }
        .expect(stringify!(LLVMBuildFNeg));
    entry(arg1, V, Name)
}
#[no_mangle]
pub extern "C" fn LLVMIsEnumAttribute(A: LLVMAttributeRef) -> LLVMBool {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMAttributeRef) -> LLVMBool,
            >(stringify!(LLVMIsEnumAttribute).as_bytes())
    }
        .expect(stringify!(LLVMIsEnumAttribute));
    entry(A)
}
#[no_mangle]
pub extern "C" fn thinlto_codegen_set_savetemps_dir(
    cg: thinlto_code_gen_t,
    save_temps_dir: *const ::libc::c_char,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(thinlto_code_gen_t, *const ::libc::c_char),
            >(stringify!(thinlto_codegen_set_savetemps_dir).as_bytes())
    }
        .expect(stringify!(thinlto_codegen_set_savetemps_dir));
    entry(cg, save_temps_dir)
}
#[no_mangle]
pub extern "C" fn LLVMGetNumContainedTypes(Tp: LLVMTypeRef) -> ::libc::c_uint {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMTypeRef) -> ::libc::c_uint,
            >(stringify!(LLVMGetNumContainedTypes).as_bytes())
    }
        .expect(stringify!(LLVMGetNumContainedTypes));
    entry(Tp)
}
#[no_mangle]
pub extern "C" fn LLVMInitializeSystemZAsmParser() {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(),
            >(stringify!(LLVMInitializeSystemZAsmParser).as_bytes())
    }
        .expect(stringify!(LLVMInitializeSystemZAsmParser));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMGetTargetMachineTarget(T: LLVMTargetMachineRef) -> LLVMTargetRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMTargetMachineRef) -> LLVMTargetRef,
            >(stringify!(LLVMGetTargetMachineTarget).as_bytes())
    }
        .expect(stringify!(LLVMGetTargetMachineTarget));
    entry(T)
}
#[no_mangle]
pub extern "C" fn LLVMGetNumMaskElements(
    ShuffleVectorInst: LLVMValueRef,
) -> ::libc::c_uint {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> ::libc::c_uint,
            >(stringify!(LLVMGetNumMaskElements).as_bytes())
    }
        .expect(stringify!(LLVMGetNumMaskElements));
    entry(ShuffleVectorInst)
}
#[no_mangle]
pub extern "C" fn LLVMAddCase(
    Switch: LLVMValueRef,
    OnVal: LLVMValueRef,
    Dest: LLVMBasicBlockRef,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, LLVMValueRef, LLVMBasicBlockRef),
            >(stringify!(LLVMAddCase).as_bytes())
    }
        .expect(stringify!(LLVMAddCase));
    entry(Switch, OnVal, Dest)
}
#[no_mangle]
pub extern "C" fn lto_codegen_set_should_embed_uselists(
    cg: lto_code_gen_t,
    ShouldEmbedUselists: lto_bool_t,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(lto_code_gen_t, lto_bool_t),
            >(stringify!(lto_codegen_set_should_embed_uselists).as_bytes())
    }
        .expect(stringify!(lto_codegen_set_should_embed_uselists));
    entry(cg, ShouldEmbedUselists)
}
#[no_mangle]
pub extern "C" fn LLVMGetRelocationType(RI: LLVMRelocationIteratorRef) -> u64 {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMRelocationIteratorRef) -> u64,
            >(stringify!(LLVMGetRelocationType).as_bytes())
    }
        .expect(stringify!(LLVMGetRelocationType));
    entry(RI)
}
#[no_mangle]
pub extern "C" fn LLVMPassBuilderOptionsSetAAPipeline(
    Options: LLVMPassBuilderOptionsRef,
    AAPipeline: *const ::libc::c_char,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMPassBuilderOptionsRef, *const ::libc::c_char),
            >(stringify!(LLVMPassBuilderOptionsSetAAPipeline).as_bytes())
    }
        .expect(stringify!(LLVMPassBuilderOptionsSetAAPipeline));
    entry(Options, AAPipeline)
}
#[no_mangle]
pub extern "C" fn LLVMCreateGDBRegistrationListener() -> LLVMJITEventListenerRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn() -> LLVMJITEventListenerRef,
            >(stringify!(LLVMCreateGDBRegistrationListener).as_bytes())
    }
        .expect(stringify!(LLVMCreateGDBRegistrationListener));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMOrcCreateNewThreadSafeModule(
    M: LLVMModuleRef,
    TSCtx: LLVMOrcThreadSafeContextRef,
) -> LLVMOrcThreadSafeModuleRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMModuleRef,
                    LLVMOrcThreadSafeContextRef,
                ) -> LLVMOrcThreadSafeModuleRef,
            >(stringify!(LLVMOrcCreateNewThreadSafeModule).as_bytes())
    }
        .expect(stringify!(LLVMOrcCreateNewThreadSafeModule));
    entry(M, TSCtx)
}
#[no_mangle]
pub extern "C" fn LLVMDISubprogramGetLine(
    Subprogram: LLVMMetadataRef,
) -> ::libc::c_uint {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMMetadataRef) -> ::libc::c_uint,
            >(stringify!(LLVMDISubprogramGetLine).as_bytes())
    }
        .expect(stringify!(LLVMDISubprogramGetLine));
    entry(Subprogram)
}
#[no_mangle]
pub extern "C" fn LLVMAddDestination(IndirectBr: LLVMValueRef, Dest: LLVMBasicBlockRef) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, LLVMBasicBlockRef),
            >(stringify!(LLVMAddDestination).as_bytes())
    }
        .expect(stringify!(LLVMAddDestination));
    entry(IndirectBr, Dest)
}
#[no_mangle]
pub extern "C" fn LLVMInitializeFunctionPassManager(
    FPM: LLVMPassManagerRef,
) -> LLVMBool {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMPassManagerRef) -> LLVMBool,
            >(stringify!(LLVMInitializeFunctionPassManager).as_bytes())
    }
        .expect(stringify!(LLVMInitializeFunctionPassManager));
    entry(FPM)
}
#[no_mangle]
pub extern "C" fn LLVMBasicBlockAsValue(BB: LLVMBasicBlockRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMBasicBlockRef) -> LLVMValueRef,
            >(stringify!(LLVMBasicBlockAsValue).as_bytes())
    }
        .expect(stringify!(LLVMBasicBlockAsValue));
    entry(BB)
}
#[no_mangle]
pub extern "C" fn LLVMIsATerminatorInst(Inst: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMIsATerminatorInst).as_bytes())
    }
        .expect(stringify!(LLVMIsATerminatorInst));
    entry(Inst)
}
#[no_mangle]
pub extern "C" fn LLVMGetPreviousGlobal(GlobalVar: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMGetPreviousGlobal).as_bytes())
    }
        .expect(stringify!(LLVMGetPreviousGlobal));
    entry(GlobalVar)
}
#[no_mangle]
pub extern "C" fn LLVMGetMDNodeOperands(V: LLVMValueRef, Dest: *mut LLVMValueRef) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, *mut LLVMValueRef),
            >(stringify!(LLVMGetMDNodeOperands).as_bytes())
    }
        .expect(stringify!(LLVMGetMDNodeOperands));
    entry(V, Dest)
}
#[no_mangle]
pub extern "C" fn LLVMSetSwitchCaseValue(
    SwitchInstr: LLVMValueRef,
    i: ::libc::c_uint,
    CaseValue: LLVMValueRef,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, ::libc::c_uint, LLVMValueRef),
            >(stringify!(LLVMSetSwitchCaseValue).as_bytes())
    }
        .expect(stringify!(LLVMSetSwitchCaseValue));
    entry(SwitchInstr, i, CaseValue)
}
#[no_mangle]
pub extern "C" fn LLVMBuildExactSDiv(
    arg1: LLVMBuilderRef,
    LHS: LLVMValueRef,
    RHS: LLVMValueRef,
    Name: *const ::libc::c_char,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMBuilderRef,
                    LLVMValueRef,
                    LLVMValueRef,
                    *const ::libc::c_char,
                ) -> LLVMValueRef,
            >(stringify!(LLVMBuildExactSDiv).as_bytes())
    }
        .expect(stringify!(LLVMBuildExactSDiv));
    entry(arg1, LHS, RHS, Name)
}
#[no_mangle]
pub extern "C" fn LLVMBuildSExt(
    arg1: LLVMBuilderRef,
    Val: LLVMValueRef,
    DestTy: LLVMTypeRef,
    Name: *const ::libc::c_char,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMBuilderRef,
                    LLVMValueRef,
                    LLVMTypeRef,
                    *const ::libc::c_char,
                ) -> LLVMValueRef,
            >(stringify!(LLVMBuildSExt).as_bytes())
    }
        .expect(stringify!(LLVMBuildSExt));
    entry(arg1, Val, DestTy, Name)
}
#[no_mangle]
pub extern "C" fn LLVMInitializeARMAsmPrinter() {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<extern "C" fn()>(stringify!(LLVMInitializeARMAsmPrinter).as_bytes())
    }
        .expect(stringify!(LLVMInitializeARMAsmPrinter));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMInitializeAArch64AsmPrinter() {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(),
            >(stringify!(LLVMInitializeAArch64AsmPrinter).as_bytes())
    }
        .expect(stringify!(LLVMInitializeAArch64AsmPrinter));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMGetTypeAttributeValue(A: LLVMAttributeRef) -> LLVMTypeRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMAttributeRef) -> LLVMTypeRef,
            >(stringify!(LLVMGetTypeAttributeValue).as_bytes())
    }
        .expect(stringify!(LLVMGetTypeAttributeValue));
    entry(A)
}
#[no_mangle]
pub extern "C" fn LLVMConstAddrSpaceCast(
    ConstantVal: LLVMValueRef,
    ToType: LLVMTypeRef,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, LLVMTypeRef) -> LLVMValueRef,
            >(stringify!(LLVMConstAddrSpaceCast).as_bytes())
    }
        .expect(stringify!(LLVMConstAddrSpaceCast));
    entry(ConstantVal, ToType)
}
#[no_mangle]
pub extern "C" fn LLVMInitializeARMTargetInfo() {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<extern "C" fn()>(stringify!(LLVMInitializeARMTargetInfo).as_bytes())
    }
        .expect(stringify!(LLVMInitializeARMTargetInfo));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMBuildCatchRet(
    B: LLVMBuilderRef,
    CatchPad: LLVMValueRef,
    BB: LLVMBasicBlockRef,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMBuilderRef,
                    LLVMValueRef,
                    LLVMBasicBlockRef,
                ) -> LLVMValueRef,
            >(stringify!(LLVMBuildCatchRet).as_bytes())
    }
        .expect(stringify!(LLVMBuildCatchRet));
    entry(B, CatchPad, BB)
}
#[no_mangle]
pub extern "C" fn LLVMGetDebugLocFilename(
    Val: LLVMValueRef,
    Length: *mut ::libc::c_uint,
) -> *const ::libc::c_char {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, *mut ::libc::c_uint) -> *const ::libc::c_char,
            >(stringify!(LLVMGetDebugLocFilename).as_bytes())
    }
        .expect(stringify!(LLVMGetDebugLocFilename));
    entry(Val, Length)
}
#[no_mangle]
pub extern "C" fn LLVMConstExtractElement(
    VectorConstant: LLVMValueRef,
    IndexConstant: LLVMValueRef,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMConstExtractElement).as_bytes())
    }
        .expect(stringify!(LLVMConstExtractElement));
    entry(VectorConstant, IndexConstant)
}
#[no_mangle]
pub extern "C" fn LLVMIsAFPExtInst(Val: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMIsAFPExtInst).as_bytes())
    }
        .expect(stringify!(LLVMIsAFPExtInst));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn LLVMInitializeRISCVTarget() {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<extern "C" fn()>(stringify!(LLVMInitializeRISCVTarget).as_bytes())
    }
        .expect(stringify!(LLVMInitializeRISCVTarget));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMGetMetadataKind(Metadata: LLVMMetadataRef) -> LLVMMetadataKind {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMMetadataRef) -> LLVMMetadataKind,
            >(stringify!(LLVMGetMetadataKind).as_bytes())
    }
        .expect(stringify!(LLVMGetMetadataKind));
    entry(Metadata)
}
#[no_mangle]
pub extern "C" fn LLVMInitializeHexagonTarget() {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<extern "C" fn()>(stringify!(LLVMInitializeHexagonTarget).as_bytes())
    }
        .expect(stringify!(LLVMInitializeHexagonTarget));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMGetICmpSameSign(Inst: LLVMValueRef) -> LLVMBool {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMBool,
            >(stringify!(LLVMGetICmpSameSign).as_bytes())
    }
        .expect(stringify!(LLVMGetICmpSameSign));
    entry(Inst)
}
#[no_mangle]
pub extern "C" fn LLVMSetInstructionCallConv(Instr: LLVMValueRef, CC: ::libc::c_uint) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, ::libc::c_uint),
            >(stringify!(LLVMSetInstructionCallConv).as_bytes())
    }
        .expect(stringify!(LLVMSetInstructionCallConv));
    entry(Instr, CC)
}
#[no_mangle]
pub extern "C" fn LLVMSetNNeg(NonNegInst: LLVMValueRef, IsNonNeg: LLVMBool) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, LLVMBool),
            >(stringify!(LLVMSetNNeg).as_bytes())
    }
        .expect(stringify!(LLVMSetNNeg));
    entry(NonNegInst, IsNonNeg)
}
#[no_mangle]
pub extern "C" fn LLVMDITypeGetOffsetInBits(DType: LLVMMetadataRef) -> u64 {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMMetadataRef) -> u64,
            >(stringify!(LLVMDITypeGetOffsetInBits).as_bytes())
    }
        .expect(stringify!(LLVMDITypeGetOffsetInBits));
    entry(DType)
}
#[no_mangle]
pub extern "C" fn LLVMCreateMemoryBufferWithMemoryRangeCopy(
    InputData: *const ::libc::c_char,
    InputDataLength: ::libc::size_t,
    BufferName: *const ::libc::c_char,
) -> LLVMMemoryBufferRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    *const ::libc::c_char,
                    ::libc::size_t,
                    *const ::libc::c_char,
                ) -> LLVMMemoryBufferRef,
            >(stringify!(LLVMCreateMemoryBufferWithMemoryRangeCopy).as_bytes())
    }
        .expect(stringify!(LLVMCreateMemoryBufferWithMemoryRangeCopy));
    entry(InputData, InputDataLength, BufferName)
}
#[no_mangle]
pub extern "C" fn lto_codegen_set_assembler_args(
    cg: lto_code_gen_t,
    args: *mut *const ::libc::c_char,
    nargs: ::libc::c_int,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(lto_code_gen_t, *mut *const ::libc::c_char, ::libc::c_int),
            >(stringify!(lto_codegen_set_assembler_args).as_bytes())
    }
        .expect(stringify!(lto_codegen_set_assembler_args));
    entry(cg, args, nargs)
}
#[no_mangle]
pub extern "C" fn LLVMGetDataLayoutStr(M: LLVMModuleRef) -> *const ::libc::c_char {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMModuleRef) -> *const ::libc::c_char,
            >(stringify!(LLVMGetDataLayoutStr).as_bytes())
    }
        .expect(stringify!(LLVMGetDataLayoutStr));
    entry(M)
}
#[no_mangle]
pub extern "C" fn LLVMSetTargetMachineFastISel(
    T: LLVMTargetMachineRef,
    Enable: LLVMBool,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMTargetMachineRef, LLVMBool),
            >(stringify!(LLVMSetTargetMachineFastISel).as_bytes())
    }
        .expect(stringify!(LLVMSetTargetMachineFastISel));
    entry(T, Enable)
}
#[no_mangle]
pub extern "C" fn LLVMGetDiagInfoSeverity(
    DI: LLVMDiagnosticInfoRef,
) -> LLVMDiagnosticSeverity {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMDiagnosticInfoRef) -> LLVMDiagnosticSeverity,
            >(stringify!(LLVMGetDiagInfoSeverity).as_bytes())
    }
        .expect(stringify!(LLVMGetDiagInfoSeverity));
    entry(DI)
}
#[no_mangle]
pub extern "C" fn LLVMGetFirstNamedMetadata(M: LLVMModuleRef) -> LLVMNamedMDNodeRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMModuleRef) -> LLVMNamedMDNodeRef,
            >(stringify!(LLVMGetFirstNamedMetadata).as_bytes())
    }
        .expect(stringify!(LLVMGetFirstNamedMetadata));
    entry(M)
}
#[no_mangle]
pub extern "C" fn LLVMGetVolatile(Inst: LLVMValueRef) -> LLVMBool {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMBool,
            >(stringify!(LLVMGetVolatile).as_bytes())
    }
        .expect(stringify!(LLVMGetVolatile));
    entry(Inst)
}
#[no_mangle]
pub extern "C" fn LLVMMoveBasicBlockAfter(
    BB: LLVMBasicBlockRef,
    MovePos: LLVMBasicBlockRef,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMBasicBlockRef, LLVMBasicBlockRef),
            >(stringify!(LLVMMoveBasicBlockAfter).as_bytes())
    }
        .expect(stringify!(LLVMMoveBasicBlockAfter));
    entry(BB, MovePos)
}
#[no_mangle]
pub extern "C" fn LLVMIsAMemCpyInst(Val: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMIsAMemCpyInst).as_bytes())
    }
        .expect(stringify!(LLVMIsAMemCpyInst));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn LLVMSetValueName(Val: LLVMValueRef, Name: *const ::libc::c_char) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, *const ::libc::c_char),
            >(stringify!(LLVMSetValueName).as_bytes())
    }
        .expect(stringify!(LLVMSetValueName));
    entry(Val, Name)
}
#[no_mangle]
pub extern "C" fn LLVMBuildUDiv(
    arg1: LLVMBuilderRef,
    LHS: LLVMValueRef,
    RHS: LLVMValueRef,
    Name: *const ::libc::c_char,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMBuilderRef,
                    LLVMValueRef,
                    LLVMValueRef,
                    *const ::libc::c_char,
                ) -> LLVMValueRef,
            >(stringify!(LLVMBuildUDiv).as_bytes())
    }
        .expect(stringify!(LLVMBuildUDiv));
    entry(arg1, LHS, RHS, Name)
}
#[no_mangle]
pub extern "C" fn LLVMDisposePassManager(PM: LLVMPassManagerRef) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMPassManagerRef),
            >(stringify!(LLVMDisposePassManager).as_bytes())
    }
        .expect(stringify!(LLVMDisposePassManager));
    entry(PM)
}
#[no_mangle]
pub extern "C" fn LLVMHasUnnamedAddr(Global: LLVMValueRef) -> LLVMBool {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMBool,
            >(stringify!(LLVMHasUnnamedAddr).as_bytes())
    }
        .expect(stringify!(LLVMHasUnnamedAddr));
    entry(Global)
}
#[no_mangle]
pub extern "C" fn LLVMBuildMalloc(
    arg1: LLVMBuilderRef,
    Ty: LLVMTypeRef,
    Name: *const ::libc::c_char,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMBuilderRef,
                    LLVMTypeRef,
                    *const ::libc::c_char,
                ) -> LLVMValueRef,
            >(stringify!(LLVMBuildMalloc).as_bytes())
    }
        .expect(stringify!(LLVMBuildMalloc));
    entry(arg1, Ty, Name)
}
#[no_mangle]
pub extern "C" fn LLVMBuildIsNotNull(
    arg1: LLVMBuilderRef,
    Val: LLVMValueRef,
    Name: *const ::libc::c_char,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMBuilderRef,
                    LLVMValueRef,
                    *const ::libc::c_char,
                ) -> LLVMValueRef,
            >(stringify!(LLVMBuildIsNotNull).as_bytes())
    }
        .expect(stringify!(LLVMBuildIsNotNull));
    entry(arg1, Val, Name)
}
#[no_mangle]
pub extern "C" fn LLVMBuildNSWAdd(
    arg1: LLVMBuilderRef,
    LHS: LLVMValueRef,
    RHS: LLVMValueRef,
    Name: *const ::libc::c_char,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMBuilderRef,
                    LLVMValueRef,
                    LLVMValueRef,
                    *const ::libc::c_char,
                ) -> LLVMValueRef,
            >(stringify!(LLVMBuildNSWAdd).as_bytes())
    }
        .expect(stringify!(LLVMBuildNSWAdd));
    entry(arg1, LHS, RHS, Name)
}
#[no_mangle]
pub extern "C" fn LLVMBuildLoad2(
    arg1: LLVMBuilderRef,
    Ty: LLVMTypeRef,
    PointerVal: LLVMValueRef,
    Name: *const ::libc::c_char,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMBuilderRef,
                    LLVMTypeRef,
                    LLVMValueRef,
                    *const ::libc::c_char,
                ) -> LLVMValueRef,
            >(stringify!(LLVMBuildLoad2).as_bytes())
    }
        .expect(stringify!(LLVMBuildLoad2));
    entry(arg1, Ty, PointerVal, Name)
}
#[no_mangle]
pub extern "C" fn LLVMRemarkDebugLocGetSourceLine(DL: LLVMRemarkDebugLocRef) -> u32 {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMRemarkDebugLocRef) -> u32,
            >(stringify!(LLVMRemarkDebugLocGetSourceLine).as_bytes())
    }
        .expect(stringify!(LLVMRemarkDebugLocGetSourceLine));
    entry(DL)
}
#[no_mangle]
pub extern "C" fn LLVMGetIncomingBlock(
    PhiNode: LLVMValueRef,
    Index: ::libc::c_uint,
) -> LLVMBasicBlockRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, ::libc::c_uint) -> LLVMBasicBlockRef,
            >(stringify!(LLVMGetIncomingBlock).as_bytes())
    }
        .expect(stringify!(LLVMGetIncomingBlock));
    entry(PhiNode, Index)
}
#[no_mangle]
pub extern "C" fn lto_module_get_num_symbols(_mod: lto_module_t) -> ::libc::c_uint {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(lto_module_t) -> ::libc::c_uint,
            >(stringify!(lto_module_get_num_symbols).as_bytes())
    }
        .expect(stringify!(lto_module_get_num_symbols));
    entry(_mod)
}
#[no_mangle]
pub extern "C" fn LLVMDIBuilderCreateNullPtrType(
    Builder: LLVMDIBuilderRef,
) -> LLVMMetadataRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMDIBuilderRef) -> LLVMMetadataRef,
            >(stringify!(LLVMDIBuilderCreateNullPtrType).as_bytes())
    }
        .expect(stringify!(LLVMDIBuilderCreateNullPtrType));
    entry(Builder)
}
#[no_mangle]
pub extern "C" fn LLVMBuildUIToFP(
    arg1: LLVMBuilderRef,
    Val: LLVMValueRef,
    DestTy: LLVMTypeRef,
    Name: *const ::libc::c_char,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMBuilderRef,
                    LLVMValueRef,
                    LLVMTypeRef,
                    *const ::libc::c_char,
                ) -> LLVMValueRef,
            >(stringify!(LLVMBuildUIToFP).as_bytes())
    }
        .expect(stringify!(LLVMBuildUIToFP));
    entry(arg1, Val, DestTy, Name)
}
#[no_mangle]
pub extern "C" fn LLVMDIBuilderCreateMacro(
    Builder: LLVMDIBuilderRef,
    ParentMacroFile: LLVMMetadataRef,
    Line: ::libc::c_uint,
    RecordType: LLVMDWARFMacinfoRecordType,
    Name: *const ::libc::c_char,
    NameLen: usize,
    Value: *const ::libc::c_char,
    ValueLen: usize,
) -> LLVMMetadataRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMDIBuilderRef,
                    LLVMMetadataRef,
                    ::libc::c_uint,
                    LLVMDWARFMacinfoRecordType,
                    *const ::libc::c_char,
                    usize,
                    *const ::libc::c_char,
                    usize,
                ) -> LLVMMetadataRef,
            >(stringify!(LLVMDIBuilderCreateMacro).as_bytes())
    }
        .expect(stringify!(LLVMDIBuilderCreateMacro));
    entry(Builder, ParentMacroFile, Line, RecordType, Name, NameLen, Value, ValueLen)
}
#[no_mangle]
pub extern "C" fn LLVMRemarkStringGetData(
    String: LLVMRemarkStringRef,
) -> *const ::libc::c_char {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMRemarkStringRef) -> *const ::libc::c_char,
            >(stringify!(LLVMRemarkStringGetData).as_bytes())
    }
        .expect(stringify!(LLVMRemarkStringGetData));
    entry(String)
}
#[no_mangle]
pub extern "C" fn LLVMBuildFAdd(
    arg1: LLVMBuilderRef,
    LHS: LLVMValueRef,
    RHS: LLVMValueRef,
    Name: *const ::libc::c_char,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMBuilderRef,
                    LLVMValueRef,
                    LLVMValueRef,
                    *const ::libc::c_char,
                ) -> LLVMValueRef,
            >(stringify!(LLVMBuildFAdd).as_bytes())
    }
        .expect(stringify!(LLVMBuildFAdd));
    entry(arg1, LHS, RHS, Name)
}
#[no_mangle]
pub extern "C" fn LLVMInitializePowerPCAsmParser() {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(),
            >(stringify!(LLVMInitializePowerPCAsmParser).as_bytes())
    }
        .expect(stringify!(LLVMInitializePowerPCAsmParser));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMInt64TypeInContext(C: LLVMContextRef) -> LLVMTypeRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMContextRef) -> LLVMTypeRef,
            >(stringify!(LLVMInt64TypeInContext).as_bytes())
    }
        .expect(stringify!(LLVMInt64TypeInContext));
    entry(C)
}
#[no_mangle]
pub extern "C" fn LLVMGetAtomicSyncScopeID(AtomicInst: LLVMValueRef) -> ::libc::c_uint {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> ::libc::c_uint,
            >(stringify!(LLVMGetAtomicSyncScopeID).as_bytes())
    }
        .expect(stringify!(LLVMGetAtomicSyncScopeID));
    entry(AtomicInst)
}
#[no_mangle]
pub extern "C" fn LLVMConstFPFromBits(Ty: LLVMTypeRef, N: *const u64) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMTypeRef, *const u64) -> LLVMValueRef,
            >(stringify!(LLVMConstFPFromBits).as_bytes())
    }
        .expect(stringify!(LLVMConstFPFromBits));
    entry(Ty, N)
}
#[no_mangle]
pub extern "C" fn LLVMBuildFPToUI(
    arg1: LLVMBuilderRef,
    Val: LLVMValueRef,
    DestTy: LLVMTypeRef,
    Name: *const ::libc::c_char,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMBuilderRef,
                    LLVMValueRef,
                    LLVMTypeRef,
                    *const ::libc::c_char,
                ) -> LLVMValueRef,
            >(stringify!(LLVMBuildFPToUI).as_bytes())
    }
        .expect(stringify!(LLVMBuildFPToUI));
    entry(arg1, Val, DestTy, Name)
}
#[no_mangle]
pub extern "C" fn LLVMCreateGenericValueOfInt(
    Ty: LLVMTypeRef,
    N: ::libc::c_ulonglong,
    IsSigned: LLVMBool,
) -> LLVMGenericValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMTypeRef,
                    ::libc::c_ulonglong,
                    LLVMBool,
                ) -> LLVMGenericValueRef,
            >(stringify!(LLVMCreateGenericValueOfInt).as_bytes())
    }
        .expect(stringify!(LLVMCreateGenericValueOfInt));
    entry(Ty, N, IsSigned)
}
#[no_mangle]
pub extern "C" fn LLVMGetConstantPtrAuthKey(PtrAuth: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMGetConstantPtrAuthKey).as_bytes())
    }
        .expect(stringify!(LLVMGetConstantPtrAuthKey));
    entry(PtrAuth)
}
#[no_mangle]
pub extern "C" fn LLVMModuleFlagEntriesGetFlagBehavior(
    Entries: *mut LLVMModuleFlagEntry,
    Index: ::libc::c_uint,
) -> LLVMModuleFlagBehavior {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    *mut LLVMModuleFlagEntry,
                    ::libc::c_uint,
                ) -> LLVMModuleFlagBehavior,
            >(stringify!(LLVMModuleFlagEntriesGetFlagBehavior).as_bytes())
    }
        .expect(stringify!(LLVMModuleFlagEntriesGetFlagBehavior));
    entry(Entries, Index)
}
#[no_mangle]
pub extern "C" fn LLVMOrcLLJITGetObjLinkingLayer(
    J: LLVMOrcLLJITRef,
) -> LLVMOrcObjectLayerRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMOrcLLJITRef) -> LLVMOrcObjectLayerRef,
            >(stringify!(LLVMOrcLLJITGetObjLinkingLayer).as_bytes())
    }
        .expect(stringify!(LLVMOrcLLJITGetObjLinkingLayer));
    entry(J)
}
#[no_mangle]
pub extern "C" fn LLVMHasPrefixData(Fn: LLVMValueRef) -> LLVMBool {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMBool,
            >(stringify!(LLVMHasPrefixData).as_bytes())
    }
        .expect(stringify!(LLVMHasPrefixData));
    entry(Fn)
}
#[no_mangle]
pub extern "C" fn LLVMInitializePowerPCAsmPrinter() {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(),
            >(stringify!(LLVMInitializePowerPCAsmPrinter).as_bytes())
    }
        .expect(stringify!(LLVMInitializePowerPCAsmPrinter));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMGetCallBrNumIndirectDests(CallBr: LLVMValueRef) -> ::libc::c_uint {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> ::libc::c_uint,
            >(stringify!(LLVMGetCallBrNumIndirectDests).as_bytes())
    }
        .expect(stringify!(LLVMGetCallBrNumIndirectDests));
    entry(CallBr)
}
#[no_mangle]
pub extern "C" fn LLVMDIBuilderCreateMemberType(
    Builder: LLVMDIBuilderRef,
    Scope: LLVMMetadataRef,
    Name: *const ::libc::c_char,
    NameLen: ::libc::size_t,
    File: LLVMMetadataRef,
    LineNo: ::libc::c_uint,
    SizeInBits: u64,
    AlignInBits: u32,
    OffsetInBits: u64,
    Flags: LLVMDIFlags,
    Ty: LLVMMetadataRef,
) -> LLVMMetadataRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMDIBuilderRef,
                    LLVMMetadataRef,
                    *const ::libc::c_char,
                    ::libc::size_t,
                    LLVMMetadataRef,
                    ::libc::c_uint,
                    u64,
                    u32,
                    u64,
                    LLVMDIFlags,
                    LLVMMetadataRef,
                ) -> LLVMMetadataRef,
            >(stringify!(LLVMDIBuilderCreateMemberType).as_bytes())
    }
        .expect(stringify!(LLVMDIBuilderCreateMemberType));
    entry(
        Builder,
        Scope,
        Name,
        NameLen,
        File,
        LineNo,
        SizeInBits,
        AlignInBits,
        OffsetInBits,
        Flags,
        Ty,
    )
}
#[no_mangle]
pub extern "C" fn LLVMBuildXor(
    arg1: LLVMBuilderRef,
    LHS: LLVMValueRef,
    RHS: LLVMValueRef,
    Name: *const ::libc::c_char,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMBuilderRef,
                    LLVMValueRef,
                    LLVMValueRef,
                    *const ::libc::c_char,
                ) -> LLVMValueRef,
            >(stringify!(LLVMBuildXor).as_bytes())
    }
        .expect(stringify!(LLVMBuildXor));
    entry(arg1, LHS, RHS, Name)
}
#[no_mangle]
pub extern "C" fn LLVMCreateExecutionEngineForModule(
    OutEE: *mut LLVMExecutionEngineRef,
    M: LLVMModuleRef,
    OutError: *mut *mut ::libc::c_char,
) -> LLVMBool {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    *mut LLVMExecutionEngineRef,
                    LLVMModuleRef,
                    *mut *mut ::libc::c_char,
                ) -> LLVMBool,
            >(stringify!(LLVMCreateExecutionEngineForModule).as_bytes())
    }
        .expect(stringify!(LLVMCreateExecutionEngineForModule));
    entry(OutEE, M, OutError)
}
#[no_mangle]
pub extern "C" fn LLVMPositionBuilder(
    Builder: LLVMBuilderRef,
    Block: LLVMBasicBlockRef,
    Instr: LLVMValueRef,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMBuilderRef, LLVMBasicBlockRef, LLVMValueRef),
            >(stringify!(LLVMPositionBuilder).as_bytes())
    }
        .expect(stringify!(LLVMPositionBuilder));
    entry(Builder, Block, Instr)
}
#[no_mangle]
pub extern "C" fn LLVMOrcDisposeDefinitionGenerator(DG: LLVMOrcDefinitionGeneratorRef) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMOrcDefinitionGeneratorRef),
            >(stringify!(LLVMOrcDisposeDefinitionGenerator).as_bytes())
    }
        .expect(stringify!(LLVMOrcDisposeDefinitionGenerator));
    entry(DG)
}
#[no_mangle]
pub extern "C" fn LLVMGetModuleDebugMetadataVersion(
    Module: LLVMModuleRef,
) -> ::libc::c_uint {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMModuleRef) -> ::libc::c_uint,
            >(stringify!(LLVMGetModuleDebugMetadataVersion).as_bytes())
    }
        .expect(stringify!(LLVMGetModuleDebugMetadataVersion));
    entry(Module)
}
#[no_mangle]
pub extern "C" fn LLVMIsAMemIntrinsic(Val: LLVMValueRef) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> LLVMValueRef,
            >(stringify!(LLVMIsAMemIntrinsic).as_bytes())
    }
        .expect(stringify!(LLVMIsAMemIntrinsic));
    entry(Val)
}
#[no_mangle]
pub extern "C" fn LLVMSetOperand(
    User: LLVMValueRef,
    Index: ::libc::c_uint,
    Val: LLVMValueRef,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, ::libc::c_uint, LLVMValueRef),
            >(stringify!(LLVMSetOperand).as_bytes())
    }
        .expect(stringify!(LLVMSetOperand));
    entry(User, Index, Val)
}
#[no_mangle]
pub extern "C" fn LLVMSetSuccessor(
    Term: LLVMValueRef,
    i: ::libc::c_uint,
    block: LLVMBasicBlockRef,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, ::libc::c_uint, LLVMBasicBlockRef),
            >(stringify!(LLVMSetSuccessor).as_bytes())
    }
        .expect(stringify!(LLVMSetSuccessor));
    entry(Term, i, block)
}
#[no_mangle]
pub extern "C" fn LLVMCreateTargetDataLayout(
    T: LLVMTargetMachineRef,
) -> LLVMTargetDataRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMTargetMachineRef) -> LLVMTargetDataRef,
            >(stringify!(LLVMCreateTargetDataLayout).as_bytes())
    }
        .expect(stringify!(LLVMCreateTargetDataLayout));
    entry(T)
}
#[no_mangle]
pub extern "C" fn LLVMSetCmpXchgSuccessOrdering(
    CmpXchgInst: LLVMValueRef,
    Ordering: LLVMAtomicOrdering,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, LLVMAtomicOrdering),
            >(stringify!(LLVMSetCmpXchgSuccessOrdering).as_bytes())
    }
        .expect(stringify!(LLVMSetCmpXchgSuccessOrdering));
    entry(CmpXchgInst, Ordering)
}
#[no_mangle]
pub extern "C" fn LLVMGetStructName(Ty: LLVMTypeRef) -> *const ::libc::c_char {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMTypeRef) -> *const ::libc::c_char,
            >(stringify!(LLVMGetStructName).as_bytes())
    }
        .expect(stringify!(LLVMGetStructName));
    entry(Ty)
}
#[no_mangle]
pub extern "C" fn LLVMGetInstructionCallConv(Instr: LLVMValueRef) -> ::libc::c_uint {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef) -> ::libc::c_uint,
            >(stringify!(LLVMGetInstructionCallConv).as_bytes())
    }
        .expect(stringify!(LLVMGetInstructionCallConv));
    entry(Instr)
}
#[no_mangle]
pub extern "C" fn LLVMOrcExecutionSessionLookup(
    ES: LLVMOrcExecutionSessionRef,
    K: LLVMOrcLookupKind,
    SearchOrder: LLVMOrcCJITDylibSearchOrder,
    SearchOrderSize: usize,
    Symbols: LLVMOrcCLookupSet,
    SymbolsSize: usize,
    HandleResult: LLVMOrcExecutionSessionLookupHandleResultFunction,
    Ctx: *mut ::libc::c_void,
) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMOrcExecutionSessionRef,
                    LLVMOrcLookupKind,
                    LLVMOrcCJITDylibSearchOrder,
                    usize,
                    LLVMOrcCLookupSet,
                    usize,
                    LLVMOrcExecutionSessionLookupHandleResultFunction,
                    *mut ::libc::c_void,
                ),
            >(stringify!(LLVMOrcExecutionSessionLookup).as_bytes())
    }
        .expect(stringify!(LLVMOrcExecutionSessionLookup));
    entry(ES, K, SearchOrder, SearchOrderSize, Symbols, SymbolsSize, HandleResult, Ctx)
}
#[no_mangle]
pub extern "C" fn LLVMInitializeBPFTarget() {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<extern "C" fn()>(stringify!(LLVMInitializeBPFTarget).as_bytes())
    }
        .expect(stringify!(LLVMInitializeBPFTarget));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMDisposePassBuilderOptions(Options: LLVMPassBuilderOptionsRef) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMPassBuilderOptionsRef),
            >(stringify!(LLVMDisposePassBuilderOptions).as_bytes())
    }
        .expect(stringify!(LLVMDisposePassBuilderOptions));
    entry(Options)
}
#[no_mangle]
pub extern "C" fn LLVMGetArgOperand(
    Funclet: LLVMValueRef,
    i: ::libc::c_uint,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, ::libc::c_uint) -> LLVMValueRef,
            >(stringify!(LLVMGetArgOperand).as_bytes())
    }
        .expect(stringify!(LLVMGetArgOperand));
    entry(Funclet, i)
}
#[no_mangle]
pub extern "C" fn LLVMDIBuilderCreateObjCProperty(
    Builder: LLVMDIBuilderRef,
    Name: *const ::libc::c_char,
    NameLen: ::libc::size_t,
    File: LLVMMetadataRef,
    LineNo: ::libc::c_uint,
    GetterName: *const ::libc::c_char,
    GetterNameLen: ::libc::size_t,
    SetterName: *const ::libc::c_char,
    SetterNameLen: ::libc::size_t,
    PropertyAttributes: ::libc::c_uint,
    Ty: LLVMMetadataRef,
) -> LLVMMetadataRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMDIBuilderRef,
                    *const ::libc::c_char,
                    ::libc::size_t,
                    LLVMMetadataRef,
                    ::libc::c_uint,
                    *const ::libc::c_char,
                    ::libc::size_t,
                    *const ::libc::c_char,
                    ::libc::size_t,
                    ::libc::c_uint,
                    LLVMMetadataRef,
                ) -> LLVMMetadataRef,
            >(stringify!(LLVMDIBuilderCreateObjCProperty).as_bytes())
    }
        .expect(stringify!(LLVMDIBuilderCreateObjCProperty));
    entry(
        Builder,
        Name,
        NameLen,
        File,
        LineNo,
        GetterName,
        GetterNameLen,
        SetterName,
        SetterNameLen,
        PropertyAttributes,
        Ty,
    )
}
#[no_mangle]
pub extern "C" fn LLVMDIBuilderCreateMemberPointerType(
    Builder: LLVMDIBuilderRef,
    PointeeType: LLVMMetadataRef,
    ClassType: LLVMMetadataRef,
    SizeInBits: u64,
    AlignInBits: u32,
    Flags: LLVMDIFlags,
) -> LLVMMetadataRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMDIBuilderRef,
                    LLVMMetadataRef,
                    LLVMMetadataRef,
                    u64,
                    u32,
                    LLVMDIFlags,
                ) -> LLVMMetadataRef,
            >(stringify!(LLVMDIBuilderCreateMemberPointerType).as_bytes())
    }
        .expect(stringify!(LLVMDIBuilderCreateMemberPointerType));
    entry(Builder, PointeeType, ClassType, SizeInBits, AlignInBits, Flags)
}
#[no_mangle]
pub extern "C" fn LLVMX86AMXType() -> LLVMTypeRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<extern "C" fn() -> LLVMTypeRef>(stringify!(LLVMX86AMXType).as_bytes())
    }
        .expect(stringify!(LLVMX86AMXType));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMDIBuilderCreateLexicalBlock(
    Builder: LLVMDIBuilderRef,
    Scope: LLVMMetadataRef,
    File: LLVMMetadataRef,
    Line: ::libc::c_uint,
    Column: ::libc::c_uint,
) -> LLVMMetadataRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMDIBuilderRef,
                    LLVMMetadataRef,
                    LLVMMetadataRef,
                    ::libc::c_uint,
                    ::libc::c_uint,
                ) -> LLVMMetadataRef,
            >(stringify!(LLVMDIBuilderCreateLexicalBlock).as_bytes())
    }
        .expect(stringify!(LLVMDIBuilderCreateLexicalBlock));
    entry(Builder, Scope, File, Line, Column)
}
#[no_mangle]
pub extern "C" fn LLVMSetICmpSameSign(Inst: LLVMValueRef, SameSign: LLVMBool) {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMValueRef, LLVMBool),
            >(stringify!(LLVMSetICmpSameSign).as_bytes())
    }
        .expect(stringify!(LLVMSetICmpSameSign));
    entry(Inst, SameSign)
}
#[no_mangle]
pub extern "C" fn LLVMBuildNUWNeg(
    B: LLVMBuilderRef,
    V: LLVMValueRef,
    Name: *const ::libc::c_char,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMBuilderRef,
                    LLVMValueRef,
                    *const ::libc::c_char,
                ) -> LLVMValueRef,
            >(stringify!(LLVMBuildNUWNeg).as_bytes())
    }
        .expect(stringify!(LLVMBuildNUWNeg));
    entry(B, V, Name)
}
#[no_mangle]
pub extern "C" fn LLVMOrcMaterializationResponsibilityGetInitializerSymbol(
    MR: LLVMOrcMaterializationResponsibilityRef,
) -> LLVMOrcSymbolStringPoolEntryRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMOrcMaterializationResponsibilityRef,
                ) -> LLVMOrcSymbolStringPoolEntryRef,
            >(
                stringify!(LLVMOrcMaterializationResponsibilityGetInitializerSymbol)
                    .as_bytes(),
            )
    }
        .expect(stringify!(LLVMOrcMaterializationResponsibilityGetInitializerSymbol));
    entry(MR)
}
#[no_mangle]
pub extern "C" fn LLVMBuildIsNull(
    arg1: LLVMBuilderRef,
    Val: LLVMValueRef,
    Name: *const ::libc::c_char,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMBuilderRef,
                    LLVMValueRef,
                    *const ::libc::c_char,
                ) -> LLVMValueRef,
            >(stringify!(LLVMBuildIsNull).as_bytes())
    }
        .expect(stringify!(LLVMBuildIsNull));
    entry(arg1, Val, Name)
}
#[no_mangle]
pub extern "C" fn LLVMGetErrorTypeId(Error: LLVMErrorRef) -> LLVMErrorTypeId {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMErrorRef) -> LLVMErrorTypeId,
            >(stringify!(LLVMGetErrorTypeId).as_bytes())
    }
        .expect(stringify!(LLVMGetErrorTypeId));
    entry(Error)
}
#[no_mangle]
pub extern "C" fn LLVMInitializeSparcDisassembler() {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(),
            >(stringify!(LLVMInitializeSparcDisassembler).as_bytes())
    }
        .expect(stringify!(LLVMInitializeSparcDisassembler));
    entry()
}
#[no_mangle]
pub extern "C" fn LLVMBuildFPCast(
    arg1: LLVMBuilderRef,
    Val: LLVMValueRef,
    DestTy: LLVMTypeRef,
    Name: *const ::libc::c_char,
) -> LLVMValueRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMBuilderRef,
                    LLVMValueRef,
                    LLVMTypeRef,
                    *const ::libc::c_char,
                ) -> LLVMValueRef,
            >(stringify!(LLVMBuildFPCast).as_bytes())
    }
        .expect(stringify!(LLVMBuildFPCast));
    entry(arg1, Val, DestTy, Name)
}
#[no_mangle]
pub extern "C" fn LLVMOrcLLJITAddObjectFile(
    J: LLVMOrcLLJITRef,
    JD: LLVMOrcJITDylibRef,
    ObjBuffer: LLVMMemoryBufferRef,
) -> LLVMErrorRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMOrcLLJITRef,
                    LLVMOrcJITDylibRef,
                    LLVMMemoryBufferRef,
                ) -> LLVMErrorRef,
            >(stringify!(LLVMOrcLLJITAddObjectFile).as_bytes())
    }
        .expect(stringify!(LLVMOrcLLJITAddObjectFile));
    entry(J, JD, ObjBuffer)
}
#[no_mangle]
pub extern "C" fn LLVMInt128TypeInContext(C: LLVMContextRef) -> LLVMTypeRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMContextRef) -> LLVMTypeRef,
            >(stringify!(LLVMInt128TypeInContext).as_bytes())
    }
        .expect(stringify!(LLVMInt128TypeInContext));
    entry(C)
}
#[no_mangle]
pub extern "C" fn LLVMRemarkArgGetValue(Arg: LLVMRemarkArgRef) -> LLVMRemarkStringRef {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(LLVMRemarkArgRef) -> LLVMRemarkStringRef,
            >(stringify!(LLVMRemarkArgGetValue).as_bytes())
    }
        .expect(stringify!(LLVMRemarkArgGetValue));
    entry(Arg)
}
#[no_mangle]
pub extern "C" fn LLVMGetStringAttributeValue(
    A: LLVMAttributeRef,
    Length: *mut ::libc::c_uint,
) -> *const ::libc::c_char {
    let entry = unsafe {
        crate::proxy::SHARED_LIB
            .get::<
                extern "C" fn(
                    LLVMAttributeRef,
                    *mut ::libc::c_uint,
                ) -> *const ::libc::c_char,
            >(stringify!(LLVMGetStringAttributeValue).as_bytes())
    }
        .expect(stringify!(LLVMGetStringAttributeValue));
    entry(A, Length)
}
