#include <stdint.h>
#include <fcitx/fcitx.h>
#include <fcitx-utils/utils.h>
#include <fcitx/instance.h>
#include <fcitx/addon.h>
#include <fcitx/module.h>


#ifndef __FCITX_MODULE_FCITX_SPELL_ADD_FUNCTION_H
#define __FCITX_MODULE_FCITX_SPELL_ADD_FUNCTION_H

#ifdef __cplusplus
extern "C" {
#endif

DEFINE_GET_ADDON("fcitx-spell", _Spell_)

static void*
__fcitx_Spell_function_HintWords(void *_self, FcitxModuleFunctionArg _args)
{
    FCITX_DEF_CAST_FROM_PTR(FcitxSpell*, __self, _self);
    FCITX_DEF_CAST_FROM_PTR(const char*, arg0, _args.args[0]);
    FCITX_DEF_CAST_FROM_PTR(const char*, arg1, _args.args[1]);
    FCITX_DEF_CAST_FROM_PTR(const char*, arg2, _args.args[2]);
    FCITX_DEF_CAST_FROM_PTR(unsigned int, arg3, _args.args[3]);
    FCITX_DEF_CAST_FROM_PTR(const char*, arg4, _args.args[4]);
    FCITX_DEF_CAST_FROM_PTR(const char*, arg5, _args.args[5]);
    FcitxSpell* self = __self;
    FCITX_UNUSED(self);
    SpellHint* res = (SpellGetSpellHintWords(self, arg0, arg1, arg2, arg3, arg4, arg5));
    FCITX_RETURN_AS_PTR(SpellHint*, res);
}

static void*
__fcitx_Spell_function_AddPersonal(void *_self, FcitxModuleFunctionArg _args)
{
    FCITX_DEF_CAST_FROM_PTR(FcitxSpell*, __self, _self);
    FCITX_DEF_CAST_FROM_PTR(const char*, arg0, _args.args[0]);
    FCITX_DEF_CAST_FROM_PTR(const char*, arg1, _args.args[1]);
    FcitxSpell* self = __self;
    FCITX_UNUSED(self);
    boolean res = (SpellAddPersonal(self, arg0, arg1));
    FCITX_RETURN_AS_PTR(boolean, res);
}

static void*
__fcitx_Spell_function_DictAvailable(void *_self, FcitxModuleFunctionArg _args)
{
    FCITX_DEF_CAST_FROM_PTR(FcitxSpell*, __self, _self);
    FCITX_DEF_CAST_FROM_PTR(const char*, arg0, _args.args[0]);
    FCITX_DEF_CAST_FROM_PTR(const char*, arg1, _args.args[1]);
    FcitxSpell* self = __self;
    FCITX_UNUSED(self);
    boolean res = (FcitxSpellDictAvailable(self, arg0, arg1));
    FCITX_RETURN_AS_PTR(boolean, res);
}

static void*
__fcitx_Spell_function_GetCandWords(void *_self, FcitxModuleFunctionArg _args)
{
    FCITX_DEF_CAST_FROM_PTR(FcitxSpell*, __self, _self);
    FCITX_DEF_CAST_FROM_PTR(const char*, arg0, _args.args[0]);
    FCITX_DEF_CAST_FROM_PTR(const char*, arg1, _args.args[1]);
    FCITX_DEF_CAST_FROM_PTR(const char*, arg2, _args.args[2]);
    FCITX_DEF_CAST_FROM_PTR(unsigned int, arg3, _args.args[3]);
    FCITX_DEF_CAST_FROM_PTR(const char*, arg4, _args.args[4]);
    FCITX_DEF_CAST_FROM_PTR(const char*, arg5, _args.args[5]);
    FCITX_DEF_CAST_FROM_PTR(FcitxSpellGetCandWordCb, arg6, _args.args[6]);
    FCITX_DEF_CAST_FROM_PTR(void*, arg7, _args.args[7]);
    FcitxSpell* self = __self;
    FCITX_UNUSED(self);
    FcitxCandidateWordList* res = (SpellGetCandWords(self, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7));
    FCITX_RETURN_AS_PTR(FcitxCandidateWordList*, res);
}

static void*
__fcitx_Spell_function_CandWordGetCommit(void *_self, FcitxModuleFunctionArg _args)
{
    FCITX_DEF_CAST_FROM_PTR(FcitxSpell*, __self, _self);
    FCITX_DEF_CAST_FROM_PTR(FcitxCandidateWord*, arg0, _args.args[0]);
    FcitxSpell* self = __self;
    FCITX_UNUSED(self);
    const char* res = (FcitxSpellCandWordGetCommit(self, arg0));
    FCITX_RETURN_AS_PTR(const char*, res);
}

static void
FcitxSpellAddFunctions(FcitxInstance *instance)
{
    int i;
    FcitxAddon *addon = Fcitx_Spell_GetAddon(instance);
    static const FcitxModuleFunction ____fcitx_Spell_addon_functions_table[] = {
        __fcitx_Spell_function_HintWords,
        __fcitx_Spell_function_AddPersonal,
        __fcitx_Spell_function_DictAvailable,
        __fcitx_Spell_function_GetCandWords,
        __fcitx_Spell_function_CandWordGetCommit,
    };
    for (i = 0;i < 5;i++) {
        FcitxModuleAddFunction(addon, ____fcitx_Spell_addon_functions_table[i]);
    }
}

#ifdef __cplusplus
}
#endif

#endif
