#include <stdint.h>
#include <fcitx/fcitx.h>
#include <fcitx-utils/utils.h>
#include <fcitx/instance.h>
#include <fcitx/addon.h>
#include <fcitx/module.h>


#ifndef __FCITX_MODULE_FCITX_X11_ADD_FUNCTION_H
#define __FCITX_MODULE_FCITX_X11_ADD_FUNCTION_H

#ifdef __cplusplus
extern "C" {
#endif

DEFINE_GET_ADDON("fcitx-x11", _X11_)

static void*
__fcitx_X11_function_GetDisplay(void *_self, FcitxModuleFunctionArg _args)
{
    FCITX_DEF_CAST_FROM_PTR(FcitxX11*, __self, _self);
    FCITX_UNUSED(_args);
    FcitxX11* self = __self;
    FCITX_UNUSED(self);
    Display* res = ((self)->dpy);
    FCITX_RETURN_AS_PTR(Display*, res);
}

static void*
__fcitx_X11_function_AddXEventHandler(void *_self, FcitxModuleFunctionArg _args)
{
    FCITX_DEF_CAST_FROM_PTR(FcitxX11*, __self, _self);
    FCITX_DEF_CAST_FROM_PTR(FcitxX11XEventHandler, arg0, _args.args[0]);
    FCITX_DEF_CAST_FROM_PTR(void*, arg1, _args.args[1]);
    FcitxX11* self = __self;
    FCITX_UNUSED(self);
    X11AddEventHandler(self, arg0, arg1);
    return NULL;
}

static void*
__fcitx_X11_function_RemoveXEventHandler(void *_self, FcitxModuleFunctionArg _args)
{
    FCITX_DEF_CAST_FROM_PTR(FcitxX11*, __self, _self);
    FCITX_DEF_CAST_FROM_PTR(void*, arg0, _args.args[0]);
    FcitxX11* self = __self;
    FCITX_UNUSED(self);
    X11RemoveEventHandler(self, arg0);
    return NULL;
}

static void*
__fcitx_X11_function_FindARGBVisual(void *_self, FcitxModuleFunctionArg _args)
{
    FCITX_DEF_CAST_FROM_PTR(FcitxX11*, __self, _self);
    FCITX_UNUSED(_args);
    FcitxX11* self = __self;
    FCITX_UNUSED(self);
    Visual* res = (X11FindARGBVisual(self));
    FCITX_RETURN_AS_PTR(Visual*, res);
}

static void*
__fcitx_X11_function_InitWindowAttribute(void *_self, FcitxModuleFunctionArg _args)
{
    FCITX_DEF_CAST_FROM_PTR(FcitxX11*, __self, _self);
    FCITX_DEF_CAST_FROM_PTR(Visual**, arg0, _args.args[0]);
    FCITX_DEF_CAST_FROM_PTR(Colormap*, arg1, _args.args[1]);
    FCITX_DEF_CAST_FROM_PTR(XSetWindowAttributes*, arg2, _args.args[2]);
    FCITX_DEF_CAST_FROM_PTR(unsigned long*, arg3, _args.args[3]);
    FCITX_DEF_CAST_FROM_PTR(int*, arg4, _args.args[4]);
    FcitxX11* self = __self;
    FCITX_UNUSED(self);
    X11InitWindowAttribute(self, arg0, arg1, arg2, arg3, arg4);
    return NULL;
}

static void*
__fcitx_X11_function_SetWindowProp(void *_self, FcitxModuleFunctionArg _args)
{
    FCITX_DEF_CAST_FROM_PTR(FcitxX11*, __self, _self);
    FCITX_DEF_CAST_FROM_PTR(const Window*, _arg0, _args.args[0]);
    FCITX_DEF_CAST_FROM_PTR(const FcitxXWindowType*, _arg1, _args.args[1]);
    FCITX_DEF_CAST_FROM_PTR(char*, arg2, _args.args[2]);
    FcitxX11* self = __self;
    FCITX_UNUSED(self);
    Window arg0 = (*(_arg0));
    FcitxXWindowType arg1 = (*(_arg1));
    X11SetWindowProperty(self, arg0, arg1, arg2);
    return NULL;
}

static void*
__fcitx_X11_function_GetScreenSize(void *_self, FcitxModuleFunctionArg _args)
{
    FCITX_DEF_CAST_FROM_PTR(FcitxX11*, __self, _self);
    FCITX_DEF_CAST_FROM_PTR(int*, arg0, _args.args[0]);
    FCITX_DEF_CAST_FROM_PTR(int*, arg1, _args.args[1]);
    FcitxX11* self = __self;
    FCITX_UNUSED(self);
    X11GetScreenSize(self, arg0, arg1);
    return NULL;
}

static void*
__fcitx_X11_function_MouseClick(void *_self, FcitxModuleFunctionArg _args)
{
    FCITX_DEF_CAST_FROM_PTR(FcitxX11*, __self, _self);
    FCITX_DEF_CAST_FROM_PTR(const Window*, _arg0, _args.args[0]);
    FCITX_DEF_CAST_FROM_PTR(int*, arg1, _args.args[1]);
    FCITX_DEF_CAST_FROM_PTR(int*, arg2, _args.args[2]);
    FCITX_DEF_CAST_FROM_PTR(boolean*, arg3, _args.args[3]);
    FcitxX11* self = __self;
    FCITX_UNUSED(self);
    Window arg0 = (*(_arg0));
    X11MouseClick(self, arg0, arg1, arg2, arg3);
    return NULL;
}

static void*
__fcitx_X11_function_AddCompositeHandler(void *_self, FcitxModuleFunctionArg _args)
{
    FCITX_DEF_CAST_FROM_PTR(FcitxX11*, __self, _self);
    FCITX_DEF_CAST_FROM_PTR(FcitxX11CompositeHandler, arg0, _args.args[0]);
    FCITX_DEF_CAST_FROM_PTR(void*, arg1, _args.args[1]);
    FcitxX11* self = __self;
    FCITX_UNUSED(self);
    X11AddCompositeHandler(self, arg0, arg1);
    return NULL;
}

static void*
__fcitx_X11_function_GetScreenGeometry(void *_self, FcitxModuleFunctionArg _args)
{
    FCITX_DEF_CAST_FROM_PTR(FcitxX11*, __self, _self);
    FCITX_DEF_CAST_FROM_PTR(const int*, _arg0, _args.args[0]);
    FCITX_DEF_CAST_FROM_PTR(const int*, _arg1, _args.args[1]);
    FCITX_DEF_CAST_FROM_PTR(FcitxRect*, arg2, _args.args[2]);
    FcitxX11* self = __self;
    FCITX_UNUSED(self);
    int arg0 = (*(_arg0));
    int arg1 = (*(_arg1));
    X11ScreenGeometry(self, arg0, arg1, arg2);
    return NULL;
}

static void*
__fcitx_X11_function_ProcessRemainEvent(void *_self, FcitxModuleFunctionArg _args)
{
    FCITX_DEF_CAST_FROM_PTR(FcitxX11*, __self, _self);
    FCITX_UNUSED(_args);
    FcitxX11* self = __self;
    FCITX_UNUSED(self);
    X11ProcessEventRealInternal(self);
    return NULL;
}

static void*
__fcitx_X11_function_GetDPI(void *_self, FcitxModuleFunctionArg _args)
{
    FCITX_DEF_CAST_FROM_PTR(FcitxX11*, __self, _self);
    FCITX_DEF_CAST_FROM_PTR(int*, arg0, _args.args[0]);
    FCITX_DEF_CAST_FROM_PTR(double*, arg1, _args.args[1]);
    FcitxX11* self = __self;
    FCITX_UNUSED(self);
    X11GetDPI(self, arg0, arg1);
    return NULL;
}

static void*
__fcitx_X11_function_RegSelectNotify(void *_self, FcitxModuleFunctionArg _args)
{
    FCITX_DEF_CAST_FROM_PTR(FcitxX11*, __self, _self);
    FCITX_DEF_CAST_FROM_PTR(const char*, arg0, _args.args[0]);
    FCITX_DEF_CAST_FROM_PTR(void*, arg1, _args.args[1]);
    FCITX_DEF_CAST_FROM_PTR(X11SelectionNotifyCallback, arg2, _args.args[2]);
    FCITX_DEF_CAST_FROM_PTR(void*, arg3, _args.args[3]);
    FCITX_DEF_CAST_FROM_PTR(FcitxDestroyNotify, arg4, _args.args[4]);
    FcitxX11* self = __self;
    FCITX_UNUSED(self);
    int res = (X11SelectionNotifyRegister(self, arg0, arg1, arg2, arg3, arg4));
    int _res = ((res) + 1);
    FCITX_RETURN_AS_PTR(int, _res);
}

static void*
__fcitx_X11_function_RemoveSelectNotify(void *_self, FcitxModuleFunctionArg _args)
{
    FCITX_DEF_CAST_FROM_PTR(FcitxX11*, __self, _self);
    FCITX_DEF_CAST_FROM_PTR(int, _arg0, _args.args[0]);
    FcitxX11* self = __self;
    FCITX_UNUSED(self);
    int arg0 = ((_arg0) - 1);
    X11SelectionNotifyRemove(self, arg0);
    return NULL;
}

static void*
__fcitx_X11_function_DefaultEventWindow(void *_self, FcitxModuleFunctionArg _args)
{
    FCITX_DEF_CAST_FROM_PTR(FcitxX11*, __self, _self);
    FCITX_UNUSED(_args);
    FcitxX11* self = __self;
    FCITX_UNUSED(self);
    Window res = ((self)->eventWindow);
    FCITX_RETURN_AS_PTR(Window, res);
}

static void*
__fcitx_X11_function_RequestConvertSelect(void *_self, FcitxModuleFunctionArg _args)
{
    FCITX_DEF_CAST_FROM_PTR(FcitxX11*, __self, _self);
    FCITX_DEF_CAST_FROM_PTR(const char*, arg0, _args.args[0]);
    FCITX_DEF_CAST_FROM_PTR(const char*, arg1, _args.args[1]);
    FCITX_DEF_CAST_FROM_PTR(void*, arg2, _args.args[2]);
    FCITX_DEF_CAST_FROM_PTR(X11ConvertSelectionCallback, arg3, _args.args[3]);
    FCITX_DEF_CAST_FROM_PTR(void*, arg4, _args.args[4]);
    FCITX_DEF_CAST_FROM_PTR(FcitxDestroyNotify, arg5, _args.args[5]);
    FcitxX11* self = __self;
    FCITX_UNUSED(self);
    int res = (X11RequestConvertSelection(self, arg0, arg1, arg2, arg3, arg4, arg5));
    int _res = ((res) + 1);
    FCITX_RETURN_AS_PTR(int, _res);
}

static void*
__fcitx_X11_function_RemoveCompositeHandler(void *_self, FcitxModuleFunctionArg _args)
{
    FCITX_DEF_CAST_FROM_PTR(FcitxX11*, __self, _self);
    FCITX_DEF_CAST_FROM_PTR(void*, arg0, _args.args[0]);
    FcitxX11* self = __self;
    FCITX_UNUSED(self);
    X11RemoveCompositeHandler(self, arg0);
    return NULL;
}

static void
FcitxX11AddFunctions(FcitxInstance *instance)
{
    int i;
    FcitxAddon *addon = Fcitx_X11_GetAddon(instance);
    static const FcitxModuleFunction ____fcitx_X11_addon_functions_table[] = {
        __fcitx_X11_function_GetDisplay,
        __fcitx_X11_function_AddXEventHandler,
        __fcitx_X11_function_RemoveXEventHandler,
        __fcitx_X11_function_FindARGBVisual,
        __fcitx_X11_function_InitWindowAttribute,
        __fcitx_X11_function_SetWindowProp,
        __fcitx_X11_function_GetScreenSize,
        __fcitx_X11_function_MouseClick,
        __fcitx_X11_function_AddCompositeHandler,
        __fcitx_X11_function_GetScreenGeometry,
        __fcitx_X11_function_ProcessRemainEvent,
        __fcitx_X11_function_GetDPI,
        __fcitx_X11_function_RegSelectNotify,
        __fcitx_X11_function_RemoveSelectNotify,
        __fcitx_X11_function_DefaultEventWindow,
        __fcitx_X11_function_RequestConvertSelect,
        __fcitx_X11_function_RemoveCompositeHandler,
    };
    for (i = 0;i < 17;i++) {
        FcitxModuleAddFunction(addon, ____fcitx_X11_addon_functions_table[i]);
    }
}

#ifdef __cplusplus
}
#endif

#endif
