// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanTelemetryMetrics_h
#define mozilla_GleanTelemetryMetrics_h

#include "mozilla/JSONStringWriteFuncs.h"
#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace browser_engagement {
  /**
   * generated from browser.engagement.session_time_excluding_suspend
   * The duration of the session in milliseconds, excluding the time the device was suspended. This metric was generated to correspond to the Legacy Telemetry scalar browser.engagement.session_time_excluding_suspend.
   */
  constexpr impl::QuantityMetric session_time_excluding_suspend(38);

  /**
   * generated from browser.engagement.session_time_including_suspend
   * The duration of the session in milliseconds, including the time the device was suspended. This metric was generated to correspond to the Legacy Telemetry scalar browser.engagement.session_time_including_suspend.
   */
  constexpr impl::QuantityMetric session_time_including_suspend(39);
}

namespace browser_timings {
  /**
   * generated from browser.timings.last_shutdown
   * The time, in milliseconds, it took to complete the last shutdown. On successful shutdown, Telemetry saves this to disk into Telemetry.ShutdownTime.txt. On the next startup this is loaded and recorded. This metric was generated to correspond to the Legacy Telemetry scalar browser.timings.last_shutdown.
   */
  constexpr impl::QuantityMetric last_shutdown(46);
}

namespace legacy_telemetry {
  /**
   * generated from legacy.telemetry.client_id
   * The client_id according to Telemetry.
   * Might not always have a value due to being too early for it to have
   * loaded.
   * Value may be the canary client id `c0ffeec0-ffee-c0ff-eec0-ffeec0ffeec0`
   * in pings near when the data upload pref is disabled (if Telemetry gets
   * to go first), or between when a client_id has been removed and when it
   * has been regenerated.
   * Does not need to be sent in the Glean "deletion-request" ping.
   */
  constexpr impl::UuidMetric client_id(5703);

  /**
   * generated from legacy.telemetry.profile_group_id
   * The profile_group_id according to Telemetry.
   * Might not always have a value due to being too early for it to have
   * loaded.
   * Does not need to be sent in the Glean "deletion-request" ping.
   */
  constexpr impl::UuidMetric profile_group_id(5704);

  /**
   * generated from legacy.telemetry.session_id
   * Legacy Telemetry's session identifier.
   * Set near startup and stable until shutdown.
   */
  constexpr impl::UuidMetric session_id(5705);

  /**
   * generated from legacy.telemetry.session_start_date
   * Legacy Telemetry's session start time.
   * The time at which the Telemetry session started.
   * Likely near to the (wall-clock) time that the application started.
   */
  constexpr impl::DatetimeMetric session_start_date(5706);
}

namespace onboarding_opt_out {
  /**
   * generated from onboarding_opt_out.active_experiments
   */
  using ActiveExperimentsObject = nsTArray<nsCString>;
  /**
   * The slugs of the actively enrolled experiments.
   */
  constexpr impl::ObjectMetric<ActiveExperimentsObject, struct ActiveExperimentsObjectTag> active_experiments(5707);

  /**
   * generated from onboarding_opt_out.active_rollouts
   */
  using ActiveRolloutsObject = nsTArray<nsCString>;
  /**
   * The slugs of the actively enrolled rollouts.
   */
  constexpr impl::ObjectMetric<ActiveRolloutsObject, struct ActiveRolloutsObjectTag> active_rollouts(5708);

  /**
   * generated from onboarding_opt_out.enrollments_map
   */

  struct EnrollmentsMapObjectItem {
    Maybe<nsCString> experimentSlug;
    Maybe<nsCString> branchSlug;
  };

  using EnrollmentsMapObject = nsTArray<EnrollmentsMapObjectItem>;
  /**
   * Information about historic enrollments, including the branches enrolled.
   */
  constexpr impl::ObjectMetric<EnrollmentsMapObject, struct EnrollmentsMapObjectTag> enrollments_map(5709);
}

template <>
inline void impl::ObjectMetric<onboarding_opt_out::ActiveExperimentsObject, onboarding_opt_out::ActiveExperimentsObjectTag>::Set(const onboarding_opt_out::ActiveExperimentsObject& aObj) const {
  nsCString json;
  JSONStringRefWriteFunc writeFunc(json);
  JSONWriter writer(writeFunc, JSONWriter::CollectionStyle::SingleLineStyle);

  writer.StartArrayElement();
  {
    for (const auto& aobjItem: aObj) {
      writer.StringElement(aobjItem);

    }
  }
  writer.EndArray();


  SetStr(json);
}

template <>
inline void impl::ObjectMetric<onboarding_opt_out::ActiveRolloutsObject, onboarding_opt_out::ActiveRolloutsObjectTag>::Set(const onboarding_opt_out::ActiveRolloutsObject& aObj) const {
  nsCString json;
  JSONStringRefWriteFunc writeFunc(json);
  JSONWriter writer(writeFunc, JSONWriter::CollectionStyle::SingleLineStyle);

  writer.StartArrayElement();
  {
    for (const auto& aobjItem: aObj) {
      writer.StringElement(aobjItem);

    }
  }
  writer.EndArray();


  SetStr(json);
}

template <>
inline void impl::ObjectMetric<onboarding_opt_out::EnrollmentsMapObject, onboarding_opt_out::EnrollmentsMapObjectTag>::Set(const onboarding_opt_out::EnrollmentsMapObject& aObj) const {
  nsCString json;
  JSONStringRefWriteFunc writeFunc(json);
  JSONWriter writer(writeFunc, JSONWriter::CollectionStyle::SingleLineStyle);

  writer.StartArrayElement();
  {
    for (const auto& aobjItem: aObj) {
      writer.StartObjectElement();
      {
        if (aobjItem.experimentSlug.isSome()) {
          writer.StringProperty("experimentSlug", *(aobjItem.experimentSlug));
        }
        if (aobjItem.branchSlug.isSome()) {
          writer.StringProperty("branchSlug", *(aobjItem.branchSlug));
        }
      }
      writer.EndObject();

    }
  }
  writer.EndArray();


  SetStr(json);
}

namespace startup_io {
  /**
   * generated from startup.io.read
   */
  enum class ReadLabel: uint16_t {
    eSessionrestore = 0,
    eWindowvisible = 1,
    e__Other__,
  };
  /**
   * Windows-only.
   * Cumulative bytes read by the application according to the OS, per startup
   * phase.
   */
  constexpr impl::Labeled<impl::QuantityMetric, ReadLabel> read(5710);

  /**
   * generated from startup.io.write
   */
  enum class WriteLabel: uint16_t {
    eSessionrestore = 0,
    eWindowvisible = 1,
    e__Other__,
  };
  /**
   * Windows-only.
   * Cumulative bytes written by the application according to the OS, per startup
   * phase.
   */
  constexpr impl::Labeled<impl::QuantityMetric, WriteLabel> write(5711);
}

namespace telemetry {
  /**
   * generated from telemetry.archive_checking_over_quota
   * Time (ms) it takes for checking if the archive is over-quota
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram TELEMETRY_ARCHIVE_CHECKING_OVER_QUOTA_MS.
   */
  constexpr impl::TimingDistributionMetric archive_checking_over_quota(5712);

  /**
   * generated from telemetry.archive_directories_count
   * Number of directories in the archive at scan
   * This metric was generated to correspond to the Legacy Telemetry linear histogram TELEMETRY_ARCHIVE_DIRECTORIES_COUNT.
   */
  constexpr impl::CustomDistributionMetric archive_directories_count(5713);

  /**
   * generated from telemetry.archive_evicted_old_dirs
   * Number of Telemetry directories evicted from the archive during cleanup, because they were too old
   * This metric was generated to correspond to the Legacy Telemetry linear histogram TELEMETRY_ARCHIVE_EVICTED_OLD_DIRS.
   */
  constexpr impl::CustomDistributionMetric archive_evicted_old_dirs(5714);

  /**
   * generated from telemetry.archive_evicted_over_quota
   * Number of Telemetry pings evicted from the archive during cleanup, because they were over the quota
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram TELEMETRY_ARCHIVE_EVICTED_OVER_QUOTA.
   */
  constexpr impl::CustomDistributionMetric archive_evicted_over_quota(5715);

  /**
   * generated from telemetry.archive_evicting_dirs
   * Time (ms) it takes for evicting old directories
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram TELEMETRY_ARCHIVE_EVICTING_DIRS_MS.
   */
  constexpr impl::TimingDistributionMetric archive_evicting_dirs(5716);

  /**
   * generated from telemetry.archive_evicting_over_quota
   * Time (ms) it takes for evicting over-quota pings
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram TELEMETRY_ARCHIVE_EVICTING_OVER_QUOTA_MS.
   */
  constexpr impl::TimingDistributionMetric archive_evicting_over_quota(5717);

  /**
   * generated from telemetry.archive_oldest_directory_age
   * The age of the oldest Telemetry archive directory in months
   * This metric was generated to correspond to the Legacy Telemetry linear histogram TELEMETRY_ARCHIVE_OLDEST_DIRECTORY_AGE.
   */
  constexpr impl::CustomDistributionMetric archive_oldest_directory_age(5718);

  /**
   * generated from telemetry.archive_scan_ping_count
   * Number of Telemetry pings in the archive at scan
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram TELEMETRY_ARCHIVE_SCAN_PING_COUNT.
   */
  constexpr impl::CustomDistributionMetric archive_scan_ping_count(5719);

  /**
   * generated from telemetry.archive_session_ping_count
   * Number of Telemetry pings added to the archive during the session
   * This metric was generated to correspond to the Legacy Telemetry count histogram TELEMETRY_ARCHIVE_SESSION_PING_COUNT.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> archive_session_ping_count(5720);

  /**
   * generated from telemetry.archive_size
   * The size of the Telemetry archive (MB)
   * This metric was generated to correspond to the Legacy Telemetry linear histogram TELEMETRY_ARCHIVE_SIZE_MB.
   */
  constexpr impl::MemoryDistributionMetric archive_size(5721);

  /**
   * generated from telemetry.compress
   * Time taken to compress telemetry object (ms)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram TELEMETRY_COMPRESS.
   */
  constexpr impl::TimingDistributionMetric compress(5722);

  /**
   * generated from telemetry.data_upload_optin
   * User opted into sending Telemetry data again. This metric was generated to correspond to the Legacy Telemetry scalar telemetry.data_upload_optin.
   */
  constexpr impl::BooleanMetric data_upload_optin(5723);

  /**
   * generated from telemetry.discarded_archived_pings_size
   * The size (MB) of the Telemetry archived, compressed, pings exceeding the maximum file size
   * This metric was generated to correspond to the Legacy Telemetry linear histogram TELEMETRY_DISCARDED_ARCHIVED_PINGS_SIZE_MB.
   */
  constexpr impl::MemoryDistributionMetric discarded_archived_pings_size(5724);

  /**
   * generated from telemetry.discarded_pending_pings_size
   * The size (MB) of the Telemetry pending pings exceeding the maximum file size
   * This metric was generated to correspond to the Legacy Telemetry linear histogram TELEMETRY_DISCARDED_PENDING_PINGS_SIZE_MB.
   */
  constexpr impl::MemoryDistributionMetric discarded_pending_pings_size(5725);

  /**
   * generated from telemetry.discarded_send_pings_size
   * The size (MB) of the ping data submitted to Telemetry exceeding the maximum size
   * This metric was generated to correspond to the Legacy Telemetry linear histogram TELEMETRY_DISCARDED_SEND_PINGS_SIZE_MB.
   */
  constexpr impl::MemoryDistributionMetric discarded_send_pings_size(5726);

  /**
   * generated from telemetry.event_ping_sent
   */
  enum class EventPingSentLabel: uint16_t {
    ePeriodic = 0,
    eMax = 1,
    eShutdown = 2,
    e__Other__,
  };
  /**
   * Number of 'event' pings sent, by reason
   * This metric was generated to correspond to the Legacy Telemetry categorical histogram TELEMETRY_EVENT_PING_SENT.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, EventPingSentLabel> event_ping_sent(5727);

  /**
   * generated from telemetry.event_recording_error
   */
  enum class EventRecordingErrorLabel: uint16_t {
    eUnknownevent = 0,
    eExpired = 1,
    eExtrakey = 2,
    eValue = 3,
    eExtra = 4,
    e__Other__,
  };
  /**
   * Number of event recording failures, by type of failure
   * This metric was generated to correspond to the Legacy Telemetry categorical histogram TELEMETRY_EVENT_RECORDING_ERROR.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, EventRecordingErrorLabel> event_recording_error(5728);

  /**
   * generated from telemetry.event_registration_error
   */
  enum class EventRegistrationErrorLabel: uint16_t {
    eOther = 0,
    eName = 1,
    eCategory = 2,
    eMethod = 3,
    eObject = 4,
    eExtrakeys = 5,
    e__Other__,
  };
  /**
   * Number of event registration failures, by field causing the failure
   * This metric was generated to correspond to the Legacy Telemetry categorical histogram TELEMETRY_EVENT_REGISTRATION_ERROR.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, EventRegistrationErrorLabel> event_registration_error(5729);

  /**
   * generated from telemetry.invalid_payload_submitted
   * Count of individual invalid payloads that were submitted to Telemetry.
   * This metric was generated to correspond to the Legacy Telemetry count histogram TELEMETRY_INVALID_PAYLOAD_SUBMITTED.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> invalid_payload_submitted(5730);

  /**
   * generated from telemetry.invalid_ping_type_submitted
   * Count of individual invalid ping types that were submitted to Telemetry.
   * This metric was generated to correspond to the Legacy Telemetry count histogram TELEMETRY_INVALID_PING_TYPE_SUBMITTED.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, DynamicLabel> invalid_ping_type_submitted(5731);

  /**
   * generated from telemetry.pending_checking_over_quota
   * Time (ms) it takes for checking if the pending pings are over-quota
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram TELEMETRY_PENDING_CHECKING_OVER_QUOTA_MS.
   */
  constexpr impl::TimingDistributionMetric pending_checking_over_quota(5732);

  /**
   * generated from telemetry.pending_evicting_over_quota
   * Time (ms) it takes for evicting over-quota pending pings
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram TELEMETRY_PENDING_EVICTING_OVER_QUOTA_MS.
   */
  constexpr impl::TimingDistributionMetric pending_evicting_over_quota(5733);

  /**
   * generated from telemetry.pending_load_failure_parse
   * Number of pending Telemetry pings that failed to parse once loaded from the disk
   * This metric was generated to correspond to the Legacy Telemetry count histogram TELEMETRY_PENDING_LOAD_FAILURE_PARSE.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> pending_load_failure_parse(5734);

  /**
   * generated from telemetry.pending_load_failure_read
   * Number of pending Telemetry pings that failed to load from the disk
   * This metric was generated to correspond to the Legacy Telemetry count histogram TELEMETRY_PENDING_LOAD_FAILURE_READ.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> pending_load_failure_read(5735);

  /**
   * generated from telemetry.pending_pings_age
   * The age, in days, of the pending pings.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram TELEMETRY_PENDING_PINGS_AGE.
   */
  constexpr impl::TimingDistributionMetric pending_pings_age(5736);

  /**
   * generated from telemetry.pending_pings_evicted_over_quota
   * Number of Telemetry pings evicted from the pending pings directory during cleanup, because they were over the quota
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram TELEMETRY_PENDING_PINGS_EVICTED_OVER_QUOTA.
   */
  constexpr impl::CustomDistributionMetric pending_pings_evicted_over_quota(5737);

  /**
   * generated from telemetry.pending_pings_size
   * The size of the Telemetry pending pings directory (MB). The special value 17 is used to indicate over quota pings.
   * This metric was generated to correspond to the Legacy Telemetry linear histogram TELEMETRY_PENDING_PINGS_SIZE_MB.
   */
  constexpr impl::MemoryDistributionMetric pending_pings_size(5738);

  /**
   * generated from telemetry.ping_evicted_for_server_errors
   * Number of Telemetry ping files evicted due to server errors (4XX HTTP code received)
   * This metric was generated to correspond to the Legacy Telemetry count histogram TELEMETRY_PING_EVICTED_FOR_SERVER_ERRORS.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> ping_evicted_for_server_errors(5739);

  /**
   * generated from telemetry.ping_size_exceeded_archived
   * Number of archived Telemetry pings discarded because they exceeded the maximum size
   * This metric was generated to correspond to the Legacy Telemetry count histogram TELEMETRY_PING_SIZE_EXCEEDED_ARCHIVED.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> ping_size_exceeded_archived(5740);

  /**
   * generated from telemetry.ping_size_exceeded_pending
   * Number of Telemetry pending pings discarded because they exceeded the maximum size
   * This metric was generated to correspond to the Legacy Telemetry count histogram TELEMETRY_PING_SIZE_EXCEEDED_PENDING.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> ping_size_exceeded_pending(5741);

  /**
   * generated from telemetry.ping_size_exceeded_send
   * Number of Telemetry pings discarded before sending because they exceeded the maximum size
   * This metric was generated to correspond to the Legacy Telemetry count histogram TELEMETRY_PING_SIZE_EXCEEDED_SEND.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> ping_size_exceeded_send(5742);

  /**
   * generated from telemetry.ping_submission_waiting_clientid
   * The number of pings that were submitted and had to wait for a client id (i.e. before it was cached or loaded from disk)
   * This metric was generated to correspond to the Legacy Telemetry count histogram TELEMETRY_PING_SUBMISSION_WAITING_CLIENTID.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> ping_submission_waiting_clientid(5743);

  /**
   * generated from telemetry.send_failure
   * Time needed (in ms) for a failed send of a Telemetry ping to the servers and getting a reply back.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram TELEMETRY_SEND_FAILURE.
   */
  constexpr impl::TimingDistributionMetric send_failure(5744);

  /**
   * generated from telemetry.send_failure_type
   */
  enum class SendFailureTypeLabel: uint16_t {
    eEok = 0,
    eErequest = 1,
    eEunreachable = 2,
    eEchannelopen = 3,
    eEredirect = 4,
    eAbort = 5,
    eTimeout = 6,
    eEtoolate = 7,
    eEterminated = 8,
    e__Other__,
  };
  /**
   * Counts of the different ways sending a Telemetry ping can fail.
   * This metric was generated to correspond to the Legacy Telemetry categorical histogram TELEMETRY_SEND_FAILURE_TYPE.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, SendFailureTypeLabel> send_failure_type(5745);

  /**
   * generated from telemetry.send_failure_type_per_ping
   * Counts of the different ways sending a Telemetry ping can fail per ping type.
   * This metric was generated to correspond to the Legacy Telemetry categorical histogram TELEMETRY_SEND_FAILURE_TYPE_PER_PING.
   */
  constexpr impl::DualLabeledCounterMetric send_failure_type_per_ping(5746);

  /**
   * generated from telemetry.send_success
   * Time needed (in ms) for a successful send of a Telemetry ping to the servers and getting a reply back.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram TELEMETRY_SEND_SUCCESS.
   */
  constexpr impl::TimingDistributionMetric send_success(5747);

  /**
   * generated from telemetry.stringify
   * Time to stringify telemetry object (ms)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram TELEMETRY_STRINGIFY.
   */
  constexpr impl::TimingDistributionMetric stringify(5748);

  /**
   * generated from telemetry.success
   */
  enum class SuccessLabel: uint16_t {
    eFalse = 0,
    eTrue = 1,
    e__Other__,
  };
  /**
   * Successful telemetry submission
   * This metric was generated to correspond to the Legacy Telemetry boolean histogram TELEMETRY_SUCCESS.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, SuccessLabel> success(5749);
}

namespace termsofuse {
  /**
   * generated from termsofuse.date
   * The timestamp when the user accepted the Terms of Use.
   */
  constexpr impl::DatetimeMetric date(5750);

  /**
   * generated from termsofuse.version
   * The version of the Terms of Use the user accepted.
   */
  constexpr impl::QuantityMetric version(5751);
}

namespace third_party_modules {
  /**
   * generated from third.party.modules.blocked_modules
   * List of all DLL filenames that are on the dynamic blocklist.
   */
  constexpr impl::StringListMetric blocked_modules(5752);

  /**
   * generated from third.party.modules.modules
   */

  struct ModulesObjectItem {
    Maybe<nsCString> resolvedDllName;
    Maybe<nsCString> fileVersion;
    Maybe<nsCString> companyName;
    Maybe<nsCString> signedBy;
    Maybe<int64_t> trustFlags;
  };

  using ModulesObject = nsTArray<ModulesObjectItem>;
  /**
   * The third-party modules we saw get loaded into Firefox.
   * Maximum of 100 modules.
   * ```text
   * [{
   *   resolvedDllName: sanitized string name of the module as resolved by the Windows loader,
   *   fileVersion: string version of the DLL as contained in its resources's fixed version information,
   *   companyName: string value of the CompanyName field as extracted from the DLL's version information. This property is only present when such version info is present, and when the 'signedBy' property is absent,
   *   signedBy: string name of the organization whose certificate was used to sign the DLL. Only present for signed modules,
   *   trustFlags: Flags that indicate this module's level of trustworthiness. This corresponds to one or more `mozilla::ModuleTrustFlags` OR'd together to form a number,
   * }, ...]
   * ```
   */
  constexpr impl::ObjectMetric<ModulesObject, struct ModulesObjectTag> modules(5753);

  /**
   * generated from third.party.modules.processes
   */

  struct ProcessesObjectItemEventsItem {
    Maybe<int64_t> processUptimeMS;
    Maybe<nsCString> loadDurationMS;
    Maybe<int64_t> threadID;
    Maybe<nsCString> threadName;
    Maybe<nsCString> requestedDllName;
    Maybe<nsCString> baseAddress;
    Maybe<int64_t> moduleIndex;
    Maybe<bool> isDependent;
    Maybe<int64_t> loadStatus;
  };

  using ProcessesObjectItemEvents = nsTArray<ProcessesObjectItemEventsItem>;

  using ProcessesObjectItemCombinedstacksMemorymapItem = nsTArray<nsCString>;

  using ProcessesObjectItemCombinedstacksMemorymap = nsTArray<ProcessesObjectItemCombinedstacksMemorymapItem>;

  using ProcessesObjectItemCombinedstacksStacksItemItem = nsTArray<int64_t>;

  using ProcessesObjectItemCombinedstacksStacksItem = nsTArray<ProcessesObjectItemCombinedstacksStacksItemItem>;

  using ProcessesObjectItemCombinedstacksStacks = nsTArray<ProcessesObjectItemCombinedstacksStacksItem>;


  struct ProcessesObjectItemCombinedstacks {
    Maybe<ProcessesObjectItemCombinedstacksMemorymap> memoryMap;
    Maybe<ProcessesObjectItemCombinedstacksStacks> stacks;
  };


  struct ProcessesObjectItem {
    Maybe<nsCString> processName;
    Maybe<nsCString> processType;
    Maybe<nsCString> elapsed;
    Maybe<nsCString> xulLoadDurationMS;
    Maybe<int64_t> sanitizationFailures;
    Maybe<int64_t> trustTestFailures;
    Maybe<ProcessesObjectItemEvents> events;
    Maybe<ProcessesObjectItemCombinedstacks> combinedStacks;
  };

  using ProcessesObject = nsTArray<ProcessesObjectItem>;
  /**
   * The per-process third-party module load context and events.
   * ```text
   * [{
   *   processName: string containing processType and pid, formatted as `${processType}.0x${pid}`,
   *   processType: one of the process string names specified in `xpcom/build/GeckoProcessTypes.h` or "browser" for Default,
   *   elapsed: number of seconds since process creation that this object was generated,
   *   xulLoadDurationMS: number of milliseconds it took to load xul.dll,
   *   sanitizationFailures: number of dropped events due to failures in path sanitization,
   *   trustTestFailures: number of dropped events due to failures computing trust levels,
   *   events: [{ // Array of module load events for this process. The entries of this array are ordered to be in sync with the combinedStacks.stacks array (see below).
   *     processUptimeMS: number of milliseconds between process creation and when this event was generated,
   *     loadDurationMS: number of milliseconds of time spent loading this module,
   *     threadID: numeric id of the thread that loaded the module,
   *     threadName: string name of the thread that loaded the module, when applicable,
   *     requestedDllName: sanitized string name of the module that was requested by the invoking code. Only exists when it is different from resolvedDllName,
   *     baseAddress: string formatted as `0x%x`, the base address to which the loader mapped the module,
   *     moduleIndex: numeric index of the element in the `modules` array that contains details about the module that was loaded during this event,
   *     isDependent: boolean, true if the module is included in the executable's Import Directory Table,
   *     loadStatus: number, corresponding to a value of `ModuleLoadInfo::Status`, of the status of the DLL load,
   *   }, ...], // Max 50 events
   *   combinedStacks: {
   *     memoryMap: [[
   *       <string> name of the module symbol file (e.g. `xul.pdb`),
   *       <string> breakpad identifier for the module (e.g. `08A541B5942242BDB4AEABD8C87E4CFF2`),
   *     ], ...],
   *     stacks: [ // Array of stacks for this process. These entries are ordered to be in sync with the events array (above).
   *       [
   *         [
   *           <integer> module index, or -1 for failure/invalid,
   *           <integer> program counter relative to its module base, or an absolute PC if the module index is -1,
   *         ], ... // Up to 512 stack frames
   *       ], ... // Up to 50 stack traces
   *     ],
   *   ]
   * }, ...] // Up to 100 processes' information
   * ```
   */
  constexpr impl::ObjectMetric<ProcessesObject, struct ProcessesObjectTag> processes(5754);
}

template <>
inline void impl::ObjectMetric<third_party_modules::ModulesObject, third_party_modules::ModulesObjectTag>::Set(const third_party_modules::ModulesObject& aObj) const {
  nsCString json;
  JSONStringRefWriteFunc writeFunc(json);
  JSONWriter writer(writeFunc, JSONWriter::CollectionStyle::SingleLineStyle);

  writer.StartArrayElement();
  {
    for (const auto& aobjItem: aObj) {
      writer.StartObjectElement();
      {
        if (aobjItem.resolvedDllName.isSome()) {
          writer.StringProperty("resolvedDllName", *(aobjItem.resolvedDllName));
        }
        if (aobjItem.fileVersion.isSome()) {
          writer.StringProperty("fileVersion", *(aobjItem.fileVersion));
        }
        if (aobjItem.companyName.isSome()) {
          writer.StringProperty("companyName", *(aobjItem.companyName));
        }
        if (aobjItem.signedBy.isSome()) {
          writer.StringProperty("signedBy", *(aobjItem.signedBy));
        }
        if (aobjItem.trustFlags.isSome()) {
          writer.IntProperty("trustFlags", *(aobjItem.trustFlags));
        }
      }
      writer.EndObject();

    }
  }
  writer.EndArray();


  SetStr(json);
}

template <>
inline void impl::ObjectMetric<third_party_modules::ProcessesObject, third_party_modules::ProcessesObjectTag>::Set(const third_party_modules::ProcessesObject& aObj) const {
  nsCString json;
  JSONStringRefWriteFunc writeFunc(json);
  JSONWriter writer(writeFunc, JSONWriter::CollectionStyle::SingleLineStyle);

  writer.StartArrayElement();
  {
    for (const auto& aobjItem: aObj) {
      writer.StartObjectElement();
      {
        if (aobjItem.processName.isSome()) {
          writer.StringProperty("processName", *(aobjItem.processName));
        }
        if (aobjItem.processType.isSome()) {
          writer.StringProperty("processType", *(aobjItem.processType));
        }
        if (aobjItem.elapsed.isSome()) {
          writer.StringProperty("elapsed", *(aobjItem.elapsed));
        }
        if (aobjItem.xulLoadDurationMS.isSome()) {
          writer.StringProperty("xulLoadDurationMS", *(aobjItem.xulLoadDurationMS));
        }
        if (aobjItem.sanitizationFailures.isSome()) {
          writer.IntProperty("sanitizationFailures", *(aobjItem.sanitizationFailures));
        }
        if (aobjItem.trustTestFailures.isSome()) {
          writer.IntProperty("trustTestFailures", *(aobjItem.trustTestFailures));
        }
        if (aobjItem.events.isSome()) {
          writer.StartArrayProperty("events");
          for (const auto& aobjitemEventsItem: *aobjItem.events) {
            writer.StartObjectElement();
            {
              if (aobjitemEventsItem.processUptimeMS.isSome()) {
                writer.IntProperty("processUptimeMS", *(aobjitemEventsItem.processUptimeMS));
              }
              if (aobjitemEventsItem.loadDurationMS.isSome()) {
                writer.StringProperty("loadDurationMS", *(aobjitemEventsItem.loadDurationMS));
              }
              if (aobjitemEventsItem.threadID.isSome()) {
                writer.IntProperty("threadID", *(aobjitemEventsItem.threadID));
              }
              if (aobjitemEventsItem.threadName.isSome()) {
                writer.StringProperty("threadName", *(aobjitemEventsItem.threadName));
              }
              if (aobjitemEventsItem.requestedDllName.isSome()) {
                writer.StringProperty("requestedDllName", *(aobjitemEventsItem.requestedDllName));
              }
              if (aobjitemEventsItem.baseAddress.isSome()) {
                writer.StringProperty("baseAddress", *(aobjitemEventsItem.baseAddress));
              }
              if (aobjitemEventsItem.moduleIndex.isSome()) {
                writer.IntProperty("moduleIndex", *(aobjitemEventsItem.moduleIndex));
              }
              if (aobjitemEventsItem.isDependent.isSome()) {
                writer.BoolProperty("isDependent", *(aobjitemEventsItem.isDependent));
              }
              if (aobjitemEventsItem.loadStatus.isSome()) {
                writer.IntProperty("loadStatus", *(aobjitemEventsItem.loadStatus));
              }
            }
            writer.EndObject();

          }
          writer.EndArray();
        }
        if (aobjItem.combinedStacks.isSome()) {
          writer.StartObjectProperty("combinedStacks");
          if (aobjItem.combinedStacks->memoryMap.isSome()) {
            writer.StartArrayProperty("memoryMap");
            for (const auto& aobjitemCombinedstacksmemorymapItem: *aobjItem.combinedStacks->memoryMap) {
              writer.StartArrayElement();
              {
                for (const auto& aobjitemcombinedstacksmemorymapitemItem: aobjitemCombinedstacksmemorymapItem) {
                  writer.StringElement(aobjitemcombinedstacksmemorymapitemItem);

                }
              }
              writer.EndArray();

            }
            writer.EndArray();
          }
          if (aobjItem.combinedStacks->stacks.isSome()) {
            writer.StartArrayProperty("stacks");
            for (const auto& aobjitemCombinedstacksstacksItem: *aobjItem.combinedStacks->stacks) {
              writer.StartArrayElement();
              {
                for (const auto& aobjitemcombinedstacksstacksitemItem: aobjitemCombinedstacksstacksItem) {
                  writer.StartArrayElement();
                  {
                    for (const auto& aobjitemcombinedstacksstacksitemitemItem: aobjitemcombinedstacksstacksitemItem) {
                      writer.IntElement(aobjitemcombinedstacksstacksitemitemItem);

                    }
                  }
                  writer.EndArray();

                }
              }
              writer.EndArray();

            }
            writer.EndArray();
          }
          writer.EndObject();
        }
      }
      writer.EndObject();

    }
  }
  writer.EndArray();


  SetStr(json);
}

namespace usage {
  /**
   * generated from usage.app_build
   * The build identifier generated by the CI system (e.g. "1234/A").
   * If the value was not provided through configuration,
   * this metric gets set to `Unknown`.
   */
  constexpr impl::StringMetric app_build(5755);

  /**
   * generated from usage.app_channel
   * The channel the application is being distributed on.
   */
  constexpr impl::StringMetric app_channel(5756);

  /**
   * generated from usage.app_display_version
   * The user visible version string (e.g. "1.0.3").
   * If the value was not provided through configuration,
   * this metric gets set to `Unknown`.
   */
  constexpr impl::StringMetric app_display_version(5757);

  /**
   * generated from usage.distribution_id
   * The distribution id associated with the install of Firefox.
   */
  constexpr impl::StringMetric distribution_id(5758);

  /**
   * generated from usage.first_run_date
   * The date of the profile's first use. Set from `ProfileAge.firstUse`
   */
  constexpr impl::DatetimeMetric first_run_date(5759);

  /**
   * generated from usage.is_default_browser
   * Whether Firefox is set as the default browser.
   */
  constexpr impl::BooleanMetric is_default_browser(5760);

  /**
   * generated from usage.os
   * The name of the operating system.
   * Possible values:
   * Android, iOS, Linux, Darwin, Windows,
   * FreeBSD, NetBSD, OpenBSD, Solaris, Unknown
   */
  constexpr impl::StringMetric os(5761);

  /**
   * generated from usage.os_version
   * The user-visible version of the operating system (e.g. "1.2.3").
   * If the version detection fails, this metric gets set to `Unknown`.
   */
  constexpr impl::StringMetric os_version(5762);

  /**
   * generated from usage.profile_group_id
   * A UUID uniquely identifying the profile group,
   * not shared with other telemetry data.
   */
  constexpr impl::UuidMetric profile_group_id(5763);

  /**
   * generated from usage.profile_id
   * A UUID uniquely identifying the profile,
   * not shared with other telemetry data.
   */
  constexpr impl::UuidMetric profile_id(5764);

  /**
   * generated from usage.reason
   * The reason the usage-reporting ping was sent.
   */
  constexpr impl::StringMetric reason(5765);

  /**
   * generated from usage.windows_backup_enabled
   * Tracks if Windows Backup is enabled and configured to back up applications.
   */
  constexpr impl::BooleanMetric windows_backup_enabled(5766);

  /**
   * generated from usage.windows_build_number
   * The optional Windows build number, reported by Windows
   * (e.g. 22000) and not set for other platforms.
   */
  constexpr impl::QuantityMetric windows_build_number(5767);

  /**
   * generated from usage.windows_user_profile_age_in_days
   * The age of the current users home folder in days.
   */
  constexpr impl::QuantityMetric windows_user_profile_age_in_days(5768);
}

} // namespace mozilla::glean

#endif // mozilla_GleanTelemetryMetrics_h
