/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=2 sts=2 et cindent: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/* THIS FILE IS AUTOGENERATED FROM GamepadButtonEvent.webidl BY Codegen.py - DO NOT EDIT */

#include "GamepadButtonEvent.h"
#include "GamepadButtonEventBinding.h"
#include "GamepadEventBinding.h"
#include "js/GCAPI.h"
#include "mozilla/HoldDropJSObjects.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/GamepadButtonEvent.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrimitiveConversions.h"

namespace mozilla::dom {


GamepadButtonEvent::GamepadButtonEvent(mozilla::dom::EventTarget* aOwner)
  : GamepadEvent(aOwner)
{
}

GamepadButtonEvent::~GamepadButtonEvent()
{
}

GamepadButtonEvent*
GamepadButtonEvent::AsGamepadButtonEvent()
{
  return this;
}

JSObject*
GamepadButtonEvent::WrapObjectInternal(JSContext* aCx, JS::Handle<JSObject*> aGivenProto)
{
  return GamepadButtonEvent_Binding::Wrap(aCx, this, aGivenProto);
}

already_AddRefed<GamepadButtonEvent>
GamepadButtonEvent::Constructor(mozilla::dom::EventTarget* aOwner, const nsAString& aType, const GamepadButtonEventInit& aEventInitDict)
{
  RefPtr<GamepadButtonEvent> e = new GamepadButtonEvent(aOwner);
  bool trusted = e->Init(aOwner);
  e->InitEvent(aType, aEventInitDict.mBubbles, aEventInitDict.mCancelable);
  e->mButton = aEventInitDict.mButton;
  e->mGamepad = aEventInitDict.mGamepad;
  e->SetTrusted(trusted);
  e->SetComposed(aEventInitDict.mComposed);
  return e.forget();
}

already_AddRefed<GamepadButtonEvent>
GamepadButtonEvent::Constructor(const GlobalObject& aGlobal, const nsAString& aType, const GamepadButtonEventInit& aEventInitDict)
{
  nsCOMPtr<mozilla::dom::EventTarget> owner = do_QueryInterface(aGlobal.GetAsSupports());
  return Constructor(owner, aType, aEventInitDict);
}

uint32_t
GamepadButtonEvent::Button() const
{
  return mButton;
}


} // namespace mozilla::dom
