/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=2 sts=2 et cindent: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/* THIS FILE IS AUTOGENERATED FROM XRInputSourceEvent.webidl BY Codegen.py - DO NOT EDIT */

#include "EventBinding.h"
#include "XRInputSourceEvent.h"
#include "XRInputSourceEventBinding.h"
#include "js/GCAPI.h"
#include "mozilla/HoldDropJSObjects.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrimitiveConversions.h"
#include "mozilla/dom/XRFrame.h"
#include "mozilla/dom/XRInputSource.h"
#include "mozilla/dom/XRInputSourceEvent.h"

namespace mozilla::dom {


NS_IMPL_CYCLE_COLLECTION_CLASS(XRInputSourceEvent)

NS_IMPL_ADDREF_INHERITED(XRInputSourceEvent, Event)
NS_IMPL_RELEASE_INHERITED(XRInputSourceEvent, Event)

NS_IMPL_CYCLE_COLLECTION_TRAVERSE_BEGIN_INHERITED(XRInputSourceEvent, Event)
  NS_IMPL_CYCLE_COLLECTION_TRAVERSE(mFrame)
  NS_IMPL_CYCLE_COLLECTION_TRAVERSE(mInputSource)
NS_IMPL_CYCLE_COLLECTION_TRAVERSE_END

NS_IMPL_CYCLE_COLLECTION_TRACE_BEGIN_INHERITED(XRInputSourceEvent, Event)
NS_IMPL_CYCLE_COLLECTION_TRACE_END

NS_IMPL_CYCLE_COLLECTION_UNLINK_BEGIN_INHERITED(XRInputSourceEvent, Event)
  NS_IMPL_CYCLE_COLLECTION_UNLINK(mFrame)
  NS_IMPL_CYCLE_COLLECTION_UNLINK(mInputSource)
NS_IMPL_CYCLE_COLLECTION_UNLINK_END

NS_INTERFACE_MAP_BEGIN_CYCLE_COLLECTION(XRInputSourceEvent)
NS_INTERFACE_MAP_END_INHERITING(Event)

XRInputSourceEvent::XRInputSourceEvent(mozilla::dom::EventTarget* aOwner)
  : Event(aOwner, nullptr, nullptr)
{
}

XRInputSourceEvent::~XRInputSourceEvent()
{
}

XRInputSourceEvent*
XRInputSourceEvent::AsXRInputSourceEvent()
{
  return this;
}

JSObject*
XRInputSourceEvent::WrapObjectInternal(JSContext* aCx, JS::Handle<JSObject*> aGivenProto)
{
  return XRInputSourceEvent_Binding::Wrap(aCx, this, aGivenProto);
}

already_AddRefed<XRInputSourceEvent>
XRInputSourceEvent::Constructor(mozilla::dom::EventTarget* aOwner, const nsAString& aType, const XRInputSourceEventInit& aEventInitDict)
{
  RefPtr<XRInputSourceEvent> e = new XRInputSourceEvent(aOwner);
  bool trusted = e->Init(aOwner);
  e->InitEvent(aType, aEventInitDict.mBubbles, aEventInitDict.mCancelable);
  e->mFrame = aEventInitDict.mFrame;
  e->mInputSource = aEventInitDict.mInputSource;
  e->SetTrusted(trusted);
  e->SetComposed(aEventInitDict.mComposed);
  return e.forget();
}

already_AddRefed<XRInputSourceEvent>
XRInputSourceEvent::Constructor(const GlobalObject& aGlobal, const nsAString& aType, const XRInputSourceEventInit& aEventInitDict)
{
  nsCOMPtr<mozilla::dom::EventTarget> owner = do_QueryInterface(aGlobal.GetAsSupports());
  return Constructor(owner, aType, aEventInitDict);
}

XRFrame*
XRInputSourceEvent::Frame() const
{
  return mFrame;
}

XRInputSource*
XRInputSourceEvent::InputSource() const
{
  return mInputSource;
}


} // namespace mozilla::dom
