// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#include "mozilla/glean/bindings/GleanJSPingsLookup.h"

#include "mozilla/PerfectHash.h"
#include "nsString.h"

#include "mozilla/PerfectHash.h"

#define GLEAN_PING_INDEX_BITS (16)
#define GLEAN_PING_ID(entry) ((entry) >> GLEAN_PING_INDEX_BITS)
#define GLEAN_PING_INDEX(entry) ((entry) & ((1UL << GLEAN_PING_INDEX_BITS) - 1))

namespace mozilla::glean {

// Contains the ping id and the index into the ping string table.
using ping_entry_t = uint32_t;

Maybe<uint32_t> ping_result_check(const nsACString& aKey, ping_entry_t aEntry);

#if defined(_MSC_VER) && !defined(__clang__)
const char gPingStringTable[] = {
#else
constexpr char gPingStringTable[] = {
#endif
  /*     0 - "messagingSystem" */ 'm', 'e', 's', 's', 'a', 'g', 'i', 'n', 'g', 'S', 'y', 's', 't', 'e', 'm', '\0',
  /*    16 - "postProfileRestore" */ 'p', 'o', 's', 't', 'P', 'r', 'o', 'f', 'i', 'l', 'e', 'R', 'e', 's', 't', 'o', 'r', 'e', '\0',
  /*    35 - "profileRestore" */ 'p', 'r', 'o', 'f', 'i', 'l', 'e', 'R', 'e', 's', 't', 'o', 'r', 'e', '\0',
  /*    50 - "newtab" */ 'n', 'e', 'w', 't', 'a', 'b', '\0',
  /*    57 - "newtabContent" */ 'n', 'e', 'w', 't', 'a', 'b', 'C', 'o', 'n', 't', 'e', 'n', 't', '\0',
  /*    71 - "spoc" */ 's', 'p', 'o', 'c', '\0',
  /*    76 - "topSites" */ 't', 'o', 'p', 'S', 'i', 't', 'e', 's', '\0',
  /*    85 - "profiles" */ 'p', 'r', 'o', 'f', 'i', 'l', 'e', 's', '\0',
  /*    94 - "searchWith" */ 's', 'e', 'a', 'r', 'c', 'h', 'W', 'i', 't', 'h', '\0',
  /*   105 - "serpCategorization" */ 's', 'e', 'r', 'p', 'C', 'a', 't', 'e', 'g', 'o', 'r', 'i', 'z', 'a', 't', 'i', 'o', 'n', '\0',
  /*   124 - "quickSuggest" */ 'q', 'u', 'i', 'c', 'k', 'S', 'u', 'g', 'g', 'e', 's', 't', '\0',
  /*   137 - "quickSuggestDeletionRequest" */ 'q', 'u', 'i', 'c', 'k', 'S', 'u', 'g', 'g', 'e', 's', 't', 'D', 'e', 'l', 'e', 't', 'i', 'o', 'n', 'R', 'e', 'q', 'u', 'e', 's', 't', '\0',
  /*   165 - "urlbarKeywordExposure" */ 'u', 'r', 'l', 'b', 'a', 'r', 'K', 'e', 'y', 'w', 'o', 'r', 'd', 'E', 'x', 'p', 'o', 's', 'u', 'r', 'e', '\0',
  /*   187 - "dataLeakBlocker" */ 'd', 'a', 't', 'a', 'L', 'e', 'a', 'k', 'B', 'l', 'o', 'c', 'k', 'e', 'r', '\0',
  /*   203 - "contextIdDeletionRequest" */ 'c', 'o', 'n', 't', 'e', 'x', 't', 'I', 'd', 'D', 'e', 'l', 'e', 't', 'i', 'o', 'n', 'R', 'e', 'q', 'u', 'e', 's', 't', '\0',
  /*   228 - "prototypeNoCodeEvents" */ 'p', 'r', 'o', 't', 'o', 't', 'y', 'p', 'e', 'N', 'o', 'C', 'o', 'd', 'e', 'E', 'v', 'e', 'n', 't', 's', '\0',
  /*   250 - "pageload" */ 'p', 'a', 'g', 'e', 'l', 'o', 'a', 'd', '\0',
  /*   259 - "pageloadBaseDomain" */ 'p', 'a', 'g', 'e', 'l', 'o', 'a', 'd', 'B', 'a', 's', 'e', 'D', 'o', 'm', 'a', 'i', 'n', '\0',
  /*   278 - "useCounters" */ 'u', 's', 'e', 'C', 'o', 'u', 'n', 't', 'e', 'r', 's', '\0',
  /*   290 - "unexpectedScriptLoad" */ 'u', 'n', 'e', 'x', 'p', 'e', 'c', 't', 'e', 'd', 'S', 'c', 'r', 'i', 'p', 't', 'L', 'o', 'a', 'd', '\0',
  /*   311 - "localNetworkAccess" */ 'l', 'o', 'c', 'a', 'l', 'N', 'e', 't', 'w', 'o', 'r', 'k', 'A', 'c', 'c', 'e', 's', 's', '\0',
  /*   330 - "fxAccounts" */ 'f', 'x', 'A', 'c', 'c', 'o', 'u', 'n', 't', 's', '\0',
  /*   341 - "sync" */ 's', 'y', 'n', 'c', '\0',
  /*   346 - "bounceTrackingProtection" */ 'b', 'o', 'u', 'n', 'c', 'e', 'T', 'r', 'a', 'c', 'k', 'i', 'n', 'g', 'P', 'r', 'o', 't', 'e', 'c', 't', 'i', 'o', 'n', '\0',
  /*   371 - "hangReport" */ 'h', 'a', 'n', 'g', 'R', 'e', 'p', 'o', 'r', 't', '\0',
  /*   382 - "backgroundTasks" */ 'b', 'a', 'c', 'k', 'g', 'r', 'o', 'u', 'n', 'd', 'T', 'a', 's', 'k', 's', '\0',
  /*   398 - "captchaDetection" */ 'c', 'a', 'p', 't', 'c', 'h', 'a', 'D', 'e', 't', 'e', 'c', 't', 'i', 'o', 'n', '\0',
  /*   415 - "crash" */ 'c', 'r', 'a', 's', 'h', '\0',
  /*   421 - "geckoTrace" */ 'g', 'e', 'c', 'k', 'o', 'T', 'r', 'a', 'c', 'e', '\0',
  /*   432 - "dauReporting" */ 'd', 'a', 'u', 'R', 'e', 'p', 'o', 'r', 't', 'i', 'n', 'g', '\0',
  /*   445 - "tempFogInitialState" */ 't', 'e', 'm', 'p', 'F', 'o', 'g', 'I', 'n', 'i', 't', 'i', 'a', 'l', 'S', 't', 'a', 't', 'e', '\0',
  /*   465 - "collectionDisabledPing" */ 'c', 'o', 'l', 'l', 'e', 'c', 't', 'i', 'o', 'n', 'D', 'i', 's', 'a', 'b', 'l', 'e', 'd', 'P', 'i', 'n', 'g', '\0',
  /*   488 - "disabledPing" */ 'd', 'i', 's', 'a', 'b', 'l', 'e', 'd', 'P', 'i', 'n', 'g', '\0',
  /*   501 - "onePingOnly" */ 'o', 'n', 'e', 'P', 'i', 'n', 'g', 'O', 'n', 'l', 'y', '\0',
  /*   513 - "rideAlongPing" */ 'r', 'i', 'd', 'e', 'A', 'l', 'o', 'n', 'g', 'P', 'i', 'n', 'g', '\0',
  /*   527 - "testOhttpPing" */ 't', 'e', 's', 't', 'O', 'h', 't', 't', 'p', 'P', 'i', 'n', 'g', '\0',
  /*   541 - "testPing" */ 't', 'e', 's', 't', 'P', 'i', 'n', 'g', '\0',
  /*   550 - "heartbeat" */ 'h', 'e', 'a', 'r', 't', 'b', 'e', 'a', 't', '\0',
  /*   560 - "nimbusTargetingContext" */ 'n', 'i', 'm', 'b', 'u', 's', 'T', 'a', 'r', 'g', 'e', 't', 'i', 'n', 'g', 'C', 'o', 'n', 't', 'e', 'x', 't', '\0',
  /*   583 - "brokenSiteReport" */ 'b', 'r', 'o', 'k', 'e', 'n', 'S', 'i', 't', 'e', 'R', 'e', 'p', 'o', 'r', 't', '\0',
  /*   600 - "userCharacteristics" */ 'u', 's', 'e', 'r', 'C', 'h', 'a', 'r', 'a', 'c', 't', 'e', 'r', 'i', 's', 't', 'i', 'c', 's', '\0',
  /*   620 - "onboardingOptOut" */ 'o', 'n', 'b', 'o', 'a', 'r', 'd', 'i', 'n', 'g', 'O', 'p', 't', 'O', 'u', 't', '\0',
  /*   637 - "thirdPartyModules" */ 't', 'h', 'i', 'r', 'd', 'P', 'a', 'r', 't', 'y', 'M', 'o', 'd', 'u', 'l', 'e', 's', '\0',
  /*   655 - "usageDeletionRequest" */ 'u', 's', 'a', 'g', 'e', 'D', 'e', 'l', 'e', 't', 'i', 'o', 'n', 'R', 'e', 'q', 'u', 'e', 's', 't', '\0',
  /*   676 - "usageReporting" */ 'u', 's', 'a', 'g', 'e', 'R', 'e', 'p', 'o', 'r', 't', 'i', 'n', 'g', '\0',
  /*   691 - "firstStartup" */ 'f', 'i', 'r', 's', 't', 'S', 't', 'a', 'r', 't', 'u', 'p', '\0',
  /*   704 - "defaultAgent" */ 'd', 'e', 'f', 'a', 'u', 'l', 't', 'A', 'g', 'e', 'n', 't', '\0',
  /*   717 - "addons" */ 'a', 'd', 'd', 'o', 'n', 's', '\0',
  /*   724 - "backgroundUpdate" */ 'b', 'a', 'c', 'k', 'g', 'r', 'o', 'u', 'n', 'd', 'U', 'p', 'd', 'a', 't', 'e', '\0',
  /*   741 - "update" */ 'u', 'p', 'd', 'a', 't', 'e', '\0',
};



const ping_entry_t sPingByNameLookupEntries[] = {
  655465,
  1638771,
  524373,
  2818685,
  1900965,
  589918,
  721020,
  1835423,
  2622023,
  1048804,
  393287,
  2097617,
  65536,
  983243,
  1704318,
  1966512,
  917691,
  1179907,
  131088,
  1311010,
  2425373,
  1442122,
  2294273,
  2884239,
  1245462,
  1376567,
  2359823,
  3146445,
  3080896,
  852133,
  2032061,
  327737,
  3211988,
  2753132,
  786569,
  262194,
  2687576,
  2490918,
  1573210,
  2163176,
  1769870,
  2228725,
  196643,
  2949796,
  2556464,
  458828,
  1114362,
  1507669,
  3277541,
  3015347
};



Maybe<uint32_t>
PingByNameLookup(const nsACString& aKey)
{
  static const uint8_t BASES[] = {
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   1,   0,   0,   0,   1,   0,   0,   0,   0,   0,   2,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   2,   0,   0,   0,   0,   1,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   4,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   5,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   4,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   3,   0,   2,   0,   0,   0,
       0,   4,   0,   0,   0,   0,   0,   0,   0,   4,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   6,   0,   0,   0,   0,   0,   0,   0,   0,   4,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   9,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,  15,   0,   0,   0,   0,   0,   0,   4,   0,   0,   0,   0,   0,   0,   0,
       3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   9,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  14,   0,   0,   0,   0,   1,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  75,   0,   0,   0,
       0,   0,   0,   0,   0,   0,  24,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  };
  

  const char* bytes = aKey.BeginReading();
  size_t length = aKey.Length();
  auto& entry = mozilla::perfecthash::Lookup(bytes, length, BASES,
                                             sPingByNameLookupEntries);
  return ping_result_check(aKey, entry);
}


/**
 * Get a ping's name given its entry from the PHF.
 */
const char* GetPingName(ping_entry_t aEntry) {
  uint32_t idx = GLEAN_PING_INDEX(aEntry);
  MOZ_ASSERT(idx < sizeof(gPingStringTable), "Ping index larger than string table");
  return &gPingStringTable[idx];
}

/**
 * Check if the found entry is pointing at the correct ping.
 * PHF can false-positive a result when the key isn't present, so we check
 * for a string match. If it fails, return Nothing(). If we found it,
 * return the ping's id.
 */
Maybe<uint32_t> ping_result_check(const nsACString& aKey, ping_entry_t aEntry) {
  uint32_t idx = GLEAN_PING_INDEX(aEntry);
  uint32_t id = GLEAN_PING_ID(aEntry);

  if (MOZ_UNLIKELY(idx > sizeof(gPingStringTable))) {
    return Nothing();
  }

  if (aKey.EqualsASCII(&gPingStringTable[idx])) {
    return Some(id);
  }

  return Nothing();
}

#undef GLEAN_PING_INDEX_BITS
#undef GLEAN_PING_ID
#undef GLEAN_PING_INDEX

}  // namespace mozilla::glean
