/* auto-generated, do not modify */
#include "config.h"

#include <glib.h>

#include "fu-dell-kestrel-ec-struct.h"
#include "fu-byte-array.h"
#include "fu-mem-private.h"
#include "fu-string.h"

#ifdef G_LOG_DOMAIN
  #undef G_LOG_DOMAIN
#endif
#define G_LOG_DOMAIN "FuStruct"








/**
 * fu_struct_dell_kestrel_ec_databytes_ref: (skip):
 **/
FuStructDellKestrelEcDatabytes *
fu_struct_dell_kestrel_ec_databytes_ref(FuStructDellKestrelEcDatabytes *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_dell_kestrel_ec_databytes_unref: (skip):
 **/
void
fu_struct_dell_kestrel_ec_databytes_unref(FuStructDellKestrelEcDatabytes *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructDellKestrelEcDatabytes refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
static FuStructDellKestrelEcDatabytes *
fu_struct_dell_kestrel_ec_databytes_new_internal(void)
{
    FuStructDellKestrelEcDatabytes *st = g_new0(FuStructDellKestrelEcDatabytes, 1);
    st->refcount = 1;
    return st;
}

/* getters */

/* setters */
/**
 * fu_struct_dell_kestrel_ec_databytes_set_cmd: (skip):
 **/
void
fu_struct_dell_kestrel_ec_databytes_set_cmd(FuStructDellKestrelEcDatabytes *st, FuDellKestrelEcCmd value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_dell_kestrel_ec_databytes_set_data_sz: (skip):
 **/
void
fu_struct_dell_kestrel_ec_databytes_set_data_sz(FuStructDellKestrelEcDatabytes *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[1] = value;
}
/**
 * fu_struct_dell_kestrel_ec_databytes_set_data: (skip):
 **/
gboolean
fu_struct_dell_kestrel_ec_databytes_set_data(FuStructDellKestrelEcDatabytes *st, const guint8 *buf, gsize bufsz, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(buf != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    return fu_memcpy_safe(st->buf->data, st->buf->len, 2, buf, bufsz, 0x0, bufsz, error);
}
/**
 * fu_struct_dell_kestrel_ec_databytes_new: (skip):
 **/
FuStructDellKestrelEcDatabytes *
fu_struct_dell_kestrel_ec_databytes_new(void)
{
    FuStructDellKestrelEcDatabytes *st = fu_struct_dell_kestrel_ec_databytes_new_internal();
    st->buf = g_byte_array_sized_new(128);
    fu_byte_array_set_size(st->buf, 128, 0x0);
    return st;
}
/**
 * fu_struct_dell_kestrel_dock_data_ref: (skip):
 **/
FuStructDellKestrelDockData *
fu_struct_dell_kestrel_dock_data_ref(FuStructDellKestrelDockData *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_dell_kestrel_dock_data_unref: (skip):
 **/
void
fu_struct_dell_kestrel_dock_data_unref(FuStructDellKestrelDockData *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructDellKestrelDockData refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
static FuStructDellKestrelDockData *
fu_struct_dell_kestrel_dock_data_new_internal(void)
{
    FuStructDellKestrelDockData *st = g_new0(FuStructDellKestrelDockData, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_dell_kestrel_dock_data_get_dock_configuration: (skip):
 **/
guint8
fu_struct_dell_kestrel_dock_data_get_dock_configuration(const FuStructDellKestrelDockData *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[0];
}
/**
 * fu_struct_dell_kestrel_dock_data_get_dock_type: (skip):
 **/
guint8
fu_struct_dell_kestrel_dock_data_get_dock_type(const FuStructDellKestrelDockData *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[1];
}
/**
 * fu_struct_dell_kestrel_dock_data_get_module_type: (skip):
 **/
guint16
fu_struct_dell_kestrel_dock_data_get_module_type(const FuStructDellKestrelDockData *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 4, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_dell_kestrel_dock_data_get_board_id: (skip):
 **/
guint16
fu_struct_dell_kestrel_dock_data_get_board_id(const FuStructDellKestrelDockData *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 6, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_dell_kestrel_dock_data_get_dock_firmware_pkg_ver: (skip):
 **/
guint32
fu_struct_dell_kestrel_dock_data_get_dock_firmware_pkg_ver(const FuStructDellKestrelDockData *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 12, G_BIG_ENDIAN);
}
/**
 * fu_struct_dell_kestrel_dock_data_get_module_serial: (skip):
 **/
guint64
fu_struct_dell_kestrel_dock_data_get_module_serial(const FuStructDellKestrelDockData *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint64(st->buf->data + 16, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_dell_kestrel_dock_data_get_service_tag: (skip):
 **/
gchar *
fu_struct_dell_kestrel_dock_data_get_service_tag(const FuStructDellKestrelDockData *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 32, 7, NULL);
}
/**
 * fu_struct_dell_kestrel_dock_data_get_marketing_name: (skip):
 **/
gchar *
fu_struct_dell_kestrel_dock_data_get_marketing_name(const FuStructDellKestrelDockData *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 39, 32, NULL);
}
/**
 * fu_struct_dell_kestrel_dock_data_get_chunk_support: (skip):
 **/
guint8
fu_struct_dell_kestrel_dock_data_get_chunk_support(const FuStructDellKestrelDockData *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[83];
}
/**
 * fu_struct_dell_kestrel_dock_data_get_dock_status: (skip):
 **/
guint32
fu_struct_dell_kestrel_dock_data_get_dock_status(const FuStructDellKestrelDockData *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 84, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_dell_kestrel_dock_data_get_dock_mac_addr: (skip):
 **/
const guint8 *
fu_struct_dell_kestrel_dock_data_get_dock_mac_addr(const FuStructDellKestrelDockData *st, gsize *bufsz)
{
    g_return_val_if_fail(st != NULL, NULL);
    if (bufsz != NULL)
        *bufsz = 6;
    return st->buf->data + 92;
}
/**
 * fu_struct_dell_kestrel_dock_data_get_eppid: (skip):
 **/
guint8
fu_struct_dell_kestrel_dock_data_get_eppid(const FuStructDellKestrelDockData *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[116];
}

/* setters */
/**
 * fu_struct_dell_kestrel_dock_data_set_dock_configuration: (skip):
 **/
void
fu_struct_dell_kestrel_dock_data_set_dock_configuration(FuStructDellKestrelDockData *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_dell_kestrel_dock_data_set_dock_type: (skip):
 **/
void
fu_struct_dell_kestrel_dock_data_set_dock_type(FuStructDellKestrelDockData *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[1] = value;
}
/**
 * fu_struct_dell_kestrel_dock_data_set_module_type: (skip):
 **/
void
fu_struct_dell_kestrel_dock_data_set_module_type(FuStructDellKestrelDockData *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 4, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_dell_kestrel_dock_data_set_board_id: (skip):
 **/
void
fu_struct_dell_kestrel_dock_data_set_board_id(FuStructDellKestrelDockData *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 6, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_dell_kestrel_dock_data_set_dock_firmware_pkg_ver: (skip):
 **/
void
fu_struct_dell_kestrel_dock_data_set_dock_firmware_pkg_ver(FuStructDellKestrelDockData *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 12, value, G_BIG_ENDIAN);
}
/**
 * fu_struct_dell_kestrel_dock_data_set_module_serial: (skip):
 **/
void
fu_struct_dell_kestrel_dock_data_set_module_serial(FuStructDellKestrelDockData *st, guint64 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint64(st->buf->data + 16, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_dell_kestrel_dock_data_set_service_tag: (skip):
 **/
gboolean
fu_struct_dell_kestrel_dock_data_set_service_tag(FuStructDellKestrelDockData *st, const gchar *value, GError **error)
{
    gsize len;
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (value == NULL) {
        memset(st->buf->data + 32, 0x0, 7);
        return TRUE;
    }
    len = strlen(value);
    if (len > 7) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "string '%s' (0x%x bytes) does not fit in FuStructDellKestrelDockData.service_tag (0x%x bytes)",
                    value, (guint) len, (guint) 7);
        return FALSE;
    }
    return fu_memcpy_safe(st->buf->data, st->buf->len, 32, (const guint8 *)value, len, 0x0, len, error);
}
/**
 * fu_struct_dell_kestrel_dock_data_set_marketing_name: (skip):
 **/
gboolean
fu_struct_dell_kestrel_dock_data_set_marketing_name(FuStructDellKestrelDockData *st, const gchar *value, GError **error)
{
    gsize len;
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (value == NULL) {
        memset(st->buf->data + 39, 0x0, 32);
        return TRUE;
    }
    len = strlen(value);
    if (len > 32) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "string '%s' (0x%x bytes) does not fit in FuStructDellKestrelDockData.marketing_name (0x%x bytes)",
                    value, (guint) len, (guint) 32);
        return FALSE;
    }
    return fu_memcpy_safe(st->buf->data, st->buf->len, 39, (const guint8 *)value, len, 0x0, len, error);
}
/**
 * fu_struct_dell_kestrel_dock_data_set_chunk_support: (skip):
 **/
void
fu_struct_dell_kestrel_dock_data_set_chunk_support(FuStructDellKestrelDockData *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[83] = value;
}
/**
 * fu_struct_dell_kestrel_dock_data_set_dock_status: (skip):
 **/
void
fu_struct_dell_kestrel_dock_data_set_dock_status(FuStructDellKestrelDockData *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 84, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_dell_kestrel_dock_data_set_dock_mac_addr: (skip):
 **/
gboolean
fu_struct_dell_kestrel_dock_data_set_dock_mac_addr(FuStructDellKestrelDockData *st, const guint8 *buf, gsize bufsz, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(buf != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    return fu_memcpy_safe(st->buf->data, st->buf->len, 92, buf, bufsz, 0x0, bufsz, error);
}
/**
 * fu_struct_dell_kestrel_dock_data_set_eppid: (skip):
 **/
void
fu_struct_dell_kestrel_dock_data_set_eppid(FuStructDellKestrelDockData *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[116] = value;
}
/**
 * fu_struct_dell_kestrel_dock_data_new: (skip):
 **/
FuStructDellKestrelDockData *
fu_struct_dell_kestrel_dock_data_new(void)
{
    FuStructDellKestrelDockData *st = fu_struct_dell_kestrel_dock_data_new_internal();
    st->buf = g_byte_array_sized_new(191);
    fu_byte_array_set_size(st->buf, 191, 0x0);
    return st;
}
/**
 * fu_struct_dell_kestrel_dock_data_to_string: (skip):
 **/
static gchar *
fu_struct_dell_kestrel_dock_data_to_string(const FuStructDellKestrelDockData *st)
{
    g_autoptr(GString) str = g_string_new("FuStructDellKestrelDockData:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  dock_configuration: 0x%x\n",
                           (guint) fu_struct_dell_kestrel_dock_data_get_dock_configuration(st));
    g_string_append_printf(str, "  dock_type: 0x%x\n",
                           (guint) fu_struct_dell_kestrel_dock_data_get_dock_type(st));
    g_string_append_printf(str, "  module_type: 0x%x\n",
                           (guint) fu_struct_dell_kestrel_dock_data_get_module_type(st));
    g_string_append_printf(str, "  board_id: 0x%x\n",
                           (guint) fu_struct_dell_kestrel_dock_data_get_board_id(st));
    g_string_append_printf(str, "  dock_firmware_pkg_ver: 0x%x\n",
                           (guint) fu_struct_dell_kestrel_dock_data_get_dock_firmware_pkg_ver(st));
    g_string_append_printf(str, "  module_serial: 0x%x\n",
                           (guint) fu_struct_dell_kestrel_dock_data_get_module_serial(st));
    {
        g_autofree gchar *tmp = fu_struct_dell_kestrel_dock_data_get_service_tag(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  service_tag: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_dell_kestrel_dock_data_get_marketing_name(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  marketing_name: %s\n", tmp);
    }
    g_string_append_printf(str, "  chunk_support: 0x%x\n",
                           (guint) fu_struct_dell_kestrel_dock_data_get_chunk_support(st));
    g_string_append_printf(str, "  dock_status: 0x%x\n",
                           (guint) fu_struct_dell_kestrel_dock_data_get_dock_status(st));
    {
        gsize bufsz = 0;
        const guint8 *buf = fu_struct_dell_kestrel_dock_data_get_dock_mac_addr(st, &bufsz);
        g_autoptr(GString) tmp = g_string_new(NULL);
        for (gsize i = 0; i < bufsz; i++)
            g_string_append_printf(tmp, "%02X", buf[i]);
        g_string_append_printf(str, "  dock_mac_addr: 0x%s\n", tmp->str);
    }
    g_string_append_printf(str, "  eppid: 0x%x\n",
                           (guint) fu_struct_dell_kestrel_dock_data_get_eppid(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_dell_kestrel_dock_data_validate_internal(FuStructDellKestrelDockData *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_dell_kestrel_dock_data_parse_internal(FuStructDellKestrelDockData *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_dell_kestrel_dock_data_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_dell_kestrel_dock_data_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_dell_kestrel_dock_data_parse: (skip):
 **/
FuStructDellKestrelDockData *
fu_struct_dell_kestrel_dock_data_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructDellKestrelDockData) st = fu_struct_dell_kestrel_dock_data_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 191, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructDellKestrelDockData: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 191);
    if (!fu_struct_dell_kestrel_dock_data_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_dell_kestrel_package_fw_versions_ref: (skip):
 **/
FuStructDellKestrelPackageFwVersions *
fu_struct_dell_kestrel_package_fw_versions_ref(FuStructDellKestrelPackageFwVersions *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_dell_kestrel_package_fw_versions_unref: (skip):
 **/
void
fu_struct_dell_kestrel_package_fw_versions_unref(FuStructDellKestrelPackageFwVersions *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructDellKestrelPackageFwVersions refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}

/* getters */

/* setters */
/**
 * fu_struct_dell_kestrel_dock_info_ec_addr_map_ref: (skip):
 **/
FuStructDellKestrelDockInfoEcAddrMap *
fu_struct_dell_kestrel_dock_info_ec_addr_map_ref(FuStructDellKestrelDockInfoEcAddrMap *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_dell_kestrel_dock_info_ec_addr_map_unref: (skip):
 **/
void
fu_struct_dell_kestrel_dock_info_ec_addr_map_unref(FuStructDellKestrelDockInfoEcAddrMap *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructDellKestrelDockInfoEcAddrMap refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
static FuStructDellKestrelDockInfoEcAddrMap *
fu_struct_dell_kestrel_dock_info_ec_addr_map_new_internal(void)
{
    FuStructDellKestrelDockInfoEcAddrMap *st = g_new0(FuStructDellKestrelDockInfoEcAddrMap, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_dell_kestrel_dock_info_ec_addr_map_get_location: (skip):
 **/
guint8
fu_struct_dell_kestrel_dock_info_ec_addr_map_get_location(const FuStructDellKestrelDockInfoEcAddrMap *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[0];
}
/**
 * fu_struct_dell_kestrel_dock_info_ec_addr_map_get_device_type: (skip):
 **/
guint8
fu_struct_dell_kestrel_dock_info_ec_addr_map_get_device_type(const FuStructDellKestrelDockInfoEcAddrMap *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[1];
}
/**
 * fu_struct_dell_kestrel_dock_info_ec_addr_map_get_subtype: (skip):
 **/
guint8
fu_struct_dell_kestrel_dock_info_ec_addr_map_get_subtype(const FuStructDellKestrelDockInfoEcAddrMap *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[2];
}
/**
 * fu_struct_dell_kestrel_dock_info_ec_addr_map_get_arg: (skip):
 **/
guint8
fu_struct_dell_kestrel_dock_info_ec_addr_map_get_arg(const FuStructDellKestrelDockInfoEcAddrMap *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[3];
}
/**
 * fu_struct_dell_kestrel_dock_info_ec_addr_map_get_instance: (skip):
 **/
guint8
fu_struct_dell_kestrel_dock_info_ec_addr_map_get_instance(const FuStructDellKestrelDockInfoEcAddrMap *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[4];
}

/* setters */
/**
 * fu_struct_dell_kestrel_dock_info_ec_addr_map_new: (skip):
 **/
static FuStructDellKestrelDockInfoEcAddrMap *
fu_struct_dell_kestrel_dock_info_ec_addr_map_new(void)
{
    FuStructDellKestrelDockInfoEcAddrMap *st = fu_struct_dell_kestrel_dock_info_ec_addr_map_new_internal();
    st->buf = g_byte_array_sized_new(5);
    fu_byte_array_set_size(st->buf, 5, 0x0);
    return st;
}
/**
 * fu_struct_dell_kestrel_dock_info_ec_addr_map_to_string: (skip):
 **/
static gchar *
fu_struct_dell_kestrel_dock_info_ec_addr_map_to_string(const FuStructDellKestrelDockInfoEcAddrMap *st)
{
    g_autoptr(GString) str = g_string_new("FuStructDellKestrelDockInfoEcAddrMap:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  location: 0x%x\n",
                           (guint) fu_struct_dell_kestrel_dock_info_ec_addr_map_get_location(st));
    g_string_append_printf(str, "  device_type: 0x%x\n",
                           (guint) fu_struct_dell_kestrel_dock_info_ec_addr_map_get_device_type(st));
    g_string_append_printf(str, "  subtype: 0x%x\n",
                           (guint) fu_struct_dell_kestrel_dock_info_ec_addr_map_get_subtype(st));
    g_string_append_printf(str, "  arg: 0x%x\n",
                           (guint) fu_struct_dell_kestrel_dock_info_ec_addr_map_get_arg(st));
    g_string_append_printf(str, "  instance: 0x%x\n",
                           (guint) fu_struct_dell_kestrel_dock_info_ec_addr_map_get_instance(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_dell_kestrel_dock_info_ec_addr_map_validate_internal(FuStructDellKestrelDockInfoEcAddrMap *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
/**
 * fu_struct_dell_kestrel_dock_info_ec_query_entry_ref: (skip):
 **/
FuStructDellKestrelDockInfoEcQueryEntry *
fu_struct_dell_kestrel_dock_info_ec_query_entry_ref(FuStructDellKestrelDockInfoEcQueryEntry *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_dell_kestrel_dock_info_ec_query_entry_unref: (skip):
 **/
void
fu_struct_dell_kestrel_dock_info_ec_query_entry_unref(FuStructDellKestrelDockInfoEcQueryEntry *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructDellKestrelDockInfoEcQueryEntry refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
static FuStructDellKestrelDockInfoEcQueryEntry *
fu_struct_dell_kestrel_dock_info_ec_query_entry_new_internal(void)
{
    FuStructDellKestrelDockInfoEcQueryEntry *st = g_new0(FuStructDellKestrelDockInfoEcQueryEntry, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_dell_kestrel_dock_info_ec_query_entry_get_ec_addr_map: (skip):
 **/
FuStructDellKestrelDockInfoEcAddrMap *
fu_struct_dell_kestrel_dock_info_ec_query_entry_get_ec_addr_map(const FuStructDellKestrelDockInfoEcQueryEntry *st)
{
    g_autoptr(FuStructDellKestrelDockInfoEcAddrMap) st_tmp = fu_struct_dell_kestrel_dock_info_ec_addr_map_new_internal();
    g_return_val_if_fail(st != NULL, NULL);
    st_tmp->buf = g_byte_array_new();
    g_byte_array_append(st_tmp->buf, st->buf->data + FU_STRUCT_DELL_KESTREL_DOCK_INFO_EC_QUERY_ENTRY_OFFSET_EC_ADDR_MAP, 5);
    return g_steal_pointer(&st_tmp);
}
/**
 * fu_struct_dell_kestrel_dock_info_ec_query_entry_get_version_32: (skip):
 **/
guint32
fu_struct_dell_kestrel_dock_info_ec_query_entry_get_version_32(const FuStructDellKestrelDockInfoEcQueryEntry *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 5, G_BIG_ENDIAN);
}

/* setters */
/**
 * fu_struct_dell_kestrel_dock_info_ec_query_entry_new: (skip):
 **/
static FuStructDellKestrelDockInfoEcQueryEntry *
fu_struct_dell_kestrel_dock_info_ec_query_entry_new(void)
{
    FuStructDellKestrelDockInfoEcQueryEntry *st = fu_struct_dell_kestrel_dock_info_ec_query_entry_new_internal();
    st->buf = g_byte_array_sized_new(9);
    fu_byte_array_set_size(st->buf, 9, 0x0);
    {
        g_autoptr(FuStructDellKestrelDockInfoEcAddrMap) st_donor = fu_struct_dell_kestrel_dock_info_ec_addr_map_new();
        memcpy(st->buf->data + 0x0, st_donor->buf->data, st_donor->buf->len); /* nocheck:blocked */
    }
    return st;
}
/**
 * fu_struct_dell_kestrel_dock_info_ec_query_entry_to_string: (skip):
 **/
static gchar *
fu_struct_dell_kestrel_dock_info_ec_query_entry_to_string(const FuStructDellKestrelDockInfoEcQueryEntry *st)
{
    g_autoptr(GString) str = g_string_new("FuStructDellKestrelDockInfoEcQueryEntry:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        g_autoptr(FuStructDellKestrelDockInfoEcAddrMap) st_tmp = fu_struct_dell_kestrel_dock_info_ec_query_entry_get_ec_addr_map(st);
        g_autofree gchar *tmp = fu_struct_dell_kestrel_dock_info_ec_addr_map_to_string(st_tmp);
        g_string_append_printf(str, "  ec_addr_map: %s\n", tmp);
    }
    g_string_append_printf(str, "  version_32: 0x%x\n",
                           (guint) fu_struct_dell_kestrel_dock_info_ec_query_entry_get_version_32(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_dell_kestrel_dock_info_ec_query_entry_validate_internal(FuStructDellKestrelDockInfoEcQueryEntry *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    {
        GByteArray buf_tmp = {
            .data = (guint8*) st->buf->data + 0x0,
            .len = 5,
        };
        FuStructDellKestrelDockInfoEcAddrMap st_tmp = { .buf = &buf_tmp };
        if (!fu_struct_dell_kestrel_dock_info_ec_addr_map_validate_internal(&st_tmp, error))
            return FALSE;
    }
    return TRUE;
}
/**
 * fu_struct_dell_kestrel_dock_info_header_ref: (skip):
 **/
FuStructDellKestrelDockInfoHeader *
fu_struct_dell_kestrel_dock_info_header_ref(FuStructDellKestrelDockInfoHeader *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_dell_kestrel_dock_info_header_unref: (skip):
 **/
void
fu_struct_dell_kestrel_dock_info_header_unref(FuStructDellKestrelDockInfoHeader *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructDellKestrelDockInfoHeader refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
static FuStructDellKestrelDockInfoHeader *
fu_struct_dell_kestrel_dock_info_header_new_internal(void)
{
    FuStructDellKestrelDockInfoHeader *st = g_new0(FuStructDellKestrelDockInfoHeader, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_dell_kestrel_dock_info_header_get_total_devices: (skip):
 **/
guint8
fu_struct_dell_kestrel_dock_info_header_get_total_devices(const FuStructDellKestrelDockInfoHeader *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[0];
}
/**
 * fu_struct_dell_kestrel_dock_info_header_get_first_index: (skip):
 **/
guint8
fu_struct_dell_kestrel_dock_info_header_get_first_index(const FuStructDellKestrelDockInfoHeader *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[1];
}
/**
 * fu_struct_dell_kestrel_dock_info_header_get_last_index: (skip):
 **/
guint8
fu_struct_dell_kestrel_dock_info_header_get_last_index(const FuStructDellKestrelDockInfoHeader *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[2];
}

/* setters */
/**
 * fu_struct_dell_kestrel_dock_info_header_new: (skip):
 **/
static FuStructDellKestrelDockInfoHeader *
fu_struct_dell_kestrel_dock_info_header_new(void)
{
    FuStructDellKestrelDockInfoHeader *st = fu_struct_dell_kestrel_dock_info_header_new_internal();
    st->buf = g_byte_array_sized_new(3);
    fu_byte_array_set_size(st->buf, 3, 0x0);
    return st;
}
/**
 * fu_struct_dell_kestrel_dock_info_header_to_string: (skip):
 **/
static gchar *
fu_struct_dell_kestrel_dock_info_header_to_string(const FuStructDellKestrelDockInfoHeader *st)
{
    g_autoptr(GString) str = g_string_new("FuStructDellKestrelDockInfoHeader:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  total_devices: 0x%x\n",
                           (guint) fu_struct_dell_kestrel_dock_info_header_get_total_devices(st));
    g_string_append_printf(str, "  first_index: 0x%x\n",
                           (guint) fu_struct_dell_kestrel_dock_info_header_get_first_index(st));
    g_string_append_printf(str, "  last_index: 0x%x\n",
                           (guint) fu_struct_dell_kestrel_dock_info_header_get_last_index(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_dell_kestrel_dock_info_header_validate_internal(FuStructDellKestrelDockInfoHeader *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
/**
 * fu_struct_dell_kestrel_dock_info_ref: (skip):
 **/
FuStructDellKestrelDockInfo *
fu_struct_dell_kestrel_dock_info_ref(FuStructDellKestrelDockInfo *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_dell_kestrel_dock_info_unref: (skip):
 **/
void
fu_struct_dell_kestrel_dock_info_unref(FuStructDellKestrelDockInfo *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructDellKestrelDockInfo refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
static FuStructDellKestrelDockInfo *
fu_struct_dell_kestrel_dock_info_new_internal(void)
{
    FuStructDellKestrelDockInfo *st = g_new0(FuStructDellKestrelDockInfo, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_dell_kestrel_dock_info_get_header: (skip):
 **/
FuStructDellKestrelDockInfoHeader *
fu_struct_dell_kestrel_dock_info_get_header(const FuStructDellKestrelDockInfo *st)
{
    g_autoptr(FuStructDellKestrelDockInfoHeader) st_tmp = fu_struct_dell_kestrel_dock_info_header_new_internal();
    g_return_val_if_fail(st != NULL, NULL);
    st_tmp->buf = g_byte_array_new();
    g_byte_array_append(st_tmp->buf, st->buf->data + FU_STRUCT_DELL_KESTREL_DOCK_INFO_OFFSET_HEADER, 3);
    return g_steal_pointer(&st_tmp);
}
/**
 * fu_struct_dell_kestrel_dock_info_get_devices: (skip):
 **/
FuStructDellKestrelDockInfoEcQueryEntry *
fu_struct_dell_kestrel_dock_info_get_devices(const FuStructDellKestrelDockInfo *st, guint idx)
{
    g_autoptr(FuStructDellKestrelDockInfoEcQueryEntry) st_tmp = fu_struct_dell_kestrel_dock_info_ec_query_entry_new_internal();
    g_return_val_if_fail(st != NULL, NULL);
    g_return_val_if_fail(idx < 20, NULL);
    st_tmp->buf = g_byte_array_new();
    g_byte_array_append(st_tmp->buf,
                        st->buf->data
                            + FU_STRUCT_DELL_KESTREL_DOCK_INFO_OFFSET_DEVICES
                            + (FU_STRUCT_DELL_KESTREL_DOCK_INFO_EC_QUERY_ENTRY_SIZE * idx),
                        9);
    return g_steal_pointer(&st_tmp);
}

/* setters */
/**
 * fu_struct_dell_kestrel_dock_info_set_header: (skip):
 **/
gboolean
fu_struct_dell_kestrel_dock_info_set_header(FuStructDellKestrelDockInfo *st, const FuStructDellKestrelDockInfoHeader *st_donor, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(st_donor != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);

    if (st_donor->buf->len > FU_STRUCT_DELL_KESTREL_DOCK_INFO_HEADER_SIZE) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "donor 'FuStructDellKestrelDockInfoHeader' (0x%x bytes) does not fit in "
                    "FuStructDellKestrelDockInfo.header (0x%x bytes)",
                    (guint) st_donor->buf->len,
                    (guint) FU_STRUCT_DELL_KESTREL_DOCK_INFO_HEADER_SIZE);
        return FALSE;
    }
    memcpy(st->buf->data + FU_STRUCT_DELL_KESTREL_DOCK_INFO_OFFSET_HEADER, st_donor->buf->data, st_donor->buf->len);
    return TRUE;
}
/**
 * fu_struct_dell_kestrel_dock_info_set_devices: (skip):
 **/
gboolean
fu_struct_dell_kestrel_dock_info_set_devices(FuStructDellKestrelDockInfo *st, guint idx, const FuStructDellKestrelDockInfoEcQueryEntry *st_donor, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(st_donor != NULL, FALSE);
    g_return_val_if_fail(idx < 20, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);

    if (st_donor->buf->len > FU_STRUCT_DELL_KESTREL_DOCK_INFO_EC_QUERY_ENTRY_SIZE) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "donor 'FuStructDellKestrelDockInfoEcQueryEntry' (0x%x bytes) does not fit in "
                    "FuStructDellKestrelDockInfo.devices (0x%x bytes)",
                    (guint) st_donor->buf->len,
                    (guint) FU_STRUCT_DELL_KESTREL_DOCK_INFO_EC_QUERY_ENTRY_SIZE);
        return FALSE;
    }
    memcpy(st->buf->data
            + FU_STRUCT_DELL_KESTREL_DOCK_INFO_OFFSET_DEVICES
            + (FU_STRUCT_DELL_KESTREL_DOCK_INFO_EC_QUERY_ENTRY_SIZE * idx),
           st_donor->buf->data,
           st_donor->buf->len);
    return TRUE;
}
/**
 * fu_struct_dell_kestrel_dock_info_new: (skip):
 **/
FuStructDellKestrelDockInfo *
fu_struct_dell_kestrel_dock_info_new(void)
{
    FuStructDellKestrelDockInfo *st = fu_struct_dell_kestrel_dock_info_new_internal();
    st->buf = g_byte_array_sized_new(183);
    fu_byte_array_set_size(st->buf, 183, 0x0);
    {
        g_autoptr(FuStructDellKestrelDockInfoHeader) st_donor = fu_struct_dell_kestrel_dock_info_header_new();
        memcpy(st->buf->data + 0x0, st_donor->buf->data, st_donor->buf->len); /* nocheck:blocked */
    }
    {
        g_autoptr(FuStructDellKestrelDockInfoEcQueryEntry) st_donor = fu_struct_dell_kestrel_dock_info_ec_query_entry_new();
        memcpy(st->buf->data + 0x3, st_donor->buf->data, st_donor->buf->len); /* nocheck:blocked */
    }
    return st;
}
/**
 * fu_struct_dell_kestrel_dock_info_to_string: (skip):
 **/
static gchar *
fu_struct_dell_kestrel_dock_info_to_string(const FuStructDellKestrelDockInfo *st)
{
    g_autoptr(GString) str = g_string_new("FuStructDellKestrelDockInfo:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        g_autoptr(FuStructDellKestrelDockInfoHeader) st_tmp = fu_struct_dell_kestrel_dock_info_get_header(st);
        g_autofree gchar *tmp = fu_struct_dell_kestrel_dock_info_header_to_string(st_tmp);
        g_string_append_printf(str, "  header: %s\n", tmp);
    }
    for (guint i = 0; i < 20; i++) {
        g_autoptr(FuStructDellKestrelDockInfoEcQueryEntry) st_tmp = fu_struct_dell_kestrel_dock_info_get_devices(st, i);
        g_autofree gchar *tmp = fu_struct_dell_kestrel_dock_info_ec_query_entry_to_string(st_tmp);
        g_string_append_printf(str, "  devices[%u]: %s\n", i, tmp);
    }
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_dell_kestrel_dock_info_validate_internal(FuStructDellKestrelDockInfo *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    {
        GByteArray buf_tmp = {
            .data = (guint8*) st->buf->data + 0x0,
            .len = 3,
        };
        FuStructDellKestrelDockInfoHeader st_tmp = { .buf = &buf_tmp };
        if (!fu_struct_dell_kestrel_dock_info_header_validate_internal(&st_tmp, error))
            return FALSE;
    }
    {
        GByteArray buf_tmp = {
            .data = (guint8*) st->buf->data + 0x3,
            .len = 180,
        };
        FuStructDellKestrelDockInfoEcQueryEntry st_tmp = { .buf = &buf_tmp };
        if (!fu_struct_dell_kestrel_dock_info_ec_query_entry_validate_internal(&st_tmp, error))
            return FALSE;
    }
    return TRUE;
}
static gboolean
fu_struct_dell_kestrel_dock_info_parse_internal(FuStructDellKestrelDockInfo *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_dell_kestrel_dock_info_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_dell_kestrel_dock_info_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_dell_kestrel_dock_info_parse: (skip):
 **/
FuStructDellKestrelDockInfo *
fu_struct_dell_kestrel_dock_info_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructDellKestrelDockInfo) st = fu_struct_dell_kestrel_dock_info_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 183, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructDellKestrelDockInfo: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 183);
    if (!fu_struct_dell_kestrel_dock_info_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
