/* CloseDialog.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from CloseDialog.vala, do not modify */

/*
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: 2021-2023, 2025 elementary, Inc. (https://elementary.io)
 */

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <meta/meta-close-dialog.h>
#include "gala.h"
#include <meta/window.h>
#include <gio/gio.h>
#include <sys/types.h>
#include <meta/display.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GALA_TYPE_ACCESS_DIALOG (gala_access_dialog_get_type ())
#define GALA_ACCESS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_ACCESS_DIALOG, GalaAccessDialog))
#define GALA_ACCESS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_ACCESS_DIALOG, GalaAccessDialogClass))
#define GALA_IS_ACCESS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_ACCESS_DIALOG))
#define GALA_IS_ACCESS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_ACCESS_DIALOG))
#define GALA_ACCESS_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_ACCESS_DIALOG, GalaAccessDialogClass))

typedef struct _GalaAccessDialog GalaAccessDialog;
typedef struct _GalaAccessDialogClass GalaAccessDialogClass;
typedef struct _GalaAccessDialogPrivate GalaAccessDialogPrivate;

#define GALA_TYPE_CLOSE_DIALOG (gala_close_dialog_get_type ())
#define GALA_CLOSE_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_CLOSE_DIALOG, GalaCloseDialog))
#define GALA_CLOSE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_CLOSE_DIALOG, GalaCloseDialogClass))
#define GALA_IS_CLOSE_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_CLOSE_DIALOG))
#define GALA_IS_CLOSE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_CLOSE_DIALOG))
#define GALA_CLOSE_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_CLOSE_DIALOG, GalaCloseDialogClass))

typedef struct _GalaCloseDialog GalaCloseDialog;
typedef struct _GalaCloseDialogClass GalaCloseDialogClass;
typedef struct _GalaCloseDialogPrivate GalaCloseDialogPrivate;
enum  {
	GALA_CLOSE_DIALOG_0_PROPERTY,
	GALA_CLOSE_DIALOG_WINDOW_PROPERTY,
	GALA_CLOSE_DIALOG_APP_PROPERTY,
	GALA_CLOSE_DIALOG_NUM_PROPERTIES
};
static GParamSpec* gala_close_dialog_properties[GALA_CLOSE_DIALOG_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _GalaAccessDialog {
	GObject parent_instance;
	GalaAccessDialogPrivate * priv;
	char* path;
};

struct _GalaAccessDialogClass {
	GObjectClass parent_class;
	void (*on_response) (GalaAccessDialog* self, guint response_id);
	void (*show) (GalaAccessDialog* self);
};

struct _GalaCloseDialog {
	GalaAccessDialog parent_instance;
	GalaCloseDialogPrivate * priv;
};

struct _GalaCloseDialogClass {
	GalaAccessDialogClass parent_class;
};

struct _GalaCloseDialogPrivate {
	GalaApp* _app;
};

static gint GalaCloseDialog_private_offset;
static gpointer gala_close_dialog_parent_class = NULL;
static MetaCloseDialogInterface * gala_close_dialog_meta_close_dialog_parent_iface = NULL;

VALA_EXTERN GType gala_access_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaAccessDialog, g_object_unref)
VALA_EXTERN GType gala_close_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaCloseDialog, g_object_unref)
VALA_EXTERN void gala_access_dialog_show (GalaAccessDialog* self);
VALA_EXTERN void gala_access_dialog_on_response (GalaAccessDialog* self,
                                     guint response_id);
VALA_EXTERN GalaCloseDialog* gala_close_dialog_new (GalaApp* app,
                                        MetaWindow* window);
VALA_EXTERN GalaCloseDialog* gala_close_dialog_construct (GType object_type,
                                              GalaApp* app,
                                              MetaWindow* window);
static void gala_close_dialog_real_show (MetaCloseDialog* base);
static void gala_close_dialog_real_hide (MetaCloseDialog* base);
VALA_EXTERN void gala_access_dialog_close (GalaAccessDialog* self);
static void gala_close_dialog_real_focus (MetaCloseDialog* base);
static gboolean __lambda131_ (GalaCloseDialog* self,
                       MetaWindow* w);
static gboolean ___lambda131__meta_window_foreach_func (MetaWindow* window,
                                                 gpointer self);
static void gala_close_dialog_real_on_response (GalaAccessDialog* base,
                                         guint response_id);
VALA_EXTERN MetaWindow* gala_access_dialog_get_parent (GalaAccessDialog* self);
VALA_EXTERN void gala_access_dialog_set_parent (GalaAccessDialog* self,
                                    MetaWindow* value);
VALA_EXTERN GalaApp* gala_close_dialog_get_app (GalaCloseDialog* self);
static void gala_close_dialog_set_app (GalaCloseDialog* self,
                                GalaApp* value);
static GObject * gala_close_dialog_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties);
VALA_EXTERN void gala_access_dialog_set_icon (GalaAccessDialog* self,
                                  const gchar* value);
VALA_EXTERN void gala_access_dialog_set_title (GalaAccessDialog* self,
                                   const gchar* value);
VALA_EXTERN void gala_access_dialog_set_body (GalaAccessDialog* self,
                                  const gchar* value);
VALA_EXTERN void gala_access_dialog_set_accept_label (GalaAccessDialog* self,
                                          const gchar* value);
VALA_EXTERN void gala_access_dialog_set_deny_label (GalaAccessDialog* self,
                                        const gchar* value);
static void gala_close_dialog_finalize (GObject * obj);
static GType gala_close_dialog_get_type_once (void);
static void _vala_gala_close_dialog_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec);
static void _vala_gala_close_dialog_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec);

static inline gpointer
gala_close_dialog_get_instance_private (GalaCloseDialog* self)
{
	return G_STRUCT_MEMBER_P (self, GalaCloseDialog_private_offset);
}

GalaCloseDialog*
gala_close_dialog_construct (GType object_type,
                             GalaApp* app,
                             MetaWindow* window)
{
	GalaCloseDialog * self = NULL;
	g_return_val_if_fail (app != NULL, NULL);
	g_return_val_if_fail (window != NULL, NULL);
	self = (GalaCloseDialog*) g_object_new (object_type, "app", app, "window", window, NULL);
	return self;
}

GalaCloseDialog*
gala_close_dialog_new (GalaApp* app,
                       MetaWindow* window)
{
	return gala_close_dialog_construct (GALA_TYPE_CLOSE_DIALOG, app, window);
}

static void
gala_close_dialog_real_show (MetaCloseDialog* base)
{
	GalaCloseDialog * self;
	const char* _tmp0_;
	GError* _inner_error0_ = NULL;
	self = (GalaCloseDialog*) base;
	_tmp0_ = ((GalaAccessDialog*) self)->path;
	if (_tmp0_ != NULL) {
		return;
	}
	{
		gint our_pid = 0;
		GCredentials* _tmp1_;
		GCredentials* _tmp2_;
		gint _tmp3_;
		MetaWindow* _tmp4_;
		MetaWindow* _tmp5_;
		MetaWindow* _tmp6_;
		gboolean _tmp7_;
		_tmp1_ = g_credentials_new ();
		_tmp2_ = _tmp1_;
		_tmp3_ = g_credentials_get_unix_pid (_tmp2_, &_inner_error0_);
		_g_object_unref0 (_tmp2_);
		our_pid = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		g_object_get ((MetaCloseDialog*) self, "window", &_tmp4_, NULL);
		_tmp5_ = _tmp4_;
		_tmp6_ = _tmp5_;
		_tmp7_ = ((pid_t) our_pid) == meta_window_get_pid (_tmp6_);
		_g_object_unref0 (_tmp6_);
		if (_tmp7_) {
			g_critical ("CloseDialog.vala:41: We have an unresponsive window somewhere. Mutter " \
"wants to end its own process. Don't let it.");
			gala_access_dialog_on_response ((GalaAccessDialog*) self, (guint) 1);
			return;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		g_warning ("CloseDialog.vala:47: Failed to safeguard kill pid: %s", _tmp9_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	GALA_ACCESS_DIALOG_CLASS (gala_close_dialog_parent_class)->show (G_TYPE_CHECK_INSTANCE_CAST (self, GALA_TYPE_ACCESS_DIALOG, GalaAccessDialog));
}

static void
gala_close_dialog_real_hide (MetaCloseDialog* base)
{
	GalaCloseDialog * self;
	const char* _tmp0_;
	self = (GalaCloseDialog*) base;
	_tmp0_ = ((GalaAccessDialog*) self)->path;
	if (_tmp0_ != NULL) {
		gala_access_dialog_close ((GalaAccessDialog*) self);
	}
}

static gboolean
__lambda131_ (GalaCloseDialog* self,
              MetaWindow* w)
{
	const gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (w != NULL, FALSE);
	_tmp0_ = meta_window_get_role (w);
	if (g_strcmp0 (_tmp0_, "AccessDialog") == 0) {
		MetaDisplay* _tmp1_;
		_tmp1_ = meta_window_get_display (w);
		meta_window_activate (w, meta_display_get_current_time (_tmp1_));
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}

static gboolean
___lambda131__meta_window_foreach_func (MetaWindow* window,
                                        gpointer self)
{
	gboolean result;
	result = __lambda131_ ((GalaCloseDialog*) self, window);
	return result;
}

static void
gala_close_dialog_real_focus (MetaCloseDialog* base)
{
	GalaCloseDialog * self;
	MetaWindow* _tmp0_;
	MetaWindow* _tmp1_;
	MetaWindow* _tmp2_;
	self = (GalaCloseDialog*) base;
	g_object_get ((MetaCloseDialog*) self, "window", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	meta_window_foreach_transient (_tmp2_, ___lambda131__meta_window_foreach_func, self);
	_g_object_unref0 (_tmp2_);
}

static void
gala_close_dialog_real_on_response (GalaAccessDialog* base,
                                    guint response_id)
{
	GalaCloseDialog * self;
	self = (GalaCloseDialog*) base;
	if (response_id == ((guint) 0)) {
		g_signal_emit_by_name (G_TYPE_CHECK_INSTANCE_CAST (self, GALA_TYPE_ACCESS_DIALOG, GalaAccessDialog), "response", (guint) META_CLOSE_DIALOG_RESPONSE_FORCE_CLOSE);
	} else {
		g_signal_emit_by_name (G_TYPE_CHECK_INSTANCE_CAST (self, GALA_TYPE_ACCESS_DIALOG, GalaAccessDialog), "response", (guint) META_CLOSE_DIALOG_RESPONSE_WAIT);
	}
}

static MetaWindow*
gala_close_dialog_real_get_window (MetaCloseDialog* base)
{
	MetaWindow* result;
	GalaCloseDialog* self;
	MetaWindow* _tmp0_;
	MetaWindow* _tmp1_;
	self = (GalaCloseDialog*) base;
	_tmp0_ = gala_access_dialog_get_parent ((GalaAccessDialog*) self);
	_tmp1_ = _tmp0_;
	result = _tmp1_;
	return result;
}

static void
gala_close_dialog_real_set_window (MetaCloseDialog* base,
                                   MetaWindow* value)
{
	GalaCloseDialog* self;
	self = (GalaCloseDialog*) base;
	gala_access_dialog_set_parent ((GalaAccessDialog*) self, value);
	g_object_notify_by_pspec ((GObject *) self, gala_close_dialog_properties[GALA_CLOSE_DIALOG_WINDOW_PROPERTY]);
}

GalaApp*
gala_close_dialog_get_app (GalaCloseDialog* self)
{
	GalaApp* result;
	GalaApp* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_app;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
gala_close_dialog_set_app (GalaCloseDialog* self,
                           GalaApp* value)
{
	GalaApp* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_close_dialog_get_app (self);
	if (old_value != value) {
		GalaApp* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_app);
		self->priv->_app = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_close_dialog_properties[GALA_CLOSE_DIALOG_APP_PROPERTY]);
	}
}

static GObject *
gala_close_dialog_constructor (GType type,
                               guint n_construct_properties,
                               GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GalaCloseDialog * self;
	gchar* window_title = NULL;
	GalaApp* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	parent_class = G_OBJECT_CLASS (gala_close_dialog_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_CLOSE_DIALOG, GalaCloseDialog);
	gala_access_dialog_set_icon ((GalaAccessDialog*) self, "computer-fail");
	_tmp0_ = self->priv->_app;
	_tmp1_ = gala_app_get_name (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup (_tmp2_);
	window_title = _tmp3_;
	_tmp4_ = window_title;
	if (_tmp4_ != NULL) {
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp5_ = window_title;
		_tmp6_ = g_strdup_printf (_ ("“%s” is not responding"), _tmp5_);
		_tmp7_ = _tmp6_;
		gala_access_dialog_set_title ((GalaAccessDialog*) self, _tmp7_);
		_g_free0 (_tmp7_);
	} else {
		gala_access_dialog_set_title ((GalaAccessDialog*) self, _ ("Application is not responding"));
	}
	gala_access_dialog_set_body ((GalaAccessDialog*) self, _ ("You may choose to wait a short while for the application to continue, " \
"or force it to quit entirely."));
	gala_access_dialog_set_accept_label ((GalaAccessDialog*) self, _ ("Force Quit"));
	gala_access_dialog_set_deny_label ((GalaAccessDialog*) self, _ ("Wait"));
	_g_free0 (window_title);
	return obj;
}

static void
gala_close_dialog_class_init (GalaCloseDialogClass * klass,
                              gpointer klass_data)
{
	gala_close_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaCloseDialog_private_offset);
	((GalaAccessDialogClass *) klass)->show = (void (*) (GalaAccessDialog*)) gala_close_dialog_real_show;
	((GalaAccessDialogClass *) klass)->on_response = (void (*) (GalaAccessDialog*, guint)) gala_close_dialog_real_on_response;
	G_OBJECT_CLASS (klass)->get_property = _vala_gala_close_dialog_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gala_close_dialog_set_property;
	G_OBJECT_CLASS (klass)->constructor = gala_close_dialog_constructor;
	G_OBJECT_CLASS (klass)->finalize = gala_close_dialog_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_CLOSE_DIALOG_WINDOW_PROPERTY, gala_close_dialog_properties[GALA_CLOSE_DIALOG_WINDOW_PROPERTY] = g_param_spec_object ("window", "window", "window", meta_window_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_CLOSE_DIALOG_APP_PROPERTY, gala_close_dialog_properties[GALA_CLOSE_DIALOG_APP_PROPERTY] = g_param_spec_object ("app", "app", "app", GALA_TYPE_APP, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
gala_close_dialog_meta_close_dialog_interface_init (MetaCloseDialogInterface * iface,
                                                    gpointer iface_data)
{
	gala_close_dialog_meta_close_dialog_parent_iface = g_type_interface_peek_parent (iface);
	iface->show = (void (*) (MetaCloseDialog*)) gala_close_dialog_real_show;
	iface->hide = (void (*) (MetaCloseDialog*)) gala_close_dialog_real_hide;
	iface->focus = (void (*) (MetaCloseDialog*)) gala_close_dialog_real_focus;
}

static void
gala_close_dialog_instance_init (GalaCloseDialog * self,
                                 gpointer klass)
{
	self->priv = gala_close_dialog_get_instance_private (self);
}

static void
gala_close_dialog_finalize (GObject * obj)
{
	GalaCloseDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_CLOSE_DIALOG, GalaCloseDialog);
	_g_object_unref0 (self->priv->_app);
	G_OBJECT_CLASS (gala_close_dialog_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
gala_close_dialog_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaCloseDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_close_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaCloseDialog), 0, (GInstanceInitFunc) gala_close_dialog_instance_init, NULL };
	static const GInterfaceInfo meta_close_dialog_info = { (GInterfaceInitFunc) gala_close_dialog_meta_close_dialog_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType gala_close_dialog_type_id;
	gala_close_dialog_type_id = g_type_register_static (GALA_TYPE_ACCESS_DIALOG, "GalaCloseDialog", &g_define_type_info, 0);
	g_type_add_interface_static (gala_close_dialog_type_id, meta_close_dialog_get_type (), &meta_close_dialog_info);
	GalaCloseDialog_private_offset = g_type_add_instance_private (gala_close_dialog_type_id, sizeof (GalaCloseDialogPrivate));
	return gala_close_dialog_type_id;
}

GType
gala_close_dialog_get_type (void)
{
	static gsize gala_close_dialog_type_id__once = 0;
	if (g_once_init_enter (&gala_close_dialog_type_id__once)) {
		GType gala_close_dialog_type_id;
		gala_close_dialog_type_id = gala_close_dialog_get_type_once ();
		g_once_init_leave (&gala_close_dialog_type_id__once, gala_close_dialog_type_id);
	}
	return gala_close_dialog_type_id__once;
}

static void
_vala_gala_close_dialog_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec)
{
	GalaCloseDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_CLOSE_DIALOG, GalaCloseDialog);
	switch (property_id) {
		case GALA_CLOSE_DIALOG_WINDOW_PROPERTY:
		g_value_take_object (value, gala_close_dialog_real_get_window ((MetaCloseDialog*) self));
		break;
		case GALA_CLOSE_DIALOG_APP_PROPERTY:
		g_value_set_object (value, gala_close_dialog_get_app (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gala_close_dialog_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec)
{
	GalaCloseDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_CLOSE_DIALOG, GalaCloseDialog);
	switch (property_id) {
		case GALA_CLOSE_DIALOG_WINDOW_PROPERTY:
		gala_close_dialog_real_set_window ((MetaCloseDialog*) self, g_value_get_object (value));
		break;
		case GALA_CLOSE_DIALOG_APP_PROPERTY:
		gala_close_dialog_set_app (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

