// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.5
// 	protoc        v6.30.2
// source: log.proto

package gitalypb

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// LogEntry is a single entry in a partition's write-ahead log.
//
// Schema for :
// - `partition/<partition_id>/log/entry/<log_index>`.
type LogEntry struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// relative_path is the relative path of the repository the changes in the
	// log entry are targeting.
	RelativePath string `protobuf:"bytes,1,opt,name=relative_path,json=relativePath,proto3" json:"relative_path,omitempty"`
	// reference_transactions contains the reference transactions this
	// entry records. The logged reference updates have already passed
	// through verification and are applied without any further checks.
	// The reference transactions are applied in order.
	ReferenceTransactions []*LogEntry_ReferenceTransaction `protobuf:"bytes,2,rep,name=reference_transactions,json=referenceTransactions,proto3" json:"reference_transactions,omitempty"`
	// repository_deletion, when set, indicates this log entry deletes the repository.
	RepositoryDeletion *LogEntry_RepositoryDeletion `protobuf:"bytes,6,opt,name=repository_deletion,json=repositoryDeletion,proto3" json:"repository_deletion,omitempty"`
	// housekeeping, when set, indicates this log entry contains a housekeeping task.
	Housekeeping *LogEntry_Housekeeping `protobuf:"bytes,9,opt,name=housekeeping,proto3" json:"housekeeping,omitempty"`
	// operations is an ordered list of operations to run in order to apply
	// this log entry.
	Operations    []*LogEntry_Operation `protobuf:"bytes,10,rep,name=operations,proto3" json:"operations,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *LogEntry) Reset() {
	*x = LogEntry{}
	mi := &file_log_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LogEntry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LogEntry) ProtoMessage() {}

func (x *LogEntry) ProtoReflect() protoreflect.Message {
	mi := &file_log_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LogEntry.ProtoReflect.Descriptor instead.
func (*LogEntry) Descriptor() ([]byte, []int) {
	return file_log_proto_rawDescGZIP(), []int{0}
}

func (x *LogEntry) GetRelativePath() string {
	if x != nil {
		return x.RelativePath
	}
	return ""
}

func (x *LogEntry) GetReferenceTransactions() []*LogEntry_ReferenceTransaction {
	if x != nil {
		return x.ReferenceTransactions
	}
	return nil
}

func (x *LogEntry) GetRepositoryDeletion() *LogEntry_RepositoryDeletion {
	if x != nil {
		return x.RepositoryDeletion
	}
	return nil
}

func (x *LogEntry) GetHousekeeping() *LogEntry_Housekeeping {
	if x != nil {
		return x.Housekeeping
	}
	return nil
}

func (x *LogEntry) GetOperations() []*LogEntry_Operation {
	if x != nil {
		return x.Operations
	}
	return nil
}

// LSN serializes a log sequence number. It's used for storing a partition's
// applied LSN in the database.
//
// Schema for:
// - `partition/<partition_id>/applied_lsn`
type LSN struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// value is an LSN pointing to a position in the log.
	Value         uint64 `protobuf:"varint,1,opt,name=value,proto3" json:"value,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *LSN) Reset() {
	*x = LSN{}
	mi := &file_log_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LSN) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LSN) ProtoMessage() {}

func (x *LSN) ProtoReflect() protoreflect.Message {
	mi := &file_log_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LSN.ProtoReflect.Descriptor instead.
func (*LSN) Descriptor() ([]byte, []int) {
	return file_log_proto_rawDescGZIP(), []int{1}
}

func (x *LSN) GetValue() uint64 {
	if x != nil {
		return x.Value
	}
	return 0
}

// ReferenceTransaction models a single reference transaction.
type LogEntry_ReferenceTransaction struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// changes are the reference changes performed in this reference transaction.
	Changes       []*LogEntry_ReferenceTransaction_Change `protobuf:"bytes,1,rep,name=changes,proto3" json:"changes,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *LogEntry_ReferenceTransaction) Reset() {
	*x = LogEntry_ReferenceTransaction{}
	mi := &file_log_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LogEntry_ReferenceTransaction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LogEntry_ReferenceTransaction) ProtoMessage() {}

func (x *LogEntry_ReferenceTransaction) ProtoReflect() protoreflect.Message {
	mi := &file_log_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LogEntry_ReferenceTransaction.ProtoReflect.Descriptor instead.
func (*LogEntry_ReferenceTransaction) Descriptor() ([]byte, []int) {
	return file_log_proto_rawDescGZIP(), []int{0, 0}
}

func (x *LogEntry_ReferenceTransaction) GetChanges() []*LogEntry_ReferenceTransaction_Change {
	if x != nil {
		return x.Changes
	}
	return nil
}

// RepositoryDeletion models a repository deletion.
type LogEntry_RepositoryDeletion struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *LogEntry_RepositoryDeletion) Reset() {
	*x = LogEntry_RepositoryDeletion{}
	mi := &file_log_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LogEntry_RepositoryDeletion) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LogEntry_RepositoryDeletion) ProtoMessage() {}

func (x *LogEntry_RepositoryDeletion) ProtoReflect() protoreflect.Message {
	mi := &file_log_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LogEntry_RepositoryDeletion.ProtoReflect.Descriptor instead.
func (*LogEntry_RepositoryDeletion) Descriptor() ([]byte, []int) {
	return file_log_proto_rawDescGZIP(), []int{0, 1}
}

// Housekeeping models a housekeeping run. All of the operations are modeled by file system
// operations. This message is still kept around for conflict checking concurrent housekeeping
// runs.
type LogEntry_Housekeeping struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// pack_refs signifies if the housekeeping run includes a pack-refs task.
	PackRefs *LogEntry_Housekeeping_PackRefs `protobuf:"bytes,1,opt,name=pack_refs,json=packRefs,proto3" json:"pack_refs,omitempty"`
	// offloading, when set, indicates this log entry contains a offloading task.
	Offloading    *LogEntry_Housekeeping_Offloading `protobuf:"bytes,2,opt,name=offloading,proto3" json:"offloading,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *LogEntry_Housekeeping) Reset() {
	*x = LogEntry_Housekeeping{}
	mi := &file_log_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LogEntry_Housekeeping) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LogEntry_Housekeeping) ProtoMessage() {}

func (x *LogEntry_Housekeeping) ProtoReflect() protoreflect.Message {
	mi := &file_log_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LogEntry_Housekeeping.ProtoReflect.Descriptor instead.
func (*LogEntry_Housekeeping) Descriptor() ([]byte, []int) {
	return file_log_proto_rawDescGZIP(), []int{0, 2}
}

func (x *LogEntry_Housekeeping) GetPackRefs() *LogEntry_Housekeeping_PackRefs {
	if x != nil {
		return x.PackRefs
	}
	return nil
}

func (x *LogEntry_Housekeeping) GetOffloading() *LogEntry_Housekeeping_Offloading {
	if x != nil {
		return x.Offloading
	}
	return nil
}

// Operation models a single operation to be performed.
type LogEntry_Operation struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Types that are valid to be assigned to Operation:
	//
	//	*LogEntry_Operation_CreateHardLink_
	//	*LogEntry_Operation_RemoveDirectoryEntry_
	//	*LogEntry_Operation_CreateDirectory_
	//	*LogEntry_Operation_SetKey_
	//	*LogEntry_Operation_DeleteKey_
	Operation     isLogEntry_Operation_Operation `protobuf_oneof:"operation"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *LogEntry_Operation) Reset() {
	*x = LogEntry_Operation{}
	mi := &file_log_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LogEntry_Operation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LogEntry_Operation) ProtoMessage() {}

func (x *LogEntry_Operation) ProtoReflect() protoreflect.Message {
	mi := &file_log_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LogEntry_Operation.ProtoReflect.Descriptor instead.
func (*LogEntry_Operation) Descriptor() ([]byte, []int) {
	return file_log_proto_rawDescGZIP(), []int{0, 3}
}

func (x *LogEntry_Operation) GetOperation() isLogEntry_Operation_Operation {
	if x != nil {
		return x.Operation
	}
	return nil
}

func (x *LogEntry_Operation) GetCreateHardLink() *LogEntry_Operation_CreateHardLink {
	if x != nil {
		if x, ok := x.Operation.(*LogEntry_Operation_CreateHardLink_); ok {
			return x.CreateHardLink
		}
	}
	return nil
}

func (x *LogEntry_Operation) GetRemoveDirectoryEntry() *LogEntry_Operation_RemoveDirectoryEntry {
	if x != nil {
		if x, ok := x.Operation.(*LogEntry_Operation_RemoveDirectoryEntry_); ok {
			return x.RemoveDirectoryEntry
		}
	}
	return nil
}

func (x *LogEntry_Operation) GetCreateDirectory() *LogEntry_Operation_CreateDirectory {
	if x != nil {
		if x, ok := x.Operation.(*LogEntry_Operation_CreateDirectory_); ok {
			return x.CreateDirectory
		}
	}
	return nil
}

func (x *LogEntry_Operation) GetSetKey() *LogEntry_Operation_SetKey {
	if x != nil {
		if x, ok := x.Operation.(*LogEntry_Operation_SetKey_); ok {
			return x.SetKey
		}
	}
	return nil
}

func (x *LogEntry_Operation) GetDeleteKey() *LogEntry_Operation_DeleteKey {
	if x != nil {
		if x, ok := x.Operation.(*LogEntry_Operation_DeleteKey_); ok {
			return x.DeleteKey
		}
	}
	return nil
}

type isLogEntry_Operation_Operation interface {
	isLogEntry_Operation_Operation()
}

type LogEntry_Operation_CreateHardLink_ struct {
	// create_hard_link creates a hard link in the storage.
	CreateHardLink *LogEntry_Operation_CreateHardLink `protobuf:"bytes,1,opt,name=create_hard_link,json=createHardLink,proto3,oneof"`
}

type LogEntry_Operation_RemoveDirectoryEntry_ struct {
	// remove_directory_entry removes a directory entry from the storage.
	RemoveDirectoryEntry *LogEntry_Operation_RemoveDirectoryEntry `protobuf:"bytes,2,opt,name=remove_directory_entry,json=removeDirectoryEntry,proto3,oneof"`
}

type LogEntry_Operation_CreateDirectory_ struct {
	// create_directory creates a directory in the storage.
	CreateDirectory *LogEntry_Operation_CreateDirectory `protobuf:"bytes,3,opt,name=create_directory,json=createDirectory,proto3,oneof"`
}

type LogEntry_Operation_SetKey_ struct {
	// set_key sets a key with a given value in the key-value store.
	SetKey *LogEntry_Operation_SetKey `protobuf:"bytes,4,opt,name=set_key,json=setKey,proto3,oneof"`
}

type LogEntry_Operation_DeleteKey_ struct {
	// delete_key deletes a given key from the key-value store.
	DeleteKey *LogEntry_Operation_DeleteKey `protobuf:"bytes,5,opt,name=delete_key,json=deleteKey,proto3,oneof"`
}

func (*LogEntry_Operation_CreateHardLink_) isLogEntry_Operation_Operation() {}

func (*LogEntry_Operation_RemoveDirectoryEntry_) isLogEntry_Operation_Operation() {}

func (*LogEntry_Operation_CreateDirectory_) isLogEntry_Operation_Operation() {}

func (*LogEntry_Operation_SetKey_) isLogEntry_Operation_Operation() {}

func (*LogEntry_Operation_DeleteKey_) isLogEntry_Operation_Operation() {}

// Change models a single reference change.
type LogEntry_ReferenceTransaction_Change struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// reference_name is the fully qualified name of the reference
	// to update.
	ReferenceName []byte `protobuf:"bytes,1,opt,name=reference_name,json=referenceName,proto3" json:"reference_name,omitempty"`
	// new_oid is the new oid to point the reference to. Deletions
	// are denoted as the SHA1 or SHA256 zero OID depending on the
	// hash type used in the repository.
	NewOid []byte `protobuf:"bytes,2,opt,name=new_oid,json=newOid,proto3" json:"new_oid,omitempty"`
	// new_target is the new target reference that the reference will
	// point to. This is used for symbolic reference updates such
	// as the default branch update.
	NewTarget     []byte `protobuf:"bytes,3,opt,name=new_target,json=newTarget,proto3" json:"new_target,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *LogEntry_ReferenceTransaction_Change) Reset() {
	*x = LogEntry_ReferenceTransaction_Change{}
	mi := &file_log_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LogEntry_ReferenceTransaction_Change) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LogEntry_ReferenceTransaction_Change) ProtoMessage() {}

func (x *LogEntry_ReferenceTransaction_Change) ProtoReflect() protoreflect.Message {
	mi := &file_log_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LogEntry_ReferenceTransaction_Change.ProtoReflect.Descriptor instead.
func (*LogEntry_ReferenceTransaction_Change) Descriptor() ([]byte, []int) {
	return file_log_proto_rawDescGZIP(), []int{0, 0, 0}
}

func (x *LogEntry_ReferenceTransaction_Change) GetReferenceName() []byte {
	if x != nil {
		return x.ReferenceName
	}
	return nil
}

func (x *LogEntry_ReferenceTransaction_Change) GetNewOid() []byte {
	if x != nil {
		return x.NewOid
	}
	return nil
}

func (x *LogEntry_ReferenceTransaction_Change) GetNewTarget() []byte {
	if x != nil {
		return x.NewTarget
	}
	return nil
}

// PackRefs models a pack-refs housekeeping task.
type LogEntry_Housekeeping_PackRefs struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *LogEntry_Housekeeping_PackRefs) Reset() {
	*x = LogEntry_Housekeeping_PackRefs{}
	mi := &file_log_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LogEntry_Housekeeping_PackRefs) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LogEntry_Housekeeping_PackRefs) ProtoMessage() {}

func (x *LogEntry_Housekeeping_PackRefs) ProtoReflect() protoreflect.Message {
	mi := &file_log_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LogEntry_Housekeeping_PackRefs.ProtoReflect.Descriptor instead.
func (*LogEntry_Housekeeping_PackRefs) Descriptor() ([]byte, []int) {
	return file_log_proto_rawDescGZIP(), []int{0, 2, 0}
}

// Offloading models a offloading task.
type LogEntry_Housekeeping_Offloading struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *LogEntry_Housekeeping_Offloading) Reset() {
	*x = LogEntry_Housekeeping_Offloading{}
	mi := &file_log_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LogEntry_Housekeeping_Offloading) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LogEntry_Housekeeping_Offloading) ProtoMessage() {}

func (x *LogEntry_Housekeeping_Offloading) ProtoReflect() protoreflect.Message {
	mi := &file_log_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LogEntry_Housekeeping_Offloading.ProtoReflect.Descriptor instead.
func (*LogEntry_Housekeeping_Offloading) Descriptor() ([]byte, []int) {
	return file_log_proto_rawDescGZIP(), []int{0, 2, 1}
}

// CreateHardLink creates a hard link. The existing inode metadata, including
// permissions, will be shared with all of the hard links to the same file.
type LogEntry_Operation_CreateHardLink struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// source_path is the relative path of the file the hard link should point to.
	SourcePath []byte `protobuf:"bytes,1,opt,name=source_path,json=sourcePath,proto3" json:"source_path,omitempty"`
	// source_in_storage is set when the source path is relative to the storage
	// root instead of the log entry.
	SourceInStorage bool `protobuf:"varint,2,opt,name=source_in_storage,json=sourceInStorage,proto3" json:"source_in_storage,omitempty"`
	// destination_path is a relative path from the storage root to where the hard
	// link should be created at.
	DestinationPath []byte `protobuf:"bytes,3,opt,name=destination_path,json=destinationPath,proto3" json:"destination_path,omitempty"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *LogEntry_Operation_CreateHardLink) Reset() {
	*x = LogEntry_Operation_CreateHardLink{}
	mi := &file_log_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LogEntry_Operation_CreateHardLink) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LogEntry_Operation_CreateHardLink) ProtoMessage() {}

func (x *LogEntry_Operation_CreateHardLink) ProtoReflect() protoreflect.Message {
	mi := &file_log_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LogEntry_Operation_CreateHardLink.ProtoReflect.Descriptor instead.
func (*LogEntry_Operation_CreateHardLink) Descriptor() ([]byte, []int) {
	return file_log_proto_rawDescGZIP(), []int{0, 3, 0}
}

func (x *LogEntry_Operation_CreateHardLink) GetSourcePath() []byte {
	if x != nil {
		return x.SourcePath
	}
	return nil
}

func (x *LogEntry_Operation_CreateHardLink) GetSourceInStorage() bool {
	if x != nil {
		return x.SourceInStorage
	}
	return false
}

func (x *LogEntry_Operation_CreateHardLink) GetDestinationPath() []byte {
	if x != nil {
		return x.DestinationPath
	}
	return nil
}

// RemoveDirectoryEntry removes a directory or a file
// from the parent directory. When removing a directory,
// it must be empty.
type LogEntry_Operation_RemoveDirectoryEntry struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// path is the relative path of the directory entry to remove in the storage.
	Path          []byte `protobuf:"bytes,1,opt,name=path,proto3" json:"path,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *LogEntry_Operation_RemoveDirectoryEntry) Reset() {
	*x = LogEntry_Operation_RemoveDirectoryEntry{}
	mi := &file_log_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LogEntry_Operation_RemoveDirectoryEntry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LogEntry_Operation_RemoveDirectoryEntry) ProtoMessage() {}

func (x *LogEntry_Operation_RemoveDirectoryEntry) ProtoReflect() protoreflect.Message {
	mi := &file_log_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LogEntry_Operation_RemoveDirectoryEntry.ProtoReflect.Descriptor instead.
func (*LogEntry_Operation_RemoveDirectoryEntry) Descriptor() ([]byte, []int) {
	return file_log_proto_rawDescGZIP(), []int{0, 3, 1}
}

func (x *LogEntry_Operation_RemoveDirectoryEntry) GetPath() []byte {
	if x != nil {
		return x.Path
	}
	return nil
}

// CreateDirectory creates a directory at a relative path.
type LogEntry_Operation_CreateDirectory struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// path is a relative path where to create the directory.
	Path []byte `protobuf:"bytes,1,opt,name=path,proto3" json:"path,omitempty"`
	// mode is the file mode to set on the created directory.
	Mode          uint32 `protobuf:"varint,2,opt,name=mode,proto3" json:"mode,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *LogEntry_Operation_CreateDirectory) Reset() {
	*x = LogEntry_Operation_CreateDirectory{}
	mi := &file_log_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LogEntry_Operation_CreateDirectory) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LogEntry_Operation_CreateDirectory) ProtoMessage() {}

func (x *LogEntry_Operation_CreateDirectory) ProtoReflect() protoreflect.Message {
	mi := &file_log_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LogEntry_Operation_CreateDirectory.ProtoReflect.Descriptor instead.
func (*LogEntry_Operation_CreateDirectory) Descriptor() ([]byte, []int) {
	return file_log_proto_rawDescGZIP(), []int{0, 3, 2}
}

func (x *LogEntry_Operation_CreateDirectory) GetPath() []byte {
	if x != nil {
		return x.Path
	}
	return nil
}

func (x *LogEntry_Operation_CreateDirectory) GetMode() uint32 {
	if x != nil {
		return x.Mode
	}
	return 0
}

// SetKey sets a key with a value in the key-value store.
type LogEntry_Operation_SetKey struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// key is the key to set.
	Key []byte `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// value is the value to set for the key.
	Value         []byte `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *LogEntry_Operation_SetKey) Reset() {
	*x = LogEntry_Operation_SetKey{}
	mi := &file_log_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LogEntry_Operation_SetKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LogEntry_Operation_SetKey) ProtoMessage() {}

func (x *LogEntry_Operation_SetKey) ProtoReflect() protoreflect.Message {
	mi := &file_log_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LogEntry_Operation_SetKey.ProtoReflect.Descriptor instead.
func (*LogEntry_Operation_SetKey) Descriptor() ([]byte, []int) {
	return file_log_proto_rawDescGZIP(), []int{0, 3, 3}
}

func (x *LogEntry_Operation_SetKey) GetKey() []byte {
	if x != nil {
		return x.Key
	}
	return nil
}

func (x *LogEntry_Operation_SetKey) GetValue() []byte {
	if x != nil {
		return x.Value
	}
	return nil
}

// DeleteKey deletes a key from the key-value store.
type LogEntry_Operation_DeleteKey struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// key is the key to delete.
	Key           []byte `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *LogEntry_Operation_DeleteKey) Reset() {
	*x = LogEntry_Operation_DeleteKey{}
	mi := &file_log_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LogEntry_Operation_DeleteKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LogEntry_Operation_DeleteKey) ProtoMessage() {}

func (x *LogEntry_Operation_DeleteKey) ProtoReflect() protoreflect.Message {
	mi := &file_log_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LogEntry_Operation_DeleteKey.ProtoReflect.Descriptor instead.
func (*LogEntry_Operation_DeleteKey) Descriptor() ([]byte, []int) {
	return file_log_proto_rawDescGZIP(), []int{0, 3, 4}
}

func (x *LogEntry_Operation_DeleteKey) GetKey() []byte {
	if x != nil {
		return x.Key
	}
	return nil
}

var File_log_proto protoreflect.FileDescriptor

var file_log_proto_rawDesc = string([]byte{
	0x0a, 0x09, 0x6c, 0x6f, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x06, 0x67, 0x69, 0x74,
	0x61, 0x6c, 0x79, 0x22, 0xf8, 0x0b, 0x0a, 0x08, 0x4c, 0x6f, 0x67, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x12, 0x23, 0x0a, 0x0d, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x70, 0x61, 0x74,
	0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x76,
	0x65, 0x50, 0x61, 0x74, 0x68, 0x12, 0x5c, 0x0a, 0x16, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18,
	0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x69, 0x74, 0x61, 0x6c, 0x79, 0x2e, 0x4c,
	0x6f, 0x67, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63,
	0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x15, 0x72, 0x65,
	0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x12, 0x54, 0x0a, 0x13, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72,
	0x79, 0x5f, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x23, 0x2e, 0x67, 0x69, 0x74, 0x61, 0x6c, 0x79, 0x2e, 0x4c, 0x6f, 0x67, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x12, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72,
	0x79, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x41, 0x0a, 0x0c, 0x68, 0x6f, 0x75,
	0x73, 0x65, 0x6b, 0x65, 0x65, 0x70, 0x69, 0x6e, 0x67, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1d, 0x2e, 0x67, 0x69, 0x74, 0x61, 0x6c, 0x79, 0x2e, 0x4c, 0x6f, 0x67, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x2e, 0x48, 0x6f, 0x75, 0x73, 0x65, 0x6b, 0x65, 0x65, 0x70, 0x69, 0x6e, 0x67, 0x52, 0x0c,
	0x68, 0x6f, 0x75, 0x73, 0x65, 0x6b, 0x65, 0x65, 0x70, 0x69, 0x6e, 0x67, 0x12, 0x3a, 0x0a, 0x0a,
	0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x69, 0x74, 0x61, 0x6c, 0x79, 0x2e, 0x4c, 0x6f, 0x67, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x6f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0xc7, 0x01, 0x0a, 0x14, 0x52, 0x65, 0x66,
	0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x46, 0x0a, 0x07, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x69, 0x74, 0x61, 0x6c, 0x79, 0x2e, 0x4c, 0x6f, 0x67, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x2e, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x54, 0x72,
	0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65,
	0x52, 0x07, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x1a, 0x67, 0x0a, 0x06, 0x43, 0x68, 0x61,
	0x6e, 0x67, 0x65, 0x12, 0x25, 0x0a, 0x0e, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0d, 0x72, 0x65, 0x66,
	0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x17, 0x0a, 0x07, 0x6e, 0x65,
	0x77, 0x5f, 0x6f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x06, 0x6e, 0x65, 0x77,
	0x4f, 0x69, 0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x6e, 0x65, 0x77, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x09, 0x6e, 0x65, 0x77, 0x54, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x1a, 0x14, 0x0a, 0x12, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0xb7, 0x01, 0x0a, 0x0c, 0x48, 0x6f, 0x75,
	0x73, 0x65, 0x6b, 0x65, 0x65, 0x70, 0x69, 0x6e, 0x67, 0x12, 0x43, 0x0a, 0x09, 0x70, 0x61, 0x63,
	0x6b, 0x5f, 0x72, 0x65, 0x66, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67,
	0x69, 0x74, 0x61, 0x6c, 0x79, 0x2e, 0x4c, 0x6f, 0x67, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x48,
	0x6f, 0x75, 0x73, 0x65, 0x6b, 0x65, 0x65, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x50, 0x61, 0x63, 0x6b,
	0x52, 0x65, 0x66, 0x73, 0x52, 0x08, 0x70, 0x61, 0x63, 0x6b, 0x52, 0x65, 0x66, 0x73, 0x12, 0x48,
	0x0a, 0x0a, 0x6f, 0x66, 0x66, 0x6c, 0x6f, 0x61, 0x64, 0x69, 0x6e, 0x67, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x69, 0x74, 0x61, 0x6c, 0x79, 0x2e, 0x4c, 0x6f, 0x67, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x2e, 0x48, 0x6f, 0x75, 0x73, 0x65, 0x6b, 0x65, 0x65, 0x70, 0x69, 0x6e,
	0x67, 0x2e, 0x4f, 0x66, 0x66, 0x6c, 0x6f, 0x61, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x0a, 0x6f, 0x66,
	0x66, 0x6c, 0x6f, 0x61, 0x64, 0x69, 0x6e, 0x67, 0x1a, 0x0a, 0x0a, 0x08, 0x50, 0x61, 0x63, 0x6b,
	0x52, 0x65, 0x66, 0x73, 0x1a, 0x0c, 0x0a, 0x0a, 0x4f, 0x66, 0x66, 0x6c, 0x6f, 0x61, 0x64, 0x69,
	0x6e, 0x67, 0x1a, 0xf9, 0x05, 0x0a, 0x09, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x55, 0x0a, 0x10, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x68, 0x61, 0x72, 0x64, 0x5f,
	0x6c, 0x69, 0x6e, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x69, 0x74,
	0x61, 0x6c, 0x79, 0x2e, 0x4c, 0x6f, 0x67, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x48, 0x61, 0x72,
	0x64, 0x4c, 0x69, 0x6e, 0x6b, 0x48, 0x00, 0x52, 0x0e, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x48,
	0x61, 0x72, 0x64, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x67, 0x0a, 0x16, 0x72, 0x65, 0x6d, 0x6f, 0x76,
	0x65, 0x5f, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x65, 0x6e, 0x74, 0x72,
	0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x69, 0x74, 0x61, 0x6c, 0x79,
	0x2e, 0x4c, 0x6f, 0x67, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74,
	0x6f, 0x72, 0x79, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x48, 0x00, 0x52, 0x14, 0x72, 0x65, 0x6d, 0x6f,
	0x76, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x12, 0x57, 0x0a, 0x10, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x64, 0x69, 0x72, 0x65, 0x63,
	0x74, 0x6f, 0x72, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x69, 0x74,
	0x61, 0x6c, 0x79, 0x2e, 0x4c, 0x6f, 0x67, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x44, 0x69, 0x72,
	0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x48, 0x00, 0x52, 0x0f, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x3c, 0x0a, 0x07, 0x73, 0x65, 0x74,
	0x5f, 0x6b, 0x65, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x69, 0x74,
	0x61, 0x6c, 0x79, 0x2e, 0x4c, 0x6f, 0x67, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x53, 0x65, 0x74, 0x4b, 0x65, 0x79, 0x48, 0x00, 0x52,
	0x06, 0x73, 0x65, 0x74, 0x4b, 0x65, 0x79, 0x12, 0x45, 0x0a, 0x0a, 0x64, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x69,
	0x74, 0x61, 0x6c, 0x79, 0x2e, 0x4c, 0x6f, 0x67, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4b, 0x65,
	0x79, 0x48, 0x00, 0x52, 0x09, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4b, 0x65, 0x79, 0x1a, 0x88,
	0x01, 0x0a, 0x0e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x48, 0x61, 0x72, 0x64, 0x4c, 0x69, 0x6e,
	0x6b, 0x12, 0x1f, 0x0a, 0x0b, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x70, 0x61, 0x74, 0x68,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0a, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x50, 0x61,
	0x74, 0x68, 0x12, 0x2a, 0x0a, 0x11, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x69, 0x6e, 0x5f,
	0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0f, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x49, 0x6e, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x12, 0x29,
	0x0a, 0x10, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x61,
	0x74, 0x68, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0f, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x61, 0x74, 0x68, 0x1a, 0x2a, 0x0a, 0x14, 0x52, 0x65, 0x6d,
	0x6f, 0x76, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x12, 0x12, 0x0a, 0x04, 0x70, 0x61, 0x74, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52,
	0x04, 0x70, 0x61, 0x74, 0x68, 0x1a, 0x39, 0x0a, 0x0f, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x44,
	0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x12, 0x0a, 0x04, 0x70, 0x61, 0x74, 0x68,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x04, 0x70, 0x61, 0x74, 0x68, 0x12, 0x12, 0x0a, 0x04,
	0x6d, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x04, 0x6d, 0x6f, 0x64, 0x65,
	0x1a, 0x30, 0x0a, 0x06, 0x53, 0x65, 0x74, 0x4b, 0x65, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x1a, 0x1d, 0x0a, 0x09, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4b, 0x65, 0x79, 0x12,
	0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x03, 0x6b, 0x65,
	0x79, 0x42, 0x0b, 0x0a, 0x09, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x1b,
	0x0a, 0x03, 0x4c, 0x53, 0x4e, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x04, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x34, 0x5a, 0x32, 0x67,
	0x69, 0x74, 0x6c, 0x61, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x69, 0x74, 0x6c, 0x61, 0x62,
	0x2d, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x69, 0x74, 0x61, 0x6c, 0x79, 0x2f, 0x76, 0x31, 0x38, 0x2f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x2f, 0x67, 0x69, 0x74, 0x61, 0x6c, 0x79, 0x70,
	0x62, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
})

var (
	file_log_proto_rawDescOnce sync.Once
	file_log_proto_rawDescData []byte
)

func file_log_proto_rawDescGZIP() []byte {
	file_log_proto_rawDescOnce.Do(func() {
		file_log_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_log_proto_rawDesc), len(file_log_proto_rawDesc)))
	})
	return file_log_proto_rawDescData
}

var file_log_proto_msgTypes = make([]protoimpl.MessageInfo, 14)
var file_log_proto_goTypes = []any{
	(*LogEntry)(nil),                                // 0: gitaly.LogEntry
	(*LSN)(nil),                                     // 1: gitaly.LSN
	(*LogEntry_ReferenceTransaction)(nil),           // 2: gitaly.LogEntry.ReferenceTransaction
	(*LogEntry_RepositoryDeletion)(nil),             // 3: gitaly.LogEntry.RepositoryDeletion
	(*LogEntry_Housekeeping)(nil),                   // 4: gitaly.LogEntry.Housekeeping
	(*LogEntry_Operation)(nil),                      // 5: gitaly.LogEntry.Operation
	(*LogEntry_ReferenceTransaction_Change)(nil),    // 6: gitaly.LogEntry.ReferenceTransaction.Change
	(*LogEntry_Housekeeping_PackRefs)(nil),          // 7: gitaly.LogEntry.Housekeeping.PackRefs
	(*LogEntry_Housekeeping_Offloading)(nil),        // 8: gitaly.LogEntry.Housekeeping.Offloading
	(*LogEntry_Operation_CreateHardLink)(nil),       // 9: gitaly.LogEntry.Operation.CreateHardLink
	(*LogEntry_Operation_RemoveDirectoryEntry)(nil), // 10: gitaly.LogEntry.Operation.RemoveDirectoryEntry
	(*LogEntry_Operation_CreateDirectory)(nil),      // 11: gitaly.LogEntry.Operation.CreateDirectory
	(*LogEntry_Operation_SetKey)(nil),               // 12: gitaly.LogEntry.Operation.SetKey
	(*LogEntry_Operation_DeleteKey)(nil),            // 13: gitaly.LogEntry.Operation.DeleteKey
}
var file_log_proto_depIdxs = []int32{
	2,  // 0: gitaly.LogEntry.reference_transactions:type_name -> gitaly.LogEntry.ReferenceTransaction
	3,  // 1: gitaly.LogEntry.repository_deletion:type_name -> gitaly.LogEntry.RepositoryDeletion
	4,  // 2: gitaly.LogEntry.housekeeping:type_name -> gitaly.LogEntry.Housekeeping
	5,  // 3: gitaly.LogEntry.operations:type_name -> gitaly.LogEntry.Operation
	6,  // 4: gitaly.LogEntry.ReferenceTransaction.changes:type_name -> gitaly.LogEntry.ReferenceTransaction.Change
	7,  // 5: gitaly.LogEntry.Housekeeping.pack_refs:type_name -> gitaly.LogEntry.Housekeeping.PackRefs
	8,  // 6: gitaly.LogEntry.Housekeeping.offloading:type_name -> gitaly.LogEntry.Housekeeping.Offloading
	9,  // 7: gitaly.LogEntry.Operation.create_hard_link:type_name -> gitaly.LogEntry.Operation.CreateHardLink
	10, // 8: gitaly.LogEntry.Operation.remove_directory_entry:type_name -> gitaly.LogEntry.Operation.RemoveDirectoryEntry
	11, // 9: gitaly.LogEntry.Operation.create_directory:type_name -> gitaly.LogEntry.Operation.CreateDirectory
	12, // 10: gitaly.LogEntry.Operation.set_key:type_name -> gitaly.LogEntry.Operation.SetKey
	13, // 11: gitaly.LogEntry.Operation.delete_key:type_name -> gitaly.LogEntry.Operation.DeleteKey
	12, // [12:12] is the sub-list for method output_type
	12, // [12:12] is the sub-list for method input_type
	12, // [12:12] is the sub-list for extension type_name
	12, // [12:12] is the sub-list for extension extendee
	0,  // [0:12] is the sub-list for field type_name
}

func init() { file_log_proto_init() }
func file_log_proto_init() {
	if File_log_proto != nil {
		return
	}
	file_log_proto_msgTypes[5].OneofWrappers = []any{
		(*LogEntry_Operation_CreateHardLink_)(nil),
		(*LogEntry_Operation_RemoveDirectoryEntry_)(nil),
		(*LogEntry_Operation_CreateDirectory_)(nil),
		(*LogEntry_Operation_SetKey_)(nil),
		(*LogEntry_Operation_DeleteKey_)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_log_proto_rawDesc), len(file_log_proto_rawDesc)),
			NumEnums:      0,
			NumMessages:   14,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_log_proto_goTypes,
		DependencyIndexes: file_log_proto_depIdxs,
		MessageInfos:      file_log_proto_msgTypes,
	}.Build()
	File_log_proto = out.File
	file_log_proto_goTypes = nil
	file_log_proto_depIdxs = nil
}
