/* ContractorProxy.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from ContractorProxy.vala, do not modify */

/*
 * Copyright 2011-2013 Lucas Baudin <xapantu@gmail.com>
 * Copyright 2011-2013 Akshay Shekher <voldyman666@gmail.com>
 * Copyright 2011-2013 Victor Martinez <victoreduardm@gmail.com>
 * SPDX-License-Identifier: LGPL-3.0-or-later
 */

#include "granite-7.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <glib-object.h>
#include <gee.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define GRANITE_SERVICES_TYPE_CONTRACT_DATA (granite_services_contract_data_get_type ())
typedef struct _GraniteServicesContractData GraniteServicesContractData;
#define _g_free0(var) (var = (g_free (var), NULL))

#define GRANITE_SERVICES_TYPE_CONTRACTOR_DBUS_API (granite_services_contractor_dbus_api_get_type ())
#define GRANITE_SERVICES_CONTRACTOR_DBUS_API(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GRANITE_SERVICES_TYPE_CONTRACTOR_DBUS_API, GraniteServicesContractorDBusAPI))
#define GRANITE_SERVICES_IS_CONTRACTOR_DBUS_API(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GRANITE_SERVICES_TYPE_CONTRACTOR_DBUS_API))
#define GRANITE_SERVICES_CONTRACTOR_DBUS_API_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GRANITE_SERVICES_TYPE_CONTRACTOR_DBUS_API, GraniteServicesContractorDBusAPIIface))

typedef struct _GraniteServicesContractorDBusAPI GraniteServicesContractorDBusAPI;
typedef struct _GraniteServicesContractorDBusAPIIface GraniteServicesContractorDBusAPIIface;

#define GRANITE_SERVICES_TYPE_CONTRACTOR_DBUS_API_PROXY (granite_services_contractor_dbus_api_proxy_get_type ())
enum  {
	GRANITE_SERVICES_CONTRACTOR_DBUS_API_CONTRACTS_CHANGED_SIGNAL,
	GRANITE_SERVICES_CONTRACTOR_DBUS_API_NUM_SIGNALS
};
static guint granite_services_contractor_dbus_api_signals[GRANITE_SERVICES_CONTRACTOR_DBUS_API_NUM_SIGNALS] = {0};
typedef GDBusProxy GraniteServicesContractorDBusAPIProxy;
typedef GDBusProxyClass GraniteServicesContractorDBusAPIProxyClass;
enum  {
	GRANITE_SERVICES_CONTRACTOR_PROXY_0_PROPERTY,
	GRANITE_SERVICES_CONTRACTOR_PROXY_NUM_PROPERTIES
};
static GParamSpec* granite_services_contractor_proxy_properties[GRANITE_SERVICES_CONTRACTOR_PROXY_NUM_PROPERTIES];

#define GRANITE_SERVICES_CONTRACTOR_PROXY_TYPE_GENERIC_CONTRACT (granite_services_contractor_proxy_generic_contract_get_type ())
#define GRANITE_SERVICES_CONTRACTOR_PROXY_GENERIC_CONTRACT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GRANITE_SERVICES_CONTRACTOR_PROXY_TYPE_GENERIC_CONTRACT, GraniteServicesContractorProxyGenericContract))
#define GRANITE_SERVICES_CONTRACTOR_PROXY_GENERIC_CONTRACT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GRANITE_SERVICES_CONTRACTOR_PROXY_TYPE_GENERIC_CONTRACT, GraniteServicesContractorProxyGenericContractClass))
#define GRANITE_SERVICES_CONTRACTOR_PROXY_IS_GENERIC_CONTRACT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GRANITE_SERVICES_CONTRACTOR_PROXY_TYPE_GENERIC_CONTRACT))
#define GRANITE_SERVICES_CONTRACTOR_PROXY_IS_GENERIC_CONTRACT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GRANITE_SERVICES_CONTRACTOR_PROXY_TYPE_GENERIC_CONTRACT))
#define GRANITE_SERVICES_CONTRACTOR_PROXY_GENERIC_CONTRACT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GRANITE_SERVICES_CONTRACTOR_PROXY_TYPE_GENERIC_CONTRACT, GraniteServicesContractorProxyGenericContractClass))

typedef struct _GraniteServicesContractorProxyGenericContract GraniteServicesContractorProxyGenericContract;
typedef struct _GraniteServicesContractorProxyGenericContractClass GraniteServicesContractorProxyGenericContractClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _GraniteServicesContractorProxyGenericContractPrivate GraniteServicesContractorProxyGenericContractPrivate;
enum  {
	GRANITE_SERVICES_CONTRACTOR_PROXY_GENERIC_CONTRACT_0_PROPERTY,
	GRANITE_SERVICES_CONTRACTOR_PROXY_GENERIC_CONTRACT_ID_PROPERTY,
	GRANITE_SERVICES_CONTRACTOR_PROXY_GENERIC_CONTRACT_NUM_PROPERTIES
};
static GParamSpec* granite_services_contractor_proxy_generic_contract_properties[GRANITE_SERVICES_CONTRACTOR_PROXY_GENERIC_CONTRACT_NUM_PROPERTIES];
enum  {
	GRANITE_SERVICES_CONTRACTOR_PROXY_CONTRACTS_CHANGED_SIGNAL,
	GRANITE_SERVICES_CONTRACTOR_PROXY_NUM_SIGNALS
};
static guint granite_services_contractor_proxy_signals[GRANITE_SERVICES_CONTRACTOR_PROXY_NUM_SIGNALS] = {0};

/**
     * thrown by {@link Granite.Services.ContractorProxy}
     */
struct _GraniteServicesContractData {
	gchar* id;
	gchar* display_name;
	gchar* description;
	gchar* icon;
};

struct _GraniteServicesContractorDBusAPIIface {
	GTypeInterface parent_iface;
	GraniteServicesContractData* (*list_all_contracts) (GraniteServicesContractorDBusAPI* self, gint* result_length1, GError** error);
	GraniteServicesContractData* (*get_contracts_by_mime) (GraniteServicesContractorDBusAPI* self, const gchar* mime_type, gint* result_length1, GError** error);
	GraniteServicesContractData* (*get_contracts_by_mimelist) (GraniteServicesContractorDBusAPI* self, gchar** mime_types, gint mime_types_length1, gint* result_length1, GError** error);
	void (*execute_with_uri) (GraniteServicesContractorDBusAPI* self, const gchar* id, const gchar* uri, GError** error);
	void (*execute_with_uri_list) (GraniteServicesContractorDBusAPI* self, const gchar* id, gchar** uri, gint uri_length1, GError** error);
};

struct _GraniteServicesContractorProxyGenericContract {
	GObject parent_instance;
	GraniteServicesContractorProxyGenericContractPrivate * priv;
};

struct _GraniteServicesContractorProxyGenericContractClass {
	GObjectClass parent_class;
};

struct _GraniteServicesContractorProxyGenericContractPrivate {
	gchar* _id;
	gchar* display_name;
	gchar* description;
	gchar* icon_key;
	GIcon* icon;
};

static gpointer granite_services_contractor_proxy_parent_class = NULL;
static GraniteServicesContractorDBusAPI* granite_services_contractor_proxy_contractor_dbus;
static GraniteServicesContractorDBusAPI* granite_services_contractor_proxy_contractor_dbus = NULL;
static GeeHashMap* granite_services_contractor_proxy_contracts;
static GeeHashMap* granite_services_contractor_proxy_contracts = NULL;
static GraniteServicesContractorProxy* granite_services_contractor_proxy_instance;
static GraniteServicesContractorProxy* granite_services_contractor_proxy_instance = NULL;
static gint GraniteServicesContractorProxyGenericContract_private_offset;
static gpointer granite_services_contractor_proxy_generic_contract_parent_class = NULL;
static GraniteServicesContractIface * granite_services_contractor_proxy_generic_contract_granite_services_contract_parent_iface = NULL;

static GType granite_services_contract_get_type_once (void);
 G_GNUC_INTERNAL GType granite_services_contract_data_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
 G_GNUC_INTERNAL GraniteServicesContractData* granite_services_contract_data_dup (const GraniteServicesContractData* self);
 G_GNUC_INTERNAL void granite_services_contract_data_free (GraniteServicesContractData* self);
 G_GNUC_INTERNAL void granite_services_contract_data_copy (const GraniteServicesContractData* self,
                                          GraniteServicesContractData* dest);
 G_GNUC_INTERNAL void granite_services_contract_data_destroy (GraniteServicesContractData* self);
VALA_EXTERN GType granite_services_contractor_dbus_api_proxy_get_type (void) G_GNUC_CONST ;
 G_GNUC_INTERNAL guint granite_services_contractor_dbus_api_register_object (void* object,
                                                            GDBusConnection* connection,
                                                            const gchar* path,
                                                            GError** error);
 G_GNUC_INTERNAL GType granite_services_contractor_dbus_api_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
 G_GNUC_INTERNAL GraniteServicesContractData* granite_services_contractor_dbus_api_list_all_contracts (GraniteServicesContractorDBusAPI* self,
                                                                                      gint* result_length1,
                                                                                      GError** error);
 G_GNUC_INTERNAL GraniteServicesContractData* granite_services_contractor_dbus_api_get_contracts_by_mime (GraniteServicesContractorDBusAPI* self,
                                                                                         const gchar* mime_type,
                                                                                         gint* result_length1,
                                                                                         GError** error);
 G_GNUC_INTERNAL GraniteServicesContractData* granite_services_contractor_dbus_api_get_contracts_by_mimelist (GraniteServicesContractorDBusAPI* self,
                                                                                             gchar** mime_types,
                                                                                             gint mime_types_length1,
                                                                                             gint* result_length1,
                                                                                             GError** error);
 G_GNUC_INTERNAL void granite_services_contractor_dbus_api_execute_with_uri (GraniteServicesContractorDBusAPI* self,
                                                            const gchar* id,
                                                            const gchar* uri,
                                                            GError** error);
 G_GNUC_INTERNAL void granite_services_contractor_dbus_api_execute_with_uri_list (GraniteServicesContractorDBusAPI* self,
                                                                 const gchar* id,
                                                                 gchar** uri,
                                                                 gint uri_length1,
                                                                 GError** error);
static GType granite_services_contractor_dbus_api_get_type_once (void);
static void granite_services_contractor_dbus_api_proxy_g_signal (GDBusProxy* proxy,
                                                          const gchar* sender_name,
                                                          const gchar* signal_name,
                                                          GVariant* parameters);
static void _dbus_handle_granite_services_contractor_dbus_api_contracts_changed (GraniteServicesContractorDBusAPI* self,
                                                                          GVariant* parameters);
static GraniteServicesContractData* granite_services_contractor_dbus_api_proxy_list_all_contracts (GraniteServicesContractorDBusAPI* self,
                                                                                            gint* result_length1,
                                                                                            GError** error);
static GraniteServicesContractData* granite_services_contractor_dbus_api_proxy_get_contracts_by_mime (GraniteServicesContractorDBusAPI* self,
                                                                                               const gchar* mime_type,
                                                                                               gint* result_length1,
                                                                                               GError** error);
static GraniteServicesContractData* granite_services_contractor_dbus_api_proxy_get_contracts_by_mimelist (GraniteServicesContractorDBusAPI* self,
                                                                                                   gchar** mime_types,
                                                                                                   gint mime_types_length1,
                                                                                                   gint* result_length1,
                                                                                                   GError** error);
static void granite_services_contractor_dbus_api_proxy_execute_with_uri (GraniteServicesContractorDBusAPI* self,
                                                                  const gchar* id,
                                                                  const gchar* uri,
                                                                  GError** error);
static void granite_services_contractor_dbus_api_proxy_execute_with_uri_list (GraniteServicesContractorDBusAPI* self,
                                                                       const gchar* id,
                                                                       gchar** uri,
                                                                       gint uri_length1,
                                                                       GError** error);
static void granite_services_contractor_dbus_api_proxy_granite_services_contractor_dbus_api_interface_init (GraniteServicesContractorDBusAPIIface* iface);
static void _vala_GraniteServicesContractData_array_free (GraniteServicesContractData * array,
                                                   gssize array_length);
static void _dbus_granite_services_contractor_dbus_api_list_all_contracts (GraniteServicesContractorDBusAPI* self,
                                                                    GVariant* _parameters_,
                                                                    GDBusMethodInvocation* invocation);
static void _dbus_granite_services_contractor_dbus_api_get_contracts_by_mime (GraniteServicesContractorDBusAPI* self,
                                                                       GVariant* _parameters_,
                                                                       GDBusMethodInvocation* invocation);
static void _dbus_granite_services_contractor_dbus_api_get_contracts_by_mimelist (GraniteServicesContractorDBusAPI* self,
                                                                           GVariant* _parameters_,
                                                                           GDBusMethodInvocation* invocation);
static void _dbus_granite_services_contractor_dbus_api_execute_with_uri (GraniteServicesContractorDBusAPI* self,
                                                                  GVariant* _parameters_,
                                                                  GDBusMethodInvocation* invocation);
static void _dbus_granite_services_contractor_dbus_api_execute_with_uri_list (GraniteServicesContractorDBusAPI* self,
                                                                       GVariant* _parameters_,
                                                                       GDBusMethodInvocation* invocation);
static void granite_services_contractor_dbus_api_dbus_interface_method_call (GDBusConnection* connection,
                                                                      const gchar* sender,
                                                                      const gchar* object_path,
                                                                      const gchar* interface_name,
                                                                      const gchar* method_name,
                                                                      GVariant* parameters,
                                                                      GDBusMethodInvocation* invocation,
                                                                      gpointer user_data);
static GVariant* granite_services_contractor_dbus_api_dbus_interface_get_property (GDBusConnection* connection,
                                                                            const gchar* sender,
                                                                            const gchar* object_path,
                                                                            const gchar* interface_name,
                                                                            const gchar* property_name,
                                                                            GError** error,
                                                                            gpointer user_data);
static gboolean granite_services_contractor_dbus_api_dbus_interface_set_property (GDBusConnection* connection,
                                                                           const gchar* sender,
                                                                           const gchar* object_path,
                                                                           const gchar* interface_name,
                                                                           const gchar* property_name,
                                                                           GVariant* value,
                                                                           GError** error,
                                                                           gpointer user_data);
static void _dbus_granite_services_contractor_dbus_api_contracts_changed (GObject* _sender,
                                                                   gpointer* _data);
static void _granite_services_contractor_dbus_api_unregister_object (gpointer user_data);
static GType granite_services_contractor_proxy_generic_contract_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static GraniteServicesContractorProxy* granite_services_contractor_proxy_new (GError** error);
static GraniteServicesContractorProxy* granite_services_contractor_proxy_construct (GType object_type,
                                                                             GError** error);
static void granite_services_contractor_proxy_ensure (GError** error);
static void granite_services_contractor_proxy_on_contracts_changed (void);
static void _granite_services_contractor_proxy_on_contracts_changed_granite_services_contractor_dbus_api_contracts_changed (GraniteServicesContractorDBusAPI* _sender,
                                                                                                                     gpointer self);
static const gchar* granite_services_contractor_proxy_generic_contract_get_id (GraniteServicesContractorProxyGenericContract* self);
static void granite_services_contractor_proxy_execute_with_uri (const gchar* id,
                                                         const gchar* uri,
                                                         GError** error);
static void granite_services_contractor_proxy_execute_with_uri_list (const gchar* id,
                                                              gchar** uris,
                                                              gint uris_length1,
                                                              GError** error);
static GeeList* granite_services_contractor_proxy_get_contracts_from_data (GraniteServicesContractData* data,
                                                                    gint data_length1);
static GraniteServicesContractorProxyGenericContract* granite_services_contractor_proxy_generic_contract_new (GraniteServicesContractData* data);
static GraniteServicesContractorProxyGenericContract* granite_services_contractor_proxy_generic_contract_construct (GType object_type,
                                                                                                             GraniteServicesContractData* data);
static void granite_services_contractor_proxy_generic_contract_update_data (GraniteServicesContractorProxyGenericContract* self,
                                                                     GraniteServicesContractData* data);
static void granite_services_contractor_proxy_generic_contract_set_id (GraniteServicesContractorProxyGenericContract* self,
                                                                const gchar* value);
static gchar* granite_services_contractor_proxy_generic_contract_real_get_display_name (GraniteServicesContract* base);
static gchar* granite_services_contractor_proxy_generic_contract_real_get_description (GraniteServicesContract* base);
static GIcon* granite_services_contractor_proxy_generic_contract_real_get_icon (GraniteServicesContract* base);
static void granite_services_contractor_proxy_generic_contract_real_execute_with_file (GraniteServicesContract* base,
                                                                                GFile* file,
                                                                                GError** error);
static void granite_services_contractor_proxy_generic_contract_real_execute_with_files (GraniteServicesContract* base,
                                                                                 GFile** files,
                                                                                 gint files_length1,
                                                                                 GError** error);
static void _vala_array_add1 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void granite_services_contractor_proxy_generic_contract_finalize (GObject * obj);
static GType granite_services_contractor_proxy_generic_contract_get_type_once (void);
static void _vala_granite_services_contractor_proxy_generic_contract_get_property (GObject * object,
                                                                            guint property_id,
                                                                            GValue * value,
                                                                            GParamSpec * pspec);
static void _vala_granite_services_contractor_proxy_generic_contract_set_property (GObject * object,
                                                                            guint property_id,
                                                                            const GValue * value,
                                                                            GParamSpec * pspec);
static void granite_services_contractor_proxy_finalize (GObject * obj);
static GType granite_services_contractor_proxy_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const GDBusArgInfo _granite_services_contractor_dbus_api_dbus_arg_info_list_all_contracts_result = {-1, "result", "a(ssss)", NULL};
static const GDBusArgInfo * const _granite_services_contractor_dbus_api_dbus_arg_info_list_all_contracts_in[] = {NULL};
static const GDBusArgInfo * const _granite_services_contractor_dbus_api_dbus_arg_info_list_all_contracts_out[] = {&_granite_services_contractor_dbus_api_dbus_arg_info_list_all_contracts_result, NULL};
static const GDBusMethodInfo _granite_services_contractor_dbus_api_dbus_method_info_list_all_contracts = {-1, "ListAllContracts", (GDBusArgInfo **) (&_granite_services_contractor_dbus_api_dbus_arg_info_list_all_contracts_in), (GDBusArgInfo **) (&_granite_services_contractor_dbus_api_dbus_arg_info_list_all_contracts_out), NULL};
static const GDBusArgInfo _granite_services_contractor_dbus_api_dbus_arg_info_get_contracts_by_mime_mime_type = {-1, "mime_type", "s", NULL};
static const GDBusArgInfo _granite_services_contractor_dbus_api_dbus_arg_info_get_contracts_by_mime_result = {-1, "result", "a(ssss)", NULL};
static const GDBusArgInfo * const _granite_services_contractor_dbus_api_dbus_arg_info_get_contracts_by_mime_in[] = {&_granite_services_contractor_dbus_api_dbus_arg_info_get_contracts_by_mime_mime_type, NULL};
static const GDBusArgInfo * const _granite_services_contractor_dbus_api_dbus_arg_info_get_contracts_by_mime_out[] = {&_granite_services_contractor_dbus_api_dbus_arg_info_get_contracts_by_mime_result, NULL};
static const GDBusMethodInfo _granite_services_contractor_dbus_api_dbus_method_info_get_contracts_by_mime = {-1, "GetContractsByMime", (GDBusArgInfo **) (&_granite_services_contractor_dbus_api_dbus_arg_info_get_contracts_by_mime_in), (GDBusArgInfo **) (&_granite_services_contractor_dbus_api_dbus_arg_info_get_contracts_by_mime_out), NULL};
static const GDBusArgInfo _granite_services_contractor_dbus_api_dbus_arg_info_get_contracts_by_mimelist_mime_types = {-1, "mime_types", "as", NULL};
static const GDBusArgInfo _granite_services_contractor_dbus_api_dbus_arg_info_get_contracts_by_mimelist_result = {-1, "result", "a(ssss)", NULL};
static const GDBusArgInfo * const _granite_services_contractor_dbus_api_dbus_arg_info_get_contracts_by_mimelist_in[] = {&_granite_services_contractor_dbus_api_dbus_arg_info_get_contracts_by_mimelist_mime_types, NULL};
static const GDBusArgInfo * const _granite_services_contractor_dbus_api_dbus_arg_info_get_contracts_by_mimelist_out[] = {&_granite_services_contractor_dbus_api_dbus_arg_info_get_contracts_by_mimelist_result, NULL};
static const GDBusMethodInfo _granite_services_contractor_dbus_api_dbus_method_info_get_contracts_by_mimelist = {-1, "GetContractsByMimelist", (GDBusArgInfo **) (&_granite_services_contractor_dbus_api_dbus_arg_info_get_contracts_by_mimelist_in), (GDBusArgInfo **) (&_granite_services_contractor_dbus_api_dbus_arg_info_get_contracts_by_mimelist_out), NULL};
static const GDBusArgInfo _granite_services_contractor_dbus_api_dbus_arg_info_execute_with_uri_id = {-1, "id", "s", NULL};
static const GDBusArgInfo _granite_services_contractor_dbus_api_dbus_arg_info_execute_with_uri_uri = {-1, "uri", "s", NULL};
static const GDBusArgInfo * const _granite_services_contractor_dbus_api_dbus_arg_info_execute_with_uri_in[] = {&_granite_services_contractor_dbus_api_dbus_arg_info_execute_with_uri_id, &_granite_services_contractor_dbus_api_dbus_arg_info_execute_with_uri_uri, NULL};
static const GDBusArgInfo * const _granite_services_contractor_dbus_api_dbus_arg_info_execute_with_uri_out[] = {NULL};
static const GDBusMethodInfo _granite_services_contractor_dbus_api_dbus_method_info_execute_with_uri = {-1, "ExecuteWithUri", (GDBusArgInfo **) (&_granite_services_contractor_dbus_api_dbus_arg_info_execute_with_uri_in), (GDBusArgInfo **) (&_granite_services_contractor_dbus_api_dbus_arg_info_execute_with_uri_out), NULL};
static const GDBusArgInfo _granite_services_contractor_dbus_api_dbus_arg_info_execute_with_uri_list_id = {-1, "id", "s", NULL};
static const GDBusArgInfo _granite_services_contractor_dbus_api_dbus_arg_info_execute_with_uri_list_uri = {-1, "uri", "as", NULL};
static const GDBusArgInfo * const _granite_services_contractor_dbus_api_dbus_arg_info_execute_with_uri_list_in[] = {&_granite_services_contractor_dbus_api_dbus_arg_info_execute_with_uri_list_id, &_granite_services_contractor_dbus_api_dbus_arg_info_execute_with_uri_list_uri, NULL};
static const GDBusArgInfo * const _granite_services_contractor_dbus_api_dbus_arg_info_execute_with_uri_list_out[] = {NULL};
static const GDBusMethodInfo _granite_services_contractor_dbus_api_dbus_method_info_execute_with_uri_list = {-1, "ExecuteWithUriList", (GDBusArgInfo **) (&_granite_services_contractor_dbus_api_dbus_arg_info_execute_with_uri_list_in), (GDBusArgInfo **) (&_granite_services_contractor_dbus_api_dbus_arg_info_execute_with_uri_list_out), NULL};
static const GDBusMethodInfo * const _granite_services_contractor_dbus_api_dbus_method_info[] = {&_granite_services_contractor_dbus_api_dbus_method_info_list_all_contracts, &_granite_services_contractor_dbus_api_dbus_method_info_get_contracts_by_mime, &_granite_services_contractor_dbus_api_dbus_method_info_get_contracts_by_mimelist, &_granite_services_contractor_dbus_api_dbus_method_info_execute_with_uri, &_granite_services_contractor_dbus_api_dbus_method_info_execute_with_uri_list, NULL};
static const GDBusArgInfo * const _granite_services_contractor_dbus_api_dbus_arg_info_contracts_changed[] = {NULL};
static const GDBusSignalInfo _granite_services_contractor_dbus_api_dbus_signal_info_contracts_changed = {-1, "ContractsChanged", (GDBusArgInfo **) (&_granite_services_contractor_dbus_api_dbus_arg_info_contracts_changed), NULL};
static const GDBusSignalInfo * const _granite_services_contractor_dbus_api_dbus_signal_info[] = {&_granite_services_contractor_dbus_api_dbus_signal_info_contracts_changed, NULL};
static const GDBusPropertyInfo * const _granite_services_contractor_dbus_api_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _granite_services_contractor_dbus_api_dbus_interface_info = {-1, "org.elementary.Contractor", (GDBusMethodInfo **) (&_granite_services_contractor_dbus_api_dbus_method_info), (GDBusSignalInfo **) (&_granite_services_contractor_dbus_api_dbus_signal_info), (GDBusPropertyInfo **) (&_granite_services_contractor_dbus_api_dbus_property_info), NULL};
static const GDBusInterfaceVTable _granite_services_contractor_dbus_api_dbus_interface_vtable = {granite_services_contractor_dbus_api_dbus_interface_method_call, granite_services_contractor_dbus_api_dbus_interface_get_property, granite_services_contractor_dbus_api_dbus_interface_set_property};

/**
         * Returns the display name of the contract, already internationalized
         *
         * @return The internationalized value of the 'Name' key in the .contract file.
         * As of 2014, Contractor uses gettext to handle internationalization.
         */
gchar*
granite_services_contract_get_display_name (GraniteServicesContract* self)
{
	GraniteServicesContractIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = GRANITE_SERVICES_CONTRACT_GET_INTERFACE (self);
	if (_iface_->get_display_name) {
		return _iface_->get_display_name (self);
	}
	return NULL;
}

/**
         * Returns the description of the contract, already internationalized
         *
         * @return The internationalized value of the 'Description' key in the .contract file.
         * As of 2014, Contractor uses gettext to handle internationalization.
         */
gchar*
granite_services_contract_get_description (GraniteServicesContract* self)
{
	GraniteServicesContractIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = GRANITE_SERVICES_CONTRACT_GET_INTERFACE (self);
	if (_iface_->get_description) {
		return _iface_->get_description (self);
	}
	return NULL;
}

/**
         * Returns an icon for this contract
         *
         * @return {@link GLib.Icon} based on the 'Icon' key in the .contract file.
         */
GIcon*
granite_services_contract_get_icon (GraniteServicesContract* self)
{
	GraniteServicesContractIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = GRANITE_SERVICES_CONTRACT_GET_INTERFACE (self);
	if (_iface_->get_icon) {
		return _iface_->get_icon (self);
	}
	return NULL;
}

/**
         * Executes the action on the given file
         */
void
granite_services_contract_execute_with_file (GraniteServicesContract* self,
                                             GFile* file,
                                             GError** error)
{
	GraniteServicesContractIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = GRANITE_SERVICES_CONTRACT_GET_INTERFACE (self);
	if (_iface_->execute_with_file) {
		_iface_->execute_with_file (self, file, error);
	}
}

/**
         * Executes the action on the given list of files
         */
void
granite_services_contract_execute_with_files (GraniteServicesContract* self,
                                              GFile** files,
                                              gint files_length1,
                                              GError** error)
{
	GraniteServicesContractIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = GRANITE_SERVICES_CONTRACT_GET_INTERFACE (self);
	if (_iface_->execute_with_files) {
		_iface_->execute_with_files (self, files, files_length1, error);
	}
}

static void
granite_services_contract_default_init (GraniteServicesContractIface * iface,
                                        gpointer iface_data)
{
}

/**
     * Interface for executing and accessing properties of Contractor actions
     */
static GType
granite_services_contract_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GraniteServicesContractIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) granite_services_contract_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType granite_services_contract_type_id;
	granite_services_contract_type_id = g_type_register_static (G_TYPE_INTERFACE, "GraniteServicesContract", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (granite_services_contract_type_id, G_TYPE_OBJECT);
	return granite_services_contract_type_id;
}

GType
granite_services_contract_get_type (void)
{
	static volatile gsize granite_services_contract_type_id__once = 0;
	if (g_once_init_enter (&granite_services_contract_type_id__once)) {
		GType granite_services_contract_type_id;
		granite_services_contract_type_id = granite_services_contract_get_type_once ();
		g_once_init_leave (&granite_services_contract_type_id__once, granite_services_contract_type_id);
	}
	return granite_services_contract_type_id__once;
}

GQuark
granite_services_contractor_error_quark (void)
{
	return g_quark_from_static_string ("granite-services-contractor-error-quark");
}

static GType
granite_services_contractor_error_get_type_once (void)
{
	static const GEnumValue values[] = {{GRANITE_SERVICES_CONTRACTOR_ERROR_SERVICE_NOT_AVAILABLE, "GRANITE_SERVICES_CONTRACTOR_ERROR_SERVICE_NOT_AVAILABLE", "service-not-available"}, {0, NULL, NULL}};
	GType granite_services_contractor_error_type_id;
	granite_services_contractor_error_type_id = g_enum_register_static ("GraniteServicesContractorError", values);
	return granite_services_contractor_error_type_id;
}

GType
granite_services_contractor_error_get_type (void)
{
	static volatile gsize granite_services_contractor_error_type_id__once = 0;
	if (g_once_init_enter (&granite_services_contractor_error_type_id__once)) {
		GType granite_services_contractor_error_type_id;
		granite_services_contractor_error_type_id = granite_services_contractor_error_get_type_once ();
		g_once_init_leave (&granite_services_contractor_error_type_id__once, granite_services_contractor_error_type_id);
	}
	return granite_services_contractor_error_type_id__once;
}

 G_GNUC_INTERNAL void
granite_services_contract_data_copy (const GraniteServicesContractData* self,
                                     GraniteServicesContractData* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	_tmp0_ = (*self).id;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).id);
	(*dest).id = _tmp1_;
	_tmp2_ = (*self).display_name;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).display_name);
	(*dest).display_name = _tmp3_;
	_tmp4_ = (*self).description;
	_tmp5_ = g_strdup (_tmp4_);
	_g_free0 ((*dest).description);
	(*dest).description = _tmp5_;
	_tmp6_ = (*self).icon;
	_tmp7_ = g_strdup (_tmp6_);
	_g_free0 ((*dest).icon);
	(*dest).icon = _tmp7_;
}

 G_GNUC_INTERNAL void
granite_services_contract_data_destroy (GraniteServicesContractData* self)
{
	_g_free0 ((*self).id);
	_g_free0 ((*self).display_name);
	_g_free0 ((*self).description);
	_g_free0 ((*self).icon);
}

GraniteServicesContractData*
granite_services_contract_data_dup (const GraniteServicesContractData* self)
{
	GraniteServicesContractData* dup;
	dup = g_new0 (GraniteServicesContractData, 1);
	granite_services_contract_data_copy (self, dup);
	return dup;
}

 G_GNUC_INTERNAL void
granite_services_contract_data_free (GraniteServicesContractData* self)
{
	granite_services_contract_data_destroy (self);
	g_free (self);
}

static GType
granite_services_contract_data_get_type_once (void)
{
	GType granite_services_contract_data_type_id;
	granite_services_contract_data_type_id = g_boxed_type_register_static ("GraniteServicesContractData", (GBoxedCopyFunc) granite_services_contract_data_dup, (GBoxedFreeFunc) granite_services_contract_data_free);
	return granite_services_contract_data_type_id;
}

 G_GNUC_INTERNAL GType
granite_services_contract_data_get_type (void)
{
	static volatile gsize granite_services_contract_data_type_id__once = 0;
	if (g_once_init_enter (&granite_services_contract_data_type_id__once)) {
		GType granite_services_contract_data_type_id;
		granite_services_contract_data_type_id = granite_services_contract_data_get_type_once ();
		g_once_init_leave (&granite_services_contract_data_type_id__once, granite_services_contract_data_type_id);
	}
	return granite_services_contract_data_type_id__once;
}

GraniteServicesContractData*
granite_services_contractor_dbus_api_list_all_contracts (GraniteServicesContractorDBusAPI* self,
                                                         gint* result_length1,
                                                         GError** error)
{
	GraniteServicesContractorDBusAPIIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = GRANITE_SERVICES_CONTRACTOR_DBUS_API_GET_INTERFACE (self);
	if (_iface_->list_all_contracts) {
		return _iface_->list_all_contracts (self, result_length1, error);
	}
	return NULL;
}

GraniteServicesContractData*
granite_services_contractor_dbus_api_get_contracts_by_mime (GraniteServicesContractorDBusAPI* self,
                                                            const gchar* mime_type,
                                                            gint* result_length1,
                                                            GError** error)
{
	GraniteServicesContractorDBusAPIIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = GRANITE_SERVICES_CONTRACTOR_DBUS_API_GET_INTERFACE (self);
	if (_iface_->get_contracts_by_mime) {
		return _iface_->get_contracts_by_mime (self, mime_type, result_length1, error);
	}
	return NULL;
}

GraniteServicesContractData*
granite_services_contractor_dbus_api_get_contracts_by_mimelist (GraniteServicesContractorDBusAPI* self,
                                                                gchar** mime_types,
                                                                gint mime_types_length1,
                                                                gint* result_length1,
                                                                GError** error)
{
	GraniteServicesContractorDBusAPIIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = GRANITE_SERVICES_CONTRACTOR_DBUS_API_GET_INTERFACE (self);
	if (_iface_->get_contracts_by_mimelist) {
		return _iface_->get_contracts_by_mimelist (self, mime_types, mime_types_length1, result_length1, error);
	}
	return NULL;
}

void
granite_services_contractor_dbus_api_execute_with_uri (GraniteServicesContractorDBusAPI* self,
                                                       const gchar* id,
                                                       const gchar* uri,
                                                       GError** error)
{
	GraniteServicesContractorDBusAPIIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = GRANITE_SERVICES_CONTRACTOR_DBUS_API_GET_INTERFACE (self);
	if (_iface_->execute_with_uri) {
		_iface_->execute_with_uri (self, id, uri, error);
	}
}

void
granite_services_contractor_dbus_api_execute_with_uri_list (GraniteServicesContractorDBusAPI* self,
                                                            const gchar* id,
                                                            gchar** uri,
                                                            gint uri_length1,
                                                            GError** error)
{
	GraniteServicesContractorDBusAPIIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = GRANITE_SERVICES_CONTRACTOR_DBUS_API_GET_INTERFACE (self);
	if (_iface_->execute_with_uri_list) {
		_iface_->execute_with_uri_list (self, id, uri, uri_length1, error);
	}
}

static void
granite_services_contractor_dbus_api_default_init (GraniteServicesContractorDBusAPIIface * iface,
                                                   gpointer iface_data)
{
	granite_services_contractor_dbus_api_signals[GRANITE_SERVICES_CONTRACTOR_DBUS_API_CONTRACTS_CHANGED_SIGNAL] = g_signal_new ("contracts-changed", GRANITE_SERVICES_TYPE_CONTRACTOR_DBUS_API, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static GType
granite_services_contractor_dbus_api_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GraniteServicesContractorDBusAPIIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) granite_services_contractor_dbus_api_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType granite_services_contractor_dbus_api_type_id;
	granite_services_contractor_dbus_api_type_id = g_type_register_static (G_TYPE_INTERFACE, "GraniteServicesContractorDBusAPI", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (granite_services_contractor_dbus_api_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (granite_services_contractor_dbus_api_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) granite_services_contractor_dbus_api_proxy_get_type);
	g_type_set_qdata (granite_services_contractor_dbus_api_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.elementary.Contractor");
	g_type_set_qdata (granite_services_contractor_dbus_api_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_granite_services_contractor_dbus_api_dbus_interface_info));
	g_type_set_qdata (granite_services_contractor_dbus_api_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) granite_services_contractor_dbus_api_register_object);
	return granite_services_contractor_dbus_api_type_id;
}

 G_GNUC_INTERNAL GType
granite_services_contractor_dbus_api_get_type (void)
{
	static volatile gsize granite_services_contractor_dbus_api_type_id__once = 0;
	if (g_once_init_enter (&granite_services_contractor_dbus_api_type_id__once)) {
		GType granite_services_contractor_dbus_api_type_id;
		granite_services_contractor_dbus_api_type_id = granite_services_contractor_dbus_api_get_type_once ();
		g_once_init_leave (&granite_services_contractor_dbus_api_type_id__once, granite_services_contractor_dbus_api_type_id);
	}
	return granite_services_contractor_dbus_api_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (GraniteServicesContractorDBusAPIProxy, granite_services_contractor_dbus_api_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (GRANITE_SERVICES_TYPE_CONTRACTOR_DBUS_API, granite_services_contractor_dbus_api_proxy_granite_services_contractor_dbus_api_interface_init) )
static void
granite_services_contractor_dbus_api_proxy_class_init (GraniteServicesContractorDBusAPIProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = granite_services_contractor_dbus_api_proxy_g_signal;
}

static void
_dbus_handle_granite_services_contractor_dbus_api_contracts_changed (GraniteServicesContractorDBusAPI* self,
                                                                     GVariant* parameters)
{
	GVariantIter _arguments_iter;
	g_variant_iter_init (&_arguments_iter, parameters);
	g_signal_emit_by_name (self, "contracts-changed");
}

static void
granite_services_contractor_dbus_api_proxy_g_signal (GDBusProxy* proxy,
                                                     const gchar* sender_name,
                                                     const gchar* signal_name,
                                                     GVariant* parameters)
{
	if (strcmp (signal_name, "ContractsChanged") == 0) {
		_dbus_handle_granite_services_contractor_dbus_api_contracts_changed ((GraniteServicesContractorDBusAPI*) proxy, parameters);
	}
}

static void
granite_services_contractor_dbus_api_proxy_init (GraniteServicesContractorDBusAPIProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_granite_services_contractor_dbus_api_dbus_interface_info));
}

static GraniteServicesContractData*
granite_services_contractor_dbus_api_proxy_list_all_contracts (GraniteServicesContractorDBusAPI* self,
                                                               gint* result_length1,
                                                               GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	GraniteServicesContractData* _result = NULL;
	gint _result_length1;
	GVariant* _tmp8_;
	GraniteServicesContractData* _tmp9_;
	gint _tmp9__length;
	gint _tmp9__size;
	gint _tmp9__length1;
	GVariantIter _tmp10_;
	GVariant* _tmp11_;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.elementary.Contractor", "ListAllContracts");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_result_length1 = 0;
	_tmp8_ = g_variant_iter_next_value (&_reply_iter);
	_tmp9_ = g_new (GraniteServicesContractData, 5);
	_tmp9__length = 0;
	_tmp9__size = 4;
	_tmp9__length1 = 0;
	g_variant_iter_init (&_tmp10_, _tmp8_);
	for (; (_tmp11_ = g_variant_iter_next_value (&_tmp10_)) != NULL; _tmp9__length1++) {
		GraniteServicesContractData _tmp12_;
		GVariantIter _tmp13_;
		GVariant* _tmp14_;
		GVariant* _tmp15_;
		GVariant* _tmp16_;
		GVariant* _tmp17_;
		if (_tmp9__size == _tmp9__length) {
			_tmp9__size = 2 * _tmp9__size;
			_tmp9_ = g_renew (GraniteServicesContractData, _tmp9_, _tmp9__size + 1);
		}
		g_variant_iter_init (&_tmp13_, _tmp11_);
		_tmp14_ = g_variant_iter_next_value (&_tmp13_);
		_tmp12_.id = g_variant_dup_string (_tmp14_, NULL);
		g_variant_unref (_tmp14_);
		_tmp15_ = g_variant_iter_next_value (&_tmp13_);
		_tmp12_.display_name = g_variant_dup_string (_tmp15_, NULL);
		g_variant_unref (_tmp15_);
		_tmp16_ = g_variant_iter_next_value (&_tmp13_);
		_tmp12_.description = g_variant_dup_string (_tmp16_, NULL);
		g_variant_unref (_tmp16_);
		_tmp17_ = g_variant_iter_next_value (&_tmp13_);
		_tmp12_.icon = g_variant_dup_string (_tmp17_, NULL);
		g_variant_unref (_tmp17_);
		_tmp9_[_tmp9__length++] = _tmp12_;
		g_variant_unref (_tmp11_);
	}
	_result_length1 = _tmp9__length1;
	_result = _tmp9_;
	g_variant_unref (_tmp8_);
	*result_length1 = _result_length1;
	g_object_unref (_reply_message);
	return _result;
}

static GraniteServicesContractData*
granite_services_contractor_dbus_api_proxy_get_contracts_by_mime (GraniteServicesContractorDBusAPI* self,
                                                                  const gchar* mime_type,
                                                                  gint* result_length1,
                                                                  GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	GraniteServicesContractData* _result = NULL;
	gint _result_length1;
	GVariant* _tmp18_;
	GraniteServicesContractData* _tmp19_;
	gint _tmp19__length;
	gint _tmp19__size;
	gint _tmp19__length1;
	GVariantIter _tmp20_;
	GVariant* _tmp21_;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.elementary.Contractor", "GetContractsByMime");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (mime_type));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_result_length1 = 0;
	_tmp18_ = g_variant_iter_next_value (&_reply_iter);
	_tmp19_ = g_new (GraniteServicesContractData, 5);
	_tmp19__length = 0;
	_tmp19__size = 4;
	_tmp19__length1 = 0;
	g_variant_iter_init (&_tmp20_, _tmp18_);
	for (; (_tmp21_ = g_variant_iter_next_value (&_tmp20_)) != NULL; _tmp19__length1++) {
		GraniteServicesContractData _tmp22_;
		GVariantIter _tmp23_;
		GVariant* _tmp24_;
		GVariant* _tmp25_;
		GVariant* _tmp26_;
		GVariant* _tmp27_;
		if (_tmp19__size == _tmp19__length) {
			_tmp19__size = 2 * _tmp19__size;
			_tmp19_ = g_renew (GraniteServicesContractData, _tmp19_, _tmp19__size + 1);
		}
		g_variant_iter_init (&_tmp23_, _tmp21_);
		_tmp24_ = g_variant_iter_next_value (&_tmp23_);
		_tmp22_.id = g_variant_dup_string (_tmp24_, NULL);
		g_variant_unref (_tmp24_);
		_tmp25_ = g_variant_iter_next_value (&_tmp23_);
		_tmp22_.display_name = g_variant_dup_string (_tmp25_, NULL);
		g_variant_unref (_tmp25_);
		_tmp26_ = g_variant_iter_next_value (&_tmp23_);
		_tmp22_.description = g_variant_dup_string (_tmp26_, NULL);
		g_variant_unref (_tmp26_);
		_tmp27_ = g_variant_iter_next_value (&_tmp23_);
		_tmp22_.icon = g_variant_dup_string (_tmp27_, NULL);
		g_variant_unref (_tmp27_);
		_tmp19_[_tmp19__length++] = _tmp22_;
		g_variant_unref (_tmp21_);
	}
	_result_length1 = _tmp19__length1;
	_result = _tmp19_;
	g_variant_unref (_tmp18_);
	*result_length1 = _result_length1;
	g_object_unref (_reply_message);
	return _result;
}

static GraniteServicesContractData*
granite_services_contractor_dbus_api_proxy_get_contracts_by_mimelist (GraniteServicesContractorDBusAPI* self,
                                                                      gchar** mime_types,
                                                                      gint mime_types_length1,
                                                                      gint* result_length1,
                                                                      GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	gchar** _tmp28_;
	GVariantBuilder _tmp29_;
	gint _tmp30_;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	GraniteServicesContractData* _result = NULL;
	gint _result_length1;
	GVariant* _tmp31_;
	GraniteServicesContractData* _tmp32_;
	gint _tmp32__length;
	gint _tmp32__size;
	gint _tmp32__length1;
	GVariantIter _tmp33_;
	GVariant* _tmp34_;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.elementary.Contractor", "GetContractsByMimelist");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_tmp28_ = mime_types;
	g_variant_builder_init (&_tmp29_, G_VARIANT_TYPE ("as"));
	for (_tmp30_ = 0; _tmp30_ < mime_types_length1; _tmp30_++) {
		g_variant_builder_add_value (&_tmp29_, g_variant_new_string (*_tmp28_));
		_tmp28_++;
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp29_));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_result_length1 = 0;
	_tmp31_ = g_variant_iter_next_value (&_reply_iter);
	_tmp32_ = g_new (GraniteServicesContractData, 5);
	_tmp32__length = 0;
	_tmp32__size = 4;
	_tmp32__length1 = 0;
	g_variant_iter_init (&_tmp33_, _tmp31_);
	for (; (_tmp34_ = g_variant_iter_next_value (&_tmp33_)) != NULL; _tmp32__length1++) {
		GraniteServicesContractData _tmp35_;
		GVariantIter _tmp36_;
		GVariant* _tmp37_;
		GVariant* _tmp38_;
		GVariant* _tmp39_;
		GVariant* _tmp40_;
		if (_tmp32__size == _tmp32__length) {
			_tmp32__size = 2 * _tmp32__size;
			_tmp32_ = g_renew (GraniteServicesContractData, _tmp32_, _tmp32__size + 1);
		}
		g_variant_iter_init (&_tmp36_, _tmp34_);
		_tmp37_ = g_variant_iter_next_value (&_tmp36_);
		_tmp35_.id = g_variant_dup_string (_tmp37_, NULL);
		g_variant_unref (_tmp37_);
		_tmp38_ = g_variant_iter_next_value (&_tmp36_);
		_tmp35_.display_name = g_variant_dup_string (_tmp38_, NULL);
		g_variant_unref (_tmp38_);
		_tmp39_ = g_variant_iter_next_value (&_tmp36_);
		_tmp35_.description = g_variant_dup_string (_tmp39_, NULL);
		g_variant_unref (_tmp39_);
		_tmp40_ = g_variant_iter_next_value (&_tmp36_);
		_tmp35_.icon = g_variant_dup_string (_tmp40_, NULL);
		g_variant_unref (_tmp40_);
		_tmp32_[_tmp32__length++] = _tmp35_;
		g_variant_unref (_tmp34_);
	}
	_result_length1 = _tmp32__length1;
	_result = _tmp32_;
	g_variant_unref (_tmp31_);
	*result_length1 = _result_length1;
	g_object_unref (_reply_message);
	return _result;
}

static void
granite_services_contractor_dbus_api_proxy_execute_with_uri (GraniteServicesContractorDBusAPI* self,
                                                             const gchar* id,
                                                             const gchar* uri,
                                                             GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.elementary.Contractor", "ExecuteWithUri");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (id));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (uri));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
granite_services_contractor_dbus_api_proxy_execute_with_uri_list (GraniteServicesContractorDBusAPI* self,
                                                                  const gchar* id,
                                                                  gchar** uri,
                                                                  gint uri_length1,
                                                                  GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	gchar** _tmp41_;
	GVariantBuilder _tmp42_;
	gint _tmp43_;
	GDBusMessage *_reply_message;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.elementary.Contractor", "ExecuteWithUriList");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (id));
	_tmp41_ = uri;
	g_variant_builder_init (&_tmp42_, G_VARIANT_TYPE ("as"));
	for (_tmp43_ = 0; _tmp43_ < uri_length1; _tmp43_++) {
		g_variant_builder_add_value (&_tmp42_, g_variant_new_string (*_tmp41_));
		_tmp41_++;
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp42_));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
granite_services_contractor_dbus_api_proxy_granite_services_contractor_dbus_api_interface_init (GraniteServicesContractorDBusAPIIface* iface)
{
	iface->list_all_contracts = granite_services_contractor_dbus_api_proxy_list_all_contracts;
	iface->get_contracts_by_mime = granite_services_contractor_dbus_api_proxy_get_contracts_by_mime;
	iface->get_contracts_by_mimelist = granite_services_contractor_dbus_api_proxy_get_contracts_by_mimelist;
	iface->execute_with_uri = granite_services_contractor_dbus_api_proxy_execute_with_uri;
	iface->execute_with_uri_list = granite_services_contractor_dbus_api_proxy_execute_with_uri_list;
}

static void
_vala_GraniteServicesContractData_array_free (GraniteServicesContractData * array,
                                              gssize array_length)
{
	if (array != NULL) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			granite_services_contract_data_destroy (&array[i]);
		}
	}
	g_free (array);
}

static void
_dbus_granite_services_contractor_dbus_api_list_all_contracts (GraniteServicesContractorDBusAPI* self,
                                                               GVariant* _parameters_,
                                                               GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	GraniteServicesContractData* result;
	gint result_length1 = 0;
	GraniteServicesContractData* _tmp44_;
	GVariantBuilder _tmp45_;
	gint _tmp46_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	result = granite_services_contractor_dbus_api_list_all_contracts (self, &result_length1, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp44_ = result;
	g_variant_builder_init (&_tmp45_, G_VARIANT_TYPE ("a(ssss)"));
	for (_tmp46_ = 0; _tmp46_ < result_length1; _tmp46_++) {
		GVariantBuilder _tmp47_;
		g_variant_builder_init (&_tmp47_, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_tmp47_, g_variant_new_string ((*_tmp44_).id));
		g_variant_builder_add_value (&_tmp47_, g_variant_new_string ((*_tmp44_).display_name));
		g_variant_builder_add_value (&_tmp47_, g_variant_new_string ((*_tmp44_).description));
		g_variant_builder_add_value (&_tmp47_, g_variant_new_string ((*_tmp44_).icon));
		g_variant_builder_add_value (&_tmp45_, g_variant_builder_end (&_tmp47_));
		_tmp44_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp45_));
	result = (_vala_GraniteServicesContractData_array_free (result, result_length1), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_granite_services_contractor_dbus_api_get_contracts_by_mime (GraniteServicesContractorDBusAPI* self,
                                                                  GVariant* _parameters_,
                                                                  GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* mime_type = NULL;
	GVariant* _tmp48_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	GraniteServicesContractData* result;
	gint result_length1 = 0;
	GraniteServicesContractData* _tmp49_;
	GVariantBuilder _tmp50_;
	gint _tmp51_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp48_ = g_variant_iter_next_value (&_arguments_iter);
	mime_type = g_variant_dup_string (_tmp48_, NULL);
	g_variant_unref (_tmp48_);
	result = granite_services_contractor_dbus_api_get_contracts_by_mime (self, mime_type, &result_length1, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp49_ = result;
	g_variant_builder_init (&_tmp50_, G_VARIANT_TYPE ("a(ssss)"));
	for (_tmp51_ = 0; _tmp51_ < result_length1; _tmp51_++) {
		GVariantBuilder _tmp52_;
		g_variant_builder_init (&_tmp52_, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_tmp52_, g_variant_new_string ((*_tmp49_).id));
		g_variant_builder_add_value (&_tmp52_, g_variant_new_string ((*_tmp49_).display_name));
		g_variant_builder_add_value (&_tmp52_, g_variant_new_string ((*_tmp49_).description));
		g_variant_builder_add_value (&_tmp52_, g_variant_new_string ((*_tmp49_).icon));
		g_variant_builder_add_value (&_tmp50_, g_variant_builder_end (&_tmp52_));
		_tmp49_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp50_));
	result = (_vala_GraniteServicesContractData_array_free (result, result_length1), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (mime_type);
	;
}

static void
_dbus_granite_services_contractor_dbus_api_get_contracts_by_mimelist (GraniteServicesContractorDBusAPI* self,
                                                                      GVariant* _parameters_,
                                                                      GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar** mime_types = NULL;
	gint mime_types_length1 = 0;
	GVariant* _tmp53_;
	gchar** _tmp54_;
	gint _tmp54__length;
	gint _tmp54__size;
	gint _tmp54__length1;
	GVariantIter _tmp55_;
	GVariant* _tmp56_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	GraniteServicesContractData* result;
	gint result_length1 = 0;
	GraniteServicesContractData* _tmp57_;
	GVariantBuilder _tmp58_;
	gint _tmp59_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp53_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp54_ = g_new (gchar*, 5);
	_tmp54__length = 0;
	_tmp54__size = 4;
	_tmp54__length1 = 0;
	g_variant_iter_init (&_tmp55_, _tmp53_);
	for (; (_tmp56_ = g_variant_iter_next_value (&_tmp55_)) != NULL; _tmp54__length1++) {
		if (_tmp54__size == _tmp54__length) {
			_tmp54__size = 2 * _tmp54__size;
			_tmp54_ = g_renew (gchar*, _tmp54_, _tmp54__size + 1);
		}
		_tmp54_[_tmp54__length++] = g_variant_dup_string (_tmp56_, NULL);
		g_variant_unref (_tmp56_);
	}
	mime_types_length1 = _tmp54__length1;
	_tmp54_[_tmp54__length] = NULL;
	mime_types = _tmp54_;
	g_variant_unref (_tmp53_);
	result = granite_services_contractor_dbus_api_get_contracts_by_mimelist (self, mime_types, mime_types_length1, &result_length1, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp57_ = result;
	g_variant_builder_init (&_tmp58_, G_VARIANT_TYPE ("a(ssss)"));
	for (_tmp59_ = 0; _tmp59_ < result_length1; _tmp59_++) {
		GVariantBuilder _tmp60_;
		g_variant_builder_init (&_tmp60_, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_tmp60_, g_variant_new_string ((*_tmp57_).id));
		g_variant_builder_add_value (&_tmp60_, g_variant_new_string ((*_tmp57_).display_name));
		g_variant_builder_add_value (&_tmp60_, g_variant_new_string ((*_tmp57_).description));
		g_variant_builder_add_value (&_tmp60_, g_variant_new_string ((*_tmp57_).icon));
		g_variant_builder_add_value (&_tmp58_, g_variant_builder_end (&_tmp60_));
		_tmp57_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp58_));
	result = (_vala_GraniteServicesContractData_array_free (result, result_length1), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	mime_types = (_vala_array_free (mime_types, mime_types_length1, (GDestroyNotify) g_free), NULL);
	;
}

static void
_dbus_granite_services_contractor_dbus_api_execute_with_uri (GraniteServicesContractorDBusAPI* self,
                                                             GVariant* _parameters_,
                                                             GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* id = NULL;
	GVariant* _tmp61_;
	gchar* uri = NULL;
	GVariant* _tmp62_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp61_ = g_variant_iter_next_value (&_arguments_iter);
	id = g_variant_dup_string (_tmp61_, NULL);
	g_variant_unref (_tmp61_);
	_tmp62_ = g_variant_iter_next_value (&_arguments_iter);
	uri = g_variant_dup_string (_tmp62_, NULL);
	g_variant_unref (_tmp62_);
	granite_services_contractor_dbus_api_execute_with_uri (self, id, uri, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (id);
	_g_free0 (uri);
	;
}

static void
_dbus_granite_services_contractor_dbus_api_execute_with_uri_list (GraniteServicesContractorDBusAPI* self,
                                                                  GVariant* _parameters_,
                                                                  GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* id = NULL;
	GVariant* _tmp63_;
	gchar** uri = NULL;
	gint uri_length1 = 0;
	GVariant* _tmp64_;
	gchar** _tmp65_;
	gint _tmp65__length;
	gint _tmp65__size;
	gint _tmp65__length1;
	GVariantIter _tmp66_;
	GVariant* _tmp67_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp63_ = g_variant_iter_next_value (&_arguments_iter);
	id = g_variant_dup_string (_tmp63_, NULL);
	g_variant_unref (_tmp63_);
	_tmp64_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp65_ = g_new (gchar*, 5);
	_tmp65__length = 0;
	_tmp65__size = 4;
	_tmp65__length1 = 0;
	g_variant_iter_init (&_tmp66_, _tmp64_);
	for (; (_tmp67_ = g_variant_iter_next_value (&_tmp66_)) != NULL; _tmp65__length1++) {
		if (_tmp65__size == _tmp65__length) {
			_tmp65__size = 2 * _tmp65__size;
			_tmp65_ = g_renew (gchar*, _tmp65_, _tmp65__size + 1);
		}
		_tmp65_[_tmp65__length++] = g_variant_dup_string (_tmp67_, NULL);
		g_variant_unref (_tmp67_);
	}
	uri_length1 = _tmp65__length1;
	_tmp65_[_tmp65__length] = NULL;
	uri = _tmp65_;
	g_variant_unref (_tmp64_);
	granite_services_contractor_dbus_api_execute_with_uri_list (self, id, uri, uri_length1, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (id);
	uri = (_vala_array_free (uri, uri_length1, (GDestroyNotify) g_free), NULL);
	;
}

static void
granite_services_contractor_dbus_api_dbus_interface_method_call (GDBusConnection* connection,
                                                                 const gchar* sender,
                                                                 const gchar* object_path,
                                                                 const gchar* interface_name,
                                                                 const gchar* method_name,
                                                                 GVariant* parameters,
                                                                 GDBusMethodInvocation* invocation,
                                                                 gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "ListAllContracts") == 0) {
		_dbus_granite_services_contractor_dbus_api_list_all_contracts (object, parameters, invocation);
	} else if (strcmp (method_name, "GetContractsByMime") == 0) {
		_dbus_granite_services_contractor_dbus_api_get_contracts_by_mime (object, parameters, invocation);
	} else if (strcmp (method_name, "GetContractsByMimelist") == 0) {
		_dbus_granite_services_contractor_dbus_api_get_contracts_by_mimelist (object, parameters, invocation);
	} else if (strcmp (method_name, "ExecuteWithUri") == 0) {
		_dbus_granite_services_contractor_dbus_api_execute_with_uri (object, parameters, invocation);
	} else if (strcmp (method_name, "ExecuteWithUriList") == 0) {
		_dbus_granite_services_contractor_dbus_api_execute_with_uri_list (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
granite_services_contractor_dbus_api_dbus_interface_get_property (GDBusConnection* connection,
                                                                  const gchar* sender,
                                                                  const gchar* object_path,
                                                                  const gchar* interface_name,
                                                                  const gchar* property_name,
                                                                  GError** error,
                                                                  gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
granite_services_contractor_dbus_api_dbus_interface_set_property (GDBusConnection* connection,
                                                                  const gchar* sender,
                                                                  const gchar* object_path,
                                                                  const gchar* interface_name,
                                                                  const gchar* property_name,
                                                                  GVariant* value,
                                                                  GError** error,
                                                                  gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

static void
_dbus_granite_services_contractor_dbus_api_contracts_changed (GObject* _sender,
                                                              gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.elementary.Contractor", "ContractsChanged", _arguments, NULL);
}

 G_GNUC_INTERNAL guint
granite_services_contractor_dbus_api_register_object (gpointer object,
                                                      GDBusConnection* connection,
                                                      const gchar* path,
                                                      GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_granite_services_contractor_dbus_api_dbus_interface_info), &_granite_services_contractor_dbus_api_dbus_interface_vtable, data, _granite_services_contractor_dbus_api_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "contracts-changed", (GCallback) _dbus_granite_services_contractor_dbus_api_contracts_changed, data);
	return result;
}

static void
_granite_services_contractor_dbus_api_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_granite_services_contractor_dbus_api_contracts_changed, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static GraniteServicesContractorProxy*
granite_services_contractor_proxy_construct (GType object_type,
                                             GError** error)
{
	GraniteServicesContractorProxy * self = NULL;
	GError* _inner_error0_ = NULL;
	self = (GraniteServicesContractorProxy*) g_object_new (object_type, NULL);
	granite_services_contractor_proxy_ensure (&_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (self);
		return NULL;
	}
	return self;
}

static GraniteServicesContractorProxy*
granite_services_contractor_proxy_new (GError** error)
{
	return granite_services_contractor_proxy_construct (GRANITE_SERVICES_TYPE_CONTRACTOR_PROXY, error);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GraniteServicesContractorProxy*
granite_services_contractor_proxy_get_instance (GError** error)
{
	GraniteServicesContractorProxy* _tmp0_;
	GraniteServicesContractorProxy* _tmp4_;
	GraniteServicesContractorProxy* _tmp5_;
	GError* _inner_error0_ = NULL;
	GraniteServicesContractorProxy* result;
	_tmp0_ = granite_services_contractor_proxy_instance;
	if (_tmp0_ == NULL) {
		GraniteServicesContractorProxy* _tmp1_ = NULL;
		GraniteServicesContractorProxy* _tmp2_;
		GraniteServicesContractorProxy* _tmp3_;
		_tmp2_ = granite_services_contractor_proxy_new (&_inner_error0_);
		_tmp1_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		}
		_tmp3_ = _tmp1_;
		_tmp1_ = NULL;
		_g_object_unref0 (granite_services_contractor_proxy_instance);
		granite_services_contractor_proxy_instance = _tmp3_;
		_g_object_unref0 (_tmp1_);
	}
	_tmp4_ = granite_services_contractor_proxy_instance;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	result = _tmp5_;
	return result;
}

static void
_granite_services_contractor_proxy_on_contracts_changed_granite_services_contractor_dbus_api_contracts_changed (GraniteServicesContractorDBusAPI* _sender,
                                                                                                                gpointer self)
{
	granite_services_contractor_proxy_on_contracts_changed ();
}

static void
granite_services_contractor_proxy_ensure (GError** error)
{
	GraniteServicesContractorDBusAPI* _tmp0_;
	GeeHashMap* _tmp8_;
	GError* _inner_error0_ = NULL;
	_tmp0_ = granite_services_contractor_proxy_contractor_dbus;
	if (_tmp0_ == NULL) {
		{
			GraniteServicesContractorDBusAPI* _tmp1_ = NULL;
			GraniteServicesContractorDBusAPI* _tmp2_;
			GraniteServicesContractorDBusAPI* _tmp3_;
			GraniteServicesContractorDBusAPI* _tmp4_;
			_tmp2_ = (GraniteServicesContractorDBusAPI*) g_initable_new (GRANITE_SERVICES_TYPE_CONTRACTOR_DBUS_API_PROXY, NULL, &_inner_error0_, "g-flags", 0, "g-name", "org.elementary.Contractor", "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", "/org/elementary/contractor", "g-interface-name", "org.elementary.Contractor", NULL);
			_tmp1_ = (GraniteServicesContractorDBusAPI*) _tmp2_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_IO_ERROR) {
					goto __catch0_g_io_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			_tmp3_ = _tmp1_;
			_tmp1_ = NULL;
			_g_object_unref0 (granite_services_contractor_proxy_contractor_dbus);
			granite_services_contractor_proxy_contractor_dbus = _tmp3_;
			_tmp4_ = granite_services_contractor_proxy_contractor_dbus;
			g_signal_connect (_tmp4_, "contracts-changed", (GCallback) _granite_services_contractor_proxy_on_contracts_changed_granite_services_contractor_dbus_api_contracts_changed, NULL);
			_g_object_unref0 (_tmp1_);
		}
		goto __finally0;
		__catch0_g_io_error:
		{
			GError* e = NULL;
			GError* _tmp5_;
			const gchar* _tmp6_;
			GError* _tmp7_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp5_ = e;
			_tmp6_ = _tmp5_->message;
			_tmp7_ = g_error_new_literal (GRANITE_SERVICES_CONTRACTOR_ERROR, GRANITE_SERVICES_CONTRACTOR_ERROR_SERVICE_NOT_AVAILABLE, _tmp6_);
			_inner_error0_ = _tmp7_;
			_g_error_free0 (e);
			goto __finally0;
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			return;
		}
	}
	_tmp8_ = granite_services_contractor_proxy_contracts;
	if (_tmp8_ == NULL) {
		GeeHashMap* _tmp9_;
		_tmp9_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, GRANITE_SERVICES_CONTRACTOR_PROXY_TYPE_GENERIC_CONTRACT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
		_g_object_unref0 (granite_services_contractor_proxy_contracts);
		granite_services_contractor_proxy_contracts = _tmp9_;
	}
}

static void
granite_services_contractor_proxy_on_contracts_changed (void)
{
	GError* _inner_error0_ = NULL;
	{
		GeeList* all_contracts = NULL;
		GeeList* _tmp0_;
		GeeLinkedList* to_remove = NULL;
		GeeLinkedList* _tmp1_;
		gint diff = 0;
		GeeHashMap* _tmp27_;
		gint _tmp28_;
		gint _tmp29_;
		GeeList* _tmp30_;
		gint _tmp31_;
		gint _tmp32_;
		GraniteServicesContractorProxy* _tmp33_;
		_tmp0_ = granite_services_contractor_proxy_get_all_contracts (&_inner_error0_);
		all_contracts = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp1_ = gee_linked_list_new (GRANITE_SERVICES_CONTRACTOR_PROXY_TYPE_GENERIC_CONTRACT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
		to_remove = _tmp1_;
		{
			GeeIterator* _contract_it = NULL;
			GeeHashMap* _tmp2_;
			GeeCollection* _tmp3_;
			GeeCollection* _tmp4_;
			GeeCollection* _tmp5_;
			GeeIterator* _tmp6_;
			GeeIterator* _tmp7_;
			_tmp2_ = granite_services_contractor_proxy_contracts;
			_tmp3_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp2_);
			_tmp4_ = _tmp3_;
			_tmp5_ = _tmp4_;
			_tmp6_ = gee_iterable_iterator ((GeeIterable*) _tmp5_);
			_tmp7_ = _tmp6_;
			_g_object_unref0 (_tmp5_);
			_contract_it = _tmp7_;
			while (TRUE) {
				GeeIterator* _tmp8_;
				GraniteServicesContractorProxyGenericContract* contract = NULL;
				GeeIterator* _tmp9_;
				gpointer _tmp10_;
				GeeList* _tmp11_;
				GraniteServicesContractorProxyGenericContract* _tmp12_;
				_tmp8_ = _contract_it;
				if (!gee_iterator_next (_tmp8_)) {
					break;
				}
				_tmp9_ = _contract_it;
				_tmp10_ = gee_iterator_get (_tmp9_);
				contract = (GraniteServicesContractorProxyGenericContract*) _tmp10_;
				_tmp11_ = all_contracts;
				_tmp12_ = contract;
				if (!gee_collection_contains ((GeeCollection*) _tmp11_, (GraniteServicesContract*) _tmp12_)) {
					GeeLinkedList* _tmp13_;
					GraniteServicesContractorProxyGenericContract* _tmp14_;
					_tmp13_ = to_remove;
					_tmp14_ = contract;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp13_, _tmp14_);
				}
				_g_object_unref0 (contract);
			}
			_g_object_unref0 (_contract_it);
		}
		{
			GeeLinkedList* _contract_list = NULL;
			GeeLinkedList* _tmp15_;
			gint _contract_size = 0;
			GeeLinkedList* _tmp16_;
			gint _tmp17_;
			gint _tmp18_;
			gint _contract_index = 0;
			_tmp15_ = to_remove;
			_contract_list = _tmp15_;
			_tmp16_ = _contract_list;
			_tmp17_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp16_);
			_tmp18_ = _tmp17_;
			_contract_size = _tmp18_;
			_contract_index = -1;
			while (TRUE) {
				gint _tmp19_;
				gint _tmp20_;
				GraniteServicesContractorProxyGenericContract* contract = NULL;
				GeeLinkedList* _tmp21_;
				gpointer _tmp22_;
				GeeHashMap* _tmp23_;
				GraniteServicesContractorProxyGenericContract* _tmp24_;
				const gchar* _tmp25_;
				const gchar* _tmp26_;
				_contract_index = _contract_index + 1;
				_tmp19_ = _contract_index;
				_tmp20_ = _contract_size;
				if (!(_tmp19_ < _tmp20_)) {
					break;
				}
				_tmp21_ = _contract_list;
				_tmp22_ = gee_abstract_list_get ((GeeAbstractList*) _tmp21_, _contract_index);
				contract = (GraniteServicesContractorProxyGenericContract*) _tmp22_;
				_tmp23_ = granite_services_contractor_proxy_contracts;
				_tmp24_ = contract;
				_tmp25_ = granite_services_contractor_proxy_generic_contract_get_id (_tmp24_);
				_tmp26_ = _tmp25_;
				gee_abstract_map_unset ((GeeAbstractMap*) _tmp23_, _tmp26_, NULL);
				_g_object_unref0 (contract);
			}
		}
		_tmp27_ = granite_services_contractor_proxy_contracts;
		_tmp28_ = gee_abstract_map_get_size ((GeeAbstractMap*) _tmp27_);
		_tmp29_ = _tmp28_;
		_tmp30_ = all_contracts;
		_tmp31_ = gee_collection_get_size ((GeeCollection*) _tmp30_);
		_tmp32_ = _tmp31_;
		diff = _tmp29_ - _tmp32_;
		if (diff < 0) {
			g_critical ("ContractorProxy.vala:202: Failed to add %d contracts.", diff);
		} else {
			if (diff > 0) {
				g_critical ("ContractorProxy.vala:204: Failed to remove %d contracts.", diff);
			}
		}
		_tmp33_ = granite_services_contractor_proxy_instance;
		if (_tmp33_ != NULL) {
			GraniteServicesContractorProxy* _tmp34_;
			_tmp34_ = granite_services_contractor_proxy_instance;
			g_signal_emit (_tmp34_, granite_services_contractor_proxy_signals[GRANITE_SERVICES_CONTRACTOR_PROXY_CONTRACTS_CHANGED_SIGNAL], 0);
		}
		_g_object_unref0 (to_remove);
		_g_object_unref0 (all_contracts);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp35_;
		const gchar* _tmp36_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp35_ = err;
		_tmp36_ = _tmp35_->message;
		g_warning ("ContractorProxy.vala:209: Could not process changes in contracts: %s", _tmp36_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
granite_services_contractor_proxy_execute_with_uri (const gchar* id,
                                                    const gchar* uri,
                                                    GError** error)
{
	GraniteServicesContractorDBusAPI* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (id != NULL);
	g_return_if_fail (uri != NULL);
	granite_services_contractor_proxy_ensure (&_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp0_ = granite_services_contractor_proxy_contractor_dbus;
	granite_services_contractor_dbus_api_execute_with_uri (_tmp0_, id, uri, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

static void
granite_services_contractor_proxy_execute_with_uri_list (const gchar* id,
                                                         gchar** uris,
                                                         gint uris_length1,
                                                         GError** error)
{
	GraniteServicesContractorDBusAPI* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (id != NULL);
	granite_services_contractor_proxy_ensure (&_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp0_ = granite_services_contractor_proxy_contractor_dbus;
	granite_services_contractor_dbus_api_execute_with_uri_list (_tmp0_, id, uris, (gint) uris_length1, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

/**
         * Provides all the contracts.
         *
         * @return {@link Gee.List} containing all the contracts available in the system.
         */
GeeList*
granite_services_contractor_proxy_get_all_contracts (GError** error)
{
	GraniteServicesContractData* data = NULL;
	GraniteServicesContractorDBusAPI* _tmp0_;
	gint _tmp1_ = 0;
	GraniteServicesContractData* _tmp2_;
	gint data_length1;
	gint _data_size_;
	GraniteServicesContractData* _tmp3_;
	gint _tmp3__length1;
	GeeList* _tmp4_;
	GError* _inner_error0_ = NULL;
	GeeList* result;
	granite_services_contractor_proxy_ensure (&_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp0_ = granite_services_contractor_proxy_contractor_dbus;
	_tmp2_ = granite_services_contractor_dbus_api_list_all_contracts (_tmp0_, &_tmp1_, &_inner_error0_);
	data = _tmp2_;
	data_length1 = _tmp1_;
	_data_size_ = data_length1;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp3_ = data;
	_tmp3__length1 = data_length1;
	_tmp4_ = granite_services_contractor_proxy_get_contracts_from_data (_tmp3_, (gint) _tmp3__length1);
	result = _tmp4_;
	data = (_vala_GraniteServicesContractData_array_free (data, data_length1), NULL);
	return result;
}

/**
         * Returns actions (contracts) applicable to the given mimetypes.
         *
         * @param mime_type Mimetype of file.
         * @return {@link Gee.List} of contracts that support the given mimetype.
         */
GeeList*
granite_services_contractor_proxy_get_contracts_by_mime (const gchar* mime_type,
                                                         GError** error)
{
	GraniteServicesContractData* data = NULL;
	GraniteServicesContractorDBusAPI* _tmp0_;
	gint _tmp1_ = 0;
	GraniteServicesContractData* _tmp2_;
	gint data_length1;
	gint _data_size_;
	GraniteServicesContractData* _tmp3_;
	gint _tmp3__length1;
	GeeList* _tmp4_;
	GError* _inner_error0_ = NULL;
	GeeList* result;
	g_return_val_if_fail (mime_type != NULL, NULL);
	granite_services_contractor_proxy_ensure (&_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp0_ = granite_services_contractor_proxy_contractor_dbus;
	_tmp2_ = granite_services_contractor_dbus_api_get_contracts_by_mime (_tmp0_, mime_type, &_tmp1_, &_inner_error0_);
	data = _tmp2_;
	data_length1 = _tmp1_;
	_data_size_ = data_length1;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp3_ = data;
	_tmp3__length1 = data_length1;
	_tmp4_ = granite_services_contractor_proxy_get_contracts_from_data (_tmp3_, (gint) _tmp3__length1);
	result = _tmp4_;
	data = (_vala_GraniteServicesContractData_array_free (data, data_length1), NULL);
	return result;
}

/**
         * Returns actions (contracts) applicable to all given mimetypes.
         *
         * Only the contracts that support all of the mimetypes are returned.
         *
         * @param mime_types Array of mimetypes.
         * @return {@link Gee.List} of contracts that support the given mimetypes.
         */
GeeList*
granite_services_contractor_proxy_get_contracts_by_mimelist (gchar** mime_types,
                                                             gint mime_types_length1,
                                                             GError** error)
{
	GraniteServicesContractData* data = NULL;
	GraniteServicesContractorDBusAPI* _tmp0_;
	gint _tmp1_ = 0;
	GraniteServicesContractData* _tmp2_;
	gint data_length1;
	gint _data_size_;
	GraniteServicesContractData* _tmp3_;
	gint _tmp3__length1;
	GeeList* _tmp4_;
	GError* _inner_error0_ = NULL;
	GeeList* result;
	granite_services_contractor_proxy_ensure (&_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp0_ = granite_services_contractor_proxy_contractor_dbus;
	_tmp2_ = granite_services_contractor_dbus_api_get_contracts_by_mimelist (_tmp0_, mime_types, (gint) mime_types_length1, &_tmp1_, &_inner_error0_);
	data = _tmp2_;
	data_length1 = _tmp1_;
	_data_size_ = data_length1;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp3_ = data;
	_tmp3__length1 = data_length1;
	_tmp4_ = granite_services_contractor_proxy_get_contracts_from_data (_tmp3_, (gint) _tmp3__length1);
	result = _tmp4_;
	data = (_vala_GraniteServicesContractData_array_free (data, data_length1), NULL);
	return result;
}

/**
         * Returns actions (contracts) applicable to the given file.
         *
         * Errors occurring in {@link GLib.File.query_info} method while looking up
         * the file (e.g. if the file is deleted) are forwarded to the caller.
         *
         * @param file An existing file.
         * @return {@link Gee.List} of contracts applicable to the given file.
         */
GeeList*
granite_services_contractor_proxy_get_contracts_for_file (GFile* file,
                                                          GError** error)
{
	GFile** files = NULL;
	GFile* _tmp0_;
	GFile** _tmp1_;
	gint files_length1;
	gint _files_size_;
	GeeList* _tmp2_ = NULL;
	GeeList* _tmp3_;
	GeeList* _tmp4_;
	GError* _inner_error0_ = NULL;
	GeeList* result;
	g_return_val_if_fail (file != NULL, NULL);
	_tmp0_ = _g_object_ref0 (file);
	_tmp1_ = g_new0 (GFile*, 1 + 1);
	_tmp1_[0] = _tmp0_;
	files = _tmp1_;
	files_length1 = 1;
	_files_size_ = files_length1;
	_tmp3_ = granite_services_contractor_proxy_get_contracts_for_files (files, (gint) files_length1, &_inner_error0_);
	_tmp2_ = _tmp3_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		files = (_vala_array_free (files, files_length1, (GDestroyNotify) g_object_unref), NULL);
		return NULL;
	}
	_tmp4_ = _tmp2_;
	_tmp2_ = NULL;
	result = _tmp4_;
	_g_object_unref0 (_tmp2_);
	files = (_vala_array_free (files, files_length1, (GDestroyNotify) g_object_unref), NULL);
	return result;
}

/**
         * Returns actions (contracts) applicable to all given files.
         *
         * Only the contracts that support all of the files are returned.<<BR>>
         * Errors occurring in {@link GLib.File.query_info} method while looking up
         * the file (e.g. if the file is deleted) are forwarded to the caller.<<BR>>
         *
         * @param files Array of existing files.
         * @return {@link Gee.List} of contracts applicable to any of the given files.
         */
GeeList*
granite_services_contractor_proxy_get_contracts_for_files (GFile** files,
                                                           gint files_length1,
                                                           GError** error)
{
	GeeHashSet* mime_types = NULL;
	GeeHashSet* _tmp0_;
	GeeList* _tmp11_ = NULL;
	GeeHashSet* _tmp12_;
	gint _tmp13_ = 0;
	gpointer* _tmp14_;
	gchar** _tmp15_;
	gint _tmp15__length1;
	GeeList* _tmp16_;
	GeeList* _tmp17_;
	GeeList* _tmp18_;
	GError* _inner_error0_ = NULL;
	GeeList* result;
	_tmp0_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	mime_types = _tmp0_;
	{
		GFile** file_collection = NULL;
		gint file_collection_length1 = 0;
		gint _file_collection_size_ = 0;
		gint file_it = 0;
		file_collection = files;
		file_collection_length1 = files_length1;
		for (file_it = 0; file_it < file_collection_length1; file_it = file_it + 1) {
			GFile* _tmp1_;
			GFile* file = NULL;
			_tmp1_ = _g_object_ref0 (file_collection[file_it]);
			file = _tmp1_;
			{
				GFileInfo* _tmp2_ = NULL;
				GFile* _tmp3_;
				GFileInfo* _tmp4_;
				gchar* content_type = NULL;
				const gchar* _tmp5_;
				gchar* _tmp6_;
				GeeHashSet* _tmp7_;
				const gchar* _tmp8_;
				gchar* _tmp9_;
				gchar* _tmp10_;
				_tmp3_ = file;
				_tmp4_ = g_file_query_info (_tmp3_, G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
				_tmp2_ = _tmp4_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_g_object_unref0 (file);
					_g_object_unref0 (mime_types);
					return NULL;
				}
				_tmp5_ = g_file_info_get_content_type (_tmp2_);
				_tmp6_ = g_strdup (_tmp5_);
				content_type = _tmp6_;
				_tmp7_ = mime_types;
				_tmp8_ = content_type;
				_tmp9_ = g_content_type_get_mime_type (_tmp8_);
				_tmp10_ = _tmp9_;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp7_, _tmp10_);
				_g_free0 (_tmp10_);
				_g_free0 (content_type);
				_g_object_unref0 (_tmp2_);
				_g_object_unref0 (file);
			}
		}
	}
	_tmp12_ = mime_types;
	_tmp14_ = gee_collection_to_array ((GeeCollection*) _tmp12_, &_tmp13_);
	_tmp15_ = _tmp14_;
	_tmp15__length1 = _tmp13_;
	_tmp16_ = granite_services_contractor_proxy_get_contracts_by_mimelist (_tmp15_, (gint) _tmp13_, &_inner_error0_);
	_tmp17_ = _tmp16_;
	_tmp15_ = (_vala_array_free (_tmp15_, _tmp15__length1, (GDestroyNotify) g_free), NULL);
	_tmp11_ = _tmp17_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (mime_types);
		return NULL;
	}
	_tmp18_ = _tmp11_;
	_tmp11_ = NULL;
	result = _tmp18_;
	_g_object_unref0 (_tmp11_);
	_g_object_unref0 (mime_types);
	return result;
}

static GeeList*
granite_services_contractor_proxy_get_contracts_from_data (GraniteServicesContractData* data,
                                                           gint data_length1)
{
	GeeLinkedList* contract_list = NULL;
	GeeLinkedList* _tmp0_;
	GeeList* result;
	_tmp0_ = gee_linked_list_new (GRANITE_SERVICES_TYPE_CONTRACT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	contract_list = _tmp0_;
	if (data != NULL) {
		{
			GraniteServicesContractData* contract_data_collection = NULL;
			gint contract_data_collection_length1 = 0;
			gint _contract_data_collection_size_ = 0;
			gint contract_data_it = 0;
			contract_data_collection = data;
			contract_data_collection_length1 = data_length1;
			for (contract_data_it = 0; contract_data_it < contract_data_collection_length1; contract_data_it = contract_data_it + 1) {
				GraniteServicesContractData _tmp1_;
				GraniteServicesContractData _tmp2_ = {0};
				GraniteServicesContractData contract_data = {0};
				_tmp1_ = contract_data_collection[contract_data_it];
				granite_services_contract_data_copy (&_tmp1_, &_tmp2_);
				contract_data = _tmp2_;
				{
					gchar* contract_id = NULL;
					GraniteServicesContractData _tmp3_;
					const gchar* _tmp4_;
					gchar* _tmp5_;
					GraniteServicesContractorProxyGenericContract* contract = NULL;
					GeeHashMap* _tmp6_;
					const gchar* _tmp7_;
					gpointer _tmp8_;
					GraniteServicesContractorProxyGenericContract* _tmp9_;
					GeeLinkedList* _tmp17_;
					GraniteServicesContractorProxyGenericContract* _tmp18_;
					_tmp3_ = contract_data;
					_tmp4_ = _tmp3_.id;
					_tmp5_ = g_strdup (_tmp4_);
					contract_id = _tmp5_;
					_tmp6_ = granite_services_contractor_proxy_contracts;
					_tmp7_ = contract_id;
					_tmp8_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp6_, _tmp7_);
					contract = (GraniteServicesContractorProxyGenericContract*) _tmp8_;
					_tmp9_ = contract;
					if (_tmp9_ == NULL) {
						GraniteServicesContractData _tmp10_;
						GraniteServicesContractorProxyGenericContract* _tmp11_;
						GeeHashMap* _tmp12_;
						const gchar* _tmp13_;
						GraniteServicesContractorProxyGenericContract* _tmp14_;
						_tmp10_ = contract_data;
						_tmp11_ = granite_services_contractor_proxy_generic_contract_new (&_tmp10_);
						_g_object_unref0 (contract);
						contract = _tmp11_;
						_tmp12_ = granite_services_contractor_proxy_contracts;
						_tmp13_ = contract_id;
						_tmp14_ = contract;
						gee_abstract_map_set ((GeeAbstractMap*) _tmp12_, _tmp13_, _tmp14_);
					} else {
						GraniteServicesContractorProxyGenericContract* _tmp15_;
						GraniteServicesContractData _tmp16_;
						_tmp15_ = contract;
						_tmp16_ = contract_data;
						granite_services_contractor_proxy_generic_contract_update_data (_tmp15_, &_tmp16_);
					}
					_tmp17_ = contract_list;
					_tmp18_ = contract;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp17_, (GraniteServicesContract*) _tmp18_);
					_g_object_unref0 (contract);
					_g_free0 (contract_id);
					granite_services_contract_data_destroy (&contract_data);
				}
			}
		}
	}
	result = (GeeList*) contract_list;
	return result;
}

static inline gpointer
granite_services_contractor_proxy_generic_contract_get_instance_private (GraniteServicesContractorProxyGenericContract* self)
{
	return G_STRUCT_MEMBER_P (self, GraniteServicesContractorProxyGenericContract_private_offset);
}

static const gchar*
granite_services_contractor_proxy_generic_contract_get_id (GraniteServicesContractorProxyGenericContract* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_id;
	result = _tmp0_;
	return result;
}

static void
granite_services_contractor_proxy_generic_contract_set_id (GraniteServicesContractorProxyGenericContract* self,
                                                           const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = granite_services_contractor_proxy_generic_contract_get_id (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_id);
		self->priv->_id = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, granite_services_contractor_proxy_generic_contract_properties[GRANITE_SERVICES_CONTRACTOR_PROXY_GENERIC_CONTRACT_ID_PROPERTY]);
	}
}

static GraniteServicesContractorProxyGenericContract*
granite_services_contractor_proxy_generic_contract_construct (GType object_type,
                                                              GraniteServicesContractData* data)
{
	GraniteServicesContractorProxyGenericContract * self = NULL;
	gchar* _tmp0_;
	GraniteServicesContractData _tmp1_;
	g_return_val_if_fail (data != NULL, NULL);
	self = (GraniteServicesContractorProxyGenericContract*) g_object_new (object_type, NULL);
	_tmp0_ = g_strdup ("");
	_g_free0 (self->priv->icon_key);
	self->priv->icon_key = _tmp0_;
	_tmp1_ = *data;
	granite_services_contractor_proxy_generic_contract_update_data (self, &_tmp1_);
	return self;
}

static GraniteServicesContractorProxyGenericContract*
granite_services_contractor_proxy_generic_contract_new (GraniteServicesContractData* data)
{
	return granite_services_contractor_proxy_generic_contract_construct (GRANITE_SERVICES_CONTRACTOR_PROXY_TYPE_GENERIC_CONTRACT, data);
}

static void
granite_services_contractor_proxy_generic_contract_update_data (GraniteServicesContractorProxyGenericContract* self,
                                                                GraniteServicesContractData* data)
{
	const gchar* _tmp0_ = NULL;
	GraniteServicesContractData _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_ = NULL;
	GraniteServicesContractData _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_ = NULL;
	GraniteServicesContractData _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	GraniteServicesContractData _tmp12_;
	const gchar* _tmp13_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (data != NULL);
	_tmp1_ = *data;
	_tmp2_ = _tmp1_.id;
	_tmp0_ = _tmp2_;
	if (_tmp0_ == NULL) {
		_tmp0_ = "";
	}
	granite_services_contractor_proxy_generic_contract_set_id (self, _tmp0_);
	_tmp4_ = *data;
	_tmp5_ = _tmp4_.display_name;
	_tmp3_ = _tmp5_;
	if (_tmp3_ == NULL) {
		_tmp3_ = "";
	}
	_tmp6_ = g_strdup (_tmp3_);
	_g_free0 (self->priv->display_name);
	self->priv->display_name = _tmp6_;
	_tmp8_ = *data;
	_tmp9_ = _tmp8_.description;
	_tmp7_ = _tmp9_;
	if (_tmp7_ == NULL) {
		_tmp7_ = "";
	}
	_tmp10_ = g_strdup (_tmp7_);
	_g_free0 (self->priv->description);
	self->priv->description = _tmp10_;
	_tmp11_ = self->priv->icon_key;
	_tmp12_ = *data;
	_tmp13_ = _tmp12_.icon;
	if (g_strcmp0 (_tmp11_, _tmp13_) != 0) {
		const gchar* _tmp14_ = NULL;
		GraniteServicesContractData _tmp15_;
		const gchar* _tmp16_;
		gchar* _tmp17_;
		_tmp15_ = *data;
		_tmp16_ = _tmp15_.icon;
		_tmp14_ = _tmp16_;
		if (_tmp14_ == NULL) {
			_tmp14_ = "";
		}
		_tmp17_ = g_strdup (_tmp14_);
		_g_free0 (self->priv->icon_key);
		self->priv->icon_key = _tmp17_;
		_g_object_unref0 (self->priv->icon);
		self->priv->icon = NULL;
	}
}

static gchar*
granite_services_contractor_proxy_generic_contract_real_get_display_name (GraniteServicesContract* base)
{
	GraniteServicesContractorProxyGenericContract * self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	self = (GraniteServicesContractorProxyGenericContract*) base;
	_tmp0_ = self->priv->display_name;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

static gchar*
granite_services_contractor_proxy_generic_contract_real_get_description (GraniteServicesContract* base)
{
	GraniteServicesContractorProxyGenericContract * self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	self = (GraniteServicesContractorProxyGenericContract*) base;
	_tmp0_ = self->priv->description;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

static GIcon*
granite_services_contractor_proxy_generic_contract_real_get_icon (GraniteServicesContract* base)
{
	GraniteServicesContractorProxyGenericContract * self;
	GIcon* _tmp0_;
	GIcon* _tmp8_;
	GIcon* _tmp9_;
	GIcon* result;
	self = (GraniteServicesContractorProxyGenericContract*) base;
	_tmp0_ = self->priv->icon;
	if (_tmp0_ == NULL) {
		const gchar* _tmp1_;
		_tmp1_ = self->priv->icon_key;
		if (g_path_is_absolute (_tmp1_)) {
			const gchar* _tmp2_;
			GFile* _tmp3_;
			GFile* _tmp4_;
			GFileIcon* _tmp5_;
			_tmp2_ = self->priv->icon_key;
			_tmp3_ = g_file_new_for_path (_tmp2_);
			_tmp4_ = _tmp3_;
			_tmp5_ = (GFileIcon*) g_file_icon_new (_tmp4_);
			_g_object_unref0 (self->priv->icon);
			self->priv->icon = (GIcon*) _tmp5_;
			_g_object_unref0 (_tmp4_);
		} else {
			const gchar* _tmp6_;
			GThemedIcon* _tmp7_;
			_tmp6_ = self->priv->icon_key;
			_tmp7_ = (GThemedIcon*) g_themed_icon_new_with_default_fallbacks (_tmp6_);
			_g_object_unref0 (self->priv->icon);
			self->priv->icon = (GIcon*) _tmp7_;
		}
	}
	_tmp8_ = self->priv->icon;
	_tmp9_ = _g_object_ref0 (_tmp8_);
	result = _tmp9_;
	return result;
}

static void
granite_services_contractor_proxy_generic_contract_real_execute_with_file (GraniteServicesContract* base,
                                                                           GFile* file,
                                                                           GError** error)
{
	GraniteServicesContractorProxyGenericContract * self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GError* _inner_error0_ = NULL;
	self = (GraniteServicesContractorProxyGenericContract*) base;
	g_return_if_fail (file != NULL);
	_tmp0_ = self->priv->_id;
	_tmp1_ = g_file_get_uri (file);
	_tmp2_ = _tmp1_;
	granite_services_contractor_proxy_execute_with_uri (_tmp0_, _tmp2_, &_inner_error0_);
	_g_free0 (_tmp2_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

static void
_vala_array_add1 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
granite_services_contractor_proxy_generic_contract_real_execute_with_files (GraniteServicesContract* base,
                                                                            GFile** files,
                                                                            gint files_length1,
                                                                            GError** error)
{
	GraniteServicesContractorProxyGenericContract * self;
	gchar** uris = NULL;
	gchar** _tmp0_;
	gint uris_length1;
	gint _uris_size_;
	const gchar* _tmp4_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	GError* _inner_error0_ = NULL;
	self = (GraniteServicesContractorProxyGenericContract*) base;
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	uris = _tmp0_;
	uris_length1 = 0;
	_uris_size_ = uris_length1;
	{
		GFile** file_collection = NULL;
		gint file_collection_length1 = 0;
		gint _file_collection_size_ = 0;
		gint file_it = 0;
		file_collection = files;
		file_collection_length1 = files_length1;
		for (file_it = 0; file_it < file_collection_length1; file_it = file_it + 1) {
			GFile* _tmp1_;
			GFile* file = NULL;
			_tmp1_ = _g_object_ref0 (file_collection[file_it]);
			file = _tmp1_;
			{
				GFile* _tmp2_;
				gchar* _tmp3_;
				_tmp2_ = file;
				_tmp3_ = g_file_get_uri (_tmp2_);
				_vala_array_add1 (&uris, &uris_length1, &_uris_size_, _tmp3_);
				_g_object_unref0 (file);
			}
		}
	}
	_tmp4_ = self->priv->_id;
	_tmp5_ = uris;
	_tmp5__length1 = uris_length1;
	granite_services_contractor_proxy_execute_with_uri_list (_tmp4_, _tmp5_, (gint) _tmp5__length1, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		uris = (_vala_array_free (uris, uris_length1, (GDestroyNotify) g_free), NULL);
		return;
	}
	uris = (_vala_array_free (uris, uris_length1, (GDestroyNotify) g_free), NULL);
}

static void
granite_services_contractor_proxy_generic_contract_class_init (GraniteServicesContractorProxyGenericContractClass * klass,
                                                               gpointer klass_data)
{
	granite_services_contractor_proxy_generic_contract_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GraniteServicesContractorProxyGenericContract_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_granite_services_contractor_proxy_generic_contract_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_granite_services_contractor_proxy_generic_contract_set_property;
	G_OBJECT_CLASS (klass)->finalize = granite_services_contractor_proxy_generic_contract_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_SERVICES_CONTRACTOR_PROXY_GENERIC_CONTRACT_ID_PROPERTY, granite_services_contractor_proxy_generic_contract_properties[GRANITE_SERVICES_CONTRACTOR_PROXY_GENERIC_CONTRACT_ID_PROPERTY] = g_param_spec_string ("id", "id", "id", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
granite_services_contractor_proxy_generic_contract_granite_services_contract_interface_init (GraniteServicesContractIface * iface,
                                                                                             gpointer iface_data)
{
	granite_services_contractor_proxy_generic_contract_granite_services_contract_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_display_name = (gchar* (*) (GraniteServicesContract*)) granite_services_contractor_proxy_generic_contract_real_get_display_name;
	iface->get_description = (gchar* (*) (GraniteServicesContract*)) granite_services_contractor_proxy_generic_contract_real_get_description;
	iface->get_icon = (GIcon* (*) (GraniteServicesContract*)) granite_services_contractor_proxy_generic_contract_real_get_icon;
	iface->execute_with_file = (void (*) (GraniteServicesContract*, GFile*, GError**)) granite_services_contractor_proxy_generic_contract_real_execute_with_file;
	iface->execute_with_files = (void (*) (GraniteServicesContract*, GFile**, gint, GError**)) granite_services_contractor_proxy_generic_contract_real_execute_with_files;
}

static void
granite_services_contractor_proxy_generic_contract_instance_init (GraniteServicesContractorProxyGenericContract * self,
                                                                  gpointer klass)
{
	self->priv = granite_services_contractor_proxy_generic_contract_get_instance_private (self);
}

static void
granite_services_contractor_proxy_generic_contract_finalize (GObject * obj)
{
	GraniteServicesContractorProxyGenericContract * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GRANITE_SERVICES_CONTRACTOR_PROXY_TYPE_GENERIC_CONTRACT, GraniteServicesContractorProxyGenericContract);
	_g_free0 (self->priv->_id);
	_g_free0 (self->priv->display_name);
	_g_free0 (self->priv->description);
	_g_free0 (self->priv->icon_key);
	_g_object_unref0 (self->priv->icon);
	G_OBJECT_CLASS (granite_services_contractor_proxy_generic_contract_parent_class)->finalize (obj);
}

static GType
granite_services_contractor_proxy_generic_contract_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GraniteServicesContractorProxyGenericContractClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) granite_services_contractor_proxy_generic_contract_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GraniteServicesContractorProxyGenericContract), 0, (GInstanceInitFunc) granite_services_contractor_proxy_generic_contract_instance_init, NULL };
	static const GInterfaceInfo granite_services_contract_info = { (GInterfaceInitFunc) granite_services_contractor_proxy_generic_contract_granite_services_contract_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType granite_services_contractor_proxy_generic_contract_type_id;
	granite_services_contractor_proxy_generic_contract_type_id = g_type_register_static (G_TYPE_OBJECT, "GraniteServicesContractorProxyGenericContract", &g_define_type_info, 0);
	g_type_add_interface_static (granite_services_contractor_proxy_generic_contract_type_id, GRANITE_SERVICES_TYPE_CONTRACT, &granite_services_contract_info);
	GraniteServicesContractorProxyGenericContract_private_offset = g_type_add_instance_private (granite_services_contractor_proxy_generic_contract_type_id, sizeof (GraniteServicesContractorProxyGenericContractPrivate));
	return granite_services_contractor_proxy_generic_contract_type_id;
}

static GType
granite_services_contractor_proxy_generic_contract_get_type (void)
{
	static volatile gsize granite_services_contractor_proxy_generic_contract_type_id__once = 0;
	if (g_once_init_enter (&granite_services_contractor_proxy_generic_contract_type_id__once)) {
		GType granite_services_contractor_proxy_generic_contract_type_id;
		granite_services_contractor_proxy_generic_contract_type_id = granite_services_contractor_proxy_generic_contract_get_type_once ();
		g_once_init_leave (&granite_services_contractor_proxy_generic_contract_type_id__once, granite_services_contractor_proxy_generic_contract_type_id);
	}
	return granite_services_contractor_proxy_generic_contract_type_id__once;
}

static void
_vala_granite_services_contractor_proxy_generic_contract_get_property (GObject * object,
                                                                       guint property_id,
                                                                       GValue * value,
                                                                       GParamSpec * pspec)
{
	GraniteServicesContractorProxyGenericContract * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GRANITE_SERVICES_CONTRACTOR_PROXY_TYPE_GENERIC_CONTRACT, GraniteServicesContractorProxyGenericContract);
	switch (property_id) {
		case GRANITE_SERVICES_CONTRACTOR_PROXY_GENERIC_CONTRACT_ID_PROPERTY:
		g_value_set_string (value, granite_services_contractor_proxy_generic_contract_get_id (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_granite_services_contractor_proxy_generic_contract_set_property (GObject * object,
                                                                       guint property_id,
                                                                       const GValue * value,
                                                                       GParamSpec * pspec)
{
	GraniteServicesContractorProxyGenericContract * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GRANITE_SERVICES_CONTRACTOR_PROXY_TYPE_GENERIC_CONTRACT, GraniteServicesContractorProxyGenericContract);
	switch (property_id) {
		case GRANITE_SERVICES_CONTRACTOR_PROXY_GENERIC_CONTRACT_ID_PROPERTY:
		granite_services_contractor_proxy_generic_contract_set_id (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
granite_services_contractor_proxy_class_init (GraniteServicesContractorProxyClass * klass,
                                              gpointer klass_data)
{
	granite_services_contractor_proxy_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = granite_services_contractor_proxy_finalize;
	/**
	         * Emitted when the list of actions available to Contractor changes.
	         * Application should generally request the updated list of actions upon receiving this signal.
	         *
	         * This is not obligatory for frequently updated lists (e.g. in context menus), 
	         * but essential for applications that display action lists without re-requesting them.
	         */
	granite_services_contractor_proxy_signals[GRANITE_SERVICES_CONTRACTOR_PROXY_CONTRACTS_CHANGED_SIGNAL] = g_signal_new ("contracts-changed", GRANITE_SERVICES_TYPE_CONTRACTOR_PROXY, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
granite_services_contractor_proxy_instance_init (GraniteServicesContractorProxy * self,
                                                 gpointer klass)
{
}

static void
granite_services_contractor_proxy_finalize (GObject * obj)
{
	GraniteServicesContractorProxy * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GRANITE_SERVICES_TYPE_CONTRACTOR_PROXY, GraniteServicesContractorProxy);
	G_OBJECT_CLASS (granite_services_contractor_proxy_parent_class)->finalize (obj);
}

/**
     * Provides a convenient GObject wrapper around Contractor's D-bus API
     */
static GType
granite_services_contractor_proxy_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GraniteServicesContractorProxyClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) granite_services_contractor_proxy_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GraniteServicesContractorProxy), 0, (GInstanceInitFunc) granite_services_contractor_proxy_instance_init, NULL };
	GType granite_services_contractor_proxy_type_id;
	granite_services_contractor_proxy_type_id = g_type_register_static (G_TYPE_OBJECT, "GraniteServicesContractorProxy", &g_define_type_info, 0);
	return granite_services_contractor_proxy_type_id;
}

GType
granite_services_contractor_proxy_get_type (void)
{
	static volatile gsize granite_services_contractor_proxy_type_id__once = 0;
	if (g_once_init_enter (&granite_services_contractor_proxy_type_id__once)) {
		GType granite_services_contractor_proxy_type_id;
		granite_services_contractor_proxy_type_id = granite_services_contractor_proxy_get_type_once ();
		g_once_init_leave (&granite_services_contractor_proxy_type_id__once, granite_services_contractor_proxy_type_id);
	}
	return granite_services_contractor_proxy_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

