{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- @GEmblem@ is an implementation of t'GI.Gio.Interfaces.Icon.Icon' that supports
-- having an emblem, which is an icon with additional properties.
-- It can than be added to a t'GI.Gio.Objects.EmblemedIcon.EmblemedIcon'.
-- 
-- Currently, only metainformation about the emblem\'s origin is
-- supported. More may be added in the future.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Objects.Emblem
    ( 

-- * Exported types
    Emblem(..)                              ,
    IsEmblem                                ,
    toEmblem                                ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [equal]("GI.Gio.Interfaces.Icon#g:method:equal"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [hash]("GI.Gio.Interfaces.Icon#g:method:hash"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [serialize]("GI.Gio.Interfaces.Icon#g:method:serialize"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [toString]("GI.Gio.Interfaces.Icon#g:method:toString"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getIcon]("GI.Gio.Objects.Emblem#g:method:getIcon"), [getOrigin]("GI.Gio.Objects.Emblem#g:method:getOrigin"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveEmblemMethod                     ,
#endif

-- ** getIcon #method:getIcon#

#if defined(ENABLE_OVERLOADING)
    EmblemGetIconMethodInfo                 ,
#endif
    emblemGetIcon                           ,


-- ** getOrigin #method:getOrigin#

#if defined(ENABLE_OVERLOADING)
    EmblemGetOriginMethodInfo               ,
#endif
    emblemGetOrigin                         ,


-- ** new #method:new#

    emblemNew                               ,


-- ** newWithOrigin #method:newWithOrigin#

    emblemNewWithOrigin                     ,




 -- * Properties


-- ** icon #attr:icon#
-- | The actual icon of the emblem.
-- 
-- /Since: 2.18/

#if defined(ENABLE_OVERLOADING)
    EmblemIconPropertyInfo                  ,
#endif
    constructEmblemIcon                     ,
#if defined(ENABLE_OVERLOADING)
    emblemIcon                              ,
#endif
    getEmblemIcon                           ,


-- ** origin #attr:origin#
-- | The origin the emblem is derived from.
-- 
-- /Since: 2.18/

#if defined(ENABLE_OVERLOADING)
    EmblemOriginPropertyInfo                ,
#endif
    constructEmblemOrigin                   ,
#if defined(ENABLE_OVERLOADING)
    emblemOrigin                            ,
#endif
    getEmblemOrigin                         ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gio.Enums as Gio.Enums
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Icon as Gio.Icon

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gio.Enums as Gio.Enums
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Icon as Gio.Icon

#endif

-- | Memory-managed wrapper type.
newtype Emblem = Emblem (SP.ManagedPtr Emblem)
    deriving (Eq)

instance SP.ManagedPtrNewtype Emblem where
    toManagedPtr (Emblem p) = p

foreign import ccall "g_emblem_get_type"
    c_g_emblem_get_type :: IO B.Types.GType

instance B.Types.TypedObject Emblem where
    glibType = c_g_emblem_get_type

instance B.Types.GObject Emblem

-- | Type class for types which can be safely cast to t'Emblem', for instance with `toEmblem`.
class (SP.GObject o, O.IsDescendantOf Emblem o) => IsEmblem o
instance (SP.GObject o, O.IsDescendantOf Emblem o) => IsEmblem o

instance O.HasParentTypes Emblem
type instance O.ParentTypes Emblem = '[GObject.Object.Object, Gio.Icon.Icon]

-- | Cast to t'Emblem', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toEmblem :: (MIO.MonadIO m, IsEmblem o) => o -> m Emblem
toEmblem = MIO.liftIO . B.ManagedPtr.unsafeCastTo Emblem

-- | Convert t'Emblem' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe Emblem) where
    gvalueGType_ = c_g_emblem_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr Emblem)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr Emblem)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject Emblem ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveEmblemMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveEmblemMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveEmblemMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveEmblemMethod "equal" o = Gio.Icon.IconEqualMethodInfo
    ResolveEmblemMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveEmblemMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveEmblemMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveEmblemMethod "hash" o = Gio.Icon.IconHashMethodInfo
    ResolveEmblemMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveEmblemMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveEmblemMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveEmblemMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveEmblemMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveEmblemMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveEmblemMethod "serialize" o = Gio.Icon.IconSerializeMethodInfo
    ResolveEmblemMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveEmblemMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveEmblemMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveEmblemMethod "toString" o = Gio.Icon.IconToStringMethodInfo
    ResolveEmblemMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveEmblemMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveEmblemMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveEmblemMethod "getIcon" o = EmblemGetIconMethodInfo
    ResolveEmblemMethod "getOrigin" o = EmblemGetOriginMethodInfo
    ResolveEmblemMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveEmblemMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveEmblemMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveEmblemMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveEmblemMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveEmblemMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveEmblemMethod t Emblem, O.OverloadedMethod info Emblem p) => OL.IsLabel t (Emblem -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveEmblemMethod t Emblem, O.OverloadedMethod info Emblem p, R.HasField t Emblem p) => R.HasField t Emblem p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveEmblemMethod t Emblem, O.OverloadedMethodInfo info Emblem) => OL.IsLabel t (O.MethodProxy info Emblem) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "icon"
   -- Type: TInterface (Name {namespace = "GObject", name = "Object"})
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@icon@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' emblem #icon
-- @
getEmblemIcon :: (MonadIO m, IsEmblem o) => o -> m (Maybe GObject.Object.Object)
getEmblemIcon obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "icon" GObject.Object.Object

-- | Construct a t'GValueConstruct' with valid value for the “@icon@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructEmblemIcon :: (IsEmblem o, MIO.MonadIO m, GObject.Object.IsObject a) => a -> m (GValueConstruct o)
constructEmblemIcon val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "icon" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data EmblemIconPropertyInfo
instance AttrInfo EmblemIconPropertyInfo where
    type AttrAllowedOps EmblemIconPropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint EmblemIconPropertyInfo = IsEmblem
    type AttrSetTypeConstraint EmblemIconPropertyInfo = GObject.Object.IsObject
    type AttrTransferTypeConstraint EmblemIconPropertyInfo = GObject.Object.IsObject
    type AttrTransferType EmblemIconPropertyInfo = GObject.Object.Object
    type AttrGetType EmblemIconPropertyInfo = (Maybe GObject.Object.Object)
    type AttrLabel EmblemIconPropertyInfo = "icon"
    type AttrOrigin EmblemIconPropertyInfo = Emblem
    attrGet = getEmblemIcon
    attrSet = undefined
    attrTransfer _ v = do
        unsafeCastTo GObject.Object.Object v
    attrConstruct = constructEmblemIcon
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.Emblem.icon"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-Emblem.html#g:attr:icon"
        })
#endif

-- VVV Prop "origin"
   -- Type: TInterface (Name {namespace = "Gio", name = "EmblemOrigin"})
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@origin@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' emblem #origin
-- @
getEmblemOrigin :: (MonadIO m, IsEmblem o) => o -> m Gio.Enums.EmblemOrigin
getEmblemOrigin obj = MIO.liftIO $ B.Properties.getObjectPropertyEnum obj "origin"

-- | Construct a t'GValueConstruct' with valid value for the “@origin@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructEmblemOrigin :: (IsEmblem o, MIO.MonadIO m) => Gio.Enums.EmblemOrigin -> m (GValueConstruct o)
constructEmblemOrigin val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyEnum "origin" val

#if defined(ENABLE_OVERLOADING)
data EmblemOriginPropertyInfo
instance AttrInfo EmblemOriginPropertyInfo where
    type AttrAllowedOps EmblemOriginPropertyInfo = '[ 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint EmblemOriginPropertyInfo = IsEmblem
    type AttrSetTypeConstraint EmblemOriginPropertyInfo = (~) Gio.Enums.EmblemOrigin
    type AttrTransferTypeConstraint EmblemOriginPropertyInfo = (~) Gio.Enums.EmblemOrigin
    type AttrTransferType EmblemOriginPropertyInfo = Gio.Enums.EmblemOrigin
    type AttrGetType EmblemOriginPropertyInfo = Gio.Enums.EmblemOrigin
    type AttrLabel EmblemOriginPropertyInfo = "origin"
    type AttrOrigin EmblemOriginPropertyInfo = Emblem
    attrGet = getEmblemOrigin
    attrSet = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructEmblemOrigin
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.Emblem.origin"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-Emblem.html#g:attr:origin"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList Emblem
type instance O.AttributeList Emblem = EmblemAttributeList
type EmblemAttributeList = ('[ '("icon", EmblemIconPropertyInfo), '("origin", EmblemOriginPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
emblemIcon :: AttrLabelProxy "icon"
emblemIcon = AttrLabelProxy

emblemOrigin :: AttrLabelProxy "origin"
emblemOrigin = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList Emblem = EmblemSignalList
type EmblemSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method Emblem::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "icon"
--           , argType = TInterface Name { namespace = "Gio" , name = "Icon" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a GIcon containing the icon."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "Emblem" })
-- throws : False
-- Skip return : False

foreign import ccall "g_emblem_new" g_emblem_new :: 
    Ptr Gio.Icon.Icon ->                    -- icon : TInterface (Name {namespace = "Gio", name = "Icon"})
    IO (Ptr Emblem)

-- | Creates a new emblem for /@icon@/.
-- 
-- /Since: 2.18/
emblemNew ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.Icon.IsIcon a) =>
    a
    -- ^ /@icon@/: a GIcon containing the icon.
    -> m Emblem
    -- ^ __Returns:__ a new t'GI.Gio.Objects.Emblem.Emblem'.
emblemNew icon = liftIO $ do
    icon' <- unsafeManagedPtrCastPtr icon
    result <- g_emblem_new icon'
    checkUnexpectedReturnNULL "emblemNew" result
    result' <- (wrapObject Emblem) result
    touchManagedPtr icon
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method Emblem::new_with_origin
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "icon"
--           , argType = TInterface Name { namespace = "Gio" , name = "Icon" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a GIcon containing the icon."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "origin"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "EmblemOrigin" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a GEmblemOrigin enum defining the emblem's origin"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "Emblem" })
-- throws : False
-- Skip return : False

foreign import ccall "g_emblem_new_with_origin" g_emblem_new_with_origin :: 
    Ptr Gio.Icon.Icon ->                    -- icon : TInterface (Name {namespace = "Gio", name = "Icon"})
    CUInt ->                                -- origin : TInterface (Name {namespace = "Gio", name = "EmblemOrigin"})
    IO (Ptr Emblem)

-- | Creates a new emblem for /@icon@/.
-- 
-- /Since: 2.18/
emblemNewWithOrigin ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.Icon.IsIcon a) =>
    a
    -- ^ /@icon@/: a GIcon containing the icon.
    -> Gio.Enums.EmblemOrigin
    -- ^ /@origin@/: a GEmblemOrigin enum defining the emblem\'s origin
    -> m Emblem
    -- ^ __Returns:__ a new t'GI.Gio.Objects.Emblem.Emblem'.
emblemNewWithOrigin icon origin = liftIO $ do
    icon' <- unsafeManagedPtrCastPtr icon
    let origin' = (fromIntegral . fromEnum) origin
    result <- g_emblem_new_with_origin icon' origin'
    checkUnexpectedReturnNULL "emblemNewWithOrigin" result
    result' <- (wrapObject Emblem) result
    touchManagedPtr icon
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method Emblem::get_icon
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "emblem"
--           , argType = TInterface Name { namespace = "Gio" , name = "Emblem" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a #GEmblem from which the icon should be extracted."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "Icon" })
-- throws : False
-- Skip return : False

foreign import ccall "g_emblem_get_icon" g_emblem_get_icon :: 
    Ptr Emblem ->                           -- emblem : TInterface (Name {namespace = "Gio", name = "Emblem"})
    IO (Ptr Gio.Icon.Icon)

-- | Gives back the icon from /@emblem@/.
-- 
-- /Since: 2.18/
emblemGetIcon ::
    (B.CallStack.HasCallStack, MonadIO m, IsEmblem a) =>
    a
    -- ^ /@emblem@/: a t'GI.Gio.Objects.Emblem.Emblem' from which the icon should be extracted.
    -> m Gio.Icon.Icon
    -- ^ __Returns:__ a t'GI.Gio.Interfaces.Icon.Icon'. The returned object belongs to
    --          the emblem and should not be modified or freed.
emblemGetIcon emblem = liftIO $ do
    emblem' <- unsafeManagedPtrCastPtr emblem
    result <- g_emblem_get_icon emblem'
    checkUnexpectedReturnNULL "emblemGetIcon" result
    result' <- (newObject Gio.Icon.Icon) result
    touchManagedPtr emblem
    return result'

#if defined(ENABLE_OVERLOADING)
data EmblemGetIconMethodInfo
instance (signature ~ (m Gio.Icon.Icon), MonadIO m, IsEmblem a) => O.OverloadedMethod EmblemGetIconMethodInfo a signature where
    overloadedMethod = emblemGetIcon

instance O.OverloadedMethodInfo EmblemGetIconMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.Emblem.emblemGetIcon",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-Emblem.html#v:emblemGetIcon"
        })


#endif

-- method Emblem::get_origin
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "emblem"
--           , argType = TInterface Name { namespace = "Gio" , name = "Emblem" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GEmblem" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gio" , name = "EmblemOrigin" })
-- throws : False
-- Skip return : False

foreign import ccall "g_emblem_get_origin" g_emblem_get_origin :: 
    Ptr Emblem ->                           -- emblem : TInterface (Name {namespace = "Gio", name = "Emblem"})
    IO CUInt

-- | Gets the origin of the emblem.
-- 
-- /Since: 2.18/
emblemGetOrigin ::
    (B.CallStack.HasCallStack, MonadIO m, IsEmblem a) =>
    a
    -- ^ /@emblem@/: a t'GI.Gio.Objects.Emblem.Emblem'
    -> m Gio.Enums.EmblemOrigin
    -- ^ __Returns:__ the origin of the emblem
emblemGetOrigin emblem = liftIO $ do
    emblem' <- unsafeManagedPtrCastPtr emblem
    result <- g_emblem_get_origin emblem'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr emblem
    return result'

#if defined(ENABLE_OVERLOADING)
data EmblemGetOriginMethodInfo
instance (signature ~ (m Gio.Enums.EmblemOrigin), MonadIO m, IsEmblem a) => O.OverloadedMethod EmblemGetOriginMethodInfo a signature where
    overloadedMethod = emblemGetOrigin

instance O.OverloadedMethodInfo EmblemGetOriginMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.Emblem.emblemGetOrigin",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-Emblem.html#v:emblemGetOrigin"
        })


#endif


