/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

import (
	corev1 "k8s.io/api/core/v1"
)

// NodeStatusApplyConfiguration represents a declarative configuration of the NodeStatus type for use
// with apply.
//
// NodeStatus is information about the current status of a node.
type NodeStatusApplyConfiguration struct {
	// Capacity represents the total resources of a node.
	// More info: https://kubernetes.io/docs/reference/node/node-status/#capacity
	Capacity *corev1.ResourceList `json:"capacity,omitempty"`
	// Allocatable represents the resources of a node that are available for scheduling.
	// Defaults to Capacity.
	Allocatable *corev1.ResourceList `json:"allocatable,omitempty"`
	// NodePhase is the recently observed lifecycle phase of the node.
	// More info: https://kubernetes.io/docs/concepts/nodes/node/#phase
	// The field is never populated, and now is deprecated.
	Phase *corev1.NodePhase `json:"phase,omitempty"`
	// Conditions is an array of current observed node conditions.
	// More info: https://kubernetes.io/docs/reference/node/node-status/#condition
	Conditions []NodeConditionApplyConfiguration `json:"conditions,omitempty"`
	// List of addresses reachable to the node.
	// Queried from cloud provider, if available.
	// More info: https://kubernetes.io/docs/reference/node/node-status/#addresses
	// Note: This field is declared as mergeable, but the merge key is not sufficiently
	// unique, which can cause data corruption when it is merged. Callers should instead
	// use a full-replacement patch. See https://pr.k8s.io/79391 for an example.
	// Consumers should assume that addresses can change during the
	// lifetime of a Node. However, there are some exceptions where this may not
	// be possible, such as Pods that inherit a Node's address in its own status or
	// consumers of the downward API (status.hostIP).
	Addresses []NodeAddressApplyConfiguration `json:"addresses,omitempty"`
	// Endpoints of daemons running on the Node.
	DaemonEndpoints *NodeDaemonEndpointsApplyConfiguration `json:"daemonEndpoints,omitempty"`
	// Set of ids/uuids to uniquely identify the node.
	// More info: https://kubernetes.io/docs/reference/node/node-status/#info
	NodeInfo *NodeSystemInfoApplyConfiguration `json:"nodeInfo,omitempty"`
	// List of container images on this node
	Images []ContainerImageApplyConfiguration `json:"images,omitempty"`
	// List of attachable volumes in use (mounted) by the node.
	VolumesInUse []corev1.UniqueVolumeName `json:"volumesInUse,omitempty"`
	// List of volumes that are attached to the node.
	VolumesAttached []AttachedVolumeApplyConfiguration `json:"volumesAttached,omitempty"`
	// Status of the config assigned to the node via the dynamic Kubelet config feature.
	Config *NodeConfigStatusApplyConfiguration `json:"config,omitempty"`
	// The available runtime handlers.
	RuntimeHandlers []NodeRuntimeHandlerApplyConfiguration `json:"runtimeHandlers,omitempty"`
	// Features describes the set of features implemented by the CRI implementation.
	Features *NodeFeaturesApplyConfiguration `json:"features,omitempty"`
	// DeclaredFeatures represents the features related to feature gates that are declared by the node.
	DeclaredFeatures []string `json:"declaredFeatures,omitempty"`
}

// NodeStatusApplyConfiguration constructs a declarative configuration of the NodeStatus type for use with
// apply.
func NodeStatus() *NodeStatusApplyConfiguration {
	return &NodeStatusApplyConfiguration{}
}

// WithCapacity sets the Capacity field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Capacity field is set to the value of the last call.
func (b *NodeStatusApplyConfiguration) WithCapacity(value corev1.ResourceList) *NodeStatusApplyConfiguration {
	b.Capacity = &value
	return b
}

// WithAllocatable sets the Allocatable field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Allocatable field is set to the value of the last call.
func (b *NodeStatusApplyConfiguration) WithAllocatable(value corev1.ResourceList) *NodeStatusApplyConfiguration {
	b.Allocatable = &value
	return b
}

// WithPhase sets the Phase field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Phase field is set to the value of the last call.
func (b *NodeStatusApplyConfiguration) WithPhase(value corev1.NodePhase) *NodeStatusApplyConfiguration {
	b.Phase = &value
	return b
}

// WithConditions adds the given value to the Conditions field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Conditions field.
func (b *NodeStatusApplyConfiguration) WithConditions(values ...*NodeConditionApplyConfiguration) *NodeStatusApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithConditions")
		}
		b.Conditions = append(b.Conditions, *values[i])
	}
	return b
}

// WithAddresses adds the given value to the Addresses field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Addresses field.
func (b *NodeStatusApplyConfiguration) WithAddresses(values ...*NodeAddressApplyConfiguration) *NodeStatusApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithAddresses")
		}
		b.Addresses = append(b.Addresses, *values[i])
	}
	return b
}

// WithDaemonEndpoints sets the DaemonEndpoints field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the DaemonEndpoints field is set to the value of the last call.
func (b *NodeStatusApplyConfiguration) WithDaemonEndpoints(value *NodeDaemonEndpointsApplyConfiguration) *NodeStatusApplyConfiguration {
	b.DaemonEndpoints = value
	return b
}

// WithNodeInfo sets the NodeInfo field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the NodeInfo field is set to the value of the last call.
func (b *NodeStatusApplyConfiguration) WithNodeInfo(value *NodeSystemInfoApplyConfiguration) *NodeStatusApplyConfiguration {
	b.NodeInfo = value
	return b
}

// WithImages adds the given value to the Images field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Images field.
func (b *NodeStatusApplyConfiguration) WithImages(values ...*ContainerImageApplyConfiguration) *NodeStatusApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithImages")
		}
		b.Images = append(b.Images, *values[i])
	}
	return b
}

// WithVolumesInUse adds the given value to the VolumesInUse field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the VolumesInUse field.
func (b *NodeStatusApplyConfiguration) WithVolumesInUse(values ...corev1.UniqueVolumeName) *NodeStatusApplyConfiguration {
	for i := range values {
		b.VolumesInUse = append(b.VolumesInUse, values[i])
	}
	return b
}

// WithVolumesAttached adds the given value to the VolumesAttached field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the VolumesAttached field.
func (b *NodeStatusApplyConfiguration) WithVolumesAttached(values ...*AttachedVolumeApplyConfiguration) *NodeStatusApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithVolumesAttached")
		}
		b.VolumesAttached = append(b.VolumesAttached, *values[i])
	}
	return b
}

// WithConfig sets the Config field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Config field is set to the value of the last call.
func (b *NodeStatusApplyConfiguration) WithConfig(value *NodeConfigStatusApplyConfiguration) *NodeStatusApplyConfiguration {
	b.Config = value
	return b
}

// WithRuntimeHandlers adds the given value to the RuntimeHandlers field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the RuntimeHandlers field.
func (b *NodeStatusApplyConfiguration) WithRuntimeHandlers(values ...*NodeRuntimeHandlerApplyConfiguration) *NodeStatusApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithRuntimeHandlers")
		}
		b.RuntimeHandlers = append(b.RuntimeHandlers, *values[i])
	}
	return b
}

// WithFeatures sets the Features field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Features field is set to the value of the last call.
func (b *NodeStatusApplyConfiguration) WithFeatures(value *NodeFeaturesApplyConfiguration) *NodeStatusApplyConfiguration {
	b.Features = value
	return b
}

// WithDeclaredFeatures adds the given value to the DeclaredFeatures field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the DeclaredFeatures field.
func (b *NodeStatusApplyConfiguration) WithDeclaredFeatures(values ...string) *NodeStatusApplyConfiguration {
	for i := range values {
		b.DeclaredFeatures = append(b.DeclaredFeatures, values[i])
	}
	return b
}
