
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kcoreaddons_python.h"

// main header
#include "krandom_wrapper.h"

// Argument includes
#include <QString>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KRandom_Type = nullptr;
static PyTypeObject *Sbk_KRandom_TypeF(void)
{
    return _Sbk_KRandom_Type;
}
} // extern "C"


// Target ---------------------------------------------------------

extern "C" {
static int Sbk_KRandom_Init(PyObject *, PyObject *, PyObject *)
{
    Shiboken::Errors::setInstantiateNamespace("KRandom");
    return -1;
}

static PyObject *Sbk_KRandomFunc_randomString(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static KRandom::randomString(int)->QString
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // randomString(int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "randomString", errInfo, SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKRandom_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // randomString(int)
            QString cppResult = ::KRandom::randomString(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_KRandom_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_KRandom_methods[] = {
    {"randomString", reinterpret_cast<PyCFunction>(Sbk_KRandomFunc_randomString), METH_O|METH_STATIC, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_KRandom_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KRandom_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KRandom_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(Sbk_object_dealloc /* PYSIDE-832: Prevent replacement of "0" with subtype_dealloc. */)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KRandom_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KRandom_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KRandom_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KRandom_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkDummyNew /* PYSIDE-595: Prevent replacement of "0" with base->tp_new. */)},
    {0, nullptr}
};
static PyType_Spec Sbk_KRandom_spec = {
    "1:KCoreAddons.KRandom",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KRandom_slots
};

} //extern "C"

// Type conversion functions.

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KCoreAddonsKRandom_SignatureStrings[] = {
    "KCoreAddons.KRandom.randomString(length:int)->QString",
    nullptr}; // Sentinel
#else
static constexpr size_t KCoreAddonsKRandom_SignatureByteSize = 54;
static constexpr uint8_t KCoreAddonsKRandom_SignatureBytes[54] = {
    0x78, 0xda, 0xf3, 0x76, 0xce, 0x2f, 0x4a, 0x75, 0x4c, 0x49, 0xc9, 0xcf, 0x2b, 0xd6, 0xf3, 0x0e,
    0x4a, 0xcc, 0x4b, 0xc9, 0xcf, 0xd5, 0x2b, 0x02, 0x53, 0xc1, 0x25, 0x45, 0x99, 0x79, 0xe9, 0x1a,
    0x39, 0xa9, 0x79, 0xe9, 0x25, 0x19, 0x56, 0x99, 0x79, 0x25, 0x9a, 0xba, 0x76, 0x81, 0x10, 0x41,
    0x2e, 0x00, 0x27, 0xef, 0x13, 0xc3
};
#endif

PyTypeObject *init_KCoreAddonsKRandom(PyObject *module)
{
    if (SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKRandom_IDX].type != nullptr)
        return SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKRandom_IDX].type;

    Shiboken::AutoDecRef Sbk_KRandom_Type_bases(PyTuple_Pack(1,
        SbkObject_TypeF()));

    _Sbk_KRandom_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KRandom",
        "KRandom",
        &Sbk_KRandom_spec,
        nullptr,
        Sbk_KRandom_Type_bases.object(),
        0);
    auto *pyType = Sbk_KRandom_TypeF(); // references _Sbk_KRandom_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KCoreAddonsKRandom_SignatureStrings);
#else
    InitSignatureBytes(pyType, KCoreAddonsKRandom_SignatureBytes, KCoreAddonsKRandom_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KRandom_PropertyStrings);
    SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKRandom_IDX].type = pyType;



    return pyType;
}
