
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kwidgetsaddons_python.h"

// main header
#include "kmimetypechooserdialog_wrapper.h"

// Wrappers providing overrides
#include "kxyselector_wrapper.h"
#include "kpixmapregionselectordialog_wrapper.h"
#include "ktimecombobox_wrapper.h"

// Argument includes
#include <QString>
#include <QStringList>
#include <kmimetypechooser.h>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qevent.h>
#include <qmetaobject.h>
#include <qnamespace.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpaintdevice.h>
#include <qpoint.h>
#include <qsize.h>
#include <qvariant.h>
#include <qwidget.h>

#include <algorithm>
#include <cctype>
#include <cstring>
#include <iterator>
#include <set>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KMimeTypeChooserDialog_Type = nullptr;
static PyTypeObject *Sbk_KMimeTypeChooserDialog_TypeF(void)
{
    return _Sbk_KMimeTypeChooserDialog_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void KMimeTypeChooserDialogWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

KMimeTypeChooserDialogWrapper::KMimeTypeChooserDialogWrapper(const ::QString & title, const ::QString & text, const ::QStringList & selectedMimeTypes, const ::QString & defaultGroup, ::QWidget * parent) : KMimeTypeChooserDialog(title, text, selectedMimeTypes, defaultGroup, parent)
{
}

KMimeTypeChooserDialogWrapper::KMimeTypeChooserDialogWrapper(const ::QString & title, const ::QString & text, const ::QStringList & selectedMimeTypes, const ::QString & defaultGroup, const ::QStringList & groupsToShow, int visuals, ::QWidget * parent) : KMimeTypeChooserDialog(title, text, selectedMimeTypes, defaultGroup, groupsToShow, visuals, parent)
{
}

void KMimeTypeChooserDialogWrapper::accept()
{
    static const char *funcName = "accept";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMimeTypeChooserDialog_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QDialog::accept();
    }
    KTimeComboBoxWrapper::sbk_o_hidePopup("KMimeTypeChooserDialog", funcName, gil, pyOverride);
}

void KMimeTypeChooserDialogWrapper::actionEvent(::QActionEvent * event)
{
    static const char *funcName = "actionEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMimeTypeChooserDialog_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::actionEvent(event);
    }
    KXYSelectorWrapper::sbk_o_actionEvent("KMimeTypeChooserDialog", funcName, gil, pyOverride, event);
}

void KMimeTypeChooserDialogWrapper::changeEvent(::QEvent * event)
{
    static const char *funcName = "changeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMimeTypeChooserDialog_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::changeEvent(event);
    }
    KXYSelectorWrapper::sbk_o_changeEvent("KMimeTypeChooserDialog", funcName, gil, pyOverride, event);
}

void KMimeTypeChooserDialogWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMimeTypeChooserDialog_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    KXYSelectorWrapper::sbk_o_childEvent("KMimeTypeChooserDialog", funcName, gil, pyOverride, event);
}

void KMimeTypeChooserDialogWrapper::closeEvent(::QCloseEvent * arg__1)
{
    static const char *funcName = "closeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMimeTypeChooserDialog_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QDialog::closeEvent(arg__1);
    }
    KXYSelectorWrapper::sbk_o_closeEvent("KMimeTypeChooserDialog", funcName, gil, pyOverride, arg__1);
}

void KMimeTypeChooserDialogWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMimeTypeChooserDialog_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KMimeTypeChooserDialog", funcName, gil, pyOverride, signal);
}

void KMimeTypeChooserDialogWrapper::contextMenuEvent(::QContextMenuEvent * arg__1)
{
    static const char *funcName = "contextMenuEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMimeTypeChooserDialog_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QDialog::contextMenuEvent(arg__1);
    }
    KXYSelectorWrapper::sbk_o_contextMenuEvent("KMimeTypeChooserDialog", funcName, gil, pyOverride, arg__1);
}

void KMimeTypeChooserDialogWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMimeTypeChooserDialog_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    KXYSelectorWrapper::sbk_o_customEvent("KMimeTypeChooserDialog", funcName, gil, pyOverride, event);
}

int KMimeTypeChooserDialogWrapper::devType() const
{
    static const char *funcName = "devType";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMimeTypeChooserDialog_TypeF(), gil, funcName, m_PyMethodCache[8], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::devType();
    }
    return KXYSelectorWrapper::sbk_o_devType("KMimeTypeChooserDialog", funcName, gil, pyOverride);
}

void KMimeTypeChooserDialogWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMimeTypeChooserDialog_TypeF(), gil, funcName, m_PyMethodCache[9], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KMimeTypeChooserDialog", funcName, gil, pyOverride, signal);
}

void KMimeTypeChooserDialogWrapper::done(int arg__1)
{
    static const char *funcName = "done";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMimeTypeChooserDialog_TypeF(), gil, funcName, m_PyMethodCache[10], nameCache));
    if (pyOverride.isNull()) {
        return this->::QDialog::done(arg__1);
    }
    KPixmapRegionSelectorDialogWrapper::sbk_o_done("KMimeTypeChooserDialog", funcName, gil, pyOverride, arg__1);
}

void KMimeTypeChooserDialogWrapper::dragEnterEvent(::QDragEnterEvent * event)
{
    static const char *funcName = "dragEnterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMimeTypeChooserDialog_TypeF(), gil, funcName, m_PyMethodCache[11], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragEnterEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dragEnterEvent("KMimeTypeChooserDialog", funcName, gil, pyOverride, event);
}

void KMimeTypeChooserDialogWrapper::dragLeaveEvent(::QDragLeaveEvent * event)
{
    static const char *funcName = "dragLeaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMimeTypeChooserDialog_TypeF(), gil, funcName, m_PyMethodCache[12], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragLeaveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dragLeaveEvent("KMimeTypeChooserDialog", funcName, gil, pyOverride, event);
}

void KMimeTypeChooserDialogWrapper::dragMoveEvent(::QDragMoveEvent * event)
{
    static const char *funcName = "dragMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMimeTypeChooserDialog_TypeF(), gil, funcName, m_PyMethodCache[13], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragMoveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dragMoveEvent("KMimeTypeChooserDialog", funcName, gil, pyOverride, event);
}

void KMimeTypeChooserDialogWrapper::dropEvent(::QDropEvent * event)
{
    static const char *funcName = "dropEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMimeTypeChooserDialog_TypeF(), gil, funcName, m_PyMethodCache[14], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dropEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dropEvent("KMimeTypeChooserDialog", funcName, gil, pyOverride, event);
}

void KMimeTypeChooserDialogWrapper::enterEvent(::QEnterEvent * event)
{
    static const char *funcName = "enterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMimeTypeChooserDialog_TypeF(), gil, funcName, m_PyMethodCache[15], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::enterEvent(event);
    }
    KXYSelectorWrapper::sbk_o_enterEvent("KMimeTypeChooserDialog", funcName, gil, pyOverride, event);
}

bool KMimeTypeChooserDialogWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMimeTypeChooserDialog_TypeF(), gil, funcName, m_PyMethodCache[16], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::event(event);
    }
    return KXYSelectorWrapper::sbk_o_event("KMimeTypeChooserDialog", funcName, gil, pyOverride, event);
}

bool KMimeTypeChooserDialogWrapper::eventFilter(::QObject * arg__1, ::QEvent * arg__2)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMimeTypeChooserDialog_TypeF(), gil, funcName, m_PyMethodCache[17], nameCache));
    if (pyOverride.isNull()) {
        return this->::QDialog::eventFilter(arg__1, arg__2);
    }
    return KXYSelectorWrapper::sbk_o_eventFilter("KMimeTypeChooserDialog", funcName, gil, pyOverride, arg__1, arg__2);
}

int KMimeTypeChooserDialogWrapper::exec()
{
    static const char *funcName = "exec";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMimeTypeChooserDialog_TypeF(), gil, funcName, m_PyMethodCache[18], nameCache));
    if (pyOverride.isNull()) {
        return this->::QDialog::exec();
    }
    return KPixmapRegionSelectorDialogWrapper::sbk_o_exec("KMimeTypeChooserDialog", funcName, gil, pyOverride);
}

void KMimeTypeChooserDialogWrapper::focusInEvent(::QFocusEvent * event)
{
    static const char *funcName = "focusInEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMimeTypeChooserDialog_TypeF(), gil, funcName, m_PyMethodCache[19], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusInEvent(event);
    }
    KXYSelectorWrapper::sbk_o_focusInEvent("KMimeTypeChooserDialog", funcName, gil, pyOverride, event);
}

bool KMimeTypeChooserDialogWrapper::focusNextPrevChild(bool next)
{
    static const char *funcName = "focusNextPrevChild";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMimeTypeChooserDialog_TypeF(), gil, funcName, m_PyMethodCache[20], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusNextPrevChild(next);
    }
    return KXYSelectorWrapper::sbk_o_focusNextPrevChild("KMimeTypeChooserDialog", funcName, gil, pyOverride, next);
}

void KMimeTypeChooserDialogWrapper::focusOutEvent(::QFocusEvent * event)
{
    static const char *funcName = "focusOutEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMimeTypeChooserDialog_TypeF(), gil, funcName, m_PyMethodCache[21], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusOutEvent(event);
    }
    KXYSelectorWrapper::sbk_o_focusOutEvent("KMimeTypeChooserDialog", funcName, gil, pyOverride, event);
}

bool KMimeTypeChooserDialogWrapper::hasHeightForWidth() const
{
    static const char *funcName = "hasHeightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMimeTypeChooserDialog_TypeF(), gil, funcName, m_PyMethodCache[22], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hasHeightForWidth();
    }
    return KXYSelectorWrapper::sbk_o_hasHeightForWidth("KMimeTypeChooserDialog", funcName, gil, pyOverride);
}

int KMimeTypeChooserDialogWrapper::heightForWidth(int arg__1) const
{
    static const char *funcName = "heightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMimeTypeChooserDialog_TypeF(), gil, funcName, m_PyMethodCache[23], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::heightForWidth(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_heightForWidth("KMimeTypeChooserDialog", funcName, gil, pyOverride, arg__1);
}

void KMimeTypeChooserDialogWrapper::hideEvent(::QHideEvent * event)
{
    static const char *funcName = "hideEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMimeTypeChooserDialog_TypeF(), gil, funcName, m_PyMethodCache[24], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hideEvent(event);
    }
    KXYSelectorWrapper::sbk_o_hideEvent("KMimeTypeChooserDialog", funcName, gil, pyOverride, event);
}

void KMimeTypeChooserDialogWrapper::initPainter(::QPainter * painter) const
{
    static const char *funcName = "initPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMimeTypeChooserDialog_TypeF(), gil, funcName, m_PyMethodCache[25], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::initPainter(painter);
    }
    KXYSelectorWrapper::sbk_o_drawContents("KMimeTypeChooserDialog", funcName, gil, pyOverride, painter);
}

void KMimeTypeChooserDialogWrapper::inputMethodEvent(::QInputMethodEvent * event)
{
    static const char *funcName = "inputMethodEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMimeTypeChooserDialog_TypeF(), gil, funcName, m_PyMethodCache[26], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodEvent(event);
    }
    KXYSelectorWrapper::sbk_o_inputMethodEvent("KMimeTypeChooserDialog", funcName, gil, pyOverride, event);
}

::QVariant KMimeTypeChooserDialogWrapper::inputMethodQuery(::Qt::InputMethodQuery arg__1) const
{
    static const char *funcName = "inputMethodQuery";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMimeTypeChooserDialog_TypeF(), gil, funcName, m_PyMethodCache[27], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodQuery(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_inputMethodQuery("KMimeTypeChooserDialog", funcName, gil, pyOverride, arg__1);
}

void KMimeTypeChooserDialogWrapper::keyPressEvent(::QKeyEvent * arg__1)
{
    static const char *funcName = "keyPressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMimeTypeChooserDialog_TypeF(), gil, funcName, m_PyMethodCache[28], nameCache));
    if (pyOverride.isNull()) {
        return this->::QDialog::keyPressEvent(arg__1);
    }
    KXYSelectorWrapper::sbk_o_keyPressEvent("KMimeTypeChooserDialog", funcName, gil, pyOverride, arg__1);
}

void KMimeTypeChooserDialogWrapper::keyReleaseEvent(::QKeyEvent * event)
{
    static const char *funcName = "keyReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMimeTypeChooserDialog_TypeF(), gil, funcName, m_PyMethodCache[29], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::keyReleaseEvent(event);
    }
    KXYSelectorWrapper::sbk_o_keyReleaseEvent("KMimeTypeChooserDialog", funcName, gil, pyOverride, event);
}

void KMimeTypeChooserDialogWrapper::leaveEvent(::QEvent * event)
{
    static const char *funcName = "leaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMimeTypeChooserDialog_TypeF(), gil, funcName, m_PyMethodCache[30], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::leaveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_leaveEvent("KMimeTypeChooserDialog", funcName, gil, pyOverride, event);
}

int KMimeTypeChooserDialogWrapper::metric(::QPaintDevice::PaintDeviceMetric arg__1) const
{
    static const char *funcName = "metric";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMimeTypeChooserDialog_TypeF(), gil, funcName, m_PyMethodCache[31], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::metric(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_metric("KMimeTypeChooserDialog", funcName, gil, pyOverride, arg__1);
}

::QSize KMimeTypeChooserDialogWrapper::minimumSizeHint() const
{
    static const char *funcName = "minimumSizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMimeTypeChooserDialog_TypeF(), gil, funcName, m_PyMethodCache[32], nameCache));
    if (pyOverride.isNull()) {
        return this->::QDialog::minimumSizeHint();
    }
    return KXYSelectorWrapper::sbk_o_minimumSizeHint("KMimeTypeChooserDialog", funcName, gil, pyOverride);
}

void KMimeTypeChooserDialogWrapper::mouseDoubleClickEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseDoubleClickEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMimeTypeChooserDialog_TypeF(), gil, funcName, m_PyMethodCache[33], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseDoubleClickEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mouseDoubleClickEvent("KMimeTypeChooserDialog", funcName, gil, pyOverride, event);
}

void KMimeTypeChooserDialogWrapper::mouseMoveEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMimeTypeChooserDialog_TypeF(), gil, funcName, m_PyMethodCache[34], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseMoveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mouseMoveEvent("KMimeTypeChooserDialog", funcName, gil, pyOverride, event);
}

void KMimeTypeChooserDialogWrapper::mousePressEvent(::QMouseEvent * event)
{
    static const char *funcName = "mousePressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMimeTypeChooserDialog_TypeF(), gil, funcName, m_PyMethodCache[35], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mousePressEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mousePressEvent("KMimeTypeChooserDialog", funcName, gil, pyOverride, event);
}

void KMimeTypeChooserDialogWrapper::mouseReleaseEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMimeTypeChooserDialog_TypeF(), gil, funcName, m_PyMethodCache[36], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseReleaseEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mouseReleaseEvent("KMimeTypeChooserDialog", funcName, gil, pyOverride, event);
}

void KMimeTypeChooserDialogWrapper::moveEvent(::QMoveEvent * event)
{
    static const char *funcName = "moveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMimeTypeChooserDialog_TypeF(), gil, funcName, m_PyMethodCache[37], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::moveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_moveEvent("KMimeTypeChooserDialog", funcName, gil, pyOverride, event);
}

bool KMimeTypeChooserDialogWrapper::nativeEvent(const ::QByteArray & eventType, void * message, ::qintptr * result)
{
    static const char *funcName = "nativeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMimeTypeChooserDialog_TypeF(), gil, funcName, m_PyMethodCache[38], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::nativeEvent(eventType, message, result);
    }
    return KXYSelectorWrapper::sbk_o_nativeEvent("KMimeTypeChooserDialog", funcName, gil, pyOverride, eventType, message, result);
}

void KMimeTypeChooserDialogWrapper::open()
{
    static const char *funcName = "open";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMimeTypeChooserDialog_TypeF(), gil, funcName, m_PyMethodCache[39], nameCache));
    if (pyOverride.isNull()) {
        return this->::QDialog::open();
    }
    KTimeComboBoxWrapper::sbk_o_hidePopup("KMimeTypeChooserDialog", funcName, gil, pyOverride);
}

::QPaintEngine * KMimeTypeChooserDialogWrapper::paintEngine() const
{
    static const char *funcName = "paintEngine";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMimeTypeChooserDialog_TypeF(), gil, funcName, m_PyMethodCache[40], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::paintEngine();
    }
    return KXYSelectorWrapper::sbk_o_paintEngine("KMimeTypeChooserDialog", funcName, gil, pyOverride);
}

void KMimeTypeChooserDialogWrapper::paintEvent(::QPaintEvent * event)
{
    static const char *funcName = "paintEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMimeTypeChooserDialog_TypeF(), gil, funcName, m_PyMethodCache[41], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::paintEvent(event);
    }
    KXYSelectorWrapper::sbk_o_paintEvent("KMimeTypeChooserDialog", funcName, gil, pyOverride, event);
}

::QPaintDevice * KMimeTypeChooserDialogWrapper::redirected(::QPoint * offset) const
{
    static const char *funcName = "redirected";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMimeTypeChooserDialog_TypeF(), gil, funcName, m_PyMethodCache[42], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::redirected(offset);
    }
    return KXYSelectorWrapper::sbk_o_redirected("KMimeTypeChooserDialog", funcName, gil, pyOverride, offset);
}

void KMimeTypeChooserDialogWrapper::reject()
{
    static const char *funcName = "reject";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMimeTypeChooserDialog_TypeF(), gil, funcName, m_PyMethodCache[43], nameCache));
    if (pyOverride.isNull()) {
        return this->::QDialog::reject();
    }
    KTimeComboBoxWrapper::sbk_o_hidePopup("KMimeTypeChooserDialog", funcName, gil, pyOverride);
}

void KMimeTypeChooserDialogWrapper::resizeEvent(::QResizeEvent * arg__1)
{
    static const char *funcName = "resizeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMimeTypeChooserDialog_TypeF(), gil, funcName, m_PyMethodCache[44], nameCache));
    if (pyOverride.isNull()) {
        return this->::QDialog::resizeEvent(arg__1);
    }
    KXYSelectorWrapper::sbk_o_resizeEvent("KMimeTypeChooserDialog", funcName, gil, pyOverride, arg__1);
}

void KMimeTypeChooserDialogWrapper::setVisible(bool visible)
{
    static const char *funcName = "setVisible";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMimeTypeChooserDialog_TypeF(), gil, funcName, m_PyMethodCache[45], nameCache));
    if (pyOverride.isNull()) {
        return this->::QDialog::setVisible(visible);
    }
    KXYSelectorWrapper::sbk_o_setVisible("KMimeTypeChooserDialog", funcName, gil, pyOverride, visible);
}

::QPainter * KMimeTypeChooserDialogWrapper::sharedPainter() const
{
    static const char *funcName = "sharedPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMimeTypeChooserDialog_TypeF(), gil, funcName, m_PyMethodCache[46], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::sharedPainter();
    }
    return KXYSelectorWrapper::sbk_o_sharedPainter("KMimeTypeChooserDialog", funcName, gil, pyOverride);
}

void KMimeTypeChooserDialogWrapper::showEvent(::QShowEvent * arg__1)
{
    static const char *funcName = "showEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMimeTypeChooserDialog_TypeF(), gil, funcName, m_PyMethodCache[47], nameCache));
    if (pyOverride.isNull()) {
        return this->::QDialog::showEvent(arg__1);
    }
    KXYSelectorWrapper::sbk_o_showEvent("KMimeTypeChooserDialog", funcName, gil, pyOverride, arg__1);
}

::QSize KMimeTypeChooserDialogWrapper::sizeHint() const
{
    static const char *funcName = "sizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMimeTypeChooserDialog_TypeF(), gil, funcName, m_PyMethodCache[48], nameCache));
    if (pyOverride.isNull()) {
        return this->::KMimeTypeChooserDialog::sizeHint();
    }
    return KXYSelectorWrapper::sbk_o_minimumSizeHint("KMimeTypeChooserDialog", funcName, gil, pyOverride);
}

void KMimeTypeChooserDialogWrapper::tabletEvent(::QTabletEvent * event)
{
    static const char *funcName = "tabletEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMimeTypeChooserDialog_TypeF(), gil, funcName, m_PyMethodCache[49], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::tabletEvent(event);
    }
    KXYSelectorWrapper::sbk_o_tabletEvent("KMimeTypeChooserDialog", funcName, gil, pyOverride, event);
}

void KMimeTypeChooserDialogWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMimeTypeChooserDialog_TypeF(), gil, funcName, m_PyMethodCache[50], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    KXYSelectorWrapper::sbk_o_timerEvent("KMimeTypeChooserDialog", funcName, gil, pyOverride, event);
}

void KMimeTypeChooserDialogWrapper::wheelEvent(::QWheelEvent * event)
{
    static const char *funcName = "wheelEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMimeTypeChooserDialog_TypeF(), gil, funcName, m_PyMethodCache[51], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::wheelEvent(event);
    }
    KXYSelectorWrapper::sbk_o_wheelEvent("KMimeTypeChooserDialog", funcName, gil, pyOverride, event);
}

const QMetaObject *KMimeTypeChooserDialogWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return KMimeTypeChooserDialog::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int KMimeTypeChooserDialogWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = KMimeTypeChooserDialog::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *KMimeTypeChooserDialogWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< KMimeTypeChooserDialogWrapper *>(this));
    }
    return KMimeTypeChooserDialog::qt_metacast(_clname);
}

KMimeTypeChooserDialogWrapper::~KMimeTypeChooserDialogWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_KMimeTypeChooserDialog_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KMimeTypeChooserDialog_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KMimeTypeChooserDialog >()))
        return -1;

    KMimeTypeChooserDialogWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[7];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|OOOOOOO:KMimeTypeChooserDialog", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KMimeTypeChooserDialog::KMimeTypeChooserDialog(QString,QString,QStringList,QString,QWidget*=)
    // 1: KMimeTypeChooserDialog::KMimeTypeChooserDialog(const QString&=,const QString&=,const QStringList&=,const QString&=,const QStringList&=,int=,QWidget*=)
    if (numArgs == 0) {
        overloadId = 1; // KMimeTypeChooserDialog(QString,QString,QStringList,QString,QStringList,int,QWidget*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // KMimeTypeChooserDialog(QString,QString,QStringList,QString,QStringList,int,QWidget*)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 1; // KMimeTypeChooserDialog(QString,QString,QStringList,QString,QStringList,int,QWidget*)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 1; // KMimeTypeChooserDialog(QString,QString,QStringList,QString,QStringList,int,QWidget*)
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[3])))) {
                    if (numArgs == 4) {
                        overloadId = 1; // KMimeTypeChooserDialog(QString,QString,QStringList,QString,QStringList,int,QWidget*)
                    } else if (numArgs >= 5
                        && (pythonToCpp[4] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], (pyArgs[4])))) {
                        if (numArgs == 5) {
                            overloadId = 1; // KMimeTypeChooserDialog(QString,QString,QStringList,QString,QStringList,int,QWidget*)
                        } else if (numArgs >= 6
                            && (pythonToCpp[5] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[5])))) {
                            if (numArgs == 6) {
                                overloadId = 1; // KMimeTypeChooserDialog(QString,QString,QStringList,QString,QStringList,int,QWidget*)
                            } else if (numArgs >= 7
                                && (pythonToCpp[6] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[6])))) {
                                overloadId = 1; // KMimeTypeChooserDialog(QString,QString,QStringList,QString,QStringList,int,QWidget*)
                            }
                        }
                    } else if (numArgs >= 5
                        && (pythonToCpp[4] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[4])))) {
                        overloadId = 0; // KMimeTypeChooserDialog(QString,QString,QStringList,QString,QWidget*)
                    }
                }
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KMimeTypeChooserDialog_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkKWidgetsAddonsTypeStructs[SBK_KMimeTypeChooserDialog_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    switch (overloadId) {
        case 0: // KMimeTypeChooserDialog(const QString &title, const QString &text, const QStringList &selectedMimeTypes, const QString &defaultGroup, QWidget *parent)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 4}};
                if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                    || (pyArgs[4] != nullptr && !(pythonToCpp[4] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[4]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KMimeTypeChooserDialog_IDX]);
                }
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QStringList cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            ::QString cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);
            if (!Shiboken::Object::isValid(pyArgs[4]))
                return -1;
            ::QWidget *cppArg4 = nullptr;
            if (pythonToCpp[4])
                pythonToCpp[4](pyArgs[4], &cppArg4);

            if (Shiboken::Errors::occurred() == nullptr) {
                // KMimeTypeChooserDialog(QString,QString,QStringList,QString,QWidget*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr != nullptr) {
                    cptr = new (addr) KMimeTypeChooserDialogWrapper(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
                    PySide::setNextQObjectMemoryAddr(nullptr);
                } else {
                    cptr = new KMimeTypeChooserDialogWrapper(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
                }

            }
            break;
        }
        case 1: // KMimeTypeChooserDialog(const QString &title, const QString &text, const QStringList &selectedMimeTypes, const QString &defaultGroup, const QStringList &groupsToShow, int visuals, QWidget *parent)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[7] = {{"title", 0}, {"text", 1}, {"selectedMimeTypes", 2}, {"defaultGroup", 3}, {"groupsToShow", 4}, {"visuals", 5}, {"parent", 6}};
                if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 7, errInfo, pyArgs)
                    || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0]))))
                    || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1]))))
                    || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], (pyArgs[2]))))
                    || (pyArgs[3] != nullptr && !(pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[3]))))
                    || (pyArgs[4] != nullptr && !(pythonToCpp[4] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], (pyArgs[4]))))
                    || (pyArgs[5] != nullptr && !(pythonToCpp[5] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[5]))))
                    || (pyArgs[6] != nullptr && !(pythonToCpp[6] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[6]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KMimeTypeChooserDialog_IDX]);
                }
            }
            ::QString cppArg0 = QString();
            if (pythonToCpp[0])
                pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1 = QString();
            if (pythonToCpp[1])
                pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QStringList cppArg2 = QStringList();
            if (pythonToCpp[2])
                pythonToCpp[2](pyArgs[2], &cppArg2);
            ::QString cppArg3 = QString();
            if (pythonToCpp[3])
                pythonToCpp[3](pyArgs[3], &cppArg3);
            ::QStringList cppArg4 = QStringList();
            if (pythonToCpp[4])
                pythonToCpp[4](pyArgs[4], &cppArg4);
            int cppArg5 = KMimeTypeChooser::Comments | KMimeTypeChooser::Patterns | KMimeTypeChooser::EditButton;
            if (pythonToCpp[5])
                pythonToCpp[5](pyArgs[5], &cppArg5);
            if (!Shiboken::Object::isValid(pyArgs[6]))
                return -1;
            ::QWidget *cppArg6 = nullptr;
            if (pythonToCpp[6])
                pythonToCpp[6](pyArgs[6], &cppArg6);

            if (Shiboken::Errors::occurred() == nullptr) {
                // KMimeTypeChooserDialog(QString,QString,QStringList,QString,QStringList,int,QWidget*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr != nullptr) {
                    cptr = new (addr) KMimeTypeChooserDialogWrapper(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6);
                    PySide::setNextQObjectMemoryAddr(nullptr);
                } else {
                    cptr = new KMimeTypeChooserDialogWrapper(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6);
                }

            }
            break;
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< KMimeTypeChooserDialog >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KMimeTypeChooserDialog_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KMimeTypeChooserDialog_IDX]);
    };


    return 1;
}

static PyObject *Sbk_KMimeTypeChooserDialogFunc_chooser(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KMimeTypeChooserDialog *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMimeTypeChooserDialog_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // chooser()
        KMimeTypeChooser * cppResult = cppSelf->chooser();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMimeTypeChooser_IDX]), cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KMimeTypeChooserDialogFunc_sizeHint(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KMimeTypeChooserDialog *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMimeTypeChooserDialog_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // sizeHint()const
        QSize cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
            ? const_cast<const ::KMimeTypeChooserDialog *>(cppSelf)->::KMimeTypeChooserDialog::sizeHint()
            : const_cast<const ::KMimeTypeChooserDialog *>(cppSelf)->sizeHint();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QSize_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_KMimeTypeChooserDialog_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_KMimeTypeChooserDialog_methods[] = {
    {"chooser", reinterpret_cast<PyCFunction>(Sbk_KMimeTypeChooserDialogFunc_chooser), METH_NOARGS, nullptr},
    {"sizeHint", reinterpret_cast<PyCFunction>(Sbk_KMimeTypeChooserDialogFunc_sizeHint), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_KMimeTypeChooserDialog_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::KMimeTypeChooserDialog *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMimeTypeChooserDialog_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<KMimeTypeChooserDialogWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_KMimeTypeChooserDialog_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KMimeTypeChooserDialog_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}
static void * Sbk_KMimeTypeChooserDialogSpecialCastFunction(void *obj, PyTypeObject *desiredType)
{
    auto me = reinterpret_cast< ::KMimeTypeChooserDialog *>(obj);
    if (desiredType == Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QDialog_IDX]))
        return static_cast< ::QDialog *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]))
        return static_cast< ::QWidget *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))
        return static_cast< ::QObject *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPaintDevice_IDX]))
        return static_cast< ::QPaintDevice *>(me);
    return me;
}



// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KMimeTypeChooserDialog_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_KMimeTypeChooserDialog_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KMimeTypeChooserDialog_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KMimeTypeChooserDialog_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KMimeTypeChooserDialog_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KMimeTypeChooserDialog_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KMimeTypeChooserDialog_spec = {
    "1:KWidgetsAddons.KMimeTypeChooserDialog",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KMimeTypeChooserDialog_slots
};

} //extern "C"

static void *Sbk_KMimeTypeChooserDialog_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QWidget >())
        return dynamic_cast< ::KMimeTypeChooserDialog *>(reinterpret_cast< ::QWidget *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::KMimeTypeChooserDialog *>(reinterpret_cast< ::QObject *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QPaintDevice >())
        return dynamic_cast< ::KMimeTypeChooserDialog *>(reinterpret_cast< ::QPaintDevice *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KMimeTypeChooserDialog_PythonToCpp_KMimeTypeChooserDialog_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KMimeTypeChooserDialog_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KMimeTypeChooserDialog_PythonToCpp_KMimeTypeChooserDialog_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KMimeTypeChooserDialog_TypeF()))
        return KMimeTypeChooserDialog_PythonToCpp_KMimeTypeChooserDialog_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KMimeTypeChooserDialog_PTR_CppToPython_KMimeTypeChooserDialog(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::KMimeTypeChooserDialog *>(const_cast<void *>(cppIn)), Sbk_KMimeTypeChooserDialog_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KMimeTypeChooserDialog_SignatureStrings[] = {
    "1:KWidgetsAddons.KMimeTypeChooserDialog(self,title:QString,text:QString,selectedMimeTypes:QStringList,defaultGroup:QString,parent:PySide6.QtWidgets.QWidget=nullptr)",
    "0:KWidgetsAddons.KMimeTypeChooserDialog(self,title:QString=QString(),text:QString=QString(),selectedMimeTypes:QStringList=QStringList(),defaultGroup:QString=QString(),groupsToShow:QStringList=QStringList(),visuals:int=KMimeTypeChooser.Comments | KMimeTypeChooser.Patterns | KMimeTypeChooser.EditButton,parent:PySide6.QtWidgets.QWidget=nullptr)",
    "KWidgetsAddons.KMimeTypeChooserDialog.chooser(self)->KWidgetsAddons.KMimeTypeChooser",
    "KWidgetsAddons.KMimeTypeChooserDialog.sizeHint(self)->PySide6.QtCore.QSize",
    nullptr}; // Sentinel
#else
static constexpr size_t KMimeTypeChooserDialog_SignatureByteSize = 244;
static constexpr uint8_t KMimeTypeChooserDialog_SignatureBytes[244] = {
    0x78, 0xda, 0x9d, 0x50, 0x4d, 0x4b, 0xc3, 0x40, 0x10, 0xbd, 0xf7, 0x57, 0xf4, 0xd8, 0x40, 0x5c,
    0xea, 0xc5, 0x43, 0x20, 0x82, 0xc6, 0xa2, 0x50, 0x85, 0x86, 0x14, 0x3c, 0x2f, 0xdd, 0x69, 0x3a,
    0xb0, 0xd9, 0x09, 0x3b, 0xb3, 0x6a, 0xc5, 0x1f, 0xef, 0x6a, 0x9b, 0x1a, 0x6d, 0xa9, 0xd5, 0xd3,
    0x7c, 0xbc, 0x79, 0x8f, 0x37, 0xef, 0x3c, 0x9b, 0x3e, 0xa2, 0xa9, 0x41, 0xf8, 0xca, 0x18, 0x72,
    0xac, 0xa6, 0x0f, 0xd8, 0xc0, 0x7c, 0xdd, 0x42, 0xb1, 0x22, 0x62, 0xf0, 0x37, 0xa8, 0x2d, 0xd5,
    0x23, 0x06, 0xbb, 0x4c, 0x05, 0xc5, 0x42, 0x56, 0x56, 0xe2, 0xd1, 0xd5, 0xa9, 0xc0, 0x8b, 0xec,
    0x86, 0x88, 0xc3, 0x42, 0xc0, 0x74, 0x6c, 0xee, 0x90, 0x7b, 0x64, 0x49, 0x0d, 0x2c, 0x75, 0xb0,
    0x72, 0xeb, 0x29, 0xb4, 0x3b, 0x4a, 0xab, 0x3d, 0x38, 0xc9, 0x66, 0xeb, 0x0a, 0x0d, 0x5c, 0xa8,
    0x52, 0xb6, 0x46, 0x54, 0xb9, 0x69, 0x72, 0x17, 0xac, 0x6d, 0xc5, 0x27, 0x83, 0xf1, 0xbf, 0x4d,
    0xe6, 0xdb, 0x3a, 0x4a, 0xbe, 0xd9, 0xed, 0xad, 0x8f, 0x1a, 0xcf, 0x7b, 0x7d, 0xbc, 0x3d, 0xf4,
    0x46, 0x4f, 0xaa, 0xfe, 0xd8, 0xf3, 0x9c, 0xaa, 0x15, 0x3d, 0x1f, 0x51, 0x79, 0x42, 0x0e, 0xda,
    0x72, 0x86, 0x4e, 0xf2, 0x9f, 0x8f, 0xa8, 0x82, 0x9a, 0x26, 0xa6, 0xc2, 0xc3, 0xb7, 0xe1, 0x1e,
    0x36, 0xd3, 0x22, 0xe0, 0xdd, 0x41, 0x6c, 0x62, 0x50, 0xae, 0x83, 0x08, 0xb9, 0x3f, 0xe4, 0x7a,
    0x52, 0xaa, 0x6a, 0xb1, 0x99, 0x3e, 0xd3, 0x4d, 0xce, 0x2e, 0x7f, 0x21, 0x9d, 0x28, 0xca, 0xf8,
    0x0a, 0x77, 0x31, 0x81, 0x4e, 0xf5, 0xcb, 0x6d, 0x41, 0x1e, 0x54, 0x59, 0x45, 0x7c, 0xf0, 0x0e,
    0x25, 0x04, 0xf9, 0x8c
};
#endif

PyTypeObject *init_KMimeTypeChooserDialog(PyObject *module)
{
    if (SbkKWidgetsAddonsTypeStructs[SBK_KMimeTypeChooserDialog_IDX].type != nullptr)
        return SbkKWidgetsAddonsTypeStructs[SBK_KMimeTypeChooserDialog_IDX].type;

    Shiboken::AutoDecRef Sbk_KMimeTypeChooserDialog_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QDialog_IDX]))));

    _Sbk_KMimeTypeChooserDialog_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KMimeTypeChooserDialog",
        "KMimeTypeChooserDialog*",
        &Sbk_KMimeTypeChooserDialog_spec,
        &Shiboken::callCppDestructor< KMimeTypeChooserDialog >,
        Sbk_KMimeTypeChooserDialog_Type_bases.object(),
        Shiboken::ObjectType::WrapperFlags::DeleteInMainThread);
    auto *pyType = Sbk_KMimeTypeChooserDialog_TypeF(); // references _Sbk_KMimeTypeChooserDialog_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KMimeTypeChooserDialog_SignatureStrings);
#else
    InitSignatureBytes(pyType, KMimeTypeChooserDialog_SignatureBytes, KMimeTypeChooserDialog_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KMimeTypeChooserDialog_PropertyStrings);
    SbkKWidgetsAddonsTypeStructs[SBK_KMimeTypeChooserDialog_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KMimeTypeChooserDialog_PythonToCpp_KMimeTypeChooserDialog_PTR,
        is_KMimeTypeChooserDialog_PythonToCpp_KMimeTypeChooserDialog_PTR_Convertible,
        KMimeTypeChooserDialog_PTR_CppToPython_KMimeTypeChooserDialog);

    Shiboken::Conversions::registerConverterName(converter, "KMimeTypeChooserDialog");
    Shiboken::Conversions::registerConverterName(converter, "KMimeTypeChooserDialog*");
    Shiboken::Conversions::registerConverterName(converter, "KMimeTypeChooserDialog&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KMimeTypeChooserDialog).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(KMimeTypeChooserDialogWrapper).name());

    MultipleInheritanceInitFunction func = Shiboken::ObjectType::getMultipleInheritanceFunction(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]));
    Shiboken::ObjectType::setMultipleInheritanceFunction(Sbk_KMimeTypeChooserDialog_TypeF(), func);
    Shiboken::ObjectType::setCastFunction(Sbk_KMimeTypeChooserDialog_TypeF(), &Sbk_KMimeTypeChooserDialogSpecialCastFunction);
    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_KMimeTypeChooserDialog_TypeF(), &Sbk_KMimeTypeChooserDialog_typeDiscovery);

    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::KMimeTypeChooserDialog::staticMetaObject, sizeof(KMimeTypeChooserDialogWrapper));

    return pyType;
}
