/* SPDX-FileCopyrightText: 2010 - Ignacio Casal Quinteiro
 * SPDX-FileCopyrightText: 2014 - Sébastien Wilmet <swilmet@gnome.org>
 * SPDX-License-Identifier: LGPL-2.1-or-later
 */

#pragma once

#include <gtk/gtk.h>
#include "gtksourcefile.h"
#include "gtksourceinternal.h"

G_BEGIN_DECLS

#define GTK_SOURCE_TYPE_BUFFER_INPUT_STREAM		(_gtk_source_buffer_input_stream_get_type ())
#define GTK_SOURCE_BUFFER_INPUT_STREAM(obj)		(G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_SOURCE_TYPE_BUFFER_INPUT_STREAM, GtkSourceBufferInputStream))
#define GTK_SOURCE_BUFFER_INPUT_STREAM_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST ((klass), GTK_SOURCE_TYPE_BUFFER_INPUT_STREAM, GtkSourceBufferInputStreamClass))
#define GTK_SOURCE_IS_BUFFER_INPUT_STREAM(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_SOURCE_TYPE_BUFFER_INPUT_STREAM))
#define GTK_SOURCE_IS_BUFFER_INPUT_STREAM_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_SOURCE_TYPE_BUFFER_INPUT_STREAM))
#define GTK_SOURCE_BUFFER_INPUT_STREAM_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_SOURCE_TYPE_BUFFER_INPUT_STREAM, GtkSourceBufferInputStreamClass))

typedef struct _GtkSourceBufferInputStream        GtkSourceBufferInputStream;
typedef struct _GtkSourceBufferInputStreamClass   GtkSourceBufferInputStreamClass;
typedef struct _GtkSourceBufferInputStreamPrivate GtkSourceBufferInputStreamPrivate;

struct _GtkSourceBufferInputStream
{
	GInputStream parent;

	GtkSourceBufferInputStreamPrivate *priv;
};

struct _GtkSourceBufferInputStreamClass
{
	GInputStreamClass parent_class;
};

GTK_SOURCE_INTERNAL
GType		 _gtk_source_buffer_input_stream_get_type		(void) G_GNUC_CONST;

GTK_SOURCE_INTERNAL
GtkSourceBufferInputStream
		*_gtk_source_buffer_input_stream_new			(GtkTextBuffer              *buffer,
									 GtkSourceNewlineType        type,
									 gboolean                    add_trailing_newline);

GTK_SOURCE_INTERNAL
gsize		 _gtk_source_buffer_input_stream_get_total_size		(GtkSourceBufferInputStream *stream);

GTK_SOURCE_INTERNAL
gsize		 _gtk_source_buffer_input_stream_tell			(GtkSourceBufferInputStream *stream);

G_END_DECLS
