#ifndef INCLUDED_OFFICECFG_OFFICE_DRAW_HXX
#define INCLUDED_OFFICECFG_OFFICE_DRAW_HXX

#include "sal/config.h"

#include "rtl/ustring.h"
#include "rtl/ustring.hxx"
#include "sal/types.h"
#include "comphelper/configuration.hxx"

namespace officecfg { namespace Office { namespace Draw {

struct Layout: public comphelper::ConfigurationGroup< Layout> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Draw/Layout"_ustr); return PATH; }

struct Display: public comphelper::ConfigurationGroup< Display> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Draw/Layout/Display"_ustr); return PATH; }

struct Ruler: public comphelper::ConfigurationProperty<Ruler, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Draw/Layout/Display/Ruler"_ustr); return PATH; }
private:
    Ruler(); // not defined
    ~Ruler(); // not defined
};

struct Helpline: public comphelper::ConfigurationProperty<Helpline, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Draw/Layout/Display/Helpline"_ustr); return PATH; }
private:
    Helpline(); // not defined
    ~Helpline(); // not defined
};

struct Guide: public comphelper::ConfigurationProperty<Guide, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Draw/Layout/Display/Guide"_ustr); return PATH; }
private:
    Guide(); // not defined
    ~Guide(); // not defined
};

struct Bezier: public comphelper::ConfigurationProperty<Bezier, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Draw/Layout/Display/Bezier"_ustr); return PATH; }
private:
    Bezier(); // not defined
    ~Bezier(); // not defined
};

struct Contour: public comphelper::ConfigurationProperty<Contour, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Draw/Layout/Display/Contour"_ustr); return PATH; }
private:
    Contour(); // not defined
    ~Contour(); // not defined
};

private:
    Display(); // not defined
    ~Display(); // not defined
};

struct Other: public comphelper::ConfigurationGroup< Other> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Draw/Layout/Other"_ustr); return PATH; }

struct TabStop: public comphelper::ConfigurationGroup< TabStop> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Draw/Layout/Other/TabStop"_ustr); return PATH; }

struct Metric: public comphelper::ConfigurationProperty<Metric, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Draw/Layout/Other/TabStop/Metric"_ustr); return PATH; }
private:
    Metric(); // not defined
    ~Metric(); // not defined
};

struct NonMetric: public comphelper::ConfigurationProperty<NonMetric, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Draw/Layout/Other/TabStop/NonMetric"_ustr); return PATH; }
private:
    NonMetric(); // not defined
    ~NonMetric(); // not defined
};

private:
    TabStop(); // not defined
    ~TabStop(); // not defined
};

struct MeasureUnit: public comphelper::ConfigurationGroup< MeasureUnit> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Draw/Layout/Other/MeasureUnit"_ustr); return PATH; }

struct Metric: public comphelper::ConfigurationProperty<Metric, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Draw/Layout/Other/MeasureUnit/Metric"_ustr); return PATH; }
private:
    Metric(); // not defined
    ~Metric(); // not defined
};

struct NonMetric: public comphelper::ConfigurationProperty<NonMetric, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Draw/Layout/Other/MeasureUnit/NonMetric"_ustr); return PATH; }
private:
    NonMetric(); // not defined
    ~NonMetric(); // not defined
};

private:
    MeasureUnit(); // not defined
    ~MeasureUnit(); // not defined
};

private:
    Other(); // not defined
    ~Other(); // not defined
};

private:
    Layout(); // not defined
    ~Layout(); // not defined
};

struct Content: public comphelper::ConfigurationGroup< Content> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Draw/Content"_ustr); return PATH; }

struct Display: public comphelper::ConfigurationGroup< Display> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Draw/Content/Display"_ustr); return PATH; }

private:
    Display(); // not defined
    ~Display(); // not defined
};

private:
    Content(); // not defined
    ~Content(); // not defined
};

struct Misc: public comphelper::ConfigurationGroup< Misc> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Draw/Misc"_ustr); return PATH; }

struct BackgroundCache: public comphelper::ConfigurationProperty<BackgroundCache, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Draw/Misc/BackgroundCache"_ustr); return PATH; }
private:
    BackgroundCache(); // not defined
    ~BackgroundCache(); // not defined
};

struct CopyWhileMoving: public comphelper::ConfigurationProperty<CopyWhileMoving, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Draw/Misc/CopyWhileMoving"_ustr); return PATH; }
private:
    CopyWhileMoving(); // not defined
    ~CopyWhileMoving(); // not defined
};

struct ObjectMoveable: public comphelper::ConfigurationProperty<ObjectMoveable, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Draw/Misc/ObjectMoveable"_ustr); return PATH; }
private:
    ObjectMoveable(); // not defined
    ~ObjectMoveable(); // not defined
};

struct NoDistort: public comphelper::ConfigurationProperty<NoDistort, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Draw/Misc/NoDistort"_ustr); return PATH; }
private:
    NoDistort(); // not defined
    ~NoDistort(); // not defined
};

struct DclickTextedit: public comphelper::ConfigurationProperty<DclickTextedit, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Draw/Misc/DclickTextedit"_ustr); return PATH; }
private:
    DclickTextedit(); // not defined
    ~DclickTextedit(); // not defined
};

struct RotateClick: public comphelper::ConfigurationProperty<RotateClick, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Draw/Misc/RotateClick"_ustr); return PATH; }
private:
    RotateClick(); // not defined
    ~RotateClick(); // not defined
};

struct Preview: public comphelper::ConfigurationProperty<Preview, double> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Draw/Misc/Preview"_ustr); return PATH; }
private:
    Preview(); // not defined
    ~Preview(); // not defined
};

struct ShowComments: public comphelper::ConfigurationProperty<ShowComments, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Draw/Misc/ShowComments"_ustr); return PATH; }
private:
    ShowComments(); // not defined
    ~ShowComments(); // not defined
};

struct ModifyWithAttributes: public comphelper::ConfigurationProperty<ModifyWithAttributes, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Draw/Misc/ModifyWithAttributes"_ustr); return PATH; }
private:
    ModifyWithAttributes(); // not defined
    ~ModifyWithAttributes(); // not defined
};

struct DragThresholdPixels: public comphelper::ConfigurationProperty<DragThresholdPixels, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Draw/Misc/DragThresholdPixels"_ustr); return PATH; }
private:
    DragThresholdPixels(); // not defined
    ~DragThresholdPixels(); // not defined
};

struct TextObject: public comphelper::ConfigurationGroup< TextObject> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Draw/Misc/TextObject"_ustr); return PATH; }

struct QuickEditing: public comphelper::ConfigurationProperty<QuickEditing, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Draw/Misc/TextObject/QuickEditing"_ustr); return PATH; }
private:
    QuickEditing(); // not defined
    ~QuickEditing(); // not defined
};

struct Selectable: public comphelper::ConfigurationProperty<Selectable, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Draw/Misc/TextObject/Selectable"_ustr); return PATH; }
private:
    Selectable(); // not defined
    ~Selectable(); // not defined
};

struct ShowBoundary: public comphelper::ConfigurationProperty<ShowBoundary, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Draw/Misc/TextObject/ShowBoundary"_ustr); return PATH; }
private:
    ShowBoundary(); // not defined
    ~ShowBoundary(); // not defined
};

private:
    TextObject(); // not defined
    ~TextObject(); // not defined
};

struct CrossFading: public comphelper::ConfigurationGroup< CrossFading> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Draw/Misc/CrossFading"_ustr); return PATH; }

struct Steps: public comphelper::ConfigurationProperty<Steps, sal_Int16> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Draw/Misc/CrossFading/Steps"_ustr); return PATH; }
private:
    Steps(); // not defined
    ~Steps(); // not defined
};

struct Orientation: public comphelper::ConfigurationProperty<Orientation, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Draw/Misc/CrossFading/Orientation"_ustr); return PATH; }
private:
    Orientation(); // not defined
    ~Orientation(); // not defined
};

struct Attributes: public comphelper::ConfigurationProperty<Attributes, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Draw/Misc/CrossFading/Attributes"_ustr); return PATH; }
private:
    Attributes(); // not defined
    ~Attributes(); // not defined
};

private:
    CrossFading(); // not defined
    ~CrossFading(); // not defined
};

struct DefaultObjectSize: public comphelper::ConfigurationGroup< DefaultObjectSize> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Draw/Misc/DefaultObjectSize"_ustr); return PATH; }

struct Width: public comphelper::ConfigurationProperty<Width, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Draw/Misc/DefaultObjectSize/Width"_ustr); return PATH; }
private:
    Width(); // not defined
    ~Width(); // not defined
};

struct Height: public comphelper::ConfigurationProperty<Height, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Draw/Misc/DefaultObjectSize/Height"_ustr); return PATH; }
private:
    Height(); // not defined
    ~Height(); // not defined
};

private:
    DefaultObjectSize(); // not defined
    ~DefaultObjectSize(); // not defined
};

struct Compatibility: public comphelper::ConfigurationGroup< Compatibility> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Draw/Misc/Compatibility"_ustr); return PATH; }

struct PrinterIndependentLayout: public comphelper::ConfigurationProperty<PrinterIndependentLayout, sal_Int16> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Draw/Misc/Compatibility/PrinterIndependentLayout"_ustr); return PATH; }
private:
    PrinterIndependentLayout(); // not defined
    ~PrinterIndependentLayout(); // not defined
};

private:
    Compatibility(); // not defined
    ~Compatibility(); // not defined
};

struct DisableLayerHighlighting: public comphelper::ConfigurationProperty<DisableLayerHighlighting, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Draw/Misc/DisableLayerHighlighting"_ustr); return PATH; }
private:
    DisableLayerHighlighting(); // not defined
    ~DisableLayerHighlighting(); // not defined
};

private:
    Misc(); // not defined
    ~Misc(); // not defined
};

struct Snap: public comphelper::ConfigurationGroup< Snap> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Draw/Snap"_ustr); return PATH; }

struct Object: public comphelper::ConfigurationGroup< Object> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Draw/Snap/Object"_ustr); return PATH; }

struct Grid: public comphelper::ConfigurationProperty<Grid, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Draw/Snap/Object/Grid"_ustr); return PATH; }
private:
    Grid(); // not defined
    ~Grid(); // not defined
};

struct SnapLine: public comphelper::ConfigurationProperty<SnapLine, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Draw/Snap/Object/SnapLine"_ustr); return PATH; }
private:
    SnapLine(); // not defined
    ~SnapLine(); // not defined
};

struct PageMargin: public comphelper::ConfigurationProperty<PageMargin, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Draw/Snap/Object/PageMargin"_ustr); return PATH; }
private:
    PageMargin(); // not defined
    ~PageMargin(); // not defined
};

struct ObjectFrame: public comphelper::ConfigurationProperty<ObjectFrame, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Draw/Snap/Object/ObjectFrame"_ustr); return PATH; }
private:
    ObjectFrame(); // not defined
    ~ObjectFrame(); // not defined
};

struct ObjectPoint: public comphelper::ConfigurationProperty<ObjectPoint, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Draw/Snap/Object/ObjectPoint"_ustr); return PATH; }
private:
    ObjectPoint(); // not defined
    ~ObjectPoint(); // not defined
};

struct Range: public comphelper::ConfigurationProperty<Range, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Draw/Snap/Object/Range"_ustr); return PATH; }
private:
    Range(); // not defined
    ~Range(); // not defined
};

private:
    Object(); // not defined
    ~Object(); // not defined
};

struct Position: public comphelper::ConfigurationGroup< Position> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Draw/Snap/Position"_ustr); return PATH; }

struct CreatingMoving: public comphelper::ConfigurationProperty<CreatingMoving, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Draw/Snap/Position/CreatingMoving"_ustr); return PATH; }
private:
    CreatingMoving(); // not defined
    ~CreatingMoving(); // not defined
};

struct ExtendEdges: public comphelper::ConfigurationProperty<ExtendEdges, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Draw/Snap/Position/ExtendEdges"_ustr); return PATH; }
private:
    ExtendEdges(); // not defined
    ~ExtendEdges(); // not defined
};

struct Rotating: public comphelper::ConfigurationProperty<Rotating, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Draw/Snap/Position/Rotating"_ustr); return PATH; }
private:
    Rotating(); // not defined
    ~Rotating(); // not defined
};

struct RotatingValue: public comphelper::ConfigurationProperty<RotatingValue, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Draw/Snap/Position/RotatingValue"_ustr); return PATH; }
private:
    RotatingValue(); // not defined
    ~RotatingValue(); // not defined
};

struct PointReduction: public comphelper::ConfigurationProperty<PointReduction, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Draw/Snap/Position/PointReduction"_ustr); return PATH; }
private:
    PointReduction(); // not defined
    ~PointReduction(); // not defined
};

private:
    Position(); // not defined
    ~Position(); // not defined
};

private:
    Snap(); // not defined
    ~Snap(); // not defined
};

struct Zoom: public comphelper::ConfigurationGroup< Zoom> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Draw/Zoom"_ustr); return PATH; }

struct ScaleX: public comphelper::ConfigurationProperty<ScaleX, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Draw/Zoom/ScaleX"_ustr); return PATH; }
private:
    ScaleX(); // not defined
    ~ScaleX(); // not defined
};

struct ScaleY: public comphelper::ConfigurationProperty<ScaleY, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Draw/Zoom/ScaleY"_ustr); return PATH; }
private:
    ScaleY(); // not defined
    ~ScaleY(); // not defined
};

private:
    Zoom(); // not defined
    ~Zoom(); // not defined
};

struct Grid: public comphelper::ConfigurationGroup< Grid> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Draw/Grid"_ustr); return PATH; }

struct Option: public comphelper::ConfigurationGroup< Option> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Draw/Grid/Option"_ustr); return PATH; }

struct SnapToGrid: public comphelper::ConfigurationProperty<SnapToGrid, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Draw/Grid/Option/SnapToGrid"_ustr); return PATH; }
private:
    SnapToGrid(); // not defined
    ~SnapToGrid(); // not defined
};

struct VisibleGrid: public comphelper::ConfigurationProperty<VisibleGrid, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Draw/Grid/Option/VisibleGrid"_ustr); return PATH; }
private:
    VisibleGrid(); // not defined
    ~VisibleGrid(); // not defined
};

struct Synchronize: public comphelper::ConfigurationProperty<Synchronize, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Draw/Grid/Option/Synchronize"_ustr); return PATH; }
private:
    Synchronize(); // not defined
    ~Synchronize(); // not defined
};

private:
    Option(); // not defined
    ~Option(); // not defined
};

struct Resolution: public comphelper::ConfigurationGroup< Resolution> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Draw/Grid/Resolution"_ustr); return PATH; }

struct XAxis: public comphelper::ConfigurationGroup< XAxis> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Draw/Grid/Resolution/XAxis"_ustr); return PATH; }

struct Metric: public comphelper::ConfigurationProperty<Metric, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Draw/Grid/Resolution/XAxis/Metric"_ustr); return PATH; }
private:
    Metric(); // not defined
    ~Metric(); // not defined
};

struct NonMetric: public comphelper::ConfigurationProperty<NonMetric, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Draw/Grid/Resolution/XAxis/NonMetric"_ustr); return PATH; }
private:
    NonMetric(); // not defined
    ~NonMetric(); // not defined
};

private:
    XAxis(); // not defined
    ~XAxis(); // not defined
};

struct YAxis: public comphelper::ConfigurationGroup< YAxis> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Draw/Grid/Resolution/YAxis"_ustr); return PATH; }

struct Metric: public comphelper::ConfigurationProperty<Metric, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Draw/Grid/Resolution/YAxis/Metric"_ustr); return PATH; }
private:
    Metric(); // not defined
    ~Metric(); // not defined
};

struct NonMetric: public comphelper::ConfigurationProperty<NonMetric, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Draw/Grid/Resolution/YAxis/NonMetric"_ustr); return PATH; }
private:
    NonMetric(); // not defined
    ~NonMetric(); // not defined
};

private:
    YAxis(); // not defined
    ~YAxis(); // not defined
};

private:
    Resolution(); // not defined
    ~Resolution(); // not defined
};

struct Subdivision: public comphelper::ConfigurationGroup< Subdivision> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Draw/Grid/Subdivision"_ustr); return PATH; }

struct XAxis: public comphelper::ConfigurationProperty<XAxis, double> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Draw/Grid/Subdivision/XAxis"_ustr); return PATH; }
private:
    XAxis(); // not defined
    ~XAxis(); // not defined
};

struct YAxis: public comphelper::ConfigurationProperty<YAxis, double> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Draw/Grid/Subdivision/YAxis"_ustr); return PATH; }
private:
    YAxis(); // not defined
    ~YAxis(); // not defined
};

private:
    Subdivision(); // not defined
    ~Subdivision(); // not defined
};

struct SnapGrid: public comphelper::ConfigurationGroup< SnapGrid> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Draw/Grid/SnapGrid"_ustr); return PATH; }

struct Size: public comphelper::ConfigurationProperty<Size, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Draw/Grid/SnapGrid/Size"_ustr); return PATH; }
private:
    Size(); // not defined
    ~Size(); // not defined
};

private:
    SnapGrid(); // not defined
    ~SnapGrid(); // not defined
};

private:
    Grid(); // not defined
    ~Grid(); // not defined
};

struct Print: public comphelper::ConfigurationGroup< Print> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Draw/Print"_ustr); return PATH; }

struct Content: public comphelper::ConfigurationGroup< Content> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Draw/Print/Content"_ustr); return PATH; }

struct Drawing: public comphelper::ConfigurationProperty<Drawing, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Draw/Print/Content/Drawing"_ustr); return PATH; }
private:
    Drawing(); // not defined
    ~Drawing(); // not defined
};

private:
    Content(); // not defined
    ~Content(); // not defined
};

struct Page: public comphelper::ConfigurationGroup< Page> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Draw/Print/Page"_ustr); return PATH; }

struct PageSize: public comphelper::ConfigurationProperty<PageSize, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Draw/Print/Page/PageSize"_ustr); return PATH; }
private:
    PageSize(); // not defined
    ~PageSize(); // not defined
};

struct PageTile: public comphelper::ConfigurationProperty<PageTile, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Draw/Print/Page/PageTile"_ustr); return PATH; }
private:
    PageTile(); // not defined
    ~PageTile(); // not defined
};

struct Booklet: public comphelper::ConfigurationProperty<Booklet, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Draw/Print/Page/Booklet"_ustr); return PATH; }
private:
    Booklet(); // not defined
    ~Booklet(); // not defined
};

struct BookletFront: public comphelper::ConfigurationProperty<BookletFront, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Draw/Print/Page/BookletFront"_ustr); return PATH; }
private:
    BookletFront(); // not defined
    ~BookletFront(); // not defined
};

struct BookletBack: public comphelper::ConfigurationProperty<BookletBack, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Draw/Print/Page/BookletBack"_ustr); return PATH; }
private:
    BookletBack(); // not defined
    ~BookletBack(); // not defined
};

private:
    Page(); // not defined
    ~Page(); // not defined
};

struct Other: public comphelper::ConfigurationGroup< Other> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Draw/Print/Other"_ustr); return PATH; }

struct PageName: public comphelper::ConfigurationProperty<PageName, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Draw/Print/Other/PageName"_ustr); return PATH; }
private:
    PageName(); // not defined
    ~PageName(); // not defined
};

struct Date: public comphelper::ConfigurationProperty<Date, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Draw/Print/Other/Date"_ustr); return PATH; }
private:
    Date(); // not defined
    ~Date(); // not defined
};

struct Time: public comphelper::ConfigurationProperty<Time, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Draw/Print/Other/Time"_ustr); return PATH; }
private:
    Time(); // not defined
    ~Time(); // not defined
};

struct HiddenPage: public comphelper::ConfigurationProperty<HiddenPage, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Draw/Print/Other/HiddenPage"_ustr); return PATH; }
private:
    HiddenPage(); // not defined
    ~HiddenPage(); // not defined
};

struct Quality: public comphelper::ConfigurationProperty<Quality, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Draw/Print/Other/Quality"_ustr); return PATH; }
private:
    Quality(); // not defined
    ~Quality(); // not defined
};

struct FromPrinterSetup: public comphelper::ConfigurationProperty<FromPrinterSetup, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Draw/Print/Other/FromPrinterSetup"_ustr); return PATH; }
private:
    FromPrinterSetup(); // not defined
    ~FromPrinterSetup(); // not defined
};

private:
    Other(); // not defined
    ~Other(); // not defined
};

private:
    Print(); // not defined
    ~Print(); // not defined
};

} } }

#endif
