#include <sal/types.h>


#include <rtl/ustring.hxx>


extern "C" {

static constexpr OUStringLiteral langID = u"\x0072\x006f";
static constexpr OUStringLiteral langDefaultName = u"\x0052\x006f\x006d\x0061\x006e\x0069\x0061\x006e";
static constexpr OUStringLiteral countryID = u"\x004d\x0044";
static constexpr OUStringLiteral countryDefaultName = u"\x004d\x006f\x006c\x0064\x006f\x0076\x0061";
static constexpr OUStringLiteral Variant = u"";

static constexpr OUString LCInfoArray[] = {
	langID,
	langDefaultName,
	countryID,
	countryDefaultName,
	Variant
};

SAL_DLLPUBLIC_EXPORT OUString const *  getLCInfo_ro_MD(sal_Int16& count)
{
	count = std::size(LCInfoArray);
	return (OUString const *)LCInfoArray;
}
extern const OUString *  getLocaleItem_ro_RO(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getLocaleItem_ro_MD(sal_Int16& count)
{
	return getLocaleItem_ro_RO(count);
}
static const sal_Unicode replaceTo0[] = {0x5b, 0x24, 0x4c, 0x2d, 0x38, 0x31, 0x38, 0x5d, 0x0};
extern OUString const * getAllFormats0_ro_RO(sal_Int16& count, const sal_Unicode*& from, const sal_Unicode*& to);
SAL_DLLPUBLIC_EXPORT OUString const * getAllFormats0_ro_MD(sal_Int16& count, const sal_Unicode*& from, const sal_Unicode*& to)
{
	to = replaceTo0;
	const sal_Unicode* tmp;
	return getAllFormats0_ro_RO(count, from, tmp);
}
extern const OUString *  getDateAcceptancePatterns_ro_RO(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getDateAcceptancePatterns_ro_MD(sal_Int16& count)
{
	return getDateAcceptancePatterns_ro_RO(count);
}
extern const OUString *  getCollatorImplementation_ro_RO(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getCollatorImplementation_ro_MD(sal_Int16& count)
{
	return getCollatorImplementation_ro_RO(count);
}
extern const OUString *  getCollationOptions_ro_RO(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getCollationOptions_ro_MD(sal_Int16& count)
{
	return getCollationOptions_ro_RO(count);
}
extern const OUString *  getSearchOptions_ro_RO(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getSearchOptions_ro_MD(sal_Int16& count)
{
	return getSearchOptions_ro_RO(count);
}
extern const OUString *  getIndexAlgorithm_ro_RO(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getIndexAlgorithm_ro_MD(sal_Int16& count)
{
	return getIndexAlgorithm_ro_RO(count);
}
extern const OUString *  getUnicodeScripts_ro_RO(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getUnicodeScripts_ro_MD(sal_Int16& count)
{
	return getUnicodeScripts_ro_RO(count);
}
extern const OUString *  getFollowPageWords_ro_RO(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getFollowPageWords_ro_MD(sal_Int16& count)
{
	return getFollowPageWords_ro_RO(count);
}
static constexpr OUStringLiteral calendarID0 = u"\x0067\x0072\x0065\x0067\x006f\x0072\x0069\x0061\x006e";
static constexpr OUStringLiteral defaultCalendar0 = u"\x1";
static constexpr OUStringLiteral dayID00 = u"\x0073\x0075\x006e";
static constexpr OUStringLiteral dayDefaultAbbrvName00 = u"\x0044\x0075\x006d";
static constexpr OUStringLiteral dayDefaultFullName00 = u"\x0064\x0075\x006d\x0069\x006e\x0069\x0063\x0103";
static constexpr OUStringLiteral dayDefaultNarrowName00 = u"\x0064";
static constexpr OUStringLiteral dayID01 = u"\x006d\x006f\x006e";
static constexpr OUStringLiteral dayDefaultAbbrvName01 = u"\x004c\x0075\x006e";
static constexpr OUStringLiteral dayDefaultFullName01 = u"\x006c\x0075\x006e\x0069";
static constexpr OUStringLiteral dayDefaultNarrowName01 = u"\x006c";
static constexpr OUStringLiteral dayID02 = u"\x0074\x0075\x0065";
static constexpr OUStringLiteral dayDefaultAbbrvName02 = u"\x004d\x0061\x0072";
static constexpr OUStringLiteral dayDefaultFullName02 = u"\x006d\x0061\x0072\x021b\x0069";
static constexpr OUStringLiteral dayDefaultNarrowName02 = u"\x006d";
static constexpr OUStringLiteral dayID03 = u"\x0077\x0065\x0064";
static constexpr OUStringLiteral dayDefaultAbbrvName03 = u"\x004d\x0069\x0065";
static constexpr OUStringLiteral dayDefaultFullName03 = u"\x006d\x0069\x0065\x0072\x0063\x0075\x0072\x0069";
static constexpr OUStringLiteral dayDefaultNarrowName03 = u"\x006d";
static constexpr OUStringLiteral dayID04 = u"\x0074\x0068\x0075";
static constexpr OUStringLiteral dayDefaultAbbrvName04 = u"\x004a\x006f\x0069";
static constexpr OUStringLiteral dayDefaultFullName04 = u"\x006a\x006f\x0069";
static constexpr OUStringLiteral dayDefaultNarrowName04 = u"\x006a";
static constexpr OUStringLiteral dayID05 = u"\x0066\x0072\x0069";
static constexpr OUStringLiteral dayDefaultAbbrvName05 = u"\x0056\x0069\x006e";
static constexpr OUStringLiteral dayDefaultFullName05 = u"\x0076\x0069\x006e\x0065\x0072\x0069";
static constexpr OUStringLiteral dayDefaultNarrowName05 = u"\x0076";
static constexpr OUStringLiteral dayID06 = u"\x0073\x0061\x0074";
static constexpr OUStringLiteral dayDefaultAbbrvName06 = u"\x0053\x00e2\x006d";
static constexpr OUStringLiteral dayDefaultFullName06 = u"\x0073\x00e2\x006d\x0062\x0103\x0074\x0103";
static constexpr OUStringLiteral dayDefaultNarrowName06 = u"\x0073";
static constexpr OUStringLiteral monthRef0 = u"\x0072\x0065\x0066";
static constexpr OUStringLiteral monthRefName0 = u"\x0072\x006f\x005f\x0052\x004f";
static constexpr OUStringLiteral genitiveMonthRef0 = u"\x0072\x0065\x0066";
static constexpr OUStringLiteral genitiveMonthRefName0 = u"\x0072\x006f\x005f\x0052\x004f";
static constexpr OUStringLiteral partitiveMonthRef0 = u"\x0072\x0065\x0066";
static constexpr OUStringLiteral partitiveMonthRefName0 = u"\x0072\x006f\x005f\x0052\x004f";
static constexpr OUStringLiteral eraRef0 = u"\x0072\x0065\x0066";
static constexpr OUStringLiteral eraRefName0 = u"\x0072\x006f\x005f\x0052\x004f";
static constexpr OUStringLiteral startDayOfWeek0 = u"\x006d\x006f\x006e";
static constexpr OUStringLiteral minimalDaysInFirstWeek0 = u"\x1";
static const sal_Int16 calendarsCount = 1;

static constexpr OUStringLiteral nbOfDays = u"\x7";
static constexpr OUStringLiteral nbOfMonths = u"\x0";
static constexpr OUStringLiteral nbOfGenitiveMonths = u"\x0";
static constexpr OUStringLiteral nbOfPartitiveMonths = u"\x0";
static constexpr OUStringLiteral nbOfEras = u"\x0";
static constexpr OUString calendars[] = {
	nbOfDays,
	nbOfMonths,
	nbOfGenitiveMonths,
	nbOfPartitiveMonths,
	nbOfEras,
	calendarID0,
	defaultCalendar0,
	dayID00,
	dayDefaultAbbrvName00,
	dayDefaultFullName00,
	dayDefaultNarrowName00,
	dayID01,
	dayDefaultAbbrvName01,
	dayDefaultFullName01,
	dayDefaultNarrowName01,
	dayID02,
	dayDefaultAbbrvName02,
	dayDefaultFullName02,
	dayDefaultNarrowName02,
	dayID03,
	dayDefaultAbbrvName03,
	dayDefaultFullName03,
	dayDefaultNarrowName03,
	dayID04,
	dayDefaultAbbrvName04,
	dayDefaultFullName04,
	dayDefaultNarrowName04,
	dayID05,
	dayDefaultAbbrvName05,
	dayDefaultFullName05,
	dayDefaultNarrowName05,
	dayID06,
	dayDefaultAbbrvName06,
	dayDefaultFullName06,
	dayDefaultNarrowName06,
	monthRef0,
	monthRefName0,
	genitiveMonthRef0,
	genitiveMonthRefName0,
	partitiveMonthRef0,
	partitiveMonthRefName0,
	eraRef0,
	eraRefName0,
	startDayOfWeek0,
	minimalDaysInFirstWeek0,
};

SAL_DLLPUBLIC_EXPORT OUString const *  getAllCalendars_ro_MD(sal_Int16& count)
{
	count = calendarsCount;
	return (OUString const *)calendars;
}
static constexpr OUStringLiteral defaultCurrency0 = u"\x1";
static constexpr OUStringLiteral defaultCurrencyUsedInCompatibleFormatCodes0 = u"\x1";
static constexpr OUStringLiteral defaultCurrencyLegacyOnly0 = u"\x0";
static constexpr OUStringLiteral currencyID0 = u"\x004d\x0044\x004c";
static constexpr OUStringLiteral currencySymbol0 = u"\x004c";
static constexpr OUStringLiteral bankSymbol0 = u"\x004d\x0044\x004c";
static constexpr OUStringLiteral currencyName0 = u"\x004c\x0065\x0075";
static constexpr OUStringLiteral currencyDecimalPlaces0 = u"\x2";

static const sal_Int16 currencyCount = 1;

static constexpr OUString currencies[] = {
	currencyID0,
	currencySymbol0,
	bankSymbol0,
	currencyName0,
	defaultCurrency0,
	defaultCurrencyUsedInCompatibleFormatCodes0,
	currencyDecimalPlaces0,
	defaultCurrencyLegacyOnly0,
};

SAL_DLLPUBLIC_EXPORT OUString const *  getAllCurrencies_ro_MD(sal_Int16& count)
{
	count = currencyCount;
	return (OUString const *)currencies;
}
extern const OUString *  getTransliterations_ro_RO(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getTransliterations_ro_MD(sal_Int16& count)
{
	return getTransliterations_ro_RO(count);
}
extern const OUString *  getForbiddenCharacters_ro_RO(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getForbiddenCharacters_ro_MD(sal_Int16& count)
{
	return getForbiddenCharacters_ro_RO(count);
}
extern const OUString *  getBreakIteratorRules_ro_RO(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getBreakIteratorRules_ro_MD(sal_Int16& count)
{
	return getBreakIteratorRules_ro_RO(count);
}
extern const OUString *  getReservedWords_ro_RO(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getReservedWords_ro_MD(sal_Int16& count)
{
	return getReservedWords_ro_RO(count);
}
// ---> ContinuousNumbering
extern const OUString **  getContinuousNumberingLevels_ro_RO(sal_Int16& nStyles, sal_Int16& nAttributes);
SAL_DLLPUBLIC_EXPORT const OUString **  getContinuousNumberingLevels_ro_MD(sal_Int16& nStyles, sal_Int16& nAttributes)
{
	return getContinuousNumberingLevels_ro_RO(nStyles, nAttributes);
}
// ---> OutlineNumbering
extern const OUString ***  getOutlineNumberingLevels_ro_RO(sal_Int16& nStyles, sal_Int16& nLevels, sal_Int16& nAttributes);
SAL_DLLPUBLIC_EXPORT const OUString ***  getOutlineNumberingLevels_ro_MD(sal_Int16& nStyles, sal_Int16& nLevels, sal_Int16& nAttributes)
{
	return getOutlineNumberingLevels_ro_RO(nStyles, nLevels, nAttributes);
}
} // extern "C"

