/* BlurManager.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from BlurManager.vala, do not modify */

/*
* SPDX-License-Identifier: GPL-3.0-or-later
* SPDX-FileCopyrightText: 2025 elementary, Inc. (https://elementary.io)
 */

#include <glib-object.h>
#include <meta/meta-plugin.h>
#include <glib.h>
#include <meta/window.h>
#include <clutter/clutter.h>
#include <meta/meta-window-actor.h>
#include <float.h>
#include <math.h>
#include <mtk/mtk.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <meta/display.h>

#define GREETER_COMPOSITOR_BLUR_MANAGER_BLUR_RADIUS 12
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GREETER_COMPOSITOR_TYPE_BLUR_MANAGER (greeter_compositor_blur_manager_get_type ())
#define GREETER_COMPOSITOR_BLUR_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GREETER_COMPOSITOR_TYPE_BLUR_MANAGER, GreeterCompositorBlurManager))
#define GREETER_COMPOSITOR_BLUR_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GREETER_COMPOSITOR_TYPE_BLUR_MANAGER, GreeterCompositorBlurManagerClass))
#define GREETER_COMPOSITOR_IS_BLUR_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GREETER_COMPOSITOR_TYPE_BLUR_MANAGER))
#define GREETER_COMPOSITOR_IS_BLUR_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GREETER_COMPOSITOR_TYPE_BLUR_MANAGER))
#define GREETER_COMPOSITOR_BLUR_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GREETER_COMPOSITOR_TYPE_BLUR_MANAGER, GreeterCompositorBlurManagerClass))

typedef struct _GreeterCompositorBlurManager GreeterCompositorBlurManager;
typedef struct _GreeterCompositorBlurManagerClass GreeterCompositorBlurManagerClass;
typedef struct _GreeterCompositorBlurManagerPrivate GreeterCompositorBlurManagerPrivate;

#define GREETER_COMPOSITOR_TYPE_WINDOW_MANAGER (greeter_compositor_window_manager_get_type ())
#define GREETER_COMPOSITOR_WINDOW_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GREETER_COMPOSITOR_TYPE_WINDOW_MANAGER, GreeterCompositorWindowManager))
#define GREETER_COMPOSITOR_WINDOW_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GREETER_COMPOSITOR_TYPE_WINDOW_MANAGER, GreeterCompositorWindowManagerClass))
#define GREETER_COMPOSITOR_IS_WINDOW_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GREETER_COMPOSITOR_TYPE_WINDOW_MANAGER))
#define GREETER_COMPOSITOR_IS_WINDOW_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GREETER_COMPOSITOR_TYPE_WINDOW_MANAGER))
#define GREETER_COMPOSITOR_WINDOW_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GREETER_COMPOSITOR_TYPE_WINDOW_MANAGER, GreeterCompositorWindowManagerClass))

typedef struct _GreeterCompositorWindowManager GreeterCompositorWindowManager;
typedef struct _GreeterCompositorWindowManagerClass GreeterCompositorWindowManagerClass;

#define GREETER_COMPOSITOR_BLUR_MANAGER_TYPE_BLUR_DATA (greeter_compositor_blur_manager_blur_data_get_type ())
typedef struct _GreeterCompositorBlurManagerBlurData GreeterCompositorBlurManagerBlurData;

#define GREETER_COMPOSITOR_TYPE_BACKGROUND_BLUR_EFFECT (greeter_compositor_background_blur_effect_get_type ())
#define GREETER_COMPOSITOR_BACKGROUND_BLUR_EFFECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GREETER_COMPOSITOR_TYPE_BACKGROUND_BLUR_EFFECT, GreeterCompositorBackgroundBlurEffect))
#define GREETER_COMPOSITOR_BACKGROUND_BLUR_EFFECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GREETER_COMPOSITOR_TYPE_BACKGROUND_BLUR_EFFECT, GreeterCompositorBackgroundBlurEffectClass))
#define GREETER_COMPOSITOR_IS_BACKGROUND_BLUR_EFFECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GREETER_COMPOSITOR_TYPE_BACKGROUND_BLUR_EFFECT))
#define GREETER_COMPOSITOR_IS_BACKGROUND_BLUR_EFFECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GREETER_COMPOSITOR_TYPE_BACKGROUND_BLUR_EFFECT))
#define GREETER_COMPOSITOR_BACKGROUND_BLUR_EFFECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GREETER_COMPOSITOR_TYPE_BACKGROUND_BLUR_EFFECT, GreeterCompositorBackgroundBlurEffectClass))

typedef struct _GreeterCompositorBackgroundBlurEffect GreeterCompositorBackgroundBlurEffect;
typedef struct _GreeterCompositorBackgroundBlurEffectClass GreeterCompositorBackgroundBlurEffectClass;
enum  {
	GREETER_COMPOSITOR_BLUR_MANAGER_0_PROPERTY,
	GREETER_COMPOSITOR_BLUR_MANAGER_WM_PROPERTY,
	GREETER_COMPOSITOR_BLUR_MANAGER_NUM_PROPERTIES
};
static GParamSpec* greeter_compositor_blur_manager_properties[GREETER_COMPOSITOR_BLUR_MANAGER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _greeter_compositor_blur_manager_blur_data_free0(var) ((var == NULL) ? NULL : (var = (greeter_compositor_blur_manager_blur_data_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _GreeterCompositorBlurManager {
	GObject parent_instance;
	GreeterCompositorBlurManagerPrivate * priv;
};

struct _GreeterCompositorBlurManagerClass {
	GObjectClass parent_class;
};

struct _GreeterCompositorBlurManagerBlurData {
	ClutterActor* actor;
	GreeterCompositorBackgroundBlurEffect* blur_effect;
	guint left;
	guint right;
	guint top;
	guint bottom;
	guint clip_radius;
};

struct _GreeterCompositorBlurManagerPrivate {
	GreeterCompositorWindowManager* _wm;
	GHashTable* blurred_windows;
};

static gint GreeterCompositorBlurManager_private_offset;
static gpointer greeter_compositor_blur_manager_parent_class = NULL;
static GreeterCompositorBlurManager* greeter_compositor_blur_manager_instance;
static GreeterCompositorBlurManager* greeter_compositor_blur_manager_instance = NULL;

VALA_EXTERN GType greeter_compositor_blur_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GreeterCompositorBlurManager, g_object_unref)
VALA_EXTERN GType greeter_compositor_window_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GreeterCompositorWindowManager, g_object_unref)
static GType greeter_compositor_blur_manager_blur_data_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
VALA_EXTERN GType greeter_compositor_background_blur_effect_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GreeterCompositorBackgroundBlurEffect, g_object_unref)
static GreeterCompositorBlurManagerBlurData* greeter_compositor_blur_manager_blur_data_dup (const GreeterCompositorBlurManagerBlurData* self);
static void greeter_compositor_blur_manager_blur_data_free (GreeterCompositorBlurManagerBlurData* self);
static void greeter_compositor_blur_manager_blur_data_copy (const GreeterCompositorBlurManagerBlurData* self,
                                                     GreeterCompositorBlurManagerBlurData* dest);
static void greeter_compositor_blur_manager_blur_data_destroy (GreeterCompositorBlurManagerBlurData* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (GreeterCompositorBlurManagerBlurData, greeter_compositor_blur_manager_blur_data_destroy)
static void _g_object_unref0_ (gpointer var);
static void _greeter_compositor_blur_manager_blur_data_free0_ (gpointer var);
VALA_EXTERN void greeter_compositor_blur_manager_init (GreeterCompositorWindowManager* wm);
static GreeterCompositorBlurManager* greeter_compositor_blur_manager_new (GreeterCompositorWindowManager* wm);
static GreeterCompositorBlurManager* greeter_compositor_blur_manager_construct (GType object_type,
                                                                         GreeterCompositorWindowManager* wm);
VALA_EXTERN GreeterCompositorBlurManager* greeter_compositor_blur_manager_get_instance (void);
VALA_EXTERN void greeter_compositor_blur_manager_add_blur (GreeterCompositorBlurManager* self,
                                               MetaWindow* window,
                                               guint left,
                                               guint right,
                                               guint top,
                                               guint bottom,
                                               guint clip_radius);
VALA_EXTERN GreeterCompositorBackgroundBlurEffect* greeter_compositor_background_blur_effect_new (gfloat blur_radius,
                                                                                      gfloat clip_radius,
                                                                                      gfloat monitor_scale);
VALA_EXTERN GreeterCompositorBackgroundBlurEffect* greeter_compositor_background_blur_effect_construct (GType object_type,
                                                                                            gfloat blur_radius,
                                                                                            gfloat clip_radius,
                                                                                            gfloat monitor_scale);
static void greeter_compositor_blur_manager_on_size_changed (GreeterCompositorBlurManager* self,
                                                      MetaWindow* window);
static void _greeter_compositor_blur_manager_on_size_changed_meta_window_size_changed (MetaWindow* _sender,
                                                                                gpointer self);
VALA_EXTERN void greeter_compositor_blur_manager_remove_blur (GreeterCompositorBlurManager* self,
                                                  MetaWindow* window);
static void greeter_compositor_blur_manager_parse_mutter_hints (GreeterCompositorBlurManager* self,
                                                         MetaWindow* window);
VALA_EXTERN GreeterCompositorWindowManager* greeter_compositor_blur_manager_get_wm (GreeterCompositorBlurManager* self);
static void greeter_compositor_blur_manager_set_wm (GreeterCompositorBlurManager* self,
                                             GreeterCompositorWindowManager* value);
static GObject * greeter_compositor_blur_manager_constructor (GType type,
                                                       guint n_construct_properties,
                                                       GObjectConstructParam * construct_properties);
static void _greeter_compositor_blur_manager___lambda25_ (GreeterCompositorBlurManager* self,
                                                   MetaWindow* window);
static void __lambda26_ (GreeterCompositorBlurManager* self,
                  GObject* obj,
                  GParamSpec* pspec);
static void ___lambda26__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void __greeter_compositor_blur_manager___lambda25__meta_display_window_created (MetaDisplay* _sender,
                                                                                MetaWindow* object,
                                                                                gpointer self);
static void greeter_compositor_blur_manager_finalize (GObject * obj);
static GType greeter_compositor_blur_manager_get_type_once (void);
static void _vala_greeter_compositor_blur_manager_get_property (GObject * object,
                                                         guint property_id,
                                                         GValue * value,
                                                         GParamSpec * pspec);
static void _vala_greeter_compositor_blur_manager_set_property (GObject * object,
                                                         guint property_id,
                                                         const GValue * value,
                                                         GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
greeter_compositor_blur_manager_get_instance_private (GreeterCompositorBlurManager* self)
{
	return G_STRUCT_MEMBER_P (self, GreeterCompositorBlurManager_private_offset);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static void
_greeter_compositor_blur_manager_blur_data_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (greeter_compositor_blur_manager_blur_data_free (var), NULL));
}

void
greeter_compositor_blur_manager_init (GreeterCompositorWindowManager* wm)
{
	GreeterCompositorBlurManager* _tmp0_;
	GreeterCompositorBlurManager* _tmp1_;
	g_return_if_fail (wm != NULL);
	_tmp0_ = greeter_compositor_blur_manager_instance;
	if (_tmp0_ != NULL) {
		return;
	}
	_tmp1_ = greeter_compositor_blur_manager_new (wm);
	_g_object_unref0 (greeter_compositor_blur_manager_instance);
	greeter_compositor_blur_manager_instance = _tmp1_;
}

GreeterCompositorBlurManager*
greeter_compositor_blur_manager_get_instance (void)
{
	GreeterCompositorBlurManager* _tmp0_;
	GreeterCompositorBlurManager* result;
	_tmp0_ = greeter_compositor_blur_manager_instance;
	result = _tmp0_;
	return result;
}

static GreeterCompositorBlurManager*
greeter_compositor_blur_manager_construct (GType object_type,
                                           GreeterCompositorWindowManager* wm)
{
	GreeterCompositorBlurManager * self = NULL;
	g_return_val_if_fail (wm != NULL, NULL);
	self = (GreeterCompositorBlurManager*) g_object_new (object_type, "wm", wm, NULL);
	return self;
}

static GreeterCompositorBlurManager*
greeter_compositor_blur_manager_new (GreeterCompositorWindowManager* wm)
{
	return greeter_compositor_blur_manager_construct (GREETER_COMPOSITOR_TYPE_BLUR_MANAGER, wm);
}

/**
     * Blurs the given region of the given window.
     */
static gpointer
_greeter_compositor_blur_manager_blur_data_dup0 (gpointer self)
{
	return self ? greeter_compositor_blur_manager_blur_data_dup (self) : NULL;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_greeter_compositor_blur_manager_on_size_changed_meta_window_size_changed (MetaWindow* _sender,
                                                                           gpointer self)
{
	greeter_compositor_blur_manager_on_size_changed ((GreeterCompositorBlurManager*) self, _sender);
}

void
greeter_compositor_blur_manager_add_blur (GreeterCompositorBlurManager* self,
                                          MetaWindow* window,
                                          guint left,
                                          guint right,
                                          guint top,
                                          guint bottom,
                                          guint clip_radius)
{
	MetaWindowActor* window_actor = NULL;
	GObject* _tmp0_;
	MetaWindowActor* _tmp1_;
	GreeterCompositorBlurManagerBlurData* blur_data = NULL;
	GHashTable* _tmp2_;
	gconstpointer _tmp3_;
	GreeterCompositorBlurManagerBlurData* _tmp4_;
	GreeterCompositorBlurManagerBlurData* _tmp5_;
	MtkRectangle buffer_rect = {0};
	MtkRectangle _tmp23_ = {0};
	MtkRectangle frame_rect = {0};
	MtkRectangle _tmp24_ = {0};
	gint x_shadow_size = 0;
	MtkRectangle _tmp25_;
	MtkRectangle _tmp26_;
	gint y_shadow_size = 0;
	MtkRectangle _tmp27_;
	MtkRectangle _tmp28_;
	GreeterCompositorBlurManagerBlurData* _tmp29_;
	ClutterActor* _tmp30_;
	GreeterCompositorBlurManagerBlurData* _tmp31_;
	ClutterActor* _tmp32_;
	MtkRectangle _tmp33_;
	MtkRectangle _tmp34_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_tmp0_ = meta_window_get_compositor_private (window);
	window_actor = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, meta_window_actor_get_type (), MetaWindowActor);
	_tmp1_ = window_actor;
	if (_tmp1_ == NULL) {
		g_critical ("BlurManager.vala:54: Cannot blur actor: Actor is null");
		return;
	}
	_tmp2_ = self->priv->blurred_windows;
	_tmp3_ = g_hash_table_lookup (_tmp2_, window);
	_tmp4_ = _greeter_compositor_blur_manager_blur_data_dup0 ((GreeterCompositorBlurManagerBlurData*) _tmp3_);
	blur_data = _tmp4_;
	_tmp5_ = blur_data;
	if (_tmp5_ == NULL) {
		GreeterCompositorBackgroundBlurEffect* blur_effect = NULL;
		GreeterCompositorBackgroundBlurEffect* _tmp6_;
		ClutterActor* blurred_actor = NULL;
		ClutterActor* _tmp7_;
		ClutterActor* _tmp8_;
		GreeterCompositorBackgroundBlurEffect* _tmp9_;
		MetaWindowActor* _tmp10_;
		ClutterActor* _tmp11_;
		ClutterActor* _tmp12_;
		ClutterActor* _tmp13_;
		GreeterCompositorBackgroundBlurEffect* _tmp14_;
		GreeterCompositorBackgroundBlurEffect* _tmp15_;
		GreeterCompositorBlurManagerBlurData _tmp16_ = {0};
		GreeterCompositorBlurManagerBlurData _tmp17_;
		GreeterCompositorBlurManagerBlurData* _tmp18_;
		GHashTable* _tmp19_;
		MetaWindow* _tmp20_;
		GreeterCompositorBlurManagerBlurData* _tmp21_;
		GreeterCompositorBlurManagerBlurData* _tmp22_;
		_tmp6_ = greeter_compositor_background_blur_effect_new ((gfloat) GREETER_COMPOSITOR_BLUR_MANAGER_BLUR_RADIUS, (gfloat) ((gint) clip_radius), 1.0f);
		g_object_ref_sink (_tmp6_);
		blur_effect = _tmp6_;
		_tmp7_ = clutter_actor_new ();
		g_object_ref_sink (_tmp7_);
		blurred_actor = _tmp7_;
		_tmp8_ = blurred_actor;
		_tmp9_ = blur_effect;
		clutter_actor_add_effect (_tmp8_, (ClutterEffect*) _tmp9_);
		_tmp10_ = window_actor;
		_tmp11_ = blurred_actor;
		clutter_actor_insert_child_below ((ClutterActor*) _tmp10_, _tmp11_, NULL);
		_tmp12_ = blurred_actor;
		_tmp13_ = _g_object_ref0 (_tmp12_);
		_tmp14_ = blur_effect;
		_tmp15_ = _g_object_ref0 (_tmp14_);
		_g_object_unref0 (_tmp16_.actor);
		_tmp16_.actor = _tmp13_;
		_g_object_unref0 (_tmp16_.blur_effect);
		_tmp16_.blur_effect = _tmp15_;
		_tmp16_.left = left;
		_tmp16_.right = right;
		_tmp16_.top = top;
		_tmp16_.bottom = bottom;
		_tmp16_.clip_radius = clip_radius;
		_tmp17_ = _tmp16_;
		_tmp18_ = _greeter_compositor_blur_manager_blur_data_dup0 (&_tmp17_);
		_greeter_compositor_blur_manager_blur_data_free0 (blur_data);
		blur_data = _tmp18_;
		greeter_compositor_blur_manager_blur_data_destroy (&_tmp17_);
		_tmp19_ = self->priv->blurred_windows;
		_tmp20_ = _g_object_ref0 (window);
		_tmp21_ = blur_data;
		_tmp22_ = _greeter_compositor_blur_manager_blur_data_dup0 (_tmp21_);
		g_hash_table_insert (_tmp19_, _tmp20_, _tmp22_);
		g_signal_connect_object (window, "size-changed", (GCallback) _greeter_compositor_blur_manager_on_size_changed_meta_window_size_changed, self, 0);
		_g_object_unref0 (blurred_actor);
		_g_object_unref0 (blur_effect);
	}
	meta_window_get_buffer_rect (window, &_tmp23_);
	buffer_rect = _tmp23_;
	meta_window_get_frame_rect (window, &_tmp24_);
	frame_rect = _tmp24_;
	_tmp25_ = frame_rect;
	_tmp26_ = buffer_rect;
	x_shadow_size = _tmp25_.x - _tmp26_.x;
	_tmp27_ = frame_rect;
	_tmp28_ = buffer_rect;
	y_shadow_size = _tmp27_.y - _tmp28_.y;
	_tmp29_ = blur_data;
	_tmp30_ = (*_tmp29_).actor;
	clutter_actor_set_position (_tmp30_, (gfloat) (x_shadow_size + left), (gfloat) (y_shadow_size + top));
	_tmp31_ = blur_data;
	_tmp32_ = (*_tmp31_).actor;
	_tmp33_ = frame_rect;
	_tmp34_ = frame_rect;
	clutter_actor_set_size (_tmp32_, (gfloat) ((_tmp33_.width - left) - right), (gfloat) ((_tmp34_.height - top) - bottom));
	_greeter_compositor_blur_manager_blur_data_free0 (blur_data);
}

void
greeter_compositor_blur_manager_remove_blur (GreeterCompositorBlurManager* self,
                                             MetaWindow* window)
{
	GreeterCompositorBlurManagerBlurData* blur_data = NULL;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	GreeterCompositorBlurManagerBlurData* _tmp2_;
	GreeterCompositorBlurManagerBlurData* _tmp3_;
	ClutterActor* actor = NULL;
	GreeterCompositorBlurManagerBlurData* _tmp4_;
	ClutterActor* _tmp5_;
	ClutterActor* _tmp6_;
	ClutterActor* _tmp7_;
	GreeterCompositorBlurManagerBlurData* _tmp8_;
	GreeterCompositorBackgroundBlurEffect* _tmp9_;
	ClutterActor* parent = NULL;
	ClutterActor* _tmp10_;
	ClutterActor* _tmp11_;
	ClutterActor* _tmp12_;
	GHashTable* _tmp15_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_tmp0_ = self->priv->blurred_windows;
	_tmp1_ = g_hash_table_lookup (_tmp0_, window);
	_tmp2_ = _greeter_compositor_blur_manager_blur_data_dup0 ((GreeterCompositorBlurManagerBlurData*) _tmp1_);
	blur_data = _tmp2_;
	_tmp3_ = blur_data;
	if (_tmp3_ == NULL) {
		_greeter_compositor_blur_manager_blur_data_free0 (blur_data);
		return;
	}
	_tmp4_ = blur_data;
	_tmp5_ = (*_tmp4_).actor;
	_tmp6_ = _g_object_ref0 (_tmp5_);
	actor = _tmp6_;
	_tmp7_ = actor;
	_tmp8_ = blur_data;
	_tmp9_ = (*_tmp8_).blur_effect;
	clutter_actor_remove_effect (_tmp7_, (ClutterEffect*) _tmp9_);
	_tmp10_ = actor;
	_tmp11_ = clutter_actor_get_parent (_tmp10_);
	parent = _tmp11_;
	_tmp12_ = parent;
	if (_tmp12_ != NULL) {
		ClutterActor* _tmp13_;
		ClutterActor* _tmp14_;
		_tmp13_ = parent;
		_tmp14_ = actor;
		clutter_actor_remove_child (_tmp13_, _tmp14_);
	}
	_tmp15_ = self->priv->blurred_windows;
	g_hash_table_remove (_tmp15_, window);
	_g_object_unref0 (actor);
	_greeter_compositor_blur_manager_blur_data_free0 (blur_data);
}

static void
greeter_compositor_blur_manager_on_size_changed (GreeterCompositorBlurManager* self,
                                                 MetaWindow* window)
{
	GreeterCompositorBlurManagerBlurData* blur_data = NULL;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	GreeterCompositorBlurManagerBlurData* _tmp2_;
	GreeterCompositorBlurManagerBlurData* _tmp3_;
	GreeterCompositorBlurManagerBlurData* _tmp4_;
	GreeterCompositorBlurManagerBlurData* _tmp5_;
	GreeterCompositorBlurManagerBlurData* _tmp6_;
	GreeterCompositorBlurManagerBlurData* _tmp7_;
	GreeterCompositorBlurManagerBlurData* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_tmp0_ = self->priv->blurred_windows;
	_tmp1_ = g_hash_table_lookup (_tmp0_, window);
	_tmp2_ = _greeter_compositor_blur_manager_blur_data_dup0 ((GreeterCompositorBlurManagerBlurData*) _tmp1_);
	blur_data = _tmp2_;
	_tmp3_ = blur_data;
	if (_tmp3_ == NULL) {
		_greeter_compositor_blur_manager_blur_data_free0 (blur_data);
		return;
	}
	_tmp4_ = blur_data;
	_tmp5_ = blur_data;
	_tmp6_ = blur_data;
	_tmp7_ = blur_data;
	_tmp8_ = blur_data;
	greeter_compositor_blur_manager_add_blur (self, window, (*_tmp4_).left, (*_tmp5_).right, (*_tmp6_).top, (*_tmp7_).bottom, (*_tmp8_).clip_radius);
	_greeter_compositor_blur_manager_blur_data_free0 (blur_data);
}

static gboolean
uint_try_parse (const gchar* str,
                guint* _result_,
                const gchar** unparsed,
                guint _base)
{
	guint _vala__result_ = 0U;
	const gchar* _vala_unparsed = NULL;
	gchar* endptr = NULL;
	gulong ulong_result = 0UL;
	gchar* _tmp0_ = NULL;
	gulong _tmp1_;
	gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gulong _tmp6_;
	gboolean result;
	g_return_val_if_fail (str != NULL, FALSE);
	errno = 0;
	_tmp1_ = strtoul (str, &_tmp0_, (gint) _base);
	endptr = _tmp0_;
	ulong_result = _tmp1_;
	_tmp2_ = endptr;
	_tmp3_ = strlen (str);
	_tmp4_ = _tmp3_;
	if (_tmp2_ == (((gchar*) str) + _tmp4_)) {
		_vala_unparsed = "";
	} else {
		gchar* _tmp5_;
		_tmp5_ = endptr;
		_vala_unparsed = (const gchar*) _tmp5_;
	}
	_tmp6_ = ulong_result;
	if ((((gulong) 0) <= _tmp6_) && (_tmp6_ <= ((gulong) G_MAXUINT))) {
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_ = FALSE;
		_vala__result_ = (guint) ulong_result;
		if (errno != ERANGE) {
			_tmp8_ = errno != EINVAL;
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			const gchar* _tmp9_;
			gchar* _tmp10_;
			_tmp9_ = _vala_unparsed;
			_tmp10_ = endptr;
			_tmp7_ = _tmp9_ != _tmp10_;
		} else {
			_tmp7_ = FALSE;
		}
		result = _tmp7_;
		if (_result_) {
			*_result_ = _vala__result_;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	} else {
		_vala__result_ = G_MAXUINT;
		result = FALSE;
		if (_result_) {
			*_result_ = _vala__result_;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	}
}

static void
greeter_compositor_blur_manager_parse_mutter_hints (GreeterCompositorBlurManager* self,
                                                    MetaWindow* window)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar** mutter_hints = NULL;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar** _tmp4_;
	gchar** _tmp5_;
	gint mutter_hints_length1;
	gint _mutter_hints_size_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_tmp0_ = meta_window_get_mutter_hints (window);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		return;
	}
	_tmp2_ = meta_window_get_mutter_hints (window);
	_tmp3_ = _tmp2_;
	_tmp5_ = _tmp4_ = g_strsplit (_tmp3_, ":", 0);
	mutter_hints = _tmp5_;
	mutter_hints_length1 = _vala_array_length (_tmp4_);
	_mutter_hints_size_ = mutter_hints_length1;
	_tmp6_ = mutter_hints;
	_tmp6__length1 = mutter_hints_length1;
	{
		gchar** mutter_hint_collection = NULL;
		gint mutter_hint_collection_length1 = 0;
		gint _mutter_hint_collection_size_ = 0;
		gint mutter_hint_it = 0;
		mutter_hint_collection = _tmp6_;
		mutter_hint_collection_length1 = _tmp6__length1;
		for (mutter_hint_it = 0; mutter_hint_it < mutter_hint_collection_length1; mutter_hint_it = mutter_hint_it + 1) {
			gchar* _tmp7_;
			gchar* mutter_hint = NULL;
			_tmp7_ = g_strdup (mutter_hint_collection[mutter_hint_it]);
			mutter_hint = _tmp7_;
			{
				gchar** split = NULL;
				const gchar* _tmp8_;
				gchar** _tmp9_;
				gchar** _tmp10_;
				gint split_length1;
				gint _split_size_;
				gchar** _tmp11_;
				gint _tmp11__length1;
				gchar* key = NULL;
				gchar** _tmp12_;
				gint _tmp12__length1;
				const gchar* _tmp13_;
				gchar* _tmp14_;
				gchar* val = NULL;
				gchar** _tmp15_;
				gint _tmp15__length1;
				const gchar* _tmp16_;
				gchar* _tmp17_;
				const gchar* _tmp18_;
				const gchar* _tmp19_;
				GQuark _tmp21_ = 0U;
				static GQuark _tmp20_label0 = 0;
				_tmp8_ = mutter_hint;
				_tmp10_ = _tmp9_ = g_strsplit (_tmp8_, "=", 0);
				split = _tmp10_;
				split_length1 = _vala_array_length (_tmp9_);
				_split_size_ = split_length1;
				_tmp11_ = split;
				_tmp11__length1 = split_length1;
				if (_tmp11__length1 != 2) {
					split = (_vala_array_free (split, split_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (mutter_hint);
					continue;
				}
				_tmp12_ = split;
				_tmp12__length1 = split_length1;
				_tmp13_ = _tmp12_[0];
				_tmp14_ = g_strdup (_tmp13_);
				key = _tmp14_;
				_tmp15_ = split;
				_tmp15__length1 = split_length1;
				_tmp16_ = _tmp15_[1];
				_tmp17_ = g_strdup (_tmp16_);
				val = _tmp17_;
				_tmp18_ = key;
				_tmp19_ = _tmp18_;
				_tmp21_ = (NULL == _tmp19_) ? 0 : g_quark_from_string (_tmp19_);
				if (_tmp21_ == ((0 != _tmp20_label0) ? _tmp20_label0 : (_tmp20_label0 = g_quark_from_static_string ("blur")))) {
					switch (0) {
						default:
						{
							gchar** split_val = NULL;
							const gchar* _tmp22_;
							gchar** _tmp23_;
							gchar** _tmp24_;
							gint split_val_length1;
							gint _split_val_size_;
							gchar** _tmp25_;
							gint _tmp25__length1;
							guint parsed_left = 0U;
							guint parsed_right = 0U;
							guint parsed_top = 0U;
							guint parsed_bottom = 0U;
							guint parsed_clip_radius = 0U;
							gboolean _tmp26_ = FALSE;
							gboolean _tmp27_ = FALSE;
							gboolean _tmp28_ = FALSE;
							gboolean _tmp29_ = FALSE;
							gchar** _tmp30_;
							gint _tmp30__length1;
							const gchar* _tmp31_;
							guint _tmp32_ = 0U;
							gboolean _tmp33_;
							_tmp22_ = val;
							_tmp24_ = _tmp23_ = g_strsplit (_tmp22_, ",", 0);
							split_val = _tmp24_;
							split_val_length1 = _vala_array_length (_tmp23_);
							_split_val_size_ = split_val_length1;
							_tmp25_ = split_val;
							_tmp25__length1 = split_val_length1;
							if (_tmp25__length1 != 5) {
								split_val = (_vala_array_free (split_val, split_val_length1, (GDestroyNotify) g_free), NULL);
								break;
							}
							parsed_left = (guint) 0;
							parsed_right = (guint) 0;
							parsed_top = (guint) 0;
							parsed_bottom = (guint) 0;
							parsed_clip_radius = (guint) 0;
							_tmp30_ = split_val;
							_tmp30__length1 = split_val_length1;
							_tmp31_ = _tmp30_[0];
							_tmp33_ = uint_try_parse (_tmp31_, &_tmp32_, NULL, (guint) 0);
							parsed_left = _tmp32_;
							if (_tmp33_) {
								gchar** _tmp34_;
								gint _tmp34__length1;
								const gchar* _tmp35_;
								guint _tmp36_ = 0U;
								gboolean _tmp37_;
								_tmp34_ = split_val;
								_tmp34__length1 = split_val_length1;
								_tmp35_ = _tmp34_[1];
								_tmp37_ = uint_try_parse (_tmp35_, &_tmp36_, NULL, (guint) 0);
								parsed_right = _tmp36_;
								_tmp29_ = _tmp37_;
							} else {
								_tmp29_ = FALSE;
							}
							if (_tmp29_) {
								gchar** _tmp38_;
								gint _tmp38__length1;
								const gchar* _tmp39_;
								guint _tmp40_ = 0U;
								gboolean _tmp41_;
								_tmp38_ = split_val;
								_tmp38__length1 = split_val_length1;
								_tmp39_ = _tmp38_[2];
								_tmp41_ = uint_try_parse (_tmp39_, &_tmp40_, NULL, (guint) 0);
								parsed_top = _tmp40_;
								_tmp28_ = _tmp41_;
							} else {
								_tmp28_ = FALSE;
							}
							if (_tmp28_) {
								gchar** _tmp42_;
								gint _tmp42__length1;
								const gchar* _tmp43_;
								guint _tmp44_ = 0U;
								gboolean _tmp45_;
								_tmp42_ = split_val;
								_tmp42__length1 = split_val_length1;
								_tmp43_ = _tmp42_[3];
								_tmp45_ = uint_try_parse (_tmp43_, &_tmp44_, NULL, (guint) 0);
								parsed_bottom = _tmp44_;
								_tmp27_ = _tmp45_;
							} else {
								_tmp27_ = FALSE;
							}
							if (_tmp27_) {
								gchar** _tmp46_;
								gint _tmp46__length1;
								const gchar* _tmp47_;
								guint _tmp48_ = 0U;
								gboolean _tmp49_;
								_tmp46_ = split_val;
								_tmp46__length1 = split_val_length1;
								_tmp47_ = _tmp46_[4];
								_tmp49_ = uint_try_parse (_tmp47_, &_tmp48_, NULL, (guint) 0);
								parsed_clip_radius = _tmp48_;
								_tmp26_ = _tmp49_;
							} else {
								_tmp26_ = FALSE;
							}
							if (_tmp26_) {
								greeter_compositor_blur_manager_add_blur (self, window, parsed_left, parsed_right, parsed_top, parsed_bottom, parsed_clip_radius);
							} else {
								const gchar* _tmp50_;
								_tmp50_ = val;
								g_warning ("BlurManager.vala:141: Failed to parse %s as width and height", _tmp50_);
							}
							split_val = (_vala_array_free (split_val, split_val_length1, (GDestroyNotify) g_free), NULL);
							break;
						}
					}
				} else {
					switch (0) {
						default:
						{
							break;
						}
					}
				}
				_g_free0 (val);
				_g_free0 (key);
				split = (_vala_array_free (split, split_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (mutter_hint);
			}
		}
	}
	mutter_hints = (_vala_array_free (mutter_hints, mutter_hints_length1, (GDestroyNotify) g_free), NULL);
}

GreeterCompositorWindowManager*
greeter_compositor_blur_manager_get_wm (GreeterCompositorBlurManager* self)
{
	GreeterCompositorWindowManager* result;
	GreeterCompositorWindowManager* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_wm;
	result = _tmp0_;
	return result;
}

static void
greeter_compositor_blur_manager_set_wm (GreeterCompositorBlurManager* self,
                                        GreeterCompositorWindowManager* value)
{
	GreeterCompositorWindowManager* old_value;
	g_return_if_fail (self != NULL);
	old_value = greeter_compositor_blur_manager_get_wm (self);
	if (old_value != value) {
		GreeterCompositorWindowManager* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_wm);
		self->priv->_wm = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, greeter_compositor_blur_manager_properties[GREETER_COMPOSITOR_BLUR_MANAGER_WM_PROPERTY]);
	}
}

static void
greeter_compositor_blur_manager_blur_data_copy (const GreeterCompositorBlurManagerBlurData* self,
                                                GreeterCompositorBlurManagerBlurData* dest)
{
	ClutterActor* _tmp0_;
	ClutterActor* _tmp1_;
	GreeterCompositorBackgroundBlurEffect* _tmp2_;
	GreeterCompositorBackgroundBlurEffect* _tmp3_;
	_tmp0_ = (*self).actor;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 ((*dest).actor);
	(*dest).actor = _tmp1_;
	_tmp2_ = (*self).blur_effect;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 ((*dest).blur_effect);
	(*dest).blur_effect = _tmp3_;
	(*dest).left = (*self).left;
	(*dest).right = (*self).right;
	(*dest).top = (*self).top;
	(*dest).bottom = (*self).bottom;
	(*dest).clip_radius = (*self).clip_radius;
}

static void
greeter_compositor_blur_manager_blur_data_destroy (GreeterCompositorBlurManagerBlurData* self)
{
	_g_object_unref0 ((*self).actor);
	_g_object_unref0 ((*self).blur_effect);
}

static GreeterCompositorBlurManagerBlurData*
greeter_compositor_blur_manager_blur_data_dup (const GreeterCompositorBlurManagerBlurData* self)
{
	GreeterCompositorBlurManagerBlurData* dup;
	dup = g_new0 (GreeterCompositorBlurManagerBlurData, 1);
	greeter_compositor_blur_manager_blur_data_copy (self, dup);
	return dup;
}

static void
greeter_compositor_blur_manager_blur_data_free (GreeterCompositorBlurManagerBlurData* self)
{
	greeter_compositor_blur_manager_blur_data_destroy (self);
	g_free (self);
}

static GType
greeter_compositor_blur_manager_blur_data_get_type_once (void)
{
	GType greeter_compositor_blur_manager_blur_data_type_id;
	greeter_compositor_blur_manager_blur_data_type_id = g_boxed_type_register_static ("GreeterCompositorBlurManagerBlurData", (GBoxedCopyFunc) greeter_compositor_blur_manager_blur_data_dup, (GBoxedFreeFunc) greeter_compositor_blur_manager_blur_data_free);
	return greeter_compositor_blur_manager_blur_data_type_id;
}

static GType
greeter_compositor_blur_manager_blur_data_get_type (void)
{
	static volatile gsize greeter_compositor_blur_manager_blur_data_type_id__once = 0;
	if (g_once_init_enter (&greeter_compositor_blur_manager_blur_data_type_id__once)) {
		GType greeter_compositor_blur_manager_blur_data_type_id;
		greeter_compositor_blur_manager_blur_data_type_id = greeter_compositor_blur_manager_blur_data_get_type_once ();
		g_once_init_leave (&greeter_compositor_blur_manager_blur_data_type_id__once, greeter_compositor_blur_manager_blur_data_type_id);
	}
	return greeter_compositor_blur_manager_blur_data_type_id__once;
}

static void
__lambda26_ (GreeterCompositorBlurManager* self,
             GObject* obj,
             GParamSpec* pspec)
{
	g_return_if_fail (obj != NULL);
	g_return_if_fail (pspec != NULL);
	greeter_compositor_blur_manager_parse_mutter_hints (self, G_TYPE_CHECK_INSTANCE_CAST (obj, meta_window_get_type (), MetaWindow));
}

static void
___lambda26__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda26_ ((GreeterCompositorBlurManager*) self, _sender, pspec);
}

static void
_greeter_compositor_blur_manager___lambda25_ (GreeterCompositorBlurManager* self,
                                              MetaWindow* window)
{
	g_return_if_fail (window != NULL);
	g_signal_connect_object ((GObject*) window, "notify::mutter-hints", (GCallback) ___lambda26__g_object_notify, self, 0);
	greeter_compositor_blur_manager_parse_mutter_hints (self, window);
}

static void
__greeter_compositor_blur_manager___lambda25__meta_display_window_created (MetaDisplay* _sender,
                                                                           MetaWindow* object,
                                                                           gpointer self)
{
	_greeter_compositor_blur_manager___lambda25_ ((GreeterCompositorBlurManager*) self, object);
}

static GObject *
greeter_compositor_blur_manager_constructor (GType type,
                                             guint n_construct_properties,
                                             GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GreeterCompositorBlurManager * self;
	GreeterCompositorWindowManager* _tmp0_;
	MetaDisplay* _tmp1_;
	parent_class = G_OBJECT_CLASS (greeter_compositor_blur_manager_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GREETER_COMPOSITOR_TYPE_BLUR_MANAGER, GreeterCompositorBlurManager);
	_tmp0_ = self->priv->_wm;
	_tmp1_ = meta_plugin_get_display ((MetaPlugin*) _tmp0_);
	g_signal_connect_object (_tmp1_, "window-created", (GCallback) __greeter_compositor_blur_manager___lambda25__meta_display_window_created, self, 0);
	return obj;
}

static void
greeter_compositor_blur_manager_class_init (GreeterCompositorBlurManagerClass * klass,
                                            gpointer klass_data)
{
	greeter_compositor_blur_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GreeterCompositorBlurManager_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_greeter_compositor_blur_manager_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_greeter_compositor_blur_manager_set_property;
	G_OBJECT_CLASS (klass)->constructor = greeter_compositor_blur_manager_constructor;
	G_OBJECT_CLASS (klass)->finalize = greeter_compositor_blur_manager_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GREETER_COMPOSITOR_BLUR_MANAGER_WM_PROPERTY, greeter_compositor_blur_manager_properties[GREETER_COMPOSITOR_BLUR_MANAGER_WM_PROPERTY] = g_param_spec_object ("wm", "wm", "wm", GREETER_COMPOSITOR_TYPE_WINDOW_MANAGER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
greeter_compositor_blur_manager_instance_init (GreeterCompositorBlurManager * self,
                                               gpointer klass)
{
	GHashTable* _tmp0_;
	self->priv = greeter_compositor_blur_manager_get_instance_private (self);
	_tmp0_ = g_hash_table_new_full (NULL, NULL, _g_object_unref0_, _greeter_compositor_blur_manager_blur_data_free0_);
	self->priv->blurred_windows = _tmp0_;
}

static void
greeter_compositor_blur_manager_finalize (GObject * obj)
{
	GreeterCompositorBlurManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GREETER_COMPOSITOR_TYPE_BLUR_MANAGER, GreeterCompositorBlurManager);
	_g_object_unref0 (self->priv->_wm);
	_g_hash_table_unref0 (self->priv->blurred_windows);
	G_OBJECT_CLASS (greeter_compositor_blur_manager_parent_class)->finalize (obj);
}

static GType
greeter_compositor_blur_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GreeterCompositorBlurManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) greeter_compositor_blur_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GreeterCompositorBlurManager), 0, (GInstanceInitFunc) greeter_compositor_blur_manager_instance_init, NULL };
	GType greeter_compositor_blur_manager_type_id;
	greeter_compositor_blur_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "GreeterCompositorBlurManager", &g_define_type_info, 0);
	GreeterCompositorBlurManager_private_offset = g_type_add_instance_private (greeter_compositor_blur_manager_type_id, sizeof (GreeterCompositorBlurManagerPrivate));
	return greeter_compositor_blur_manager_type_id;
}

GType
greeter_compositor_blur_manager_get_type (void)
{
	static volatile gsize greeter_compositor_blur_manager_type_id__once = 0;
	if (g_once_init_enter (&greeter_compositor_blur_manager_type_id__once)) {
		GType greeter_compositor_blur_manager_type_id;
		greeter_compositor_blur_manager_type_id = greeter_compositor_blur_manager_get_type_once ();
		g_once_init_leave (&greeter_compositor_blur_manager_type_id__once, greeter_compositor_blur_manager_type_id);
	}
	return greeter_compositor_blur_manager_type_id__once;
}

static void
_vala_greeter_compositor_blur_manager_get_property (GObject * object,
                                                    guint property_id,
                                                    GValue * value,
                                                    GParamSpec * pspec)
{
	GreeterCompositorBlurManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GREETER_COMPOSITOR_TYPE_BLUR_MANAGER, GreeterCompositorBlurManager);
	switch (property_id) {
		case GREETER_COMPOSITOR_BLUR_MANAGER_WM_PROPERTY:
		g_value_set_object (value, greeter_compositor_blur_manager_get_wm (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_greeter_compositor_blur_manager_set_property (GObject * object,
                                                    guint property_id,
                                                    const GValue * value,
                                                    GParamSpec * pspec)
{
	GreeterCompositorBlurManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GREETER_COMPOSITOR_TYPE_BLUR_MANAGER, GreeterCompositorBlurManager);
	switch (property_id) {
		case GREETER_COMPOSITOR_BLUR_MANAGER_WM_PROPERTY:
		greeter_compositor_blur_manager_set_wm (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

