use gio::prelude::*;
use glib::Boxed;
use news_flash::models::PluginID;
use std::fmt;

#[derive(Clone, Debug, Eq, Boxed, Hash)]
#[boxed_type(name = "GPluginID")]
pub struct GPluginID(PluginID);

impl From<PluginID> for GPluginID {
    fn from(id: PluginID) -> Self {
        Self(id)
    }
}

impl AsRef<PluginID> for GPluginID {
    fn as_ref(&self) -> &PluginID {
        &self.0
    }
}

impl From<GPluginID> for PluginID {
    fn from(id: GPluginID) -> Self {
        id.0
    }
}

impl Default for GPluginID {
    fn default() -> Self {
        PluginID::from_owned(String::new()).into()
    }
}

impl ToVariant for GPluginID {
    fn to_variant(&self) -> glib::Variant {
        self.0.as_str().to_variant()
    }
}

impl FromVariant for GPluginID {
    fn from_variant(variant: &glib::Variant) -> Option<Self> {
        variant.str().map(PluginID::new).map(GPluginID::from)
    }
}

impl StaticVariantType for GPluginID {
    fn static_variant_type() -> std::borrow::Cow<'static, glib::VariantTy> {
        std::borrow::Cow::Borrowed(glib::VariantTy::STRING)
    }
}

impl fmt::Display for GPluginID {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
        write!(f, "{}", self.0)
    }
}

impl PartialEq for GPluginID {
    fn eq(&self, other: &GPluginID) -> bool {
        self.0 == other.0
    }
}
