/* Agent.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Agent.vala, do not modify */

/*-
 * Copyright (c) 2015-2016 elementary LLC.
 * Copyright (C) 2015-2016 Ikey Doherty <ikey@solus-project.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Adam Bieńkowski <donadigos159@gmail.com>
 */
/*
 * Code based on budgie-desktop:
 * https://github.com/solus-project/budgie-desktop
 */

#include <polkitagent/polkitagent.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <polkit/polkit.h>
#include <granite-7.h>
#include <gtk/gtk.h>
#include <pantheon-wayland.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define AG_TYPE_AGENT (ag_agent_get_type ())
#define AG_AGENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AG_TYPE_AGENT, AgAgent))
#define AG_AGENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AG_TYPE_AGENT, AgAgentClass))
#define AG_IS_AGENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AG_TYPE_AGENT))
#define AG_IS_AGENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AG_TYPE_AGENT))
#define AG_AGENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AG_TYPE_AGENT, AgAgentClass))

typedef struct _AgAgent AgAgent;
typedef struct _AgAgentClass AgAgentClass;
typedef struct _AgAgentPrivate AgAgentPrivate;
enum  {
	AG_AGENT_0_PROPERTY,
	AG_AGENT_NUM_PROPERTIES
};
static GParamSpec* ag_agent_properties[AG_AGENT_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block1Data Block1Data;

#define AG_TYPE_POLKIT_DIALOG (ag_polkit_dialog_get_type ())
#define AG_POLKIT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AG_TYPE_POLKIT_DIALOG, AgPolkitDialog))
#define AG_POLKIT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AG_TYPE_POLKIT_DIALOG, AgPolkitDialogClass))
#define AG_IS_POLKIT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AG_TYPE_POLKIT_DIALOG))
#define AG_IS_POLKIT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AG_TYPE_POLKIT_DIALOG))
#define AG_POLKIT_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AG_TYPE_POLKIT_DIALOG, AgPolkitDialogClass))

typedef struct _AgPolkitDialog AgPolkitDialog;
typedef struct _AgPolkitDialogClass AgPolkitDialogClass;
typedef struct _AgPolkitDialogPrivate AgPolkitDialogPrivate;
typedef struct _AgAgentInitiateAuthenticationData AgAgentInitiateAuthenticationData;

struct _AgAgent {
	PolkitAgentListener parent_instance;
	AgAgentPrivate * priv;
};

struct _AgAgentClass {
	PolkitAgentListenerClass parent_class;
};

struct _Block1Data {
	int _ref_count_;
	AgAgent* self;
	gpointer _async_data_;
};

struct _AgPolkitDialog {
	GraniteMessageDialog parent_instance;
	AgPolkitDialogPrivate * priv;
	gboolean was_canceled;
};

struct _AgPolkitDialogClass {
	GraniteMessageDialogClass parent_class;
};

struct _AgAgentInitiateAuthenticationData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	AgAgent* self;
	gchar* action_id;
	gchar* message;
	gchar* icon_name;
	PolkitDetails* details;
	gchar* cookie;
	GList* identities;
	GCancellable* cancellable;
	gboolean result;
	Block1Data* _data1_;
	AgPolkitDialog* dialog;
	AgPolkitDialog* _tmp0_;
	AgPolkitDialog* _tmp1_;
	AgPolkitDialog* _tmp2_;
	AgPolkitDialog* _tmp3_;
	AgPolkitDialog* _tmp4_;
	GError* _tmp5_;
	GError* _inner_error0_;
};

static gpointer ag_agent_parent_class = NULL;

VALA_EXTERN GType ag_agent_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AgAgent, g_object_unref)
static void ag_agent_real_initiate_authentication_data_free (gpointer _data);
static void ag_agent_real_initiate_authentication (PolkitAgentListener* base,
                                            const gchar* action_id,
                                            const gchar* message,
                                            const gchar* icon_name,
                                            PolkitDetails* details,
                                            const gchar* cookie,
                                            GList* identities,
                                            GCancellable* cancellable,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_);
static gboolean ag_agent_real_initiate_authentication_co (AgAgentInitiateAuthenticationData* _data_);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
VALA_EXTERN GType ag_polkit_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AgPolkitDialog, g_object_unref)
VALA_EXTERN AgPolkitDialog* ag_polkit_dialog_new (const gchar* message,
                                      const gchar* icon_name,
                                      const gchar* _cookie,
                                      GList* _idents,
                                      GCancellable* _cancellable);
VALA_EXTERN AgPolkitDialog* ag_polkit_dialog_construct (GType object_type,
                                            const gchar* message,
                                            const gchar* icon_name,
                                            const gchar* _cookie,
                                            GList* _idents,
                                            GCancellable* _cancellable);
static void __lambda8_ (Block1Data* _data1_);
static void ___lambda8__ag_polkit_dialog_done (AgPolkitDialog* _sender,
                                        gpointer self);
VALA_EXTERN AgAgent* ag_agent_new (void);
VALA_EXTERN AgAgent* ag_agent_construct (GType object_type);
static GType ag_agent_get_type_once (void);

static void
ag_agent_real_initiate_authentication_data_free (gpointer _data)
{
	AgAgentInitiateAuthenticationData* _data_;
	_data_ = _data;
	_g_free0 (_data_->action_id);
	_g_free0 (_data_->message);
	_g_free0 (_data_->icon_name);
	_g_object_unref0 (_data_->details);
	_g_free0 (_data_->cookie);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (AgAgentInitiateAuthenticationData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
ag_agent_real_initiate_authentication (PolkitAgentListener* base,
                                       const gchar* action_id,
                                       const gchar* message,
                                       const gchar* icon_name,
                                       PolkitDetails* details,
                                       const gchar* cookie,
                                       GList* identities,
                                       GCancellable* cancellable,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_)
{
	AgAgent * self;
	AgAgentInitiateAuthenticationData* _data_;
	AgAgent* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	PolkitDetails* _tmp4_;
	gchar* _tmp5_;
	GCancellable* _tmp6_;
	g_return_if_fail (action_id != NULL);
	g_return_if_fail (message != NULL);
	g_return_if_fail (icon_name != NULL);
	g_return_if_fail (details != NULL);
	g_return_if_fail (cookie != NULL);
	self = (AgAgent*) base;
	_data_ = g_slice_new0 (AgAgentInitiateAuthenticationData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, ag_agent_real_initiate_authentication_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (action_id);
	_g_free0 (_data_->action_id);
	_data_->action_id = _tmp1_;
	_tmp2_ = g_strdup (message);
	_g_free0 (_data_->message);
	_data_->message = _tmp2_;
	_tmp3_ = g_strdup (icon_name);
	_g_free0 (_data_->icon_name);
	_data_->icon_name = _tmp3_;
	_tmp4_ = _g_object_ref0 (details);
	_g_object_unref0 (_data_->details);
	_data_->details = _tmp4_;
	_tmp5_ = g_strdup (cookie);
	_g_free0 (_data_->cookie);
	_data_->cookie = _tmp5_;
	_data_->identities = identities;
	_tmp6_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp6_;
	ag_agent_real_initiate_authentication_co (_data_);
}

static gboolean
ag_agent_initiate_authentication_finish (PolkitAgentListener* base,
                                         GAsyncResult* _res_,
                                         GError** error)
{
	gboolean result;
	AgAgentInitiateAuthenticationData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		gboolean _tmp0_ = FALSE;
		return _tmp0_;
	}
	result = _data_->result;
	return result;
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		AgAgent* self;
		self = _data1_->self;
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static void
__lambda8_ (Block1Data* _data1_)
{
	AgAgent* self;
	self = _data1_->self;
	ag_agent_real_initiate_authentication_co (_data1_->_async_data_);
}

static void
___lambda8__ag_polkit_dialog_done (AgPolkitDialog* _sender,
                                   gpointer self)
{
	__lambda8_ (self);
}

static gboolean
ag_agent_real_initiate_authentication_co (AgAgentInitiateAuthenticationData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data1_ = g_slice_new0 (Block1Data);
	_data_->_data1_->_ref_count_ = 1;
	_data_->_data1_->self = g_object_ref (_data_->self);
	_data_->_data1_->_async_data_ = _data_;
	if (_data_->identities == NULL) {
		_data_->result = FALSE;
		block1_data_unref (_data_->_data1_);
		_data_->_data1_ = NULL;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp0_ = ag_polkit_dialog_new (_data_->message, _data_->icon_name, _data_->cookie, _data_->identities, _data_->cancellable);
	g_object_ref_sink (_data_->_tmp0_);
	_data_->dialog = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->dialog;
	g_signal_connect_data (_data_->_tmp1_, "done", (GCallback) ___lambda8__ag_polkit_dialog_done, block1_data_ref (_data_->_data1_), (GClosureNotify) block1_data_unref, 0);
	_data_->_tmp2_ = _data_->dialog;
	gtk_window_present ((GtkWindow*) _data_->_tmp2_);
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	_data_->_tmp3_ = _data_->dialog;
	gtk_window_destroy ((GtkWindow*) _data_->_tmp3_);
	_data_->_tmp4_ = _data_->dialog;
	if (_data_->_tmp4_->was_canceled) {
		_data_->_tmp5_ = g_error_new_literal (POLKIT_ERROR, POLKIT_ERROR_CANCELLED, "Authentication dialog was dismissed by the user");
		_data_->_inner_error0_ = _data_->_tmp5_;
		if (_data_->_inner_error0_->domain == POLKIT_ERROR) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->dialog);
			block1_data_unref (_data_->_data1_);
			_data_->_data1_ = NULL;
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (_data_->dialog);
			block1_data_unref (_data_->_data1_);
			_data_->_data1_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->result = TRUE;
	_g_object_unref0 (_data_->dialog);
	block1_data_unref (_data_->_data1_);
	_data_->_data1_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

AgAgent*
ag_agent_construct (GType object_type)
{
	AgAgent * self = NULL;
	self = (AgAgent*) g_object_new (object_type, NULL);
	return self;
}

AgAgent*
ag_agent_new (void)
{
	return ag_agent_construct (AG_TYPE_AGENT);
}

static void
ag_agent_class_init (AgAgentClass * klass,
                     gpointer klass_data)
{
	ag_agent_parent_class = g_type_class_peek_parent (klass);
	((PolkitAgentListenerClass *) klass)->initiate_authentication = (void (*) (PolkitAgentListener*, const gchar*, const gchar*, const gchar*, PolkitDetails*, const gchar*, GList*, GCancellable*, GAsyncReadyCallback, gpointer)) ag_agent_real_initiate_authentication;
	((PolkitAgentListenerClass *) klass)->initiate_authentication_finish = (gboolean (*) (PolkitAgentListener*, GAsyncResult*, GError**)) ag_agent_initiate_authentication_finish;
}

static void
ag_agent_instance_init (AgAgent * self,
                        gpointer klass)
{
}

static GType
ag_agent_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AgAgentClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ag_agent_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AgAgent), 0, (GInstanceInitFunc) ag_agent_instance_init, NULL };
	GType ag_agent_type_id;
	ag_agent_type_id = g_type_register_static (polkit_agent_listener_get_type (), "AgAgent", &g_define_type_info, 0);
	return ag_agent_type_id;
}

GType
ag_agent_get_type (void)
{
	static volatile gsize ag_agent_type_id__once = 0;
	if (g_once_init_enter (&ag_agent_type_id__once)) {
		GType ag_agent_type_id;
		ag_agent_type_id = ag_agent_get_type_once ();
		g_once_init_leave (&ag_agent_type_id__once, ag_agent_type_id);
	}
	return ag_agent_type_id__once;
}

