// python wrapper for vtkSMSettingsProxy
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkSMSettingsProxy.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkSMSettingsProxy(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkSMSettingsProxy_ClassNew(); }

#ifndef DECLARED_PyvtkSMProxy_ClassNew
extern "C" { PyObject *PyvtkSMProxy_ClassNew(); }
#define DECLARED_PyvtkSMProxy_ClassNew
#endif

static PyObject *
PyvtkSMSettingsProxy_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkSMSettingsProxy::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMSettingsProxy_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMSettingsProxy *op = static_cast<vtkSMSettingsProxy *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkSMSettingsProxy::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMSettingsProxy_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkSMSettingsProxy *tempr = vtkSMSettingsProxy::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMSettingsProxy_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMSettingsProxy *op = static_cast<vtkSMSettingsProxy *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkSMSettingsProxy *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkSMSettingsProxy::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMSettingsProxy_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkSMSettingsProxy::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMSettingsProxy_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMSettingsProxy *op = static_cast<vtkSMSettingsProxy *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkSMSettingsProxy::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMSettingsProxy_ReadXMLAttributes(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ReadXMLAttributes");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMSettingsProxy *op = static_cast<vtkSMSettingsProxy *>(vp);

  vtkSMSessionProxyManager *temp0 = nullptr;
  vtkPVXMLElement *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkSMSessionProxyManager") &&
      ap.GetVTKObject(temp1, "vtkPVXMLElement"))
  {
    int tempr = (ap.IsBound() ?
      op->ReadXMLAttributes(temp0, temp1) :
      op->vtkSMSettingsProxy::ReadXMLAttributes(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMSettingsProxy_ProcessPropertyLinks(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "ProcessPropertyLinks");

  vtkSMProxy *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMProxy"))
  {
    vtkSMSettingsProxy::ProcessPropertyLinks(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMSettingsProxy_AddLink(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AddLink");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMSettingsProxy *op = static_cast<vtkSMSettingsProxy *>(vp);

  const char *temp0 = nullptr;
  vtkSMProxy *temp1 = nullptr;
  const char *temp2 = nullptr;
  bool temp3 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(4) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkSMProxy") &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3))
  {
    if (ap.IsBound())
    {
      op->AddLink(temp0, temp1, temp2, temp3);
    }
    else
    {
      op->vtkSMSettingsProxy::AddLink(temp0, temp1, temp2, temp3);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMSettingsProxy_RemoveLink(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RemoveLink");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMSettingsProxy *op = static_cast<vtkSMSettingsProxy *>(vp);

  const char *temp0 = nullptr;
  vtkSMProxy *temp1 = nullptr;
  const char *temp2 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkSMProxy") &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->RemoveLink(temp0, temp1, temp2);
    }
    else
    {
      op->vtkSMSettingsProxy::RemoveLink(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMSettingsProxy_GetSourcePropertyName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSourcePropertyName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMSettingsProxy *op = static_cast<vtkSMSettingsProxy *>(vp);

  vtkSMProxy *temp0 = nullptr;
  const char *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetValue(temp1))
  {
    const char *tempr = (ap.IsBound() ?
      op->GetSourcePropertyName(temp0, temp1) :
      op->vtkSMSettingsProxy::GetSourcePropertyName(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMSettingsProxy_SaveLinksState(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SaveLinksState");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMSettingsProxy *op = static_cast<vtkSMSettingsProxy *>(vp);

  vtkPVXMLElement *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkPVXMLElement"))
  {
    if (ap.IsBound())
    {
      op->SaveLinksState(temp0);
    }
    else
    {
      op->vtkSMSettingsProxy::SaveLinksState(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMSettingsProxy_LoadLinksState(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "LoadLinksState");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMSettingsProxy *op = static_cast<vtkSMSettingsProxy *>(vp);

  vtkPVXMLElement *temp0 = nullptr;
  vtkSMProxyLocator *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkPVXMLElement") &&
      ap.GetVTKObject(temp1, "vtkSMProxyLocator"))
  {
    if (ap.IsBound())
    {
      op->LoadLinksState(temp0, temp1);
    }
    else
    {
      op->vtkSMSettingsProxy::LoadLinksState(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMSettingsProxy_SetIsSerializable(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetIsSerializable");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMSettingsProxy *op = static_cast<vtkSMSettingsProxy *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetIsSerializable(temp0);
    }
    else
    {
      op->vtkSMSettingsProxy::SetIsSerializable(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMSettingsProxy_GetIsSerializable(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetIsSerializable");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMSettingsProxy *op = static_cast<vtkSMSettingsProxy *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetIsSerializable() :
      op->vtkSMSettingsProxy::GetIsSerializable());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkSMSettingsProxy_Methods[] = {
  {"IsTypeOf", PyvtkSMSettingsProxy_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkSMSettingsProxy_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkSMSettingsProxy_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkSMSettingsProxy\nC++: static vtkSMSettingsProxy *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkSMSettingsProxy_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkSMSettingsProxy\nC++: vtkSMSettingsProxy *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkSMSettingsProxy_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkSMSettingsProxy_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"ReadXMLAttributes", PyvtkSMSettingsProxy_ReadXMLAttributes, METH_VARARGS,
   "ReadXMLAttributes(self, pm:vtkSMSessionProxyManager,\n    element:vtkPVXMLElement) -> int\nC++: int ReadXMLAttributes(vtkSMSessionProxyManager *pm,\n    vtkPVXMLElement *element) override;\n\nOverridden to link information properties with their\ncorresponding \"setter\" properties.\n"},
  {"ProcessPropertyLinks", PyvtkSMSettingsProxy_ProcessPropertyLinks, METH_VARARGS,
   "ProcessPropertyLinks(proxy:vtkSMProxy) -> None\nC++: static void ProcessPropertyLinks(vtkSMProxy *proxy)\n\nProcess property link hints on the given proxy.\n"},
  {"AddLink", PyvtkSMSettingsProxy_AddLink, METH_VARARGS,
   "AddLink(self, sourceProperty:str, target:vtkSMProxy,\n    targetProperty:str, unlink_if_modified:bool) -> None\nC++: void AddLink(const char *sourceProperty, vtkSMProxy *target,\n    const char *targetProperty, bool unlink_if_modified)\n\nAdd/Remove links. If `unlink_if_modified` is true, if a linked\nproperty on the target proxy is modified independently, then the\nlink is broken to avoid overriding the explicitly selected value.\n"},
  {"RemoveLink", PyvtkSMSettingsProxy_RemoveLink, METH_VARARGS,
   "RemoveLink(self, sourceProperty:str, target:vtkSMProxy,\n    targetProperty:str) -> None\nC++: void RemoveLink(const char *sourceProperty,\n    vtkSMProxy *target, const char *targetProperty)\n\n"},
  {"GetSourcePropertyName", PyvtkSMSettingsProxy_GetSourcePropertyName, METH_VARARGS,
   "GetSourcePropertyName(self, target:vtkSMProxy, targetProperty:str)\n     -> str\nC++: const char *GetSourcePropertyName(vtkSMProxy *target,\n    const char *targetProperty)\n\nReturns the name of the sourceProperty, if any, with which the\ntarget property is linked. Returns nullptr if no such link has\nbeen added.\n"},
  {"SaveLinksState", PyvtkSMSettingsProxy_SaveLinksState, METH_VARARGS,
   "SaveLinksState(self, root:vtkPVXMLElement) -> None\nC++: void SaveLinksState(vtkPVXMLElement *root)\n\nSave/Load the state for links registered with this settings\nproxy.\n"},
  {"LoadLinksState", PyvtkSMSettingsProxy_LoadLinksState, METH_VARARGS,
   "LoadLinksState(self, root:vtkPVXMLElement,\n    locator:vtkSMProxyLocator) -> None\nC++: void LoadLinksState(vtkPVXMLElement *root,\n    vtkSMProxyLocator *locator)\n\n"},
  {"SetIsSerializable", PyvtkSMSettingsProxy_SetIsSerializable, METH_VARARGS,
   "SetIsSerializable(self, _arg:bool) -> None\nC++: virtual void SetIsSerializable(bool _arg)\n\nGet/Set whether the settings proxy is serializable.\n"},
  {"GetIsSerializable", PyvtkSMSettingsProxy_GetIsSerializable, METH_VARARGS,
   "GetIsSerializable(self) -> bool\nC++: virtual bool GetIsSerializable()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkSMSettingsProxy_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("is_serializable"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMSettingsProxy_GetIsSerializable(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSMSettingsProxy_SetIsSerializable(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSMSettingsProxy_SetIsSerializable(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetIsSerializable/SetIsSerializable\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkSMSettingsProxy_Doc =
  "vtkSMSettingsProxy - proxy subclass responsible for linking settings\nproxies and settings classes on the VTK side.\n\n"
  "Superclass: vtkSMProxy\n\n"
  "Settings proxies are session specific singleton proxies designed to\n"
  "track configuration options. Typically, properties on such settings\n"
  "proxies are linked to other proxies in the session so that changing a\n"
  "setting property will result in changing all linked proxies.\n\n"
  "Settings proxies have several unique traits when compared with other\n"
  "properties:\n\n"
  "1. In `ReadXMLAttributes`, if for a property an\n"
  "   `information_property` attribute is specified i.e.\n"
  "   `vtkSMProperty::GetInformationProperty` is not null, then a link\n"
  "   is setup between that information property and the original\n"
  "   property so that if the information property is modified, the\n"
  "   original property is updated accordingly.\n"
  "2. Settings proxies may have an underlying vtkObject class that they\n"
  "   instantiate locally. In which case, the proxy observes\n"
  "   vtkCommand::ModifiedEvent on that VTK object and calls\n"
  "   `vtkSMProxy::UpdatePropertyInformation` on itself to ensure all\n"
  "   information properties are updated if the vtkObject changes.\n\n"
  "`vtkSMSettingsProxy::ProcessPropertyLinks` is called during proxy\n"
  "initialization (vtkSMParaViewPipelineController::PreInitializeProxy)\n"
  "to setup links between the proxy being initialized any of the\n"
  "settings proxies for that session. This is done by processing\n"
  "property hints on the proxy being initialized.\n\n"
  "@section SettingsAndStateFiles SettingsProxies and state files\n\n"
  "By default, settings proxies are not saved in the XML state files by\n"
  "`vtkSMSessionProxyManager::SaveXMLState`. This is so since settings\n"
  "proxies are often used for application settings to preserve across\n"
  "sessions rather than visualization state. However, there are\n"
  "exceptions. For example, color palettes which are handled using a\n"
  "settings proxy are part of the visualization state and hence should\n"
  "be saved in the XML state. For such settings proxies, one can add the\n"
  "`serializable=\"1\"` attribute in the proxy definition XML.\n\n"
  "{xml}\n"
  "  <SettingsProxy name=\"ColorPalette\" label=\"Color Palette\"\n"
  "serializable=\"1\">\n"
  "  ...\n"
  "  \n\n"
  "All settings proxies with this attribute will be saved in the XML\n"
  "state files.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkSMSettingsProxy_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingServerManager.vtkSMSettingsProxy", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkSMSettingsProxy_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkSMSettingsProxy_StaticNew()
{
  return vtkSMSettingsProxy::New();
}

PyObject *PyvtkSMSettingsProxy_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkSMSettingsProxy_Type, PyvtkSMSettingsProxy_Methods,
    "vtkSMSettingsProxy",
 &PyvtkSMSettingsProxy_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = (PyTypeObject *)PyvtkSMProxy_ClassNew();

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkSMSettingsProxy_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkSMSettingsProxy(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkSMSettingsProxy_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkSMSettingsProxy", o) != 0)
  {
    Py_DECREF(o);
  }

}

