/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.12.0
 *
 * Copyright (c) 2025 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt6.
 * 
 * This file may be used under the terms of the GNU General Public License
 * version 3.0 as published by the Free Software Foundation and appearing in
 * the file LICENSE included in the packaging of this file.  Please review the
 * following information to ensure the GNU General Public License version 3.0
 * requirements will be met: http://www.gnu.org/copyleft/gpl.html.
 * 
 * If you do not wish to use this file under the terms of the GPL version 3.0
 * then you may purchase a commercial license.  For more information contact
 * info@riverbankcomputing.com.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtBluetooth.h"

#line 26 "/build/pyqt6/src/pyqt6-6.9.1/sip/QtBluetooth/qpybluetooth_quint128.sip"
#include <qbluetoothuuid.h>
#line 29 "/build/pyqt6/src/pyqt6-6.9.1/build/QtBluetooth/sipQtBluetoothquint128.cpp"



extern "C" {static void assign_quint128(void *, Py_ssize_t, void *);}
static void assign_quint128(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::quint128 *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::quint128 *>(sipSrc);
}


extern "C" {static void *array_quint128(Py_ssize_t);}
static void *array_quint128(Py_ssize_t sipNrElem)
{
    return new ::quint128[sipNrElem];
}


extern "C" {static void *copy_quint128(const void *, Py_ssize_t);}
static void *copy_quint128(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new ::quint128(reinterpret_cast<const ::quint128 *>(sipSrc)[sipSrcIdx]);
}


/* Call the mapped type's destructor. */
extern "C" {static void release_quint128(void *, int, void *);}
static void release_quint128(void *sipCppV, int, void *)
{
    ::quint128 *sipCpp = reinterpret_cast< ::quint128 *>(sipCppV);
    delete sipCpp;
}



extern "C" {static int convertTo_quint128(PyObject *, void **, int *, PyObject *, void **);}
static int convertTo_quint128(PyObject *sipPy, void **sipCppPtrV, int *sipIsErr, PyObject *sipTransferObj, void **)
{
    ::quint128 **sipCppPtr = reinterpret_cast< ::quint128 **>(sipCppPtrV);

#line 65 "/build/pyqt6/src/pyqt6-6.9.1/sip/QtBluetooth/qpybluetooth_quint128.sip"
    if (!sipIsErr)
        return (PySequence_Check(sipPy) && !PyUnicode_Check(sipPy));

    Py_ssize_t len = PySequence_Size(sipPy);

    if (len != 16)
    {
        // A negative length should only be an internal error so let the
        // original exception stand.
        if (len >= 0)
            PyErr_Format(PyExc_TypeError,
                    "sequence has %zd elements but 16 elements are expected",
                    len);

        *sipIsErr = 1;

        return 0;
    }

    quint128 *qv = new quint128;

    for (Py_ssize_t i = 15; i >= 0; --i)
    {
        PyObject *itm = PySequence_GetItem(sipPy, i);

        if (!itm)
        {
            delete qv;
            *sipIsErr = 1;

            return 0;
        }

        PyErr_Clear();
        unsigned long val = PyLong_AsUnsignedLongMask(itm);

        if (PyErr_Occurred())
        {
            PyErr_Format(PyExc_TypeError,
                    "element %zd has type '%s' but 'int' is expected", i,
                    sipPyTypeName(Py_TYPE(itm)));

            Py_DECREF(itm);
            delete qv;
            *sipIsErr = 1;

            return 0;
        }

#if defined(QT_SUPPORTS_INT128)
        // This was added in Qt v6.6.0.
        (*qv) <<= 8;
        (*qv) |= (val & 255);
#else
        qv->data[i] = val;
#endif

        Py_DECREF(itm);
    }

    *sipCppPtr = qv;

    return sipGetState(sipTransferObj);
#line 133 "/build/pyqt6/src/pyqt6-6.9.1/build/QtBluetooth/sipQtBluetoothquint128.cpp"
}


extern "C" {static PyObject *convertFrom_quint128(void *, PyObject *);}
static PyObject *convertFrom_quint128(void *sipCppV, PyObject *)
{
    ::quint128 *sipCpp = reinterpret_cast< ::quint128 *>(sipCppV);

#line 30 "/build/pyqt6/src/pyqt6-6.9.1/sip/QtBluetooth/qpybluetooth_quint128.sip"
    PyObject *t = PyTuple_New(16);

    if (!t)
        return 0;

#if defined(QT_SUPPORTS_INT128)
    // This was added in Qt v6.6.0.
    quint128 value = *sipCpp;
#endif

    for (Py_ssize_t i = 0; i < 16; ++i)
    {
        // Convert to a Python long to make sure it doesn't get interpreted as
        // a signed value.
#if defined(QT_SUPPORTS_INT128)
        PyObject *pobj = PyLong_FromUnsignedLong(value & 255);
        value >>= 8;
#else
        PyObject *pobj = PyLong_FromUnsignedLong(sipCpp->data[i]);
#endif

        if (!pobj)
        {
            Py_DECREF(t);

            return 0;
        }

        PyTuple_SetItem(t, i, pobj);
    }

    return t;
#line 175 "/build/pyqt6/src/pyqt6-6.9.1/build/QtBluetooth/sipQtBluetoothquint128.cpp"
}


sipMappedTypeDef sipTypeDef_QtBluetooth_quint128 = {
    {
        SIP_NULLPTR,
        SIP_TYPE_MAPPED,
        sipNameNr_quint128,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        -1,
        {0, 0, 1},
        0, SIP_NULLPTR,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR}
    },
    assign_quint128,
    array_quint128,
    copy_quint128,
    release_quint128,
    convertTo_quint128,
    convertFrom_quint128
};
