/* This file is autogenerated by tracetool, do not edit. */
/* SPDX-License-Identifier: GPL-2.0-or-later */

#ifndef TRACE_HW_REMOTE_GENERATED_TRACERS_H
#define TRACE_HW_REMOTE_GENERATED_TRACERS_H

#include "trace/control.h"

extern TraceEvent _TRACE_MPQEMU_SEND_IO_ERROR_EVENT;
extern TraceEvent _TRACE_MPQEMU_RECV_IO_ERROR_EVENT;
extern TraceEvent _TRACE_VFU_PROP_EVENT;
extern TraceEvent _TRACE_VFU_CFG_READ_EVENT;
extern TraceEvent _TRACE_VFU_CFG_WRITE_EVENT;
extern TraceEvent _TRACE_VFU_DMA_REGISTER_EVENT;
extern TraceEvent _TRACE_VFU_DMA_UNREGISTER_EVENT;
extern TraceEvent _TRACE_VFU_BAR_REGISTER_EVENT;
extern TraceEvent _TRACE_VFU_BAR_RW_ENTER_EVENT;
extern TraceEvent _TRACE_VFU_BAR_RW_EXIT_EVENT;
extern TraceEvent _TRACE_VFU_INTERRUPT_EVENT;
extern uint16_t _TRACE_MPQEMU_SEND_IO_ERROR_DSTATE;
extern uint16_t _TRACE_MPQEMU_RECV_IO_ERROR_DSTATE;
extern uint16_t _TRACE_VFU_PROP_DSTATE;
extern uint16_t _TRACE_VFU_CFG_READ_DSTATE;
extern uint16_t _TRACE_VFU_CFG_WRITE_DSTATE;
extern uint16_t _TRACE_VFU_DMA_REGISTER_DSTATE;
extern uint16_t _TRACE_VFU_DMA_UNREGISTER_DSTATE;
extern uint16_t _TRACE_VFU_BAR_REGISTER_DSTATE;
extern uint16_t _TRACE_VFU_BAR_RW_ENTER_DSTATE;
extern uint16_t _TRACE_VFU_BAR_RW_EXIT_DSTATE;
extern uint16_t _TRACE_VFU_INTERRUPT_DSTATE;
#define TRACE_MPQEMU_SEND_IO_ERROR_ENABLED 1
#define TRACE_MPQEMU_RECV_IO_ERROR_ENABLED 1
#define TRACE_VFU_PROP_ENABLED 1
#define TRACE_VFU_CFG_READ_ENABLED 1
#define TRACE_VFU_CFG_WRITE_ENABLED 1
#define TRACE_VFU_DMA_REGISTER_ENABLED 1
#define TRACE_VFU_DMA_UNREGISTER_ENABLED 1
#define TRACE_VFU_BAR_REGISTER_ENABLED 1
#define TRACE_VFU_BAR_RW_ENTER_ENABLED 1
#define TRACE_VFU_BAR_RW_EXIT_ENABLED 1
#define TRACE_VFU_INTERRUPT_ENABLED 1
#include "qemu/log-for-trace.h"


#define TRACE_MPQEMU_SEND_IO_ERROR_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_MPQEMU_SEND_IO_ERROR) || \
    false)

static inline void trace_mpqemu_send_io_error(int cmd, int size, int nfds)
{
    if (trace_event_get_state(TRACE_MPQEMU_SEND_IO_ERROR)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 3 "../qemu-10.2.0/hw/remote/trace-events"
            qemu_log("mpqemu_send_io_error " "send command %d size %d, %d file descriptors to remote process" "\n", cmd, size, nfds);
#line 56 "trace/trace-hw_remote.h"
        }
    }
}

#define TRACE_MPQEMU_RECV_IO_ERROR_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_MPQEMU_RECV_IO_ERROR) || \
    false)

static inline void trace_mpqemu_recv_io_error(int cmd, int size, int nfds)
{
    if (trace_event_get_state(TRACE_MPQEMU_RECV_IO_ERROR)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 4 "../qemu-10.2.0/hw/remote/trace-events"
            qemu_log("mpqemu_recv_io_error " "failed to receive %d size %d, %d file descriptors to remote process" "\n", cmd, size, nfds);
#line 71 "trace/trace-hw_remote.h"
        }
    }
}

#define TRACE_VFU_PROP_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_VFU_PROP) || \
    false)

static inline void trace_vfu_prop(const char *prop, const char *val)
{
    if (trace_event_get_state(TRACE_VFU_PROP)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 7 "../qemu-10.2.0/hw/remote/trace-events"
            qemu_log("vfu_prop " "vfu: setting %s as %s" "\n", prop, val);
#line 86 "trace/trace-hw_remote.h"
        }
    }
}

#define TRACE_VFU_CFG_READ_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_VFU_CFG_READ) || \
    false)

static inline void trace_vfu_cfg_read(uint32_t offset, uint32_t val)
{
    if (trace_event_get_state(TRACE_VFU_CFG_READ)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 8 "../qemu-10.2.0/hw/remote/trace-events"
            qemu_log("vfu_cfg_read " "vfu: cfg: 0x%x -> 0x%x" "\n", offset, val);
#line 101 "trace/trace-hw_remote.h"
        }
    }
}

#define TRACE_VFU_CFG_WRITE_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_VFU_CFG_WRITE) || \
    false)

static inline void trace_vfu_cfg_write(uint32_t offset, uint32_t val)
{
    if (trace_event_get_state(TRACE_VFU_CFG_WRITE)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 9 "../qemu-10.2.0/hw/remote/trace-events"
            qemu_log("vfu_cfg_write " "vfu: cfg: 0x%x <- 0x%x" "\n", offset, val);
#line 116 "trace/trace-hw_remote.h"
        }
    }
}

#define TRACE_VFU_DMA_REGISTER_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_VFU_DMA_REGISTER) || \
    false)

static inline void trace_vfu_dma_register(uint64_t gpa, size_t len)
{
    if (trace_event_get_state(TRACE_VFU_DMA_REGISTER)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 10 "../qemu-10.2.0/hw/remote/trace-events"
            qemu_log("vfu_dma_register " "vfu: registering GPA 0x%"PRIx64", %zu bytes" "\n", gpa, len);
#line 131 "trace/trace-hw_remote.h"
        }
    }
}

#define TRACE_VFU_DMA_UNREGISTER_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_VFU_DMA_UNREGISTER) || \
    false)

static inline void trace_vfu_dma_unregister(uint64_t gpa)
{
    if (trace_event_get_state(TRACE_VFU_DMA_UNREGISTER)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 11 "../qemu-10.2.0/hw/remote/trace-events"
            qemu_log("vfu_dma_unregister " "vfu: unregistering GPA 0x%"PRIx64"" "\n", gpa);
#line 146 "trace/trace-hw_remote.h"
        }
    }
}

#define TRACE_VFU_BAR_REGISTER_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_VFU_BAR_REGISTER) || \
    false)

static inline void trace_vfu_bar_register(int i, uint64_t addr, uint64_t size)
{
    if (trace_event_get_state(TRACE_VFU_BAR_REGISTER)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 12 "../qemu-10.2.0/hw/remote/trace-events"
            qemu_log("vfu_bar_register " "vfu: BAR %d: addr 0x%"PRIx64" size 0x%"PRIx64"" "\n", i, addr, size);
#line 161 "trace/trace-hw_remote.h"
        }
    }
}

#define TRACE_VFU_BAR_RW_ENTER_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_VFU_BAR_RW_ENTER) || \
    false)

static inline void trace_vfu_bar_rw_enter(const char *op, uint64_t addr)
{
    if (trace_event_get_state(TRACE_VFU_BAR_RW_ENTER)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 13 "../qemu-10.2.0/hw/remote/trace-events"
            qemu_log("vfu_bar_rw_enter " "vfu: %s request for BAR address 0x%"PRIx64"" "\n", op, addr);
#line 176 "trace/trace-hw_remote.h"
        }
    }
}

#define TRACE_VFU_BAR_RW_EXIT_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_VFU_BAR_RW_EXIT) || \
    false)

static inline void trace_vfu_bar_rw_exit(const char *op, uint64_t addr)
{
    if (trace_event_get_state(TRACE_VFU_BAR_RW_EXIT)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 14 "../qemu-10.2.0/hw/remote/trace-events"
            qemu_log("vfu_bar_rw_exit " "vfu: Finished %s of BAR address 0x%"PRIx64"" "\n", op, addr);
#line 191 "trace/trace-hw_remote.h"
        }
    }
}

#define TRACE_VFU_INTERRUPT_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_VFU_INTERRUPT) || \
    false)

static inline void trace_vfu_interrupt(int pirq)
{
    if (trace_event_get_state(TRACE_VFU_INTERRUPT)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 15 "../qemu-10.2.0/hw/remote/trace-events"
            qemu_log("vfu_interrupt " "vfu: sending interrupt to device - PIRQ %d" "\n", pirq);
#line 206 "trace/trace-hw_remote.h"
        }
    }
}
#endif /* TRACE_HW_REMOTE_GENERATED_TRACERS_H */
