// content/common/agent_scheduling_group.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_COMMON_AGENT_SCHEDULING_GROUP_MOJOM_SHARED_H_
#define CONTENT_COMMON_AGENT_SCHEDULING_GROUP_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "content/common/agent_scheduling_group.mojom-shared-internal.h"
#include "content/common/document_scoped_interface_bundle.mojom-shared.h"
#include "content/common/native_types.mojom-shared.h"
#include "ipc/constants.mojom-shared.h"
#include "mojo/public/mojom/base/generic_pending_receiver.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/frame_owner_properties.mojom-shared.h"
#include "third_party/blink/public/mojom/page/page.mojom-shared.h"
#include "third_party/blink/public/mojom/page/widget.mojom-shared.h"
#include "third_party/blink/public/mojom/renderer_preferences.mojom-shared.h"
#include "third_party/blink/public/mojom/webpreferences/web_preferences.mojom-shared.h"
#include "third_party/blink/public/mojom/widget/visual_properties.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"


#include "mojo/public/cpp/bindings/native_enum.h"
#include "mojo/public/cpp/bindings/lib/native_struct_serialization.h"
#include "base/component_export.h"




namespace content {
namespace mojom {
class CreateViewParamsDataView;

class CreateFrameWidgetParamsDataView;

class CreateFrameParamsDataView;



}  // namespace mojom
}  // namespace content

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::content::mojom::CreateViewParamsDataView> {
  using Data = ::content::mojom::internal::CreateViewParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::content::mojom::CreateFrameWidgetParamsDataView> {
  using Data = ::content::mojom::internal::CreateFrameWidgetParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::content::mojom::CreateFrameParamsDataView> {
  using Data = ::content::mojom::internal::CreateFrameParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace content {
namespace mojom {


enum class ViewWidgetType : int32_t {
  
  kTopLevel = 0,
  
  kGuestView = 1,
  
  kPortal = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) std::ostream& operator<<(std::ostream& os, ViewWidgetType value);
inline bool IsKnownEnumValue(ViewWidgetType value) {
  return internal::ViewWidgetType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class AgentSchedulingGroupHostInterfaceBase {};

using AgentSchedulingGroupHostPtrDataView =
    mojo::InterfacePtrDataView<AgentSchedulingGroupHostInterfaceBase>;
using AgentSchedulingGroupHostRequestDataView =
    mojo::InterfaceRequestDataView<AgentSchedulingGroupHostInterfaceBase>;
using AgentSchedulingGroupHostAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<AgentSchedulingGroupHostInterfaceBase>;
using AgentSchedulingGroupHostAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<AgentSchedulingGroupHostInterfaceBase>;
class AgentSchedulingGroupInterfaceBase {};

using AgentSchedulingGroupPtrDataView =
    mojo::InterfacePtrDataView<AgentSchedulingGroupInterfaceBase>;
using AgentSchedulingGroupRequestDataView =
    mojo::InterfaceRequestDataView<AgentSchedulingGroupInterfaceBase>;
using AgentSchedulingGroupAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<AgentSchedulingGroupInterfaceBase>;
using AgentSchedulingGroupAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<AgentSchedulingGroupInterfaceBase>;


class CreateViewParamsDataView {
 public:
  CreateViewParamsDataView() {}

  CreateViewParamsDataView(
      internal::CreateViewParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetRendererPreferencesDataView(
      ::blink::mojom::RendererPreferencesDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadRendererPreferences(UserType* output) {
    
    auto* pointer = data_->renderer_preferences.Get();
    return mojo::internal::Deserialize<::blink::mojom::RendererPreferencesDataView>(
        pointer, output, context_);
  }
  inline void GetWebPreferencesDataView(
      ::blink::mojom::WebPreferencesDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadWebPreferences(UserType* output) {
    
    auto* pointer = data_->web_preferences.Get();
    return mojo::internal::Deserialize<::blink::mojom::WebPreferencesDataView>(
        pointer, output, context_);
  }
  int32_t view_id() const {
    return data_->view_id;
  }
  int32_t main_frame_routing_id() const {
    return data_->main_frame_routing_id;
  }
  int32_t main_frame_widget_routing_id() const {
    return data_->main_frame_widget_routing_id;
  }
  inline void GetMainFrameInterfaceBundleDataView(
      ::content::mojom::DocumentScopedInterfaceBundleDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadMainFrameInterfaceBundle(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::content::mojom::DocumentScopedInterfaceBundleDataView, UserType>(),
    "Attempting to read the optional `main_frame_interface_bundle` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadMainFrameInterfaceBundle` instead "
    "of `ReadMainFrameInterfaceBundle if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->main_frame_interface_bundle.Get();
    return mojo::internal::Deserialize<::content::mojom::DocumentScopedInterfaceBundleDataView>(
        pointer, output, context_);
  }
  template <typename UserType>
  UserType TakeFrameWidgetHost() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::blink::mojom::FrameWidgetHostAssociatedPtrInfoDataView>(
            &data_->frame_widget_host, &result, context_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeFrameWidget() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::blink::mojom::FrameWidgetAssociatedRequestDataView>(
            &data_->frame_widget, &result, context_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeWidgetHost() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::blink::mojom::WidgetHostAssociatedPtrInfoDataView>(
            &data_->widget_host, &result, context_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeWidget() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::blink::mojom::WidgetAssociatedRequestDataView>(
            &data_->widget, &result, context_);
    DCHECK(ret);
    return result;
  }
  inline void GetSessionStorageNamespaceIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadSessionStorageNamespaceId(UserType* output) {
    
    auto* pointer = data_->session_storage_namespace_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  inline void GetOpenerFrameTokenDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadOpenerFrameToken(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::UnguessableTokenDataView, UserType>(),
    "Attempting to read the optional `opener_frame_token` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadOpenerFrameToken` instead "
    "of `ReadOpenerFrameToken if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->opener_frame_token.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, context_);
  }
  inline void GetReplicatedFrameStateDataView(
      ::content::mojom::FrameReplicationStateDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadReplicatedFrameState(UserType* output) {
    
    auto* pointer = data_->replicated_frame_state.Get();
    return mojo::internal::Deserialize<::content::mojom::FrameReplicationStateDataView>(
        pointer, output, context_);
  }
  inline void GetMainFrameFrameTokenDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadMainFrameFrameToken(UserType* output) {
    
    auto* pointer = data_->main_frame_frame_token.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, context_);
  }
  inline void GetDevtoolsMainFrameTokenDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadDevtoolsMainFrameToken(UserType* output) {
    
    auto* pointer = data_->devtools_main_frame_token.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, context_);
  }
  int32_t proxy_routing_id() const {
    return data_->proxy_routing_id;
  }
  bool hidden() const {
    return data_->hidden;
  }
  bool never_composited() const {
    return data_->never_composited;
  }
  bool window_was_created_with_opener() const {
    return data_->window_was_created_with_opener;
  }
  bool has_committed_real_load() const {
    return data_->has_committed_real_load;
  }
  inline void GetVisualPropertiesDataView(
      ::blink::mojom::VisualPropertiesDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadVisualProperties(UserType* output) {
    
    auto* pointer = data_->visual_properties.Get();
    return mojo::internal::Deserialize<::blink::mojom::VisualPropertiesDataView>(
        pointer, output, context_);
  }
  bool renderer_wide_named_frame_lookup() const {
    return data_->renderer_wide_named_frame_lookup;
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::content::mojom::ViewWidgetType>(
        data_value, output);
  }

  ViewWidgetType type() const {
    return static_cast<ViewWidgetType>(data_->type);
  }
  template <typename UserType>
  UserType TakeBlinkPageBroadcast() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::blink::mojom::PageBroadcastAssociatedRequestDataView>(
            &data_->blink_page_broadcast, &result, context_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::CreateViewParams_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class CreateFrameWidgetParamsDataView {
 public:
  CreateFrameWidgetParamsDataView() {}

  CreateFrameWidgetParamsDataView(
      internal::CreateFrameWidgetParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  int32_t routing_id() const {
    return data_->routing_id;
  }
  template <typename UserType>
  UserType TakeFrameWidgetHost() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::blink::mojom::FrameWidgetHostAssociatedPtrInfoDataView>(
            &data_->frame_widget_host, &result, context_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeFrameWidget() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::blink::mojom::FrameWidgetAssociatedRequestDataView>(
            &data_->frame_widget, &result, context_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeWidgetHost() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::blink::mojom::WidgetHostAssociatedPtrInfoDataView>(
            &data_->widget_host, &result, context_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeWidget() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::blink::mojom::WidgetAssociatedRequestDataView>(
            &data_->widget, &result, context_);
    DCHECK(ret);
    return result;
  }
  inline void GetVisualPropertiesDataView(
      ::blink::mojom::VisualPropertiesDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadVisualProperties(UserType* output) {
    
    auto* pointer = data_->visual_properties.Get();
    return mojo::internal::Deserialize<::blink::mojom::VisualPropertiesDataView>(
        pointer, output, context_);
  }
 private:
  internal::CreateFrameWidgetParams_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class CreateFrameParamsDataView {
 public:
  CreateFrameParamsDataView() {}

  CreateFrameParamsDataView(
      internal::CreateFrameParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  int32_t routing_id() const {
    return data_->routing_id;
  }
  int32_t previous_routing_id() const {
    return data_->previous_routing_id;
  }
  inline void GetFrameTokenDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadFrameToken(UserType* output) {
    
    auto* pointer = data_->frame_token.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, context_);
  }
  inline void GetOpenerFrameTokenDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadOpenerFrameToken(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::UnguessableTokenDataView, UserType>(),
    "Attempting to read the optional `opener_frame_token` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadOpenerFrameToken` instead "
    "of `ReadOpenerFrameToken if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->opener_frame_token.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, context_);
  }
  int32_t parent_routing_id() const {
    return data_->parent_routing_id;
  }
  int32_t previous_sibling_routing_id() const {
    return data_->previous_sibling_routing_id;
  }
  inline void GetInterfaceBundleDataView(
      ::content::mojom::DocumentScopedInterfaceBundleDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadInterfaceBundle(UserType* output) {
    
    auto* pointer = data_->interface_bundle.Get();
    return mojo::internal::Deserialize<::content::mojom::DocumentScopedInterfaceBundleDataView>(
        pointer, output, context_);
  }
  inline void GetReplicationStateDataView(
      ::content::mojom::FrameReplicationStateDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadReplicationState(UserType* output) {
    
    auto* pointer = data_->replication_state.Get();
    return mojo::internal::Deserialize<::content::mojom::FrameReplicationStateDataView>(
        pointer, output, context_);
  }
  inline void GetDevtoolsFrameTokenDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadDevtoolsFrameToken(UserType* output) {
    
    auto* pointer = data_->devtools_frame_token.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, context_);
  }
  inline void GetFrameOwnerPropertiesDataView(
      ::blink::mojom::FrameOwnerPropertiesDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadFrameOwnerProperties(UserType* output) {
    
    auto* pointer = data_->frame_owner_properties.Get();
    return mojo::internal::Deserialize<::blink::mojom::FrameOwnerPropertiesDataView>(
        pointer, output, context_);
  }
  inline void GetWidgetParamsDataView(
      CreateFrameWidgetParamsDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadWidgetParams(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::content::mojom::CreateFrameWidgetParamsDataView, UserType>(),
    "Attempting to read the optional `widget_params` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadWidgetParams` instead "
    "of `ReadWidgetParams if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->widget_params.Get();
    return mojo::internal::Deserialize<::content::mojom::CreateFrameWidgetParamsDataView>(
        pointer, output, context_);
  }
  bool has_committed_real_load() const {
    return data_->has_committed_real_load;
  }
 private:
  internal::CreateFrameParams_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace content

namespace std {

template <>
struct hash<::content::mojom::ViewWidgetType>
    : public mojo::internal::EnumHashImpl<::content::mojom::ViewWidgetType> {};

}  // namespace std

namespace mojo {


template <>
struct EnumTraits<::content::mojom::ViewWidgetType, ::content::mojom::ViewWidgetType> {
  static ::content::mojom::ViewWidgetType ToMojom(::content::mojom::ViewWidgetType input) { return input; }
  static bool FromMojom(::content::mojom::ViewWidgetType input, ::content::mojom::ViewWidgetType* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::content::mojom::ViewWidgetType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::content::mojom::ViewWidgetType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::content::mojom::ViewWidgetType>(input), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::content::mojom::CreateViewParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::content::mojom::CreateViewParamsDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::content::mojom::internal::CreateViewParams_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::renderer_preferences(input)) in_renderer_preferences = Traits::renderer_preferences(input);
    typename decltype((*output)->renderer_preferences)::BaseType::BufferWriter
        renderer_preferences_writer;
    mojo::internal::Serialize<::blink::mojom::RendererPreferencesDataView>(
        in_renderer_preferences, buffer, &renderer_preferences_writer, context);
    (*output)->renderer_preferences.Set(
        renderer_preferences_writer.is_null() ? nullptr : renderer_preferences_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->renderer_preferences.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null renderer_preferences in CreateViewParams struct");
    decltype(Traits::web_preferences(input)) in_web_preferences = Traits::web_preferences(input);
    typename decltype((*output)->web_preferences)::BaseType::BufferWriter
        web_preferences_writer;
    mojo::internal::Serialize<::blink::mojom::WebPreferencesDataView>(
        in_web_preferences, buffer, &web_preferences_writer, context);
    (*output)->web_preferences.Set(
        web_preferences_writer.is_null() ? nullptr : web_preferences_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->web_preferences.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null web_preferences in CreateViewParams struct");
    (*output)->view_id = Traits::view_id(input);
    (*output)->main_frame_routing_id = Traits::main_frame_routing_id(input);
    (*output)->main_frame_widget_routing_id = Traits::main_frame_widget_routing_id(input);
    decltype(Traits::main_frame_interface_bundle(input)) in_main_frame_interface_bundle = Traits::main_frame_interface_bundle(input);
    typename decltype((*output)->main_frame_interface_bundle)::BaseType::BufferWriter
        main_frame_interface_bundle_writer;
    mojo::internal::Serialize<::content::mojom::DocumentScopedInterfaceBundleDataView>(
        in_main_frame_interface_bundle, buffer, &main_frame_interface_bundle_writer, context);
    (*output)->main_frame_interface_bundle.Set(
        main_frame_interface_bundle_writer.is_null() ? nullptr : main_frame_interface_bundle_writer.data());
    decltype(Traits::frame_widget_host(input)) in_frame_widget_host = Traits::frame_widget_host(input);
    mojo::internal::Serialize<::blink::mojom::FrameWidgetHostAssociatedPtrInfoDataView>(
        in_frame_widget_host, &(*output)->frame_widget_host, context);
    decltype(Traits::frame_widget(input)) in_frame_widget = Traits::frame_widget(input);
    mojo::internal::Serialize<::blink::mojom::FrameWidgetAssociatedRequestDataView>(
        in_frame_widget, &(*output)->frame_widget, context);
    decltype(Traits::widget_host(input)) in_widget_host = Traits::widget_host(input);
    mojo::internal::Serialize<::blink::mojom::WidgetHostAssociatedPtrInfoDataView>(
        in_widget_host, &(*output)->widget_host, context);
    decltype(Traits::widget(input)) in_widget = Traits::widget(input);
    mojo::internal::Serialize<::blink::mojom::WidgetAssociatedRequestDataView>(
        in_widget, &(*output)->widget, context);
    decltype(Traits::session_storage_namespace_id(input)) in_session_storage_namespace_id = Traits::session_storage_namespace_id(input);
    typename decltype((*output)->session_storage_namespace_id)::BaseType::BufferWriter
        session_storage_namespace_id_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_session_storage_namespace_id, buffer, &session_storage_namespace_id_writer, context);
    (*output)->session_storage_namespace_id.Set(
        session_storage_namespace_id_writer.is_null() ? nullptr : session_storage_namespace_id_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->session_storage_namespace_id.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null session_storage_namespace_id in CreateViewParams struct");
    decltype(Traits::opener_frame_token(input)) in_opener_frame_token = Traits::opener_frame_token(input);
    typename decltype((*output)->opener_frame_token)::BaseType::BufferWriter
        opener_frame_token_writer;
    mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
        in_opener_frame_token, buffer, &opener_frame_token_writer, context);
    (*output)->opener_frame_token.Set(
        opener_frame_token_writer.is_null() ? nullptr : opener_frame_token_writer.data());
    decltype(Traits::replicated_frame_state(input)) in_replicated_frame_state = Traits::replicated_frame_state(input);
    typename decltype((*output)->replicated_frame_state)::BaseType::BufferWriter
        replicated_frame_state_writer;
    mojo::internal::Serialize<::content::mojom::FrameReplicationStateDataView>(
        in_replicated_frame_state, buffer, &replicated_frame_state_writer, context);
    (*output)->replicated_frame_state.Set(
        replicated_frame_state_writer.is_null() ? nullptr : replicated_frame_state_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->replicated_frame_state.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null replicated_frame_state in CreateViewParams struct");
    decltype(Traits::main_frame_frame_token(input)) in_main_frame_frame_token = Traits::main_frame_frame_token(input);
    typename decltype((*output)->main_frame_frame_token)::BaseType::BufferWriter
        main_frame_frame_token_writer;
    mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
        in_main_frame_frame_token, buffer, &main_frame_frame_token_writer, context);
    (*output)->main_frame_frame_token.Set(
        main_frame_frame_token_writer.is_null() ? nullptr : main_frame_frame_token_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->main_frame_frame_token.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null main_frame_frame_token in CreateViewParams struct");
    decltype(Traits::devtools_main_frame_token(input)) in_devtools_main_frame_token = Traits::devtools_main_frame_token(input);
    typename decltype((*output)->devtools_main_frame_token)::BaseType::BufferWriter
        devtools_main_frame_token_writer;
    mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
        in_devtools_main_frame_token, buffer, &devtools_main_frame_token_writer, context);
    (*output)->devtools_main_frame_token.Set(
        devtools_main_frame_token_writer.is_null() ? nullptr : devtools_main_frame_token_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->devtools_main_frame_token.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null devtools_main_frame_token in CreateViewParams struct");
    (*output)->proxy_routing_id = Traits::proxy_routing_id(input);
    (*output)->hidden = Traits::hidden(input);
    (*output)->never_composited = Traits::never_composited(input);
    (*output)->window_was_created_with_opener = Traits::window_was_created_with_opener(input);
    (*output)->has_committed_real_load = Traits::has_committed_real_load(input);
    decltype(Traits::visual_properties(input)) in_visual_properties = Traits::visual_properties(input);
    typename decltype((*output)->visual_properties)::BaseType::BufferWriter
        visual_properties_writer;
    mojo::internal::Serialize<::blink::mojom::VisualPropertiesDataView>(
        in_visual_properties, buffer, &visual_properties_writer, context);
    (*output)->visual_properties.Set(
        visual_properties_writer.is_null() ? nullptr : visual_properties_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->visual_properties.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null visual_properties in CreateViewParams struct");
    (*output)->renderer_wide_named_frame_lookup = Traits::renderer_wide_named_frame_lookup(input);
    mojo::internal::Serialize<::content::mojom::ViewWidgetType>(
        Traits::type(input), &(*output)->type);
    decltype(Traits::blink_page_broadcast(input)) in_blink_page_broadcast = Traits::blink_page_broadcast(input);
    mojo::internal::Serialize<::blink::mojom::PageBroadcastAssociatedRequestDataView>(
        in_blink_page_broadcast, &(*output)->blink_page_broadcast, context);
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        !mojo::internal::IsHandleOrInterfaceValid((*output)->blink_page_broadcast),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
        "invalid blink_page_broadcast in CreateViewParams struct");
  }

  static bool Deserialize(::content::mojom::internal::CreateViewParams_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::content::mojom::CreateViewParamsDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::content::mojom::CreateFrameWidgetParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::content::mojom::CreateFrameWidgetParamsDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::content::mojom::internal::CreateFrameWidgetParams_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    (*output)->routing_id = Traits::routing_id(input);
    decltype(Traits::frame_widget_host(input)) in_frame_widget_host = Traits::frame_widget_host(input);
    mojo::internal::Serialize<::blink::mojom::FrameWidgetHostAssociatedPtrInfoDataView>(
        in_frame_widget_host, &(*output)->frame_widget_host, context);
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        !mojo::internal::IsHandleOrInterfaceValid((*output)->frame_widget_host),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
        "invalid frame_widget_host in CreateFrameWidgetParams struct");
    decltype(Traits::frame_widget(input)) in_frame_widget = Traits::frame_widget(input);
    mojo::internal::Serialize<::blink::mojom::FrameWidgetAssociatedRequestDataView>(
        in_frame_widget, &(*output)->frame_widget, context);
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        !mojo::internal::IsHandleOrInterfaceValid((*output)->frame_widget),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
        "invalid frame_widget in CreateFrameWidgetParams struct");
    decltype(Traits::widget_host(input)) in_widget_host = Traits::widget_host(input);
    mojo::internal::Serialize<::blink::mojom::WidgetHostAssociatedPtrInfoDataView>(
        in_widget_host, &(*output)->widget_host, context);
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        !mojo::internal::IsHandleOrInterfaceValid((*output)->widget_host),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
        "invalid widget_host in CreateFrameWidgetParams struct");
    decltype(Traits::widget(input)) in_widget = Traits::widget(input);
    mojo::internal::Serialize<::blink::mojom::WidgetAssociatedRequestDataView>(
        in_widget, &(*output)->widget, context);
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        !mojo::internal::IsHandleOrInterfaceValid((*output)->widget),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
        "invalid widget in CreateFrameWidgetParams struct");
    decltype(Traits::visual_properties(input)) in_visual_properties = Traits::visual_properties(input);
    typename decltype((*output)->visual_properties)::BaseType::BufferWriter
        visual_properties_writer;
    mojo::internal::Serialize<::blink::mojom::VisualPropertiesDataView>(
        in_visual_properties, buffer, &visual_properties_writer, context);
    (*output)->visual_properties.Set(
        visual_properties_writer.is_null() ? nullptr : visual_properties_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->visual_properties.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null visual_properties in CreateFrameWidgetParams struct");
  }

  static bool Deserialize(::content::mojom::internal::CreateFrameWidgetParams_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::content::mojom::CreateFrameWidgetParamsDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::content::mojom::CreateFrameParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::content::mojom::CreateFrameParamsDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::content::mojom::internal::CreateFrameParams_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    (*output)->routing_id = Traits::routing_id(input);
    (*output)->previous_routing_id = Traits::previous_routing_id(input);
    decltype(Traits::frame_token(input)) in_frame_token = Traits::frame_token(input);
    typename decltype((*output)->frame_token)::BaseType::BufferWriter
        frame_token_writer;
    mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
        in_frame_token, buffer, &frame_token_writer, context);
    (*output)->frame_token.Set(
        frame_token_writer.is_null() ? nullptr : frame_token_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->frame_token.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null frame_token in CreateFrameParams struct");
    decltype(Traits::opener_frame_token(input)) in_opener_frame_token = Traits::opener_frame_token(input);
    typename decltype((*output)->opener_frame_token)::BaseType::BufferWriter
        opener_frame_token_writer;
    mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
        in_opener_frame_token, buffer, &opener_frame_token_writer, context);
    (*output)->opener_frame_token.Set(
        opener_frame_token_writer.is_null() ? nullptr : opener_frame_token_writer.data());
    (*output)->parent_routing_id = Traits::parent_routing_id(input);
    (*output)->previous_sibling_routing_id = Traits::previous_sibling_routing_id(input);
    decltype(Traits::interface_bundle(input)) in_interface_bundle = Traits::interface_bundle(input);
    typename decltype((*output)->interface_bundle)::BaseType::BufferWriter
        interface_bundle_writer;
    mojo::internal::Serialize<::content::mojom::DocumentScopedInterfaceBundleDataView>(
        in_interface_bundle, buffer, &interface_bundle_writer, context);
    (*output)->interface_bundle.Set(
        interface_bundle_writer.is_null() ? nullptr : interface_bundle_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->interface_bundle.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null interface_bundle in CreateFrameParams struct");
    decltype(Traits::replication_state(input)) in_replication_state = Traits::replication_state(input);
    typename decltype((*output)->replication_state)::BaseType::BufferWriter
        replication_state_writer;
    mojo::internal::Serialize<::content::mojom::FrameReplicationStateDataView>(
        in_replication_state, buffer, &replication_state_writer, context);
    (*output)->replication_state.Set(
        replication_state_writer.is_null() ? nullptr : replication_state_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->replication_state.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null replication_state in CreateFrameParams struct");
    decltype(Traits::devtools_frame_token(input)) in_devtools_frame_token = Traits::devtools_frame_token(input);
    typename decltype((*output)->devtools_frame_token)::BaseType::BufferWriter
        devtools_frame_token_writer;
    mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
        in_devtools_frame_token, buffer, &devtools_frame_token_writer, context);
    (*output)->devtools_frame_token.Set(
        devtools_frame_token_writer.is_null() ? nullptr : devtools_frame_token_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->devtools_frame_token.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null devtools_frame_token in CreateFrameParams struct");
    decltype(Traits::frame_owner_properties(input)) in_frame_owner_properties = Traits::frame_owner_properties(input);
    typename decltype((*output)->frame_owner_properties)::BaseType::BufferWriter
        frame_owner_properties_writer;
    mojo::internal::Serialize<::blink::mojom::FrameOwnerPropertiesDataView>(
        in_frame_owner_properties, buffer, &frame_owner_properties_writer, context);
    (*output)->frame_owner_properties.Set(
        frame_owner_properties_writer.is_null() ? nullptr : frame_owner_properties_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->frame_owner_properties.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null frame_owner_properties in CreateFrameParams struct");
    decltype(Traits::widget_params(input)) in_widget_params = Traits::widget_params(input);
    typename decltype((*output)->widget_params)::BaseType::BufferWriter
        widget_params_writer;
    mojo::internal::Serialize<::content::mojom::CreateFrameWidgetParamsDataView>(
        in_widget_params, buffer, &widget_params_writer, context);
    (*output)->widget_params.Set(
        widget_params_writer.is_null() ? nullptr : widget_params_writer.data());
    (*output)->has_committed_real_load = Traits::has_committed_real_load(input);
  }

  static bool Deserialize(::content::mojom::internal::CreateFrameParams_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::content::mojom::CreateFrameParamsDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace content {
namespace mojom {

inline void CreateViewParamsDataView::GetRendererPreferencesDataView(
    ::blink::mojom::RendererPreferencesDataView* output) {
  auto pointer = data_->renderer_preferences.Get();
  *output = ::blink::mojom::RendererPreferencesDataView(pointer, context_);
}
inline void CreateViewParamsDataView::GetWebPreferencesDataView(
    ::blink::mojom::WebPreferencesDataView* output) {
  auto pointer = data_->web_preferences.Get();
  *output = ::blink::mojom::WebPreferencesDataView(pointer, context_);
}
inline void CreateViewParamsDataView::GetMainFrameInterfaceBundleDataView(
    ::content::mojom::DocumentScopedInterfaceBundleDataView* output) {
  auto pointer = data_->main_frame_interface_bundle.Get();
  *output = ::content::mojom::DocumentScopedInterfaceBundleDataView(pointer, context_);
}
inline void CreateViewParamsDataView::GetSessionStorageNamespaceIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->session_storage_namespace_id.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void CreateViewParamsDataView::GetOpenerFrameTokenDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->opener_frame_token.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, context_);
}
inline void CreateViewParamsDataView::GetReplicatedFrameStateDataView(
    ::content::mojom::FrameReplicationStateDataView* output) {
  auto pointer = data_->replicated_frame_state.Get();
  *output = ::content::mojom::FrameReplicationStateDataView(pointer, context_);
}
inline void CreateViewParamsDataView::GetMainFrameFrameTokenDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->main_frame_frame_token.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, context_);
}
inline void CreateViewParamsDataView::GetDevtoolsMainFrameTokenDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->devtools_main_frame_token.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, context_);
}
inline void CreateViewParamsDataView::GetVisualPropertiesDataView(
    ::blink::mojom::VisualPropertiesDataView* output) {
  auto pointer = data_->visual_properties.Get();
  *output = ::blink::mojom::VisualPropertiesDataView(pointer, context_);
}


inline void CreateFrameWidgetParamsDataView::GetVisualPropertiesDataView(
    ::blink::mojom::VisualPropertiesDataView* output) {
  auto pointer = data_->visual_properties.Get();
  *output = ::blink::mojom::VisualPropertiesDataView(pointer, context_);
}


inline void CreateFrameParamsDataView::GetFrameTokenDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->frame_token.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, context_);
}
inline void CreateFrameParamsDataView::GetOpenerFrameTokenDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->opener_frame_token.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, context_);
}
inline void CreateFrameParamsDataView::GetInterfaceBundleDataView(
    ::content::mojom::DocumentScopedInterfaceBundleDataView* output) {
  auto pointer = data_->interface_bundle.Get();
  *output = ::content::mojom::DocumentScopedInterfaceBundleDataView(pointer, context_);
}
inline void CreateFrameParamsDataView::GetReplicationStateDataView(
    ::content::mojom::FrameReplicationStateDataView* output) {
  auto pointer = data_->replication_state.Get();
  *output = ::content::mojom::FrameReplicationStateDataView(pointer, context_);
}
inline void CreateFrameParamsDataView::GetDevtoolsFrameTokenDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->devtools_frame_token.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, context_);
}
inline void CreateFrameParamsDataView::GetFrameOwnerPropertiesDataView(
    ::blink::mojom::FrameOwnerPropertiesDataView* output) {
  auto pointer = data_->frame_owner_properties.Get();
  *output = ::blink::mojom::FrameOwnerPropertiesDataView(pointer, context_);
}
inline void CreateFrameParamsDataView::GetWidgetParamsDataView(
    CreateFrameWidgetParamsDataView* output) {
  auto pointer = data_->widget_params.Get();
  *output = CreateFrameWidgetParamsDataView(pointer, context_);
}



}  // namespace mojom
}  // namespace content

#endif  // CONTENT_COMMON_AGENT_SCHEDULING_GROUP_MOJOM_SHARED_H_