// content/common/renderer.mojom-shared-internal.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_COMMON_RENDERER_MOJOM_SHARED_INTERNAL_H_
#define CONTENT_COMMON_RENDERER_MOJOM_SHARED_INTERNAL_H_

#include "mojo/public/cpp/bindings/lib/array_internal.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/map_data_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"
#include "content/common/agent_scheduling_group.mojom-shared-internal.h"
#include "content/common/native_types.mojom-shared-internal.h"
#include "mojo/public/mojom/base/generic_pending_receiver.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared-internal.h"
#include "services/network/public/mojom/network_types.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/user_agent/user_agent_metadata.mojom-shared-internal.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/native_enum_data.h"
#include "mojo/public/interfaces/bindings/native_struct.mojom-shared-internal.h"
#include "base/component_export.h"



namespace mojo {
namespace internal {
class ValidationContext;
}
}
namespace content {
namespace mojom {
namespace internal {
class UpdateScrollbarThemeParams_Data;
class UpdateSystemColorInfoParams_Data;

struct RenderProcessBackgroundState_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct RenderProcessVisibleState_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

#pragma pack(push, 1)
class COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) UpdateScrollbarThemeParams_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(UpdateScrollbarThemeParams_Data));
      new (data()) UpdateScrollbarThemeParams_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    UpdateScrollbarThemeParams_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<UpdateScrollbarThemeParams_Data>(index_);
    }
    UpdateScrollbarThemeParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t has_initial_button_delay : 1;
  uint8_t has_autoscroll_button_delay : 1;
  uint8_t jump_on_track_click : 1;
  uint8_t redraw : 1;
  uint8_t scroll_view_rubber_banding : 1;
  uint8_t pad4_[3];
  float initial_button_delay;
  float autoscroll_button_delay;
  int32_t preferred_scroller_style;

 private:
  UpdateScrollbarThemeParams_Data();
  ~UpdateScrollbarThemeParams_Data() = delete;
};
static_assert(sizeof(UpdateScrollbarThemeParams_Data) == 24,
              "Bad sizeof(UpdateScrollbarThemeParams_Data)");
// Used by UpdateScrollbarThemeParams::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct UpdateScrollbarThemeParams_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  UpdateScrollbarThemeParams_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~UpdateScrollbarThemeParams_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    UpdateScrollbarThemeParams_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    UpdateScrollbarThemeParams_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) UpdateSystemColorInfoParams_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(UpdateSystemColorInfoParams_Data));
      new (data()) UpdateSystemColorInfoParams_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    UpdateSystemColorInfoParams_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<UpdateSystemColorInfoParams_Data>(index_);
    }
    UpdateSystemColorInfoParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t is_dark_mode : 1;
  uint8_t is_high_contrast : 1;
  uint8_t pad1_[7];
  mojo::internal::Pointer<mojo::internal::Map_Data<int32_t, uint32_t>> colors;

 private:
  UpdateSystemColorInfoParams_Data();
  ~UpdateSystemColorInfoParams_Data() = delete;
};
static_assert(sizeof(UpdateSystemColorInfoParams_Data) == 24,
              "Bad sizeof(UpdateSystemColorInfoParams_Data)");
// Used by UpdateSystemColorInfoParams::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct UpdateSystemColorInfoParams_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  UpdateSystemColorInfoParams_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~UpdateSystemColorInfoParams_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    UpdateSystemColorInfoParams_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    UpdateSystemColorInfoParams_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};

#pragma pack(pop)

}  // namespace internal
}  // namespace mojom
}  // namespace content

#endif  // CONTENT_COMMON_RENDERER_MOJOM_SHARED_INTERNAL_H_