// mojo/public/interfaces/bindings/interface_control_messages.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MOJO_PUBLIC_INTERFACES_BINDINGS_INTERFACE_CONTROL_MESSAGES_MOJOM_H_
#define MOJO_PUBLIC_INTERFACES_BINDINGS_INTERFACE_CONTROL_MESSAGES_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom-shared.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom-forward.h"
#include <string>
#include <vector>




#include "base/component_export.h"



// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace mojo {
namespace interface_control {







class COMPONENT_EXPORT(MOJO_MOJOM_BINDINGS) QueryVersion {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<QueryVersion, T>::value>;
  using DataView = QueryVersionDataView;
  using Data_ = internal::QueryVersion_Data;

  template <typename... Args>
  static QueryVersionPtr New(Args&&... args) {
    return QueryVersionPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static QueryVersionPtr From(const U& u) {
    return mojo::TypeConverter<QueryVersionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, QueryVersion>::Convert(*this);
  }


  QueryVersion();

  ~QueryVersion();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = QueryVersionPtr>
  QueryVersionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, QueryVersion::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;
  size_t Hash(size_t seed) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        QueryVersion::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        QueryVersion::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::QueryVersion_UnserializedMessageContext<
            UserType, QueryVersion::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<QueryVersion::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return QueryVersion::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::QueryVersion_UnserializedMessageContext<
            UserType, QueryVersion::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<QueryVersion::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }


  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, QueryVersion::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, QueryVersion::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, QueryVersion::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, QueryVersion::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(MOJO_MOJOM_BINDINGS) QueryVersionResult {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<QueryVersionResult, T>::value>;
  using DataView = QueryVersionResultDataView;
  using Data_ = internal::QueryVersionResult_Data;

  template <typename... Args>
  static QueryVersionResultPtr New(Args&&... args) {
    return QueryVersionResultPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static QueryVersionResultPtr From(const U& u) {
    return mojo::TypeConverter<QueryVersionResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, QueryVersionResult>::Convert(*this);
  }


  QueryVersionResult();

  explicit QueryVersionResult(
      uint32_t version);

  ~QueryVersionResult();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = QueryVersionResultPtr>
  QueryVersionResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, QueryVersionResult::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;
  size_t Hash(size_t seed) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        QueryVersionResult::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        QueryVersionResult::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::QueryVersionResult_UnserializedMessageContext<
            UserType, QueryVersionResult::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<QueryVersionResult::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return QueryVersionResult::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::QueryVersionResult_UnserializedMessageContext<
            UserType, QueryVersionResult::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<QueryVersionResult::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  uint32_t version;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, QueryVersionResult::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, QueryVersionResult::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, QueryVersionResult::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, QueryVersionResult::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(MOJO_MOJOM_BINDINGS) FlushForTesting {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FlushForTesting, T>::value>;
  using DataView = FlushForTestingDataView;
  using Data_ = internal::FlushForTesting_Data;

  template <typename... Args>
  static FlushForTestingPtr New(Args&&... args) {
    return FlushForTestingPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FlushForTestingPtr From(const U& u) {
    return mojo::TypeConverter<FlushForTestingPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FlushForTesting>::Convert(*this);
  }


  FlushForTesting();

  ~FlushForTesting();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FlushForTestingPtr>
  FlushForTestingPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FlushForTesting::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;
  size_t Hash(size_t seed) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FlushForTesting::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FlushForTesting::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FlushForTesting_UnserializedMessageContext<
            UserType, FlushForTesting::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<FlushForTesting::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return FlushForTesting::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FlushForTesting_UnserializedMessageContext<
            UserType, FlushForTesting::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FlushForTesting::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }


  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FlushForTesting::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FlushForTesting::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FlushForTesting::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FlushForTesting::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class COMPONENT_EXPORT(MOJO_MOJOM_BINDINGS) RequireVersion {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<RequireVersion, T>::value>;
  using DataView = RequireVersionDataView;
  using Data_ = internal::RequireVersion_Data;

  template <typename... Args>
  static RequireVersionPtr New(Args&&... args) {
    return RequireVersionPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static RequireVersionPtr From(const U& u) {
    return mojo::TypeConverter<RequireVersionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, RequireVersion>::Convert(*this);
  }


  RequireVersion();

  explicit RequireVersion(
      uint32_t version);

  ~RequireVersion();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = RequireVersionPtr>
  RequireVersionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, RequireVersion::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;
  size_t Hash(size_t seed) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        RequireVersion::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        RequireVersion::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::RequireVersion_UnserializedMessageContext<
            UserType, RequireVersion::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<RequireVersion::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return RequireVersion::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::RequireVersion_UnserializedMessageContext<
            UserType, RequireVersion::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<RequireVersion::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  uint32_t version;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, RequireVersion::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, RequireVersion::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, RequireVersion::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, RequireVersion::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(MOJO_MOJOM_BINDINGS) EnableIdleTracking {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<EnableIdleTracking, T>::value>;
  using DataView = EnableIdleTrackingDataView;
  using Data_ = internal::EnableIdleTracking_Data;

  template <typename... Args>
  static EnableIdleTrackingPtr New(Args&&... args) {
    return EnableIdleTrackingPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static EnableIdleTrackingPtr From(const U& u) {
    return mojo::TypeConverter<EnableIdleTrackingPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, EnableIdleTracking>::Convert(*this);
  }


  EnableIdleTracking();

  explicit EnableIdleTracking(
      int64_t timeout_in_microseconds);

  ~EnableIdleTracking();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = EnableIdleTrackingPtr>
  EnableIdleTrackingPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, EnableIdleTracking::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;
  size_t Hash(size_t seed) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        EnableIdleTracking::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        EnableIdleTracking::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::EnableIdleTracking_UnserializedMessageContext<
            UserType, EnableIdleTracking::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<EnableIdleTracking::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return EnableIdleTracking::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::EnableIdleTracking_UnserializedMessageContext<
            UserType, EnableIdleTracking::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<EnableIdleTracking::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  int64_t timeout_in_microseconds;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, EnableIdleTracking::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, EnableIdleTracking::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, EnableIdleTracking::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, EnableIdleTracking::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(MOJO_MOJOM_BINDINGS) MessageAck {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<MessageAck, T>::value>;
  using DataView = MessageAckDataView;
  using Data_ = internal::MessageAck_Data;

  template <typename... Args>
  static MessageAckPtr New(Args&&... args) {
    return MessageAckPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static MessageAckPtr From(const U& u) {
    return mojo::TypeConverter<MessageAckPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, MessageAck>::Convert(*this);
  }


  MessageAck();

  ~MessageAck();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = MessageAckPtr>
  MessageAckPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, MessageAck::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;
  size_t Hash(size_t seed) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        MessageAck::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        MessageAck::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::MessageAck_UnserializedMessageContext<
            UserType, MessageAck::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<MessageAck::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return MessageAck::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::MessageAck_UnserializedMessageContext<
            UserType, MessageAck::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<MessageAck::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }


  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, MessageAck::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, MessageAck::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, MessageAck::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, MessageAck::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(MOJO_MOJOM_BINDINGS) NotifyIdle {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<NotifyIdle, T>::value>;
  using DataView = NotifyIdleDataView;
  using Data_ = internal::NotifyIdle_Data;

  template <typename... Args>
  static NotifyIdlePtr New(Args&&... args) {
    return NotifyIdlePtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static NotifyIdlePtr From(const U& u) {
    return mojo::TypeConverter<NotifyIdlePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, NotifyIdle>::Convert(*this);
  }


  NotifyIdle();

  ~NotifyIdle();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = NotifyIdlePtr>
  NotifyIdlePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, NotifyIdle::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;
  size_t Hash(size_t seed) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        NotifyIdle::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        NotifyIdle::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::NotifyIdle_UnserializedMessageContext<
            UserType, NotifyIdle::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<NotifyIdle::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return NotifyIdle::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::NotifyIdle_UnserializedMessageContext<
            UserType, NotifyIdle::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<NotifyIdle::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }


  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, NotifyIdle::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, NotifyIdle::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, NotifyIdle::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, NotifyIdle::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(MOJO_MOJOM_BINDINGS) RunInput {
 public:
  using DataView = RunInputDataView;
  using Data_ = internal::RunInput_Data;
  using Tag = Data_::RunInput_Tag;

  static RunInputPtr New() {
    return RunInputPtr(base::in_place);
  }
  // Construct an instance holding |query_version|.
  static RunInputPtr
  NewQueryVersion(
      QueryVersionPtr query_version) {
    auto result = RunInputPtr(base::in_place);
    result->set_query_version(std::move(query_version));
    return result;
  }
  // Construct an instance holding |flush_for_testing|.
  static RunInputPtr
  NewFlushForTesting(
      FlushForTestingPtr flush_for_testing) {
    auto result = RunInputPtr(base::in_place);
    result->set_flush_for_testing(std::move(flush_for_testing));
    return result;
  }

  template <typename U>
  static RunInputPtr From(const U& u) {
    return mojo::TypeConverter<RunInputPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, RunInput>::Convert(*this);
  }

  RunInput();
  ~RunInput();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = RunInputPtr>
  RunInputPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, RunInput>::value>::type* = nullptr>
  bool Equals(const T& other) const;
  size_t Hash(size_t seed) const;

  Tag which() const {
    return tag_;
  }


  
  bool is_query_version() const { return tag_ == Tag::QUERY_VERSION; }

  
  QueryVersionPtr& get_query_version() const {
    DCHECK(tag_ == Tag::QUERY_VERSION);
    return *(data_.query_version);
  }

  
  void set_query_version(
      QueryVersionPtr query_version);
  
  bool is_flush_for_testing() const { return tag_ == Tag::FLUSH_FOR_TESTING; }

  
  FlushForTestingPtr& get_flush_for_testing() const {
    DCHECK(tag_ == Tag::FLUSH_FOR_TESTING);
    return *(data_.flush_for_testing);
  }

  
  void set_flush_for_testing(
      FlushForTestingPtr flush_for_testing);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        RunInput::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<RunInput::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

 private:
  union Union_ {
    Union_() {}
    ~Union_() {}
    QueryVersionPtr* query_version;
    FlushForTestingPtr* flush_for_testing;
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class COMPONENT_EXPORT(MOJO_MOJOM_BINDINGS) RunOutput {
 public:
  using DataView = RunOutputDataView;
  using Data_ = internal::RunOutput_Data;
  using Tag = Data_::RunOutput_Tag;

  static RunOutputPtr New() {
    return RunOutputPtr(base::in_place);
  }
  // Construct an instance holding |query_version_result|.
  static RunOutputPtr
  NewQueryVersionResult(
      QueryVersionResultPtr query_version_result) {
    auto result = RunOutputPtr(base::in_place);
    result->set_query_version_result(std::move(query_version_result));
    return result;
  }

  template <typename U>
  static RunOutputPtr From(const U& u) {
    return mojo::TypeConverter<RunOutputPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, RunOutput>::Convert(*this);
  }

  RunOutput();
  ~RunOutput();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = RunOutputPtr>
  RunOutputPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, RunOutput>::value>::type* = nullptr>
  bool Equals(const T& other) const;
  size_t Hash(size_t seed) const;

  Tag which() const {
    return tag_;
  }


  
  bool is_query_version_result() const { return tag_ == Tag::QUERY_VERSION_RESULT; }

  
  QueryVersionResultPtr& get_query_version_result() const {
    DCHECK(tag_ == Tag::QUERY_VERSION_RESULT);
    return *(data_.query_version_result);
  }

  
  void set_query_version_result(
      QueryVersionResultPtr query_version_result);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        RunOutput::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<RunOutput::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

 private:
  union Union_ {
    Union_() {}
    ~Union_() {}
    QueryVersionResultPtr* query_version_result;
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class COMPONENT_EXPORT(MOJO_MOJOM_BINDINGS) RunOrClosePipeInput {
 public:
  using DataView = RunOrClosePipeInputDataView;
  using Data_ = internal::RunOrClosePipeInput_Data;
  using Tag = Data_::RunOrClosePipeInput_Tag;

  static RunOrClosePipeInputPtr New() {
    return RunOrClosePipeInputPtr(base::in_place);
  }
  // Construct an instance holding |require_version|.
  static RunOrClosePipeInputPtr
  NewRequireVersion(
      RequireVersionPtr require_version) {
    auto result = RunOrClosePipeInputPtr(base::in_place);
    result->set_require_version(std::move(require_version));
    return result;
  }
  // Construct an instance holding |enable_idle_tracking|.
  static RunOrClosePipeInputPtr
  NewEnableIdleTracking(
      EnableIdleTrackingPtr enable_idle_tracking) {
    auto result = RunOrClosePipeInputPtr(base::in_place);
    result->set_enable_idle_tracking(std::move(enable_idle_tracking));
    return result;
  }
  // Construct an instance holding |message_ack|.
  static RunOrClosePipeInputPtr
  NewMessageAck(
      MessageAckPtr message_ack) {
    auto result = RunOrClosePipeInputPtr(base::in_place);
    result->set_message_ack(std::move(message_ack));
    return result;
  }
  // Construct an instance holding |notify_idle|.
  static RunOrClosePipeInputPtr
  NewNotifyIdle(
      NotifyIdlePtr notify_idle) {
    auto result = RunOrClosePipeInputPtr(base::in_place);
    result->set_notify_idle(std::move(notify_idle));
    return result;
  }

  template <typename U>
  static RunOrClosePipeInputPtr From(const U& u) {
    return mojo::TypeConverter<RunOrClosePipeInputPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, RunOrClosePipeInput>::Convert(*this);
  }

  RunOrClosePipeInput();
  ~RunOrClosePipeInput();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = RunOrClosePipeInputPtr>
  RunOrClosePipeInputPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, RunOrClosePipeInput>::value>::type* = nullptr>
  bool Equals(const T& other) const;
  size_t Hash(size_t seed) const;

  Tag which() const {
    return tag_;
  }


  
  bool is_require_version() const { return tag_ == Tag::REQUIRE_VERSION; }

  
  RequireVersionPtr& get_require_version() const {
    DCHECK(tag_ == Tag::REQUIRE_VERSION);
    return *(data_.require_version);
  }

  
  void set_require_version(
      RequireVersionPtr require_version);
  
  bool is_enable_idle_tracking() const { return tag_ == Tag::ENABLE_IDLE_TRACKING; }

  
  EnableIdleTrackingPtr& get_enable_idle_tracking() const {
    DCHECK(tag_ == Tag::ENABLE_IDLE_TRACKING);
    return *(data_.enable_idle_tracking);
  }

  
  void set_enable_idle_tracking(
      EnableIdleTrackingPtr enable_idle_tracking);
  
  bool is_message_ack() const { return tag_ == Tag::MESSAGE_ACK; }

  
  MessageAckPtr& get_message_ack() const {
    DCHECK(tag_ == Tag::MESSAGE_ACK);
    return *(data_.message_ack);
  }

  
  void set_message_ack(
      MessageAckPtr message_ack);
  
  bool is_notify_idle() const { return tag_ == Tag::NOTIFY_IDLE; }

  
  NotifyIdlePtr& get_notify_idle() const {
    DCHECK(tag_ == Tag::NOTIFY_IDLE);
    return *(data_.notify_idle);
  }

  
  void set_notify_idle(
      NotifyIdlePtr notify_idle);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        RunOrClosePipeInput::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<RunOrClosePipeInput::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

 private:
  union Union_ {
    Union_() {}
    ~Union_() {}
    RequireVersionPtr* require_version;
    EnableIdleTrackingPtr* enable_idle_tracking;
    MessageAckPtr* message_ack;
    NotifyIdlePtr* notify_idle;
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};





class COMPONENT_EXPORT(MOJO_MOJOM_BINDINGS) RunMessageParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<RunMessageParams, T>::value>;
  using DataView = RunMessageParamsDataView;
  using Data_ = internal::RunMessageParams_Data;

  template <typename... Args>
  static RunMessageParamsPtr New(Args&&... args) {
    return RunMessageParamsPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static RunMessageParamsPtr From(const U& u) {
    return mojo::TypeConverter<RunMessageParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, RunMessageParams>::Convert(*this);
  }


  RunMessageParams();

  explicit RunMessageParams(
      RunInputPtr input);

  ~RunMessageParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = RunMessageParamsPtr>
  RunMessageParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, RunMessageParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;
  size_t Hash(size_t seed) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        RunMessageParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        RunMessageParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::RunMessageParams_UnserializedMessageContext<
            UserType, RunMessageParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<RunMessageParams::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return RunMessageParams::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::RunMessageParams_UnserializedMessageContext<
            UserType, RunMessageParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<RunMessageParams::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  RunInputPtr input;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(RunMessageParams);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, RunMessageParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, RunMessageParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, RunMessageParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, RunMessageParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(MOJO_MOJOM_BINDINGS) RunResponseMessageParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<RunResponseMessageParams, T>::value>;
  using DataView = RunResponseMessageParamsDataView;
  using Data_ = internal::RunResponseMessageParams_Data;

  template <typename... Args>
  static RunResponseMessageParamsPtr New(Args&&... args) {
    return RunResponseMessageParamsPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static RunResponseMessageParamsPtr From(const U& u) {
    return mojo::TypeConverter<RunResponseMessageParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, RunResponseMessageParams>::Convert(*this);
  }


  RunResponseMessageParams();

  explicit RunResponseMessageParams(
      RunOutputPtr output);

  ~RunResponseMessageParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = RunResponseMessageParamsPtr>
  RunResponseMessageParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, RunResponseMessageParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        RunResponseMessageParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        RunResponseMessageParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::RunResponseMessageParams_UnserializedMessageContext<
            UserType, RunResponseMessageParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<RunResponseMessageParams::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return RunResponseMessageParams::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::RunResponseMessageParams_UnserializedMessageContext<
            UserType, RunResponseMessageParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<RunResponseMessageParams::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  RunOutputPtr output;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(RunResponseMessageParams);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, RunResponseMessageParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, RunResponseMessageParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, RunResponseMessageParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, RunResponseMessageParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}








class COMPONENT_EXPORT(MOJO_MOJOM_BINDINGS) RunOrClosePipeMessageParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<RunOrClosePipeMessageParams, T>::value>;
  using DataView = RunOrClosePipeMessageParamsDataView;
  using Data_ = internal::RunOrClosePipeMessageParams_Data;

  template <typename... Args>
  static RunOrClosePipeMessageParamsPtr New(Args&&... args) {
    return RunOrClosePipeMessageParamsPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static RunOrClosePipeMessageParamsPtr From(const U& u) {
    return mojo::TypeConverter<RunOrClosePipeMessageParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, RunOrClosePipeMessageParams>::Convert(*this);
  }


  RunOrClosePipeMessageParams();

  explicit RunOrClosePipeMessageParams(
      RunOrClosePipeInputPtr input);

  ~RunOrClosePipeMessageParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = RunOrClosePipeMessageParamsPtr>
  RunOrClosePipeMessageParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, RunOrClosePipeMessageParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;
  size_t Hash(size_t seed) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        RunOrClosePipeMessageParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        RunOrClosePipeMessageParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::RunOrClosePipeMessageParams_UnserializedMessageContext<
            UserType, RunOrClosePipeMessageParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<RunOrClosePipeMessageParams::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return RunOrClosePipeMessageParams::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::RunOrClosePipeMessageParams_UnserializedMessageContext<
            UserType, RunOrClosePipeMessageParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<RunOrClosePipeMessageParams::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  RunOrClosePipeInputPtr input;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(RunOrClosePipeMessageParams);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, RunOrClosePipeMessageParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, RunOrClosePipeMessageParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, RunOrClosePipeMessageParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, RunOrClosePipeMessageParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





template <typename UnionPtrType>
RunInputPtr RunInput::Clone() const {
  // Use UnionPtrType to prevent the compiler from trying to compile this
  // without being asked.
  UnionPtrType rv(New());
  switch (tag_) {
    case Tag::QUERY_VERSION:
      rv->set_query_version(mojo::Clone(*data_.query_version));
      break;
    case Tag::FLUSH_FOR_TESTING:
      rv->set_flush_for_testing(mojo::Clone(*data_.flush_for_testing));
      break;
  }
  return rv;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, RunInput>::value>::type*>
bool RunInput::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::QUERY_VERSION:
      return mojo::Equals(*(data_.query_version), *(other.data_.query_version));
    case Tag::FLUSH_FOR_TESTING:
      return mojo::Equals(*(data_.flush_for_testing), *(other.data_.flush_for_testing));
  }

  return false;
}
template <typename UnionPtrType>
RunOutputPtr RunOutput::Clone() const {
  // Use UnionPtrType to prevent the compiler from trying to compile this
  // without being asked.
  UnionPtrType rv(New());
  switch (tag_) {
    case Tag::QUERY_VERSION_RESULT:
      rv->set_query_version_result(mojo::Clone(*data_.query_version_result));
      break;
  }
  return rv;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, RunOutput>::value>::type*>
bool RunOutput::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::QUERY_VERSION_RESULT:
      return mojo::Equals(*(data_.query_version_result), *(other.data_.query_version_result));
  }

  return false;
}
template <typename UnionPtrType>
RunOrClosePipeInputPtr RunOrClosePipeInput::Clone() const {
  // Use UnionPtrType to prevent the compiler from trying to compile this
  // without being asked.
  UnionPtrType rv(New());
  switch (tag_) {
    case Tag::REQUIRE_VERSION:
      rv->set_require_version(mojo::Clone(*data_.require_version));
      break;
    case Tag::ENABLE_IDLE_TRACKING:
      rv->set_enable_idle_tracking(mojo::Clone(*data_.enable_idle_tracking));
      break;
    case Tag::MESSAGE_ACK:
      rv->set_message_ack(mojo::Clone(*data_.message_ack));
      break;
    case Tag::NOTIFY_IDLE:
      rv->set_notify_idle(mojo::Clone(*data_.notify_idle));
      break;
  }
  return rv;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, RunOrClosePipeInput>::value>::type*>
bool RunOrClosePipeInput::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::REQUIRE_VERSION:
      return mojo::Equals(*(data_.require_version), *(other.data_.require_version));
    case Tag::ENABLE_IDLE_TRACKING:
      return mojo::Equals(*(data_.enable_idle_tracking), *(other.data_.enable_idle_tracking));
    case Tag::MESSAGE_ACK:
      return mojo::Equals(*(data_.message_ack), *(other.data_.message_ack));
    case Tag::NOTIFY_IDLE:
      return mojo::Equals(*(data_.notify_idle), *(other.data_.notify_idle));
  }

  return false;
}
template <typename StructPtrType>
RunMessageParamsPtr RunMessageParams::Clone() const {
  return New(
      mojo::Clone(input)
  );
}

template <typename T, RunMessageParams::EnableIfSame<T>*>
bool RunMessageParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->input, other_struct.input))
    return false;
  return true;
}

template <typename T, RunMessageParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.input, rhs.input))
    return true;
  if (std::less<>{}(rhs.input, lhs.input))
    return false;
  return false;
}
template <typename StructPtrType>
RunResponseMessageParamsPtr RunResponseMessageParams::Clone() const {
  return New(
      mojo::Clone(output)
  );
}

template <typename T, RunResponseMessageParams::EnableIfSame<T>*>
bool RunResponseMessageParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->output, other_struct.output))
    return false;
  return true;
}

template <typename T, RunResponseMessageParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.output, rhs.output))
    return true;
  if (std::less<>{}(rhs.output, lhs.output))
    return false;
  return false;
}
template <typename StructPtrType>
QueryVersionPtr QueryVersion::Clone() const {
  return New(
  );
}

template <typename T, QueryVersion::EnableIfSame<T>*>
bool QueryVersion::Equals(const T& other_struct) const {
  return true;
}

template <typename T, QueryVersion::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  return false;
}
template <typename StructPtrType>
QueryVersionResultPtr QueryVersionResult::Clone() const {
  return New(
      mojo::Clone(version)
  );
}

template <typename T, QueryVersionResult::EnableIfSame<T>*>
bool QueryVersionResult::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->version, other_struct.version))
    return false;
  return true;
}

template <typename T, QueryVersionResult::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.version, rhs.version))
    return true;
  if (std::less<>{}(rhs.version, lhs.version))
    return false;
  return false;
}
template <typename StructPtrType>
FlushForTestingPtr FlushForTesting::Clone() const {
  return New(
  );
}

template <typename T, FlushForTesting::EnableIfSame<T>*>
bool FlushForTesting::Equals(const T& other_struct) const {
  return true;
}

template <typename T, FlushForTesting::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  return false;
}
template <typename StructPtrType>
RunOrClosePipeMessageParamsPtr RunOrClosePipeMessageParams::Clone() const {
  return New(
      mojo::Clone(input)
  );
}

template <typename T, RunOrClosePipeMessageParams::EnableIfSame<T>*>
bool RunOrClosePipeMessageParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->input, other_struct.input))
    return false;
  return true;
}

template <typename T, RunOrClosePipeMessageParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.input, rhs.input))
    return true;
  if (std::less<>{}(rhs.input, lhs.input))
    return false;
  return false;
}
template <typename StructPtrType>
RequireVersionPtr RequireVersion::Clone() const {
  return New(
      mojo::Clone(version)
  );
}

template <typename T, RequireVersion::EnableIfSame<T>*>
bool RequireVersion::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->version, other_struct.version))
    return false;
  return true;
}

template <typename T, RequireVersion::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.version, rhs.version))
    return true;
  if (std::less<>{}(rhs.version, lhs.version))
    return false;
  return false;
}
template <typename StructPtrType>
EnableIdleTrackingPtr EnableIdleTracking::Clone() const {
  return New(
      mojo::Clone(timeout_in_microseconds)
  );
}

template <typename T, EnableIdleTracking::EnableIfSame<T>*>
bool EnableIdleTracking::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->timeout_in_microseconds, other_struct.timeout_in_microseconds))
    return false;
  return true;
}

template <typename T, EnableIdleTracking::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.timeout_in_microseconds, rhs.timeout_in_microseconds))
    return true;
  if (std::less<>{}(rhs.timeout_in_microseconds, lhs.timeout_in_microseconds))
    return false;
  return false;
}
template <typename StructPtrType>
MessageAckPtr MessageAck::Clone() const {
  return New(
  );
}

template <typename T, MessageAck::EnableIfSame<T>*>
bool MessageAck::Equals(const T& other_struct) const {
  return true;
}

template <typename T, MessageAck::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  return false;
}
template <typename StructPtrType>
NotifyIdlePtr NotifyIdle::Clone() const {
  return New(
  );
}

template <typename T, NotifyIdle::EnableIfSame<T>*>
bool NotifyIdle::Equals(const T& other_struct) const {
  return true;
}

template <typename T, NotifyIdle::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  return false;
}


}  // namespace interface_control
}  // namespace mojo

namespace mojo {


template <>
struct COMPONENT_EXPORT(MOJO_MOJOM_BINDINGS) StructTraits<::mojo::interface_control::RunMessageParams::DataView,
                                         ::mojo::interface_control::RunMessageParamsPtr> {
  static bool IsNull(const ::mojo::interface_control::RunMessageParamsPtr& input) { return !input; }
  static void SetToNull(::mojo::interface_control::RunMessageParamsPtr* output) { output->reset(); }

  static const decltype(::mojo::interface_control::RunMessageParams::input)& input(
      const ::mojo::interface_control::RunMessageParamsPtr& input) {
    return input->input;
  }

  static bool Read(::mojo::interface_control::RunMessageParams::DataView input, ::mojo::interface_control::RunMessageParamsPtr* output);
};


template <>
struct COMPONENT_EXPORT(MOJO_MOJOM_BINDINGS) StructTraits<::mojo::interface_control::RunResponseMessageParams::DataView,
                                         ::mojo::interface_control::RunResponseMessageParamsPtr> {
  static bool IsNull(const ::mojo::interface_control::RunResponseMessageParamsPtr& input) { return !input; }
  static void SetToNull(::mojo::interface_control::RunResponseMessageParamsPtr* output) { output->reset(); }

  static const decltype(::mojo::interface_control::RunResponseMessageParams::output)& output(
      const ::mojo::interface_control::RunResponseMessageParamsPtr& input) {
    return input->output;
  }

  static bool Read(::mojo::interface_control::RunResponseMessageParams::DataView input, ::mojo::interface_control::RunResponseMessageParamsPtr* output);
};


template <>
struct COMPONENT_EXPORT(MOJO_MOJOM_BINDINGS) StructTraits<::mojo::interface_control::QueryVersion::DataView,
                                         ::mojo::interface_control::QueryVersionPtr> {
  static bool IsNull(const ::mojo::interface_control::QueryVersionPtr& input) { return !input; }
  static void SetToNull(::mojo::interface_control::QueryVersionPtr* output) { output->reset(); }

  static bool Read(::mojo::interface_control::QueryVersion::DataView input, ::mojo::interface_control::QueryVersionPtr* output);
};


template <>
struct COMPONENT_EXPORT(MOJO_MOJOM_BINDINGS) StructTraits<::mojo::interface_control::QueryVersionResult::DataView,
                                         ::mojo::interface_control::QueryVersionResultPtr> {
  static bool IsNull(const ::mojo::interface_control::QueryVersionResultPtr& input) { return !input; }
  static void SetToNull(::mojo::interface_control::QueryVersionResultPtr* output) { output->reset(); }

  static decltype(::mojo::interface_control::QueryVersionResult::version) version(
      const ::mojo::interface_control::QueryVersionResultPtr& input) {
    return input->version;
  }

  static bool Read(::mojo::interface_control::QueryVersionResult::DataView input, ::mojo::interface_control::QueryVersionResultPtr* output);
};


template <>
struct COMPONENT_EXPORT(MOJO_MOJOM_BINDINGS) StructTraits<::mojo::interface_control::FlushForTesting::DataView,
                                         ::mojo::interface_control::FlushForTestingPtr> {
  static bool IsNull(const ::mojo::interface_control::FlushForTestingPtr& input) { return !input; }
  static void SetToNull(::mojo::interface_control::FlushForTestingPtr* output) { output->reset(); }

  static bool Read(::mojo::interface_control::FlushForTesting::DataView input, ::mojo::interface_control::FlushForTestingPtr* output);
};


template <>
struct COMPONENT_EXPORT(MOJO_MOJOM_BINDINGS) StructTraits<::mojo::interface_control::RunOrClosePipeMessageParams::DataView,
                                         ::mojo::interface_control::RunOrClosePipeMessageParamsPtr> {
  static bool IsNull(const ::mojo::interface_control::RunOrClosePipeMessageParamsPtr& input) { return !input; }
  static void SetToNull(::mojo::interface_control::RunOrClosePipeMessageParamsPtr* output) { output->reset(); }

  static const decltype(::mojo::interface_control::RunOrClosePipeMessageParams::input)& input(
      const ::mojo::interface_control::RunOrClosePipeMessageParamsPtr& input) {
    return input->input;
  }

  static bool Read(::mojo::interface_control::RunOrClosePipeMessageParams::DataView input, ::mojo::interface_control::RunOrClosePipeMessageParamsPtr* output);
};


template <>
struct COMPONENT_EXPORT(MOJO_MOJOM_BINDINGS) StructTraits<::mojo::interface_control::RequireVersion::DataView,
                                         ::mojo::interface_control::RequireVersionPtr> {
  static bool IsNull(const ::mojo::interface_control::RequireVersionPtr& input) { return !input; }
  static void SetToNull(::mojo::interface_control::RequireVersionPtr* output) { output->reset(); }

  static decltype(::mojo::interface_control::RequireVersion::version) version(
      const ::mojo::interface_control::RequireVersionPtr& input) {
    return input->version;
  }

  static bool Read(::mojo::interface_control::RequireVersion::DataView input, ::mojo::interface_control::RequireVersionPtr* output);
};


template <>
struct COMPONENT_EXPORT(MOJO_MOJOM_BINDINGS) StructTraits<::mojo::interface_control::EnableIdleTracking::DataView,
                                         ::mojo::interface_control::EnableIdleTrackingPtr> {
  static bool IsNull(const ::mojo::interface_control::EnableIdleTrackingPtr& input) { return !input; }
  static void SetToNull(::mojo::interface_control::EnableIdleTrackingPtr* output) { output->reset(); }

  static decltype(::mojo::interface_control::EnableIdleTracking::timeout_in_microseconds) timeout_in_microseconds(
      const ::mojo::interface_control::EnableIdleTrackingPtr& input) {
    return input->timeout_in_microseconds;
  }

  static bool Read(::mojo::interface_control::EnableIdleTracking::DataView input, ::mojo::interface_control::EnableIdleTrackingPtr* output);
};


template <>
struct COMPONENT_EXPORT(MOJO_MOJOM_BINDINGS) StructTraits<::mojo::interface_control::MessageAck::DataView,
                                         ::mojo::interface_control::MessageAckPtr> {
  static bool IsNull(const ::mojo::interface_control::MessageAckPtr& input) { return !input; }
  static void SetToNull(::mojo::interface_control::MessageAckPtr* output) { output->reset(); }

  static bool Read(::mojo::interface_control::MessageAck::DataView input, ::mojo::interface_control::MessageAckPtr* output);
};


template <>
struct COMPONENT_EXPORT(MOJO_MOJOM_BINDINGS) StructTraits<::mojo::interface_control::NotifyIdle::DataView,
                                         ::mojo::interface_control::NotifyIdlePtr> {
  static bool IsNull(const ::mojo::interface_control::NotifyIdlePtr& input) { return !input; }
  static void SetToNull(::mojo::interface_control::NotifyIdlePtr* output) { output->reset(); }

  static bool Read(::mojo::interface_control::NotifyIdle::DataView input, ::mojo::interface_control::NotifyIdlePtr* output);
};


template <>
struct COMPONENT_EXPORT(MOJO_MOJOM_BINDINGS) UnionTraits<::mojo::interface_control::RunInput::DataView,
                                        ::mojo::interface_control::RunInputPtr> {
  static bool IsNull(const ::mojo::interface_control::RunInputPtr& input) { return !input; }
  static void SetToNull(::mojo::interface_control::RunInputPtr* output) { output->reset(); }

  static ::mojo::interface_control::RunInput::Tag GetTag(const ::mojo::interface_control::RunInputPtr& input) {
    return input->which();
  }

  static const ::mojo::interface_control::QueryVersionPtr& query_version(const ::mojo::interface_control::RunInputPtr& input) {
    return input->get_query_version();
  }

  static const ::mojo::interface_control::FlushForTestingPtr& flush_for_testing(const ::mojo::interface_control::RunInputPtr& input) {
    return input->get_flush_for_testing();
  }

  static bool Read(::mojo::interface_control::RunInput::DataView input, ::mojo::interface_control::RunInputPtr* output);
};


template <>
struct COMPONENT_EXPORT(MOJO_MOJOM_BINDINGS) UnionTraits<::mojo::interface_control::RunOutput::DataView,
                                        ::mojo::interface_control::RunOutputPtr> {
  static bool IsNull(const ::mojo::interface_control::RunOutputPtr& input) { return !input; }
  static void SetToNull(::mojo::interface_control::RunOutputPtr* output) { output->reset(); }

  static ::mojo::interface_control::RunOutput::Tag GetTag(const ::mojo::interface_control::RunOutputPtr& input) {
    return input->which();
  }

  static const ::mojo::interface_control::QueryVersionResultPtr& query_version_result(const ::mojo::interface_control::RunOutputPtr& input) {
    return input->get_query_version_result();
  }

  static bool Read(::mojo::interface_control::RunOutput::DataView input, ::mojo::interface_control::RunOutputPtr* output);
};


template <>
struct COMPONENT_EXPORT(MOJO_MOJOM_BINDINGS) UnionTraits<::mojo::interface_control::RunOrClosePipeInput::DataView,
                                        ::mojo::interface_control::RunOrClosePipeInputPtr> {
  static bool IsNull(const ::mojo::interface_control::RunOrClosePipeInputPtr& input) { return !input; }
  static void SetToNull(::mojo::interface_control::RunOrClosePipeInputPtr* output) { output->reset(); }

  static ::mojo::interface_control::RunOrClosePipeInput::Tag GetTag(const ::mojo::interface_control::RunOrClosePipeInputPtr& input) {
    return input->which();
  }

  static const ::mojo::interface_control::RequireVersionPtr& require_version(const ::mojo::interface_control::RunOrClosePipeInputPtr& input) {
    return input->get_require_version();
  }

  static const ::mojo::interface_control::EnableIdleTrackingPtr& enable_idle_tracking(const ::mojo::interface_control::RunOrClosePipeInputPtr& input) {
    return input->get_enable_idle_tracking();
  }

  static const ::mojo::interface_control::MessageAckPtr& message_ack(const ::mojo::interface_control::RunOrClosePipeInputPtr& input) {
    return input->get_message_ack();
  }

  static const ::mojo::interface_control::NotifyIdlePtr& notify_idle(const ::mojo::interface_control::RunOrClosePipeInputPtr& input) {
    return input->get_notify_idle();
  }

  static bool Read(::mojo::interface_control::RunOrClosePipeInput::DataView input, ::mojo::interface_control::RunOrClosePipeInputPtr* output);
};

}  // namespace mojo

#endif  // MOJO_PUBLIC_INTERFACES_BINDINGS_INTERFACE_CONTROL_MESSAGES_MOJOM_H_