// services/viz/public/mojom/compositing/compositor_render_pass.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_COMPOSITOR_RENDER_PASS_MOJOM_SHARED_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_COMPOSITOR_RENDER_PASS_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "services/viz/public/mojom/compositing/compositor_render_pass.mojom-shared-internal.h"
#include "services/viz/public/mojom/compositing/compositor_render_pass_id.mojom-shared.h"
#include "services/viz/public/mojom/compositing/copy_output_request.mojom-shared.h"
#include "services/viz/public/mojom/compositing/filter_operations.mojom-shared.h"
#include "services/viz/public/mojom/compositing/quads.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/gfx/mojom/rrect_f.mojom-shared.h"
#include "ui/gfx/mojom/transform.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"






namespace viz {
namespace mojom {
class CompositorRenderPassDataView;



}  // namespace mojom
}  // namespace viz

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::viz::mojom::CompositorRenderPassDataView> {
  using Data = ::viz::mojom::internal::CompositorRenderPass_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace viz {
namespace mojom {


class CompositorRenderPassDataView {
 public:
  CompositorRenderPassDataView() {}

  CompositorRenderPassDataView(
      internal::CompositorRenderPass_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetIdDataView(
      ::viz::mojom::CompositorRenderPassIdDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadId(UserType* output) {
    
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<::viz::mojom::CompositorRenderPassIdDataView>(
        pointer, output, context_);
  }
  inline void GetOutputRectDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadOutputRect(UserType* output) {
    
    auto* pointer = data_->output_rect.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, context_);
  }
  inline void GetDamageRectDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadDamageRect(UserType* output) {
    
    auto* pointer = data_->damage_rect.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, context_);
  }
  inline void GetTransformToRootTargetDataView(
      ::gfx::mojom::TransformDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadTransformToRootTarget(UserType* output) {
    
    auto* pointer = data_->transform_to_root_target.Get();
    return mojo::internal::Deserialize<::gfx::mojom::TransformDataView>(
        pointer, output, context_);
  }
  inline void GetFiltersDataView(
      ::viz::mojom::FilterOperationsDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadFilters(UserType* output) {
    
    auto* pointer = data_->filters.Get();
    return mojo::internal::Deserialize<::viz::mojom::FilterOperationsDataView>(
        pointer, output, context_);
  }
  inline void GetBackdropFiltersDataView(
      ::viz::mojom::FilterOperationsDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadBackdropFilters(UserType* output) {
    
    auto* pointer = data_->backdrop_filters.Get();
    return mojo::internal::Deserialize<::viz::mojom::FilterOperationsDataView>(
        pointer, output, context_);
  }
  inline void GetBackdropFilterBoundsDataView(
      ::gfx::mojom::RRectFDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadBackdropFilterBounds(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gfx::mojom::RRectFDataView, UserType>(),
    "Attempting to read the optional `backdrop_filter_bounds` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadBackdropFilterBounds` instead "
    "of `ReadBackdropFilterBounds if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->backdrop_filter_bounds.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RRectFDataView>(
        pointer, output, context_);
  }
  bool has_transparent_background() const {
    return data_->has_transparent_background;
  }
  bool cache_render_pass() const {
    return data_->cache_render_pass;
  }
  bool has_damage_from_contributing_content() const {
    return data_->has_damage_from_contributing_content;
  }
  bool generate_mipmap() const {
    return data_->generate_mipmap;
  }
  inline void GetCopyRequestsDataView(
      mojo::ArrayDataView<::viz::mojom::CopyOutputRequestDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadCopyRequests(UserType* output) {
    
    auto* pointer = data_->copy_requests.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::viz::mojom::CopyOutputRequestDataView>>(
        pointer, output, context_);
  }
  inline void GetQuadListDataView(
      mojo::ArrayDataView<::viz::mojom::DrawQuadDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadQuadList(UserType* output) {
    
    auto* pointer = data_->quad_list.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::viz::mojom::DrawQuadDataView>>(
        pointer, output, context_);
  }
 private:
  internal::CompositorRenderPass_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace viz

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::CompositorRenderPassDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::CompositorRenderPassDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::viz::mojom::internal::CompositorRenderPass_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::id(input)) in_id = Traits::id(input);
    typename decltype((*output)->id)::BaseType::BufferWriter
        id_writer;
    mojo::internal::Serialize<::viz::mojom::CompositorRenderPassIdDataView>(
        in_id, buffer, &id_writer, context);
    (*output)->id.Set(
        id_writer.is_null() ? nullptr : id_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->id.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null id in CompositorRenderPass struct");
    decltype(Traits::output_rect(input)) in_output_rect = Traits::output_rect(input);
    typename decltype((*output)->output_rect)::BaseType::BufferWriter
        output_rect_writer;
    mojo::internal::Serialize<::gfx::mojom::RectDataView>(
        in_output_rect, buffer, &output_rect_writer, context);
    (*output)->output_rect.Set(
        output_rect_writer.is_null() ? nullptr : output_rect_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->output_rect.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null output_rect in CompositorRenderPass struct");
    decltype(Traits::damage_rect(input)) in_damage_rect = Traits::damage_rect(input);
    typename decltype((*output)->damage_rect)::BaseType::BufferWriter
        damage_rect_writer;
    mojo::internal::Serialize<::gfx::mojom::RectDataView>(
        in_damage_rect, buffer, &damage_rect_writer, context);
    (*output)->damage_rect.Set(
        damage_rect_writer.is_null() ? nullptr : damage_rect_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->damage_rect.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null damage_rect in CompositorRenderPass struct");
    decltype(Traits::transform_to_root_target(input)) in_transform_to_root_target = Traits::transform_to_root_target(input);
    typename decltype((*output)->transform_to_root_target)::BaseType::BufferWriter
        transform_to_root_target_writer;
    mojo::internal::Serialize<::gfx::mojom::TransformDataView>(
        in_transform_to_root_target, buffer, &transform_to_root_target_writer, context);
    (*output)->transform_to_root_target.Set(
        transform_to_root_target_writer.is_null() ? nullptr : transform_to_root_target_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->transform_to_root_target.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null transform_to_root_target in CompositorRenderPass struct");
    decltype(Traits::filters(input)) in_filters = Traits::filters(input);
    typename decltype((*output)->filters)::BaseType::BufferWriter
        filters_writer;
    mojo::internal::Serialize<::viz::mojom::FilterOperationsDataView>(
        in_filters, buffer, &filters_writer, context);
    (*output)->filters.Set(
        filters_writer.is_null() ? nullptr : filters_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->filters.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null filters in CompositorRenderPass struct");
    decltype(Traits::backdrop_filters(input)) in_backdrop_filters = Traits::backdrop_filters(input);
    typename decltype((*output)->backdrop_filters)::BaseType::BufferWriter
        backdrop_filters_writer;
    mojo::internal::Serialize<::viz::mojom::FilterOperationsDataView>(
        in_backdrop_filters, buffer, &backdrop_filters_writer, context);
    (*output)->backdrop_filters.Set(
        backdrop_filters_writer.is_null() ? nullptr : backdrop_filters_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->backdrop_filters.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null backdrop_filters in CompositorRenderPass struct");
    decltype(Traits::backdrop_filter_bounds(input)) in_backdrop_filter_bounds = Traits::backdrop_filter_bounds(input);
    typename decltype((*output)->backdrop_filter_bounds)::BaseType::BufferWriter
        backdrop_filter_bounds_writer;
    mojo::internal::Serialize<::gfx::mojom::RRectFDataView>(
        in_backdrop_filter_bounds, buffer, &backdrop_filter_bounds_writer, context);
    (*output)->backdrop_filter_bounds.Set(
        backdrop_filter_bounds_writer.is_null() ? nullptr : backdrop_filter_bounds_writer.data());
    (*output)->has_transparent_background = Traits::has_transparent_background(input);
    (*output)->cache_render_pass = Traits::cache_render_pass(input);
    (*output)->has_damage_from_contributing_content = Traits::has_damage_from_contributing_content(input);
    (*output)->generate_mipmap = Traits::generate_mipmap(input);
    decltype(Traits::copy_requests(input)) in_copy_requests = Traits::copy_requests(input);
    typename decltype((*output)->copy_requests)::BaseType::BufferWriter
        copy_requests_writer;
    const mojo::internal::ContainerValidateParams copy_requests_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<::viz::mojom::CopyOutputRequestDataView>>(
        in_copy_requests, buffer, &copy_requests_writer, &copy_requests_validate_params,
        context);
    (*output)->copy_requests.Set(
        copy_requests_writer.is_null() ? nullptr : copy_requests_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->copy_requests.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null copy_requests in CompositorRenderPass struct");
    decltype(Traits::quad_list(input)) in_quad_list = Traits::quad_list(input);
    typename decltype((*output)->quad_list)::BaseType::BufferWriter
        quad_list_writer;
    const mojo::internal::ContainerValidateParams quad_list_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<::viz::mojom::DrawQuadDataView>>(
        in_quad_list, buffer, &quad_list_writer, &quad_list_validate_params,
        context);
    (*output)->quad_list.Set(
        quad_list_writer.is_null() ? nullptr : quad_list_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->quad_list.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null quad_list in CompositorRenderPass struct");
  }

  static bool Deserialize(::viz::mojom::internal::CompositorRenderPass_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::viz::mojom::CompositorRenderPassDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace viz {
namespace mojom {

inline void CompositorRenderPassDataView::GetIdDataView(
    ::viz::mojom::CompositorRenderPassIdDataView* output) {
  auto pointer = data_->id.Get();
  *output = ::viz::mojom::CompositorRenderPassIdDataView(pointer, context_);
}
inline void CompositorRenderPassDataView::GetOutputRectDataView(
    ::gfx::mojom::RectDataView* output) {
  auto pointer = data_->output_rect.Get();
  *output = ::gfx::mojom::RectDataView(pointer, context_);
}
inline void CompositorRenderPassDataView::GetDamageRectDataView(
    ::gfx::mojom::RectDataView* output) {
  auto pointer = data_->damage_rect.Get();
  *output = ::gfx::mojom::RectDataView(pointer, context_);
}
inline void CompositorRenderPassDataView::GetTransformToRootTargetDataView(
    ::gfx::mojom::TransformDataView* output) {
  auto pointer = data_->transform_to_root_target.Get();
  *output = ::gfx::mojom::TransformDataView(pointer, context_);
}
inline void CompositorRenderPassDataView::GetFiltersDataView(
    ::viz::mojom::FilterOperationsDataView* output) {
  auto pointer = data_->filters.Get();
  *output = ::viz::mojom::FilterOperationsDataView(pointer, context_);
}
inline void CompositorRenderPassDataView::GetBackdropFiltersDataView(
    ::viz::mojom::FilterOperationsDataView* output) {
  auto pointer = data_->backdrop_filters.Get();
  *output = ::viz::mojom::FilterOperationsDataView(pointer, context_);
}
inline void CompositorRenderPassDataView::GetBackdropFilterBoundsDataView(
    ::gfx::mojom::RRectFDataView* output) {
  auto pointer = data_->backdrop_filter_bounds.Get();
  *output = ::gfx::mojom::RRectFDataView(pointer, context_);
}
inline void CompositorRenderPassDataView::GetCopyRequestsDataView(
    mojo::ArrayDataView<::viz::mojom::CopyOutputRequestDataView>* output) {
  auto pointer = data_->copy_requests.Get();
  *output = mojo::ArrayDataView<::viz::mojom::CopyOutputRequestDataView>(pointer, context_);
}
inline void CompositorRenderPassDataView::GetQuadListDataView(
    mojo::ArrayDataView<::viz::mojom::DrawQuadDataView>* output) {
  auto pointer = data_->quad_list.Get();
  *output = mojo::ArrayDataView<::viz::mojom::DrawQuadDataView>(pointer, context_);
}



}  // namespace mojom
}  // namespace viz

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_COMPOSITOR_RENDER_PASS_MOJOM_SHARED_H_