// third_party/blink/public/mojom/content_index/content_index.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_CONTENT_INDEX_CONTENT_INDEX_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_CONTENT_INDEX_CONTENT_INDEX_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "third_party/blink/public/mojom/content_index/content_index.mojom-shared.h"
#include "third_party/blink/public/mojom/content_index/content_index.mojom-blink-forward.h"
#include "skia/public/mojom/bitmap.mojom-blink.h"
#include "third_party/blink/public/mojom/manifest/manifest.mojom-blink.h"
#include "url/mojom/url.mojom-blink.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"


#include "third_party/blink/renderer/platform/platform_export.h"




namespace WTF {
struct blink_mojom_internal_ContentIndexError_DataHashFn {
  static unsigned GetHash(const ::blink::mojom::ContentIndexError& value) {
    using utype = std::underlying_type<::blink::mojom::ContentIndexError>::type;
    return DefaultHash<utype>::Hash().GetHash(static_cast<utype>(value));
  }
  static bool Equal(const ::blink::mojom::ContentIndexError& left, const ::blink::mojom::ContentIndexError& right) {
    return left == right;
  }
  static const bool safe_to_compare_to_empty_or_deleted = true;
};

template <>
struct HashTraits<::blink::mojom::ContentIndexError>
    : public GenericHashTraits<::blink::mojom::ContentIndexError> {
  static_assert(true,
                "-1000000 is a reserved enum value");
  static_assert(true,
                "-1000001 is a reserved enum value");
  static const bool hasIsEmptyValueFunction = true;
  static bool IsEmptyValue(const ::blink::mojom::ContentIndexError& value) {
    return value == static_cast<::blink::mojom::ContentIndexError>(-1000000);
  }
  static void ConstructDeletedValue(::blink::mojom::ContentIndexError& slot, bool) {
    slot = static_cast<::blink::mojom::ContentIndexError>(-1000001);
  }
  static bool IsDeletedValue(const ::blink::mojom::ContentIndexError& value) {
    return value == static_cast<::blink::mojom::ContentIndexError>(-1000001);
  }
};
}  // namespace WTF


namespace WTF {
struct blink_mojom_internal_ContentCategory_DataHashFn {
  static unsigned GetHash(const ::blink::mojom::ContentCategory& value) {
    using utype = std::underlying_type<::blink::mojom::ContentCategory>::type;
    return DefaultHash<utype>::Hash().GetHash(static_cast<utype>(value));
  }
  static bool Equal(const ::blink::mojom::ContentCategory& left, const ::blink::mojom::ContentCategory& right) {
    return left == right;
  }
  static const bool safe_to_compare_to_empty_or_deleted = true;
};

template <>
struct HashTraits<::blink::mojom::ContentCategory>
    : public GenericHashTraits<::blink::mojom::ContentCategory> {
  static_assert(true,
                "-1000000 is a reserved enum value");
  static_assert(true,
                "-1000001 is a reserved enum value");
  static const bool hasIsEmptyValueFunction = true;
  static bool IsEmptyValue(const ::blink::mojom::ContentCategory& value) {
    return value == static_cast<::blink::mojom::ContentCategory>(-1000000);
  }
  static void ConstructDeletedValue(::blink::mojom::ContentCategory& slot, bool) {
    slot = static_cast<::blink::mojom::ContentCategory>(-1000001);
  }
  static bool IsDeletedValue(const ::blink::mojom::ContentCategory& value) {
    return value == static_cast<::blink::mojom::ContentCategory>(-1000001);
  }
};
}  // namespace WTF

// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace blink {
namespace mojom {
namespace blink {

class ContentIndexServiceProxy;

template <typename ImplRefTraits>
class ContentIndexServiceStub;

class ContentIndexServiceRequestValidator;
class ContentIndexServiceResponseValidator;


class PLATFORM_EXPORT ContentIndexService
    : public ContentIndexServiceInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = ContentIndexServiceInterfaceBase;
  using Proxy_ = ContentIndexServiceProxy;

  template <typename ImplRefTraits>
  using Stub_ = ContentIndexServiceStub<ImplRefTraits>;

  using RequestValidator_ = ContentIndexServiceRequestValidator;
  using ResponseValidator_ = ContentIndexServiceResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetIconSizesMinVersion = 0,
    kAddMinVersion = 0,
    kDeleteMinVersion = 0,
    kGetDescriptionsMinVersion = 0,
  };
  
  static constexpr int32_t kMaxIconResolution = 65536;
  virtual ~ContentIndexService() {}


  using GetIconSizesCallback = base::OnceCallback<void(const WTF::Vector<::gfx::Size>&)>;
  
  virtual void GetIconSizes(ContentCategory category, GetIconSizesCallback callback) = 0;


  using AddCallback = base::OnceCallback<void(ContentIndexError)>;
  
  virtual void Add(int64_t service_worker_registration_id, ContentDescriptionPtr description, const WTF::Vector<::SkBitmap>& icon, const ::blink::KURL& launchUrl, AddCallback callback) = 0;


  using DeleteCallback = base::OnceCallback<void(ContentIndexError)>;
  
  virtual void Delete(int64_t service_worker_registration_id, const WTF::String& id, DeleteCallback callback) = 0;


  using GetDescriptionsCallback = base::OnceCallback<void(ContentIndexError, WTF::Vector<ContentDescriptionPtr>)>;
  
  virtual void GetDescriptions(int64_t service_worker_registration_id, GetDescriptionsCallback callback) = 0;
};



class PLATFORM_EXPORT ContentIndexServiceProxy
    : public ContentIndexService {
 public:
  using InterfaceType = ContentIndexService;

  explicit ContentIndexServiceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetIconSizes(ContentCategory category, GetIconSizesCallback callback) final;
  
  void Add(int64_t service_worker_registration_id, ContentDescriptionPtr description, const WTF::Vector<::SkBitmap>& icon, const ::blink::KURL& launchUrl, AddCallback callback) final;
  
  void Delete(int64_t service_worker_registration_id, const WTF::String& id, DeleteCallback callback) final;
  
  void GetDescriptions(int64_t service_worker_registration_id, GetDescriptionsCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class PLATFORM_EXPORT ContentIndexServiceStubDispatch {
 public:
  static bool Accept(ContentIndexService* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ContentIndexService* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ContentIndexService>>
class ContentIndexServiceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ContentIndexServiceStub() {}
  ~ContentIndexServiceStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ContentIndexServiceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ContentIndexServiceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT ContentIndexServiceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT ContentIndexServiceResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class PLATFORM_EXPORT ContentIconDefinition {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ContentIconDefinition, T>::value>;
  using DataView = ContentIconDefinitionDataView;
  using Data_ = internal::ContentIconDefinition_Data;

  template <typename... Args>
  static ContentIconDefinitionPtr New(Args&&... args) {
    return ContentIconDefinitionPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ContentIconDefinitionPtr From(const U& u) {
    return mojo::TypeConverter<ContentIconDefinitionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ContentIconDefinition>::Convert(*this);
  }


  ContentIconDefinition();

  ContentIconDefinition(
      const WTF::String& src,
      const WTF::String& sizes,
      const WTF::String& type);

  ~ContentIconDefinition();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ContentIconDefinitionPtr>
  ContentIconDefinitionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ContentIconDefinition::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ContentIconDefinition::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ContentIconDefinition::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ContentIconDefinition_UnserializedMessageContext<
            UserType, ContentIconDefinition::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<ContentIconDefinition::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return ContentIconDefinition::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ContentIconDefinition_UnserializedMessageContext<
            UserType, ContentIconDefinition::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ContentIconDefinition::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  WTF::String src;
  
  WTF::String sizes;
  
  WTF::String type;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ContentIconDefinition::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ContentIconDefinition::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ContentIconDefinition::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ContentIconDefinition::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}









class PLATFORM_EXPORT ContentDescription {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ContentDescription, T>::value>;
  using DataView = ContentDescriptionDataView;
  using Data_ = internal::ContentDescription_Data;

  template <typename... Args>
  static ContentDescriptionPtr New(Args&&... args) {
    return ContentDescriptionPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ContentDescriptionPtr From(const U& u) {
    return mojo::TypeConverter<ContentDescriptionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ContentDescription>::Convert(*this);
  }


  ContentDescription();

  ContentDescription(
      const WTF::String& id,
      const WTF::String& title,
      const WTF::String& description,
      ContentCategory category,
      WTF::Vector<ContentIconDefinitionPtr> icons,
      const WTF::String& launch_url);

  ~ContentDescription();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ContentDescriptionPtr>
  ContentDescriptionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ContentDescription::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ContentDescription::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ContentDescription::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ContentDescription_UnserializedMessageContext<
            UserType, ContentDescription::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<ContentDescription::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return ContentDescription::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ContentDescription_UnserializedMessageContext<
            UserType, ContentDescription::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ContentDescription::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  WTF::String id;
  
  WTF::String title;
  
  WTF::String description;
  
  ContentCategory category;
  
  WTF::Vector<ContentIconDefinitionPtr> icons;
  
  WTF::String launch_url;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(ContentDescription);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ContentDescription::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ContentDescription::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ContentDescription::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ContentDescription::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
ContentIconDefinitionPtr ContentIconDefinition::Clone() const {
  return New(
      mojo::Clone(src),
      mojo::Clone(sizes),
      mojo::Clone(type)
  );
}

template <typename T, ContentIconDefinition::EnableIfSame<T>*>
bool ContentIconDefinition::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->src, other_struct.src))
    return false;
  if (!mojo::Equals(this->sizes, other_struct.sizes))
    return false;
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  return true;
}

template <typename T, ContentIconDefinition::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.src, rhs.src))
    return true;
  if (std::less<>{}(rhs.src, lhs.src))
    return false;
  if (std::less<>{}(lhs.sizes, rhs.sizes))
    return true;
  if (std::less<>{}(rhs.sizes, lhs.sizes))
    return false;
  if (std::less<>{}(lhs.type, rhs.type))
    return true;
  if (std::less<>{}(rhs.type, lhs.type))
    return false;
  return false;
}
template <typename StructPtrType>
ContentDescriptionPtr ContentDescription::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(title),
      mojo::Clone(description),
      mojo::Clone(category),
      mojo::Clone(icons),
      mojo::Clone(launch_url)
  );
}

template <typename T, ContentDescription::EnableIfSame<T>*>
bool ContentDescription::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->title, other_struct.title))
    return false;
  if (!mojo::Equals(this->description, other_struct.description))
    return false;
  if (!mojo::Equals(this->category, other_struct.category))
    return false;
  if (!mojo::Equals(this->icons, other_struct.icons))
    return false;
  if (!mojo::Equals(this->launch_url, other_struct.launch_url))
    return false;
  return true;
}

template <typename T, ContentDescription::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.id, rhs.id))
    return true;
  if (std::less<>{}(rhs.id, lhs.id))
    return false;
  if (std::less<>{}(lhs.title, rhs.title))
    return true;
  if (std::less<>{}(rhs.title, lhs.title))
    return false;
  if (std::less<>{}(lhs.description, rhs.description))
    return true;
  if (std::less<>{}(rhs.description, lhs.description))
    return false;
  if (std::less<>{}(lhs.category, rhs.category))
    return true;
  if (std::less<>{}(rhs.category, lhs.category))
    return false;
  if (std::less<>{}(lhs.icons, rhs.icons))
    return true;
  if (std::less<>{}(rhs.icons, lhs.icons))
    return false;
  if (std::less<>{}(lhs.launch_url, rhs.launch_url))
    return true;
  if (std::less<>{}(rhs.launch_url, lhs.launch_url))
    return false;
  return false;
}


}  // namespace blink
}  // namespace mojom
}  // namespace blink

namespace mojo {


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::ContentIconDefinition::DataView,
                                         ::blink::mojom::blink::ContentIconDefinitionPtr> {
  static bool IsNull(const ::blink::mojom::blink::ContentIconDefinitionPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::ContentIconDefinitionPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::ContentIconDefinition::src)& src(
      const ::blink::mojom::blink::ContentIconDefinitionPtr& input) {
    return input->src;
  }

  static const decltype(::blink::mojom::blink::ContentIconDefinition::sizes)& sizes(
      const ::blink::mojom::blink::ContentIconDefinitionPtr& input) {
    return input->sizes;
  }

  static const decltype(::blink::mojom::blink::ContentIconDefinition::type)& type(
      const ::blink::mojom::blink::ContentIconDefinitionPtr& input) {
    return input->type;
  }

  static bool Read(::blink::mojom::blink::ContentIconDefinition::DataView input, ::blink::mojom::blink::ContentIconDefinitionPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::ContentDescription::DataView,
                                         ::blink::mojom::blink::ContentDescriptionPtr> {
  static bool IsNull(const ::blink::mojom::blink::ContentDescriptionPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::ContentDescriptionPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::ContentDescription::id)& id(
      const ::blink::mojom::blink::ContentDescriptionPtr& input) {
    return input->id;
  }

  static const decltype(::blink::mojom::blink::ContentDescription::title)& title(
      const ::blink::mojom::blink::ContentDescriptionPtr& input) {
    return input->title;
  }

  static const decltype(::blink::mojom::blink::ContentDescription::description)& description(
      const ::blink::mojom::blink::ContentDescriptionPtr& input) {
    return input->description;
  }

  static decltype(::blink::mojom::blink::ContentDescription::category) category(
      const ::blink::mojom::blink::ContentDescriptionPtr& input) {
    return input->category;
  }

  static const decltype(::blink::mojom::blink::ContentDescription::icons)& icons(
      const ::blink::mojom::blink::ContentDescriptionPtr& input) {
    return input->icons;
  }

  static const decltype(::blink::mojom::blink::ContentDescription::launch_url)& launch_url(
      const ::blink::mojom::blink::ContentDescriptionPtr& input) {
    return input->launch_url;
  }

  static bool Read(::blink::mojom::blink::ContentDescription::DataView input, ::blink::mojom::blink::ContentDescriptionPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_CONTENT_INDEX_CONTENT_INDEX_MOJOM_BLINK_H_