// third_party/blink/public/mojom/file_system_access/native_file_system_file_handle.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILE_SYSTEM_ACCESS_NATIVE_FILE_SYSTEM_FILE_HANDLE_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILE_SYSTEM_ACCESS_NATIVE_FILE_SYSTEM_FILE_HANDLE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "third_party/blink/public/mojom/file_system_access/native_file_system_file_handle.mojom-shared.h"
#include "third_party/blink/public/mojom/file_system_access/native_file_system_file_handle.mojom-forward.h"
#include "mojo/public/mojom/base/file_info.mojom.h"
#include "third_party/blink/public/mojom/blob/blob.mojom-forward.h"
#include "third_party/blink/public/mojom/blob/serialized_blob.mojom.h"
#include "third_party/blink/public/mojom/file_system_access/native_file_system_error.mojom.h"
#include "third_party/blink/public/mojom/file_system_access/native_file_system_file_writer.mojom.h"
#include "third_party/blink/public/mojom/file_system_access/native_file_system_transfer_token.mojom.h"
#include "third_party/blink/public/mojom/permissions/permission_status.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"


#include "third_party/blink/public/common/common_export.h"



// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace blink {
namespace mojom {

class NativeFileSystemFileHandleProxy;

template <typename ImplRefTraits>
class NativeFileSystemFileHandleStub;

class NativeFileSystemFileHandleRequestValidator;
class NativeFileSystemFileHandleResponseValidator;


class BLINK_COMMON_EXPORT NativeFileSystemFileHandle
    : public NativeFileSystemFileHandleInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = NativeFileSystemFileHandleInterfaceBase;
  using Proxy_ = NativeFileSystemFileHandleProxy;

  template <typename ImplRefTraits>
  using Stub_ = NativeFileSystemFileHandleStub<ImplRefTraits>;

  using RequestValidator_ = NativeFileSystemFileHandleRequestValidator;
  using ResponseValidator_ = NativeFileSystemFileHandleResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetPermissionStatusMinVersion = 0,
    kRequestPermissionMinVersion = 0,
    kAsBlobMinVersion = 0,
    kCreateFileWriterMinVersion = 0,
    kIsSameEntryMinVersion = 0,
    kTransferMinVersion = 0,
  };
  virtual ~NativeFileSystemFileHandle() {}


  using GetPermissionStatusCallback = base::OnceCallback<void(::blink::mojom::PermissionStatus)>;
  
  virtual void GetPermissionStatus(bool writable, GetPermissionStatusCallback callback) = 0;


  using RequestPermissionCallback = base::OnceCallback<void(::blink::mojom::NativeFileSystemErrorPtr, ::blink::mojom::PermissionStatus)>;
  
  virtual void RequestPermission(bool writable, RequestPermissionCallback callback) = 0;


  using AsBlobCallback = base::OnceCallback<void(::blink::mojom::NativeFileSystemErrorPtr, const ::base::File::Info&, ::blink::mojom::SerializedBlobPtr)>;
  
  virtual void AsBlob(AsBlobCallback callback) = 0;


  using CreateFileWriterCallback = base::OnceCallback<void(::blink::mojom::NativeFileSystemErrorPtr, ::mojo::PendingRemote<::blink::mojom::NativeFileSystemFileWriter>)>;
  
  virtual void CreateFileWriter(bool keep_existing_data, CreateFileWriterCallback callback) = 0;


  using IsSameEntryCallback = base::OnceCallback<void(::blink::mojom::NativeFileSystemErrorPtr, bool)>;
  
  virtual void IsSameEntry(::mojo::PendingRemote<::blink::mojom::NativeFileSystemTransferToken> other, IsSameEntryCallback callback) = 0;

  
  virtual void Transfer(::mojo::PendingReceiver<::blink::mojom::NativeFileSystemTransferToken> token) = 0;
};



class BLINK_COMMON_EXPORT NativeFileSystemFileHandleProxy
    : public NativeFileSystemFileHandle {
 public:
  using InterfaceType = NativeFileSystemFileHandle;

  explicit NativeFileSystemFileHandleProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetPermissionStatus(bool writable, GetPermissionStatusCallback callback) final;
  
  void RequestPermission(bool writable, RequestPermissionCallback callback) final;
  
  void AsBlob(AsBlobCallback callback) final;
  
  void CreateFileWriter(bool keep_existing_data, CreateFileWriterCallback callback) final;
  
  void IsSameEntry(::mojo::PendingRemote<::blink::mojom::NativeFileSystemTransferToken> other, IsSameEntryCallback callback) final;
  
  void Transfer(::mojo::PendingReceiver<::blink::mojom::NativeFileSystemTransferToken> token) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_COMMON_EXPORT NativeFileSystemFileHandleStubDispatch {
 public:
  static bool Accept(NativeFileSystemFileHandle* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      NativeFileSystemFileHandle* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<NativeFileSystemFileHandle>>
class NativeFileSystemFileHandleStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  NativeFileSystemFileHandleStub() {}
  ~NativeFileSystemFileHandleStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NativeFileSystemFileHandleStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NativeFileSystemFileHandleStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT NativeFileSystemFileHandleRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT NativeFileSystemFileHandleResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // namespace mojom
}  // namespace blink

namespace mojo {

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILE_SYSTEM_ACCESS_NATIVE_FILE_SYSTEM_FILE_HANDLE_MOJOM_H_