// third_party/blink/public/mojom/payments/payment_credential.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAYMENTS_PAYMENT_CREDENTIAL_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAYMENTS_PAYMENT_CREDENTIAL_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "third_party/blink/public/mojom/payments/payment_credential.mojom-shared.h"
#include "third_party/blink/public/mojom/payments/payment_credential.mojom-forward.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"


#include "third_party/blink/public/common/common_export.h"



// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace payments {
namespace mojom {

class PaymentCredentialProxy;

template <typename ImplRefTraits>
class PaymentCredentialStub;

class PaymentCredentialRequestValidator;
class PaymentCredentialResponseValidator;


class BLINK_COMMON_EXPORT PaymentCredential
    : public PaymentCredentialInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = PaymentCredentialInterfaceBase;
  using Proxy_ = PaymentCredentialProxy;

  template <typename ImplRefTraits>
  using Stub_ = PaymentCredentialStub<ImplRefTraits>;

  using RequestValidator_ = PaymentCredentialRequestValidator;
  using ResponseValidator_ = PaymentCredentialResponseValidator;
  enum MethodMinVersions : uint32_t {
    kStorePaymentCredentialMinVersion = 0,
  };
  virtual ~PaymentCredential() {}


  using StorePaymentCredentialCallback = base::OnceCallback<void(PaymentCredentialCreationStatus)>;
  
  virtual void StorePaymentCredential(PaymentCredentialInstrumentPtr instrument, const std::vector<uint8_t>& credential_id, const std::string& rp_id, StorePaymentCredentialCallback callback) = 0;
};



class BLINK_COMMON_EXPORT PaymentCredentialProxy
    : public PaymentCredential {
 public:
  using InterfaceType = PaymentCredential;

  explicit PaymentCredentialProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void StorePaymentCredential(PaymentCredentialInstrumentPtr instrument, const std::vector<uint8_t>& credential_id, const std::string& rp_id, StorePaymentCredentialCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_COMMON_EXPORT PaymentCredentialStubDispatch {
 public:
  static bool Accept(PaymentCredential* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PaymentCredential* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PaymentCredential>>
class PaymentCredentialStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PaymentCredentialStub() {}
  ~PaymentCredentialStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PaymentCredentialStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PaymentCredentialStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT PaymentCredentialRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT PaymentCredentialResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class BLINK_COMMON_EXPORT PaymentCredentialInstrument {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PaymentCredentialInstrument, T>::value>;
  using DataView = PaymentCredentialInstrumentDataView;
  using Data_ = internal::PaymentCredentialInstrument_Data;

  template <typename... Args>
  static PaymentCredentialInstrumentPtr New(Args&&... args) {
    return PaymentCredentialInstrumentPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PaymentCredentialInstrumentPtr From(const U& u) {
    return mojo::TypeConverter<PaymentCredentialInstrumentPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PaymentCredentialInstrument>::Convert(*this);
  }


  PaymentCredentialInstrument();

  PaymentCredentialInstrument(
      const std::string& display_name,
      const ::GURL& icon);

  ~PaymentCredentialInstrument();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PaymentCredentialInstrumentPtr>
  PaymentCredentialInstrumentPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PaymentCredentialInstrument::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PaymentCredentialInstrument::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PaymentCredentialInstrument::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PaymentCredentialInstrument_UnserializedMessageContext<
            UserType, PaymentCredentialInstrument::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<PaymentCredentialInstrument::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return PaymentCredentialInstrument::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PaymentCredentialInstrument_UnserializedMessageContext<
            UserType, PaymentCredentialInstrument::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PaymentCredentialInstrument::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  std::string display_name;
  
  ::GURL icon;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PaymentCredentialInstrument::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PaymentCredentialInstrument::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PaymentCredentialInstrument::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PaymentCredentialInstrument::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
PaymentCredentialInstrumentPtr PaymentCredentialInstrument::Clone() const {
  return New(
      mojo::Clone(display_name),
      mojo::Clone(icon)
  );
}

template <typename T, PaymentCredentialInstrument::EnableIfSame<T>*>
bool PaymentCredentialInstrument::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->display_name, other_struct.display_name))
    return false;
  if (!mojo::Equals(this->icon, other_struct.icon))
    return false;
  return true;
}

template <typename T, PaymentCredentialInstrument::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.display_name, rhs.display_name))
    return true;
  if (std::less<>{}(rhs.display_name, lhs.display_name))
    return false;
  if (std::less<>{}(lhs.icon, rhs.icon))
    return true;
  if (std::less<>{}(rhs.icon, lhs.icon))
    return false;
  return false;
}


}  // namespace mojom
}  // namespace payments

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT StructTraits<::payments::mojom::PaymentCredentialInstrument::DataView,
                                         ::payments::mojom::PaymentCredentialInstrumentPtr> {
  static bool IsNull(const ::payments::mojom::PaymentCredentialInstrumentPtr& input) { return !input; }
  static void SetToNull(::payments::mojom::PaymentCredentialInstrumentPtr* output) { output->reset(); }

  static const decltype(::payments::mojom::PaymentCredentialInstrument::display_name)& display_name(
      const ::payments::mojom::PaymentCredentialInstrumentPtr& input) {
    return input->display_name;
  }

  static const decltype(::payments::mojom::PaymentCredentialInstrument::icon)& icon(
      const ::payments::mojom::PaymentCredentialInstrumentPtr& input) {
    return input->icon;
  }

  static bool Read(::payments::mojom::PaymentCredentialInstrument::DataView input, ::payments::mojom::PaymentCredentialInstrumentPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAYMENTS_PAYMENT_CREDENTIAL_MOJOM_H_