// third_party/blink/public/mojom/service_worker/service_worker_provider.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/service_worker/service_worker_provider.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "third_party/blink/public/mojom/service_worker/service_worker_provider.mojom-params-data.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_provider.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/service_worker/service_worker_provider.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_SERVICE_WORKER_PROVIDER_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_SERVICE_WORKER_PROVIDER_MOJOM_JUMBO_H_
#endif
namespace blink {
namespace mojom {
const char kNavigation_ServiceWorkerSpec[] = "navigation:service_worker";
ServiceWorkerProviderInfoForStartWorker::ServiceWorkerProviderInfoForStartWorker()
    : host_remote(),
      script_loader_factory_remote(),
      cache_storage(),
      browser_interface_broker() {}

ServiceWorkerProviderInfoForStartWorker::ServiceWorkerProviderInfoForStartWorker(
    ::mojo::PendingAssociatedRemote<::blink::mojom::ServiceWorkerContainerHost> host_remote_in,
    ::mojo::PendingRemote<::network::mojom::URLLoaderFactory> script_loader_factory_remote_in,
    ::mojo::PendingRemote<::blink::mojom::CacheStorage> cache_storage_in,
    ::mojo::PendingRemote<::blink::mojom::BrowserInterfaceBroker> browser_interface_broker_in)
    : host_remote(std::move(host_remote_in)),
      script_loader_factory_remote(std::move(script_loader_factory_remote_in)),
      cache_storage(std::move(cache_storage_in)),
      browser_interface_broker(std::move(browser_interface_broker_in)) {}

ServiceWorkerProviderInfoForStartWorker::~ServiceWorkerProviderInfoForStartWorker() = default;

void ServiceWorkerProviderInfoForStartWorker::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetBoolean("host_remote", this->host_remote.is_valid());
  value->SetBoolean("script_loader_factory_remote", this->script_loader_factory_remote.is_valid());
  value->SetBoolean("cache_storage", this->cache_storage.is_valid());
  value->SetBoolean("browser_interface_broker", this->browser_interface_broker.is_valid());
}

bool ServiceWorkerProviderInfoForStartWorker::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char ServiceWorkerWorkerClient::Name_[] = "blink.mojom.ServiceWorkerWorkerClient";

ServiceWorkerWorkerClientProxy::ServiceWorkerWorkerClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ServiceWorkerWorkerClientProxy::OnControllerChanged(
    ::blink::mojom::ControllerServiceWorkerMode in_mode) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ServiceWorkerWorkerClient::OnControllerChanged", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("mode", base::trace_event::ValueToString(in_mode));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerWorkerClient_OnControllerChanged_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::ServiceWorkerWorkerClient_OnControllerChanged_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::blink::mojom::ControllerServiceWorkerMode>(
      in_mode, &params->mode);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerWorkerClient::Name_);
  message.set_method_name("OnControllerChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool ServiceWorkerWorkerClientStubDispatch::Accept(
    ServiceWorkerWorkerClient* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kServiceWorkerWorkerClient_OnControllerChanged_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ServiceWorkerWorkerClient::OnControllerChanged",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ServiceWorkerWorkerClient::OnControllerChanged");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ServiceWorkerWorkerClient_OnControllerChanged_Params_Data* params =
          reinterpret_cast<internal::ServiceWorkerWorkerClient_OnControllerChanged_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::ControllerServiceWorkerMode p_mode{};
      ServiceWorkerWorkerClient_OnControllerChanged_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadMode(&p_mode))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerWorkerClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnControllerChanged(
std::move(p_mode));
      return true;
    }
  }
  return false;
}

// static
bool ServiceWorkerWorkerClientStubDispatch::AcceptWithResponder(
    ServiceWorkerWorkerClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kServiceWorkerWorkerClient_OnControllerChanged_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kServiceWorkerWorkerClientValidationInfo[] = {
    {internal::kServiceWorkerWorkerClient_OnControllerChanged_Name,
     {&internal::ServiceWorkerWorkerClient_OnControllerChanged_Params_Data::Validate,
      nullptr /* no response */}},
};

bool ServiceWorkerWorkerClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::ServiceWorkerWorkerClient::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kServiceWorkerWorkerClientValidationInfo);
}

const char ServiceWorkerWorkerClientRegistry::Name_[] = "blink.mojom.ServiceWorkerWorkerClientRegistry";

ServiceWorkerWorkerClientRegistryProxy::ServiceWorkerWorkerClientRegistryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ServiceWorkerWorkerClientRegistryProxy::RegisterWorkerClient(
    ::mojo::PendingRemote<ServiceWorkerWorkerClient> in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ServiceWorkerWorkerClientRegistry::RegisterWorkerClient", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("client", in_client.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerWorkerClientRegistry_RegisterWorkerClient_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::ServiceWorkerWorkerClientRegistry_RegisterWorkerClient_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::ServiceWorkerWorkerClientInterfaceBase>>(
      in_client, &params->client, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid client in ServiceWorkerWorkerClientRegistry.RegisterWorkerClient request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerWorkerClientRegistry::Name_);
  message.set_method_name("RegisterWorkerClient");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void ServiceWorkerWorkerClientRegistryProxy::CloneWorkerClientRegistry(
    ::mojo::PendingReceiver<ServiceWorkerWorkerClientRegistry> in_host) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ServiceWorkerWorkerClientRegistry::CloneWorkerClientRegistry", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("host", in_host.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kServiceWorkerWorkerClientRegistry_CloneWorkerClientRegistry_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::ServiceWorkerWorkerClientRegistry_CloneWorkerClientRegistry_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::ServiceWorkerWorkerClientRegistryInterfaceBase>>(
      in_host, &params->host, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->host),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid host in ServiceWorkerWorkerClientRegistry.CloneWorkerClientRegistry request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerWorkerClientRegistry::Name_);
  message.set_method_name("CloneWorkerClientRegistry");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool ServiceWorkerWorkerClientRegistryStubDispatch::Accept(
    ServiceWorkerWorkerClientRegistry* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kServiceWorkerWorkerClientRegistry_RegisterWorkerClient_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ServiceWorkerWorkerClientRegistry::RegisterWorkerClient",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ServiceWorkerWorkerClientRegistry::RegisterWorkerClient");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ServiceWorkerWorkerClientRegistry_RegisterWorkerClient_Params_Data* params =
          reinterpret_cast<internal::ServiceWorkerWorkerClientRegistry_RegisterWorkerClient_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<ServiceWorkerWorkerClient> p_client{};
      ServiceWorkerWorkerClientRegistry_RegisterWorkerClient_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerWorkerClientRegistry::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RegisterWorkerClient(
std::move(p_client));
      return true;
    }
    case internal::kServiceWorkerWorkerClientRegistry_CloneWorkerClientRegistry_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ServiceWorkerWorkerClientRegistry::CloneWorkerClientRegistry",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ServiceWorkerWorkerClientRegistry::CloneWorkerClientRegistry");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ServiceWorkerWorkerClientRegistry_CloneWorkerClientRegistry_Params_Data* params =
          reinterpret_cast<internal::ServiceWorkerWorkerClientRegistry_CloneWorkerClientRegistry_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<ServiceWorkerWorkerClientRegistry> p_host{};
      ServiceWorkerWorkerClientRegistry_CloneWorkerClientRegistry_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success) {
        p_host =
            input_data_view.TakeHost<decltype(p_host)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerWorkerClientRegistry::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CloneWorkerClientRegistry(
std::move(p_host));
      return true;
    }
  }
  return false;
}

// static
bool ServiceWorkerWorkerClientRegistryStubDispatch::AcceptWithResponder(
    ServiceWorkerWorkerClientRegistry* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kServiceWorkerWorkerClientRegistry_RegisterWorkerClient_Name: {
      break;
    }
    case internal::kServiceWorkerWorkerClientRegistry_CloneWorkerClientRegistry_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kServiceWorkerWorkerClientRegistryValidationInfo[] = {
    {internal::kServiceWorkerWorkerClientRegistry_RegisterWorkerClient_Name,
     {&internal::ServiceWorkerWorkerClientRegistry_RegisterWorkerClient_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kServiceWorkerWorkerClientRegistry_CloneWorkerClientRegistry_Name,
     {&internal::ServiceWorkerWorkerClientRegistry_CloneWorkerClientRegistry_Params_Data::Validate,
      nullptr /* no response */}},
};

bool ServiceWorkerWorkerClientRegistryRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::ServiceWorkerWorkerClientRegistry::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kServiceWorkerWorkerClientRegistryValidationInfo);
}

}  // namespace mojom
}  // namespace blink

namespace mojo {


// static
bool StructTraits<::blink::mojom::ServiceWorkerProviderInfoForStartWorker::DataView, ::blink::mojom::ServiceWorkerProviderInfoForStartWorkerPtr>::Read(
    ::blink::mojom::ServiceWorkerProviderInfoForStartWorker::DataView input,
    ::blink::mojom::ServiceWorkerProviderInfoForStartWorkerPtr* output) {
  bool success = true;
  ::blink::mojom::ServiceWorkerProviderInfoForStartWorkerPtr result(::blink::mojom::ServiceWorkerProviderInfoForStartWorker::New());
  
      if (success) {
        result->host_remote =
            input.TakeHostRemote<decltype(result->host_remote)>();
      }
      if (success) {
        result->script_loader_factory_remote =
            input.TakeScriptLoaderFactoryRemote<decltype(result->script_loader_factory_remote)>();
      }
      if (success) {
        result->cache_storage =
            input.TakeCacheStorage<decltype(result->cache_storage)>();
      }
      if (success) {
        result->browser_interface_broker =
            input.TakeBrowserInterfaceBroker<decltype(result->browser_interface_broker)>();
      }
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif