// components/services/storage/public/mojom/blob_storage_context.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_BLOB_STORAGE_CONTEXT_MOJOM_PARAMS_DATA_H_
#define COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_BLOB_STORAGE_CONTEXT_MOJOM_PARAMS_DATA_H_

#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

namespace mojo::internal {
class ValidationContext;
}


namespace storage::mojom {
namespace internal {
class  BlobDataItemReader_Read_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint64_t offset;
  uint64_t length;
  mojo::internal::Handle_Data pipe;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<BlobDataItemReader_Read_Params_Data>;

  BlobDataItemReader_Read_Params_Data();
  ~BlobDataItemReader_Read_Params_Data() = delete;
};
static_assert(sizeof(BlobDataItemReader_Read_Params_Data) == 32,
              "Bad sizeof(BlobDataItemReader_Read_Params_Data)");
class  BlobDataItemReader_Read_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t success;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<BlobDataItemReader_Read_ResponseParams_Data>;

  BlobDataItemReader_Read_ResponseParams_Data();
  ~BlobDataItemReader_Read_ResponseParams_Data() = delete;
};
static_assert(sizeof(BlobDataItemReader_Read_ResponseParams_Data) == 16,
              "Bad sizeof(BlobDataItemReader_Read_ResponseParams_Data)");
class  BlobDataItemReader_ReadSideData_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<BlobDataItemReader_ReadSideData_Params_Data>;

  BlobDataItemReader_ReadSideData_Params_Data();
  ~BlobDataItemReader_ReadSideData_Params_Data() = delete;
};
static_assert(sizeof(BlobDataItemReader_ReadSideData_Params_Data) == 8,
              "Bad sizeof(BlobDataItemReader_ReadSideData_Params_Data)");
class  BlobDataItemReader_ReadSideData_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t success;
  uint8_t pad0_[4];
  ::mojo_base::mojom::internal::BigBuffer_Data data;

 private:
  friend class mojo::internal::MessageFragment<BlobDataItemReader_ReadSideData_ResponseParams_Data>;

  BlobDataItemReader_ReadSideData_ResponseParams_Data();
  ~BlobDataItemReader_ReadSideData_ResponseParams_Data() = delete;
};
static_assert(sizeof(BlobDataItemReader_ReadSideData_ResponseParams_Data) == 32,
              "Bad sizeof(BlobDataItemReader_ReadSideData_ResponseParams_Data)");
class  BlobStorageContext_RegisterFromDataItem_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Handle_Data blob;
  uint8_t pad0_[4];
  mojo::internal::Pointer<mojo::internal::String_Data> uuid;
  mojo::internal::Pointer<internal::BlobDataItem_Data> item;

 private:
  friend class mojo::internal::MessageFragment<BlobStorageContext_RegisterFromDataItem_Params_Data>;

  BlobStorageContext_RegisterFromDataItem_Params_Data();
  ~BlobStorageContext_RegisterFromDataItem_Params_Data() = delete;
};
static_assert(sizeof(BlobStorageContext_RegisterFromDataItem_Params_Data) == 32,
              "Bad sizeof(BlobStorageContext_RegisterFromDataItem_Params_Data)");
class  BlobStorageContext_RegisterFromMemory_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Handle_Data blob;
  uint8_t pad0_[4];
  mojo::internal::Pointer<mojo::internal::String_Data> uuid;
  ::mojo_base::mojom::internal::BigBuffer_Data data;

 private:
  friend class mojo::internal::MessageFragment<BlobStorageContext_RegisterFromMemory_Params_Data>;

  BlobStorageContext_RegisterFromMemory_Params_Data();
  ~BlobStorageContext_RegisterFromMemory_Params_Data() = delete;
};
static_assert(sizeof(BlobStorageContext_RegisterFromMemory_Params_Data) == 40,
              "Bad sizeof(BlobStorageContext_RegisterFromMemory_Params_Data)");
class  BlobStorageContext_WriteBlobToFile_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Interface_Data blob;
  mojo::internal::Pointer<::mojo_base::mojom::internal::FilePath_Data> path;
  uint8_t flush_on_write : 1;
  uint8_t pad2_[7];
  mojo::internal::Pointer<::mojo_base::mojom::internal::Time_Data> last_modified;

 private:
  friend class mojo::internal::MessageFragment<BlobStorageContext_WriteBlobToFile_Params_Data>;

  BlobStorageContext_WriteBlobToFile_Params_Data();
  ~BlobStorageContext_WriteBlobToFile_Params_Data() = delete;
};
static_assert(sizeof(BlobStorageContext_WriteBlobToFile_Params_Data) == 40,
              "Bad sizeof(BlobStorageContext_WriteBlobToFile_Params_Data)");
class  BlobStorageContext_WriteBlobToFile_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t result;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<BlobStorageContext_WriteBlobToFile_ResponseParams_Data>;

  BlobStorageContext_WriteBlobToFile_ResponseParams_Data();
  ~BlobStorageContext_WriteBlobToFile_ResponseParams_Data() = delete;
};
static_assert(sizeof(BlobStorageContext_WriteBlobToFile_ResponseParams_Data) == 16,
              "Bad sizeof(BlobStorageContext_WriteBlobToFile_ResponseParams_Data)");
class  BlobStorageContext_Clone_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Handle_Data receiver;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<BlobStorageContext_Clone_Params_Data>;

  BlobStorageContext_Clone_Params_Data();
  ~BlobStorageContext_Clone_Params_Data() = delete;
};
static_assert(sizeof(BlobStorageContext_Clone_Params_Data) == 16,
              "Bad sizeof(BlobStorageContext_Clone_Params_Data)");

}  // namespace internal


class BlobDataItemReader_Read_ParamsDataView {
 public:
  BlobDataItemReader_Read_ParamsDataView() = default;

  BlobDataItemReader_Read_ParamsDataView(
      internal::BlobDataItemReader_Read_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint64_t offset() const {
    return data_->offset;
  }
  uint64_t length() const {
    return data_->length;
  }
  mojo::ScopedDataPipeProducerHandle TakePipe() {
    mojo::ScopedDataPipeProducerHandle result;
    bool ret =
        mojo::internal::Deserialize<mojo::ScopedDataPipeProducerHandle>(
            &data_->pipe, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::BlobDataItemReader_Read_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class BlobDataItemReader_Read_ResponseParamsDataView {
 public:
  BlobDataItemReader_Read_ResponseParamsDataView() = default;

  BlobDataItemReader_Read_ResponseParamsDataView(
      internal::BlobDataItemReader_Read_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int32_t success() const {
    return data_->success;
  }
 private:
  internal::BlobDataItemReader_Read_ResponseParams_Data* data_ = nullptr;
};


class BlobDataItemReader_ReadSideData_ParamsDataView {
 public:
  BlobDataItemReader_ReadSideData_ParamsDataView() = default;

  BlobDataItemReader_ReadSideData_ParamsDataView(
      internal::BlobDataItemReader_ReadSideData_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::BlobDataItemReader_ReadSideData_Params_Data* data_ = nullptr;
};


class BlobDataItemReader_ReadSideData_ResponseParamsDataView {
 public:
  BlobDataItemReader_ReadSideData_ResponseParamsDataView() = default;

  BlobDataItemReader_ReadSideData_ResponseParamsDataView(
      internal::BlobDataItemReader_ReadSideData_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t success() const {
    return data_->success;
  }
  inline void GetDataDataView(
      ::mojo_base::mojom::BigBufferDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadData(UserType* output) {
    
    auto* pointer = !data_->data.is_null() ? &data_->data : nullptr;
    return mojo::internal::Deserialize<::mojo_base::mojom::BigBufferDataView>(
        pointer, output, message_);
  }
 private:
  internal::BlobDataItemReader_ReadSideData_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class BlobStorageContext_RegisterFromDataItem_ParamsDataView {
 public:
  BlobStorageContext_RegisterFromDataItem_ParamsDataView() = default;

  BlobStorageContext_RegisterFromDataItem_ParamsDataView(
      internal::BlobStorageContext_RegisterFromDataItem_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeBlob() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::blink::mojom::BlobInterfaceBase>>(
            &data_->blob, &result, message_);
    DCHECK(ret);
    return result;
  }
  inline void GetUuidDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUuid(UserType* output) {
    
    auto* pointer = data_->uuid.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetItemDataView(
      BlobDataItemDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadItem(UserType* output) {
    
    auto* pointer = data_->item.Get();
    return mojo::internal::Deserialize<::storage::mojom::BlobDataItemDataView>(
        pointer, output, message_);
  }
 private:
  internal::BlobStorageContext_RegisterFromDataItem_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class BlobStorageContext_RegisterFromMemory_ParamsDataView {
 public:
  BlobStorageContext_RegisterFromMemory_ParamsDataView() = default;

  BlobStorageContext_RegisterFromMemory_ParamsDataView(
      internal::BlobStorageContext_RegisterFromMemory_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeBlob() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::blink::mojom::BlobInterfaceBase>>(
            &data_->blob, &result, message_);
    DCHECK(ret);
    return result;
  }
  inline void GetUuidDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUuid(UserType* output) {
    
    auto* pointer = data_->uuid.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetDataDataView(
      ::mojo_base::mojom::BigBufferDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadData(UserType* output) {
    
    auto* pointer = !data_->data.is_null() ? &data_->data : nullptr;
    return mojo::internal::Deserialize<::mojo_base::mojom::BigBufferDataView>(
        pointer, output, message_);
  }
 private:
  internal::BlobStorageContext_RegisterFromMemory_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class BlobStorageContext_WriteBlobToFile_ParamsDataView {
 public:
  BlobStorageContext_WriteBlobToFile_ParamsDataView() = default;

  BlobStorageContext_WriteBlobToFile_ParamsDataView(
      internal::BlobStorageContext_WriteBlobToFile_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeBlob() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::blink::mojom::BlobInterfaceBase>>(
            &data_->blob, &result, message_);
    DCHECK(ret);
    return result;
  }
  inline void GetPathDataView(
      ::mojo_base::mojom::FilePathDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPath(UserType* output) {
    
    auto* pointer = data_->path.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::FilePathDataView>(
        pointer, output, message_);
  }
  bool flush_on_write() const {
    return data_->flush_on_write;
  }
  inline void GetLastModifiedDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLastModified(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDataView, UserType>(),
    "Attempting to read the optional `last_modified` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadLastModified` instead "
    "of `ReadLastModified if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->last_modified.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
 private:
  internal::BlobStorageContext_WriteBlobToFile_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class BlobStorageContext_WriteBlobToFile_ResponseParamsDataView {
 public:
  BlobStorageContext_WriteBlobToFile_ResponseParamsDataView() = default;

  BlobStorageContext_WriteBlobToFile_ResponseParamsDataView(
      internal::BlobStorageContext_WriteBlobToFile_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadResult(UserType* output) const {
    auto data_value = data_->result;
    return mojo::internal::Deserialize<::storage::mojom::WriteBlobToFileResult>(
        data_value, output);
  }
  WriteBlobToFileResult result() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::storage::mojom::WriteBlobToFileResult>(data_->result));
  }
 private:
  internal::BlobStorageContext_WriteBlobToFile_ResponseParams_Data* data_ = nullptr;
};


class BlobStorageContext_Clone_ParamsDataView {
 public:
  BlobStorageContext_Clone_ParamsDataView() = default;

  BlobStorageContext_Clone_ParamsDataView(
      internal::BlobStorageContext_Clone_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeReceiver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::storage::mojom::BlobStorageContextInterfaceBase>>(
            &data_->receiver, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::BlobStorageContext_Clone_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};







inline void BlobDataItemReader_ReadSideData_ResponseParamsDataView::GetDataDataView(
    ::mojo_base::mojom::BigBufferDataView* output) {
  auto pointer = &data_->data;
  *output = ::mojo_base::mojom::BigBufferDataView(pointer, message_);
}


inline void BlobStorageContext_RegisterFromDataItem_ParamsDataView::GetUuidDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->uuid.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void BlobStorageContext_RegisterFromDataItem_ParamsDataView::GetItemDataView(
    BlobDataItemDataView* output) {
  auto pointer = data_->item.Get();
  *output = BlobDataItemDataView(pointer, message_);
}


inline void BlobStorageContext_RegisterFromMemory_ParamsDataView::GetUuidDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->uuid.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void BlobStorageContext_RegisterFromMemory_ParamsDataView::GetDataDataView(
    ::mojo_base::mojom::BigBufferDataView* output) {
  auto pointer = &data_->data;
  *output = ::mojo_base::mojom::BigBufferDataView(pointer, message_);
}


inline void BlobStorageContext_WriteBlobToFile_ParamsDataView::GetPathDataView(
    ::mojo_base::mojom::FilePathDataView* output) {
  auto pointer = data_->path.Get();
  *output = ::mojo_base::mojom::FilePathDataView(pointer, message_);
}
inline void BlobStorageContext_WriteBlobToFile_ParamsDataView::GetLastModifiedDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->last_modified.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, message_);
}







}  // storage::mojom

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_BLOB_STORAGE_CONTEXT_MOJOM_PARAMS_DATA_H_