// extensions/common/mojom/code_injection.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef EXTENSIONS_COMMON_MOJOM_CODE_INJECTION_MOJOM_SHARED_H_
#define EXTENSIONS_COMMON_MOJOM_CODE_INJECTION_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "extensions/common/mojom/code_injection.mojom-shared-internal.h"
#include "extensions/common/mojom/css_origin.mojom-shared.h"
#include "extensions/common/mojom/execution_world.mojom-shared.h"
#include "third_party/blink/public/mojom/script/script_evaluation_params.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"







namespace extensions::mojom {
class JSSourceDataView;

class CSSSourceDataView;

class JSInjectionDataView;

class CSSInjectionDataView;

class CodeInjectionDataView;


}  // extensions::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::extensions::mojom::JSSourceDataView> {
  using Data = ::extensions::mojom::internal::JSSource_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::extensions::mojom::CSSSourceDataView> {
  using Data = ::extensions::mojom::internal::CSSSource_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::extensions::mojom::JSInjectionDataView> {
  using Data = ::extensions::mojom::internal::JSInjection_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::extensions::mojom::CSSInjectionDataView> {
  using Data = ::extensions::mojom::internal::CSSInjection_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::extensions::mojom::CodeInjectionDataView> {
  using Data = ::extensions::mojom::internal::CodeInjection_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace extensions::mojom {


enum class CSSInjection_Operation : int32_t {
  
  kAdd = 0,
  
  kRemove = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, CSSInjection_Operation value);
inline bool IsKnownEnumValue(CSSInjection_Operation value) {
  return internal::CSSInjection_Operation_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class JSSourceDataView {
 public:
  JSSourceDataView() = default;

  JSSourceDataView(
      internal::JSSource_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetCodeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCode(UserType* output) {
    
    auto* pointer = data_->code.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetScriptUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScriptUrl(UserType* output) {
    
    auto* pointer = data_->script_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
 private:
  internal::JSSource_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CSSSourceDataView {
 public:
  CSSSourceDataView() = default;

  CSSSourceDataView(
      internal::CSSSource_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetCodeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCode(UserType* output) {
    
    auto* pointer = data_->code.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetKeyDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadKey(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `key` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadKey` instead "
    "of `ReadKey if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->key.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::CSSSource_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class JSInjectionDataView {
 public:
  JSInjectionDataView() = default;

  JSInjectionDataView(
      internal::JSInjection_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSourcesDataView(
      mojo::ArrayDataView<JSSourceDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSources(UserType* output) {
    
    auto* pointer = data_->sources.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::extensions::mojom::JSSourceDataView>>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadWorld(UserType* output) const {
    auto data_value = data_->world;
    return mojo::internal::Deserialize<::extensions::mojom::ExecutionWorld>(
        data_value, output);
  }
  ::extensions::mojom::ExecutionWorld world() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::extensions::mojom::ExecutionWorld>(data_->world));
  }
  inline void GetWorldIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadWorldId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `world_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadWorldId` instead "
    "of `ReadWorldId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->world_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadWantsResult(UserType* output) const {
    auto data_value = data_->wants_result;
    return mojo::internal::Deserialize<::blink::mojom::WantResultOption>(
        data_value, output);
  }
  ::blink::mojom::WantResultOption wants_result() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::WantResultOption>(data_->wants_result));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadUserGesture(UserType* output) const {
    auto data_value = data_->user_gesture;
    return mojo::internal::Deserialize<::blink::mojom::UserActivationOption>(
        data_value, output);
  }
  ::blink::mojom::UserActivationOption user_gesture() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::UserActivationOption>(data_->user_gesture));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadWaitForPromise(UserType* output) const {
    auto data_value = data_->wait_for_promise;
    return mojo::internal::Deserialize<::blink::mojom::PromiseResultOption>(
        data_value, output);
  }
  ::blink::mojom::PromiseResultOption wait_for_promise() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::PromiseResultOption>(data_->wait_for_promise));
  }
 private:
  internal::JSInjection_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CSSInjectionDataView {
 public:
  CSSInjectionDataView() = default;

  CSSInjectionDataView(
      internal::CSSInjection_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSourcesDataView(
      mojo::ArrayDataView<CSSSourceDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSources(UserType* output) {
    
    auto* pointer = data_->sources.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::extensions::mojom::CSSSourceDataView>>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadCssOrigin(UserType* output) const {
    auto data_value = data_->css_origin;
    return mojo::internal::Deserialize<::extensions::mojom::CSSOrigin>(
        data_value, output);
  }
  ::extensions::mojom::CSSOrigin css_origin() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::extensions::mojom::CSSOrigin>(data_->css_origin));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadOperation(UserType* output) const {
    auto data_value = data_->operation;
    return mojo::internal::Deserialize<::extensions::mojom::CSSInjection_Operation>(
        data_value, output);
  }
  CSSInjection_Operation operation() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::extensions::mojom::CSSInjection_Operation>(data_->operation));
  }
 private:
  internal::CSSInjection_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CodeInjectionDataView {
 public:
  using Tag = internal::CodeInjection_Data::CodeInjection_Tag;

  CodeInjectionDataView() = default;

  CodeInjectionDataView(
      internal::CodeInjection_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_css() const { return data_->tag == Tag::kCss; }
  inline void GetCssDataView(
      CSSInjectionDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadCss(UserType* output) const {
    
    CHECK(is_css());
    return mojo::internal::Deserialize<::extensions::mojom::CSSInjectionDataView>(
        data_->data.f_css.Get(), output, message_);
  }
  bool is_js() const { return data_->tag == Tag::kJs; }
  inline void GetJsDataView(
      JSInjectionDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadJs(UserType* output) const {
    
    CHECK(is_js());
    return mojo::internal::Deserialize<::extensions::mojom::JSInjectionDataView>(
        data_->data.f_js.Get(), output, message_);
  }

 private:
  internal::CodeInjection_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // extensions::mojom

namespace std {

template <>
struct hash<::extensions::mojom::CSSInjection_Operation>
    : public mojo::internal::EnumHashImpl<::extensions::mojom::CSSInjection_Operation> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::extensions::mojom::CSSInjection_Operation, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::extensions::mojom::CSSInjection_Operation, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::extensions::mojom::CSSInjection_Operation>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::extensions::mojom::JSSourceDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::extensions::mojom::JSSourceDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::extensions::mojom::internal::JSSource_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::code(input)) in_code = Traits::code(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->code)::BaseType> code_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_code, code_fragment);
    fragment->code.Set(
        code_fragment.is_null() ? nullptr : code_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->code.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null code in JSSource struct");
    decltype(Traits::script_url(input)) in_script_url = Traits::script_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->script_url)::BaseType> script_url_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_script_url, script_url_fragment);
    fragment->script_url.Set(
        script_url_fragment.is_null() ? nullptr : script_url_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->script_url.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null script_url in JSSource struct");
  }

  static bool Deserialize(::extensions::mojom::internal::JSSource_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::extensions::mojom::JSSourceDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::extensions::mojom::CSSSourceDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::extensions::mojom::CSSSourceDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::extensions::mojom::internal::CSSSource_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::code(input)) in_code = Traits::code(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->code)::BaseType> code_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_code, code_fragment);
    fragment->code.Set(
        code_fragment.is_null() ? nullptr : code_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->code.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null code in CSSSource struct");
    decltype(Traits::key(input)) in_key = Traits::key(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->key)::BaseType> key_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_key, key_fragment);
    fragment->key.Set(
        key_fragment.is_null() ? nullptr : key_fragment.data());
  }

  static bool Deserialize(::extensions::mojom::internal::CSSSource_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::extensions::mojom::CSSSourceDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::extensions::mojom::JSInjectionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::extensions::mojom::JSInjectionDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::extensions::mojom::internal::JSInjection_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::sources(input)) in_sources = Traits::sources(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->sources)::BaseType>
        sources_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& sources_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::extensions::mojom::JSSourceDataView>>(
        in_sources, sources_fragment, &sources_validate_params);
    fragment->sources.Set(
        sources_fragment.is_null() ? nullptr : sources_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->sources.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null sources in JSInjection struct");
    mojo::internal::Serialize<::extensions::mojom::ExecutionWorld>(
        Traits::world(input), &fragment->world);
    decltype(Traits::world_id(input)) in_world_id = Traits::world_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->world_id)::BaseType> world_id_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_world_id, world_id_fragment);
    fragment->world_id.Set(
        world_id_fragment.is_null() ? nullptr : world_id_fragment.data());
    mojo::internal::Serialize<::blink::mojom::WantResultOption>(
        Traits::wants_result(input), &fragment->wants_result);
    mojo::internal::Serialize<::blink::mojom::UserActivationOption>(
        Traits::user_gesture(input), &fragment->user_gesture);
    mojo::internal::Serialize<::blink::mojom::PromiseResultOption>(
        Traits::wait_for_promise(input), &fragment->wait_for_promise);
  }

  static bool Deserialize(::extensions::mojom::internal::JSInjection_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::extensions::mojom::JSInjectionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::extensions::mojom::CSSInjectionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::extensions::mojom::CSSInjectionDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::extensions::mojom::internal::CSSInjection_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::sources(input)) in_sources = Traits::sources(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->sources)::BaseType>
        sources_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& sources_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::extensions::mojom::CSSSourceDataView>>(
        in_sources, sources_fragment, &sources_validate_params);
    fragment->sources.Set(
        sources_fragment.is_null() ? nullptr : sources_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->sources.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null sources in CSSInjection struct");
    mojo::internal::Serialize<::extensions::mojom::CSSOrigin>(
        Traits::css_origin(input), &fragment->css_origin);
    mojo::internal::Serialize<::extensions::mojom::CSSInjection_Operation>(
        Traits::operation(input), &fragment->operation);
  }

  static bool Deserialize(::extensions::mojom::internal::CSSInjection_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::extensions::mojom::CSSInjectionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::extensions::mojom::CodeInjectionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::extensions::mojom::CodeInjectionDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::extensions::mojom::internal::CodeInjection_Data>& fragment,
                        bool inlined) {
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

    if (!inlined)
      fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
    fragment->size = kUnionDataSize;
    fragment->tag = Traits::GetTag(input);
    switch (fragment->tag) {
      case ::extensions::mojom::CodeInjectionDataView::Tag::kCss: {
        decltype(Traits::css(input))
            in_css = Traits::css(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_css)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::extensions::mojom::CSSInjectionDataView>(
            in_css, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null css in CodeInjection union");
        fragment->data.f_css.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
      case ::extensions::mojom::CodeInjectionDataView::Tag::kJs: {
        decltype(Traits::js(input))
            in_js = Traits::js(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_js)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::extensions::mojom::JSInjectionDataView>(
            in_js, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null js in CodeInjection union");
        fragment->data.f_js.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
    }
  }

  static bool Deserialize(::extensions::mojom::internal::CodeInjection_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::extensions::mojom::CodeInjectionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace extensions::mojom {

inline void JSSourceDataView::GetCodeDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->code.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void JSSourceDataView::GetScriptUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->script_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}


inline void CSSSourceDataView::GetCodeDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->code.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void CSSSourceDataView::GetKeyDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->key.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void JSInjectionDataView::GetSourcesDataView(
    mojo::ArrayDataView<JSSourceDataView>* output) {
  auto pointer = data_->sources.Get();
  *output = mojo::ArrayDataView<JSSourceDataView>(pointer, message_);
}
inline void JSInjectionDataView::GetWorldIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->world_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void CSSInjectionDataView::GetSourcesDataView(
    mojo::ArrayDataView<CSSSourceDataView>* output) {
  auto pointer = data_->sources.Get();
  *output = mojo::ArrayDataView<CSSSourceDataView>(pointer, message_);
}


inline void CodeInjectionDataView::GetCssDataView(
    CSSInjectionDataView* output) const {
  CHECK(is_css());
  *output = CSSInjectionDataView(data_->data.f_css.Get(), message_);
}
inline void CodeInjectionDataView::GetJsDataView(
    JSInjectionDataView* output) const {
  CHECK(is_js());
  *output = JSInjectionDataView(data_->data.f_js.Get(), message_);
}


}  // extensions::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::extensions::mojom::CSSInjection_Operation> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::extensions::mojom::CSSInjection_Operation value);
};

} // namespace perfetto

#endif  // EXTENSIONS_COMMON_MOJOM_CODE_INJECTION_MOJOM_SHARED_H_