// services/metrics/public/mojom/ukm_interface.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/metrics/public/mojom/ukm_interface.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/metrics/public/mojom/ukm_interface.mojom-params-data.h"
namespace ukm {
namespace mojom {

namespace internal {


// static
bool UkmEntry_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UkmEntry_Data* object =
      static_cast<const UkmEntry_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->metrics, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& metrics_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->metrics, validation_context,
                                         &metrics_validate_params)) {
    return false;
  }

  return true;
}

UkmEntry_Data::UkmEntry_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UkmRecorderParameters_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UkmRecorderParameters_Data* object =
      static_cast<const UkmRecorderParameters_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->event_hash_bypass_list, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& event_hash_bypass_list_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->event_hash_bypass_list, validation_context,
                                         &event_hash_bypass_list_validate_params)) {
    return false;
  }

  return true;
}

UkmRecorderParameters_Data::UkmRecorderParameters_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SingularUkmInterface_Submit_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SingularUkmInterface_Submit_Params_Data* object =
      static_cast<const SingularUkmInterface_Submit_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->entry, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->entry, validation_context))
    return false;

  return true;
}

SingularUkmInterface_Submit_Params_Data::SingularUkmInterface_Submit_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UkmRecorderClientInterface_SetParameters_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UkmRecorderClientInterface_SetParameters_Params_Data* object =
      static_cast<const UkmRecorderClientInterface_SetParameters_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->params, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->params, validation_context))
    return false;

  return true;
}

UkmRecorderClientInterface_SetParameters_Params_Data::UkmRecorderClientInterface_SetParameters_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UkmRecorderInterface_AddEntry_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UkmRecorderInterface_AddEntry_Params_Data* object =
      static_cast<const UkmRecorderInterface_AddEntry_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->entry, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->entry, validation_context))
    return false;

  return true;
}

UkmRecorderInterface_AddEntry_Params_Data::UkmRecorderInterface_AddEntry_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UkmRecorderInterface_UpdateSourceURL_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UkmRecorderInterface_UpdateSourceURL_Params_Data* object =
      static_cast<const UkmRecorderInterface_UpdateSourceURL_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& url_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->url, validation_context,
                                         &url_validate_params)) {
    return false;
  }

  return true;
}

UkmRecorderInterface_UpdateSourceURL_Params_Data::UkmRecorderInterface_UpdateSourceURL_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UkmRecorderFactory_CreateUkmRecorder_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UkmRecorderFactory_CreateUkmRecorder_Params_Data* object =
      static_cast<const UkmRecorderFactory_CreateUkmRecorder_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterface(object->client_remote,
                                                 validation_context)) {
    return false;
  }

  return true;
}

UkmRecorderFactory_CreateUkmRecorder_Params_Data::UkmRecorderFactory_CreateUkmRecorder_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace ukm