// third_party/blink/public/mojom/peerconnection/webrtc_ip_handling_url_entry.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PEERCONNECTION_WEBRTC_IP_HANDLING_URL_ENTRY_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PEERCONNECTION_WEBRTC_IP_HANDLING_URL_ENTRY_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/peerconnection/webrtc_ip_handling_url_entry.mojom-shared-internal.h"
#include "components/content_settings/core/common/content_settings.mojom-shared.h"
#include "third_party/blink/public/mojom/peerconnection/webrtc_ip_handling_policy.mojom-shared.h"



#include "base/component_export.h"




namespace blink::mojom {
class WebRtcIpHandlingUrlEntryDataView;



}  // blink::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::WebRtcIpHandlingUrlEntryDataView> {
  using Data = ::blink::mojom::internal::WebRtcIpHandlingUrlEntry_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


class WebRtcIpHandlingUrlEntryDataView {
 public:
  WebRtcIpHandlingUrlEntryDataView() = default;

  WebRtcIpHandlingUrlEntryDataView(
      internal::WebRtcIpHandlingUrlEntry_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUrlPatternDataView(
      ::content_settings::mojom::ContentSettingsPatternDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrlPattern(UserType* output) {
    
    auto* pointer = data_->url_pattern.Get();
    return mojo::internal::Deserialize<::content_settings::mojom::ContentSettingsPatternDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadHandling(UserType* output) const {
    auto data_value = data_->handling;
    return mojo::internal::Deserialize<::blink::mojom::WebRtcIpHandlingPolicy>(
        data_value, output);
  }
  ::blink::mojom::WebRtcIpHandlingPolicy handling() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::WebRtcIpHandlingPolicy>(data_->handling));
  }
 private:
  internal::WebRtcIpHandlingUrlEntry_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // blink::mojom

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::WebRtcIpHandlingUrlEntryDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::WebRtcIpHandlingUrlEntryDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::WebRtcIpHandlingUrlEntry_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::url_pattern(input)) in_url_pattern = Traits::url_pattern(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url_pattern)::BaseType> url_pattern_fragment(
            fragment.message());
    mojo::internal::Serialize<::content_settings::mojom::ContentSettingsPatternDataView>(
        in_url_pattern, url_pattern_fragment);
    fragment->url_pattern.Set(
        url_pattern_fragment.is_null() ? nullptr : url_pattern_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->url_pattern.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null url_pattern in WebRtcIpHandlingUrlEntry struct");
    mojo::internal::Serialize<::blink::mojom::WebRtcIpHandlingPolicy>(
        Traits::handling(input), &fragment->handling);
  }

  static bool Deserialize(::blink::mojom::internal::WebRtcIpHandlingUrlEntry_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::WebRtcIpHandlingUrlEntryDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {

inline void WebRtcIpHandlingUrlEntryDataView::GetUrlPatternDataView(
    ::content_settings::mojom::ContentSettingsPatternDataView* output) {
  auto pointer = data_->url_pattern.Get();
  *output = ::content_settings::mojom::ContentSettingsPatternDataView(pointer, message_);
}



}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_PEERCONNECTION_WEBRTC_IP_HANDLING_URL_ENTRY_MOJOM_SHARED_H_