// ui/accessibility/mojom/ax_tree_checks.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "ui/accessibility/mojom/ax_tree_checks.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "ui/accessibility/mojom/ax_tree_checks.mojom-params-data.h"
#include "ui/accessibility/mojom/ax_tree_checks.mojom-shared-message-ids.h"

#include "ui/accessibility/mojom/ax_tree_checks.mojom-blink-import-headers.h"
#include "ui/accessibility/mojom/ax_tree_checks.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace ax::mojom::blink {
AXTreeChecks::AXTreeChecks()
    : node_count() {}

AXTreeChecks::AXTreeChecks(
    uint64_t node_count_in)
    : node_count(std::move(node_count_in)) {}

AXTreeChecks::~AXTreeChecks() = default;
size_t AXTreeChecks::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->node_count);
  return seed;
}

void AXTreeChecks::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "node_count"), this->node_count,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AXTreeChecks::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}


}  // ax::mojom::blink


namespace mojo {


// static
bool StructTraits<::ax::mojom::blink::AXTreeChecks::DataView, ::ax::mojom::blink::AXTreeChecksPtr>::Read(
    ::ax::mojom::blink::AXTreeChecks::DataView input,
    ::ax::mojom::blink::AXTreeChecksPtr* output) {
  bool success = true;
  ::ax::mojom::blink::AXTreeChecksPtr result(::ax::mojom::blink::AXTreeChecks::New());
  
      if (success)
        result->node_count = input.node_count();
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace ax::mojom::blink {




}  // ax::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif