/*
 * MOTIS API
 *
 * This is the MOTIS routing API.  Overview of MOTIS API versions:  MOTIS 0.x - deprecated/discontinued  MOTIS 2.x - current, providing:  * /api/v5/{plan,trip,stoptimes,map/trips} renamed METRO mode to SUBURBAN, AREAL_LIFT to AERIAL_LIFT; since MOTIS 2.5.0 * /api/v4/{plan,trip,stoptimes,map/trips} new displayName property, routeShortName only contains actual route short name from source; since MOTIS 2.2.0 * /api/v3/plan with correct maxTransfers API parameter (transfers actually corresponding to number of changes between transit legs (and not to number of transit legs), i.e. maxTransfers=0 returns direct public transit connections, as expected); since MOTIS 2.0.84  * /api/v2/{plan,trip} returns Google polylines with precision=6; since MOTIS 2.0.60 * /api/v1/{plan,trip} returns Google polylines with precision=7 (not defined for |longitude|>107) * /api/v1/_* all other endpoints  If you use the JS client lib https://www.npmjs.com/package/@motis-project/motis-client, endpoint versions will be taken into account automatically (i.e. the newest one available will be used). 
 *
 * The version of the OpenAPI document: v5
 * Contact: felix@triptix.tech
 * Generated by: https://openapi-generator.tech
 */

use crate::models;
use serde::{Deserialize, Serialize};

/// Rental : Vehicle rental
#[derive(Clone, Default, Debug, PartialEq, Serialize, Deserialize)]
pub struct Rental {
    /// Rental provider ID
    #[serde(rename = "providerId")]
    pub provider_id: String,
    /// Rental provider group ID
    #[serde(rename = "providerGroupId")]
    pub provider_group_id: String,
    /// Vehicle share system ID
    #[serde(rename = "systemId")]
    pub system_id: String,
    /// Vehicle share system name
    #[serde(rename = "systemName", skip_serializing_if = "Option::is_none")]
    pub system_name: Option<String>,
    /// URL of the vehicle share system
    #[serde(rename = "url", skip_serializing_if = "Option::is_none")]
    pub url: Option<String>,
    /// Color associated with this provider, in hexadecimal RGB format (e.g. \"#FF0000\" for red). Can be empty. 
    #[serde(rename = "color", skip_serializing_if = "Option::is_none")]
    pub color: Option<String>,
    /// Name of the station
    #[serde(rename = "stationName", skip_serializing_if = "Option::is_none")]
    pub station_name: Option<String>,
    /// Name of the station where the vehicle is picked up (empty for free floating vehicles)
    #[serde(rename = "fromStationName", skip_serializing_if = "Option::is_none")]
    pub from_station_name: Option<String>,
    /// Name of the station where the vehicle is returned (empty for free floating vehicles)
    #[serde(rename = "toStationName", skip_serializing_if = "Option::is_none")]
    pub to_station_name: Option<String>,
    /// Rental URI for Android (deep link to the specific station or vehicle)
    #[serde(rename = "rentalUriAndroid", skip_serializing_if = "Option::is_none")]
    pub rental_uri_android: Option<String>,
    /// Rental URI for iOS (deep link to the specific station or vehicle)
    #[serde(rename = "rentalUriIOS", skip_serializing_if = "Option::is_none")]
    pub rental_uri_ios: Option<String>,
    /// Rental URI for web (deep link to the specific station or vehicle)
    #[serde(rename = "rentalUriWeb", skip_serializing_if = "Option::is_none")]
    pub rental_uri_web: Option<String>,
    #[serde(rename = "formFactor", skip_serializing_if = "Option::is_none")]
    pub form_factor: Option<models::RentalFormFactor>,
    #[serde(rename = "propulsionType", skip_serializing_if = "Option::is_none")]
    pub propulsion_type: Option<models::RentalPropulsionType>,
    #[serde(rename = "returnConstraint", skip_serializing_if = "Option::is_none")]
    pub return_constraint: Option<models::RentalReturnConstraint>,
}

impl Rental {
    /// Vehicle rental
    pub fn new(provider_id: String, provider_group_id: String, system_id: String) -> Rental {
        Rental {
            provider_id,
            provider_group_id,
            system_id,
            system_name: None,
            url: None,
            color: None,
            station_name: None,
            from_station_name: None,
            to_station_name: None,
            rental_uri_android: None,
            rental_uri_ios: None,
            rental_uri_web: None,
            form_factor: None,
            propulsion_type: None,
            return_constraint: None,
        }
    }
}

