/* parser auto-generated by pidl */

#include "replace.h"
#include "bin/default/librpc/gen_ndr/ndr_ODJ.h"

#include "librpc/gen_ndr/ndr_misc.h"
#include "librpc/gen_ndr/ndr_lsa.h"
#include "librpc/gen_ndr/ndr_netlogon.h"
#include "librpc/gen_ndr/ndr_security.h"
static enum ndr_err_code ndr_push_OP_BLOB(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct OP_BLOB *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->cbBlob));
		{
			libndr_flags _flags_save_uint8 = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
			NDR_CHECK(ndr_push_unique_ptr(ndr, r->pBlob));
			ndr->flags = _flags_save_uint8;
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			libndr_flags _flags_save_uint8 = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
			if (r->pBlob) {
				NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->cbBlob));
				NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->pBlob, r->cbBlob));
			}
			ndr->flags = _flags_save_uint8;
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_OP_BLOB(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct OP_BLOB *r)
{
	uint32_t _ptr_pBlob;
	uint32_t size_pBlob_1 = 0;
	TALLOC_CTX *_mem_save_pBlob_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->cbBlob));
		{
			libndr_flags _flags_save_uint8 = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pBlob));
			if (_ptr_pBlob) {
				NDR_PULL_ALLOC(ndr, r->pBlob);
			} else {
				r->pBlob = NULL;
			}
			ndr->flags = _flags_save_uint8;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			libndr_flags _flags_save_uint8 = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
			if (r->pBlob) {
				_mem_save_pBlob_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->pBlob, 0);
				NDR_CHECK(ndr_pull_array_size(ndr, &r->pBlob));
				NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->pBlob, &size_pBlob_1));
				NDR_PULL_ALLOC_N(ndr, r->pBlob, size_pBlob_1);
				NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->pBlob, size_pBlob_1));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pBlob_0, 0);
			}
			ndr->flags = _flags_save_uint8;
		}
		if (r->pBlob) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->pBlob, r->cbBlob));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_OP_BLOB(struct ndr_print *ndr, const char *name, const struct OP_BLOB *r)
{
	ndr_print_struct(ndr, name, "OP_BLOB");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "cbBlob", r->cbBlob);
	{
		libndr_flags _flags_save_uint8 = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		ndr_print_ptr(ndr, "pBlob", r->pBlob);
		ndr->depth++;
		if (r->pBlob) {
			ndr_print_array_uint8(ndr, "pBlob", r->pBlob, r->cbBlob);
		}
		ndr->depth--;
		ndr->flags = _flags_save_uint8;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_ODJ_POLICY_DNS_DOMAIN_INFO(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct ODJ_POLICY_DNS_DOMAIN_INFO *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_lsa_StringLarge(ndr, NDR_SCALARS, &r->Name));
		NDR_CHECK(ndr_push_lsa_StringLarge(ndr, NDR_SCALARS, &r->DnsDomainName));
		NDR_CHECK(ndr_push_lsa_StringLarge(ndr, NDR_SCALARS, &r->DnsForestName));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->DomainGuid));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->Sid));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_lsa_StringLarge(ndr, NDR_BUFFERS, &r->Name));
		NDR_CHECK(ndr_push_lsa_StringLarge(ndr, NDR_BUFFERS, &r->DnsDomainName));
		NDR_CHECK(ndr_push_lsa_StringLarge(ndr, NDR_BUFFERS, &r->DnsForestName));
		if (r->Sid) {
			NDR_CHECK(ndr_push_dom_sid2(ndr, NDR_SCALARS|NDR_BUFFERS, r->Sid));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_ODJ_POLICY_DNS_DOMAIN_INFO(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct ODJ_POLICY_DNS_DOMAIN_INFO *r)
{
	uint32_t _ptr_Sid;
	TALLOC_CTX *_mem_save_Sid_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_lsa_StringLarge(ndr, NDR_SCALARS, &r->Name));
		NDR_CHECK(ndr_pull_lsa_StringLarge(ndr, NDR_SCALARS, &r->DnsDomainName));
		NDR_CHECK(ndr_pull_lsa_StringLarge(ndr, NDR_SCALARS, &r->DnsForestName));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->DomainGuid));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_Sid));
		if (_ptr_Sid) {
			NDR_PULL_ALLOC(ndr, r->Sid);
		} else {
			r->Sid = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_lsa_StringLarge(ndr, NDR_BUFFERS, &r->Name));
		NDR_CHECK(ndr_pull_lsa_StringLarge(ndr, NDR_BUFFERS, &r->DnsDomainName));
		NDR_CHECK(ndr_pull_lsa_StringLarge(ndr, NDR_BUFFERS, &r->DnsForestName));
		if (r->Sid) {
			_mem_save_Sid_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->Sid, 0);
			NDR_CHECK(ndr_pull_dom_sid2(ndr, NDR_SCALARS|NDR_BUFFERS, r->Sid));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_Sid_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_ODJ_POLICY_DNS_DOMAIN_INFO(struct ndr_print *ndr, const char *name, const struct ODJ_POLICY_DNS_DOMAIN_INFO *r)
{
	ndr_print_struct(ndr, name, "ODJ_POLICY_DNS_DOMAIN_INFO");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_lsa_StringLarge(ndr, "Name", &r->Name);
	ndr_print_lsa_StringLarge(ndr, "DnsDomainName", &r->DnsDomainName);
	ndr_print_lsa_StringLarge(ndr, "DnsForestName", &r->DnsForestName);
	ndr_print_GUID(ndr, "DomainGuid", &r->DomainGuid);
	ndr_print_ptr(ndr, "Sid", r->Sid);
	ndr->depth++;
	if (r->Sid) {
		ndr_print_dom_sid2(ndr, "Sid", r->Sid);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_ODJ_WIN7BLOB(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct ODJ_WIN7BLOB *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->lpDomain));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->lpMachineName));
		{
			libndr_flags _flags_save_uint16 = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_IS_SECRET);
			NDR_CHECK(ndr_push_unique_ptr(ndr, r->lpMachinePassword));
			ndr->flags = _flags_save_uint16;
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0xffffffff));
		NDR_CHECK(ndr_push_ODJ_POLICY_DNS_DOMAIN_INFO(ndr, NDR_SCALARS, &r->DnsDomainInfo));
		NDR_CHECK(ndr_push_netr_DsRGetDCNameInfo(ndr, NDR_SCALARS, &r->DcInfo));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->Options));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->lpDomain) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->lpDomain, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->lpDomain, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->lpDomain, ndr_charset_length(r->lpDomain, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->lpMachineName) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->lpMachineName, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->lpMachineName, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->lpMachineName, ndr_charset_length(r->lpMachineName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		{
			libndr_flags _flags_save_uint16 = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_IS_SECRET);
			if (r->lpMachinePassword) {
				NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->lpMachinePassword, CH_UTF16)));
				NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
				NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->lpMachinePassword, CH_UTF16)));
				NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->lpMachinePassword, ndr_charset_length(r->lpMachinePassword, CH_UTF16), sizeof(uint16_t), CH_UTF16));
			}
			ndr->flags = _flags_save_uint16;
		}
		NDR_CHECK(ndr_push_ODJ_POLICY_DNS_DOMAIN_INFO(ndr, NDR_BUFFERS, &r->DnsDomainInfo));
		NDR_CHECK(ndr_push_netr_DsRGetDCNameInfo(ndr, NDR_BUFFERS, &r->DcInfo));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_ODJ_WIN7BLOB(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct ODJ_WIN7BLOB *r)
{
	uint32_t _ptr_lpDomain;
	uint32_t size_lpDomain_1 = 0;
	uint32_t length_lpDomain_1 = 0;
	TALLOC_CTX *_mem_save_lpDomain_0 = NULL;
	uint32_t _ptr_lpMachineName;
	uint32_t size_lpMachineName_1 = 0;
	uint32_t length_lpMachineName_1 = 0;
	TALLOC_CTX *_mem_save_lpMachineName_0 = NULL;
	uint32_t _ptr_lpMachinePassword;
	uint32_t size_lpMachinePassword_1 = 0;
	uint32_t length_lpMachinePassword_1 = 0;
	TALLOC_CTX *_mem_save_lpMachinePassword_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_lpDomain));
		if (_ptr_lpDomain) {
			NDR_PULL_ALLOC(ndr, r->lpDomain);
		} else {
			r->lpDomain = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_lpMachineName));
		if (_ptr_lpMachineName) {
			NDR_PULL_ALLOC(ndr, r->lpMachineName);
		} else {
			r->lpMachineName = NULL;
		}
		{
			libndr_flags _flags_save_uint16 = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_IS_SECRET);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_lpMachinePassword));
			if (_ptr_lpMachinePassword) {
				NDR_PULL_ALLOC(ndr, r->lpMachinePassword);
			} else {
				r->lpMachinePassword = NULL;
			}
			ndr->flags = _flags_save_uint16;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->_pad));
		NDR_CHECK(ndr_pull_ODJ_POLICY_DNS_DOMAIN_INFO(ndr, NDR_SCALARS, &r->DnsDomainInfo));
		NDR_CHECK(ndr_pull_netr_DsRGetDCNameInfo(ndr, NDR_SCALARS, &r->DcInfo));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->Options));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->lpDomain) {
			_mem_save_lpDomain_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->lpDomain, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->lpDomain));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->lpDomain));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->lpDomain, &size_lpDomain_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->lpDomain, &length_lpDomain_1));
			if (length_lpDomain_1 > size_lpDomain_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_lpDomain_1, length_lpDomain_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_lpDomain_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->lpDomain, length_lpDomain_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpDomain_0, 0);
		}
		if (r->lpMachineName) {
			_mem_save_lpMachineName_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->lpMachineName, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->lpMachineName));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->lpMachineName));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->lpMachineName, &size_lpMachineName_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->lpMachineName, &length_lpMachineName_1));
			if (length_lpMachineName_1 > size_lpMachineName_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_lpMachineName_1, length_lpMachineName_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_lpMachineName_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->lpMachineName, length_lpMachineName_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpMachineName_0, 0);
		}
		{
			libndr_flags _flags_save_uint16 = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_IS_SECRET);
			if (r->lpMachinePassword) {
				_mem_save_lpMachinePassword_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->lpMachinePassword, 0);
				NDR_CHECK(ndr_pull_array_size(ndr, &r->lpMachinePassword));
				NDR_CHECK(ndr_pull_array_length(ndr, &r->lpMachinePassword));
				NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->lpMachinePassword, &size_lpMachinePassword_1));
				NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->lpMachinePassword, &length_lpMachinePassword_1));
				if (length_lpMachinePassword_1 > size_lpMachinePassword_1) {
					return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_lpMachinePassword_1, length_lpMachinePassword_1);
				}
				NDR_CHECK(ndr_check_string_terminator(ndr, length_lpMachinePassword_1, sizeof(uint16_t)));
				NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->lpMachinePassword, length_lpMachinePassword_1, sizeof(uint16_t), CH_UTF16));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpMachinePassword_0, 0);
			}
			ndr->flags = _flags_save_uint16;
		}
		NDR_CHECK(ndr_pull_ODJ_POLICY_DNS_DOMAIN_INFO(ndr, NDR_BUFFERS, &r->DnsDomainInfo));
		NDR_CHECK(ndr_pull_netr_DsRGetDCNameInfo(ndr, NDR_BUFFERS, &r->DcInfo));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_ODJ_WIN7BLOB(struct ndr_print *ndr, const char *name, const struct ODJ_WIN7BLOB *r)
{
	ndr_print_struct(ndr, name, "ODJ_WIN7BLOB");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "lpDomain", r->lpDomain);
	ndr->depth++;
	if (r->lpDomain) {
		ndr_print_string(ndr, "lpDomain", r->lpDomain);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "lpMachineName", r->lpMachineName);
	ndr->depth++;
	if (r->lpMachineName) {
		ndr_print_string(ndr, "lpMachineName", r->lpMachineName);
	}
	ndr->depth--;
	{
		libndr_flags _flags_save_uint16 = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_IS_SECRET);
		ndr_print_ptr(ndr, "lpMachinePassword", r->lpMachinePassword);
		ndr->depth++;
		if (r->lpMachinePassword) {
			ndr_print_string(ndr, "lpMachinePassword", r->lpMachinePassword);
		}
		ndr->depth--;
		ndr->flags = _flags_save_uint16;
	}
	ndr_print_uint32(ndr, "_pad", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0xffffffff:r->_pad);
	ndr_print_ODJ_POLICY_DNS_DOMAIN_INFO(ndr, "DnsDomainInfo", &r->DnsDomainInfo);
	ndr_print_netr_DsRGetDCNameInfo(ndr, "DcInfo", &r->DcInfo);
	ndr_print_uint32(ndr, "Options", r->Options);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_OP_JOINPROV2_PART(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct OP_JOINPROV2_PART *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwFlags));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->lpNetbiosName));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->lpSiteName));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->lpPrimaryDNSDomain));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwReserved));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->lpReserved));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->lpNetbiosName) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->lpNetbiosName, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->lpNetbiosName, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->lpNetbiosName, ndr_charset_length(r->lpNetbiosName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->lpSiteName) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->lpSiteName, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->lpSiteName, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->lpSiteName, ndr_charset_length(r->lpSiteName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->lpPrimaryDNSDomain) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->lpPrimaryDNSDomain, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->lpPrimaryDNSDomain, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->lpPrimaryDNSDomain, ndr_charset_length(r->lpPrimaryDNSDomain, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->lpReserved) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->lpReserved, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->lpReserved, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->lpReserved, ndr_charset_length(r->lpReserved, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_OP_JOINPROV2_PART(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct OP_JOINPROV2_PART *r)
{
	uint32_t _ptr_lpNetbiosName;
	uint32_t size_lpNetbiosName_1 = 0;
	uint32_t length_lpNetbiosName_1 = 0;
	TALLOC_CTX *_mem_save_lpNetbiosName_0 = NULL;
	uint32_t _ptr_lpSiteName;
	uint32_t size_lpSiteName_1 = 0;
	uint32_t length_lpSiteName_1 = 0;
	TALLOC_CTX *_mem_save_lpSiteName_0 = NULL;
	uint32_t _ptr_lpPrimaryDNSDomain;
	uint32_t size_lpPrimaryDNSDomain_1 = 0;
	uint32_t length_lpPrimaryDNSDomain_1 = 0;
	TALLOC_CTX *_mem_save_lpPrimaryDNSDomain_0 = NULL;
	uint32_t _ptr_lpReserved;
	uint32_t size_lpReserved_1 = 0;
	uint32_t length_lpReserved_1 = 0;
	TALLOC_CTX *_mem_save_lpReserved_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwFlags));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_lpNetbiosName));
		if (_ptr_lpNetbiosName) {
			NDR_PULL_ALLOC(ndr, r->lpNetbiosName);
		} else {
			r->lpNetbiosName = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_lpSiteName));
		if (_ptr_lpSiteName) {
			NDR_PULL_ALLOC(ndr, r->lpSiteName);
		} else {
			r->lpSiteName = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_lpPrimaryDNSDomain));
		if (_ptr_lpPrimaryDNSDomain) {
			NDR_PULL_ALLOC(ndr, r->lpPrimaryDNSDomain);
		} else {
			r->lpPrimaryDNSDomain = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwReserved));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_lpReserved));
		if (_ptr_lpReserved) {
			NDR_PULL_ALLOC(ndr, r->lpReserved);
		} else {
			r->lpReserved = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->lpNetbiosName) {
			_mem_save_lpNetbiosName_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->lpNetbiosName, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->lpNetbiosName));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->lpNetbiosName));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->lpNetbiosName, &size_lpNetbiosName_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->lpNetbiosName, &length_lpNetbiosName_1));
			if (length_lpNetbiosName_1 > size_lpNetbiosName_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_lpNetbiosName_1, length_lpNetbiosName_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_lpNetbiosName_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->lpNetbiosName, length_lpNetbiosName_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpNetbiosName_0, 0);
		}
		if (r->lpSiteName) {
			_mem_save_lpSiteName_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->lpSiteName, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->lpSiteName));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->lpSiteName));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->lpSiteName, &size_lpSiteName_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->lpSiteName, &length_lpSiteName_1));
			if (length_lpSiteName_1 > size_lpSiteName_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_lpSiteName_1, length_lpSiteName_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_lpSiteName_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->lpSiteName, length_lpSiteName_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpSiteName_0, 0);
		}
		if (r->lpPrimaryDNSDomain) {
			_mem_save_lpPrimaryDNSDomain_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->lpPrimaryDNSDomain, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->lpPrimaryDNSDomain));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->lpPrimaryDNSDomain));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->lpPrimaryDNSDomain, &size_lpPrimaryDNSDomain_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->lpPrimaryDNSDomain, &length_lpPrimaryDNSDomain_1));
			if (length_lpPrimaryDNSDomain_1 > size_lpPrimaryDNSDomain_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_lpPrimaryDNSDomain_1, length_lpPrimaryDNSDomain_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_lpPrimaryDNSDomain_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->lpPrimaryDNSDomain, length_lpPrimaryDNSDomain_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpPrimaryDNSDomain_0, 0);
		}
		if (r->lpReserved) {
			_mem_save_lpReserved_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->lpReserved, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->lpReserved));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->lpReserved));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->lpReserved, &size_lpReserved_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->lpReserved, &length_lpReserved_1));
			if (length_lpReserved_1 > size_lpReserved_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_lpReserved_1, length_lpReserved_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_lpReserved_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->lpReserved, length_lpReserved_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpReserved_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_OP_JOINPROV2_PART(struct ndr_print *ndr, const char *name, const struct OP_JOINPROV2_PART *r)
{
	ndr_print_struct(ndr, name, "OP_JOINPROV2_PART");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "dwFlags", r->dwFlags);
	ndr_print_ptr(ndr, "lpNetbiosName", r->lpNetbiosName);
	ndr->depth++;
	if (r->lpNetbiosName) {
		ndr_print_string(ndr, "lpNetbiosName", r->lpNetbiosName);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "lpSiteName", r->lpSiteName);
	ndr->depth++;
	if (r->lpSiteName) {
		ndr_print_string(ndr, "lpSiteName", r->lpSiteName);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "lpPrimaryDNSDomain", r->lpPrimaryDNSDomain);
	ndr->depth++;
	if (r->lpPrimaryDNSDomain) {
		ndr_print_string(ndr, "lpPrimaryDNSDomain", r->lpPrimaryDNSDomain);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "dwReserved", r->dwReserved);
	ndr_print_ptr(ndr, "lpReserved", r->lpReserved);
	ndr->depth++;
	if (r->lpReserved) {
		ndr_print_string(ndr, "lpReserved", r->lpReserved);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_OP_JOINPROV3_PART(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct OP_JOINPROV3_PART *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->Rid));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->lpSid));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->lpSid) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->lpSid, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->lpSid, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->lpSid, ndr_charset_length(r->lpSid, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_OP_JOINPROV3_PART(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct OP_JOINPROV3_PART *r)
{
	uint32_t _ptr_lpSid;
	uint32_t size_lpSid_1 = 0;
	uint32_t length_lpSid_1 = 0;
	TALLOC_CTX *_mem_save_lpSid_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->Rid));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_lpSid));
		if (_ptr_lpSid) {
			NDR_PULL_ALLOC(ndr, r->lpSid);
		} else {
			r->lpSid = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->lpSid) {
			_mem_save_lpSid_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->lpSid, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->lpSid));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->lpSid));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->lpSid, &size_lpSid_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->lpSid, &length_lpSid_1));
			if (length_lpSid_1 > size_lpSid_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_lpSid_1, length_lpSid_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_lpSid_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->lpSid, length_lpSid_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpSid_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_OP_JOINPROV3_PART(struct ndr_print *ndr, const char *name, const struct OP_JOINPROV3_PART *r)
{
	ndr_print_struct(ndr, name, "OP_JOINPROV3_PART");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "Rid", r->Rid);
	ndr_print_ptr(ndr, "lpSid", r->lpSid);
	ndr->depth++;
	if (r->lpSid) {
		ndr_print_string(ndr, "lpSid", r->lpSid);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_OP_POLICY_ELEMENT(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct OP_POLICY_ELEMENT *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pKeyPath));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pValueName));
		NDR_CHECK(ndr_push_winreg_Type(ndr, NDR_SCALARS, r->ulValueType));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->cbValueData));
		{
			libndr_flags _flags_save_uint8 = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
			NDR_CHECK(ndr_push_unique_ptr(ndr, r->pValueData));
			ndr->flags = _flags_save_uint8;
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->pKeyPath) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pKeyPath, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pKeyPath, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->pKeyPath, ndr_charset_length(r->pKeyPath, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->pValueName) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pValueName, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pValueName, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->pValueName, ndr_charset_length(r->pValueName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		{
			libndr_flags _flags_save_uint8 = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
			if (r->pValueData) {
				NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->cbValueData));
				NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->pValueData, r->cbValueData));
			}
			ndr->flags = _flags_save_uint8;
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_OP_POLICY_ELEMENT(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct OP_POLICY_ELEMENT *r)
{
	uint32_t _ptr_pKeyPath;
	uint32_t size_pKeyPath_1 = 0;
	uint32_t length_pKeyPath_1 = 0;
	TALLOC_CTX *_mem_save_pKeyPath_0 = NULL;
	uint32_t _ptr_pValueName;
	uint32_t size_pValueName_1 = 0;
	uint32_t length_pValueName_1 = 0;
	TALLOC_CTX *_mem_save_pValueName_0 = NULL;
	uint32_t _ptr_pValueData;
	uint32_t size_pValueData_1 = 0;
	TALLOC_CTX *_mem_save_pValueData_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pKeyPath));
		if (_ptr_pKeyPath) {
			NDR_PULL_ALLOC(ndr, r->pKeyPath);
		} else {
			r->pKeyPath = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pValueName));
		if (_ptr_pValueName) {
			NDR_PULL_ALLOC(ndr, r->pValueName);
		} else {
			r->pValueName = NULL;
		}
		NDR_CHECK(ndr_pull_winreg_Type(ndr, NDR_SCALARS, &r->ulValueType));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->cbValueData));
		{
			libndr_flags _flags_save_uint8 = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pValueData));
			if (_ptr_pValueData) {
				NDR_PULL_ALLOC(ndr, r->pValueData);
			} else {
				r->pValueData = NULL;
			}
			ndr->flags = _flags_save_uint8;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->pKeyPath) {
			_mem_save_pKeyPath_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pKeyPath, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->pKeyPath));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->pKeyPath));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->pKeyPath, &size_pKeyPath_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->pKeyPath, &length_pKeyPath_1));
			if (length_pKeyPath_1 > size_pKeyPath_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pKeyPath_1, length_pKeyPath_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pKeyPath_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->pKeyPath, length_pKeyPath_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pKeyPath_0, 0);
		}
		if (r->pValueName) {
			_mem_save_pValueName_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pValueName, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->pValueName));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->pValueName));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->pValueName, &size_pValueName_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->pValueName, &length_pValueName_1));
			if (length_pValueName_1 > size_pValueName_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pValueName_1, length_pValueName_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pValueName_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->pValueName, length_pValueName_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pValueName_0, 0);
		}
		{
			libndr_flags _flags_save_uint8 = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
			if (r->pValueData) {
				_mem_save_pValueData_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->pValueData, 0);
				NDR_CHECK(ndr_pull_array_size(ndr, &r->pValueData));
				NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->pValueData, &size_pValueData_1));
				NDR_PULL_ALLOC_N(ndr, r->pValueData, size_pValueData_1);
				NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->pValueData, size_pValueData_1));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pValueData_0, 0);
			}
			ndr->flags = _flags_save_uint8;
		}
		if (r->pValueData) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->pValueData, r->cbValueData));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_OP_POLICY_ELEMENT(struct ndr_print *ndr, const char *name, const struct OP_POLICY_ELEMENT *r)
{
	ndr_print_struct(ndr, name, "OP_POLICY_ELEMENT");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "pKeyPath", r->pKeyPath);
	ndr->depth++;
	if (r->pKeyPath) {
		ndr_print_string(ndr, "pKeyPath", r->pKeyPath);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "pValueName", r->pValueName);
	ndr->depth++;
	if (r->pValueName) {
		ndr_print_string(ndr, "pValueName", r->pValueName);
	}
	ndr->depth--;
	ndr_print_winreg_Type(ndr, "ulValueType", r->ulValueType);
	ndr_print_uint32(ndr, "cbValueData", r->cbValueData);
	{
		libndr_flags _flags_save_uint8 = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		ndr_print_ptr(ndr, "pValueData", r->pValueData);
		ndr->depth++;
		if (r->pValueData) {
			ndr_print_array_uint8(ndr, "pValueData", r->pValueData, r->cbValueData);
		}
		ndr->depth--;
		ndr->flags = _flags_save_uint8;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_OP_POLICY_ELEMENT_LIST(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct OP_POLICY_ELEMENT_LIST *r)
{
	uint32_t cntr_pElements_1;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pSource));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->ulRootKeyId));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->cElements));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pElements));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->pSource) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pSource, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pSource, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->pSource, ndr_charset_length(r->pSource, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->pElements) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->cElements));
			for (cntr_pElements_1 = 0; cntr_pElements_1 < (r->cElements); cntr_pElements_1++) {
				NDR_CHECK(ndr_push_OP_POLICY_ELEMENT(ndr, NDR_SCALARS, &r->pElements[cntr_pElements_1]));
			}
			for (cntr_pElements_1 = 0; cntr_pElements_1 < (r->cElements); cntr_pElements_1++) {
				NDR_CHECK(ndr_push_OP_POLICY_ELEMENT(ndr, NDR_BUFFERS, &r->pElements[cntr_pElements_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_OP_POLICY_ELEMENT_LIST(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct OP_POLICY_ELEMENT_LIST *r)
{
	uint32_t _ptr_pSource;
	uint32_t size_pSource_1 = 0;
	uint32_t length_pSource_1 = 0;
	TALLOC_CTX *_mem_save_pSource_0 = NULL;
	uint32_t _ptr_pElements;
	uint32_t size_pElements_1 = 0;
	uint32_t cntr_pElements_1;
	TALLOC_CTX *_mem_save_pElements_0 = NULL;
	TALLOC_CTX *_mem_save_pElements_1 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pSource));
		if (_ptr_pSource) {
			NDR_PULL_ALLOC(ndr, r->pSource);
		} else {
			r->pSource = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->ulRootKeyId));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->cElements));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pElements));
		if (_ptr_pElements) {
			NDR_PULL_ALLOC(ndr, r->pElements);
		} else {
			r->pElements = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->pSource) {
			_mem_save_pSource_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pSource, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->pSource));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->pSource));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->pSource, &size_pSource_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->pSource, &length_pSource_1));
			if (length_pSource_1 > size_pSource_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pSource_1, length_pSource_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pSource_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->pSource, length_pSource_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pSource_0, 0);
		}
		if (r->pElements) {
			_mem_save_pElements_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pElements, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->pElements));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->pElements, &size_pElements_1));
			NDR_PULL_ALLOC_N(ndr, r->pElements, size_pElements_1);
			_mem_save_pElements_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pElements, 0);
			for (cntr_pElements_1 = 0; cntr_pElements_1 < (size_pElements_1); cntr_pElements_1++) {
				NDR_CHECK(ndr_pull_OP_POLICY_ELEMENT(ndr, NDR_SCALARS, &r->pElements[cntr_pElements_1]));
			}
			for (cntr_pElements_1 = 0; cntr_pElements_1 < (size_pElements_1); cntr_pElements_1++) {
				NDR_CHECK(ndr_pull_OP_POLICY_ELEMENT(ndr, NDR_BUFFERS, &r->pElements[cntr_pElements_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pElements_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pElements_0, 0);
		}
		if (r->pElements) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->pElements, r->cElements));
		}
		for (cntr_pElements_1 = 0; cntr_pElements_1 < (size_pElements_1); cntr_pElements_1++) {
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_OP_POLICY_ELEMENT_LIST(struct ndr_print *ndr, const char *name, const struct OP_POLICY_ELEMENT_LIST *r)
{
	uint32_t cntr_pElements_1;
	ndr_print_struct(ndr, name, "OP_POLICY_ELEMENT_LIST");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "pSource", r->pSource);
	ndr->depth++;
	if (r->pSource) {
		ndr_print_string(ndr, "pSource", r->pSource);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "ulRootKeyId", r->ulRootKeyId);
	ndr_print_uint32(ndr, "cElements", r->cElements);
	ndr_print_ptr(ndr, "pElements", r->pElements);
	ndr->depth++;
	if (r->pElements) {
		ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "pElements", (uint32_t)(r->cElements));
		ndr->depth++;
		for (cntr_pElements_1 = 0; cntr_pElements_1 < (r->cElements); cntr_pElements_1++) {
			ndr_print_OP_POLICY_ELEMENT(ndr, "pElements", &r->pElements[cntr_pElements_1]);
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_OP_POLICY_PART(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct OP_POLICY_PART *r)
{
	uint32_t cntr_pElementLists_1;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->cElementLists));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pElementLists));
		NDR_CHECK(ndr_push_OP_BLOB(ndr, NDR_SCALARS, &r->Extension));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->pElementLists) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->cElementLists));
			for (cntr_pElementLists_1 = 0; cntr_pElementLists_1 < (r->cElementLists); cntr_pElementLists_1++) {
				NDR_CHECK(ndr_push_OP_POLICY_ELEMENT_LIST(ndr, NDR_SCALARS, &r->pElementLists[cntr_pElementLists_1]));
			}
			for (cntr_pElementLists_1 = 0; cntr_pElementLists_1 < (r->cElementLists); cntr_pElementLists_1++) {
				NDR_CHECK(ndr_push_OP_POLICY_ELEMENT_LIST(ndr, NDR_BUFFERS, &r->pElementLists[cntr_pElementLists_1]));
			}
		}
		NDR_CHECK(ndr_push_OP_BLOB(ndr, NDR_BUFFERS, &r->Extension));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_OP_POLICY_PART(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct OP_POLICY_PART *r)
{
	uint32_t _ptr_pElementLists;
	uint32_t size_pElementLists_1 = 0;
	uint32_t cntr_pElementLists_1;
	TALLOC_CTX *_mem_save_pElementLists_0 = NULL;
	TALLOC_CTX *_mem_save_pElementLists_1 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->cElementLists));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pElementLists));
		if (_ptr_pElementLists) {
			NDR_PULL_ALLOC(ndr, r->pElementLists);
		} else {
			r->pElementLists = NULL;
		}
		NDR_CHECK(ndr_pull_OP_BLOB(ndr, NDR_SCALARS, &r->Extension));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->pElementLists) {
			_mem_save_pElementLists_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pElementLists, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->pElementLists));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->pElementLists, &size_pElementLists_1));
			NDR_PULL_ALLOC_N(ndr, r->pElementLists, size_pElementLists_1);
			_mem_save_pElementLists_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pElementLists, 0);
			for (cntr_pElementLists_1 = 0; cntr_pElementLists_1 < (size_pElementLists_1); cntr_pElementLists_1++) {
				NDR_CHECK(ndr_pull_OP_POLICY_ELEMENT_LIST(ndr, NDR_SCALARS, &r->pElementLists[cntr_pElementLists_1]));
			}
			for (cntr_pElementLists_1 = 0; cntr_pElementLists_1 < (size_pElementLists_1); cntr_pElementLists_1++) {
				NDR_CHECK(ndr_pull_OP_POLICY_ELEMENT_LIST(ndr, NDR_BUFFERS, &r->pElementLists[cntr_pElementLists_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pElementLists_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pElementLists_0, 0);
		}
		NDR_CHECK(ndr_pull_OP_BLOB(ndr, NDR_BUFFERS, &r->Extension));
		if (r->pElementLists) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->pElementLists, r->cElementLists));
		}
		for (cntr_pElementLists_1 = 0; cntr_pElementLists_1 < (size_pElementLists_1); cntr_pElementLists_1++) {
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_OP_POLICY_PART(struct ndr_print *ndr, const char *name, const struct OP_POLICY_PART *r)
{
	uint32_t cntr_pElementLists_1;
	ndr_print_struct(ndr, name, "OP_POLICY_PART");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "cElementLists", r->cElementLists);
	ndr_print_ptr(ndr, "pElementLists", r->pElementLists);
	ndr->depth++;
	if (r->pElementLists) {
		ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "pElementLists", (uint32_t)(r->cElementLists));
		ndr->depth++;
		for (cntr_pElementLists_1 = 0; cntr_pElementLists_1 < (r->cElementLists); cntr_pElementLists_1++) {
			ndr_print_OP_POLICY_ELEMENT_LIST(ndr, "pElementLists", &r->pElementLists[cntr_pElementLists_1]);
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr_print_OP_BLOB(ndr, "Extension", &r->Extension);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_OP_CERT_PFX_STORE(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct OP_CERT_PFX_STORE *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pTemplateName));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->ulPrivateKeyExportPolicy));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pPolicyServerUrl));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->ulPolicyServerUrlFlags));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pPolicyServerId));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->cbPfx));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pPfx));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->pTemplateName) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pTemplateName, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pTemplateName, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->pTemplateName, ndr_charset_length(r->pTemplateName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->pPolicyServerUrl) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pPolicyServerUrl, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pPolicyServerUrl, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->pPolicyServerUrl, ndr_charset_length(r->pPolicyServerUrl, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->pPolicyServerId) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pPolicyServerId, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pPolicyServerId, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->pPolicyServerId, ndr_charset_length(r->pPolicyServerId, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->pPfx) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->cbPfx));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->pPfx, r->cbPfx));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_OP_CERT_PFX_STORE(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct OP_CERT_PFX_STORE *r)
{
	uint32_t _ptr_pTemplateName;
	uint32_t size_pTemplateName_1 = 0;
	uint32_t length_pTemplateName_1 = 0;
	TALLOC_CTX *_mem_save_pTemplateName_0 = NULL;
	uint32_t _ptr_pPolicyServerUrl;
	uint32_t size_pPolicyServerUrl_1 = 0;
	uint32_t length_pPolicyServerUrl_1 = 0;
	TALLOC_CTX *_mem_save_pPolicyServerUrl_0 = NULL;
	uint32_t _ptr_pPolicyServerId;
	uint32_t size_pPolicyServerId_1 = 0;
	uint32_t length_pPolicyServerId_1 = 0;
	TALLOC_CTX *_mem_save_pPolicyServerId_0 = NULL;
	uint32_t _ptr_pPfx;
	uint32_t size_pPfx_1 = 0;
	TALLOC_CTX *_mem_save_pPfx_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pTemplateName));
		if (_ptr_pTemplateName) {
			NDR_PULL_ALLOC(ndr, r->pTemplateName);
		} else {
			r->pTemplateName = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->ulPrivateKeyExportPolicy));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pPolicyServerUrl));
		if (_ptr_pPolicyServerUrl) {
			NDR_PULL_ALLOC(ndr, r->pPolicyServerUrl);
		} else {
			r->pPolicyServerUrl = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->ulPolicyServerUrlFlags));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pPolicyServerId));
		if (_ptr_pPolicyServerId) {
			NDR_PULL_ALLOC(ndr, r->pPolicyServerId);
		} else {
			r->pPolicyServerId = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->cbPfx));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pPfx));
		if (_ptr_pPfx) {
			NDR_PULL_ALLOC(ndr, r->pPfx);
		} else {
			r->pPfx = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->pTemplateName) {
			_mem_save_pTemplateName_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pTemplateName, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->pTemplateName));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->pTemplateName));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->pTemplateName, &size_pTemplateName_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->pTemplateName, &length_pTemplateName_1));
			if (length_pTemplateName_1 > size_pTemplateName_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pTemplateName_1, length_pTemplateName_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pTemplateName_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->pTemplateName, length_pTemplateName_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pTemplateName_0, 0);
		}
		if (r->pPolicyServerUrl) {
			_mem_save_pPolicyServerUrl_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pPolicyServerUrl, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->pPolicyServerUrl));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->pPolicyServerUrl));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->pPolicyServerUrl, &size_pPolicyServerUrl_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->pPolicyServerUrl, &length_pPolicyServerUrl_1));
			if (length_pPolicyServerUrl_1 > size_pPolicyServerUrl_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pPolicyServerUrl_1, length_pPolicyServerUrl_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pPolicyServerUrl_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->pPolicyServerUrl, length_pPolicyServerUrl_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pPolicyServerUrl_0, 0);
		}
		if (r->pPolicyServerId) {
			_mem_save_pPolicyServerId_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pPolicyServerId, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->pPolicyServerId));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->pPolicyServerId));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->pPolicyServerId, &size_pPolicyServerId_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->pPolicyServerId, &length_pPolicyServerId_1));
			if (length_pPolicyServerId_1 > size_pPolicyServerId_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pPolicyServerId_1, length_pPolicyServerId_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pPolicyServerId_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->pPolicyServerId, length_pPolicyServerId_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pPolicyServerId_0, 0);
		}
		if (r->pPfx) {
			_mem_save_pPfx_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pPfx, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->pPfx));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->pPfx, &size_pPfx_1));
			NDR_PULL_ALLOC_N(ndr, r->pPfx, size_pPfx_1);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->pPfx, size_pPfx_1));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pPfx_0, 0);
		}
		if (r->pPfx) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->pPfx, r->cbPfx));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_OP_CERT_PFX_STORE(struct ndr_print *ndr, const char *name, const struct OP_CERT_PFX_STORE *r)
{
	ndr_print_struct(ndr, name, "OP_CERT_PFX_STORE");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "pTemplateName", r->pTemplateName);
	ndr->depth++;
	if (r->pTemplateName) {
		ndr_print_string(ndr, "pTemplateName", r->pTemplateName);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "ulPrivateKeyExportPolicy", r->ulPrivateKeyExportPolicy);
	ndr_print_ptr(ndr, "pPolicyServerUrl", r->pPolicyServerUrl);
	ndr->depth++;
	if (r->pPolicyServerUrl) {
		ndr_print_string(ndr, "pPolicyServerUrl", r->pPolicyServerUrl);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "ulPolicyServerUrlFlags", r->ulPolicyServerUrlFlags);
	ndr_print_ptr(ndr, "pPolicyServerId", r->pPolicyServerId);
	ndr->depth++;
	if (r->pPolicyServerId) {
		ndr_print_string(ndr, "pPolicyServerId", r->pPolicyServerId);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "cbPfx", r->cbPfx);
	ndr_print_ptr(ndr, "pPfx", r->pPfx);
	ndr->depth++;
	if (r->pPfx) {
		ndr_print_array_uint8(ndr, "pPfx", r->pPfx, r->cbPfx);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_OP_CERT_SST_STORE(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct OP_CERT_SST_STORE *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->StoreLocation));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pStoreName));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->cbSst));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pSst));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->pStoreName) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pStoreName, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pStoreName, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->pStoreName, ndr_charset_length(r->pStoreName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->pSst) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->cbSst));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->pSst, r->cbSst));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_OP_CERT_SST_STORE(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct OP_CERT_SST_STORE *r)
{
	uint32_t _ptr_pStoreName;
	uint32_t size_pStoreName_1 = 0;
	uint32_t length_pStoreName_1 = 0;
	TALLOC_CTX *_mem_save_pStoreName_0 = NULL;
	uint32_t _ptr_pSst;
	uint32_t size_pSst_1 = 0;
	TALLOC_CTX *_mem_save_pSst_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->StoreLocation));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pStoreName));
		if (_ptr_pStoreName) {
			NDR_PULL_ALLOC(ndr, r->pStoreName);
		} else {
			r->pStoreName = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->cbSst));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pSst));
		if (_ptr_pSst) {
			NDR_PULL_ALLOC(ndr, r->pSst);
		} else {
			r->pSst = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->pStoreName) {
			_mem_save_pStoreName_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pStoreName, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->pStoreName));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->pStoreName));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->pStoreName, &size_pStoreName_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->pStoreName, &length_pStoreName_1));
			if (length_pStoreName_1 > size_pStoreName_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pStoreName_1, length_pStoreName_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pStoreName_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->pStoreName, length_pStoreName_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pStoreName_0, 0);
		}
		if (r->pSst) {
			_mem_save_pSst_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pSst, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->pSst));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->pSst, &size_pSst_1));
			NDR_PULL_ALLOC_N(ndr, r->pSst, size_pSst_1);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->pSst, size_pSst_1));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pSst_0, 0);
		}
		if (r->pSst) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->pSst, r->cbSst));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_OP_CERT_SST_STORE(struct ndr_print *ndr, const char *name, const struct OP_CERT_SST_STORE *r)
{
	ndr_print_struct(ndr, name, "OP_CERT_SST_STORE");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "StoreLocation", r->StoreLocation);
	ndr_print_ptr(ndr, "pStoreName", r->pStoreName);
	ndr->depth++;
	if (r->pStoreName) {
		ndr_print_string(ndr, "pStoreName", r->pStoreName);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "cbSst", r->cbSst);
	ndr_print_ptr(ndr, "pSst", r->pSst);
	ndr->depth++;
	if (r->pSst) {
		ndr_print_array_uint8(ndr, "pSst", r->pSst, r->cbSst);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_OP_CERT_PART(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct OP_CERT_PART *r)
{
	uint32_t cntr_pPfxStores_1;
	uint32_t cntr_pSstStores_1;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->cPfxStores));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pPfxStores));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->cSstStores));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pSstStores));
		NDR_CHECK(ndr_push_OP_BLOB(ndr, NDR_SCALARS, &r->Extension));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->pPfxStores) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->cPfxStores));
			for (cntr_pPfxStores_1 = 0; cntr_pPfxStores_1 < (r->cPfxStores); cntr_pPfxStores_1++) {
				NDR_CHECK(ndr_push_OP_CERT_PFX_STORE(ndr, NDR_SCALARS, &r->pPfxStores[cntr_pPfxStores_1]));
			}
			for (cntr_pPfxStores_1 = 0; cntr_pPfxStores_1 < (r->cPfxStores); cntr_pPfxStores_1++) {
				NDR_CHECK(ndr_push_OP_CERT_PFX_STORE(ndr, NDR_BUFFERS, &r->pPfxStores[cntr_pPfxStores_1]));
			}
		}
		if (r->pSstStores) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->cSstStores));
			for (cntr_pSstStores_1 = 0; cntr_pSstStores_1 < (r->cSstStores); cntr_pSstStores_1++) {
				NDR_CHECK(ndr_push_OP_CERT_SST_STORE(ndr, NDR_SCALARS, &r->pSstStores[cntr_pSstStores_1]));
			}
			for (cntr_pSstStores_1 = 0; cntr_pSstStores_1 < (r->cSstStores); cntr_pSstStores_1++) {
				NDR_CHECK(ndr_push_OP_CERT_SST_STORE(ndr, NDR_BUFFERS, &r->pSstStores[cntr_pSstStores_1]));
			}
		}
		NDR_CHECK(ndr_push_OP_BLOB(ndr, NDR_BUFFERS, &r->Extension));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_OP_CERT_PART(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct OP_CERT_PART *r)
{
	uint32_t _ptr_pPfxStores;
	uint32_t size_pPfxStores_1 = 0;
	uint32_t cntr_pPfxStores_1;
	TALLOC_CTX *_mem_save_pPfxStores_0 = NULL;
	TALLOC_CTX *_mem_save_pPfxStores_1 = NULL;
	uint32_t _ptr_pSstStores;
	uint32_t size_pSstStores_1 = 0;
	uint32_t cntr_pSstStores_1;
	TALLOC_CTX *_mem_save_pSstStores_0 = NULL;
	TALLOC_CTX *_mem_save_pSstStores_1 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->cPfxStores));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pPfxStores));
		if (_ptr_pPfxStores) {
			NDR_PULL_ALLOC(ndr, r->pPfxStores);
		} else {
			r->pPfxStores = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->cSstStores));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pSstStores));
		if (_ptr_pSstStores) {
			NDR_PULL_ALLOC(ndr, r->pSstStores);
		} else {
			r->pSstStores = NULL;
		}
		NDR_CHECK(ndr_pull_OP_BLOB(ndr, NDR_SCALARS, &r->Extension));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->pPfxStores) {
			_mem_save_pPfxStores_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pPfxStores, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->pPfxStores));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->pPfxStores, &size_pPfxStores_1));
			NDR_PULL_ALLOC_N(ndr, r->pPfxStores, size_pPfxStores_1);
			_mem_save_pPfxStores_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pPfxStores, 0);
			for (cntr_pPfxStores_1 = 0; cntr_pPfxStores_1 < (size_pPfxStores_1); cntr_pPfxStores_1++) {
				NDR_CHECK(ndr_pull_OP_CERT_PFX_STORE(ndr, NDR_SCALARS, &r->pPfxStores[cntr_pPfxStores_1]));
			}
			for (cntr_pPfxStores_1 = 0; cntr_pPfxStores_1 < (size_pPfxStores_1); cntr_pPfxStores_1++) {
				NDR_CHECK(ndr_pull_OP_CERT_PFX_STORE(ndr, NDR_BUFFERS, &r->pPfxStores[cntr_pPfxStores_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pPfxStores_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pPfxStores_0, 0);
		}
		if (r->pSstStores) {
			_mem_save_pSstStores_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pSstStores, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->pSstStores));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->pSstStores, &size_pSstStores_1));
			NDR_PULL_ALLOC_N(ndr, r->pSstStores, size_pSstStores_1);
			_mem_save_pSstStores_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pSstStores, 0);
			for (cntr_pSstStores_1 = 0; cntr_pSstStores_1 < (size_pSstStores_1); cntr_pSstStores_1++) {
				NDR_CHECK(ndr_pull_OP_CERT_SST_STORE(ndr, NDR_SCALARS, &r->pSstStores[cntr_pSstStores_1]));
			}
			for (cntr_pSstStores_1 = 0; cntr_pSstStores_1 < (size_pSstStores_1); cntr_pSstStores_1++) {
				NDR_CHECK(ndr_pull_OP_CERT_SST_STORE(ndr, NDR_BUFFERS, &r->pSstStores[cntr_pSstStores_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pSstStores_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pSstStores_0, 0);
		}
		NDR_CHECK(ndr_pull_OP_BLOB(ndr, NDR_BUFFERS, &r->Extension));
		if (r->pPfxStores) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->pPfxStores, r->cPfxStores));
		}
		for (cntr_pPfxStores_1 = 0; cntr_pPfxStores_1 < (size_pPfxStores_1); cntr_pPfxStores_1++) {
		}
		if (r->pSstStores) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->pSstStores, r->cSstStores));
		}
		for (cntr_pSstStores_1 = 0; cntr_pSstStores_1 < (size_pSstStores_1); cntr_pSstStores_1++) {
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_OP_CERT_PART(struct ndr_print *ndr, const char *name, const struct OP_CERT_PART *r)
{
	uint32_t cntr_pPfxStores_1;
	uint32_t cntr_pSstStores_1;
	ndr_print_struct(ndr, name, "OP_CERT_PART");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "cPfxStores", r->cPfxStores);
	ndr_print_ptr(ndr, "pPfxStores", r->pPfxStores);
	ndr->depth++;
	if (r->pPfxStores) {
		ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "pPfxStores", (uint32_t)(r->cPfxStores));
		ndr->depth++;
		for (cntr_pPfxStores_1 = 0; cntr_pPfxStores_1 < (r->cPfxStores); cntr_pPfxStores_1++) {
			ndr_print_OP_CERT_PFX_STORE(ndr, "pPfxStores", &r->pPfxStores[cntr_pPfxStores_1]);
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "cSstStores", r->cSstStores);
	ndr_print_ptr(ndr, "pSstStores", r->pSstStores);
	ndr->depth++;
	if (r->pSstStores) {
		ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "pSstStores", (uint32_t)(r->cSstStores));
		ndr->depth++;
		for (cntr_pSstStores_1 = 0; cntr_pSstStores_1 < (r->cSstStores); cntr_pSstStores_1++) {
			ndr_print_OP_CERT_SST_STORE(ndr, "pSstStores", &r->pSstStores[cntr_pSstStores_1]);
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr_print_OP_BLOB(ndr, "Extension", &r->Extension);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_ODJ_WIN7BLOB_ctr(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct ODJ_WIN7BLOB_ctr *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->p));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->p) {
			NDR_CHECK(ndr_push_ODJ_WIN7BLOB(ndr, NDR_SCALARS|NDR_BUFFERS, r->p));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_ODJ_WIN7BLOB_ctr(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct ODJ_WIN7BLOB_ctr *r)
{
	uint32_t _ptr_p;
	TALLOC_CTX *_mem_save_p_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_p));
		if (_ptr_p) {
			NDR_PULL_ALLOC(ndr, r->p);
		} else {
			r->p = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->p) {
			_mem_save_p_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->p, 0);
			NDR_CHECK(ndr_pull_ODJ_WIN7BLOB(ndr, NDR_SCALARS|NDR_BUFFERS, r->p));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_p_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_ODJ_WIN7BLOB_ctr(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct ODJ_WIN7BLOB_ctr *r)
{
	ndr_print_ODJ_WIN7BLOB_ctr(ndr, name, r);
}

_PUBLIC_ void ndr_print_ODJ_WIN7BLOB_ctr(struct ndr_print *ndr, const char *name, const struct ODJ_WIN7BLOB_ctr *r)
{
	ndr_print_struct(ndr, name, "ODJ_WIN7BLOB_ctr");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "p", r->p);
	ndr->depth++;
	if (r->p) {
		ndr_print_ODJ_WIN7BLOB(ndr, "p", r->p);
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_ODJ_WIN7BLOB_serialized_ptr(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct ODJ_WIN7BLOB_serialized_ptr *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 1));
		{
			struct ndr_push *_ndr_s;
			NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_s, 0xFFFFFC01, -1));
			NDR_CHECK(ndr_push_ODJ_WIN7BLOB_ctr(_ndr_s, NDR_SCALARS|NDR_BUFFERS, &r->s));
			NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_s, 0xFFFFFC01, -1));
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_ODJ_WIN7BLOB_serialized_ptr(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct ODJ_WIN7BLOB_serialized_ptr *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 1));
		{
			struct ndr_pull *_ndr_s;
			ssize_t sub_size = -1;
			NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_s, 0xFFFFFC01, sub_size));
			NDR_CHECK(ndr_pull_ODJ_WIN7BLOB_ctr(_ndr_s, NDR_SCALARS|NDR_BUFFERS, &r->s));
			NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_s, 0xFFFFFC01, sub_size));
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_ODJ_WIN7BLOB_serialized_ptr(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct ODJ_WIN7BLOB_serialized_ptr *r)
{
	ndr_print_ODJ_WIN7BLOB_serialized_ptr(ndr, name, r);
}

_PUBLIC_ void ndr_print_ODJ_WIN7BLOB_serialized_ptr(struct ndr_print *ndr, const char *name, const struct ODJ_WIN7BLOB_serialized_ptr *r)
{
	ndr_print_struct(ndr, name, "ODJ_WIN7BLOB_serialized_ptr");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ODJ_WIN7BLOB_ctr(ndr, "s", &r->s);
	ndr->depth--;
}

_PUBLIC_ size_t ndr_size_ODJ_WIN7BLOB_serialized_ptr(const struct ODJ_WIN7BLOB_serialized_ptr *r, libndr_flags flags)
{
	return ndr_size_struct(r, flags, (ndr_push_flags_fn_t)ndr_push_ODJ_WIN7BLOB_serialized_ptr);
}

_PUBLIC_ enum ndr_err_code ndr_push_OP_JOINPROV2_PART_ctr(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct OP_JOINPROV2_PART_ctr *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->p));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->p) {
			NDR_CHECK(ndr_push_OP_JOINPROV2_PART(ndr, NDR_SCALARS|NDR_BUFFERS, r->p));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_OP_JOINPROV2_PART_ctr(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct OP_JOINPROV2_PART_ctr *r)
{
	uint32_t _ptr_p;
	TALLOC_CTX *_mem_save_p_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_p));
		if (_ptr_p) {
			NDR_PULL_ALLOC(ndr, r->p);
		} else {
			r->p = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->p) {
			_mem_save_p_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->p, 0);
			NDR_CHECK(ndr_pull_OP_JOINPROV2_PART(ndr, NDR_SCALARS|NDR_BUFFERS, r->p));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_p_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_OP_JOINPROV2_PART_ctr(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct OP_JOINPROV2_PART_ctr *r)
{
	ndr_print_OP_JOINPROV2_PART_ctr(ndr, name, r);
}

_PUBLIC_ void ndr_print_OP_JOINPROV2_PART_ctr(struct ndr_print *ndr, const char *name, const struct OP_JOINPROV2_PART_ctr *r)
{
	ndr_print_struct(ndr, name, "OP_JOINPROV2_PART_ctr");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "p", r->p);
	ndr->depth++;
	if (r->p) {
		ndr_print_OP_JOINPROV2_PART(ndr, "p", r->p);
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_OP_JOINPROV2_PART_serialized_ptr(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct OP_JOINPROV2_PART_serialized_ptr *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 1));
		{
			struct ndr_push *_ndr_s;
			NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_s, 0xFFFFFC01, -1));
			NDR_CHECK(ndr_push_OP_JOINPROV2_PART_ctr(_ndr_s, NDR_SCALARS|NDR_BUFFERS, &r->s));
			NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_s, 0xFFFFFC01, -1));
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_OP_JOINPROV2_PART_serialized_ptr(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct OP_JOINPROV2_PART_serialized_ptr *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 1));
		{
			struct ndr_pull *_ndr_s;
			ssize_t sub_size = -1;
			NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_s, 0xFFFFFC01, sub_size));
			NDR_CHECK(ndr_pull_OP_JOINPROV2_PART_ctr(_ndr_s, NDR_SCALARS|NDR_BUFFERS, &r->s));
			NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_s, 0xFFFFFC01, sub_size));
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_OP_JOINPROV2_PART_serialized_ptr(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct OP_JOINPROV2_PART_serialized_ptr *r)
{
	ndr_print_OP_JOINPROV2_PART_serialized_ptr(ndr, name, r);
}

_PUBLIC_ void ndr_print_OP_JOINPROV2_PART_serialized_ptr(struct ndr_print *ndr, const char *name, const struct OP_JOINPROV2_PART_serialized_ptr *r)
{
	ndr_print_struct(ndr, name, "OP_JOINPROV2_PART_serialized_ptr");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_OP_JOINPROV2_PART_ctr(ndr, "s", &r->s);
	ndr->depth--;
}

_PUBLIC_ size_t ndr_size_OP_JOINPROV2_PART_serialized_ptr(const struct OP_JOINPROV2_PART_serialized_ptr *r, libndr_flags flags)
{
	return ndr_size_struct(r, flags, (ndr_push_flags_fn_t)ndr_push_OP_JOINPROV2_PART_serialized_ptr);
}

_PUBLIC_ enum ndr_err_code ndr_push_OP_JOINPROV3_PART_ctr(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct OP_JOINPROV3_PART_ctr *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->p));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->p) {
			NDR_CHECK(ndr_push_OP_JOINPROV3_PART(ndr, NDR_SCALARS|NDR_BUFFERS, r->p));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_OP_JOINPROV3_PART_ctr(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct OP_JOINPROV3_PART_ctr *r)
{
	uint32_t _ptr_p;
	TALLOC_CTX *_mem_save_p_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_p));
		if (_ptr_p) {
			NDR_PULL_ALLOC(ndr, r->p);
		} else {
			r->p = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->p) {
			_mem_save_p_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->p, 0);
			NDR_CHECK(ndr_pull_OP_JOINPROV3_PART(ndr, NDR_SCALARS|NDR_BUFFERS, r->p));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_p_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_OP_JOINPROV3_PART_ctr(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct OP_JOINPROV3_PART_ctr *r)
{
	ndr_print_OP_JOINPROV3_PART_ctr(ndr, name, r);
}

_PUBLIC_ void ndr_print_OP_JOINPROV3_PART_ctr(struct ndr_print *ndr, const char *name, const struct OP_JOINPROV3_PART_ctr *r)
{
	ndr_print_struct(ndr, name, "OP_JOINPROV3_PART_ctr");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "p", r->p);
	ndr->depth++;
	if (r->p) {
		ndr_print_OP_JOINPROV3_PART(ndr, "p", r->p);
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_OP_JOINPROV3_PART_serialized_ptr(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct OP_JOINPROV3_PART_serialized_ptr *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 1));
		{
			struct ndr_push *_ndr_s;
			NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_s, 0xFFFFFC01, -1));
			NDR_CHECK(ndr_push_OP_JOINPROV3_PART_ctr(_ndr_s, NDR_SCALARS|NDR_BUFFERS, &r->s));
			NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_s, 0xFFFFFC01, -1));
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_OP_JOINPROV3_PART_serialized_ptr(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct OP_JOINPROV3_PART_serialized_ptr *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 1));
		{
			struct ndr_pull *_ndr_s;
			ssize_t sub_size = -1;
			NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_s, 0xFFFFFC01, sub_size));
			NDR_CHECK(ndr_pull_OP_JOINPROV3_PART_ctr(_ndr_s, NDR_SCALARS|NDR_BUFFERS, &r->s));
			NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_s, 0xFFFFFC01, sub_size));
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_OP_JOINPROV3_PART_serialized_ptr(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct OP_JOINPROV3_PART_serialized_ptr *r)
{
	ndr_print_OP_JOINPROV3_PART_serialized_ptr(ndr, name, r);
}

_PUBLIC_ void ndr_print_OP_JOINPROV3_PART_serialized_ptr(struct ndr_print *ndr, const char *name, const struct OP_JOINPROV3_PART_serialized_ptr *r)
{
	ndr_print_struct(ndr, name, "OP_JOINPROV3_PART_serialized_ptr");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_OP_JOINPROV3_PART_ctr(ndr, "s", &r->s);
	ndr->depth--;
}

_PUBLIC_ size_t ndr_size_OP_JOINPROV3_PART_serialized_ptr(const struct OP_JOINPROV3_PART_serialized_ptr *r, libndr_flags flags)
{
	return ndr_size_struct(r, flags, (ndr_push_flags_fn_t)ndr_push_OP_JOINPROV3_PART_serialized_ptr);
}

_PUBLIC_ enum ndr_err_code ndr_push_OP_POLICY_PART_ctr(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct OP_POLICY_PART_ctr *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->p));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->p) {
			NDR_CHECK(ndr_push_OP_POLICY_PART(ndr, NDR_SCALARS|NDR_BUFFERS, r->p));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_OP_POLICY_PART_ctr(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct OP_POLICY_PART_ctr *r)
{
	uint32_t _ptr_p;
	TALLOC_CTX *_mem_save_p_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_p));
		if (_ptr_p) {
			NDR_PULL_ALLOC(ndr, r->p);
		} else {
			r->p = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->p) {
			_mem_save_p_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->p, 0);
			NDR_CHECK(ndr_pull_OP_POLICY_PART(ndr, NDR_SCALARS|NDR_BUFFERS, r->p));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_p_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_OP_POLICY_PART_ctr(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct OP_POLICY_PART_ctr *r)
{
	ndr_print_OP_POLICY_PART_ctr(ndr, name, r);
}

_PUBLIC_ void ndr_print_OP_POLICY_PART_ctr(struct ndr_print *ndr, const char *name, const struct OP_POLICY_PART_ctr *r)
{
	ndr_print_struct(ndr, name, "OP_POLICY_PART_ctr");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "p", r->p);
	ndr->depth++;
	if (r->p) {
		ndr_print_OP_POLICY_PART(ndr, "p", r->p);
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_OP_POLICY_PART_serialized_ptr(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct OP_POLICY_PART_serialized_ptr *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 1));
		{
			struct ndr_push *_ndr_s;
			NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_s, 0xFFFFFC01, -1));
			NDR_CHECK(ndr_push_OP_POLICY_PART_ctr(_ndr_s, NDR_SCALARS|NDR_BUFFERS, &r->s));
			NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_s, 0xFFFFFC01, -1));
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_OP_POLICY_PART_serialized_ptr(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct OP_POLICY_PART_serialized_ptr *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 1));
		{
			struct ndr_pull *_ndr_s;
			ssize_t sub_size = -1;
			NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_s, 0xFFFFFC01, sub_size));
			NDR_CHECK(ndr_pull_OP_POLICY_PART_ctr(_ndr_s, NDR_SCALARS|NDR_BUFFERS, &r->s));
			NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_s, 0xFFFFFC01, sub_size));
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_OP_POLICY_PART_serialized_ptr(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct OP_POLICY_PART_serialized_ptr *r)
{
	ndr_print_OP_POLICY_PART_serialized_ptr(ndr, name, r);
}

_PUBLIC_ void ndr_print_OP_POLICY_PART_serialized_ptr(struct ndr_print *ndr, const char *name, const struct OP_POLICY_PART_serialized_ptr *r)
{
	ndr_print_struct(ndr, name, "OP_POLICY_PART_serialized_ptr");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_OP_POLICY_PART_ctr(ndr, "s", &r->s);
	ndr->depth--;
}

_PUBLIC_ size_t ndr_size_OP_POLICY_PART_serialized_ptr(const struct OP_POLICY_PART_serialized_ptr *r, libndr_flags flags)
{
	return ndr_size_struct(r, flags, (ndr_push_flags_fn_t)ndr_push_OP_POLICY_PART_serialized_ptr);
}

_PUBLIC_ enum ndr_err_code ndr_push_OP_CERT_PART_ctr(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct OP_CERT_PART_ctr *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->p));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->p) {
			NDR_CHECK(ndr_push_OP_CERT_PART(ndr, NDR_SCALARS|NDR_BUFFERS, r->p));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_OP_CERT_PART_ctr(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct OP_CERT_PART_ctr *r)
{
	uint32_t _ptr_p;
	TALLOC_CTX *_mem_save_p_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_p));
		if (_ptr_p) {
			NDR_PULL_ALLOC(ndr, r->p);
		} else {
			r->p = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->p) {
			_mem_save_p_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->p, 0);
			NDR_CHECK(ndr_pull_OP_CERT_PART(ndr, NDR_SCALARS|NDR_BUFFERS, r->p));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_p_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_OP_CERT_PART_ctr(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct OP_CERT_PART_ctr *r)
{
	ndr_print_OP_CERT_PART_ctr(ndr, name, r);
}

_PUBLIC_ void ndr_print_OP_CERT_PART_ctr(struct ndr_print *ndr, const char *name, const struct OP_CERT_PART_ctr *r)
{
	ndr_print_struct(ndr, name, "OP_CERT_PART_ctr");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "p", r->p);
	ndr->depth++;
	if (r->p) {
		ndr_print_OP_CERT_PART(ndr, "p", r->p);
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_OP_CERT_PART_serialized_ptr(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct OP_CERT_PART_serialized_ptr *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 1));
		{
			struct ndr_push *_ndr_s;
			NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_s, 0xFFFFFC01, -1));
			NDR_CHECK(ndr_push_OP_CERT_PART_ctr(_ndr_s, NDR_SCALARS|NDR_BUFFERS, &r->s));
			NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_s, 0xFFFFFC01, -1));
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_OP_CERT_PART_serialized_ptr(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct OP_CERT_PART_serialized_ptr *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 1));
		{
			struct ndr_pull *_ndr_s;
			ssize_t sub_size = -1;
			NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_s, 0xFFFFFC01, sub_size));
			NDR_CHECK(ndr_pull_OP_CERT_PART_ctr(_ndr_s, NDR_SCALARS|NDR_BUFFERS, &r->s));
			NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_s, 0xFFFFFC01, sub_size));
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_OP_CERT_PART_serialized_ptr(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct OP_CERT_PART_serialized_ptr *r)
{
	ndr_print_OP_CERT_PART_serialized_ptr(ndr, name, r);
}

_PUBLIC_ void ndr_print_OP_CERT_PART_serialized_ptr(struct ndr_print *ndr, const char *name, const struct OP_CERT_PART_serialized_ptr *r)
{
	ndr_print_struct(ndr, name, "OP_CERT_PART_serialized_ptr");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_OP_CERT_PART_ctr(ndr, "s", &r->s);
	ndr->depth--;
}

_PUBLIC_ size_t ndr_size_OP_CERT_PART_serialized_ptr(const struct OP_CERT_PART_serialized_ptr *r, libndr_flags flags)
{
	return ndr_size_struct(r, flags, (ndr_push_flags_fn_t)ndr_push_OP_CERT_PART_serialized_ptr);
}

_PUBLIC_ enum ndr_err_code ndr_push_OP_PACKAGE_PART_u(struct ndr_push *ndr, ndr_flags_type ndr_flags, const union OP_PACKAGE_PART_u *r)
{
	uint32_t level;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_push_union_align(ndr, 1));
		switch (level) {
			case 1: {
				{
					struct ndr_push *_ndr_win7blob;
					NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_win7blob, 0xFFFFFC01, -1));
					NDR_CHECK(ndr_push_ODJ_WIN7BLOB(_ndr_win7blob, NDR_SCALARS|NDR_BUFFERS, &r->win7blob));
					NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_win7blob, 0xFFFFFC01, -1));
				}
			break; }

			case 2: {
				{
					struct ndr_push *_ndr_join_prov2;
					NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_join_prov2, 0xFFFFFC01, -1));
					NDR_CHECK(ndr_push_OP_JOINPROV2_PART_ctr(_ndr_join_prov2, NDR_SCALARS|NDR_BUFFERS, &r->join_prov2));
					NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_join_prov2, 0xFFFFFC01, -1));
				}
			break; }

			case 3: {
				{
					struct ndr_push *_ndr_join_prov3;
					NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_join_prov3, 0xFFFFFC01, -1));
					NDR_CHECK(ndr_push_OP_JOINPROV3_PART_ctr(_ndr_join_prov3, NDR_SCALARS|NDR_BUFFERS, &r->join_prov3));
					NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_join_prov3, 0xFFFFFC01, -1));
				}
			break; }

			case 4: {
				{
					struct ndr_push *_ndr_cert_part;
					NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_cert_part, 0xFFFFFC01, -1));
					NDR_CHECK(ndr_push_OP_CERT_PART_ctr(_ndr_cert_part, NDR_SCALARS|NDR_BUFFERS, &r->cert_part));
					NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_cert_part, 0xFFFFFC01, -1));
				}
			break; }

			case 5: {
				{
					struct ndr_push *_ndr_policy_part;
					NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_policy_part, 0xFFFFFC01, -1));
					NDR_CHECK(ndr_push_OP_POLICY_PART_ctr(_ndr_policy_part, NDR_SCALARS|NDR_BUFFERS, &r->policy_part));
					NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_policy_part, 0xFFFFFC01, -1));
				}
			break; }

			default: {
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 1:
			break;

			case 2:
			break;

			case 3:
			break;

			case 4:
			break;

			case 5:
			break;

			default:
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_OP_PACKAGE_PART_u(struct ndr_pull *ndr, ndr_flags_type ndr_flags, union OP_PACKAGE_PART_u *r)
{
	uint32_t level;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_pull_union_align(ndr, 1));
		switch (level) {
			case 1: {
				{
					struct ndr_pull *_ndr_win7blob;
					ssize_t sub_size = -1;
					NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_win7blob, 0xFFFFFC01, sub_size));
					NDR_CHECK(ndr_pull_ODJ_WIN7BLOB(_ndr_win7blob, NDR_SCALARS|NDR_BUFFERS, &r->win7blob));
					NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_win7blob, 0xFFFFFC01, sub_size));
				}
			break; }

			case 2: {
				{
					struct ndr_pull *_ndr_join_prov2;
					ssize_t sub_size = -1;
					NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_join_prov2, 0xFFFFFC01, sub_size));
					NDR_CHECK(ndr_pull_OP_JOINPROV2_PART_ctr(_ndr_join_prov2, NDR_SCALARS|NDR_BUFFERS, &r->join_prov2));
					NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_join_prov2, 0xFFFFFC01, sub_size));
				}
			break; }

			case 3: {
				{
					struct ndr_pull *_ndr_join_prov3;
					ssize_t sub_size = -1;
					NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_join_prov3, 0xFFFFFC01, sub_size));
					NDR_CHECK(ndr_pull_OP_JOINPROV3_PART_ctr(_ndr_join_prov3, NDR_SCALARS|NDR_BUFFERS, &r->join_prov3));
					NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_join_prov3, 0xFFFFFC01, sub_size));
				}
			break; }

			case 4: {
				{
					struct ndr_pull *_ndr_cert_part;
					ssize_t sub_size = -1;
					NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_cert_part, 0xFFFFFC01, sub_size));
					NDR_CHECK(ndr_pull_OP_CERT_PART_ctr(_ndr_cert_part, NDR_SCALARS|NDR_BUFFERS, &r->cert_part));
					NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_cert_part, 0xFFFFFC01, sub_size));
				}
			break; }

			case 5: {
				{
					struct ndr_pull *_ndr_policy_part;
					ssize_t sub_size = -1;
					NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_policy_part, 0xFFFFFC01, sub_size));
					NDR_CHECK(ndr_pull_OP_POLICY_PART_ctr(_ndr_policy_part, NDR_SCALARS|NDR_BUFFERS, &r->policy_part));
					NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_policy_part, 0xFFFFFC01, sub_size));
				}
			break; }

			default: {
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 1:
			break;

			case 2:
			break;

			case 3:
			break;

			case 4:
			break;

			case 5:
			break;

			default:
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_OP_PACKAGE_PART_u(struct ndr_print *ndr, const char *name, const union OP_PACKAGE_PART_u *r)
{
	uint32_t level;
	level = ndr_print_steal_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "OP_PACKAGE_PART_u");
	switch (level) {
		case 1:
			ndr_print_ODJ_WIN7BLOB(ndr, "win7blob", &r->win7blob);
		break;

		case 2:
			ndr_print_OP_JOINPROV2_PART_ctr(ndr, "join_prov2", &r->join_prov2);
		break;

		case 3:
			ndr_print_OP_JOINPROV3_PART_ctr(ndr, "join_prov3", &r->join_prov3);
		break;

		case 4:
			ndr_print_OP_CERT_PART_ctr(ndr, "cert_part", &r->cert_part);
		break;

		case 5:
			ndr_print_OP_POLICY_PART_ctr(ndr, "policy_part", &r->policy_part);
		break;

		default:
		break;

	}
}

_PUBLIC_ size_t ndr_size_OP_PACKAGE_PART_u(const union OP_PACKAGE_PART_u *r, uint32_t level, libndr_flags flags)
{
	return ndr_size_union(r, flags, level, (ndr_push_flags_fn_t)ndr_push_OP_PACKAGE_PART_u);
}

_PUBLIC_ enum ndr_err_code ndr_push_ODJ_PackageFlags(struct ndr_push *ndr, ndr_flags_type ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_ODJ_PackageFlags(struct ndr_pull *ndr, ndr_flags_type ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_ODJ_PackageFlags(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "OPSPI_PACKAGE_PART_ESSENTIAL", OPSPI_PACKAGE_PART_ESSENTIAL, r);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_OP_PACKAGE_PART(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct OP_PACKAGE_PART *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->PartType));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->ulFlags));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_size_OP_PACKAGE_PART_u(r->Part, odj_switch_level_from_guid(&r->PartType), 0)));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->Part));
		NDR_CHECK(ndr_push_OP_BLOB(ndr, NDR_SCALARS, &r->Extension));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->Part) {
			{
				struct ndr_push *_ndr_Part;
				NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_Part, 4, ndr_size_OP_PACKAGE_PART_u(r->Part, odj_switch_level_from_guid(&r->PartType), 0)));
				NDR_CHECK(ndr_push_set_switch_value(_ndr_Part, r->Part, odj_switch_level_from_guid(&r->PartType)));
				NDR_CHECK(ndr_push_OP_PACKAGE_PART_u(_ndr_Part, NDR_SCALARS|NDR_BUFFERS, r->Part));
				NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_Part, 4, ndr_size_OP_PACKAGE_PART_u(r->Part, odj_switch_level_from_guid(&r->PartType), 0)));
			}
		}
		NDR_CHECK(ndr_push_OP_BLOB(ndr, NDR_BUFFERS, &r->Extension));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_OP_PACKAGE_PART(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct OP_PACKAGE_PART *r)
{
	uint32_t _ptr_Part;
	TALLOC_CTX *_mem_save_Part_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->PartType));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->ulFlags));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->part_len));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_Part));
		if (_ptr_Part) {
			NDR_PULL_ALLOC(ndr, r->Part);
		} else {
			r->Part = NULL;
		}
		NDR_CHECK(ndr_pull_OP_BLOB(ndr, NDR_SCALARS, &r->Extension));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->Part) {
			_mem_save_Part_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->Part, 0);
			{
				struct ndr_pull *_ndr_Part;
				ssize_t sub_size = r->part_len;
				NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_Part, 4, sub_size));
				NDR_CHECK(ndr_pull_set_switch_value(_ndr_Part, r->Part, odj_switch_level_from_guid(&r->PartType)));
				NDR_CHECK(ndr_pull_OP_PACKAGE_PART_u(_ndr_Part, NDR_SCALARS|NDR_BUFFERS, r->Part));
				NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_Part, 4, sub_size));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_Part_0, 0);
		}
		NDR_CHECK(ndr_pull_OP_BLOB(ndr, NDR_BUFFERS, &r->Extension));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_OP_PACKAGE_PART(struct ndr_print *ndr, const char *name, const struct OP_PACKAGE_PART *r)
{
	ndr_print_struct(ndr, name, "OP_PACKAGE_PART");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_GUID(ndr, "PartType", &r->PartType);
	ndr_print_uint32(ndr, "ulFlags", r->ulFlags);
	ndr_print_uint32(ndr, "part_len", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?ndr_size_OP_PACKAGE_PART_u(r->Part, odj_switch_level_from_guid(&r->PartType), 0):r->part_len);
	ndr_print_ptr(ndr, "Part", r->Part);
	ndr->depth++;
	if (r->Part) {
		ndr_print_set_switch_value(ndr, r->Part, odj_switch_level_from_guid(&r->PartType));
		ndr_print_OP_PACKAGE_PART_u(ndr, "Part", r->Part);
	}
	ndr->depth--;
	ndr_print_OP_BLOB(ndr, "Extension", &r->Extension);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_OP_PACKAGE_PART_ctr(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct OP_PACKAGE_PART_ctr *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->p));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->p) {
			NDR_CHECK(ndr_push_OP_PACKAGE_PART(ndr, NDR_SCALARS|NDR_BUFFERS, r->p));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_OP_PACKAGE_PART_ctr(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct OP_PACKAGE_PART_ctr *r)
{
	uint32_t _ptr_p;
	TALLOC_CTX *_mem_save_p_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_p));
		if (_ptr_p) {
			NDR_PULL_ALLOC(ndr, r->p);
		} else {
			r->p = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->p) {
			_mem_save_p_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->p, 0);
			NDR_CHECK(ndr_pull_OP_PACKAGE_PART(ndr, NDR_SCALARS|NDR_BUFFERS, r->p));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_p_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_OP_PACKAGE_PART_ctr(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct OP_PACKAGE_PART_ctr *r)
{
	ndr_print_OP_PACKAGE_PART_ctr(ndr, name, r);
}

_PUBLIC_ void ndr_print_OP_PACKAGE_PART_ctr(struct ndr_print *ndr, const char *name, const struct OP_PACKAGE_PART_ctr *r)
{
	ndr_print_struct(ndr, name, "OP_PACKAGE_PART_ctr");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "p", r->p);
	ndr->depth++;
	if (r->p) {
		ndr_print_OP_PACKAGE_PART(ndr, "p", r->p);
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_OP_PACKAGE_PART_serialized_ptr(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct OP_PACKAGE_PART_serialized_ptr *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 1));
		{
			struct ndr_push *_ndr_s;
			NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_s, 0xFFFFFC01, -1));
			NDR_CHECK(ndr_push_OP_PACKAGE_PART_ctr(_ndr_s, NDR_SCALARS|NDR_BUFFERS, &r->s));
			NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_s, 0xFFFFFC01, -1));
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_OP_PACKAGE_PART_serialized_ptr(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct OP_PACKAGE_PART_serialized_ptr *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 1));
		{
			struct ndr_pull *_ndr_s;
			ssize_t sub_size = -1;
			NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_s, 0xFFFFFC01, sub_size));
			NDR_CHECK(ndr_pull_OP_PACKAGE_PART_ctr(_ndr_s, NDR_SCALARS|NDR_BUFFERS, &r->s));
			NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_s, 0xFFFFFC01, sub_size));
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_OP_PACKAGE_PART_serialized_ptr(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct OP_PACKAGE_PART_serialized_ptr *r)
{
	ndr_print_OP_PACKAGE_PART_serialized_ptr(ndr, name, r);
}

_PUBLIC_ void ndr_print_OP_PACKAGE_PART_serialized_ptr(struct ndr_print *ndr, const char *name, const struct OP_PACKAGE_PART_serialized_ptr *r)
{
	ndr_print_struct(ndr, name, "OP_PACKAGE_PART_serialized_ptr");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_OP_PACKAGE_PART_ctr(ndr, "s", &r->s);
	ndr->depth--;
}

_PUBLIC_ size_t ndr_size_OP_PACKAGE_PART_serialized_ptr(const struct OP_PACKAGE_PART_serialized_ptr *r, libndr_flags flags)
{
	return ndr_size_struct(r, flags, (ndr_push_flags_fn_t)ndr_push_OP_PACKAGE_PART_serialized_ptr);
}

static enum ndr_err_code ndr_push_OP_PACKAGE_PART_COLLECTION(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct OP_PACKAGE_PART_COLLECTION *r)
{
	uint32_t cntr_pParts_1;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->cParts));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pParts));
		NDR_CHECK(ndr_push_OP_BLOB(ndr, NDR_SCALARS, &r->Extension));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->pParts) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->cParts));
			for (cntr_pParts_1 = 0; cntr_pParts_1 < (r->cParts); cntr_pParts_1++) {
				NDR_CHECK(ndr_push_OP_PACKAGE_PART(ndr, NDR_SCALARS, &r->pParts[cntr_pParts_1]));
			}
			for (cntr_pParts_1 = 0; cntr_pParts_1 < (r->cParts); cntr_pParts_1++) {
				NDR_CHECK(ndr_push_OP_PACKAGE_PART(ndr, NDR_BUFFERS, &r->pParts[cntr_pParts_1]));
			}
		}
		NDR_CHECK(ndr_push_OP_BLOB(ndr, NDR_BUFFERS, &r->Extension));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_OP_PACKAGE_PART_COLLECTION(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct OP_PACKAGE_PART_COLLECTION *r)
{
	uint32_t _ptr_pParts;
	uint32_t size_pParts_1 = 0;
	uint32_t cntr_pParts_1;
	TALLOC_CTX *_mem_save_pParts_0 = NULL;
	TALLOC_CTX *_mem_save_pParts_1 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->cParts));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pParts));
		if (_ptr_pParts) {
			NDR_PULL_ALLOC(ndr, r->pParts);
		} else {
			r->pParts = NULL;
		}
		NDR_CHECK(ndr_pull_OP_BLOB(ndr, NDR_SCALARS, &r->Extension));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->pParts) {
			_mem_save_pParts_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pParts, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->pParts));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->pParts, &size_pParts_1));
			NDR_PULL_ALLOC_N(ndr, r->pParts, size_pParts_1);
			_mem_save_pParts_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pParts, 0);
			for (cntr_pParts_1 = 0; cntr_pParts_1 < (size_pParts_1); cntr_pParts_1++) {
				NDR_CHECK(ndr_pull_OP_PACKAGE_PART(ndr, NDR_SCALARS, &r->pParts[cntr_pParts_1]));
			}
			for (cntr_pParts_1 = 0; cntr_pParts_1 < (size_pParts_1); cntr_pParts_1++) {
				NDR_CHECK(ndr_pull_OP_PACKAGE_PART(ndr, NDR_BUFFERS, &r->pParts[cntr_pParts_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pParts_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pParts_0, 0);
		}
		NDR_CHECK(ndr_pull_OP_BLOB(ndr, NDR_BUFFERS, &r->Extension));
		if (r->pParts) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->pParts, r->cParts));
		}
		for (cntr_pParts_1 = 0; cntr_pParts_1 < (size_pParts_1); cntr_pParts_1++) {
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_OP_PACKAGE_PART_COLLECTION(struct ndr_print *ndr, const char *name, const struct OP_PACKAGE_PART_COLLECTION *r)
{
	uint32_t cntr_pParts_1;
	ndr_print_struct(ndr, name, "OP_PACKAGE_PART_COLLECTION");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "cParts", r->cParts);
	ndr_print_ptr(ndr, "pParts", r->pParts);
	ndr->depth++;
	if (r->pParts) {
		ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "pParts", (uint32_t)(r->cParts));
		ndr->depth++;
		for (cntr_pParts_1 = 0; cntr_pParts_1 < (r->cParts); cntr_pParts_1++) {
			ndr_print_OP_PACKAGE_PART(ndr, "pParts", &r->pParts[cntr_pParts_1]);
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr_print_OP_BLOB(ndr, "Extension", &r->Extension);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_OP_PACKAGE_PART_COLLECTION_ctr(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct OP_PACKAGE_PART_COLLECTION_ctr *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->p));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->p) {
			NDR_CHECK(ndr_push_OP_PACKAGE_PART_COLLECTION(ndr, NDR_SCALARS|NDR_BUFFERS, r->p));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_OP_PACKAGE_PART_COLLECTION_ctr(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct OP_PACKAGE_PART_COLLECTION_ctr *r)
{
	uint32_t _ptr_p;
	TALLOC_CTX *_mem_save_p_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_p));
		if (_ptr_p) {
			NDR_PULL_ALLOC(ndr, r->p);
		} else {
			r->p = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->p) {
			_mem_save_p_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->p, 0);
			NDR_CHECK(ndr_pull_OP_PACKAGE_PART_COLLECTION(ndr, NDR_SCALARS|NDR_BUFFERS, r->p));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_p_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_OP_PACKAGE_PART_COLLECTION_ctr(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct OP_PACKAGE_PART_COLLECTION_ctr *r)
{
	ndr_print_OP_PACKAGE_PART_COLLECTION_ctr(ndr, name, r);
}

_PUBLIC_ void ndr_print_OP_PACKAGE_PART_COLLECTION_ctr(struct ndr_print *ndr, const char *name, const struct OP_PACKAGE_PART_COLLECTION_ctr *r)
{
	ndr_print_struct(ndr, name, "OP_PACKAGE_PART_COLLECTION_ctr");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "p", r->p);
	ndr->depth++;
	if (r->p) {
		ndr_print_OP_PACKAGE_PART_COLLECTION(ndr, "p", r->p);
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_OP_PACKAGE_PART_COLLECTION_serialized_ptr(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct OP_PACKAGE_PART_COLLECTION_serialized_ptr *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 1));
		{
			struct ndr_push *_ndr_s;
			NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_s, 0xFFFFFC01, -1));
			NDR_CHECK(ndr_push_OP_PACKAGE_PART_COLLECTION_ctr(_ndr_s, NDR_SCALARS|NDR_BUFFERS, &r->s));
			NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_s, 0xFFFFFC01, -1));
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_OP_PACKAGE_PART_COLLECTION_serialized_ptr(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct OP_PACKAGE_PART_COLLECTION_serialized_ptr *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 1));
		{
			struct ndr_pull *_ndr_s;
			ssize_t sub_size = -1;
			NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_s, 0xFFFFFC01, sub_size));
			NDR_CHECK(ndr_pull_OP_PACKAGE_PART_COLLECTION_ctr(_ndr_s, NDR_SCALARS|NDR_BUFFERS, &r->s));
			NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_s, 0xFFFFFC01, sub_size));
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_OP_PACKAGE_PART_COLLECTION_serialized_ptr(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct OP_PACKAGE_PART_COLLECTION_serialized_ptr *r)
{
	ndr_print_OP_PACKAGE_PART_COLLECTION_serialized_ptr(ndr, name, r);
}

_PUBLIC_ void ndr_print_OP_PACKAGE_PART_COLLECTION_serialized_ptr(struct ndr_print *ndr, const char *name, const struct OP_PACKAGE_PART_COLLECTION_serialized_ptr *r)
{
	ndr_print_struct(ndr, name, "OP_PACKAGE_PART_COLLECTION_serialized_ptr");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_OP_PACKAGE_PART_COLLECTION_ctr(ndr, "s", &r->s);
	ndr->depth--;
}

_PUBLIC_ size_t ndr_size_OP_PACKAGE_PART_COLLECTION_serialized_ptr(const struct OP_PACKAGE_PART_COLLECTION_serialized_ptr *r, libndr_flags flags)
{
	return ndr_size_struct(r, flags, (ndr_push_flags_fn_t)ndr_push_OP_PACKAGE_PART_COLLECTION_serialized_ptr);
}

static enum ndr_err_code ndr_push_OP_PACKAGE_PART_COLLECTION_blob(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct OP_PACKAGE_PART_COLLECTION_blob *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_size_OP_PACKAGE_PART_COLLECTION_serialized_ptr(r->w, 0)));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->w));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->w) {
			{
				struct ndr_push *_ndr_w;
				NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_w, 4, ndr_size_OP_PACKAGE_PART_COLLECTION_serialized_ptr(r->w, 0)));
				NDR_CHECK(ndr_push_OP_PACKAGE_PART_COLLECTION_serialized_ptr(_ndr_w, NDR_SCALARS|NDR_BUFFERS, r->w));
				NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_w, 4, ndr_size_OP_PACKAGE_PART_COLLECTION_serialized_ptr(r->w, 0)));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_OP_PACKAGE_PART_COLLECTION_blob(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct OP_PACKAGE_PART_COLLECTION_blob *r)
{
	uint32_t _ptr_w;
	TALLOC_CTX *_mem_save_w_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->cbBlob));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_w));
		if (_ptr_w) {
			NDR_PULL_ALLOC(ndr, r->w);
		} else {
			r->w = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->w) {
			_mem_save_w_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->w, 0);
			{
				struct ndr_pull *_ndr_w;
				ssize_t sub_size = r->cbBlob;
				NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_w, 4, sub_size));
				NDR_CHECK(ndr_pull_OP_PACKAGE_PART_COLLECTION_serialized_ptr(_ndr_w, NDR_SCALARS|NDR_BUFFERS, r->w));
				NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_w, 4, sub_size));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_w_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_OP_PACKAGE_PART_COLLECTION_blob(struct ndr_print *ndr, const char *name, const struct OP_PACKAGE_PART_COLLECTION_blob *r)
{
	ndr_print_struct(ndr, name, "OP_PACKAGE_PART_COLLECTION_blob");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "cbBlob", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?ndr_size_OP_PACKAGE_PART_COLLECTION_serialized_ptr(r->w, 0):r->cbBlob);
	ndr_print_ptr(ndr, "w", r->w);
	ndr->depth++;
	if (r->w) {
		ndr_print_OP_PACKAGE_PART_COLLECTION_serialized_ptr(ndr, "w", r->w);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_OP_PACKAGE(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct OP_PACKAGE *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->EncryptionType));
		NDR_CHECK(ndr_push_OP_BLOB(ndr, NDR_SCALARS, &r->EncryptionContext));
		NDR_CHECK(ndr_push_OP_PACKAGE_PART_COLLECTION_blob(ndr, NDR_SCALARS, &r->WrappedPartCollection));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->cbDecryptedPartCollection));
		NDR_CHECK(ndr_push_OP_BLOB(ndr, NDR_SCALARS, &r->Extension));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_OP_BLOB(ndr, NDR_BUFFERS, &r->EncryptionContext));
		NDR_CHECK(ndr_push_OP_PACKAGE_PART_COLLECTION_blob(ndr, NDR_BUFFERS, &r->WrappedPartCollection));
		NDR_CHECK(ndr_push_OP_BLOB(ndr, NDR_BUFFERS, &r->Extension));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_OP_PACKAGE(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct OP_PACKAGE *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->EncryptionType));
		NDR_CHECK(ndr_pull_OP_BLOB(ndr, NDR_SCALARS, &r->EncryptionContext));
		NDR_CHECK(ndr_pull_OP_PACKAGE_PART_COLLECTION_blob(ndr, NDR_SCALARS, &r->WrappedPartCollection));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->cbDecryptedPartCollection));
		NDR_CHECK(ndr_pull_OP_BLOB(ndr, NDR_SCALARS, &r->Extension));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_OP_BLOB(ndr, NDR_BUFFERS, &r->EncryptionContext));
		NDR_CHECK(ndr_pull_OP_PACKAGE_PART_COLLECTION_blob(ndr, NDR_BUFFERS, &r->WrappedPartCollection));
		NDR_CHECK(ndr_pull_OP_BLOB(ndr, NDR_BUFFERS, &r->Extension));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_OP_PACKAGE(struct ndr_print *ndr, const char *name, const struct OP_PACKAGE *r)
{
	ndr_print_struct(ndr, name, "OP_PACKAGE");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_GUID(ndr, "EncryptionType", &r->EncryptionType);
	ndr_print_OP_BLOB(ndr, "EncryptionContext", &r->EncryptionContext);
	ndr_print_OP_PACKAGE_PART_COLLECTION_blob(ndr, "WrappedPartCollection", &r->WrappedPartCollection);
	ndr_print_uint32(ndr, "cbDecryptedPartCollection", r->cbDecryptedPartCollection);
	ndr_print_OP_BLOB(ndr, "Extension", &r->Extension);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_OP_PACKAGE_ctr(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct OP_PACKAGE_ctr *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->p));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->p) {
			NDR_CHECK(ndr_push_OP_PACKAGE(ndr, NDR_SCALARS|NDR_BUFFERS, r->p));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_OP_PACKAGE_ctr(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct OP_PACKAGE_ctr *r)
{
	uint32_t _ptr_p;
	TALLOC_CTX *_mem_save_p_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_p));
		if (_ptr_p) {
			NDR_PULL_ALLOC(ndr, r->p);
		} else {
			r->p = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->p) {
			_mem_save_p_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->p, 0);
			NDR_CHECK(ndr_pull_OP_PACKAGE(ndr, NDR_SCALARS|NDR_BUFFERS, r->p));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_p_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_OP_PACKAGE_ctr(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct OP_PACKAGE_ctr *r)
{
	ndr_print_OP_PACKAGE_ctr(ndr, name, r);
}

_PUBLIC_ void ndr_print_OP_PACKAGE_ctr(struct ndr_print *ndr, const char *name, const struct OP_PACKAGE_ctr *r)
{
	ndr_print_struct(ndr, name, "OP_PACKAGE_ctr");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "p", r->p);
	ndr->depth++;
	if (r->p) {
		ndr_print_OP_PACKAGE(ndr, "p", r->p);
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_OP_PACKAGE_serialized_ptr(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct OP_PACKAGE_serialized_ptr *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 1));
		{
			struct ndr_push *_ndr_s;
			NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_s, 0xFFFFFC01, -1));
			NDR_CHECK(ndr_push_OP_PACKAGE_ctr(_ndr_s, NDR_SCALARS|NDR_BUFFERS, &r->s));
			NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_s, 0xFFFFFC01, -1));
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_OP_PACKAGE_serialized_ptr(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct OP_PACKAGE_serialized_ptr *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 1));
		{
			struct ndr_pull *_ndr_s;
			ssize_t sub_size = -1;
			NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_s, 0xFFFFFC01, sub_size));
			NDR_CHECK(ndr_pull_OP_PACKAGE_ctr(_ndr_s, NDR_SCALARS|NDR_BUFFERS, &r->s));
			NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_s, 0xFFFFFC01, sub_size));
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_OP_PACKAGE_serialized_ptr(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct OP_PACKAGE_serialized_ptr *r)
{
	ndr_print_OP_PACKAGE_serialized_ptr(ndr, name, r);
}

_PUBLIC_ void ndr_print_OP_PACKAGE_serialized_ptr(struct ndr_print *ndr, const char *name, const struct OP_PACKAGE_serialized_ptr *r)
{
	ndr_print_struct(ndr, name, "OP_PACKAGE_serialized_ptr");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_OP_PACKAGE_ctr(ndr, "s", &r->s);
	ndr->depth--;
}

_PUBLIC_ size_t ndr_size_OP_PACKAGE_serialized_ptr(const struct OP_PACKAGE_serialized_ptr *r, libndr_flags flags)
{
	return ndr_size_struct(r, flags, (ndr_push_flags_fn_t)ndr_push_OP_PACKAGE_serialized_ptr);
}

_PUBLIC_ enum ndr_err_code ndr_push_ODJFormat(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum ODJFormat r)
{
	NDR_CHECK(ndr_push_enum_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_ODJFormat(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum ODJFormat *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_enum_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_ODJFormat(struct ndr_print *ndr, const char *name, enum ODJFormat r)
{
	const char *val = NULL;

	switch (r) {
		case ODJ_WIN7_FORMAT: val = "ODJ_WIN7_FORMAT"; break;
		case ODJ_WIN8_FORMAT: val = "ODJ_WIN8_FORMAT"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

_PUBLIC_ enum ndr_err_code ndr_push_ODJ_BLOB_u(struct ndr_push *ndr, ndr_flags_type ndr_flags, const union ODJ_BLOB_u *r)
{
	uint32_t level;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_push_union_align(ndr, 1));
		switch (level) {
			case ODJ_WIN7_FORMAT: {
				{
					struct ndr_push *_ndr_odj_win7blob;
					NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_odj_win7blob, 0xFFFFFC01, -1));
					NDR_CHECK(ndr_push_ODJ_WIN7BLOB(_ndr_odj_win7blob, NDR_SCALARS|NDR_BUFFERS, &r->odj_win7blob));
					NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_odj_win7blob, 0xFFFFFC01, -1));
				}
			break; }

			case ODJ_WIN8_FORMAT: {
				{
					struct ndr_push *_ndr_op_package;
					NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_op_package, 0xFFFFFC01, -1));
					NDR_CHECK(ndr_push_OP_PACKAGE_ctr(_ndr_op_package, NDR_SCALARS|NDR_BUFFERS, &r->op_package));
					NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_op_package, 0xFFFFFC01, -1));
				}
			break; }

			default: {
				{
					libndr_flags _flags_save_DATA_BLOB = ndr->flags;
					ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
					{
						struct ndr_push *_ndr_blob;
						NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_blob, 0xFFFFFC01, -1));
						NDR_CHECK(ndr_push_DATA_BLOB(_ndr_blob, NDR_SCALARS, r->blob));
						NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_blob, 0xFFFFFC01, -1));
					}
					ndr->flags = _flags_save_DATA_BLOB;
				}
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case ODJ_WIN7_FORMAT:
			break;

			case ODJ_WIN8_FORMAT:
			break;

			default:
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_ODJ_BLOB_u(struct ndr_pull *ndr, ndr_flags_type ndr_flags, union ODJ_BLOB_u *r)
{
	uint32_t level;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_pull_union_align(ndr, 1));
		switch (level) {
			case ODJ_WIN7_FORMAT: {
				{
					struct ndr_pull *_ndr_odj_win7blob;
					ssize_t sub_size = -1;
					NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_odj_win7blob, 0xFFFFFC01, sub_size));
					NDR_CHECK(ndr_pull_ODJ_WIN7BLOB(_ndr_odj_win7blob, NDR_SCALARS|NDR_BUFFERS, &r->odj_win7blob));
					NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_odj_win7blob, 0xFFFFFC01, sub_size));
				}
			break; }

			case ODJ_WIN8_FORMAT: {
				{
					struct ndr_pull *_ndr_op_package;
					ssize_t sub_size = -1;
					NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_op_package, 0xFFFFFC01, sub_size));
					NDR_CHECK(ndr_pull_OP_PACKAGE_ctr(_ndr_op_package, NDR_SCALARS|NDR_BUFFERS, &r->op_package));
					NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_op_package, 0xFFFFFC01, sub_size));
				}
			break; }

			default: {
				{
					libndr_flags _flags_save_DATA_BLOB = ndr->flags;
					ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
					{
						struct ndr_pull *_ndr_blob;
						ssize_t sub_size = -1;
						NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_blob, 0xFFFFFC01, sub_size));
						NDR_CHECK(ndr_pull_DATA_BLOB(_ndr_blob, NDR_SCALARS, &r->blob));
						NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_blob, 0xFFFFFC01, sub_size));
					}
					ndr->flags = _flags_save_DATA_BLOB;
				}
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case ODJ_WIN7_FORMAT:
			break;

			case ODJ_WIN8_FORMAT:
			break;

			default:
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_ODJ_BLOB_u(struct ndr_print *ndr, const char *name, const union ODJ_BLOB_u *r)
{
	uint32_t level;
	level = ndr_print_steal_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "ODJ_BLOB_u");
	switch (level) {
		case ODJ_WIN7_FORMAT:
			ndr_print_ODJ_WIN7BLOB(ndr, "odj_win7blob", &r->odj_win7blob);
		break;

		case ODJ_WIN8_FORMAT:
			ndr_print_OP_PACKAGE_ctr(ndr, "op_package", &r->op_package);
		break;

		default:
			{
				libndr_flags _flags_save_DATA_BLOB = ndr->flags;
				ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
				ndr_print_DATA_BLOB(ndr, "blob", r->blob);
				ndr->flags = _flags_save_DATA_BLOB;
			}
		break;

	}
}

_PUBLIC_ size_t ndr_size_ODJ_BLOB_u(const union ODJ_BLOB_u *r, uint32_t level, libndr_flags flags)
{
	return ndr_size_union(r, flags, level, (ndr_push_flags_fn_t)ndr_push_ODJ_BLOB_u);
}

static enum ndr_err_code ndr_push_ODJ_BLOB(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct ODJ_BLOB *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_ODJFormat(ndr, NDR_SCALARS, r->ulODJFormat));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_size_ODJ_BLOB_u(r->pBlob, r->ulODJFormat, 0)));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pBlob));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->pBlob) {
			{
				struct ndr_push *_ndr_pBlob;
				NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_pBlob, 4, ndr_size_ODJ_BLOB_u(r->pBlob, r->ulODJFormat, 0)));
				NDR_CHECK(ndr_push_set_switch_value(_ndr_pBlob, r->pBlob, r->ulODJFormat));
				NDR_CHECK(ndr_push_ODJ_BLOB_u(_ndr_pBlob, NDR_SCALARS|NDR_BUFFERS, r->pBlob));
				NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_pBlob, 4, ndr_size_ODJ_BLOB_u(r->pBlob, r->ulODJFormat, 0)));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_ODJ_BLOB(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct ODJ_BLOB *r)
{
	uint32_t _ptr_pBlob;
	TALLOC_CTX *_mem_save_pBlob_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_ODJFormat(ndr, NDR_SCALARS, &r->ulODJFormat));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->cbBlob));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pBlob));
		if (_ptr_pBlob) {
			NDR_PULL_ALLOC(ndr, r->pBlob);
		} else {
			r->pBlob = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->pBlob) {
			_mem_save_pBlob_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pBlob, 0);
			{
				struct ndr_pull *_ndr_pBlob;
				ssize_t sub_size = r->cbBlob;
				NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_pBlob, 4, sub_size));
				NDR_CHECK(ndr_pull_set_switch_value(_ndr_pBlob, r->pBlob, r->ulODJFormat));
				NDR_CHECK(ndr_pull_ODJ_BLOB_u(_ndr_pBlob, NDR_SCALARS|NDR_BUFFERS, r->pBlob));
				NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_pBlob, 4, sub_size));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pBlob_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_ODJ_BLOB(struct ndr_print *ndr, const char *name, const struct ODJ_BLOB *r)
{
	ndr_print_struct(ndr, name, "ODJ_BLOB");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ODJFormat(ndr, "ulODJFormat", r->ulODJFormat);
	ndr_print_uint32(ndr, "cbBlob", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?ndr_size_ODJ_BLOB_u(r->pBlob, r->ulODJFormat, 0):r->cbBlob);
	ndr_print_ptr(ndr, "pBlob", r->pBlob);
	ndr->depth++;
	if (r->pBlob) {
		ndr_print_set_switch_value(ndr, r->pBlob, r->ulODJFormat);
		ndr_print_ODJ_BLOB_u(ndr, "pBlob", r->pBlob);
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_ODJ_PROVISION_DATA(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct ODJ_PROVISION_DATA *r)
{
	uint32_t cntr_pBlobs_1;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 1));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->ulcBlobs));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pBlobs));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->pBlobs) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->ulcBlobs));
			for (cntr_pBlobs_1 = 0; cntr_pBlobs_1 < (r->ulcBlobs); cntr_pBlobs_1++) {
				NDR_CHECK(ndr_push_ODJ_BLOB(ndr, NDR_SCALARS, &r->pBlobs[cntr_pBlobs_1]));
			}
			for (cntr_pBlobs_1 = 0; cntr_pBlobs_1 < (r->ulcBlobs); cntr_pBlobs_1++) {
				NDR_CHECK(ndr_push_ODJ_BLOB(ndr, NDR_BUFFERS, &r->pBlobs[cntr_pBlobs_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_ODJ_PROVISION_DATA(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct ODJ_PROVISION_DATA *r)
{
	uint32_t _ptr_pBlobs;
	uint32_t size_pBlobs_1 = 0;
	uint32_t cntr_pBlobs_1;
	TALLOC_CTX *_mem_save_pBlobs_0 = NULL;
	TALLOC_CTX *_mem_save_pBlobs_1 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->ulVersion));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->ulcBlobs));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pBlobs));
		if (_ptr_pBlobs) {
			NDR_PULL_ALLOC(ndr, r->pBlobs);
		} else {
			r->pBlobs = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->pBlobs) {
			_mem_save_pBlobs_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pBlobs, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->pBlobs));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->pBlobs, &size_pBlobs_1));
			NDR_PULL_ALLOC_N(ndr, r->pBlobs, size_pBlobs_1);
			_mem_save_pBlobs_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pBlobs, 0);
			for (cntr_pBlobs_1 = 0; cntr_pBlobs_1 < (size_pBlobs_1); cntr_pBlobs_1++) {
				NDR_CHECK(ndr_pull_ODJ_BLOB(ndr, NDR_SCALARS, &r->pBlobs[cntr_pBlobs_1]));
			}
			for (cntr_pBlobs_1 = 0; cntr_pBlobs_1 < (size_pBlobs_1); cntr_pBlobs_1++) {
				NDR_CHECK(ndr_pull_ODJ_BLOB(ndr, NDR_BUFFERS, &r->pBlobs[cntr_pBlobs_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pBlobs_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pBlobs_0, 0);
		}
		if (r->pBlobs) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->pBlobs, r->ulcBlobs));
		}
		for (cntr_pBlobs_1 = 0; cntr_pBlobs_1 < (size_pBlobs_1); cntr_pBlobs_1++) {
		}
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_ODJ_PROVISION_DATA(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct ODJ_PROVISION_DATA *r)
{
	ndr_print_ODJ_PROVISION_DATA(ndr, name, r);
}

_PUBLIC_ void ndr_print_ODJ_PROVISION_DATA(struct ndr_print *ndr, const char *name, const struct ODJ_PROVISION_DATA *r)
{
	uint32_t cntr_pBlobs_1;
	ndr_print_struct(ndr, name, "ODJ_PROVISION_DATA");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "ulVersion", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?1:r->ulVersion);
	ndr_print_uint32(ndr, "ulcBlobs", r->ulcBlobs);
	ndr_print_ptr(ndr, "pBlobs", r->pBlobs);
	ndr->depth++;
	if (r->pBlobs) {
		ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "pBlobs", (uint32_t)(r->ulcBlobs));
		ndr->depth++;
		for (cntr_pBlobs_1 = 0; cntr_pBlobs_1 < (r->ulcBlobs); cntr_pBlobs_1++) {
			ndr_print_ODJ_BLOB(ndr, "pBlobs", &r->pBlobs[cntr_pBlobs_1]);
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_ODJ_PROVISION_DATA_ctr(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct ODJ_PROVISION_DATA_ctr *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->p));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->p) {
			NDR_CHECK(ndr_push_ODJ_PROVISION_DATA(ndr, NDR_SCALARS|NDR_BUFFERS, r->p));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_ODJ_PROVISION_DATA_ctr(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct ODJ_PROVISION_DATA_ctr *r)
{
	uint32_t _ptr_p;
	TALLOC_CTX *_mem_save_p_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_p));
		if (_ptr_p) {
			NDR_PULL_ALLOC(ndr, r->p);
		} else {
			r->p = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->p) {
			_mem_save_p_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->p, 0);
			NDR_CHECK(ndr_pull_ODJ_PROVISION_DATA(ndr, NDR_SCALARS|NDR_BUFFERS, r->p));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_p_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_ODJ_PROVISION_DATA_ctr(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct ODJ_PROVISION_DATA_ctr *r)
{
	ndr_print_ODJ_PROVISION_DATA_ctr(ndr, name, r);
}

_PUBLIC_ void ndr_print_ODJ_PROVISION_DATA_ctr(struct ndr_print *ndr, const char *name, const struct ODJ_PROVISION_DATA_ctr *r)
{
	ndr_print_struct(ndr, name, "ODJ_PROVISION_DATA_ctr");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "p", r->p);
	ndr->depth++;
	if (r->p) {
		ndr_print_ODJ_PROVISION_DATA(ndr, "p", r->p);
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_ODJ_PROVISION_DATA_serialized_ptr(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct ODJ_PROVISION_DATA_serialized_ptr *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 1));
		{
			struct ndr_push *_ndr_s;
			NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_s, 0xFFFFFC01, -1));
			NDR_CHECK(ndr_push_ODJ_PROVISION_DATA_ctr(_ndr_s, NDR_SCALARS|NDR_BUFFERS, &r->s));
			NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_s, 0xFFFFFC01, -1));
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_ODJ_PROVISION_DATA_serialized_ptr(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct ODJ_PROVISION_DATA_serialized_ptr *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 1));
		{
			struct ndr_pull *_ndr_s;
			ssize_t sub_size = -1;
			NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_s, 0xFFFFFC01, sub_size));
			NDR_CHECK(ndr_pull_ODJ_PROVISION_DATA_ctr(_ndr_s, NDR_SCALARS|NDR_BUFFERS, &r->s));
			NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_s, 0xFFFFFC01, sub_size));
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_ODJ_PROVISION_DATA_serialized_ptr(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct ODJ_PROVISION_DATA_serialized_ptr *r)
{
	ndr_print_ODJ_PROVISION_DATA_serialized_ptr(ndr, name, r);
}

_PUBLIC_ void ndr_print_ODJ_PROVISION_DATA_serialized_ptr(struct ndr_print *ndr, const char *name, const struct ODJ_PROVISION_DATA_serialized_ptr *r)
{
	ndr_print_struct(ndr, name, "ODJ_PROVISION_DATA_serialized_ptr");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ODJ_PROVISION_DATA_ctr(ndr, "s", &r->s);
	ndr->depth--;
}

_PUBLIC_ size_t ndr_size_ODJ_PROVISION_DATA_serialized_ptr(const struct ODJ_PROVISION_DATA_serialized_ptr *r, libndr_flags flags)
{
	return ndr_size_struct(r, flags, (ndr_push_flags_fn_t)ndr_push_ODJ_PROVISION_DATA_serialized_ptr);
}

#ifndef SKIP_NDR_TABLE_ODJ
static const struct ndr_interface_public_struct ODJ_public_structs[] = {
	{
		.name = "ODJ_WIN7BLOB_ctr",
		.struct_size = sizeof(struct ODJ_WIN7BLOB_ctr ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_ODJ_WIN7BLOB_ctr,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_ODJ_WIN7BLOB_ctr,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_ODJ_WIN7BLOB_ctr,
	},
	{
		.name = "ODJ_WIN7BLOB_serialized_ptr",
		.struct_size = sizeof(struct ODJ_WIN7BLOB_serialized_ptr ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_ODJ_WIN7BLOB_serialized_ptr,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_ODJ_WIN7BLOB_serialized_ptr,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_ODJ_WIN7BLOB_serialized_ptr,
	},
	{
		.name = "OP_JOINPROV2_PART_ctr",
		.struct_size = sizeof(struct OP_JOINPROV2_PART_ctr ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_OP_JOINPROV2_PART_ctr,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_OP_JOINPROV2_PART_ctr,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_OP_JOINPROV2_PART_ctr,
	},
	{
		.name = "OP_JOINPROV2_PART_serialized_ptr",
		.struct_size = sizeof(struct OP_JOINPROV2_PART_serialized_ptr ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_OP_JOINPROV2_PART_serialized_ptr,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_OP_JOINPROV2_PART_serialized_ptr,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_OP_JOINPROV2_PART_serialized_ptr,
	},
	{
		.name = "OP_JOINPROV3_PART_ctr",
		.struct_size = sizeof(struct OP_JOINPROV3_PART_ctr ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_OP_JOINPROV3_PART_ctr,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_OP_JOINPROV3_PART_ctr,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_OP_JOINPROV3_PART_ctr,
	},
	{
		.name = "OP_JOINPROV3_PART_serialized_ptr",
		.struct_size = sizeof(struct OP_JOINPROV3_PART_serialized_ptr ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_OP_JOINPROV3_PART_serialized_ptr,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_OP_JOINPROV3_PART_serialized_ptr,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_OP_JOINPROV3_PART_serialized_ptr,
	},
	{
		.name = "OP_POLICY_PART_ctr",
		.struct_size = sizeof(struct OP_POLICY_PART_ctr ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_OP_POLICY_PART_ctr,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_OP_POLICY_PART_ctr,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_OP_POLICY_PART_ctr,
	},
	{
		.name = "OP_POLICY_PART_serialized_ptr",
		.struct_size = sizeof(struct OP_POLICY_PART_serialized_ptr ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_OP_POLICY_PART_serialized_ptr,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_OP_POLICY_PART_serialized_ptr,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_OP_POLICY_PART_serialized_ptr,
	},
	{
		.name = "OP_CERT_PART_ctr",
		.struct_size = sizeof(struct OP_CERT_PART_ctr ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_OP_CERT_PART_ctr,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_OP_CERT_PART_ctr,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_OP_CERT_PART_ctr,
	},
	{
		.name = "OP_CERT_PART_serialized_ptr",
		.struct_size = sizeof(struct OP_CERT_PART_serialized_ptr ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_OP_CERT_PART_serialized_ptr,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_OP_CERT_PART_serialized_ptr,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_OP_CERT_PART_serialized_ptr,
	},
	{
		.name = "OP_PACKAGE_PART_ctr",
		.struct_size = sizeof(struct OP_PACKAGE_PART_ctr ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_OP_PACKAGE_PART_ctr,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_OP_PACKAGE_PART_ctr,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_OP_PACKAGE_PART_ctr,
	},
	{
		.name = "OP_PACKAGE_PART_serialized_ptr",
		.struct_size = sizeof(struct OP_PACKAGE_PART_serialized_ptr ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_OP_PACKAGE_PART_serialized_ptr,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_OP_PACKAGE_PART_serialized_ptr,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_OP_PACKAGE_PART_serialized_ptr,
	},
	{
		.name = "OP_PACKAGE_PART_COLLECTION_ctr",
		.struct_size = sizeof(struct OP_PACKAGE_PART_COLLECTION_ctr ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_OP_PACKAGE_PART_COLLECTION_ctr,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_OP_PACKAGE_PART_COLLECTION_ctr,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_OP_PACKAGE_PART_COLLECTION_ctr,
	},
	{
		.name = "OP_PACKAGE_PART_COLLECTION_serialized_ptr",
		.struct_size = sizeof(struct OP_PACKAGE_PART_COLLECTION_serialized_ptr ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_OP_PACKAGE_PART_COLLECTION_serialized_ptr,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_OP_PACKAGE_PART_COLLECTION_serialized_ptr,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_OP_PACKAGE_PART_COLLECTION_serialized_ptr,
	},
	{
		.name = "OP_PACKAGE_ctr",
		.struct_size = sizeof(struct OP_PACKAGE_ctr ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_OP_PACKAGE_ctr,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_OP_PACKAGE_ctr,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_OP_PACKAGE_ctr,
	},
	{
		.name = "OP_PACKAGE_serialized_ptr",
		.struct_size = sizeof(struct OP_PACKAGE_serialized_ptr ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_OP_PACKAGE_serialized_ptr,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_OP_PACKAGE_serialized_ptr,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_OP_PACKAGE_serialized_ptr,
	},
	{
		.name = "ODJ_PROVISION_DATA",
		.struct_size = sizeof(struct ODJ_PROVISION_DATA ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_ODJ_PROVISION_DATA,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_ODJ_PROVISION_DATA,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_ODJ_PROVISION_DATA,
	},
	{
		.name = "ODJ_PROVISION_DATA_ctr",
		.struct_size = sizeof(struct ODJ_PROVISION_DATA_ctr ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_ODJ_PROVISION_DATA_ctr,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_ODJ_PROVISION_DATA_ctr,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_ODJ_PROVISION_DATA_ctr,
	},
	{
		.name = "ODJ_PROVISION_DATA_serialized_ptr",
		.struct_size = sizeof(struct ODJ_PROVISION_DATA_serialized_ptr ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_ODJ_PROVISION_DATA_serialized_ptr,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_ODJ_PROVISION_DATA_serialized_ptr,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_ODJ_PROVISION_DATA_serialized_ptr,
	},
	{ .name = NULL }
};

static const struct ndr_interface_call ODJ_calls[] = {
	{ .name = NULL }
};

static const char * const ODJ_endpoint_strings[] = {
	"ncacn_np:[\\pipe\\ODJ]", 
};

static const struct ndr_interface_string_array ODJ_endpoints = {
	.count	= 1,
	.names	= ODJ_endpoint_strings
};

static const char * const ODJ_authservice_strings[] = {
	"host", 
};

static const struct ndr_interface_string_array ODJ_authservices = {
	.count	= 1,
	.names	= ODJ_authservice_strings
};


const struct ndr_interface_table ndr_table_ODJ = {
	.name		= "ODJ",
	.syntax_id	= {
		{0x11111111,0x3333,0x5555,{0x77,0x77},{0x99,0x99,0x99,0x99}},
		NDR_ODJ_VERSION
	},
	.helpstring	= NDR_ODJ_HELPSTRING,
	.num_calls	= 0,
	.calls		= ODJ_calls,
	.num_public_structs	= 19,
	.public_structs		= ODJ_public_structs,
	.endpoints	= &ODJ_endpoints,
	.authservices	= &ODJ_authservices
};

#endif /* SKIP_NDR_TABLE_ODJ */
