/* parser auto-generated by pidl */

#include "replace.h"
#include "bin/default/librpc/gen_ndr/ndr_tpm20_rsakey_blob.h"

static enum ndr_err_code ndr_push_TPMT_RSA_SCHEME(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct TPMT_RSA_SCHEME *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 2));
		{
			libndr_flags _flags_save_uint16 = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
			NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, 0x0014));
			ndr->flags = _flags_save_uint16;
		}
		{
			libndr_flags _flags_save_uint16 = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
			NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, 0x000B));
			ndr->flags = _flags_save_uint16;
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 2));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_TPMT_RSA_SCHEME(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct TPMT_RSA_SCHEME *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 2));
		{
			libndr_flags _flags_save_uint16 = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
			NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->scheme));
			if (r->scheme < 20 || r->scheme > 20) {
				return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu16") out of range (%"PRIu16" - %"PRIu16")", (uint16_t)(r->scheme), (uint16_t)(20), (uint16_t)(20));
			}
			ndr->flags = _flags_save_uint16;
		}
		{
			libndr_flags _flags_save_uint16 = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
			NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->hash_algorithm));
			if (r->hash_algorithm < 11 || r->hash_algorithm > 11) {
				return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu16") out of range (%"PRIu16" - %"PRIu16")", (uint16_t)(r->hash_algorithm), (uint16_t)(11), (uint16_t)(11));
			}
			ndr->flags = _flags_save_uint16;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 2));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_TPMT_RSA_SCHEME(struct ndr_print *ndr, const char *name, const struct TPMT_RSA_SCHEME *r)
{
	ndr_print_struct(ndr, name, "TPMT_RSA_SCHEME");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	{
		libndr_flags _flags_save_uint16 = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
		ndr_print_uint16(ndr, "scheme", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0x0014:r->scheme);
		ndr->flags = _flags_save_uint16;
	}
	{
		libndr_flags _flags_save_uint16 = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
		ndr_print_uint16(ndr, "hash_algorithm", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0x000B:r->hash_algorithm);
		ndr->flags = _flags_save_uint16;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_TPMS_RSA_PARMS(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct TPMS_RSA_PARMS *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 2));
		{
			libndr_flags _flags_save_uint16 = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
			NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, 0x0010));
			ndr->flags = _flags_save_uint16;
		}
		NDR_CHECK(ndr_push_TPMT_RSA_SCHEME(ndr, NDR_SCALARS, &r->scheme));
		{
			libndr_flags _flags_save_uint16 = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
			NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->keyBits));
			ndr->flags = _flags_save_uint16;
		}
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->exponent, TPM_RSA_EXPONENT_SIZE));
		NDR_CHECK(ndr_push_trailer_align(ndr, 2));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_TPMS_RSA_PARMS(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct TPMS_RSA_PARMS *r)
{
	uint32_t size_exponent_0 = 0;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 2));
		{
			libndr_flags _flags_save_uint16 = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
			NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->symmetric_algorithm));
			if (r->symmetric_algorithm < 16 || r->symmetric_algorithm > 16) {
				return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu16") out of range (%"PRIu16" - %"PRIu16")", (uint16_t)(r->symmetric_algorithm), (uint16_t)(16), (uint16_t)(16));
			}
			ndr->flags = _flags_save_uint16;
		}
		NDR_CHECK(ndr_pull_TPMT_RSA_SCHEME(ndr, NDR_SCALARS, &r->scheme));
		{
			libndr_flags _flags_save_uint16 = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
			NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->keyBits));
			ndr->flags = _flags_save_uint16;
		}
		size_exponent_0 = TPM_RSA_EXPONENT_SIZE;
		NDR_PULL_ALLOC_N(ndr, r->exponent, size_exponent_0);
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->exponent, size_exponent_0));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 2));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_TPMS_RSA_PARMS(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct TPMS_RSA_PARMS *r)
{
	ndr_print_TPMS_RSA_PARMS(ndr, name, r);
}

_PUBLIC_ void ndr_print_TPMS_RSA_PARMS(struct ndr_print *ndr, const char *name, const struct TPMS_RSA_PARMS *r)
{
	ndr_print_struct(ndr, name, "TPMS_RSA_PARMS");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	{
		libndr_flags _flags_save_uint16 = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
		ndr_print_uint16(ndr, "symmetric_algorithm", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0x0010:r->symmetric_algorithm);
		ndr->flags = _flags_save_uint16;
	}
	ndr_print_TPMT_RSA_SCHEME(ndr, "scheme", &r->scheme);
	{
		libndr_flags _flags_save_uint16 = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
		ndr_print_uint16(ndr, "keyBits", r->keyBits);
		ndr->flags = _flags_save_uint16;
	}
	ndr_print_array_uint8(ndr, "exponent", r->exponent, TPM_RSA_EXPONENT_SIZE);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_TPM2B_PUBLIC_KEY_RSA(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct TPM2B_PUBLIC_KEY_RSA *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 2));
		{
			libndr_flags _flags_save_uint16 = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
			NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->size));
			ndr->flags = _flags_save_uint16;
		}
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->buffer, r->size));
		NDR_CHECK(ndr_push_trailer_align(ndr, 2));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_TPM2B_PUBLIC_KEY_RSA(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct TPM2B_PUBLIC_KEY_RSA *r)
{
	uint32_t size_buffer_0 = 0;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 2));
		{
			libndr_flags _flags_save_uint16 = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
			NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->size));
			ndr->flags = _flags_save_uint16;
		}
		size_buffer_0 = r->size;
		NDR_PULL_ALLOC_N(ndr, r->buffer, size_buffer_0);
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->buffer, size_buffer_0));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 2));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_TPM2B_PUBLIC_KEY_RSA(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct TPM2B_PUBLIC_KEY_RSA *r)
{
	ndr_print_TPM2B_PUBLIC_KEY_RSA(ndr, name, r);
}

_PUBLIC_ void ndr_print_TPM2B_PUBLIC_KEY_RSA(struct ndr_print *ndr, const char *name, const struct TPM2B_PUBLIC_KEY_RSA *r)
{
	ndr_print_struct(ndr, name, "TPM2B_PUBLIC_KEY_RSA");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	{
		libndr_flags _flags_save_uint16 = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
		ndr_print_uint16(ndr, "size", r->size);
		ndr->flags = _flags_save_uint16;
	}
	ndr_print_array_uint8(ndr, "buffer", r->buffer, r->size);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_TPM2B_DIGEST(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct TPM2B_DIGEST *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 2));
		{
			libndr_flags _flags_save_uint16 = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
			NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->size));
			ndr->flags = _flags_save_uint16;
		}
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->buffer, r->size));
		NDR_CHECK(ndr_push_trailer_align(ndr, 2));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_TPM2B_DIGEST(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct TPM2B_DIGEST *r)
{
	uint32_t size_buffer_0 = 0;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 2));
		{
			libndr_flags _flags_save_uint16 = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
			NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->size));
			ndr->flags = _flags_save_uint16;
		}
		size_buffer_0 = r->size;
		NDR_PULL_ALLOC_N(ndr, r->buffer, size_buffer_0);
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->buffer, size_buffer_0));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 2));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_TPM2B_DIGEST(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct TPM2B_DIGEST *r)
{
	ndr_print_TPM2B_DIGEST(ndr, name, r);
}

_PUBLIC_ void ndr_print_TPM2B_DIGEST(struct ndr_print *ndr, const char *name, const struct TPM2B_DIGEST *r)
{
	ndr_print_struct(ndr, name, "TPM2B_DIGEST");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	{
		libndr_flags _flags_save_uint16 = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
		ndr_print_uint16(ndr, "size", r->size);
		ndr->flags = _flags_save_uint16;
	}
	ndr_print_array_uint8(ndr, "buffer", r->buffer, r->size);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_TPM2B_PUBLIC(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct TPM2B_PUBLIC *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		{
			libndr_flags _flags_save_uint16 = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
			NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->size));
			ndr->flags = _flags_save_uint16;
		}
		{
			libndr_flags _flags_save_uint16 = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
			NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, 0x0001));
			ndr->flags = _flags_save_uint16;
		}
		{
			libndr_flags _flags_save_uint16 = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
			NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, 0x000B));
			ndr->flags = _flags_save_uint16;
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->attributes));
		NDR_CHECK(ndr_push_TPM2B_DIGEST(ndr, NDR_SCALARS, &r->auth_policy));
		NDR_CHECK(ndr_push_TPMS_RSA_PARMS(ndr, NDR_SCALARS, &r->rsa_detail));
		NDR_CHECK(ndr_push_TPM2B_PUBLIC_KEY_RSA(ndr, NDR_SCALARS, &r->rsa));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_TPM2B_PUBLIC(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct TPM2B_PUBLIC *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		{
			libndr_flags _flags_save_uint16 = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
			NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->size));
			ndr->flags = _flags_save_uint16;
		}
		{
			libndr_flags _flags_save_uint16 = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
			NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->type));
			if (r->type < 1 || r->type > 1) {
				return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu16") out of range (%"PRIu16" - %"PRIu16")", (uint16_t)(r->type), (uint16_t)(1), (uint16_t)(1));
			}
			ndr->flags = _flags_save_uint16;
		}
		{
			libndr_flags _flags_save_uint16 = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
			NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->hash_algorithm));
			if (r->hash_algorithm < 11 || r->hash_algorithm > 11) {
				return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu16") out of range (%"PRIu16" - %"PRIu16")", (uint16_t)(r->hash_algorithm), (uint16_t)(11), (uint16_t)(11));
			}
			ndr->flags = _flags_save_uint16;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->attributes));
		NDR_CHECK(ndr_pull_TPM2B_DIGEST(ndr, NDR_SCALARS, &r->auth_policy));
		NDR_CHECK(ndr_pull_TPMS_RSA_PARMS(ndr, NDR_SCALARS, &r->rsa_detail));
		NDR_CHECK(ndr_pull_TPM2B_PUBLIC_KEY_RSA(ndr, NDR_SCALARS, &r->rsa));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_TPM2B_PUBLIC(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct TPM2B_PUBLIC *r)
{
	ndr_print_TPM2B_PUBLIC(ndr, name, r);
}

_PUBLIC_ void ndr_print_TPM2B_PUBLIC(struct ndr_print *ndr, const char *name, const struct TPM2B_PUBLIC *r)
{
	ndr_print_struct(ndr, name, "TPM2B_PUBLIC");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	{
		libndr_flags _flags_save_uint16 = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
		ndr_print_uint16(ndr, "size", r->size);
		ndr->flags = _flags_save_uint16;
	}
	{
		libndr_flags _flags_save_uint16 = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
		ndr_print_uint16(ndr, "type", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0x0001:r->type);
		ndr->flags = _flags_save_uint16;
	}
	{
		libndr_flags _flags_save_uint16 = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
		ndr_print_uint16(ndr, "hash_algorithm", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0x000B:r->hash_algorithm);
		ndr->flags = _flags_save_uint16;
	}
	ndr_print_uint32(ndr, "attributes", r->attributes);
	ndr_print_TPM2B_DIGEST(ndr, "auth_policy", &r->auth_policy);
	ndr_print_TPMS_RSA_PARMS(ndr, "rsa_detail", &r->rsa_detail);
	ndr_print_TPM2B_PUBLIC_KEY_RSA(ndr, "rsa", &r->rsa);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_TPM20_RSAKEY_BLOB(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct TPM20_RSAKEY_BLOB *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0x4D504350));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 46));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0x00000002));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->flags));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->public_length));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->private_length));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->migration_public_length));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->migration_private_length));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->policy_digest_list_length));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->pcr_binding_length));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->pcr_digest_length));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->encrypted_secret_length));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->tpm12_hostage_blob_length));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->pcr_alg_id));
		{
			libndr_flags _flags_save_TPM2B_PUBLIC = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN);
			NDR_CHECK(ndr_push_TPM2B_PUBLIC(ndr, NDR_SCALARS, &r->public_key));
			ndr->flags = _flags_save_TPM2B_PUBLIC;
		}
		{
			libndr_flags _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->remaining));
			ndr->flags = _flags_save_DATA_BLOB;
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_TPM20_RSAKEY_BLOB(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct TPM20_RSAKEY_BLOB *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->magic));
		if (r->magic < 1297105744 || r->magic > 1297105744) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->magic), (uint32_t)(1297105744), (uint32_t)(1297105744));
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->header_length));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->type));
		if (r->type < 2 || r->type > 2) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->type), (uint32_t)(2), (uint32_t)(2));
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->flags));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->public_length));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->private_length));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->migration_public_length));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->migration_private_length));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->policy_digest_list_length));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->pcr_binding_length));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->pcr_digest_length));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->encrypted_secret_length));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->tpm12_hostage_blob_length));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->pcr_alg_id));
		{
			libndr_flags _flags_save_TPM2B_PUBLIC = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN);
			NDR_CHECK(ndr_pull_TPM2B_PUBLIC(ndr, NDR_SCALARS, &r->public_key));
			ndr->flags = _flags_save_TPM2B_PUBLIC;
		}
		{
			libndr_flags _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->remaining));
			ndr->flags = _flags_save_DATA_BLOB;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_TPM20_RSAKEY_BLOB(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct TPM20_RSAKEY_BLOB *r)
{
	ndr_print_TPM20_RSAKEY_BLOB(ndr, name, r);
}

_PUBLIC_ void ndr_print_TPM20_RSAKEY_BLOB(struct ndr_print *ndr, const char *name, const struct TPM20_RSAKEY_BLOB *r)
{
	ndr_print_struct(ndr, name, "TPM20_RSAKEY_BLOB");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "magic", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0x4D504350:r->magic);
	ndr_print_uint32(ndr, "header_length", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?46:r->header_length);
	ndr_print_uint32(ndr, "type", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0x00000002:r->type);
	ndr_print_uint32(ndr, "flags", r->flags);
	ndr_print_uint32(ndr, "public_length", r->public_length);
	ndr_print_uint32(ndr, "private_length", r->private_length);
	ndr_print_uint32(ndr, "migration_public_length", r->migration_public_length);
	ndr_print_uint32(ndr, "migration_private_length", r->migration_private_length);
	ndr_print_uint32(ndr, "policy_digest_list_length", r->policy_digest_list_length);
	ndr_print_uint32(ndr, "pcr_binding_length", r->pcr_binding_length);
	ndr_print_uint32(ndr, "pcr_digest_length", r->pcr_digest_length);
	ndr_print_uint32(ndr, "encrypted_secret_length", r->encrypted_secret_length);
	ndr_print_uint32(ndr, "tpm12_hostage_blob_length", r->tpm12_hostage_blob_length);
	ndr_print_uint16(ndr, "pcr_alg_id", r->pcr_alg_id);
	{
		libndr_flags _flags_save_TPM2B_PUBLIC = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN);
		ndr_print_TPM2B_PUBLIC(ndr, "public_key", &r->public_key);
		ndr->flags = _flags_save_TPM2B_PUBLIC;
	}
	{
		libndr_flags _flags_save_DATA_BLOB = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
		ndr_print_DATA_BLOB(ndr, "remaining", r->remaining);
		ndr->flags = _flags_save_DATA_BLOB;
	}
	ndr->depth--;
}

#ifndef SKIP_NDR_TABLE_tpm20_rsakey_blob
static const struct ndr_interface_public_struct tpm20_rsakey_blob_public_structs[] = {
	{
		.name = "TPMS_RSA_PARMS",
		.struct_size = sizeof(struct TPMS_RSA_PARMS ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_TPMS_RSA_PARMS,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_TPMS_RSA_PARMS,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_TPMS_RSA_PARMS,
	},
	{
		.name = "TPM2B_PUBLIC_KEY_RSA",
		.struct_size = sizeof(struct TPM2B_PUBLIC_KEY_RSA ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_TPM2B_PUBLIC_KEY_RSA,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_TPM2B_PUBLIC_KEY_RSA,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_TPM2B_PUBLIC_KEY_RSA,
	},
	{
		.name = "TPM2B_DIGEST",
		.struct_size = sizeof(struct TPM2B_DIGEST ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_TPM2B_DIGEST,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_TPM2B_DIGEST,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_TPM2B_DIGEST,
	},
	{
		.name = "TPM2B_PUBLIC",
		.struct_size = sizeof(struct TPM2B_PUBLIC ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_TPM2B_PUBLIC,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_TPM2B_PUBLIC,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_TPM2B_PUBLIC,
	},
	{
		.name = "TPM20_RSAKEY_BLOB",
		.struct_size = sizeof(struct TPM20_RSAKEY_BLOB ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_TPM20_RSAKEY_BLOB,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_TPM20_RSAKEY_BLOB,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_TPM20_RSAKEY_BLOB,
	},
	{ .name = NULL }
};

static const struct ndr_interface_call tpm20_rsakey_blob_calls[] = {
	{ .name = NULL }
};

static const char * const tpm20_rsakey_blob_endpoint_strings[] = {
	"ncacn_np:[\\pipe\\tpm20_rsakey_blob]", 
};

static const struct ndr_interface_string_array tpm20_rsakey_blob_endpoints = {
	.count	= 1,
	.names	= tpm20_rsakey_blob_endpoint_strings
};

static const char * const tpm20_rsakey_blob_authservice_strings[] = {
	"host", 
};

static const struct ndr_interface_string_array tpm20_rsakey_blob_authservices = {
	.count	= 1,
	.names	= tpm20_rsakey_blob_authservice_strings
};


const struct ndr_interface_table ndr_table_tpm20_rsakey_blob = {
	.name		= "tpm20_rsakey_blob",
	.num_calls	= 0,
	.calls		= tpm20_rsakey_blob_calls,
	.num_public_structs	= 5,
	.public_structs		= tpm20_rsakey_blob_public_structs,
	.endpoints	= &tpm20_rsakey_blob_endpoints,
	.authservices	= &tpm20_rsakey_blob_authservices
};

#endif /* SKIP_NDR_TABLE_tpm20_rsakey_blob */
