/* parser auto-generated by pidl */

#include "replace.h"
#include "bin/default/librpc/gen_ndr/ndr_misc.h"

_PUBLIC_ enum ndr_err_code ndr_push_GUID(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct GUID *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->time_low));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->time_mid));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->time_hi_and_version));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->clock_seq, 2));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->node, 6));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_GUID(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct GUID *r)
{
	uint32_t size_clock_seq_0 = 0;
	uint32_t size_node_0 = 0;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->time_low));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->time_mid));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->time_hi_and_version));
		size_clock_seq_0 = 2;
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->clock_seq, size_clock_seq_0));
		size_node_0 = 6;
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->node, size_node_0));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_GUID(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct GUID *r)
{
	ndr_print_GUID(ndr, name, r);
}

_PUBLIC_ size_t ndr_size_GUID(const struct GUID *r, libndr_flags flags)
{
	return ndr_size_struct(r, flags, (ndr_push_flags_fn_t)ndr_push_GUID);
}

_PUBLIC_ enum ndr_err_code ndr_push_ndr_syntax_id(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct ndr_syntax_id *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->uuid));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->if_version));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_ndr_syntax_id(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct ndr_syntax_id *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->uuid));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->if_version));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_ndr_syntax_id(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct ndr_syntax_id *r)
{
	ndr_print_ndr_syntax_id(ndr, name, r);
}

_PUBLIC_ void ndr_print_ndr_syntax_id(struct ndr_print *ndr, const char *name, const struct ndr_syntax_id *r)
{
	ndr_print_struct(ndr, name, "ndr_syntax_id");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_GUID(ndr, "uuid", &r->uuid);
	ndr_print_uint32(ndr, "if_version", r->if_version);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_policy_handle(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct policy_handle *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->handle_type));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->uuid));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_policy_handle(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct policy_handle *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->handle_type));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->uuid));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_policy_handle(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct policy_handle *r)
{
	ndr_print_policy_handle(ndr, name, r);
}

_PUBLIC_ void ndr_print_policy_handle(struct ndr_print *ndr, const char *name, const struct policy_handle *r)
{
	ndr_print_struct(ndr, name, "policy_handle");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "handle_type", r->handle_type);
	ndr_print_GUID(ndr, "uuid", &r->uuid);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_netr_SchannelType(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum netr_SchannelType r)
{
	NDR_CHECK(ndr_push_enum_uint1632(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_netr_SchannelType(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum netr_SchannelType *r)
{
	uint16_t v;
	NDR_CHECK(ndr_pull_enum_uint1632(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_SchannelType(struct ndr_print *ndr, const char *name, enum netr_SchannelType r)
{
	const char *val = NULL;

	switch (r) {
		case SEC_CHAN_NULL: val = "SEC_CHAN_NULL"; break;
		case SEC_CHAN_LOCAL: val = "SEC_CHAN_LOCAL"; break;
		case SEC_CHAN_WKSTA: val = "SEC_CHAN_WKSTA"; break;
		case SEC_CHAN_DNS_DOMAIN: val = "SEC_CHAN_DNS_DOMAIN"; break;
		case SEC_CHAN_DOMAIN: val = "SEC_CHAN_DOMAIN"; break;
		case SEC_CHAN_LANMAN: val = "SEC_CHAN_LANMAN"; break;
		case SEC_CHAN_BDC: val = "SEC_CHAN_BDC"; break;
		case SEC_CHAN_RODC: val = "SEC_CHAN_RODC"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

_PUBLIC_ enum ndr_err_code ndr_push_winreg_Type(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum winreg_Type r)
{
	NDR_CHECK(ndr_push_enum_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_winreg_Type(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum winreg_Type *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_enum_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winreg_Type(struct ndr_print *ndr, const char *name, enum winreg_Type r)
{
	const char *val = NULL;

	switch (r) {
		case REG_NONE: val = "REG_NONE"; break;
		case REG_SZ: val = "REG_SZ"; break;
		case REG_EXPAND_SZ: val = "REG_EXPAND_SZ"; break;
		case REG_BINARY: val = "REG_BINARY"; break;
		case REG_DWORD: val = "REG_DWORD"; break;
		case REG_DWORD_BIG_ENDIAN: val = "REG_DWORD_BIG_ENDIAN"; break;
		case REG_LINK: val = "REG_LINK"; break;
		case REG_MULTI_SZ: val = "REG_MULTI_SZ"; break;
		case REG_RESOURCE_LIST: val = "REG_RESOURCE_LIST"; break;
		case REG_FULL_RESOURCE_DESCRIPTOR: val = "REG_FULL_RESOURCE_DESCRIPTOR"; break;
		case REG_RESOURCE_REQUIREMENTS_LIST: val = "REG_RESOURCE_REQUIREMENTS_LIST"; break;
		case REG_QWORD: val = "REG_QWORD"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

_PUBLIC_ enum ndr_err_code ndr_push_winreg_Data(struct ndr_push *ndr, ndr_flags_type ndr_flags, const union winreg_Data *r)
{
	uint32_t level;
	{
		libndr_flags _flags_save_UNION = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_LITTLE_ENDIAN);
		NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
			NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
			NDR_CHECK(ndr_push_union_align(ndr, 8));
			switch (level) {
				case REG_NONE: {
				break; }

				case REG_SZ: {
					{
						libndr_flags _flags_save_string = ndr->flags;
						ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
						NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->string));
						ndr->flags = _flags_save_string;
					}
				break; }

				case REG_EXPAND_SZ: {
					{
						libndr_flags _flags_save_string = ndr->flags;
						ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
						NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->string));
						ndr->flags = _flags_save_string;
					}
				break; }

				case REG_BINARY: {
					{
						libndr_flags _flags_save_DATA_BLOB = ndr->flags;
						ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
						NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->binary));
						ndr->flags = _flags_save_DATA_BLOB;
					}
				break; }

				case REG_DWORD: {
					NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->value));
				break; }

				case REG_DWORD_BIG_ENDIAN: {
					{
						libndr_flags _flags_save_uint32 = ndr->flags;
						ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
						NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->value));
						ndr->flags = _flags_save_uint32;
					}
				break; }

				case REG_MULTI_SZ: {
					{
						libndr_flags _flags_save_string_array = ndr->flags;
						ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
						NDR_CHECK(ndr_push_string_array(ndr, NDR_SCALARS, r->string_array));
						ndr->flags = _flags_save_string_array;
					}
				break; }

				case REG_QWORD: {
					NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->qword));
				break; }

				default: {
					{
						libndr_flags _flags_save_DATA_BLOB = ndr->flags;
						ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
						NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->data));
						ndr->flags = _flags_save_DATA_BLOB;
					}
				break; }

			}
		}
		ndr->flags = _flags_save_UNION;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_winreg_Data(struct ndr_pull *ndr, ndr_flags_type ndr_flags, union winreg_Data *r)
{
	uint32_t level;
	{
		libndr_flags _flags_save_UNION = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_LITTLE_ENDIAN);
		NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
			NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
			NDR_CHECK(ndr_pull_union_align(ndr, 8));
			switch (level) {
				case REG_NONE: {
				break; }

				case REG_SZ: {
					{
						libndr_flags _flags_save_string = ndr->flags;
						ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
						NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->string));
						ndr->flags = _flags_save_string;
					}
				break; }

				case REG_EXPAND_SZ: {
					{
						libndr_flags _flags_save_string = ndr->flags;
						ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
						NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->string));
						ndr->flags = _flags_save_string;
					}
				break; }

				case REG_BINARY: {
					{
						libndr_flags _flags_save_DATA_BLOB = ndr->flags;
						ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
						NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->binary));
						ndr->flags = _flags_save_DATA_BLOB;
					}
				break; }

				case REG_DWORD: {
					NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->value));
				break; }

				case REG_DWORD_BIG_ENDIAN: {
					{
						libndr_flags _flags_save_uint32 = ndr->flags;
						ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
						NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->value));
						ndr->flags = _flags_save_uint32;
					}
				break; }

				case REG_MULTI_SZ: {
					{
						libndr_flags _flags_save_string_array = ndr->flags;
						ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
						NDR_CHECK(ndr_pull_string_array(ndr, NDR_SCALARS, &r->string_array));
						ndr->flags = _flags_save_string_array;
					}
				break; }

				case REG_QWORD: {
					NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->qword));
				break; }

				default: {
					{
						libndr_flags _flags_save_DATA_BLOB = ndr->flags;
						ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
						NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->data));
						ndr->flags = _flags_save_DATA_BLOB;
					}
				break; }

			}
		}
		ndr->flags = _flags_save_UNION;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winreg_Data(struct ndr_print *ndr, const char *name, const union winreg_Data *r)
{
	uint32_t level;
	{
		libndr_flags _flags_save_UNION = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_LITTLE_ENDIAN);
		level = ndr_print_steal_switch_value(ndr, r);
		ndr_print_union(ndr, name, level, "winreg_Data");
		switch (level) {
			case REG_NONE:
			break;

			case REG_SZ:
				{
					libndr_flags _flags_save_string = ndr->flags;
					ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
					ndr_print_string(ndr, "string", r->string);
					ndr->flags = _flags_save_string;
				}
			break;

			case REG_EXPAND_SZ:
				{
					libndr_flags _flags_save_string = ndr->flags;
					ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
					ndr_print_string(ndr, "string", r->string);
					ndr->flags = _flags_save_string;
				}
			break;

			case REG_BINARY:
				{
					libndr_flags _flags_save_DATA_BLOB = ndr->flags;
					ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
					ndr_print_DATA_BLOB(ndr, "binary", r->binary);
					ndr->flags = _flags_save_DATA_BLOB;
				}
			break;

			case REG_DWORD:
				ndr_print_uint32(ndr, "value", r->value);
			break;

			case REG_DWORD_BIG_ENDIAN:
				{
					libndr_flags _flags_save_uint32 = ndr->flags;
					ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
					ndr_print_uint32(ndr, "value", r->value);
					ndr->flags = _flags_save_uint32;
				}
			break;

			case REG_MULTI_SZ:
				{
					libndr_flags _flags_save_string_array = ndr->flags;
					ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
					ndr_print_string_array(ndr, "string_array", r->string_array);
					ndr->flags = _flags_save_string_array;
				}
			break;

			case REG_QWORD:
				ndr_print_hyper(ndr, "qword", r->qword);
			break;

			default:
				{
					libndr_flags _flags_save_DATA_BLOB = ndr->flags;
					ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
					ndr_print_DATA_BLOB(ndr, "data", r->data);
					ndr->flags = _flags_save_DATA_BLOB;
				}
			break;

		}
		ndr->flags = _flags_save_UNION;
	}
}

_PUBLIC_ enum ndr_err_code ndr_push_winreg_Data_GPO(struct ndr_push *ndr, ndr_flags_type ndr_flags, const union winreg_Data_GPO *r)
{
	uint32_t level;
	{
		libndr_flags _flags_save_UNION = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_LITTLE_ENDIAN);
		NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
			NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
			NDR_CHECK(ndr_push_union_align(ndr, 8));
			switch (level) {
				case REG_NONE: {
				break; }

				case REG_SZ: {
					{
						libndr_flags _flags_save_string = ndr->flags;
						ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
						NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->string));
						ndr->flags = _flags_save_string;
					}
				break; }

				case REG_EXPAND_SZ: {
					{
						libndr_flags _flags_save_string = ndr->flags;
						ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
						NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->string));
						ndr->flags = _flags_save_string;
					}
				break; }

				case REG_BINARY: {
					{
						libndr_flags _flags_save_DATA_BLOB = ndr->flags;
						ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
						NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->binary));
						ndr->flags = _flags_save_DATA_BLOB;
					}
				break; }

				case REG_DWORD: {
					NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->value));
				break; }

				case REG_DWORD_BIG_ENDIAN: {
					{
						libndr_flags _flags_save_uint32 = ndr->flags;
						ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
						NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->value));
						ndr->flags = _flags_save_uint32;
					}
				break; }

				case REG_QWORD: {
					NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->qword));
				break; }

				default: {
					{
						libndr_flags _flags_save_DATA_BLOB = ndr->flags;
						ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
						NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->data));
						ndr->flags = _flags_save_DATA_BLOB;
					}
				break; }

			}
		}
		ndr->flags = _flags_save_UNION;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_winreg_Data_GPO(struct ndr_pull *ndr, ndr_flags_type ndr_flags, union winreg_Data_GPO *r)
{
	uint32_t level;
	{
		libndr_flags _flags_save_UNION = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_LITTLE_ENDIAN);
		NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
			NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
			NDR_CHECK(ndr_pull_union_align(ndr, 8));
			switch (level) {
				case REG_NONE: {
				break; }

				case REG_SZ: {
					{
						libndr_flags _flags_save_string = ndr->flags;
						ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
						NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->string));
						ndr->flags = _flags_save_string;
					}
				break; }

				case REG_EXPAND_SZ: {
					{
						libndr_flags _flags_save_string = ndr->flags;
						ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
						NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->string));
						ndr->flags = _flags_save_string;
					}
				break; }

				case REG_BINARY: {
					{
						libndr_flags _flags_save_DATA_BLOB = ndr->flags;
						ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
						NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->binary));
						ndr->flags = _flags_save_DATA_BLOB;
					}
				break; }

				case REG_DWORD: {
					NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->value));
				break; }

				case REG_DWORD_BIG_ENDIAN: {
					{
						libndr_flags _flags_save_uint32 = ndr->flags;
						ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
						NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->value));
						ndr->flags = _flags_save_uint32;
					}
				break; }

				case REG_QWORD: {
					NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->qword));
				break; }

				default: {
					{
						libndr_flags _flags_save_DATA_BLOB = ndr->flags;
						ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
						NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->data));
						ndr->flags = _flags_save_DATA_BLOB;
					}
				break; }

			}
		}
		ndr->flags = _flags_save_UNION;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_winreg_Data_GPO(struct ndr_print *ndr, const char *name, const union winreg_Data_GPO *r)
{
	uint32_t level;
	{
		libndr_flags _flags_save_UNION = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_LITTLE_ENDIAN);
		level = ndr_print_steal_switch_value(ndr, r);
		ndr_print_union(ndr, name, level, "winreg_Data_GPO");
		switch (level) {
			case REG_NONE:
			break;

			case REG_SZ:
				{
					libndr_flags _flags_save_string = ndr->flags;
					ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
					ndr_print_string(ndr, "string", r->string);
					ndr->flags = _flags_save_string;
				}
			break;

			case REG_EXPAND_SZ:
				{
					libndr_flags _flags_save_string = ndr->flags;
					ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
					ndr_print_string(ndr, "string", r->string);
					ndr->flags = _flags_save_string;
				}
			break;

			case REG_BINARY:
				{
					libndr_flags _flags_save_DATA_BLOB = ndr->flags;
					ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
					ndr_print_DATA_BLOB(ndr, "binary", r->binary);
					ndr->flags = _flags_save_DATA_BLOB;
				}
			break;

			case REG_DWORD:
				ndr_print_uint32(ndr, "value", r->value);
			break;

			case REG_DWORD_BIG_ENDIAN:
				{
					libndr_flags _flags_save_uint32 = ndr->flags;
					ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
					ndr_print_uint32(ndr, "value", r->value);
					ndr->flags = _flags_save_uint32;
				}
			break;

			case REG_QWORD:
				ndr_print_hyper(ndr, "qword", r->qword);
			break;

			default:
				{
					libndr_flags _flags_save_DATA_BLOB = ndr->flags;
					ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
					ndr_print_DATA_BLOB(ndr, "data", r->data);
					ndr->flags = _flags_save_DATA_BLOB;
				}
			break;

		}
		ndr->flags = _flags_save_UNION;
	}
}

_PUBLIC_ size_t ndr_size_winreg_Data_GPO(const union winreg_Data_GPO *r, uint32_t level, libndr_flags flags)
{
	flags |= LIBNDR_FLAG_LITTLE_ENDIAN;
	return ndr_size_union(r, flags, level, (ndr_push_flags_fn_t)ndr_push_winreg_Data_GPO);
}

_PUBLIC_ enum ndr_err_code ndr_push_netr_SamDatabaseID(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum netr_SamDatabaseID r)
{
	NDR_CHECK(ndr_push_enum_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_netr_SamDatabaseID(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum netr_SamDatabaseID *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_enum_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netr_SamDatabaseID(struct ndr_print *ndr, const char *name, enum netr_SamDatabaseID r)
{
	const char *val = NULL;

	switch (r) {
		case SAM_DATABASE_DOMAIN: val = "SAM_DATABASE_DOMAIN"; break;
		case SAM_DATABASE_BUILTIN: val = "SAM_DATABASE_BUILTIN"; break;
		case SAM_DATABASE_PRIVS: val = "SAM_DATABASE_PRIVS"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

_PUBLIC_ enum ndr_err_code ndr_push_svcctl_ServerType(struct ndr_push *ndr, ndr_flags_type ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_svcctl_ServerType(struct ndr_pull *ndr, ndr_flags_type ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_ServerType(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SV_TYPE_WORKSTATION", SV_TYPE_WORKSTATION, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SV_TYPE_SERVER", SV_TYPE_SERVER, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SV_TYPE_SQLSERVER", SV_TYPE_SQLSERVER, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SV_TYPE_DOMAIN_CTRL", SV_TYPE_DOMAIN_CTRL, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SV_TYPE_DOMAIN_BAKCTRL", SV_TYPE_DOMAIN_BAKCTRL, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SV_TYPE_TIME_SOURCE", SV_TYPE_TIME_SOURCE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SV_TYPE_AFP", SV_TYPE_AFP, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SV_TYPE_NOVELL", SV_TYPE_NOVELL, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SV_TYPE_DOMAIN_MEMBER", SV_TYPE_DOMAIN_MEMBER, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SV_TYPE_PRINTQ_SERVER", SV_TYPE_PRINTQ_SERVER, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SV_TYPE_DIALIN_SERVER", SV_TYPE_DIALIN_SERVER, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SV_TYPE_SERVER_UNIX", SV_TYPE_SERVER_UNIX, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SV_TYPE_NT", SV_TYPE_NT, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SV_TYPE_WFW", SV_TYPE_WFW, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SV_TYPE_SERVER_MFPN", SV_TYPE_SERVER_MFPN, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SV_TYPE_SERVER_NT", SV_TYPE_SERVER_NT, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SV_TYPE_POTENTIAL_BROWSER", SV_TYPE_POTENTIAL_BROWSER, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SV_TYPE_BACKUP_BROWSER", SV_TYPE_BACKUP_BROWSER, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SV_TYPE_MASTER_BROWSER", SV_TYPE_MASTER_BROWSER, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SV_TYPE_DOMAIN_MASTER", SV_TYPE_DOMAIN_MASTER, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SV_TYPE_SERVER_OSF", SV_TYPE_SERVER_OSF, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SV_TYPE_SERVER_VMS", SV_TYPE_SERVER_VMS, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SV_TYPE_WIN95_PLUS", SV_TYPE_WIN95_PLUS, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SV_TYPE_DFS_SERVER", SV_TYPE_DFS_SERVER, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SV_TYPE_ALTERNATE_XPORT", SV_TYPE_ALTERNATE_XPORT, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SV_TYPE_LOCAL_LIST_ONLY", SV_TYPE_LOCAL_LIST_ONLY, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SV_TYPE_DOMAIN_ENUM", SV_TYPE_DOMAIN_ENUM, r);
	ndr->depth--;
}

#ifndef SKIP_NDR_TABLE_misc
static const struct ndr_interface_public_struct misc_public_structs[] = {
	{
		.name = "GUID",
		.struct_size = sizeof(struct GUID ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_GUID,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_GUID,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_GUID,
	},
	{
		.name = "ndr_syntax_id",
		.struct_size = sizeof(struct ndr_syntax_id ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_ndr_syntax_id,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_ndr_syntax_id,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_ndr_syntax_id,
	},
	{
		.name = "policy_handle",
		.struct_size = sizeof(struct policy_handle ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_policy_handle,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_policy_handle,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_policy_handle,
	},
	{ .name = NULL }
};

static const struct ndr_interface_call misc_calls[] = {
	{ .name = NULL }
};

static const char * const misc_endpoint_strings[] = {
	"ncacn_np:[\\pipe\\misc]", 
};

static const struct ndr_interface_string_array misc_endpoints = {
	.count	= 1,
	.names	= misc_endpoint_strings
};

static const char * const misc_authservice_strings[] = {
	"host", 
};

static const struct ndr_interface_string_array misc_authservices = {
	.count	= 1,
	.names	= misc_authservice_strings
};


const struct ndr_interface_table ndr_table_misc = {
	.name		= "misc",
	.num_calls	= 0,
	.calls		= misc_calls,
	.num_public_structs	= 3,
	.public_structs		= misc_public_structs,
	.endpoints	= &misc_endpoints,
	.authservices	= &misc_authservices
};

#endif /* SKIP_NDR_TABLE_misc */
