/* Server.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Server.vala, do not modify */

/*
 * Copyright (c) 2011-2015 elementary Developers (https://launchpad.net/elementary)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */

#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <polkit/polkit.h>

#define LOGIN_DHELPER_SERVER_CONFIG_FILE "/etc/systemd/logind.conf"
#define LOGIN_DHELPER_SERVER_CONFIG_GROUP "Login"
#define LOGIN_DHELPER_SERVER_ACTION_ID "io.elementary.settings.power.administration"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define LOGIN_DHELPER_TYPE_SERVER (login_dhelper_server_get_type ())
#define LOGIN_DHELPER_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), LOGIN_DHELPER_TYPE_SERVER, LoginDHelperServer))
#define LOGIN_DHELPER_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), LOGIN_DHELPER_TYPE_SERVER, LoginDHelperServerClass))
#define LOGIN_DHELPER_IS_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), LOGIN_DHELPER_TYPE_SERVER))
#define LOGIN_DHELPER_IS_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), LOGIN_DHELPER_TYPE_SERVER))
#define LOGIN_DHELPER_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), LOGIN_DHELPER_TYPE_SERVER, LoginDHelperServerClass))

typedef struct _LoginDHelperServer LoginDHelperServer;
typedef struct _LoginDHelperServerClass LoginDHelperServerClass;
typedef struct _LoginDHelperServerPrivate LoginDHelperServerPrivate;
enum  {
	LOGIN_DHELPER_SERVER_0_PROPERTY,
	LOGIN_DHELPER_SERVER_PRESENT_PROPERTY,
	LOGIN_DHELPER_SERVER_NUM_PROPERTIES
};
static GParamSpec* login_dhelper_server_properties[LOGIN_DHELPER_SERVER_NUM_PROPERTIES];
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))

#define POWER_TYPE_DBUS (power_dbus_get_type ())
#define POWER_DBUS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), POWER_TYPE_DBUS, PowerDBus))
#define POWER_IS_DBUS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), POWER_TYPE_DBUS))
#define POWER_DBUS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), POWER_TYPE_DBUS, PowerDBusIface))

typedef struct _PowerDBus PowerDBus;
typedef struct _PowerDBusIface PowerDBusIface;

#define POWER_TYPE_DBUS_PROXY (power_dbus_proxy_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	LOGIN_DHELPER_SERVER_RESET_TIMEOUT_SIGNAL,
	LOGIN_DHELPER_SERVER_CHANGED_SIGNAL,
	LOGIN_DHELPER_SERVER_NUM_SIGNALS
};
static guint login_dhelper_server_signals[LOGIN_DHELPER_SERVER_NUM_SIGNALS] = {0};

struct _LoginDHelperServer {
	GObject parent_instance;
	LoginDHelperServerPrivate * priv;
};

struct _LoginDHelperServerClass {
	GObjectClass parent_class;
};

struct _LoginDHelperServerPrivate {
	GKeyFile* file;
	gboolean _present;
};

struct _PowerDBusIface {
	GTypeInterface parent_iface;
	guint32 (*get_connection_unix_process_id) (PowerDBus* self, const gchar* name, GError** error);
	guint32 (*get_connection_unix_user) (PowerDBus* self, const gchar* name, GError** error);
};

static gint LoginDHelperServer_private_offset;
static gpointer login_dhelper_server_parent_class = NULL;
static LoginDHelperServer* login_dhelper_server_instance;
static LoginDHelperServer* login_dhelper_server_instance = NULL;
static PowerDBus* login_dhelper_server_bus_proxy;
static PowerDBus* login_dhelper_server_bus_proxy = NULL;

VALA_EXTERN GType login_dhelper_server_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LoginDHelperServer, g_object_unref)
VALA_EXTERN guint login_dhelper_server_register_object (void* object,
                                            GDBusConnection* connection,
                                            const gchar* path,
                                            GError** error);
VALA_EXTERN GType power_dbus_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint power_dbus_register_object (void* object,
                                  GDBusConnection* connection,
                                  const gchar* path,
                                  GError** error);
VALA_EXTERN GType power_dbus_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PowerDBus, g_object_unref)
VALA_EXTERN LoginDHelperServer* login_dhelper_server_get_default (void);
VALA_EXTERN LoginDHelperServer* login_dhelper_server_new (void);
VALA_EXTERN LoginDHelperServer* login_dhelper_server_construct (GType object_type);
VALA_EXTERN void login_dhelper_server_set_key (LoginDHelperServer* self,
                                   const gchar* key,
                                   const gchar* value,
                                   const char* sender,
                                   GError** error);
static gboolean login_dhelper_server_get_sender_is_authorized (const char* sender);
VALA_EXTERN gchar* login_dhelper_server_get_key (LoginDHelperServer* self,
                                     const gchar* key,
                                     GError** error);
VALA_EXTERN gchar* login_dhelper_server_get_config_file (LoginDHelperServer* self,
                                             GError** error);
VALA_EXTERN guint32 power_dbus_get_connection_unix_process_id (PowerDBus* self,
                                                   const gchar* name,
                                                   GError** error);
VALA_EXTERN guint32 power_dbus_get_connection_unix_user (PowerDBus* self,
                                             const gchar* name,
                                             GError** error);
VALA_EXTERN gboolean login_dhelper_server_get_present (LoginDHelperServer* self);
static GObject * login_dhelper_server_constructor (GType type,
                                            guint n_construct_properties,
                                            GObjectConstructParam * construct_properties);
static void login_dhelper_server_finalize (GObject * obj);
static GType login_dhelper_server_get_type_once (void);
static void _vala_login_dhelper_server_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec);
static void _dbus_login_dhelper_server_set_key (LoginDHelperServer* self,
                                         GVariant* _parameters_,
                                         GDBusMethodInvocation* invocation);
static void _dbus_login_dhelper_server_get_key (LoginDHelperServer* self,
                                         GVariant* _parameters_,
                                         GDBusMethodInvocation* invocation);
static void _dbus_login_dhelper_server_get_config_file (LoginDHelperServer* self,
                                                 GVariant* _parameters_,
                                                 GDBusMethodInvocation* invocation);
static void login_dhelper_server_dbus_interface_method_call (GDBusConnection* connection,
                                                      const gchar* sender,
                                                      const gchar* object_path,
                                                      const gchar* interface_name,
                                                      const gchar* method_name,
                                                      GVariant* parameters,
                                                      GDBusMethodInvocation* invocation,
                                                      gpointer user_data);
static GVariant* login_dhelper_server_dbus_interface_get_property (GDBusConnection* connection,
                                                            const gchar* sender,
                                                            const gchar* object_path,
                                                            const gchar* interface_name,
                                                            const gchar* property_name,
                                                            GError** error,
                                                            gpointer user_data);
static GVariant* _dbus_login_dhelper_server_get_present (LoginDHelperServer* self);
static gboolean login_dhelper_server_dbus_interface_set_property (GDBusConnection* connection,
                                                           const gchar* sender,
                                                           const gchar* object_path,
                                                           const gchar* interface_name,
                                                           const gchar* property_name,
                                                           GVariant* value,
                                                           GError** error,
                                                           gpointer user_data);
static void _dbus_login_dhelper_server_changed (GObject* _sender,
                                         gpointer* _data);
static void _login_dhelper_server_unregister_object (gpointer user_data);

static const GDBusArgInfo _login_dhelper_server_dbus_arg_info_set_key_key = {-1, "key", "s", NULL};
static const GDBusArgInfo _login_dhelper_server_dbus_arg_info_set_key_value = {-1, "value", "s", NULL};
static const GDBusArgInfo * const _login_dhelper_server_dbus_arg_info_set_key_in[] = {&_login_dhelper_server_dbus_arg_info_set_key_key, &_login_dhelper_server_dbus_arg_info_set_key_value, NULL};
static const GDBusArgInfo * const _login_dhelper_server_dbus_arg_info_set_key_out[] = {NULL};
static const GDBusMethodInfo _login_dhelper_server_dbus_method_info_set_key = {-1, "SetKey", (GDBusArgInfo **) (&_login_dhelper_server_dbus_arg_info_set_key_in), (GDBusArgInfo **) (&_login_dhelper_server_dbus_arg_info_set_key_out), NULL};
static const GDBusArgInfo _login_dhelper_server_dbus_arg_info_get_key_key = {-1, "key", "s", NULL};
static const GDBusArgInfo _login_dhelper_server_dbus_arg_info_get_key_result = {-1, "result", "s", NULL};
static const GDBusArgInfo * const _login_dhelper_server_dbus_arg_info_get_key_in[] = {&_login_dhelper_server_dbus_arg_info_get_key_key, NULL};
static const GDBusArgInfo * const _login_dhelper_server_dbus_arg_info_get_key_out[] = {&_login_dhelper_server_dbus_arg_info_get_key_result, NULL};
static const GDBusMethodInfo _login_dhelper_server_dbus_method_info_get_key = {-1, "GetKey", (GDBusArgInfo **) (&_login_dhelper_server_dbus_arg_info_get_key_in), (GDBusArgInfo **) (&_login_dhelper_server_dbus_arg_info_get_key_out), NULL};
static const GDBusArgInfo _login_dhelper_server_dbus_arg_info_get_config_file_result = {-1, "result", "s", NULL};
static const GDBusArgInfo * const _login_dhelper_server_dbus_arg_info_get_config_file_in[] = {NULL};
static const GDBusArgInfo * const _login_dhelper_server_dbus_arg_info_get_config_file_out[] = {&_login_dhelper_server_dbus_arg_info_get_config_file_result, NULL};
static const GDBusMethodInfo _login_dhelper_server_dbus_method_info_get_config_file = {-1, "GetConfigFile", (GDBusArgInfo **) (&_login_dhelper_server_dbus_arg_info_get_config_file_in), (GDBusArgInfo **) (&_login_dhelper_server_dbus_arg_info_get_config_file_out), NULL};
static const GDBusMethodInfo * const _login_dhelper_server_dbus_method_info[] = {&_login_dhelper_server_dbus_method_info_set_key, &_login_dhelper_server_dbus_method_info_get_key, &_login_dhelper_server_dbus_method_info_get_config_file, NULL};
static const GDBusArgInfo * const _login_dhelper_server_dbus_arg_info_changed[] = {NULL};
static const GDBusSignalInfo _login_dhelper_server_dbus_signal_info_changed = {-1, "Changed", (GDBusArgInfo **) (&_login_dhelper_server_dbus_arg_info_changed), NULL};
static const GDBusSignalInfo * const _login_dhelper_server_dbus_signal_info[] = {&_login_dhelper_server_dbus_signal_info_changed, NULL};
static const GDBusPropertyInfo _login_dhelper_server_dbus_property_info_present = {-1, "Present", "b", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo * const _login_dhelper_server_dbus_property_info[] = {&_login_dhelper_server_dbus_property_info_present, NULL};
static const GDBusInterfaceInfo _login_dhelper_server_dbus_interface_info = {-1, "io.elementary.logind.helper", (GDBusMethodInfo **) (&_login_dhelper_server_dbus_method_info), (GDBusSignalInfo **) (&_login_dhelper_server_dbus_signal_info), (GDBusPropertyInfo **) (&_login_dhelper_server_dbus_property_info), NULL};
static const GDBusInterfaceVTable _login_dhelper_server_dbus_interface_vtable = {login_dhelper_server_dbus_interface_method_call, login_dhelper_server_dbus_interface_get_property, login_dhelper_server_dbus_interface_set_property};

static inline gpointer
login_dhelper_server_get_instance_private (LoginDHelperServer* self)
{
	return G_STRUCT_MEMBER_P (self, LoginDHelperServer_private_offset);
}

LoginDHelperServer*
login_dhelper_server_get_default (void)
{
	LoginDHelperServer* _tmp0_;
	LoginDHelperServer* _tmp2_;
	LoginDHelperServer* result;
	_tmp0_ = login_dhelper_server_instance;
	if (_tmp0_ == NULL) {
		LoginDHelperServer* _tmp1_;
		_tmp1_ = login_dhelper_server_new ();
		_g_object_unref0 (login_dhelper_server_instance);
		login_dhelper_server_instance = _tmp1_;
	}
	_tmp2_ = login_dhelper_server_instance;
	result = _tmp2_;
	return result;
}

/**
     * set_key:
     * @key: the key to set
     * @value: the value that key will be set with
     *
     * Sets the @key to @value in the logind config file (that is /etc/systemd/logind.conf)
     *
     * In order for this method to succeed, the caller must be already granted the 
     * io.elementary.settings.power.administration policy PolicyKit permission, otherwise
     * the method will throw an error and exit
     *
     * When the @key was successfully set, the changed () signal will be emitted
     */
static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

void
login_dhelper_server_set_key (LoginDHelperServer* self,
                              const gchar* key,
                              const gchar* value,
                              const char* sender,
                              GError** error)
{
	GKeyFile* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	g_return_if_fail (value != NULL);
	g_return_if_fail (sender != NULL);
	g_signal_emit (self, login_dhelper_server_signals[LOGIN_DHELPER_SERVER_RESET_TIMEOUT_SIGNAL], 0);
	if (!login_dhelper_server_get_sender_is_authorized (sender)) {
		GError* _tmp0_;
		_tmp0_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_PERMISSION_DENIED, "Error: sender not authorized");
		_inner_error0_ = _tmp0_;
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp1_ = self->priv->file;
	g_key_file_set_string (_tmp1_, LOGIN_DHELPER_SERVER_CONFIG_GROUP, key, value);
	{
		GKeyFile* _tmp2_;
		_tmp2_ = self->priv->file;
		g_key_file_save_to_file (_tmp2_, LOGIN_DHELPER_SERVER_CONFIG_FILE, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		g_signal_emit (self, login_dhelper_server_signals[LOGIN_DHELPER_SERVER_CHANGED_SIGNAL], 0);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		GError* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _g_error_copy0 (_tmp3_);
		_inner_error0_ = _tmp4_;
		_g_error_free0 (e);
		goto __finally0;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

/**
     * get_key:
     * @key: the key to retrieve
     *
     * Returns the value of @key in the logind config file (that is /etc/systemd/logind.conf)
     *
     * If the @key does not exist, an error will be thrown
     *
     * Returns: the value for the @key
     */
gchar*
login_dhelper_server_get_key (LoginDHelperServer* self,
                              const gchar* key,
                              GError** error)
{
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	g_signal_emit (self, login_dhelper_server_signals[LOGIN_DHELPER_SERVER_RESET_TIMEOUT_SIGNAL], 0);
	{
		gchar* _tmp0_ = NULL;
		GKeyFile* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp1_ = self->priv->file;
		_tmp2_ = g_key_file_get_string (_tmp1_, LOGIN_DHELPER_SERVER_CONFIG_GROUP, key, &_inner_error0_);
		_tmp0_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		result = _tmp3_;
		_g_free0 (_tmp0_);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		GError* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _g_error_copy0 (_tmp4_);
		_inner_error0_ = _tmp5_;
		_g_error_free0 (e);
		goto __finally0;
	}
	__finally0:
	g_propagate_error (error, _inner_error0_);
	return NULL;
}

/**
     * get_config_file:
     *
     * Gets a full path to the current used logind config file (at the moment this
     * will always return "/etc/systemd/logind.conf")
     */
gchar*
login_dhelper_server_get_config_file (LoginDHelperServer* self,
                                      GError** error)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_signal_emit (self, login_dhelper_server_signals[LOGIN_DHELPER_SERVER_RESET_TIMEOUT_SIGNAL], 0);
	_tmp0_ = g_strdup (LOGIN_DHELPER_SERVER_CONFIG_FILE);
	result = _tmp0_;
	return result;
}

static gboolean
login_dhelper_server_get_sender_is_authorized (const char* sender)
{
	PowerDBus* _tmp0_;
	guint32 user = 0U;
	guint32 pid = 0U;
	PolkitUnixProcess* subject = NULL;
	PolkitUnixProcess* _tmp8_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (sender != NULL, FALSE);
	_tmp0_ = login_dhelper_server_bus_proxy;
	if (_tmp0_ == NULL) {
		result = FALSE;
		return result;
	}
	user = (guint32) 0;
	pid = (guint32) 0;
	{
		guint32 _tmp1_ = 0U;
		PowerDBus* _tmp2_;
		guint32 _tmp3_ = 0U;
		PowerDBus* _tmp4_;
		_tmp2_ = login_dhelper_server_bus_proxy;
		_tmp1_ = power_dbus_get_connection_unix_process_id (_tmp2_, (const gchar*) sender, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		pid = _tmp1_;
		_tmp4_ = login_dhelper_server_bus_proxy;
		_tmp3_ = power_dbus_get_connection_unix_user (_tmp4_, (const gchar*) sender, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		user = _tmp3_;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		g_warning ("Server.vala:149: %s", _tmp6_);
		result = FALSE;
		_g_error_free0 (e);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp7_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp7_;
	}
	_tmp8_ = (PolkitUnixProcess*) polkit_unix_process_new_for_owner ((gint) pid, (guint64) 0, (gint) user);
	subject = _tmp8_;
	{
		PolkitAuthority* authority = NULL;
		PolkitAuthority* _tmp9_;
		PolkitAuthorizationResult* auth_result = NULL;
		PolkitAuthority* _tmp10_;
		PolkitUnixProcess* _tmp11_;
		PolkitAuthorizationResult* _tmp12_;
		PolkitAuthorizationResult* _tmp13_;
		_tmp9_ = polkit_authority_get_sync (NULL, &_inner_error0_);
		authority = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
		_tmp10_ = authority;
		_tmp11_ = subject;
		_tmp12_ = polkit_authority_check_authorization_sync (_tmp10_, (PolkitSubject*) _tmp11_, LOGIN_DHELPER_SERVER_ACTION_ID, NULL, POLKIT_CHECK_AUTHORIZATION_FLAGS_NONE, NULL, &_inner_error0_);
		auth_result = _tmp12_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (authority);
			goto __catch1_g_error;
		}
		_tmp13_ = auth_result;
		result = polkit_authorization_result_get_is_authorized (_tmp13_);
		_g_object_unref0 (auth_result);
		_g_object_unref0 (authority);
		_g_object_unref0 (subject);
		return result;
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp14_;
		const gchar* _tmp15_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp14_ = e;
		_tmp15_ = _tmp14_->message;
		g_warning ("Server.vala:165: %s", _tmp15_);
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp16_ = FALSE;
		_g_object_unref0 (subject);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp16_;
	}
	result = FALSE;
	_g_object_unref0 (subject);
	return result;
}

LoginDHelperServer*
login_dhelper_server_construct (GType object_type)
{
	LoginDHelperServer * self = NULL;
	self = (LoginDHelperServer*) g_object_new (object_type, NULL);
	return self;
}

LoginDHelperServer*
login_dhelper_server_new (void)
{
	return login_dhelper_server_construct (LOGIN_DHELPER_TYPE_SERVER);
}

gboolean
login_dhelper_server_get_present (LoginDHelperServer* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_signal_emit (self, login_dhelper_server_signals[LOGIN_DHELPER_SERVER_RESET_TIMEOUT_SIGNAL], 0);
	result = self->priv->_present;
	return result;
}

static GObject *
login_dhelper_server_constructor (GType type,
                                  guint n_construct_properties,
                                  GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	LoginDHelperServer * self;
	GKeyFile* _tmp0_;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (login_dhelper_server_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, LOGIN_DHELPER_TYPE_SERVER, LoginDHelperServer);
	_tmp0_ = g_key_file_new ();
	_g_key_file_unref0 (self->priv->file);
	self->priv->file = _tmp0_;
	{
		gboolean _tmp1_ = FALSE;
		GKeyFile* _tmp2_;
		_tmp2_ = self->priv->file;
		_tmp1_ = g_key_file_load_from_file (_tmp2_, LOGIN_DHELPER_SERVER_CONFIG_FILE, G_KEY_FILE_KEEP_COMMENTS, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		self->priv->_present = _tmp1_;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("Server.vala:73: %s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
	return obj;
}

static void
login_dhelper_server_class_init (LoginDHelperServerClass * klass,
                                 gpointer klass_data)
{
	GError* _inner_error0_ = NULL;
	login_dhelper_server_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &LoginDHelperServer_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_login_dhelper_server_get_property;
	G_OBJECT_CLASS (klass)->constructor = login_dhelper_server_constructor;
	G_OBJECT_CLASS (klass)->finalize = login_dhelper_server_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), LOGIN_DHELPER_SERVER_PRESENT_PROPERTY, login_dhelper_server_properties[LOGIN_DHELPER_SERVER_PRESENT_PROPERTY] = g_param_spec_boolean ("present", "present", "present", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	login_dhelper_server_signals[LOGIN_DHELPER_SERVER_RESET_TIMEOUT_SIGNAL] = g_signal_new ("reset-timeout", LOGIN_DHELPER_TYPE_SERVER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	/**
	     * changed:
	     *
	     * Emitted when a call to set_key () succeeded
	     */
	login_dhelper_server_signals[LOGIN_DHELPER_SERVER_CHANGED_SIGNAL] = g_signal_new ("changed", LOGIN_DHELPER_TYPE_SERVER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	{
		PowerDBus* _tmp0_ = NULL;
		PowerDBus* _tmp1_;
		PowerDBus* _tmp2_;
		_tmp1_ = (PowerDBus*) g_initable_new (POWER_TYPE_DBUS_PROXY, NULL, &_inner_error0_, "g-flags", 0, "g-name", "org.freedesktop.DBus", "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", "/", "g-interface-name", "org.freedesktop.DBus", NULL);
		_tmp0_ = (PowerDBus*) _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (login_dhelper_server_bus_proxy);
		login_dhelper_server_bus_proxy = _tmp2_;
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("Server.vala:62: %s", _tmp4_);
		_g_object_unref0 (login_dhelper_server_bus_proxy);
		login_dhelper_server_bus_proxy = NULL;
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
}

static void
login_dhelper_server_instance_init (LoginDHelperServer * self,
                                    gpointer klass)
{
	self->priv = login_dhelper_server_get_instance_private (self);
	self->priv->_present = FALSE;
}

static void
login_dhelper_server_finalize (GObject * obj)
{
	LoginDHelperServer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, LOGIN_DHELPER_TYPE_SERVER, LoginDHelperServer);
	_g_key_file_unref0 (self->priv->file);
	G_OBJECT_CLASS (login_dhelper_server_parent_class)->finalize (obj);
}

static GType
login_dhelper_server_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (LoginDHelperServerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) login_dhelper_server_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (LoginDHelperServer), 0, (GInstanceInitFunc) login_dhelper_server_instance_init, NULL };
	GType login_dhelper_server_type_id;
	login_dhelper_server_type_id = g_type_register_static (G_TYPE_OBJECT, "LoginDHelperServer", &g_define_type_info, 0);
	g_type_set_qdata (login_dhelper_server_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) login_dhelper_server_register_object);
	LoginDHelperServer_private_offset = g_type_add_instance_private (login_dhelper_server_type_id, sizeof (LoginDHelperServerPrivate));
	return login_dhelper_server_type_id;
}

GType
login_dhelper_server_get_type (void)
{
	static volatile gsize login_dhelper_server_type_id__once = 0;
	if (g_once_init_enter (&login_dhelper_server_type_id__once)) {
		GType login_dhelper_server_type_id;
		login_dhelper_server_type_id = login_dhelper_server_get_type_once ();
		g_once_init_leave (&login_dhelper_server_type_id__once, login_dhelper_server_type_id);
	}
	return login_dhelper_server_type_id__once;
}

static void
_vala_login_dhelper_server_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec)
{
	LoginDHelperServer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, LOGIN_DHELPER_TYPE_SERVER, LoginDHelperServer);
	switch (property_id) {
		case LOGIN_DHELPER_SERVER_PRESENT_PROPERTY:
		g_value_set_boolean (value, login_dhelper_server_get_present (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_dbus_login_dhelper_server_set_key (LoginDHelperServer* self,
                                    GVariant* _parameters_,
                                    GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* key = NULL;
	GVariant* _tmp0_;
	gchar* value = NULL;
	GVariant* _tmp1_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp0_ = g_variant_iter_next_value (&_arguments_iter);
	key = g_variant_dup_string (_tmp0_, NULL);
	g_variant_unref (_tmp0_);
	_tmp1_ = g_variant_iter_next_value (&_arguments_iter);
	value = g_variant_dup_string (_tmp1_, NULL);
	g_variant_unref (_tmp1_);
	login_dhelper_server_set_key (self, key, value, g_dbus_method_invocation_get_sender (invocation), &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (key);
	_g_free0 (value);
	;
}

static void
_dbus_login_dhelper_server_get_key (LoginDHelperServer* self,
                                    GVariant* _parameters_,
                                    GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* key = NULL;
	GVariant* _tmp2_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar* result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp2_ = g_variant_iter_next_value (&_arguments_iter);
	key = g_variant_dup_string (_tmp2_, NULL);
	g_variant_unref (_tmp2_);
	result = login_dhelper_server_get_key (self, key, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (result));
	_g_free0 (result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (key);
	;
}

static void
_dbus_login_dhelper_server_get_config_file (LoginDHelperServer* self,
                                            GVariant* _parameters_,
                                            GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar* result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	result = login_dhelper_server_get_config_file (self, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (result));
	_g_free0 (result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
login_dhelper_server_dbus_interface_method_call (GDBusConnection* connection,
                                                 const gchar* sender,
                                                 const gchar* object_path,
                                                 const gchar* interface_name,
                                                 const gchar* method_name,
                                                 GVariant* parameters,
                                                 GDBusMethodInvocation* invocation,
                                                 gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "SetKey") == 0) {
		_dbus_login_dhelper_server_set_key (object, parameters, invocation);
	} else if (strcmp (method_name, "GetKey") == 0) {
		_dbus_login_dhelper_server_get_key (object, parameters, invocation);
	} else if (strcmp (method_name, "GetConfigFile") == 0) {
		_dbus_login_dhelper_server_get_config_file (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
_dbus_login_dhelper_server_get_present (LoginDHelperServer* self)
{
	gboolean result;
	GVariant* _reply;
	result = login_dhelper_server_get_present (self);
	_reply = g_variant_new_boolean (result);
	return _reply;
}

static GVariant*
login_dhelper_server_dbus_interface_get_property (GDBusConnection* connection,
                                                  const gchar* sender,
                                                  const gchar* object_path,
                                                  const gchar* interface_name,
                                                  const gchar* property_name,
                                                  GError** error,
                                                  gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "Present") == 0) {
		return _dbus_login_dhelper_server_get_present (object);
	}
	return NULL;
}

static gboolean
login_dhelper_server_dbus_interface_set_property (GDBusConnection* connection,
                                                  const gchar* sender,
                                                  const gchar* object_path,
                                                  const gchar* interface_name,
                                                  const gchar* property_name,
                                                  GVariant* value,
                                                  GError** error,
                                                  gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

static void
_dbus_login_dhelper_server_changed (GObject* _sender,
                                    gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "io.elementary.logind.helper", "Changed", _arguments, NULL);
}

guint
login_dhelper_server_register_object (gpointer object,
                                      GDBusConnection* connection,
                                      const gchar* path,
                                      GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_login_dhelper_server_dbus_interface_info), &_login_dhelper_server_dbus_interface_vtable, data, _login_dhelper_server_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "changed", (GCallback) _dbus_login_dhelper_server_changed, data);
	return result;
}

static void
_login_dhelper_server_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_login_dhelper_server_changed, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

